#! /bin/sh

TEMPDIR=/tmp/pspp-tst-$$
mkdir -p $TEMPDIR
trap 'cd /; rm -rf $TEMPDIR' 0

# ensure that top_builddir  are absolute
if [ -z "$top_builddir" ] ; then top_builddir=. ; fi
if [ -z "$top_srcdir" ] ; then top_srcdir=. ; fi
top_builddir=`cd $top_builddir; pwd`
PSPP=$top_builddir/src/ui/terminal/pspp

# ensure that top_srcdir is absolute
top_srcdir=`cd $top_srcdir; pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH

fail()
{
    echo $activity
    echo FAILED
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    exit 2;
}

pass()
{
    exit 0;
}

cd $TEMPDIR

activity="write program to generate PSPP syntax and data"
cat > time-in.pl <<'EOF'
#! /usr/bin/perl

use strict;
use warnings;

our $next = 1;

my @formats = (["time", "+H:M", "+H:M:S"],
	       ["dtime", "+D H:M", "+D H:M:S"]);

my @times = (#  D  HH  MM     SS
	     [  0,  0,  0,  0.00],
	     [  1,  4, 50, 38.68],
	     [  5, 12, 31, 35.82],
	     [  0, 12, 47, 53.41],
	     [  3,  1, 26,  0.69],
	     [  1, 20, 58, 11.19],
	     [ 12,  7, 36,  5.98],
	     [ 52, 15, 43, 49.27],
	     [  7,  4, 25,  9.24],
	     [  0,  6, 49, 27.89],
	     [ 20,  2, 57, 52.56],
	     [555, 16, 45, 44.12],
	     [120, 21, 30, 57.27],
	     [  0,  4, 25,  9.98],
	     [  3,  6, 49, 27.24],
	     [  5,  2, 57, 52.13],
	     [  0, 16, 45, 44.35],
	     [  1, 21, 30, 57.32],
	     [ 10, 22, 30,  4.27],
	     [ 22,  1, 56, 51.18]);

open (SYNTAX, '>', 'time-in.pspp') or die "time-in.pspp: create: $!\n";
for my $format (@formats) {
    my ($name) = @$format;
    print SYNTAX "DATA LIST file='$name.data'/$name 1-40 ($name).\n";
    print SYNTAX "PRINT OUTFILE='$name.out'/$name (F16.2).\n";
    print SYNTAX "EXECUTE.\n";
}
close (SYNTAX);

for my $format (@formats) {
    my ($fmt_name, @templates) = @$format;
    my ($fn) = "$fmt_name.data";
    open (DATA, '>', $fn) or die "$fn: create: $!\n";
    select DATA;
    for my $template (@templates) {
	for my $time (@times) {
	    print_time_with_template ($time, $template) for 1...10;
	}
    }
    close (DATA);
}

sub print_time_with_template {
    my ($time, $template) = @_;
    my ($day, $hour, $minute, $second) = @$time;
    for my $c (split ('', $template)) {
	if ($c eq '+') {
	    print +pick ('', '-', '+');
	} elsif ($c eq 'D') {
	    printf (+pick ('%d', '%02d'), $day);
	    $day = 0;
	} elsif ($c eq 'H') {
	    printf (+pick ('%d', '%02d'), $hour + 24 * $day);
	} elsif ($c eq 'M') {
	    printf (+pick ('%d', '%02d'), $minute);
	} elsif ($c eq 'S') {
	    printf (+pick ('%.0f', '%02.0f', '%.1f', '%.2f'), $second);
	} elsif ($c eq ':') {
	    print +pick (' ', ':');
	} elsif ($c eq ' ') {
	    print ' ';
	} else {
	    die;
	}
    }
    print "\n";
}

sub pick {
   return $_[int (my_rand ($#_ + 1))];
}

sub my_rand {
    my ($modulo) = @_;
    $next = ($next * 1103515245 + 12345) % (2**32);
    return int ($next / 65536) % $modulo;
}
EOF
if [ $? -ne 0 ] ; then no_result ; fi

activity="generate PSPP syntax and data"
$PERL time-in.pl
if [ $? -ne 0 ] ; then no_result ; fi

activity="run program"
$SUPERVISOR $PSPP --testing-mode time-in.pspp
if [ $? -ne 0 ] ; then no_result ; fi

activity="compare time.out output"
diff -u time.out - <<EOF
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
        103800.00
       -103800.00
        103800.00
        103800.00
        103800.00
        103800.00
       -103800.00
        103800.00
       -103800.00
        103800.00
        477060.00
        477060.00
       -477060.00
        477060.00
        477060.00
        477060.00
        477060.00
       -477060.00
        477060.00
       -477060.00
        -46020.00
         46020.00
         46020.00
        -46020.00
         46020.00
        -46020.00
         46020.00
         46020.00
        -46020.00
         46020.00
        264360.00
        264360.00
        264360.00
        264360.00
        264360.00
        264360.00
       -264360.00
       -264360.00
        264360.00
        264360.00
        161880.00
       -161880.00
       -161880.00
        161880.00
        161880.00
        161880.00
        161880.00
        161880.00
        161880.00
       -161880.00
      -1064160.00
       1064160.00
       1064160.00
       1064160.00
       1064160.00
       1064160.00
      -1064160.00
       1064160.00
      -1064160.00
       1064160.00
      -4549380.00
      -4549380.00
       4549380.00
      -4549380.00
       4549380.00
       4549380.00
      -4549380.00
       4549380.00
      -4549380.00
      -4549380.00
       -620700.00
        620700.00
        620700.00
        620700.00
       -620700.00
       -620700.00
        620700.00
        620700.00
        620700.00
       -620700.00
         24540.00
         24540.00
        -24540.00
        -24540.00
        -24540.00
        -24540.00
        -24540.00
         24540.00
        -24540.00
         24540.00
       1738620.00
       1738620.00
       1738620.00
       1738620.00
      -1738620.00
       1738620.00
       1738620.00
       1738620.00
      -1738620.00
       1738620.00
      48012300.00
      48012300.00
      48012300.00
      48012300.00
     -48012300.00
      48012300.00
     -48012300.00
     -48012300.00
     -48012300.00
      48012300.00
      10445400.00
      10445400.00
      10445400.00
      10445400.00
     -10445400.00
      10445400.00
     -10445400.00
      10445400.00
     -10445400.00
      10445400.00
         15900.00
         15900.00
        -15900.00
         15900.00
         15900.00
         15900.00
         15900.00
        -15900.00
         15900.00
        -15900.00
        283740.00
       -283740.00
        283740.00
        283740.00
       -283740.00
       -283740.00
       -283740.00
        283740.00
        283740.00
       -283740.00
       -442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
       -442620.00
        -60300.00
         60300.00
         60300.00
        -60300.00
        -60300.00
        -60300.00
        -60300.00
         60300.00
        -60300.00
         60300.00
       -163800.00
        163800.00
       -163800.00
        163800.00
        163800.00
       -163800.00
        163800.00
        163800.00
        163800.00
        163800.00
        945000.00
        945000.00
       -945000.00
       -945000.00
        945000.00
       -945000.00
        945000.00
        945000.00
        945000.00
        945000.00
      -1907760.00
      -1907760.00
       1907760.00
       1907760.00
       1907760.00
      -1907760.00
      -1907760.00
      -1907760.00
       1907760.00
       1907760.00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
        103839.00
        103839.00
       -103838.70
       -103839.00
        103839.00
        103839.00
       -103838.68
        103839.00
       -103838.70
        103838.68
        477096.00
        477096.00
        477096.00
       -477096.00
       -477096.00
       -477096.00
       -477096.00
        477095.80
        477095.80
        477095.80
         46073.41
         46073.00
        -46073.00
         46073.41
         46073.41
         46073.40
         46073.00
        -46073.41
         46073.41
         46073.40
       -264361.00
        264361.00
       -264360.70
        264360.70
        264360.70
       -264361.00
        264360.70
        264360.70
       -264361.00
        264361.00
        161891.20
        161891.19
        161891.00
        161891.19
        161891.00
        161891.00
        161891.20
        161891.00
        161891.19
        161891.20
      -1064166.00
       1064166.00
       1064166.00
       1064165.98
      -1064165.98
      -1064166.00
      -1064165.98
       1064166.00
       1064165.98
       1064166.00
       4549429.27
      -4549429.00
       4549429.30
      -4549429.00
       4549429.00
       4549429.00
      -4549429.27
       4549429.27
       4549429.00
       4549429.00
       -620709.24
       -620709.00
        620709.00
        620709.20
       -620709.00
       -620709.20
        620709.24
       -620709.24
        620709.24
        620709.20
        -24567.90
         24567.89
         24568.00
         24568.00
        -24568.00
         24568.00
        -24567.90
         24568.00
         24567.90
         24568.00
      -1738673.00
       1738672.60
      -1738672.60
       1738672.60
       1738672.56
       1738673.00
       1738673.00
       1738673.00
      -1738673.00
       1738672.56
     -48012344.00
      48012344.00
      48012344.00
     -48012344.12
     -48012344.10
      48012344.00
      48012344.00
      48012344.10
      48012344.00
      48012344.12
     -10445457.30
      10445457.00
      10445457.30
      10445457.00
      10445457.27
     -10445457.00
      10445457.00
     -10445457.27
      10445457.30
      10445457.27
        -15910.00
         15910.00
         15910.00
        -15909.98
         15909.98
         15909.98
        -15910.00
        -15909.98
         15910.00
         15910.00
       -283767.00
        283767.00
       -283767.00
        283767.20
        283767.24
       -283767.00
       -283767.00
        283767.20
        283767.00
       -283767.20
        442672.13
       -442672.13
        442672.10
        442672.00
        442672.10
        442672.00
       -442672.00
       -442672.10
        442672.13
       -442672.13
         60344.40
         60344.40
         60344.40
         60344.40
        -60344.35
         60344.35
        -60344.35
         60344.00
         60344.00
         60344.00
        163857.32
       -163857.30
        163857.30
       -163857.32
        163857.00
        163857.32
       -163857.32
        163857.00
        163857.32
       -163857.00
        945004.00
        945004.30
        945004.30
        945004.00
        945004.00
        945004.30
        945004.00
        945004.27
       -945004.00
        945004.00
      -1907811.00
       1907811.20
       1907811.00
      -1907811.00
       1907811.00
       1907811.18
       1907811.20
      -1907811.20
      -1907811.00
       1907811.20
EOF
if [ $? -ne 0 ] ; then fail ; fi

activity="compare dtime.out output"
diff -u dtime.out - <<EOF
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
        103800.00
        103800.00
       -103800.00
       -103800.00
        103800.00
        103800.00
        103800.00
        103800.00
        103800.00
        103800.00
        477060.00
        477060.00
        477060.00
        477060.00
        477060.00
       -477060.00
       -477060.00
       -477060.00
        477060.00
        477060.00
        -46020.00
         46020.00
         46020.00
         46020.00
         46020.00
         46020.00
         46020.00
        -46020.00
         46020.00
         46020.00
       -264360.00
       -264360.00
        264360.00
       -264360.00
        264360.00
        264360.00
       -264360.00
        264360.00
        264360.00
        264360.00
        161880.00
        161880.00
       -161880.00
        161880.00
        161880.00
        161880.00
       -161880.00
        161880.00
       -161880.00
        161880.00
      -1064160.00
      -1064160.00
       1064160.00
      -1064160.00
      -1064160.00
       1064160.00
       1064160.00
       1064160.00
       1064160.00
      -1064160.00
       4549380.00
      -4549380.00
       4549380.00
       4549380.00
       4549380.00
       4549380.00
       4549380.00
       4549380.00
      -4549380.00
      -4549380.00
       -620700.00
       -620700.00
        620700.00
        620700.00
       -620700.00
        620700.00
        620700.00
        620700.00
       -620700.00
        620700.00
        -24540.00
         24540.00
         24540.00
        -24540.00
         24540.00
        -24540.00
         24540.00
         24540.00
        -24540.00
         24540.00
      -1738620.00
       1738620.00
       1738620.00
       1738620.00
      -1738620.00
      -1738620.00
       1738620.00
       1738620.00
       1738620.00
       1738620.00
      48012300.00
     -48012300.00
      48012300.00
      48012300.00
     -48012300.00
      48012300.00
      48012300.00
      48012300.00
      48012300.00
      48012300.00
      10445400.00
      10445400.00
     -10445400.00
      10445400.00
      10445400.00
      10445400.00
      10445400.00
      10445400.00
      10445400.00
      10445400.00
         15900.00
         15900.00
         15900.00
         15900.00
         15900.00
         15900.00
        -15900.00
         15900.00
         15900.00
        -15900.00
        283740.00
       -283740.00
        283740.00
        283740.00
        283740.00
       -283740.00
        283740.00
        283740.00
       -283740.00
        283740.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
        442620.00
         60300.00
         60300.00
        -60300.00
        -60300.00
         60300.00
        -60300.00
        -60300.00
         60300.00
        -60300.00
        -60300.00
        163800.00
       -163800.00
        163800.00
        163800.00
        163800.00
        163800.00
        163800.00
        163800.00
       -163800.00
        163800.00
       -945000.00
       -945000.00
        945000.00
        945000.00
        945000.00
        945000.00
        945000.00
        945000.00
        945000.00
        945000.00
       1907760.00
       1907760.00
       1907760.00
       1907760.00
       1907760.00
       1907760.00
       1907760.00
       1907760.00
       1907760.00
       1907760.00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
              .00
       -103839.00
        103838.70
        103839.00
        103838.70
        103839.00
        103838.68
       -103838.68
        103838.70
        103838.68
        103838.70
       -477096.00
        477096.00
        477095.82
        477096.00
       -477095.82
       -477096.00
        477095.82
        477095.80
        477096.00
        477095.82
         46073.00
         46073.40
        -46073.40
         46073.00
         46073.41
        -46073.00
         46073.00
         46073.00
        -46073.00
        -46073.00
        264361.00
        264360.70
        264361.00
        264360.70
       -264361.00
        264360.69
        264360.70
        264360.69
       -264360.70
       -264360.69
        161891.20
        161891.00
        161891.20
        161891.00
       -161891.00
        161891.00
        161891.00
        161891.00
        161891.00
        161891.19
      -1064166.00
      -1064165.98
       1064166.00
       1064165.98
      -1064166.00
       1064165.98
      -1064166.00
       1064166.00
      -1064166.00
       1064166.00
       4549429.00
       4549429.27
       4549429.00
       4549429.27
       4549429.27
       4549429.30
       4549429.27
      -4549429.00
       4549429.30
       4549429.30
        620709.24
        620709.00
       -620709.00
        620709.24
       -620709.00
       -620709.24
       -620709.24
        620709.20
       -620709.00
        620709.24
         24567.89
         24567.90
         24567.89
         24568.00
         24568.00
        -24567.89
         24567.90
         24567.90
        -24567.90
        -24568.00
       1738672.60
       1738673.00
      -1738672.56
      -1738672.60
       1738673.00
      -1738672.60
      -1738673.00
      -1738672.56
       1738672.60
       1738672.56
     -48012344.00
     -48012344.10
      48012344.10
      48012344.00
      48012344.12
     -48012344.10
      48012344.00
      48012344.12
      48012344.00
     -48012344.10
      10445457.00
      10445457.27
     -10445457.00
     -10445457.00
      10445457.00
     -10445457.00
      10445457.27
     -10445457.00
      10445457.00
     -10445457.27
        -15909.98
        -15910.00
        -15910.00
        -15910.00
         15910.00
         15910.00
         15910.00
         15909.98
         15910.00
         15910.00
       -283767.00
       -283767.00
        283767.00
        283767.24
       -283767.24
       -283767.24
       -283767.24
        283767.00
        283767.00
        283767.00
       -442672.13
       -442672.00
        442672.00
        442672.00
        442672.10
       -442672.00
        442672.00
        442672.13
        442672.13
        442672.00
         60344.35
         60344.40
         60344.00
         60344.00
         60344.35
        -60344.00
         60344.00
         60344.00
        -60344.35
        -60344.00
        163857.00
        163857.00
       -163857.00
        163857.00
        163857.30
        163857.00
       -163857.00
        163857.32
        163857.00
        163857.00
        945004.27
        945004.30
       -945004.30
       -945004.30
        945004.00
        945004.00
        945004.30
       -945004.30
        945004.00
        945004.00
       1907811.00
      -1907811.20
       1907811.18
      -1907811.00
       1907811.18
       1907811.18
      -1907811.00
      -1907811.00
       1907811.00
       1907811.20
EOF
if [ $? -ne 0 ] ; then fail ; fi

pass
