/* src/language/utilities/set.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../src/language/utilities/set.q.
   Do not modify!
 */
#line 1 "../src/language/utilities/set.q"
/* PSPP - computes sample statistics.
   Copyright (C) 1997-9, 2000, 2006 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA. */

#include <config.h>

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>

#include <data/data-in.h>
#include <data/data-out.h>
#include <data/dictionary.h>
#include <data/format.h>
#include <data/procedure.h>
#include <data/settings.h>
#include <data/value.h>
#include <data/variable.h>
#include <language/command.h>
#include <language/lexer/format-parser.h>
#include <language/lexer/lexer.h>
#include <language/prompt.h>
#include <libpspp/alloc.h>
#include <libpspp/compiler.h>
#include <libpspp/copyleft.h>
#include <libpspp/float-format.h>
#include <libpspp/integer-format.h>
#include <libpspp/magic.h>
#include <libpspp/message.h>
#include <math/random.h>
#include <output/output.h>

#if HAVE_LIBTERMCAP
#if HAVE_TERMCAP_H
#include <termcap.h>
#else /* !HAVE_TERMCAP_H */
int tgetent (char *, const char *);
int tgetnum (const char *);
#endif /* !HAVE_TERMCAP_H */
#endif /* !HAVE_LIBTERMCAP */

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 67 "src/language/utilities/set.c"
#line 121 "../src/language/utilities/set.q"

#line 70 "src/language/utilities/set.c"
#include <stdlib.h>
#include <libpspp/alloc.h>
#include <libpspp/assertion.h>
#include <libpspp/message.h>
#include <language/lexer/lexer.h>
#include <language/lexer/variable-parser.h>
#include <data/settings.h>
#include <libpspp/str.h>
#include <language/lexer/subcommand-list.h>
#include <data/variable.h>

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 123 "../src/language/utilities/set.q"

#line 87 "src/language/utilities/set.c"
/* Settings for subcommand specifiers. */
enum
  {
    STC_UPPER = 1000,
    STC_UPLOW,
    STC_ON,
    STC_OFF,
    STC_DOT,
    STC_COMMA,
    STC_TERMINAL,
    STC_LISTING,
    STC_BOTH,
    STC_NONE,
    STC_NO,
    STC_YES,
    STC_BLANK,
    STC_AUTO,
    STC_STANDARD,
    STC_EXTENDED,
    STC_MSBFIRST,
    STC_LSBFIRST,
    STC_VAX,
    STC_NATIVE,
    STC_ISL,
    STC_ISB,
    STC_IDL,
    STC_IDB,
    STC_VF,
    STC_VD,
    STC_VG,
    STC_ZS,
    STC_ZL,
    STC_WARN,
    STC_NOWARN
  };

#define MAXLISTS 10
/* SET structure. */
struct cmd_set
  {
    /* BLANKS subcommand. */
    int sbc_blanks;
    
    /* BLOCK subcommand. */
    int sbc_block;
    char *s_block;
    
    /* BOXSTRING subcommand. */
    int sbc_boxstring;
    char *s_boxstring;
    
    /* CASE subcommand. */
    int sbc_case;
    long size;
    
    /* CCA subcommand. */
    int sbc_cca;
    char *s_cca;
    
    /* CCB subcommand. */
    int sbc_ccb;
    char *s_ccb;
    
    /* CCC subcommand. */
    int sbc_ccc;
    char *s_ccc;
    
    /* CCD subcommand. */
    int sbc_ccd;
    char *s_ccd;
    
    /* CCE subcommand. */
    int sbc_cce;
    char *s_cce;
    
    /* COMPRESSION subcommand. */
    int sbc_compression;
    long compress;
    
    /* CPI subcommand. */
    int sbc_cpi;
    long n_cpi[MAXLISTS];
    
    /* CPROMPT subcommand. */
    int sbc_cprompt;
    char *s_cprompt;
    
    /* DECIMAL subcommand. */
    int sbc_decimal;
    long dec;
    
    /* DISK subcommand. */
    int sbc_disk;
    
    /* DPROMPT subcommand. */
    int sbc_dprompt;
    char *s_dprompt;
    
    /* ECHO subcommand. */
    int sbc_echo;
    long echo;
    
    /* ENDCMD subcommand. */
    int sbc_endcmd;
    char *s_endcmd;
    
    /* EPOCH subcommand. */
    int sbc_epoch;
    
    /* ERRORBREAK subcommand. */
    int sbc_errorbreak;
    long errbrk;
    
    /* ERRORS subcommand. */
    int sbc_errors;
    long errors;
    
    /* FORMAT subcommand. */
    int sbc_format;
    
    /* HEADERS subcommand. */
    int sbc_headers;
    long headers;
    
    /* HIGHRES subcommand. */
    int sbc_highres;
    long hires;
    
    /* HISTOGRAM subcommand. */
    int sbc_histogram;
    char *s_histogram;
    
    /* INCLUDE subcommand. */
    int sbc_include;
    long inc;
    
    /* JOURNAL subcommand. */
    int sbc_journal;
    
    /* LENGTH subcommand. */
    int sbc_length;
    
    /* LISTING subcommand. */
    int sbc_listing;
    
    /* LOWRES subcommand. */
    int sbc_lowres;
    long lores;
    
    /* LPI subcommand. */
    int sbc_lpi;
    long n_lpi[MAXLISTS];
    
    /* MENUS subcommand. */
    int sbc_menus;
    long menus;
    
    /* MESSAGES subcommand. */
    int sbc_messages;
    long messages;
    
    /* MEXPAND subcommand. */
    int sbc_mexpand;
    long mexp;
    
    /* MITERATE subcommand. */
    int sbc_miterate;
    long n_miterate[MAXLISTS];
    
    /* MNEST subcommand. */
    int sbc_mnest;
    long n_mnest[MAXLISTS];
    
    /* MPRINT subcommand. */
    int sbc_mprint;
    long mprint;
    
    /* MXERRS subcommand. */
    int sbc_mxerrs;
    long n_mxerrs[MAXLISTS];
    
    /* MXLOOPS subcommand. */
    int sbc_mxloops;
    long n_mxloops[MAXLISTS];
    
    /* MXMEMORY subcommand. */
    int sbc_mxmemory;
    long n_mxmemory[MAXLISTS];
    
    /* MXWARNS subcommand. */
    int sbc_mxwarns;
    long n_mxwarns[MAXLISTS];
    
    /* NULLINE subcommand. */
    int sbc_nulline;
    long null;
    
    /* PRINTBACK subcommand. */
    int sbc_printback;
    long prtbck;
    
    /* PROMPT subcommand. */
    int sbc_prompt;
    char *s_prompt;
    
    /* RESULTS subcommand. */
    int sbc_results;
    long res;
    
    /* RIB subcommand. */
    int sbc_rib;
    long rib;
    
    /* RRB subcommand. */
    int sbc_rrb;
    long rrb;
    
    /* SAFER subcommand. */
    int sbc_safer;
    long safe;
    
    /* SCOMPRESSION subcommand. */
    int sbc_scompression;
    long scompress;
    
    /* SCRIPTTAB subcommand. */
    int sbc_scripttab;
    char *s_scripttab;
    
    /* SEED subcommand. */
    int sbc_seed;
    
    /* TB1 subcommand. */
    int sbc_tb1;
    char *s_tb1;
    
    /* TBFONTS subcommand. */
    int sbc_tbfonts;
    char *s_tbfonts;
    
    /* UNDEFINED subcommand. */
    int sbc_undefined;
    long undef;
    
    /* WIB subcommand. */
    int sbc_wib;
    long wib;
    
    /* WRB subcommand. */
    int sbc_wrb;
    long wrb;
    
    /* WIDTH subcommand. */
    int sbc_width;
    
    /* WORKSPACE subcommand. */
    int sbc_workspace;
    long n_workspace[MAXLISTS];
    
    /* XSORT subcommand. */
    int sbc_xsort;
    long xsort;
  };

/* Prototype for custom subcommands of SET. */
static int stc_custom_blanks (struct lexer *, struct dataset *, struct cmd_set *, void *);
static int stc_custom_disk (struct lexer *, struct dataset *, struct cmd_set *, void *);
static int stc_custom_epoch (struct lexer *, struct dataset *, struct cmd_set *, void *);
static int stc_custom_format (struct lexer *, struct dataset *, struct cmd_set *, void *);
static int stc_custom_journal (struct lexer *, struct dataset *, struct cmd_set *, void *);
static int stc_custom_length (struct lexer *, struct dataset *, struct cmd_set *, void *);
static int stc_custom_listing (struct lexer *, struct dataset *, struct cmd_set *, void *);
static int stc_custom_seed (struct lexer *, struct dataset *, struct cmd_set *, void *);
static int stc_custom_width (struct lexer *, struct dataset *, struct cmd_set *, void *);

/* Command parsing functions. */
static int parse_set (struct lexer *, struct dataset *, struct cmd_set *, void *);
static void free_set (struct cmd_set *);

#line 125 "../src/language/utilities/set.q"

#line 369 "src/language/utilities/set.c"
static int
parse_set (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_set *p, void *aux UNUSED)
{
  p->sbc_blanks = 0;
  p->sbc_block = 0;
  p->s_block = NULL;
  p->sbc_boxstring = 0;
  p->s_boxstring = NULL;
  p->sbc_case = 0;
  p->size = -1;
  p->sbc_cca = 0;
  p->s_cca = NULL;
  p->sbc_ccb = 0;
  p->s_ccb = NULL;
  p->sbc_ccc = 0;
  p->s_ccc = NULL;
  p->sbc_ccd = 0;
  p->s_ccd = NULL;
  p->sbc_cce = 0;
  p->s_cce = NULL;
  p->sbc_compression = 0;
  p->compress = -1;
  p->sbc_cpi = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_cpi[i] = NOT_LONG;
  }
  p->sbc_cprompt = 0;
  p->s_cprompt = NULL;
  p->sbc_decimal = 0;
  p->dec = -1;
  p->sbc_disk = 0;
  p->sbc_dprompt = 0;
  p->s_dprompt = NULL;
  p->sbc_echo = 0;
  p->echo = -1;
  p->sbc_endcmd = 0;
  p->s_endcmd = NULL;
  p->sbc_epoch = 0;
  p->sbc_errorbreak = 0;
  p->errbrk = -1;
  p->sbc_errors = 0;
  p->errors = -1;
  p->sbc_format = 0;
  p->sbc_headers = 0;
  p->headers = -1;
  p->sbc_highres = 0;
  p->hires = -1;
  p->sbc_histogram = 0;
  p->s_histogram = NULL;
  p->sbc_include = 0;
  p->inc = -1;
  p->sbc_journal = 0;
  p->sbc_length = 0;
  p->sbc_listing = 0;
  p->sbc_lowres = 0;
  p->lores = -1;
  p->sbc_lpi = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_lpi[i] = NOT_LONG;
  }
  p->sbc_menus = 0;
  p->menus = -1;
  p->sbc_messages = 0;
  p->messages = -1;
  p->sbc_mexpand = 0;
  p->mexp = -1;
  p->sbc_miterate = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_miterate[i] = NOT_LONG;
  }
  p->sbc_mnest = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_mnest[i] = NOT_LONG;
  }
  p->sbc_mprint = 0;
  p->mprint = -1;
  p->sbc_mxerrs = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_mxerrs[i] = NOT_LONG;
  }
  p->sbc_mxloops = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_mxloops[i] = NOT_LONG;
  }
  p->sbc_mxmemory = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_mxmemory[i] = NOT_LONG;
  }
  p->sbc_mxwarns = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_mxwarns[i] = NOT_LONG;
  }
  p->sbc_nulline = 0;
  p->null = -1;
  p->sbc_printback = 0;
  p->prtbck = -1;
  p->sbc_prompt = 0;
  p->s_prompt = NULL;
  p->sbc_results = 0;
  p->res = -1;
  p->sbc_rib = 0;
  p->rib = -1;
  p->sbc_rrb = 0;
  p->rrb = -1;
  p->sbc_safer = 0;
  p->safe = -1;
  p->sbc_scompression = 0;
  p->scompress = -1;
  p->sbc_scripttab = 0;
  p->s_scripttab = NULL;
  p->sbc_seed = 0;
  p->sbc_tb1 = 0;
  p->s_tb1 = NULL;
  p->sbc_tbfonts = 0;
  p->s_tbfonts = NULL;
  p->sbc_undefined = 0;
  p->undef = -1;
  p->sbc_wib = 0;
  p->wib = -1;
  p->sbc_wrb = 0;
  p->wrb = -1;
  p->sbc_width = 0;
  p->sbc_workspace = 0;
  {
    int i;
    for (i = 0; i < MAXLISTS; ++i)
      p->n_workspace[i] = NOT_LONG;
  }
  p->sbc_xsort = 0;
  p->xsort = -1;
  for (;;)
    {
      if (lex_match_id (lexer, "BLANKS"))
        {
          lex_match (lexer, '=');
          p->sbc_blanks++;
          if (p->sbc_blanks > 1)
            {
              msg (SE, _("BLANKS subcommand may be given only once."));
              goto lossage;
            }
          switch (stc_custom_blanks (lexer, ds, p, aux))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (lexer, NULL);
              goto lossage;
            default:
              NOT_REACHED ();
            }
        }
      else if (lex_match_id (lexer, "BLOCK"))
        {
          lex_match (lexer, '=');
          p->sbc_block++;
          if (p->sbc_block > 1)
            {
              msg (SE, _("BLOCK subcommand may be given only once."));
              goto lossage;
            }
          {
            int x;
            if (!lex_force_string (lexer))
              return false;
            x = ds_length (lex_tokstr (lexer));
            if (!(x==1))
              {
                msg (SE, _("String for BLOCK must be one character long."));
                goto lossage;
              }
            free(p->s_block);
            p->s_block = ds_xstrdup (lex_tokstr (lexer));
            lex_get (lexer);
          }
        }
      else if (lex_match_id (lexer, "BOXSTRING"))
        {
          lex_match (lexer, '=');
          p->sbc_boxstring++;
          if (p->sbc_boxstring > 1)
            {
              msg (SE, _("BOXSTRING subcommand may be given only once."));
              goto lossage;
            }
          {
            int x;
            if (!lex_force_string (lexer))
              return false;
            x = ds_length (lex_tokstr (lexer));
            if (!(x==3 || x==11))
              {
                msg (SE, _("String for BOXSTRING must be 3 or 11 characters long."));
                goto lossage;
              }
            free(p->s_boxstring);
            p->s_boxstring = ds_xstrdup (lex_tokstr (lexer));
            lex_get (lexer);
          }
        }
      else if (lex_match_id (lexer, "CASE"))
        {
          lex_match (lexer, '=');
          p->sbc_case++;
          if (p->sbc_case > 1)
            {
              msg (SE, _("CASE subcommand may be given only once."));
              goto lossage;
            }
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if (lex_match_id (lexer, "UPPER"))
                p->size = STC_UPPER;
              else if (lex_match_id (lexer, "UPLOW"))
                p->size = STC_UPLOW;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "CCA"))
        {
          lex_match (lexer, '=');
          p->sbc_cca++;
          if (p->sbc_cca > 1)
            {
              msg (SE, _("CCA subcommand may be given only once."));
              goto lossage;
            }
          if (!lex_force_string (lexer))
            return false;
          free(p->s_cca);
          p->s_cca = ds_xstrdup (lex_tokstr (lexer));
          lex_get (lexer);
        }
      else if (lex_match_id (lexer, "CCB"))
        {
          lex_match (lexer, '=');
          p->sbc_ccb++;
          if (p->sbc_ccb > 1)
            {
              msg (SE, _("CCB subcommand may be given only once."));
              goto lossage;
            }
          if (!lex_force_string (lexer))
            return false;
          free(p->s_ccb);
          p->s_ccb = ds_xstrdup (lex_tokstr (lexer));
          lex_get (lexer);
        }
      else if (lex_match_id (lexer, "CCC"))
        {
          lex_match (lexer, '=');
          p->sbc_ccc++;
          if (p->sbc_ccc > 1)
            {
              msg (SE, _("CCC subcommand may be given only once."));
              goto lossage;
            }
          if (!lex_force_string (lexer))
            return false;
          free(p->s_ccc);
          p->s_ccc = ds_xstrdup (lex_tokstr (lexer));
          lex_get (lexer);
        }
      else if (lex_match_id (lexer, "CCD"))
        {
          lex_match (lexer, '=');
          p->sbc_ccd++;
          if (p->sbc_ccd > 1)
            {
              msg (SE, _("CCD subcommand may be given only once."));
              goto lossage;
            }
          if (!lex_force_string (lexer))
            return false;
          free(p->s_ccd);
          p->s_ccd = ds_xstrdup (lex_tokstr (lexer));
          lex_get (lexer);
        }
      else if (lex_match_id (lexer, "CCE"))
        {
          lex_match (lexer, '=');
          p->sbc_cce++;
          if (p->sbc_cce > 1)
            {
              msg (SE, _("CCE subcommand may be given only once."));
              goto lossage;
            }
          if (!lex_force_string (lexer))
            return false;
          free(p->s_cce);
          p->s_cce = ds_xstrdup (lex_tokstr (lexer));
          lex_get (lexer);
        }
      else if (lex_match_id (lexer, "COMPRESSION"))
        {
          lex_match (lexer, '=');
          p->sbc_compression++;
          if (p->sbc_compression > 1)
            {
              msg (SE, _("COMPRESSION subcommand may be given only once."));
              goto lossage;
            }
          while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
            {
              if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                p->compress = STC_ON;
              else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                p->compress = STC_OFF;
              else
                {
                  lex_error (lexer, NULL);
                  goto lossage;
                }
              lex_match (lexer, ',');
            }
        }
      else if (lex_match_id (lexer, "CPI"))
        {
          lex_match (lexer, '=');
          p->sbc_cpi++;
          if (p->sbc_cpi > 1)
            {
              msg (SE, _("CPI subcommand may be given only once."));
              goto lossage;
            }
          {
            int x;
            if (!lex_force_int (lexer))
              goto lossage;
            x = lex_integer (lexer);
            lex_get(lexer);
            if (!(x>0))
              {
                msg (SE, "CPI must be greater than 0");
                goto lossage;
              }
              p->n_cpi[p->sbc_cpi - 1] = x;
            }
          }
        else if (lex_match_id (lexer, "CPROMPT"))
          {
            lex_match (lexer, '=');
            p->sbc_cprompt++;
            if (p->sbc_cprompt > 1)
              {
                msg (SE, _("CPROMPT subcommand may be given only once."));
                goto lossage;
              }
            if (!lex_force_string (lexer))
              return false;
            free(p->s_cprompt);
            p->s_cprompt = ds_xstrdup (lex_tokstr (lexer));
            lex_get (lexer);
          }
        else if (lex_match_id (lexer, "DECIMAL"))
          {
            lex_match (lexer, '=');
            p->sbc_decimal++;
            if (p->sbc_decimal > 1)
              {
                msg (SE, _("DECIMAL subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "DOT"))
                  p->dec = STC_DOT;
                else if (lex_match_id (lexer, "COMMA"))
                  p->dec = STC_COMMA;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "DISK"))
          {
            lex_match (lexer, '=');
            p->sbc_disk++;
            if (p->sbc_disk > 1)
              {
                msg (SE, _("DISK subcommand may be given only once."));
                goto lossage;
              }
            switch (stc_custom_disk (lexer, ds, p, aux))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (lexer, NULL);
                goto lossage;
              default:
                NOT_REACHED ();
              }
          }
        else if (lex_match_id (lexer, "DPROMPT"))
          {
            lex_match (lexer, '=');
            p->sbc_dprompt++;
            if (p->sbc_dprompt > 1)
              {
                msg (SE, _("DPROMPT subcommand may be given only once."));
                goto lossage;
              }
            if (!lex_force_string (lexer))
              return false;
            free(p->s_dprompt);
            p->s_dprompt = ds_xstrdup (lex_tokstr (lexer));
            lex_get (lexer);
          }
        else if (lex_match_id (lexer, "ECHO"))
          {
            lex_match (lexer, '=');
            p->sbc_echo++;
            if (p->sbc_echo > 1)
              {
                msg (SE, _("ECHO subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                  p->echo = STC_ON;
                else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                  p->echo = STC_OFF;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "ENDCMD"))
          {
            lex_match (lexer, '=');
            p->sbc_endcmd++;
            if (p->sbc_endcmd > 1)
              {
                msg (SE, _("ENDCMD subcommand may be given only once."));
                goto lossage;
              }
            {
              int x;
              if (!lex_force_string (lexer))
                return false;
              x = ds_length (lex_tokstr (lexer));
              if (!(x==1))
                {
                  msg (SE, _("String for ENDCMD must be one character long."));
                  goto lossage;
                }
              free(p->s_endcmd);
              p->s_endcmd = ds_xstrdup (lex_tokstr (lexer));
              lex_get (lexer);
            }
          }
        else if (lex_match_id (lexer, "EPOCH"))
          {
            lex_match (lexer, '=');
            p->sbc_epoch++;
            if (p->sbc_epoch > 1)
              {
                msg (SE, _("EPOCH subcommand may be given only once."));
                goto lossage;
              }
            switch (stc_custom_epoch (lexer, ds, p, aux))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (lexer, NULL);
                goto lossage;
              default:
                NOT_REACHED ();
              }
          }
        else if (lex_match_id (lexer, "ERRORBREAK"))
          {
            lex_match (lexer, '=');
            p->sbc_errorbreak++;
            if (p->sbc_errorbreak > 1)
              {
                msg (SE, _("ERRORBREAK subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                  p->errbrk = STC_ON;
                else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                  p->errbrk = STC_OFF;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "ERRORS"))
          {
            lex_match (lexer, '=');
            p->sbc_errors++;
            if (p->sbc_errors > 1)
              {
                msg (SE, _("ERRORS subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "TERMINAL"))
                  p->errors = STC_TERMINAL;
                else if (lex_match_id (lexer, "LISTING"))
                  p->errors = STC_LISTING;
                else if (lex_match_id (lexer, "BOTH"))
                  p->errors = STC_BOTH;
                else if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                  p->errors = STC_ON;
                else if (lex_match_id (lexer, "NONE"))
                  p->errors = STC_NONE;
                else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                  p->errors = STC_OFF;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "FORMAT"))
          {
            lex_match (lexer, '=');
            p->sbc_format++;
            if (p->sbc_format > 1)
              {
                msg (SE, _("FORMAT subcommand may be given only once."));
                goto lossage;
              }
            switch (stc_custom_format (lexer, ds, p, aux))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (lexer, NULL);
                goto lossage;
              default:
                NOT_REACHED ();
              }
          }
        else if (lex_match_id (lexer, "HEADERS"))
          {
            lex_match (lexer, '=');
            p->sbc_headers++;
            if (p->sbc_headers > 1)
              {
                msg (SE, _("HEADERS subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                  p->headers = STC_NO;
                else if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                  p->headers = STC_YES;
                else if (lex_match_id (lexer, "BLANK"))
                  p->headers = STC_BLANK;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "HIGHRES"))
          {
            lex_match (lexer, '=');
            p->sbc_highres++;
            if (p->sbc_highres > 1)
              {
                msg (SE, _("HIGHRES subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                  p->hires = STC_ON;
                else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                  p->hires = STC_OFF;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "HISTOGRAM"))
          {
            lex_match (lexer, '=');
            p->sbc_histogram++;
            if (p->sbc_histogram > 1)
              {
                msg (SE, _("HISTOGRAM subcommand may be given only once."));
                goto lossage;
              }
            {
              int x;
              if (!lex_force_string (lexer))
                return false;
              x = ds_length (lex_tokstr (lexer));
              if (!(x==1))
                {
                  msg (SE, _("String for HISTOGRAM must be one character long."));
                  goto lossage;
                }
              free(p->s_histogram);
              p->s_histogram = ds_xstrdup (lex_tokstr (lexer));
              lex_get (lexer);
            }
          }
        else if (lex_match_id (lexer, "INCLUDE"))
          {
            lex_match (lexer, '=');
            p->sbc_include++;
            if (p->sbc_include > 1)
              {
                msg (SE, _("INCLUDE subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                  p->inc = STC_ON;
                else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                  p->inc = STC_OFF;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "JOURNAL"))
          {
            lex_match (lexer, '=');
            p->sbc_journal++;
            if (p->sbc_journal > 1)
              {
                msg (SE, _("JOURNAL subcommand may be given only once."));
                goto lossage;
              }
            switch (stc_custom_journal (lexer, ds, p, aux))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (lexer, NULL);
                goto lossage;
              default:
                NOT_REACHED ();
              }
          }
        else if (lex_match_id (lexer, "LENGTH"))
          {
            lex_match (lexer, '=');
            p->sbc_length++;
            if (p->sbc_length > 1)
              {
                msg (SE, _("LENGTH subcommand may be given only once."));
                goto lossage;
              }
            switch (stc_custom_length (lexer, ds, p, aux))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (lexer, NULL);
                goto lossage;
              default:
                NOT_REACHED ();
              }
          }
        else if (lex_match_id (lexer, "LISTING"))
          {
            lex_match (lexer, '=');
            p->sbc_listing++;
            if (p->sbc_listing > 1)
              {
                msg (SE, _("LISTING subcommand may be given only once."));
                goto lossage;
              }
            switch (stc_custom_listing (lexer, ds, p, aux))
              {
              case 0:
                goto lossage;
              case 1:
                break;
              case 2:
                lex_error (lexer, NULL);
                goto lossage;
              default:
                NOT_REACHED ();
              }
          }
        else if (lex_match_id (lexer, "LOWRES"))
          {
            lex_match (lexer, '=');
            p->sbc_lowres++;
            if (p->sbc_lowres > 1)
              {
                msg (SE, _("LOWRES subcommand may be given only once."));
                goto lossage;
              }
            while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
              {
                if (lex_match_id (lexer, "AUTO"))
                  p->lores = STC_AUTO;
                else if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                  p->lores = STC_ON;
                else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                  p->lores = STC_OFF;
                else
                  {
                    lex_error (lexer, NULL);
                    goto lossage;
                  }
                lex_match (lexer, ',');
              }
          }
        else if (lex_match_id (lexer, "LPI"))
          {
            lex_match (lexer, '=');
            p->sbc_lpi++;
            if (p->sbc_lpi > 1)
              {
                msg (SE, _("LPI subcommand may be given only once."));
                goto lossage;
              }
            {
              int x;
              if (!lex_force_int (lexer))
                goto lossage;
              x = lex_integer (lexer);
              lex_get(lexer);
              if (!(x>0))
                {
                  msg (SE, "LPI must be greater than 0");
                  goto lossage;
                }
                p->n_lpi[p->sbc_lpi - 1] = x;
              }
            }
          else if (lex_match_id (lexer, "MENUS"))
            {
              lex_match (lexer, '=');
              p->sbc_menus++;
              if (p->sbc_menus > 1)
                {
                  msg (SE, _("MENUS subcommand may be given only once."));
                  goto lossage;
                }
              while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                {
                  if (lex_match_id (lexer, "STANDARD"))
                    p->menus = STC_STANDARD;
                  else if (lex_match_id (lexer, "EXTENDED"))
                    p->menus = STC_EXTENDED;
                  else
                    {
                      lex_error (lexer, NULL);
                      goto lossage;
                    }
                  lex_match (lexer, ',');
                }
            }
          else if (lex_match_id (lexer, "MESSAGES"))
            {
              lex_match (lexer, '=');
              p->sbc_messages++;
              if (p->sbc_messages > 1)
                {
                  msg (SE, _("MESSAGES subcommand may be given only once."));
                  goto lossage;
                }
              while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                {
                  if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                    p->messages = STC_ON;
                  else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                    p->messages = STC_OFF;
                  else if (lex_match_id (lexer, "TERMINAL"))
                    p->messages = STC_TERMINAL;
                  else if (lex_match_id (lexer, "LISTING"))
                    p->messages = STC_LISTING;
                  else if (lex_match_id (lexer, "BOTH"))
                    p->messages = STC_BOTH;
                  else if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                    p->messages = STC_ON;
                  else if (lex_match_id (lexer, "NONE"))
                    p->messages = STC_NONE;
                  else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                    p->messages = STC_OFF;
                  else
                    {
                      lex_error (lexer, NULL);
                      goto lossage;
                    }
                  lex_match (lexer, ',');
                }
            }
          else if (lex_match_id (lexer, "MEXPAND"))
            {
              lex_match (lexer, '=');
              p->sbc_mexpand++;
              if (p->sbc_mexpand > 1)
                {
                  msg (SE, _("MEXPAND subcommand may be given only once."));
                  goto lossage;
                }
              while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                {
                  if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                    p->mexp = STC_ON;
                  else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                    p->mexp = STC_OFF;
                  else
                    {
                      lex_error (lexer, NULL);
                      goto lossage;
                    }
                  lex_match (lexer, ',');
                }
            }
          else if (lex_match_id (lexer, "MITERATE"))
            {
              lex_match (lexer, '=');
              p->sbc_miterate++;
              if (p->sbc_miterate > 1)
                {
                  msg (SE, _("MITERATE subcommand may be given only once."));
                  goto lossage;
                }
              {
                int x;
                if (!lex_force_int (lexer))
                  goto lossage;
                x = lex_integer (lexer);
                lex_get(lexer);
                if (!(x>0))
                  {
                    msg (SE, "MITERATE must be greater than 0");
                    goto lossage;
                  }
                  p->n_miterate[p->sbc_miterate - 1] = x;
                }
              }
            else if (lex_match_id (lexer, "MNEST"))
              {
                lex_match (lexer, '=');
                p->sbc_mnest++;
                if (p->sbc_mnest > 1)
                  {
                    msg (SE, _("MNEST subcommand may be given only once."));
                    goto lossage;
                  }
                {
                  int x;
                  if (!lex_force_int (lexer))
                    goto lossage;
                  x = lex_integer (lexer);
                  lex_get(lexer);
                  if (!(x>0))
                    {
                      msg (SE, "MNEST must be greater than 0");
                      goto lossage;
                    }
                    p->n_mnest[p->sbc_mnest - 1] = x;
                  }
                }
              else if (lex_match_id (lexer, "MPRINT"))
                {
                  lex_match (lexer, '=');
                  p->sbc_mprint++;
                  if (p->sbc_mprint > 1)
                    {
                      msg (SE, _("MPRINT subcommand may be given only once."));
                      goto lossage;
                    }
                  while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                    {
                      if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                        p->mprint = STC_ON;
                      else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                        p->mprint = STC_OFF;
                      else
                        {
                          lex_error (lexer, NULL);
                          goto lossage;
                        }
                      lex_match (lexer, ',');
                    }
                }
              else if (lex_match_id (lexer, "MXERRS"))
                {
                  lex_match (lexer, '=');
                  p->sbc_mxerrs++;
                  if (p->sbc_mxerrs > 1)
                    {
                      msg (SE, _("MXERRS subcommand may be given only once."));
                      goto lossage;
                    }
                  {
                    int x;
                    if (!lex_force_int (lexer))
                      goto lossage;
                    x = lex_integer (lexer);
                    lex_get(lexer);
                    if (!(x >= 1))
                      {
                        msg (SE, "MXERRS must be at least 1");
                        goto lossage;
                      }
                      p->n_mxerrs[p->sbc_mxerrs - 1] = x;
                    }
                  }
                else if (lex_match_id (lexer, "MXLOOPS"))
                  {
                    lex_match (lexer, '=');
                    p->sbc_mxloops++;
                    if (p->sbc_mxloops > 1)
                      {
                        msg (SE, _("MXLOOPS subcommand may be given only once."));
                        goto lossage;
                      }
                    {
                      int x;
                      if (!lex_force_int (lexer))
                        goto lossage;
                      x = lex_integer (lexer);
                      lex_get(lexer);
                      if (!(x >=1))
                        {
                          msg (SE, "MXLOOPS must be at least 1");
                          goto lossage;
                        }
                        p->n_mxloops[p->sbc_mxloops - 1] = x;
                      }
                    }
                  else if (lex_match_id (lexer, "MXMEMORY"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_mxmemory++;
                      if (p->sbc_mxmemory > 1)
                        {
                          msg (SE, _("MXMEMORY subcommand may be given only once."));
                          goto lossage;
                        }
                      {
                        int x;
                        if (!lex_force_int (lexer))
                          goto lossage;
                        x = lex_integer (lexer);
                        lex_get(lexer);
                        p->n_mxmemory[p->sbc_mxmemory - 1] = x;
                      }
                    }
                  else if (lex_match_id (lexer, "MXWARNS"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_mxwarns++;
                      if (p->sbc_mxwarns > 1)
                        {
                          msg (SE, _("MXWARNS subcommand may be given only once."));
                          goto lossage;
                        }
                      {
                        int x;
                        if (!lex_force_int (lexer))
                          goto lossage;
                        x = lex_integer (lexer);
                        lex_get(lexer);
                        p->n_mxwarns[p->sbc_mxwarns - 1] = x;
                      }
                    }
                  else if (lex_match_id (lexer, "NULLINE"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_nulline++;
                      if (p->sbc_nulline > 1)
                        {
                          msg (SE, _("NULLINE subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                            p->null = STC_ON;
                          else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                            p->null = STC_OFF;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "PRINTBACK"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_printback++;
                      if (p->sbc_printback > 1)
                        {
                          msg (SE, _("PRINTBACK subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                            p->prtbck = STC_ON;
                          else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                            p->prtbck = STC_OFF;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "PROMPT"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_prompt++;
                      if (p->sbc_prompt > 1)
                        {
                          msg (SE, _("PROMPT subcommand may be given only once."));
                          goto lossage;
                        }
                      if (!lex_force_string (lexer))
                        return false;
                      free(p->s_prompt);
                      p->s_prompt = ds_xstrdup (lex_tokstr (lexer));
                      lex_get (lexer);
                    }
                  else if (lex_match_id (lexer, "RESULTS"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_results++;
                      if (p->sbc_results > 1)
                        {
                          msg (SE, _("RESULTS subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                            p->res = STC_ON;
                          else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                            p->res = STC_OFF;
                          else if (lex_match_id (lexer, "TERMINAL"))
                            p->res = STC_TERMINAL;
                          else if (lex_match_id (lexer, "LISTING"))
                            p->res = STC_LISTING;
                          else if (lex_match_id (lexer, "BOTH"))
                            p->res = STC_BOTH;
                          else if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                            p->res = STC_ON;
                          else if (lex_match_id (lexer, "NONE"))
                            p->res = STC_NONE;
                          else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                            p->res = STC_OFF;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "RIB"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_rib++;
                      if (p->sbc_rib > 1)
                        {
                          msg (SE, _("RIB subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if (lex_match_id (lexer, "MSBFIRST"))
                            p->rib = STC_MSBFIRST;
                          else if (lex_match_id (lexer, "LSBFIRST"))
                            p->rib = STC_LSBFIRST;
                          else if (lex_match_id (lexer, "VAX"))
                            p->rib = STC_VAX;
                          else if (lex_match_id (lexer, "NATIVE"))
                            p->rib = STC_NATIVE;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "RRB"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_rrb++;
                      if (p->sbc_rrb > 1)
                        {
                          msg (SE, _("RRB subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if (lex_match_id (lexer, "NATIVE"))
                            p->rrb = STC_NATIVE;
                          else if (lex_match_id (lexer, "ISL"))
                            p->rrb = STC_ISL;
                          else if (lex_match_id (lexer, "ISB"))
                            p->rrb = STC_ISB;
                          else if (lex_match_id (lexer, "IDL"))
                            p->rrb = STC_IDL;
                          else if (lex_match_id (lexer, "IDB"))
                            p->rrb = STC_IDB;
                          else if (lex_match_id (lexer, "VF"))
                            p->rrb = STC_VF;
                          else if (lex_match_id (lexer, "VD"))
                            p->rrb = STC_VD;
                          else if (lex_match_id (lexer, "VG"))
                            p->rrb = STC_VG;
                          else if (lex_match_id (lexer, "ZS"))
                            p->rrb = STC_ZS;
                          else if (lex_match_id (lexer, "ZL"))
                            p->rrb = STC_ZL;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "SAFER"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_safer++;
                      if (p->sbc_safer > 1)
                        {
                          msg (SE, _("SAFER subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                            p->safe = STC_ON;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "SCOMPRESSION"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_scompression++;
                      if (p->sbc_scompression > 1)
                        {
                          msg (SE, _("SCOMPRESSION subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                            p->scompress = STC_ON;
                          else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                            p->scompress = STC_OFF;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "SCRIPTTAB"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_scripttab++;
                      if (p->sbc_scripttab > 1)
                        {
                          msg (SE, _("SCRIPTTAB subcommand may be given only once."));
                          goto lossage;
                        }
                      {
                        int x;
                        if (!lex_force_string (lexer))
                          return false;
                        x = ds_length (lex_tokstr (lexer));
                        if (!(x==1))
                          {
                            msg (SE, _("String for SCRIPTTAB must be one character long."));
                            goto lossage;
                          }
                        free(p->s_scripttab);
                        p->s_scripttab = ds_xstrdup (lex_tokstr (lexer));
                        lex_get (lexer);
                      }
                    }
                  else if (lex_match_id (lexer, "SEED"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_seed++;
                      if (p->sbc_seed > 1)
                        {
                          msg (SE, _("SEED subcommand may be given only once."));
                          goto lossage;
                        }
                      switch (stc_custom_seed (lexer, ds, p, aux))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (lexer, NULL);
                          goto lossage;
                        default:
                          NOT_REACHED ();
                        }
                    }
                  else if (lex_match_id (lexer, "TB1"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_tb1++;
                      if (p->sbc_tb1 > 1)
                        {
                          msg (SE, _("TB1 subcommand may be given only once."));
                          goto lossage;
                        }
                      {
                        int x;
                        if (!lex_force_string (lexer))
                          return false;
                        x = ds_length (lex_tokstr (lexer));
                        if (!(x==3 || x==11))
                          {
                            msg (SE, _("String for TB1 must be 3 or 11 characters long."));
                            goto lossage;
                          }
                        free(p->s_tb1);
                        p->s_tb1 = ds_xstrdup (lex_tokstr (lexer));
                        lex_get (lexer);
                      }
                    }
                  else if (lex_match_id (lexer, "TBFONTS"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_tbfonts++;
                      if (p->sbc_tbfonts > 1)
                        {
                          msg (SE, _("TBFONTS subcommand may be given only once."));
                          goto lossage;
                        }
                      if (!lex_force_string (lexer))
                        return false;
                      free(p->s_tbfonts);
                      p->s_tbfonts = ds_xstrdup (lex_tokstr (lexer));
                      lex_get (lexer);
                    }
                  else if (lex_match_id (lexer, "UNDEFINED"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_undefined++;
                      if (p->sbc_undefined > 1)
                        {
                          msg (SE, _("UNDEFINED subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if (lex_match_id (lexer, "WARN"))
                            p->undef = STC_WARN;
                          else if (lex_match_id (lexer, "NOWARN"))
                            p->undef = STC_NOWARN;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "WIB"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_wib++;
                      if (p->sbc_wib > 1)
                        {
                          msg (SE, _("WIB subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if (lex_match_id (lexer, "MSBFIRST"))
                            p->wib = STC_MSBFIRST;
                          else if (lex_match_id (lexer, "LSBFIRST"))
                            p->wib = STC_LSBFIRST;
                          else if (lex_match_id (lexer, "VAX"))
                            p->wib = STC_VAX;
                          else if (lex_match_id (lexer, "NATIVE"))
                            p->wib = STC_NATIVE;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "WRB"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_wrb++;
                      if (p->sbc_wrb > 1)
                        {
                          msg (SE, _("WRB subcommand may be given only once."));
                          goto lossage;
                        }
                      while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                        {
                          if (lex_match_id (lexer, "NATIVE"))
                            p->wrb = STC_NATIVE;
                          else if (lex_match_id (lexer, "ISL"))
                            p->wrb = STC_ISL;
                          else if (lex_match_id (lexer, "ISB"))
                            p->wrb = STC_ISB;
                          else if (lex_match_id (lexer, "IDL"))
                            p->wrb = STC_IDL;
                          else if (lex_match_id (lexer, "IDB"))
                            p->wrb = STC_IDB;
                          else if (lex_match_id (lexer, "VF"))
                            p->wrb = STC_VF;
                          else if (lex_match_id (lexer, "VD"))
                            p->wrb = STC_VD;
                          else if (lex_match_id (lexer, "VG"))
                            p->wrb = STC_VG;
                          else if (lex_match_id (lexer, "ZS"))
                            p->wrb = STC_ZS;
                          else if (lex_match_id (lexer, "ZL"))
                            p->wrb = STC_ZL;
                          else
                            {
                              lex_error (lexer, NULL);
                              goto lossage;
                            }
                          lex_match (lexer, ',');
                        }
                    }
                  else if (lex_match_id (lexer, "WIDTH"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_width++;
                      if (p->sbc_width > 1)
                        {
                          msg (SE, _("WIDTH subcommand may be given only once."));
                          goto lossage;
                        }
                      switch (stc_custom_width (lexer, ds, p, aux))
                        {
                        case 0:
                          goto lossage;
                        case 1:
                          break;
                        case 2:
                          lex_error (lexer, NULL);
                          goto lossage;
                        default:
                          NOT_REACHED ();
                        }
                    }
                  else if (lex_match_id (lexer, "WORKSPACE"))
                    {
                      lex_match (lexer, '=');
                      p->sbc_workspace++;
                      if (p->sbc_workspace > 1)
                        {
                          msg (SE, _("WORKSPACE subcommand may be given only once."));
                          goto lossage;
                        }
                      {
                        int x;
                        if (!lex_force_int (lexer))
                          goto lossage;
                        x = lex_integer (lexer);
                        lex_get(lexer);
                        if (!(x>=1024))
                          {
                            msg (SE, "WORKSPACE must be at least 1 MB");
                            goto lossage;
                          }
                          p->n_workspace[p->sbc_workspace - 1] = x;
                        }
                      }
                    else if (lex_match_id (lexer, "XSORT"))
                      {
                        lex_match (lexer, '=');
                        p->sbc_xsort++;
                        if (p->sbc_xsort > 1)
                          {
                            msg (SE, _("XSORT subcommand may be given only once."));
                            goto lossage;
                          }
                        while (lex_token (lexer) != '/' && lex_token (lexer) != '.')
                          {
                            if ((lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES") || lex_match_id (lexer, "TRUE")))
                              p->xsort = STC_YES;
                            else if ((lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO") || lex_match_id (lexer, "FALSE")))
                              p->xsort = STC_NO;
                            else
                              {
                                lex_error (lexer, NULL);
                                goto lossage;
                              }
                            lex_match (lexer, ',');
                          }
                      }
                    else if ( get_syntax() != COMPATIBLE && lex_match_id(lexer, "ALGORITHM"))
                      {
                        lex_match (lexer, '=');
                        if (lex_match_id(lexer, "COMPATIBLE"))
                          set_cmd_algorithm(COMPATIBLE);
                        else if (lex_match_id(lexer, "ENHANCED"))
                          set_cmd_algorithm(ENHANCED);
                        }
                      if (!lex_match (lexer, '/'))
                        break;
                    }
                  
                  if (lex_token (lexer) != '.')
                    {
                      lex_error (lexer, _("expecting end of command"));
                      goto lossage;
                    }
                    
                return true;
                
              lossage:
                free_set (p);
                return false;
              }
              
static void
free_set (struct cmd_set *p)
{
  free (p->s_block);
  free (p->s_boxstring);
  free (p->s_cca);
  free (p->s_ccb);
  free (p->s_ccc);
  free (p->s_ccd);
  free (p->s_cce);
  free (p->s_cprompt);
  free (p->s_dprompt);
  free (p->s_endcmd);
  free (p->s_histogram);
  free (p->s_prompt);
  free (p->s_scripttab);
  free (p->s_tb1);
  free (p->s_tbfonts);
}
#line 127 "../src/language/utilities/set.q"

static bool do_cc (const char *cc_string, enum fmt_type);
static enum integer_format stc_to_integer_format (int stc);
static enum float_format stc_to_float_format (int stc);

int
cmd_set (struct lexer *lexer, struct dataset *ds)
{
  struct cmd_set cmd;

  if (!parse_set (lexer, ds, &cmd, NULL))
    {
      free_set (&cmd);
      return CMD_FAILURE;
    }

  if (cmd.sbc_cca)
    do_cc (cmd.s_cca, FMT_CCA);
  if (cmd.sbc_ccb)
    do_cc (cmd.s_ccb, FMT_CCB);
  if (cmd.sbc_ccc)
    do_cc (cmd.s_ccc, FMT_CCC);
  if (cmd.sbc_ccd)
    do_cc (cmd.s_ccd, FMT_CCD);
  if (cmd.sbc_cce)
    do_cc (cmd.s_cce, FMT_CCE);

  if (cmd.sbc_prompt)
    prompt_set (PROMPT_FIRST, cmd.s_prompt);
  if (cmd.sbc_cprompt)
    prompt_set (PROMPT_LATER, cmd.s_cprompt);
  if (cmd.sbc_dprompt)
    prompt_set (PROMPT_DATA, cmd.s_dprompt);

  if (cmd.sbc_decimal)
    fmt_set_decimal (cmd.dec == STC_DOT ? '.' : ',');
  if (cmd.sbc_echo)
    set_echo (cmd.echo == STC_ON);
  if (cmd.sbc_endcmd)
    set_endcmd (cmd.s_endcmd[0]);
  if (cmd.sbc_errorbreak)
    set_errorbreak (cmd.errbrk == STC_ON);
  if (cmd.sbc_errors)
    {
      bool both = cmd.errors == STC_BOTH || cmd.errors == STC_ON;
      set_error_routing_to_terminal (cmd.errors == STC_TERMINAL || both);
      set_error_routing_to_listing (cmd.errors == STC_LISTING || both);
    }
  if (cmd.sbc_include)
    set_include (cmd.inc == STC_ON);
  if (cmd.sbc_mxerrs)
    set_mxerrs (cmd.n_mxerrs[0]);
  if (cmd.sbc_mxwarns)
    set_mxwarns (cmd.n_mxwarns[0]);
  if (cmd.sbc_nulline)
    set_nulline (cmd.null == STC_ON);
  if (cmd.sbc_rib)
    data_in_set_integer_format (stc_to_integer_format (cmd.rib));
  if (cmd.sbc_rrb)
    data_in_set_float_format (stc_to_float_format (cmd.rrb));
  if (cmd.sbc_safer)
    set_safer_mode ();
  if (cmd.sbc_scompression)
    set_scompression (cmd.scompress == STC_ON);
  if (cmd.sbc_undefined)
    set_undefined (cmd.undef == STC_WARN);
  if (cmd.sbc_wib)
    data_out_set_integer_format (stc_to_integer_format (cmd.wib));
  if (cmd.sbc_wrb)
    data_out_set_float_format (stc_to_float_format (cmd.wrb));
  if (cmd.sbc_workspace)
    set_workspace (cmd.n_workspace[0] * 1024L);

  if (cmd.sbc_block)
    msg (SW, _("%s is obsolete."), "BLOCK");
  if (cmd.sbc_boxstring)
    msg (SW, _("%s is obsolete."), "BOXSTRING");
  if (cmd.sbc_histogram)
    msg (SW, _("%s is obsolete."), "HISTOGRAM");
  if (cmd.sbc_menus)
    msg (SW, _("%s is obsolete."), "MENUS");
  if (cmd.sbc_xsort)
    msg (SW, _("%s is obsolete."), "XSORT");
  if (cmd.sbc_mxmemory)
    msg (SE, _("%s is obsolete."), "MXMEMORY");
  if (cmd.sbc_scripttab)
    msg (SE, _("%s is obsolete."), "SCRIPTTAB");
  if (cmd.sbc_tbfonts)
    msg (SW, _("%s is obsolete."), "TBFONTS");
  if (cmd.sbc_tb1 && cmd.s_tb1)
    msg (SW, _("%s is obsolete."), "TB1");

  if (cmd.sbc_case)
    msg (SW, _("%s is not implemented."), "CASE");

  if (cmd.sbc_compression)
    msg (SW, _("Active file compression is not implemented."));

  free_set (&cmd);

  return CMD_SUCCESS;
}

/* Returns the integer_format value corresponding to STC,
   which should be the value of cmd.rib or cmd.wib. */
static enum integer_format
stc_to_integer_format (int stc) 
{
  return (stc == STC_MSBFIRST ? INTEGER_MSB_FIRST
          : stc == STC_LSBFIRST ? INTEGER_LSB_FIRST
          : stc == STC_VAX ? INTEGER_VAX
          : INTEGER_NATIVE);
}

/* Returns the float_format value corresponding to STC,
   which should be the value of cmd.rrb or cmd.wrb. */
static enum float_format
stc_to_float_format (int stc) 
{
  switch (stc) 
    {
    case STC_NATIVE:
      return FLOAT_NATIVE_DOUBLE;

    case STC_ISL:
      return FLOAT_IEEE_SINGLE_LE;
    case STC_ISB:
      return FLOAT_IEEE_SINGLE_BE;
    case STC_IDL:
      return FLOAT_IEEE_DOUBLE_LE;
    case STC_IDB:
      return FLOAT_IEEE_DOUBLE_BE;

    case STC_VF:
      return FLOAT_VAX_F;
    case STC_VD:
      return FLOAT_VAX_D;
    case STC_VG:
      return FLOAT_VAX_G;

    case STC_ZS:
      return FLOAT_Z_SHORT;
    case STC_ZL:
      return FLOAT_Z_LONG;
    }

  NOT_REACHED ();
}

/* Find the grouping characters in CC_STRING and set CC's
   grouping and decimal members appropriately.  Returns true if
   successful, false otherwise. */
static bool
find_cc_separators (const char *cc_string, struct fmt_number_style *cc)
{
  const char *sp;
  int comma_cnt, dot_cnt;
  
  /* Count commas and periods.  There must be exactly three of
     one or the other, except that an apostrophe escapes a
     following comma or period. */
  comma_cnt = dot_cnt = 0;
  for (sp = cc_string; *sp; sp++)
    if (*sp == ',')
      comma_cnt++;
    else if (*sp == '.')
      dot_cnt++;
    else if (*sp == '\'' && (sp[1] == '.' || sp[1] == ',' || sp[1] == '\''))
      sp++;
  
  if ((comma_cnt == 3) == (dot_cnt == 3))
    return false;

  if (comma_cnt == 3)
    {
      cc->decimal = '.';
      cc->grouping = ',';
    }
  else
    {
      cc->decimal = ',';
      cc->grouping = '.';
    }
  return true;
}

/* Extracts a token from IN into a newly allocated AFFIX.  Tokens
   are delimited by GROUPING.  The token is truncated to at most
   FMT_STYLE_AFFIX_MAX characters.  Returns the first character
   following the token. */
static const char *
extract_cc_token (const char *in, int grouping, struct substring *affix) 
{
  size_t ofs = 0;
  ss_alloc_uninit (affix, FMT_STYLE_AFFIX_MAX);
  for (; *in != '\0' && *in != grouping; in++) 
    {
      if (*in == '\'' && in[1] == grouping)
        in++;
      if (ofs < FMT_STYLE_AFFIX_MAX) 
        ss_data (*affix)[ofs++] = *in;
    }
  affix->length = ofs;

  if (*in == grouping)
    in++;
  return in;
}

/* Sets custom currency specifier CC having name CC_NAME ('A' through
   'E') to correspond to the settings in CC_STRING. */
static bool
do_cc (const char *cc_string, enum fmt_type type)
{
  struct fmt_number_style *cc = fmt_number_style_create ();
  
  /* Determine separators. */
  if (!find_cc_separators (cc_string, cc)) 
    {
      fmt_number_style_destroy (cc);
      msg (SE, _("%s: Custom currency string `%s' does not contain "
                 "exactly three periods or commas (or it contains both)."),
           fmt_name (type), cc_string);
      return false;
    }
  
  cc_string = extract_cc_token (cc_string, cc->grouping, &cc->neg_prefix);
  cc_string = extract_cc_token (cc_string, cc->grouping, &cc->prefix);
  cc_string = extract_cc_token (cc_string, cc->grouping, &cc->suffix);
  cc_string = extract_cc_token (cc_string, cc->grouping, &cc->neg_suffix);

  fmt_set_style (type, cc);
  
  return true;
}

/* Parses the BLANKS subcommand, which controls the value that
   completely blank fields in numeric data imply.  X, Wnd: Syntax is
   SYSMIS or a numeric value. */
static int
stc_custom_blanks (struct lexer *lexer, 
		   struct dataset *ds UNUSED, 
		   struct cmd_set *cmd UNUSED, void *aux UNUSED)
{
  lex_match (lexer, '=');
  if (lex_match_id (lexer, "SYSMIS"))
    {
      lex_get (lexer);
      set_blanks (SYSMIS);
    }
  else
    {
      if (!lex_force_num (lexer))
	return 0;
      set_blanks (lex_number (lexer));
      lex_get (lexer);
    }
  return 1;
}

/* Parses the EPOCH subcommand, which controls the epoch used for
   parsing 2-digit years. */
static int
stc_custom_epoch (struct lexer *lexer, 
		  struct dataset *ds UNUSED, 
		  struct cmd_set *cmd UNUSED, void *aux UNUSED) 
{
  lex_match (lexer, '=');
  if (lex_match_id (lexer, "AUTOMATIC"))
    set_epoch (-1);
  else if (lex_is_integer (lexer)) 
    {
      int new_epoch = lex_integer (lexer);
      lex_get (lexer);
      if (new_epoch < 1500) 
        {
          msg (SE, _("EPOCH must be 1500 or later."));
          return 0;
        }
      set_epoch (new_epoch);
    }
  else 
    {
      lex_error (lexer, _("expecting AUTOMATIC or year"));
      return 0;
    }

  return 1;
}

static int
stc_custom_length (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_set *cmd UNUSED, void *aux UNUSED)
{
  int page_length;

  lex_match (lexer, '=');
  if (lex_match_id (lexer, "NONE"))
    page_length = -1;
  else
    {
      if (!lex_force_int (lexer))
	return 0;
      if (lex_integer (lexer) < 1)
	{
	  msg (SE, _("LENGTH must be at least 1."));
	  return 0;
	}
      page_length = lex_integer (lexer);
      lex_get (lexer);
    }

  if (page_length != -1) 
    set_viewlength (page_length);

  return 1;
}

static int
stc_custom_seed (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_set *cmd UNUSED, void *aux UNUSED)
{
  lex_match (lexer, '=');
  if (lex_match_id (lexer, "RANDOM"))
    set_rng (time (0));
  else
    {
      if (!lex_force_num (lexer))
	return 0;
      set_rng (lex_number (lexer));
      lex_get (lexer);
    }

  return 1;
}

static int
stc_custom_width (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_set *cmd UNUSED, void *aux UNUSED)
{
  lex_match (lexer, '=');
  if (lex_match_id (lexer, "NARROW"))
    set_viewwidth (79);
  else if (lex_match_id (lexer, "WIDE"))
    set_viewwidth (131);
  else
    {
      if (!lex_force_int (lexer))
	return 0;
      if (lex_integer (lexer) < 40)
	{
	  msg (SE, _("WIDTH must be at least 40."));
	  return 0;
	}
      set_viewwidth (lex_integer (lexer));
      lex_get (lexer);
    }

  return 1;
}

/* Parses FORMAT subcommand, which consists of a numeric format
   specifier. */
static int
stc_custom_format (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_set *cmd UNUSED, void *aux UNUSED)
{
  struct fmt_spec fmt;

  lex_match (lexer, '=');
  if (!parse_format_specifier (lexer, &fmt))
    return 0;
  if (fmt_is_string (fmt.type))
    {
      char str[FMT_STRING_LEN_MAX + 1];
      msg (SE, _("FORMAT requires numeric output format as an argument.  "
		 "Specified format %s is of type string."),
	   fmt_to_string (&fmt, str));
      return 0;
    }

  set_format (&fmt);
  return 1;
}

static int
stc_custom_journal (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_set *cmd UNUSED, void *aux UNUSED)
{
  lex_match (lexer, '=');
  if (!lex_match_id (lexer, "ON") && !lex_match_id (lexer, "OFF")) 
    {
      if (lex_token (lexer) == T_STRING)
        lex_get (lexer);
      else
        {
          lex_error (lexer, NULL);
          return 0;
        }
    }
  return 1;
}

static int
stc_custom_listing (struct lexer *lexer, struct dataset *ds UNUSED, struct cmd_set *cmd UNUSED, void *aux UNUSED)
{
  bool listing;

  lex_match (lexer, '=');
  if (lex_match_id (lexer, "ON") || lex_match_id (lexer, "YES"))
    listing = true;
  else if (lex_match_id (lexer, "OFF") || lex_match_id (lexer, "NO"))
    listing = false;
  else
    {
      /* FIXME */
      return 0;
    }
  outp_enable_device (listing, OUTP_DEV_LISTING);

  return 1;
}

static int
stc_custom_disk (struct lexer *lexer, struct dataset *ds, struct cmd_set *cmd UNUSED, void *aux)
{
  return stc_custom_listing (lexer, ds, cmd, aux);
}

static void
show_blanks (const struct dataset *ds UNUSED) 
{
  if (get_blanks () == SYSMIS)
    msg (SN, _("BLANKS is SYSMIS."));
  else
    msg (SN, _("BLANKS is %g."), get_blanks ());

}

static char *
format_cc (struct substring in, char grouping, char *out) 
{
  while (!ss_is_empty (in)) 
    {
      char c = ss_get_char (&in);
      if (c == grouping || c == '\'')
        *out++ = '\'';
      else if (c == '"')
        *out++ = '"';
      *out++ = c;
    }
  return out;
}

static void
show_cc (enum fmt_type type) 
{
  const struct fmt_number_style *cc = fmt_get_style (type);
  char cc_string[FMT_STYLE_AFFIX_MAX * 4 * 2 + 3 + 1];
  char *out;

  out = format_cc (cc->neg_prefix, cc->grouping, cc_string);
  *out++ = cc->grouping;
  out = format_cc (cc->prefix, cc->grouping, out);
  *out++ = cc->grouping;
  out = format_cc (cc->suffix, cc->grouping, out);
  *out++ = cc->grouping;
  out = format_cc (cc->neg_suffix, cc->grouping, out);
  *out = '\0';
  
  msg (SN, _("%s is \"%s\"."), fmt_name (type), cc_string);
}

static void
show_cca (const struct dataset *ds UNUSED) 
{
  show_cc (FMT_CCA);
}

static void
show_ccb (const struct dataset *ds UNUSED) 
{
  show_cc (FMT_CCB);
}

static void
show_ccc (const struct dataset *ds UNUSED) 
{
  show_cc (FMT_CCC);
}

static void
show_ccd (const struct dataset *ds UNUSED) 
{
  show_cc (FMT_CCD);
}

static void
show_cce (const struct dataset *ds UNUSED) 
{
  show_cc (FMT_CCE);
}

static void
show_decimals (const struct dataset *ds UNUSED) 
{
  msg (SN, _("DECIMAL is \"%c\"."), fmt_decimal_char (FMT_F));
}

static void
show_endcmd (const struct dataset *ds UNUSED) 
{
  msg (SN, _("ENDCMD is \"%c\"."), get_endcmd ());
}

static void
show_errors (const struct dataset *ds UNUSED) 
{
  bool terminal = get_error_routing_to_terminal ();
  bool listing = get_error_routing_to_listing ();
  msg (SN, _("ERRORS is \"%s\"."),
       terminal && listing ? "BOTH"
       : terminal ? "TERMINAL"
       : listing ? "LISTING"
       : "NONE");
}

static void
show_format (const struct dataset *ds UNUSED) 
{
  char str[FMT_STRING_LEN_MAX + 1];
  msg (SN, _("FORMAT is %s."), fmt_to_string (get_format (), str));
}

static void
show_length (const struct dataset *ds UNUSED) 
{
  msg (SN, _("LENGTH is %d."), get_viewlength ());
}

static void
show_mxerrs (const struct dataset *ds UNUSED) 
{
  msg (SN, _("MXERRS is %d."), get_mxerrs ());
}

static void
show_mxloops (const struct dataset *ds UNUSED) 
{
  msg (SN, _("MXLOOPS is %d."), get_mxloops ());
}

static void
show_mxwarns (const struct dataset *ds UNUSED) 
{
  msg (SN, _("MXWARNS is %d."), get_mxwarns ());
}

/* Outputs that SETTING has the given INTEGER_FORMAT value. */
static void
show_integer_format (const char *setting, enum integer_format integer_format) 
{
  msg (SN, _("%s is %s (%s)."),
       setting,
       (integer_format == INTEGER_MSB_FIRST ? "MSBFIRST"
        : integer_format == INTEGER_LSB_FIRST ? "LSBFIRST"
        : "VAX"),
       integer_format == INTEGER_NATIVE ? "NATIVE" : "nonnative");
}

/* Outputs that SETTING has the given FLOAT_FORMAT value. */
static void
show_float_format (const char *setting, enum float_format float_format) 
{
  const char *format_name = "";
  
  switch (float_format)
    {
    case FLOAT_IEEE_SINGLE_LE:
      format_name = "ISL (32-bit IEEE 754 single, little-endian)";
      break;
    case FLOAT_IEEE_SINGLE_BE:
      format_name = "ISB (32-bit IEEE 754 single, big-endian)";
      break;
    case FLOAT_IEEE_DOUBLE_LE:
      format_name = "IDL (64-bit IEEE 754 double, little-endian)";
      break;
    case FLOAT_IEEE_DOUBLE_BE:
      format_name = "IDB (64-bit IEEE 754 double, big-endian)";
      break;

    case FLOAT_VAX_F:
      format_name = "VF (32-bit VAX F, VAX-endian)";
      break;
    case FLOAT_VAX_D:
      format_name = "VD (64-bit VAX D, VAX-endian)";
      break;
    case FLOAT_VAX_G:
      format_name = "VG (64-bit VAX G, VAX-endian)";
      break;

    case FLOAT_Z_SHORT:
      format_name = "ZS (32-bit IBM Z hexadecimal short, big-endian)";
      break;
    case FLOAT_Z_LONG:
      format_name = "ZL (64-bit IBM Z hexadecimal long, big-endian)";
      break;

    case FLOAT_FP:
    case FLOAT_HEX:
      NOT_REACHED ();
    }

  msg (SN, _("%s is %s (%s)."),
       setting, format_name,
       float_format == FLOAT_NATIVE_DOUBLE ? "NATIVE" : "nonnative");
}

static void
show_rib (const struct dataset *ds UNUSED) 
{
  show_integer_format ("RIB", data_in_get_integer_format ());
}

static void
show_rrb (const struct dataset *ds UNUSED) 
{
  show_float_format ("RRB", data_in_get_float_format ());
}

static void
show_scompression (const struct dataset *ds UNUSED) 
{
  if (get_scompression ())
    msg (SN, _("SCOMPRESSION is ON."));
  else
    msg (SN, _("SCOMPRESSION is OFF."));
}

static void
show_undefined (const struct dataset *ds UNUSED) 
{
  if (get_undefined ())
    msg (SN, _("UNDEFINED is WARN."));
  else
    msg (SN, _("UNDEFINED is NOWARN."));
}

static void
show_weight (const struct dataset *ds) 
{
  struct variable *var = dict_get_weight (dataset_dict (ds));
  if (var == NULL)
    msg (SN, _("WEIGHT is off."));
  else
    msg (SN, _("WEIGHT is variable %s."), var_get_name (var));
}

static void
show_wib (const struct dataset *ds UNUSED) 
{
  show_integer_format ("WIB", data_out_get_integer_format ());
}

static void
show_wrb (const struct dataset *ds UNUSED) 
{
  show_float_format ("WRB", data_out_get_float_format ());
}

static void
show_width (const struct dataset *ds UNUSED) 
{
  msg (SN, _("WIDTH is %d."), get_viewwidth ());
}

struct show_sbc 
  {
    const char *name;
    void (*function) (const struct dataset *);
  };

const struct show_sbc show_table[] = 
  {
    {"BLANKS", show_blanks},
    {"CCA", show_cca},
    {"CCB", show_ccb},
    {"CCC", show_ccc},
    {"CCD", show_ccd},
    {"CCE", show_cce},
    {"DECIMALS", show_decimals},
    {"ENDCMD", show_endcmd},
    {"ERRORS", show_errors},      
    {"FORMAT", show_format},
    {"LENGTH", show_length},
    {"MXERRS", show_mxerrs},
    {"MXLOOPS", show_mxloops},
    {"MXWARNS", show_mxwarns},
    {"RIB", show_rib},
    {"RRB", show_rrb},
    {"SCOMPRESSION", show_scompression},
    {"UNDEFINED", show_undefined},
    {"WEIGHT", show_weight},
    {"WIB", show_wib},
    {"WRB", show_wrb},
    {"WIDTH", show_width},
  };

static void
show_all (const struct dataset *ds) 
{
  size_t i;
  
  for (i = 0; i < sizeof show_table / sizeof *show_table; i++)
    show_table[i].function (ds);
}

static void
show_all_cc (void) 
{
  int i;

  for (i = 0; i < 5; i++)
    show_cc (i);
}

static void
show_warranty (const struct dataset *ds UNUSED) 
{
  msg (MN, lack_of_warranty);
}

static void
show_copying (const struct dataset *ds UNUSED) 
{
  msg (MN, copyleft);
}

int
cmd_show (struct lexer *lexer, struct dataset *ds) 
{
  if (lex_token (lexer) == '.') 
    {
      show_all (ds);
      return CMD_SUCCESS;
    }

  do 
    {
      if (lex_match (lexer, T_ALL))
        show_all (ds);
      else if (lex_match_id (lexer, "CC")) 
        show_all_cc ();
      else if (lex_match_id (lexer, "WARRANTY"))
        show_warranty (ds);
      else if (lex_match_id (lexer, "COPYING"))
        show_copying (ds);
      else if (lex_token (lexer) == T_ID)
        {
          int i;

          for (i = 0; i < sizeof show_table / sizeof *show_table; i++)
            if (lex_match_id (lexer, show_table[i].name)) 
              {
                show_table[i].function (ds);
                goto found;
              }
          lex_error (lexer, NULL);
          return CMD_FAILURE;

        found: ;
        }
      else 
        {
          lex_error (lexer, NULL);
          return CMD_FAILURE;
        }

      lex_match (lexer, '/');
    }
  while (lex_token (lexer) != '.');

  return CMD_SUCCESS;
}

/*
   Local Variables:
   mode: c
   End:
*/
