/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_product_image.c
 * @brief Implementation of the lookup_product_image_by_hash function for Postgres
 * @author Bohdan Potuzhnyi
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_pq_lib.h>
#include "pg_lookup_product_image.h"


enum GNUNET_DB_QueryStatus
TMH_PG_lookup_product_image_by_hash (void *cls,
                                     const char *instance_id,
                                     const char *image_hash,
                                     char **image)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (instance_id),
    GNUNET_PQ_query_param_string (image_hash),
    GNUNET_PQ_query_param_end
  };

  check_connection (pg);
  PREPARE (
    pg,
    "lookup_product_image_by_hash",
    "SELECT"
    "  mi.image"
    " FROM merchant_inventory mi"
    " JOIN merchant_instances inst"
    "   USING (merchant_serial)"
    " WHERE inst.merchant_id=$1"
    "   AND mi.image_hash=$2");

  *image = NULL;
  {
    struct GNUNET_PQ_ResultSpec rs[] = {
      GNUNET_PQ_result_spec_string ("image",
                                    image),
      GNUNET_PQ_result_spec_end
    };

    return GNUNET_PQ_eval_prepared_singleton_select (
      pg->conn,
      "lookup_product_image_by_hash",
      params,
      rs);
  }
}