--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

-- @file merchant-0020.sql
-- @brief Add token descriptions
-- @author Martin Schanzenbach


BEGIN;

-- Check patch versioning is in place.
SELECT _v.register_patch('merchant-0020', NULL, NULL);

SET search_path TO merchant;

-- delete existing login tokens as we don't have a description, this
-- logs out all users but should be safe as a migration.
DELETE FROM merchant_login_tokens;
ALTER TABLE merchant_login_tokens
  ADD description TEXT NOT NULL;

COMMENT ON COLUMN merchant_login_tokens.description
  IS 'Description of the login token';

ALTER TABLE merchant_login_tokens
ADD COLUMN serial BIGINT PRIMARY KEY GENERATED ALWAYS AS IDENTITY;

COMMIT;
