# GNU inetutils - The GNU Networking Utilities

GNU Networking Utilities (Inetutils) are the traditional network
clients, servers and utilities.  Included are ftp, hostname, ifconfig,
inetd, logger, ping, rsh, rlogin, talk, telnet, tftp, syslogd,
traceroute, whois, and dnsdomainname.

Send bug reports to <bug-inetutils@gnu.org>.

# Licensing

GNU Inetutils is licensed under the GNU General Public License version
3.0 or later - see the file [COPYING](COPYING).

The manual (see doc/) is under the GNU Free Documentation License
version 1.3 or later, see [doc/fdl-1.3.texi](doc/fdl-1.3.texi).

Other files are licensed as indicated in each file.  There may be
exceptions to these general rules, see each file for precise
information.

For any copyright year range specified as YYYY-ZZZZ in this package
note that the range specifies every single year in that closed
interval.

# Building

See the file INSTALL for generic installation instructions.

The file `paths` contains a list of all paths used by programs in this
distribution, and rules to find values for them.  To change a path
PATH_FOO, you may either tell configure, by using
`--with-path-foo=VALUE` (where VALUE may contain references to make
variables such as `$(bindir)`), or edit the `paths` file.  See further
below for some important cases.

If you wish to build only the clients or only the servers, you may
wish to use the `--disable-servers` or `--disable-clients` options
when invoking `configure`.  You can also use `--enable-<program>` or
`--disable-<program>` to control whether to build individual programs;
if you explicitly specify whether to build a program, that will
override the values specified by `--disable-clients` or
`--disable-servers`.

# History

The individual utilities were originally derived from the 4.4BSDLite2
distribution.  Many features were integrated from NetBSD, OpenBSD,
FreeBSD and GNU/Linux.

# Join GNU

If you are the author of an awesome program and want to join us in
writing Free (libre) Software, please consider making it an official
GNU program and become a GNU Maintainer.  You can find instructions on
how to do this here: http://www.gnu.org/help/evaluation

# Testing

Some words on testing are in order.  The three tests `ftp-localhost`,
`ping`, and `traceroute`, all need to be run by root.  Several tests
will depend on infrastructure files in `/etc/`, but most tests will
complain about their obvious needs.  Anyway, these dependencies are
important whenever chrooted builds are conducted.

At the time of running a test, the shell variables TEST_IPV4 and
TEST_IPV6 are influential.  Regard them as taking one of three values:
`yes`, `no`, or `auto`.  When assigned the value `auto`, a small check
at runtime will determine if the corresponding address family is available,
and accordingly include it during test.  The values `yes`, and `no`,
include or exclude the corresponding address family unconditionally.

During configuration time, TEST_IPV# is essentially set to `auto`,
except that `-enable-ipv#` assigns `yes`, and `--disable-ipv#` assigns
`no` unconditionally.  Note however, that `--disable-ipv6` retains
its property of removing all support for IPv6 in every executable,
while `--disable-ipv4` only affects the testing target `check` and scripts.

During chrooted tests, the runtime check for either family can be
fooled, so setting `TEST_IPV6=yes` might be necessary.  On the other
hand, chrooting similar to a FreeBSD jail, normally changes the address
of `localhost`, so similar environments will need counteractions like
`TARGET=10.0.6.1`.

# Whois

The GNU whois client reads a whois-servers file to figure out which
whois server to use.  It won't always pick the best server;
whois.internic.net seems to know something about nic.ddn.mil, but the
GNU whois client will use nic.ddn.mil to look up nic.ddn.mil if you
use the configuration file we supply.  Our configuration file probably
also does not have a complete list of whois servers; feel free to send
information about additional whois servers to the bug reporting
address.

# Notes on setuid-executables:

 - All of the r* client commands, `rcp`, `rlogin`, `rsh`, used to need
   to be installed as setuid root to work correctly, since they use
   privileged ports for communication.  However, some modern operating
   systems now offer capabilities that avoid the need for setuid
   settings, and this is accounted for in our present code.
   CAP_NET_BIND_SERVICE and PRIV_NET_PRIVADDR are relevant for the
   above three programs.

 - Similarly, `ping`, `ping6`, and `traceroute`, used to depend on
   setuid installation, but also these are now content with
   capabilities like CAP_NET_RAW, PRIV_NET_ICMPACCESS, and
   PRIV_NET_RAWACCESS.

# Notes on hard-coded file locations

 - Some of the buildable executables depend critically on hard-coded
   file locations for correct execution.  The most important, where
   care is needed, are highlighted below.

 - `ftpd` needs access to several configuration files, in order that
   all use cases be covered.  Both of PATH_FTPCHROOT and
   PATH_FTPWELCOME are normally positioned correctly in sysconfdir by
   default, whereas PATH_FTPUSERS usually is desired to state
   `/etc/ftpusers`, but not all systems manage this.  Particular care
   should be given to PATH_FTPLOGINMESG, since it defaults to
   `/etc/motd`, which cannot be claimed as universally ideal.  A
   sensible counter measure could be

     `./configure --with-path-ftploginmesg=$(sysconfdir)/ftpmotd`

   This would, however, complicate matter for chrooted users, so a
   minor variation on the default could be preferable:

     `./configure --with-path-ftploginmesg=/etc/ftpmotd`

   Finally, the fall-back value `/etc/nologin` for PATH_NOLOGIN is in
   effect for every systems lacking <paths.h>, but this sets the most
   plausible location in any case.

 - `rcp` relies on PATH_RSH for proper hand-over.  Use the
   configuration switch `--with-path-rsh=VALUE` for overriding the
   detected value.  It should point to the intended location of `rsh`,
   particularly when built with Kerberos support.

 - Similarly, `rsh` needs PATH_RLOGIN to locate `rlogin` for correct
   delegation.  The switch `--with-path-rlogin=VALUE` may come handy
   to ensure that `rsh` as well as `rlogin` offer identical Kerberos
   support.

# Some known deficiencies:

 - Non-Shishi Kerberos support does not build.  Patches welcome.

 - Shishi Kerberos support is only implemented for `rcp`, `rlogin`,
   `rlogind`, `rsh`, `rshd`, `telnet`, and `telnetd`.

 - Not all utilities are Kerberized even when built with Kerberos
   libraries, including `rcp` for non-Shishi Kerberos.

 - InetUtils does not build on HP-UX 11.00, Cygwin, Minix, MinGW,
   MSCV, BeOS, Haiki (and probably other systems as well).  Patches
   welcome.

========================================================================

Copyright (C) 1997-2025 Free Software Foundation, Inc.

Copying and distribution of this file, with or without modification,
are permitted in any medium without royalty provided the copyright
notice and this notice are preserved.  This file is offered as-is,
without any warranty.
