# DESCRIPTION: Perl ExtUtils: Type 'perl Makefile.PL' to create a Makefile for this package
#
# Copyright 2001-2013 by Wilson Snyder.  This program is free software; you
# can redistribute it and/or modify it under the terms of either the GNU
# Lesser General Public License Version 3 or the Perl Artistic License
# Version 2.0.

use ExtUtils::MakeMaker;
use Config;

sub MY::postamble {
    my $out;
    # MakeMaker wants to create bundles on MacOSX rather than dylibs. We override DLEXT and LDDLFLAGS generated by MakeMaker in this case
    if ($Config{osname} =~ /darwin/i || $Config{archname} =~ /darwin/i) {
    $out .= "DLEXT = dylib\n";
    $out .= sprintf("LDDLFLAGS = -dynamiclib -lstdc++ -L/System/Library/Perl/%vd/%s/CORE -lperl -lgcc_eh -L/usr/local/lib\n",$^V,$Config{archname});
    }
    $out .= "CCFLAGS  += -Wall -Wno-unused -Werror\n" if $ENV{VERILATOR_AUTHOR_SITE};
    $out .= '
CC = $(OBJCACHE) gcc
LEX = flex
YACC = bison
CFLAGS += -Wall
YACCFIX = ./yaccfix

#CFLAGS += -DFLEX_DEBUG
#LEXFLAGS += -d -L

sclex_prefix.c: sclex.l  scgrammer.h scparse.h
	${LEX} ${LEXFLAGS} -Psclex -o$@ $<

sclex.c: sclex_prefix.c
        # GCC 4.1.0 warn_unused_result
	cat $< \
	| sed "s/(void) *fwrite(\(.*\))/if (fwrite(\1)) {}/g" \
	| sed "s/static \(int y*y*input\)/\1/g" > $@

scgrammer.h:	scgrammer.c

scgrammer.c:	scgrammer.y scparse.h
	${YACC} ${YFLAGS} --debug --verbose -d -k $< -pscgrammer -o scgrammer.c
	$(PERL) $(YACCFIX) < scgrammer.c > scgrammer_pretmp.c
	mv scgrammer_pretmp.c scgrammer.c

clean::
	-$(RM_RF) test *.o sclex*.c scgrammer.h scgrammer.c *.output *_pretmp.*
';
    return $out;
}

WriteMakefile(
              NAME => "SystemC::Parser",
	      VERSION_FROM  => 'Parser.pm',
	      MYEXTLIB => 'sclex.o scgrammer.o',
	      INC => (" -I."),
	      );
