## Enumerations

# == /usr/include/libxml2/libxml/entities.h ==

enum xmlEntityType is export (
   XML_INTERNAL_GENERAL_ENTITY => 1,
   XML_EXTERNAL_GENERAL_PARSED_ENTITY => 2,
   XML_EXTERNAL_GENERAL_UNPARSED_ENTITY => 3,
   XML_INTERNAL_PARAMETER_ENTITY => 4,
   XML_EXTERNAL_PARAMETER_ENTITY => 5,
   XML_INTERNAL_PREDEFINED_ENTITY => 6
);

# == /usr/include/libxml2/libxml/xmlerror.h ==

enum xmlErrorLevel is export (
   XML_ERR_NONE => 0,
   XML_ERR_WARNING => 1,
   XML_ERR_ERROR => 2,
   XML_ERR_FATAL => 3
);
enum xmlErrorDomain is export (
   XML_FROM_NONE => 0,
   XML_FROM_PARSER => 1,
   XML_FROM_TREE => 2,
   XML_FROM_NAMESPACE => 3,
   XML_FROM_DTD => 4,
   XML_FROM_HTML => 5,
   XML_FROM_MEMORY => 6,
   XML_FROM_OUTPUT => 7,
   XML_FROM_IO => 8,
   XML_FROM_FTP => 9,
   XML_FROM_HTTP => 10,
   XML_FROM_XINCLUDE => 11,
   XML_FROM_XPATH => 12,
   XML_FROM_XPOINTER => 13,
   XML_FROM_REGEXP => 14,
   XML_FROM_DATATYPE => 15,
   XML_FROM_SCHEMASP => 16,
   XML_FROM_SCHEMASV => 17,
   XML_FROM_RELAXNGP => 18,
   XML_FROM_RELAXNGV => 19,
   XML_FROM_CATALOG => 20,
   XML_FROM_C14N => 21,
   XML_FROM_XSLT => 22,
   XML_FROM_VALID => 23,
   XML_FROM_CHECK => 24,
   XML_FROM_WRITER => 25,
   XML_FROM_MODULE => 26,
   XML_FROM_I18N => 27,
   XML_FROM_SCHEMATRONV => 28,
   XML_FROM_BUFFER => 29,
   XML_FROM_URI => 30
);
enum xmlParserErrors is export (
   XML_ERR_OK => 0,
   XML_ERR_INTERNAL_ERROR => 1,
   XML_ERR_NO_MEMORY => 2,
   XML_ERR_DOCUMENT_START => 3,
   XML_ERR_DOCUMENT_EMPTY => 4,
   XML_ERR_DOCUMENT_END => 5,
   XML_ERR_INVALID_HEX_CHARREF => 6,
   XML_ERR_INVALID_DEC_CHARREF => 7,
   XML_ERR_INVALID_CHARREF => 8,
   XML_ERR_INVALID_CHAR => 9,
   XML_ERR_CHARREF_AT_EOF => 10,
   XML_ERR_CHARREF_IN_PROLOG => 11,
   XML_ERR_CHARREF_IN_EPILOG => 12,
   XML_ERR_CHARREF_IN_DTD => 13,
   XML_ERR_ENTITYREF_AT_EOF => 14,
   XML_ERR_ENTITYREF_IN_PROLOG => 15,
   XML_ERR_ENTITYREF_IN_EPILOG => 16,
   XML_ERR_ENTITYREF_IN_DTD => 17,
   XML_ERR_PEREF_AT_EOF => 18,
   XML_ERR_PEREF_IN_PROLOG => 19,
   XML_ERR_PEREF_IN_EPILOG => 20,
   XML_ERR_PEREF_IN_INT_SUBSET => 21,
   XML_ERR_ENTITYREF_NO_NAME => 22,
   XML_ERR_ENTITYREF_SEMICOL_MISSING => 23,
   XML_ERR_PEREF_NO_NAME => 24,
   XML_ERR_PEREF_SEMICOL_MISSING => 25,
   XML_ERR_UNDECLARED_ENTITY => 26,
   XML_WAR_UNDECLARED_ENTITY => 27,
   XML_ERR_UNPARSED_ENTITY => 28,
   XML_ERR_ENTITY_IS_EXTERNAL => 29,
   XML_ERR_ENTITY_IS_PARAMETER => 30,
   XML_ERR_UNKNOWN_ENCODING => 31,
   XML_ERR_UNSUPPORTED_ENCODING => 32,
   XML_ERR_STRING_NOT_STARTED => 33,
   XML_ERR_STRING_NOT_CLOSED => 34,
   XML_ERR_NS_DECL_ERROR => 35,
   XML_ERR_ENTITY_NOT_STARTED => 36,
   XML_ERR_ENTITY_NOT_FINISHED => 37,
   XML_ERR_LT_IN_ATTRIBUTE => 38,
   XML_ERR_ATTRIBUTE_NOT_STARTED => 39,
   XML_ERR_ATTRIBUTE_NOT_FINISHED => 40,
   XML_ERR_ATTRIBUTE_WITHOUT_VALUE => 41,
   XML_ERR_ATTRIBUTE_REDEFINED => 42,
   XML_ERR_LITERAL_NOT_STARTED => 43,
   XML_ERR_LITERAL_NOT_FINISHED => 44,
   XML_ERR_COMMENT_NOT_FINISHED => 45,
   XML_ERR_PI_NOT_STARTED => 46,
   XML_ERR_PI_NOT_FINISHED => 47,
   XML_ERR_NOTATION_NOT_STARTED => 48,
   XML_ERR_NOTATION_NOT_FINISHED => 49,
   XML_ERR_ATTLIST_NOT_STARTED => 50,
   XML_ERR_ATTLIST_NOT_FINISHED => 51,
   XML_ERR_MIXED_NOT_STARTED => 52,
   XML_ERR_MIXED_NOT_FINISHED => 53,
   XML_ERR_ELEMCONTENT_NOT_STARTED => 54,
   XML_ERR_ELEMCONTENT_NOT_FINISHED => 55,
   XML_ERR_XMLDECL_NOT_STARTED => 56,
   XML_ERR_XMLDECL_NOT_FINISHED => 57,
   XML_ERR_CONDSEC_NOT_STARTED => 58,
   XML_ERR_CONDSEC_NOT_FINISHED => 59,
   XML_ERR_EXT_SUBSET_NOT_FINISHED => 60,
   XML_ERR_DOCTYPE_NOT_FINISHED => 61,
   XML_ERR_MISPLACED_CDATA_END => 62,
   XML_ERR_CDATA_NOT_FINISHED => 63,
   XML_ERR_RESERVED_XML_NAME => 64,
   XML_ERR_SPACE_REQUIRED => 65,
   XML_ERR_SEPARATOR_REQUIRED => 66,
   XML_ERR_NMTOKEN_REQUIRED => 67,
   XML_ERR_NAME_REQUIRED => 68,
   XML_ERR_PCDATA_REQUIRED => 69,
   XML_ERR_URI_REQUIRED => 70,
   XML_ERR_PUBID_REQUIRED => 71,
   XML_ERR_LT_REQUIRED => 72,
   XML_ERR_GT_REQUIRED => 73,
   XML_ERR_LTSLASH_REQUIRED => 74,
   XML_ERR_EQUAL_REQUIRED => 75,
   XML_ERR_TAG_NAME_MISMATCH => 76,
   XML_ERR_TAG_NOT_FINISHED => 77,
   XML_ERR_STANDALONE_VALUE => 78,
   XML_ERR_ENCODING_NAME => 79,
   XML_ERR_HYPHEN_IN_COMMENT => 80,
   XML_ERR_INVALID_ENCODING => 81,
   XML_ERR_EXT_ENTITY_STANDALONE => 82,
   XML_ERR_CONDSEC_INVALID => 83,
   XML_ERR_VALUE_REQUIRED => 84,
   XML_ERR_NOT_WELL_BALANCED => 85,
   XML_ERR_EXTRA_CONTENT => 86,
   XML_ERR_ENTITY_CHAR_ERROR => 87,
   XML_ERR_ENTITY_PE_INTERNAL => 88,
   XML_ERR_ENTITY_LOOP => 89,
   XML_ERR_ENTITY_BOUNDARY => 90,
   XML_ERR_INVALID_URI => 91,
   XML_ERR_URI_FRAGMENT => 92,
   XML_WAR_CATALOG_PI => 93,
   XML_ERR_NO_DTD => 94,
   XML_ERR_CONDSEC_INVALID_KEYWORD => 95,
   XML_ERR_VERSION_MISSING => 96,
   XML_WAR_UNKNOWN_VERSION => 97,
   XML_WAR_LANG_VALUE => 98,
   XML_WAR_NS_URI => 99,
   XML_WAR_NS_URI_RELATIVE => 100,
   XML_ERR_MISSING_ENCODING => 101,
   XML_WAR_SPACE_VALUE => 102,
   XML_ERR_NOT_STANDALONE => 103,
   XML_ERR_ENTITY_PROCESSING => 104,
   XML_ERR_NOTATION_PROCESSING => 105,
   XML_WAR_NS_COLUMN => 106,
   XML_WAR_ENTITY_REDEFINED => 107,
   XML_ERR_UNKNOWN_VERSION => 108,
   XML_ERR_VERSION_MISMATCH => 109,
   XML_ERR_NAME_TOO_LONG => 110,
   XML_ERR_USER_STOP => 111,
   XML_NS_ERR_XML_NAMESPACE => 200,
   XML_NS_ERR_UNDEFINED_NAMESPACE => 201,
   XML_NS_ERR_QNAME => 202,
   XML_NS_ERR_ATTRIBUTE_REDEFINED => 203,
   XML_NS_ERR_EMPTY => 204,
   XML_NS_ERR_COLON => 205,
   XML_DTD_ATTRIBUTE_DEFAULT => 500,
   XML_DTD_ATTRIBUTE_REDEFINED => 501,
   XML_DTD_ATTRIBUTE_VALUE => 502,
   XML_DTD_CONTENT_ERROR => 503,
   XML_DTD_CONTENT_MODEL => 504,
   XML_DTD_CONTENT_NOT_DETERMINIST => 505,
   XML_DTD_DIFFERENT_PREFIX => 506,
   XML_DTD_ELEM_DEFAULT_NAMESPACE => 507,
   XML_DTD_ELEM_NAMESPACE => 508,
   XML_DTD_ELEM_REDEFINED => 509,
   XML_DTD_EMPTY_NOTATION => 510,
   XML_DTD_ENTITY_TYPE => 511,
   XML_DTD_ID_FIXED => 512,
   XML_DTD_ID_REDEFINED => 513,
   XML_DTD_ID_SUBSET => 514,
   XML_DTD_INVALID_CHILD => 515,
   XML_DTD_INVALID_DEFAULT => 516,
   XML_DTD_LOAD_ERROR => 517,
   XML_DTD_MISSING_ATTRIBUTE => 518,
   XML_DTD_MIXED_CORRUPT => 519,
   XML_DTD_MULTIPLE_ID => 520,
   XML_DTD_NO_DOC => 521,
   XML_DTD_NO_DTD => 522,
   XML_DTD_NO_ELEM_NAME => 523,
   XML_DTD_NO_PREFIX => 524,
   XML_DTD_NO_ROOT => 525,
   XML_DTD_NOTATION_REDEFINED => 526,
   XML_DTD_NOTATION_VALUE => 527,
   XML_DTD_NOT_EMPTY => 528,
   XML_DTD_NOT_PCDATA => 529,
   XML_DTD_NOT_STANDALONE => 530,
   XML_DTD_ROOT_NAME => 531,
   XML_DTD_STANDALONE_WHITE_SPACE => 532,
   XML_DTD_UNKNOWN_ATTRIBUTE => 533,
   XML_DTD_UNKNOWN_ELEM => 534,
   XML_DTD_UNKNOWN_ENTITY => 535,
   XML_DTD_UNKNOWN_ID => 536,
   XML_DTD_UNKNOWN_NOTATION => 537,
   XML_DTD_STANDALONE_DEFAULTED => 538,
   XML_DTD_XMLID_VALUE => 539,
   XML_DTD_XMLID_TYPE => 540,
   XML_DTD_DUP_TOKEN => 541,
   XML_HTML_STRUCURE_ERROR => 800,
   XML_HTML_UNKNOWN_TAG => 801,
   XML_RNGP_ANYNAME_ATTR_ANCESTOR => 1000,
   XML_RNGP_ATTR_CONFLICT => 1001,
   XML_RNGP_ATTRIBUTE_CHILDREN => 1002,
   XML_RNGP_ATTRIBUTE_CONTENT => 1003,
   XML_RNGP_ATTRIBUTE_EMPTY => 1004,
   XML_RNGP_ATTRIBUTE_NOOP => 1005,
   XML_RNGP_CHOICE_CONTENT => 1006,
   XML_RNGP_CHOICE_EMPTY => 1007,
   XML_RNGP_CREATE_FAILURE => 1008,
   XML_RNGP_DATA_CONTENT => 1009,
   XML_RNGP_DEF_CHOICE_AND_INTERLEAVE => 1010,
   XML_RNGP_DEFINE_CREATE_FAILED => 1011,
   XML_RNGP_DEFINE_EMPTY => 1012,
   XML_RNGP_DEFINE_MISSING => 1013,
   XML_RNGP_DEFINE_NAME_MISSING => 1014,
   XML_RNGP_ELEM_CONTENT_EMPTY => 1015,
   XML_RNGP_ELEM_CONTENT_ERROR => 1016,
   XML_RNGP_ELEMENT_EMPTY => 1017,
   XML_RNGP_ELEMENT_CONTENT => 1018,
   XML_RNGP_ELEMENT_NAME => 1019,
   XML_RNGP_ELEMENT_NO_CONTENT => 1020,
   XML_RNGP_ELEM_TEXT_CONFLICT => 1021,
   XML_RNGP_EMPTY => 1022,
   XML_RNGP_EMPTY_CONSTRUCT => 1023,
   XML_RNGP_EMPTY_CONTENT => 1024,
   XML_RNGP_EMPTY_NOT_EMPTY => 1025,
   XML_RNGP_ERROR_TYPE_LIB => 1026,
   XML_RNGP_EXCEPT_EMPTY => 1027,
   XML_RNGP_EXCEPT_MISSING => 1028,
   XML_RNGP_EXCEPT_MULTIPLE => 1029,
   XML_RNGP_EXCEPT_NO_CONTENT => 1030,
   XML_RNGP_EXTERNALREF_EMTPY => 1031,
   XML_RNGP_EXTERNAL_REF_FAILURE => 1032,
   XML_RNGP_EXTERNALREF_RECURSE => 1033,
   XML_RNGP_FORBIDDEN_ATTRIBUTE => 1034,
   XML_RNGP_FOREIGN_ELEMENT => 1035,
   XML_RNGP_GRAMMAR_CONTENT => 1036,
   XML_RNGP_GRAMMAR_EMPTY => 1037,
   XML_RNGP_GRAMMAR_MISSING => 1038,
   XML_RNGP_GRAMMAR_NO_START => 1039,
   XML_RNGP_GROUP_ATTR_CONFLICT => 1040,
   XML_RNGP_HREF_ERROR => 1041,
   XML_RNGP_INCLUDE_EMPTY => 1042,
   XML_RNGP_INCLUDE_FAILURE => 1043,
   XML_RNGP_INCLUDE_RECURSE => 1044,
   XML_RNGP_INTERLEAVE_ADD => 1045,
   XML_RNGP_INTERLEAVE_CREATE_FAILED => 1046,
   XML_RNGP_INTERLEAVE_EMPTY => 1047,
   XML_RNGP_INTERLEAVE_NO_CONTENT => 1048,
   XML_RNGP_INVALID_DEFINE_NAME => 1049,
   XML_RNGP_INVALID_URI => 1050,
   XML_RNGP_INVALID_VALUE => 1051,
   XML_RNGP_MISSING_HREF => 1052,
   XML_RNGP_NAME_MISSING => 1053,
   XML_RNGP_NEED_COMBINE => 1054,
   XML_RNGP_NOTALLOWED_NOT_EMPTY => 1055,
   XML_RNGP_NSNAME_ATTR_ANCESTOR => 1056,
   XML_RNGP_NSNAME_NO_NS => 1057,
   XML_RNGP_PARAM_FORBIDDEN => 1058,
   XML_RNGP_PARAM_NAME_MISSING => 1059,
   XML_RNGP_PARENTREF_CREATE_FAILED => 1060,
   XML_RNGP_PARENTREF_NAME_INVALID => 1061,
   XML_RNGP_PARENTREF_NO_NAME => 1062,
   XML_RNGP_PARENTREF_NO_PARENT => 1063,
   XML_RNGP_PARENTREF_NOT_EMPTY => 1064,
   XML_RNGP_PARSE_ERROR => 1065,
   XML_RNGP_PAT_ANYNAME_EXCEPT_ANYNAME => 1066,
   XML_RNGP_PAT_ATTR_ATTR => 1067,
   XML_RNGP_PAT_ATTR_ELEM => 1068,
   XML_RNGP_PAT_DATA_EXCEPT_ATTR => 1069,
   XML_RNGP_PAT_DATA_EXCEPT_ELEM => 1070,
   XML_RNGP_PAT_DATA_EXCEPT_EMPTY => 1071,
   XML_RNGP_PAT_DATA_EXCEPT_GROUP => 1072,
   XML_RNGP_PAT_DATA_EXCEPT_INTERLEAVE => 1073,
   XML_RNGP_PAT_DATA_EXCEPT_LIST => 1074,
   XML_RNGP_PAT_DATA_EXCEPT_ONEMORE => 1075,
   XML_RNGP_PAT_DATA_EXCEPT_REF => 1076,
   XML_RNGP_PAT_DATA_EXCEPT_TEXT => 1077,
   XML_RNGP_PAT_LIST_ATTR => 1078,
   XML_RNGP_PAT_LIST_ELEM => 1079,
   XML_RNGP_PAT_LIST_INTERLEAVE => 1080,
   XML_RNGP_PAT_LIST_LIST => 1081,
   XML_RNGP_PAT_LIST_REF => 1082,
   XML_RNGP_PAT_LIST_TEXT => 1083,
   XML_RNGP_PAT_NSNAME_EXCEPT_ANYNAME => 1084,
   XML_RNGP_PAT_NSNAME_EXCEPT_NSNAME => 1085,
   XML_RNGP_PAT_ONEMORE_GROUP_ATTR => 1086,
   XML_RNGP_PAT_ONEMORE_INTERLEAVE_ATTR => 1087,
   XML_RNGP_PAT_START_ATTR => 1088,
   XML_RNGP_PAT_START_DATA => 1089,
   XML_RNGP_PAT_START_EMPTY => 1090,
   XML_RNGP_PAT_START_GROUP => 1091,
   XML_RNGP_PAT_START_INTERLEAVE => 1092,
   XML_RNGP_PAT_START_LIST => 1093,
   XML_RNGP_PAT_START_ONEMORE => 1094,
   XML_RNGP_PAT_START_TEXT => 1095,
   XML_RNGP_PAT_START_VALUE => 1096,
   XML_RNGP_PREFIX_UNDEFINED => 1097,
   XML_RNGP_REF_CREATE_FAILED => 1098,
   XML_RNGP_REF_CYCLE => 1099,
   XML_RNGP_REF_NAME_INVALID => 1100,
   XML_RNGP_REF_NO_DEF => 1101,
   XML_RNGP_REF_NO_NAME => 1102,
   XML_RNGP_REF_NOT_EMPTY => 1103,
   XML_RNGP_START_CHOICE_AND_INTERLEAVE => 1104,
   XML_RNGP_START_CONTENT => 1105,
   XML_RNGP_START_EMPTY => 1106,
   XML_RNGP_START_MISSING => 1107,
   XML_RNGP_TEXT_EXPECTED => 1108,
   XML_RNGP_TEXT_HAS_CHILD => 1109,
   XML_RNGP_TYPE_MISSING => 1110,
   XML_RNGP_TYPE_NOT_FOUND => 1111,
   XML_RNGP_TYPE_VALUE => 1112,
   XML_RNGP_UNKNOWN_ATTRIBUTE => 1113,
   XML_RNGP_UNKNOWN_COMBINE => 1114,
   XML_RNGP_UNKNOWN_CONSTRUCT => 1115,
   XML_RNGP_UNKNOWN_TYPE_LIB => 1116,
   XML_RNGP_URI_FRAGMENT => 1117,
   XML_RNGP_URI_NOT_ABSOLUTE => 1118,
   XML_RNGP_VALUE_EMPTY => 1119,
   XML_RNGP_VALUE_NO_CONTENT => 1120,
   XML_RNGP_XMLNS_NAME => 1121,
   XML_RNGP_XML_NS => 1122,
   XML_XPATH_EXPRESSION_OK => 1200,
   XML_XPATH_NUMBER_ERROR => 1201,
   XML_XPATH_UNFINISHED_LITERAL_ERROR => 1202,
   XML_XPATH_START_LITERAL_ERROR => 1203,
   XML_XPATH_VARIABLE_REF_ERROR => 1204,
   XML_XPATH_UNDEF_VARIABLE_ERROR => 1205,
   XML_XPATH_INVALID_PREDICATE_ERROR => 1206,
   XML_XPATH_EXPR_ERROR => 1207,
   XML_XPATH_UNCLOSED_ERROR => 1208,
   XML_XPATH_UNKNOWN_FUNC_ERROR => 1209,
   XML_XPATH_INVALID_OPERAND => 1210,
   XML_XPATH_INVALID_TYPE => 1211,
   XML_XPATH_INVALID_ARITY => 1212,
   XML_XPATH_INVALID_CTXT_SIZE => 1213,
   XML_XPATH_INVALID_CTXT_POSITION => 1214,
   XML_XPATH_MEMORY_ERROR => 1215,
   XML_XPTR_SYNTAX_ERROR => 1216,
   XML_XPTR_RESOURCE_ERROR => 1217,
   XML_XPTR_SUB_RESOURCE_ERROR => 1218,
   XML_XPATH_UNDEF_PREFIX_ERROR => 1219,
   XML_XPATH_ENCODING_ERROR => 1220,
   XML_XPATH_INVALID_CHAR_ERROR => 1221,
   XML_TREE_INVALID_HEX => 1300,
   XML_TREE_INVALID_DEC => 1301,
   XML_TREE_UNTERMINATED_ENTITY => 1302,
   XML_TREE_NOT_UTF8 => 1303,
   XML_SAVE_NOT_UTF8 => 1400,
   XML_SAVE_CHAR_INVALID => 1401,
   XML_SAVE_NO_DOCTYPE => 1402,
   XML_SAVE_UNKNOWN_ENCODING => 1403,
   XML_REGEXP_COMPILE_ERROR => 1450,
   XML_IO_UNKNOWN => 1500,
   XML_IO_EACCES => 1501,
   XML_IO_EAGAIN => 1502,
   XML_IO_EBADF => 1503,
   XML_IO_EBADMSG => 1504,
   XML_IO_EBUSY => 1505,
   XML_IO_ECANCELED => 1506,
   XML_IO_ECHILD => 1507,
   XML_IO_EDEADLK => 1508,
   XML_IO_EDOM => 1509,
   XML_IO_EEXIST => 1510,
   XML_IO_EFAULT => 1511,
   XML_IO_EFBIG => 1512,
   XML_IO_EINPROGRESS => 1513,
   XML_IO_EINTR => 1514,
   XML_IO_EINVAL => 1515,
   XML_IO_EIO => 1516,
   XML_IO_EISDIR => 1517,
   XML_IO_EMFILE => 1518,
   XML_IO_EMLINK => 1519,
   XML_IO_EMSGSIZE => 1520,
   XML_IO_ENAMETOOLONG => 1521,
   XML_IO_ENFILE => 1522,
   XML_IO_ENODEV => 1523,
   XML_IO_ENOENT => 1524,
   XML_IO_ENOEXEC => 1525,
   XML_IO_ENOLCK => 1526,
   XML_IO_ENOMEM => 1527,
   XML_IO_ENOSPC => 1528,
   XML_IO_ENOSYS => 1529,
   XML_IO_ENOTDIR => 1530,
   XML_IO_ENOTEMPTY => 1531,
   XML_IO_ENOTSUP => 1532,
   XML_IO_ENOTTY => 1533,
   XML_IO_ENXIO => 1534,
   XML_IO_EPERM => 1535,
   XML_IO_EPIPE => 1536,
   XML_IO_ERANGE => 1537,
   XML_IO_EROFS => 1538,
   XML_IO_ESPIPE => 1539,
   XML_IO_ESRCH => 1540,
   XML_IO_ETIMEDOUT => 1541,
   XML_IO_EXDEV => 1542,
   XML_IO_NETWORK_ATTEMPT => 1543,
   XML_IO_ENCODER => 1544,
   XML_IO_FLUSH => 1545,
   XML_IO_WRITE => 1546,
   XML_IO_NO_INPUT => 1547,
   XML_IO_BUFFER_FULL => 1548,
   XML_IO_LOAD_ERROR => 1549,
   XML_IO_ENOTSOCK => 1550,
   XML_IO_EISCONN => 1551,
   XML_IO_ECONNREFUSED => 1552,
   XML_IO_ENETUNREACH => 1553,
   XML_IO_EADDRINUSE => 1554,
   XML_IO_EALREADY => 1555,
   XML_IO_EAFNOSUPPORT => 1556,
   XML_XINCLUDE_RECURSION => 1600,
   XML_XINCLUDE_PARSE_VALUE => 1601,
   XML_XINCLUDE_ENTITY_DEF_MISMATCH => 1602,
   XML_XINCLUDE_NO_HREF => 1603,
   XML_XINCLUDE_NO_FALLBACK => 1604,
   XML_XINCLUDE_HREF_URI => 1605,
   XML_XINCLUDE_TEXT_FRAGMENT => 1606,
   XML_XINCLUDE_TEXT_DOCUMENT => 1607,
   XML_XINCLUDE_INVALID_CHAR => 1608,
   XML_XINCLUDE_BUILD_FAILED => 1609,
   XML_XINCLUDE_UNKNOWN_ENCODING => 1610,
   XML_XINCLUDE_MULTIPLE_ROOT => 1611,
   XML_XINCLUDE_XPTR_FAILED => 1612,
   XML_XINCLUDE_XPTR_RESULT => 1613,
   XML_XINCLUDE_INCLUDE_IN_INCLUDE => 1614,
   XML_XINCLUDE_FALLBACKS_IN_INCLUDE => 1615,
   XML_XINCLUDE_FALLBACK_NOT_IN_INCLUDE => 1616,
   XML_XINCLUDE_DEPRECATED_NS => 1617,
   XML_XINCLUDE_FRAGMENT_ID => 1618,
   XML_CATALOG_MISSING_ATTR => 1650,
   XML_CATALOG_ENTRY_BROKEN => 1651,
   XML_CATALOG_PREFER_VALUE => 1652,
   XML_CATALOG_NOT_CATALOG => 1653,
   XML_CATALOG_RECURSION => 1654,
   XML_SCHEMAP_PREFIX_UNDEFINED => 1700,
   XML_SCHEMAP_ATTRFORMDEFAULT_VALUE => 1701,
   XML_SCHEMAP_ATTRGRP_NONAME_NOREF => 1702,
   XML_SCHEMAP_ATTR_NONAME_NOREF => 1703,
   XML_SCHEMAP_COMPLEXTYPE_NONAME_NOREF => 1704,
   XML_SCHEMAP_ELEMFORMDEFAULT_VALUE => 1705,
   XML_SCHEMAP_ELEM_NONAME_NOREF => 1706,
   XML_SCHEMAP_EXTENSION_NO_BASE => 1707,
   XML_SCHEMAP_FACET_NO_VALUE => 1708,
   XML_SCHEMAP_FAILED_BUILD_IMPORT => 1709,
   XML_SCHEMAP_GROUP_NONAME_NOREF => 1710,
   XML_SCHEMAP_IMPORT_NAMESPACE_NOT_URI => 1711,
   XML_SCHEMAP_IMPORT_REDEFINE_NSNAME => 1712,
   XML_SCHEMAP_IMPORT_SCHEMA_NOT_URI => 1713,
   XML_SCHEMAP_INVALID_BOOLEAN => 1714,
   XML_SCHEMAP_INVALID_ENUM => 1715,
   XML_SCHEMAP_INVALID_FACET => 1716,
   XML_SCHEMAP_INVALID_FACET_VALUE => 1717,
   XML_SCHEMAP_INVALID_MAXOCCURS => 1718,
   XML_SCHEMAP_INVALID_MINOCCURS => 1719,
   XML_SCHEMAP_INVALID_REF_AND_SUBTYPE => 1720,
   XML_SCHEMAP_INVALID_WHITE_SPACE => 1721,
   XML_SCHEMAP_NOATTR_NOREF => 1722,
   XML_SCHEMAP_NOTATION_NO_NAME => 1723,
   XML_SCHEMAP_NOTYPE_NOREF => 1724,
   XML_SCHEMAP_REF_AND_SUBTYPE => 1725,
   XML_SCHEMAP_RESTRICTION_NONAME_NOREF => 1726,
   XML_SCHEMAP_SIMPLETYPE_NONAME => 1727,
   XML_SCHEMAP_TYPE_AND_SUBTYPE => 1728,
   XML_SCHEMAP_UNKNOWN_ALL_CHILD => 1729,
   XML_SCHEMAP_UNKNOWN_ANYATTRIBUTE_CHILD => 1730,
   XML_SCHEMAP_UNKNOWN_ATTR_CHILD => 1731,
   XML_SCHEMAP_UNKNOWN_ATTRGRP_CHILD => 1732,
   XML_SCHEMAP_UNKNOWN_ATTRIBUTE_GROUP => 1733,
   XML_SCHEMAP_UNKNOWN_BASE_TYPE => 1734,
   XML_SCHEMAP_UNKNOWN_CHOICE_CHILD => 1735,
   XML_SCHEMAP_UNKNOWN_COMPLEXCONTENT_CHILD => 1736,
   XML_SCHEMAP_UNKNOWN_COMPLEXTYPE_CHILD => 1737,
   XML_SCHEMAP_UNKNOWN_ELEM_CHILD => 1738,
   XML_SCHEMAP_UNKNOWN_EXTENSION_CHILD => 1739,
   XML_SCHEMAP_UNKNOWN_FACET_CHILD => 1740,
   XML_SCHEMAP_UNKNOWN_FACET_TYPE => 1741,
   XML_SCHEMAP_UNKNOWN_GROUP_CHILD => 1742,
   XML_SCHEMAP_UNKNOWN_IMPORT_CHILD => 1743,
   XML_SCHEMAP_UNKNOWN_LIST_CHILD => 1744,
   XML_SCHEMAP_UNKNOWN_NOTATION_CHILD => 1745,
   XML_SCHEMAP_UNKNOWN_PROCESSCONTENT_CHILD => 1746,
   XML_SCHEMAP_UNKNOWN_REF => 1747,
   XML_SCHEMAP_UNKNOWN_RESTRICTION_CHILD => 1748,
   XML_SCHEMAP_UNKNOWN_SCHEMAS_CHILD => 1749,
   XML_SCHEMAP_UNKNOWN_SEQUENCE_CHILD => 1750,
   XML_SCHEMAP_UNKNOWN_SIMPLECONTENT_CHILD => 1751,
   XML_SCHEMAP_UNKNOWN_SIMPLETYPE_CHILD => 1752,
   XML_SCHEMAP_UNKNOWN_TYPE => 1753,
   XML_SCHEMAP_UNKNOWN_UNION_CHILD => 1754,
   XML_SCHEMAP_ELEM_DEFAULT_FIXED => 1755,
   XML_SCHEMAP_REGEXP_INVALID => 1756,
   XML_SCHEMAP_FAILED_LOAD => 1757,
   XML_SCHEMAP_NOTHING_TO_PARSE => 1758,
   XML_SCHEMAP_NOROOT => 1759,
   XML_SCHEMAP_REDEFINED_GROUP => 1760,
   XML_SCHEMAP_REDEFINED_TYPE => 1761,
   XML_SCHEMAP_REDEFINED_ELEMENT => 1762,
   XML_SCHEMAP_REDEFINED_ATTRGROUP => 1763,
   XML_SCHEMAP_REDEFINED_ATTR => 1764,
   XML_SCHEMAP_REDEFINED_NOTATION => 1765,
   XML_SCHEMAP_FAILED_PARSE => 1766,
   XML_SCHEMAP_UNKNOWN_PREFIX => 1767,
   XML_SCHEMAP_DEF_AND_PREFIX => 1768,
   XML_SCHEMAP_UNKNOWN_INCLUDE_CHILD => 1769,
   XML_SCHEMAP_INCLUDE_SCHEMA_NOT_URI => 1770,
   XML_SCHEMAP_INCLUDE_SCHEMA_NO_URI => 1771,
   XML_SCHEMAP_NOT_SCHEMA => 1772,
   XML_SCHEMAP_UNKNOWN_MEMBER_TYPE => 1773,
   XML_SCHEMAP_INVALID_ATTR_USE => 1774,
   XML_SCHEMAP_RECURSIVE => 1775,
   XML_SCHEMAP_SUPERNUMEROUS_LIST_ITEM_TYPE => 1776,
   XML_SCHEMAP_INVALID_ATTR_COMBINATION => 1777,
   XML_SCHEMAP_INVALID_ATTR_INLINE_COMBINATION => 1778,
   XML_SCHEMAP_MISSING_SIMPLETYPE_CHILD => 1779,
   XML_SCHEMAP_INVALID_ATTR_NAME => 1780,
   XML_SCHEMAP_REF_AND_CONTENT => 1781,
   XML_SCHEMAP_CT_PROPS_CORRECT_1 => 1782,
   XML_SCHEMAP_CT_PROPS_CORRECT_2 => 1783,
   XML_SCHEMAP_CT_PROPS_CORRECT_3 => 1784,
   XML_SCHEMAP_CT_PROPS_CORRECT_4 => 1785,
   XML_SCHEMAP_CT_PROPS_CORRECT_5 => 1786,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_1 => 1787,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_2_1_1 => 1788,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_2_1_2 => 1789,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_2_2 => 1790,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_3 => 1791,
   XML_SCHEMAP_WILDCARD_INVALID_NS_MEMBER => 1792,
   XML_SCHEMAP_INTERSECTION_NOT_EXPRESSIBLE => 1793,
   XML_SCHEMAP_UNION_NOT_EXPRESSIBLE => 1794,
   XML_SCHEMAP_SRC_IMPORT_3_1 => 1795,
   XML_SCHEMAP_SRC_IMPORT_3_2 => 1796,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_4_1 => 1797,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_4_2 => 1798,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_4_3 => 1799,
   XML_SCHEMAP_COS_CT_EXTENDS_1_3 => 1800,
   XML_SCHEMAV_NOROOT => 1801,
   XML_SCHEMAV_UNDECLAREDELEM => 1802,
   XML_SCHEMAV_NOTTOPLEVEL => 1803,
   XML_SCHEMAV_MISSING => 1804,
   XML_SCHEMAV_WRONGELEM => 1805,
   XML_SCHEMAV_NOTYPE => 1806,
   XML_SCHEMAV_NOROLLBACK => 1807,
   XML_SCHEMAV_ISABSTRACT => 1808,
   XML_SCHEMAV_NOTEMPTY => 1809,
   XML_SCHEMAV_ELEMCONT => 1810,
   XML_SCHEMAV_HAVEDEFAULT => 1811,
   XML_SCHEMAV_NOTNILLABLE => 1812,
   XML_SCHEMAV_EXTRACONTENT => 1813,
   XML_SCHEMAV_INVALIDATTR => 1814,
   XML_SCHEMAV_INVALIDELEM => 1815,
   XML_SCHEMAV_NOTDETERMINIST => 1816,
   XML_SCHEMAV_CONSTRUCT => 1817,
   XML_SCHEMAV_INTERNAL => 1818,
   XML_SCHEMAV_NOTSIMPLE => 1819,
   XML_SCHEMAV_ATTRUNKNOWN => 1820,
   XML_SCHEMAV_ATTRINVALID => 1821,
   XML_SCHEMAV_VALUE => 1822,
   XML_SCHEMAV_FACET => 1823,
   XML_SCHEMAV_CVC_DATATYPE_VALID_1_2_1 => 1824,
   XML_SCHEMAV_CVC_DATATYPE_VALID_1_2_2 => 1825,
   XML_SCHEMAV_CVC_DATATYPE_VALID_1_2_3 => 1826,
   XML_SCHEMAV_CVC_TYPE_3_1_1 => 1827,
   XML_SCHEMAV_CVC_TYPE_3_1_2 => 1828,
   XML_SCHEMAV_CVC_FACET_VALID => 1829,
   XML_SCHEMAV_CVC_LENGTH_VALID => 1830,
   XML_SCHEMAV_CVC_MINLENGTH_VALID => 1831,
   XML_SCHEMAV_CVC_MAXLENGTH_VALID => 1832,
   XML_SCHEMAV_CVC_MININCLUSIVE_VALID => 1833,
   XML_SCHEMAV_CVC_MAXINCLUSIVE_VALID => 1834,
   XML_SCHEMAV_CVC_MINEXCLUSIVE_VALID => 1835,
   XML_SCHEMAV_CVC_MAXEXCLUSIVE_VALID => 1836,
   XML_SCHEMAV_CVC_TOTALDIGITS_VALID => 1837,
   XML_SCHEMAV_CVC_FRACTIONDIGITS_VALID => 1838,
   XML_SCHEMAV_CVC_PATTERN_VALID => 1839,
   XML_SCHEMAV_CVC_ENUMERATION_VALID => 1840,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_2_1 => 1841,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_2_2 => 1842,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_2_3 => 1843,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_2_4 => 1844,
   XML_SCHEMAV_CVC_ELT_1 => 1845,
   XML_SCHEMAV_CVC_ELT_2 => 1846,
   XML_SCHEMAV_CVC_ELT_3_1 => 1847,
   XML_SCHEMAV_CVC_ELT_3_2_1 => 1848,
   XML_SCHEMAV_CVC_ELT_3_2_2 => 1849,
   XML_SCHEMAV_CVC_ELT_4_1 => 1850,
   XML_SCHEMAV_CVC_ELT_4_2 => 1851,
   XML_SCHEMAV_CVC_ELT_4_3 => 1852,
   XML_SCHEMAV_CVC_ELT_5_1_1 => 1853,
   XML_SCHEMAV_CVC_ELT_5_1_2 => 1854,
   XML_SCHEMAV_CVC_ELT_5_2_1 => 1855,
   XML_SCHEMAV_CVC_ELT_5_2_2_1 => 1856,
   XML_SCHEMAV_CVC_ELT_5_2_2_2_1 => 1857,
   XML_SCHEMAV_CVC_ELT_5_2_2_2_2 => 1858,
   XML_SCHEMAV_CVC_ELT_6 => 1859,
   XML_SCHEMAV_CVC_ELT_7 => 1860,
   XML_SCHEMAV_CVC_ATTRIBUTE_1 => 1861,
   XML_SCHEMAV_CVC_ATTRIBUTE_2 => 1862,
   XML_SCHEMAV_CVC_ATTRIBUTE_3 => 1863,
   XML_SCHEMAV_CVC_ATTRIBUTE_4 => 1864,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_3_1 => 1865,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_3_2_1 => 1866,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_3_2_2 => 1867,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_4 => 1868,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_5_1 => 1869,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_5_2 => 1870,
   XML_SCHEMAV_ELEMENT_CONTENT => 1871,
   XML_SCHEMAV_DOCUMENT_ELEMENT_MISSING => 1872,
   XML_SCHEMAV_CVC_COMPLEX_TYPE_1 => 1873,
   XML_SCHEMAV_CVC_AU => 1874,
   XML_SCHEMAV_CVC_TYPE_1 => 1875,
   XML_SCHEMAV_CVC_TYPE_2 => 1876,
   XML_SCHEMAV_CVC_IDC => 1877,
   XML_SCHEMAV_CVC_WILDCARD => 1878,
   XML_SCHEMAV_MISC => 1879,
   XML_XPTR_UNKNOWN_SCHEME => 1900,
   XML_XPTR_CHILDSEQ_START => 1901,
   XML_XPTR_EVAL_FAILED => 1902,
   XML_XPTR_EXTRA_OBJECTS => 1903,
   XML_C14N_CREATE_CTXT => 1950,
   XML_C14N_REQUIRES_UTF8 => 1951,
   XML_C14N_CREATE_STACK => 1952,
   XML_C14N_INVALID_NODE => 1953,
   XML_C14N_UNKNOW_NODE => 1954,
   XML_C14N_RELATIVE_NAMESPACE => 1955,
   XML_FTP_PASV_ANSWER => 2000,
   XML_FTP_EPSV_ANSWER => 2001,
   XML_FTP_ACCNT => 2002,
   XML_FTP_URL_SYNTAX => 2003,
   XML_HTTP_URL_SYNTAX => 2020,
   XML_HTTP_USE_IP => 2021,
   XML_HTTP_UNKNOWN_HOST => 2022,
   XML_SCHEMAP_SRC_SIMPLE_TYPE_1 => 3000,
   XML_SCHEMAP_SRC_SIMPLE_TYPE_2 => 3001,
   XML_SCHEMAP_SRC_SIMPLE_TYPE_3 => 3002,
   XML_SCHEMAP_SRC_SIMPLE_TYPE_4 => 3003,
   XML_SCHEMAP_SRC_RESOLVE => 3004,
   XML_SCHEMAP_SRC_RESTRICTION_BASE_OR_SIMPLETYPE => 3005,
   XML_SCHEMAP_SRC_LIST_ITEMTYPE_OR_SIMPLETYPE => 3006,
   XML_SCHEMAP_SRC_UNION_MEMBERTYPES_OR_SIMPLETYPES => 3007,
   XML_SCHEMAP_ST_PROPS_CORRECT_1 => 3008,
   XML_SCHEMAP_ST_PROPS_CORRECT_2 => 3009,
   XML_SCHEMAP_ST_PROPS_CORRECT_3 => 3010,
   XML_SCHEMAP_COS_ST_RESTRICTS_1_1 => 3011,
   XML_SCHEMAP_COS_ST_RESTRICTS_1_2 => 3012,
   XML_SCHEMAP_COS_ST_RESTRICTS_1_3_1 => 3013,
   XML_SCHEMAP_COS_ST_RESTRICTS_1_3_2 => 3014,
   XML_SCHEMAP_COS_ST_RESTRICTS_2_1 => 3015,
   XML_SCHEMAP_COS_ST_RESTRICTS_2_3_1_1 => 3016,
   XML_SCHEMAP_COS_ST_RESTRICTS_2_3_1_2 => 3017,
   XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_1 => 3018,
   XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_2 => 3019,
   XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_3 => 3020,
   XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_4 => 3021,
   XML_SCHEMAP_COS_ST_RESTRICTS_2_3_2_5 => 3022,
   XML_SCHEMAP_COS_ST_RESTRICTS_3_1 => 3023,
   XML_SCHEMAP_COS_ST_RESTRICTS_3_3_1 => 3024,
   XML_SCHEMAP_COS_ST_RESTRICTS_3_3_1_2 => 3025,
   XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_2 => 3026,
   XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_1 => 3027,
   XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_3 => 3028,
   XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_4 => 3029,
   XML_SCHEMAP_COS_ST_RESTRICTS_3_3_2_5 => 3030,
   XML_SCHEMAP_COS_ST_DERIVED_OK_2_1 => 3031,
   XML_SCHEMAP_COS_ST_DERIVED_OK_2_2 => 3032,
   XML_SCHEMAP_S4S_ELEM_NOT_ALLOWED => 3033,
   XML_SCHEMAP_S4S_ELEM_MISSING => 3034,
   XML_SCHEMAP_S4S_ATTR_NOT_ALLOWED => 3035,
   XML_SCHEMAP_S4S_ATTR_MISSING => 3036,
   XML_SCHEMAP_S4S_ATTR_INVALID_VALUE => 3037,
   XML_SCHEMAP_SRC_ELEMENT_1 => 3038,
   XML_SCHEMAP_SRC_ELEMENT_2_1 => 3039,
   XML_SCHEMAP_SRC_ELEMENT_2_2 => 3040,
   XML_SCHEMAP_SRC_ELEMENT_3 => 3041,
   XML_SCHEMAP_P_PROPS_CORRECT_1 => 3042,
   XML_SCHEMAP_P_PROPS_CORRECT_2_1 => 3043,
   XML_SCHEMAP_P_PROPS_CORRECT_2_2 => 3044,
   XML_SCHEMAP_E_PROPS_CORRECT_2 => 3045,
   XML_SCHEMAP_E_PROPS_CORRECT_3 => 3046,
   XML_SCHEMAP_E_PROPS_CORRECT_4 => 3047,
   XML_SCHEMAP_E_PROPS_CORRECT_5 => 3048,
   XML_SCHEMAP_E_PROPS_CORRECT_6 => 3049,
   XML_SCHEMAP_SRC_INCLUDE => 3050,
   XML_SCHEMAP_SRC_ATTRIBUTE_1 => 3051,
   XML_SCHEMAP_SRC_ATTRIBUTE_2 => 3052,
   XML_SCHEMAP_SRC_ATTRIBUTE_3_1 => 3053,
   XML_SCHEMAP_SRC_ATTRIBUTE_3_2 => 3054,
   XML_SCHEMAP_SRC_ATTRIBUTE_4 => 3055,
   XML_SCHEMAP_NO_XMLNS => 3056,
   XML_SCHEMAP_NO_XSI => 3057,
   XML_SCHEMAP_COS_VALID_DEFAULT_1 => 3058,
   XML_SCHEMAP_COS_VALID_DEFAULT_2_1 => 3059,
   XML_SCHEMAP_COS_VALID_DEFAULT_2_2_1 => 3060,
   XML_SCHEMAP_COS_VALID_DEFAULT_2_2_2 => 3061,
   XML_SCHEMAP_CVC_SIMPLE_TYPE => 3062,
   XML_SCHEMAP_COS_CT_EXTENDS_1_1 => 3063,
   XML_SCHEMAP_SRC_IMPORT_1_1 => 3064,
   XML_SCHEMAP_SRC_IMPORT_1_2 => 3065,
   XML_SCHEMAP_SRC_IMPORT_2 => 3066,
   XML_SCHEMAP_SRC_IMPORT_2_1 => 3067,
   XML_SCHEMAP_SRC_IMPORT_2_2 => 3068,
   XML_SCHEMAP_INTERNAL => 3069,
   XML_SCHEMAP_NOT_DETERMINISTIC => 3070,
   XML_SCHEMAP_SRC_ATTRIBUTE_GROUP_1 => 3071,
   XML_SCHEMAP_SRC_ATTRIBUTE_GROUP_2 => 3072,
   XML_SCHEMAP_SRC_ATTRIBUTE_GROUP_3 => 3073,
   XML_SCHEMAP_MG_PROPS_CORRECT_1 => 3074,
   XML_SCHEMAP_MG_PROPS_CORRECT_2 => 3075,
   XML_SCHEMAP_SRC_CT_1 => 3076,
   XML_SCHEMAP_DERIVATION_OK_RESTRICTION_2_1_3 => 3077,
   XML_SCHEMAP_AU_PROPS_CORRECT_2 => 3078,
   XML_SCHEMAP_A_PROPS_CORRECT_2 => 3079,
   XML_SCHEMAP_C_PROPS_CORRECT => 3080,
   XML_SCHEMAP_SRC_REDEFINE => 3081,
   XML_SCHEMAP_SRC_IMPORT => 3082,
   XML_SCHEMAP_WARN_SKIP_SCHEMA => 3083,
   XML_SCHEMAP_WARN_UNLOCATED_SCHEMA => 3084,
   XML_SCHEMAP_WARN_ATTR_REDECL_PROH => 3085,
   XML_SCHEMAP_WARN_ATTR_POINTLESS_PROH => 3086,
   XML_SCHEMAP_AG_PROPS_CORRECT => 3087,
   XML_SCHEMAP_COS_CT_EXTENDS_1_2 => 3088,
   XML_SCHEMAP_AU_PROPS_CORRECT => 3089,
   XML_SCHEMAP_A_PROPS_CORRECT_3 => 3090,
   XML_SCHEMAP_COS_ALL_LIMITED => 3091,
   XML_SCHEMATRONV_ASSERT => 4000,
   XML_SCHEMATRONV_REPORT => 4001,
   XML_MODULE_OPEN => 4900,
   XML_MODULE_CLOSE => 4901,
   XML_CHECK_FOUND_ELEMENT => 5000,
   XML_CHECK_FOUND_ATTRIBUTE => 5001,
   XML_CHECK_FOUND_TEXT => 5002,
   XML_CHECK_FOUND_CDATA => 5003,
   XML_CHECK_FOUND_ENTITYREF => 5004,
   XML_CHECK_FOUND_ENTITY => 5005,
   XML_CHECK_FOUND_PI => 5006,
   XML_CHECK_FOUND_COMMENT => 5007,
   XML_CHECK_FOUND_DOCTYPE => 5008,
   XML_CHECK_FOUND_FRAGMENT => 5009,
   XML_CHECK_FOUND_NOTATION => 5010,
   XML_CHECK_UNKNOWN_NODE => 5011,
   XML_CHECK_ENTITY_TYPE => 5012,
   XML_CHECK_NO_PARENT => 5013,
   XML_CHECK_NO_DOC => 5014,
   XML_CHECK_NO_NAME => 5015,
   XML_CHECK_NO_ELEM => 5016,
   XML_CHECK_WRONG_DOC => 5017,
   XML_CHECK_NO_PREV => 5018,
   XML_CHECK_WRONG_PREV => 5019,
   XML_CHECK_NO_NEXT => 5020,
   XML_CHECK_WRONG_NEXT => 5021,
   XML_CHECK_NOT_DTD => 5022,
   XML_CHECK_NOT_ATTR => 5023,
   XML_CHECK_NOT_ATTR_DECL => 5024,
   XML_CHECK_NOT_ELEM_DECL => 5025,
   XML_CHECK_NOT_ENTITY_DECL => 5026,
   XML_CHECK_NOT_NS_DECL => 5027,
   XML_CHECK_NO_HREF => 5028,
   XML_CHECK_WRONG_PARENT => 5029,
   XML_CHECK_NS_SCOPE => 5030,
   XML_CHECK_NS_ANCESTOR => 5031,
   XML_CHECK_NOT_UTF8 => 5032,
   XML_CHECK_NO_DICT => 5033,
   XML_CHECK_NOT_NCNAME => 5034,
   XML_CHECK_OUTSIDE_DICT => 5035,
   XML_CHECK_WRONG_NAME => 5036,
   XML_CHECK_NAME_NOT_NULL => 5037,
   XML_I18N_NO_NAME => 6000,
   XML_I18N_NO_HANDLER => 6001,
   XML_I18N_EXCESS_HANDLER => 6002,
   XML_I18N_CONV_FAILED => 6003,
   XML_I18N_NO_OUTPUT => 6004,
   XML_BUF_OVERFLOW => 7000
);

# == /usr/include/libxml2/libxml/parser.h ==

enum xmlParserInputState is export (
   XML_PARSER_EOF => -1,
   XML_PARSER_START => 0,
   XML_PARSER_MISC => 1,
   XML_PARSER_PI => 2,
   XML_PARSER_DTD => 3,
   XML_PARSER_PROLOG => 4,
   XML_PARSER_COMMENT => 5,
   XML_PARSER_START_TAG => 6,
   XML_PARSER_CONTENT => 7,
   XML_PARSER_CDATA_SECTION => 8,
   XML_PARSER_END_TAG => 9,
   XML_PARSER_ENTITY_DECL => 10,
   XML_PARSER_ENTITY_VALUE => 11,
   XML_PARSER_ATTRIBUTE_VALUE => 12,
   XML_PARSER_SYSTEM_LITERAL => 13,
   XML_PARSER_EPILOG => 14,
   XML_PARSER_IGNORE => 15,
   XML_PARSER_PUBLIC_LITERAL => 16
);
enum xmlParserMode is export (
   XML_PARSE_UNKNOWN => 0,
   XML_PARSE_DOM => 1,
   XML_PARSE_SAX => 2,
   XML_PARSE_PUSH_DOM => 3,
   XML_PARSE_PUSH_SAX => 4,
   XML_PARSE_READER => 5
);
enum xmlParserOption is export (
   XML_PARSE_RECOVER => 1,
   XML_PARSE_NOENT => 2,
   XML_PARSE_DTDLOAD => 4,
   XML_PARSE_DTDATTR => 8,
   XML_PARSE_DTDVALID => 16,
   XML_PARSE_NOERROR => 32,
   XML_PARSE_NOWARNING => 64,
   XML_PARSE_PEDANTIC => 128,
   XML_PARSE_NOBLANKS => 256,
   XML_PARSE_SAX1 => 512,
   XML_PARSE_XINCLUDE => 1024,
   XML_PARSE_NONET => 2048,
   XML_PARSE_NODICT => 4096,
   XML_PARSE_NSCLEAN => 8192,
   XML_PARSE_NOCDATA => 16384,
   XML_PARSE_NOXINCNODE => 32768,
   XML_PARSE_COMPACT => 65536,
   XML_PARSE_OLD10 => 131072,
   XML_PARSE_NOBASEFIX => 262144,
   XML_PARSE_HUGE => 524288,
   XML_PARSE_OLDSAX => 1048576,
   XML_PARSE_IGNORE_ENC => 2097152,
   XML_PARSE_BIG_LINES => 4194304
);
enum xmlFeature is export (
   XML_WITH_THREAD => 1,
   XML_WITH_TREE => 2,
   XML_WITH_OUTPUT => 3,
   XML_WITH_PUSH => 4,
   XML_WITH_READER => 5,
   XML_WITH_PATTERN => 6,
   XML_WITH_WRITER => 7,
   XML_WITH_SAX1 => 8,
   XML_WITH_FTP => 9,
   XML_WITH_HTTP => 10,
   XML_WITH_VALID => 11,
   XML_WITH_HTML => 12,
   XML_WITH_LEGACY => 13,
   XML_WITH_C14N => 14,
   XML_WITH_CATALOG => 15,
   XML_WITH_XPATH => 16,
   XML_WITH_XPTR => 17,
   XML_WITH_XINCLUDE => 18,
   XML_WITH_ICONV => 19,
   XML_WITH_ISO8859X => 20,
   XML_WITH_UNICODE => 21,
   XML_WITH_REGEXP => 22,
   XML_WITH_AUTOMATA => 23,
   XML_WITH_EXPR => 24,
   XML_WITH_SCHEMAS => 25,
   XML_WITH_SCHEMATRON => 26,
   XML_WITH_MODULES => 27,
   XML_WITH_DEBUG => 28,
   XML_WITH_DEBUG_MEM => 29,
   XML_WITH_DEBUG_RUN => 30,
   XML_WITH_ZLIB => 31,
   XML_WITH_ICU => 32,
   XML_WITH_LZMA => 33,
   XML_WITH_NONE => 99999
);

# == /usr/include/libxml2/libxml/xmlregexp.h ==

enum xmlExpNodeType is export (
   XML_EXP_EMPTY => 0,
   XML_EXP_FORBID => 1,
   XML_EXP_ATOM => 2,
   XML_EXP_SEQ => 3,
   XML_EXP_OR => 4,
   XML_EXP_COUNT => 5
);

# == /usr/include/unicode/ucnv_err.h ==

enum UConverterCallbackReason is export (
   UCNV_UNASSIGNED => 0,
   UCNV_ILLEGAL => 1,
   UCNV_IRREGULAR => 2,
   UCNV_RESET => 3,
   UCNV_CLOSE => 4,
   UCNV_CLONE => 5
);

# == /usr/include/libxml2/libxml/tree.h ==

enum xmlBufferAllocationScheme is export (
   XML_BUFFER_ALLOC_DOUBLEIT => 0,
   XML_BUFFER_ALLOC_EXACT => 1,
   XML_BUFFER_ALLOC_IMMUTABLE => 2,
   XML_BUFFER_ALLOC_IO => 3,
   XML_BUFFER_ALLOC_HYBRID => 4,
   XML_BUFFER_ALLOC_BOUNDED => 5
);
enum xmlElementType is export (
   XML_ELEMENT_NODE => 1,
   XML_ATTRIBUTE_NODE => 2,
   XML_TEXT_NODE => 3,
   XML_CDATA_SECTION_NODE => 4,
   XML_ENTITY_REF_NODE => 5,
   XML_ENTITY_NODE => 6,
   XML_PI_NODE => 7,
   XML_COMMENT_NODE => 8,
   XML_DOCUMENT_NODE => 9,
   XML_DOCUMENT_TYPE_NODE => 10,
   XML_DOCUMENT_FRAG_NODE => 11,
   XML_NOTATION_NODE => 12,
   XML_HTML_DOCUMENT_NODE => 13,
   XML_DTD_NODE => 14,
   XML_ELEMENT_DECL => 15,
   XML_ATTRIBUTE_DECL => 16,
   XML_ENTITY_DECL => 17,
   XML_NAMESPACE_DECL => 18,
   XML_XINCLUDE_START => 19,
   XML_XINCLUDE_END => 20,
   XML_DOCB_DOCUMENT_NODE => 21
);
enum xmlAttributeType is export (
   XML_ATTRIBUTE_CDATA => 1,
   XML_ATTRIBUTE_ID => 2,
   XML_ATTRIBUTE_IDREF => 3,
   XML_ATTRIBUTE_IDREFS => 4,
   XML_ATTRIBUTE_ENTITY => 5,
   XML_ATTRIBUTE_ENTITIES => 6,
   XML_ATTRIBUTE_NMTOKEN => 7,
   XML_ATTRIBUTE_NMTOKENS => 8,
   XML_ATTRIBUTE_ENUMERATION => 9,
   XML_ATTRIBUTE_NOTATION => 10
);
enum xmlAttributeDefault is export (
   XML_ATTRIBUTE_NONE => 1,
   XML_ATTRIBUTE_REQUIRED => 2,
   XML_ATTRIBUTE_IMPLIED => 3,
   XML_ATTRIBUTE_FIXED => 4
);
enum xmlElementContentType is export (
   XML_ELEMENT_CONTENT_PCDATA => 1,
   XML_ELEMENT_CONTENT_ELEMENT => 2,
   XML_ELEMENT_CONTENT_SEQ => 3,
   XML_ELEMENT_CONTENT_OR => 4
);
enum xmlElementContentOccur is export (
   XML_ELEMENT_CONTENT_ONCE => 1,
   XML_ELEMENT_CONTENT_OPT => 2,
   XML_ELEMENT_CONTENT_MULT => 3,
   XML_ELEMENT_CONTENT_PLUS => 4
);
enum xmlElementTypeVal is export (
   XML_ELEMENT_TYPE_UNDEFINED => 0,
   XML_ELEMENT_TYPE_EMPTY => 1,
   XML_ELEMENT_TYPE_ANY => 2,
   XML_ELEMENT_TYPE_MIXED => 3,
   XML_ELEMENT_TYPE_ELEMENT => 4
);
enum xmlDocProperties is export (
   XML_DOC_WELLFORMED => 1,
   XML_DOC_NSVALID => 2,
   XML_DOC_OLD10 => 4,
   XML_DOC_DTDVALID => 8,
   XML_DOC_XINCLUDE => 16,
   XML_DOC_USERBUILT => 32,
   XML_DOC_INTERNAL => 64,
   XML_DOC_HTML => 128
);

# == /usr/include/libxml2/libxml/xlink.h ==

enum xlinkType is export (
   XLINK_TYPE_NONE => 0,
   XLINK_TYPE_SIMPLE => 1,
   XLINK_TYPE_EXTENDED => 2,
   XLINK_TYPE_EXTENDED_SET => 3
);
enum xlinkShow is export (
   XLINK_SHOW_NONE => 0,
   XLINK_SHOW_NEW => 1,
   XLINK_SHOW_EMBED => 2,
   XLINK_SHOW_REPLACE => 3
);
enum xlinkActuate is export (
   XLINK_ACTUATE_NONE => 0,
   XLINK_ACTUATE_AUTO => 1,
   XLINK_ACTUATE_ONREQUEST => 2
);

# == /usr/include/unicode/ucnv.h ==

enum UConverterType is export (
   UCNV_UNSUPPORTED_CONVERTER => -1,
   UCNV_SBCS => 0,
   UCNV_DBCS => 1,
   UCNV_MBCS => 2,
   UCNV_LATIN_1 => 3,
   UCNV_UTF8 => 4,
   UCNV_UTF16_BigEndian => 5,
   UCNV_UTF16_LittleEndian => 6,
   UCNV_UTF32_BigEndian => 7,
   UCNV_UTF32_LittleEndian => 8,
   UCNV_EBCDIC_STATEFUL => 9,
   UCNV_ISO_2022 => 10,
   UCNV_LMBCS_1 => 11,
   UCNV_LMBCS_2 => 12,
   UCNV_LMBCS_3 => 13,
   UCNV_LMBCS_4 => 14,
   UCNV_LMBCS_5 => 15,
   UCNV_LMBCS_6 => 16,
   UCNV_LMBCS_8 => 17,
   UCNV_LMBCS_11 => 18,
   UCNV_LMBCS_16 => 19,
   UCNV_LMBCS_17 => 20,
   UCNV_LMBCS_18 => 21,
   UCNV_LMBCS_19 => 22,
   UCNV_LMBCS_LAST => 22,
   UCNV_HZ => 23,
   UCNV_SCSU => 24,
   UCNV_ISCII => 25,
   UCNV_US_ASCII => 26,
   UCNV_UTF7 => 27,
   UCNV_BOCU1 => 28,
   UCNV_UTF16 => 29,
   UCNV_UTF32 => 30,
   UCNV_CESU8 => 31,
   UCNV_IMAP_MAILBOX => 32,
   UCNV_COMPOUND_TEXT => 33,
   UCNV_NUMBER_OF_SUPPORTED_CONVERTER_TYPES => 34
);
enum UConverterPlatform is export (
   UCNV_UNKNOWN => -1,
   UCNV_IBM => 0
);
enum UConverterUnicodeSet is export (
   UCNV_ROUNDTRIP_SET => 0,
   UCNV_ROUNDTRIP_AND_FALLBACK_SET => 1,
   UCNV_SET_COUNT => 2
);

# == /usr/include/unicode/utypes.h ==

enum UErrorCode is export (
   U_USING_FALLBACK_WARNING => -128,
   U_ERROR_WARNING_START => -128,
   U_USING_DEFAULT_WARNING => -127,
   U_SAFECLONE_ALLOCATED_WARNING => -126,
   U_STATE_OLD_WARNING => -125,
   U_STRING_NOT_TERMINATED_WARNING => -124,
   U_SORT_KEY_TOO_SHORT_WARNING => -123,
   U_AMBIGUOUS_ALIAS_WARNING => -122,
   U_DIFFERENT_UCA_VERSION => -121,
   U_PLUGIN_CHANGED_LEVEL_WARNING => -120,
   U_ERROR_WARNING_LIMIT => -119,
   U_ZERO_ERROR => 0,
   U_ILLEGAL_ARGUMENT_ERROR => 1,
   U_MISSING_RESOURCE_ERROR => 2,
   U_INVALID_FORMAT_ERROR => 3,
   U_FILE_ACCESS_ERROR => 4,
   U_INTERNAL_PROGRAM_ERROR => 5,
   U_MESSAGE_PARSE_ERROR => 6,
   U_MEMORY_ALLOCATION_ERROR => 7,
   U_INDEX_OUTOFBOUNDS_ERROR => 8,
   U_PARSE_ERROR => 9,
   U_INVALID_CHAR_FOUND => 10,
   U_TRUNCATED_CHAR_FOUND => 11,
   U_ILLEGAL_CHAR_FOUND => 12,
   U_INVALID_TABLE_FORMAT => 13,
   U_INVALID_TABLE_FILE => 14,
   U_BUFFER_OVERFLOW_ERROR => 15,
   U_UNSUPPORTED_ERROR => 16,
   U_RESOURCE_TYPE_MISMATCH => 17,
   U_ILLEGAL_ESCAPE_SEQUENCE => 18,
   U_UNSUPPORTED_ESCAPE_SEQUENCE => 19,
   U_NO_SPACE_AVAILABLE => 20,
   U_CE_NOT_FOUND_ERROR => 21,
   U_PRIMARY_TOO_LONG_ERROR => 22,
   U_STATE_TOO_OLD_ERROR => 23,
   U_TOO_MANY_ALIASES_ERROR => 24,
   U_ENUM_OUT_OF_SYNC_ERROR => 25,
   U_INVARIANT_CONVERSION_ERROR => 26,
   U_INVALID_STATE_ERROR => 27,
   U_COLLATOR_VERSION_MISMATCH => 28,
   U_USELESS_COLLATOR_ERROR => 29,
   U_NO_WRITE_PERMISSION => 30,
   U_STANDARD_ERROR_LIMIT => 31,
   U_BAD_VARIABLE_DEFINITION => 65536,
   U_PARSE_ERROR_START => 65536,
   U_MALFORMED_RULE => 65537,
   U_MALFORMED_SET => 65538,
   U_MALFORMED_SYMBOL_REFERENCE => 65539,
   U_MALFORMED_UNICODE_ESCAPE => 65540,
   U_MALFORMED_VARIABLE_DEFINITION => 65541,
   U_MALFORMED_VARIABLE_REFERENCE => 65542,
   U_MISMATCHED_SEGMENT_DELIMITERS => 65543,
   U_MISPLACED_ANCHOR_START => 65544,
   U_MISPLACED_CURSOR_OFFSET => 65545,
   U_MISPLACED_QUANTIFIER => 65546,
   U_MISSING_OPERATOR => 65547,
   U_MISSING_SEGMENT_CLOSE => 65548,
   U_MULTIPLE_ANTE_CONTEXTS => 65549,
   U_MULTIPLE_CURSORS => 65550,
   U_MULTIPLE_POST_CONTEXTS => 65551,
   U_TRAILING_BACKSLASH => 65552,
   U_UNDEFINED_SEGMENT_REFERENCE => 65553,
   U_UNDEFINED_VARIABLE => 65554,
   U_UNQUOTED_SPECIAL => 65555,
   U_UNTERMINATED_QUOTE => 65556,
   U_RULE_MASK_ERROR => 65557,
   U_MISPLACED_COMPOUND_FILTER => 65558,
   U_MULTIPLE_COMPOUND_FILTERS => 65559,
   U_INVALID_RBT_SYNTAX => 65560,
   U_INVALID_PROPERTY_PATTERN => 65561,
   U_MALFORMED_PRAGMA => 65562,
   U_UNCLOSED_SEGMENT => 65563,
   U_ILLEGAL_CHAR_IN_SEGMENT => 65564,
   U_VARIABLE_RANGE_EXHAUSTED => 65565,
   U_VARIABLE_RANGE_OVERLAP => 65566,
   U_ILLEGAL_CHARACTER => 65567,
   U_INTERNAL_TRANSLITERATOR_ERROR => 65568,
   U_INVALID_ID => 65569,
   U_INVALID_FUNCTION => 65570,
   U_PARSE_ERROR_LIMIT => 65571,
   U_UNEXPECTED_TOKEN => 65792,
   U_FMT_PARSE_ERROR_START => 65792,
   U_MULTIPLE_DECIMAL_SEPARATORS => 65793,
   U_MULTIPLE_DECIMAL_SEPERATORS => 65793,
   U_MULTIPLE_EXPONENTIAL_SYMBOLS => 65794,
   U_MALFORMED_EXPONENTIAL_PATTERN => 65795,
   U_MULTIPLE_PERCENT_SYMBOLS => 65796,
   U_MULTIPLE_PERMILL_SYMBOLS => 65797,
   U_MULTIPLE_PAD_SPECIFIERS => 65798,
   U_PATTERN_SYNTAX_ERROR => 65799,
   U_ILLEGAL_PAD_POSITION => 65800,
   U_UNMATCHED_BRACES => 65801,
   U_UNSUPPORTED_PROPERTY => 65802,
   U_UNSUPPORTED_ATTRIBUTE => 65803,
   U_ARGUMENT_TYPE_MISMATCH => 65804,
   U_DUPLICATE_KEYWORD => 65805,
   U_UNDEFINED_KEYWORD => 65806,
   U_DEFAULT_KEYWORD_MISSING => 65807,
   U_DECIMAL_NUMBER_SYNTAX_ERROR => 65808,
   U_FORMAT_INEXACT_ERROR => 65809,
   U_FMT_PARSE_ERROR_LIMIT => 65810,
   U_BRK_INTERNAL_ERROR => 66048,
   U_BRK_ERROR_START => 66048,
   U_BRK_HEX_DIGITS_EXPECTED => 66049,
   U_BRK_SEMICOLON_EXPECTED => 66050,
   U_BRK_RULE_SYNTAX => 66051,
   U_BRK_UNCLOSED_SET => 66052,
   U_BRK_ASSIGN_ERROR => 66053,
   U_BRK_VARIABLE_REDFINITION => 66054,
   U_BRK_MISMATCHED_PAREN => 66055,
   U_BRK_NEW_LINE_IN_QUOTED_STRING => 66056,
   U_BRK_UNDEFINED_VARIABLE => 66057,
   U_BRK_INIT_ERROR => 66058,
   U_BRK_RULE_EMPTY_SET => 66059,
   U_BRK_UNRECOGNIZED_OPTION => 66060,
   U_BRK_MALFORMED_RULE_TAG => 66061,
   U_BRK_ERROR_LIMIT => 66062,
   U_REGEX_INTERNAL_ERROR => 66304,
   U_REGEX_ERROR_START => 66304,
   U_REGEX_RULE_SYNTAX => 66305,
   U_REGEX_INVALID_STATE => 66306,
   U_REGEX_BAD_ESCAPE_SEQUENCE => 66307,
   U_REGEX_PROPERTY_SYNTAX => 66308,
   U_REGEX_UNIMPLEMENTED => 66309,
   U_REGEX_MISMATCHED_PAREN => 66310,
   U_REGEX_NUMBER_TOO_BIG => 66311,
   U_REGEX_BAD_INTERVAL => 66312,
   U_REGEX_MAX_LT_MIN => 66313,
   U_REGEX_INVALID_BACK_REF => 66314,
   U_REGEX_INVALID_FLAG => 66315,
   U_REGEX_LOOK_BEHIND_LIMIT => 66316,
   U_REGEX_SET_CONTAINS_STRING => 66317,
   U_REGEX_OCTAL_TOO_BIG => 66318,
   U_REGEX_MISSING_CLOSE_BRACKET => 66319,
   U_REGEX_INVALID_RANGE => 66320,
   U_REGEX_STACK_OVERFLOW => 66321,
   U_REGEX_TIME_OUT => 66322,
   U_REGEX_STOPPED_BY_CALLER => 66323,
   U_REGEX_PATTERN_TOO_BIG => 66324,
   U_REGEX_INVALID_CAPTURE_GROUP_NAME => 66325,
   U_REGEX_ERROR_LIMIT => 66326,
   U_IDNA_PROHIBITED_ERROR => 66560,
   U_IDNA_ERROR_START => 66560,
   U_IDNA_UNASSIGNED_ERROR => 66561,
   U_IDNA_CHECK_BIDI_ERROR => 66562,
   U_IDNA_STD3_ASCII_RULES_ERROR => 66563,
   U_IDNA_ACE_PREFIX_ERROR => 66564,
   U_IDNA_VERIFICATION_ERROR => 66565,
   U_IDNA_LABEL_TOO_LONG_ERROR => 66566,
   U_IDNA_ZERO_LENGTH_LABEL_ERROR => 66567,
   U_IDNA_DOMAIN_NAME_TOO_LONG_ERROR => 66568,
   U_IDNA_ERROR_LIMIT => 66569,
   U_STRINGPREP_PROHIBITED_ERROR => 66560,
   U_STRINGPREP_UNASSIGNED_ERROR => 66561,
   U_STRINGPREP_CHECK_BIDI_ERROR => 66562,
   U_PLUGIN_ERROR_START => 66816,
   U_PLUGIN_TOO_HIGH => 66816,
   U_PLUGIN_DIDNT_SET_LEVEL => 66817,
   U_PLUGIN_ERROR_LIMIT => 66818,
   U_ERROR_LIMIT => 66818
);

# == HTMLparser.h ==

enum htmlParserOption is export (
   HTML_PARSE_RECOVER => 1,
   HTML_PARSE_NODEFDTD => 4,
   HTML_PARSE_NOERROR => 32,
   HTML_PARSE_NOWARNING => 64,
   HTML_PARSE_PEDANTIC => 128,
   HTML_PARSE_NOBLANKS => 256,
   HTML_PARSE_NONET => 2048,
   HTML_PARSE_NOIMPLIED => 8192,
   HTML_PARSE_COMPACT => 65536,
   HTML_PARSE_IGNORE_ENC => 2097152
);
enum htmlStatus is export (
   HTML_NA => 0,
   HTML_INVALID => 1,
   HTML_DEPRECATED => 2,
   HTML_VALID => 4,
   HTML_REQUIRED => 12
);

# == /usr/include/libxml2/libxml/encoding.h ==

enum xmlCharEncoding is export (
   XML_CHAR_ENCODING_ERROR => -1,
   XML_CHAR_ENCODING_NONE => 0,
   XML_CHAR_ENCODING_UTF8 => 1,
   XML_CHAR_ENCODING_UTF16LE => 2,
   XML_CHAR_ENCODING_UTF16BE => 3,
   XML_CHAR_ENCODING_UCS4LE => 4,
   XML_CHAR_ENCODING_UCS4BE => 5,
   XML_CHAR_ENCODING_EBCDIC => 6,
   XML_CHAR_ENCODING_UCS4_2143 => 7,
   XML_CHAR_ENCODING_UCS4_3412 => 8,
   XML_CHAR_ENCODING_UCS2 => 9,
   XML_CHAR_ENCODING_8859_1 => 10,
   XML_CHAR_ENCODING_8859_2 => 11,
   XML_CHAR_ENCODING_8859_3 => 12,
   XML_CHAR_ENCODING_8859_4 => 13,
   XML_CHAR_ENCODING_8859_5 => 14,
   XML_CHAR_ENCODING_8859_6 => 15,
   XML_CHAR_ENCODING_8859_7 => 16,
   XML_CHAR_ENCODING_8859_8 => 17,
   XML_CHAR_ENCODING_8859_9 => 18,
   XML_CHAR_ENCODING_2022_JP => 19,
   XML_CHAR_ENCODING_SHIFT_JIS => 20,
   XML_CHAR_ENCODING_EUC_JP => 21,
   XML_CHAR_ENCODING_ASCII => 22
);
## Structures


# == /usr/include/libxml2/libxml/entities.h ==

class _xmlEntity is repr('CStruct') is export {
	has Pointer                       $._private; # void* _private
	has int32                         $.type; # Typedef<xmlElementType>->«xmlElementType» type
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has _xmlNode                      $.children; # _xmlNode* children
	has _xmlNode                      $.last; # _xmlNode* last
	has _xmlDtd                       $.parent; # _xmlDtd* parent
	has _xmlNode                      $.next; # _xmlNode* next
	has _xmlNode                      $.prev; # _xmlNode* prev
	has _xmlDoc                       $.doc; # _xmlDoc* doc
	has Pointer[xmlChar]              $.orig; # Typedef<xmlChar>->«unsigned char»* orig
	has Pointer[xmlChar]              $.content; # Typedef<xmlChar>->«unsigned char»* content
	has int32                         $.length; # int length
	has int32                         $.etype; # Typedef<xmlEntityType>->«xmlEntityType» etype
	has Pointer[xmlChar]              $.ExternalID; # const Typedef<xmlChar>->«unsigned char»* ExternalID
	has Pointer[xmlChar]              $.SystemID; # const Typedef<xmlChar>->«unsigned char»* SystemID
	has _xmlEntity                    $.nexte; # _xmlEntity* nexte
	has Pointer[xmlChar]              $.URI; # const Typedef<xmlChar>->«unsigned char»* URI
	has int32                         $.owner; # int owner
	has int32                         $.checked; # int checked
}

# == /usr/include/libxml2/libxml/xmlerror.h ==

class _xmlError is repr('CStruct') is export {
	has int32                         $.domain; # int domain
	has int32                         $.code; # int code
	has Str                           $.message; # char* message
	has int32                         $.level; # Typedef<xmlErrorLevel>->«xmlErrorLevel» level
	has Str                           $.file; # char* file
	has int32                         $.line; # int line
	has Str                           $.str1; # char* str1
	has Str                           $.str2; # char* str2
	has Str                           $.str3; # char* str3
	has int32                         $.int1; # int int1
	has int32                         $.int2; # int int2
	has Pointer                       $.ctxt; # void* ctxt
	has Pointer                       $.node; # void* node
}

# == /usr/include/libxml2/libxml/parser.h ==

class _xmlParserInput is repr('CStruct') is export {
	has _xmlParserInputBuffer         $.buf; # Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*» buf
	has Str                           $.filename; # const char* filename
	has Str                           $.directory; # const char* directory
	has Pointer[xmlChar]              $.base; # const Typedef<xmlChar>->«unsigned char»* base
	has Pointer[xmlChar]              $.cur; # const Typedef<xmlChar>->«unsigned char»* cur
	has Pointer[xmlChar]              $.end; # const Typedef<xmlChar>->«unsigned char»* end
	has int32                         $.length; # int length
	has int32                         $.line; # int line
	has int32                         $.col; # int col
	has ulong                         $.consumed; # long unsigned int consumed
	has Pointer                       $.free; # Typedef<xmlParserInputDeallocate>->«F:void ( )*» free
	has Pointer[xmlChar]              $.encoding; # const Typedef<xmlChar>->«unsigned char»* encoding
	has Pointer[xmlChar]              $.version; # const Typedef<xmlChar>->«unsigned char»* version
	has int32                         $.standalone; # int standalone
	has int32                         $.id; # int id
}
class _xmlParserNodeInfo is repr('CStruct') is export {
	has _xmlNode                      $.node; # const _xmlNode* node
	has ulong                         $.begin_pos; # long unsigned int begin_pos
	has ulong                         $.begin_line; # long unsigned int begin_line
	has ulong                         $.end_pos; # long unsigned int end_pos
	has ulong                         $.end_line; # long unsigned int end_line
}
class _xmlParserNodeInfoSeq is repr('CStruct') is export {
	has ulong                         $.maximum; # long unsigned int maximum
	has ulong                         $.length; # long unsigned int length
	has _xmlParserNodeInfo            $.buffer; # Typedef<xmlParserNodeInfo>->«_xmlParserNodeInfo»* buffer
}
class _xmlParserCtxt is repr('CStruct') is export {
	has _xmlSAXHandler                $.sax; # _xmlSAXHandler* sax
	has Pointer                       $.userData; # void* userData
	has _xmlDoc                       $.myDoc; # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*» myDoc
	has int32                         $.wellFormed; # int wellFormed
	has int32                         $.replaceEntities; # int replaceEntities
	has Pointer[xmlChar]              $.version; # const Typedef<xmlChar>->«unsigned char»* version
	has Pointer[xmlChar]              $.encoding; # const Typedef<xmlChar>->«unsigned char»* encoding
	has int32                         $.standalone; # int standalone
	has int32                         $.html; # int html
	has _xmlParserInput               $.input; # Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*» input
	has int32                         $.inputNr; # int inputNr
	has int32                         $.inputMax; # int inputMax
	has Pointer[_xmlParserInput]      $.inputTab; # Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*»* inputTab
	has _xmlNode                      $.node; # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*» node
	has int32                         $.nodeNr; # int nodeNr
	has int32                         $.nodeMax; # int nodeMax
	has Pointer[_xmlNode]             $.nodeTab; # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»* nodeTab
	has int32                         $.record_info; # int record_info
	has _xmlParserNodeInfoSeq         $.node_seq; # Typedef<xmlParserNodeInfoSeq>->«_xmlParserNodeInfoSeq» node_seq
	has int32                         $.errNo; # int errNo
	has int32                         $.hasExternalSubset; # int hasExternalSubset
	has int32                         $.hasPErefs; # int hasPErefs
	has int32                         $.external; # int external
	has int32                         $.valid; # int valid
	has int32                         $.validate; # int validate
	has _xmlValidCtxt                 $.vctxt; # Typedef<xmlValidCtxt>->«_xmlValidCtxt» vctxt
	has int32                         $.instate; # Typedef<xmlParserInputState>->«xmlParserInputState» instate
	has int32                         $.token; # int token
	has Str                           $.directory; # char* directory
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has int32                         $.nameNr; # int nameNr
	has int32                         $.nameMax; # int nameMax
	has Pointer[Pointer[xmlChar]]     $.nameTab; # const Typedef<xmlChar>->«unsigned char»** nameTab
	has long                          $.nbChars; # long int nbChars
	has long                          $.checkIndex; # long int checkIndex
	has int32                         $.keepBlanks; # int keepBlanks
	has int32                         $.disableSAX; # int disableSAX
	has int32                         $.inSubset; # int inSubset
	has Pointer[xmlChar]              $.intSubName; # const Typedef<xmlChar>->«unsigned char»* intSubName
	has Pointer[xmlChar]              $.extSubURI; # Typedef<xmlChar>->«unsigned char»* extSubURI
	has Pointer[xmlChar]              $.extSubSystem; # Typedef<xmlChar>->«unsigned char»* extSubSystem
	has Pointer[int32]                $.space; # int* space
	has int32                         $.spaceNr; # int spaceNr
	has int32                         $.spaceMax; # int spaceMax
	has Pointer[int32]                $.spaceTab; # int* spaceTab
	has int32                         $.depth; # int depth
	has _xmlParserInput               $.entity; # Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*» entity
	has int32                         $.charset; # int charset
	has int32                         $.nodelen; # int nodelen
	has int32                         $.nodemem; # int nodemem
	has int32                         $.pedantic; # int pedantic
	has Pointer                       $._private; # void* _private
	has int32                         $.loadsubset; # int loadsubset
	has int32                         $.linenumbers; # int linenumbers
	has Pointer                       $.catalogs; # void* catalogs
	has int32                         $.recovery; # int recovery
	has int32                         $.progressive; # int progressive
	has _xmlDict                      $.dict; # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*» dict
	has Pointer[Pointer[xmlChar]]     $.atts; # const Typedef<xmlChar>->«unsigned char»** atts
	has int32                         $.maxatts; # int maxatts
	has int32                         $.docdict; # int docdict
	has Pointer[xmlChar]              $.str_xml; # const Typedef<xmlChar>->«unsigned char»* str_xml
	has Pointer[xmlChar]              $.str_xmlns; # const Typedef<xmlChar>->«unsigned char»* str_xmlns
	has Pointer[xmlChar]              $.str_xml_ns; # const Typedef<xmlChar>->«unsigned char»* str_xml_ns
	has int32                         $.sax2; # int sax2
	has int32                         $.nsNr; # int nsNr
	has int32                         $.nsMax; # int nsMax
	has Pointer[Pointer[xmlChar]]     $.nsTab; # const Typedef<xmlChar>->«unsigned char»** nsTab
	has Pointer[int32]                $.attallocs; # int* attallocs
	has Pointer[Pointer]              $.pushTab; # void** pushTab
	has _xmlHashTable                 $.attsDefault; # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*» attsDefault
	has _xmlHashTable                 $.attsSpecial; # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*» attsSpecial
	has int32                         $.nsWellFormed; # int nsWellFormed
	has int32                         $.options; # int options
	has int32                         $.dictNames; # int dictNames
	has int32                         $.freeElemsNr; # int freeElemsNr
	has _xmlNode                      $.freeElems; # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*» freeElems
	has int32                         $.freeAttrsNr; # int freeAttrsNr
	has _xmlAttr                      $.freeAttrs; # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*» freeAttrs
	has _xmlError                     $.lastError; # Typedef<xmlError>->«_xmlError» lastError
	has int32                         $.parseMode; # Typedef<xmlParserMode>->«xmlParserMode» parseMode
	has ulong                         $.nbentities; # long unsigned int nbentities
	has ulong                         $.sizeentities; # long unsigned int sizeentities
	has _xmlParserNodeInfo            $.nodeInfo; # Typedef<xmlParserNodeInfo>->«_xmlParserNodeInfo»* nodeInfo
	has int32                         $.nodeInfoNr; # int nodeInfoNr
	has int32                         $.nodeInfoMax; # int nodeInfoMax
	has _xmlParserNodeInfo            $.nodeInfoTab; # Typedef<xmlParserNodeInfo>->«_xmlParserNodeInfo»* nodeInfoTab
	has int32                         $.input_id; # int input_id
	has ulong                         $.sizeentcopy; # long unsigned int sizeentcopy
}
class _xmlSAXLocator is repr('CStruct') is export {
	has Pointer                       $.getPublicId; # F:const Typedef<xmlChar>->«unsigned char»* ( )* getPublicId
	has Pointer                       $.getSystemId; # F:const Typedef<xmlChar>->«unsigned char»* ( )* getSystemId
	has Pointer                       $.getLineNumber; # F:int ( )* getLineNumber
	has Pointer                       $.getColumnNumber; # F:int ( )* getColumnNumber
}
class _xmlSAXHandler is repr('CStruct') is export {
	has Pointer                       $.internalSubset; # Typedef<internalSubsetSAXFunc>->«F:void ( )*» internalSubset
	has Pointer                       $.isStandalone; # Typedef<isStandaloneSAXFunc>->«F:int ( )*» isStandalone
	has Pointer                       $.hasInternalSubset; # Typedef<hasInternalSubsetSAXFunc>->«F:int ( )*» hasInternalSubset
	has Pointer                       $.hasExternalSubset; # Typedef<hasExternalSubsetSAXFunc>->«F:int ( )*» hasExternalSubset
	has Pointer                       $.resolveEntity; # Typedef<resolveEntitySAXFunc>->«F:Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*» ( )*» resolveEntity
	has Pointer                       $.getEntity; # Typedef<getEntitySAXFunc>->«F:Typedef<xmlEntityPtr>->«Typedef<xmlEntity>->«_xmlEntity»*» ( )*» getEntity
	has Pointer                       $.entityDecl; # Typedef<entityDeclSAXFunc>->«F:void ( )*» entityDecl
	has Pointer                       $.notationDecl; # Typedef<notationDeclSAXFunc>->«F:void ( )*» notationDecl
	has Pointer                       $.attributeDecl; # Typedef<attributeDeclSAXFunc>->«F:void ( )*» attributeDecl
	has Pointer                       $.elementDecl; # Typedef<elementDeclSAXFunc>->«F:void ( )*» elementDecl
	has Pointer                       $.unparsedEntityDecl; # Typedef<unparsedEntityDeclSAXFunc>->«F:void ( )*» unparsedEntityDecl
	has Pointer                       $.setDocumentLocator; # Typedef<setDocumentLocatorSAXFunc>->«F:void ( )*» setDocumentLocator
	has Pointer                       $.startDocument; # Typedef<startDocumentSAXFunc>->«F:void ( )*» startDocument
	has Pointer                       $.endDocument; # Typedef<endDocumentSAXFunc>->«F:void ( )*» endDocument
	has Pointer                       $.startElement; # Typedef<startElementSAXFunc>->«F:void ( )*» startElement
	has Pointer                       $.endElement; # Typedef<endElementSAXFunc>->«F:void ( )*» endElement
	has Pointer                       $.reference; # Typedef<referenceSAXFunc>->«F:void ( )*» reference
	has Pointer                       $.characters; # Typedef<charactersSAXFunc>->«F:void ( )*» characters
	has Pointer                       $.ignorableWhitespace; # Typedef<ignorableWhitespaceSAXFunc>->«F:void ( )*» ignorableWhitespace
	has Pointer                       $.processingInstruction; # Typedef<processingInstructionSAXFunc>->«F:void ( )*» processingInstruction
	has Pointer                       $.comment; # Typedef<commentSAXFunc>->«F:void ( )*» comment
	has Pointer                       $.warning; # Typedef<warningSAXFunc>->«F:void ( )*» warning
	has Pointer                       $.error; # Typedef<errorSAXFunc>->«F:void ( )*» error
	has Pointer                       $.fatalError; # Typedef<fatalErrorSAXFunc>->«F:void ( )*» fatalError
	has Pointer                       $.getParameterEntity; # Typedef<getParameterEntitySAXFunc>->«F:Typedef<xmlEntityPtr>->«Typedef<xmlEntity>->«_xmlEntity»*» ( )*» getParameterEntity
	has Pointer                       $.cdataBlock; # Typedef<cdataBlockSAXFunc>->«F:void ( )*» cdataBlock
	has Pointer                       $.externalSubset; # Typedef<externalSubsetSAXFunc>->«F:void ( )*» externalSubset
	has uint32                        $.initialized; # unsigned int initialized
	has Pointer                       $._private; # void* _private
	has Pointer                       $.startElementNs; # Typedef<startElementNsSAX2Func>->«F:void ( )*» startElementNs
	has Pointer                       $.endElementNs; # Typedef<endElementNsSAX2Func>->«F:void ( )*» endElementNs
	has Pointer                       $.serror; # Typedef<xmlStructuredErrorFunc>->«F:void ( )*» serror
}
class _xmlSAXHandlerV1 is repr('CStruct') is export {
	has Pointer                       $.internalSubset; # Typedef<internalSubsetSAXFunc>->«F:void ( )*» internalSubset
	has Pointer                       $.isStandalone; # Typedef<isStandaloneSAXFunc>->«F:int ( )*» isStandalone
	has Pointer                       $.hasInternalSubset; # Typedef<hasInternalSubsetSAXFunc>->«F:int ( )*» hasInternalSubset
	has Pointer                       $.hasExternalSubset; # Typedef<hasExternalSubsetSAXFunc>->«F:int ( )*» hasExternalSubset
	has Pointer                       $.resolveEntity; # Typedef<resolveEntitySAXFunc>->«F:Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*» ( )*» resolveEntity
	has Pointer                       $.getEntity; # Typedef<getEntitySAXFunc>->«F:Typedef<xmlEntityPtr>->«Typedef<xmlEntity>->«_xmlEntity»*» ( )*» getEntity
	has Pointer                       $.entityDecl; # Typedef<entityDeclSAXFunc>->«F:void ( )*» entityDecl
	has Pointer                       $.notationDecl; # Typedef<notationDeclSAXFunc>->«F:void ( )*» notationDecl
	has Pointer                       $.attributeDecl; # Typedef<attributeDeclSAXFunc>->«F:void ( )*» attributeDecl
	has Pointer                       $.elementDecl; # Typedef<elementDeclSAXFunc>->«F:void ( )*» elementDecl
	has Pointer                       $.unparsedEntityDecl; # Typedef<unparsedEntityDeclSAXFunc>->«F:void ( )*» unparsedEntityDecl
	has Pointer                       $.setDocumentLocator; # Typedef<setDocumentLocatorSAXFunc>->«F:void ( )*» setDocumentLocator
	has Pointer                       $.startDocument; # Typedef<startDocumentSAXFunc>->«F:void ( )*» startDocument
	has Pointer                       $.endDocument; # Typedef<endDocumentSAXFunc>->«F:void ( )*» endDocument
	has Pointer                       $.startElement; # Typedef<startElementSAXFunc>->«F:void ( )*» startElement
	has Pointer                       $.endElement; # Typedef<endElementSAXFunc>->«F:void ( )*» endElement
	has Pointer                       $.reference; # Typedef<referenceSAXFunc>->«F:void ( )*» reference
	has Pointer                       $.characters; # Typedef<charactersSAXFunc>->«F:void ( )*» characters
	has Pointer                       $.ignorableWhitespace; # Typedef<ignorableWhitespaceSAXFunc>->«F:void ( )*» ignorableWhitespace
	has Pointer                       $.processingInstruction; # Typedef<processingInstructionSAXFunc>->«F:void ( )*» processingInstruction
	has Pointer                       $.comment; # Typedef<commentSAXFunc>->«F:void ( )*» comment
	has Pointer                       $.warning; # Typedef<warningSAXFunc>->«F:void ( )*» warning
	has Pointer                       $.error; # Typedef<errorSAXFunc>->«F:void ( )*» error
	has Pointer                       $.fatalError; # Typedef<fatalErrorSAXFunc>->«F:void ( )*» fatalError
	has Pointer                       $.getParameterEntity; # Typedef<getParameterEntitySAXFunc>->«F:Typedef<xmlEntityPtr>->«Typedef<xmlEntity>->«_xmlEntity»*» ( )*» getParameterEntity
	has Pointer                       $.cdataBlock; # Typedef<cdataBlockSAXFunc>->«F:void ( )*» cdataBlock
	has Pointer                       $.externalSubset; # Typedef<externalSubsetSAXFunc>->«F:void ( )*» externalSubset
	has uint32                        $.initialized; # unsigned int initialized
}

# == /usr/include/libxml2/libxml/xmlautomata.h ==

class _xmlAutomata is repr('CStruct') is export {
}
class _xmlAutomataState is repr('CStruct') is export {
}

# == /usr/include/unicode/ucnv_err.h ==

class UConverter is repr('CStruct') is export {
}

# == /usr/include/libxml2/libxml/xmlregexp.h ==

class _xmlRegexp is repr('CStruct') is export {
}
class _xmlRegExecCtxt is repr('CStruct') is export {
}
class _xmlExpCtxt is repr('CStruct') is export {
}
class _xmlExpNode is repr('CStruct') is export {
}

# == /usr/include/libxml2/libxml/globals.h ==

class _xmlGlobalState is repr('CStruct') is export {
	has Str                           $.xmlParserVersion; # const char* xmlParserVersion
	has _xmlSAXLocator                $.xmlDefaultSAXLocator; # Typedef<xmlSAXLocator>->«_xmlSAXLocator» xmlDefaultSAXLocator
	has _xmlSAXHandlerV1              $.xmlDefaultSAXHandler; # Typedef<xmlSAXHandlerV1>->«_xmlSAXHandlerV1» xmlDefaultSAXHandler
	has _xmlSAXHandlerV1              $.docbDefaultSAXHandler; # Typedef<xmlSAXHandlerV1>->«_xmlSAXHandlerV1» docbDefaultSAXHandler
	has _xmlSAXHandlerV1              $.htmlDefaultSAXHandler; # Typedef<xmlSAXHandlerV1>->«_xmlSAXHandlerV1» htmlDefaultSAXHandler
	has Pointer                       $.xmlFree; # Typedef<xmlFreeFunc>->«F:void ( )*» xmlFree
	has Pointer                       $.xmlMalloc; # Typedef<xmlMallocFunc>->«F:void* ( )*» xmlMalloc
	has Pointer                       $.xmlMemStrdup; # Typedef<xmlStrdupFunc>->«F:char* ( )*» xmlMemStrdup
	has Pointer                       $.xmlRealloc; # Typedef<xmlReallocFunc>->«F:void* ( )*» xmlRealloc
	has Pointer                       $.xmlGenericError; # Typedef<xmlGenericErrorFunc>->«F:void ( )*» xmlGenericError
	has Pointer                       $.xmlStructuredError; # Typedef<xmlStructuredErrorFunc>->«F:void ( )*» xmlStructuredError
	has Pointer                       $.xmlGenericErrorContext; # void* xmlGenericErrorContext
	has int32                         $.oldXMLWDcompatibility; # int oldXMLWDcompatibility
	has int32                         $.xmlBufferAllocScheme; # Typedef<xmlBufferAllocationScheme>->«xmlBufferAllocationScheme» xmlBufferAllocScheme
	has int32                         $.xmlDefaultBufferSize; # int xmlDefaultBufferSize
	has int32                         $.xmlSubstituteEntitiesDefaultValue; # int xmlSubstituteEntitiesDefaultValue
	has int32                         $.xmlDoValidityCheckingDefaultValue; # int xmlDoValidityCheckingDefaultValue
	has int32                         $.xmlGetWarningsDefaultValue; # int xmlGetWarningsDefaultValue
	has int32                         $.xmlKeepBlanksDefaultValue; # int xmlKeepBlanksDefaultValue
	has int32                         $.xmlLineNumbersDefaultValue; # int xmlLineNumbersDefaultValue
	has int32                         $.xmlLoadExtDtdDefaultValue; # int xmlLoadExtDtdDefaultValue
	has int32                         $.xmlParserDebugEntities; # int xmlParserDebugEntities
	has int32                         $.xmlPedanticParserDefaultValue; # int xmlPedanticParserDefaultValue
	has int32                         $.xmlSaveNoEmptyTags; # int xmlSaveNoEmptyTags
	has int32                         $.xmlIndentTreeOutput; # int xmlIndentTreeOutput
	has Str                           $.xmlTreeIndentString; # const char* xmlTreeIndentString
	has Pointer                       $.xmlRegisterNodeDefaultValue; # Typedef<xmlRegisterNodeFunc>->«F:void ( )*» xmlRegisterNodeDefaultValue
	has Pointer                       $.xmlDeregisterNodeDefaultValue; # Typedef<xmlDeregisterNodeFunc>->«F:void ( )*» xmlDeregisterNodeDefaultValue
	has Pointer                       $.xmlMallocAtomic; # Typedef<xmlMallocFunc>->«F:void* ( )*» xmlMallocAtomic
	has _xmlError                     $.xmlLastError; # Typedef<xmlError>->«_xmlError» xmlLastError
	has Pointer                       $.xmlParserInputBufferCreateFilenameValue; # Typedef<xmlParserInputBufferCreateFilenameFunc>->«F:Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*» ( )*» xmlParserInputBufferCreateFilenameValue
	has Pointer                       $.xmlOutputBufferCreateFilenameValue; # Typedef<xmlOutputBufferCreateFilenameFunc>->«F:Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*» ( )*» xmlOutputBufferCreateFilenameValue
	has Pointer                       $.xmlStructuredErrorContext; # void* xmlStructuredErrorContext
}

# == /usr/include/_G_config.h ==

class  is repr('CStruct') is export {
	has __off64_t                     $.__pos; # Typedef<__off64_t>->«long int» __pos
	has                               $.__state; # Typedef<__mbstate_t>->«» __state
}

# == /usr/include/unicode/uenum.h ==

class UEnumeration is repr('CStruct') is export {
}

# == /usr/include/libxml2/libxml/valid.h ==

class _xmlValidState is repr('CStruct') is export {
}
class _xmlValidCtxt is repr('CStruct') is export {
	has Pointer                       $.userData; # void* userData
	has Pointer                       $.error; # Typedef<xmlValidityErrorFunc>->«F:void ( )*» error
	has Pointer                       $.warning; # Typedef<xmlValidityWarningFunc>->«F:void ( )*» warning
	has _xmlNode                      $.node; # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*» node
	has int32                         $.nodeNr; # int nodeNr
	has int32                         $.nodeMax; # int nodeMax
	has Pointer[_xmlNode]             $.nodeTab; # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»* nodeTab
	has uint32                        $.finishDtd; # unsigned int finishDtd
	has _xmlDoc                       $.doc; # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*» doc
	has int32                         $.valid; # int valid
	has _xmlValidState                $.vstate; # Typedef<xmlValidState>->«_xmlValidState»* vstate
	has int32                         $.vstateNr; # int vstateNr
	has int32                         $.vstateMax; # int vstateMax
	has _xmlValidState                $.vstateTab; # Typedef<xmlValidState>->«_xmlValidState»* vstateTab
	has _xmlAutomata                  $.am; # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*» am
	has _xmlAutomataState             $.state; # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*» state
}

# == /usr/include/libxml2/libxml/dict.h ==

class _xmlDict is repr('CStruct') is export {
}

# == /usr/include/libxml2/libxml/xmlIO.h ==

class _xmlParserInputBuffer is repr('CStruct') is export {
	has Pointer                       $.context; # void* context
	has Pointer                       $.readcallback; # Typedef<xmlInputReadCallback>->«F:int ( )*» readcallback
	has Pointer                       $.closecallback; # Typedef<xmlInputCloseCallback>->«F:int ( )*» closecallback
	has _xmlCharEncodingHandler       $.encoder; # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*» encoder
	has _xmlBuf                       $.buffer; # Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*» buffer
	has _xmlBuf                       $.raw; # Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*» raw
	has int32                         $.compressed; # int compressed
	has int32                         $.error; # int error
	has ulong                         $.rawconsumed; # long unsigned int rawconsumed
}
class _xmlOutputBuffer is repr('CStruct') is export {
	has Pointer                       $.context; # void* context
	has Pointer                       $.writecallback; # Typedef<xmlOutputWriteCallback>->«F:int ( )*» writecallback
	has Pointer                       $.closecallback; # Typedef<xmlOutputCloseCallback>->«F:int ( )*» closecallback
	has _xmlCharEncodingHandler       $.encoder; # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*» encoder
	has _xmlBuf                       $.buffer; # Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*» buffer
	has _xmlBuf                       $.conv; # Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*» conv
	has int32                         $.written; # int written
	has int32                         $.error; # int error
}

# == /usr/include/libxml2/libxml/tree.h ==

class _xmlBuffer is repr('CStruct') is export {
	has Pointer[xmlChar]              $.content; # Typedef<xmlChar>->«unsigned char»* content
	has uint32                        $.use; # unsigned int use
	has uint32                        $.size; # unsigned int size
	has int32                         $.alloc; # Typedef<xmlBufferAllocationScheme>->«xmlBufferAllocationScheme» alloc
	has Pointer[xmlChar]              $.contentIO; # Typedef<xmlChar>->«unsigned char»* contentIO
}
class _xmlBuf is repr('CStruct') is export {
}
class _xmlNotation is repr('CStruct') is export {
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has Pointer[xmlChar]              $.PublicID; # const Typedef<xmlChar>->«unsigned char»* PublicID
	has Pointer[xmlChar]              $.SystemID; # const Typedef<xmlChar>->«unsigned char»* SystemID
}
class _xmlEnumeration is repr('CStruct') is export {
	has _xmlEnumeration               $.next; # _xmlEnumeration* next
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
}
class _xmlAttribute is repr('CStruct') is export {
	has Pointer                       $._private; # void* _private
	has int32                         $.type; # Typedef<xmlElementType>->«xmlElementType» type
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has _xmlNode                      $.children; # _xmlNode* children
	has _xmlNode                      $.last; # _xmlNode* last
	has _xmlDtd                       $.parent; # _xmlDtd* parent
	has _xmlNode                      $.next; # _xmlNode* next
	has _xmlNode                      $.prev; # _xmlNode* prev
	has _xmlDoc                       $.doc; # _xmlDoc* doc
	has _xmlAttribute                 $.nexth; # _xmlAttribute* nexth
	has int32                         $.atype; # Typedef<xmlAttributeType>->«xmlAttributeType» atype
	has int32                         $.def; # Typedef<xmlAttributeDefault>->«xmlAttributeDefault» def
	has Pointer[xmlChar]              $.defaultValue; # const Typedef<xmlChar>->«unsigned char»* defaultValue
	has _xmlEnumeration               $.tree; # Typedef<xmlEnumerationPtr>->«Typedef<xmlEnumeration>->«_xmlEnumeration»*» tree
	has Pointer[xmlChar]              $.prefix; # const Typedef<xmlChar>->«unsigned char»* prefix
	has Pointer[xmlChar]              $.elem; # const Typedef<xmlChar>->«unsigned char»* elem
}
class _xmlElementContent is repr('CStruct') is export {
	has int32                         $.type; # Typedef<xmlElementContentType>->«xmlElementContentType» type
	has int32                         $.ocur; # Typedef<xmlElementContentOccur>->«xmlElementContentOccur» ocur
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has _xmlElementContent            $.c1; # _xmlElementContent* c1
	has _xmlElementContent            $.c2; # _xmlElementContent* c2
	has _xmlElementContent            $.parent; # _xmlElementContent* parent
	has Pointer[xmlChar]              $.prefix; # const Typedef<xmlChar>->«unsigned char»* prefix
}
class _xmlElement is repr('CStruct') is export {
	has Pointer                       $._private; # void* _private
	has int32                         $.type; # Typedef<xmlElementType>->«xmlElementType» type
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has _xmlNode                      $.children; # _xmlNode* children
	has _xmlNode                      $.last; # _xmlNode* last
	has _xmlDtd                       $.parent; # _xmlDtd* parent
	has _xmlNode                      $.next; # _xmlNode* next
	has _xmlNode                      $.prev; # _xmlNode* prev
	has _xmlDoc                       $.doc; # _xmlDoc* doc
	has int32                         $.etype; # Typedef<xmlElementTypeVal>->«xmlElementTypeVal» etype
	has _xmlElementContent            $.content; # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*» content
	has _xmlAttribute                 $.attributes; # Typedef<xmlAttributePtr>->«Typedef<xmlAttribute>->«_xmlAttribute»*» attributes
	has Pointer[xmlChar]              $.prefix; # const Typedef<xmlChar>->«unsigned char»* prefix
	has _xmlRegexp                    $.contModel; # Typedef<xmlRegexpPtr>->«Typedef<xmlRegexp>->«_xmlRegexp»*» contModel
}
class _xmlNs is repr('CStruct') is export {
	has _xmlNs                        $.next; # _xmlNs* next
	has int32                         $.type; # Typedef<xmlNsType>->«Typedef<xmlElementType>->«xmlElementType»» type
	has Pointer[xmlChar]              $.href; # const Typedef<xmlChar>->«unsigned char»* href
	has Pointer[xmlChar]              $.prefix; # const Typedef<xmlChar>->«unsigned char»* prefix
	has Pointer                       $._private; # void* _private
	has _xmlDoc                       $.context; # _xmlDoc* context
}
class _xmlDtd is repr('CStruct') is export {
	has Pointer                       $._private; # void* _private
	has int32                         $.type; # Typedef<xmlElementType>->«xmlElementType» type
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has _xmlNode                      $.children; # _xmlNode* children
	has _xmlNode                      $.last; # _xmlNode* last
	has _xmlDoc                       $.parent; # _xmlDoc* parent
	has _xmlNode                      $.next; # _xmlNode* next
	has _xmlNode                      $.prev; # _xmlNode* prev
	has _xmlDoc                       $.doc; # _xmlDoc* doc
	has Pointer                       $.notations; # void* notations
	has Pointer                       $.elements; # void* elements
	has Pointer                       $.attributes; # void* attributes
	has Pointer                       $.entities; # void* entities
	has Pointer[xmlChar]              $.ExternalID; # const Typedef<xmlChar>->«unsigned char»* ExternalID
	has Pointer[xmlChar]              $.SystemID; # const Typedef<xmlChar>->«unsigned char»* SystemID
	has Pointer                       $.pentities; # void* pentities
}
class _xmlAttr is repr('CStruct') is export {
	has Pointer                       $._private; # void* _private
	has int32                         $.type; # Typedef<xmlElementType>->«xmlElementType» type
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has _xmlNode                      $.children; # _xmlNode* children
	has _xmlNode                      $.last; # _xmlNode* last
	has _xmlNode                      $.parent; # _xmlNode* parent
	has _xmlAttr                      $.next; # _xmlAttr* next
	has _xmlAttr                      $.prev; # _xmlAttr* prev
	has _xmlDoc                       $.doc; # _xmlDoc* doc
	has _xmlNs                        $.ns; # Typedef<xmlNs>->«_xmlNs»* ns
	has int32                         $.atype; # Typedef<xmlAttributeType>->«xmlAttributeType» atype
	has Pointer                       $.psvi; # void* psvi
}
class _xmlID is repr('CStruct') is export {
	has _xmlID                        $.next; # _xmlID* next
	has Pointer[xmlChar]              $.value; # const Typedef<xmlChar>->«unsigned char»* value
	has _xmlAttr                      $.attr; # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*» attr
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has int32                         $.lineno; # int lineno
	has _xmlDoc                       $.doc; # _xmlDoc* doc
}
class _xmlRef is repr('CStruct') is export {
	has _xmlRef                       $.next; # _xmlRef* next
	has Pointer[xmlChar]              $.value; # const Typedef<xmlChar>->«unsigned char»* value
	has _xmlAttr                      $.attr; # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*» attr
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has int32                         $.lineno; # int lineno
}
class _xmlNode is repr('CStruct') is export {
	has Pointer                       $._private; # void* _private
	has int32                         $.type; # Typedef<xmlElementType>->«xmlElementType» type
	has Pointer[xmlChar]              $.name; # const Typedef<xmlChar>->«unsigned char»* name
	has _xmlNode                      $.children; # _xmlNode* children
	has _xmlNode                      $.last; # _xmlNode* last
	has _xmlNode                      $.parent; # _xmlNode* parent
	has _xmlNode                      $.next; # _xmlNode* next
	has _xmlNode                      $.prev; # _xmlNode* prev
	has _xmlDoc                       $.doc; # _xmlDoc* doc
	has _xmlNs                        $.ns; # Typedef<xmlNs>->«_xmlNs»* ns
	has Pointer[xmlChar]              $.content; # Typedef<xmlChar>->«unsigned char»* content
	has _xmlAttr                      $.properties; # _xmlAttr* properties
	has _xmlNs                        $.nsDef; # Typedef<xmlNs>->«_xmlNs»* nsDef
	has Pointer                       $.psvi; # void* psvi
	has uint16                        $.line; # short unsigned int line
	has uint16                        $.extra; # short unsigned int extra
}
class _xmlDoc is repr('CStruct') is export {
	has Pointer                       $._private; # void* _private
	has int32                         $.type; # Typedef<xmlElementType>->«xmlElementType» type
	has Str                           $.name; # char* name
	has _xmlNode                      $.children; # _xmlNode* children
	has _xmlNode                      $.last; # _xmlNode* last
	has _xmlNode                      $.parent; # _xmlNode* parent
	has _xmlNode                      $.next; # _xmlNode* next
	has _xmlNode                      $.prev; # _xmlNode* prev
	has _xmlDoc                       $.doc; # _xmlDoc* doc
	has int32                         $.compression; # int compression
	has int32                         $.standalone; # int standalone
	has _xmlDtd                       $.intSubset; # _xmlDtd* intSubset
	has _xmlDtd                       $.extSubset; # _xmlDtd* extSubset
	has _xmlNs                        $.oldNs; # _xmlNs* oldNs
	has Pointer[xmlChar]              $.version; # const Typedef<xmlChar>->«unsigned char»* version
	has Pointer[xmlChar]              $.encoding; # const Typedef<xmlChar>->«unsigned char»* encoding
	has Pointer                       $.ids; # void* ids
	has Pointer                       $.refs; # void* refs
	has Pointer[xmlChar]              $.URL; # const Typedef<xmlChar>->«unsigned char»* URL
	has int32                         $.charset; # int charset
	has _xmlDict                      $.dict; # _xmlDict* dict
	has Pointer                       $.psvi; # void* psvi
	has int32                         $.parseFlags; # int parseFlags
	has int32                         $.properties; # int properties
}
class _xmlDOMWrapCtxt is repr('CStruct') is export {
	has Pointer                       $._private; # void* _private
	has int32                         $.type; # int type
	has Pointer                       $.namespaceMap; # void* namespaceMap
	has Pointer                       $.getNsForNodeFunc; # Typedef<xmlDOMWrapAcquireNsFunction>->«F:Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*» ( )*» getNsForNodeFunc
}

# == /usr/include/libxml2/libxml/xlink.h ==

class _xlinkHandler is repr('CStruct') is export {
	has Pointer                       $.simple; # Typedef<xlinkSimpleLinkFunk>->«F:void ( )*» simple
	has Pointer                       $.extended; # Typedef<xlinkExtendedLinkFunk>->«F:void ( )*» extended
	has Pointer                       $.set; # Typedef<xlinkExtendedLinkSetFunk>->«F:void ( )*» set
}

# == /usr/include/unicode/ucnv.h ==

class USet is repr('CStruct') is export {
}

# == HTMLparser.h ==

class _htmlElemDesc is repr('CStruct') is export {
	has Str                           $.name; # const char* name
	has int8                          $.startTag; # char startTag
	has int8                          $.endTag; # char endTag
	has int8                          $.saveEndTag; # char saveEndTag
	has int8                          $.empty; # char empty
	has int8                          $.depr; # char depr
	has int8                          $.dtd; # char dtd
	has int8                          $.isinline; # char isinline
	has Str                           $.desc; # const char* desc
	has Pointer[Str]                  $.subelts; # const char** subelts
	has Str                           $.defaultsubelt; # const char* defaultsubelt
	has Pointer[Str]                  $.attrs_opt; # const char** attrs_opt
	has Pointer[Str]                  $.attrs_depr; # const char** attrs_depr
	has Pointer[Str]                  $.attrs_req; # const char** attrs_req
}
class _htmlEntityDesc is repr('CStruct') is export {
	has uint32                        $.value; # unsigned int value
	has Str                           $.name; # const char* name
	has Str                           $.desc; # const char* desc
}

# == /usr/include/libxml2/libxml/hash.h ==

class _xmlHashTable is repr('CStruct') is export {
}

# == /usr/include/libxml2/libxml/list.h ==

class _xmlLink is repr('CStruct') is export {
}
class _xmlList is repr('CStruct') is export {
}

# == /usr/include/libxml2/libxml/threads.h ==

class _xmlMutex is repr('CStruct') is export {
}
class _xmlRMutex is repr('CStruct') is export {
}

# == /usr/include/libxml2/libxml/encoding.h ==

class _uconv_t is repr('CStruct') is export {
	has UConverter                    $.uconv; # Typedef<UConverter>->«UConverter»* uconv
	has UConverter                    $.utf8; # Typedef<UConverter>->«UConverter»* utf8
}
class _xmlCharEncodingHandler is repr('CStruct') is export {
	has Str                           $.name; # char* name
	has Pointer                       $.input; # Typedef<xmlCharEncodingInputFunc>->«F:int ( )*» input
	has Pointer                       $.output; # Typedef<xmlCharEncodingOutputFunc>->«F:int ( )*» output
	has Pointer                       $.iconv_in; # Typedef<iconv_t>->«void*» iconv_in
	has Pointer                       $.iconv_out; # Typedef<iconv_t>->«void*» iconv_out
	has _uconv_t                      $.uconv_in; # Typedef<uconv_t>->«_uconv_t»* uconv_in
	has _uconv_t                      $.uconv_out; # Typedef<uconv_t>->«_uconv_t»* uconv_out
}
## Extras stuff

constant xmlRef is export := _xmlRef;
constant xmlRefTable is export := _xmlHashTable;
constant __mbstate_t is export := ;
constant xmlExpNode is export := _xmlExpNode;
constant div_t is export := ;
constant htmlEntityDesc is export := _htmlEntityDesc;
constant _G_fpos64_t is export := ;
constant xmlSAXHandlerV1 is export := _xmlSAXHandlerV1;
constant xmlDict is export := _xmlDict;
constant xmlOutputBuffer is export := _xmlOutputBuffer;
constant xmlNotation is export := _xmlNotation;
constant xmlParserCtxt is export := _xmlParserCtxt;
constant FILE is export := _IO_FILE;
constant xmlID is export := _xmlID;
constant xmlAutomata is export := _xmlAutomata;
constant xmlSAXHandler is export := _xmlSAXHandler;
constant htmlElemDesc is export := _htmlElemDesc;
constant xmlError is export := _xmlError;
constant xmlRegExecCtxt is export := _xmlRegExecCtxt;
constant xmlEntity is export := _xmlEntity;
constant xmlParserNodeInfo is export := _xmlParserNodeInfo;
constant UEnumeration is export := UEnumeration;
constant xmlNotationTable is export := _xmlHashTable;
constant xmlNs is export := _xmlNs;
constant xmlBuf is export := _xmlBuf;
constant UConverterFromUnicodeArgs is export := ;
constant uconv_t is export := _uconv_t;
constant xmlDoc is export := _xmlDoc;
constant xmlAttr is export := _xmlAttr;
constant xmlMutex is export := _xmlMutex;
constant xmlBuffer is export := _xmlBuffer;
constant UConverterToUnicodeArgs is export := ;
constant xmlElement is export := _xmlElement;
constant xlinkHandler is export := _xlinkHandler;
constant xmlIDTable is export := _xmlHashTable;
constant _G_fpos_t is export := ;
constant xmlAutomataState is export := _xmlAutomataState;
constant xmlEntitiesTable is export := _xmlHashTable;
constant ldiv_t is export := ;
constant xmlParserInput is export := _xmlParserInput;
constant UConverter is export := UConverter;
constant xmlValidCtxt is export := _xmlValidCtxt;
constant xmlRegexp is export := _xmlRegexp;
constant xmlElementTable is export := _xmlHashTable;
constant xmlElementContent is export := _xmlElementContent;
constant xmlGlobalState is export := _xmlGlobalState;
constant xmlRMutex is export := _xmlRMutex;
constant xmlList is export := _xmlList;
constant xmlParserNodeInfoSeq is export := _xmlParserNodeInfoSeq;
constant xmlDOMWrapCtxt is export := _xmlDOMWrapCtxt;
constant xmlAttributeTable is export := _xmlHashTable;
constant _IO_FILE is export := _IO_FILE;
constant xmlDtd is export := _xmlDtd;
constant _IO_lock_tPtr is export = Pointer;
constant xmlExpCtxt is export := _xmlExpCtxt;
constant xmlCharEncodingHandler is export := _xmlCharEncodingHandler;
constant xmlParserInputBuffer is export := _xmlParserInputBuffer;
constant xmlSAXLocator is export := _xmlSAXLocator;
constant __fsid_t is export := ;
constant xmlNode is export := _xmlNode;
constant xmlAttribute is export := _xmlAttribute;
constant xmlEnumeration is export := _xmlEnumeration;
constant xmlHashTable is export := _xmlHashTable;
constant xmlLink is export := _xmlLink;
constant xmlValidState is export := _xmlValidState;
constant __FILE is export := _IO_FILE;
constant USet is export := USet;
## Functions


# == /usr/include/libxml2/libxml/xmlerror.h ==

#-From /usr/include/libxml2/libxml/xmlerror.h:863
#/*
# * Use the following function to reset the two global variables
# * xmlGenericError and xmlGenericErrorContext.
# */
#XMLPUBFUN void XMLCALL
#    xmlSetGenericErrorFunc	(void *ctx,
sub xmlSetGenericErrorFunc(Pointer                       $ctx # void*
                          ,&handler () # Typedef<xmlGenericErrorFunc>->«F:void ( )*»
                           ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:866
#XMLPUBFUN void XMLCALL
#    initGenericErrorDefaultFunc	(xmlGenericErrorFunc *handler);
sub initGenericErrorDefaultFunc(Pointer[()] $handler # Typedef<xmlGenericErrorFunc>->«F:void ( )*»*
                                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:869
#XMLPUBFUN void XMLCALL
#    xmlSetStructuredErrorFunc	(void *ctx,
sub xmlSetStructuredErrorFunc(Pointer                       $ctx # void*
                             ,&handler () # Typedef<xmlStructuredErrorFunc>->«F:void ( )*»
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:876
#/*
# * Default message routines used by SAX and Valid context for error
# * and warning reporting.
# */
#XMLPUBFUN void XMLCDECL
#    xmlParserError		(void *ctx,
sub xmlParserError(Pointer                       $ctx # void*
                  ,Str                           $msg # const char*
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:880
#XMLPUBFUN void XMLCDECL
#    xmlParserWarning		(void *ctx,
sub xmlParserWarning(Pointer                       $ctx # void*
                    ,Str                           $msg # const char*
                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:884
#XMLPUBFUN void XMLCDECL
#    xmlParserValidityError	(void *ctx,
sub xmlParserValidityError(Pointer                       $ctx # void*
                          ,Str                           $msg # const char*
                           ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:888
#XMLPUBFUN void XMLCDECL
#    xmlParserValidityWarning	(void *ctx,
sub xmlParserValidityWarning(Pointer                       $ctx # void*
                            ,Str                           $msg # const char*
                             ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:892
#XMLPUBFUN void XMLCALL
#    xmlParserPrintFileInfo	(xmlParserInputPtr input);
sub xmlParserPrintFileInfo(_xmlParserInput $input # Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*»
                           ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:894
#XMLPUBFUN void XMLCALL
#    xmlParserPrintFileContext	(xmlParserInputPtr input);
sub xmlParserPrintFileContext(_xmlParserInput $input # Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*»
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:900
#/*
# * Extended error information routines
# */
#XMLPUBFUN xmlErrorPtr XMLCALL
#    xmlGetLastError		(void);
sub xmlGetLastError(
                    ) is native(LIB) returns _xmlError is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:902
#XMLPUBFUN void XMLCALL
#    xmlResetLastError		(void);
sub xmlResetLastError(
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:904
#XMLPUBFUN xmlErrorPtr XMLCALL
#    xmlCtxtGetLastError		(void *ctx);
sub xmlCtxtGetLastError(Pointer $ctx # void*
                        ) is native(LIB) returns _xmlError is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:906
#XMLPUBFUN void XMLCALL
#    xmlCtxtResetLastError	(void *ctx);
sub xmlCtxtResetLastError(Pointer $ctx # void*
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:908
#XMLPUBFUN void XMLCALL
#    xmlResetError		(xmlErrorPtr err);
sub xmlResetError(_xmlError $err # Typedef<xmlErrorPtr>->«Typedef<xmlError>->«_xmlError»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlerror.h:910
#XMLPUBFUN int XMLCALL
#    xmlCopyError		(xmlErrorPtr from,
sub xmlCopyError(_xmlError                     $from # Typedef<xmlErrorPtr>->«Typedef<xmlError>->«_xmlError»*»
                ,_xmlError                     $to # Typedef<xmlErrorPtr>->«Typedef<xmlError>->«_xmlError»*»
                 ) is native(LIB) returns int32 is export { * }


# == /usr/include/unicode/utf8.h ==

#-From /usr/include/unicode/utf8.h:118
# * however it is U_STABLE (not U_INTERNAL) since it is called by public macros in this
# * file and thus must remain stable, and should not be hidden when other internal
# * functions are hidden (otherwise public macros would fail to compile).
# * @internal
# */
#U_STABLE UChar32 U_EXPORT2
#utf8_nextCharSafeBody(const uint8_t *s, int32_t *pi, int32_t length, UChar32 c, UBool strict);
sub utf8_nextCharSafeBody_57(Pointer[uint8_t]              $s # const Typedef<uint8_t>->«unsigned char»*
                            ,Pointer[int32_t]              $pi # Typedef<int32_t>->«int»*
                            ,int32_t                       $length # Typedef<int32_t>->«int»
                            ,int32_t                       $c # Typedef<UChar32>->«Typedef<int32_t>->«int»»
                            ,int8_t                        $strict # Typedef<UBool>->«Typedef<int8_t>->«signed char»»
                             ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/utf8.h:130
# * however it is U_STABLE (not U_INTERNAL) since it is called by public macros in this
# * file and thus must remain stable, and should not be hidden when other internal
# * functions are hidden (otherwise public macros would fail to compile).
# * @internal
# */
#U_STABLE int32_t U_EXPORT2
#utf8_appendCharSafeBody(uint8_t *s, int32_t i, int32_t length, UChar32 c, UBool *pIsError);
sub utf8_appendCharSafeBody_57(Pointer[uint8_t]              $s # Typedef<uint8_t>->«unsigned char»*
                              ,int32_t                       $i # Typedef<int32_t>->«int»
                              ,int32_t                       $length # Typedef<int32_t>->«int»
                              ,int32_t                       $c # Typedef<UChar32>->«Typedef<int32_t>->«int»»
                              ,Pointer[int8_t]               $pIsError # Typedef<UBool>->«Typedef<int8_t>->«signed char»»*
                               ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/utf8.h:142
# * however it is U_STABLE (not U_INTERNAL) since it is called by public macros in this
# * file and thus must remain stable, and should not be hidden when other internal
# * functions are hidden (otherwise public macros would fail to compile).
# * @internal
# */
#U_STABLE UChar32 U_EXPORT2
#utf8_prevCharSafeBody(const uint8_t *s, int32_t start, int32_t *pi, UChar32 c, UBool strict);
sub utf8_prevCharSafeBody_57(Pointer[uint8_t]              $s # const Typedef<uint8_t>->«unsigned char»*
                            ,int32_t                       $start # Typedef<int32_t>->«int»
                            ,Pointer[int32_t]              $pi # Typedef<int32_t>->«int»*
                            ,int32_t                       $c # Typedef<UChar32>->«Typedef<int32_t>->«int»»
                            ,int8_t                        $strict # Typedef<UBool>->«Typedef<int8_t>->«signed char»»
                             ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/utf8.h:154
# * however it is U_STABLE (not U_INTERNAL) since it is called by public macros in this
# * file and thus must remain stable, and should not be hidden when other internal
# * functions are hidden (otherwise public macros would fail to compile).
# * @internal
# */
#U_STABLE int32_t U_EXPORT2
#utf8_back1SafeBody(const uint8_t *s, int32_t start, int32_t i);
sub utf8_back1SafeBody_57(Pointer[uint8_t]              $s # const Typedef<uint8_t>->«unsigned char»*
                         ,int32_t                       $start # Typedef<int32_t>->«int»
                         ,int32_t                       $i # Typedef<int32_t>->«int»
                          ) is native(LIB) returns int32_t is export { * }


# == /usr/include/libxml2/libxml/entities.h ==

#-From /usr/include/libxml2/libxml/entities.h:79
##ifdef LIBXML_LEGACY_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlInitializePredefinedEntities	(void);
sub xmlInitializePredefinedEntities(
                                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/entities.h:83
#XMLPUBFUN xmlEntityPtr XMLCALL
#			xmlNewEntity		(xmlDocPtr doc,
sub xmlNewEntity(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                ,int32                         $type # int
                ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/entities.h:90
#XMLPUBFUN xmlEntityPtr XMLCALL
#			xmlAddDocEntity		(xmlDocPtr doc,
sub xmlAddDocEntity(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ,int32                         $type # int
                   ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/entities.h:97
#XMLPUBFUN xmlEntityPtr XMLCALL
#			xmlAddDtdEntity		(xmlDocPtr doc,
sub xmlAddDtdEntity(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ,int32                         $type # int
                   ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/entities.h:104
#XMLPUBFUN xmlEntityPtr XMLCALL
#			xmlGetPredefinedEntity	(const xmlChar *name);
sub xmlGetPredefinedEntity(Pointer[xmlChar] $name # const Typedef<xmlChar>->«unsigned char»*
                           ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/entities.h:106
#XMLPUBFUN xmlEntityPtr XMLCALL
#			xmlGetDocEntity		(const xmlDoc *doc,
sub xmlGetDocEntity(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/entities.h:109
#XMLPUBFUN xmlEntityPtr XMLCALL
#			xmlGetDtdEntity		(xmlDocPtr doc,
sub xmlGetDtdEntity(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/entities.h:112
#XMLPUBFUN xmlEntityPtr XMLCALL
#			xmlGetParameterEntity	(xmlDocPtr doc,
sub xmlGetParameterEntity(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                         ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/entities.h:116
##ifdef LIBXML_LEGACY_ENABLED
#XMLPUBFUN const xmlChar * XMLCALL
#			xmlEncodeEntities	(xmlDocPtr doc,
sub xmlEncodeEntities(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                     ,Pointer[xmlChar]              $input # const Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/entities.h:120
##endif /* LIBXML_LEGACY_ENABLED */
#XMLPUBFUN xmlChar * XMLCALL
#			xmlEncodeEntitiesReentrant(xmlDocPtr doc,
sub xmlEncodeEntitiesReentrant(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                              ,Pointer[xmlChar]              $input # const Typedef<xmlChar>->«unsigned char»*
                               ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/entities.h:123
#XMLPUBFUN xmlChar * XMLCALL
#			xmlEncodeSpecialChars	(const xmlDoc *doc,
sub xmlEncodeSpecialChars(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                         ,Pointer[xmlChar]              $input # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/entities.h:126
#XMLPUBFUN xmlEntitiesTablePtr XMLCALL
#			xmlCreateEntitiesTable	(void);
sub xmlCreateEntitiesTable(
                           ) is native(LIB) returns _xmlHashTable is export { * }

#-From /usr/include/libxml2/libxml/entities.h:129
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN xmlEntitiesTablePtr XMLCALL
#			xmlCopyEntitiesTable	(xmlEntitiesTablePtr table);
sub xmlCopyEntitiesTable(_xmlHashTable $table # Typedef<xmlEntitiesTablePtr>->«Typedef<xmlEntitiesTable>->«_xmlHashTable»*»
                         ) is native(LIB) returns _xmlHashTable is export { * }

#-From /usr/include/libxml2/libxml/entities.h:132
##endif /* LIBXML_TREE_ENABLED */
#XMLPUBFUN void XMLCALL
#			xmlFreeEntitiesTable	(xmlEntitiesTablePtr table);
sub xmlFreeEntitiesTable(_xmlHashTable $table # Typedef<xmlEntitiesTablePtr>->«Typedef<xmlEntitiesTable>->«_xmlHashTable»*»
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/entities.h:135
##ifdef LIBXML_OUTPUT_ENABLED
#XMLPUBFUN void XMLCALL
#			xmlDumpEntitiesTable	(xmlBufferPtr buf,
sub xmlDumpEntitiesTable(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                        ,_xmlHashTable                 $table # Typedef<xmlEntitiesTablePtr>->«Typedef<xmlEntitiesTable>->«_xmlHashTable»*»
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/entities.h:138
#XMLPUBFUN void XMLCALL
#			xmlDumpEntityDecl	(xmlBufferPtr buf,
sub xmlDumpEntityDecl(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                     ,_xmlEntity                    $ent # Typedef<xmlEntityPtr>->«Typedef<xmlEntity>->«_xmlEntity»*»
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/entities.h:143
##endif /* LIBXML_OUTPUT_ENABLED */
##ifdef LIBXML_LEGACY_ENABLED
#XMLPUBFUN void XMLCALL
#			xmlCleanupPredefinedEntities(void);
sub xmlCleanupPredefinedEntities(
                                 ) is native(LIB)  is export { * }


# == /usr/include/unicode/uversion.h ==

#-From /usr/include/unicode/uversion.h:151
#/**
# * Parse a string with dotted-decimal version information and
# * fill in a UVersionInfo structure with the result.
# * Definition of this function lives in putil.c
# *
# * @param versionArray The destination structure for the version information.
# * @param versionString A string with dotted-decimal version information,
# *                      with up to four non-negative number fields with
# *                      values of up to 255 each.
# * @stable ICU 2.4
# */
#U_STABLE void U_EXPORT2
#u_versionFromString(UVersionInfo versionArray, const char *versionString);
sub u_versionFromString_57(Pointer[uint8_t]              $versionArray # Typedef<uint8_t>->«unsigned char»*
                          ,Str                           $versionString # const char*
                           ) is native(LIB)  is export { * }

#-From /usr/include/unicode/uversion.h:165
#/**
# * Parse a Unicode string with dotted-decimal version information and
# * fill in a UVersionInfo structure with the result.
# * Definition of this function lives in putil.c
# *
# * @param versionArray The destination structure for the version information.
# * @param versionString A Unicode string with dotted-decimal version
# *                      information, with up to four non-negative number
# *                      fields with values of up to 255 each.
# * @stable ICU 4.2
# */
#U_STABLE void U_EXPORT2
#u_versionFromUString(UVersionInfo versionArray, const UChar *versionString);
sub u_versionFromUString_57(Pointer[uint8_t]              $versionArray # Typedef<uint8_t>->«unsigned char»*
                           ,Pointer[UChar]                $versionString # const Typedef<UChar>->«short unsigned int»*
                            ) is native(LIB)  is export { * }

#-From /usr/include/unicode/uversion.h:181
#/**
# * Write a string with dotted-decimal version information according
# * to the input UVersionInfo.
# * Definition of this function lives in putil.c
# *
# * @param versionArray The version information to be written as a string.
# * @param versionString A string buffer that will be filled in with
# *                      a string corresponding to the numeric version
# *                      information in versionArray.
# *                      The buffer size must be at least U_MAX_VERSION_STRING_LENGTH.
# * @stable ICU 2.4
# */
#U_STABLE void U_EXPORT2
#u_versionToString(const UVersionInfo versionArray, char *versionString);
sub u_versionToString_57(Pointer[uint8_t]              $versionArray # const Typedef<uint8_t>->«unsigned char»*
                        ,Str                           $versionString # char*
                         ) is native(LIB)  is export { * }

#-From /usr/include/unicode/uversion.h:192
#/**
# * Gets the ICU release version.  The version array stores the version information
# * for ICU.  For example, release "1.3.31.2" is then represented as 0x01031F02.
# * Definition of this function lives in putil.c
# *
# * @param versionArray the version # information, the result will be filled in
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#u_getVersion(UVersionInfo versionArray);
sub u_getVersion_57(Pointer[uint8_t] $versionArray # Typedef<uint8_t>->«unsigned char»*
                    ) is native(LIB)  is export { * }


# == /usr/include/libxml2/libxml/parser.h ==

#-From /usr/include/libxml2/libxml/parser.h:823
#/*
# * Init/Cleanup
# */
#XMLPUBFUN void XMLCALL
#		xmlInitParser		(void);
sub xmlInitParser(
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:825
#XMLPUBFUN void XMLCALL
#		xmlCleanupParser	(void);
sub xmlCleanupParser(
                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:831
#/*
# * Input functions
# */
#XMLPUBFUN int XMLCALL
#		xmlParserInputRead	(xmlParserInputPtr in,
sub xmlParserInputRead(_xmlParserInput               $in # Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*»
                      ,int32                         $len # int
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:834
#XMLPUBFUN int XMLCALL
#		xmlParserInputGrow	(xmlParserInputPtr in,
sub xmlParserInputGrow(_xmlParserInput               $in # Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*»
                      ,int32                         $len # int
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:842
#/*
# * Basic parsing Interfaces
# */
##ifdef LIBXML_SAX1_ENABLED
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlParseDoc		(const xmlChar *cur);
sub xmlParseDoc(Pointer[xmlChar] $cur # const Typedef<xmlChar>->«unsigned char»*
                ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:844
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlParseFile		(const char *filename);
sub xmlParseFile(Str $filename # const char*
                 ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:846
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlParseMemory		(const char *buffer,
sub xmlParseMemory(Str                           $buffer # const char*
                  ,int32                         $size # int
                   ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:850
##endif /* LIBXML_SAX1_ENABLED */
#XMLPUBFUN int XMLCALL
#		xmlSubstituteEntitiesDefault(int val);
sub xmlSubstituteEntitiesDefault(int32 $val # int
                                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:852
#XMLPUBFUN int XMLCALL
#		xmlKeepBlanksDefault	(int val);
sub xmlKeepBlanksDefault(int32 $val # int
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:854
#XMLPUBFUN void XMLCALL
#		xmlStopParser		(xmlParserCtxtPtr ctxt);
sub xmlStopParser(_xmlParserCtxt $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:856
#XMLPUBFUN int XMLCALL
#		xmlPedanticParserDefault(int val);
sub xmlPedanticParserDefault(int32 $val # int
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:858
#XMLPUBFUN int XMLCALL
#		xmlLineNumbersDefault	(int val);
sub xmlLineNumbersDefault(int32 $val # int
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:865
##ifdef LIBXML_SAX1_ENABLED
#/*
# * Recovery mode
# */
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlRecoverDoc		(const xmlChar *cur);
sub xmlRecoverDoc(Pointer[xmlChar] $cur # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:867
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlRecoverMemory	(const char *buffer,
sub xmlRecoverMemory(Str                           $buffer # const char*
                    ,int32                         $size # int
                     ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:870
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlRecoverFile		(const char *filename);
sub xmlRecoverFile(Str $filename # const char*
                   ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:877
#/*
# * Less common routines and SAX interfaces
# */
#XMLPUBFUN int XMLCALL
#		xmlParseDocument	(xmlParserCtxtPtr ctxt);
sub xmlParseDocument(_xmlParserCtxt $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:879
#XMLPUBFUN int XMLCALL
#		xmlParseExtParsedEnt	(xmlParserCtxtPtr ctxt);
sub xmlParseExtParsedEnt(_xmlParserCtxt $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:882
##ifdef LIBXML_SAX1_ENABLED
#XMLPUBFUN int XMLCALL
#		xmlSAXUserParseFile	(xmlSAXHandlerPtr sax,
sub xmlSAXUserParseFile(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                       ,Pointer                       $user_data # void*
                       ,Str                           $filename # const char*
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:886
#XMLPUBFUN int XMLCALL
#		xmlSAXUserParseMemory	(xmlSAXHandlerPtr sax,
sub xmlSAXUserParseMemory(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                         ,Pointer                       $user_data # void*
                         ,Str                           $buffer # const char*
                         ,int32                         $size # int
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:891
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlSAXParseDoc		(xmlSAXHandlerPtr sax,
sub xmlSAXParseDoc(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                  ,Pointer[xmlChar]              $cur # const Typedef<xmlChar>->«unsigned char»*
                  ,int32                         $recovery # int
                   ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:895
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlSAXParseMemory	(xmlSAXHandlerPtr sax,
sub xmlSAXParseMemory(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                     ,Str                           $buffer # const char*
                     ,int32                         $size # int
                     ,int32                         $recovery # int
                      ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:900
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlSAXParseMemoryWithData (xmlSAXHandlerPtr sax,
sub xmlSAXParseMemoryWithData(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                             ,Str                           $buffer # const char*
                             ,int32                         $size # int
                             ,int32                         $recovery # int
                             ,Pointer                       $data # void*
                              ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:906
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlSAXParseFile		(xmlSAXHandlerPtr sax,
sub xmlSAXParseFile(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                   ,Str                           $filename # const char*
                   ,int32                         $recovery # int
                    ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:910
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlSAXParseFileWithData	(xmlSAXHandlerPtr sax,
sub xmlSAXParseFileWithData(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                           ,Str                           $filename # const char*
                           ,int32                         $recovery # int
                           ,Pointer                       $data # void*
                            ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:915
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlSAXParseEntity	(xmlSAXHandlerPtr sax,
sub xmlSAXParseEntity(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                     ,Str                           $filename # const char*
                      ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:918
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlParseEntity		(const char *filename);
sub xmlParseEntity(Str $filename # const char*
                   ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:923
##ifdef LIBXML_VALID_ENABLED
#XMLPUBFUN xmlDtdPtr XMLCALL
#		xmlSAXParseDTD		(xmlSAXHandlerPtr sax,
sub xmlSAXParseDTD(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                  ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns _xmlDtd is export { * }

#-From /usr/include/libxml2/libxml/parser.h:927
#XMLPUBFUN xmlDtdPtr XMLCALL
#		xmlParseDTD		(const xmlChar *ExternalID,
sub xmlParseDTD(Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
               ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                ) is native(LIB) returns _xmlDtd is export { * }

#-From /usr/include/libxml2/libxml/parser.h:930
#XMLPUBFUN xmlDtdPtr XMLCALL
#		xmlIOParseDTD		(xmlSAXHandlerPtr sax,
sub xmlIOParseDTD(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                 ,_xmlParserInputBuffer         $input # Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*»
                 ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                  ) is native(LIB) returns _xmlDtd is export { * }

#-From /usr/include/libxml2/libxml/parser.h:936
##endif /* LIBXML_VALID_ENABLE */
##ifdef LIBXML_SAX1_ENABLED
#XMLPUBFUN int XMLCALL
#		xmlParseBalancedChunkMemory(xmlDocPtr doc,
sub xmlParseBalancedChunkMemory(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                               ,_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                               ,Pointer                       $user_data # void*
                               ,int32                         $depth # int
                               ,Pointer[xmlChar]              $string # const Typedef<xmlChar>->«unsigned char»*
                               ,Pointer[_xmlNode]             $lst # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»*
                                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:944
##endif /* LIBXML_SAX1_ENABLED */
#XMLPUBFUN xmlParserErrors XMLCALL
#		xmlParseInNodeContext	(xmlNodePtr node,
sub xmlParseInNodeContext(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                         ,Str                           $data # const char*
                         ,int32                         $datalen # int
                         ,int32                         $options # int
                         ,Pointer[_xmlNode]             $lst # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»*
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:951
##ifdef LIBXML_SAX1_ENABLED
#XMLPUBFUN int XMLCALL
#		xmlParseBalancedChunkMemoryRecover(xmlDocPtr doc,
sub xmlParseBalancedChunkMemoryRecover(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                                      ,_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                                      ,Pointer                       $user_data # void*
                                      ,int32                         $depth # int
                                      ,Pointer[xmlChar]              $string # const Typedef<xmlChar>->«unsigned char»*
                                      ,Pointer[_xmlNode]             $lst # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»*
                                      ,int32                         $recover # int
                                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:959
#XMLPUBFUN int XMLCALL
#		xmlParseExternalEntity	(xmlDocPtr doc,
sub xmlParseExternalEntity(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                          ,_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                          ,Pointer                       $user_data # void*
                          ,int32                         $depth # int
                          ,Pointer[xmlChar]              $URL # const Typedef<xmlChar>->«unsigned char»*
                          ,Pointer[xmlChar]              $ID # const Typedef<xmlChar>->«unsigned char»*
                          ,Pointer[_xmlNode]             $lst # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»*
                           ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:968
##endif /* LIBXML_SAX1_ENABLED */
#XMLPUBFUN int XMLCALL
#		xmlParseCtxtExternalEntity(xmlParserCtxtPtr ctx,
sub xmlParseCtxtExternalEntity(_xmlParserCtxt                $ctx # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                              ,Pointer[xmlChar]              $URL # const Typedef<xmlChar>->«unsigned char»*
                              ,Pointer[xmlChar]              $ID # const Typedef<xmlChar>->«unsigned char»*
                              ,Pointer[_xmlNode]             $lst # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»*
                               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:977
#/*
# * Parser contexts handling.
# */
#XMLPUBFUN xmlParserCtxtPtr XMLCALL
#		xmlNewParserCtxt	(void);
sub xmlNewParserCtxt(
                     ) is native(LIB) returns _xmlParserCtxt is export { * }

#-From /usr/include/libxml2/libxml/parser.h:979
#XMLPUBFUN int XMLCALL
#		xmlInitParserCtxt	(xmlParserCtxtPtr ctxt);
sub xmlInitParserCtxt(_xmlParserCtxt $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:981
#XMLPUBFUN void XMLCALL
#		xmlClearParserCtxt	(xmlParserCtxtPtr ctxt);
sub xmlClearParserCtxt(_xmlParserCtxt $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:983
#XMLPUBFUN void XMLCALL
#		xmlFreeParserCtxt	(xmlParserCtxtPtr ctxt);
sub xmlFreeParserCtxt(_xmlParserCtxt $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:986
##ifdef LIBXML_SAX1_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlSetupParserForBuffer	(xmlParserCtxtPtr ctxt,
sub xmlSetupParserForBuffer(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                           ,Pointer[xmlChar]              $buffer # const Typedef<xmlChar>->«unsigned char»*
                           ,Str                           $filename # const char*
                            ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:991
##endif /* LIBXML_SAX1_ENABLED */
#XMLPUBFUN xmlParserCtxtPtr XMLCALL
#		xmlCreateDocParserCtxt	(const xmlChar *cur);
sub xmlCreateDocParserCtxt(Pointer[xmlChar] $cur # const Typedef<xmlChar>->«unsigned char»*
                           ) is native(LIB) returns _xmlParserCtxt is export { * }

#-From /usr/include/libxml2/libxml/parser.h:998
##ifdef LIBXML_LEGACY_ENABLED
#/*
# * Reading/setting optional parsing features.
# */
#XMLPUBFUN int XMLCALL
#		xmlGetFeaturesList	(int *len,
sub xmlGetFeaturesList(Pointer[int32]                $len # int*
                      ,Pointer[Str]                  $result # const char**
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1001
#XMLPUBFUN int XMLCALL
#		xmlGetFeature		(xmlParserCtxtPtr ctxt,
sub xmlGetFeature(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                 ,Str                           $name # const char*
                 ,Pointer                       $result # void*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1005
#XMLPUBFUN int XMLCALL
#		xmlSetFeature		(xmlParserCtxtPtr ctxt,
sub xmlSetFeature(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                 ,Str                           $name # const char*
                 ,Pointer                       $value # void*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1015
##ifdef LIBXML_PUSH_ENABLED
#/*
# * Interfaces for the Push mode.
# */
#XMLPUBFUN xmlParserCtxtPtr XMLCALL
#		xmlCreatePushParserCtxt(xmlSAXHandlerPtr sax,
sub xmlCreatePushParserCtxt(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                           ,Pointer                       $user_data # void*
                           ,Str                           $chunk # const char*
                           ,int32                         $size # int
                           ,Str                           $filename # const char*
                            ) is native(LIB) returns _xmlParserCtxt is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1021
#XMLPUBFUN int XMLCALL
#		xmlParseChunk		(xmlParserCtxtPtr ctxt,
sub xmlParseChunk(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                 ,Str                           $chunk # const char*
                 ,int32                         $size # int
                 ,int32                         $terminate # int
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1032
#XMLPUBFUN xmlParserCtxtPtr XMLCALL
#		xmlCreateIOParserCtxt	(xmlSAXHandlerPtr sax,
sub xmlCreateIOParserCtxt(_xmlSAXHandler                $sax # Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»
                         ,Pointer                       $user_data # void*
                         ,&ioread ( --> int32) # Typedef<xmlInputReadCallback>->«F:int ( )*»
                         ,&ioclose ( --> int32) # Typedef<xmlInputCloseCallback>->«F:int ( )*»
                         ,Pointer                       $ioctx # void*
                         ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                          ) is native(LIB) returns _xmlParserCtxt is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1040
#XMLPUBFUN xmlParserInputPtr XMLCALL
#		xmlNewIOInputStream	(xmlParserCtxtPtr ctxt,
sub xmlNewIOInputStream(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                       ,_xmlParserInputBuffer         $input # Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*»
                       ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                        ) is native(LIB) returns _xmlParserInput is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1048
#/*
# * Node infos.
# */
#XMLPUBFUN const xmlParserNodeInfo* XMLCALL
#		xmlParserFindNodeInfo	(const xmlParserCtxtPtr ctxt,
sub xmlParserFindNodeInfo(_xmlParserCtxt                $ctxt # const Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                         ,_xmlNode                      $node # const Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                          ) is native(LIB) returns _xmlParserNodeInfo is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1051
#XMLPUBFUN void XMLCALL
#		xmlInitNodeInfoSeq	(xmlParserNodeInfoSeqPtr seq);
sub xmlInitNodeInfoSeq(_xmlParserNodeInfoSeq $seq # Typedef<xmlParserNodeInfoSeqPtr>->«Typedef<xmlParserNodeInfoSeq>->«_xmlParserNodeInfoSeq»*»
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1053
#XMLPUBFUN void XMLCALL
#		xmlClearNodeInfoSeq	(xmlParserNodeInfoSeqPtr seq);
sub xmlClearNodeInfoSeq(_xmlParserNodeInfoSeq $seq # Typedef<xmlParserNodeInfoSeqPtr>->«Typedef<xmlParserNodeInfoSeq>->«_xmlParserNodeInfoSeq»*»
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1055
#XMLPUBFUN unsigned long XMLCALL
#		xmlParserFindNodeInfoIndex(const xmlParserNodeInfoSeqPtr seq,
sub xmlParserFindNodeInfoIndex(_xmlParserNodeInfoSeq         $seq # const Typedef<xmlParserNodeInfoSeqPtr>->«Typedef<xmlParserNodeInfoSeq>->«_xmlParserNodeInfoSeq»*»
                              ,_xmlNode                      $node # const Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                               ) is native(LIB) returns ulong is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1058
#XMLPUBFUN void XMLCALL
#		xmlParserAddNodeInfo	(xmlParserCtxtPtr ctxt,
sub xmlParserAddNodeInfo(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                        ,_xmlParserNodeInfo            $info # const Typedef<xmlParserNodeInfoPtr>->«Typedef<xmlParserNodeInfo>->«_xmlParserNodeInfo»*»
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1066
#XMLPUBFUN void XMLCALL
#		xmlSetExternalEntityLoader(xmlExternalEntityLoader f);
sub xmlSetExternalEntityLoader(&f ( --> _xmlParserInput) # Typedef<xmlExternalEntityLoader>->«F:Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*» ( )*»
                               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1068
#XMLPUBFUN xmlExternalEntityLoader XMLCALL
#		xmlGetExternalEntityLoader(void);
sub xmlGetExternalEntityLoader(
                               ) is native(LIB) returns ( --> _xmlParserInput) is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1070
#XMLPUBFUN xmlParserInputPtr XMLCALL
#		xmlLoadExternalEntity	(const char *URL,
sub xmlLoadExternalEntity(Str                           $URL # const char*
                         ,Str                           $ID # const char*
                         ,_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                          ) is native(LIB) returns _xmlParserInput is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1078
#/*
# * Index lookup, actually implemented in the encoding module
# */
#XMLPUBFUN long XMLCALL
#		xmlByteConsumed		(xmlParserCtxtPtr ctxt);
sub xmlByteConsumed(_xmlParserCtxt $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                    ) is native(LIB) returns long is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1118
#XMLPUBFUN void XMLCALL
#		xmlCtxtReset		(xmlParserCtxtPtr ctxt);
sub xmlCtxtReset(_xmlParserCtxt $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1120
#XMLPUBFUN int XMLCALL
#		xmlCtxtResetPush	(xmlParserCtxtPtr ctxt,
sub xmlCtxtResetPush(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                    ,Str                           $chunk # const char*
                    ,int32                         $size # int
                    ,Str                           $filename # const char*
                    ,Str                           $encoding # const char*
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1126
#XMLPUBFUN int XMLCALL
#		xmlCtxtUseOptions	(xmlParserCtxtPtr ctxt,
sub xmlCtxtUseOptions(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                     ,int32                         $options # int
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1129
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlReadDoc		(const xmlChar *cur,
sub xmlReadDoc(Pointer[xmlChar]              $cur # const Typedef<xmlChar>->«unsigned char»*
              ,Str                           $URL # const char*
              ,Str                           $encoding # const char*
              ,int32                         $options # int
               ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1134
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlReadFile		(const char *URL,
sub xmlReadFile(Str                           $URL # const char*
               ,Str                           $encoding # const char*
               ,int32                         $options # int
                ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1138
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlReadMemory		(const char *buffer,
sub xmlReadMemory(Str                           $buffer # const char*
                 ,int32                         $size # int
                 ,Str                           $URL # const char*
                 ,Str                           $encoding # const char*
                 ,int32                         $options # int
                  ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1144
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlReadFd		(int fd,
sub xmlReadFd(int32                         $fd # int
             ,Str                           $URL # const char*
             ,Str                           $encoding # const char*
             ,int32                         $options # int
              ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1149
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlReadIO		(xmlInputReadCallback ioread,
sub xmlReadIO(&ioread ( --> int32) # Typedef<xmlInputReadCallback>->«F:int ( )*»
             ,&ioclose ( --> int32) # Typedef<xmlInputCloseCallback>->«F:int ( )*»
             ,Pointer                       $ioctx # void*
             ,Str                           $URL # const char*
             ,Str                           $encoding # const char*
             ,int32                         $options # int
              ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1156
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlCtxtReadDoc		(xmlParserCtxtPtr ctxt,
sub xmlCtxtReadDoc(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                  ,Pointer[xmlChar]              $cur # const Typedef<xmlChar>->«unsigned char»*
                  ,Str                           $URL # const char*
                  ,Str                           $encoding # const char*
                  ,int32                         $options # int
                   ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1162
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlCtxtReadFile		(xmlParserCtxtPtr ctxt,
sub xmlCtxtReadFile(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                   ,Str                           $filename # const char*
                   ,Str                           $encoding # const char*
                   ,int32                         $options # int
                    ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1167
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlCtxtReadMemory		(xmlParserCtxtPtr ctxt,
sub xmlCtxtReadMemory(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                     ,Str                           $buffer # const char*
                     ,int32                         $size # int
                     ,Str                           $URL # const char*
                     ,Str                           $encoding # const char*
                     ,int32                         $options # int
                      ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1174
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlCtxtReadFd		(xmlParserCtxtPtr ctxt,
sub xmlCtxtReadFd(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                 ,int32                         $fd # int
                 ,Str                           $URL # const char*
                 ,Str                           $encoding # const char*
                 ,int32                         $options # int
                  ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1180
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlCtxtReadIO		(xmlParserCtxtPtr ctxt,
sub xmlCtxtReadIO(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                 ,&ioread ( --> int32) # Typedef<xmlInputReadCallback>->«F:int ( )*»
                 ,&ioclose ( --> int32) # Typedef<xmlInputCloseCallback>->«F:int ( )*»
                 ,Pointer                       $ioctx # void*
                 ,Str                           $URL # const char*
                 ,Str                           $encoding # const char*
                 ,int32                         $options # int
                  ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/parser.h:1236
#XMLPUBFUN int XMLCALL
#		xmlHasFeature		(xmlFeature feature);
sub xmlHasFeature(int32 $feature # Typedef<xmlFeature>->«xmlFeature»
                  ) is native(LIB) returns int32 is export { * }


# == /usr/include/libxml2/libxml/xmlversion.h ==

#-From /usr/include/libxml2/libxml/xmlversion.h:24
#/*
# * use those to be sure nothing nasty will happen if
# * your library and includes mismatch
# */
##ifndef LIBXML2_COMPILING_MSCCDEF
#XMLPUBFUN void XMLCALL xmlCheckVersion(int version);
sub xmlCheckVersion(int32 $version # int
                    ) is native(LIB)  is export { * }


# == /usr/include/libxml2/libxml/xmlautomata.h ==

#-From /usr/include/libxml2/libxml/xmlautomata.h:44
#/*
# * Building API
# */
#XMLPUBFUN xmlAutomataPtr XMLCALL
#		    xmlNewAutomata		(void);
sub xmlNewAutomata(
                   ) is native(LIB) returns _xmlAutomata is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:46
#XMLPUBFUN void XMLCALL
#		    xmlFreeAutomata		(xmlAutomataPtr am);
sub xmlFreeAutomata(_xmlAutomata $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:49
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataGetInitState	(xmlAutomataPtr am);
sub xmlAutomataGetInitState(_xmlAutomata $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                            ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:51
#XMLPUBFUN int XMLCALL
#		    xmlAutomataSetFinalState	(xmlAutomataPtr am,
sub xmlAutomataSetFinalState(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                            ,_xmlAutomataState             $state # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:54
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewState		(xmlAutomataPtr am);
sub xmlAutomataNewState(_xmlAutomata $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                        ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:56
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewTransition	(xmlAutomataPtr am,
sub xmlAutomataNewTransition(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                            ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                            ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                            ,Pointer[xmlChar]              $token # const Typedef<xmlChar>->«unsigned char»*
                            ,Pointer                       $data # void*
                             ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:62
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewTransition2	(xmlAutomataPtr am,
sub xmlAutomataNewTransition2(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                             ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                             ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                             ,Pointer[xmlChar]              $token # const Typedef<xmlChar>->«unsigned char»*
                             ,Pointer[xmlChar]              $token2 # const Typedef<xmlChar>->«unsigned char»*
                             ,Pointer                       $data # void*
                              ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:69
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#                    xmlAutomataNewNegTrans	(xmlAutomataPtr am,
sub xmlAutomataNewNegTrans(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                          ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                          ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                          ,Pointer[xmlChar]              $token # const Typedef<xmlChar>->«unsigned char»*
                          ,Pointer[xmlChar]              $token2 # const Typedef<xmlChar>->«unsigned char»*
                          ,Pointer                       $data # void*
                           ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:77
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewCountTrans	(xmlAutomataPtr am,
sub xmlAutomataNewCountTrans(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                            ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                            ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                            ,Pointer[xmlChar]              $token # const Typedef<xmlChar>->«unsigned char»*
                            ,int32                         $min # int
                            ,int32                         $max # int
                            ,Pointer                       $data # void*
                             ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:85
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewCountTrans2	(xmlAutomataPtr am,
sub xmlAutomataNewCountTrans2(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                             ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                             ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                             ,Pointer[xmlChar]              $token # const Typedef<xmlChar>->«unsigned char»*
                             ,Pointer[xmlChar]              $token2 # const Typedef<xmlChar>->«unsigned char»*
                             ,int32                         $min # int
                             ,int32                         $max # int
                             ,Pointer                       $data # void*
                              ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:94
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewOnceTrans	(xmlAutomataPtr am,
sub xmlAutomataNewOnceTrans(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                           ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                           ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                           ,Pointer[xmlChar]              $token # const Typedef<xmlChar>->«unsigned char»*
                           ,int32                         $min # int
                           ,int32                         $max # int
                           ,Pointer                       $data # void*
                            ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:102
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewOnceTrans2	(xmlAutomataPtr am,
sub xmlAutomataNewOnceTrans2(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                            ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                            ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                            ,Pointer[xmlChar]              $token # const Typedef<xmlChar>->«unsigned char»*
                            ,Pointer[xmlChar]              $token2 # const Typedef<xmlChar>->«unsigned char»*
                            ,int32                         $min # int
                            ,int32                         $max # int
                            ,Pointer                       $data # void*
                             ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:111
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewAllTrans	(xmlAutomataPtr am,
sub xmlAutomataNewAllTrans(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                          ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                          ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                          ,int32                         $lax # int
                           ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:116
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewEpsilon	(xmlAutomataPtr am,
sub xmlAutomataNewEpsilon(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                         ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                         ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                          ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:120
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewCountedTrans	(xmlAutomataPtr am,
sub xmlAutomataNewCountedTrans(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                              ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                              ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                              ,int32                         $counter # int
                               ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:125
#XMLPUBFUN xmlAutomataStatePtr XMLCALL
#		    xmlAutomataNewCounterTrans	(xmlAutomataPtr am,
sub xmlAutomataNewCounterTrans(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                              ,_xmlAutomataState             $from # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                              ,_xmlAutomataState             $to # Typedef<xmlAutomataStatePtr>->«Typedef<xmlAutomataState>->«_xmlAutomataState»*»
                              ,int32                         $counter # int
                               ) is native(LIB) returns _xmlAutomataState is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:130
#XMLPUBFUN int XMLCALL
#		    xmlAutomataNewCounter	(xmlAutomataPtr am,
sub xmlAutomataNewCounter(_xmlAutomata                  $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                         ,int32                         $min # int
                         ,int32                         $max # int
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:135
#XMLPUBFUN xmlRegexpPtr XMLCALL
#		    xmlAutomataCompile		(xmlAutomataPtr am);
sub xmlAutomataCompile(_xmlAutomata $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                       ) is native(LIB) returns _xmlRegexp is export { * }

#-From /usr/include/libxml2/libxml/xmlautomata.h:137
#XMLPUBFUN int XMLCALL
#		    xmlAutomataIsDeterminist	(xmlAutomataPtr am);
sub xmlAutomataIsDeterminist(_xmlAutomata $am # Typedef<xmlAutomataPtr>->«Typedef<xmlAutomata>->«_xmlAutomata»*»
                             ) is native(LIB) returns int32 is export { * }


# == /usr/include/unicode/ucnv_err.h ==

#-From /usr/include/unicode/ucnv_err.h:234
#/**
# * DO NOT CALL THIS FUNCTION DIRECTLY!
# * This From Unicode callback STOPS at the ILLEGAL_SEQUENCE,
# * returning the error code back to the caller immediately.
# *
# * @param context Pointer to the callback's private data
# * @param fromUArgs Information about the conversion in progress
# * @param codeUnits Points to 'length' UChars of the concerned Unicode sequence
# * @param length Size (in bytes) of the concerned codepage sequence
# * @param codePoint Single UChar32 (UTF-32) containing the concerend Unicode codepoint.
# * @param reason Defines the reason the callback was invoked
# * @param err This should always be set to a failure status prior to calling.
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2 UCNV_FROM_U_CALLBACK_STOP (
sub UCNV_FROM_U_CALLBACK_STOP_57(Pointer                       $context # const void*
                                ,                              $fromUArgs # Typedef<UConverterFromUnicodeArgs>->«»*
                                ,Pointer[UChar]                $codeUnits # const Typedef<UChar>->«short unsigned int»*
                                ,int32_t                       $length # Typedef<int32_t>->«int»
                                ,int32_t                       $codePoint # Typedef<UChar32>->«Typedef<int32_t>->«int»»
                                ,int32                         $reason # Typedef<UConverterCallbackReason>->«UConverterCallbackReason»
                                ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                                 ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv_err.h:258
#/**
# * DO NOT CALL THIS FUNCTION DIRECTLY!
# * This To Unicode callback STOPS at the ILLEGAL_SEQUENCE,
# * returning the error code back to the caller immediately.
# *
# * @param context Pointer to the callback's private data
# * @param toUArgs Information about the conversion in progress
# * @param codeUnits Points to 'length' bytes of the concerned codepage sequence
# * @param length Size (in bytes) of the concerned codepage sequence
# * @param reason Defines the reason the callback was invoked
# * @param err This should always be set to a failure status prior to calling.
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2 UCNV_TO_U_CALLBACK_STOP (
sub UCNV_TO_U_CALLBACK_STOP_57(Pointer                       $context # const void*
                              ,                              $toUArgs # Typedef<UConverterToUnicodeArgs>->«»*
                              ,Str                           $codeUnits # const char*
                              ,int32_t                       $length # Typedef<int32_t>->«int»
                              ,int32                         $reason # Typedef<UConverterCallbackReason>->«UConverterCallbackReason»
                              ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                               ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv_err.h:285
#/**
# * DO NOT CALL THIS FUNCTION DIRECTLY!
# * This From Unicode callback skips any ILLEGAL_SEQUENCE, or
# * skips only UNASSINGED_SEQUENCE depending on the context parameter
# * simply ignoring those characters. 
# *
# * @param context  The function currently recognizes the callback options:
# *                 UCNV_SKIP_STOP_ON_ILLEGAL: STOPS at the ILLEGAL_SEQUENCE,
# *                      returning the error code back to the caller immediately.
# *                 NULL: Skips any ILLEGAL_SEQUENCE
# * @param fromUArgs Information about the conversion in progress
# * @param codeUnits Points to 'length' UChars of the concerned Unicode sequence
# * @param length Size (in bytes) of the concerned codepage sequence
# * @param codePoint Single UChar32 (UTF-32) containing the concerend Unicode codepoint.
# * @param reason Defines the reason the callback was invoked
# * @param err Return value will be set to success if the callback was handled,
# *      otherwise this value will be set to a failure status.
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2 UCNV_FROM_U_CALLBACK_SKIP (
sub UCNV_FROM_U_CALLBACK_SKIP_57(Pointer                       $context # const void*
                                ,                              $fromUArgs # Typedef<UConverterFromUnicodeArgs>->«»*
                                ,Pointer[UChar]                $codeUnits # const Typedef<UChar>->«short unsigned int»*
                                ,int32_t                       $length # Typedef<int32_t>->«int»
                                ,int32_t                       $codePoint # Typedef<UChar32>->«Typedef<int32_t>->«int»»
                                ,int32                         $reason # Typedef<UConverterCallbackReason>->«UConverterCallbackReason»
                                ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                                 ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv_err.h:315
#/**
# * DO NOT CALL THIS FUNCTION DIRECTLY!
# * This From Unicode callback will Substitute the ILLEGAL SEQUENCE, or 
# * UNASSIGNED_SEQUENCE depending on context parameter, with the
# * current substitution string for the converter. This is the default
# * callback.
# *
# * @param context The function currently recognizes the callback options:
# *                 UCNV_SUB_STOP_ON_ILLEGAL: STOPS at the ILLEGAL_SEQUENCE,
# *                      returning the error code back to the caller immediately.
# *                 NULL: Substitutes any ILLEGAL_SEQUENCE
# * @param fromUArgs Information about the conversion in progress
# * @param codeUnits Points to 'length' UChars of the concerned Unicode sequence
# * @param length Size (in bytes) of the concerned codepage sequence
# * @param codePoint Single UChar32 (UTF-32) containing the concerend Unicode codepoint.
# * @param reason Defines the reason the callback was invoked
# * @param err Return value will be set to success if the callback was handled,
# *      otherwise this value will be set to a failure status.
# * @see ucnv_setSubstChars
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2 UCNV_FROM_U_CALLBACK_SUBSTITUTE (
sub UCNV_FROM_U_CALLBACK_SUBSTITUTE_57(Pointer                       $context # const void*
                                      ,                              $fromUArgs # Typedef<UConverterFromUnicodeArgs>->«»*
                                      ,Pointer[UChar]                $codeUnits # const Typedef<UChar>->«short unsigned int»*
                                      ,int32_t                       $length # Typedef<int32_t>->«int»
                                      ,int32_t                       $codePoint # Typedef<UChar32>->«Typedef<int32_t>->«int»»
                                      ,int32                         $reason # Typedef<UConverterCallbackReason>->«UConverterCallbackReason»
                                      ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                                       ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv_err.h:371
# *        </ul>
# * @param fromUArgs Information about the conversion in progress
# * @param codeUnits Points to 'length' UChars of the concerned Unicode sequence
# * @param length Size (in bytes) of the concerned codepage sequence
# * @param codePoint Single UChar32 (UTF-32) containing the concerend Unicode codepoint.
# * @param reason Defines the reason the callback was invoked
# * @param err Return value will be set to success if the callback was handled,
# *      otherwise this value will be set to a failure status.
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2 UCNV_FROM_U_CALLBACK_ESCAPE (
sub UCNV_FROM_U_CALLBACK_ESCAPE_57(Pointer                       $context # const void*
                                  ,                              $fromUArgs # Typedef<UConverterFromUnicodeArgs>->«»*
                                  ,Pointer[UChar]                $codeUnits # const Typedef<UChar>->«short unsigned int»*
                                  ,int32_t                       $length # Typedef<int32_t>->«int»
                                  ,int32_t                       $codePoint # Typedef<UChar32>->«Typedef<int32_t>->«int»»
                                  ,int32                         $reason # Typedef<UConverterCallbackReason>->«UConverterCallbackReason»
                                  ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                                   ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv_err.h:399
#/**
# * DO NOT CALL THIS FUNCTION DIRECTLY!
# * This To Unicode callback skips any ILLEGAL_SEQUENCE, or
# * skips only UNASSINGED_SEQUENCE depending on the context parameter
# * simply ignoring those characters. 
# *
# * @param context  The function currently recognizes the callback options:
# *                 UCNV_SKIP_STOP_ON_ILLEGAL: STOPS at the ILLEGAL_SEQUENCE,
# *                      returning the error code back to the caller immediately.
# *                 NULL: Skips any ILLEGAL_SEQUENCE
# * @param toUArgs Information about the conversion in progress
# * @param codeUnits Points to 'length' bytes of the concerned codepage sequence
# * @param length Size (in bytes) of the concerned codepage sequence
# * @param reason Defines the reason the callback was invoked
# * @param err Return value will be set to success if the callback was handled,
# *      otherwise this value will be set to a failure status.
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2 UCNV_TO_U_CALLBACK_SKIP (
sub UCNV_TO_U_CALLBACK_SKIP_57(Pointer                       $context # const void*
                              ,                              $toUArgs # Typedef<UConverterToUnicodeArgs>->«»*
                              ,Str                           $codeUnits # const char*
                              ,int32_t                       $length # Typedef<int32_t>->«int»
                              ,int32                         $reason # Typedef<UConverterCallbackReason>->«UConverterCallbackReason»
                              ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                               ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv_err.h:425
#/**
# * DO NOT CALL THIS FUNCTION DIRECTLY!
# * This To Unicode callback will Substitute the ILLEGAL SEQUENCE,or 
# * UNASSIGNED_SEQUENCE depending on context parameter,  with the
# * Unicode substitution character, U+FFFD.
# *
# * @param context  The function currently recognizes the callback options:
# *                 UCNV_SUB_STOP_ON_ILLEGAL: STOPS at the ILLEGAL_SEQUENCE,
# *                      returning the error code back to the caller immediately.
# *                 NULL: Substitutes any ILLEGAL_SEQUENCE
# * @param toUArgs Information about the conversion in progress
# * @param codeUnits Points to 'length' bytes of the concerned codepage sequence
# * @param length Size (in bytes) of the concerned codepage sequence
# * @param reason Defines the reason the callback was invoked
# * @param err Return value will be set to success if the callback was handled,
# *      otherwise this value will be set to a failure status.
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2 UCNV_TO_U_CALLBACK_SUBSTITUTE (
sub UCNV_TO_U_CALLBACK_SUBSTITUTE_57(Pointer                       $context # const void*
                                    ,                              $toUArgs # Typedef<UConverterToUnicodeArgs>->«»*
                                    ,Str                           $codeUnits # const char*
                                    ,int32_t                       $length # Typedef<int32_t>->«int»
                                    ,int32                         $reason # Typedef<UConverterCallbackReason>->«UConverterCallbackReason»
                                    ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                                     ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv_err.h:451
#U_STABLE void U_EXPORT2 UCNV_TO_U_CALLBACK_ESCAPE (
sub UCNV_TO_U_CALLBACK_ESCAPE_57(Pointer                       $context # const void*
                                ,                              $toUArgs # Typedef<UConverterToUnicodeArgs>->«»*
                                ,Str                           $codeUnits # const char*
                                ,int32_t                       $length # Typedef<int32_t>->«int»
                                ,int32                         $reason # Typedef<UConverterCallbackReason>->«UConverterCallbackReason»
                                ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                                 ) is native(LIB)  is export { * }


# == /usr/include/libxml2/libxml/xmlregexp.h ==

#-From /usr/include/libxml2/libxml/xmlregexp.h:52
#/*
# * The POSIX like API
# */
#XMLPUBFUN xmlRegexpPtr XMLCALL
#		    xmlRegexpCompile	(const xmlChar *regexp);
sub xmlRegexpCompile(Pointer[xmlChar] $regexp # const Typedef<xmlChar>->«unsigned char»*
                     ) is native(LIB) returns _xmlRegexp is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:53
#XMLPUBFUN void XMLCALL			 xmlRegFreeRegexp(xmlRegexpPtr regexp);
sub xmlRegFreeRegexp(_xmlRegexp $regexp # Typedef<xmlRegexpPtr>->«Typedef<xmlRegexp>->«_xmlRegexp»*»
                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:55
#XMLPUBFUN int XMLCALL
#		    xmlRegexpExec	(xmlRegexpPtr comp,
sub xmlRegexpExec(_xmlRegexp                    $comp # Typedef<xmlRegexpPtr>->«Typedef<xmlRegexp>->«_xmlRegexp»*»
                 ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:58
#XMLPUBFUN void XMLCALL
#		    xmlRegexpPrint	(FILE *output,
sub xmlRegexpPrint(_IO_FILE                      $output # Typedef<FILE>->«_IO_FILE»*
                  ,_xmlRegexp                    $regexp # Typedef<xmlRegexpPtr>->«Typedef<xmlRegexp>->«_xmlRegexp»*»
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:61
#XMLPUBFUN int XMLCALL
#		    xmlRegexpIsDeterminist(xmlRegexpPtr comp);
sub xmlRegexpIsDeterminist(_xmlRegexp $comp # Typedef<xmlRegexpPtr>->«Typedef<xmlRegexp>->«_xmlRegexp»*»
                           ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:81
#/*
# * The progressive API
# */
#XMLPUBFUN xmlRegExecCtxtPtr XMLCALL
#		    xmlRegNewExecCtxt	(xmlRegexpPtr comp,
sub xmlRegNewExecCtxt(_xmlRegexp                    $comp # Typedef<xmlRegexpPtr>->«Typedef<xmlRegexp>->«_xmlRegexp»*»
                     ,&callback () # Typedef<xmlRegExecCallbacks>->«F:void ( )*»
                     ,Pointer                       $data # void*
                      ) is native(LIB) returns _xmlRegExecCtxt is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:85
#XMLPUBFUN void XMLCALL
#		    xmlRegFreeExecCtxt	(xmlRegExecCtxtPtr exec);
sub xmlRegFreeExecCtxt(_xmlRegExecCtxt $exec # Typedef<xmlRegExecCtxtPtr>->«Typedef<xmlRegExecCtxt>->«_xmlRegExecCtxt»*»
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:87
#XMLPUBFUN int XMLCALL
#		    xmlRegExecPushString(xmlRegExecCtxtPtr exec,
sub xmlRegExecPushString(_xmlRegExecCtxt               $exec # Typedef<xmlRegExecCtxtPtr>->«Typedef<xmlRegExecCtxt>->«_xmlRegExecCtxt»*»
                        ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                        ,Pointer                       $data # void*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:91
#XMLPUBFUN int XMLCALL
#		    xmlRegExecPushString2(xmlRegExecCtxtPtr exec,
sub xmlRegExecPushString2(_xmlRegExecCtxt               $exec # Typedef<xmlRegExecCtxtPtr>->«Typedef<xmlRegExecCtxt>->«_xmlRegExecCtxt»*»
                         ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $value2 # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer                       $data # void*
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:97
#XMLPUBFUN int XMLCALL
#		    xmlRegExecNextValues(xmlRegExecCtxtPtr exec,
sub xmlRegExecNextValues(_xmlRegExecCtxt               $exec # Typedef<xmlRegExecCtxtPtr>->«Typedef<xmlRegExecCtxt>->«_xmlRegExecCtxt»*»
                        ,Pointer[int32]                $nbval # int*
                        ,Pointer[int32]                $nbneg # int*
                        ,Pointer[Pointer[xmlChar]]     $values # Typedef<xmlChar>->«unsigned char»**
                        ,Pointer[int32]                $terminal # int*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:103
#XMLPUBFUN int XMLCALL
#		    xmlRegExecErrInfo	(xmlRegExecCtxtPtr exec,
sub xmlRegExecErrInfo(_xmlRegExecCtxt               $exec # Typedef<xmlRegExecCtxtPtr>->«Typedef<xmlRegExecCtxt>->«_xmlRegExecCtxt»*»
                     ,Pointer[Pointer[xmlChar]]     $string # const Typedef<xmlChar>->«unsigned char»**
                     ,Pointer[int32]                $nbval # int*
                     ,Pointer[int32]                $nbneg # int*
                     ,Pointer[Pointer[xmlChar]]     $values # Typedef<xmlChar>->«unsigned char»**
                     ,Pointer[int32]                $terminal # int*
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:120
#XMLPUBFUN void XMLCALL
#			xmlExpFreeCtxt	(xmlExpCtxtPtr ctxt);
sub xmlExpFreeCtxt(_xmlExpCtxt $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:122
#XMLPUBFUN xmlExpCtxtPtr XMLCALL
#			xmlExpNewCtxt	(int maxNodes,
sub xmlExpNewCtxt(int32                         $maxNodes # int
                 ,_xmlDict                      $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                  ) is native(LIB) returns _xmlExpCtxt is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:126
#XMLPUBFUN int XMLCALL
#			xmlExpCtxtNbNodes(xmlExpCtxtPtr ctxt);
sub xmlExpCtxtNbNodes(_xmlExpCtxt $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:128
#XMLPUBFUN int XMLCALL
#			xmlExpCtxtNbCons(xmlExpCtxtPtr ctxt);
sub xmlExpCtxtNbCons(_xmlExpCtxt $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:154
#/*
# * Expressions are reference counted internally
# */
#XMLPUBFUN void XMLCALL
#			xmlExpFree	(xmlExpCtxtPtr ctxt,
sub xmlExpFree(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
              ,_xmlExpNode                   $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:157
#XMLPUBFUN void XMLCALL
#			xmlExpRef	(xmlExpNodePtr expr);
sub xmlExpRef(_xmlExpNode $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:163
#/*
# * constructors can be either manual or from a string
# */
#XMLPUBFUN xmlExpNodePtr XMLCALL
#			xmlExpParse	(xmlExpCtxtPtr ctxt,
sub xmlExpParse(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
               ,Str                           $expr # const char*
                ) is native(LIB) returns _xmlExpNode is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:166
#XMLPUBFUN xmlExpNodePtr XMLCALL
#			xmlExpNewAtom	(xmlExpCtxtPtr ctxt,
sub xmlExpNewAtom(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                 ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $len # int
                  ) is native(LIB) returns _xmlExpNode is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:170
#XMLPUBFUN xmlExpNodePtr XMLCALL
#			xmlExpNewOr	(xmlExpCtxtPtr ctxt,
sub xmlExpNewOr(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
               ,_xmlExpNode                   $left # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
               ,_xmlExpNode                   $right # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                ) is native(LIB) returns _xmlExpNode is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:174
#XMLPUBFUN xmlExpNodePtr XMLCALL
#			xmlExpNewSeq	(xmlExpCtxtPtr ctxt,
sub xmlExpNewSeq(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                ,_xmlExpNode                   $left # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                ,_xmlExpNode                   $right # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                 ) is native(LIB) returns _xmlExpNode is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:178
#XMLPUBFUN xmlExpNodePtr XMLCALL
#			xmlExpNewRange	(xmlExpCtxtPtr ctxt,
sub xmlExpNewRange(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                  ,_xmlExpNode                   $subset # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                  ,int32                         $min # int
                  ,int32                         $max # int
                   ) is native(LIB) returns _xmlExpNode is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:186
#/*
# * The really interesting APIs
# */
#XMLPUBFUN int XMLCALL
#			xmlExpIsNillable(xmlExpNodePtr expr);
sub xmlExpIsNillable(_xmlExpNode $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:188
#XMLPUBFUN int XMLCALL
#			xmlExpMaxToken	(xmlExpNodePtr expr);
sub xmlExpMaxToken(_xmlExpNode $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:190
#XMLPUBFUN int XMLCALL
#			xmlExpGetLanguage(xmlExpCtxtPtr ctxt,
sub xmlExpGetLanguage(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                     ,_xmlExpNode                   $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                     ,Pointer[Pointer[xmlChar]]     $langList # const Typedef<xmlChar>->«unsigned char»**
                     ,int32                         $len # int
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:195
#XMLPUBFUN int XMLCALL
#			xmlExpGetStart	(xmlExpCtxtPtr ctxt,
sub xmlExpGetStart(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                  ,_xmlExpNode                   $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                  ,Pointer[Pointer[xmlChar]]     $tokList # const Typedef<xmlChar>->«unsigned char»**
                  ,int32                         $len # int
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:200
#XMLPUBFUN xmlExpNodePtr XMLCALL
#			xmlExpStringDerive(xmlExpCtxtPtr ctxt,
sub xmlExpStringDerive(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                      ,_xmlExpNode                   $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                      ,Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
                      ,int32                         $len # int
                       ) is native(LIB) returns _xmlExpNode is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:205
#XMLPUBFUN xmlExpNodePtr XMLCALL
#			xmlExpExpDerive	(xmlExpCtxtPtr ctxt,
sub xmlExpExpDerive(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                   ,_xmlExpNode                   $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                   ,_xmlExpNode                   $sub # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                    ) is native(LIB) returns _xmlExpNode is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:209
#XMLPUBFUN int XMLCALL
#			xmlExpSubsume	(xmlExpCtxtPtr ctxt,
sub xmlExpSubsume(_xmlExpCtxt                   $ctxt # Typedef<xmlExpCtxtPtr>->«Typedef<xmlExpCtxt>->«_xmlExpCtxt»*»
                 ,_xmlExpNode                   $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                 ,_xmlExpNode                   $sub # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlregexp.h:213
#XMLPUBFUN void XMLCALL
#			xmlExpDump	(xmlBufferPtr buf,
sub xmlExpDump(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
              ,_xmlExpNode                   $expr # Typedef<xmlExpNodePtr>->«Typedef<xmlExpNode>->«_xmlExpNode»*»
               ) is native(LIB)  is export { * }


# == /usr/include/iconv.h ==

#-From /usr/include/iconv.h:37
#   This function is a possible cancellation point and therefore not
#   marked with __THROW.  */
#extern iconv_t iconv_open (const char *__tocode, const char *__fromcode);
sub iconv_open(Str                           $__tocode # const char*
              ,Str                           $__fromcode # const char*
               ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/iconv.h:42
#/* Convert at most *INBYTESLEFT bytes from *INBUF according to the
#   code conversion algorithm specified by CD and place up to
#   *OUTBYTESLEFT bytes in buffer at *OUTBUF.  */
#extern size_t iconv (iconv_t __cd, char **__restrict __inbuf,
sub iconv(Pointer                       $__cd # Typedef<iconv_t>->«void*»
         ,Pointer[Str]                  $__inbuf # const char**
         ,Pointer[size_t]               $__inbytesleft # const Typedef<size_t>->«long unsigned int»*
         ,Pointer[Str]                  $__outbuf # const char**
         ,Pointer[size_t]               $__outbytesleft # const Typedef<size_t>->«long unsigned int»*
          ) is native(LIB) returns size_t is export { * }

#-From /usr/include/iconv.h:51
#   This function is a possible cancellation point and therefore not
#   marked with __THROW.  */
#extern int iconv_close (iconv_t __cd);
sub iconv_close(Pointer $__cd # Typedef<iconv_t>->«void*»
                ) is native(LIB) returns int32 is export { * }


# == /usr/include/libxml2/libxml/globals.h ==

#-From /usr/include/libxml2/libxml/globals.h:28
#XMLPUBFUN void XMLCALL xmlInitGlobals(void);
sub xmlInitGlobals(
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/globals.h:29
#XMLPUBFUN void XMLCALL xmlCleanupGlobals(void);
sub xmlCleanupGlobals(
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/globals.h:62
#XMLPUBFUN xmlParserInputBufferCreateFilenameFunc
#XMLCALL xmlParserInputBufferCreateFilenameDefault (xmlParserInputBufferCreateFilenameFunc func);
sub xmlParserInputBufferCreateFilenameDefault(&func ( --> _xmlParserInputBuffer) # Typedef<xmlParserInputBufferCreateFilenameFunc>->«F:Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*» ( )*»
                                              ) is native(LIB) returns ( --> _xmlParserInputBuffer) is export { * }

#-From /usr/include/libxml2/libxml/globals.h:64
#XMLPUBFUN xmlOutputBufferCreateFilenameFunc
#XMLCALL xmlOutputBufferCreateFilenameDefault (xmlOutputBufferCreateFilenameFunc func);
sub xmlOutputBufferCreateFilenameDefault(&func ( --> _xmlOutputBuffer) # Typedef<xmlOutputBufferCreateFilenameFunc>->«F:Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*» ( )*»
                                         ) is native(LIB) returns ( --> _xmlOutputBuffer) is export { * }

#-From /usr/include/libxml2/libxml/globals.h:178
#XMLPUBFUN void XMLCALL	xmlInitializeGlobalState(xmlGlobalStatePtr gs);
sub xmlInitializeGlobalState(_xmlGlobalState $gs # Typedef<xmlGlobalStatePtr>->«Typedef<xmlGlobalState>->«_xmlGlobalState»*»
                             ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/globals.h:180
#XMLPUBFUN void XMLCALL xmlThrDefSetGenericErrorFunc(void *ctx, xmlGenericErrorFunc handler);
sub xmlThrDefSetGenericErrorFunc(Pointer                       $ctx # void*
                                ,&handler () # Typedef<xmlGenericErrorFunc>->«F:void ( )*»
                                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/globals.h:182
#XMLPUBFUN void XMLCALL xmlThrDefSetStructuredErrorFunc(void *ctx, xmlStructuredErrorFunc handler);
sub xmlThrDefSetStructuredErrorFunc(Pointer                       $ctx # void*
                                   ,&handler () # Typedef<xmlStructuredErrorFunc>->«F:void ( )*»
                                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/globals.h:184
#XMLPUBFUN xmlRegisterNodeFunc XMLCALL xmlRegisterNodeDefault(xmlRegisterNodeFunc func);
sub xmlRegisterNodeDefault(&func () # Typedef<xmlRegisterNodeFunc>->«F:void ( )*»
                           ) is native(LIB) returns () is export { * }

#-From /usr/include/libxml2/libxml/globals.h:185
#XMLPUBFUN xmlRegisterNodeFunc XMLCALL xmlThrDefRegisterNodeDefault(xmlRegisterNodeFunc func);
sub xmlThrDefRegisterNodeDefault(&func () # Typedef<xmlRegisterNodeFunc>->«F:void ( )*»
                                 ) is native(LIB) returns () is export { * }

#-From /usr/include/libxml2/libxml/globals.h:186
#XMLPUBFUN xmlDeregisterNodeFunc XMLCALL xmlDeregisterNodeDefault(xmlDeregisterNodeFunc func);
sub xmlDeregisterNodeDefault(&func () # Typedef<xmlDeregisterNodeFunc>->«F:void ( )*»
                             ) is native(LIB) returns () is export { * }

#-From /usr/include/libxml2/libxml/globals.h:187
#XMLPUBFUN xmlDeregisterNodeFunc XMLCALL xmlThrDefDeregisterNodeDefault(xmlDeregisterNodeFunc func);
sub xmlThrDefDeregisterNodeDefault(&func () # Typedef<xmlDeregisterNodeFunc>->«F:void ( )*»
                                   ) is native(LIB) returns () is export { * }

#-From /usr/include/libxml2/libxml/globals.h:190
#XMLPUBFUN xmlOutputBufferCreateFilenameFunc XMLCALL
#	xmlThrDefOutputBufferCreateFilenameDefault(xmlOutputBufferCreateFilenameFunc func);
sub xmlThrDefOutputBufferCreateFilenameDefault(&func ( --> _xmlOutputBuffer) # Typedef<xmlOutputBufferCreateFilenameFunc>->«F:Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*» ( )*»
                                               ) is native(LIB) returns ( --> _xmlOutputBuffer) is export { * }

#-From /usr/include/libxml2/libxml/globals.h:192
#XMLPUBFUN xmlParserInputBufferCreateFilenameFunc XMLCALL
#	xmlThrDefParserInputBufferCreateFilenameDefault(
sub xmlThrDefParserInputBufferCreateFilenameDefault(&func ( --> _xmlParserInputBuffer) # Typedef<xmlParserInputBufferCreateFilenameFunc>->«F:Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*» ( )*»
                                                    ) is native(LIB) returns ( --> _xmlParserInputBuffer) is export { * }

#-From /usr/include/libxml2/libxml/globals.h:306
##endif
#XMLPUBFUN xmlBufferAllocationScheme XMLCALL
#	xmlThrDefBufferAllocScheme(xmlBufferAllocationScheme v);
sub xmlThrDefBufferAllocScheme(int32 $v # Typedef<xmlBufferAllocationScheme>->«xmlBufferAllocationScheme»
                               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:315
##endif
#XMLPUBFUN int XMLCALL xmlThrDefDefaultBufferSize(int v);
sub xmlThrDefDefaultBufferSize(int32 $v # int
                               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:340
##endif
#XMLPUBFUN int XMLCALL xmlThrDefDoValidityCheckingDefaultValue(int v);
sub xmlThrDefDoValidityCheckingDefaultValue(int32 $v # int
                                            ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:381
##endif
#XMLPUBFUN int XMLCALL xmlThrDefGetWarningsDefaultValue(int v);
sub xmlThrDefGetWarningsDefaultValue(int32 $v # int
                                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:390
##endif
#XMLPUBFUN int XMLCALL xmlThrDefIndentTreeOutput(int v);
sub xmlThrDefIndentTreeOutput(int32 $v # int
                              ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:399
##endif
#XMLPUBFUN const char * XMLCALL xmlThrDefTreeIndentString(const char * v);
sub xmlThrDefTreeIndentString(Str $v # const char*
                              ) is native(LIB) returns Str is export { * }

#-From /usr/include/libxml2/libxml/globals.h:408
##endif
#XMLPUBFUN int XMLCALL xmlThrDefKeepBlanksDefaultValue(int v);
sub xmlThrDefKeepBlanksDefaultValue(int32 $v # int
                                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:417
##endif
#XMLPUBFUN int XMLCALL xmlThrDefLineNumbersDefaultValue(int v);
sub xmlThrDefLineNumbersDefaultValue(int32 $v # int
                                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:426
##endif
#XMLPUBFUN int XMLCALL xmlThrDefLoadExtDtdDefaultValue(int v);
sub xmlThrDefLoadExtDtdDefaultValue(int32 $v # int
                                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:435
##endif
#XMLPUBFUN int XMLCALL xmlThrDefParserDebugEntities(int v);
sub xmlThrDefParserDebugEntities(int32 $v # int
                                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:452
##endif
#XMLPUBFUN int XMLCALL xmlThrDefPedanticParserDefaultValue(int v);
sub xmlThrDefPedanticParserDefaultValue(int32 $v # int
                                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:461
##endif
#XMLPUBFUN int XMLCALL xmlThrDefSaveNoEmptyTags(int v);
sub xmlThrDefSaveNoEmptyTags(int32 $v # int
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/globals.h:470
##endif
#XMLPUBFUN int XMLCALL xmlThrDefSubstituteEntitiesDefaultValue(int v);
sub xmlThrDefSubstituteEntitiesDefaultValue(int32 $v # int
                                            ) is native(LIB) returns int32 is export { * }


# == /usr/include/libxml2/libxml/SAX.h ==

#-From /usr/include/libxml2/libxml/SAX.h:27
##ifdef __cplusplus
#extern "C" {
##endif
#XMLPUBFUN const xmlChar * XMLCALL
#		getPublicId			(void *ctx);
sub getPublicId(Pointer $ctx # void*
                ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:29
#XMLPUBFUN const xmlChar * XMLCALL
#		getSystemId			(void *ctx);
sub getSystemId(Pointer $ctx # void*
                ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:31
#XMLPUBFUN void XMLCALL
#		setDocumentLocator		(void *ctx,
sub setDocumentLocator(Pointer                       $ctx # void*
                      ,_xmlSAXLocator                $loc # Typedef<xmlSAXLocatorPtr>->«Typedef<xmlSAXLocator>->«_xmlSAXLocator»*»
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:35
#XMLPUBFUN int XMLCALL
#		getLineNumber			(void *ctx);
sub getLineNumber(Pointer $ctx # void*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:37
#XMLPUBFUN int XMLCALL
#		getColumnNumber			(void *ctx);
sub getColumnNumber(Pointer $ctx # void*
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:40
#XMLPUBFUN int XMLCALL
#		isStandalone			(void *ctx);
sub isStandalone(Pointer $ctx # void*
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:42
#XMLPUBFUN int XMLCALL
#		hasInternalSubset		(void *ctx);
sub hasInternalSubset(Pointer $ctx # void*
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:44
#XMLPUBFUN int XMLCALL
#		hasExternalSubset		(void *ctx);
sub hasExternalSubset(Pointer $ctx # void*
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:47
#XMLPUBFUN void XMLCALL
#		internalSubset			(void *ctx,
sub internalSubset(Pointer                       $ctx # void*
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:52
#XMLPUBFUN void XMLCALL
#		externalSubset			(void *ctx,
sub externalSubset(Pointer                       $ctx # void*
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:57
#XMLPUBFUN xmlEntityPtr XMLCALL
#		getEntity			(void *ctx,
sub getEntity(Pointer                       $ctx # void*
             ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:60
#XMLPUBFUN xmlEntityPtr XMLCALL
#		getParameterEntity		(void *ctx,
sub getParameterEntity(Pointer                       $ctx # void*
                      ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                       ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:63
#XMLPUBFUN xmlParserInputPtr XMLCALL
#		resolveEntity			(void *ctx,
sub resolveEntity(Pointer                       $ctx # void*
                 ,Pointer[xmlChar]              $publicId # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $systemId # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns _xmlParserInput is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:68
#XMLPUBFUN void XMLCALL
#		entityDecl			(void *ctx,
sub entityDecl(Pointer                       $ctx # void*
              ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
              ,int32                         $type # int
              ,Pointer[xmlChar]              $publicId # const Typedef<xmlChar>->«unsigned char»*
              ,Pointer[xmlChar]              $systemId # const Typedef<xmlChar>->«unsigned char»*
              ,Pointer[xmlChar]              $content # Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:75
#XMLPUBFUN void XMLCALL
#		attributeDecl			(void *ctx,
sub attributeDecl(Pointer                       $ctx # void*
                 ,Pointer[xmlChar]              $elem # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $fullname # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $type # int
                 ,int32                         $def # int
                 ,Pointer[xmlChar]              $defaultValue # const Typedef<xmlChar>->«unsigned char»*
                 ,_xmlEnumeration               $tree # Typedef<xmlEnumerationPtr>->«Typedef<xmlEnumeration>->«_xmlEnumeration»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:83
#XMLPUBFUN void XMLCALL
#		elementDecl			(void *ctx,
sub elementDecl(Pointer                       $ctx # void*
               ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
               ,int32                         $type # int
               ,_xmlElementContent            $content # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:88
#XMLPUBFUN void XMLCALL
#		notationDecl			(void *ctx,
sub notationDecl(Pointer                       $ctx # void*
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $publicId # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $systemId # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:93
#XMLPUBFUN void XMLCALL
#		unparsedEntityDecl		(void *ctx,
sub unparsedEntityDecl(Pointer                       $ctx # void*
                      ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $publicId # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $systemId # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $notationName # const Typedef<xmlChar>->«unsigned char»*
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:100
#XMLPUBFUN void XMLCALL
#		startDocument			(void *ctx);
sub startDocument(Pointer $ctx # void*
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:102
#XMLPUBFUN void XMLCALL
#		endDocument			(void *ctx);
sub endDocument(Pointer $ctx # void*
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:104
#XMLPUBFUN void XMLCALL
#		attribute			(void *ctx,
sub attribute(Pointer                       $ctx # void*
             ,Pointer[xmlChar]              $fullname # const Typedef<xmlChar>->«unsigned char»*
             ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:108
#XMLPUBFUN void XMLCALL
#		startElement			(void *ctx,
sub startElement(Pointer                       $ctx # void*
                ,Pointer[xmlChar]              $fullname # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[Pointer[xmlChar]]     $atts # const Typedef<xmlChar>->«unsigned char»**
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:112
#XMLPUBFUN void XMLCALL
#		endElement			(void *ctx,
sub endElement(Pointer                       $ctx # void*
              ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:115
#XMLPUBFUN void XMLCALL
#		reference			(void *ctx,
sub reference(Pointer                       $ctx # void*
             ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:118
#XMLPUBFUN void XMLCALL
#		characters			(void *ctx,
sub characters(Pointer                       $ctx # void*
              ,Pointer[xmlChar]              $ch # const Typedef<xmlChar>->«unsigned char»*
              ,int32                         $len # int
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:122
#XMLPUBFUN void XMLCALL
#		ignorableWhitespace		(void *ctx,
sub ignorableWhitespace(Pointer                       $ctx # void*
                       ,Pointer[xmlChar]              $ch # const Typedef<xmlChar>->«unsigned char»*
                       ,int32                         $len # int
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:126
#XMLPUBFUN void XMLCALL
#		processingInstruction		(void *ctx,
sub processingInstruction(Pointer                       $ctx # void*
                         ,Pointer[xmlChar]              $target # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $data # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:130
#XMLPUBFUN void XMLCALL
#		globalNamespace			(void *ctx,
sub globalNamespace(Pointer                       $ctx # void*
                   ,Pointer[xmlChar]              $href # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:134
#XMLPUBFUN void XMLCALL
#		setNamespace			(void *ctx,
sub setNamespace(Pointer                       $ctx # void*
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:137
#XMLPUBFUN xmlNsPtr XMLCALL
#		getNamespace			(void *ctx);
sub getNamespace(Pointer $ctx # void*
                 ) is native(LIB) returns _xmlNs is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:139
#XMLPUBFUN int XMLCALL
#		checkNamespace			(void *ctx,
sub checkNamespace(Pointer                       $ctx # void*
                  ,Pointer[xmlChar]              $nameSpace # Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:142
#XMLPUBFUN void XMLCALL
#		namespaceDecl			(void *ctx,
sub namespaceDecl(Pointer                       $ctx # void*
                 ,Pointer[xmlChar]              $href # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:146
#XMLPUBFUN void XMLCALL
#		comment				(void *ctx,
sub comment(Pointer                       $ctx # void*
           ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
            ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:149
#XMLPUBFUN void XMLCALL
#		cdataBlock			(void *ctx,
sub cdataBlock(Pointer                       $ctx # void*
              ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
              ,int32                         $len # int
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:155
##ifdef LIBXML_SAX1_ENABLED
#XMLPUBFUN void XMLCALL
#		initxmlDefaultSAXHandler	(xmlSAXHandlerV1 *hdlr,
sub initxmlDefaultSAXHandler(_xmlSAXHandlerV1              $hdlr # Typedef<xmlSAXHandlerV1>->«_xmlSAXHandlerV1»*
                            ,int32                         $warning # int
                             ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:159
##ifdef LIBXML_HTML_ENABLED
#XMLPUBFUN void XMLCALL
#		inithtmlDefaultSAXHandler	(xmlSAXHandlerV1 *hdlr);
sub inithtmlDefaultSAXHandler(_xmlSAXHandlerV1 $hdlr # Typedef<xmlSAXHandlerV1>->«_xmlSAXHandlerV1»*
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX.h:163
##endif
##ifdef LIBXML_DOCB_ENABLED
#XMLPUBFUN void XMLCALL
#		initdocbDefaultSAXHandler	(xmlSAXHandlerV1 *hdlr);
sub initdocbDefaultSAXHandler(_xmlSAXHandlerV1 $hdlr # Typedef<xmlSAXHandlerV1>->«_xmlSAXHandlerV1»*
                              ) is native(LIB)  is export { * }


# == /usr/include/unicode/uenum.h ==

#-From /usr/include/unicode/uenum.h:49
#/**
# * Disposes of resources in use by the iterator.  If en is NULL,
# * does nothing.  After this call, any char* or UChar* pointer
# * returned by uenum_unext() or uenum_next() is invalid.
# * @param en UEnumeration structure pointer
# * @stable ICU 2.2
# */
#U_STABLE void U_EXPORT2
#uenum_close(UEnumeration* en);
sub uenum_close_57(UEnumeration $en # Typedef<UEnumeration>->«UEnumeration»*
                   ) is native(LIB)  is export { * }

#-From /usr/include/unicode/uenum.h:85
#/**
# * Returns the number of elements that the iterator traverses.  If
# * the iterator is out-of-sync with its service, status is set to
# * U_ENUM_OUT_OF_SYNC_ERROR.
# * This is a convenience function. It can end up being very
# * expensive as all the items might have to be pre-fetched (depending
# * on the type of data being traversed). Use with caution and only 
# * when necessary.
# * @param en UEnumeration structure pointer
# * @param status error code, can be U_ENUM_OUT_OF_SYNC_ERROR if the
# *               iterator is out of sync.
# * @return number of elements in the iterator
# * @stable ICU 2.2
# */
#U_STABLE int32_t U_EXPORT2
#uenum_count(UEnumeration* en, UErrorCode* status);
sub uenum_count_57(UEnumeration                  $en # Typedef<UEnumeration>->«UEnumeration»*
                  ,Pointer[int32]                $status # Typedef<UErrorCode>->«UErrorCode»*
                   ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/uenum.h:109
#/**
# * Returns the next element in the iterator's list.  If there are
# * no more elements, returns NULL.  If the iterator is out-of-sync
# * with its service, status is set to U_ENUM_OUT_OF_SYNC_ERROR and
# * NULL is returned.  If the native service string is a char* string,
# * it is converted to UChar* with the invariant converter.
# * The result is terminated by (UChar)0.
# * @param en the iterator object
# * @param resultLength pointer to receive the length of the result
# *                     (not including the terminating \\0).
# *                     If the pointer is NULL it is ignored.
# * @param status the error code, set to U_ENUM_OUT_OF_SYNC_ERROR if
# *               the iterator is out of sync with its service.
# * @return a pointer to the string.  The string will be
# *         zero-terminated.  The return pointer is owned by this iterator
# *         and must not be deleted by the caller.  The pointer is valid
# *         until the next call to any uenum_... method, including
# *         uenum_next() or uenum_unext().  When all strings have been
# *         traversed, returns NULL.
# * @stable ICU 2.2
# */
#U_STABLE const UChar* U_EXPORT2
#uenum_unext(UEnumeration* en,
sub uenum_unext_57(UEnumeration                  $en # Typedef<UEnumeration>->«UEnumeration»*
                  ,Pointer[int32_t]              $resultLength # Typedef<int32_t>->«int»*
                  ,Pointer[int32]                $status # Typedef<UErrorCode>->«UErrorCode»*
                   ) is native(LIB) returns Pointer[UChar] is export { * }

#-From /usr/include/unicode/uenum.h:142
#/**
# * Returns the next element in the iterator's list.  If there are
# * no more elements, returns NULL.  If the iterator is out-of-sync
# * with its service, status is set to U_ENUM_OUT_OF_SYNC_ERROR and
# * NULL is returned.  If the native service string is a UChar*
# * string, it is converted to char* with the invariant converter.
# * The result is terminated by (char)0.  If the conversion fails
# * (because a character cannot be converted) then status is set to
# * U_INVARIANT_CONVERSION_ERROR and the return value is undefined
# * (but non-NULL).
# * @param en the iterator object
# * @param resultLength pointer to receive the length of the result
# *                     (not including the terminating \\0).
# *                     If the pointer is NULL it is ignored.
# * @param status the error code, set to U_ENUM_OUT_OF_SYNC_ERROR if
# *               the iterator is out of sync with its service.  Set to
# *               U_INVARIANT_CONVERSION_ERROR if the underlying native string is
# *               UChar* and conversion to char* with the invariant converter
# *               fails. This error pertains only to current string, so iteration
# *               might be able to continue successfully.
# * @return a pointer to the string.  The string will be
# *         zero-terminated.  The return pointer is owned by this iterator
# *         and must not be deleted by the caller.  The pointer is valid
# *         until the next call to any uenum_... method, including
# *         uenum_next() or uenum_unext().  When all strings have been
# *         traversed, returns NULL.
# * @stable ICU 2.2
# */
#U_STABLE const char* U_EXPORT2
#uenum_next(UEnumeration* en,
sub uenum_next_57(UEnumeration                  $en # Typedef<UEnumeration>->«UEnumeration»*
                 ,Pointer[int32_t]              $resultLength # Typedef<int32_t>->«int»*
                 ,Pointer[int32]                $status # Typedef<UErrorCode>->«UErrorCode»*
                  ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/uenum.h:156
#/**
# * Resets the iterator to the current list of service IDs.  This
# * re-establishes sync with the service and rewinds the iterator
# * to start at the first element.
# * @param en the iterator object
# * @param status the error code, set to U_ENUM_OUT_OF_SYNC_ERROR if
# *               the iterator is out of sync with its service.  
# * @stable ICU 2.2
# */
#U_STABLE void U_EXPORT2
#uenum_reset(UEnumeration* en, UErrorCode* status);
sub uenum_reset_57(UEnumeration                  $en # Typedef<UEnumeration>->«UEnumeration»*
                  ,Pointer[int32]                $status # Typedef<UErrorCode>->«UErrorCode»*
                   ) is native(LIB)  is export { * }

#-From /usr/include/unicode/uenum.h:186
#/**
# * Given an array of const UChar* strings, return a UEnumeration.  String pointers from 0..count-1 must not be null.
# * Do not free or modify either the string array or the characters it points to until this object has been destroyed with uenum_close.
# * \snippet test/cintltst/uenumtst.c uenum_openUCharStringsEnumeration
# * @param strings array of const UChar* strings (each null terminated). All storage is owned by the caller.
# * @param count length of the array
# * @param ec error code
# * @return the new UEnumeration object. Caller is responsible for calling uenum_close to free memory.
# * @see uenum_close
# * @stable ICU 50
# */
#U_STABLE UEnumeration* U_EXPORT2
#uenum_openUCharStringsEnumeration(const UChar* const strings[], int32_t count,
sub uenum_openUCharStringsEnumeration_57(Pointer[Pointer[UChar]]       $strings # const const Typedef<UChar>->«short unsigned int»**
                                        ,int32_t                       $count # Typedef<int32_t>->«int»
                                        ,Pointer[int32]                $ec # Typedef<UErrorCode>->«UErrorCode»*
                                         ) is native(LIB) returns UEnumeration is export { * }

#-From /usr/include/unicode/uenum.h:203
#/**
# * Given an array of const char* strings (invariant chars only), return a UEnumeration.  String pointers from 0..count-1 must not be null.
# * Do not free or modify either the string array or the characters it points to until this object has been destroyed with uenum_close.
# * \snippet test/cintltst/uenumtst.c uenum_openCharStringsEnumeration
# * @param strings array of char* strings (each null terminated).  All storage is owned by the caller.
# * @param count length of the array
# * @param ec error code
# * @return the new UEnumeration object. Caller is responsible for calling uenum_close to free memory
# * @see uenum_close
# * @stable ICU 50
# */
#U_STABLE UEnumeration* U_EXPORT2
#uenum_openCharStringsEnumeration(const char* const strings[], int32_t count,
sub uenum_openCharStringsEnumeration_57(Pointer[Str]                  $strings # const const char**
                                       ,int32_t                       $count # Typedef<int32_t>->«int»
                                       ,Pointer[int32]                $ec # Typedef<UErrorCode>->«UErrorCode»*
                                        ) is native(LIB) returns UEnumeration is export { * }


# == /usr/include/libxml2/libxml/valid.h ==

#-From /usr/include/libxml2/libxml/valid.h:154
#/* Notation */
#XMLPUBFUN xmlNotationPtr XMLCALL
#		xmlAddNotationDecl	(xmlValidCtxtPtr ctxt,
sub xmlAddNotationDecl(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                      ,_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                      ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $PublicID # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                       ) is native(LIB) returns _xmlNotation is export { * }

#-From /usr/include/libxml2/libxml/valid.h:161
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN xmlNotationTablePtr XMLCALL
#		xmlCopyNotationTable	(xmlNotationTablePtr table);
sub xmlCopyNotationTable(_xmlHashTable $table # Typedef<xmlNotationTablePtr>->«Typedef<xmlNotationTable>->«_xmlHashTable»*»
                         ) is native(LIB) returns _xmlHashTable is export { * }

#-From /usr/include/libxml2/libxml/valid.h:164
##endif /* LIBXML_TREE_ENABLED */
#XMLPUBFUN void XMLCALL
#		xmlFreeNotationTable	(xmlNotationTablePtr table);
sub xmlFreeNotationTable(_xmlHashTable $table # Typedef<xmlNotationTablePtr>->«Typedef<xmlNotationTable>->«_xmlHashTable»*»
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:167
##ifdef LIBXML_OUTPUT_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlDumpNotationDecl	(xmlBufferPtr buf,
sub xmlDumpNotationDecl(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                       ,_xmlNotation                  $nota # Typedef<xmlNotationPtr>->«Typedef<xmlNotation>->«_xmlNotation»*»
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:170
#XMLPUBFUN void XMLCALL
#		xmlDumpNotationTable	(xmlBufferPtr buf,
sub xmlDumpNotationTable(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                        ,_xmlHashTable                 $table # Typedef<xmlNotationTablePtr>->«Typedef<xmlNotationTable>->«_xmlHashTable»*»
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:177
#/* Element Content */
#/* the non Doc version are being deprecated */
#XMLPUBFUN xmlElementContentPtr XMLCALL
#		xmlNewElementContent	(const xmlChar *name,
sub xmlNewElementContent(Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                        ,int32                         $type # Typedef<xmlElementContentType>->«xmlElementContentType»
                         ) is native(LIB) returns _xmlElementContent is export { * }

#-From /usr/include/libxml2/libxml/valid.h:180
#XMLPUBFUN xmlElementContentPtr XMLCALL
#		xmlCopyElementContent	(xmlElementContentPtr content);
sub xmlCopyElementContent(_xmlElementContent $content # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                          ) is native(LIB) returns _xmlElementContent is export { * }

#-From /usr/include/libxml2/libxml/valid.h:182
#XMLPUBFUN void XMLCALL
#		xmlFreeElementContent	(xmlElementContentPtr cur);
sub xmlFreeElementContent(_xmlElementContent $cur # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:185
#/* the new versions with doc argument */
#XMLPUBFUN xmlElementContentPtr XMLCALL
#		xmlNewDocElementContent	(xmlDocPtr doc,
sub xmlNewDocElementContent(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                           ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                           ,int32                         $type # Typedef<xmlElementContentType>->«xmlElementContentType»
                            ) is native(LIB) returns _xmlElementContent is export { * }

#-From /usr/include/libxml2/libxml/valid.h:189
#XMLPUBFUN xmlElementContentPtr XMLCALL
#		xmlCopyDocElementContent(xmlDocPtr doc,
sub xmlCopyDocElementContent(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                            ,_xmlElementContent            $content # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                             ) is native(LIB) returns _xmlElementContent is export { * }

#-From /usr/include/libxml2/libxml/valid.h:192
#XMLPUBFUN void XMLCALL
#		xmlFreeDocElementContent(xmlDocPtr doc,
sub xmlFreeDocElementContent(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                            ,_xmlElementContent            $cur # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                             ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:195
#XMLPUBFUN void XMLCALL
#		xmlSnprintfElementContent(char *buf,
sub xmlSnprintfElementContent(Str                           $buf # char*
                             ,int32                         $size # int
                             ,_xmlElementContent            $content # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                             ,int32                         $englob # int
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:202
##ifdef LIBXML_OUTPUT_ENABLED
#/* DEPRECATED */
#XMLPUBFUN void XMLCALL
#		xmlSprintfElementContent(char *buf,
sub xmlSprintfElementContent(Str                           $buf # char*
                            ,_xmlElementContent            $content # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                            ,int32                         $englob # int
                             ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:210
#/* Element */
#XMLPUBFUN xmlElementPtr XMLCALL
#		xmlAddElementDecl	(xmlValidCtxtPtr ctxt,
sub xmlAddElementDecl(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                     ,_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                     ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                     ,int32                         $type # Typedef<xmlElementTypeVal>->«xmlElementTypeVal»
                     ,_xmlElementContent            $content # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                      ) is native(LIB) returns _xmlElement is export { * }

#-From /usr/include/libxml2/libxml/valid.h:217
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN xmlElementTablePtr XMLCALL
#		xmlCopyElementTable	(xmlElementTablePtr table);
sub xmlCopyElementTable(_xmlHashTable $table # Typedef<xmlElementTablePtr>->«Typedef<xmlElementTable>->«_xmlHashTable»*»
                        ) is native(LIB) returns _xmlHashTable is export { * }

#-From /usr/include/libxml2/libxml/valid.h:220
##endif /* LIBXML_TREE_ENABLED */
#XMLPUBFUN void XMLCALL
#		xmlFreeElementTable	(xmlElementTablePtr table);
sub xmlFreeElementTable(_xmlHashTable $table # Typedef<xmlElementTablePtr>->«Typedef<xmlElementTable>->«_xmlHashTable»*»
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:223
##ifdef LIBXML_OUTPUT_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlDumpElementTable	(xmlBufferPtr buf,
sub xmlDumpElementTable(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                       ,_xmlHashTable                 $table # Typedef<xmlElementTablePtr>->«Typedef<xmlElementTable>->«_xmlHashTable»*»
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:226
#XMLPUBFUN void XMLCALL
#		xmlDumpElementDecl	(xmlBufferPtr buf,
sub xmlDumpElementDecl(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                      ,_xmlElement                   $elem # Typedef<xmlElementPtr>->«Typedef<xmlElement>->«_xmlElement»*»
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:232
#/* Enumeration */
#XMLPUBFUN xmlEnumerationPtr XMLCALL
#		xmlCreateEnumeration	(const xmlChar *name);
sub xmlCreateEnumeration(Pointer[xmlChar] $name # const Typedef<xmlChar>->«unsigned char»*
                         ) is native(LIB) returns _xmlEnumeration is export { * }

#-From /usr/include/libxml2/libxml/valid.h:234
#XMLPUBFUN void XMLCALL
#		xmlFreeEnumeration	(xmlEnumerationPtr cur);
sub xmlFreeEnumeration(_xmlEnumeration $cur # Typedef<xmlEnumerationPtr>->«Typedef<xmlEnumeration>->«_xmlEnumeration»*»
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:237
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN xmlEnumerationPtr XMLCALL
#		xmlCopyEnumeration	(xmlEnumerationPtr cur);
sub xmlCopyEnumeration(_xmlEnumeration $cur # Typedef<xmlEnumerationPtr>->«Typedef<xmlEnumeration>->«_xmlEnumeration»*»
                       ) is native(LIB) returns _xmlEnumeration is export { * }

#-From /usr/include/libxml2/libxml/valid.h:242
#/* Attribute */
#XMLPUBFUN xmlAttributePtr XMLCALL
#		xmlAddAttributeDecl	(xmlValidCtxtPtr ctxt,
sub xmlAddAttributeDecl(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                       ,_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                       ,Pointer[xmlChar]              $elem # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $ns # const Typedef<xmlChar>->«unsigned char»*
                       ,int32                         $type # Typedef<xmlAttributeType>->«xmlAttributeType»
                       ,int32                         $def # Typedef<xmlAttributeDefault>->«xmlAttributeDefault»
                       ,Pointer[xmlChar]              $defaultValue # const Typedef<xmlChar>->«unsigned char»*
                       ,_xmlEnumeration               $tree # Typedef<xmlEnumerationPtr>->«Typedef<xmlEnumeration>->«_xmlEnumeration»*»
                        ) is native(LIB) returns _xmlAttribute is export { * }

#-From /usr/include/libxml2/libxml/valid.h:253
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN xmlAttributeTablePtr XMLCALL
#		xmlCopyAttributeTable  (xmlAttributeTablePtr table);
sub xmlCopyAttributeTable(_xmlHashTable $table # Typedef<xmlAttributeTablePtr>->«Typedef<xmlAttributeTable>->«_xmlHashTable»*»
                          ) is native(LIB) returns _xmlHashTable is export { * }

#-From /usr/include/libxml2/libxml/valid.h:256
##endif /* LIBXML_TREE_ENABLED */
#XMLPUBFUN void XMLCALL
#		xmlFreeAttributeTable  (xmlAttributeTablePtr table);
sub xmlFreeAttributeTable(_xmlHashTable $table # Typedef<xmlAttributeTablePtr>->«Typedef<xmlAttributeTable>->«_xmlHashTable»*»
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:259
##ifdef LIBXML_OUTPUT_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlDumpAttributeTable  (xmlBufferPtr buf,
sub xmlDumpAttributeTable(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                         ,_xmlHashTable                 $table # Typedef<xmlAttributeTablePtr>->«Typedef<xmlAttributeTable>->«_xmlHashTable»*»
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:262
#XMLPUBFUN void XMLCALL
#		xmlDumpAttributeDecl   (xmlBufferPtr buf,
sub xmlDumpAttributeDecl(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                        ,_xmlAttribute                 $attr # Typedef<xmlAttributePtr>->«Typedef<xmlAttribute>->«_xmlAttribute»*»
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:268
#/* IDs */
#XMLPUBFUN xmlIDPtr XMLCALL
#		xmlAddID	       (xmlValidCtxtPtr ctxt,
sub xmlAddID(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
            ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
            ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
            ,_xmlAttr                      $attr # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
             ) is native(LIB) returns _xmlID is export { * }

#-From /usr/include/libxml2/libxml/valid.h:273
#XMLPUBFUN void XMLCALL
#		xmlFreeIDTable	       (xmlIDTablePtr table);
sub xmlFreeIDTable(_xmlHashTable $table # Typedef<xmlIDTablePtr>->«Typedef<xmlIDTable>->«_xmlHashTable»*»
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:275
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlGetID	       (xmlDocPtr doc,
sub xmlGetID(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
            ,Pointer[xmlChar]              $ID # const Typedef<xmlChar>->«unsigned char»*
             ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/valid.h:278
#XMLPUBFUN int XMLCALL
#		xmlIsID		       (xmlDocPtr doc,
sub xmlIsID(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
           ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
           ,_xmlAttr                      $attr # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
            ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:282
#XMLPUBFUN int XMLCALL
#		xmlRemoveID	       (xmlDocPtr doc,
sub xmlRemoveID(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
               ,_xmlAttr                      $attr # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:287
#/* IDREFs */
#XMLPUBFUN xmlRefPtr XMLCALL
#		xmlAddRef	       (xmlValidCtxtPtr ctxt,
sub xmlAddRef(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
             ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
             ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
             ,_xmlAttr                      $attr # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
              ) is native(LIB) returns _xmlRef is export { * }

#-From /usr/include/libxml2/libxml/valid.h:292
#XMLPUBFUN void XMLCALL
#		xmlFreeRefTable	       (xmlRefTablePtr table);
sub xmlFreeRefTable(_xmlHashTable $table # Typedef<xmlRefTablePtr>->«Typedef<xmlRefTable>->«_xmlHashTable»*»
                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:294
#XMLPUBFUN int XMLCALL
#		xmlIsRef	       (xmlDocPtr doc,
sub xmlIsRef(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
            ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
            ,_xmlAttr                      $attr # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:298
#XMLPUBFUN int XMLCALL
#		xmlRemoveRef	       (xmlDocPtr doc,
sub xmlRemoveRef(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                ,_xmlAttr                      $attr # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:301
#XMLPUBFUN xmlListPtr XMLCALL
#		xmlGetRefs	       (xmlDocPtr doc,
sub xmlGetRefs(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
              ,Pointer[xmlChar]              $ID # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB) returns _xmlList is export { * }

#-From /usr/include/libxml2/libxml/valid.h:310
#/**
# * The public function calls related to validity checking.
# */
##ifdef LIBXML_VALID_ENABLED
#/* Allocate/Release Validation Contexts */
#XMLPUBFUN xmlValidCtxtPtr XMLCALL
#		xmlNewValidCtxt(void);
sub xmlNewValidCtxt(
                    ) is native(LIB) returns _xmlValidCtxt is export { * }

#-From /usr/include/libxml2/libxml/valid.h:312
#XMLPUBFUN void XMLCALL
#		xmlFreeValidCtxt(xmlValidCtxtPtr);
sub xmlFreeValidCtxt(_xmlValidCtxt  # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/valid.h:315
#XMLPUBFUN int XMLCALL
#		xmlValidateRoot		(xmlValidCtxtPtr ctxt,
sub xmlValidateRoot(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                   ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:318
#XMLPUBFUN int XMLCALL
#		xmlValidateElementDecl	(xmlValidCtxtPtr ctxt,
sub xmlValidateElementDecl(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                          ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                          ,_xmlElement                   $elem # Typedef<xmlElementPtr>->«Typedef<xmlElement>->«_xmlElement»*»
                           ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:322
#XMLPUBFUN xmlChar * XMLCALL
#		xmlValidNormalizeAttributeValue(xmlDocPtr doc,
sub xmlValidNormalizeAttributeValue(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                                   ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                                   ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                                    ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/valid.h:327
#XMLPUBFUN xmlChar * XMLCALL
#		xmlValidCtxtNormalizeAttributeValue(xmlValidCtxtPtr ctxt,
sub xmlValidCtxtNormalizeAttributeValue(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                                       ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                                       ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                                       ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                                       ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                                        ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/valid.h:333
#XMLPUBFUN int XMLCALL
#		xmlValidateAttributeDecl(xmlValidCtxtPtr ctxt,
sub xmlValidateAttributeDecl(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                            ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                            ,_xmlAttribute                 $attr # Typedef<xmlAttributePtr>->«Typedef<xmlAttribute>->«_xmlAttribute»*»
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:337
#XMLPUBFUN int XMLCALL
#		xmlValidateAttributeValue(xmlAttributeType type,
sub xmlValidateAttributeValue(int32                         $type # Typedef<xmlAttributeType>->«xmlAttributeType»
                             ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                              ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:340
#XMLPUBFUN int XMLCALL
#		xmlValidateNotationDecl	(xmlValidCtxtPtr ctxt,
sub xmlValidateNotationDecl(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                           ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                           ,_xmlNotation                  $nota # Typedef<xmlNotationPtr>->«Typedef<xmlNotation>->«_xmlNotation»*»
                            ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:344
#XMLPUBFUN int XMLCALL
#		xmlValidateDtd		(xmlValidCtxtPtr ctxt,
sub xmlValidateDtd(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                  ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                  ,_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:348
#XMLPUBFUN int XMLCALL
#		xmlValidateDtdFinal	(xmlValidCtxtPtr ctxt,
sub xmlValidateDtdFinal(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                       ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:351
#XMLPUBFUN int XMLCALL
#		xmlValidateDocument	(xmlValidCtxtPtr ctxt,
sub xmlValidateDocument(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                       ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:354
#XMLPUBFUN int XMLCALL
#		xmlValidateElement	(xmlValidCtxtPtr ctxt,
sub xmlValidateElement(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                      ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                      ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:358
#XMLPUBFUN int XMLCALL
#		xmlValidateOneElement	(xmlValidCtxtPtr ctxt,
sub xmlValidateOneElement(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                         ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                         ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:362
#XMLPUBFUN int XMLCALL
#		xmlValidateOneAttribute	(xmlValidCtxtPtr ctxt,
sub xmlValidateOneAttribute(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                           ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                           ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                           ,_xmlAttr                      $attr # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                           ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                            ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:368
#XMLPUBFUN int XMLCALL
#		xmlValidateOneNamespace	(xmlValidCtxtPtr ctxt,
sub xmlValidateOneNamespace(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                           ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                           ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                           ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                           ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                           ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                            ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:375
#XMLPUBFUN int XMLCALL
#		xmlValidateDocumentFinal(xmlValidCtxtPtr ctxt,
sub xmlValidateDocumentFinal(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                            ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:381
##if defined(LIBXML_VALID_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#XMLPUBFUN int XMLCALL
#		xmlValidateNotationUse	(xmlValidCtxtPtr ctxt,
sub xmlValidateNotationUse(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                          ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                          ,Pointer[xmlChar]              $notationName # const Typedef<xmlChar>->«unsigned char»*
                           ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:387
#XMLPUBFUN int XMLCALL
#		xmlIsMixedElement	(xmlDocPtr doc,
sub xmlIsMixedElement(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                     ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:390
#XMLPUBFUN xmlAttributePtr XMLCALL
#		xmlGetDtdAttrDesc	(xmlDtdPtr dtd,
sub xmlGetDtdAttrDesc(_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                     ,Pointer[xmlChar]              $elem # const Typedef<xmlChar>->«unsigned char»*
                     ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB) returns _xmlAttribute is export { * }

#-From /usr/include/libxml2/libxml/valid.h:394
#XMLPUBFUN xmlAttributePtr XMLCALL
#		xmlGetDtdQAttrDesc	(xmlDtdPtr dtd,
sub xmlGetDtdQAttrDesc(_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                      ,Pointer[xmlChar]              $elem # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                       ) is native(LIB) returns _xmlAttribute is export { * }

#-From /usr/include/libxml2/libxml/valid.h:399
#XMLPUBFUN xmlNotationPtr XMLCALL
#		xmlGetDtdNotationDesc	(xmlDtdPtr dtd,
sub xmlGetDtdNotationDesc(_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                         ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB) returns _xmlNotation is export { * }

#-From /usr/include/libxml2/libxml/valid.h:402
#XMLPUBFUN xmlElementPtr XMLCALL
#		xmlGetDtdQElementDesc	(xmlDtdPtr dtd,
sub xmlGetDtdQElementDesc(_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                         ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB) returns _xmlElement is export { * }

#-From /usr/include/libxml2/libxml/valid.h:406
#XMLPUBFUN xmlElementPtr XMLCALL
#		xmlGetDtdElementDesc	(xmlDtdPtr dtd,
sub xmlGetDtdElementDesc(_xmlDtd                       $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
                        ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                         ) is native(LIB) returns _xmlElement is export { * }

#-From /usr/include/libxml2/libxml/valid.h:412
#XMLPUBFUN int XMLCALL
#		xmlValidGetPotentialChildren(xmlElementContent *ctree,
sub xmlValidGetPotentialChildren(_xmlElementContent            $ctree # Typedef<xmlElementContent>->«_xmlElementContent»*
                                ,Pointer[Pointer[xmlChar]]     $names # const Typedef<xmlChar>->«unsigned char»**
                                ,Pointer[int32]                $len # int*
                                ,int32                         $max # int
                                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:418
#XMLPUBFUN int XMLCALL
#		xmlValidGetValidElements(xmlNode *prev,
sub xmlValidGetValidElements(_xmlNode                      $prev # Typedef<xmlNode>->«_xmlNode»*
                            ,_xmlNode                      $next # Typedef<xmlNode>->«_xmlNode»*
                            ,Pointer[Pointer[xmlChar]]     $names # const Typedef<xmlChar>->«unsigned char»**
                            ,int32                         $max # int
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:423
#XMLPUBFUN int XMLCALL
#		xmlValidateNameValue	(const xmlChar *value);
sub xmlValidateNameValue(Pointer[xmlChar] $value # const Typedef<xmlChar>->«unsigned char»*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:425
#XMLPUBFUN int XMLCALL
#		xmlValidateNamesValue	(const xmlChar *value);
sub xmlValidateNamesValue(Pointer[xmlChar] $value # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:427
#XMLPUBFUN int XMLCALL
#		xmlValidateNmtokenValue	(const xmlChar *value);
sub xmlValidateNmtokenValue(Pointer[xmlChar] $value # const Typedef<xmlChar>->«unsigned char»*
                            ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:429
#XMLPUBFUN int XMLCALL
#		xmlValidateNmtokensValue(const xmlChar *value);
sub xmlValidateNmtokensValue(Pointer[xmlChar] $value # const Typedef<xmlChar>->«unsigned char»*
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:436
##ifdef LIBXML_REGEXP_ENABLED
#/*
# * Validation based on the regexp support
# */
#XMLPUBFUN int XMLCALL
#		xmlValidBuildContentModel(xmlValidCtxtPtr ctxt,
sub xmlValidBuildContentModel(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                             ,_xmlElement                   $elem # Typedef<xmlElementPtr>->«Typedef<xmlElement>->«_xmlElement»*»
                              ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:440
#XMLPUBFUN int XMLCALL
#		xmlValidatePushElement	(xmlValidCtxtPtr ctxt,
sub xmlValidatePushElement(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                          ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                          ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                          ,Pointer[xmlChar]              $qname # const Typedef<xmlChar>->«unsigned char»*
                           ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:445
#XMLPUBFUN int XMLCALL
#		xmlValidatePushCData	(xmlValidCtxtPtr ctxt,
sub xmlValidatePushCData(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                        ,Pointer[xmlChar]              $data # const Typedef<xmlChar>->«unsigned char»*
                        ,int32                         $len # int
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/valid.h:449
#XMLPUBFUN int XMLCALL
#		xmlValidatePopElement	(xmlValidCtxtPtr ctxt,
sub xmlValidatePopElement(_xmlValidCtxt                 $ctxt # Typedef<xmlValidCtxtPtr>->«Typedef<xmlValidCtxt>->«_xmlValidCtxt»*»
                         ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                         ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                         ,Pointer[xmlChar]              $qname # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB) returns int32 is export { * }


# == /usr/include/libxml2/libxml/xmlmemory.h ==

#-From /usr/include/libxml2/libxml/xmlmemory.h:104
#/*
# * The way to overload the existing functions.
# * The xmlGc function have an extra entry for atomic block
# * allocations useful for garbage collected memory allocators
# */
#XMLPUBFUN int XMLCALL
#	xmlMemSetup	(xmlFreeFunc freeFunc,
sub xmlMemSetup(&freeFunc () # Typedef<xmlFreeFunc>->«F:void ( )*»
               ,&mallocFunc ( --> Pointer) # Typedef<xmlMallocFunc>->«F:void* ( )*»
               ,&reallocFunc ( --> Pointer) # Typedef<xmlReallocFunc>->«F:void* ( )*»
               ,&strdupFunc ( --> Str) # Typedef<xmlStrdupFunc>->«F:char* ( )*»
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:109
#XMLPUBFUN int XMLCALL
#	xmlMemGet	(xmlFreeFunc *freeFunc,
sub xmlMemGet(Pointer[()]                   $freeFunc # Typedef<xmlFreeFunc>->«F:void ( )*»*
             ,Pointer[( --> Pointer)]       $mallocFunc # Typedef<xmlMallocFunc>->«F:void* ( )*»*
             ,Pointer[( --> Pointer)]       $reallocFunc # Typedef<xmlReallocFunc>->«F:void* ( )*»*
             ,Pointer[( --> Str)]           $strdupFunc # Typedef<xmlStrdupFunc>->«F:char* ( )*»*
              ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:114
#XMLPUBFUN int XMLCALL
#	xmlGcMemSetup	(xmlFreeFunc freeFunc,
sub xmlGcMemSetup(&freeFunc () # Typedef<xmlFreeFunc>->«F:void ( )*»
                 ,&mallocFunc ( --> Pointer) # Typedef<xmlMallocFunc>->«F:void* ( )*»
                 ,&mallocAtomicFunc ( --> Pointer) # Typedef<xmlMallocFunc>->«F:void* ( )*»
                 ,&reallocFunc ( --> Pointer) # Typedef<xmlReallocFunc>->«F:void* ( )*»
                 ,&strdupFunc ( --> Str) # Typedef<xmlStrdupFunc>->«F:char* ( )*»
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:120
#XMLPUBFUN int XMLCALL
#	xmlGcMemGet	(xmlFreeFunc *freeFunc,
sub xmlGcMemGet(Pointer[()]                   $freeFunc # Typedef<xmlFreeFunc>->«F:void ( )*»*
               ,Pointer[( --> Pointer)]       $mallocFunc # Typedef<xmlMallocFunc>->«F:void* ( )*»*
               ,Pointer[( --> Pointer)]       $mallocAtomicFunc # Typedef<xmlMallocFunc>->«F:void* ( )*»*
               ,Pointer[( --> Pointer)]       $reallocFunc # Typedef<xmlReallocFunc>->«F:void* ( )*»*
               ,Pointer[( --> Str)]           $strdupFunc # Typedef<xmlStrdupFunc>->«F:char* ( )*»*
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:130
#/*
# * Initialization of the memory layer.
# */
#XMLPUBFUN int XMLCALL
#	xmlInitMemory	(void);
sub xmlInitMemory(
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:136
#/*
# * Cleanup of the memory layer.
# */
#XMLPUBFUN void XMLCALL
#                xmlCleanupMemory        (void);
sub xmlCleanupMemory(
                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:141
#/*
# * These are specific to the XML debug memory wrapper.
# */
#XMLPUBFUN int XMLCALL
#	xmlMemUsed	(void);
sub xmlMemUsed(
               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:143
#XMLPUBFUN int XMLCALL
#	xmlMemBlocks	(void);
sub xmlMemBlocks(
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:145
#XMLPUBFUN void XMLCALL
#	xmlMemDisplay	(FILE *fp);
sub xmlMemDisplay(_IO_FILE $fp # Typedef<FILE>->«_IO_FILE»*
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:147
#XMLPUBFUN void XMLCALL
#	xmlMemDisplayLast(FILE *fp, long nbBytes);
sub xmlMemDisplayLast(_IO_FILE                      $fp # Typedef<FILE>->«_IO_FILE»*
                     ,long                          $nbBytes # long int
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:149
#XMLPUBFUN void XMLCALL
#	xmlMemShow	(FILE *fp, int nr);
sub xmlMemShow(_IO_FILE                      $fp # Typedef<FILE>->«_IO_FILE»*
              ,int32                         $nr # int
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:151
#XMLPUBFUN void XMLCALL
#	xmlMemoryDump	(void);
sub xmlMemoryDump(
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:153
#XMLPUBFUN void * XMLCALL
#	xmlMemMalloc	(size_t size) LIBXML_ATTR_ALLOC_SIZE(1);
sub xmlMemMalloc(size_t $size # Typedef<size_t>->«long unsigned int»
                 ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:155
#XMLPUBFUN void * XMLCALL
#	xmlMemRealloc	(void *ptr,size_t size);
sub xmlMemRealloc(Pointer                       $ptr # void*
                 ,size_t                        $size # Typedef<size_t>->«long unsigned int»
                  ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:157
#XMLPUBFUN void XMLCALL
#	xmlMemFree	(void *ptr);
sub xmlMemFree(Pointer $ptr # void*
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:159
#XMLPUBFUN char * XMLCALL
#	xmlMemoryStrdup	(const char *str);
sub xmlMemoryStrdup(Str $str # const char*
                    ) is native(LIB) returns Str is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:161
#XMLPUBFUN void * XMLCALL
#	xmlMallocLoc	(size_t size, const char *file, int line) LIBXML_ATTR_ALLOC_SIZE(1);
sub xmlMallocLoc(size_t                        $size # Typedef<size_t>->«long unsigned int»
                ,Str                           $file # const char*
                ,int32                         $line # int
                 ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:163
#XMLPUBFUN void * XMLCALL
#	xmlReallocLoc	(void *ptr, size_t size, const char *file, int line);
sub xmlReallocLoc(Pointer                       $ptr # void*
                 ,size_t                        $size # Typedef<size_t>->«long unsigned int»
                 ,Str                           $file # const char*
                 ,int32                         $line # int
                  ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:165
#XMLPUBFUN void * XMLCALL
#	xmlMallocAtomicLoc (size_t size, const char *file, int line) LIBXML_ATTR_ALLOC_SIZE(1);
sub xmlMallocAtomicLoc(size_t                        $size # Typedef<size_t>->«long unsigned int»
                      ,Str                           $file # const char*
                      ,int32                         $line # int
                       ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlmemory.h:167
#XMLPUBFUN char * XMLCALL
#	xmlMemStrdupLoc	(const char *str, const char *file, int line);
sub xmlMemStrdupLoc(Str                           $str # const char*
                   ,Str                           $file # const char*
                   ,int32                         $line # int
                    ) is native(LIB) returns Str is export { * }


# == /usr/include/libxml2/libxml/xmlstring.h ==

#-From /usr/include/libxml2/libxml/xmlstring.h:41
#/*
# * xmlChar handling
# */
#XMLPUBFUN xmlChar * XMLCALL
#                xmlStrdup                (const xmlChar *cur);
sub xmlStrdup(Pointer[xmlChar] $cur # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:43
#XMLPUBFUN xmlChar * XMLCALL
#                xmlStrndup               (const xmlChar *cur,
sub xmlStrndup(Pointer[xmlChar]              $cur # const Typedef<xmlChar>->«unsigned char»*
              ,int32                         $len # int
               ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:46
#XMLPUBFUN xmlChar * XMLCALL
#                xmlCharStrndup           (const char *cur,
sub xmlCharStrndup(Str                           $cur # const char*
                  ,int32                         $len # int
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:49
#XMLPUBFUN xmlChar * XMLCALL
#                xmlCharStrdup            (const char *cur);
sub xmlCharStrdup(Str $cur # const char*
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:51
#XMLPUBFUN xmlChar * XMLCALL
#                xmlStrsub                (const xmlChar *str,
sub xmlStrsub(Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
             ,int32                         $start # int
             ,int32                         $len # int
              ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:55
#XMLPUBFUN const xmlChar * XMLCALL
#                xmlStrchr                (const xmlChar *str,
sub xmlStrchr(Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
             ,xmlChar                       $val # Typedef<xmlChar>->«unsigned char»
              ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:58
#XMLPUBFUN const xmlChar * XMLCALL
#                xmlStrstr                (const xmlChar *str,
sub xmlStrstr(Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
             ,Pointer[xmlChar]              $val # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:61
#XMLPUBFUN const xmlChar * XMLCALL
#                xmlStrcasestr            (const xmlChar *str,
sub xmlStrcasestr(Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $val # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:64
#XMLPUBFUN int XMLCALL
#                xmlStrcmp                (const xmlChar *str1,
sub xmlStrcmp(Pointer[xmlChar]              $str1 # const Typedef<xmlChar>->«unsigned char»*
             ,Pointer[xmlChar]              $str2 # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:67
#XMLPUBFUN int XMLCALL
#                xmlStrncmp               (const xmlChar *str1,
sub xmlStrncmp(Pointer[xmlChar]              $str1 # const Typedef<xmlChar>->«unsigned char»*
              ,Pointer[xmlChar]              $str2 # const Typedef<xmlChar>->«unsigned char»*
              ,int32                         $len # int
               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:71
#XMLPUBFUN int XMLCALL
#                xmlStrcasecmp            (const xmlChar *str1,
sub xmlStrcasecmp(Pointer[xmlChar]              $str1 # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $str2 # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:74
#XMLPUBFUN int XMLCALL
#                xmlStrncasecmp           (const xmlChar *str1,
sub xmlStrncasecmp(Pointer[xmlChar]              $str1 # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $str2 # const Typedef<xmlChar>->«unsigned char»*
                  ,int32                         $len # int
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:78
#XMLPUBFUN int XMLCALL
#                xmlStrEqual              (const xmlChar *str1,
sub xmlStrEqual(Pointer[xmlChar]              $str1 # const Typedef<xmlChar>->«unsigned char»*
               ,Pointer[xmlChar]              $str2 # const Typedef<xmlChar>->«unsigned char»*
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:81
#XMLPUBFUN int XMLCALL
#                xmlStrQEqual             (const xmlChar *pref,
sub xmlStrQEqual(Pointer[xmlChar]              $pref # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:85
#XMLPUBFUN int XMLCALL
#                xmlStrlen                (const xmlChar *str);
sub xmlStrlen(Pointer[xmlChar] $str # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:87
#XMLPUBFUN xmlChar * XMLCALL
#                xmlStrcat                (xmlChar *cur,
sub xmlStrcat(Pointer[xmlChar]              $cur # Typedef<xmlChar>->«unsigned char»*
             ,Pointer[xmlChar]              $add # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:90
#XMLPUBFUN xmlChar * XMLCALL
#                xmlStrncat               (xmlChar *cur,
sub xmlStrncat(Pointer[xmlChar]              $cur # Typedef<xmlChar>->«unsigned char»*
              ,Pointer[xmlChar]              $add # const Typedef<xmlChar>->«unsigned char»*
              ,int32                         $len # int
               ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:94
#XMLPUBFUN xmlChar * XMLCALL
#                xmlStrncatNew            (const xmlChar *str1,
sub xmlStrncatNew(Pointer[xmlChar]              $str1 # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $str2 # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $len # int
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:98
#XMLPUBFUN int XMLCALL
#                xmlStrPrintf             (xmlChar *buf,
sub xmlStrPrintf(Pointer[xmlChar]              $buf # Typedef<xmlChar>->«unsigned char»*
                ,int32                         $len # int
                ,Str                           $msg # const char*
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:103
#XMLPUBFUN int XMLCALL
#                xmlStrVPrintf                (xmlChar *buf,
sub xmlStrVPrintf(Pointer[xmlChar]              $buf # Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $len # int
                 ,Str                           $msg # const char*
                 ,__va_list_tag                 $ap # __va_list_tag*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:109
#XMLPUBFUN int XMLCALL
#        xmlGetUTF8Char                   (const unsigned char *utf,
sub xmlGetUTF8Char(Pointer[uint8]                $utf # const unsigned char*
                  ,Pointer[int32]                $len # int*
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:112
#XMLPUBFUN int XMLCALL
#        xmlCheckUTF8                     (const unsigned char *utf);
sub xmlCheckUTF8(Pointer[uint8] $utf # const unsigned char*
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:114
#XMLPUBFUN int XMLCALL
#        xmlUTF8Strsize                   (const xmlChar *utf,
sub xmlUTF8Strsize(Pointer[xmlChar]              $utf # const Typedef<xmlChar>->«unsigned char»*
                  ,int32                         $len # int
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:117
#XMLPUBFUN xmlChar * XMLCALL
#        xmlUTF8Strndup                   (const xmlChar *utf,
sub xmlUTF8Strndup(Pointer[xmlChar]              $utf # const Typedef<xmlChar>->«unsigned char»*
                  ,int32                         $len # int
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:120
#XMLPUBFUN const xmlChar * XMLCALL
#        xmlUTF8Strpos                    (const xmlChar *utf,
sub xmlUTF8Strpos(Pointer[xmlChar]              $utf # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $pos # int
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:123
#XMLPUBFUN int XMLCALL
#        xmlUTF8Strloc                    (const xmlChar *utf,
sub xmlUTF8Strloc(Pointer[xmlChar]              $utf # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $utfchar # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:126
#XMLPUBFUN xmlChar * XMLCALL
#        xmlUTF8Strsub                    (const xmlChar *utf,
sub xmlUTF8Strsub(Pointer[xmlChar]              $utf # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $start # int
                 ,int32                         $len # int
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:130
#XMLPUBFUN int XMLCALL
#        xmlUTF8Strlen                    (const xmlChar *utf);
sub xmlUTF8Strlen(Pointer[xmlChar] $utf # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:132
#XMLPUBFUN int XMLCALL
#        xmlUTF8Size                      (const xmlChar *utf);
sub xmlUTF8Size(Pointer[xmlChar] $utf # const Typedef<xmlChar>->«unsigned char»*
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlstring.h:134
#XMLPUBFUN int XMLCALL
#        xmlUTF8Charcmp                   (const xmlChar *utf1,
sub xmlUTF8Charcmp(Pointer[xmlChar]              $utf1 # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $utf2 # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns int32 is export { * }


# == /usr/include/libxml2/libxml/SAX2.h ==

#-From /usr/include/libxml2/libxml/SAX2.h:25
##ifdef __cplusplus
#extern "C" {
##endif
#XMLPUBFUN const xmlChar * XMLCALL
#		xmlSAX2GetPublicId		(void *ctx);
sub xmlSAX2GetPublicId(Pointer $ctx # void*
                       ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:27
#XMLPUBFUN const xmlChar * XMLCALL
#		xmlSAX2GetSystemId		(void *ctx);
sub xmlSAX2GetSystemId(Pointer $ctx # void*
                       ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:29
#XMLPUBFUN void XMLCALL
#		xmlSAX2SetDocumentLocator	(void *ctx,
sub xmlSAX2SetDocumentLocator(Pointer                       $ctx # void*
                             ,_xmlSAXLocator                $loc # Typedef<xmlSAXLocatorPtr>->«Typedef<xmlSAXLocator>->«_xmlSAXLocator»*»
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:33
#XMLPUBFUN int XMLCALL
#		xmlSAX2GetLineNumber		(void *ctx);
sub xmlSAX2GetLineNumber(Pointer $ctx # void*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:35
#XMLPUBFUN int XMLCALL
#		xmlSAX2GetColumnNumber		(void *ctx);
sub xmlSAX2GetColumnNumber(Pointer $ctx # void*
                           ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:38
#XMLPUBFUN int XMLCALL
#		xmlSAX2IsStandalone		(void *ctx);
sub xmlSAX2IsStandalone(Pointer $ctx # void*
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:40
#XMLPUBFUN int XMLCALL
#		xmlSAX2HasInternalSubset	(void *ctx);
sub xmlSAX2HasInternalSubset(Pointer $ctx # void*
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:42
#XMLPUBFUN int XMLCALL
#		xmlSAX2HasExternalSubset	(void *ctx);
sub xmlSAX2HasExternalSubset(Pointer $ctx # void*
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:45
#XMLPUBFUN void XMLCALL
#		xmlSAX2InternalSubset		(void *ctx,
sub xmlSAX2InternalSubset(Pointer                       $ctx # void*
                         ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:50
#XMLPUBFUN void XMLCALL
#		xmlSAX2ExternalSubset		(void *ctx,
sub xmlSAX2ExternalSubset(Pointer                       $ctx # void*
                         ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:55
#XMLPUBFUN xmlEntityPtr XMLCALL
#		xmlSAX2GetEntity		(void *ctx,
sub xmlSAX2GetEntity(Pointer                       $ctx # void*
                    ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                     ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:58
#XMLPUBFUN xmlEntityPtr XMLCALL
#		xmlSAX2GetParameterEntity	(void *ctx,
sub xmlSAX2GetParameterEntity(Pointer                       $ctx # void*
                             ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                              ) is native(LIB) returns _xmlEntity is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:61
#XMLPUBFUN xmlParserInputPtr XMLCALL
#		xmlSAX2ResolveEntity		(void *ctx,
sub xmlSAX2ResolveEntity(Pointer                       $ctx # void*
                        ,Pointer[xmlChar]              $publicId # const Typedef<xmlChar>->«unsigned char»*
                        ,Pointer[xmlChar]              $systemId # const Typedef<xmlChar>->«unsigned char»*
                         ) is native(LIB) returns _xmlParserInput is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:66
#XMLPUBFUN void XMLCALL
#		xmlSAX2EntityDecl		(void *ctx,
sub xmlSAX2EntityDecl(Pointer                       $ctx # void*
                     ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                     ,int32                         $type # int
                     ,Pointer[xmlChar]              $publicId # const Typedef<xmlChar>->«unsigned char»*
                     ,Pointer[xmlChar]              $systemId # const Typedef<xmlChar>->«unsigned char»*
                     ,Pointer[xmlChar]              $content # Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:73
#XMLPUBFUN void XMLCALL
#		xmlSAX2AttributeDecl		(void *ctx,
sub xmlSAX2AttributeDecl(Pointer                       $ctx # void*
                        ,Pointer[xmlChar]              $elem # const Typedef<xmlChar>->«unsigned char»*
                        ,Pointer[xmlChar]              $fullname # const Typedef<xmlChar>->«unsigned char»*
                        ,int32                         $type # int
                        ,int32                         $def # int
                        ,Pointer[xmlChar]              $defaultValue # const Typedef<xmlChar>->«unsigned char»*
                        ,_xmlEnumeration               $tree # Typedef<xmlEnumerationPtr>->«Typedef<xmlEnumeration>->«_xmlEnumeration»*»
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:81
#XMLPUBFUN void XMLCALL
#		xmlSAX2ElementDecl		(void *ctx,
sub xmlSAX2ElementDecl(Pointer                       $ctx # void*
                      ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ,int32                         $type # int
                      ,_xmlElementContent            $content # Typedef<xmlElementContentPtr>->«Typedef<xmlElementContent>->«_xmlElementContent»*»
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:86
#XMLPUBFUN void XMLCALL
#		xmlSAX2NotationDecl		(void *ctx,
sub xmlSAX2NotationDecl(Pointer                       $ctx # void*
                       ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $publicId # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $systemId # const Typedef<xmlChar>->«unsigned char»*
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:91
#XMLPUBFUN void XMLCALL
#		xmlSAX2UnparsedEntityDecl	(void *ctx,
sub xmlSAX2UnparsedEntityDecl(Pointer                       $ctx # void*
                             ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                             ,Pointer[xmlChar]              $publicId # const Typedef<xmlChar>->«unsigned char»*
                             ,Pointer[xmlChar]              $systemId # const Typedef<xmlChar>->«unsigned char»*
                             ,Pointer[xmlChar]              $notationName # const Typedef<xmlChar>->«unsigned char»*
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:98
#XMLPUBFUN void XMLCALL
#		xmlSAX2StartDocument		(void *ctx);
sub xmlSAX2StartDocument(Pointer $ctx # void*
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:100
#XMLPUBFUN void XMLCALL
#		xmlSAX2EndDocument		(void *ctx);
sub xmlSAX2EndDocument(Pointer $ctx # void*
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:105
##if defined(LIBXML_SAX1_ENABLED) || defined(LIBXML_HTML_ENABLED) || \
#    defined(LIBXML_WRITER_ENABLED) || defined(LIBXML_DOCB_ENABLED) || \
#    defined(LIBXML_LEGACY_ENABLED)
#XMLPUBFUN void XMLCALL
#		xmlSAX2StartElement		(void *ctx,
sub xmlSAX2StartElement(Pointer                       $ctx # void*
                       ,Pointer[xmlChar]              $fullname # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[Pointer[xmlChar]]     $atts # const Typedef<xmlChar>->«unsigned char»**
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:109
#XMLPUBFUN void XMLCALL
#		xmlSAX2EndElement		(void *ctx,
sub xmlSAX2EndElement(Pointer                       $ctx # void*
                     ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:113
##endif /* LIBXML_SAX1_ENABLED or LIBXML_HTML_ENABLED or LIBXML_LEGACY_ENABLED */
#XMLPUBFUN void XMLCALL
#		xmlSAX2StartElementNs		(void *ctx,
sub xmlSAX2StartElementNs(Pointer                       $ctx # void*
                         ,Pointer[xmlChar]              $localname # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                         ,Pointer[xmlChar]              $URI # const Typedef<xmlChar>->«unsigned char»*
                         ,int32                         $nb_namespaces # int
                         ,Pointer[Pointer[xmlChar]]     $namespaces # const Typedef<xmlChar>->«unsigned char»**
                         ,int32                         $nb_attributes # int
                         ,int32                         $nb_defaulted # int
                         ,Pointer[Pointer[xmlChar]]     $attributes # const Typedef<xmlChar>->«unsigned char»**
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:123
#XMLPUBFUN void XMLCALL
#		xmlSAX2EndElementNs		(void *ctx,
sub xmlSAX2EndElementNs(Pointer                       $ctx # void*
                       ,Pointer[xmlChar]              $localname # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $URI # const Typedef<xmlChar>->«unsigned char»*
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:128
#XMLPUBFUN void XMLCALL
#		xmlSAX2Reference		(void *ctx,
sub xmlSAX2Reference(Pointer                       $ctx # void*
                    ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:131
#XMLPUBFUN void XMLCALL
#		xmlSAX2Characters		(void *ctx,
sub xmlSAX2Characters(Pointer                       $ctx # void*
                     ,Pointer[xmlChar]              $ch # const Typedef<xmlChar>->«unsigned char»*
                     ,int32                         $len # int
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:135
#XMLPUBFUN void XMLCALL
#		xmlSAX2IgnorableWhitespace	(void *ctx,
sub xmlSAX2IgnorableWhitespace(Pointer                       $ctx # void*
                              ,Pointer[xmlChar]              $ch # const Typedef<xmlChar>->«unsigned char»*
                              ,int32                         $len # int
                               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:139
#XMLPUBFUN void XMLCALL
#		xmlSAX2ProcessingInstruction	(void *ctx,
sub xmlSAX2ProcessingInstruction(Pointer                       $ctx # void*
                                ,Pointer[xmlChar]              $target # const Typedef<xmlChar>->«unsigned char»*
                                ,Pointer[xmlChar]              $data # const Typedef<xmlChar>->«unsigned char»*
                                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:143
#XMLPUBFUN void XMLCALL
#		xmlSAX2Comment			(void *ctx,
sub xmlSAX2Comment(Pointer                       $ctx # void*
                  ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:146
#XMLPUBFUN void XMLCALL
#		xmlSAX2CDataBlock		(void *ctx,
sub xmlSAX2CDataBlock(Pointer                       $ctx # void*
                     ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                     ,int32                         $len # int
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:152
##ifdef LIBXML_SAX1_ENABLED
#XMLPUBFUN int XMLCALL
#		xmlSAXDefaultVersion		(int version);
sub xmlSAXDefaultVersion(int32 $version # int
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:156
#XMLPUBFUN int XMLCALL
#		xmlSAXVersion			(xmlSAXHandler *hdlr,
sub xmlSAXVersion(_xmlSAXHandler                $hdlr # Typedef<xmlSAXHandler>->«_xmlSAXHandler»*
                 ,int32                         $version # int
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:159
#XMLPUBFUN void XMLCALL
#		xmlSAX2InitDefaultSAXHandler    (xmlSAXHandler *hdlr,
sub xmlSAX2InitDefaultSAXHandler(_xmlSAXHandler                $hdlr # Typedef<xmlSAXHandler>->«_xmlSAXHandler»*
                                ,int32                         $warning # int
                                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:163
##ifdef LIBXML_HTML_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlSAX2InitHtmlDefaultSAXHandler(xmlSAXHandler *hdlr);
sub xmlSAX2InitHtmlDefaultSAXHandler(_xmlSAXHandler $hdlr # Typedef<xmlSAXHandler>->«_xmlSAXHandler»*
                                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:165
#XMLPUBFUN void XMLCALL
#		htmlDefaultSAXHandlerInit	(void);
sub htmlDefaultSAXHandlerInit(
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:169
##endif
##ifdef LIBXML_DOCB_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlSAX2InitDocbDefaultSAXHandler(xmlSAXHandler *hdlr);
sub xmlSAX2InitDocbDefaultSAXHandler(_xmlSAXHandler $hdlr # Typedef<xmlSAXHandler>->«_xmlSAXHandler»*
                                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:171
#XMLPUBFUN void XMLCALL
#		docbDefaultSAXHandlerInit	(void);
sub docbDefaultSAXHandlerInit(
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/SAX2.h:174
##endif
#XMLPUBFUN void XMLCALL
#		xmlDefaultSAXHandlerInit	(void);
sub xmlDefaultSAXHandlerInit(
                             ) is native(LIB)  is export { * }


# == /usr/include/unicode/ucnv.h ==

#-From /usr/include/unicode/ucnv.h:311
#/**
# * Do a fuzzy compare of two converter/alias names.
# * The comparison is case-insensitive, ignores leading zeroes if they are not
# * followed by further digits, and ignores all but letters and digits.
# * Thus the strings "UTF-8", "utf_8", "u*T@f08" and "Utf 8" are exactly equivalent.
# * See section 1.4, Charset Alias Matching in Unicode Technical Standard #22
# * at http://www.unicode.org/reports/tr22/
# *
# * @param name1 a converter name or alias, zero-terminated
# * @param name2 a converter name or alias, zero-terminated
# * @return 0 if the names match, or a negative value if the name1
# * lexically precedes name2, or a positive value if the name1
# * lexically follows name2.
# * @stable ICU 2.0
# */
#U_STABLE int U_EXPORT2
#ucnv_compareNames(const char *name1, const char *name2);
sub ucnv_compareNames_57(Str                           $name1 # const char*
                        ,Str                           $name2 # const char*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/unicode/ucnv.h:365
#/**
# * Creates a UConverter object with the name of a coded character set specified as a C string.
# * The actual name will be resolved with the alias file
# * using a case-insensitive string comparison that ignores
# * leading zeroes and all non-alphanumeric characters.
# * E.g., the names "UTF8", "utf-8", "u*T@f08" and "Utf 8" are all equivalent.
# * (See also ucnv_compareNames().)
# * If <code>NULL</code> is passed for the converter name, it will create one with the
# * getDefaultName return value.
# *
# * <p>A converter name for ICU 1.5 and above may contain options
# * like a locale specification to control the specific behavior of
# * the newly instantiated converter.
# * The meaning of the options depends on the particular converter.
# * If an option is not defined for or recognized by a given converter, then it is ignored.</p>
# *
# * <p>Options are appended to the converter name string, with a
# * <code>UCNV_OPTION_SEP_CHAR</code> between the name and the first option and
# * also between adjacent options.</p>
# *
# * <p>If the alias is ambiguous, then the preferred converter is used
# * and the status is set to U_AMBIGUOUS_ALIAS_WARNING.</p>
# *
# * <p>The conversion behavior and names can vary between platforms. ICU may
# * convert some characters differently from other platforms. Details on this topic
# * are in the <a href="http://icu-project.org/userguide/conversion.html">User's
# * Guide</a>. Aliases starting with a "cp" prefix have no specific meaning
# * other than its an alias starting with the letters "cp". Please do not
# * associate any meaning to these aliases.</p>
# *
# * \snippet samples/ucnv/convsamp.cpp ucnv_open
# *
# * @param converterName Name of the coded character set table.
# *          This may have options appended to the string.
# *          IANA alias character set names, IBM CCSIDs starting with "ibm-",
# *          Windows codepage numbers starting with "windows-" are frequently
# *          used for this parameter. See ucnv_getAvailableName and
# *          ucnv_getAlias for a complete list that is available.
# *          If this parameter is NULL, the default converter will be used.
# * @param err outgoing error status <TT>U_MEMORY_ALLOCATION_ERROR, U_FILE_ACCESS_ERROR</TT>
# * @return the created Unicode converter object, or <TT>NULL</TT> if an error occured
# * @see ucnv_openU
# * @see ucnv_openCCSID
# * @see ucnv_getAvailableName
# * @see ucnv_getAlias
# * @see ucnv_getDefaultName
# * @see ucnv_close
# * @see ucnv_compareNames
# * @stable ICU 2.0
# */
#U_STABLE UConverter* U_EXPORT2
#ucnv_open(const char *converterName, UErrorCode *err);
sub ucnv_open_57(Str                           $converterName # const char*
                ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                 ) is native(LIB) returns UConverter is export { * }

#-From /usr/include/unicode/ucnv.h:395
#/**
# * Creates a Unicode converter with the names specified as unicode string.
# * The name should be limited to the ASCII-7 alphanumerics range.
# * The actual name will be resolved with the alias file
# * using a case-insensitive string comparison that ignores
# * leading zeroes and all non-alphanumeric characters.
# * E.g., the names "UTF8", "utf-8", "u*T@f08" and "Utf 8" are all equivalent.
# * (See also ucnv_compareNames().)
# * If <TT>NULL</TT> is passed for the converter name, it will create
# * one with the ucnv_getDefaultName() return value.
# * If the alias is ambiguous, then the preferred converter is used
# * and the status is set to U_AMBIGUOUS_ALIAS_WARNING.
# *
# * <p>See ucnv_open for the complete details</p>
# * @param name Name of the UConverter table in a zero terminated
# *        Unicode string
# * @param err outgoing error status <TT>U_MEMORY_ALLOCATION_ERROR,
# *        U_FILE_ACCESS_ERROR</TT>
# * @return the created Unicode converter object, or <TT>NULL</TT> if an
# *        error occured
# * @see ucnv_open
# * @see ucnv_openCCSID
# * @see ucnv_close
# * @see ucnv_compareNames
# * @stable ICU 2.0
# */
#U_STABLE UConverter* U_EXPORT2
#ucnv_openU(const UChar *name,
sub ucnv_openU_57(Pointer[UChar]                $name # const Typedef<UChar>->«short unsigned int»*
                 ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                  ) is native(LIB) returns UConverter is export { * }

#-From /usr/include/unicode/ucnv.h:463
# * \endcode
# *
# * If the alias is ambiguous, then the preferred converter is used
# * and the status is set to U_AMBIGUOUS_ALIAS_WARNING.
# *
# * @param codepage codepage number to create
# * @param platform the platform in which the codepage number exists
# * @param err error status <TT>U_MEMORY_ALLOCATION_ERROR, U_FILE_ACCESS_ERROR</TT>
# * @return the created Unicode converter object, or <TT>NULL</TT> if an error
# *   occured.
# * @see ucnv_open
# * @see ucnv_openU
# * @see ucnv_close
# * @see ucnv_getCCSID
# * @see ucnv_getPlatform
# * @see UConverterPlatform
# * @stable ICU 2.0
# */
#U_STABLE UConverter* U_EXPORT2
#ucnv_openCCSID(int32_t codepage,
sub ucnv_openCCSID_57(int32_t                       $codepage # Typedef<int32_t>->«int»
                     ,int32                         $platform # Typedef<UConverterPlatform>->«UConverterPlatform»
                     ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                      ) is native(LIB) returns UConverter is export { * }

#-From /usr/include/unicode/ucnv.h:498
# * </p>
# *
# * @param packageName name of the package (equivalent to 'path' in udata_open() call)
# * @param converterName name of the data item to be used, without suffix.
# * @param err outgoing error status <TT>U_MEMORY_ALLOCATION_ERROR, U_FILE_ACCESS_ERROR</TT>
# * @return the created Unicode converter object, or <TT>NULL</TT> if an error occured
# * @see udata_open
# * @see ucnv_open
# * @see ucnv_safeClone
# * @see ucnv_close
# * @stable ICU 2.2
# */
#U_STABLE UConverter* U_EXPORT2
#ucnv_openPackage(const char *packageName, const char *converterName, UErrorCode *err);
sub ucnv_openPackage_57(Str                           $packageName # const char*
                       ,Str                           $converterName # const char*
                       ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                        ) is native(LIB) returns UConverter is export { * }

#-From /usr/include/unicode/ucnv.h:540
# * otherwise, it will be allocated, and *pBufferSize will indicate
# * the actual size. (This should not occur with U_CNV_SAFECLONE_BUFFERSIZE.)
# *
# * You must ucnv_close() the clone in any case.
# *
# * If *pBufferSize==0, (regardless of whether stackBuffer==NULL or not)
# * then *pBufferSize will be changed to a sufficient size
# * for cloning this converter,
# * without actually cloning the converter ("pure pre-flighting").
# *
# * If *pBufferSize is greater than zero but not large enough for a stack-based
# * clone, then the converter is cloned using newly allocated memory
# * and *pBufferSize is changed to the necessary size.
# *
# * If the converter clone fits into the stack buffer but the stack buffer is not
# * sufficiently aligned for the clone, then the clone will use an
# * adjusted pointer and use an accordingly smaller buffer size.
# *
# * @param cnv converter to be cloned
# * @param stackBuffer <em>Deprecated functionality as of ICU 52, use NULL.</em><br>
# *  user allocated space for the new clone. If NULL new memory will be allocated.
# *  If buffer is not large enough, new memory will be allocated.
# *  Clients can use the U_CNV_SAFECLONE_BUFFERSIZE. This will probably be enough to avoid memory allocations.
# * @param pBufferSize <em>Deprecated functionality as of ICU 52, use NULL or 1.</em><br>
# *  pointer to size of allocated space.
# * @param status to indicate whether the operation went on smoothly or there were errors
# *  An informational status value, U_SAFECLONE_ALLOCATED_WARNING,
# *  is used if any allocations were necessary.
# *  However, it is better to check if *pBufferSize grew for checking for
# *  allocations because warning codes can be overridden by subsequent
# *  function calls.
# * @return pointer to the new clone
# * @stable ICU 2.0
# */
#U_STABLE UConverter * U_EXPORT2
#ucnv_safeClone(const UConverter *cnv,
sub ucnv_safeClone_57(UConverter                    $cnv # const Typedef<UConverter>->«UConverter»*
                     ,Pointer                       $stackBuffer # void*
                     ,Pointer[int32_t]              $pBufferSize # Typedef<int32_t>->«int»*
                     ,Pointer[int32]                $status # Typedef<UErrorCode>->«UErrorCode»*
                      ) is native(LIB) returns UConverter is export { * }

#-From /usr/include/unicode/ucnv.h:569
#/**
# * Deletes the unicode converter and releases resources associated
# * with just this instance.
# * Does not free up shared converter tables.
# *
# * @param converter the converter object to be deleted
# * @see ucnv_open
# * @see ucnv_openU
# * @see ucnv_openCCSID
# * @stable ICU 2.0
# */
#U_STABLE void  U_EXPORT2
#ucnv_close(UConverter * converter);
sub ucnv_close_57(UConverter $converter # Typedef<UConverter>->«UConverter»*
                  ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:608
#/**
# * Fills in the output parameter, subChars, with the substitution characters
# * as multiple bytes.
# * If ucnv_setSubstString() set a Unicode string because the converter is
# * stateful, then subChars will be an empty string.
# *
# * @param converter the Unicode converter
# * @param subChars the subsitution characters
# * @param len on input the capacity of subChars, on output the number
# * of bytes copied to it
# * @param  err the outgoing error status code.
# * If the substitution character array is too small, an
# * <TT>U_INDEX_OUTOFBOUNDS_ERROR</TT> will be returned.
# * @see ucnv_setSubstString
# * @see ucnv_setSubstChars
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_getSubstChars(const UConverter *converter,
sub ucnv_getSubstChars_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                         ,Str                           $subChars # char*
                         ,Pointer[int8_t]               $len # Typedef<int8_t>->«signed char»*
                         ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                          ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:633
#/**
# * Sets the substitution chars when converting from unicode to a codepage. The
# * substitution is specified as a string of 1-4 bytes, and may contain
# * <TT>NULL</TT> bytes.
# * The subChars must represent a single character. The caller needs to know the
# * byte sequence of a valid character in the converter's charset.
# * For some converters, for example some ISO 2022 variants, only single-byte
# * substitution characters may be supported.
# * The newer ucnv_setSubstString() function relaxes these limitations.
# *
# * @param converter the Unicode converter
# * @param subChars the substitution character byte sequence we want set
# * @param len the number of bytes in subChars
# * @param err the error status code.  <TT>U_INDEX_OUTOFBOUNDS_ERROR </TT> if
# * len is bigger than the maximum number of bytes allowed in subchars
# * @see ucnv_setSubstString
# * @see ucnv_getSubstChars
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_setSubstChars(UConverter *converter,
sub ucnv_setSubstChars_57(UConverter                    $converter # Typedef<UConverter>->«UConverter»*
                         ,Str                           $subChars # const char*
                         ,int8_t                        $len # Typedef<int8_t>->«signed char»
                         ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                          ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:666
#/**
# * Set a substitution string for converting from Unicode to a charset.
# * The caller need not know the charset byte sequence for each charset.
# *
# * Unlike ucnv_setSubstChars() which is designed to set a charset byte sequence
# * for a single character, this function takes a Unicode string with
# * zero, one or more characters, and immediately verifies that the string can be
# * converted to the charset.
# * If not, or if the result is too long (more than 32 bytes as of ICU 3.6),
# * then the function returns with an error accordingly.
# *
# * Also unlike ucnv_setSubstChars(), this function works for stateful charsets
# * by converting on the fly at the point of substitution rather than setting
# * a fixed byte sequence.
# *
# * @param cnv The UConverter object.
# * @param s The Unicode string.
# * @param length The number of UChars in s, or -1 for a NUL-terminated string.
# * @param err Pointer to a standard ICU error code. Its input value must
# *            pass the U_SUCCESS() test, or else the function returns
# *            immediately. Check for U_FAILURE() on output or use with
# *            function chaining. (See User Guide for details.)
# *
# * @see ucnv_setSubstChars
# * @see ucnv_getSubstChars
# * @stable ICU 3.6
# */
#U_STABLE void U_EXPORT2
#ucnv_setSubstString(UConverter *cnv,
sub ucnv_setSubstString_57(UConverter                    $cnv # Typedef<UConverter>->«UConverter»*
                          ,Pointer[UChar]                $s # const Typedef<UChar>->«short unsigned int»*
                          ,int32_t                       $length # Typedef<int32_t>->«int»
                          ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                           ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:685
#/**
# * Fills in the output parameter, errBytes, with the error characters from the
# * last failing conversion.
# *
# * @param converter the Unicode converter
# * @param errBytes the codepage bytes which were in error
# * @param len on input the capacity of errBytes, on output the number of
# *  bytes which were copied to it
# * @param err the error status code.
# * If the substitution character array is too small, an
# * <TT>U_INDEX_OUTOFBOUNDS_ERROR</TT> will be returned.
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_getInvalidChars(const UConverter *converter,
sub ucnv_getInvalidChars_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                           ,Str                           $errBytes # char*
                           ,Pointer[int8_t]               $len # Typedef<int8_t>->«signed char»*
                           ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                            ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:704
#/**
# * Fills in the output parameter, errChars, with the error characters from the
# * last failing conversion.
# *
# * @param converter the Unicode converter
# * @param errUChars the UChars which were in error
# * @param len on input the capacity of errUChars, on output the number of
# *  UChars which were copied to it
# * @param err the error status code.
# * If the substitution character array is too small, an
# * <TT>U_INDEX_OUTOFBOUNDS_ERROR</TT> will be returned.
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_getInvalidUChars(const UConverter *converter,
sub ucnv_getInvalidUChars_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                            ,Pointer[UChar]                $errUChars # Typedef<UChar>->«short unsigned int»*
                            ,Pointer[int8_t]               $len # Typedef<int8_t>->«signed char»*
                            ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                             ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:717
#/**
# * Resets the state of a converter to the default state. This is used
# * in the case of an error, to restart a conversion from a known default state.
# * It will also empty the internal output buffers.
# * @param converter the Unicode converter
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_reset(UConverter *converter);
sub ucnv_reset_57(UConverter $converter # Typedef<UConverter>->«UConverter»*
                  ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:728
#/**
# * Resets the to-Unicode part of a converter state to the default state.
# * This is used in the case of an error to restart a conversion to
# * Unicode to a known default state. It will also empty the internal
# * output buffers used for the conversion to Unicode codepoints.
# * @param converter the Unicode converter
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_resetToUnicode(UConverter *converter);
sub ucnv_resetToUnicode_57(UConverter $converter # Typedef<UConverter>->«UConverter»*
                           ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:739
#/**
# * Resets the from-Unicode part of a converter state to the default state.
# * This is used in the case of an error to restart a conversion from
# * Unicode to a known default state. It will also empty the internal output
# * buffers used for the conversion from Unicode codepoints.
# * @param converter the Unicode converter
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_resetFromUnicode(UConverter *converter);
sub ucnv_resetFromUnicode_57(UConverter $converter # Typedef<UConverter>->«UConverter»*
                             ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:792
#/**
# * Returns the maximum number of bytes that are output per UChar in conversion
# * from Unicode using this converter.
# * The returned number can be used with UCNV_GET_MAX_BYTES_FOR_STRING
# * to calculate the size of a target buffer for conversion from Unicode.
# *
# * Note: Before ICU 2.8, this function did not return reliable numbers for
# * some stateful converters (EBCDIC_STATEFUL, ISO-2022) and LMBCS.
# *
# * This number may not be the same as the maximum number of bytes per
# * "conversion unit". In other words, it may not be the intuitively expected
# * number of bytes per character that would be published for a charset,
# * and may not fulfill any other purpose than the allocation of an output
# * buffer of guaranteed sufficient size for a given input length and converter.
# *
# * Examples for special cases that are taken into account:
# * - Supplementary code points may convert to more bytes than BMP code points.
# *   This function returns bytes per UChar (UTF-16 code unit), not per
# *   Unicode code point, for efficient buffer allocation.
# * - State-shifting output (SI/SO, escapes, etc.) from stateful converters.
# * - When m input UChars are converted to n output bytes, then the maximum m/n
# *   is taken into account.
# *
# * The number returned here does not take into account
# * (see UCNV_GET_MAX_BYTES_FOR_STRING):
# * - callbacks which output more than one charset character sequence per call,
# *   like escape callbacks
# * - initial and final non-character bytes that are output by some converters
# *   (automatic BOMs, initial escape sequence, final SI, etc.)
# *
# * Examples for returned values:
# * - SBCS charsets: 1
# * - Shift-JIS: 2
# * - UTF-16: 2 (2 per BMP, 4 per surrogate _pair_, BOM not counted)
# * - UTF-8: 3 (3 per BMP, 4 per surrogate _pair_)
# * - EBCDIC_STATEFUL (EBCDIC mixed SBCS/DBCS): 3 (SO + DBCS)
# * - ISO-2022: 3 (always outputs UTF-8)
# * - ISO-2022-JP: 6 (4-byte escape sequences + DBCS)
# * - ISO-2022-CN: 8 (4-byte designator sequences + 2-byte SS2/SS3 + DBCS)
# *
# * @param converter The Unicode converter.
# * @return The maximum number of bytes per UChar (16 bit code unit)
# *    that are output by ucnv_fromUnicode(),
# *    to be used together with UCNV_GET_MAX_BYTES_FOR_STRING
# *    for buffer allocation.
# *
# * @see UCNV_GET_MAX_BYTES_FOR_STRING
# * @see ucnv_getMinCharSize
# * @stable ICU 2.0
# */
#U_STABLE int8_t U_EXPORT2
#ucnv_getMaxCharSize(const UConverter *converter);
sub ucnv_getMaxCharSize_57(UConverter $converter # const Typedef<UConverter>->«UConverter»*
                           ) is native(LIB) returns int8_t is export { * }

#-From /usr/include/unicode/ucnv.h:825
#/**
# * Returns the minimum byte length (per codepoint) for characters in this codepage.
# * This is usually either 1 or 2.
# * @param converter the Unicode converter
# * @return the minimum number of bytes per codepoint allowed by this particular converter
# * @see ucnv_getMaxCharSize
# * @stable ICU 2.0
# */
#U_STABLE int8_t U_EXPORT2
#ucnv_getMinCharSize(const UConverter *converter);
sub ucnv_getMinCharSize_57(UConverter $converter # const Typedef<UConverter>->«UConverter»*
                           ) is native(LIB) returns int8_t is export { * }

#-From /usr/include/unicode/ucnv.h:842
#/**
# * Returns the display name of the converter passed in based on the Locale
# * passed in. If the locale contains no display name, the internal ASCII
# * name will be filled in.
# *
# * @param converter the Unicode converter.
# * @param displayLocale is the specific Locale we want to localised for
# * @param displayName user provided buffer to be filled in
# * @param displayNameCapacity size of displayName Buffer
# * @param err error status code
# * @return displayNameLength number of UChar needed in displayName
# * @see ucnv_getName
# * @stable ICU 2.0
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_getDisplayName(const UConverter *converter,
sub ucnv_getDisplayName_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                          ,Str                           $displayLocale # const char*
                          ,Pointer[UChar]                $displayName # Typedef<UChar>->«short unsigned int»*
                          ,int32_t                       $displayNameCapacity # Typedef<int32_t>->«int»
                          ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                           ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:859
#/**
# * Gets the internal, canonical name of the converter (zero-terminated).
# * The lifetime of the returned string will be that of the converter
# * passed to this function.
# * @param converter the Unicode converter
# * @param err UErrorCode status
# * @return the internal name of the converter
# * @see ucnv_getDisplayName
# * @stable ICU 2.0
# */
#U_STABLE const char * U_EXPORT2
#ucnv_getName(const UConverter *converter, UErrorCode *err);
sub ucnv_getName_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                   ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                    ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/ucnv.h:885
#/**
# * Gets a codepage number associated with the converter. This is not guaranteed
# * to be the one used to create the converter. Some converters do not represent
# * platform registered codepages and return zero for the codepage number.
# * The error code fill-in parameter indicates if the codepage number
# * is available.
# * Does not check if the converter is <TT>NULL</TT> or if converter's data
# * table is <TT>NULL</TT>.
# *
# * Important: The use of CCSIDs is not recommended because it is limited
# * to only two platforms in principle and only one (UCNV_IBM) in the current
# * ICU converter API.
# * Also, CCSIDs are insufficient to identify IBM Unicode conversion tables precisely.
# * For more details see ucnv_openCCSID().
# *
# * @param converter the Unicode converter
# * @param err the error status code.
# * @return If any error occurrs, -1 will be returned otherwise, the codepage number
# * will be returned
# * @see ucnv_openCCSID
# * @see ucnv_getPlatform
# * @stable ICU 2.0
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_getCCSID(const UConverter *converter,
sub ucnv_getCCSID_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                    ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                     ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:899
#/**
# * Gets a codepage platform associated with the converter. Currently,
# * only <TT>UCNV_IBM</TT> will be returned.
# * Does not test if the converter is <TT>NULL</TT> or if converter's data
# * table is <TT>NULL</TT>.
# * @param converter the Unicode converter
# * @param err the error status code.
# * @return The codepage platform
# * @stable ICU 2.0
# */
#U_STABLE UConverterPlatform U_EXPORT2
#ucnv_getPlatform(const UConverter *converter,
sub ucnv_getPlatform_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                       ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/unicode/ucnv.h:911
#/**
# * Gets the type of the converter
# * e.g. SBCS, MBCS, DBCS, UTF8, UTF16_BE, UTF16_LE, ISO_2022,
# * EBCDIC_STATEFUL, LATIN_1
# * @param converter a valid, opened converter
# * @return the type of the converter
# * @stable ICU 2.0
# */
#U_STABLE UConverterType U_EXPORT2
#ucnv_getType(const UConverter * converter);
sub ucnv_getType_57(UConverter $converter # const Typedef<UConverter>->«UConverter»*
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/unicode/ucnv.h:929
#/**
# * Gets the "starter" (lead) bytes for converters of type MBCS.
# * Will fill in an <TT>U_ILLEGAL_ARGUMENT_ERROR</TT> if converter passed in
# * is not MBCS. Fills in an array of type UBool, with the value of the byte
# * as offset to the array. For example, if (starters[0x20] == TRUE) at return,
# * it means that the byte 0x20 is a starter byte in this converter.
# * Context pointers are always owned by the caller.
# *
# * @param converter a valid, opened converter of type MBCS
# * @param starters an array of size 256 to be filled in
# * @param err error status, <TT>U_ILLEGAL_ARGUMENT_ERROR</TT> if the
# * converter is not a type which can return starters.
# * @see ucnv_getType
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_getStarters(const UConverter* converter,
sub ucnv_getStarters_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                       ,Pointer[int8_t]               $starters # Typedef<UBool>->«Typedef<int8_t>->«signed char»»*
                       ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                        ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:995
# *              currently UCNV_ROUNDTRIP_SET is the only supported value.
# * @param pErrorCode ICU error code in/out parameter.
# *                   Must fulfill U_SUCCESS before the function call.
# *
# * @see UConverterUnicodeSet
# * @see uset_open
# * @see uset_close
# * @stable ICU 2.6
# */
#U_STABLE void U_EXPORT2
#ucnv_getUnicodeSet(const UConverter *cnv,
sub ucnv_getUnicodeSet_57(UConverter                    $cnv # const Typedef<UConverter>->«UConverter»*
                         ,USet                          $setFillIn # Typedef<USet>->«USet»*
                         ,int32                         $whichSet # Typedef<UConverterUnicodeSet>->«UConverterUnicodeSet»
                         ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                          ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1012
#/**
# * Gets the current calback function used by the converter when an illegal
# *  or invalid codepage sequence is found.
# * Context pointers are always owned by the caller.
# *
# * @param converter the unicode converter
# * @param action fillin: returns the callback function pointer
# * @param context fillin: returns the callback's private void* context
# * @see ucnv_setToUCallBack
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_getToUCallBack (const UConverter * converter,
sub ucnv_getToUCallBack_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                          ,Pointer[()]                   $action # Typedef<UConverterToUCallback>->«F:void ( )*»*
                          ,Pointer[Pointer]              $context # const void**
                           ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1028
#/**
# * Gets the current callback function used by the converter when illegal
# * or invalid Unicode sequence is found.
# * Context pointers are always owned by the caller.
# *
# * @param converter the unicode converter
# * @param action fillin: returns the callback function pointer
# * @param context fillin: returns the callback's private void* context
# * @see ucnv_setFromUCallBack
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_getFromUCallBack (const UConverter * converter,
sub ucnv_getFromUCallBack_57(UConverter                    $converter # const Typedef<UConverter>->«UConverter»*
                            ,Pointer[()]                   $action # Typedef<UConverterFromUCallback>->«F:void ( )*»*
                            ,Pointer[Pointer]              $context # const void**
                             ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1048
#/**
# * Changes the callback function used by the converter when
# * an illegal or invalid sequence is found.
# * Context pointers are always owned by the caller.
# * Predefined actions and contexts can be found in the ucnv_err.h header.
# *
# * @param converter the unicode converter
# * @param newAction the new callback function
# * @param newContext the new toUnicode callback context pointer. This can be NULL.
# * @param oldAction fillin: returns the old callback function pointer. This can be NULL.
# * @param oldContext fillin: returns the old callback's private void* context. This can be NULL.
# * @param err The error code status
# * @see ucnv_getToUCallBack
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_setToUCallBack (UConverter * converter,
sub ucnv_setToUCallBack_57(UConverter                    $converter # Typedef<UConverter>->«UConverter»*
                          ,&newAction () # Typedef<UConverterToUCallback>->«F:void ( )*»
                          ,Pointer                       $newContext # const void*
                          ,Pointer[()]                   $oldAction # Typedef<UConverterToUCallback>->«F:void ( )*»*
                          ,Pointer[Pointer]              $oldContext # const void**
                          ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                           ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1071
#/**
# * Changes the current callback function used by the converter when
# * an illegal or invalid sequence is found.
# * Context pointers are always owned by the caller.
# * Predefined actions and contexts can be found in the ucnv_err.h header.
# *
# * @param converter the unicode converter
# * @param newAction the new callback function
# * @param newContext the new fromUnicode callback context pointer. This can be NULL.
# * @param oldAction fillin: returns the old callback function pointer. This can be NULL.
# * @param oldContext fillin: returns the old callback's private void* context. This can be NULL.
# * @param err The error code status
# * @see ucnv_getFromUCallBack
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_setFromUCallBack (UConverter * converter,
sub ucnv_setFromUCallBack_57(UConverter                    $converter # Typedef<UConverter>->«UConverter»*
                            ,&newAction () # Typedef<UConverterFromUCallback>->«F:void ( )*»
                            ,Pointer                       $newContext # const void*
                            ,Pointer[()]                   $oldAction # Typedef<UConverterFromUCallback>->«F:void ( )*»*
                            ,Pointer[Pointer]              $oldContext # const void**
                            ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                             ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1137
#/**
# * Converts an array of unicode characters to an array of codepage
# * characters. This function is optimized for converting a continuous
# * stream of data in buffer-sized chunks, where the entire source and
# * target does not fit in available buffers.
# *
# * The source pointer is an in/out parameter. It starts out pointing where the
# * conversion is to begin, and ends up pointing after the last UChar consumed.
# *
# * Target similarly starts out pointer at the first available byte in the output
# * buffer, and ends up pointing after the last byte written to the output.
# *
# * The converter always attempts to consume the entire source buffer, unless
# * (1.) the target buffer is full, or (2.) a failing error is returned from the
# * current callback function.  When a successful error status has been
# * returned, it means that all of the source buffer has been
# *  consumed. At that point, the caller should reset the source and
# *  sourceLimit pointers to point to the next chunk.
# *
# * At the end of the stream (flush==TRUE), the input is completely consumed
# * when *source==sourceLimit and no error code is set.
# * The converter object is then automatically reset by this function.
# * (This means that a converter need not be reset explicitly between data
# * streams if it finishes the previous stream without errors.)
# *
# * This is a <I>stateful</I> conversion. Additionally, even when all source data has
# * been consumed, some data may be in the converters' internal state.
# * Call this function repeatedly, updating the target pointers with
# * the next empty chunk of target in case of a
# * <TT>U_BUFFER_OVERFLOW_ERROR</TT>, and updating the source  pointers
# *  with the next chunk of source when a successful error status is
# * returned, until there are no more chunks of source data.
# * @param converter the Unicode converter
# * @param target I/O parameter. Input : Points to the beginning of the buffer to copy
# *  codepage characters to. Output : points to after the last codepage character copied
# *  to <TT>target</TT>.
# * @param targetLimit the pointer just after last of the <TT>target</TT> buffer
# * @param source I/O parameter, pointer to pointer to the source Unicode character buffer.
# * @param sourceLimit the pointer just after the last of the source buffer
# * @param offsets if NULL is passed, nothing will happen to it, otherwise it needs to have the same number
# * of allocated cells as <TT>target</TT>. Will fill in offsets from target to source pointer
# * e.g: <TT>offsets[3]</TT> is equal to 6, it means that the <TT>target[3]</TT> was a result of transcoding <TT>source[6]</TT>
# * For output data carried across calls, and other data without a specific source character
# * (such as from escape sequences or callbacks)  -1 will be placed for offsets.
# * @param flush set to <TT>TRUE</TT> if the current source buffer is the last available
# * chunk of the source, <TT>FALSE</TT> otherwise. Note that if a failing status is returned,
# * this function may have to be called multiple times with flush set to <TT>TRUE</TT> until
# * the source buffer is consumed.
# * @param err the error status.  <TT>U_ILLEGAL_ARGUMENT_ERROR</TT> will be set if the
# * converter is <TT>NULL</TT>.
# * <code>U_BUFFER_OVERFLOW_ERROR</code> will be set if the target is full and there is
# * still data to be written to the target.
# * @see ucnv_fromUChars
# * @see ucnv_convert
# * @see ucnv_getMinCharSize
# * @see ucnv_setToUCallBack
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_fromUnicode (UConverter * converter,
sub ucnv_fromUnicode_57(UConverter                    $converter # Typedef<UConverter>->«UConverter»*
                       ,Pointer[Str]                  $target # char**
                       ,Str                           $targetLimit # const char*
                       ,Pointer[Pointer[UChar]]       $source # const Typedef<UChar>->«short unsigned int»**
                       ,Pointer[UChar]                $sourceLimit # const Typedef<UChar>->«short unsigned int»*
                       ,Pointer[int32_t]              $offsets # Typedef<int32_t>->«int»*
                       ,int8_t                        $flush # Typedef<UBool>->«Typedef<int8_t>->«signed char»»
                       ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                        ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1206
#/**
# * Converts a buffer of codepage bytes into an array of unicode UChars
# * characters. This function is optimized for converting a continuous
# * stream of data in buffer-sized chunks, where the entire source and
# * target does not fit in available buffers.
# *
# * The source pointer is an in/out parameter. It starts out pointing where the
# * conversion is to begin, and ends up pointing after the last byte of source consumed.
# *
# * Target similarly starts out pointer at the first available UChar in the output
# * buffer, and ends up pointing after the last UChar written to the output.
# * It does NOT necessarily keep UChar sequences together.
# *
# * The converter always attempts to consume the entire source buffer, unless
# * (1.) the target buffer is full, or (2.) a failing error is returned from the
# * current callback function.  When a successful error status has been
# * returned, it means that all of the source buffer has been
# *  consumed. At that point, the caller should reset the source and
# *  sourceLimit pointers to point to the next chunk.
# *
# * At the end of the stream (flush==TRUE), the input is completely consumed
# * when *source==sourceLimit and no error code is set
# * The converter object is then automatically reset by this function.
# * (This means that a converter need not be reset explicitly between data
# * streams if it finishes the previous stream without errors.)
# *
# * This is a <I>stateful</I> conversion. Additionally, even when all source data has
# * been consumed, some data may be in the converters' internal state.
# * Call this function repeatedly, updating the target pointers with
# * the next empty chunk of target in case of a
# * <TT>U_BUFFER_OVERFLOW_ERROR</TT>, and updating the source  pointers
# *  with the next chunk of source when a successful error status is
# * returned, until there are no more chunks of source data.
# * @param converter the Unicode converter
# * @param target I/O parameter. Input : Points to the beginning of the buffer to copy
# *  UChars into. Output : points to after the last UChar copied.
# * @param targetLimit the pointer just after the end of the <TT>target</TT> buffer
# * @param source I/O parameter, pointer to pointer to the source codepage buffer.
# * @param sourceLimit the pointer to the byte after the end of the source buffer
# * @param offsets if NULL is passed, nothing will happen to it, otherwise it needs to have the same number
# * of allocated cells as <TT>target</TT>. Will fill in offsets from target to source pointer
# * e.g: <TT>offsets[3]</TT> is equal to 6, it means that the <TT>target[3]</TT> was a result of transcoding <TT>source[6]</TT>
# * For output data carried across calls, and other data without a specific source character
# * (such as from escape sequences or callbacks)  -1 will be placed for offsets.
# * @param flush set to <TT>TRUE</TT> if the current source buffer is the last available
# * chunk of the source, <TT>FALSE</TT> otherwise. Note that if a failing status is returned,
# * this function may have to be called multiple times with flush set to <TT>TRUE</TT> until
# * the source buffer is consumed.
# * @param err the error status.  <TT>U_ILLEGAL_ARGUMENT_ERROR</TT> will be set if the
# * converter is <TT>NULL</TT>.
# * <code>U_BUFFER_OVERFLOW_ERROR</code> will be set if the target is full and there is
# * still data to be written to the target.
# * @see ucnv_fromUChars
# * @see ucnv_convert
# * @see ucnv_getMinCharSize
# * @see ucnv_setFromUCallBack
# * @see ucnv_getNextUChar
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_toUnicode(UConverter *converter,
sub ucnv_toUnicode_57(UConverter                    $converter # Typedef<UConverter>->«UConverter»*
                     ,Pointer[Pointer[UChar]]       $target # Typedef<UChar>->«short unsigned int»**
                     ,Pointer[UChar]                $targetLimit # const Typedef<UChar>->«short unsigned int»*
                     ,Pointer[Str]                  $source # const char**
                     ,Str                           $sourceLimit # const char*
                     ,Pointer[int32_t]              $offsets # Typedef<int32_t>->«int»*
                     ,int8_t                        $flush # Typedef<UBool>->«Typedef<int8_t>->«signed char»»
                     ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                      ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1243
# *         if the length is greater than destCapacity, then the string will not fit
# *         and a buffer of the indicated length would need to be passed in
# * @see ucnv_fromUnicode
# * @see ucnv_convert
# * @see UCNV_GET_MAX_BYTES_FOR_STRING
# * @stable ICU 2.0
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_fromUChars(UConverter *cnv,
sub ucnv_fromUChars_57(UConverter                    $cnv # Typedef<UConverter>->«UConverter»*
                      ,Str                           $dest # char*
                      ,int32_t                       $destCapacity # Typedef<int32_t>->«int»
                      ,Pointer[UChar]                $src # const Typedef<UChar>->«short unsigned int»*
                      ,int32_t                       $srcLength # Typedef<int32_t>->«int»
                      ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                       ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:1275
# *         if the length is greater than destCapacity, then the string will not fit
# *         and a buffer of the indicated length would need to be passed in
# * @see ucnv_toUnicode
# * @see ucnv_convert
# * @stable ICU 2.0
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_toUChars(UConverter *cnv,
sub ucnv_toUChars_57(UConverter                    $cnv # Typedef<UConverter>->«UConverter»*
                    ,Pointer[UChar]                $dest # Typedef<UChar>->«short unsigned int»*
                    ,int32_t                       $destCapacity # Typedef<int32_t>->«int»
                    ,Str                           $src # const char*
                    ,int32_t                       $srcLength # Typedef<int32_t>->«int»
                    ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                     ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:1351
#/**
# * Convert a codepage buffer into Unicode one character at a time.
# * The input is completely consumed when the U_INDEX_OUTOFBOUNDS_ERROR is set.
# *
# * Advantage compared to ucnv_toUnicode() or ucnv_toUChars():
# * - Faster for small amounts of data, for most converters, e.g.,
# *   US-ASCII, ISO-8859-1, UTF-8/16/32, and most "normal" charsets.
# *   (For complex converters, e.g., SCSU, UTF-7 and ISO 2022 variants,
# *    it uses ucnv_toUnicode() internally.)
# * - Convenient.
# *
# * Limitations compared to ucnv_toUnicode():
# * - Always assumes flush=TRUE.
# *   This makes ucnv_getNextUChar() unsuitable for "streaming" conversion,
# *   that is, for where the input is supplied in multiple buffers,
# *   because ucnv_getNextUChar() will assume the end of the input at the end
# *   of the first buffer.
# * - Does not provide offset output.
# *
# * It is possible to "mix" ucnv_getNextUChar() and ucnv_toUnicode() because
# * ucnv_getNextUChar() uses the current state of the converter
# * (unlike ucnv_toUChars() which always resets first).
# * However, if ucnv_getNextUChar() is called after ucnv_toUnicode()
# * stopped in the middle of a character sequence (with flush=FALSE),
# * then ucnv_getNextUChar() will always use the slower ucnv_toUnicode()
# * internally until the next character boundary.
# * (This is new in ICU 2.6. In earlier releases, ucnv_getNextUChar() had to
# * start at a character boundary.)
# *
# * Instead of using ucnv_getNextUChar(), it is recommended
# * to convert using ucnv_toUnicode() or ucnv_toUChars()
# * and then iterate over the text using U16_NEXT() or a UCharIterator (uiter.h)
# * or a C++ CharacterIterator or similar.
# * This allows streaming conversion and offset output, for example.
# *
# * <p>Handling of surrogate pairs and supplementary-plane code points:<br>
# * There are two different kinds of codepages that provide mappings for surrogate characters:
# * <ul>
# *   <li>Codepages like UTF-8, UTF-32, and GB 18030 provide direct representations for Unicode
# *       code points U+10000-U+10ffff as well as for single surrogates U+d800-U+dfff.
# *       Each valid sequence will result in exactly one returned code point.
# *       If a sequence results in a single surrogate, then that will be returned
# *       by itself, even if a neighboring sequence encodes the matching surrogate.</li>
# *   <li>Codepages like SCSU and LMBCS (and UTF-16) provide direct representations only for BMP code points
# *       including surrogates. Code points in supplementary planes are represented with
# *       two sequences, each encoding a surrogate.
# *       For these codepages, matching pairs of surrogates will be combined into single
# *       code points for returning from this function.
# *       (Note that SCSU is actually a mix of these codepage types.)</li>
# * </ul></p>
# *
# * @param converter an open UConverter
# * @param source the address of a pointer to the codepage buffer, will be
# *  updated to point after the bytes consumed in the conversion call.
# * @param sourceLimit points to the end of the input buffer
# * @param err fills in error status (see ucnv_toUnicode)
# * <code>U_INDEX_OUTOFBOUNDS_ERROR</code> will be set if the input
# * is empty or does not convert to any output (e.g.: pure state-change
# * codes SI/SO, escape sequences for ISO 2022,
# * or if the callback did not output anything, ...).
# * This function will not set a <code>U_BUFFER_OVERFLOW_ERROR</code> because
# *  the "buffer" is the return code. However, there might be subsequent output
# *  stored in the converter object
# * that will be returned in following calls to this function.
# * @return a UChar32 resulting from the partial conversion of source
# * @see ucnv_toUnicode
# * @see ucnv_toUChars
# * @see ucnv_convert
# * @stable ICU 2.0
# */
#U_STABLE UChar32 U_EXPORT2
#ucnv_getNextUChar(UConverter * converter,
sub ucnv_getNextUChar_57(UConverter                    $converter # Typedef<UConverter>->«UConverter»*
                        ,Pointer[Str]                  $source # const char**
                        ,Str                           $sourceLimit # const char*
                        ,Pointer[int32]                $err # Typedef<UErrorCode>->«UErrorCode»*
                         ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:1495
# * }
# * \endcode
# *
# * @param targetCnv     Output converter, used to convert from the UTF-16 pivot
# *                      to the target using ucnv_fromUnicode().
# * @param sourceCnv     Input converter, used to convert from the source to
# *                      the UTF-16 pivot using ucnv_toUnicode().
# * @param target        I/O parameter, same as for ucnv_fromUChars().
# *                      Input: *target points to the beginning of the target buffer.
# *                      Output: *target points to the first unit after the last char written.
# * @param targetLimit   Pointer to the first unit after the target buffer.
# * @param source        I/O parameter, same as for ucnv_toUChars().
# *                      Input: *source points to the beginning of the source buffer.
# *                      Output: *source points to the first unit after the last char read.
# * @param sourceLimit   Pointer to the first unit after the source buffer.
# * @param pivotStart    Pointer to the UTF-16 pivot buffer. If pivotStart==NULL,
# *                      then an internal buffer is used and the other pivot
# *                      arguments are ignored and can be NULL as well.
# * @param pivotSource   I/O parameter, same as source in ucnv_fromUChars() for
# *                      conversion from the pivot buffer to the target buffer.
# * @param pivotTarget   I/O parameter, same as target in ucnv_toUChars() for
# *                      conversion from the source buffer to the pivot buffer.
# *                      It must be pivotStart<=*pivotSource<=*pivotTarget<=pivotLimit
# *                      and pivotStart<pivotLimit (unless pivotStart==NULL).
# * @param pivotLimit    Pointer to the first unit after the pivot buffer.
# * @param reset         If TRUE, then ucnv_resetToUnicode(sourceCnv) and
# *                      ucnv_resetFromUnicode(targetCnv) are called, and the
# *                      pivot pointers are reset (*pivotTarget=*pivotSource=pivotStart).
# * @param flush         If true, indicates the end of the input.
# *                      Passed directly to ucnv_toUnicode(), and carried over to
# *                      ucnv_fromUnicode() when the source is empty as well.
# * @param pErrorCode    ICU error code in/out parameter.
# *                      Must fulfill U_SUCCESS before the function call.
# *                      U_BUFFER_OVERFLOW_ERROR always refers to the target buffer
# *                      because overflows into the pivot buffer are handled internally.
# *                      Other conversion errors are from the source-to-pivot
# *                      conversion if *pivotSource==pivotStart, otherwise from
# *                      the pivot-to-target conversion.
# *
# * @see ucnv_convert
# * @see ucnv_fromAlgorithmic
# * @see ucnv_toAlgorithmic
# * @see ucnv_fromUnicode
# * @see ucnv_toUnicode
# * @see ucnv_fromUChars
# * @see ucnv_toUChars
# * @stable ICU 2.6
# */
#U_STABLE void U_EXPORT2
#ucnv_convertEx(UConverter *targetCnv, UConverter *sourceCnv,
sub ucnv_convertEx_57(UConverter                    $targetCnv # Typedef<UConverter>->«UConverter»*
                     ,UConverter                    $sourceCnv # Typedef<UConverter>->«UConverter»*
                     ,Pointer[Str]                  $target # char**
                     ,Str                           $targetLimit # const char*
                     ,Pointer[Str]                  $source # const char**
                     ,Str                           $sourceLimit # const char*
                     ,Pointer[UChar]                $pivotStart # Typedef<UChar>->«short unsigned int»*
                     ,Pointer[Pointer[UChar]]       $pivotSource # Typedef<UChar>->«short unsigned int»**
                     ,Pointer[Pointer[UChar]]       $pivotTarget # Typedef<UChar>->«short unsigned int»**
                     ,Pointer[UChar]                $pivotLimit # const Typedef<UChar>->«short unsigned int»*
                     ,int8_t                        $reset # Typedef<UBool>->«Typedef<int8_t>->«signed char»»
                     ,int8_t                        $flush # Typedef<UBool>->«Typedef<int8_t>->«signed char»»
                     ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                      ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1559
#/**
# * Convert from one external charset to another.
# * Internally, two converters are opened according to the name arguments,
# * then the text is converted to and from the 16-bit Unicode "pivot"
# * using ucnv_convertEx(), then the converters are closed again.
# *
# * This is a convenience function, not an efficient way to convert a lot of text:
# * ucnv_convert()
# * - takes charset names, not converter objects, so that
# *   - two converters are opened for each call
# *   - only single-string conversion is possible, not streaming operation
# * - does not provide enough information to find out,
# *   in case of failure, whether the toUnicode or
# *   the fromUnicode conversion failed
# * - allows NUL-terminated input
# *   (only a single NUL byte, will not work for charsets with multi-byte NULs)
# *   (if sourceLength==-1, see parameters)
# * - terminate with a NUL on output
# *   (only a single NUL byte, not useful for charsets with multi-byte NULs),
# *   or set U_STRING_NOT_TERMINATED_WARNING if the output exactly fills
# *   the target buffer
# * - a pivot buffer is provided internally
# *
# * The function returns when one of the following is true:
# * - the entire source text has been converted successfully to the target buffer
# *   and either the target buffer is terminated with a single NUL byte
# *   or the error code is set to U_STRING_NOT_TERMINATED_WARNING
# * - a target buffer overflow occurred (U_BUFFER_OVERFLOW_ERROR)
# *   and the full output string length is returned ("preflighting")
# * - a conversion error occurred
# *   (other U_FAILURE(), see description of pErrorCode)
# *
# * @param toConverterName   The name of the converter that is used to convert
# *                          from the UTF-16 pivot buffer to the target.
# * @param fromConverterName The name of the converter that is used to convert
# *                          from the source to the UTF-16 pivot buffer.
# * @param target            Pointer to the output buffer.
# * @param targetCapacity    Capacity of the target, in bytes.
# * @param source            Pointer to the input buffer.
# * @param sourceLength      Length of the input text, in bytes, or -1 for NUL-terminated input.
# * @param pErrorCode        ICU error code in/out parameter.
# *                          Must fulfill U_SUCCESS before the function call.
# * @return Length of the complete output text in bytes, even if it exceeds the targetCapacity
# *         and a U_BUFFER_OVERFLOW_ERROR is set.
# *
# * @see ucnv_convertEx
# * @see ucnv_fromAlgorithmic
# * @see ucnv_toAlgorithmic
# * @see ucnv_fromUnicode
# * @see ucnv_toUnicode
# * @see ucnv_fromUChars
# * @see ucnv_toUChars
# * @see ucnv_getNextUChar
# * @stable ICU 2.0
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_convert(const char *toConverterName,
sub ucnv_convert_57(Str                           $toConverterName # const char*
                   ,Str                           $fromConverterName # const char*
                   ,Str                           $target # char*
                   ,int32_t                       $targetCapacity # Typedef<int32_t>->«int»
                   ,Str                           $source # const char*
                   ,int32_t                       $sourceLength # Typedef<int32_t>->«int»
                   ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                    ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:1613
# * see the User Guide Strings chapter). See ucnv_convert() for details.
# *
# * @param algorithmicType   UConverterType constant identifying the desired target
# *                          charset as a purely algorithmic converter.
# *                          Those are converters for Unicode charsets like
# *                          UTF-8, BOCU-1, SCSU, UTF-7, IMAP-mailbox-name, etc.,
# *                          as well as US-ASCII and ISO-8859-1.
# * @param cnv               The converter that is used to convert
# *                          from the source to the UTF-16 pivot buffer.
# * @param target            Pointer to the output buffer.
# * @param targetCapacity    Capacity of the target, in bytes.
# * @param source            Pointer to the input buffer.
# * @param sourceLength      Length of the input text, in bytes
# * @param pErrorCode        ICU error code in/out parameter.
# *                          Must fulfill U_SUCCESS before the function call.
# * @return Length of the complete output text in bytes, even if it exceeds the targetCapacity
# *         and a U_BUFFER_OVERFLOW_ERROR is set.
# *
# * @see ucnv_fromAlgorithmic
# * @see ucnv_convert
# * @see ucnv_convertEx
# * @see ucnv_fromUnicode
# * @see ucnv_toUnicode
# * @see ucnv_fromUChars
# * @see ucnv_toUChars
# * @stable ICU 2.6
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_toAlgorithmic(UConverterType algorithmicType,
sub ucnv_toAlgorithmic_57(int32                         $algorithmicType # Typedef<UConverterType>->«UConverterType»
                         ,UConverter                    $cnv # Typedef<UConverter>->«UConverter»*
                         ,Str                           $target # char*
                         ,int32_t                       $targetCapacity # Typedef<int32_t>->«int»
                         ,Str                           $source # const char*
                         ,int32_t                       $sourceLength # Typedef<int32_t>->«int»
                         ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                          ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:1665
# * see the User Guide Strings chapter). See ucnv_convert() for details.
# *
# * @param cnv               The converter that is used to convert
# *                          from the UTF-16 pivot buffer to the target.
# * @param algorithmicType   UConverterType constant identifying the desired source
# *                          charset as a purely algorithmic converter.
# *                          Those are converters for Unicode charsets like
# *                          UTF-8, BOCU-1, SCSU, UTF-7, IMAP-mailbox-name, etc.,
# *                          as well as US-ASCII and ISO-8859-1.
# * @param target            Pointer to the output buffer.
# * @param targetCapacity    Capacity of the target, in bytes.
# * @param source            Pointer to the input buffer.
# * @param sourceLength      Length of the input text, in bytes
# * @param pErrorCode        ICU error code in/out parameter.
# *                          Must fulfill U_SUCCESS before the function call.
# * @return Length of the complete output text in bytes, even if it exceeds the targetCapacity
# *         and a U_BUFFER_OVERFLOW_ERROR is set.
# *
# * @see ucnv_fromAlgorithmic
# * @see ucnv_convert
# * @see ucnv_convertEx
# * @see ucnv_fromUnicode
# * @see ucnv_toUnicode
# * @see ucnv_fromUChars
# * @see ucnv_toUChars
# * @stable ICU 2.6
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_fromAlgorithmic(UConverter *cnv,
sub ucnv_fromAlgorithmic_57(UConverter                    $cnv # Typedef<UConverter>->«UConverter»*
                           ,int32                         $algorithmicType # Typedef<UConverterType>->«UConverterType»
                           ,Str                           $target # char*
                           ,int32_t                       $targetCapacity # Typedef<int32_t>->«int»
                           ,Str                           $source # const char*
                           ,int32_t                       $sourceLength # Typedef<int32_t>->«int»
                           ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                            ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:1679
#/**
# * Frees up memory occupied by unused, cached converter shared data.
# *
# * @return the number of cached converters successfully deleted
# * @see ucnv_close
# * @stable ICU 2.0
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_flushCache(void);
sub ucnv_flushCache_57(
                       ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:1689
#/**
# * Returns the number of available converters, as per the alias file.
# *
# * @return the number of available converters
# * @see ucnv_getAvailableName
# * @stable ICU 2.0
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_countAvailable(void);
sub ucnv_countAvailable_57(
                           ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:1702
#/**
# * Gets the canonical converter name of the specified converter from a list of
# * all available converters contaied in the alias file. All converters
# * in this list can be opened.
# *
# * @param n the index to a converter available on the system (in the range <TT>[0..ucnv_countAvaiable()]</TT>)
# * @return a pointer a string (library owned), or <TT>NULL</TT> if the index is out of bounds.
# * @see ucnv_countAvailable
# * @stable ICU 2.0
# */
#U_STABLE const char* U_EXPORT2
#ucnv_getAvailableName(int32_t n);
sub ucnv_getAvailableName_57(int32_t $n # Typedef<int32_t>->«int»
                             ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/ucnv.h:1717
#/**
# * Returns a UEnumeration to enumerate all of the canonical converter
# * names, as per the alias file, regardless of the ability to open each
# * converter.
# *
# * @return A UEnumeration object for getting all the recognized canonical
# *   converter names.
# * @see ucnv_getAvailableName
# * @see uenum_close
# * @see uenum_next
# * @stable ICU 2.4
# */
#U_STABLE UEnumeration * U_EXPORT2
#ucnv_openAllNames(UErrorCode *pErrorCode);
sub ucnv_openAllNames_57(Pointer[int32] $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                         ) is native(LIB) returns UEnumeration is export { * }

#-From /usr/include/unicode/ucnv.h:1730
#/**
# * Gives the number of aliases for a given converter or alias name.
# * If the alias is ambiguous, then the preferred converter is used
# * and the status is set to U_AMBIGUOUS_ALIAS_WARNING.
# * This method only enumerates the listed entries in the alias file.
# * @param alias alias name
# * @param pErrorCode error status
# * @return number of names on alias list for given alias
# * @stable ICU 2.0
# */
#U_STABLE uint16_t U_EXPORT2
#ucnv_countAliases(const char *alias, UErrorCode *pErrorCode);
sub ucnv_countAliases_57(Str                           $alias # const char*
                        ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                         ) is native(LIB) returns uint16_t is export { * }

#-From /usr/include/unicode/ucnv.h:1745
#/**
# * Gives the name of the alias at given index of alias list.
# * This method only enumerates the listed entries in the alias file.
# * If the alias is ambiguous, then the preferred converter is used
# * and the status is set to U_AMBIGUOUS_ALIAS_WARNING.
# * @param alias alias name
# * @param n index in alias list
# * @param pErrorCode result of operation
# * @return returns the name of the alias at given index
# * @see ucnv_countAliases
# * @stable ICU 2.0
# */
#U_STABLE const char * U_EXPORT2
#ucnv_getAlias(const char *alias, uint16_t n, UErrorCode *pErrorCode);
sub ucnv_getAlias_57(Str                           $alias # const char*
                    ,uint16_t                      $n # Typedef<uint16_t>->«short unsigned int»
                    ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                     ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/ucnv.h:1761
#/**
# * Fill-up the list of alias names for the given alias.
# * This method only enumerates the listed entries in the alias file.
# * If the alias is ambiguous, then the preferred converter is used
# * and the status is set to U_AMBIGUOUS_ALIAS_WARNING.
# * @param alias alias name
# * @param aliases fill-in list, aliases is a pointer to an array of
# *        <code>ucnv_countAliases()</code> string-pointers
# *        (<code>const char *</code>) that will be filled in.
# *        The strings themselves are owned by the library.
# * @param pErrorCode result of operation
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_getAliases(const char *alias, const char **aliases, UErrorCode *pErrorCode);
sub ucnv_getAliases_57(Str                           $alias # const char*
                      ,Pointer[Str]                  $aliases # const char**
                      ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                       ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1787
# *      are such standards
# * @param pErrorCode The error code
# * @return A UEnumeration object for getting all aliases that are recognized
# *      by a standard. If any of the parameters are invalid, NULL
# *      is returned.
# * @see ucnv_getStandardName
# * @see uenum_close
# * @see uenum_next
# * @stable ICU 2.2
# */
#U_STABLE UEnumeration * U_EXPORT2
#ucnv_openStandardNames(const char *convName,
sub ucnv_openStandardNames_57(Str                           $convName # const char*
                             ,Str                           $standard # const char*
                             ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                              ) is native(LIB) returns UEnumeration is export { * }

#-From /usr/include/unicode/ucnv.h:1797
#/**
# * Gives the number of standards associated to converter names.
# * @return number of standards
# * @stable ICU 2.0
# */
#U_STABLE uint16_t U_EXPORT2
#ucnv_countStandards(void);
sub ucnv_countStandards_57(
                           ) is native(LIB) returns uint16_t is export { * }

#-From /usr/include/unicode/ucnv.h:1807
#/**
# * Gives the name of the standard at given index of standard list.
# * @param n index in standard list
# * @param pErrorCode result of operation
# * @return returns the name of the standard at given index. Owned by the library.
# * @stable ICU 2.0
# */
#U_STABLE const char * U_EXPORT2
#ucnv_getStandard(uint16_t n, UErrorCode *pErrorCode);
sub ucnv_getStandard_57(uint16_t                      $n # Typedef<uint16_t>->«short unsigned int»
                       ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                        ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/ucnv.h:1829
# *         if a standard converter name cannot be determined,
# *         then <code>NULL</code> is returned. Owned by the library.
# * @stable ICU 2.0
# */
#U_STABLE const char * U_EXPORT2
#ucnv_getStandardName(const char *name, const char *standard, UErrorCode *pErrorCode);
sub ucnv_getStandardName_57(Str                           $name # const char*
                           ,Str                           $standard # const char*
                           ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                            ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/ucnv.h:1851
# *         if a standard or alias name cannot be determined,
# *         then <code>NULL</code> is returned. The returned string is
# *         owned by the library.
# * @see ucnv_getStandardName
# * @stable ICU 2.4
# */
#U_STABLE const char * U_EXPORT2
#ucnv_getCanonicalName(const char *alias, const char *standard, UErrorCode *pErrorCode);
sub ucnv_getCanonicalName_57(Str                           $alias # const char*
                            ,Str                           $standard # const char*
                            ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                             ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/ucnv.h:1868
#/**
# * Returns the current default converter name. If you want to open
# * a default converter, you do not need to use this function.
# * It is faster if you pass a NULL argument to ucnv_open the
# * default converter.
# *
# * If U_CHARSET_IS_UTF8 is defined to 1 in utypes.h then this function
# * always returns "UTF-8".
# *
# * @return returns the current default converter name.
# *         Storage owned by the library
# * @see ucnv_setDefaultName
# * @stable ICU 2.0
# */
#U_STABLE const char * U_EXPORT2
#ucnv_getDefaultName(void);
sub ucnv_getDefaultName_57(
                           ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/ucnv.h:1888
##ifndef U_HIDE_SYSTEM_API
#/**
# * This function is not thread safe. DO NOT call this function when ANY ICU
# * function is being used from more than one thread! This function sets the
# * current default converter name. If this function needs to be called, it
# * should be called during application initialization. Most of the time, the
# * results from ucnv_getDefaultName() or ucnv_open with a NULL string argument
# * is sufficient for your application.
# *
# * If U_CHARSET_IS_UTF8 is defined to 1 in utypes.h then this function
# * does nothing.
# *
# * @param name the converter name to be the default (must be known by ICU).
# * @see ucnv_getDefaultName
# * @system
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_setDefaultName(const char *name);
sub ucnv_setDefaultName_57(Str $name # const char*
                           ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1909
#/**
# * Fixes the backslash character mismapping.  For example, in SJIS, the backslash
# * character in the ASCII portion is also used to represent the yen currency sign.
# * When mapping from Unicode character 0x005C, it's unclear whether to map the
# * character back to yen or backslash in SJIS.  This function will take the input
# * buffer and replace all the yen sign characters with backslash.  This is necessary
# * when the user tries to open a file with the input buffer on Windows.
# * This function will test the converter to see whether such mapping is
# * required.  You can sometimes avoid using this function by using the correct version
# * of Shift-JIS.
# *
# * @param cnv The converter representing the target codepage.
# * @param source the input buffer to be fixed
# * @param sourceLen the length of the input buffer
# * @see ucnv_isAmbiguous
# * @stable ICU 2.0
# */
#U_STABLE void U_EXPORT2
#ucnv_fixFileSeparator(const UConverter *cnv, UChar *source, int32_t sourceLen);
sub ucnv_fixFileSeparator_57(UConverter                    $cnv # const Typedef<UConverter>->«UConverter»*
                            ,Pointer[UChar]                $source # Typedef<UChar>->«short unsigned int»*
                            ,int32_t                       $sourceLen # Typedef<int32_t>->«int»
                             ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1920
#/**
# * Determines if the converter contains ambiguous mappings of the same
# * character or not.
# * @param cnv the converter to be tested
# * @return TRUE if the converter contains ambiguous mapping of the same
# * character, FALSE otherwise.
# * @stable ICU 2.0
# */
#U_STABLE UBool U_EXPORT2
#ucnv_isAmbiguous(const UConverter *cnv);
sub ucnv_isAmbiguous_57(UConverter $cnv # const Typedef<UConverter>->«UConverter»*
                        ) is native(LIB) returns int8_t is export { * }

#-From /usr/include/unicode/ucnv.h:1938
#/**
# * Sets the converter to use fallback mappings or not.
# * Regardless of this flag, the converter will always use
# * fallbacks from Unicode Private Use code points, as well as
# * reverse fallbacks (to Unicode).
# * For details see ".ucm File Format"
# * in the Conversion Data chapter of the ICU User Guide:
# * http://www.icu-project.org/userguide/conversion-data.html#ucmformat
# *
# * @param cnv The converter to set the fallback mapping usage on.
# * @param usesFallback TRUE if the user wants the converter to take advantage of the fallback
# * mapping, FALSE otherwise.
# * @stable ICU 2.0
# * @see ucnv_usesFallback
# */
#U_STABLE void U_EXPORT2
#ucnv_setFallback(UConverter *cnv, UBool usesFallback);
sub ucnv_setFallback_57(UConverter                    $cnv # Typedef<UConverter>->«UConverter»*
                       ,int8_t                        $usesFallback # Typedef<UBool>->«Typedef<int8_t>->«signed char»»
                        ) is native(LIB)  is export { * }

#-From /usr/include/unicode/ucnv.h:1950
#/**
# * Determines if the converter uses fallback mappings or not.
# * This flag has restrictions, see ucnv_setFallback().
# *
# * @param cnv The converter to be tested
# * @return TRUE if the converter uses fallback, FALSE otherwise.
# * @stable ICU 2.0
# * @see ucnv_setFallback
# */
#U_STABLE UBool U_EXPORT2
#ucnv_usesFallback(const UConverter *cnv);
sub ucnv_usesFallback_57(UConverter $cnv # const Typedef<UConverter>->«UConverter»*
                         ) is native(LIB) returns int8_t is export { * }

#-From /usr/include/unicode/ucnv.h:1982
#/**
# * Detects Unicode signature byte sequences at the start of the byte stream
# * and returns the charset name of the indicated Unicode charset.
# * NULL is returned when no Unicode signature is recognized.
# * The number of bytes in the signature is output as well.
# *
# * The caller can ucnv_open() a converter using the charset name.
# * The first code unit (UChar) from the start of the stream will be U+FEFF
# * (the Unicode BOM/signature character) and can usually be ignored.
# *
# * For most Unicode charsets it is also possible to ignore the indicated
# * number of initial stream bytes and start converting after them.
# * However, there are stateful Unicode charsets (UTF-7 and BOCU-1) for which
# * this will not work. Therefore, it is best to ignore the first output UChar
# * instead of the input signature bytes.
# * <p>
# * Usage:
# * \snippet samples/ucnv/convsamp.cpp ucnv_detectUnicodeSignature
# *
# * @param source            The source string in which the signature should be detected.
# * @param sourceLength      Length of the input string, or -1 if terminated with a NUL byte.
# * @param signatureLength   A pointer to int32_t to receive the number of bytes that make up the signature
# *                          of the detected UTF. 0 if not detected.
# *                          Can be a NULL pointer.
# * @param pErrorCode        ICU error code in/out parameter.
# *                          Must fulfill U_SUCCESS before the function call.
# * @return The name of the encoding detected. NULL if encoding is not detected.
# * @stable ICU 2.4
# */
#U_STABLE const char* U_EXPORT2
#ucnv_detectUnicodeSignature(const char* source,
sub ucnv_detectUnicodeSignature_57(Str                           $source # const char*
                                  ,int32_t                       $sourceLength # Typedef<int32_t>->«int»
                                  ,Pointer[int32_t]              $signatureLength # Typedef<int32_t>->«int»*
                                  ,Pointer[int32]                $pErrorCode # Typedef<UErrorCode>->«UErrorCode»*
                                   ) is native(LIB) returns Str is export { * }

#-From /usr/include/unicode/ucnv.h:1999
#/**
# * Returns the number of UChars held in the converter's internal state
# * because more input is needed for completing the conversion. This function is
# * useful for mapping semantics of ICU's converter interface to those of iconv,
# * and this information is not needed for normal conversion.
# * @param cnv       The converter in which the input is held
# * @param status    ICU error code in/out parameter.
# *                  Must fulfill U_SUCCESS before the function call.
# * @return The number of UChars in the state. -1 if an error is encountered.
# * @stable ICU 3.4
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_fromUCountPending(const UConverter* cnv, UErrorCode* status);
sub ucnv_fromUCountPending_57(UConverter                    $cnv # const Typedef<UConverter>->«UConverter»*
                             ,Pointer[int32]                $status # Typedef<UErrorCode>->«UErrorCode»*
                              ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:2013
#/**
# * Returns the number of chars held in the converter's internal state
# * because more input is needed for completing the conversion. This function is
# * useful for mapping semantics of ICU's converter interface to those of iconv,
# * and this information is not needed for normal conversion.
# * @param cnv       The converter in which the input is held as internal state
# * @param status    ICU error code in/out parameter.
# *                  Must fulfill U_SUCCESS before the function call.
# * @return The number of chars in the state. -1 if an error is encountered.
# * @stable ICU 3.4
# */
#U_STABLE int32_t U_EXPORT2
#ucnv_toUCountPending(const UConverter* cnv, UErrorCode* status);
sub ucnv_toUCountPending_57(UConverter                    $cnv # const Typedef<UConverter>->«UConverter»*
                           ,Pointer[int32]                $status # Typedef<UErrorCode>->«UErrorCode»*
                            ) is native(LIB) returns int32_t is export { * }

#-From /usr/include/unicode/ucnv.h:2031
#/**
# * Returns whether or not the charset of the converter has a fixed number of bytes
# * per charset character.
# * An example of this are converters that are of the type UCNV_SBCS or UCNV_DBCS.
# * Another example is UTF-32 which is always 4 bytes per character.
# * A Unicode code point may be represented by more than one UTF-8 or UTF-16 code unit
# * but a UTF-32 converter encodes each code point with 4 bytes.
# * Note: This method is not intended to be used to determine whether the charset has a
# * fixed ratio of bytes to Unicode codes <i>units</i> for any particular Unicode encoding form.
# * FALSE is returned with the UErrorCode if error occurs or cnv is NULL.
# * @param cnv       The converter to be tested
# * @param status    ICU error code in/out paramter
# * @return TRUE if the converter is fixed-width
# * @stable ICU 4.8
# */
#U_STABLE UBool U_EXPORT2
#ucnv_isFixedWidth(UConverter *cnv, UErrorCode *status);
sub ucnv_isFixedWidth_57(UConverter                    $cnv # Typedef<UConverter>->«UConverter»*
                        ,Pointer[int32]                $status # Typedef<UErrorCode>->«UErrorCode»*
                         ) is native(LIB) returns int8_t is export { * }


# == /usr/include/libxml2/libxml/tree.h ==

#-From /usr/include/libxml2/libxml/tree.h:120
#/*
# * A few public routines for xmlBuf. As those are expected to be used
# * mostly internally the bulk of the routines are internal in buf.h
# */
#XMLPUBFUN xmlChar* XMLCALL       xmlBufContent	(const xmlBuf* buf);
sub xmlBufContent(_xmlBuf $buf # const Typedef<xmlBuf>->«_xmlBuf»*
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:121
#XMLPUBFUN xmlChar* XMLCALL       xmlBufEnd      (xmlBufPtr buf);
sub xmlBufEnd(_xmlBuf $buf # Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*»
              ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:122
#XMLPUBFUN size_t XMLCALL         xmlBufUse      (const xmlBufPtr buf);
sub xmlBufUse(_xmlBuf $buf # const Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*»
              ) is native(LIB) returns size_t is export { * }

#-From /usr/include/libxml2/libxml/tree.h:123
#XMLPUBFUN size_t XMLCALL         xmlBufShrink	(xmlBufPtr buf, size_t len);
sub xmlBufShrink(_xmlBuf                       $buf # Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*»
                ,size_t                        $len # Typedef<size_t>->«long unsigned int»
                 ) is native(LIB) returns size_t is export { * }

#-From /usr/include/libxml2/libxml/tree.h:664
#/*
# * Some helper functions
# */
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XPATH_ENABLED) || \
#    defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_DEBUG_ENABLED) || \
#    defined (LIBXML_HTML_ENABLED) || defined(LIBXML_SAX1_ENABLED) || \
#    defined(LIBXML_HTML_ENABLED) || defined(LIBXML_WRITER_ENABLED) || \
#    defined(LIBXML_DOCB_ENABLED) || defined(LIBXML_LEGACY_ENABLED)
#XMLPUBFUN int XMLCALL
#		xmlValidateNCName	(const xmlChar *value,
sub xmlValidateNCName(Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                     ,int32                         $space # int
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:670
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#XMLPUBFUN int XMLCALL
#		xmlValidateQName	(const xmlChar *value,
sub xmlValidateQName(Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                    ,int32                         $space # int
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:673
#XMLPUBFUN int XMLCALL
#		xmlValidateName		(const xmlChar *value,
sub xmlValidateName(Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                   ,int32                         $space # int
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:676
#XMLPUBFUN int XMLCALL
#		xmlValidateNMToken	(const xmlChar *value,
sub xmlValidateNMToken(Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                      ,int32                         $space # int
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:681
#XMLPUBFUN xmlChar * XMLCALL
#		xmlBuildQName		(const xmlChar *ncname,
sub xmlBuildQName(Pointer[xmlChar]              $ncname # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $memory # Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $len # int
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:686
#XMLPUBFUN xmlChar * XMLCALL
#		xmlSplitQName2		(const xmlChar *name,
sub xmlSplitQName2(Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[Pointer[xmlChar]]     $prefix # Typedef<xmlChar>->«unsigned char»**
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:689
#XMLPUBFUN const xmlChar * XMLCALL
#		xmlSplitQName3		(const xmlChar *name,
sub xmlSplitQName3(Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[int32]                $len # int*
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:697
#XMLPUBFUN void XMLCALL
#		xmlSetBufferAllocationScheme(xmlBufferAllocationScheme scheme);
sub xmlSetBufferAllocationScheme(int32 $scheme # Typedef<xmlBufferAllocationScheme>->«xmlBufferAllocationScheme»
                                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:699
#XMLPUBFUN xmlBufferAllocationScheme XMLCALL
#		xmlGetBufferAllocationScheme(void);
sub xmlGetBufferAllocationScheme(
                                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:702
#XMLPUBFUN xmlBufferPtr XMLCALL
#		xmlBufferCreate		(void);
sub xmlBufferCreate(
                    ) is native(LIB) returns _xmlBuffer is export { * }

#-From /usr/include/libxml2/libxml/tree.h:704
#XMLPUBFUN xmlBufferPtr XMLCALL
#		xmlBufferCreateSize	(size_t size);
sub xmlBufferCreateSize(size_t $size # Typedef<size_t>->«long unsigned int»
                        ) is native(LIB) returns _xmlBuffer is export { * }

#-From /usr/include/libxml2/libxml/tree.h:706
#XMLPUBFUN xmlBufferPtr XMLCALL
#		xmlBufferCreateStatic	(void *mem,
sub xmlBufferCreateStatic(Pointer                       $mem # void*
                         ,size_t                        $size # Typedef<size_t>->«long unsigned int»
                          ) is native(LIB) returns _xmlBuffer is export { * }

#-From /usr/include/libxml2/libxml/tree.h:709
#XMLPUBFUN int XMLCALL
#		xmlBufferResize		(xmlBufferPtr buf,
sub xmlBufferResize(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                   ,uint32                        $size # unsigned int
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:712
#XMLPUBFUN void XMLCALL
#		xmlBufferFree		(xmlBufferPtr buf);
sub xmlBufferFree(_xmlBuffer $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:714
#XMLPUBFUN int XMLCALL
#		xmlBufferDump		(FILE *file,
sub xmlBufferDump(_IO_FILE                      $file # Typedef<FILE>->«_IO_FILE»*
                 ,_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:717
#XMLPUBFUN int XMLCALL
#		xmlBufferAdd		(xmlBufferPtr buf,
sub xmlBufferAdd(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                ,Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
                ,int32                         $len # int
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:721
#XMLPUBFUN int XMLCALL
#		xmlBufferAddHead	(xmlBufferPtr buf,
sub xmlBufferAddHead(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                    ,Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
                    ,int32                         $len # int
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:725
#XMLPUBFUN int XMLCALL
#		xmlBufferCat		(xmlBufferPtr buf,
sub xmlBufferCat(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                ,Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:728
#XMLPUBFUN int XMLCALL
#		xmlBufferCCat		(xmlBufferPtr buf,
sub xmlBufferCCat(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                 ,Str                           $str # const char*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:731
#XMLPUBFUN int XMLCALL
#		xmlBufferShrink		(xmlBufferPtr buf,
sub xmlBufferShrink(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                   ,uint32                        $len # unsigned int
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:734
#XMLPUBFUN int XMLCALL
#		xmlBufferGrow		(xmlBufferPtr buf,
sub xmlBufferGrow(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                 ,uint32                        $len # unsigned int
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:737
#XMLPUBFUN void XMLCALL
#		xmlBufferEmpty		(xmlBufferPtr buf);
sub xmlBufferEmpty(_xmlBuffer $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:739
#XMLPUBFUN const xmlChar* XMLCALL
#		xmlBufferContent	(const xmlBuffer *buf);
sub xmlBufferContent(_xmlBuffer $buf # const Typedef<xmlBuffer>->«_xmlBuffer»*
                     ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:741
#XMLPUBFUN xmlChar* XMLCALL
#		xmlBufferDetach         (xmlBufferPtr buf);
sub xmlBufferDetach(_xmlBuffer $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                    ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:743
#XMLPUBFUN void XMLCALL
#		xmlBufferSetAllocationScheme(xmlBufferPtr buf,
sub xmlBufferSetAllocationScheme(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                                ,int32                         $scheme # Typedef<xmlBufferAllocationScheme>->«xmlBufferAllocationScheme»
                                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:746
#XMLPUBFUN int XMLCALL
#		xmlBufferLength		(const xmlBuffer *buf);
sub xmlBufferLength(_xmlBuffer $buf # const Typedef<xmlBuffer>->«_xmlBuffer»*
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:752
#/*
# * Creating/freeing new structures.
# */
#XMLPUBFUN xmlDtdPtr XMLCALL
#		xmlCreateIntSubset	(xmlDocPtr doc,
sub xmlCreateIntSubset(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                      ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
                       ) is native(LIB) returns _xmlDtd is export { * }

#-From /usr/include/libxml2/libxml/tree.h:757
#XMLPUBFUN xmlDtdPtr XMLCALL
#		xmlNewDtd		(xmlDocPtr doc,
sub xmlNewDtd(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
             ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
             ,Pointer[xmlChar]              $ExternalID # const Typedef<xmlChar>->«unsigned char»*
             ,Pointer[xmlChar]              $SystemID # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB) returns _xmlDtd is export { * }

#-From /usr/include/libxml2/libxml/tree.h:762
#XMLPUBFUN xmlDtdPtr XMLCALL
#		xmlGetIntSubset		(const xmlDoc *doc);
sub xmlGetIntSubset(_xmlDoc $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                    ) is native(LIB) returns _xmlDtd is export { * }

#-From /usr/include/libxml2/libxml/tree.h:764
#XMLPUBFUN void XMLCALL
#		xmlFreeDtd		(xmlDtdPtr cur);
sub xmlFreeDtd(_xmlDtd $cur # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:767
##ifdef LIBXML_LEGACY_ENABLED
#XMLPUBFUN xmlNsPtr XMLCALL
#		xmlNewGlobalNs		(xmlDocPtr doc,
sub xmlNewGlobalNs(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                  ,Pointer[xmlChar]              $href # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns _xmlNs is export { * }

#-From /usr/include/libxml2/libxml/tree.h:772
##endif /* LIBXML_LEGACY_ENABLED */
#XMLPUBFUN xmlNsPtr XMLCALL
#		xmlNewNs		(xmlNodePtr node,
sub xmlNewNs(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
            ,Pointer[xmlChar]              $href # const Typedef<xmlChar>->«unsigned char»*
            ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
             ) is native(LIB) returns _xmlNs is export { * }

#-From /usr/include/libxml2/libxml/tree.h:776
#XMLPUBFUN void XMLCALL
#		xmlFreeNs		(xmlNsPtr cur);
sub xmlFreeNs(_xmlNs $cur # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:778
#XMLPUBFUN void XMLCALL
#		xmlFreeNsList		(xmlNsPtr cur);
sub xmlFreeNsList(_xmlNs $cur # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:780
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlNewDoc		(const xmlChar *version);
sub xmlNewDoc(Pointer[xmlChar] $version # const Typedef<xmlChar>->«unsigned char»*
              ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/tree.h:782
#XMLPUBFUN void XMLCALL
#		xmlFreeDoc		(xmlDocPtr cur);
sub xmlFreeDoc(_xmlDoc $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:784
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlNewDocProp		(xmlDocPtr doc,
sub xmlNewDocProp(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                 ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:790
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_HTML_ENABLED) || \
#    defined(LIBXML_SCHEMAS_ENABLED)
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlNewProp		(xmlNodePtr node,
sub xmlNewProp(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
              ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
              ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:795
##endif
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlNewNsProp		(xmlNodePtr node,
sub xmlNewNsProp(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:800
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlNewNsPropEatName	(xmlNodePtr node,
sub xmlNewNsPropEatName(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                       ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                       ,Pointer[xmlChar]              $name # Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                        ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:805
#XMLPUBFUN void XMLCALL
#		xmlFreePropList		(xmlAttrPtr cur);
sub xmlFreePropList(_xmlAttr $cur # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:807
#XMLPUBFUN void XMLCALL
#		xmlFreeProp		(xmlAttrPtr cur);
sub xmlFreeProp(_xmlAttr $cur # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:809
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlCopyProp		(xmlNodePtr target,
sub xmlCopyProp(_xmlNode                      $target # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
               ,_xmlAttr                      $cur # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:812
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlCopyPropList		(xmlNodePtr target,
sub xmlCopyPropList(_xmlNode                      $target # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                   ,_xmlAttr                      $cur # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                    ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:816
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN xmlDtdPtr XMLCALL
#		xmlCopyDtd		(xmlDtdPtr dtd);
sub xmlCopyDtd(_xmlDtd $dtd # Typedef<xmlDtdPtr>->«Typedef<xmlDtd>->«_xmlDtd»*»
               ) is native(LIB) returns _xmlDtd is export { * }

#-From /usr/include/libxml2/libxml/tree.h:820
##endif /* LIBXML_TREE_ENABLED */
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#XMLPUBFUN xmlDocPtr XMLCALL
#		xmlCopyDoc		(xmlDocPtr doc,
sub xmlCopyDoc(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
              ,int32                         $recursive # int
               ) is native(LIB) returns _xmlDoc is export { * }

#-From /usr/include/libxml2/libxml/tree.h:827
##endif /* defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED) */
#/*
# * Creating new nodes.
# */
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewDocNode		(xmlDocPtr doc,
sub xmlNewDocNode(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                 ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                 ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                 ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:832
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewDocNodeEatName	(xmlDocPtr doc,
sub xmlNewDocNodeEatName(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                        ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                        ,Pointer[xmlChar]              $name # Typedef<xmlChar>->«unsigned char»*
                        ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                         ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:837
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewNode		(xmlNsPtr ns,
sub xmlNewNode(_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
              ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:840
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewNodeEatName	(xmlNsPtr ns,
sub xmlNewNodeEatName(_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                     ,Pointer[xmlChar]              $name # Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:844
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewChild		(xmlNodePtr parent,
sub xmlNewChild(_xmlNode                      $parent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
               ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
               ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
               ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:850
##endif
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewDocText		(const xmlDoc *doc,
sub xmlNewDocText(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                 ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:853
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewText		(const xmlChar *content);
sub xmlNewText(Pointer[xmlChar] $content # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:855
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewDocPI		(xmlDocPtr doc,
sub xmlNewDocPI(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
               ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
               ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:859
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewPI		(const xmlChar *name,
sub xmlNewPI(Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
            ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
             ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:862
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewDocTextLen	(xmlDocPtr doc,
sub xmlNewDocTextLen(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                    ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                    ,int32                         $len # int
                     ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:866
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewTextLen		(const xmlChar *content,
sub xmlNewTextLen(Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $len # int
                  ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:869
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewDocComment	(xmlDocPtr doc,
sub xmlNewDocComment(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                    ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                     ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:872
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewComment		(const xmlChar *content);
sub xmlNewComment(Pointer[xmlChar] $content # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:874
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewCDataBlock	(xmlDocPtr doc,
sub xmlNewCDataBlock(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                    ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                    ,int32                         $len # int
                     ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:878
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewCharRef		(xmlDocPtr doc,
sub xmlNewCharRef(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                 ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:881
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewReference		(const xmlDoc *doc,
sub xmlNewReference(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:884
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlCopyNode		(xmlNodePtr node,
sub xmlCopyNode(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
               ,int32                         $recursive # int
                ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:887
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlDocCopyNode		(xmlNodePtr node,
sub xmlDocCopyNode(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                  ,int32                         $recursive # int
                   ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:891
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlDocCopyNodeList	(xmlDocPtr doc,
sub xmlDocCopyNodeList(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                      ,_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                       ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:894
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlCopyNodeList		(xmlNodePtr node);
sub xmlCopyNodeList(_xmlNode $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                    ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:897
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewTextChild		(xmlNodePtr parent,
sub xmlNewTextChild(_xmlNode                      $parent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                   ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:902
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewDocRawNode	(xmlDocPtr doc,
sub xmlNewDocRawNode(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                    ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                    ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                    ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                     ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:907
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlNewDocFragment	(xmlDocPtr doc);
sub xmlNewDocFragment(_xmlDoc $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                      ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:914
#/*
# * Navigating.
# */
#XMLPUBFUN long XMLCALL
#		xmlGetLineNo		(const xmlNode *node);
sub xmlGetLineNo(_xmlNode $node # const Typedef<xmlNode>->«_xmlNode»*
                 ) is native(LIB) returns long is export { * }

#-From /usr/include/libxml2/libxml/tree.h:917
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_DEBUG_ENABLED)
#XMLPUBFUN xmlChar * XMLCALL
#		xmlGetNodePath		(const xmlNode *node);
sub xmlGetNodePath(_xmlNode $node # const Typedef<xmlNode>->«_xmlNode»*
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:920
##endif /* defined(LIBXML_TREE_ENABLED) || defined(LIBXML_DEBUG_ENABLED) */
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlDocGetRootElement	(const xmlDoc *doc);
sub xmlDocGetRootElement(_xmlDoc $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                         ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:922
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlGetLastChild		(const xmlNode *parent);
sub xmlGetLastChild(_xmlNode $parent # const Typedef<xmlNode>->«_xmlNode»*
                    ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:924
#XMLPUBFUN int XMLCALL
#		xmlNodeIsText		(const xmlNode *node);
sub xmlNodeIsText(_xmlNode $node # const Typedef<xmlNode>->«_xmlNode»*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:926
#XMLPUBFUN int XMLCALL
#		xmlIsBlankNode		(const xmlNode *node);
sub xmlIsBlankNode(_xmlNode $node # const Typedef<xmlNode>->«_xmlNode»*
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:933
#/*
# * Changing the structure.
# */
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_WRITER_ENABLED)
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlDocSetRootElement	(xmlDocPtr doc,
sub xmlDocSetRootElement(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                        ,_xmlNode                      $root # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                         ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:938
##endif /* defined(LIBXML_TREE_ENABLED) || defined(LIBXML_WRITER_ENABLED) */
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlNodeSetName		(xmlNodePtr cur,
sub xmlNodeSetName(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:942
##endif /* LIBXML_TREE_ENABLED */
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlAddChild		(xmlNodePtr parent,
sub xmlAddChild(_xmlNode                      $parent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
               ,_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:945
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlAddChildList		(xmlNodePtr parent,
sub xmlAddChildList(_xmlNode                      $parent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                   ,_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                    ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:949
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_WRITER_ENABLED)
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlReplaceNode		(xmlNodePtr old,
sub xmlReplaceNode(_xmlNode                      $old # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ,_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                   ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:955
##endif /* defined(LIBXML_TREE_ENABLED) || defined(LIBXML_WRITER_ENABLED) */
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_HTML_ENABLED) || \
#    defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED)
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlAddPrevSibling	(xmlNodePtr cur,
sub xmlAddPrevSibling(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                     ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                      ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:959
##endif /* LIBXML_TREE_ENABLED || LIBXML_HTML_ENABLED || LIBXML_SCHEMAS_ENABLED */
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlAddSibling		(xmlNodePtr cur,
sub xmlAddSibling(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                 ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:962
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlAddNextSibling	(xmlNodePtr cur,
sub xmlAddNextSibling(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                     ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                      ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:965
#XMLPUBFUN void XMLCALL
#		xmlUnlinkNode		(xmlNodePtr cur);
sub xmlUnlinkNode(_xmlNode $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:967
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlTextMerge		(xmlNodePtr first,
sub xmlTextMerge(_xmlNode                      $first # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                ,_xmlNode                      $second # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                 ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:970
#XMLPUBFUN int XMLCALL
#		xmlTextConcat		(xmlNodePtr node,
sub xmlTextConcat(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                 ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $len # int
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:974
#XMLPUBFUN void XMLCALL
#		xmlFreeNodeList		(xmlNodePtr cur);
sub xmlFreeNodeList(_xmlNode $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:976
#XMLPUBFUN void XMLCALL
#		xmlFreeNode		(xmlNodePtr cur);
sub xmlFreeNode(_xmlNode $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:978
#XMLPUBFUN void XMLCALL
#		xmlSetTreeDoc		(xmlNodePtr tree,
sub xmlSetTreeDoc(_xmlNode                      $tree # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                 ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:981
#XMLPUBFUN void XMLCALL
#		xmlSetListDoc		(xmlNodePtr list,
sub xmlSetListDoc(_xmlNode                      $list # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                 ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:987
#/*
# * Namespaces.
# */
#XMLPUBFUN xmlNsPtr XMLCALL
#		xmlSearchNs		(xmlDocPtr doc,
sub xmlSearchNs(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
               ,_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
               ,Pointer[xmlChar]              $nameSpace # const Typedef<xmlChar>->«unsigned char»*
                ) is native(LIB) returns _xmlNs is export { * }

#-From /usr/include/libxml2/libxml/tree.h:991
#XMLPUBFUN xmlNsPtr XMLCALL
#		xmlSearchNsByHref	(xmlDocPtr doc,
sub xmlSearchNsByHref(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                     ,_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                     ,Pointer[xmlChar]              $href # const Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB) returns _xmlNs is export { * }

#-From /usr/include/libxml2/libxml/tree.h:997
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XPATH_ENABLED) || \
#    defined(LIBXML_SCHEMAS_ENABLED)
#XMLPUBFUN xmlNsPtr * XMLCALL
#		xmlGetNsList		(const xmlDoc *doc,
sub xmlGetNsList(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                ,_xmlNode                      $node # const Typedef<xmlNode>->«_xmlNode»*
                 ) is native(LIB) returns Pointer[_xmlNs] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1002
#XMLPUBFUN void XMLCALL
#		xmlSetNs		(xmlNodePtr node,
sub xmlSetNs(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
            ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
             ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1005
#XMLPUBFUN xmlNsPtr XMLCALL
#		xmlCopyNamespace	(xmlNsPtr cur);
sub xmlCopyNamespace(_xmlNs $cur # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                     ) is native(LIB) returns _xmlNs is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1007
#XMLPUBFUN xmlNsPtr XMLCALL
#		xmlCopyNamespaceList	(xmlNsPtr cur);
sub xmlCopyNamespaceList(_xmlNs $cur # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                         ) is native(LIB) returns _xmlNs is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1015
#/*
# * Changing the content.
# */
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED) || \
#    defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_HTML_ENABLED)
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlSetProp		(xmlNodePtr node,
sub xmlSetProp(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
              ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
              ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1019
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlSetNsProp		(xmlNodePtr node,
sub xmlSetNsProp(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1026
##endif /* defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED) || \
#	  defined(LIBXML_SCHEMAS_ENABLED) || defined(LIBXML_HTML_ENABLED) */
#XMLPUBFUN xmlChar * XMLCALL
#		xmlGetNoNsProp		(const xmlNode *node,
sub xmlGetNoNsProp(_xmlNode                      $node # const Typedef<xmlNode>->«_xmlNode»*
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1029
#XMLPUBFUN xmlChar * XMLCALL
#		xmlGetProp		(const xmlNode *node,
sub xmlGetProp(_xmlNode                      $node # const Typedef<xmlNode>->«_xmlNode»*
              ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1032
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlHasProp		(const xmlNode *node,
sub xmlHasProp(_xmlNode                      $node # const Typedef<xmlNode>->«_xmlNode»*
              ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1035
#XMLPUBFUN xmlAttrPtr XMLCALL
#		xmlHasNsProp		(const xmlNode *node,
sub xmlHasNsProp(_xmlNode                      $node # const Typedef<xmlNode>->«_xmlNode»*
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $nameSpace # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB) returns _xmlAttr is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1039
#XMLPUBFUN xmlChar * XMLCALL
#		xmlGetNsProp		(const xmlNode *node,
sub xmlGetNsProp(_xmlNode                      $node # const Typedef<xmlNode>->«_xmlNode»*
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $nameSpace # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1043
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlStringGetNodeList	(const xmlDoc *doc,
sub xmlStringGetNodeList(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                        ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                         ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1046
#XMLPUBFUN xmlNodePtr XMLCALL
#		xmlStringLenGetNodeList	(const xmlDoc *doc,
sub xmlStringLenGetNodeList(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                           ,Pointer[xmlChar]              $value # const Typedef<xmlChar>->«unsigned char»*
                           ,int32                         $len # int
                            ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1050
#XMLPUBFUN xmlChar * XMLCALL
#		xmlNodeListGetString	(xmlDocPtr doc,
sub xmlNodeListGetString(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                        ,_xmlNode                      $list # const Typedef<xmlNode>->«_xmlNode»*
                        ,int32                         $inLine # int
                         ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1055
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN xmlChar * XMLCALL
#		xmlNodeListGetRawString	(const xmlDoc *doc,
sub xmlNodeListGetRawString(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                           ,_xmlNode                      $list # const Typedef<xmlNode>->«_xmlNode»*
                           ,int32                         $inLine # int
                            ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1060
##endif /* LIBXML_TREE_ENABLED */
#XMLPUBFUN void XMLCALL
#		xmlNodeSetContent	(xmlNodePtr cur,
sub xmlNodeSetContent(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                     ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1064
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlNodeSetContentLen	(xmlNodePtr cur,
sub xmlNodeSetContentLen(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                        ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                        ,int32                         $len # int
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1069
##endif /* LIBXML_TREE_ENABLED */
#XMLPUBFUN void XMLCALL
#		xmlNodeAddContent	(xmlNodePtr cur,
sub xmlNodeAddContent(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                     ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1072
#XMLPUBFUN void XMLCALL
#		xmlNodeAddContentLen	(xmlNodePtr cur,
sub xmlNodeAddContentLen(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                        ,Pointer[xmlChar]              $content # const Typedef<xmlChar>->«unsigned char»*
                        ,int32                         $len # int
                         ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1076
#XMLPUBFUN xmlChar * XMLCALL
#		xmlNodeGetContent	(const xmlNode *cur);
sub xmlNodeGetContent(_xmlNode $cur # const Typedef<xmlNode>->«_xmlNode»*
                      ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1079
#XMLPUBFUN int XMLCALL
#		xmlNodeBufGetContent	(xmlBufferPtr buffer,
sub xmlNodeBufGetContent(_xmlBuffer                    $buffer # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                        ,_xmlNode                      $cur # const Typedef<xmlNode>->«_xmlNode»*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1082
#XMLPUBFUN int XMLCALL
#		xmlBufGetNodeContent	(xmlBufPtr buf,
sub xmlBufGetNodeContent(_xmlBuf                       $buf # Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*»
                        ,_xmlNode                      $cur # const Typedef<xmlNode>->«_xmlNode»*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1086
#XMLPUBFUN xmlChar * XMLCALL
#		xmlNodeGetLang		(const xmlNode *cur);
sub xmlNodeGetLang(_xmlNode $cur # const Typedef<xmlNode>->«_xmlNode»*
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1088
#XMLPUBFUN int XMLCALL
#		xmlNodeGetSpacePreserve	(const xmlNode *cur);
sub xmlNodeGetSpacePreserve(_xmlNode $cur # const Typedef<xmlNode>->«_xmlNode»*
                            ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1091
##ifdef LIBXML_TREE_ENABLED
#XMLPUBFUN void XMLCALL
#		xmlNodeSetLang		(xmlNodePtr cur,
sub xmlNodeSetLang(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ,Pointer[xmlChar]              $lang # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1094
#XMLPUBFUN void XMLCALL
#		xmlNodeSetSpacePreserve (xmlNodePtr cur,
sub xmlNodeSetSpacePreserve(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                           ,int32                         $val # int
                            ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1098
##endif /* LIBXML_TREE_ENABLED */
#XMLPUBFUN xmlChar * XMLCALL
#		xmlNodeGetBase		(const xmlDoc *doc,
sub xmlNodeGetBase(_xmlDoc                       $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                  ,_xmlNode                      $cur # const Typedef<xmlNode>->«_xmlNode»*
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1102
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_XINCLUDE_ENABLED)
#XMLPUBFUN void XMLCALL
#		xmlNodeSetBase		(xmlNodePtr cur,
sub xmlNodeSetBase(_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ,Pointer[xmlChar]              $uri # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1110
#/*
# * Removing content.
# */
#XMLPUBFUN int XMLCALL
#		xmlRemoveProp		(xmlAttrPtr cur);
sub xmlRemoveProp(_xmlAttr $cur # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1113
##if defined(LIBXML_TREE_ENABLED) || defined(LIBXML_SCHEMAS_ENABLED)
#XMLPUBFUN int XMLCALL
#		xmlUnsetNsProp		(xmlNodePtr node,
sub xmlUnsetNsProp(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ,_xmlNs                        $ns # Typedef<xmlNsPtr>->«Typedef<xmlNs>->«_xmlNs»*»
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1117
#XMLPUBFUN int XMLCALL
#		xmlUnsetProp		(xmlNodePtr node,
sub xmlUnsetProp(_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1125
#/*
# * Internal, don't use.
# */
#XMLPUBFUN void XMLCALL
#		xmlBufferWriteCHAR	(xmlBufferPtr buf,
sub xmlBufferWriteCHAR(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                      ,Pointer[xmlChar]              $string # const Typedef<xmlChar>->«unsigned char»*
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1128
#XMLPUBFUN void XMLCALL
#		xmlBufferWriteChar	(xmlBufferPtr buf,
sub xmlBufferWriteChar(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                      ,Str                           $string # const char*
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1131
#XMLPUBFUN void XMLCALL
#		xmlBufferWriteQuotedString(xmlBufferPtr buf,
sub xmlBufferWriteQuotedString(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                              ,Pointer[xmlChar]              $string # const Typedef<xmlChar>->«unsigned char»*
                               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1135
##ifdef LIBXML_OUTPUT_ENABLED
#XMLPUBFUN void xmlAttrSerializeTxtContent(xmlBufferPtr buf,
sub xmlAttrSerializeTxtContent(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                              ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                              ,_xmlAttr                      $attr # Typedef<xmlAttrPtr>->«Typedef<xmlAttr>->«_xmlAttr»*»
                              ,Pointer[xmlChar]              $string # const Typedef<xmlChar>->«unsigned char»*
                               ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1146
##ifdef LIBXML_TREE_ENABLED
#/*
# * Namespace handling.
# */
#XMLPUBFUN int XMLCALL
#		xmlReconciliateNs	(xmlDocPtr doc,
sub xmlReconciliateNs(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                     ,_xmlNode                      $tree # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1155
##ifdef LIBXML_OUTPUT_ENABLED
#/*
# * Saving.
# */
#XMLPUBFUN void XMLCALL
#		xmlDocDumpFormatMemory	(xmlDocPtr cur,
sub xmlDocDumpFormatMemory(_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                          ,Pointer[Pointer[xmlChar]]     $mem # Typedef<xmlChar>->«unsigned char»**
                          ,Pointer[int32]                $size # int*
                          ,int32                         $format # int
                           ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1160
#XMLPUBFUN void XMLCALL
#		xmlDocDumpMemory	(xmlDocPtr cur,
sub xmlDocDumpMemory(_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                    ,Pointer[Pointer[xmlChar]]     $mem # Typedef<xmlChar>->«unsigned char»**
                    ,Pointer[int32]                $size # int*
                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1164
#XMLPUBFUN void XMLCALL
#		xmlDocDumpMemoryEnc	(xmlDocPtr out_doc,
sub xmlDocDumpMemoryEnc(_xmlDoc                       $out_doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                       ,Pointer[Pointer[xmlChar]]     $doc_txt_ptr # Typedef<xmlChar>->«unsigned char»**
                       ,Pointer[int32]                $doc_txt_len # int*
                       ,Str                           $txt_encoding # const char*
                        ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1169
#XMLPUBFUN void XMLCALL
#		xmlDocDumpFormatMemoryEnc(xmlDocPtr out_doc,
sub xmlDocDumpFormatMemoryEnc(_xmlDoc                       $out_doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                             ,Pointer[Pointer[xmlChar]]     $doc_txt_ptr # Typedef<xmlChar>->«unsigned char»**
                             ,Pointer[int32]                $doc_txt_len # int*
                             ,Str                           $txt_encoding # const char*
                             ,int32                         $format # int
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1175
#XMLPUBFUN int XMLCALL
#		xmlDocFormatDump	(FILE *f,
sub xmlDocFormatDump(_IO_FILE                      $f # Typedef<FILE>->«_IO_FILE»*
                    ,_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                    ,int32                         $format # int
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1179
#XMLPUBFUN int XMLCALL
#		xmlDocDump		(FILE *f,
sub xmlDocDump(_IO_FILE                      $f # Typedef<FILE>->«_IO_FILE»*
              ,_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1182
#XMLPUBFUN void XMLCALL
#		xmlElemDump		(FILE *f,
sub xmlElemDump(_IO_FILE                      $f # Typedef<FILE>->«_IO_FILE»*
               ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
               ,_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1186
#XMLPUBFUN int XMLCALL
#		xmlSaveFile		(const char *filename,
sub xmlSaveFile(Str                           $filename # const char*
               ,_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1189
#XMLPUBFUN int XMLCALL
#		xmlSaveFormatFile	(const char *filename,
sub xmlSaveFormatFile(Str                           $filename # const char*
                     ,_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                     ,int32                         $format # int
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1193
#XMLPUBFUN size_t XMLCALL
#		xmlBufNodeDump		(xmlBufPtr buf,
sub xmlBufNodeDump(_xmlBuf                       $buf # Typedef<xmlBufPtr>->«Typedef<xmlBuf>->«_xmlBuf»*»
                  ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                  ,_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                  ,int32                         $level # int
                  ,int32                         $format # int
                   ) is native(LIB) returns size_t is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1199
#XMLPUBFUN int XMLCALL
#		xmlNodeDump		(xmlBufferPtr buf,
sub xmlNodeDump(_xmlBuffer                    $buf # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
               ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
               ,_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
               ,int32                         $level # int
               ,int32                         $format # int
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1206
#XMLPUBFUN int XMLCALL
#		xmlSaveFileTo		(xmlOutputBufferPtr buf,
sub xmlSaveFileTo(_xmlOutputBuffer              $buf # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                 ,_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                 ,Str                           $encoding # const char*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1210
#XMLPUBFUN int XMLCALL
#		xmlSaveFormatFileTo     (xmlOutputBufferPtr buf,
sub xmlSaveFormatFileTo(_xmlOutputBuffer              $buf # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                       ,_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                       ,Str                           $encoding # const char*
                       ,int32                         $format # int
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1215
#XMLPUBFUN void XMLCALL
#		xmlNodeDumpOutput	(xmlOutputBufferPtr buf,
sub xmlNodeDumpOutput(_xmlOutputBuffer              $buf # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                     ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                     ,_xmlNode                      $cur # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                     ,int32                         $level # int
                     ,int32                         $format # int
                     ,Str                           $encoding # const char*
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1223
#XMLPUBFUN int XMLCALL
#		xmlSaveFormatFileEnc    (const char *filename,
sub xmlSaveFormatFileEnc(Str                           $filename # const char*
                        ,_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                        ,Str                           $encoding # const char*
                        ,int32                         $format # int
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1229
#XMLPUBFUN int XMLCALL
#		xmlSaveFileEnc		(const char *filename,
sub xmlSaveFileEnc(Str                           $filename # const char*
                  ,_xmlDoc                       $cur # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                  ,Str                           $encoding # const char*
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1238
##endif /* LIBXML_OUTPUT_ENABLED */
#/*
# * XHTML
# */
#XMLPUBFUN int XMLCALL
#		xmlIsXHTML		(const xmlChar *systemID,
sub xmlIsXHTML(Pointer[xmlChar]              $systemID # const Typedef<xmlChar>->«unsigned char»*
              ,Pointer[xmlChar]              $publicID # const Typedef<xmlChar>->«unsigned char»*
               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1245
#/*
# * Compression.
# */
#XMLPUBFUN int XMLCALL
#		xmlGetDocCompressMode	(const xmlDoc *doc);
sub xmlGetDocCompressMode(_xmlDoc $doc # const Typedef<xmlDoc>->«_xmlDoc»*
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1247
#XMLPUBFUN void XMLCALL
#		xmlSetDocCompressMode	(xmlDocPtr doc,
sub xmlSetDocCompressMode(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                         ,int32                         $mode # int
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1250
#XMLPUBFUN int XMLCALL
#		xmlGetCompressMode	(void);
sub xmlGetCompressMode(
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1252
#XMLPUBFUN void XMLCALL
#		xmlSetCompressMode	(int mode);
sub xmlSetCompressMode(int32 $mode # int
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1258
#/*
#* DOM-wrapper helper functions.
#*/
#XMLPUBFUN xmlDOMWrapCtxtPtr XMLCALL
#		xmlDOMWrapNewCtxt	(void);
sub xmlDOMWrapNewCtxt(
                      ) is native(LIB) returns _xmlDOMWrapCtxt is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1260
#XMLPUBFUN void XMLCALL
#		xmlDOMWrapFreeCtxt	(xmlDOMWrapCtxtPtr ctxt);
sub xmlDOMWrapFreeCtxt(_xmlDOMWrapCtxt $ctxt # Typedef<xmlDOMWrapCtxtPtr>->«Typedef<xmlDOMWrapCtxt>->«_xmlDOMWrapCtxt»*»
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1262
#XMLPUBFUN int XMLCALL
#	    xmlDOMWrapReconcileNamespaces(xmlDOMWrapCtxtPtr ctxt,
sub xmlDOMWrapReconcileNamespaces(_xmlDOMWrapCtxt               $ctxt # Typedef<xmlDOMWrapCtxtPtr>->«Typedef<xmlDOMWrapCtxt>->«_xmlDOMWrapCtxt»*»
                                 ,_xmlNode                      $elem # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                                 ,int32                         $options # int
                                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1266
#XMLPUBFUN int XMLCALL
#	    xmlDOMWrapAdoptNode		(xmlDOMWrapCtxtPtr ctxt,
sub xmlDOMWrapAdoptNode(_xmlDOMWrapCtxt               $ctxt # Typedef<xmlDOMWrapCtxtPtr>->«Typedef<xmlDOMWrapCtxt>->«_xmlDOMWrapCtxt»*»
                       ,_xmlDoc                       $sourceDoc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                       ,_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                       ,_xmlDoc                       $destDoc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                       ,_xmlNode                      $destParent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                       ,int32                         $options # int
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1273
#XMLPUBFUN int XMLCALL
#	    xmlDOMWrapRemoveNode	(xmlDOMWrapCtxtPtr ctxt,
sub xmlDOMWrapRemoveNode(_xmlDOMWrapCtxt               $ctxt # Typedef<xmlDOMWrapCtxtPtr>->«Typedef<xmlDOMWrapCtxt>->«_xmlDOMWrapCtxt»*»
                        ,_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                        ,_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                        ,int32                         $options # int
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1278
#XMLPUBFUN int XMLCALL
#	    xmlDOMWrapCloneNode		(xmlDOMWrapCtxtPtr ctxt,
sub xmlDOMWrapCloneNode(_xmlDOMWrapCtxt               $ctxt # Typedef<xmlDOMWrapCtxtPtr>->«Typedef<xmlDOMWrapCtxt>->«_xmlDOMWrapCtxt»*»
                       ,_xmlDoc                       $sourceDoc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                       ,_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                       ,Pointer[_xmlNode]             $clonedNode # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»*
                       ,_xmlDoc                       $destDoc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
                       ,_xmlNode                      $destParent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                       ,int32                         $deep # int
                       ,int32                         $options # int
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1293
##ifdef LIBXML_TREE_ENABLED
#/*
# * 5 interfaces from DOM ElementTraversal, but different in entities
# * traversal.
# */
#XMLPUBFUN unsigned long XMLCALL
#            xmlChildElementCount        (xmlNodePtr parent);
sub xmlChildElementCount(_xmlNode $parent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                         ) is native(LIB) returns ulong is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1295
#XMLPUBFUN xmlNodePtr XMLCALL
#            xmlNextElementSibling       (xmlNodePtr node);
sub xmlNextElementSibling(_xmlNode $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                          ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1297
#XMLPUBFUN xmlNodePtr XMLCALL
#            xmlFirstElementChild        (xmlNodePtr parent);
sub xmlFirstElementChild(_xmlNode $parent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                         ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1299
#XMLPUBFUN xmlNodePtr XMLCALL
#            xmlLastElementChild         (xmlNodePtr parent);
sub xmlLastElementChild(_xmlNode $parent # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                        ) is native(LIB) returns _xmlNode is export { * }

#-From /usr/include/libxml2/libxml/tree.h:1301
#XMLPUBFUN xmlNodePtr XMLCALL
#            xmlPreviousElementSibling   (xmlNodePtr node);
sub xmlPreviousElementSibling(_xmlNode $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                              ) is native(LIB) returns _xmlNode is export { * }


# == /usr/include/libxml2/libxml/xlink.h ==

#-From /usr/include/libxml2/libxml/xlink.h:164
#XMLPUBFUN xlinkNodeDetectFunc XMLCALL
#		xlinkGetDefaultDetect	(void);
sub xlinkGetDefaultDetect(
                          ) is native(LIB) returns () is export { * }

#-From /usr/include/libxml2/libxml/xlink.h:166
#XMLPUBFUN void XMLCALL
#		xlinkSetDefaultDetect	(xlinkNodeDetectFunc func);
sub xlinkSetDefaultDetect(&func () # Typedef<xlinkNodeDetectFunc>->«F:void ( )*»
                          ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xlink.h:172
#/*
# * Routines to set/get the default handlers.
# */
#XMLPUBFUN xlinkHandlerPtr XMLCALL
#		xlinkGetDefaultHandler	(void);
sub xlinkGetDefaultHandler(
                           ) is native(LIB) returns _xlinkHandler is export { * }

#-From /usr/include/libxml2/libxml/xlink.h:174
#XMLPUBFUN void XMLCALL
#		xlinkSetDefaultHandler	(xlinkHandlerPtr handler);
sub xlinkSetDefaultHandler(_xlinkHandler $handler # Typedef<xlinkHandlerPtr>->«Typedef<xlinkHandler>->«_xlinkHandler»*»
                           ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xlink.h:180
#/*
# * Link detection module itself.
# */
#XMLPUBFUN xlinkType XMLCALL
#		xlinkIsLink		(xmlDocPtr doc,
sub xlinkIsLink(_xmlDoc                       $doc # Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»
               ,_xmlNode                      $node # Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»
                ) is native(LIB) returns int32 is export { * }


# == /usr/include/libxml2/libxml/dict.h ==

#-From /usr/include/libxml2/libxml/dict.h:37
#/*
# * Initializer
# */
#XMLPUBFUN int XMLCALL  xmlInitializeDict(void);
sub xmlInitializeDict(
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/dict.h:43
#/*
# * Constructor and destructor.
# */
#XMLPUBFUN xmlDictPtr XMLCALL
#			xmlDictCreate	(void);
sub xmlDictCreate(
                  ) is native(LIB) returns _xmlDict is export { * }

#-From /usr/include/libxml2/libxml/dict.h:45
#XMLPUBFUN size_t XMLCALL
#			xmlDictSetLimit	(xmlDictPtr dict,
sub xmlDictSetLimit(_xmlDict                      $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                   ,size_t                        $limit # Typedef<size_t>->«long unsigned int»
                    ) is native(LIB) returns size_t is export { * }

#-From /usr/include/libxml2/libxml/dict.h:48
#XMLPUBFUN size_t XMLCALL
#			xmlDictGetUsage (xmlDictPtr dict);
sub xmlDictGetUsage(_xmlDict $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                    ) is native(LIB) returns size_t is export { * }

#-From /usr/include/libxml2/libxml/dict.h:50
#XMLPUBFUN xmlDictPtr XMLCALL
#			xmlDictCreateSub(xmlDictPtr sub);
sub xmlDictCreateSub(_xmlDict $sub # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                     ) is native(LIB) returns _xmlDict is export { * }

#-From /usr/include/libxml2/libxml/dict.h:52
#XMLPUBFUN int XMLCALL
#			xmlDictReference(xmlDictPtr dict);
sub xmlDictReference(_xmlDict $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/dict.h:54
#XMLPUBFUN void XMLCALL
#			xmlDictFree	(xmlDictPtr dict);
sub xmlDictFree(_xmlDict $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/dict.h:60
#/*
# * Lookup of entry in the dictionary.
# */
#XMLPUBFUN const xmlChar * XMLCALL
#			xmlDictLookup	(xmlDictPtr dict,
sub xmlDictLookup(_xmlDict                      $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                 ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $len # int
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/dict.h:64
#XMLPUBFUN const xmlChar * XMLCALL
#			xmlDictExists	(xmlDictPtr dict,
sub xmlDictExists(_xmlDict                      $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                 ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                 ,int32                         $len # int
                  ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/dict.h:68
#XMLPUBFUN const xmlChar * XMLCALL
#			xmlDictQLookup	(xmlDictPtr dict,
sub xmlDictQLookup(_xmlDict                      $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                  ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/dict.h:72
#XMLPUBFUN int XMLCALL
#			xmlDictOwns	(xmlDictPtr dict,
sub xmlDictOwns(_xmlDict                      $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
               ,Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/dict.h:75
#XMLPUBFUN int XMLCALL
#			xmlDictSize	(xmlDictPtr dict);
sub xmlDictSize(_xmlDict $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/dict.h:81
#/*
# * Cleanup function
# */
#XMLPUBFUN void XMLCALL
#                        xmlDictCleanup  (void);
sub xmlDictCleanup(
                   ) is native(LIB)  is export { * }


# == /usr/include/libxml2/libxml/xmlIO.h ==

#-From /usr/include/libxml2/libxml/xmlIO.h:159
#/*
# * Interfaces for input
# */
#XMLPUBFUN void XMLCALL
#	xmlCleanupInputCallbacks		(void);
sub xmlCleanupInputCallbacks(
                             ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:162
#XMLPUBFUN int XMLCALL
#	xmlPopInputCallbacks			(void);
sub xmlPopInputCallbacks(
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:165
#XMLPUBFUN void XMLCALL
#	xmlRegisterDefaultInputCallbacks	(void);
sub xmlRegisterDefaultInputCallbacks(
                                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:167
#XMLPUBFUN xmlParserInputBufferPtr XMLCALL
#	xmlAllocParserInputBuffer		(xmlCharEncoding enc);
sub xmlAllocParserInputBuffer(int32 $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                              ) is native(LIB) returns _xmlParserInputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:170
#XMLPUBFUN xmlParserInputBufferPtr XMLCALL
#	xmlParserInputBufferCreateFilename	(const char *URI,
sub xmlParserInputBufferCreateFilename(Str                           $URI # const char*
                                      ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                                       ) is native(LIB) returns _xmlParserInputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:173
#XMLPUBFUN xmlParserInputBufferPtr XMLCALL
#	xmlParserInputBufferCreateFile		(FILE *file,
sub xmlParserInputBufferCreateFile(_IO_FILE                      $file # Typedef<FILE>->«_IO_FILE»*
                                  ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                                   ) is native(LIB) returns _xmlParserInputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:176
#XMLPUBFUN xmlParserInputBufferPtr XMLCALL
#	xmlParserInputBufferCreateFd		(int fd,
sub xmlParserInputBufferCreateFd(int32                         $fd # int
                                ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                                 ) is native(LIB) returns _xmlParserInputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:179
#XMLPUBFUN xmlParserInputBufferPtr XMLCALL
#	xmlParserInputBufferCreateMem		(const char *mem, int size,
sub xmlParserInputBufferCreateMem(Str                           $mem # const char*
                                 ,int32                         $size # int
                                 ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                                  ) is native(LIB) returns _xmlParserInputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:182
#XMLPUBFUN xmlParserInputBufferPtr XMLCALL
#	xmlParserInputBufferCreateStatic	(const char *mem, int size,
sub xmlParserInputBufferCreateStatic(Str                           $mem # const char*
                                    ,int32                         $size # int
                                    ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                                     ) is native(LIB) returns _xmlParserInputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:185
#XMLPUBFUN xmlParserInputBufferPtr XMLCALL
#	xmlParserInputBufferCreateIO		(xmlInputReadCallback   ioread,
sub xmlParserInputBufferCreateIO(&ioread ( --> int32) # Typedef<xmlInputReadCallback>->«F:int ( )*»
                                ,&ioclose ( --> int32) # Typedef<xmlInputCloseCallback>->«F:int ( )*»
                                ,Pointer                       $ioctx # void*
                                ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                                 ) is native(LIB) returns _xmlParserInputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:190
#XMLPUBFUN int XMLCALL
#	xmlParserInputBufferRead		(xmlParserInputBufferPtr in,
sub xmlParserInputBufferRead(_xmlParserInputBuffer         $in # Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*»
                            ,int32                         $len # int
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:193
#XMLPUBFUN int XMLCALL
#	xmlParserInputBufferGrow		(xmlParserInputBufferPtr in,
sub xmlParserInputBufferGrow(_xmlParserInputBuffer         $in # Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*»
                            ,int32                         $len # int
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:196
#XMLPUBFUN int XMLCALL
#	xmlParserInputBufferPush		(xmlParserInputBufferPtr in,
sub xmlParserInputBufferPush(_xmlParserInputBuffer         $in # Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*»
                            ,int32                         $len # int
                            ,Str                           $buf # const char*
                             ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:200
#XMLPUBFUN void XMLCALL
#	xmlFreeParserInputBuffer		(xmlParserInputBufferPtr in);
sub xmlFreeParserInputBuffer(_xmlParserInputBuffer $in # Typedef<xmlParserInputBufferPtr>->«Typedef<xmlParserInputBuffer>->«_xmlParserInputBuffer»*»
                             ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:202
#XMLPUBFUN char * XMLCALL
#	xmlParserGetDirectory			(const char *filename);
sub xmlParserGetDirectory(Str $filename # const char*
                          ) is native(LIB) returns Str is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:205
#XMLPUBFUN int XMLCALL
#	xmlRegisterInputCallbacks		(xmlInputMatchCallback matchFunc,
sub xmlRegisterInputCallbacks(&matchFunc ( --> int32) # Typedef<xmlInputMatchCallback>->«F:int ( )*»
                             ,&openFunc ( --> Pointer) # Typedef<xmlInputOpenCallback>->«F:void* ( )*»
                             ,&readFunc ( --> int32) # Typedef<xmlInputReadCallback>->«F:int ( )*»
                             ,&closeFunc ( --> int32) # Typedef<xmlInputCloseCallback>->«F:int ( )*»
                              ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:219
##ifdef LIBXML_OUTPUT_ENABLED
#/*
# * Interfaces for output
# */
#XMLPUBFUN void XMLCALL
#	xmlCleanupOutputCallbacks		(void);
sub xmlCleanupOutputCallbacks(
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:221
#XMLPUBFUN void XMLCALL
#	xmlRegisterDefaultOutputCallbacks(void);
sub xmlRegisterDefaultOutputCallbacks(
                                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:223
#XMLPUBFUN xmlOutputBufferPtr XMLCALL
#	xmlAllocOutputBuffer		(xmlCharEncodingHandlerPtr encoder);
sub xmlAllocOutputBuffer(_xmlCharEncodingHandler $encoder # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*»
                         ) is native(LIB) returns _xmlOutputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:226
#XMLPUBFUN xmlOutputBufferPtr XMLCALL
#	xmlOutputBufferCreateFilename	(const char *URI,
sub xmlOutputBufferCreateFilename(Str                           $URI # const char*
                                 ,_xmlCharEncodingHandler       $encoder # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*»
                                 ,int32                         $compression # int
                                  ) is native(LIB) returns _xmlOutputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:231
#XMLPUBFUN xmlOutputBufferPtr XMLCALL
#	xmlOutputBufferCreateFile	(FILE *file,
sub xmlOutputBufferCreateFile(_IO_FILE                      $file # Typedef<FILE>->«_IO_FILE»*
                             ,_xmlCharEncodingHandler       $encoder # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*»
                              ) is native(LIB) returns _xmlOutputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:235
#XMLPUBFUN xmlOutputBufferPtr XMLCALL
#	xmlOutputBufferCreateBuffer	(xmlBufferPtr buffer,
sub xmlOutputBufferCreateBuffer(_xmlBuffer                    $buffer # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                               ,_xmlCharEncodingHandler       $encoder # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*»
                                ) is native(LIB) returns _xmlOutputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:239
#XMLPUBFUN xmlOutputBufferPtr XMLCALL
#	xmlOutputBufferCreateFd		(int fd,
sub xmlOutputBufferCreateFd(int32                         $fd # int
                           ,_xmlCharEncodingHandler       $encoder # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*»
                            ) is native(LIB) returns _xmlOutputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:243
#XMLPUBFUN xmlOutputBufferPtr XMLCALL
#	xmlOutputBufferCreateIO		(xmlOutputWriteCallback   iowrite,
sub xmlOutputBufferCreateIO(&iowrite ( --> int32) # Typedef<xmlOutputWriteCallback>->«F:int ( )*»
                           ,&ioclose ( --> int32) # Typedef<xmlOutputCloseCallback>->«F:int ( )*»
                           ,Pointer                       $ioctx # void*
                           ,_xmlCharEncodingHandler       $encoder # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*»
                            ) is native(LIB) returns _xmlOutputBuffer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:250
#/* Couple of APIs to get the output without digging into the buffers */
#XMLPUBFUN const xmlChar * XMLCALL
#        xmlOutputBufferGetContent       (xmlOutputBufferPtr out);
sub xmlOutputBufferGetContent(_xmlOutputBuffer $out # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                              ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:252
#XMLPUBFUN size_t XMLCALL
#        xmlOutputBufferGetSize          (xmlOutputBufferPtr out);
sub xmlOutputBufferGetSize(_xmlOutputBuffer $out # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                           ) is native(LIB) returns size_t is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:255
#XMLPUBFUN int XMLCALL
#	xmlOutputBufferWrite		(xmlOutputBufferPtr out,
sub xmlOutputBufferWrite(_xmlOutputBuffer              $out # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                        ,int32                         $len # int
                        ,Str                           $buf # const char*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:259
#XMLPUBFUN int XMLCALL
#	xmlOutputBufferWriteString	(xmlOutputBufferPtr out,
sub xmlOutputBufferWriteString(_xmlOutputBuffer              $out # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                              ,Str                           $str # const char*
                               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:262
#XMLPUBFUN int XMLCALL
#	xmlOutputBufferWriteEscape	(xmlOutputBufferPtr out,
sub xmlOutputBufferWriteEscape(_xmlOutputBuffer              $out # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                              ,Pointer[xmlChar]              $str # const Typedef<xmlChar>->«unsigned char»*
                              ,&escaping ( --> int32) # Typedef<xmlCharEncodingOutputFunc>->«F:int ( )*»
                               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:267
#XMLPUBFUN int XMLCALL
#	xmlOutputBufferFlush		(xmlOutputBufferPtr out);
sub xmlOutputBufferFlush(_xmlOutputBuffer $out # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:269
#XMLPUBFUN int XMLCALL
#	xmlOutputBufferClose		(xmlOutputBufferPtr out);
sub xmlOutputBufferClose(_xmlOutputBuffer $out # Typedef<xmlOutputBufferPtr>->«Typedef<xmlOutputBuffer>->«_xmlOutputBuffer»*»
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:272
#XMLPUBFUN int XMLCALL
#	xmlRegisterOutputCallbacks	(xmlOutputMatchCallback matchFunc,
sub xmlRegisterOutputCallbacks(&matchFunc ( --> int32) # Typedef<xmlOutputMatchCallback>->«F:int ( )*»
                              ,&openFunc ( --> Pointer) # Typedef<xmlOutputOpenCallback>->«F:void* ( )*»
                              ,&writeFunc ( --> int32) # Typedef<xmlOutputWriteCallback>->«F:int ( )*»
                              ,&closeFunc ( --> int32) # Typedef<xmlOutputCloseCallback>->«F:int ( )*»
                               ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:285
##ifdef LIBXML_HTTP_ENABLED
#/*  This function only exists if HTTP support built into the library  */
#XMLPUBFUN void XMLCALL
#	xmlRegisterHTTPPostCallbacks	(void );
sub xmlRegisterHTTPPostCallbacks(
                                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:291
#XMLPUBFUN xmlParserInputPtr XMLCALL
#	xmlCheckHTTPInput		(xmlParserCtxtPtr ctxt,
sub xmlCheckHTTPInput(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                     ,_xmlParserInput               $ret # Typedef<xmlParserInputPtr>->«Typedef<xmlParserInput>->«_xmlParserInput»*»
                      ) is native(LIB) returns _xmlParserInput is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:298
#/*
# * A predefined entity loader disabling network accesses
# */
#XMLPUBFUN xmlParserInputPtr XMLCALL
#	xmlNoNetExternalEntityLoader	(const char *URL,
sub xmlNoNetExternalEntityLoader(Str                           $URL # const char*
                                ,Str                           $ID # const char*
                                ,_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                                 ) is native(LIB) returns _xmlParserInput is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:307
#/*
# * xmlNormalizeWindowsPath is obsolete, don't use it.
# * Check xmlCanonicPath in uri.h for a better alternative.
# */
#XMLPUBFUN xmlChar * XMLCALL
#	xmlNormalizeWindowsPath		(const xmlChar *path);
sub xmlNormalizeWindowsPath(Pointer[xmlChar] $path # const Typedef<xmlChar>->«unsigned char»*
                            ) is native(LIB) returns Pointer[xmlChar] is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:310
#XMLPUBFUN int XMLCALL
#	xmlCheckFilename		(const char *path);
sub xmlCheckFilename(Str $path # const char*
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:315
#/**
# * Default 'file://' protocol callbacks
# */
#XMLPUBFUN int XMLCALL
#	xmlFileMatch			(const char *filename);
sub xmlFileMatch(Str $filename # const char*
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:317
#XMLPUBFUN void * XMLCALL
#	xmlFileOpen			(const char *filename);
sub xmlFileOpen(Str $filename # const char*
                ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:319
#XMLPUBFUN int XMLCALL
#	xmlFileRead			(void * context,
sub xmlFileRead(Pointer                       $context # void*
               ,Str                           $buffer # char*
               ,int32                         $len # int
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:323
#XMLPUBFUN int XMLCALL
#	xmlFileClose			(void * context);
sub xmlFileClose(Pointer $context # void*
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:330
#/**
# * Default 'http://' protocol callbacks
# */
##ifdef LIBXML_HTTP_ENABLED
#XMLPUBFUN int XMLCALL
#	xmlIOHTTPMatch			(const char *filename);
sub xmlIOHTTPMatch(Str $filename # const char*
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:332
#XMLPUBFUN void * XMLCALL
#	xmlIOHTTPOpen			(const char *filename);
sub xmlIOHTTPOpen(Str $filename # const char*
                  ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:335
##ifdef LIBXML_OUTPUT_ENABLED
#XMLPUBFUN void * XMLCALL
#	xmlIOHTTPOpenW			(const char * post_uri,
sub xmlIOHTTPOpenW(Str                           $post_uri # const char*
                  ,int32                         $compression # int
                   ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:339
##endif /* LIBXML_OUTPUT_ENABLED */
#XMLPUBFUN int XMLCALL
#	xmlIOHTTPRead			(void * context,
sub xmlIOHTTPRead(Pointer                       $context # void*
                 ,Str                           $buffer # char*
                 ,int32                         $len # int
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:343
#XMLPUBFUN int XMLCALL
#	xmlIOHTTPClose			(void * context);
sub xmlIOHTTPClose(Pointer $context # void*
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:351
#/**
# * Default 'ftp://' protocol callbacks
# */
##ifdef LIBXML_FTP_ENABLED
#XMLPUBFUN int XMLCALL
#	xmlIOFTPMatch			(const char *filename);
sub xmlIOFTPMatch(Str $filename # const char*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:353
#XMLPUBFUN void * XMLCALL
#	xmlIOFTPOpen			(const char *filename);
sub xmlIOFTPOpen(Str $filename # const char*
                 ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:355
#XMLPUBFUN int XMLCALL
#	xmlIOFTPRead			(void * context,
sub xmlIOFTPRead(Pointer                       $context # void*
                ,Str                           $buffer # char*
                ,int32                         $len # int
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/xmlIO.h:359
#XMLPUBFUN int XMLCALL
#	xmlIOFTPClose			(void * context);
sub xmlIOFTPClose(Pointer $context # void*
                  ) is native(LIB) returns int32 is export { * }


# == HTMLparser.h ==

#-From HTMLparser.h:87
#/*
# * There is only few public functions.
# */
#XMLPUBFUN const htmlElemDesc * XMLCALL
#			htmlTagLookup	(const xmlChar *tag);
sub htmlTagLookup(Pointer[xmlChar] $tag # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns _htmlElemDesc is export { * }

#-From HTMLparser.h:89
#XMLPUBFUN const htmlEntityDesc * XMLCALL
#			htmlEntityLookup(const xmlChar *name);
sub htmlEntityLookup(Pointer[xmlChar] $name # const Typedef<xmlChar>->«unsigned char»*
                     ) is native(LIB) returns _htmlEntityDesc is export { * }

#-From HTMLparser.h:91
#XMLPUBFUN const htmlEntityDesc * XMLCALL
#			htmlEntityValueLookup(unsigned int value);
sub htmlEntityValueLookup(uint32 $value # unsigned int
                          ) is native(LIB) returns _htmlEntityDesc is export { * }

#-From HTMLparser.h:94
#XMLPUBFUN int XMLCALL
#			htmlIsAutoClosed(htmlDocPtr doc,
sub htmlIsAutoClosed(_xmlDoc                       $doc # Typedef<htmlDocPtr>->«Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»»
                    ,_xmlNode                      $elem # Typedef<htmlNodePtr>->«Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»»
                     ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:97
#XMLPUBFUN int XMLCALL
#			htmlAutoCloseTag(htmlDocPtr doc,
sub htmlAutoCloseTag(_xmlDoc                       $doc # Typedef<htmlDocPtr>->«Typedef<xmlDocPtr>->«Typedef<xmlDoc>->«_xmlDoc»*»»
                    ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                    ,_xmlNode                      $elem # Typedef<htmlNodePtr>->«Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»»
                     ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:101
#XMLPUBFUN const htmlEntityDesc * XMLCALL
#			htmlParseEntityRef(htmlParserCtxtPtr ctxt,
sub htmlParseEntityRef(_xmlParserCtxt                $ctxt # Typedef<htmlParserCtxtPtr>->«Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»»
                      ,Pointer[Pointer[xmlChar]]     $str # const Typedef<xmlChar>->«unsigned char»**
                       ) is native(LIB) returns _htmlEntityDesc is export { * }

#-From HTMLparser.h:104
#XMLPUBFUN int XMLCALL
#			htmlParseCharRef(htmlParserCtxtPtr ctxt);
sub htmlParseCharRef(_xmlParserCtxt $ctxt # Typedef<htmlParserCtxtPtr>->«Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»»
                     ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:106
#XMLPUBFUN void XMLCALL
#			htmlParseElement(htmlParserCtxtPtr ctxt);
sub htmlParseElement(_xmlParserCtxt $ctxt # Typedef<htmlParserCtxtPtr>->«Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»»
                     ) is native(LIB)  is export { * }

#-From HTMLparser.h:109
#XMLPUBFUN htmlParserCtxtPtr XMLCALL
#			htmlNewParserCtxt(void);
sub htmlNewParserCtxt(
                      ) is native(LIB) returns _xmlParserCtxt is export { * }

#-From HTMLparser.h:112
#XMLPUBFUN htmlParserCtxtPtr XMLCALL
#			htmlCreateMemoryParserCtxt(const char *buffer,
sub htmlCreateMemoryParserCtxt(Str                           $buffer # const char*
                              ,int32                         $size # int
                               ) is native(LIB) returns _xmlParserCtxt is export { * }

#-From HTMLparser.h:116
#XMLPUBFUN int XMLCALL
#			htmlParseDocument(htmlParserCtxtPtr ctxt);
sub htmlParseDocument(_xmlParserCtxt $ctxt # Typedef<htmlParserCtxtPtr>->«Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»»
                      ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:118
#XMLPUBFUN htmlDocPtr XMLCALL
#			htmlSAXParseDoc	(xmlChar *cur,
sub htmlSAXParseDoc(Pointer[xmlChar]              $cur # Typedef<xmlChar>->«unsigned char»*
                   ,Str                           $encoding # const char*
                   ,_xmlSAXHandler                $sax # Typedef<htmlSAXHandlerPtr>->«Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»»
                   ,Pointer                       $userData # void*
                    ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:123
#XMLPUBFUN htmlDocPtr XMLCALL
#			htmlParseDoc	(xmlChar *cur,
sub htmlParseDoc(Pointer[xmlChar]              $cur # Typedef<xmlChar>->«unsigned char»*
                ,Str                           $encoding # const char*
                 ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:126
#XMLPUBFUN htmlDocPtr XMLCALL
#			htmlSAXParseFile(const char *filename,
sub htmlSAXParseFile(Str                           $filename # const char*
                    ,Str                           $encoding # const char*
                    ,_xmlSAXHandler                $sax # Typedef<htmlSAXHandlerPtr>->«Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»»
                    ,Pointer                       $userData # void*
                     ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:131
#XMLPUBFUN htmlDocPtr XMLCALL
#			htmlParseFile	(const char *filename,
sub htmlParseFile(Str                           $filename # const char*
                 ,Str                           $encoding # const char*
                  ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:134
#XMLPUBFUN int XMLCALL
#			UTF8ToHtml	(unsigned char *out,
sub UTF8ToHtml(Pointer[uint8]                $out # unsigned char*
              ,Pointer[int32]                $outlen # int*
              ,Pointer[uint8]                $in # const unsigned char*
              ,Pointer[int32]                $inlen # int*
               ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:139
#XMLPUBFUN int XMLCALL
#			htmlEncodeEntities(unsigned char *out,
sub htmlEncodeEntities(Pointer[uint8]                $out # unsigned char*
                      ,Pointer[int32]                $outlen # int*
                      ,Pointer[uint8]                $in # const unsigned char*
                      ,Pointer[int32]                $inlen # int*
                      ,int32                         $quoteChar # int
                       ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:144
#XMLPUBFUN int XMLCALL
#			htmlIsScriptAttribute(const xmlChar *name);
sub htmlIsScriptAttribute(Pointer[xmlChar] $name # const Typedef<xmlChar>->«unsigned char»*
                          ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:146
#XMLPUBFUN int XMLCALL
#			htmlHandleOmittedElem(int val);
sub htmlHandleOmittedElem(int32 $val # int
                          ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:153
##ifdef LIBXML_PUSH_ENABLED
#/**
# * Interfaces for the Push mode.
# */
#XMLPUBFUN htmlParserCtxtPtr XMLCALL
#			htmlCreatePushParserCtxt(htmlSAXHandlerPtr sax,
sub htmlCreatePushParserCtxt(_xmlSAXHandler                $sax # Typedef<htmlSAXHandlerPtr>->«Typedef<xmlSAXHandlerPtr>->«Typedef<xmlSAXHandler>->«_xmlSAXHandler»*»»
                            ,Pointer                       $user_data # void*
                            ,Str                           $chunk # const char*
                            ,int32                         $size # int
                            ,Str                           $filename # const char*
                            ,int32                         $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                             ) is native(LIB) returns _xmlParserCtxt is export { * }

#-From HTMLparser.h:160
#XMLPUBFUN int XMLCALL
#			htmlParseChunk		(htmlParserCtxtPtr ctxt,
sub htmlParseChunk(_xmlParserCtxt                $ctxt # Typedef<htmlParserCtxtPtr>->«Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»»
                  ,Str                           $chunk # const char*
                  ,int32                         $size # int
                  ,int32                         $terminate # int
                   ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:167
#XMLPUBFUN void XMLCALL
#			htmlFreeParserCtxt	(htmlParserCtxtPtr ctxt);
sub htmlFreeParserCtxt(_xmlParserCtxt $ctxt # Typedef<htmlParserCtxtPtr>->«Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»»
                       ) is native(LIB)  is export { * }

#-From HTMLparser.h:192
#XMLPUBFUN void XMLCALL
#		htmlCtxtReset		(htmlParserCtxtPtr ctxt);
sub htmlCtxtReset(_xmlParserCtxt $ctxt # Typedef<htmlParserCtxtPtr>->«Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»»
                  ) is native(LIB)  is export { * }

#-From HTMLparser.h:194
#XMLPUBFUN int XMLCALL
#		htmlCtxtUseOptions	(htmlParserCtxtPtr ctxt,
sub htmlCtxtUseOptions(_xmlParserCtxt                $ctxt # Typedef<htmlParserCtxtPtr>->«Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»»
                      ,int32                         $options # int
                       ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:197
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlReadDoc		(const xmlChar *cur,
sub htmlReadDoc(Pointer[xmlChar]              $cur # const Typedef<xmlChar>->«unsigned char»*
               ,Str                           $URL # const char*
               ,Str                           $encoding # const char*
               ,int32                         $options # int
                ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:202
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlReadFile		(const char *URL,
sub htmlReadFile(Str                           $URL # const char*
                ,Str                           $encoding # const char*
                ,int32                         $options # int
                 ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:206
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlReadMemory		(const char *buffer,
sub htmlReadMemory(Str                           $buffer # const char*
                  ,int32                         $size # int
                  ,Str                           $URL # const char*
                  ,Str                           $encoding # const char*
                  ,int32                         $options # int
                   ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:212
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlReadFd		(int fd,
sub htmlReadFd(int32                         $fd # int
              ,Str                           $URL # const char*
              ,Str                           $encoding # const char*
              ,int32                         $options # int
               ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:217
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlReadIO		(xmlInputReadCallback ioread,
sub htmlReadIO(&ioread ( --> int32) # Typedef<xmlInputReadCallback>->«F:int ( )*»
              ,&ioclose ( --> int32) # Typedef<xmlInputCloseCallback>->«F:int ( )*»
              ,Pointer                       $ioctx # void*
              ,Str                           $URL # const char*
              ,Str                           $encoding # const char*
              ,int32                         $options # int
               ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:224
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlCtxtReadDoc		(xmlParserCtxtPtr ctxt,
sub htmlCtxtReadDoc(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                   ,Pointer[xmlChar]              $cur # const Typedef<xmlChar>->«unsigned char»*
                   ,Str                           $URL # const char*
                   ,Str                           $encoding # const char*
                   ,int32                         $options # int
                    ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:230
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlCtxtReadFile		(xmlParserCtxtPtr ctxt,
sub htmlCtxtReadFile(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                    ,Str                           $filename # const char*
                    ,Str                           $encoding # const char*
                    ,int32                         $options # int
                     ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:235
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlCtxtReadMemory		(xmlParserCtxtPtr ctxt,
sub htmlCtxtReadMemory(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                      ,Str                           $buffer # const char*
                      ,int32                         $size # int
                      ,Str                           $URL # const char*
                      ,Str                           $encoding # const char*
                      ,int32                         $options # int
                       ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:242
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlCtxtReadFd		(xmlParserCtxtPtr ctxt,
sub htmlCtxtReadFd(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                  ,int32                         $fd # int
                  ,Str                           $URL # const char*
                  ,Str                           $encoding # const char*
                  ,int32                         $options # int
                   ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:248
#XMLPUBFUN htmlDocPtr XMLCALL
#		htmlCtxtReadIO		(xmlParserCtxtPtr ctxt,
sub htmlCtxtReadIO(_xmlParserCtxt                $ctxt # Typedef<xmlParserCtxtPtr>->«Typedef<xmlParserCtxt>->«_xmlParserCtxt»*»
                  ,&ioread ( --> int32) # Typedef<xmlInputReadCallback>->«F:int ( )*»
                  ,&ioclose ( --> int32) # Typedef<xmlInputCloseCallback>->«F:int ( )*»
                  ,Pointer                       $ioctx # void*
                  ,Str                           $URL # const char*
                  ,Str                           $encoding # const char*
                  ,int32                         $options # int
                   ) is native(LIB) returns _xmlDoc is export { * }

#-From HTMLparser.h:269
#/* Using htmlElemDesc rather than name here, to emphasise the fact
#   that otherwise there's a lookup overhead
#*/
#XMLPUBFUN htmlStatus XMLCALL htmlAttrAllowed(const htmlElemDesc*, const xmlChar*, int) ;
sub htmlAttrAllowed(_htmlElemDesc                  # const Typedef<htmlElemDesc>->«_htmlElemDesc»*
                   ,Pointer[xmlChar]               # const Typedef<xmlChar>->«unsigned char»*
                   ,int32                          # int
                    ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:270
#XMLPUBFUN int XMLCALL htmlElementAllowedHere(const htmlElemDesc*, const xmlChar*) ;
sub htmlElementAllowedHere(_htmlElemDesc                  # const Typedef<htmlElemDesc>->«_htmlElemDesc»*
                          ,Pointer[xmlChar]               # const Typedef<xmlChar>->«unsigned char»*
                           ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:271
#XMLPUBFUN htmlStatus XMLCALL htmlElementStatusHere(const htmlElemDesc*, const htmlElemDesc*) ;
sub htmlElementStatusHere(_htmlElemDesc                  # const Typedef<htmlElemDesc>->«_htmlElemDesc»*
                         ,_htmlElemDesc                  # const Typedef<htmlElemDesc>->«_htmlElemDesc»*
                          ) is native(LIB) returns int32 is export { * }

#-From HTMLparser.h:272
#XMLPUBFUN htmlStatus XMLCALL htmlNodeStatus(const htmlNodePtr, int) ;
sub htmlNodeStatus(_xmlNode                       # const Typedef<htmlNodePtr>->«Typedef<xmlNodePtr>->«Typedef<xmlNode>->«_xmlNode»*»»
                  ,int32                          # int
                   ) is native(LIB) returns int32 is export { * }


# == /usr/include/libxml2/libxml/list.h ==

#-From /usr/include/libxml2/libxml/list.h:56
#/* Creation/Deletion */
#XMLPUBFUN xmlListPtr XMLCALL
#		xmlListCreate		(xmlListDeallocator deallocator,
sub xmlListCreate(&deallocator () # Typedef<xmlListDeallocator>->«F:void ( )*»
                 ,&compare ( --> int32) # Typedef<xmlListDataCompare>->«F:int ( )*»
                  ) is native(LIB) returns _xmlList is export { * }

#-From /usr/include/libxml2/libxml/list.h:59
#XMLPUBFUN void XMLCALL
#		xmlListDelete		(xmlListPtr l);
sub xmlListDelete(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:63
#/* Basic Operators */
#XMLPUBFUN void * XMLCALL
#		xmlListSearch		(xmlListPtr l,
sub xmlListSearch(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                 ,Pointer                       $data # void*
                  ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/list.h:66
#XMLPUBFUN void * XMLCALL
#		xmlListReverseSearch	(xmlListPtr l,
sub xmlListReverseSearch(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                        ,Pointer                       $data # void*
                         ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/list.h:69
#XMLPUBFUN int XMLCALL
#		xmlListInsert		(xmlListPtr l,
sub xmlListInsert(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                 ,Pointer                       $data # void*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:72
#XMLPUBFUN int XMLCALL
#		xmlListAppend		(xmlListPtr l,
sub xmlListAppend(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                 ,Pointer                       $data # void*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:75
#XMLPUBFUN int XMLCALL
#		xmlListRemoveFirst	(xmlListPtr l,
sub xmlListRemoveFirst(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                      ,Pointer                       $data # void*
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:78
#XMLPUBFUN int XMLCALL
#		xmlListRemoveLast	(xmlListPtr l,
sub xmlListRemoveLast(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                     ,Pointer                       $data # void*
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:81
#XMLPUBFUN int XMLCALL
#		xmlListRemoveAll	(xmlListPtr l,
sub xmlListRemoveAll(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                    ,Pointer                       $data # void*
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:84
#XMLPUBFUN void XMLCALL
#		xmlListClear		(xmlListPtr l);
sub xmlListClear(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:86
#XMLPUBFUN int XMLCALL
#		xmlListEmpty		(xmlListPtr l);
sub xmlListEmpty(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                 ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:88
#XMLPUBFUN xmlLinkPtr XMLCALL
#		xmlListFront		(xmlListPtr l);
sub xmlListFront(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                 ) is native(LIB) returns _xmlLink is export { * }

#-From /usr/include/libxml2/libxml/list.h:90
#XMLPUBFUN xmlLinkPtr XMLCALL
#		xmlListEnd		(xmlListPtr l);
sub xmlListEnd(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
               ) is native(LIB) returns _xmlLink is export { * }

#-From /usr/include/libxml2/libxml/list.h:92
#XMLPUBFUN int XMLCALL
#		xmlListSize		(xmlListPtr l);
sub xmlListSize(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:95
#XMLPUBFUN void XMLCALL
#		xmlListPopFront		(xmlListPtr l);
sub xmlListPopFront(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:97
#XMLPUBFUN void XMLCALL
#		xmlListPopBack		(xmlListPtr l);
sub xmlListPopBack(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:99
#XMLPUBFUN int XMLCALL
#		xmlListPushFront	(xmlListPtr l,
sub xmlListPushFront(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                    ,Pointer                       $data # void*
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:102
#XMLPUBFUN int XMLCALL
#		xmlListPushBack		(xmlListPtr l,
sub xmlListPushBack(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                   ,Pointer                       $data # void*
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:107
#/* Advanced Operators */
#XMLPUBFUN void XMLCALL
#		xmlListReverse		(xmlListPtr l);
sub xmlListReverse(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:109
#XMLPUBFUN void XMLCALL
#		xmlListSort		(xmlListPtr l);
sub xmlListSort(_xmlList $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:111
#XMLPUBFUN void XMLCALL
#		xmlListWalk		(xmlListPtr l,
sub xmlListWalk(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
               ,&walker ( --> int32) # Typedef<xmlListWalker>->«F:int ( )*»
               ,Pointer                       $user # const void*
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:115
#XMLPUBFUN void XMLCALL
#		xmlListReverseWalk	(xmlListPtr l,
sub xmlListReverseWalk(_xmlList                      $l # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                      ,&walker ( --> int32) # Typedef<xmlListWalker>->«F:int ( )*»
                      ,Pointer                       $user # const void*
                       ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:119
#XMLPUBFUN void XMLCALL
#		xmlListMerge		(xmlListPtr l1,
sub xmlListMerge(_xmlList                      $l1 # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                ,_xmlList                      $l2 # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/list.h:122
#XMLPUBFUN xmlListPtr XMLCALL
#		xmlListDup		(const xmlListPtr old);
sub xmlListDup(_xmlList $old # const Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
               ) is native(LIB) returns _xmlList is export { * }

#-From /usr/include/libxml2/libxml/list.h:124
#XMLPUBFUN int XMLCALL
#		xmlListCopy		(xmlListPtr cur,
sub xmlListCopy(_xmlList                      $cur # Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
               ,_xmlList                      $old # const Typedef<xmlListPtr>->«Typedef<xmlList>->«_xmlList»*»
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/list.h:128
#/* Link operators */
#XMLPUBFUN void * XMLCALL
#		xmlLinkGetData          (xmlLinkPtr lk);
sub xmlLinkGetData(_xmlLink $lk # Typedef<xmlLinkPtr>->«Typedef<xmlLink>->«_xmlLink»*»
                   ) is native(LIB) returns Pointer is export { * }


# == /usr/include/libxml2/libxml/hash.h ==

#-From /usr/include/libxml2/libxml/hash.h:107
#/*
# * Constructor and destructor.
# */
#XMLPUBFUN xmlHashTablePtr XMLCALL
#			xmlHashCreate	(int size);
sub xmlHashCreate(int32 $size # int
                  ) is native(LIB) returns _xmlHashTable is export { * }

#-From /usr/include/libxml2/libxml/hash.h:109
#XMLPUBFUN xmlHashTablePtr XMLCALL
#			xmlHashCreateDict(int size,
sub xmlHashCreateDict(int32                         $size # int
                     ,_xmlDict                      $dict # Typedef<xmlDictPtr>->«Typedef<xmlDict>->«_xmlDict»*»
                      ) is native(LIB) returns _xmlHashTable is export { * }

#-From /usr/include/libxml2/libxml/hash.h:112
#XMLPUBFUN void XMLCALL
#			xmlHashFree	(xmlHashTablePtr table,
sub xmlHashFree(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
               ,&f () # Typedef<xmlHashDeallocator>->«F:void ( )*»
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/hash.h:119
#/*
# * Add a new entry to the hash table.
# */
#XMLPUBFUN int XMLCALL
#			xmlHashAddEntry	(xmlHashTablePtr table,
sub xmlHashAddEntry(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer                       $userdata # void*
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:123
#XMLPUBFUN int XMLCALL
#			xmlHashUpdateEntry(xmlHashTablePtr table,
sub xmlHashUpdateEntry(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                      ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ,Pointer                       $userdata # void*
                      ,&f () # Typedef<xmlHashDeallocator>->«F:void ( )*»
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:128
#XMLPUBFUN int XMLCALL
#			xmlHashAddEntry2(xmlHashTablePtr table,
sub xmlHashAddEntry2(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                    ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                    ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                    ,Pointer                       $userdata # void*
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:133
#XMLPUBFUN int XMLCALL
#			xmlHashUpdateEntry2(xmlHashTablePtr table,
sub xmlHashUpdateEntry2(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                       ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer                       $userdata # void*
                       ,&f () # Typedef<xmlHashDeallocator>->«F:void ( )*»
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:139
#XMLPUBFUN int XMLCALL
#			xmlHashAddEntry3(xmlHashTablePtr table,
sub xmlHashAddEntry3(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                    ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                    ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                    ,Pointer[xmlChar]              $name3 # const Typedef<xmlChar>->«unsigned char»*
                    ,Pointer                       $userdata # void*
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:145
#XMLPUBFUN int XMLCALL
#			xmlHashUpdateEntry3(xmlHashTablePtr table,
sub xmlHashUpdateEntry3(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                       ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $name3 # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer                       $userdata # void*
                       ,&f () # Typedef<xmlHashDeallocator>->«F:void ( )*»
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:156
#/*
# * Remove an entry from the hash table.
# */
#XMLPUBFUN int XMLCALL
#			xmlHashRemoveEntry(xmlHashTablePtr table, const xmlChar *name,
sub xmlHashRemoveEntry(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                      ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                      ,&f () # Typedef<xmlHashDeallocator>->«F:void ( )*»
                       ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:159
#XMLPUBFUN int XMLCALL
#			xmlHashRemoveEntry2(xmlHashTablePtr table, const xmlChar *name,
sub xmlHashRemoveEntry2(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                       ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                       ,&f () # Typedef<xmlHashDeallocator>->«F:void ( )*»
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:162
#XMLPUBFUN int  XMLCALL
#			xmlHashRemoveEntry3(xmlHashTablePtr table, const xmlChar *name,
sub xmlHashRemoveEntry3(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                       ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                       ,Pointer[xmlChar]              $name3 # const Typedef<xmlChar>->«unsigned char»*
                       ,&f () # Typedef<xmlHashDeallocator>->«F:void ( )*»
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:170
#/*
# * Retrieve the userdata.
# */
#XMLPUBFUN void * XMLCALL
#			xmlHashLookup	(xmlHashTablePtr table,
sub xmlHashLookup(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                 ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/hash.h:173
#XMLPUBFUN void * XMLCALL
#			xmlHashLookup2	(xmlHashTablePtr table,
sub xmlHashLookup2(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/hash.h:177
#XMLPUBFUN void * XMLCALL
#			xmlHashLookup3	(xmlHashTablePtr table,
sub xmlHashLookup3(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $name3 # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/hash.h:182
#XMLPUBFUN void * XMLCALL
#			xmlHashQLookup	(xmlHashTablePtr table,
sub xmlHashQLookup(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                  ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                  ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                   ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/hash.h:186
#XMLPUBFUN void * XMLCALL
#			xmlHashQLookup2	(xmlHashTablePtr table,
sub xmlHashQLookup2(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $prefix2 # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/hash.h:192
#XMLPUBFUN void * XMLCALL
#			xmlHashQLookup3	(xmlHashTablePtr table,
sub xmlHashQLookup3(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                   ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $prefix # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $prefix2 # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $name3 # const Typedef<xmlChar>->«unsigned char»*
                   ,Pointer[xmlChar]              $prefix3 # const Typedef<xmlChar>->«unsigned char»*
                    ) is native(LIB) returns Pointer is export { * }

#-From /usr/include/libxml2/libxml/hash.h:204
#/*
# * Helpers.
# */
#XMLPUBFUN xmlHashTablePtr XMLCALL
#			xmlHashCopy	(xmlHashTablePtr table,
sub xmlHashCopy(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
               ,&f ( --> Pointer) # Typedef<xmlHashCopier>->«F:void* ( )*»
                ) is native(LIB) returns _xmlHashTable is export { * }

#-From /usr/include/libxml2/libxml/hash.h:207
#XMLPUBFUN int XMLCALL
#			xmlHashSize	(xmlHashTablePtr table);
sub xmlHashSize(_xmlHashTable $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/hash.h:209
#XMLPUBFUN void XMLCALL
#			xmlHashScan	(xmlHashTablePtr table,
sub xmlHashScan(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
               ,&f () # Typedef<xmlHashScanner>->«F:void ( )*»
               ,Pointer                       $data # void*
                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/hash.h:213
#XMLPUBFUN void XMLCALL
#			xmlHashScan3	(xmlHashTablePtr table,
sub xmlHashScan3(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                ,Pointer[xmlChar]              $name3 # const Typedef<xmlChar>->«unsigned char»*
                ,&f () # Typedef<xmlHashScanner>->«F:void ( )*»
                ,Pointer                       $data # void*
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/hash.h:220
#XMLPUBFUN void XMLCALL
#			xmlHashScanFull	(xmlHashTablePtr table,
sub xmlHashScanFull(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                   ,&f () # Typedef<xmlHashScannerFull>->«F:void ( )*»
                   ,Pointer                       $data # void*
                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/hash.h:224
#XMLPUBFUN void XMLCALL
#			xmlHashScanFull3(xmlHashTablePtr table,
sub xmlHashScanFull3(_xmlHashTable                 $table # Typedef<xmlHashTablePtr>->«Typedef<xmlHashTable>->«_xmlHashTable»*»
                    ,Pointer[xmlChar]              $name # const Typedef<xmlChar>->«unsigned char»*
                    ,Pointer[xmlChar]              $name2 # const Typedef<xmlChar>->«unsigned char»*
                    ,Pointer[xmlChar]              $name3 # const Typedef<xmlChar>->«unsigned char»*
                    ,&f () # Typedef<xmlHashScannerFull>->«F:void ( )*»
                    ,Pointer                       $data # void*
                     ) is native(LIB)  is export { * }


# == /usr/include/unicode/utypes.h ==

#-From /usr/include/unicode/utypes.h:724
#/**
# * Return a string for a UErrorCode value.
# * The string will be the same as the name of the error code constant
# * in the UErrorCode enum above.
# * @stable ICU 2.0
# */
#U_STABLE const char * U_EXPORT2
#u_errorName(UErrorCode code);
sub u_errorName_57(int32 $code # Typedef<UErrorCode>->«UErrorCode»
                   ) is native(LIB) returns Str is export { * }


# == /usr/include/libxml2/libxml/threads.h ==

#-From /usr/include/libxml2/libxml/threads.h:40
##ifdef __cplusplus
#}
##endif
##include <libxml/globals.h>
##ifdef __cplusplus
#extern "C" {
##endif
#XMLPUBFUN xmlMutexPtr XMLCALL
#			xmlNewMutex	(void);
sub xmlNewMutex(
                ) is native(LIB) returns _xmlMutex is export { * }

#-From /usr/include/libxml2/libxml/threads.h:42
#XMLPUBFUN void XMLCALL
#			xmlMutexLock	(xmlMutexPtr tok);
sub xmlMutexLock(_xmlMutex $tok # Typedef<xmlMutexPtr>->«Typedef<xmlMutex>->«_xmlMutex»*»
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:44
#XMLPUBFUN void XMLCALL
#			xmlMutexUnlock	(xmlMutexPtr tok);
sub xmlMutexUnlock(_xmlMutex $tok # Typedef<xmlMutexPtr>->«Typedef<xmlMutex>->«_xmlMutex»*»
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:46
#XMLPUBFUN void XMLCALL
#			xmlFreeMutex	(xmlMutexPtr tok);
sub xmlFreeMutex(_xmlMutex $tok # Typedef<xmlMutexPtr>->«Typedef<xmlMutex>->«_xmlMutex»*»
                 ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:49
#XMLPUBFUN xmlRMutexPtr XMLCALL
#			xmlNewRMutex	(void);
sub xmlNewRMutex(
                 ) is native(LIB) returns _xmlRMutex is export { * }

#-From /usr/include/libxml2/libxml/threads.h:51
#XMLPUBFUN void XMLCALL
#			xmlRMutexLock	(xmlRMutexPtr tok);
sub xmlRMutexLock(_xmlRMutex $tok # Typedef<xmlRMutexPtr>->«Typedef<xmlRMutex>->«_xmlRMutex»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:53
#XMLPUBFUN void XMLCALL
#			xmlRMutexUnlock	(xmlRMutexPtr tok);
sub xmlRMutexUnlock(_xmlRMutex $tok # Typedef<xmlRMutexPtr>->«Typedef<xmlRMutex>->«_xmlRMutex»*»
                    ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:55
#XMLPUBFUN void XMLCALL
#			xmlFreeRMutex	(xmlRMutexPtr tok);
sub xmlFreeRMutex(_xmlRMutex $tok # Typedef<xmlRMutexPtr>->«Typedef<xmlRMutex>->«_xmlRMutex»*»
                  ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:61
#/*
# * Library wide APIs.
# */
#XMLPUBFUN void XMLCALL
#			xmlInitThreads	(void);
sub xmlInitThreads(
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:63
#XMLPUBFUN void XMLCALL
#			xmlLockLibrary	(void);
sub xmlLockLibrary(
                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:65
#XMLPUBFUN void XMLCALL
#			xmlUnlockLibrary(void);
sub xmlUnlockLibrary(
                     ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:67
#XMLPUBFUN int XMLCALL
#			xmlGetThreadId	(void);
sub xmlGetThreadId(
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/threads.h:69
#XMLPUBFUN int XMLCALL
#			xmlIsMainThread	(void);
sub xmlIsMainThread(
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/threads.h:71
#XMLPUBFUN void XMLCALL
#			xmlCleanupThreads(void);
sub xmlCleanupThreads(
                      ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/threads.h:73
#XMLPUBFUN xmlGlobalStatePtr XMLCALL
#			xmlGetGlobalState(void);
sub xmlGetGlobalState(
                      ) is native(LIB) returns _xmlGlobalState is export { * }


# == /usr/include/libxml2/libxml/encoding.h ==

#-From /usr/include/libxml2/libxml/encoding.h:167
#/*
# * Interfaces for encoding handlers.
# */
#XMLPUBFUN void XMLCALL
#	xmlInitCharEncodingHandlers	(void);
sub xmlInitCharEncodingHandlers(
                                ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:169
#XMLPUBFUN void XMLCALL
#	xmlCleanupCharEncodingHandlers	(void);
sub xmlCleanupCharEncodingHandlers(
                                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:171
#XMLPUBFUN void XMLCALL
#	xmlRegisterCharEncodingHandler	(xmlCharEncodingHandlerPtr handler);
sub xmlRegisterCharEncodingHandler(_xmlCharEncodingHandler $handler # Typedef<xmlCharEncodingHandlerPtr>->«Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*»
                                   ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:173
#XMLPUBFUN xmlCharEncodingHandlerPtr XMLCALL
#	xmlGetCharEncodingHandler	(xmlCharEncoding enc);
sub xmlGetCharEncodingHandler(int32 $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                              ) is native(LIB) returns _xmlCharEncodingHandler is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:175
#XMLPUBFUN xmlCharEncodingHandlerPtr XMLCALL
#	xmlFindCharEncodingHandler	(const char *name);
sub xmlFindCharEncodingHandler(Str $name # const char*
                               ) is native(LIB) returns _xmlCharEncodingHandler is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:177
#XMLPUBFUN xmlCharEncodingHandlerPtr XMLCALL
#	xmlNewCharEncodingHandler	(const char *name,
sub xmlNewCharEncodingHandler(Str                           $name # const char*
                             ,&input ( --> int32) # Typedef<xmlCharEncodingInputFunc>->«F:int ( )*»
                             ,&output ( --> int32) # Typedef<xmlCharEncodingOutputFunc>->«F:int ( )*»
                              ) is native(LIB) returns _xmlCharEncodingHandler is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:185
#/*
# * Interfaces for encoding names and aliases.
# */
#XMLPUBFUN int XMLCALL
#	xmlAddEncodingAlias		(const char *name,
sub xmlAddEncodingAlias(Str                           $name # const char*
                       ,Str                           $alias # const char*
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:188
#XMLPUBFUN int XMLCALL
#	xmlDelEncodingAlias		(const char *alias);
sub xmlDelEncodingAlias(Str $alias # const char*
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:190
#XMLPUBFUN const char * XMLCALL
#	xmlGetEncodingAlias		(const char *alias);
sub xmlGetEncodingAlias(Str $alias # const char*
                        ) is native(LIB) returns Str is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:192
#XMLPUBFUN void XMLCALL
#	xmlCleanupEncodingAliases	(void);
sub xmlCleanupEncodingAliases(
                              ) is native(LIB)  is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:194
#XMLPUBFUN xmlCharEncoding XMLCALL
#	xmlParseCharEncoding		(const char *name);
sub xmlParseCharEncoding(Str $name # const char*
                         ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:196
#XMLPUBFUN const char * XMLCALL
#	xmlGetCharEncodingName		(xmlCharEncoding enc);
sub xmlGetCharEncodingName(int32 $enc # Typedef<xmlCharEncoding>->«xmlCharEncoding»
                           ) is native(LIB) returns Str is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:202
#/*
# * Interfaces directly used by the parsers.
# */
#XMLPUBFUN xmlCharEncoding XMLCALL
#	xmlDetectCharEncoding		(const unsigned char *in,
sub xmlDetectCharEncoding(Pointer[uint8]                $in # const unsigned char*
                         ,int32                         $len # int
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:206
#XMLPUBFUN int XMLCALL
#	xmlCharEncOutFunc		(xmlCharEncodingHandler *handler,
sub xmlCharEncOutFunc(_xmlCharEncodingHandler       $handler # Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*
                     ,_xmlBuffer                    $out # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                     ,_xmlBuffer                    $in # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                      ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:211
#XMLPUBFUN int XMLCALL
#	xmlCharEncInFunc		(xmlCharEncodingHandler *handler,
sub xmlCharEncInFunc(_xmlCharEncodingHandler       $handler # Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*
                    ,_xmlBuffer                    $out # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                    ,_xmlBuffer                    $in # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                     ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:215
#XMLPUBFUN int XMLCALL
#	xmlCharEncFirstLine		(xmlCharEncodingHandler *handler,
sub xmlCharEncFirstLine(_xmlCharEncodingHandler       $handler # Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*
                       ,_xmlBuffer                    $out # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                       ,_xmlBuffer                    $in # Typedef<xmlBufferPtr>->«Typedef<xmlBuffer>->«_xmlBuffer»*»
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:219
#XMLPUBFUN int XMLCALL
#	xmlCharEncCloseFunc		(xmlCharEncodingHandler *handler);
sub xmlCharEncCloseFunc(_xmlCharEncodingHandler $handler # Typedef<xmlCharEncodingHandler>->«_xmlCharEncodingHandler»*
                        ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:226
#/*
# * Export a few useful functions
# */
##ifdef LIBXML_OUTPUT_ENABLED
#XMLPUBFUN int XMLCALL
#	UTF8Toisolat1			(unsigned char *out,
sub UTF8Toisolat1(Pointer[uint8]                $out # unsigned char*
                 ,Pointer[int32]                $outlen # int*
                 ,Pointer[uint8]                $in # const unsigned char*
                 ,Pointer[int32]                $inlen # int*
                  ) is native(LIB) returns int32 is export { * }

#-From /usr/include/libxml2/libxml/encoding.h:232
##endif /* LIBXML_OUTPUT_ENABLED */
#XMLPUBFUN int XMLCALL
#	isolat1ToUTF8			(unsigned char *out,
sub isolat1ToUTF8(Pointer[uint8]                $out # unsigned char*
                 ,Pointer[int32]                $outlen # int*
                 ,Pointer[uint8]                $in # const unsigned char*
                 ,Pointer[int32]                $inlen # int*
                  ) is native(LIB) returns int32 is export { * }

## Externs


# == /usr/include/unicode/utf8.h ==

our $utf8_countTrailBytes_57 is export = cglobal(LIB, "utf8_countTrailBytes_57", CArray[uint8_t]);

# == /usr/include/libxml2/libxml/xmlregexp.h ==

our $forbiddenExp is export = cglobal(LIB, "forbiddenExp", _xmlExpNode);
our $emptyExp is export = cglobal(LIB, "emptyExp", _xmlExpNode);

# == /usr/include/libxml2/libxml/globals.h ==

our $xmlMalloc is export = cglobal(LIB, "xmlMalloc", Pointer);
our $xmlMallocAtomic is export = cglobal(LIB, "xmlMallocAtomic", Pointer);
our $xmlRealloc is export = cglobal(LIB, "xmlRealloc", Pointer);
our $xmlFree is export = cglobal(LIB, "xmlFree", Pointer);
our $xmlMemStrdup is export = cglobal(LIB, "xmlMemStrdup", Pointer);
our $docbDefaultSAXHandler is export = cglobal(LIB, "docbDefaultSAXHandler", _xmlSAXHandlerV1);
our $htmlDefaultSAXHandler is export = cglobal(LIB, "htmlDefaultSAXHandler", _xmlSAXHandlerV1);
our $xmlLastError is export = cglobal(LIB, "xmlLastError", _xmlError);
our $oldXMLWDcompatibility is export = cglobal(LIB, "oldXMLWDcompatibility", int32);
our $xmlBufferAllocScheme is export = cglobal(LIB, "xmlBufferAllocScheme", int32);
our $xmlDefaultBufferSize is export = cglobal(LIB, "xmlDefaultBufferSize", int32);
our $xmlDefaultSAXHandler is export = cglobal(LIB, "xmlDefaultSAXHandler", _xmlSAXHandlerV1);
our $xmlDefaultSAXLocator is export = cglobal(LIB, "xmlDefaultSAXLocator", _xmlSAXLocator);
our $xmlDoValidityCheckingDefaultValue is export = cglobal(LIB, "xmlDoValidityCheckingDefaultValue", int32);
our $xmlGenericError is export = cglobal(LIB, "xmlGenericError", Pointer);
our $xmlStructuredError is export = cglobal(LIB, "xmlStructuredError", Pointer);
our $xmlGenericErrorContext is export = cglobal(LIB, "xmlGenericErrorContext", Pointer);
our $xmlStructuredErrorContext is export = cglobal(LIB, "xmlStructuredErrorContext", Pointer);
our $xmlGetWarningsDefaultValue is export = cglobal(LIB, "xmlGetWarningsDefaultValue", int32);
our $xmlIndentTreeOutput is export = cglobal(LIB, "xmlIndentTreeOutput", int32);
our $xmlTreeIndentString is export = cglobal(LIB, "xmlTreeIndentString", Str);
our $xmlKeepBlanksDefaultValue is export = cglobal(LIB, "xmlKeepBlanksDefaultValue", int32);
our $xmlLineNumbersDefaultValue is export = cglobal(LIB, "xmlLineNumbersDefaultValue", int32);
our $xmlLoadExtDtdDefaultValue is export = cglobal(LIB, "xmlLoadExtDtdDefaultValue", int32);
our $xmlParserDebugEntities is export = cglobal(LIB, "xmlParserDebugEntities", int32);
our $xmlParserVersion is export = cglobal(LIB, "xmlParserVersion", Str);
our $xmlPedanticParserDefaultValue is export = cglobal(LIB, "xmlPedanticParserDefaultValue", int32);
our $xmlSaveNoEmptyTags is export = cglobal(LIB, "xmlSaveNoEmptyTags", int32);
our $xmlSubstituteEntitiesDefaultValue is export = cglobal(LIB, "xmlSubstituteEntitiesDefaultValue", int32);
our $xmlRegisterNodeDefaultValue is export = cglobal(LIB, "xmlRegisterNodeDefaultValue", Pointer);
our $xmlDeregisterNodeDefaultValue is export = cglobal(LIB, "xmlDeregisterNodeDefaultValue", Pointer);
our $xmlParserInputBufferCreateFilenameValue is export = cglobal(LIB, "xmlParserInputBufferCreateFilenameValue", Pointer);
our $xmlOutputBufferCreateFilenameValue is export = cglobal(LIB, "xmlOutputBufferCreateFilenameValue", Pointer);
