use v6;
#  -- DO NOT EDIT --
# generated by: etc/generator.p6 

unit module LibXML::Native::Gen::uri;
# library of generic URI related routines:
#    library of generic URI related routines Implements RFC 2396 
use LibXML::Native::Defs :$lib, :xmlCharP;

class xmlURI is repr('CStruct') {
    has Str $.scheme; # the URI scheme
    has Str $.opaque; # opaque part
    has Str $.authority; # the authority part
    has Str $.server; # the server part
    has Str $.user; # the user part
    has int32 $.port; # the port number
    has Str $.path; # the path string
    has Str $.query; # the query string (deprecated - use with caution)
    has Str $.fragment; # the fragment identifier
    has int32 $.cleanup; # parsing potentially unclean URI
    has Str $.query_raw; # the query string (as it appears in the URI)

    sub xmlCreateURI( --> xmlURI) is native(XML2) is export {*};
    sub xmlParseURI(Str $str --> xmlURI) is native(XML2) is export {*};
    sub xmlParseURIRaw(Str $str, int32 $raw --> xmlURI) is native(XML2) is export {*};

    method Free() is native(XML2) is symbol('xmlFreeURI') {*};
    method ParseURIReference(Str $str --> int32) is native(XML2) is symbol('xmlParseURIReference') {*};
    method SaveUri( --> xmlCharP) is native(XML2) is symbol('xmlSaveUri') {*};
}

sub xmlBuildRelativeURI(xmlCharP $URI, xmlCharP $base --> xmlCharP) is native(XML2) is export {*};
sub xmlBuildURI(xmlCharP $URI, xmlCharP $base --> xmlCharP) is native(XML2) is export {*};
sub xmlCanonicPath(xmlCharP $path --> xmlCharP) is native(XML2) is export {*};
sub xmlNormalizeURIPath(Str $path --> int32) is native(XML2) is export {*};
sub xmlPathToURI(xmlCharP $path --> xmlCharP) is native(XML2) is export {*};
sub xmlPrintURI(FILE * $stream, xmlURI $uri) is native(XML2) is export {*};
sub xmlURIEscape(xmlCharP $str --> xmlCharP) is native(XML2) is export {*};
sub xmlURIEscapeStr(xmlCharP $str, xmlCharP $list --> xmlCharP) is native(XML2) is export {*};
sub xmlURIUnescapeString(Str $str, int32 $len, Str $target --> Str) is native(XML2) is export {*};
