package Webservice::Trello;

use warnings;
use strict;

=head1 NAME

Webservice::Trello - Client Class for accessing Asana API!

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';


=head1 SYNOPSIS

  my $trello = Webservice::Trello->new();

=head1 DESCRIPTION

This library implements the L<http://trello.com/api Trello API>.

L<Trello https://trello.com> is a Web based project management application.


=head1 AUTHOR

Thomas Fahle, C<< <cpan at thomas-fahle.de> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-webservice-trello at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Webservice-Trello>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Webservice::Trello


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Webservice-Trello>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Webservice-Trello>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Webservice-Trello>

=item * Search CPAN

L<http://search.cpan.org/dist/Webservice-Trello/>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2012 Thomas Fahle.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.


=cut

1; # End of Webservice::Trello
