#!/usr/bin/perl -w
# $Id: Makefile.PL 2693 2008-01-02 09:54:19Z hospelt $
require 5.004;
use strict;
use vars qw($VERSION $opt_n $opt_y);
$VERSION = "0.08";

use ExtUtils::MakeMaker;
BEGIN {
    @Heap::Simple::implementors = qw(CGI) unless @Heap::Simple::implementors;
}

# Allows to suppress all questions with -n or -y
use Getopt::Std;
getopts("ny") || die "Usage: $0 [-n] [-y]\n";

my $benchmark = 0;
my $benchmark_others = 0;

if (!$opt_n || $opt_y) {
    print <<EOT

   Note that you can avoid these questions by passing
   the '-n' or '-y' option to 'Makefile.PL'.

EOT
;
    $benchmark =
        $opt_y ||
        prompt("Run Heap::Simple benchmarks during 'make test' ?", "n") =~ /^y/i;
    if ($benchmark) {
        $benchmark_others =
            $opt_y ||
            prompt("Benchmarks against other heap modules that happen to be installed on this machine during 'make test' ?", "n") =~ /^y/i;
    }
}
my $option_file = "t/options";
my $new = "$option_file.new.$$";
open(my $fh, ">", $new) || die "Could not open '$new': $!";
printf($fh "BENCHMARK=%d\nBENCHMARK_OTHERS=%d\n",
       $benchmark ? 1 : 0,
       $benchmark_others ? 1 : 0) || die "Error writing to '$new': $!";
eval {
    close($fh) || die "Could not close '$new': $!";
    rename($new, $option_file) ||
        die "Could not rename '$new' to '$option_file': $!";
};
if ($@) {
    $fh = undef;	# close file if open
    unlink($new) || die "Could not unlink '$new': $! after $@";
    die $@;
}

WriteMakefile(
    NAME		=> 'Heap::Simple::Perl',
    VERSION_FROM	=> 'lib/Heap/Simple/Perl/Package.pm',
    PREREQ_PM		=> {
        "Heap::Simple"	=> "0.09",	# implementor switch
        "Test::More"	=> "0.11",	# For the tests only
    },
    ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
      (AUTHOR		=> 'Ton Hospel <Heap-Simple@ton.iguana.be>') : ()),
     $^O eq "MSWin32" ? (
         PM_FILTER	=> '$(PERL) -p -e1',
     ) : (),
     clean		=> {
         FILES => '$(DISTNAME).ppd ppm cover_db t/options',
     },
);

# START MY
# autogenerated by release_pm
package MY;
sub postamble {
    return shift->SUPER::postamble() . <<"EOF";
ppm: \$(DISTNAME).ppd

\$(DISTNAME).ppd: all ppd
	makeppd.pl "--perl=\$(PERL)" --min_version=1.013 "--zip=\$(ZIP)" "--tar=\$(TAR)" "--compress=\$(COMPRESS)" --leave=ppm \$(DISTNAME).ppd \$(VERSION)

cover:
	cover -delete
	-HARNESS_PERL_SWITCHES=-MDevel::Cover make test
	cover

ppm_install: \$(DISTNAME).ppd
	ppm install ppm/\$(DISTNAME).ppd

ppm_uninstall:
	ppm uninstall \$(DISTNAME)
EOF
}
# END MY
