package Tapper::Model;
# git description: v4.1.2-24-ge5fa35b

our $AUTHORITY = 'cpan:TAPPER';
$Tapper::Model::VERSION = '5.0.0';
# ABSTRACT: Tapper - Context sensitive connected DBIC schema

use strict;
use warnings;

use 5.010;

# avoid these warnings
#   Subroutine initialize redefined at /2home/ss5/perl510/lib/site_perl/5.10.0/Class/C3.pm line 70.
#   Subroutine uninitialize redefined at /2home/ss5/perl510/lib/site_perl/5.10.0/Class/C3.pm line 88.
#   Subroutine reinitialize redefined at /2home/ss5/perl510/lib/site_perl/5.10.0/Class/C3.pm line 101.
# by forcing correct load order.

use English;
use Class::C3;
use MRO::Compat;
use Tapper::Config;
use parent 'Exporter';
use Tapper::Schema::TestrunDB;

my $or_testrundb_schema;
our @EXPORT_OK = qw(model get_hardware_overview);


sub model {
    return $or_testrundb_schema //= Tapper::Schema::TestrunDB->connect(
        @{Tapper::Config->subconfig->{database}{TestrunDB}}{qw/ dsn username password /},{},
    );
}


sub get_or_create_owner {

        my ($login) = @_;

        return model('TestrunDB')
            ->resultset('Owner')
            ->find_or_create({ login => $login },{ login => $login })
            ->id()
        ;

}


sub get_hardware_overview {

        my ($host_id) = @_;

        my $host = model('TestrunDB')
                ->resultset('Host')
                ->search({ 'me.id' => $host_id }, { prefetch => 'features' })
                ->first()
        ;

        if (! $host ) {
                return qq(Host with id '$host_id' not found);
        }

        return { map { $_->entry => $_->value } $host->features };

}


1; # End of Tapper::Model

__END__

=pod

=encoding UTF-8

=head1 NAME

Tapper::Model - Tapper - Context sensitive connected DBIC schema

=head1 SYNOPSIS

    use Tapper::Model 'model';
    my $testrun = model('TestrunDB')->schema('Testrun')->find(12);
    my $testrun = model('TestrunDB')->schema('Report')->find(7343);

=head2 model

Returns a connected schema, depending on the environment (live,
development, test).

@param 1. $schema_basename - optional, default is "Tests", meaning the
          Schema "Tapper::Schema::Tests"

@return $schema

=head2 get_or_create_owner

Search a owner based on login name. Create a owner with this login name if
not found.

@param string - login name

@return success - id (primary key of owner table)
@return error   - undef

=head2 get_hardware_overview

Returns an overview of a given machine revision.

@param int - machine lid

@return success - hash ref
@return error   - undef

=head1 AUTHORS

=over 4

=item *

AMD OSRC Tapper Team <tapper@amd64.org>

=item *

Tapper Team <tapper-ops@amazon.com>

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Advanced Micro Devices, Inc..

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
