#!/usr/bin/perl -w

use strict;
use warnings;
use t::lib::XSP::Test tests => 3;

run_diff process => 'expected';

__DATA__

=== Basic file - stdout
--- process xsp_stdout
%module{Foo};
%package{Foo};

%file{foo.h};
{%
Some verbatim
text
%}
%file{-};

int foo( int a, int b, int c );
--- expected
#include <exception>


MODULE=Foo

MODULE=Foo PACKAGE=Foo


#include <exception>


int
foo( a, b, c )
    int a
    int b
    int c
  CODE:
    try {
      RETVAL = foo( a, b, c );
    } catch (std::exception& e) {
      croak("Caught unhandled C++ exception: %s", e.what());
    } catch (...) {
      croak("Caught unhandled C++ exception of unknown type");
    }
  OUTPUT: RETVAL

=== Basic file - external file
--- process xsp_file=foo.h
%module{Foo};
%package{Foo};

%file{foo.h};
%{
Some verbatim
text
%}
%file{-};

int foo( int a, int b, int c );
--- expected
#include <exception>



Some verbatim
text

=== Basic file - processed external file
--- process xsp_file=foo.h
%module{Foo};
%package{Foo};

%file{foo.h};
int bar( int x );
%file{-};

int foo( int a, int b, int c );
--- expected
#include <exception>


int
bar( x )
    int x
  CODE:
    try {
      RETVAL = bar( x );
    } catch (std::exception& e) {
      croak("Caught unhandled C++ exception: %s", e.what());
    } catch (...) {
      croak("Caught unhandled C++ exception of unknown type");
    }
  OUTPUT: RETVAL
