#!/usr/bin/perl
#

use strict;
use warnings;
use Test::More tests => 6;

use Net::DNS::Resolver::Unbound;


my $resolver = Net::DNS::Resolver::Unbound->new();
ok( $resolver, 'create new resolver instance' );


sub test_case {
	my ( $handle, @vector ) = @_;
	Net::DNS::Resolver::libunbound::async_callback( $handle, @vector ) if @vector;
	return $resolver->bgread($handle);
}


is( test_case(), undef, 'handle undefined' );

is( test_case( [1] ), undef, 'awaiting callback' );

is( test_case( [1, -8] ), undef, 'callback error' );
ok( $resolver->errorstring(), '$resolver->errorstring' );

is( test_case( [1, 0, undef] ), undef, 'result undefined' );


exit;

