package Gtk2::Ex::DbLinker::AbForm;
use Gtk2::Ex::DbLinker::DbTools;
our $VERSION = $Gtk2::Ex::DbLinker::DbTools::VERSION;

=head1 NAME

Gtk2::Ex::DbLinker::AbForm - Common methods for Gtk2::Ex::DbLinker::Form and Wx::Perl::DbLinker::Wxform

=head1 SYNOPSIS

See L<Gtk2::Ex::DbLinker::Form> and L<Wx::Perl::DbLinker::Wxform>. The methods in this module are not supposed to be called directly. But they are commented here.

=cut

use strict;
use warnings;
use Data::Dumper;
use DateTime::Format::Strptime;
use Carp qw(confess);

sub new {

    my $class = shift;
    my @arg   = @_;
    my $def   = {};
    my $self  = { ( %$def, @arg ) };
    $self->{log} = Log::Log4perl->get_logger(__PACKAGE__);
    bless $self, $class;
}

=head2 C<set_data_manager( $dman ) >

Replaces the current data manager with the one receives. The columns should not changed, but this method can be use to change the join clause. 

=cut

sub set_data_manager {
    my ( $self, $dman ) = @_;
    $self->{dman} = $dman;
}

=item C<add_childform( $childform )>

You may add any dependant form or datasheet object with this call if you want that a changed in this subform/datasheet be applied when the apply method of this form is called. 

=cut

sub add_childform {
    my ( $self, $sf ) = @_;
    $self->{log}->warn(
        "add_childform : do not set auto_apply to 0 if you call this method")
      unless ( $self->{auto_apply} );

#carp("add_childform : do not set auto_apply to 0 if you call this method")  unless ($self->{auto_apply});
    push @{ $self->{subform} }, $sf;

}

sub _init {
    my $self = shift;

    if ( defined $self->{datawidgets_ro} ) {
        my %seen;
        %seen = map { $_ => $seen{$_}++ }
          ( @{ $self->{cols} }, @{ $self->{datawidgets_ro} } );
        my @fields_to_save = grep { $seen{$_} < 1 } keys %seen;

        #$self->{log}->debug("cols: " . join(" ", @{$self->{cols}}));
        $self->{log}->debug( "cols to saved: " . join( " ", @fields_to_save ) );
        $self->{col2save} = \@fields_to_save;

    } else {
        $self->{col2save} = $self->{cols};

    }

}

sub _display_data {
    my ( $self, $pos ) = @_;
    $self->{log}->debug( "display_data for row at pos " . $pos );

    my $dman = $self->{dman};

    $self->{pos} = $pos;

    $dman->set_row_pos($pos) unless ( $pos < 0 );

    $self->{painting} = 1;

    #foreach my $id (keys %{$self->{datawidgets}}){
    foreach my $id ( @{ $self->{cols} } ) {

        my $w    = $self->{datawidgets}->{$id};
        my $name = $self->{datawidgetsName}->{$id};

#die("no name found $id") unless($name);
#if $name is not defined means that $id is in a field array but with no corresponding
#control in the gui
        next unless ($name);
        my $x;

        #my $row = $self->{data}[$pos];

        if ( $pos < 0 ) {
            $x = undef;
        } else {

            #$x = $row->$id() if ($row);
            $x = $dman->get_field($id);
            my $ref = ref $x;
            $self->{log}->debug( "ref: " . $ref ) if ($ref);
            if ( $ref && $ref eq "ARRAY" ) {

                # my @set = $row->$id();
                #my @set = $dman->get_field($id);
                my @set = @$x;
                $x = join( ',', @set );
                $self->{log}->debug( "id: "
                      . $id
                      . " gtkname : "
                      . $name
                      . " ref value: "
                      . ( $x ? ref($x) : "" )
                      . " value: "
                      . ( $x ? $x : "" )
                      . " type : "
                      . $self->{dman}->get_field_type($id) );

            }

        }

        # $w->signal_handler_block()

        if ( defined $self->{hdates_formatted}->{$id} ) {

            #$x = $self->_dateformatter($self->{date_formatters}->{$id}, $x);
            if ( defined $x ) {

            #my $ff = $self->{dates_formatters_f}->{$id};
            #my $fdb = $self->{dates_formatters_db}->{$id};
            # $self->{log}->debug("display_data formatted received date: ". $x);
                $x = $self->_format_date( 0, $id, $x );

            }
        }
        $self->{log}->debug( $name . " widget undef " ) unless ($w);

        my %setter = $self->{childclass}->_get_setter;
        $setter{$name}( $self, $w, $x, $id ) if ( $name && $setter{$name} );

        if ( $name eq "Wx::ListCtrl" ) {
            $self->{datawidgetsValue}->{$id} = $x;

        }
    }    #foreach
         #$self->{pos}= $pos;

    $self->_set_record_status_label;

=for comment
    my $first = ($pos < 0 ? 0 : 1);
   $self->_set_rs_range($first,  $self->{dman}->row_count);
   my $coderef = $self->{rec_spinner_callback};
   &$coderef($self);
=cut

    $self->{on_current}() if ( $self->{on_current} );
    $self->{painting} = 0;
    $self->{changed}  = 0;

}

=head2 Methods applied to a row of data

=over

=item C<insert()>

Create an empty rows at position 0 in the record_count_label.

=cut

sub insert {
    my $self = shift;
    $self->{log}->debug("insert");

    # my $row = $self->{data}[0]->new;
    $self->{inserting} = 1;

    #$self->{pos} = $self->{count} + 1;
    #afficher des champs vides
    #$self->_display_data(-1);
    my $new_pos = $self->{dman}->row_count;
    my $first = ( $new_pos > 0 ? 1 : 0 );

#data_manager->new_row is called when apply is cliked / but defaults value are not displayed then
    $self->{dman}->new_row;
    $self->{log}->debug(
        "insert : row count is : ",
        $self->{dman}->row_count,
        " new pos is : ", $new_pos
    );

# SqlADM and DBIDM ->new_row does not change row_count (are the others DM similar ?)
    $self->_display_data($new_pos);
    $self->{log}->debug( ref $self );
    my $coderef = $self->{rec_spinner_insert_callback};
    &$coderef( $self, $new_pos );

=for comment
	   if ($self->{rec_spinner}){
		  #	my $last = $self->{dman}->row_count;
		  #$self->{rec_spinner}->signal_handler_block( $self->{rs_value_changed_signal} );
	         $self->{rec_spinner}->SetRange( $first, $new_pos+1 );
		 #ne pas appler _rs_on_changed ici
        	$self->{rec_spinner}->SetValue($new_pos+1);
		#$self->{rec_spinner}->signal_handler_unblock( $self->{rs_value_changed_signal} );
		 
    
    	} 
=cut

}

=item C<undo()>

Revert the row to the original state in displaying the values fetch from the database.

=cut

sub undo {
    my $self = shift;
    $self->{log}->debug("undo clicked");
    $self->{changed}   = 0;
    $self->{inserting} = 0;
    $self->{pos2del}   = [];
    $self->_display_data( $self->{pos} );
    my $coderef = $self->{rec_spinner_callback};
    &$coderef($self);

=for comment
	  if ($self->{rec_spinner}){


		$self->{rec_spinner}->signal_handler_block( $self->{rs_value_changed_signal} );
       		$self->{rec_spinner}->set_value($self->{pos} + 1);
		#$self->{rec_spinner}->SetValue($self->{pos} + 1);
	        $self->{rec_spinner}->signal_handler_unblock( $self->{rs_value_changed_signal} );

	
	}
=cut

}

=item C<delete()>

Marks the current row to be deleted. The deletion itself will be done on apply.

=cut

sub delete {
    my $self = shift;
    $self->{log}->debug( "delete at " . $self->{dman}->get_row_pos );

    #$self->next;
    $self->{changed} = 1;
    push @{ $self->{pos2del} }, $self->{dman}->get_row_pos;
    $self->_set_record_status_label;

}

=item C<has_changed()>  

return true if the data exposed in the current row has been modified. If autoaply=>1 has been pass to the constructor,  return true if any child form has been modified.

=cut

sub has_changed {
    my $self   = shift;
    my $result = $self->{changed};
    if ( $self->{auto_apply} ) {
        foreach my $sf ( @{ $self->{subform} } ) {
            if ( $sf->has_changed ) {
                $result = 1;
                last;
            }

        }
    }
    return $result;
}

=item C<apply()>

Save a new row, save changes on an existing row, or delete the row(s) marked for deletion.

=item C<apply( [fieldname1, fieldname2 ...] )>

When inserting a new row, you can pass an array ref of fieldnames that will not be saved to the database. This is usefull to exclude composed primary keys from being saved when this has been done by saving these values directly with the DbiDM or SqlADM with C<dman->save({pk1=> value1, pk2=> value2});>. To populate the datamanager with the new data (and to have the new data correctly diplayed in the form), calls query on the Datamanager and then update on the Form. Without that you may well see the old values diplayed again despite that the database have been updated.


=back

=cut

sub apply {
    my $self = shift;
    my $pkref = ( defined $_[0] ? $_[0] : undef );
    my $row;
    my $done = 1;    # by default, changes are done
                     #we are adding a new record if $pos < 0
    $self->{log}->debug( "apply: pos : " . $self->{pos} );
    if ( $self->{pos} < 0 ) {
        $self->{log}->debug("New row");
    }

    # deleting a (or some) record
    for my $p ( @{ $self->{pos2del} } ) {
        $self->{dman}->set_row_pos($p);
        $self->{dman}->delete;
    }

    #$self->_dman_update_rows($self->{pos2del}) unless ($arg{form_only});

    $self->{log}->debug( "items in pos2del: " . scalar @{ $self->{pos2del} } );
    if ( scalar @{ $self->{pos2del} } ) {
        $self->{pos2del} = [];
        $self->{changed} = 0;
        my $last = $self->{dman}->row_count;

        # $self->set_record_status_label;
        if ( $last > 0 ) {

            #$self->{rec_spinner}->set_value(1) if ($self->{rec_spinner});
            $self->_display_data(0);
        } else {
            $self->_display_data(-1);
        }
        return;
    }

    # return value: number of fields updated - don't save if there are none
    my $count = $self->_update_fields($pkref);
    $self->{log}->debug( "count updated ", $count );
    if ($count) {
        $self->{log}->debug("dman->save");
        $done = $self->{dman}->save;
    }

    #fetch the value of the autoinc pk to pass them on after insert.
    my %pk_val;
    my @pk = $self->{dman}->get_autoinc_primarykeys;

    for my $pk (@pk) {
        $self->{log}->debug( "Primary Key: " . $pk );
        my $value = $self->{dman}->get_field($pk);
        $pk_val{$pk} = $value;
    }

    #push @pk_val, $id

    if ( $done && $self->{after_insert} ) {
        my $coderef = $self->{after_insert};
        &$coderef( undef, \%pk_val );
    }

    #if ($done && $self->{pos}<0){
    if ( $done && $self->{inserting} ) {
        my $last = $self->{dman}->row_count - 1;
        $last = ( $last < 0 ? 0 : $last );
        $self->{log}->debug( "last is " . $last );
        $self->_display_data($last);
        $self->{inserting} = 0;

        # $self->{rec_spinner_callback}->(); fait dans diplay_data

=for comment
		 if ($self->{rec_spinner}){
		  #	my $last = $self->{dman}->row_count;
			$self->{rec_spinner}->signal_handler_block( $self->{rs_value_changed_signal} );
        		$self->{rec_spinner}->set_value($last+1);
	        	$self->{rec_spinner}->signal_handler_unblock( $self->{rs_value_changed_signal} );
    		}
=cut

    }
    if ($done) {
        $self->{changed} = 0;
        $self->_save_subforms;

        $self->_set_record_status_label;
    }
    return $done;
}

sub _update_fields {
    my $self = shift;
    my @pk =
      ( defined $_[0] ? @{ $_[0] } : $self->{dman}->get_autoinc_primarykeys );

#updating a new or an existing record
#foreach widget in the form, get the value from the widget and place it in the field unless it's a primary key
#with an autogenerated value

    my $count_updated = 0;
    foreach my $id ( @{ $self->{col2save} } ) {

# {datawidgets}: href to $widget object - different from the datawidgets param in the constructor
        $self->{log}->debug( "updating field ", $id );
        if ( exists $self->{datawidgets}->{$id} ) {

            #@pk = $self->{dman}->get_autoinc_primarykeys;

            #if ($id ~~ @pk)  {
            if ( grep /^$id$/, @pk ) {
                $self->{log}->debug( $id, " not done because it's a pk" );
            } else {
                my $w = $self->{datawidgets}->{$id};
                $self->{log}->debug( $self->{datawidgetsName}->{$id} );
                my %getter  = $self->{childclass}->_get_getter;
                my $coderef = $getter{ $self->{datawidgetsName}->{$id} };

                #$id only used by Wxform
                my $v = &$coderef( $self, $w, $id );
                $self->{log}->debug(
                    "_update_fields id: $id value: " . ( $v ? $v : "" ) );
                $v = ( $v eq "" ? undef : $v );
                $self->{log}->debug( $id . ": value undef" )
                  unless ( defined $v );

                # if ( defined $v && ( $id ~~ @{$self->{dates_formatted}})){
                if ( defined $v && defined $self->{hdates_formatted}->{$id} ) {

                    #my $ff = $self->{dates_formatters_f}->{$id};

                    #my $date = $ff->parse_datetime($v);
                    $v = $self->_format_date( 1, $id, $v );

             # $v = $self->{dates_formatters_db}->{$id}->format_datetime($date);
             #$v = $self->dateformatter('%Y-%m-%d', $date);
                }

                if ( $self->{pos} < -1 ) {
                    $self->{log}->debug(
                        "current row pos: " . $self->{dman}->get_row_pos );
                }
                $count_updated++;
                $self->{dman}->set_field( $id, $v );
                $self->{log}->debug("done");
            }    # not in @pk
        }    # if exists
        else {
            $self->{log}->debug( $id . " not in data" );
        }
    }    #foreach

    return $count_updated;
}

=head2 Moving between rows

=over

=item C<next>

=item C<previous>

=item C<first>

=item C<last>

=back

=cut

sub next {
    my $self = shift;
    if ( $self->{auto_apply} && $self->has_changed ) { $self->apply; }
    $self->_display_data( $self->{dman}->next );
}

sub previous {
    my $self = shift;
    if ( $self->{auto_apply} && $self->has_changed ) { $self->apply; }
    $self->_display_data( $self->{dman}->previous );
}

sub first {
    my $self = shift;
    if ( $self->{auto_apply} && $self->has_changed ) { $self->apply; }
    $self->_display_data( $self->{dman}->first );
}

sub last {
    my $self = shift;
    if ( $self->{auto_apply} && $self->has_changed ) { $self->apply; }
    $self->_display_data( $self->{dman}->last );
}

sub _save_subforms {
    my ($self) = @_;
    return unless ( $self->{auto_apply} );
    foreach my $sf ( @{ $self->{subform} } ) {
        $sf->apply if ( $sf->has_changed );
    }

}

sub set_widget_value {
    my ( $self, $wid, $x ) = @_;
    $self->{log}->debug(
        "set_widget_value: " . $wid . " to " . ( defined $x ? $x : "null" ) );
    my $w = $self->{builder}->get_object($wid);
    if ($w) {

        my %setter  = $self->{childclass}->_get_setter;
        my $coderef = $setter{ $self->{datawidgetsName}->{$wid} };

        #$wid used only by wxform
        &$coderef( $self, $w, $x, $wid );
    }

}

sub get_widget_value {
    my ( $self, $wid ) = @_;
    my $x;
    $self->{log}->debug( "get_widget_value: " . $wid );
    my $w = $self->{builder}->get_object($wid);
    $self->{log}->debug("no widget found") unless ($w);
    if ( $w && $self->{datawidgetsName} ) {
        my %getter  = $self->{childclass}->_get_getter;
        my $coderef = $getter{ $self->{datawidgetsName}->{$wid} };
        $x = &$coderef( $self, $w, $wid );
    }
    $self->{log}->debug( "found: " . ( $x ? $x : " undef" ) );
    return ( $x ? $x : "" );
}

=head2 C<update()>

Reflect in the user interface the changes made after the data manager has been queried, or on the form creation

=cut

sub update {
    my ($self) = @_;
    my @col = $self->{dman}->get_field_names;
    $self->{log}->debug(
        "update cols are " . ( @col ? join( " ", @col ) : " cols undef " ) );
    my $pos;
    if ( $self->{dman}->row_count > 0 ) {

        #$self->{rec_spinner}->set_value(1) if ($self->{rec_spinner});
        $pos = 0;

    } else {
        $pos = -1;
    }
    $self->_display_data($pos);
    my $first = ( $pos < 0 ? 0 : 1 );
    $self->_set_rs_range( $first, $self->{dman}->row_count );
    my $coderef = $self->{rec_spinner_callback};
    &$coderef($self);
}

#parameter $in_db is 0 or 1 :
# 0 we are reading from the db, and the format to use are at the pos 0 and 1 in the array of format for the field
# 1 we are writing to the db and the format are to use in a revers order
# $id is the field id
# $v the date string from the form (if in_db is 1) or from the db (if in_db is 0)
sub _format_date {
    my ( $self, $in_db, $id, $v ) = @_;
    $self->{log}->debug( "format_date received date: " . $v );
    my ( $pos1, $pos2 ) = ( $in_db ? ( 1, 0 ) : ( 0, 1 ) );
    my $format = $self->{date_formatters}->{$id}->[$pos1];
    my $f      = $self->_get_dateformatter($format);
    my $dt     = $f->parse_datetime($v) or croak( $f->errmsg );
    $self->{log}->debug( "format_date:  date time object ymd: " . $dt->ymd );
    $format = $self->{date_formatters}->{$id}->[$pos2];
    $f      = $self->_get_dateformatter($format);
    my $r = $f->format_datetime($dt) or croak( $f->errmsg );
    $self->{log}->debug( "format_date formatted date: " . $r );

    return $r;

}

# create a formatter if none is found in the hash for the corresponding formatting string and store it for later use, and return it or
# return an existing formatter
sub _get_dateformatter {
    my ( $self, $format ) = @_;
    my %hf = %{ $self->{dates_formatters} };
    my $f;
    if ( exists $hf{$format} ) {
        $self->{log}->debug(
            "get_dateformatter : return an existing formatter for " . $format );
        $f = $hf{$format};
    } else {
        $self->{log}
          ->debug( "get_dateformatter: new formatter for " . $format );
        $f = new DateTime::Format::Strptime(
            pattern   => $format,
            locale    => $self->{locale},
            time_zone => $self->{time_zone},
            on_error  => 'undef',
        );
        $hf{$format} = $f;

    }
    $self->{dates_formatters} = \%hf;
    return $f;
}

=head2 C<get_data_manager>

Returns the data manager to be queried

=cut

sub get_data_manager {
    return shift->{dman};
}

1;
__END__

=head1 SUPPORT

Any Gk2::Ex::DbLinker questions or problems can be posted to me (rappazf) on my gmail account.  

The current state of the source can be extract using Mercurial from
L<http://sourceforge.net/projects/gtk2-ex-dblinker/>.

=head1 AUTHOR

FranE<ccedil>ois Rappaz <rappazf@gmail.com>

=head1 COPYRIGHT

Copyright (c) 2014 by F. Rappaz.  All rights reserved.
This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

=head1 SEE ALSO

L<Gtk2::Ex::DbLinker> L<Wx::Perl::DbLinker>.

=cut

