#!/usr/bin/perl

$mregex = q/(?:aj|emb)/;

while (<>) {
    # --- lines starting with "aj.." or "emb..." ?
    next unless /^($mregex\w+).*\(.*\)/o;

    $method = $1;
    push (@methods, $method);

    # --- the following line starts with "AjP..." ?
    $_ = <>;
    next unless /^\s*AjP(\w+)/;

    $class = $1;

    push @{ $all{$class} }, $method;
}

$thistime = gmtime();
print <<EOF;
package Bio::Emboss::Methods;

# automatically generated by $0 on $thistime

# This file defines the methods that are available for certain classes
# (i.e. certain EMBOSS types "AjP...")
#
# If an EMBOSS library function has an AjP... type as a first parameter,
# this function can be used as a method on that data type.
#
# This information is extracted from .xs files by "$0"
#
# Bio::Emboss.pm can EXPORT several functions on request into the callers
# namespace. Lists of functions are created for some EXPORT tags.


EOF

# --- make aliases in the symbol table

foreach $class (sort keys %all) {
    ## print "## package Bio::Emboss::$class;\n";

    my $arr = $all{$class};

    foreach $method (@$arr) {
## sub $method { Bio::Emboss::$method (\@_); }
	print <<EOF;
*Bio::Emboss::${class}::$method = *Bio::Emboss::$method;
EOF
    }
    print "\n";
}

print "# --- list all methods of EMBOSS for the EXPORT :all tag\n\n";

print "\@ALL_METHODS = qw(\n";

foreach $method (@methods){
    print "\t", $method, "\n";
}

print "\t);\n\n";


print "# --- list ajAcdGet... methods of EMBOSS for the EXPORT :acd tag\n\n";

print "\@ACD_METHODS = qw(\n";

foreach $method (@methods){
    next unless $method =~ /^ajAcdGet/;

    print "\t", $method, "\n";
}

print "\t);\n\n";


print "1;\n"
