# NAME

Statistics::Cook - Statistics::Cook

# VERSION

version 0.0.1

# SYNOPSIS

    use Statistics::Cook;
    my @x = qw/1 2 3 4 5 6/;
    my @y = qw/1 2.1 3.2 4 7 6/;
    my $sc = Statistics::Cook->new(x => \@x, y => \@y);
    ($intercept, $slope) = $sc->coefficients;
    my @predictedYs = $sc->fitted;
    my @residuals = $sc->residuals;
    my @cooks = $sc->cooks_distance;

# DESCRIPTION

The Statistics::Cook module is used to calculate cook distance of Least squares line fit does weighted
or unweighted to two-dimensional data (y = a + b \* x). (This is also called linear regression.)
In addition to the slope and y-intercept, the module, the predicted y values and the
residuals of the y values. (See the METHODS section for a description of these statistics.)

The module accepts input data in separate x and y arrays. The optional weights are input in a separate array
The module is state-oriented and caches its results. you can call the other methods in any order
or call a method several times without invoking redundant calculations.

# NAME

Statistics::Cook - calculate cook distance of Least squares line fit

# LIMITATIONS

The purpose of I write this module is that I could not find a module to calculate cook distance in CPAN,
Therefore I just realized a minimized function of least squares and cook distance in this module

# ATTRIBUTES

## x

## y

## weight

## slope

## intercept

## regress\_done

# METHODS

## \_trigger\_x

## \_trigger\_y

## regress

## computeSums

## coefficients

## fitted

## residuals

## cooks\_distance

## N

# AUTHOR

Yan Xueqing &lt;yanxueqing621@163.com>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Yan Xueqing.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
