use strict;
use warnings;

use Test::More;
use HTML::Video::Embed;

my $embeder = new HTML::Video::Embed({
    class => "test-video",
});

is( $embeder->url_to_embed('http://www.liveleak.com/view?i=ffc_1272800490'),
    '<iframe class="test-video" src="http://www.liveleak.com/ll_embed?i=ffc_1272800490" frameborder="0" allowFullScreen="1"></iframe>',
    'liveleak embed works'
);

is( $embeder->url_to_embed('http://www.liveleak.com/view?i=ffc_12728770049090'), undef, 'invalid i=');
is( $embeder->url_to_embed('http://www.liveleak.com/view?v=ffc_12728004900'), undef, 'no i=');
is( $embeder->url_to_embed('http://www.l1veleak.com/view?i=ffc_12728004900'), undef, 'domain check');

done_testing;
