#
# $Id: Makefile.PL 1395 2015-09-14 21:16:13Z willem $	-*-perl-*-
#


warn <<AMEN if $] < 5.008;

Net::DNS::SEC has been tested with Perl 5.8

The author is confident that this package will work with version 5.6
but not confident that it will work with any earlier version.

The latest version of perl can always be found at:
	http://www.cpan.org/src/latest.tar.gz
AMEN


use ExtUtils::MakeMaker;

# See perldoc ExtUtils::MakeMaker for details of how to influence
# the contents of the Makefile that is written.

my %metadata = (
	NAME		 => 'Net::DNS::SEC',
	VERSION_FROM	 => 'lib/Net/DNS/SEC.pm',
	ABSTRACT_FROM	 => 'lib/Net/DNS/SEC.pm',
	AUTHOR		 => ['Olaf Kolkman', 'Dick Franks'],
	LICENSE		 => 'mit',
	MIN_PERL_VERSION => 5.006,
	);


my %prerequisite = (
	Crypt::OpenSSL::Bignum => 0.04,
	Crypt::OpenSSL::DSA    => 0.14,
	Crypt::OpenSSL::RSA    => 0.27,
	File::Spec	       => 0.86,
	MIME::Base64	       => 2.11,
	);


my %optional = (
	Crypt::OpenSSL::EC     => 1.01,
	Crypt::OpenSSL::ECDSA  => 0.06,
	Crypt::OpenSSL::Random => 0.06,
	Digest::GOST	       => 0.06,
	Digest::SHA	       => 5.23,
	);

foreach my $module ( keys %optional ) {	## check optional module availability
	delete $optional{$module} unless eval "require $module";
}


my %test_requires = (			## not actioned by all CPAN clients
	Net::DNS   => 1.01,		## required for complete test
	Test::More => 0.47,
	);

# otherwise add dependency or use existing Net::DNS to perform partial test
%optional = ( %optional, %test_requires ) unless eval "require Net::DNS";


WriteMakefile(				## version check & end-user metadata
	PREREQ_PM => {%prerequisite, %optional},
	%metadata
	);


local $SIG{__WARN__} = sub { };		## suppress repeated warnings

WriteMakefile(				## Makefile & distribution metadata
	NO_MYMETA     => 1,
	PREREQ_PM     => {%prerequisite},
	TEST_REQUIRES => {%test_requires},
	%metadata
	);


sub MY::libscan {
	my $path = $_[1];
	return '' if $path =~ /\B\.svn\b/;
	return $path;
}


__END__

