##-*- Mode: CPerl -*-

## File: DDC::Utils.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: various utilities
##======================================================================

package DDC::Utils;
use Exporter;
use strict;

##======================================================================
## Globals etc.
our @ISA = qw(Exporter);
our @EXPORT = qw();
our %EXPORT_TAGS =
  (
   'escape' => [qw(unescape unescapeq escape escapeq)],
  );
$EXPORT_TAGS{all} = [map {@$_} values %EXPORT_TAGS];
our @EXPORT_OK = @{$EXPORT_TAGS{all}};

##======================================================================
## escapes

## $sym = unescape($escaped_symbol);
sub unescape {
  my $s = shift;
  if (0) {
    ##-- unsafe but elegant
    return eval '"'.quotemeta($s).'"';
  }
  ##-- safer but klutzy
  $s =~ s/\\([0-7]{1,3})/chr(oct($1))/eg;
  $s =~ s/\\x([0-9A-Fa-f]{1,2})/chr(hex($1))/eg;
  $s =~ s/\\u([0-9A-Fa-f]{1,4})/chr(hex($1))/eg;
  $s =~ s/\\a/\a/g;
  $s =~ s/\\b/\b/g;
  $s =~ s/\\t/\t/g;
  $s =~ s/\\n/\n/g;
  $s =~ s/\\r/\r/g;
  $s =~ s/\\f/\f/g;
  #$s =~ s/\\v/\v/g;
  $s =~ s/\\(.)/$1/g;
  return $s;
}

## $sym = unescapeq($single_quoted_symbol);
sub unescapeq {
  my $sym = shift;
  $sym =~ s/^\'//;
  $sym =~ s/\'\z//;
  return unescape($sym);
}

## $escaped_str = escape($str);
sub escape {
  return quotemeta($_[0]);
}

## $sq_escaped_str = escapeq($str);
sub escapeq {
  my $s = shift;
  return $s if ($s =~ /^[\w\-][\w\-\~\$\@\/\?\+\.]*\z/);
  $s =~ s/\\/\\\\/g;
  $s =~ s/\'/\\\'/g;
  $s =~ s/\n/\\n/g;
  $s =~ s/\r/\\r/g;
  $s =~ s/\t/\\t/g;
  return "'$s'";
}

1; ##-- be happy

