use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    isa_ok exception { bif(qw/ show hub /) }, 'OptArgs::Usage';

    isa_ok exception { bif(qw/ show hub local/) },
      'Bif::Error::UserRepoNotFound';

    bif(qw/init/);

    isa_ok exception { bif(qw/ show hub unknown /) }, 'Bif::Error::HubNotFound';

    bif(qw/new hub name title/);
    isa_ok bif(qw/ show hub name/), 'Bif::OK::ShowHub';

    bif(qw/new hub name2 title2 location1 location2/);
    isa_ok bif(qw/ show hub name2/), 'Bif::OK::ShowHub';

};

done_testing();
