CREATE TABLE func_import_update_project(
    uuid VARCHAR(40) NOT NULL,
    parent_uuid VARCHAR(40),
    project_status_uuid VARCHAR(40),
    name VARCHAR(40),
    title VARCHAR(1024),
    hub_uuid VARCHAR(40)
);


CREATE TRIGGER
    func_import_update_project_bi_1
BEFORE INSERT ON
    func_import_update_project
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.parent_uuid,
        NEW.project_status_uuid,
        NEW.name,
        NEW.title,
        NEW.hub_uuid
    );

    INSERT INTO
        func_update_project(
            change_id,
            id,
            parent_id,
            project_status_id,
            name,
            title,
            hub_id
        )
    SELECT
        currval('changes'),
        p.id,
        pp.id,
        s.id,
        NEW.name,
        NEW.title,
        h.id
    FROM
        nodes p
    LEFT JOIN
        nodes pp
    ON
        pp.uuid = NEW.parent_uuid
    LEFT JOIN
        nodes s
    ON
        s.uuid = NEW.project_status_uuid
    LEFT JOIN
        nodes h
    ON
        h.uuid = NEW.hub_uuid
    WHERE
        p.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
