package App::bif::update;
use strict;
use warnings;
use Bif::Mo;
use OptArgs 'class_optargs';

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $info = $self->get_node( $self->uuid2id( $opts->{id} ) );

    my ( $class, $newopts ) = class_optargs(
        'App::bif',
        'update',
        $info->{kind},
        $info->{id},
        $opts->{status} ? $opts->{status} : (),
        {
            $opts->{message} ? ( message => $opts->{message} ) : (),
            $opts->{title}   ? ( title   => $opts->{title} )   : (),
        },
    );

    return $self->dispatch( $class, opts => $newopts );
}

1;
__END__

=head1 NAME

=for bif-doc #modify

bif-update - change or comment a node

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif update ID [STATUS] [OPTIONS...]

=head1 DESCRIPTION

Add a comment to a node, possibly setting a new status at the same
time. Valid values for a nodes's status depend on the projects it is
associated with. The list of valid status for a project can be found
using L<bif-list-status>(1).

=head1 ARGUMENTS

=over

=item ID

A node ID, a node ID.UPDATE_ID, or project PATH. Required.

=item STATUS

The new status for the node. The status cannot be set when commenting
as a reply to another change.

=back

=head1 OPTIONS

=over

=item --title, -t

The new title for the node.  The title cannot be set when commenting as
a reply to another change.

=item --message, -m

The message describing this issue in detail. If this option is not used
an editor will be invoked.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

