package App::bif::push;
use strict;
use warnings;
use Bif::Mo;
use OptArgs 'class_optargs';

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $info = $self->get_node( $self->uuid2id( $opts->{id} ) );

    my ( $class, $newopts ) =
      class_optargs( 'App::bif', 'push', $info->{kind}, $info->{id},
        $opts->{destination},
        { $opts->{message} ? ( message => $opts->{message} ) : (), },
      );

    return $self->dispatch( $class, opts => $newopts );
}

1;
__END__

=head1 NAME

=for bif-doc #modify

bif-push - link a topic or project with another object

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif push ID DESTINATION [OPTIONS...]

=head1 DESCRIPTION

The B<bif-push> command is used to link two items together. Usually the
source and destination items are one of the following combinations:

    ID                  DESTINATION
    ------------------  -----------
    topic(issue)        project
    project             hub
    hub                 location

Pushing an topic (usually an issue) for example "shares" that node with
another project.  Comments made in any project for that issue will
appear everywhere else, but status changes are project-specific. In
order for that to be possible however, the destination project must
already be cooperating with all of the projects already associated with
the issue.

See each bif-push-* specific command documentation for details.

=head1 ARGUMENTS

=over

=item ID

A node ID or project PATH. Required.

=item DESTINATION

The target node to link ID with or a destination .

=back

=head1 OPTIONS

=over

=item --message, -m

The message to record with this particular change.

=back

=head1 SEE ALSO

L<bif-push-topic>(1), L<bif-push-project>, L<bif-push-hub>

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

