#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Point_3b__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__x = -1;
static int32_t FIELD_ID_TestCase__Point_3b__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__y = -1;
static int32_t FIELD_ID_TestCase__Point_3b__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__z = -1;
static int32_t FIELD_ID_TestCase__Point_3d__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__x = -1;
static int32_t FIELD_ID_TestCase__Point_3d__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__y = -1;
static int32_t FIELD_ID_TestCase__Point_3d__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__z = -1;
static int32_t FIELD_ID_TestCase__Point_3f__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__x = -1;
static int32_t FIELD_ID_TestCase__Point_3f__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__y = -1;
static int32_t FIELD_ID_TestCase__Point_3f__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__z = -1;
static int32_t FIELD_ID_TestCase__Point_3i__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__x = -1;
static int32_t FIELD_ID_TestCase__Point_3i__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__y = -1;
static int32_t FIELD_ID_TestCase__Point_3i__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__z = -1;
static int32_t FIELD_ID_TestCase__Point_3l__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__x = -1;
static int32_t FIELD_ID_TestCase__Point_3l__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__y = -1;
static int32_t FIELD_ID_TestCase__Point_3l__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__z = -1;
static int32_t FIELD_ID_TestCase__Point_3s__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__x = -1;
static int32_t FIELD_ID_TestCase__Point_3s__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__y = -1;
static int32_t FIELD_ID_TestCase__Point_3s__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__z = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_TestCase__Ref__pass_value_ref_byte = - 1;
static int32_t SUB_ID_TestCase__Ref__pass_value_ref_double = - 1;
static int32_t SUB_ID_TestCase__Ref__pass_value_ref_float = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_TestCase__Ref__pass_value_ref_int = - 1;
static int32_t SUB_ID_TestCase__Ref__pass_value_ref_long = - 1;
static int32_t SUB_ID_TestCase__Ref__pass_value_ref_short = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(TestCase::Point_3b,TestCase::Point_3b,&TestCase::Point_3b)
int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(TestCase::Point_3d,TestCase::Point_3d,&TestCase::Point_3d)
int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(TestCase::Point_3f,TestCase::Point_3f,&TestCase::Point_3f)
int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(TestCase::Point_3i,TestCase::Point_3i,&TestCase::Point_3i)
int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(TestCase::Point_3l,TestCase::Point_3l,&TestCase::Point_3l)
int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(TestCase::Point_3s,TestCase::Point_3s,&TestCase::Point_3s)
int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_short(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 11;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[1];
L5: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L6: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L8: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L11: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[4];
L12: // SET_DEREF_BYTE
  *(int8_t*)*(void**)&ref_vars[0] = byte_vars[3];
L13: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L20: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L21: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L23: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L26: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // BOOL_INT
  int_vars[0] = int_vars[2];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[3];
L34: // GOTO
  goto L37;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L36: // BOOL_INT
  int_vars[0] = int_vars[4];
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L41: // GOTO
  goto L42;
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L3: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L4: // REF_DOUBLE
  *(void**)&ref_vars[0] = &double_vars[1];
L5: // GET_DEREF_DOUBLE
  double_vars[0] = *(double*)*(void**)&ref_vars[0];
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L10: // ADD_DOUBLE
  double_vars[4] = double_vars[2] + double_vars[3];
L11: // MOVE_DOUBLE
  double_vars[5] = double_vars[4];
L12: // SET_DEREF_DOUBLE
  *(double*)*(void**)&ref_vars[0] = double_vars[5];
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 99;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L18: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 99;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L22: // ADD_DOUBLE
  double_vars[4] = double_vars[2] + double_vars[3];
L23: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[4]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  float float_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L3: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L4: // REF_FLOAT
  *(void**)&ref_vars[0] = &float_vars[1];
L5: // GET_DEREF_FLOAT
  float_vars[0] = *(float*)*(void**)&ref_vars[0];
L6: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 81;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[2];
L10: // ADD_FLOAT
  float_vars[4] = float_vars[2] + float_vars[3];
L11: // MOVE_FLOAT
  float_vars[5] = float_vars[4];
L12: // SET_DEREF_FLOAT
  *(float*)*(void**)&ref_vars[0] = float_vars[5];
L13: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L18: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[2];
L22: // ADD_FLOAT
  float_vars[4] = float_vars[2] + float_vars[3];
L23: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[4]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[1];
L3: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L5: // SET_DEREF_INT
  *(int32_t*)*(void**)&ref_vars[0] = int_vars[4];
L6: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L7: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L11: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[4]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // GOTO
  goto L19;
L17: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L18: // BOOL_INT
  int_vars[0] = int_vars[5];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[6];
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L31;
L26: // GOTO
  goto L27;
L27: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L31;
L29: // INIT_INT
  int_vars[8] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L31;
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L3: // MOVE_LONG
  long_vars[1] = long_vars[0];
L4: // REF_LONG
  *(void**)&ref_vars[0] = &long_vars[1];
L5: // GET_DEREF_LONG
  long_vars[0] = *(int64_t*)*(void**)&ref_vars[0];
L6: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L10: // ADD_LONG
  long_vars[4] = long_vars[2] + long_vars[3];
L11: // MOVE_LONG
  long_vars[5] = long_vars[4];
L12: // SET_DEREF_LONG
  *(int64_t*)*(void**)&ref_vars[0] = long_vars[5];
L13: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L15: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L18: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L22: // ADD_LONG
  long_vars[4] = long_vars[2] + long_vars[3];
L23: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[4]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__numeric_ref_deref_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 27;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L3: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L4: // REF_SHORT
  *(void**)&ref_vars[0] = &short_vars[1];
L5: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[0];
L6: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 33;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L8: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L11: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[4];
L12: // SET_DEREF_SHORT
  *(int16_t*)*(void**)&ref_vars[0] = short_vars[3];
L13: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L20: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L21: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "numeric_ref_deref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L23: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L26: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // BOOL_INT
  int_vars[0] = int_vars[2];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[3];
L34: // GOTO
  goto L37;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L36: // BOOL_INT
  int_vars[0] = int_vars[4];
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L41: // GOTO
  goto L42;
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[9];
  char convert_string_buffer[21];
  // Copy arguments to variables
  byte_vars[0] = *(int8_t*)&stack[0];
  byte_vars[1] = *(int8_t*)&stack[1];
  byte_vars[2] = *(int8_t*)&stack[2];
  byte_vars[3] = *(int8_t*)&stack[3];
  byte_vars[4] = *(int8_t*)&stack[4];
  byte_vars[5] = *(int8_t*)&stack[5];
  ref_vars[0] = *(void**)&stack[6];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_GET_FIELD_BYTE
  byte_vars[6] = byte_vars[0];
L2: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[6];
L3: // MULNUM_GET_FIELD_BYTE
  byte_vars[7] = byte_vars[3];
L4: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[7];
L5: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L6: // CONVERT_INT_TO_BYTE
  byte_vars[8] = (int8_t)int_vars[3];
L7: // MULNUM_DEREF_SET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&value_ref[0] = *(int8_t*)&byte_vars[8];
  }
L8: // MULNUM_GET_FIELD_BYTE
  byte_vars[6] = byte_vars[1];
L9: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[6];
L10: // MULNUM_GET_FIELD_BYTE
  byte_vars[7] = byte_vars[4];
L11: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[7];
L12: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L13: // CONVERT_INT_TO_BYTE
  byte_vars[8] = (int8_t)int_vars[4];
L14: // MULNUM_DEREF_SET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&value_ref[1] = *(int8_t*)&byte_vars[8];
  }
L15: // MULNUM_GET_FIELD_BYTE
  byte_vars[6] = byte_vars[2];
L16: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[6];
L17: // MULNUM_GET_FIELD_BYTE
  byte_vars[7] = byte_vars[5];
L18: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[7];
L19: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L20: // CONVERT_INT_TO_BYTE
  byte_vars[8] = (int8_t)int_vars[4];
L21: // MULNUM_DEREF_SET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&value_ref[2] = *(int8_t*)&byte_vars[8];
  }
L22: // RETURN_VOID
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[9];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  double_vars[0] = *(double*)&stack[0];
  double_vars[1] = *(double*)&stack[1];
  double_vars[2] = *(double*)&stack[2];
  double_vars[3] = *(double*)&stack[3];
  double_vars[4] = *(double*)&stack[4];
  double_vars[5] = *(double*)&stack[5];
  ref_vars[0] = *(void**)&stack[6];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L2: // MULNUM_GET_FIELD_DOUBLE
  double_vars[7] = double_vars[3];
L3: // ADD_DOUBLE
  double_vars[8] = double_vars[6] + double_vars[7];
L4: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[0] = *(double*)&double_vars[8];
  }
L5: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L6: // MULNUM_GET_FIELD_DOUBLE
  double_vars[7] = double_vars[4];
L7: // ADD_DOUBLE
  double_vars[8] = double_vars[6] + double_vars[7];
L8: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[1] = *(double*)&double_vars[8];
  }
L9: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[2];
L10: // MULNUM_GET_FIELD_DOUBLE
  double_vars[7] = double_vars[5];
L11: // ADD_DOUBLE
  double_vars[8] = double_vars[6] + double_vars[7];
L12: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[2] = *(double*)&double_vars[8];
  }
L13: // RETURN_VOID
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  float float_vars[9];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  float_vars[0] = *(float*)&stack[0];
  float_vars[1] = *(float*)&stack[1];
  float_vars[2] = *(float*)&stack[2];
  float_vars[3] = *(float*)&stack[3];
  float_vars[4] = *(float*)&stack[4];
  float_vars[5] = *(float*)&stack[5];
  ref_vars[0] = *(void**)&stack[6];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L2: // MULNUM_GET_FIELD_FLOAT
  float_vars[7] = float_vars[3];
L3: // ADD_FLOAT
  float_vars[8] = float_vars[6] + float_vars[7];
L4: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[0] = *(float*)&float_vars[8];
  }
L5: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L6: // MULNUM_GET_FIELD_FLOAT
  float_vars[7] = float_vars[4];
L7: // ADD_FLOAT
  float_vars[8] = float_vars[6] + float_vars[7];
L8: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[1] = *(float*)&float_vars[8];
  }
L9: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[2];
L10: // MULNUM_GET_FIELD_FLOAT
  float_vars[7] = float_vars[5];
L11: // ADD_FLOAT
  float_vars[8] = float_vars[6] + float_vars[7];
L12: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[2] = *(float*)&float_vars[8];
  }
L13: // RETURN_VOID
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];
  int_vars[3] = *(int32_t*)&stack[2];
  int_vars[4] = *(int32_t*)&stack[3];
  int_vars[5] = *(int32_t*)&stack[4];
  int_vars[6] = *(int32_t*)&stack[5];
  ref_vars[0] = *(void**)&stack[6];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_GET_FIELD_INT
  int_vars[7] = int_vars[1];
L2: // MULNUM_GET_FIELD_INT
  int_vars[8] = int_vars[4];
L3: // ADD_INT
  int_vars[9] = int_vars[7] + int_vars[8];
L4: // MOVE_INT
  int_vars[10] = int_vars[9];
L5: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[0] = *(int32_t*)&int_vars[10];
  }
L6: // MULNUM_GET_FIELD_INT
  int_vars[8] = int_vars[2];
L7: // MULNUM_GET_FIELD_INT
  int_vars[9] = int_vars[5];
L8: // ADD_INT
  int_vars[10] = int_vars[8] + int_vars[9];
L9: // MOVE_INT
  int_vars[11] = int_vars[10];
L10: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[1] = *(int32_t*)&int_vars[11];
  }
L11: // MULNUM_GET_FIELD_INT
  int_vars[8] = int_vars[3];
L12: // MULNUM_GET_FIELD_INT
  int_vars[9] = int_vars[6];
L13: // ADD_INT
  int_vars[10] = int_vars[8] + int_vars[9];
L14: // MOVE_INT
  int_vars[11] = int_vars[10];
L15: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[2] = *(int32_t*)&int_vars[11];
  }
L16: // RETURN_VOID
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[10];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  long_vars[0] = *(int64_t*)&stack[0];
  long_vars[1] = *(int64_t*)&stack[1];
  long_vars[2] = *(int64_t*)&stack[2];
  long_vars[3] = *(int64_t*)&stack[3];
  long_vars[4] = *(int64_t*)&stack[4];
  long_vars[5] = *(int64_t*)&stack[5];
  ref_vars[0] = *(void**)&stack[6];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_GET_FIELD_LONG
  long_vars[6] = long_vars[0];
L2: // MULNUM_GET_FIELD_LONG
  long_vars[7] = long_vars[3];
L3: // ADD_LONG
  long_vars[8] = long_vars[6] + long_vars[7];
L4: // MOVE_LONG
  long_vars[9] = long_vars[8];
L5: // MULNUM_DEREF_SET_FIELD_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&value_ref[0] = *(int64_t*)&long_vars[9];
  }
L6: // MULNUM_GET_FIELD_LONG
  long_vars[6] = long_vars[1];
L7: // MULNUM_GET_FIELD_LONG
  long_vars[7] = long_vars[4];
L8: // ADD_LONG
  long_vars[8] = long_vars[6] + long_vars[7];
L9: // MOVE_LONG
  long_vars[9] = long_vars[8];
L10: // MULNUM_DEREF_SET_FIELD_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&value_ref[1] = *(int64_t*)&long_vars[9];
  }
L11: // MULNUM_GET_FIELD_LONG
  long_vars[6] = long_vars[2];
L12: // MULNUM_GET_FIELD_LONG
  long_vars[7] = long_vars[5];
L13: // ADD_LONG
  long_vars[8] = long_vars[6] + long_vars[7];
L14: // MOVE_LONG
  long_vars[9] = long_vars[8];
L15: // MULNUM_DEREF_SET_FIELD_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&value_ref[2] = *(int64_t*)&long_vars[9];
  }
L16: // RETURN_VOID
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__pass_value_ref_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[9];
  char convert_string_buffer[21];
  // Copy arguments to variables
  short_vars[0] = *(int16_t*)&stack[0];
  short_vars[1] = *(int16_t*)&stack[1];
  short_vars[2] = *(int16_t*)&stack[2];
  short_vars[3] = *(int16_t*)&stack[3];
  short_vars[4] = *(int16_t*)&stack[4];
  short_vars[5] = *(int16_t*)&stack[5];
  ref_vars[0] = *(void**)&stack[6];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_GET_FIELD_SHORT
  short_vars[6] = short_vars[0];
L2: // CONVERT_SHORT_TO_INT
  int_vars[1] = (int32_t)short_vars[6];
L3: // MULNUM_GET_FIELD_SHORT
  short_vars[7] = short_vars[3];
L4: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[7];
L5: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L6: // CONVERT_INT_TO_SHORT
  short_vars[8] = (int16_t)int_vars[3];
L7: // MULNUM_DEREF_SET_FIELD_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&value_ref[0] = *(int16_t*)&short_vars[8];
  }
L8: // MULNUM_GET_FIELD_SHORT
  short_vars[6] = short_vars[1];
L9: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[6];
L10: // MULNUM_GET_FIELD_SHORT
  short_vars[7] = short_vars[4];
L11: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[7];
L12: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L13: // CONVERT_INT_TO_SHORT
  short_vars[8] = (int16_t)int_vars[4];
L14: // MULNUM_DEREF_SET_FIELD_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&value_ref[1] = *(int16_t*)&short_vars[8];
  }
L15: // MULNUM_GET_FIELD_SHORT
  short_vars[6] = short_vars[2];
L16: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[6];
L17: // MULNUM_GET_FIELD_SHORT
  short_vars[7] = short_vars[5];
L18: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[7];
L19: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L20: // CONVERT_INT_TO_SHORT
  short_vars[8] = (int16_t)int_vars[4];
L21: // MULNUM_DEREF_SET_FIELD_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&value_ref[2] = *(int16_t*)&short_vars[8];
  }
L22: // RETURN_VOID
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[11];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_BYTE
  byte_vars[0] = 0;
  byte_vars[1] = 0;
  byte_vars[2] = 0;
L2: // INIT_MULNUM_BYTE
  byte_vars[3] = 0;
  byte_vars[4] = 0;
  byte_vars[5] = 0;
L3: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[6] = *(int8_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L5: // MULNUM_SET_FIELD_BYTE
  byte_vars[3] = byte_vars[6];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // CONVERT_INT_TO_BYTE
  byte_vars[6] = (int8_t)int_vars[2];
L8: // MULNUM_SET_FIELD_BYTE
  byte_vars[4] = byte_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // CONVERT_INT_TO_BYTE
  byte_vars[6] = (int8_t)int_vars[2];
L11: // MULNUM_SET_FIELD_BYTE
  byte_vars[5] = byte_vars[6];
L12: // INIT_MULNUM_BYTE
  byte_vars[7] = 0;
  byte_vars[8] = 0;
  byte_vars[9] = 0;
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // CONVERT_INT_TO_BYTE
  byte_vars[6] = (int8_t)int_vars[2];
L15: // MULNUM_SET_FIELD_BYTE
  byte_vars[7] = byte_vars[6];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[6] = (int8_t)int_vars[2];
L18: // MULNUM_SET_FIELD_BYTE
  byte_vars[8] = byte_vars[6];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L20: // CONVERT_INT_TO_BYTE
  byte_vars[6] = (int8_t)int_vars[2];
L21: // MULNUM_SET_FIELD_BYTE
  byte_vars[9] = byte_vars[6];
L22: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[0];
L23: // PUSH_ARG_MULNUM_BYTE
  *(int8_t*)&stack[0] = byte_vars[3];
  *(int8_t*)&stack[1] = byte_vars[4];
  *(int8_t*)&stack[2] = byte_vars[5];
L24: // PUSH_ARG_MULNUM_BYTE
  *(int8_t*)&stack[3] = byte_vars[7];
  *(int8_t*)&stack[4] = byte_vars[8];
  *(int8_t*)&stack[5] = byte_vars[9];
L25: // PUSH_ARG_REF
  *(void**)&stack[6] = ref_vars[0];
L26: // CALL_SUB_VOID
  // TestCase::Ref->pass_value_ref_byte
  {
    if (SUB_ID_TestCase__Ref__pass_value_ref_byte < 0) {
      SUB_ID_TestCase__Ref__pass_value_ref_byte = env->get_sub_id(env, "TestCase::Ref", "pass_value_ref_byte", "void(TestCase::Point_3b,TestCase::Point_3b,&TestCase::Point_3b)");
      if (SUB_ID_TestCase__Ref__pass_value_ref_byte < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Ref pass_value_ref_byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Ref__pass_value_ref_byte;
    exception_flag = SPPRECOMPILE__TestCase__Ref__pass_value_ref_byte(env, stack);
    if (!exception_flag) {
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L28: // MULNUM_GET_FIELD_BYTE
  byte_vars[6] = byte_vars[0];
L29: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[6];
L30: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[10] = *(int8_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 172;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L32: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[10];
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L34: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L35: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L50; }
L38: // MULNUM_GET_FIELD_BYTE
  byte_vars[6] = byte_vars[1];
L39: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[6];
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L41: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L45: // BOOL_INT
  int_vars[0] = int_vars[2];
L46: // GOTO
  goto L49;
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L48: // BOOL_INT
  int_vars[0] = int_vars[3];
L49: // GOTO
  goto L52;
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L51: // BOOL_INT
  int_vars[0] = int_vars[4];
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L54: // MULNUM_GET_FIELD_BYTE
  byte_vars[6] = byte_vars[2];
L55: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[6];
L56: // MOVE_CONSTANT_INT
  int_vars[3] = 7;
L57: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L61: // BOOL_INT
  int_vars[0] = int_vars[2];
L62: // GOTO
  goto L65;
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L64: // BOOL_INT
  int_vars[0] = int_vars[3];
L65: // GOTO
  goto L68;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L67: // BOOL_INT
  int_vars[0] = int_vars[4];
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L72: // GOTO
  goto L73;
L73: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L77;
L75: // INIT_INT
  int_vars[6] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L77;
L77: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[11];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
  double_vars[2] = 0;
L2: // INIT_MULNUM_DOUBLE
  double_vars[3] = 0;
  double_vars[4] = 0;
  double_vars[5] = 0;
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[6] = 0.25;
L4: // MULNUM_SET_FIELD_DOUBLE
  double_vars[3] = double_vars[6];
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[6] = 0.5;
L6: // MULNUM_SET_FIELD_DOUBLE
  double_vars[4] = double_vars[6];
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[6] = 0.125;
L8: // MULNUM_SET_FIELD_DOUBLE
  double_vars[5] = double_vars[6];
L9: // INIT_MULNUM_DOUBLE
  double_vars[7] = 0;
  double_vars[8] = 0;
  double_vars[9] = 0;
L10: // MOVE_CONSTANT_DOUBLE
  double_vars[6] = 0.25;
L11: // MULNUM_SET_FIELD_DOUBLE
  double_vars[7] = double_vars[6];
L12: // MOVE_CONSTANT_DOUBLE
  double_vars[6] = 0.5;
L13: // MULNUM_SET_FIELD_DOUBLE
  double_vars[8] = double_vars[6];
L14: // MOVE_CONSTANT_DOUBLE
  double_vars[6] = 0.125;
L15: // MULNUM_SET_FIELD_DOUBLE
  double_vars[9] = double_vars[6];
L16: // REF_DOUBLE
  *(void**)&ref_vars[0] = &double_vars[0];
L17: // PUSH_ARG_MULNUM_DOUBLE
  *(double*)&stack[0] = double_vars[3];
  *(double*)&stack[1] = double_vars[4];
  *(double*)&stack[2] = double_vars[5];
L18: // PUSH_ARG_MULNUM_DOUBLE
  *(double*)&stack[3] = double_vars[7];
  *(double*)&stack[4] = double_vars[8];
  *(double*)&stack[5] = double_vars[9];
L19: // PUSH_ARG_REF
  *(void**)&stack[6] = ref_vars[0];
L20: // CALL_SUB_VOID
  // TestCase::Ref->pass_value_ref_double
  {
    if (SUB_ID_TestCase__Ref__pass_value_ref_double < 0) {
      SUB_ID_TestCase__Ref__pass_value_ref_double = env->get_sub_id(env, "TestCase::Ref", "pass_value_ref_double", "void(TestCase::Point_3d,TestCase::Point_3d,&TestCase::Point_3d)");
      if (SUB_ID_TestCase__Ref__pass_value_ref_double < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Ref pass_value_ref_double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Ref__pass_value_ref_double;
    exception_flag = SPPRECOMPILE__TestCase__Ref__pass_value_ref_double(env, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 560;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L22: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L23: // MOVE_CONSTANT_DOUBLE
  double_vars[10] = 0.5;
L24: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[10]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L27: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L29: // CONVERT_INT_TO_DOUBLE
  double_vars[10] = (double)int_vars[2];
L30: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[10]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // BOOL_INT
  int_vars[0] = int_vars[2];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // GOTO
  goto L41;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // BOOL_INT
  int_vars[0] = int_vars[4];
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L43: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[2];
L44: // MOVE_CONSTANT_DOUBLE
  double_vars[10] = 0.25;
L45: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[10]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L49: // BOOL_INT
  int_vars[0] = int_vars[2];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L52: // BOOL_INT
  int_vars[0] = int_vars[3];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[4];
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L61; }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L65;
L60: // GOTO
  goto L61;
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L65;
L63: // INIT_INT
  int_vars[6] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L65;
L65: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[2];
  float float_vars[11];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_FLOAT
  float_vars[0] = 0;
  float_vars[1] = 0;
  float_vars[2] = 0;
L2: // INIT_MULNUM_FLOAT
  float_vars[3] = 0;
  float_vars[4] = 0;
  float_vars[5] = 0;
L3: // MOVE_CONSTANT_FLOAT
  float_vars[6] = 0.25;
L4: // MULNUM_SET_FIELD_FLOAT
  float_vars[3] = float_vars[6];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[6] = 0.5;
L6: // MULNUM_SET_FIELD_FLOAT
  float_vars[4] = float_vars[6];
L7: // MOVE_CONSTANT_FLOAT
  float_vars[6] = 0.125;
L8: // MULNUM_SET_FIELD_FLOAT
  float_vars[5] = float_vars[6];
L9: // INIT_MULNUM_FLOAT
  float_vars[7] = 0;
  float_vars[8] = 0;
  float_vars[9] = 0;
L10: // MOVE_CONSTANT_FLOAT
  float_vars[6] = 0.25;
L11: // MULNUM_SET_FIELD_FLOAT
  float_vars[7] = float_vars[6];
L12: // MOVE_CONSTANT_FLOAT
  float_vars[6] = 0.5;
L13: // MULNUM_SET_FIELD_FLOAT
  float_vars[8] = float_vars[6];
L14: // MOVE_CONSTANT_FLOAT
  float_vars[6] = 0.125;
L15: // MULNUM_SET_FIELD_FLOAT
  float_vars[9] = float_vars[6];
L16: // REF_FLOAT
  *(void**)&ref_vars[0] = &float_vars[0];
L17: // PUSH_ARG_MULNUM_FLOAT
  *(float*)&stack[0] = float_vars[3];
  *(float*)&stack[1] = float_vars[4];
  *(float*)&stack[2] = float_vars[5];
L18: // PUSH_ARG_MULNUM_FLOAT
  *(float*)&stack[3] = float_vars[7];
  *(float*)&stack[4] = float_vars[8];
  *(float*)&stack[5] = float_vars[9];
L19: // PUSH_ARG_REF
  *(void**)&stack[6] = ref_vars[0];
L20: // CALL_SUB_VOID
  // TestCase::Ref->pass_value_ref_float
  {
    if (SUB_ID_TestCase__Ref__pass_value_ref_float < 0) {
      SUB_ID_TestCase__Ref__pass_value_ref_float = env->get_sub_id(env, "TestCase::Ref", "pass_value_ref_float", "void(TestCase::Point_3f,TestCase::Point_3f,&TestCase::Point_3f)");
      if (SUB_ID_TestCase__Ref__pass_value_ref_float < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Ref pass_value_ref_float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Ref__pass_value_ref_float;
    exception_flag = SPPRECOMPILE__TestCase__Ref__pass_value_ref_float(env, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 499;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L67;
  }
L22: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L23: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L24: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L25: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L28: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // CONVERT_INT_TO_FLOAT
  float_vars[10] = (float)int_vars[2];
L31: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[10]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L35: // BOOL_INT
  int_vars[0] = int_vars[2];
L36: // GOTO
  goto L39;
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L38: // BOOL_INT
  int_vars[0] = int_vars[3];
L39: // GOTO
  goto L42;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L44: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[2];
L45: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L46: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L47: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // BOOL_INT
  int_vars[0] = int_vars[2];
L52: // GOTO
  goto L55;
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // BOOL_INT
  int_vars[0] = int_vars[3];
L55: // GOTO
  goto L58;
L56: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L57: // BOOL_INT
  int_vars[0] = int_vars[4];
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L67;
L62: // GOTO
  goto L63;
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L67;
L65: // INIT_INT
  int_vars[6] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L67;
L67: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[17];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_INT
  int_vars[1] = 0;
  int_vars[2] = 0;
  int_vars[3] = 0;
L2: // INIT_MULNUM_INT
  int_vars[5] = 0;
  int_vars[6] = 0;
  int_vars[7] = 0;
L3: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L5: // MULNUM_SET_FIELD_INT
  int_vars[5] = int_vars[8];
L6: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L7: // MULNUM_SET_FIELD_INT
  int_vars[6] = int_vars[8];
L8: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L9: // MULNUM_SET_FIELD_INT
  int_vars[7] = int_vars[8];
L10: // INIT_MULNUM_INT
  int_vars[9] = 0;
  int_vars[10] = 0;
  int_vars[11] = 0;
L11: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L12: // MULNUM_SET_FIELD_INT
  int_vars[9] = int_vars[8];
L13: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L14: // MULNUM_SET_FIELD_INT
  int_vars[10] = int_vars[8];
L15: // MOVE_CONSTANT_INT
  int_vars[8] = 5;
L16: // MULNUM_SET_FIELD_INT
  int_vars[11] = int_vars[8];
L17: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[1];
L18: // PUSH_ARG_MULNUM_INT
  *(int32_t*)&stack[0] = int_vars[5];
  *(int32_t*)&stack[1] = int_vars[6];
  *(int32_t*)&stack[2] = int_vars[7];
L19: // PUSH_ARG_MULNUM_INT
  *(int32_t*)&stack[3] = int_vars[9];
  *(int32_t*)&stack[4] = int_vars[10];
  *(int32_t*)&stack[5] = int_vars[11];
L20: // PUSH_ARG_REF
  *(void**)&stack[6] = ref_vars[0];
L21: // CALL_SUB_VOID
  // TestCase::Ref->pass_value_ref_int
  {
    if (SUB_ID_TestCase__Ref__pass_value_ref_int < 0) {
      SUB_ID_TestCase__Ref__pass_value_ref_int = env->get_sub_id(env, "TestCase::Ref", "pass_value_ref_int", "void(TestCase::Point_3i,TestCase::Point_3i,&TestCase::Point_3i)");
      if (SUB_ID_TestCase__Ref__pass_value_ref_int < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Ref pass_value_ref_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Ref__pass_value_ref_int;
    exception_flag = SPPRECOMPILE__TestCase__Ref__pass_value_ref_int(env, stack);
    if (!exception_flag) {
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L23: // MULNUM_GET_FIELD_INT
  int_vars[8] = int_vars[1];
L24: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[12] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 345;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[13] = 3;
L27: // ADD_INT
  int_vars[14] = int_vars[12] + int_vars[13];
L28: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[14]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L31: // MULNUM_GET_FIELD_INT
  int_vars[8] = int_vars[2];
L32: // MOVE_CONSTANT_INT
  int_vars[12] = 5;
L33: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[12]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L37: // BOOL_INT
  int_vars[0] = int_vars[8];
L38: // GOTO
  goto L41;
L39: // MOVE_CONSTANT_INT
  int_vars[12] = 0;
L40: // BOOL_INT
  int_vars[0] = int_vars[12];
L41: // GOTO
  goto L44;
L42: // MOVE_CONSTANT_INT
  int_vars[13] = 0;
L43: // BOOL_INT
  int_vars[0] = int_vars[13];
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L46: // MULNUM_GET_FIELD_INT
  int_vars[8] = int_vars[3];
L47: // MOVE_CONSTANT_INT
  int_vars[12] = 7;
L48: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[12]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[8];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[12] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[12];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[13] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[13];
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L68;
L63: // GOTO
  goto L64;
L64: // MOVE_CONSTANT_INT
  int_vars[13] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[13];
  goto L68;
L66: // INIT_INT
  int_vars[15] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[15];
  goto L68;
L68: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[13];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_LONG
  long_vars[0] = 0;
  long_vars[1] = 0;
  long_vars[2] = 0;
L2: // INIT_MULNUM_LONG
  long_vars[3] = 0;
  long_vars[4] = 0;
  long_vars[5] = 0;
L3: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[6] = *(int64_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 412;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L76;
  }
L5: // MULNUM_SET_FIELD_LONG
  long_vars[3] = long_vars[6];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[2];
L8: // MULNUM_SET_FIELD_LONG
  long_vars[4] = long_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[2];
L11: // MULNUM_SET_FIELD_LONG
  long_vars[5] = long_vars[6];
L12: // INIT_MULNUM_LONG
  long_vars[7] = 0;
  long_vars[8] = 0;
  long_vars[9] = 0;
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[2];
L15: // MULNUM_SET_FIELD_LONG
  long_vars[7] = long_vars[6];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L17: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[2];
L18: // MULNUM_SET_FIELD_LONG
  long_vars[8] = long_vars[6];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L20: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[2];
L21: // MULNUM_SET_FIELD_LONG
  long_vars[9] = long_vars[6];
L22: // REF_LONG
  *(void**)&ref_vars[0] = &long_vars[0];
L23: // PUSH_ARG_MULNUM_LONG
  *(int64_t*)&stack[0] = long_vars[3];
  *(int64_t*)&stack[1] = long_vars[4];
  *(int64_t*)&stack[2] = long_vars[5];
L24: // PUSH_ARG_MULNUM_LONG
  *(int64_t*)&stack[3] = long_vars[7];
  *(int64_t*)&stack[4] = long_vars[8];
  *(int64_t*)&stack[5] = long_vars[9];
L25: // PUSH_ARG_REF
  *(void**)&stack[6] = ref_vars[0];
L26: // CALL_SUB_VOID
  // TestCase::Ref->pass_value_ref_long
  {
    if (SUB_ID_TestCase__Ref__pass_value_ref_long < 0) {
      SUB_ID_TestCase__Ref__pass_value_ref_long = env->get_sub_id(env, "TestCase::Ref", "pass_value_ref_long", "void(TestCase::Point_3l,TestCase::Point_3l,&TestCase::Point_3l)");
      if (SUB_ID_TestCase__Ref__pass_value_ref_long < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Ref pass_value_ref_long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Ref__pass_value_ref_long;
    exception_flag = SPPRECOMPILE__TestCase__Ref__pass_value_ref_long(env, stack);
    if (!exception_flag) {
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L76;
  }
L28: // MULNUM_GET_FIELD_LONG
  long_vars[6] = long_vars[0];
L29: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[10] = *(int64_t*)&stack[0];
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L76;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L32: // CONVERT_INT_TO_LONG
  long_vars[11] = (int64_t)int_vars[2];
L33: // ADD_LONG
  long_vars[12] = long_vars[10] + long_vars[11];
L34: // EQ_LONG
  int_vars[0] = (long_vars[6] == long_vars[12]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L37: // MULNUM_GET_FIELD_LONG
  long_vars[6] = long_vars[1];
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L39: // CONVERT_INT_TO_LONG
  long_vars[10] = (int64_t)int_vars[2];
L40: // EQ_LONG
  int_vars[0] = (long_vars[6] == long_vars[10]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L44: // BOOL_INT
  int_vars[0] = int_vars[2];
L45: // GOTO
  goto L48;
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L47: // BOOL_INT
  int_vars[0] = int_vars[3];
L48: // GOTO
  goto L51;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // BOOL_INT
  int_vars[0] = int_vars[4];
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L53: // MULNUM_GET_FIELD_LONG
  long_vars[6] = long_vars[2];
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L55: // CONVERT_INT_TO_LONG
  long_vars[10] = (int64_t)int_vars[2];
L56: // EQ_LONG
  int_vars[0] = (long_vars[6] == long_vars[10]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L62; }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L60: // BOOL_INT
  int_vars[0] = int_vars[2];
L61: // GOTO
  goto L64;
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L63: // BOOL_INT
  int_vars[0] = int_vars[3];
L64: // GOTO
  goto L67;
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L66: // BOOL_INT
  int_vars[0] = int_vars[4];
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L76;
L71: // GOTO
  goto L72;
L72: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L76;
L74: // INIT_INT
  int_vars[6] = 0;
L75: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L76;
L76: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__test_pass_value_ref_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[11];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_SHORT
  short_vars[0] = 0;
  short_vars[1] = 0;
  short_vars[2] = 0;
L2: // INIT_MULNUM_SHORT
  short_vars[3] = 0;
  short_vars[4] = 0;
  short_vars[5] = 0;
L3: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[6] = *(int16_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L5: // MULNUM_SET_FIELD_SHORT
  short_vars[3] = short_vars[6];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // CONVERT_INT_TO_SHORT
  short_vars[6] = (int16_t)int_vars[2];
L8: // MULNUM_SET_FIELD_SHORT
  short_vars[4] = short_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // CONVERT_INT_TO_SHORT
  short_vars[6] = (int16_t)int_vars[2];
L11: // MULNUM_SET_FIELD_SHORT
  short_vars[5] = short_vars[6];
L12: // INIT_MULNUM_SHORT
  short_vars[7] = 0;
  short_vars[8] = 0;
  short_vars[9] = 0;
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // CONVERT_INT_TO_SHORT
  short_vars[6] = (int16_t)int_vars[2];
L15: // MULNUM_SET_FIELD_SHORT
  short_vars[7] = short_vars[6];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L17: // CONVERT_INT_TO_SHORT
  short_vars[6] = (int16_t)int_vars[2];
L18: // MULNUM_SET_FIELD_SHORT
  short_vars[8] = short_vars[6];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L20: // CONVERT_INT_TO_SHORT
  short_vars[6] = (int16_t)int_vars[2];
L21: // MULNUM_SET_FIELD_SHORT
  short_vars[9] = short_vars[6];
L22: // REF_SHORT
  *(void**)&ref_vars[0] = &short_vars[0];
L23: // PUSH_ARG_MULNUM_SHORT
  *(int16_t*)&stack[0] = short_vars[3];
  *(int16_t*)&stack[1] = short_vars[4];
  *(int16_t*)&stack[2] = short_vars[5];
L24: // PUSH_ARG_MULNUM_SHORT
  *(int16_t*)&stack[3] = short_vars[7];
  *(int16_t*)&stack[4] = short_vars[8];
  *(int16_t*)&stack[5] = short_vars[9];
L25: // PUSH_ARG_REF
  *(void**)&stack[6] = ref_vars[0];
L26: // CALL_SUB_VOID
  // TestCase::Ref->pass_value_ref_short
  {
    if (SUB_ID_TestCase__Ref__pass_value_ref_short < 0) {
      SUB_ID_TestCase__Ref__pass_value_ref_short = env->get_sub_id(env, "TestCase::Ref", "pass_value_ref_short", "void(TestCase::Point_3s,TestCase::Point_3s,&TestCase::Point_3s)");
      if (SUB_ID_TestCase__Ref__pass_value_ref_short < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Ref pass_value_ref_short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Ref__pass_value_ref_short;
    exception_flag = SPPRECOMPILE__TestCase__Ref__pass_value_ref_short(env, stack);
    if (!exception_flag) {
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L28: // MULNUM_GET_FIELD_SHORT
  short_vars[6] = short_vars[0];
L29: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[6];
L30: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[10] = *(int16_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "test_pass_value_ref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L32: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[10];
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L34: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L35: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L50; }
L38: // MULNUM_GET_FIELD_SHORT
  short_vars[6] = short_vars[1];
L39: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[6];
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L41: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L45: // BOOL_INT
  int_vars[0] = int_vars[2];
L46: // GOTO
  goto L49;
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L48: // BOOL_INT
  int_vars[0] = int_vars[3];
L49: // GOTO
  goto L52;
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L51: // BOOL_INT
  int_vars[0] = int_vars[4];
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L54: // MULNUM_GET_FIELD_SHORT
  short_vars[6] = short_vars[2];
L55: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[6];
L56: // MOVE_CONSTANT_INT
  int_vars[3] = 7;
L57: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L61: // BOOL_INT
  int_vars[0] = int_vars[2];
L62: // GOTO
  goto L65;
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L64: // BOOL_INT
  int_vars[0] = int_vars[3];
L65: // GOTO
  goto L68;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L67: // BOOL_INT
  int_vars[0] = int_vars[4];
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L72: // GOTO
  goto L73;
L73: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L77;
L75: // INIT_INT
  int_vars[6] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L77;
L77: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[8];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_BYTE
  byte_vars[0] = 0;
  byte_vars[1] = 0;
  byte_vars[2] = 0;
L2: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L4: // MULNUM_SET_FIELD_BYTE
  byte_vars[0] = byte_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L7: // MULNUM_SET_FIELD_BYTE
  byte_vars[1] = byte_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L10: // MULNUM_SET_FIELD_BYTE
  byte_vars[2] = byte_vars[3];
L11: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[0];
L12: // MULNUM_DEREF_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&byte_vars[4 + 0]  = *(int8_t*)&value_ref[0];
    *(int8_t*)&byte_vars[4 + 1]  = *(int8_t*)&value_ref[1];
    *(int8_t*)&byte_vars[4 + 2]  = *(int8_t*)&value_ref[2];
  }
L13: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[4];
L14: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L15: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[7] = *(int8_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L17: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[7];
L18: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L21: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[5];
L22: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // BOOL_INT
  int_vars[0] = int_vars[2];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[3];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[4];
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L37: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[6];
L38: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L40: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L44: // BOOL_INT
  int_vars[0] = int_vars[2];
L45: // GOTO
  goto L48;
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L47: // BOOL_INT
  int_vars[0] = int_vars[3];
L48: // GOTO
  goto L51;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // BOOL_INT
  int_vars[0] = int_vars[4];
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L60;
L55: // GOTO
  goto L56;
L56: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L60;
L58: // INIT_INT
  int_vars[6] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L60;
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
  double_vars[2] = 0;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L4: // MULNUM_SET_FIELD_DOUBLE
  double_vars[0] = double_vars[3];
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.5;
L6: // MULNUM_SET_FIELD_DOUBLE
  double_vars[1] = double_vars[3];
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.125;
L8: // MULNUM_SET_FIELD_DOUBLE
  double_vars[2] = double_vars[3];
L9: // REF_DOUBLE
  *(void**)&ref_vars[0] = &double_vars[0];
L10: // MULNUM_DEREF_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&double_vars[4 + 0]  = *(double*)&value_ref[0];
    *(double*)&double_vars[4 + 1]  = *(double*)&value_ref[1];
    *(double*)&double_vars[4 + 2]  = *(double*)&value_ref[2];
  }
L11: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[4];
L12: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[7] = *(double*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 273;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L14: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[7]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L17: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[5];
L18: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.5;
L19: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[7]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[2];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[3];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L32: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[6];
L33: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.125;
L34: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[7]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // BOOL_INT
  int_vars[0] = int_vars[2];
L39: // GOTO
  goto L42;
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[3];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[4];
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L54;
L49: // GOTO
  goto L50;
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L54;
L52: // INIT_INT
  int_vars[6] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L54;
L54: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[2];
  float float_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_FLOAT
  float_vars[0] = 0;
  float_vars[1] = 0;
  float_vars[2] = 0;
L2: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 438;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L4: // MULNUM_SET_FIELD_FLOAT
  float_vars[0] = float_vars[3];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.5;
L6: // MULNUM_SET_FIELD_FLOAT
  float_vars[1] = float_vars[3];
L7: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.125;
L8: // MULNUM_SET_FIELD_FLOAT
  float_vars[2] = float_vars[3];
L9: // REF_FLOAT
  *(void**)&ref_vars[0] = &float_vars[0];
L10: // MULNUM_DEREF_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&float_vars[4 + 0]  = *(float*)&value_ref[0];
    *(float*)&float_vars[4 + 1]  = *(float*)&value_ref[1];
    *(float*)&float_vars[4 + 2]  = *(float*)&value_ref[2];
  }
L11: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[4];
L12: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[7] = *(float*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 446;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L14: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[7]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L17: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[5];
L18: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[3];
L19: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L20: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[2];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[3];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L33: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[6];
L34: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[3];
L35: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.125;
L36: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L40: // BOOL_INT
  int_vars[0] = int_vars[2];
L41: // GOTO
  goto L44;
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L43: // BOOL_INT
  int_vars[0] = int_vars[3];
L44: // GOTO
  goto L47;
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L46: // BOOL_INT
  int_vars[0] = int_vars[4];
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L52; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L51: // GOTO
  goto L52;
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L54: // INIT_INT
  int_vars[6] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L56;
L56: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[7];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_BYTE
  byte_vars[0] = 0;
  byte_vars[1] = 0;
  byte_vars[2] = 0;
L2: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L4: // MULNUM_SET_FIELD_BYTE
  byte_vars[0] = byte_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L7: // MULNUM_SET_FIELD_BYTE
  byte_vars[1] = byte_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L10: // MULNUM_SET_FIELD_BYTE
  byte_vars[2] = byte_vars[3];
L11: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[0];
L12: // MULNUM_DEREF_GET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&byte_vars[3] = *(int8_t*)&value_ref[0];
  }
L13: // MULNUM_DEREF_GET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&byte_vars[4] = *(int8_t*)&value_ref[1];
  }
L14: // MULNUM_DEREF_GET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&byte_vars[5] = *(int8_t*)&value_ref[2];
  }
L15: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L16: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[6] = *(int8_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L18: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[6];
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L22: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[4];
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // BOOL_INT
  int_vars[0] = int_vars[2];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[3];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[4];
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L37: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[5];
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L39: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // BOOL_INT
  int_vars[0] = int_vars[2];
L44: // GOTO
  goto L47;
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L46: // BOOL_INT
  int_vars[0] = int_vars[3];
L47: // GOTO
  goto L50;
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L49: // BOOL_INT
  int_vars[0] = int_vars[4];
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L54: // GOTO
  goto L55;
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[7];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
  double_vars[2] = 0;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L4: // MULNUM_SET_FIELD_DOUBLE
  double_vars[0] = double_vars[3];
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.5;
L6: // MULNUM_SET_FIELD_DOUBLE
  double_vars[1] = double_vars[3];
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.125;
L8: // MULNUM_SET_FIELD_DOUBLE
  double_vars[2] = double_vars[3];
L9: // REF_DOUBLE
  *(void**)&ref_vars[0] = &double_vars[0];
L10: // MULNUM_DEREF_GET_FETCH_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&double_vars[3] = *(double*)&value_ref[0];
  }
L11: // MULNUM_DEREF_GET_FETCH_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&double_vars[4] = *(double*)&value_ref[1];
  }
L12: // MULNUM_DEREF_GET_FETCH_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&double_vars[5] = *(double*)&value_ref[2];
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[6] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[6]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L18: // MOVE_CONSTANT_DOUBLE
  double_vars[6] = 0.5;
L19: // EQ_DOUBLE
  int_vars[0] = (double_vars[4] == double_vars[6]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[2];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[3];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L32: // MOVE_CONSTANT_DOUBLE
  double_vars[6] = 0.125;
L33: // EQ_DOUBLE
  int_vars[0] = (double_vars[5] == double_vars[6]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // BOOL_INT
  int_vars[0] = int_vars[2];
L38: // GOTO
  goto L41;
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // BOOL_INT
  int_vars[0] = int_vars[3];
L41: // GOTO
  goto L44;
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L43: // BOOL_INT
  int_vars[0] = int_vars[4];
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L53;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L53;
L51: // INIT_INT
  int_vars[6] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L53;
L53: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[2];
  float float_vars[7];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_FLOAT
  float_vars[0] = 0;
  float_vars[1] = 0;
  float_vars[2] = 0;
L2: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L4: // MULNUM_SET_FIELD_FLOAT
  float_vars[0] = float_vars[3];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.5;
L6: // MULNUM_SET_FIELD_FLOAT
  float_vars[1] = float_vars[3];
L7: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.125;
L8: // MULNUM_SET_FIELD_FLOAT
  float_vars[2] = float_vars[3];
L9: // REF_FLOAT
  *(void**)&ref_vars[0] = &float_vars[0];
L10: // MULNUM_DEREF_GET_FETCH_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&float_vars[3] = *(float*)&value_ref[0];
  }
L11: // MULNUM_DEREF_GET_FETCH_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&float_vars[4] = *(float*)&value_ref[1];
  }
L12: // MULNUM_DEREF_GET_FETCH_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&float_vars[5] = *(float*)&value_ref[2];
  }
L13: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[6] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[6]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L18: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[4];
L19: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L20: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[2];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[3];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L33: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[5];
L34: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.125;
L35: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[2];
L40: // GOTO
  goto L43;
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[3];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[4];
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L55;
L50: // GOTO
  goto L51;
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L55;
L53: // INIT_INT
  int_vars[6] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L55;
L55: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[14];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_INT
  int_vars[1] = 0;
  int_vars[2] = 0;
  int_vars[3] = 0;
L2: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L4: // MULNUM_SET_FIELD_INT
  int_vars[1] = int_vars[5];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L6: // MULNUM_SET_FIELD_INT
  int_vars[2] = int_vars[5];
L7: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L8: // MULNUM_SET_FIELD_INT
  int_vars[3] = int_vars[5];
L9: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[1];
L10: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[5] = *(int32_t*)&value_ref[0];
  }
L11: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[6] = *(int32_t*)&value_ref[1];
  }
L12: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[7] = *(int32_t*)&value_ref[2];
  }
L13: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L15: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[8]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L18: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[8]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[8];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[9] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[9];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[10];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L32: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L33: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L37: // BOOL_INT
  int_vars[0] = int_vars[8];
L38: // GOTO
  goto L41;
L39: // MOVE_CONSTANT_INT
  int_vars[9] = 0;
L40: // BOOL_INT
  int_vars[0] = int_vars[9];
L41: // GOTO
  goto L44;
L42: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L43: // BOOL_INT
  int_vars[0] = int_vars[10];
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L53;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L53;
L51: // INIT_INT
  int_vars[12] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[12];
  goto L53;
L53: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[7];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_LONG
  long_vars[0] = 0;
  long_vars[1] = 0;
  long_vars[2] = 0;
L2: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 377;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L4: // MULNUM_SET_FIELD_LONG
  long_vars[0] = long_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L7: // MULNUM_SET_FIELD_LONG
  long_vars[1] = long_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L10: // MULNUM_SET_FIELD_LONG
  long_vars[2] = long_vars[3];
L11: // REF_LONG
  *(void**)&ref_vars[0] = &long_vars[0];
L12: // MULNUM_DEREF_GET_FETCH_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&long_vars[3] = *(int64_t*)&value_ref[0];
  }
L13: // MULNUM_DEREF_GET_FETCH_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&long_vars[4] = *(int64_t*)&value_ref[1];
  }
L14: // MULNUM_DEREF_GET_FETCH_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&long_vars[5] = *(int64_t*)&value_ref[2];
  }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[6] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 387;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L17: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[6]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[2];
L22: // EQ_LONG
  int_vars[0] = (long_vars[4] == long_vars[6]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[2];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[3];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L32: // BOOL_INT
  int_vars[0] = int_vars[4];
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[2];
L37: // EQ_LONG
  int_vars[0] = (long_vars[5] == long_vars[6]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // BOOL_INT
  int_vars[0] = int_vars[2];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[3];
L45: // GOTO
  goto L48;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L47: // BOOL_INT
  int_vars[0] = int_vars[4];
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L57;
L52: // GOTO
  goto L53;
L53: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L57;
L55: // INIT_INT
  int_vars[6] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L57;
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_get_field_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[7];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_SHORT
  short_vars[0] = 0;
  short_vars[1] = 0;
  short_vars[2] = 0;
L2: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 204;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L4: // MULNUM_SET_FIELD_SHORT
  short_vars[0] = short_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L7: // MULNUM_SET_FIELD_SHORT
  short_vars[1] = short_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L10: // MULNUM_SET_FIELD_SHORT
  short_vars[2] = short_vars[3];
L11: // REF_SHORT
  *(void**)&ref_vars[0] = &short_vars[0];
L12: // MULNUM_DEREF_GET_FETCH_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&short_vars[3] = *(int16_t*)&value_ref[0];
  }
L13: // MULNUM_DEREF_GET_FETCH_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&short_vars[4] = *(int16_t*)&value_ref[1];
  }
L14: // MULNUM_DEREF_GET_FETCH_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&short_vars[5] = *(int16_t*)&value_ref[2];
  }
L15: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L16: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[6] = *(int16_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_get_field_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 214;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L18: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[6];
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L22: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[4];
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // BOOL_INT
  int_vars[0] = int_vars[2];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[3];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[4];
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L37: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[5];
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L39: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // BOOL_INT
  int_vars[0] = int_vars[2];
L44: // GOTO
  goto L47;
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L46: // BOOL_INT
  int_vars[0] = int_vars[3];
L47: // GOTO
  goto L50;
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L49: // BOOL_INT
  int_vars[0] = int_vars[4];
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L54: // GOTO
  goto L55;
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[14];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_INT
  int_vars[1] = 0;
  int_vars[2] = 0;
  int_vars[3] = 0;
L2: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 282;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L4: // MULNUM_SET_FIELD_INT
  int_vars[1] = int_vars[5];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L6: // MULNUM_SET_FIELD_INT
  int_vars[2] = int_vars[5];
L7: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L8: // MULNUM_SET_FIELD_INT
  int_vars[3] = int_vars[5];
L9: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[1];
L10: // MULNUM_DEREF_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[6 + 0]  = *(int32_t*)&value_ref[0];
    *(int32_t*)&int_vars[6 + 1]  = *(int32_t*)&value_ref[1];
    *(int32_t*)&int_vars[6 + 2]  = *(int32_t*)&value_ref[2];
  }
L11: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[6];
L12: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[9] = *(int32_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L14: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[9]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L17: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[7];
L18: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[9]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[5];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[9] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[9];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[10];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L32: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[8];
L33: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L34: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[9]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L38: // BOOL_INT
  int_vars[0] = int_vars[5];
L39: // GOTO
  goto L42;
L40: // MOVE_CONSTANT_INT
  int_vars[9] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[9];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[10];
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L54;
L49: // GOTO
  goto L50;
L50: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L54;
L52: // INIT_INT
  int_vars[12] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[12];
  goto L54;
L54: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_LONG
  long_vars[0] = 0;
  long_vars[1] = 0;
  long_vars[2] = 0;
L2: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 360;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L4: // MULNUM_SET_FIELD_LONG
  long_vars[0] = long_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L7: // MULNUM_SET_FIELD_LONG
  long_vars[1] = long_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L10: // MULNUM_SET_FIELD_LONG
  long_vars[2] = long_vars[3];
L11: // REF_LONG
  *(void**)&ref_vars[0] = &long_vars[0];
L12: // MULNUM_DEREF_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&long_vars[4 + 0]  = *(int64_t*)&value_ref[0];
    *(int64_t*)&long_vars[4 + 1]  = *(int64_t*)&value_ref[1];
    *(int64_t*)&long_vars[4 + 2]  = *(int64_t*)&value_ref[2];
  }
L13: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[4];
L14: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[7] = *(int64_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L16: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[7]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L19: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[5];
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // CONVERT_INT_TO_LONG
  long_vars[7] = (int64_t)int_vars[2];
L22: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[7]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[2];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[3];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L32: // BOOL_INT
  int_vars[0] = int_vars[4];
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L35: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[6];
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L37: // CONVERT_INT_TO_LONG
  long_vars[7] = (int64_t)int_vars[2];
L38: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[7]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // BOOL_INT
  int_vars[0] = int_vars[2];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[3];
L46: // GOTO
  goto L49;
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L48: // BOOL_INT
  int_vars[0] = int_vars[4];
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L58;
L53: // GOTO
  goto L54;
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L58;
L56: // INIT_INT
  int_vars[6] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L58;
L58: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[5];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_BYTE
  byte_vars[0] = 0;
  byte_vars[1] = 0;
  byte_vars[2] = 0;
L2: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[0];
L3: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 147;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L5: // MULNUM_SET_FIELD_BYTE
  byte_vars[0] = byte_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L8: // MULNUM_SET_FIELD_BYTE
  byte_vars[1] = byte_vars[3];
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L11: // MULNUM_SET_FIELD_BYTE
  byte_vars[2] = byte_vars[3];
L12: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[0];
L13: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[4] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_byte";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 151;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[4];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L20: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[1];
L21: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L23: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L36: // MULNUM_GET_FIELD_BYTE
  byte_vars[3] = byte_vars[2];
L37: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L39: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // BOOL_INT
  int_vars[0] = int_vars[2];
L44: // GOTO
  goto L47;
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L46: // BOOL_INT
  int_vars[0] = int_vars[3];
L47: // GOTO
  goto L50;
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L49: // BOOL_INT
  int_vars[0] = int_vars[4];
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L54: // GOTO
  goto L55;
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
  double_vars[2] = 0;
L2: // REF_DOUBLE
  *(void**)&ref_vars[0] = &double_vars[0];
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L5: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[0] = *(double*)&double_vars[3];
  }
L6: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.5;
L7: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[1] = *(double*)&double_vars[3];
  }
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.125;
L9: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[2] = *(double*)&double_vars[3];
  }
L10: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[0];
L11: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_double";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L13: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[4]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L16: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[1];
L17: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.5;
L18: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[4]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // BOOL_INT
  int_vars[0] = int_vars[2];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[3];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[4];
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L31: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[2];
L32: // MOVE_CONSTANT_DOUBLE
  double_vars[4] = 0.125;
L33: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[4]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // BOOL_INT
  int_vars[0] = int_vars[2];
L38: // GOTO
  goto L41;
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // BOOL_INT
  int_vars[0] = int_vars[3];
L41: // GOTO
  goto L44;
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L43: // BOOL_INT
  int_vars[0] = int_vars[4];
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L53;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L53;
L51: // INIT_INT
  int_vars[6] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L53;
L53: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[2];
  float float_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_FLOAT
  float_vars[0] = 0;
  float_vars[1] = 0;
  float_vars[2] = 0;
L2: // REF_FLOAT
  *(void**)&ref_vars[0] = &float_vars[0];
L3: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 476;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L5: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[0] = *(float*)&float_vars[3];
  }
L6: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.5;
L7: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[1] = *(float*)&float_vars[3];
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.125;
L9: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[2] = *(float*)&float_vars[3];
  }
L10: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[0];
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_float";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L13: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[4]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L16: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[1];
L17: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[3];
L18: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L19: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[2];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[3];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L32: // MULNUM_GET_FIELD_FLOAT
  float_vars[3] = float_vars[2];
L33: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[3];
L34: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.125;
L35: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[2];
L40: // GOTO
  goto L43;
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[3];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[4];
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L55;
L50: // GOTO
  goto L51;
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L55;
L53: // INIT_INT
  int_vars[6] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L55;
L55: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_INT
  int_vars[1] = 0;
  int_vars[2] = 0;
  int_vars[3] = 0;
L2: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[1];
L3: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 320;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L5: // MULNUM_SET_FIELD_INT
  int_vars[1] = int_vars[5];
L6: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L7: // MULNUM_SET_FIELD_INT
  int_vars[2] = int_vars[5];
L8: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L9: // MULNUM_SET_FIELD_INT
  int_vars[3] = int_vars[5];
L10: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[1];
L11: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_int";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L13: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L16: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L18: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // BOOL_INT
  int_vars[0] = int_vars[5];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[6];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[7];
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L31: // MULNUM_GET_FIELD_INT
  int_vars[5] = int_vars[3];
L32: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L33: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L37: // BOOL_INT
  int_vars[0] = int_vars[5];
L38: // GOTO
  goto L41;
L39: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L40: // BOOL_INT
  int_vars[0] = int_vars[6];
L41: // GOTO
  goto L44;
L42: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L43: // BOOL_INT
  int_vars[0] = int_vars[7];
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L53;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L53;
L51: // INIT_INT
  int_vars[9] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L53;
L53: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_LONG
  long_vars[0] = 0;
  long_vars[1] = 0;
  long_vars[2] = 0;
L2: // REF_LONG
  *(void**)&ref_vars[0] = &long_vars[0];
L3: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 398;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L5: // MULNUM_SET_FIELD_LONG
  long_vars[0] = long_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L8: // MULNUM_SET_FIELD_LONG
  long_vars[1] = long_vars[3];
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L11: // MULNUM_SET_FIELD_LONG
  long_vars[2] = long_vars[3];
L12: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[0];
L13: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[4] = *(int64_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_long";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L15: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[4]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L18: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[1];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L21: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[4]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L34: // MULNUM_GET_FIELD_LONG
  long_vars[3] = long_vars[2];
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L36: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[2];
L37: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[4]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // BOOL_INT
  int_vars[0] = int_vars[2];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[3];
L45: // GOTO
  goto L48;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L47: // BOOL_INT
  int_vars[0] = int_vars[4];
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L57;
L52: // GOTO
  goto L53;
L53: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L57;
L55: // INIT_INT
  int_vars[6] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L57;
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_set_field_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[5];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_SHORT
  short_vars[0] = 0;
  short_vars[1] = 0;
  short_vars[2] = 0;
L2: // REF_SHORT
  *(void**)&ref_vars[0] = &short_vars[0];
L3: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 225;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L5: // MULNUM_SET_FIELD_SHORT
  short_vars[0] = short_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L8: // MULNUM_SET_FIELD_SHORT
  short_vars[1] = short_vars[3];
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L11: // MULNUM_SET_FIELD_SHORT
  short_vars[2] = short_vars[3];
L12: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[0];
L13: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[4] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_set_field_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 229;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[4];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L20: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[1];
L21: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L23: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L36: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[2];
L37: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L39: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // BOOL_INT
  int_vars[0] = int_vars[2];
L44: // GOTO
  goto L47;
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L46: // BOOL_INT
  int_vars[0] = int_vars[3];
L47: // GOTO
  goto L50;
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L49: // BOOL_INT
  int_vars[0] = int_vars[4];
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L54: // GOTO
  goto L55;
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Ref__value_ref_deref_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[8];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_SHORT
  short_vars[0] = 0;
  short_vars[1] = 0;
  short_vars[2] = 0;
L2: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 187;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L4: // MULNUM_SET_FIELD_SHORT
  short_vars[0] = short_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L7: // MULNUM_SET_FIELD_SHORT
  short_vars[1] = short_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L10: // MULNUM_SET_FIELD_SHORT
  short_vars[2] = short_vars[3];
L11: // REF_SHORT
  *(void**)&ref_vars[0] = &short_vars[0];
L12: // MULNUM_DEREF_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&short_vars[4 + 0]  = *(int16_t*)&value_ref[0];
    *(int16_t*)&short_vars[4 + 1]  = *(int16_t*)&value_ref[1];
    *(int16_t*)&short_vars[4 + 2]  = *(int16_t*)&value_ref[2];
  }
L13: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[4];
L14: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L15: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[7] = *(int16_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Ref";
    const char* sub_name = "value_ref_deref_short";
    const char* file = "TestCase/Ref.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L17: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[7];
L18: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L21: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[5];
L22: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // BOOL_INT
  int_vars[0] = int_vars[2];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[3];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[4];
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L37: // MULNUM_GET_FIELD_SHORT
  short_vars[3] = short_vars[6];
L38: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L40: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L44: // BOOL_INT
  int_vars[0] = int_vars[2];
L45: // GOTO
  goto L48;
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L47: // BOOL_INT
  int_vars[0] = int_vars[3];
L48: // GOTO
  goto L51;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // BOOL_INT
  int_vars[0] = int_vars[4];
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L60;
L55: // GOTO
  goto L56;
L56: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L60;
L58: // INIT_INT
  int_vars[6] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L60;
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


