#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Sort__sortb = - 1;
static int32_t SUB_ID_SPVM__Util__equals_barray = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Sort__sortd = - 1;
static int32_t SUB_ID_SPVM__Util__equals_darray = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Sort__sortf = - 1;
static int32_t SUB_ID_SPVM__Util__equals_farray = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Sort__sorti = - 1;
static int32_t SUB_ID_SPVM__Util__equals_iarray = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Sort__sortl = - 1;
static int32_t SUB_ID_SPVM__Util__equals_larray = - 1;
static int32_t SUB_ID_TestCase__Minimal__newp = - 1;
static int32_t SUB_ID_SPVM__Sort__sorto = - 1;
static int32_t SUB_ID_SPVM__EqualityChecker__SameObject__new = - 1;
static int32_t SUB_ID_SPVM__Util__equals_oarray = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_SPVM__Sort__sorts = - 1;
static int32_t SUB_ID_SPVM__Util__equals_sarray = - 1;
static int32_t SUB_ID_SPVM__Sort__sortstr = - 1;
static int32_t SUB_ID_SPVM__Util__equals_strarray = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_double = -1;
static int32_t BASIC_TYPE_ID_float = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_anon0 = -1;
static int32_t BASIC_TYPE_ID_short = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortd(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sorti(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortl(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sorto(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sorts(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortstr(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[18];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[8];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = -7;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L16: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L20: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L23: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[3];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[9] = 127;
L26: // CONVERT_INT_TO_BYTE
  byte_vars[4] = (int8_t)int_vars[9];
L27: // MOVE_CONSTANT_INT
  int_vars[10] = 4;
L28: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[4];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[11] = 15;
L31: // CONVERT_INT_TO_BYTE
  byte_vars[5] = (int8_t)int_vars[11];
L32: // MOVE_CONSTANT_INT
  int_vars[12] = 5;
L33: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[5];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[13] = 19;
L36: // CONVERT_INT_TO_BYTE
  byte_vars[6] = (int8_t)int_vars[13];
L37: // MOVE_CONSTANT_INT
  int_vars[14] = 6;
L38: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[14];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[6];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L44: // CALL_SUB_VOID
  // SPVM::Sort->sortb
  {
    if (SUB_ID_SPVM__Sort__sortb < 0) {
      SUB_ID_SPVM__Sort__sortb = env->get_sub_id(env, "SPVM::Sort", "sortb", "void(byte[])");
      if (SUB_ID_SPVM__Sort__sortb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Sort sortb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Sort__sortb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L48: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L50: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L52: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[4] = -7;
L57: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[4];
L58: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L59: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L62: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[6];
L63: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[3];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[8] = 9;
L67: // CONVERT_INT_TO_BYTE
  byte_vars[4] = (int8_t)int_vars[8];
L68: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L69: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[4];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[10] = 15;
L72: // CONVERT_INT_TO_BYTE
  byte_vars[5] = (int8_t)int_vars[10];
L73: // MOVE_CONSTANT_INT
  int_vars[11] = 4;
L74: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[5];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[12] = 19;
L77: // CONVERT_INT_TO_BYTE
  byte_vars[6] = (int8_t)int_vars[12];
L78: // MOVE_CONSTANT_INT
  int_vars[13] = 5;
L79: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[6];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[14] = 127;
L82: // CONVERT_INT_TO_BYTE
  byte_vars[7] = (int8_t)int_vars[14];
L83: // MOVE_CONSTANT_INT
  int_vars[15] = 6;
L84: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[7];
      } 
    } 
  } 
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L88: // CALL_SUB_INT
  // SPVM::Util->equals_barray
  {
    if (SUB_ID_SPVM__Util__equals_barray < 0) {
      SUB_ID_SPVM__Util__equals_barray = env->get_sub_id(env, "SPVM::Util", "equals_barray", "int(byte[],byte[])");
      if (SUB_ID_SPVM__Util__equals_barray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_barray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_barray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[16] = *(int32_t*)&stack[0];
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortb";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L90: // BOOL_INT
  int_vars[0] = int_vars[16];
L91: // IF_NE_ZERO
  if (int_vars[0]) { goto L96; }
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L93: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L102;
L95: // GOTO
  goto L96;
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L99: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L102;
L100: // INIT_INT
  int_vars[6] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L102;
L102: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L103: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortd(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[7];
  int32_t int_vars[18];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L6: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = -7;
L11: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L16: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L20: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L23: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[3];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[9] = 127;
L26: // CONVERT_INT_TO_DOUBLE
  double_vars[4] = (double)int_vars[9];
L27: // MOVE_CONSTANT_INT
  int_vars[10] = 4;
L28: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[4];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[11] = 15;
L31: // CONVERT_INT_TO_DOUBLE
  double_vars[5] = (double)int_vars[11];
L32: // MOVE_CONSTANT_INT
  int_vars[12] = 5;
L33: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[5];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[13] = 19;
L36: // CONVERT_INT_TO_DOUBLE
  double_vars[6] = (double)int_vars[13];
L37: // MOVE_CONSTANT_INT
  int_vars[14] = 6;
L38: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[14];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[6];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L44: // CALL_SUB_VOID
  // SPVM::Sort->sortd
  {
    if (SUB_ID_SPVM__Sort__sortd < 0) {
      SUB_ID_SPVM__Sort__sortd = env->get_sub_id(env, "SPVM::Sort", "sortd", "void(double[])");
      if (SUB_ID_SPVM__Sort__sortd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Sort sortd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Sort__sortd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L48: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = -7;
L51: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[3];
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L53: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L55: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L58: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L61: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[6];
L62: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L63: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[8] = 9;
L66: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[8];
L67: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L68: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[3];
      } 
    } 
  } 
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L70: // MOVE_CONSTANT_INT
  int_vars[10] = 15;
L71: // CONVERT_INT_TO_DOUBLE
  double_vars[4] = (double)int_vars[10];
L72: // MOVE_CONSTANT_INT
  int_vars[11] = 4;
L73: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[4];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L75: // MOVE_CONSTANT_INT
  int_vars[12] = 19;
L76: // CONVERT_INT_TO_DOUBLE
  double_vars[5] = (double)int_vars[12];
L77: // MOVE_CONSTANT_INT
  int_vars[13] = 5;
L78: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[5];
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[14] = 127;
L81: // CONVERT_INT_TO_DOUBLE
  double_vars[6] = (double)int_vars[14];
L82: // MOVE_CONSTANT_INT
  int_vars[15] = 6;
L83: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[6];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L87: // CALL_SUB_INT
  // SPVM::Util->equals_darray
  {
    if (SUB_ID_SPVM__Util__equals_darray < 0) {
      SUB_ID_SPVM__Util__equals_darray = env->get_sub_id(env, "SPVM::Util", "equals_darray", "int(double[],double[])");
      if (SUB_ID_SPVM__Util__equals_darray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_darray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_darray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[16] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortd";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[16];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L101;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L98: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L101;
L99: // INIT_INT
  int_vars[6] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L101;
L101: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L102: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[7];
  int32_t int_vars[18];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L6: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = -7;
L11: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L16: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L20: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L23: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[3];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[9] = 127;
L26: // CONVERT_INT_TO_FLOAT
  float_vars[4] = (float)int_vars[9];
L27: // MOVE_CONSTANT_INT
  int_vars[10] = 4;
L28: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[4];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[11] = 15;
L31: // CONVERT_INT_TO_FLOAT
  float_vars[5] = (float)int_vars[11];
L32: // MOVE_CONSTANT_INT
  int_vars[12] = 5;
L33: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[5];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[13] = 19;
L36: // CONVERT_INT_TO_FLOAT
  float_vars[6] = (float)int_vars[13];
L37: // MOVE_CONSTANT_INT
  int_vars[14] = 6;
L38: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[14];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[6];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L44: // CALL_SUB_VOID
  // SPVM::Sort->sortf
  {
    if (SUB_ID_SPVM__Sort__sortf < 0) {
      SUB_ID_SPVM__Sort__sortf = env->get_sub_id(env, "SPVM::Sort", "sortf", "void(float[])");
      if (SUB_ID_SPVM__Sort__sortf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Sort sortf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Sort__sortf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 63;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L48: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = -7;
L51: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[3];
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L53: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L55: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L58: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L61: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[6];
L62: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L63: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[8] = 9;
L66: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[8];
L67: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L68: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[3];
      } 
    } 
  } 
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L70: // MOVE_CONSTANT_INT
  int_vars[10] = 15;
L71: // CONVERT_INT_TO_FLOAT
  float_vars[4] = (float)int_vars[10];
L72: // MOVE_CONSTANT_INT
  int_vars[11] = 4;
L73: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[4];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L75: // MOVE_CONSTANT_INT
  int_vars[12] = 19;
L76: // CONVERT_INT_TO_FLOAT
  float_vars[5] = (float)int_vars[12];
L77: // MOVE_CONSTANT_INT
  int_vars[13] = 5;
L78: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[5];
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[14] = 127;
L81: // CONVERT_INT_TO_FLOAT
  float_vars[6] = (float)int_vars[14];
L82: // MOVE_CONSTANT_INT
  int_vars[15] = 6;
L83: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[6];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L87: // CALL_SUB_INT
  // SPVM::Util->equals_farray
  {
    if (SUB_ID_SPVM__Util__equals_farray < 0) {
      SUB_ID_SPVM__Util__equals_farray = env->get_sub_id(env, "SPVM::Util", "equals_farray", "int(float[],float[])");
      if (SUB_ID_SPVM__Util__equals_farray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_farray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_farray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[16] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortf";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[16];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L101;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L98: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L101;
L99: // INIT_INT
  int_vars[6] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L101;
L101: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L102: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sorti(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[20];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L6: // MOVE_INT
  int_vars[3] = int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = -7;
L11: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L12: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L14: // MOVE_CONSTANT_INT
  int_vars[7] = 9;
L15: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L16: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L18: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[9] = *(int32_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L21: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[9];
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[11] = 127;
L24: // MOVE_CONSTANT_INT
  int_vars[12] = 4;
L25: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[11];
      } 
    } 
  } 
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[13] = 15;
L28: // MOVE_CONSTANT_INT
  int_vars[14] = 5;
L29: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[14];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[13];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[15] = 19;
L32: // MOVE_CONSTANT_INT
  int_vars[16] = 6;
L33: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[16];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[15];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L36: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L38: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L39: // CALL_SUB_VOID
  // SPVM::Sort->sorti
  {
    if (SUB_ID_SPVM__Sort__sorti < 0) {
      SUB_ID_SPVM__Sort__sorti = env->get_sub_id(env, "SPVM::Sort", "sorti", "void(int[])");
      if (SUB_ID_SPVM__Sort__sorti < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Sort sorti");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Sort__sorti;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L43: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L45: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L47: // MOVE_INT
  int_vars[4] = int_vars[3];
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L49: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[6] = -7;
L52: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L53: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[8] = 5;
L56: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L57: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[10] = 9;
L60: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L61: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[12] = 15;
L64: // MOVE_CONSTANT_INT
  int_vars[13] = 4;
L65: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[12];
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[14] = 19;
L68: // MOVE_CONSTANT_INT
  int_vars[15] = 5;
L69: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[14];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[16] = 127;
L72: // MOVE_CONSTANT_INT
  int_vars[17] = 6;
L73: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[17];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[16];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L77: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[18] = *(int32_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorti";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L79: // BOOL_INT
  int_vars[0] = int_vars[18];
L80: // IF_NE_ZERO
  if (int_vars[0]) { goto L85; }
L81: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L84: // GOTO
  goto L85;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L91;
L89: // INIT_INT
  int_vars[6] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L91;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortl(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[8];
  int32_t int_vars[18];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = -7;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L16: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L20: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L23: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[9] = 127;
L26: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[9];
L27: // MOVE_CONSTANT_INT
  int_vars[10] = 4;
L28: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[4];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[11] = 15;
L31: // CONVERT_INT_TO_LONG
  long_vars[5] = (int64_t)int_vars[11];
L32: // MOVE_CONSTANT_INT
  int_vars[12] = 5;
L33: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[5];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[13] = 19;
L36: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[13];
L37: // MOVE_CONSTANT_INT
  int_vars[14] = 6;
L38: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[14];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[6];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L44: // CALL_SUB_VOID
  // SPVM::Sort->sortl
  {
    if (SUB_ID_SPVM__Sort__sortl < 0) {
      SUB_ID_SPVM__Sort__sortl = env->get_sub_id(env, "SPVM::Sort", "sortl", "void(long[])");
      if (SUB_ID_SPVM__Sort__sortl < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Sort sortl");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Sort__sortl;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L48: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L50: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L52: // MOVE_LONG
  long_vars[1] = long_vars[0];
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[4] = -7;
L57: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L58: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L59: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L62: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[6];
L63: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L64: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[8] = 9;
L67: // CONVERT_INT_TO_LONG
  long_vars[4] = (int64_t)int_vars[8];
L68: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L69: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[4];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[10] = 15;
L72: // CONVERT_INT_TO_LONG
  long_vars[5] = (int64_t)int_vars[10];
L73: // MOVE_CONSTANT_INT
  int_vars[11] = 4;
L74: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[5];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[12] = 19;
L77: // CONVERT_INT_TO_LONG
  long_vars[6] = (int64_t)int_vars[12];
L78: // MOVE_CONSTANT_INT
  int_vars[13] = 5;
L79: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[6];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[14] = 127;
L82: // CONVERT_INT_TO_LONG
  long_vars[7] = (int64_t)int_vars[14];
L83: // MOVE_CONSTANT_INT
  int_vars[15] = 6;
L84: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[7];
      } 
    } 
  } 
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L88: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[16] = *(int32_t*)&stack[0];
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortl";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L90: // BOOL_INT
  int_vars[0] = int_vars[16];
L91: // IF_NE_ZERO
  if (int_vars[0]) { goto L96; }
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L93: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L102;
L95: // GOTO
  goto L96;
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L99: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L102;
L100: // INIT_INT
  int_vars[6] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L102;
L102: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L103: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sorto(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[12];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 419;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L5: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L6: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 84;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 11;
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 366;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L11: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L12: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L13: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L16: // MOVE_CONSTANT_INT
  int_vars[3] = 402;
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L18: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L19: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L20: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 86;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 453;
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L26: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L27: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 419;
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L32: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L34: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 15;
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 402;
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L39: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L40: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L41: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L45: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[6], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L48: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L51: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L54: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L57: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L60: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[8] = 5;
L63: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L66: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[6]);
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L69: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object);
  }
L70: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[6];
L72: // CALL_SUB_VOID
  // SPVM::Sort->sorto
  {
    if (SUB_ID_SPVM__Sort__sorto < 0) {
      SUB_ID_SPVM__Sort__sorto = env->get_sub_id(env, "SPVM::Sort", "sorto", "void(oarray,SPVM::Comparator)");
      if (SUB_ID_SPVM__Sort__sorto < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Sort sorto");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Sort__sorto;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 92;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L76: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L77: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[6], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L80: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L83: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L86: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L89: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L92: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L94: // MOVE_CONSTANT_INT
  int_vars[8] = 5;
L95: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L97: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L98: // CALL_SUB_OBJECT
  // SPVM::EqualityChecker::SameObject->new
  {
    if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
      SUB_ID_SPVM__EqualityChecker__SameObject__new = env->get_sub_id(env, "SPVM::EqualityChecker::SameObject", "new", "SPVM::EqualityChecker::SameObject()");
      if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::EqualityChecker::SameObject new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__EqualityChecker__SameObject__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L100: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L101: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[6];
L102: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[8];
L103: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[9] = *(int32_t*)&stack[0];
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorto";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L105: // BOOL_INT
  int_vars[0] = int_vars[9];
L106: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L107: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L108: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L118;
L111: // GOTO
  goto L112;
L112: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L115: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L118;
L116: // INIT_INT
  int_vars[6] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L118;
L118: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L119: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sorts(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[18];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[8];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = -7;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L16: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L20: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L23: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[9] = 127;
L26: // CONVERT_INT_TO_SHORT
  short_vars[4] = (int16_t)int_vars[9];
L27: // MOVE_CONSTANT_INT
  int_vars[10] = 4;
L28: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[4];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[11] = 15;
L31: // CONVERT_INT_TO_SHORT
  short_vars[5] = (int16_t)int_vars[11];
L32: // MOVE_CONSTANT_INT
  int_vars[12] = 5;
L33: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[5];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[13] = 19;
L36: // CONVERT_INT_TO_SHORT
  short_vars[6] = (int16_t)int_vars[13];
L37: // MOVE_CONSTANT_INT
  int_vars[14] = 6;
L38: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[14];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[6];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L44: // CALL_SUB_VOID
  // SPVM::Sort->sorts
  {
    if (SUB_ID_SPVM__Sort__sorts < 0) {
      SUB_ID_SPVM__Sort__sorts = env->get_sub_id(env, "SPVM::Sort", "sorts", "void(short[])");
      if (SUB_ID_SPVM__Sort__sorts < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Sort sorts");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Sort__sorts;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L48: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L50: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L52: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[4] = -7;
L57: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[4];
L58: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L59: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L62: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[6];
L63: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L64: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[8] = 9;
L67: // CONVERT_INT_TO_SHORT
  short_vars[4] = (int16_t)int_vars[8];
L68: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L69: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[4];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[10] = 15;
L72: // CONVERT_INT_TO_SHORT
  short_vars[5] = (int16_t)int_vars[10];
L73: // MOVE_CONSTANT_INT
  int_vars[11] = 4;
L74: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[5];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[12] = 19;
L77: // CONVERT_INT_TO_SHORT
  short_vars[6] = (int16_t)int_vars[12];
L78: // MOVE_CONSTANT_INT
  int_vars[13] = 5;
L79: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[6];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[14] = 127;
L82: // CONVERT_INT_TO_SHORT
  short_vars[7] = (int16_t)int_vars[14];
L83: // MOVE_CONSTANT_INT
  int_vars[15] = 6;
L84: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[7];
      } 
    } 
  } 
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L88: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[16] = *(int32_t*)&stack[0];
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sorts";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L90: // BOOL_INT
  int_vars[0] = int_vars[16];
L91: // IF_NE_ZERO
  if (int_vars[0]) { goto L96; }
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L93: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L102;
L95: // GOTO
  goto L96;
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L99: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L102;
L100: // INIT_INT
  int_vars[6] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L102;
L102: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L103: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Sort__test_sortstr(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x61", 3));
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62", 2));
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61", 1));
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L23: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L26: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L37: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L39: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L42: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62", 2));
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L44: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L47: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x61", 3));
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L49: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L52: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L53: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L54: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L57: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[0]);
L58: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L60: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L63: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L64: // CALL_SUB_VOID
  // SPVM::Sort->sortstr
  {
    if (SUB_ID_SPVM__Sort__sortstr < 0) {
      SUB_ID_SPVM__Sort__sortstr = env->get_sub_id(env, "SPVM::Sort", "sortstr", "void(string[])");
      if (SUB_ID_SPVM__Sort__sortstr < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Sort sortstr");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Sort__sortstr;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L66: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L67: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[6];
L68: // CALL_SUB_INT
  // SPVM::Util->equals_strarray
  {
    if (SUB_ID_SPVM__Util__equals_strarray < 0) {
      SUB_ID_SPVM__Util__equals_strarray = env->get_sub_id(env, "SPVM::Util", "equals_strarray", "int(string[],string[])");
      if (SUB_ID_SPVM__Util__equals_strarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_strarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_strarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Sort";
    const char* sub_name = "test_sortstr";
    const char* file = "TestCase/Lib/SPVM/Sort.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L70: // BOOL_INT
  int_vars[0] = int_vars[2];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L74: // GOTO
  goto L75;
L75: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L79;
L77: // INIT_INT
  int_vars[6] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


