#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__IfRequire__if_require(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__IfRequire__if_require(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L4: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L40;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L40;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L19: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L21: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_NE_ZERO
  if (int_vars[0]) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L40;
L26: // GOTO
  goto L27;
L27: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L28: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L30: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L40;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L40;
L38: // INIT_INT
  int_vars[6] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L40;
L40: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


