#!/usr/bin/perl -w

use MyDB::Main;
use strict;

my $schema = MyDB::Main->connect('dbi:SQLite:example.db');
my $dbh    = $schema->storage->dbh;

$dbh->do(
    qq{
CREATE TABLE artist (
    artistid INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL 
  );}
) or die;

$dbh->do(
    qq{
CREATE TABLE cd (
    cdid INTEGER PRIMARY KEY AUTOINCREMENT,
    artist INTEGER NOT NULL REFERENCES artist(artistid),
    title TEXT NOT NULL
  );
}
) or die;

$dbh->do(
    qq{
CREATE TABLE track (
    trackid INTEGER PRIMARY KEY AUTOINCREMENT,
    cd INTEGER NOT NULL REFERENCES cd(cdid),
    title TEXT NOT NULL
  );
}
) or die;

#  here's some of the sql that is going to be generated by the schema
#  INSERT INTO artist VALUES (NULL,'Michael Jackson');
#  INSERT INTO artist VALUES (NULL,'Eminem');

my @artists = ( ['Michael Jackson'], ['Eminem'] );
$schema->populate( 'Artist', [ [qw/name/], @artists, ] );

my %albums = (
    'Thriller'                => 'Michael Jackson',
    'Bad'                     => 'Michael Jackson',
    'The Marshall Mathers LP' => 'Eminem',
);

my @cds;
foreach my $lp ( sort keys %albums ) {
    my $artist
        = $schema->resultset('Artist')->search( { name => $albums{$lp} } );
    push @cds, [ $lp, $artist->first ];
}

$schema->populate( 'Cd', [ [qw/title artist/], @cds, ] );

my %tracks = (
    'Beat It'         => 'Thriller',
    'Billie Jean'     => 'Thriller',
    'Dirty Diana'     => 'Bad',
    'Smooth Criminal' => 'Bad',
    'Leave Me Alone'  => 'Bad',
    'Stan'            => 'The Marshall Mathers LP',
    'The Way I Am'    => 'The Marshall Mathers LP',
);

my @tracks;
foreach my $track ( sort keys %tracks ) {
    my $cdname
        = $schema->resultset('Cd')->search( { title => $tracks{$track}, } );
    push @tracks, [ $cdname->first, $track ];
}

$schema->populate( 'Track', [ [qw/cd title/], @tracks, ] );
