#!/perl

package nuodblogmonitor;

my $IP = '(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})';
my ($a2,$a3,@memory,@PIP,@time,$str,$quotient,$digitsi,$alarm,$remainder) = "";

sub dbnamed_hash_file()
{
	open(A,shift) or die "File A:$!\n";
	open(B,shift) or die "File B:$!\n";
	open(C, '>',shift) or die "File C:$!\n";
	@input=<B>;
	while(my $a=<A>)
	{
		if($a =~ m/$IPADDRESS/g)
		{
			$a2=$a;$a3='';
		}
		else
		{
			$a3.="\t\t\t$a";$sizes{$a2} = $a3;
		}
	}
	dbtiedhash(\%sizes,\@input);
}
	
sub dbtied_hash()
{

	my %sizes = shift;
	my @input = shift;

	foreach $key (keys %$sizes)
	{
		if($key =~m/$IPADDRESS/g)
		{
			$str = "$1\.$2\.$3\.$4";
			@memory = grep(/$str(\s+)(\d+)/,@$input);
			@PIP = split(/\s+/,$memory[0]);
			($digits) = $sizes{$key} =~ /HeapAllocatedMemory = (\d+)/g;
			$prev = $digits if($digits != '');
			$quotient = $digits / $PIP[1] if($digits != '');
			$quotient = $prev / $PIP[1] if($digits == '');
			$remainder = sprintf('%.2f', $quotient);
			$alarm = '';
			##Alarm has been raised in all Database
			$alarm = raisealarm(1) if($remainder >= 0.75);
			@time = split(/(\[SM\]|\[TE\])/,$key); 
			print C "IP: $str\n\t\t\tTIME: $time[0]\n\t\t\tQUOTIENT: $quotient\t$alarm\n$sizes{$key}";	
		}
	}
}

sub raisealarm()
{
	my $alarmflag = shift;
	if($alarmflag == 1)
	{
		$addlarm = '<================================[ALARM]============================>';
		return $addlarm;	

	}
}


1;
