# Before 'make install' is performed this script should be runnable with
# 'make test'. After 'make install' it should work as 'perl WordNet-Insert.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use strict;
use warnings;

use Test::More tests => 10;
BEGIN { use_ok('WordNet::Insert') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

################ Load Insert

my $win = WordNet::Insert->new();
if($win)
{
    print "ok 2\n";
}
else
{
    print "not ok 2\n";
}

################# change current stop list to valid input.

$win->stopList("s/\b(the|is|at)\b/");

my @err = $win->getError();
if($err[0] == 0)
{
    print "ok 3\n";
}
else
{
    print "not ok 3\n";
}

################## change current stop list using invalid input.

$win->stopList("ffwwwss");

@err = $win->getError();
if($err[0] == 1)
{
    print "ok 4\n";
}
else
{
   print "not ok 4\n";
}

################### addCleanUp with valid input

$win->addCleanUp("s/the/one/g");

@err = $win->getError();
if($err[0] == 0)
{
    print "ok 5\n";
}
else
{
    print "not ok 5\n";
}

################### addCleanUp with invalid input

$win->addCleanUp("qwergad");

@err = $win->getError();
if($err[0] == 1)
{
    print "ok 6\n";
}
else
{
    print "not ok 6\n";
}

################### run insert() before calling preProcessing()

$win->insert("dog\tnoun\twithdef.1\tman\'s best friend");

@err = $win->getError();
if($err[0] == 2)
{
	print "ok 7\n";
}
else
{
	print "not ok 7\n";
}

#################### run processLemma() before calling preProcessing()

my @inLemma = ("dog","noun","withdef.1","man's best friend", "");
$win->processLemma(\@inLemma);

@err = $win->getError();
if($err[0] == 2)
{
	print "ok 8\n";
}
else
{
	print "not ok 8\n";
}

###################### run insert() and processLemma() after calling preProcessing().
$win->preProcessing();

$win->insert("dog\tnoun\twithdef.1\tman\'s best friend");

@err = $win->getError();
if($err[0] == 0)
{
	print "ok 9\n";
}
else
{
	print "not ok 9\n";
}

$win->processLemma(\@inLemma);

@err = $win->getError();
if($err[0] == 0)
{
	print "ok 10\n";
}
else
{
	print "not ok 10\n";
}
