###############################################################################
#
# Tests for Excel::Writer::XLSX::Chartsheet methods.
#
# reverse(''), September 2010, John McNamara, jmcnamara@cpan.org
#

use lib 't/lib';
use TestFunctions qw(_expected_to_aref _got_to_aref _is_deep_diff _new_object);
use strict;
use warnings;
use Excel::Writer::XLSX::Chartsheet;

use Test::More tests => 1;

###############################################################################
#
# Tests setup.
#
my $expected;
my $caption;
my $got;
my $chartsheet = _new_object( \$got, 'Excel::Writer::XLSX::Chartsheet' );


###############################################################################
#
# Test the _assemble_xml_file() method.
#
$caption = " \tChartsheet: _assemble_xml_file()";
$chartsheet->_assemble_xml_file();

$expected = _expected_to_aref();
$got      = _got_to_aref( $got );

_is_deep_diff( $got, $expected, $caption );

__DATA__
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<chartsheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships">
  <sheetPr/>
  <sheetViews>
    <sheetView workbookViewId="0"/>
  </sheetViews>
  <pageMargins left="0.7" right="0.7" top="0.75" bottom="0.75" header="0.3" footer="0.3"/>
  <drawing r:id="rId1"/>
</chartsheet>
