package Mojolicious::Plugin::Riotjs::Preprocessor;
use Mojo::Base 'Mojolicious::Plugin::AssetPack::Preprocessor';
use File::Basename 'dirname';
use File::Spec  ();
use File::Which ();

has executable => sub {
  my $self = shift;
  my $local = File::Spec->catfile($self->cwd, 'node_modules', '.bin', 'riot');
  return $local if -e $local;
  return File::Which::which('riot') || 'riot';
};

has _compile_cmd => sub {
  return [
    File::Which::which('nodejs') || File::Which::which('node'),
    File::Spec->catfile(dirname(__FILE__), 'compile.js'),
  ];
};

sub can_process { -f $_[0]->executable ? 1 : 0 }

sub process {
  my ($self, $assetpack, $text, $path) = @_;
  my $err = '';

  local $ENV{RIOT_COMPACT} = $assetpack->minify ? 1 : 0;
  $self->_run($self->_compile_cmd, $text, $text, \$err);
  $self->_make_js_error($err, $text) if length $err;
  $self;
}

sub _url {'https://muut.com/riotjs/'}

1;

=encoding utf8

=head1 NAME

Mojolicious::Plugin::Riotjs::Preprocessor - DEPRECATED

=head1 DESCRIPTION

See L<Mojolicious::Plugin::Riotjs>.

=head1 ATTRIBUTES

=head2 executable

DEPRECATED.

=head1 METHODS

=head2 can_process

DEPRECATED.

=head2 process

DEPRECATED.

=head1 SEE ALSO

L<Mojolicious::Plugin::Riotjs>.

=cut
