# in case Test::More ain't there
# vim: syntax=perl
BEGIN {
    eval { require Test::More; };
    print "1..0\n" and exit if $@;

}

use strict;
use Test::More;
use lib qw( ./lib ../lib );
use Solaris::Disk::SVM;

my $tests;
my $datadir="t/data3";
my $metastat = "$datadir/metastat-p.txt";

open METASTAT, $metastat or die "Can not open metastat dump file: $metastat";
my @metastat = <METASTAT>;
close METASTAT;

my ( %mirrors, %softparts, %devices, %stripes, %concats, %concatstripes, %trans, %raids, %hotspares);

foreach (@metastat) {
    $hotspares{$1}++     if /^(hsp\d+)/;
    $mirrors{$1}++       if /^(d\d+) -m/;
    $softparts{$1}++     if /^(d\d+) -p/;
    $raids{$1}++         if /^(d\d+) -r/;
    $trans{$1}++         if /^(d\d+) -t/;
    $devices{$1}++       if /^(d\d+) 1 1/;
    $stripes{$1}++       if /^(d\d+) (?:[2-9]|\d\d+) 1/;
    $concats{$1}++       if /^(d\d+) 1 (?:[2-9]|\d\d+)/;
    $concatstripes{$1}++ if /^(d\d+) (?:[2-9]|\d\d+) (?:[2-9]|\d\d+)/;
}

# garbage'd definitions
delete $softparts{"d$_"} foreach ( 208..214 );

my $svm = Solaris::Disk::SVM->new( init => 0 );
$svm->readconfig( amaya => 'hhgg');

$svm=();
$svm = Solaris::Disk::SVM->new( init => 0 );
$svm->{mnttab}->readmtab( mnttab => "$datadir/mnttab.txt" );
$svm->{mnttab}->readstab( swaptab => "$datadir/swaptab.txt" );
$svm->{vtoc}->readvtocdir( $datadir );
$svm->readconfig( metastatp => $metastat );


plan tests => scalar( keys(%mirrors) ) + scalar( keys(%softparts) )
  + scalar( keys(%devices) ) + scalar( keys(%stripes) ) + scalar( keys(%concats) )
  + scalar( keys(%concatstripes) ) + scalar( keys(%trans) )
  + scalar( keys(%raids) ) + scalar( keys(%hotspares) ) + $tests;

is( $svm->{devices}{$_}{type}, "mirror", "$_ is a mirror" ) foreach keys %mirrors;
is( $svm->{devices}{$_}{type}, "softpart", "$_ is a soft partition" ) foreach keys %softparts;
is( $svm->{devices}{$_}{type}, "device", "$_ is a simple device" ) foreach keys %devices;
is( $svm->{devices}{$_}{type}, "stripe", "$_ is a stripe" ) foreach keys %stripes;
is( $svm->{devices}{$_}{type}, "concat", "$_ is a concat" ) foreach keys %concats;
is( $svm->{devices}{$_}{type}, "concat/stripe", "$_ is a concat/stripe" ) foreach keys %concatstripes;
is( $svm->{devices}{$_}{type}, "hotspare", "$_ is a hotspare" ) foreach keys %hotspares;
is( $svm->{devices}{$_}{type}, "trans", "$_ is a trans" ) foreach keys %trans;
is( $svm->{devices}{$_}{type}, "raid5", "$_ is a raid5" ) foreach keys %raids;

# Coverage

open NULL, "> /dev/null"
    or die "Cannot open /dev/null";
*OUT = *STDOUT;
*STDOUT = *NULL;

# coverage test for show
$svm->showconfig;
$svm->{colour}++;
$svm->showconfig;
$svm->dumpconfig;
$svm->showsp;
$svm->explaindev("d0", "d10");

*STDOUT = *OUT;
close NULL;

BEGIN { $tests += 3; }
my $free = $svm->getnextdev;
is( $svm->{devices}{"d$free"}, undef, "Get next dev is not used");
is( $svm->isdevfree($free), 1, "isdevfree is OK with getnextdev");
is( $svm->isdevfree("d$free"), 1, "isdevfree is OK with getnextdev");

my $occpd = $free - 1;
BEGIN { $tests += 3; }
isa_ok( $svm->{devices}{"d$occpd"}, 'HASH', "Get next dev ");
is( $svm->isdevfree($occpd), 0, "isdevfree is still OK with getnextdev");
is( $svm->isdevfree("d$occpd"), 0, "isdevfree is still OK with getnextdev");


BEGIN { $tests += 3; }
my @physd;
@physd = $svm->getphysdevs("d61");
ok(eq_set(\@physd, [ "c3t1d0s0" ]), "getphysdevs d61");

@physd = $svm->getphysdevs( "d60" );
ok(eq_set(\@physd, [ "c3t2d0s0", "c3t1d0s0" ]), "getphysdevs d60" );

@physd = $svm->getphysdevs( "d2" );
ok(eq_set( \@physd, [ qw( c0t1d0s0 c0t2d0s0 c0t3d0s0 c2t1d0s0 c2t2d0s0
    c2t3d0s0 c3t0d0s0 c3t3d0s0 ) ]), "getphysdevs d2");


BEGIN { $tests += 2; }
my $cpt=1;
foreach (qw( c0t0d0s0 c2t0d0s0 )) {
    my @mps = $svm->mponslice($_);
    ok(eq_set(\@mps, [ '/' ]), "mponslice ".$cpt++)
}

BEGIN { $tests += 8; }
foreach ( qw(   c0t1d0s0 c0t2d0s0 c0t3d0s0 c2t1d0s0
                c2t2d0s0 c2t3d0s0 c3t0d0s0 c3t3d0s0 ) ) {
    my @mps = $svm->mponslice($_);
    ok(eq_set(\@mps, [ '/export' ]), "mponslice ".$cpt++)
}

BEGIN { $tests += 3; }
$cpt=1;
foreach (qw( d10 d11 d12 )) {
    my @mps = $svm->mpondev($_);
    ok(eq_set(\@mps, [ '/' ]), "mpondev ".$cpt++)
}

BEGIN { $tests += 5; }
foreach ( qw( d1 d2 d50 d51 d52 ) ) {
    my @mps = $svm->mpondev($_);
    ok(eq_set(\@mps, [ '/export' ]), "mpondev ".$cpt++)
}


BEGIN { $tests += 2; }
$cpt=1;
foreach (qw( c0t0d0 c2t0d0 )) {
    my @mps = $svm->mpondisk($_);
    ok(eq_set(\@mps, [ '/', '/export', '/var', 'swap' ]), "mpondisk ".$cpt++)
}

BEGIN { $tests += 8; }
foreach ( qw(   c0t1d0 c0t2d0 c0t3d0 c2t1d0
                c2t2d0 c2t3d0 c3t0d0 c3t3d0 ) ) {
    my @mps = $svm->mpondisk($_);
    ok( eq_set( \@mps, ['/export'] ), "mpondisk " . $cpt++ );
}

#devs4mp
BEGIN { $tests += 5; }
my %mp2dev = (
    '/'       => [qw( d10 d12 d11 )],
    '/export' => [qw( d1 d2 d50 d51 d52)],
    '/ext'    => [qw( d60 d61 d62 )],
    'swap'    => [qw( d30 d31 d32 )],
    '/var'    => [qw( d3 d20 d21 d22 d40 d41 d42 )],
);

foreach ( keys %mp2dev ) {
    my @devs = $svm->devs4mp($_);
    ok( eq_set( \@devs, \@{ $mp2dev{$_} } ), "devs4mp $_" );
}

#disks4mp
BEGIN { $tests += 5; }
my %mp2disk = (
    '/'       => [qw( c2t0d0s0 c0t0d0s0 )],
    '/export' => [qw( c0t0d0s5 c2t3d0s0 c0t1d0s0 c3t0d0s0 c3t3d0s0 c0t2d0s0
    c2t1d0s0 c2t0d0s5 c2t2d0s0 c0t3d0s0 )],
    '/ext'    => [qw( c3t1d0s0 c3t2d0s0 )],
    'swap'    => [qw( c0t0d0s1 c2t0d0s1 )],
    '/var'    => [qw( c2t0d0s4 c0t0d0s4 c0t0d0s6 c2t0d0s6 )],
);

foreach ( keys %mp2dev ) {
    my @devs = $svm->disks4mp($_);
    ok( eq_set( \@devs, \@{ $mp2disk{$_} } ), "disks4mp $_" );
}

my @d100 = (qw( d91 d92 d93 d94 d95 d96 d97 d98 d99 d201 d202 d203 d204 d205 d206 d207 ) );
BEGIN { $tests += 16;}
foreach ( @d100 ) {
    my @devs = $svm->getsubdevs( $_ );
    ok( eq_set( \@devs, [ 'd100' ]), "soft part on device $_");
}

# methods that should return undef on undefined device

BEGIN { $tests += 8;}
is($svm->disks4mp('/nothing'), 0, "empty list on disks4mp");
is($svm->devs4mp('/nothing'), 0, "empty list on devs4mp");
is($svm->getsubdevs('d1000'), 0, "empty list on getsubdevs");
is($svm->getphysdevs('d1000'), 0, "empty list on getphysdevs");
is($svm->mponslice('c99t99d99s99'), 0, "empty list on mponslice");
is($svm->mpondisk('c99t99d99'), 0, "empty list on mpondisk");
is($svm->mpondisk('nothing'), 0, "empty list on mpondisk");
is($svm->mpondev('d1000'), 0, "empty list on mpondev");

# version
BEGIN { $tests++; }
is($svm->version, 0.02, "Version is ".$svm->version);

#use Data::Dumper; print STDERR Dumper $svm;
