# Test gaussian()

use Test::More tests => 4;
use Scalar::Util 'looks_like_number';

BEGIN {
    use_ok('Math::Random::MT::Auto', qw/gaussian srand warnings :!auto/);
};

can_ok('Math::Random::MT::Auto', qw/gaussian srand warnings/);

# Known test values for gaussian()
my @base_gaus = qw/
    -0.67900010  -0.76353070  -1.22055314   1.70912815   2.16055966
     0.76768605   0.77652945  -1.61644663  -0.88292110   0.26198049
     0.24328359   0.69033541  -1.03393856  -0.40027470   2.27263946
    -0.62430946   1.27916708   0.67434065  -0.21996068  -0.62762867
    -0.43698433  -0.53687934   0.42856553  -0.22543321   1.29415241
     1.42726328  -2.12264560   0.13847042   0.26737712   0.68645675
     0.38605774  -0.95860332  -1.07557563  -1.52879695  -0.96806549
     0.73186775  -0.50145088   2.16420334  -0.45426248   1.12537493
    -0.02670718   1.11944719   0.48722774  -0.28728689   0.45148410
     0.13053322  -0.72644368   0.05816893  -0.02115270   0.68634808
     1.64985385  -1.63358803   0.17987764   1.09711570  -0.86123347
     0.15496576   0.35002371  -0.93026082   0.01618218  -0.16037354
     0.36703253   1.86624428   0.77299935  -1.72601245   0.71059066
    -0.91276332   0.04126098   0.52123484  -0.16453685  -0.00808668
    -2.40360676  -0.59022802   0.58972699   0.46505708  -0.72014329
     0.02179857   2.37615965   0.45401722   1.22106625   0.54072968
    -0.52864313  -1.29424897   0.10462222   0.35390484  -0.53142435
     1.13474901  -1.52782483   0.28320489   0.24346593   0.55784609
     2.18881755  -0.56508311   0.98285684  -0.67143526   0.14551121
    -0.17335697   0.52923238  -0.08619739   0.52467633  -0.69215082
    -0.39443838   0.88897785  -1.97187874   0.17645475   0.57128632
     1.29070896  -0.81455168   1.38222671   0.07108479   0.28753603
    -0.69374219   0.27003562   0.33399782  -0.11420947  -1.66122486
     0.42215373  -1.01029821   0.03676902  -1.23241263  -1.54440295
     0.95863264  -0.69771632   1.27896420  -0.40993469   0.36440376
     1.18815772   0.08987873   0.59248630  -2.90152122   0.38578120
    -1.12898624  -1.05914728  -0.50179005  -0.84609081  -0.99468041
    -0.41574952  -0.76211969  -0.20299729  -0.71325347   0.88402499
    -0.14368680   1.08816270   1.91729303  -0.20682637  -1.12362944
     1.12763703   0.61693399  -0.35387886   0.78621331  -0.97141916
     0.19239875  -1.54455109  -1.56717047   0.50680235  -0.20029765
    -0.75296394   0.92199925   0.35072992   0.51153266  -0.29514504
     0.03426061   0.55253334   1.04827075   0.61529743   0.30380821
    -0.28662049  -0.19427693  -1.30523354   1.31129013   0.11673200
    -0.71794471  -0.58214888   0.01369455   0.24879386  -0.87976113
    -0.65148067  -0.43105601  -1.63184963   2.25866025   1.92904017
     0.27176520   0.58162239  -1.50830827  -0.24356306  -0.45637866
    -0.72860127  -0.86774494  -0.15279850   1.38002969   0.28652261
     1.33609983  -1.94745000   0.17627001   1.10527031   0.73706010
     1.12969134   0.55999512  -0.76511473   0.26127602  -0.63203112
     1.19384409   0.38299677  -0.74321487   0.87226975  -0.84083218
     0.31658483   0.08890916  -1.03324471  -1.60370690  -1.07315687
     1.07578588  -0.17463034  -0.31997483   1.43186566   0.32393862
     0.42341384  -1.57653697   0.97085585   0.75623248   1.55301233
    -0.71971361  -0.76757147   1.41834869   0.23025256  -1.69996160
     0.30258519   0.71546495   0.47236540  -0.56111496  -0.13267620
     0.92803983  -0.36504838   0.02139622   0.71590681  -1.28289086
     0.13518499   1.60034312   1.34842855   0.34812205  -2.17042649
     1.14760942  -0.85513258   0.40308688   0.15660158  -0.72191595
    -0.18059661   0.15399787  -1.80457578   0.88313007   1.69640013
     0.42395761  -0.82432333  -0.21315128   0.35815099  -0.48051247
     0.70900858   0.07105364   0.52089723   0.64443754  -0.81145639
    -0.83587056   3.15928772  -2.03740685  -0.40564928   1.72690182
     0.66042581   0.43339619   0.18392800   0.99073473   0.05336630
     0.73983739  -0.04392395   0.36274058   1.16822342  -0.25872667
     2.76468656   0.35683563   0.41112267  -1.27633884   0.64155403
    -2.50564439   0.23795010  -1.72064188   1.31943865  -0.12834823
    -0.49208036   0.83591542   0.71456205  -0.21491903   2.45134727
    -0.15876076   3.02679669   0.67640287  -0.24689274   1.61840233
     0.43362910  -0.62117358  -1.47193139  -0.24586867  -0.13090489
    -0.59812169  -0.34381041  -1.68198497  -1.12370152  -0.02342749
     0.33195258   0.85231309   1.06445296  -0.92827048  -0.82057411
    -1.20948283  -0.21921034   1.30274100   0.28860582  -0.59775623
    -0.38182075   0.64385688  -0.32873730  -0.56046331  -1.43299182
     0.09149188  -0.77837133   0.32051966   0.65350950  -0.08399004
    -0.19006613   0.36516604  -2.82771563  -0.36652092   1.77646039
    -2.07098381  -1.29342376   0.86819046  -1.14505952   0.92792778
     0.07584727   0.75714209   0.67041333   1.72599838   2.03455481
     0.00861707   0.69951705   0.04180243   0.50560959  -1.55845761
     0.42819104   0.58623670   0.24897470  -0.16742131   0.45892873
     0.34027503  -0.73083727   0.22030652   0.15034567  -1.55134666
    -0.03538797  -0.18051762  -0.14874899   0.22393302  -0.39403836
     0.42915502  -2.10147850   0.06860015  -0.94066242   0.25926413
    -0.46055477  -2.15732424  -0.19283784  -0.14535494  -0.02878216
    -0.20788636  -1.51909657  -1.37963203   1.92388983  -1.08691233
    -1.73661302   0.39057554  -0.34147646  -0.35671011  -1.35244976
    -0.41230719  -0.64364491   0.59673733   1.09730624  -0.86768419
     0.96826380  -0.13674848  -1.06710164   2.66691369  -0.14188941
    -2.30539038   0.73200789  -0.59515746   1.03066293   1.36289736
    -0.30856502   1.06394156  -0.75277416  -0.61219092  -0.37327749
    -1.25177691  -0.37011232  -0.86387100  -0.72704593  -0.67622042
     0.44869145  -0.74969831   1.66012041  -0.17594821   1.32266784
     0.04690328  -0.31211411   0.44230388   0.97155470   0.90523572
    -0.84965835  -0.83840044  -0.89360810   0.43358720   0.40396575
     0.71247847   1.48216826  -1.65755942  -0.20114935  -2.95185051
     0.40528248  -0.89820915   2.44371778  -0.91240064   1.19694453
     0.42441724   0.34649062  -0.67585940  -0.49745447  -0.52383390
     0.75470185  -0.07945107  -2.08217915  -0.78998007  -0.61330454
    -0.28405933   0.18402104   0.27259858  -1.33936692   0.76848496
    -0.39010815   1.68676650   0.62789843   0.91876472   1.78332509
    -1.25903671  -0.00580486   1.00371662  -0.87967978  -0.61400856
     1.12427103  -0.27612582   0.64486982   0.90475247   0.04707521
    -0.72339994  -1.20893895  -0.83763732   0.65115287  -0.69176037
     1.17239556   3.17292548  -0.85410512  -0.48530390   0.40726012
    -0.94016253  -0.05353060   2.40470848   0.14006401   0.50718046
    -1.25837150  -0.04069010  -0.56197399   1.52747327  -0.45172723
     0.61650966   0.25511258   1.19296831  -0.80737900   0.44607527
    -0.25197867   0.78596503   0.30917724  -0.76384849   1.22184319
    -0.65125174   1.31370130   0.07587660   0.35703115  -0.22700003
     0.15612765   0.31911374   2.23410709  -0.60783103   2.08425230
     0.57574280   1.41945574  -0.28644632  -0.03503043   1.86885501
     0.21157010  -0.33770027  -0.92057709  -0.75207452  -1.20241703
    -0.42431736  -0.50687216   0.70482596   0.82602015  -0.34864225
     0.52770451  -0.62201574   0.70491460  -0.46738459  -0.30389059
    -0.52978626   0.04819083  -1.29516631   0.70534771  -2.35494299
    -0.29965748  -0.26397931   0.03529472   0.24992585   0.16213455
    -0.90899783   0.33763435   0.80475292  -1.77454331   0.09471756
    -0.16856530  -1.12924701  -1.51199859  -0.32219139   0.33629224
    -0.24672311   1.02574110  -1.05782008   1.23412914   2.60921874
     0.91047293   0.11491478   0.16603746  -1.04517079   1.28584748
    -0.88443702   0.56787488   2.74991534  -0.03169719  -0.07239003
    -0.34450677   0.83036303   1.78222223   0.53144648   0.70267110
     0.44661108   0.64836241   2.38993862  -0.53864101  -0.71251358
    -0.87798273  -0.78473551   0.51689773   0.78897968   0.99470338
    -0.07535737  -1.90432294   0.39725397  -0.44375693  -0.55825407
    -0.59380803   0.62741480   0.05573984  -0.22477983  -1.51419686
     2.69471494  -0.29968222   1.19471379  -2.73610734  -1.97556688
    -0.31920327  -1.13405590   0.20349634  -0.50584252   1.37633888
     1.96842803  -1.23781003   0.47889897  -0.17117167   0.28351957
    -2.23140751   1.22755689  -0.93293793   1.57015565  -0.53404272
    -0.63797776  -2.02507780  -0.01233693  -1.28624017  -1.34112670
     0.26112293  -0.09335167   1.65534659   0.01457528   0.78524077
     0.98986950   0.13541561   0.45548461   1.10497585   1.09772959
     0.29971907   0.87004616   0.58565753   1.37620918   0.26437745
    -1.44472854   0.62048990  -0.84613906  -1.83005566   1.16209251
    -0.90693241   0.00795211  -1.11361279  -0.15306165  -2.71460755
     0.04864673  -0.32212339   1.37043776   1.36040056   0.00485763
    -1.86224075  -1.28021191  -0.13079462  -1.51863376  -1.68756893
     1.00121586  -0.31900260  -0.21270389  -0.84799824   1.15380852
     0.46656485   0.78352523   0.52829336   1.12566205   0.29344039
     1.17386669  -0.60954282  -1.66527560   0.43893881   0.89909315
     0.57319940   0.87200371  -0.23476307   0.35353564  -1.44958196
    -0.28819623  -1.75861085  -0.76348406   1.45872715  -1.11743785
    -0.72871184  -0.57310292   0.48844415   1.24141371   1.25179089
     0.18777951   1.44216240   0.70064171  -0.44505285  -0.49686365
     0.09356023   0.60571049   1.00905904   1.23933872   1.30429660
     0.09413284   0.30320394  -0.41872836   0.92461852   0.64913337
    -0.56699722  -0.63793177  -1.73995279   0.52618610   0.38845365
     1.03770034  -1.78131510  -0.14361246  -0.26501899  -0.63027212
    -1.19650150   0.73545008   1.59556468   0.99040700   1.66094398
    -1.28378901  -1.50010525  -0.87182895  -0.30825364   1.13628886
     0.26073400   2.02099904  -2.17969509   0.71487473   1.46342663
     0.38535090  -0.13499994   0.25870324  -0.46727604  -0.44887857
    -2.19650692   1.21344560   0.53448598   0.27511196  -1.15937424
     0.36380507   0.76539227   0.28049142  -1.52529624   1.51310692
     0.58450546  -0.31188719   0.11119090  -0.20616474  -0.54427601
     2.24598035  -0.00520781   0.53495206   1.90912834  -1.25468912
     0.71422585  -1.06388042   0.33113273  -0.40648985  -0.48914519
    -1.38481711  -0.59241390   0.07675448  -0.22417277   0.38794171
    -2.21257839   0.45013826  -0.56007421  -0.30633285   1.36931495
    -1.28235511  -0.19583087   0.08210015   1.75822686   1.43177706
     0.93945616  -0.71019834  -0.44832379  -0.08488514  -2.02331507
     0.09730286   0.14973228   0.52420199   0.95155446  -0.28124707
    -0.22300503  -0.20209795  -0.85344413   0.52417473  -0.44406390
    -0.61414536  -0.01271084  -0.21018387  -0.20464778  -0.94408110
     0.15137101  -0.92074986   0.30081329   1.04919790   0.01431403
     0.21432851  -0.27597970  -1.60739819  -0.61609785  -1.79166171
    -0.41639126   0.90125814  -0.12740289   0.09465179  -0.00242445
     0.49399635  -1.31114583   0.47914316   0.25622234  -1.14812830
     0.11413797  -1.28016352  -0.94496418  -0.12273360   0.74506462
    -0.03613196   1.54218575  -0.92162945   0.91161699  -0.99204263
    -0.52060820  -0.23212847   2.02360077  -0.10092186  -2.41859424
     0.95717335   0.61941127  -0.27259332   1.78342521   0.52390593
     0.98637647  -1.28544392  -0.93234699   1.04664345  -0.10697019
    -0.86643694  -0.87314972  -0.23608421  -0.72462102  -0.32804787
    -0.54587776  -0.71103610  -0.14652763   0.45622198  -0.99007012
    -0.70127570   0.64230882  -0.10470717   0.01518823  -0.66331180
    -0.23505929   0.48128612  -0.75382861  -0.19304559   0.50224462
     1.29558266  -0.64143542   1.46595164  -0.29627956   0.04960887
     0.88403422   1.04150142   1.15166474  -0.85150060  -0.66841338
    -0.73756389   0.43600353   0.65634577   1.37230557  -1.02260958
     1.05074187   0.01614685   0.03282021   0.36296551   0.18132155
     1.31516909  -0.52085624   0.40971297   0.56009989   1.85632909
    -0.34883564   0.25913116  -0.90610859  -0.48002904  -2.44051652
     1.18654858   0.76472477  -0.03209411  -0.81089182  -1.00938077
     0.92300218   0.99042928  -0.68755277   0.84690097  -0.38771263
     0.60926947   1.02529824  -2.64065259   0.06556281  -1.20866378
     2.14964935   1.08042331  -0.15646304   1.36463578  -1.34808125
     1.51789843   0.17868856   0.35093958   0.03641585  -0.01079558
    -1.27051571  -1.08612860  -1.03895721  -0.30304907   1.32756191
    -1.05088740   0.97869833  -1.39205589   0.29077859   0.11755481
     0.11353633  -0.01374465  -1.83304416  -0.37108767  -1.37282011
    -1.08256705  -0.77676171  -0.37292585  -1.96305310  -1.35517080
    -0.48607849  -0.51845203  -0.92292995   1.13146469  -0.78121715
    -0.15295365   0.67332197  -1.16341569   0.52960308  -1.43784410
    -0.06342474   1.69156664   0.42331332   0.50942602  -0.15168407
    -0.07786868   0.90945445   1.93273584   0.86331844   0.29273466
     0.64403066   0.45582812   0.04076944   1.56181497  -0.21336070
     0.74251865  -2.04611919   0.36106936   0.28876444   0.41026358
     1.06842793   0.46735124   1.16729143   0.40085998  -1.45984892
     0.13833485  -1.79837692  -1.34281600  -0.59045746  -0.18001220
    -0.83069550   0.47093770  -0.50977588  -0.02650916  -0.38438485
     0.96292046  -0.59071751   0.75694964   0.64479339   0.93098218
    -1.00004812   0.73731488   1.03395148  -0.76814482   1.90580546
    -0.22803111  -1.17877173  -1.00023474  -1.10226675  -0.60577117
     1.51270619   0.32074401  -0.98256964   0.31197798  -0.62867788
    -1.89906688  -1.22626577  -0.68932323  -0.71990808   0.87973504
     1.15189422   1.45384544   1.23657847  -0.15840770   1.03670758
    -0.73867633   0.90969075   1.66518911   0.04534167  -0.55061938
     0.29343915   1.32344159   0.15794698  -0.45255219   0.86179561/;


### - Guassian Function - ###

# Set predetermined seed for verification test
sub myseed
{
    my $seed = $_[0];
    my $need = $_[1];  # Ignored

    push(@$seed, 0x123, 0x234, 0x345, 0x456);
}
eval { srand(\&myseed); };
if (! ok(! $@, 'srand(\&sub) works')) {
    diag('srand(\&sub) died: ' . $@);
}


# Test Gaussian randoms
my @test_gaus;
for (my $ii=0; $ii < 1000; $ii++) {
    push(@test_gaus, sprintf('%0.8f', gaussian()));
}
is_deeply(\@test_gaus, \@base_gaus);

# EOF
