# WARNING: This file is autogenerated from following files:
#
#            lib/HTTP/WebTest.pm.in
#            lib/HTTP/WebTest.pm.in
#            lib/HTTP/WebTest/Plugin/Apache.pm
#            lib/HTTP/WebTest/Plugin/Click.pm
#            lib/HTTP/WebTest/Plugin/ContentSizeTest.pm
#            lib/HTTP/WebTest/Plugin/Cookies.pm
#            lib/HTTP/WebTest/Plugin/DefaultReport.pm
#            lib/HTTP/WebTest/Plugin/HarnessReport.pm
#            lib/HTTP/WebTest/Plugin/Hooks.pm
#            lib/HTTP/WebTest/Plugin/Loader.pm
#            lib/HTTP/WebTest/Plugin/ResponseTimeTest.pm
#            lib/HTTP/WebTest/Plugin/SetRequest.pm
#            lib/HTTP/WebTest/Plugin/StatusTest.pm
#            lib/HTTP/WebTest/Plugin/TextMatchTest.pm
#            lib/HTTP/WebTest/ReportPlugin.pm
#
# Do not modify this file but edit those files. All changes in this
# file will be lost.


# This is a -*-perl-*- source file


package HTTP::WebTest;

$VERSION = '1.99_06';
# workaround for warning caused by underscore char in $VERSION
$VERSION = eval $VERSION;

# actual content of HTTP::WebTest package is in HTTP::WebTest::API
require HTTP::WebTest::API;

=head1 NAME

HTTP::WebTest - Test remote URLs or local web files

=head1 SYNOPSIS

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;

    # run test from file
    $webtest->run_wtscript('script.wt');

    # or (to pass test parameters as method arguments)
    $webtest->run_tests($tests);

=head1 DESCRIPTION

=head2 Beta software warning

THIS IS A BETA VERSION THAT IS A REWRITE OF VERSION 1.07 AND IS
PROBABLY NOT AS WELL DEBUGGED AS VERSION 1.07.  Version 1.07 can be
downloaded at http://search.cpan.org/search?dist=HTTP-WebTest-1.07

=head2 Introduction

This module runs tests on remote URLs or local web files containing
Perl/JSP/HTML/JavaScript/etc. and generates a detailed test report.
This module can be used "as-is" or its functionality can be extended
using plugins.  Plugins can define test types and provide additional
report capabilities.  This module comes with a set of default plugins
but can be easily extended with third party plugins.

The L<wt|wt> script is provided for running C<HTTP::WebTest> from the
command line.

The test specifications can be read from a parameter file in wtscript
format or input as method arguments.  If you are testing a local file,
Apache is started on a private/dynamic port with a configuration file
in a temporary directory.

The test results can be displayed on the terminal, directed to a file,
stored in a scalar variable.  The test results can also be emailed.
The report can be modified and extended using report plugins.

Each URL/web file is tested by fetching it from the web server using a
local instance of an HTTP user agent.  The basic test is simply
whether or not the fetch was successful.  You may also test using
literal strings or regular expressions that are either required to
exist or forbidden to exist in the fetched page.  You may also specify
tests for the minimum and maximum number of bytes in the returned
page.  You may also specify tests for the minimum and maximum web
server response time.

Data flow for C<HTTP::WebTest> using a remote URL:

          --------------              -------------
          |            |              |           |
          | Input      |------------->|  WebTest  |
          | parameters |              |           |
          |            |              -------------
          --------------                  |   ^
                                          |   |
                                          V   |
          -------------               ------------
          |           |    request    |          |
          | Remote    |<--------------|   HTTP   |
          | webserver |-------------->|   user   |
          |           |    response   |   agent  |
          -------------               |          |
                                      ------------

Data flow diagram for C<HTTP::WebTest> using a local web file:

          --------------           ---------------------
          |            |           |                   |
          | Input      |           |  Web page code    |
          | parameters |           |  (Perl/HTML/etc.) |
          |            |           |                   |
          --------------           ---------------------
                |                            |
                |  ---------------------------
                |  |
                V  V              ------------------------
          -------------           |                      |
          |           |---------->| Temporary Apache     |
          |  WebTest  |           | directories (htdocs, |
          |           |<----------| conf, logs)          |
          -------------           |                      |
              |  ^                ------------------------
              |  |                        |    ^
              V  |                        V    |
          ------------             ----------------------
          |          |   request   |                    |
          |   HTTP   |------------>| Temporary local    |
          |   user   |             | instance of Apache |
          |   agent  |<------------|                    |
          |          |   response  ----------------------
          ------------

=head2 Getting Started

This module has complex functionality, but using it to run simple
tests is simple.  Create a file of test parameters in the
L<wtscript format|Running HTTP::WebTest using a parameter file> and use the
L<wt|wt> program to process the file using the command C<wt
filename>.  The only required parameters are C<test_name> and C<url>.

This document describes:

=over 4

=item *

How tests can be specified.  See section
L<TEST SPECIFICATION|TEST SPECIFICATION>.

=item *

All test parameters supported by core C<HTTP::WebTest>
plugins.  See section L<TEST PARAMETERS|TEST PARAMETERS>.

=back

See L<"perldoc wt"|wt> for documentation on the wt program.

Other useful documentation is:

=over 4

=item *

L<perldoc HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook> - examples
of wtscript files and examples of C<HTTP::WebTest> API usage.

=item *

L<perldoc HTTP::WebTest::API|HTTP::WebTest::API> - full documentaion
on API of C<HTTP::WebTest>.

=item *

L<perldoc HTTP::WebTest::Plugins|HTTP::WebTest::Plugins> - for
developers of C<HTTP::WebTest> plugins.

=back

=head1 TEST SPECIFICATION

The test specifications can be read from a parameter file (in the
wtscript format described below) or passed as method arguments as an
array of hashes.

=head2 Running HTTP::WebTest using a parameter file

C<HTTP::WebTest> can read test specification from file
in format called as C<wtscript>.

Tests defined by wtscript file can be
run either using Perl API of C<HTTP::WebTest>

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;
    $webtest->run_wtscript('script.wt');

or by using program L<wt|wt> supplied with this module.

If you are running dozens of tests, you may want to divide them into
several parameter files.  This will organize the tests and reduce the
size of the output and e-mail messages.  However, cookies passed to or
received from the web server(s) are not shared between tests in
different parameter files.

=head3 File format

The wtscript file is a text file containing global parameters and test
blocks containing test block parameters.  A test block begins with a
test_name parameter and ends with an end_test directive.  The order of
the parameters and test blocks is arbitrary.

Test block parameters MUST occur between a test_name parameter and an
end_test directive.  (Test block parameters affect only an individual
test.) Global parameters must NOT occur between a test_name parameter
and an end_test directive.  (This requirement does not apply to
certain parameters that are both global and test block parameters.)

The following lines are ignored:

=over 4

=item *

lines consisting of nothing but white space (blanks or tabs)

=item *

lines beginning with a number sign (C<#>)

=item *

lines beginning with white space (blanks or tabs) followed by a number
sign

=back

Parameters are either scalar (single-valued) or lists (single or
multi-valued).

You can specify scalar parameters using forms such as:

    name=value
    name =
           value
    name = 'value'

You can specify list parameters using forms such as:

    name = ( first value
             second value )
    name=( first value => second value
           third value => fourth value
         )
    name = ( first value => second value )
    name = (
             'first value'
             'second value' )
    name= (
             first value
             second value
             third value => 'fourth value'
          )
    name =
           ( first value
             'second value' )
    name = (
             'first value'
             'second value'
           )

You can specify a null (placeholder) value using '' or "".  Within single
or double quotes, the usual Perl string quoting rules apply.  Thus, single
quotes mean that all enclosed characters are interpreted literally: '\n'
is backslash-n rather than a newline character.  Double quotes mean that
Perl metasymbols are interpreted: "\n\t" is a newline and a tab.

Also it is possible to specify Perl code instead of scalar, instead of
list parameter value or instead of element of list paramater.  Curly
brackets are used to denote Perl code inside wtscript files.  This
code will be evaluated during test run.

C<HTTP::WebTest> compiles this Perl code as anonymous subroutines
which are called during test run when value of corresponding test
parameters are required.  When these subroutines are called
C<HTTP::WebTest> object is passed to them.

Some examples of syntax:

    # scalar value
    name = { 1 + 1 }

    # list value (Perl code should return array reference)
    name = { [ a => 'b', c => 'd' ] }

    # element of list value
    name = (
             'first value'
             { "first " . "value" }
           )

    # accessing HTTP::WebTest object
    name = { my $webtest = shift; ..... }

=head3 Examples of wtscript files

The parameters below specify tests of a local file and a remote URL.
The tests specified by the C<text_forbid> parameter apply to both the
"RayCosoft home page" and the "Yahoo home page" tests.  Hence, if
either returned page contains one of the case-insensitive strings in
text_forbid, the test fails.  If any test fails or the fetch of the URL
fails, an e-mail will be sent to tester@unixscripts.com.


    apache_exec = /usr/sbin/apache
    ignore_case = yes
    mail = errors
    mail_addresses = ( tester@unixscripts.com )
    mail_server = mailhost.unixscripts.com
    text_forbid = ( Premature end of script headers
                    an error occurred while processing this directive
                  )

    test_name = 'RayCosoft home page (static)'
        file_path = ( raycosoft_home.html => . )
        text_require = (
            <a href="/dept/peopledev/new_employee/"><font color="#0033cc">
            <a href="https://www.raycosoft.com/"><font color=
                       )
    end_test

    test_name = Yahoo home page
        url = www.yahoo.com
        text_require = ( <a href=r/qt>Quotations</a>...<br> )
        min_bytes = 13000
        max_bytes = 99000
        min_rtime = 0.010
        max_rtime = 30.0
    end_test

The parameters below specify a test of a local file containing Perl
code using the L<Apache::ASP|Apache::ASP> module.  The C<includes.htm>
file requires five include files and two Perl modules, which are
copied using the C<include_file_path> parameter.

    apache_exec = /usr/sbin/apache
    ignore_case = yes
    include_file_path = ( footer.inc => htdocs/apps/myapp/inc
                          header.inc => htdocs/apps/myapp/inc
                          head.inc   => htdocs/apps/myapp/inc
                          go.script  => htdocs/shared/includes
                          go.include => htdocs/shared/includes
                          ../utils/DBconn.pm  => lib/perl/utils
                          ../utils/Window.pm  => lib/perl/utils
                        )

    test_name = includes.htm
        file_path = ( includes.htm => apps/myapp )
        min_bytes = 33000
        max_bytes = 35000
        text_require = ( input type=hidden name=control value= )
        text_forbid  = ( Premature end of script headers
                         an error occurred while processing this directive
                       )
    end_test

=head2 Calling HTTP::WebTest from a Perl program

If you are using Perl API of C<HTTP::WebTest> then the test parameters
can be defined in form of array of hashes.

Each hash in array defines tests for one URL or local web file.  Keys
in hashes are test parameter names and values in hashes are values of
test parameters.  Additionally, optional global test parameters can be
passed in a hash passed as the second argument.

Instead of test parameter values subroutine references can be
specified.  Referenced subroutines are called during test run when
values of corresponding test parameters are required.  When called
these subroutines get C<HTTP::WebTest> object passed to them.

Tests can be run as

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;
    $webtest->run_tests(
                        [ # test 1
                          { param1 => value1,
                            param2 => value2 },
                          # test 2
                          { param1 => value1,
                            param2 => value2 },
                        ],
                        { global_param1 => value1,
                          global_param2 => value2 }
                       );

=head3 Example

This Perl script tests Yahoo home page and sends full test report to
C<tester@unixscripts.com>.

    use HTTP::WebTest;

    my $tests = [
                 { name         => 'Yahoo home page',
                   url          => 'http://www.yahoo.com',
                   text_require => [ '<a href=r/qt>Quotations</a>...<br>' ],
                   min_bytes    => 13000,
                   max_bytes    => 99000,
                 }
                ];

    my $params = { mail_server    => 'mailhost.unixscripts.com',
                   mail_addresses => [ 'tester@unixscripts.com' ],
                   mail           => 'all',
                   ignore_case    => 'yes',
                 };

    $webtest->run_tests($tests, $params);

=head1 PLUGIN MODULES

=head2 Core Plugin Modules

C<HTTP::WebTest> provides a number of core plugin modules which are
loaded by default:

=over 4

=item L<HTTP::WebTest::Plugin::Apache>

This plugin provides support for local web file test mode.

=item L<HTTP::WebTest::Plugin::ContentSizeTest>

This plugin provides size checks of HTTP response bodies.

=item L<HTTP::WebTest::Plugin::Cookies>

This plugin provides means to control sending and recieve cookies.

=item L<HTTP::WebTest::Plugin::DefaultReport>

Default test report plugin.

=item L<HTTP::WebTest::Plugin::Loader>

This plugin allows to load external plugin modules.

=item L<HTTP::WebTest::Plugin::ResponseTimeTest>

This plugin provides support for response time tests.

=item L<HTTP::WebTest::Plugin::SetRequest>

This plugin initializes test HTTP requests.

=item L<HTTP::WebTest::Plugin::StatusTest>

This plugin checks HTTP response statuses.

=item L<HTTP::WebTest::Plugin::TextMatchTest>

This plugin provides test parameters which allow to check body of HTTP
responses.

=back

Information about test parameters supported by core plugins is
summarized below in section L<TEST PARAMETERS|TEST PARAMETERS>.

=head2 Other Plugin Modules Bundled With HTTP::WebTest

Following plugin modules come with HTTP::WebTest but they are not
loaded by default.  They should be loaded using global test parameter
C<plugins> when needed.

=over 4

=item L<HTTP::WebTest::Plugin::Click>

This plugin allows to use names of links and button on HTML pages to
build test requests.

=item L<HTTP::WebTest::Plugin::HarnessReport>

This report plugin can generate L<Test::Harness|Test::Harness>
compatible test reports.

=item L<HTTP::WebTest::Plugin::Hooks>

This plugin allows to define callback test parameters which are
evaluated at specific time of L<HTTP::WebTest> test run.  These test
parameters can define user-defined checks.

=back

See documentation on these modules for more information.

=head2 Writting Plugin Modules

L<perldoc HTTP::WebTest::Plugins|HTTP::WebTest::Plugins> contains
information needed for L<HTTP::WebTest|HTTP::WebTest> plugin
developers.

=head1 TEST PARAMETERS

Most parameters can be used both as global and as test block
parameters.  If you specify such parameter as global its value applies
to all test blocks.  Value of parameter specified as global can be
overriden individually in each test block by specifying this parameter
with different values in test blocks.

Parameters marked as I<GLOBAL PARAMETER> can be used only as global
and it cannot be overriden in test blocks.

=head2 accept_cookies

Option to accept cookies from the web server.

These cookies exist only while the program is executing and do not
affect subsequent runs.  These cookies do not affect your browser or
any software other than the test program.  These cookies are only
accessible to other tests executed during test sequence execution.

See also the <send_cookies> parameter.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 apache_dir

I<GLOBAL PARAMETER>

Absolute or relative path name of directory containing Apache files.
See the L<APACHE DIRECTORY AND FILES|/"APACHE DIRECTORY AND FILES">
section.  This parameter is ignored unless the C<file_path> parameter
is specified.

=head3 Default value

C</usr/local/etc/http-webtest>

=head2 apache_exec

I<GLOBAL PARAMETER>

Absolute or relative path name of Apache executable.  This command can
be in your C<$PATH>.  This parameter is ignored unless the
C<file_path> parameter is specified.

=head3 Default value

C</usr/sbin/apache>

=head2 apache_loglevel

I<GLOBAL PARAMETER>

Apache logging level.  If you use a level less than C<warn> (i.e.,
C<debug>, C<info>, or C<notice>), the program may generate irrelevant
errors.  This parameter is ignored unless the C<file_path> parameter
is specified.  See also the C<ignore_error_log> parameter.

=head3 Allowed values

C<debug>, C<info>, C<notice>, C<warn>, C<error>, C<crit>, C<alert>,
C<emerg>

=head3 Default value

C<warn>

=head2 apache_max_wait

I<GLOBAL PARAMETER>

Maximum number of seconds to wait for Apache to start.  This parameter
is ignored unless the C<file_path> parameter is specified.

=head3 Default value

C<60>

=head2 apache_options

I<GLOBAL PARAMETER>

Additional Apache command line options.  Many of the options cause
Apache to exit immediately after starting, so the web page tests will
not run.  This parameter is ignored unless the C<file_path> parameter
is specified.

=head3 Allowed values

See Apache documentation

=head2 auth

A list which contains two elements: userid/password pair to be used
for web page access authorization.

=head2 cookie

Synonym to C<cookies>.

=head2 cookies

Specifies a cookie(s) to send to the web server.

Each cookie is specified by following list:

    ( version
      name
      value
      path
      domain
      port
      path_spec
      secure
      maxage
      discard
      name1
      value1
      name2
      value2
      ...
    )


Any element not marked below as REQUIRED may be defaulted by
specifying a null value or ''.

=over 4

=item * version (REQUIRED)

Version number of cookie spec to use, usually 0.

=item * name (REQUIRED)

Name of cookie.  Cannot begin with a $ character.

=item * value (REQUIRED)

Value of cookie.

=item * path (REQUIRED)

URL path name for which this cookie applies.  Must begin with a /
character.  See also path_spec.

=item * domain (REQUIRED)

Domain for which cookie is valid.  (REQUIRED).  Should begin with a
period.  Must either contain two periods or be equal to C<.local>.

=item * port

List of allowed port numbers that the cookie may be returned to.  If
not specified, cookie can be returned to any port.  Must be specified
using the format C<N> or C<N, N, ..., N> where N is one or more
digits.

=item * path_spec

Ignored if version is less than 1.  Option to ignore the value of
path.  Default value is 0.

=over 4

=item * 1

Use the value of path.

=item * 0

Ignore the specified value of path.

=back

=item * secure

Option to require secure protocols for cookie transmission.  Default
value is 0.

=over 4

=item * 1

Use only secure protocols to transmit this cookie.

=item * 0

Secure protocols are not required for transmission.

=back

=item * maxage

Number of seconds until cookie expires.

=item * discard

Option to discard cookie when the program finishes.  Default is 0.
(The cookie will be discarded regardless of the value of this
element.)

=over 4

=item * 1

Discard cookie when the program finishes.

=item * 0

Don't discard cookie.

=back

=item * name/value

Zero, one or several name/value pairs may be specified.  The name
parameters are words such as Comment or CommentURL and the value
parameters are strings that may contain embedded blanks.

=back

An example cookie would look like:

    ( 0
      WebTest cookie #1
      expires&2592000&type&consumer
      /
      .unixscripts.com
      ''
      0
      0
      200
      1
    )

See RFC 2965 for details (ftp://ftp.isi.edu/in-notes/rfc2965.txt).

=head3 Usage in wtscript files

You may specify multiple cookies within each test block by specifying
multiple instances of the C<cookies> parameter.

=head3 Usage in Perl scripts

Use arrayref of arrayrefs containing cookies to pass with the HTTP
request.

Each array must have at least 5 elements; if the number of elements is
over 10 it must have an even number of elements.


=head2 default_report

I<GLOBAL PARAMETER>

This parameter defines if default report plugin should be used for
test report creation.  Value C<yes> means that default report plugin
should be used, value C<no> means that it should not.  It can be
useful if it is desired to use another non-default report for creation
of test report.  It can be used to disable any output at all also
(i.e. if this parameter has value C<no> and no other report plugins
are loaded).

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 end_test

It is not really test parameter but a part of
L<wtscript format|Running HTTP::WebTest using a parameter file>.
It marks end of test block.
=head2 error_log

I<GLOBAL PARAMETER>

The pathname of a local web server error log.  The module counts the
number of lines in the error log before and after each request.  If
the number of lines increases, an error is counted and the additional
lines are listed in the report.  This argument should be used only
when the local web server is running in single-process mode.
Otherwise, requests generated by other processes/users may add lines
to the error log that are not related to the requests generated by
this module.  See also parameter C<ignore_error_log>.

=head2 fh_out

I<GLOBAL PARAMETER>

A filehandle (or anything else that supports C<print>) to use for test
report output.  This parameter is ignored if test parameter
C<output_ref> is specified also.

This parameter can be used only when passing the test parameters
as arguments from a calling Perl script.

=head2 file_path

If L<HTTP::WebTest|HTTP::WebTest> encounters parameter C<file_path> it
switches in local web file test mode.  In local web file test mode it
launches an instance of Apache daemon, copies local test file(s) under
DocumentRoot of this Apache and performs test checks against it.

=head3 Allowed values

Two-element list.  First element is the file to test, either an
absolute or a relative pathname.  Second element is the subdirectory
pathname, relative to the Apache htdocs directory, to copy the file
to.  The copied file will have the same basename as the first element
and the relative pathname of the second element.  To copy the file
directly to the htdocs directory, use a pathname of C<.> or C<./.>.

=head2 http_headers

A list of HTTP header/value pairs.  Can be used to override default
HTTP headers or to add additional HTTP headers.

=head3 Example

    http_headers = ( Accept => text/plain, text/html )

=head2 ignore_case

Option to do case-insensitive string matching for C<text_forbid>,
C<text_require>, C<regex_forbid> and C<regex_require> test parameters.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 ignore_error_log

Option to ignore any errors found in the Apache error log.  The
default behavior is to flag an error if the fetch causes any errors to
be added to the error log and echo the errors to the program output.
This check is available only if C<error_log> parameter is specified.
See also the C<apache_loglevel> parameter.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 include_file_path

List with an even number of elements.  Odd-numbered elements are files
to copy to the the temporary Apache directory before running the
tests.  These files can be specified using either an absolute or a
relative pathname.  Even-numbered elements are the subdirectory
pathname, relative to the Apache ServerRoot directory, to copy the
corresponding file to.  The copied file will have the same basename as
the odd-numbered element and the relative pathname of the
corresponding even-numbered element.  To copy the file directly to the
ServerRoot directory, use a pathname of C<.> or C<./.>.

For example:

    include_file_path = (/home/tester/inc/header.inc => htdocs/includes)

will copy the file to htdocs/includes/header.inc.

This parameter is also useful for adding Perl modules that are needed
by the web page specified by the file_path parameter.  For example:

    include_file_path = ( ../apps/myapp/DBconn.pm => lib/perl/apps )

will copy the Perl module DBconn.pm to a directory that is in the
Perl @INC array.


=head2 mail

I<GLOBAL PARAMETER>

Option to e-mail output to one or more addresses specified by
C<mail_addresses> test parameter.

=over 4

=item * all

Send e-mail containing test results.

=item * errors

Send e-mail only if one or more tests fails.

=item * no

Do not send e-mail.

=head3 Default value

C<no>

=back

=head2 mail_addresses

I<GLOBAL PARAMETER>

A list of e-mail addresses where report will be send (if sending
report is enabled with C<mail> test parameter).

=head2 mail_from

I<GLOBAL PARAMETER>

Sets From: header for test report e-mails.

=head3 Default Value

Name of user under which test script runs.


=head2 mail_server

I<GLOBAL PARAMETER>

Fully-qualified name of of the mail server (e.g., mailhost.mycompany.com).

=head3 Default value

C<localhost>

=head2 max_bytes

Maximum number of bytes expected in returned page.

=head3 Allowed values

Any integer greater that zero and greater than C<min_bytes> (if
C<min_bytes> is specified).


=head2 max_rtime

Maximum web server response time (seconds) expected.

=head3 Allowed values

Any number greater that zero and greater than C<min_rtime> (if
C<min_rtime> is specified).


=head2 method

HTTP request method.

See RFC 2616 (HTTP/1.1 protocol).

=head3 Allowed values

C<GET>, C<PUT>

=head3 Default value

C<GET>

=head2 min_bytes

Minimum number of bytes expected in returned page.

=head3 Allowed values

Any integer less than C<max_bytes> (if C<max_bytes> is specified).

=head2 min_rtime

Minimum web server response time (seconds) expected.

=head3 Allowed values

Any number less than C<max_rtime> (if C<max_rtime> is specified).

=head2 output_ref

I<GLOBAL PARAMETER>

A reference on scalar which accumulates text of test report.  If this
test parameter is specified then value of test parameter C<fh_out> is
ignore.

This parameter can be used only when passing the test parameters
as arguments from a calling Perl script.

=head2 params

A list of name/value pairs to be passed as parameters to the URL.
(This element is used to test pages that process input from forms.)
Unless the method key is set to C<POST>, these pairs are URI-escaped
and appended to the requested URL.

The names and values will be URI-escaped as defined by RFC 2396.

=head3 Example

    url = http://www.hotmail.com/cgi-bin/hmhome
    params = ( curmbox
               F001 A005
               from
               HotMail )

generates the HTTP request:

    http://www.hotmail.com/cgi-bin/hmhome?curmbox=F001%20A005&from=HotMail

=head2 pauth

A list which contains two elements: userid/password pair to be used
for proxy server access authorization.

=head2 plugins

I<GLOBAL PARAMETER>

A list of module names.  Loads these modules and registers them as
L<HTTP::WebTest|HTTP::WebTest> plugins.  If name of plugin starts with
C<::> prepends it with C<HTTP::WebTest::Plugin>.  So

    plugins = ( ::ValidateHTML )

is equal to

    plugins = ( HTTP::WebTest::Plugin::ValidateHTML )


=head2 proxies

A list of service name/proxy URL pairs that specify proxy servers to
use for requests.

=head3 Example

    proxies = ( http => http://http_proxy.mycompany.com
                ftp  => http://ftp_proxy.mycompany.com )

=head2 regex_forbid

List of regular expressions that are forbidden to exist in the
returned page.

For more information, see L<perldoc perlre|perlre> or see Programming
Perl, 3rd edition, Chapter 5.

See also the C<text_forbid> and C<ignore_case> parameters.

=head2 regex_require

List of regular expressions that are required to exist in the
returned page.

For more information, see L<perldoc perlre|perlre> or see Programming Perl,
3rd edition, Chapter 5.

See also the C<text_require> and C<ignore_case> parameters.


=head2 send_cookies

Option to send cookies to web server.  This applies to cookies
received from the web server or cookies specified using the C<cookies>
test parameter.

This does NOT give the web server(s) access to cookies created with a
browser or any user agent software other than this program.  The
cookies created while this program is running are only accessible to
other tests in the same test sequence.

See also the <accept_cookies> parameter.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 show_cookies

Option to display any cookies sent or received.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 show_headers

Include request and response headers in the test report.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 show_html

Include content of HTTP response in the test report.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 terse

Option to display shorter test report.

=over 4

=item * summary

Only a one-line summary for each URL

=item * failed_only

Only tests that failed and the summary

=item * no

Show all tests and the summary

=head3 Default value

C<no>

=back


=head2 test_name

Name associated with this url in the test report and error messages.

=head2 text_forbid

List of text strings that are forbidden to use exist in the returned
page.

See also the C<regex_forbid> and C<ignore_case> parameters.

=head2 text_require

List of text strings that are required to use exist in the returned
page.

See also the C<regex_require> and C<ignore_case> parameters.

=head2 url

URL to test.  If schema part of URL is omitted (i.e. URL doesn't start
with C<http://>, C<ftp://>, etc) then C<http://> is implied.

=head2 user_agent

Set the product token that is used to identify the user agent on
the network.

=head3 Default value

C<HTTP-WebTest/NN>

where C<NN> is version number of HTTP-WebTest.



=cut



=head1 APACHE DIRECTORY AND FILES

A tree of directories with templates of Apache config files is
required to run local web file tests.

The C<apache_dir> parameter must be set to the name of a directory
that contains the subdirectories C<conf>, C<logs> and C<htdocs>.  The
C<conf> subdirectory must contain a file named C<httpd.conf-dist>.
The C<htdocs> subdirectory must contain a subdirectory named
C<webtest> that contains a file named C<is_apache_responding.html>.
If your installation of Apache has the Perl module
L<Apache::ASP|Apache::ASP> configured, the C<apache_dir> directory
must also contain a subdirectory named C<asp_tmp>.

The file C<httpd.conf-dist> is used as template for the Apache config
file.  It contains tags which are replaced with the values needed by
the Apache server that the program starts at runtime.

=over 4

=item * Please_do_not_modify_PORT

To be replaced with port number on which Apache runs during tests.

=item * Please_do_not_modify_HOST_NAME

To be replace with Apache host name.

=item * Please_do_not_modify_SERVER_ROOT

To be replaced with Apache server root.

=item * Please_do_not_modify_LOG_LEVEL

To be replaced with Apache log level.

=back

=cut

=head1 RESTRICTIONS / BUGS

This module have been tested only on Unix (e.g., Solaris, Linux, AIX,
etc.) but it should work on Win32 systems.

Local file tests don't work on Win32 systems.

The module's HTTP requests time out after 3 minutes (the default value
for L<LWP::UserAgent|LWP::UserAgent>).  If the C<file_path> parameter is
specified, Apache must be installed.

=head1 SUPPORT

Please email bug reports, suggestions, questions, etc. to
C<HTTP::WebTest> maillist
C<http-webtest-general@lists.sourceforge.net>.  You can sign up at
http://lists.sourceforge.net/lists/listinfo/http-webtest-general.

=head1 AUTHORS

Richard Anderson <richard@richard-anderson.org> have wrote
C<HTTP::WebTest 1.xx>.

Ilya Martynov <ilya@martynov.org> made rewrite of
C<HTTP::WebTest>.  New version of C<HTTP::WebTest> have introduced
extended API and plugin based architecture.

Please don't email authors directly.  Use C<HTTP::WebTest> maillists.

=head1 COPYRIGHT

Copyright (c) 2000-2001 Richard Anderson.  All rights reserved.

Copyright (c) 2001,2002 Ilya Martynov.  All rights reserved.

This module is free software.  It may be used, redistributed and/or
modified under the terms of the Perl Artistic License.

=head1 SEE ALSO

L<HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook>

L<HTTP::WebTest::API|HTTP::WebTest::API>

L<HTTP::WebTest::Plugins|HTTP::WebTest::Plugins>

L<wt|wt>

=cut

1;
