package Convert::IBM390;
$VERSION = '0.11';

#--- DUMMY ----------------------------------------------------------
#
# This is a dummy .pm file, needed only because CPAN expects one.
# To generate the real thing, run 'perl Makefile.PL'.
#
#--- DUMMY ----------------------------------------------------------

1;
__END__

=head1 NAME

Convert::IBM390 -- functions for manipulating mainframe data

=head1 SYNOPSIS

  use Convert::IBM390 qw(...those desired... or :all);

  $eb  = asc2eb($string);
  $asc = eb2asc($string);
  $asc = eb2ascp($string);

  $ebrecord = packeb($template, LIST...);
  @fields = unpackeb($template, $record);
  @lines = hexdump($string [,startaddr [,charset]]);

=head1 DESCRIPTION

B<Convert::IBM390> supplies various functions that you may find useful
when messing with IBM System/3[679]0 data.  No functions are exported
automatically; you must ask for the ones you want.  "use ... qw(:all)"
exports all functions.

By the way, this module is called "IBM390" because it will deal with
data from any mainframe operating system.  Nothing about it is
specific to MVS, VM, VSE, or OS/390.

=head1 FUNCTIONS

=over 2

=item B<asc2eb> STRING

Converts a character string from ASCII to EBCDIC.  The translation
table is taken from the LE/370 code set converter EDCUI1EY; it
translates ISO8859-1 to IBM-1047.  For more information, see "IBM
C/C++ for MVS/ESA V3R2 Programming Guide", SC09-2164.

=item B<eb2asc> STRING

Converts a character string from EBCDIC to ASCII.  EBCDIC character
strings ordinarily come from files transferred from mainframes
via the binary option of FTP.  The translation table is taken from
the LE/370 code set converter EDCUEYI1; it translates IBM-1047 to
ISO8859-1 (see above).

=item B<eb2ascp> STRING

Like eb2asc, but the output will contain only printable ASCII characters.

=item B<packeb> TEMPLATE LIST

This function is much like Perl's built-in "pack".  It takes a list
of values and packs it into an EBCDIC record (structure).  If
called in list context, it will return a list of one element.
The TEMPLATE is patterned after Perl's pack template but allows fewer
options.  The following characters are allowed in the template:

  c  (1)  Character string without translation, padded with nulls
  C  (1)  Character string without translation, padded with native
          spaces
  e  (1)  ASCII string to be translated into EBCDIC, padded with nulls
  E  (1)  ASCII string to be translated into EBCDIC, padded with EBCDIC
          spaces
  h  (1)  A hexadecimal string, high nybble always first
  i  (2)  Signed integer (S/390 fullword)
  p  (1)  Packed-decimal field (default length = 8)
  s  (2)  Signed short integer (S/390 halfword)
  S  (2)  Unsigned short integer (2 bytes)	
  x  (2)  A null byte
  z  (1)  Zoned-decimal field (default length = 8)
  @       Null-fill to absolute offset

 (1) May be followed by a number giving the length of the output field;
     or, for hexadecimal, the number of nybbles in the input.
 (2) May be followed by a number giving the repeat count.

Each character may be followed by a number giving either the length
of the field or a repeat count, as shown above.  Types 'i', 's', and
'S' will gobble the specified number of items from the list; if '*' is
given as the length, all the remaining items will be gobbled.  All
other types will gobble only one item; you will usually want to give
a length for the output field.  The following defaults apply:

  Conversion                No length given   '*' given
  Character string [cCeE]   1                 Same length as input
  Hex string [hH]           2                 Same length as input
  Decimal [pz]              8                 8

The number must immediately follow the character, but whitespace may
appear between field specifiers.

The length for packed (p) or zoned (z) fields may include a number
of decimal places,
which is added after the byte count and a '.'.  For instance, "p3.2"
indicates a 3-byte (5-digit) packed field with 2 implied decimal
places; if the corresponding list element is 24.68, the result will
be x'02468C'.
Likewise, "z7.2" indicates a 7-byte (7-digit) zoned field with 2
implied decimal places; if the input is -35.79, the result will be
'000357R' in EBCDIC.
The number of implied decimals may be greater than the number of digits,
but such a specification will usually cause you to lose part of your
value; e.g., packing .589 with "p3.6" would yield x'89000c'.
If the input is not a valid Perl number, the results are unpredictable
(since they depend on internal Perl code), but most likely the output
field will contain zero.

Zoned output will always have an overpunch in the last byte for the sign
(e.g., x'C1' (EBCDIC 'A') for +1 or x'D3' (EBCDIC 'L') for -3).  If
you want unsigned numbers, you can use sprintf() and then translate
the result: e.g., C<asc2eb(sprintf("%08d", $num))>.

The ASCII-to-EBCDIC translation used by [Ee] is the same as in
asc2eb().

Either 'h' or 'H' may be used to request hexadecimal conversion.  This
conversion is exactly the same as in the Perl pack function, except
that the high nybble must always come first in the input.

The maximum length of a packed field is 16 bytes; of a zoned field, 32
bytes.  All other fields may have a maximum specifier (length or repeat
count) of 32767.  These maxima are enforced.

=item B<unpackeb> TEMPLATE RECORD

This function is much like Perl's built-in "unpack".  It takes an
EBCDIC record (structure) and unpacks it into a list of values.  If
called in scalar context, it will return only the first unpacked value.
The TEMPLATE is patterned after Perl's unpack template but allows fewer
options.  The following characters are allowed in the template:

  c or C (1)   Character string without translation
  e or E (1)   EBCDIC string to be translated into ASCII
  i      (2)   Signed integer (S/390 fullword)
  I      (2)   Unsigned integer (4 bytes)
  p      (1)   Packed-decimal field
  s      (2)   Signed short integer (S/390 halfword)
  S      (2)   Unsigned short integer (2 bytes)	
  v      (2)   EBCDIC varchar string
  x      (1)   Ignore these bytes
  z      (1)   Zoned-decimal field

 (1) May be followed by a number giving the length of the field.
 (2) May be followed by a number giving the repeat count.

Each character may be followed by a number giving either the length
of the field or a repeat count, as shown above, or by '*', which means
to use however many items are left in the string.  The number must
immediately follow the character, but whitespace may appear between
field specifiers.

The length for packed (p) or zoned (z) fields may include a number
of decimal places,
which is added after the byte count and a '.'.  For instance, "p3.2"
indicates a 3-byte (5-digit) packed field with 2 implied decimal
places; if this field contains x'02468C', the result will be 24.68.
Likewise, "z7.2" indicates a 7-byte (7-digit) zoned field with 2
implied decimal places; if this field contains '000357R' (in EBCDIC),
the result will be -35.79.
The number of implied decimals may be greater than the number of digits;
e.g., unpacking the packed field above with "p3.6" would yield 0.002468.
Zoned input fields may, but need not, have an overpunch sign in the
last byte.
If the field is not a valid packed or zoned field, the resulting
element of the list will be undefined.

Varchar (v) fields are assumed to consist of a signed halfword (16-bit)
integer followed by EBCDIC characters.  If the number appearing in the
initial halfword is N, the following N bytes are translated from EBCDIC
to ASCII and returned as one string.  This format is used, for
instance, by DB2/MVS.  A repeat count may be specified; e.g., "v2" does
not mean a length of 2 bytes, but that there are two such fields in
succession.  If the length is found to be less than 0, the resulting
element of the list will be undefined.

The EBCDIC-to-ASCII translation used by [Eev] is the same as in
eb2asc().

The maximum length of a packed field is 16 bytes; of a zoned field, 32
bytes.  All other fields may have a maximum specifier (length or repeat
count) of 32767.  These maxima are enforced.

In most cases, you should use 'i' rather than 'I' when unpacking
fullword integers.  Unsigned long integers are not handled cleanly by
all systems.

=item B<hexdump> STRING [STARTADDR [CHARSET]]

Generates a hexadecimal dump of STRING.  The dump is similar to a
SYSABEND dump in MVS: each line contains an address, 32 bytes of data
in hexadecimal, and the same data in printable form.  This function
returns a list of lines, each of which is terminated with a newline.
This allows them to be printed immediately; for instance, you can say
"print hexdump($crud);".

The second and third arguments are optional.  The second specifies 
a starting address for the dump (default = 0); the third specifies
the character set to use for the printable data at the end of each
line ("ascii" or "ebcdic", in upper or lower case; default = ascii).

=back

=head1 REFERENCES

IBM ESA/390 Principles of Operation, SA22-7201.

IBM System/370 Principles of Operation, GA22-7000.

IBM C/C++ for MVS/ESA V3R2 Programming Guide, SC09-2164.

=head1 BUGS

None, of course.  What do you think this is -- Unix?

=head1 AUTHOR

Convert::IBM390 was written by Geoffrey Rommel E<lt>grommel@sears.comE<gt>
in January 1999.

=cut
