package Foo::Testmysqlorm::League::ResultClass;

use Modern::Perl;
use Moose;
use namespace::autoclean;
use Method::Signatures;
use Data::Printer alias => 'pdump';

has league_id => (
## type:    int(11)
## key:     PRI
## autoinc: yes
## null:    no
## default:
    is      => 'rw',
    isa     => 'Num|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{league_id}++;
    },
);

has league_name => (
## type:    varchar(20)
## key:     MUL
## autoinc: no
## null:    no
## default:
    is      => 'rw',
    isa     => 'Str|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{league_name}++;
    },
);

has sport_id => (
## type:    int(11)
## key:     MUL
## autoinc: no
## null:    no
## default:
    is      => 'rw',
    isa     => 'Num|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{sport_id}++;
    },
);

has _touched => (
    is      => 'rw',
    isa     => 'HashRef',
    default => sub { {} },
);

method get_touched_attributes (
) {
    my @attr = keys %{ $self->_touched };

    return @attr;
}

1;
