=begin comment

PeakForest REST API

API specification to support \"PeakForest - REST API\" operations

The version of the OpenAPI document: 2.3.4
Contact: contact@peakforest.org
Generated by: https://openapi-generator.tech

=end comment

=cut

#
# NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
# Do not edit the class manually.
# Ref: https://openapi-generator.tech
#
package PeakForest::REST_Client::ChromatographyApi;

require 5.6.0;
use strict;
use warnings;
use utf8;
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use PeakForest::REST_Client::ApiClient;

use base "Class::Data::Inheritable";

our $VERSION = '2.3.0';

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'PeakForest::REST_Client::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = PeakForest::REST_Client::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# get_chromatographies
#
# Get / search chromatography data
#
# @param string $spectra_type the mandatory spectra type (required)
# @param string $column_name the optional column name (optional)
# @param string $column_constructor the optional column constructor (optional)
# @param string $mode the optional chromatography mode (optional)
# @param double $column_length the optional column length, in &#39;mm&#39; (optional)
# @param double $column_diameter the optional column diameter, in &#39;mm&#39; (optional)
# @param double $column_particule_size the optional column particule size, in &#39;µm&#39; (optional)
# @param double $flow_rate the optional separation flow rate, in &#39;µL/min&#39; (optional)
# @param int $offset The number of items to skip before starting to collect the result set. (optional, default to 0)
# @param int $limit The numbers of items to return. (optional, default to 20)
{
    my $params = {
    'spectra_type' => {
        data_type => 'string',
        description => 'the mandatory spectra type',
        required => '1',
    },
    'column_name' => {
        data_type => 'string',
        description => 'the optional column name',
        required => '0',
    },
    'column_constructor' => {
        data_type => 'string',
        description => 'the optional column constructor',
        required => '0',
    },
    'mode' => {
        data_type => 'string',
        description => 'the optional chromatography mode',
        required => '0',
    },
    'column_length' => {
        data_type => 'double',
        description => 'the optional column length, in &#39;mm&#39;',
        required => '0',
    },
    'column_diameter' => {
        data_type => 'double',
        description => 'the optional column diameter, in &#39;mm&#39;',
        required => '0',
    },
    'column_particule_size' => {
        data_type => 'double',
        description => 'the optional column particule size, in &#39;µm&#39;',
        required => '0',
    },
    'flow_rate' => {
        data_type => 'double',
        description => 'the optional separation flow rate, in &#39;µL/min&#39;',
        required => '0',
    },
    'offset' => {
        data_type => 'int',
        description => 'The number of items to skip before starting to collect the result set.',
        required => '0',
    },
    'limit' => {
        data_type => 'int',
        description => 'The numbers of items to return.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_chromatographies' } = {
        summary => 'Get / search chromatography data',
        params => $params,
        returns => 'ARRAY[Chromatography]',
        };
}
# @return ARRAY[Chromatography]
#
sub get_chromatographies {
    my ($self, %args) = @_;

    # verify the required parameter 'spectra_type' is set
    unless (exists $args{'spectra_type'}) {
      croak("Missing the required parameter 'spectra_type' when calling get_chromatographies");
    }

    # parse inputs
    my $_resource_path = '/spectra/{spectraType}/chromatographies';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'column_name'}) {
        $query_params->{'column_name'} = $self->{api_client}->to_query_value($args{'column_name'});
    }

    # query params
    if ( exists $args{'column_constructor'}) {
        $query_params->{'column_constructor'} = $self->{api_client}->to_query_value($args{'column_constructor'});
    }

    # query params
    if ( exists $args{'mode'}) {
        $query_params->{'mode'} = $self->{api_client}->to_query_value($args{'mode'});
    }

    # query params
    if ( exists $args{'column_length'}) {
        $query_params->{'column_length'} = $self->{api_client}->to_query_value($args{'column_length'});
    }

    # query params
    if ( exists $args{'column_diameter'}) {
        $query_params->{'column_diameter'} = $self->{api_client}->to_query_value($args{'column_diameter'});
    }

    # query params
    if ( exists $args{'column_particule_size'}) {
        $query_params->{'column_particule_size'} = $self->{api_client}->to_query_value($args{'column_particule_size'});
    }

    # query params
    if ( exists $args{'flow_rate'}) {
        $query_params->{'flow_rate'} = $self->{api_client}->to_query_value($args{'flow_rate'});
    }

    # query params
    if ( exists $args{'offset'}) {
        $query_params->{'offset'} = $self->{api_client}->to_query_value($args{'offset'});
    }

    # query params
    if ( exists $args{'limit'}) {
        $query_params->{'limit'} = $self->{api_client}->to_query_value($args{'limit'});
    }

    # path params
    if ( exists $args{'spectra_type'}) {
        my $_base_variable = "{" . "spectraType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'spectra_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Chromatography]', $response);
    return $_response_object;
}

#
# get_chromatographies_properties
#
# Get / search chromatographies, extract queried properties.
#
# @param string $spectra_type the mandatory spectra type (required)
# @param ARRAY[string] $properties  (required)
# @param string $column_name the optional column name (optional)
# @param string $column_constructor the optional column constructor (optional)
# @param string $mode the optional chromatography mode (optional)
# @param double $column_length the optional column length, in &#39;mm&#39; (optional)
# @param double $column_diameter the optional column diameter, in &#39;mm&#39; (optional)
# @param double $column_particule_size the optional column particule size, in &#39;µm&#39; (optional)
# @param double $flow_rate the optional separation flow rate, in &#39;µL/min&#39; (optional)
# @param int $offset The number of items to skip before starting to collect the result set. (optional, default to 0)
# @param int $limit The numbers of items to return. (optional, default to 20)
{
    my $params = {
    'spectra_type' => {
        data_type => 'string',
        description => 'the mandatory spectra type',
        required => '1',
    },
    'properties' => {
        data_type => 'ARRAY[string]',
        description => '',
        required => '1',
    },
    'column_name' => {
        data_type => 'string',
        description => 'the optional column name',
        required => '0',
    },
    'column_constructor' => {
        data_type => 'string',
        description => 'the optional column constructor',
        required => '0',
    },
    'mode' => {
        data_type => 'string',
        description => 'the optional chromatography mode',
        required => '0',
    },
    'column_length' => {
        data_type => 'double',
        description => 'the optional column length, in &#39;mm&#39;',
        required => '0',
    },
    'column_diameter' => {
        data_type => 'double',
        description => 'the optional column diameter, in &#39;mm&#39;',
        required => '0',
    },
    'column_particule_size' => {
        data_type => 'double',
        description => 'the optional column particule size, in &#39;µm&#39;',
        required => '0',
    },
    'flow_rate' => {
        data_type => 'double',
        description => 'the optional separation flow rate, in &#39;µL/min&#39;',
        required => '0',
    },
    'offset' => {
        data_type => 'int',
        description => 'The number of items to skip before starting to collect the result set.',
        required => '0',
    },
    'limit' => {
        data_type => 'int',
        description => 'The numbers of items to return.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_chromatographies_properties' } = {
        summary => 'Get / search chromatographies, extract queried properties.',
        params => $params,
        returns => 'object',
        };
}
# @return object
#
sub get_chromatographies_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'spectra_type' is set
    unless (exists $args{'spectra_type'}) {
      croak("Missing the required parameter 'spectra_type' when calling get_chromatographies_properties");
    }

    # verify the required parameter 'properties' is set
    unless (exists $args{'properties'}) {
      croak("Missing the required parameter 'properties' when calling get_chromatographies_properties");
    }

    # parse inputs
    my $_resource_path = '/spectra/{spectraType}/chromatographies/{properties}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'column_name'}) {
        $query_params->{'column_name'} = $self->{api_client}->to_query_value($args{'column_name'});
    }

    # query params
    if ( exists $args{'column_constructor'}) {
        $query_params->{'column_constructor'} = $self->{api_client}->to_query_value($args{'column_constructor'});
    }

    # query params
    if ( exists $args{'mode'}) {
        $query_params->{'mode'} = $self->{api_client}->to_query_value($args{'mode'});
    }

    # query params
    if ( exists $args{'column_length'}) {
        $query_params->{'column_length'} = $self->{api_client}->to_query_value($args{'column_length'});
    }

    # query params
    if ( exists $args{'column_diameter'}) {
        $query_params->{'column_diameter'} = $self->{api_client}->to_query_value($args{'column_diameter'});
    }

    # query params
    if ( exists $args{'column_particule_size'}) {
        $query_params->{'column_particule_size'} = $self->{api_client}->to_query_value($args{'column_particule_size'});
    }

    # query params
    if ( exists $args{'flow_rate'}) {
        $query_params->{'flow_rate'} = $self->{api_client}->to_query_value($args{'flow_rate'});
    }

    # query params
    if ( exists $args{'offset'}) {
        $query_params->{'offset'} = $self->{api_client}->to_query_value($args{'offset'});
    }

    # query params
    if ( exists $args{'limit'}) {
        $query_params->{'limit'} = $self->{api_client}->to_query_value($args{'limit'});
    }

    # path params
    if ( exists $args{'spectra_type'}) {
        my $_base_variable = "{" . "spectraType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'spectra_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'properties'}) {
        my $_base_variable = "{" . "properties" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'properties'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('object', $response);
    return $_response_object;
}

#
# get_chromatography
#
# Get a chromatography by its PeakForest ID or its InChIKey
#
# @param string $id The chromatography PeakForest ID or its code. (required)
{
    my $params = {
    'id' => {
        data_type => 'string',
        description => 'The chromatography PeakForest ID or its code.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_chromatography' } = {
        summary => 'Get a chromatography by its PeakForest ID or its InChIKey',
        params => $params,
        returns => 'Chromatography',
        };
}
# @return Chromatography
#
sub get_chromatography {
    my ($self, %args) = @_;

    # verify the required parameter 'id' is set
    unless (exists $args{'id'}) {
      croak("Missing the required parameter 'id' when calling get_chromatography");
    }

    # parse inputs
    my $_resource_path = '/chromatography/{id}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'id'}) {
        my $_base_variable = "{" . "id" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chromatography', $response);
    return $_response_object;
}

1;
