# $Id: Provider.pm,v 1.4 2002/10/22 07:45:11 lapp Exp $
#
# BioPerl module for Bio::Biblio::Provider
#
# Cared for by Martin Senger <senger@ebi.ac.uk>
# For copyright and disclaimer see below.

# POD documentation - main docs before the code

=head1 NAME

Bio::Biblio::Provider - Representation of a general provider

=head1 SYNOPSIS

    # usually this class is not instantiated but can be...
    $obj = new Bio::Biblio::Provider (-type => 'Department');

 --- OR ---

    $obj = new Bio::Biblio::Provider;
    $obj->type ('Department');

=head1 DESCRIPTION

A storage object for a general bibliographic resource provider
(a rpovider can be a person, a organisation, or even a program).

=head2 Attributes

The following attributes are specific to this class, 
and they are inherited by all provider types.

  type

=head1 SEE ALSO

=over

=item *

OpenBQS home page: http://industry.ebi.ac.uk/openBQS

=item *

Comments to the Perl client: http://industry.ebi.ac.uk/openBQS/Client_perl.html

=back

=head1 FEEDBACK

=head2 Mailing Lists

User feedback is an integral part of the evolution of this and other
Bioperl modules. Send your comments and suggestions preferably to
the Bioperl mailing list.  Your participation is much appreciated.

  bioperl-l@bioperl.org              - General discussion
  http://bioperl.org/MailList.shtml  - About the mailing lists

=head2 Reporting Bugs

Report bugs to the Bioperl bug tracking system to help us keep track
of the bugs and their resolution. Bug reports can be submitted via
email or the web:

  bioperl-bugs@bioperl.org
  http://bugzilla.bioperl.org/

=head1 AUTHORS

Heikki Lehvaslaiho (heikki@ebi.ac.uk),
Martin Senger (senger@ebi.ac.uk)

=head1 COPYRIGHT

Copyright (c) 2002 European Bioinformatics Institute. All Rights Reserved.

This module is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 DISCLAIMER

This software is provided "as is" without warranty of any kind.

=cut


# Let the code begin...


package Bio::Biblio::Provider;
use strict;
use vars qw(@ISA $AUTOLOAD);

use Bio::Biblio::BiblioBase;

@ISA = qw(Bio::Biblio::BiblioBase);

#
# a closure with a list of allowed attribute names (these names
# correspond with the allowed 'get' and 'set' methods); each name also
# keep what type the attribute should be (use 'undef' if it is a
# simple scalar)
#
{
    my %_allowed =
	(
	 _type => undef,
	 );

    # return 1 if $attr is allowed to be set/get in this class
    sub _accessible {
	my ($self, $attr) = @_;
	exists $_allowed{$attr};
    }

    # return an expected type of given $attr
    sub _attr_type {
	my ($self, $attr) = @_;
	$_allowed{$attr};
    }
}

1;
__END__
