#!/usr/bin/perl
use strict; use warnings;

use lib 'lib';
use Test::Most;
use Finance::Asset;

subtest 'pip_size' => sub {

    my $asset = Finance::Asset->new('frxAUDUSD');
    is $asset->pip_size, 0.0001, 'pip_size';
};

subtest 'market_convention' => sub {

    my $asset = Finance::Asset->new('frxAUDUSD');
    is $asset->market_convention->{atm_setting}, 'atm_delta_neutral_straddle',
        'atm_setting';
    is $asset->market_convention->{bf}, '2_vol',
        'bf';
    is $asset->market_convention->{delta_premium_adjusted}, 0,
        'delta_premium_adjusted';
    is $asset->market_convention->{delta_style}, 'spot_delta',
        'delta_style';
    is $asset->market_convention->{rr}, 'call-put',
        'rr';
};

subtest 'divisor' => sub {

    my $asset = Finance::Asset->new('frxAUDUSD');
    is $asset->divisor, 1, 'divisor';

    $asset = Finance::Asset->new('FUTGRTSI');
    is $asset->divisor, 100, 'divisor';
};

subtest 'display_decimals' => sub {

    my $asset = Finance::Asset->new('frxAUDUSD');
    is $asset->display_decimals, 4, 'display_decimals';

    $asset = Finance::Asset->new('frxXAUUSD');
    is $asset->display_decimals, 2, 'display_decimals';
};

subtest 'display_name' => sub {

    my $asset = Finance::Asset->new('frxAUDUSD');
    is $asset->display_name, 'AUD/USD', 'display_name';

};

subtest 'exchange_name' => sub {

    my $asset = Finance::Asset->new('frxAUDUSD');
    is $asset->exchange_name, 'FOREX', 'exchange_name';

};

done_testing();

