/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSerializer;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlOption
extends HtmlElement
implements DisabledElement {
    public static final String TAG_NAME = "option";
    private final boolean initialSelectedState_ = this.hasAttribute("selected");
    private boolean selected_;

    HtmlOption(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public boolean isSelected() {
        return this.hasAttribute("selected") || this.selected_;
    }

    public Page setSelected(boolean selected) {
        this.setSelected(selected, true);
        return this.getPage();
    }

    public void setSelected(boolean selected, boolean invokeOnFocus) {
        if (selected == this.isSelected()) {
            return;
        }
        HtmlSelect select = this.getEnclosingSelect();
        if (select != null) {
            if (!select.isMultipleSelectEnabled() && select.getOptionSize() == 1) {
                selected = true;
            }
            select.setSelectedAttribute(this, selected, invokeOnFocus);
            return;
        }
        this.setSelectedInternal(selected);
    }

    @Override
    public void insertBefore(DomNode newNode) throws IllegalStateException {
        HtmlOption option;
        super.insertBefore(newNode);
        if (newNode instanceof HtmlOption && (option = (HtmlOption)newNode).isSelected()) {
            this.getEnclosingSelect().setSelectedAttribute(option, true);
        }
    }

    public HtmlSelect getEnclosingSelect() {
        return (HtmlSelect)this.getEnclosingElement("select");
    }

    public void reset() {
        this.setSelectedInternal(this.initialSelectedState_);
    }

    public final String getSelectedAttribute() {
        return this.getAttribute("selected");
    }

    public final boolean isDefaultSelected() {
        return this.initialSelectedState_;
    }

    @Override
    public final boolean isDisabled() {
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLOPTION_PREVENT_DISABLED)) {
            return false;
        }
        return this.hasAttribute("disabled");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    public final String getLabelAttribute() {
        return this.getAttribute("label");
    }

    public final void setLabelAttribute(String newLabel) {
        this.setAttribute("label", newLabel);
    }

    public final String getValueAttribute() {
        String value = this.getAttribute("value");
        if (value == ATTRIBUTE_NOT_DEFINED) {
            value = this.getText();
        }
        return value;
    }

    public final void setValueAttribute(String newValue) {
        this.setAttribute("value", newValue);
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        boolean changed = false;
        if (!this.isSelected()) {
            this.setSelected(true);
            changed = true;
        } else if (this.getEnclosingSelect().isMultipleSelectEnabled()) {
            this.setSelected(false);
            changed = true;
        }
        super.doClickStateUpdate();
        return changed;
    }

    @Override
    protected ScriptResult doClickFireClickEvent(Event event) throws IOException {
        ScriptResult scriptResult = super.doClickFireClickEvent(event);
        boolean triggerClickOption = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_FOR_SELECT_OPTION_ALSO);
        if (!triggerClickOption) {
            return scriptResult;
        }
        if (event.isAborted(scriptResult)) {
            return scriptResult;
        }
        MouseEvent optionClickEvent = new MouseEvent(this, "click", event.jsxGet_shiftKey(), event.jsxGet_ctrlKey(), event.jsxGet_altKey(), 0);
        return super.doClickFireClickEvent(optionClickEvent);
    }

    @Override
    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        super.printOpeningTagContentAsXml(printWriter);
        if (this.selected_ && this.getAttribute("selected") == ATTRIBUTE_NOT_DEFINED) {
            printWriter.print(" selected=\"selected\"");
        }
    }

    void setSelectedInternal(boolean selected) {
        this.selected_ = selected;
        if (!selected) {
            this.removeAttribute("selected");
        }
    }

    @Override
    public String asText() {
        return super.asText();
    }

    public void setText(String text) {
        if ((text == null || text.length() == 0) && this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLOPTION_EMPTY_TEXT_IS_NO_CHILDREN)) {
            this.removeAllChildren();
        } else {
            DomNode child = this.getFirstChild();
            if (child == null) {
                this.appendChild(new DomText(this.getPage(), text));
            } else {
                child.setNodeValue(text);
            }
        }
    }

    public String getText() {
        HtmlSerializer ser = new HtmlSerializer();
        ser.setIgnoreMaskedElements(false);
        return ser.asText(this);
    }

    @Override
    protected DomNode getEventTargetElement() {
        HtmlSelect select = this.getEnclosingSelect();
        if (select != null) {
            return select;
        }
        return super.getEventTargetElement();
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_103);
    }
}

