/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.net.MalformedURLException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.xalan.xsltc.runtime.AttributeList;
import org.xml.sax.Attributes;

public class HTMLImageElement
extends HTMLElement {
    private static final long serialVersionUID = 5630843390548382869L;
    private boolean instantiatedViaJavaScript_ = false;

    public void jsConstructor() {
        this.instantiatedViaJavaScript_ = true;
        SgmlPage page = (SgmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        HtmlElement fake = HTMLParser.getFactory("img").createElement(page, "img", (Attributes)new AttributeList());
        this.setDomNode(fake);
    }

    public void jsxSet_src(String src) {
        this.getDomNodeOrDie().setAttribute("src", src);
        this.getWindow().getJavaScriptEngine().addPostponedAction(new ImageOnLoadAction());
    }

    public String jsxGet_src() {
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        String src = img.getSrcAttribute();
        if (this.instantiatedViaJavaScript_ && "".equals(src)) {
            return src;
        }
        try {
            HtmlPage page = (HtmlPage)img.getPage();
            return page.getFullyQualifiedUrl(src).toExternalForm();
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create fully qualified URL for src attribute of image " + e.getMessage();
            throw Context.reportRuntimeError((String)msg);
        }
    }

    public void jsxSet_onload(Object onloadHandler) {
        this.setEventHandlerProp("onload", onloadHandler);
        this.getWindow().getJavaScriptEngine().addPostponedAction(new ImageOnLoadAction());
    }

    public Object jsxGet_onload() {
        return this.getEventHandlerProp("onload");
    }

    public String jsxGet_alt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        if (alt == NOT_FOUND) {
            alt = "";
        }
        return alt;
    }

    public void jsxSet_alt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    public String jsxGet_border() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        if (border == NOT_FOUND) {
            border = "";
        }
        return border;
    }

    public void jsxSet_border(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    public String jsxGet_align() {
        return this.getAlign(true);
    }

    public void jsxSet_align(String align) {
        this.setAlign(align, false);
    }

    private class ImageOnLoadAction
    implements PostponedAction {
        private ImageOnLoadAction() {
        }

        public void execute() throws Exception {
            HtmlImage img = (HtmlImage)HTMLImageElement.this.getDomNodeOrNull();
            if (img != null) {
                img.doOnLoad();
            }
        }
    }
}

