#  Makefile.PL for WebMod::Session
#
package WebDyne::Session;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				    =>  __PACKAGE__,
    VERSION_FROM			    =>  'VERSION.pm',
    PM					    =>  {
	'Session.pm'			    =>  '$(INST_LIBDIR)/Session.pm',
	'Constant.pm'			    =>  '$(INST_LIBDIR)/Session/Constant.pm',
	'VERSION.pm'			    =>  '$(INST_LIBDIR)/Session/VERSION.pm',
	'LICENSE'			    =>  '$(INST_LIBDIR)/Session/LICENSE'
       },

    'dist'				    =>  {
	COMPRESS			    =>  'gzip -9f',
	SUFFIX				    =>  '.gz'
       },

    'depend'				    =>  {
	Makefile			    =>  '$(VERSION_FROM)'
       },

    'macro'				    =>  {
        COPYRIGHT			    =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				    =>  'GPL: GNU General Public License',
    	statl				    =>  'g',
    },

    ($] >=  5.005 ?
	 (AUTHOR			    => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
	),

);

