#=======================================================================
#    ____  ____  _____              _    ____ ___   ____
#   |  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#   | |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#   |  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#   |_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
#   A Perl Module Chain to faciliate the Creation and Modification
#   of High-Quality "Portable Document Format (PDF)" Files.
#
#   Copyright 1999-2004 Alfred Reibenschuh <areibens@cpan.org>.
#
#=======================================================================
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   $Id: korean.pm,v 1.6 2004/06/15 09:14:45 fredo Exp $
#
#=======================================================================

$cmap->{korean}={
    'g2u' => [
        0x0000, # G+0  U+0000  .notdef,  UNDEFINED
        0x0020, # G+1  U+0020  space,  SPACE
        0x0021, # G+2  U+0021  exclam,  EXCLAMATION MARK
        0x0022, # G+3  U+0022  quotedbl,  QUOTATION MARK
        0x0023, # G+4  U+0023  numbersign,  NUMBER SIGN
        0x0024, # G+5  U+0024  dollar,  DOLLAR SIGN
        0x0025, # G+6  U+0025  percent,  PERCENT SIGN
        0x0026, # G+7  U+0026  ampersand,  AMPERSAND
        0x0027, # G+8  U+0027  quotesingle,  APOSTROPHE
        0x0028, # G+9  U+0028  parenleft,  LEFT PARENTHESIS
        0x0029, # G+10  U+0029  parenright,  RIGHT PARENTHESIS
        0x002A, # G+11  U+002A  asterisk,  ASTERISK
        0x002B, # G+12  U+002B  plus,  PLUS SIGN
        0x002C, # G+13  U+002C  comma,  COMMA
        0x002D, # G+14  U+002D  hyphen,  HYPHEN-MINUS
        0x002E, # G+15  U+002E  period,  FULL STOP
        0x002F, # G+16  U+002F  slash,  SOLIDUS
        0x0030, # G+17  U+0030  zero,  DIGIT ZERO
        0x0031, # G+18  U+0031  one,  DIGIT ONE
        0x0032, # G+19  U+0032  two,  DIGIT TWO
        0x0033, # G+20  U+0033  three,  DIGIT THREE
        0x0034, # G+21  U+0034  four,  DIGIT FOUR
        0x0035, # G+22  U+0035  five,  DIGIT FIVE
        0x0036, # G+23  U+0036  six,  DIGIT SIX
        0x0037, # G+24  U+0037  seven,  DIGIT SEVEN
        0x0038, # G+25  U+0038  eight,  DIGIT EIGHT
        0x0039, # G+26  U+0039  nine,  DIGIT NINE
        0x003A, # G+27  U+003A  colon,  COLON
        0x003B, # G+28  U+003B  semicolon,  SEMICOLON
        0x003C, # G+29  U+003C  less,  LESS-THAN SIGN
        0x003D, # G+30  U+003D  equal,  EQUALS SIGN
        0x003E, # G+31  U+003E  greater,  GREATER-THAN SIGN
        0x003F, # G+32  U+003F  question,  QUESTION MARK
        0x0040, # G+33  U+0040  at,  COMMERCIAL AT
        0x0041, # G+34  U+0041  A,  LATIN CAPITAL LETTER A
        0x0042, # G+35  U+0042  B,  LATIN CAPITAL LETTER B
        0x0043, # G+36  U+0043  C,  LATIN CAPITAL LETTER C
        0x0044, # G+37  U+0044  D,  LATIN CAPITAL LETTER D
        0x0045, # G+38  U+0045  E,  LATIN CAPITAL LETTER E
        0x0046, # G+39  U+0046  F,  LATIN CAPITAL LETTER F
        0x0047, # G+40  U+0047  G,  LATIN CAPITAL LETTER G
        0x0048, # G+41  U+0048  H,  LATIN CAPITAL LETTER H
        0x0049, # G+42  U+0049  I,  LATIN CAPITAL LETTER I
        0x004A, # G+43  U+004A  J,  LATIN CAPITAL LETTER J
        0x004B, # G+44  U+004B  K,  LATIN CAPITAL LETTER K
        0x004C, # G+45  U+004C  L,  LATIN CAPITAL LETTER L
        0x004D, # G+46  U+004D  M,  LATIN CAPITAL LETTER M
        0x004E, # G+47  U+004E  N,  LATIN CAPITAL LETTER N
        0x004F, # G+48  U+004F  O,  LATIN CAPITAL LETTER O
        0x0050, # G+49  U+0050  P,  LATIN CAPITAL LETTER P
        0x0051, # G+50  U+0051  Q,  LATIN CAPITAL LETTER Q
        0x0052, # G+51  U+0052  R,  LATIN CAPITAL LETTER R
        0x0053, # G+52  U+0053  S,  LATIN CAPITAL LETTER S
        0x0054, # G+53  U+0054  T,  LATIN CAPITAL LETTER T
        0x0055, # G+54  U+0055  U,  LATIN CAPITAL LETTER U
        0x0056, # G+55  U+0056  V,  LATIN CAPITAL LETTER V
        0x0057, # G+56  U+0057  W,  LATIN CAPITAL LETTER W
        0x0058, # G+57  U+0058  X,  LATIN CAPITAL LETTER X
        0x0059, # G+58  U+0059  Y,  LATIN CAPITAL LETTER Y
        0x005A, # G+59  U+005A  Z,  LATIN CAPITAL LETTER Z
        0x005B, # G+60  U+005B  bracketleft,  LEFT SQUARE BRACKET
        0x005C, # G+61  U+005C  backslash,  REVERSE SOLIDUS
        0x005D, # G+62  U+005D  bracketright,  RIGHT SQUARE BRACKET
        0x005E, # G+63  U+005E  asciicircum,  CIRCUMFLEX ACCENT
        0x005F, # G+64  U+005F  underscore,  LOW LINE
        0x0060, # G+65  U+0060  grave,  GRAVE ACCENT
        0x0061, # G+66  U+0061  a,  LATIN SMALL LETTER A
        0x0062, # G+67  U+0062  b,  LATIN SMALL LETTER B
        0x0063, # G+68  U+0063  c,  LATIN SMALL LETTER C
        0x0064, # G+69  U+0064  d,  LATIN SMALL LETTER D
        0x0065, # G+70  U+0065  e,  LATIN SMALL LETTER E
        0x0066, # G+71  U+0066  f,  LATIN SMALL LETTER F
        0x0067, # G+72  U+0067  g,  LATIN SMALL LETTER G
        0x0068, # G+73  U+0068  h,  LATIN SMALL LETTER H
        0x0069, # G+74  U+0069  i,  LATIN SMALL LETTER I
        0x006A, # G+75  U+006A  j,  LATIN SMALL LETTER J
        0x006B, # G+76  U+006B  k,  LATIN SMALL LETTER K
        0x006C, # G+77  U+006C  l,  LATIN SMALL LETTER L
        0x006D, # G+78  U+006D  m,  LATIN SMALL LETTER M
        0x006E, # G+79  U+006E  n,  LATIN SMALL LETTER N
        0x006F, # G+80  U+006F  o,  LATIN SMALL LETTER O
        0x0070, # G+81  U+0070  p,  LATIN SMALL LETTER P
        0x0071, # G+82  U+0071  q,  LATIN SMALL LETTER Q
        0x0072, # G+83  U+0072  r,  LATIN SMALL LETTER R
        0x0073, # G+84  U+0073  s,  LATIN SMALL LETTER S
        0x0074, # G+85  U+0074  t,  LATIN SMALL LETTER T
        0x0075, # G+86  U+0075  u,  LATIN SMALL LETTER U
        0x0076, # G+87  U+0076  v,  LATIN SMALL LETTER V
        0x0077, # G+88  U+0077  w,  LATIN SMALL LETTER W
        0x0078, # G+89  U+0078  x,  LATIN SMALL LETTER X
        0x0079, # G+90  U+0079  y,  LATIN SMALL LETTER Y
        0x007A, # G+91  U+007A  z,  LATIN SMALL LETTER Z
        0x007B, # G+92  U+007B  braceleft,  LEFT CURLY BRACKET
        0x007C, # G+93  U+007C  bar,  VERTICAL LINE
        0x007D, # G+94  U+007D  braceright,  RIGHT CURLY BRACKET
        0x007E, # G+95  U+007E  asciitilde,  TILDE
        0x20A9, # G+96  U+20A9  uni20A9,  WON SIGN
        0x2010, # G+97  U+2010  uni2010,  HYPHEN
        0x00A9, # G+98  U+00A9  copyright,  COPYRIGHT SIGN
        0x0000, # G+99  U+0000  .notdef,  UNDEFINED
        0x0000, # G+100  U+0000  .notdef,  UNDEFINED
        0x3164, # G+101  U+3164  uni3164,  HANGUL FILLER
        0x3001, # G+102  U+3001  uni3001,  IDEOGRAPHIC COMMA
        0x3002, # G+103  U+3002  uni3002,  IDEOGRAPHIC FULL STOP
        0x30FB, # G+104  U+30FB  uni30FB,  KATAKANA MIDDLE DOT
        0x2025, # G+105  U+2025  twodotenleader,  TWO DOT LEADER
        0x22EF, # G+106  U+22EF  uni22EF,  MIDLINE HORIZONTAL ELLIPSIS
        0x00A8, # G+107  U+00A8  dieresis,  DIAERESIS
        0x3003, # G+108  U+3003  uni3003,  DITTO MARK
        0x2013, # G+109  U+2013  endash,  EN DASH
        0x2014, # G+110  U+2014  emdash,  EM DASH
        0x2016, # G+111  U+2016  uni2016,  DOUBLE VERTICAL LINE
        0xFF3C, # G+112  U+FF3C  uniFF3C,  FULLWIDTH REVERSE SOLIDUS
        0xFF5E, # G+113  U+FF5E  uniFF5E,  FULLWIDTH TILDE
        0x2018, # G+114  U+2018  quoteleft,  LEFT SINGLE QUOTATION MARK
        0x2019, # G+115  U+2019  quoteright,  RIGHT SINGLE QUOTATION MARK
        0x201C, # G+116  U+201C  quotedblleft,  LEFT DOUBLE QUOTATION MARK
        0x201D, # G+117  U+201D  quotedblright,  RIGHT DOUBLE QUOTATION MARK
        0x3014, # G+118  U+3014  uni3014,  LEFT TORTOISE SHELL BRACKET
        0x3015, # G+119  U+3015  uni3015,  RIGHT TORTOISE SHELL BRACKET
        0x3008, # G+120  U+3008  uni3008,  LEFT ANGLE BRACKET
        0x3009, # G+121  U+3009  uni3009,  RIGHT ANGLE BRACKET
        0x300A, # G+122  U+300A  uni300A,  LEFT DOUBLE ANGLE BRACKET
        0x300B, # G+123  U+300B  uni300B,  RIGHT DOUBLE ANGLE BRACKET
        0x300C, # G+124  U+300C  uni300C,  LEFT CORNER BRACKET
        0x300D, # G+125  U+300D  uni300D,  RIGHT CORNER BRACKET
        0x300E, # G+126  U+300E  uni300E,  LEFT WHITE CORNER BRACKET
        0x300F, # G+127  U+300F  uni300F,  RIGHT WHITE CORNER BRACKET
        0x3010, # G+128  U+3010  uni3010,  LEFT BLACK LENTICULAR BRACKET
        0x3011, # G+129  U+3011  uni3011,  RIGHT BLACK LENTICULAR BRACKET
        0x00B1, # G+130  U+00B1  plusminus,  PLUS-MINUS SIGN
        0x00D7, # G+131  U+00D7  multiply,  MULTIPLICATION SIGN
        0x00F7, # G+132  U+00F7  divide,  DIVISION SIGN
        0x2260, # G+133  U+2260  notequal,  NOT EQUAL TO
        0x2264, # G+134  U+2264  lessequal,  LESS-THAN OR EQUAL TO
        0x2265, # G+135  U+2265  greaterequal,  GREATER-THAN OR EQUAL TO
        0x221E, # G+136  U+221E  infinity,  INFINITY
        0x2234, # G+137  U+2234  therefore,  THEREFORE
        0x00B0, # G+138  U+00B0  degree,  DEGREE SIGN
        0x2032, # G+139  U+2032  minute,  PRIME
        0x2033, # G+140  U+2033  second,  DOUBLE PRIME
        0x2103, # G+141  U+2103  uni2103,  DEGREE CELSIUS
        0x212B, # G+142  U+212B  uni212B,  ANGSTROM SIGN
        0xFFE0, # G+143  U+FFE0  uniFFE0,  FULLWIDTH CENT SIGN
        0xFFE1, # G+144  U+FFE1  uniFFE1,  FULLWIDTH POUND SIGN
        0xFFE5, # G+145  U+FFE5  uniFFE5,  FULLWIDTH YEN SIGN
        0x2642, # G+146  U+2642  male,  MALE SIGN
        0x2640, # G+147  U+2640  female,  FEMALE SIGN
        0x2220, # G+148  U+2220  angle,  ANGLE
        0x22A5, # G+149  U+22A5  perpendicular,  UP TACK
        0x2312, # G+150  U+2312  uni2312,  ARC
        0x2202, # G+151  U+2202  partialdiff,  PARTIAL DIFFERENTIAL
        0x2207, # G+152  U+2207  gradient,  NABLA
        0x2261, # G+153  U+2261  equivalence,  IDENTICAL TO
        0x2252, # G+154  U+2252  uni2252,  APPROXIMATELY EQUAL TO OR THE IMAGE OF
        0x00A7, # G+155  U+00A7  section,  SECTION SIGN
        0x203B, # G+156  U+203B  uni203B,  REFERENCE MARK
        0x2606, # G+157  U+2606  uni2606,  WHITE STAR
        0x2605, # G+158  U+2605  a35,  BLACK STAR
        0x25CB, # G+159  U+25CB  circle,  WHITE CIRCLE
        0x25CF, # G+160  U+25CF  H18533,  BLACK CIRCLE
        0x25CE, # G+161  U+25CE  uni25CE,  BULLSEYE
        0x25C7, # G+162  U+25C7  uni25C7,  WHITE DIAMOND
        0x25C6, # G+163  U+25C6  a78,  BLACK DIAMOND
        0x25A1, # G+164  U+25A1  H22073,  WHITE SQUARE
        0x25A0, # G+165  U+25A0  filledbox,  BLACK SQUARE
        0x25B3, # G+166  U+25B3  uni25B3,  WHITE UP-POINTING TRIANGLE
        0x25B2, # G+167  U+25B2  triagup,  BLACK UP-POINTING TRIANGLE
        0x25BD, # G+168  U+25BD  uni25BD,  WHITE DOWN-POINTING TRIANGLE
        0x25BC, # G+169  U+25BC  triagdn,  BLACK DOWN-POINTING TRIANGLE
        0x2192, # G+170  U+2192  arrowright,  RIGHTWARDS ARROW
        0x2190, # G+171  U+2190  arrowleft,  LEFTWARDS ARROW
        0x2191, # G+172  U+2191  arrowup,  UPWARDS ARROW
        0x2193, # G+173  U+2193  arrowdown,  DOWNWARDS ARROW
        0x2194, # G+174  U+2194  arrowboth,  LEFT RIGHT ARROW
        0x3013, # G+175  U+3013  uni3013,  GETA MARK
        0x00AB, # G+176  U+00AB  guillemotleft,  LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        0x00BB, # G+177  U+00BB  guillemotright,  RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        0x221A, # G+178  U+221A  radical,  SQUARE ROOT
        0x223D, # G+179  U+223D  uni223D,  REVERSED TILDE
        0x221D, # G+180  U+221D  proportional,  PROPORTIONAL TO
        0x2235, # G+181  U+2235  uni2235,  BECAUSE
        0x222B, # G+182  U+222B  integral,  INTEGRAL
        0x222C, # G+183  U+222C  uni222C,  DOUBLE INTEGRAL
        0x2208, # G+184  U+2208  element,  ELEMENT OF
        0x220B, # G+185  U+220B  suchthat,  CONTAINS AS MEMBER
        0x2286, # G+186  U+2286  reflexsubset,  SUBSET OF OR EQUAL TO
        0x2287, # G+187  U+2287  reflexsuperset,  SUPERSET OF OR EQUAL TO
        0x2282, # G+188  U+2282  propersubset,  SUBSET OF
        0x2283, # G+189  U+2283  propersuperset,  SUPERSET OF
        0x222A, # G+190  U+222A  union,  UNION
        0x2229, # G+191  U+2229  intersection,  INTERSECTION
        0x2227, # G+192  U+2227  logicaland,  LOGICAL AND
        0x2228, # G+193  U+2228  logicalor,  LOGICAL OR
        0xFFE2, # G+194  U+FFE2  uniFFE2,  FULLWIDTH NOT SIGN
        0x21D2, # G+195  U+21D2  arrowdblright,  RIGHTWARDS DOUBLE ARROW
        0x21D4, # G+196  U+21D4  arrowdblboth,  LEFT RIGHT DOUBLE ARROW
        0x2200, # G+197  U+2200  universal,  FOR ALL
        0x2203, # G+198  U+2203  existential,  THERE EXISTS
        0x00B4, # G+199  U+00B4  acute,  ACUTE ACCENT
        0x02DC, # G+200  U+02DC  tilde,  SMALL TILDE
        0x02C7, # G+201  U+02C7  caron,  CARON
        0x02D8, # G+202  U+02D8  breve,  BREVE
        0x02DD, # G+203  U+02DD  hungarumlaut,  DOUBLE ACUTE ACCENT
        0x02DA, # G+204  U+02DA  ring,  RING ABOVE
        0x02D9, # G+205  U+02D9  dotaccent,  DOT ABOVE
        0x00B8, # G+206  U+00B8  cedilla,  CEDILLA
        0x02DB, # G+207  U+02DB  ogonek,  OGONEK
        0x00A1, # G+208  U+00A1  exclamdown,  INVERTED EXCLAMATION MARK
        0x00BF, # G+209  U+00BF  questiondown,  INVERTED QUESTION MARK
        0x2236, # G+210  U+2236  uni2236,  RATIO
        0x222E, # G+211  U+222E  uni222E,  CONTOUR INTEGRAL
        0x2211, # G+212  U+2211  summation,  N-ARY SUMMATION
        0x220F, # G+213  U+220F  product,  N-ARY PRODUCT
        0x00A4, # G+214  U+00A4  currency,  CURRENCY SIGN
        0x2109, # G+215  U+2109  uni2109,  DEGREE FAHRENHEIT
        0x2030, # G+216  U+2030  perthousand,  PER MILLE SIGN
        0x25C1, # G+217  U+25C1  uni25C1,  WHITE LEFT-POINTING TRIANGLE
        0x25C0, # G+218  U+25C0  uni25C0,  BLACK LEFT-POINTING TRIANGLE
        0x25B7, # G+219  U+25B7  uni25B7,  WHITE RIGHT-POINTING TRIANGLE
        0x25B6, # G+220  U+25B6  uni25B6,  BLACK RIGHT-POINTING TRIANGLE
        0x2664, # G+221  U+2664  uni2664,  WHITE SPADE SUIT
        0x2660, # G+222  U+2660  spade,  BLACK SPADE SUIT
        0x2661, # G+223  U+2661  uni2661,  WHITE HEART SUIT
        0x2665, # G+224  U+2665  heart,  BLACK HEART SUIT
        0x2667, # G+225  U+2667  uni2667,  WHITE CLUB SUIT
        0x2663, # G+226  U+2663  club,  BLACK CLUB SUIT
        0x25C9, # G+227  U+25C9  uni25C9,  FISHEYE
        0x25C8, # G+228  U+25C8  uni25C8,  WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
        0x25A3, # G+229  U+25A3  uni25A3,  WHITE SQUARE CONTAINING BLACK SMALL SQUARE
        0x25D0, # G+230  U+25D0  uni25D0,  CIRCLE WITH LEFT HALF BLACK
        0x25D1, # G+231  U+25D1  uni25D1,  CIRCLE WITH RIGHT HALF BLACK
        0x2592, # G+232  U+2592  shade,  MEDIUM SHADE
        0x25A4, # G+233  U+25A4  uni25A4,  SQUARE WITH HORIZONTAL FILL
        0x25A5, # G+234  U+25A5  uni25A5,  SQUARE WITH VERTICAL FILL
        0x25A8, # G+235  U+25A8  uni25A8,  SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
        0x25A7, # G+236  U+25A7  uni25A7,  SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
        0x25A6, # G+237  U+25A6  uni25A6,  SQUARE WITH ORTHOGONAL CROSSHATCH FILL
        0x25A9, # G+238  U+25A9  uni25A9,  SQUARE WITH DIAGONAL CROSSHATCH FILL
        0x2668, # G+239  U+2668  uni2668,  HOT SPRINGS
        0x260F, # G+240  U+260F  uni260F,  WHITE TELEPHONE
        0x260E, # G+241  U+260E  a4,  BLACK TELEPHONE
        0x261C, # G+242  U+261C  uni261C,  WHITE LEFT POINTING INDEX
        0x261E, # G+243  U+261E  a12,  WHITE RIGHT POINTING INDEX
        0x00B6, # G+244  U+00B6  paragraph,  PILCROW SIGN
        0x2020, # G+245  U+2020  dagger,  DAGGER
        0x2021, # G+246  U+2021  daggerdbl,  DOUBLE DAGGER
        0x2195, # G+247  U+2195  arrowupdn,  UP DOWN ARROW
        0x2197, # G+248  U+2197  uni2197,  NORTH EAST ARROW
        0x2199, # G+249  U+2199  uni2199,  SOUTH WEST ARROW
        0x2196, # G+250  U+2196  uni2196,  NORTH WEST ARROW
        0x2198, # G+251  U+2198  uni2198,  SOUTH EAST ARROW
        0x266D, # G+252  U+266D  uni266D,  MUSIC FLAT SIGN
        0x2669, # G+253  U+2669  uni2669,  QUARTER NOTE
        0x266A, # G+254  U+266A  musicalnote,  EIGHTH NOTE
        0x266C, # G+255  U+266C  uni266C,  BEAMED SIXTEENTH NOTES
        0x327F, # G+256  U+327F  uni327F,  KOREAN STANDARD SYMBOL
        0x321C, # G+257  U+321C  uni321C,  PARENTHESIZED HANGUL CIEUC U
        0x2116, # G+258  U+2116  afii61352,  NUMERO SIGN
        0x33C7, # G+259  U+33C7  uni33C7,  SQUARE CO
        0x2122, # G+260  U+2122  trademark,  TRADE MARK SIGN
        0x33C2, # G+261  U+33C2  uni33C2,  SQUARE AM
        0x33D8, # G+262  U+33D8  uni33D8,  SQUARE PM
        0x2121, # G+263  U+2121  uni2121,  TELEPHONE SIGN
        0xFF01, # G+264  U+FF01  uniFF01,  FULLWIDTH EXCLAMATION MARK
        0xFF02, # G+265  U+FF02  uniFF02,  FULLWIDTH QUOTATION MARK
        0xFF03, # G+266  U+FF03  uniFF03,  FULLWIDTH NUMBER SIGN
        0xFF04, # G+267  U+FF04  uniFF04,  FULLWIDTH DOLLAR SIGN
        0xFF05, # G+268  U+FF05  uniFF05,  FULLWIDTH PERCENT SIGN
        0xFF06, # G+269  U+FF06  uniFF06,  FULLWIDTH AMPERSAND
        0xFF07, # G+270  U+FF07  uniFF07,  FULLWIDTH APOSTROPHE
        0xFF08, # G+271  U+FF08  uniFF08,  FULLWIDTH LEFT PARENTHESIS
        0xFF09, # G+272  U+FF09  uniFF09,  FULLWIDTH RIGHT PARENTHESIS
        0xFF0A, # G+273  U+FF0A  uniFF0A,  FULLWIDTH ASTERISK
        0xFF0B, # G+274  U+FF0B  uniFF0B,  FULLWIDTH PLUS SIGN
        0xFF0C, # G+275  U+FF0C  uniFF0C,  FULLWIDTH COMMA
        0xFF0D, # G+276  U+FF0D  uniFF0D,  FULLWIDTH HYPHEN-MINUS
        0xFF0E, # G+277  U+FF0E  uniFF0E,  FULLWIDTH FULL STOP
        0xFF0F, # G+278  U+FF0F  uniFF0F,  FULLWIDTH SOLIDUS
        0xFF10, # G+279  U+FF10  uniFF10,  FULLWIDTH DIGIT ZERO
        0xFF11, # G+280  U+FF11  uniFF11,  FULLWIDTH DIGIT ONE
        0xFF12, # G+281  U+FF12  uniFF12,  FULLWIDTH DIGIT TWO
        0xFF13, # G+282  U+FF13  uniFF13,  FULLWIDTH DIGIT THREE
        0xFF14, # G+283  U+FF14  uniFF14,  FULLWIDTH DIGIT FOUR
        0xFF15, # G+284  U+FF15  uniFF15,  FULLWIDTH DIGIT FIVE
        0xFF16, # G+285  U+FF16  uniFF16,  FULLWIDTH DIGIT SIX
        0xFF17, # G+286  U+FF17  uniFF17,  FULLWIDTH DIGIT SEVEN
        0xFF18, # G+287  U+FF18  uniFF18,  FULLWIDTH DIGIT EIGHT
        0xFF19, # G+288  U+FF19  uniFF19,  FULLWIDTH DIGIT NINE
        0xFF1A, # G+289  U+FF1A  uniFF1A,  FULLWIDTH COLON
        0xFF1B, # G+290  U+FF1B  uniFF1B,  FULLWIDTH SEMICOLON
        0xFF1C, # G+291  U+FF1C  uniFF1C,  FULLWIDTH LESS-THAN SIGN
        0xFF1D, # G+292  U+FF1D  uniFF1D,  FULLWIDTH EQUALS SIGN
        0xFF1E, # G+293  U+FF1E  uniFF1E,  FULLWIDTH GREATER-THAN SIGN
        0xFF1F, # G+294  U+FF1F  uniFF1F,  FULLWIDTH QUESTION MARK
        0xFF20, # G+295  U+FF20  uniFF20,  FULLWIDTH COMMERCIAL AT
        0xFF21, # G+296  U+FF21  uniFF21,  FULLWIDTH LATIN CAPITAL LETTER A
        0xFF22, # G+297  U+FF22  uniFF22,  FULLWIDTH LATIN CAPITAL LETTER B
        0xFF23, # G+298  U+FF23  uniFF23,  FULLWIDTH LATIN CAPITAL LETTER C
        0xFF24, # G+299  U+FF24  uniFF24,  FULLWIDTH LATIN CAPITAL LETTER D
        0xFF25, # G+300  U+FF25  uniFF25,  FULLWIDTH LATIN CAPITAL LETTER E
        0xFF26, # G+301  U+FF26  uniFF26,  FULLWIDTH LATIN CAPITAL LETTER F
        0xFF27, # G+302  U+FF27  uniFF27,  FULLWIDTH LATIN CAPITAL LETTER G
        0xFF28, # G+303  U+FF28  uniFF28,  FULLWIDTH LATIN CAPITAL LETTER H
        0xFF29, # G+304  U+FF29  uniFF29,  FULLWIDTH LATIN CAPITAL LETTER I
        0xFF2A, # G+305  U+FF2A  uniFF2A,  FULLWIDTH LATIN CAPITAL LETTER J
        0xFF2B, # G+306  U+FF2B  uniFF2B,  FULLWIDTH LATIN CAPITAL LETTER K
        0xFF2C, # G+307  U+FF2C  uniFF2C,  FULLWIDTH LATIN CAPITAL LETTER L
        0xFF2D, # G+308  U+FF2D  uniFF2D,  FULLWIDTH LATIN CAPITAL LETTER M
        0xFF2E, # G+309  U+FF2E  uniFF2E,  FULLWIDTH LATIN CAPITAL LETTER N
        0xFF2F, # G+310  U+FF2F  uniFF2F,  FULLWIDTH LATIN CAPITAL LETTER O
        0xFF30, # G+311  U+FF30  uniFF30,  FULLWIDTH LATIN CAPITAL LETTER P
        0xFF31, # G+312  U+FF31  uniFF31,  FULLWIDTH LATIN CAPITAL LETTER Q
        0xFF32, # G+313  U+FF32  uniFF32,  FULLWIDTH LATIN CAPITAL LETTER R
        0xFF33, # G+314  U+FF33  uniFF33,  FULLWIDTH LATIN CAPITAL LETTER S
        0xFF34, # G+315  U+FF34  uniFF34,  FULLWIDTH LATIN CAPITAL LETTER T
        0xFF35, # G+316  U+FF35  uniFF35,  FULLWIDTH LATIN CAPITAL LETTER U
        0xFF36, # G+317  U+FF36  uniFF36,  FULLWIDTH LATIN CAPITAL LETTER V
        0xFF37, # G+318  U+FF37  uniFF37,  FULLWIDTH LATIN CAPITAL LETTER W
        0xFF38, # G+319  U+FF38  uniFF38,  FULLWIDTH LATIN CAPITAL LETTER X
        0xFF39, # G+320  U+FF39  uniFF39,  FULLWIDTH LATIN CAPITAL LETTER Y
        0xFF3A, # G+321  U+FF3A  uniFF3A,  FULLWIDTH LATIN CAPITAL LETTER Z
        0xFF3B, # G+322  U+FF3B  uniFF3B,  FULLWIDTH LEFT SQUARE BRACKET
        0xFFE6, # G+323  U+FFE6  uniFFE6,  FULLWIDTH WON SIGN
        0xFF3D, # G+324  U+FF3D  uniFF3D,  FULLWIDTH RIGHT SQUARE BRACKET
        0xFF3E, # G+325  U+FF3E  uniFF3E,  FULLWIDTH CIRCUMFLEX ACCENT
        0xFF3F, # G+326  U+FF3F  uniFF3F,  FULLWIDTH LOW LINE
        0xFF40, # G+327  U+FF40  uniFF40,  FULLWIDTH GRAVE ACCENT
        0xFF41, # G+328  U+FF41  uniFF41,  FULLWIDTH LATIN SMALL LETTER A
        0xFF42, # G+329  U+FF42  uniFF42,  FULLWIDTH LATIN SMALL LETTER B
        0xFF43, # G+330  U+FF43  uniFF43,  FULLWIDTH LATIN SMALL LETTER C
        0xFF44, # G+331  U+FF44  uniFF44,  FULLWIDTH LATIN SMALL LETTER D
        0xFF45, # G+332  U+FF45  uniFF45,  FULLWIDTH LATIN SMALL LETTER E
        0xFF46, # G+333  U+FF46  uniFF46,  FULLWIDTH LATIN SMALL LETTER F
        0xFF47, # G+334  U+FF47  uniFF47,  FULLWIDTH LATIN SMALL LETTER G
        0xFF48, # G+335  U+FF48  uniFF48,  FULLWIDTH LATIN SMALL LETTER H
        0xFF49, # G+336  U+FF49  uniFF49,  FULLWIDTH LATIN SMALL LETTER I
        0xFF4A, # G+337  U+FF4A  uniFF4A,  FULLWIDTH LATIN SMALL LETTER J
        0xFF4B, # G+338  U+FF4B  uniFF4B,  FULLWIDTH LATIN SMALL LETTER K
        0xFF4C, # G+339  U+FF4C  uniFF4C,  FULLWIDTH LATIN SMALL LETTER L
        0xFF4D, # G+340  U+FF4D  uniFF4D,  FULLWIDTH LATIN SMALL LETTER M
        0xFF4E, # G+341  U+FF4E  uniFF4E,  FULLWIDTH LATIN SMALL LETTER N
        0xFF4F, # G+342  U+FF4F  uniFF4F,  FULLWIDTH LATIN SMALL LETTER O
        0xFF50, # G+343  U+FF50  uniFF50,  FULLWIDTH LATIN SMALL LETTER P
        0xFF51, # G+344  U+FF51  uniFF51,  FULLWIDTH LATIN SMALL LETTER Q
        0xFF52, # G+345  U+FF52  uniFF52,  FULLWIDTH LATIN SMALL LETTER R
        0xFF53, # G+346  U+FF53  uniFF53,  FULLWIDTH LATIN SMALL LETTER S
        0xFF54, # G+347  U+FF54  uniFF54,  FULLWIDTH LATIN SMALL LETTER T
        0xFF55, # G+348  U+FF55  uniFF55,  FULLWIDTH LATIN SMALL LETTER U
        0xFF56, # G+349  U+FF56  uniFF56,  FULLWIDTH LATIN SMALL LETTER V
        0xFF57, # G+350  U+FF57  uniFF57,  FULLWIDTH LATIN SMALL LETTER W
        0xFF58, # G+351  U+FF58  uniFF58,  FULLWIDTH LATIN SMALL LETTER X
        0xFF59, # G+352  U+FF59  uniFF59,  FULLWIDTH LATIN SMALL LETTER Y
        0xFF5A, # G+353  U+FF5A  uniFF5A,  FULLWIDTH LATIN SMALL LETTER Z
        0xFF5B, # G+354  U+FF5B  uniFF5B,  FULLWIDTH LEFT CURLY BRACKET
        0xFF5C, # G+355  U+FF5C  uniFF5C,  FULLWIDTH VERTICAL LINE
        0xFF5D, # G+356  U+FF5D  uniFF5D,  FULLWIDTH RIGHT CURLY BRACKET
        0xFFE3, # G+357  U+FFE3  uniFFE3,  FULLWIDTH MACRON
        0x3131, # G+358  U+3131  uni3131,  HANGUL LETTER KIYEOK
        0x3132, # G+359  U+3132  uni3132,  HANGUL LETTER SSANGKIYEOK
        0x3133, # G+360  U+3133  uni3133,  HANGUL LETTER KIYEOK-SIOS
        0x3134, # G+361  U+3134  uni3134,  HANGUL LETTER NIEUN
        0x3135, # G+362  U+3135  uni3135,  HANGUL LETTER NIEUN-CIEUC
        0x3136, # G+363  U+3136  uni3136,  HANGUL LETTER NIEUN-HIEUH
        0x3137, # G+364  U+3137  uni3137,  HANGUL LETTER TIKEUT
        0x3138, # G+365  U+3138  uni3138,  HANGUL LETTER SSANGTIKEUT
        0x3139, # G+366  U+3139  uni3139,  HANGUL LETTER RIEUL
        0x313A, # G+367  U+313A  uni313A,  HANGUL LETTER RIEUL-KIYEOK
        0x313B, # G+368  U+313B  uni313B,  HANGUL LETTER RIEUL-MIEUM
        0x313C, # G+369  U+313C  uni313C,  HANGUL LETTER RIEUL-PIEUP
        0x313D, # G+370  U+313D  uni313D,  HANGUL LETTER RIEUL-SIOS
        0x313E, # G+371  U+313E  uni313E,  HANGUL LETTER RIEUL-THIEUTH
        0x313F, # G+372  U+313F  uni313F,  HANGUL LETTER RIEUL-PHIEUPH
        0x3140, # G+373  U+3140  uni3140,  HANGUL LETTER RIEUL-HIEUH
        0x3141, # G+374  U+3141  uni3141,  HANGUL LETTER MIEUM
        0x3142, # G+375  U+3142  uni3142,  HANGUL LETTER PIEUP
        0x3143, # G+376  U+3143  uni3143,  HANGUL LETTER SSANGPIEUP
        0x3144, # G+377  U+3144  uni3144,  HANGUL LETTER PIEUP-SIOS
        0x3145, # G+378  U+3145  uni3145,  HANGUL LETTER SIOS
        0x3146, # G+379  U+3146  uni3146,  HANGUL LETTER SSANGSIOS
        0x3147, # G+380  U+3147  uni3147,  HANGUL LETTER IEUNG
        0x3148, # G+381  U+3148  uni3148,  HANGUL LETTER CIEUC
        0x3149, # G+382  U+3149  uni3149,  HANGUL LETTER SSANGCIEUC
        0x314A, # G+383  U+314A  uni314A,  HANGUL LETTER CHIEUCH
        0x314B, # G+384  U+314B  uni314B,  HANGUL LETTER KHIEUKH
        0x314C, # G+385  U+314C  uni314C,  HANGUL LETTER THIEUTH
        0x314D, # G+386  U+314D  uni314D,  HANGUL LETTER PHIEUPH
        0x314E, # G+387  U+314E  uni314E,  HANGUL LETTER HIEUH
        0x314F, # G+388  U+314F  uni314F,  HANGUL LETTER A
        0x3150, # G+389  U+3150  uni3150,  HANGUL LETTER AE
        0x3151, # G+390  U+3151  uni3151,  HANGUL LETTER YA
        0x3152, # G+391  U+3152  uni3152,  HANGUL LETTER YAE
        0x3153, # G+392  U+3153  uni3153,  HANGUL LETTER EO
        0x3154, # G+393  U+3154  uni3154,  HANGUL LETTER E
        0x3155, # G+394  U+3155  uni3155,  HANGUL LETTER YEO
        0x3156, # G+395  U+3156  uni3156,  HANGUL LETTER YE
        0x3157, # G+396  U+3157  uni3157,  HANGUL LETTER O
        0x3158, # G+397  U+3158  uni3158,  HANGUL LETTER WA
        0x3159, # G+398  U+3159  uni3159,  HANGUL LETTER WAE
        0x315A, # G+399  U+315A  uni315A,  HANGUL LETTER OE
        0x315B, # G+400  U+315B  uni315B,  HANGUL LETTER YO
        0x315C, # G+401  U+315C  uni315C,  HANGUL LETTER U
        0x315D, # G+402  U+315D  uni315D,  HANGUL LETTER WEO
        0x315E, # G+403  U+315E  uni315E,  HANGUL LETTER WE
        0x315F, # G+404  U+315F  uni315F,  HANGUL LETTER WI
        0x3160, # G+405  U+3160  uni3160,  HANGUL LETTER YU
        0x3161, # G+406  U+3161  uni3161,  HANGUL LETTER EU
        0x3162, # G+407  U+3162  uni3162,  HANGUL LETTER YI
        0x3163, # G+408  U+3163  uni3163,  HANGUL LETTER I
        0x3165, # G+409  U+3165  uni3165,  HANGUL LETTER SSANGNIEUN
        0x3166, # G+410  U+3166  uni3166,  HANGUL LETTER NIEUN-TIKEUT
        0x3167, # G+411  U+3167  uni3167,  HANGUL LETTER NIEUN-SIOS
        0x3168, # G+412  U+3168  uni3168,  HANGUL LETTER NIEUN-PANSIOS
        0x3169, # G+413  U+3169  uni3169,  HANGUL LETTER RIEUL-KIYEOK-SIOS
        0x316A, # G+414  U+316A  uni316A,  HANGUL LETTER RIEUL-TIKEUT
        0x316B, # G+415  U+316B  uni316B,  HANGUL LETTER RIEUL-PIEUP-SIOS
        0x316C, # G+416  U+316C  uni316C,  HANGUL LETTER RIEUL-PANSIOS
        0x316D, # G+417  U+316D  uni316D,  HANGUL LETTER RIEUL-YEORINHIEUH
        0x316E, # G+418  U+316E  uni316E,  HANGUL LETTER MIEUM-PIEUP
        0x316F, # G+419  U+316F  uni316F,  HANGUL LETTER MIEUM-SIOS
        0x3170, # G+420  U+3170  uni3170,  HANGUL LETTER MIEUM-PANSIOS
        0x3171, # G+421  U+3171  uni3171,  HANGUL LETTER KAPYEOUNMIEUM
        0x3172, # G+422  U+3172  uni3172,  HANGUL LETTER PIEUP-KIYEOK
        0x3173, # G+423  U+3173  uni3173,  HANGUL LETTER PIEUP-TIKEUT
        0x3174, # G+424  U+3174  uni3174,  HANGUL LETTER PIEUP-SIOS-KIYEOK
        0x3175, # G+425  U+3175  uni3175,  HANGUL LETTER PIEUP-SIOS-TIKEUT
        0x3176, # G+426  U+3176  uni3176,  HANGUL LETTER PIEUP-CIEUC
        0x3177, # G+427  U+3177  uni3177,  HANGUL LETTER PIEUP-THIEUTH
        0x3178, # G+428  U+3178  uni3178,  HANGUL LETTER KAPYEOUNPIEUP
        0x3179, # G+429  U+3179  uni3179,  HANGUL LETTER KAPYEOUNSSANGPIEUP
        0x317A, # G+430  U+317A  uni317A,  HANGUL LETTER SIOS-KIYEOK
        0x317B, # G+431  U+317B  uni317B,  HANGUL LETTER SIOS-NIEUN
        0x317C, # G+432  U+317C  uni317C,  HANGUL LETTER SIOS-TIKEUT
        0x317D, # G+433  U+317D  uni317D,  HANGUL LETTER SIOS-PIEUP
        0x317E, # G+434  U+317E  uni317E,  HANGUL LETTER SIOS-CIEUC
        0x317F, # G+435  U+317F  uni317F,  HANGUL LETTER PANSIOS
        0x3180, # G+436  U+3180  uni3180,  HANGUL LETTER SSANGIEUNG
        0x3181, # G+437  U+3181  uni3181,  HANGUL LETTER YESIEUNG
        0x3182, # G+438  U+3182  uni3182,  HANGUL LETTER YESIEUNG-SIOS
        0x3183, # G+439  U+3183  uni3183,  HANGUL LETTER YESIEUNG-PANSIOS
        0x3184, # G+440  U+3184  uni3184,  HANGUL LETTER KAPYEOUNPHIEUPH
        0x3185, # G+441  U+3185  uni3185,  HANGUL LETTER SSANGHIEUH
        0x3186, # G+442  U+3186  uni3186,  HANGUL LETTER YEORINHIEUH
        0x3187, # G+443  U+3187  uni3187,  HANGUL LETTER YO-YA
        0x3188, # G+444  U+3188  uni3188,  HANGUL LETTER YO-YAE
        0x3189, # G+445  U+3189  uni3189,  HANGUL LETTER YO-I
        0x318A, # G+446  U+318A  uni318A,  HANGUL LETTER YU-YEO
        0x318B, # G+447  U+318B  uni318B,  HANGUL LETTER YU-YE
        0x318C, # G+448  U+318C  uni318C,  HANGUL LETTER YU-I
        0x318D, # G+449  U+318D  uni318D,  HANGUL LETTER ARAEA
        0x318E, # G+450  U+318E  uni318E,  HANGUL LETTER ARAEAE
        0x2170, # G+451  U+2170  uni2170,  SMALL ROMAN NUMERAL ONE
        0x2171, # G+452  U+2171  uni2171,  SMALL ROMAN NUMERAL TWO
        0x2172, # G+453  U+2172  uni2172,  SMALL ROMAN NUMERAL THREE
        0x2173, # G+454  U+2173  uni2173,  SMALL ROMAN NUMERAL FOUR
        0x2174, # G+455  U+2174  uni2174,  SMALL ROMAN NUMERAL FIVE
        0x2175, # G+456  U+2175  uni2175,  SMALL ROMAN NUMERAL SIX
        0x2176, # G+457  U+2176  uni2176,  SMALL ROMAN NUMERAL SEVEN
        0x2177, # G+458  U+2177  uni2177,  SMALL ROMAN NUMERAL EIGHT
        0x2178, # G+459  U+2178  uni2178,  SMALL ROMAN NUMERAL NINE
        0x2179, # G+460  U+2179  uni2179,  SMALL ROMAN NUMERAL TEN
        0x2160, # G+461  U+2160  uni2160,  ROMAN NUMERAL ONE
        0x2161, # G+462  U+2161  uni2161,  ROMAN NUMERAL TWO
        0x2162, # G+463  U+2162  uni2162,  ROMAN NUMERAL THREE
        0x2163, # G+464  U+2163  uni2163,  ROMAN NUMERAL FOUR
        0x2164, # G+465  U+2164  uni2164,  ROMAN NUMERAL FIVE
        0x2165, # G+466  U+2165  uni2165,  ROMAN NUMERAL SIX
        0x2166, # G+467  U+2166  uni2166,  ROMAN NUMERAL SEVEN
        0x2167, # G+468  U+2167  uni2167,  ROMAN NUMERAL EIGHT
        0x2168, # G+469  U+2168  uni2168,  ROMAN NUMERAL NINE
        0x2169, # G+470  U+2169  uni2169,  ROMAN NUMERAL TEN
        0x0391, # G+471  U+0391  Alpha,  GREEK CAPITAL LETTER ALPHA
        0x0392, # G+472  U+0392  Beta,  GREEK CAPITAL LETTER BETA
        0x0393, # G+473  U+0393  Gamma,  GREEK CAPITAL LETTER GAMMA
        0x0394, # G+474  U+0394  Delta,  GREEK CAPITAL LETTER DELTA
        0x0395, # G+475  U+0395  Epsilon,  GREEK CAPITAL LETTER EPSILON
        0x0396, # G+476  U+0396  Zeta,  GREEK CAPITAL LETTER ZETA
        0x0397, # G+477  U+0397  Eta,  GREEK CAPITAL LETTER ETA
        0x0398, # G+478  U+0398  Theta,  GREEK CAPITAL LETTER THETA
        0x0399, # G+479  U+0399  Iota,  GREEK CAPITAL LETTER IOTA
        0x039A, # G+480  U+039A  Kappa,  GREEK CAPITAL LETTER KAPPA
        0x039B, # G+481  U+039B  Lambda,  GREEK CAPITAL LETTER LAMDA
        0x039C, # G+482  U+039C  Mu,  GREEK CAPITAL LETTER MU
        0x039D, # G+483  U+039D  Nu,  GREEK CAPITAL LETTER NU
        0x039E, # G+484  U+039E  Xi,  GREEK CAPITAL LETTER XI
        0x039F, # G+485  U+039F  Omicron,  GREEK CAPITAL LETTER OMICRON
        0x03A0, # G+486  U+03A0  Pi,  GREEK CAPITAL LETTER PI
        0x03A1, # G+487  U+03A1  Rho,  GREEK CAPITAL LETTER RHO
        0x03A3, # G+488  U+03A3  Sigma,  GREEK CAPITAL LETTER SIGMA
        0x03A4, # G+489  U+03A4  Tau,  GREEK CAPITAL LETTER TAU
        0x03A5, # G+490  U+03A5  Upsilon,  GREEK CAPITAL LETTER UPSILON
        0x03A6, # G+491  U+03A6  Phi,  GREEK CAPITAL LETTER PHI
        0x03A7, # G+492  U+03A7  Chi,  GREEK CAPITAL LETTER CHI
        0x03A8, # G+493  U+03A8  Psi,  GREEK CAPITAL LETTER PSI
        0x03A9, # G+494  U+03A9  Omega,  GREEK CAPITAL LETTER OMEGA
        0x03B1, # G+495  U+03B1  alpha,  GREEK SMALL LETTER ALPHA
        0x03B2, # G+496  U+03B2  beta,  GREEK SMALL LETTER BETA
        0x03B3, # G+497  U+03B3  gamma,  GREEK SMALL LETTER GAMMA
        0x03B4, # G+498  U+03B4  delta,  GREEK SMALL LETTER DELTA
        0x03B5, # G+499  U+03B5  epsilon,  GREEK SMALL LETTER EPSILON
        0x03B6, # G+500  U+03B6  zeta,  GREEK SMALL LETTER ZETA
        0x03B7, # G+501  U+03B7  eta,  GREEK SMALL LETTER ETA
        0x03B8, # G+502  U+03B8  theta,  GREEK SMALL LETTER THETA
        0x03B9, # G+503  U+03B9  iota,  GREEK SMALL LETTER IOTA
        0x03BA, # G+504  U+03BA  kappa,  GREEK SMALL LETTER KAPPA
        0x03BB, # G+505  U+03BB  lambda,  GREEK SMALL LETTER LAMDA
        0x03BC, # G+506  U+03BC  mu,  GREEK SMALL LETTER MU
        0x03BD, # G+507  U+03BD  nu,  GREEK SMALL LETTER NU
        0x03BE, # G+508  U+03BE  xi,  GREEK SMALL LETTER XI
        0x03BF, # G+509  U+03BF  omicron,  GREEK SMALL LETTER OMICRON
        0x03C0, # G+510  U+03C0  pi,  GREEK SMALL LETTER PI
        0x03C1, # G+511  U+03C1  rho,  GREEK SMALL LETTER RHO
        0x03C3, # G+512  U+03C3  sigma,  GREEK SMALL LETTER SIGMA
        0x03C4, # G+513  U+03C4  tau,  GREEK SMALL LETTER TAU
        0x03C5, # G+514  U+03C5  upsilon,  GREEK SMALL LETTER UPSILON
        0x03C6, # G+515  U+03C6  phi,  GREEK SMALL LETTER PHI
        0x03C7, # G+516  U+03C7  chi,  GREEK SMALL LETTER CHI
        0x03C8, # G+517  U+03C8  psi,  GREEK SMALL LETTER PSI
        0x03C9, # G+518  U+03C9  omega,  GREEK SMALL LETTER OMEGA
        0x2500, # G+519  U+2500  SF100000,  BOX DRAWINGS LIGHT HORIZONTAL
        0x2502, # G+520  U+2502  SF110000,  BOX DRAWINGS LIGHT VERTICAL
        0x250C, # G+521  U+250C  SF010000,  BOX DRAWINGS LIGHT DOWN AND RIGHT
        0x2510, # G+522  U+2510  SF030000,  BOX DRAWINGS LIGHT DOWN AND LEFT
        0x2518, # G+523  U+2518  SF040000,  BOX DRAWINGS LIGHT UP AND LEFT
        0x2514, # G+524  U+2514  SF020000,  BOX DRAWINGS LIGHT UP AND RIGHT
        0x251C, # G+525  U+251C  SF080000,  BOX DRAWINGS LIGHT VERTICAL AND RIGHT
        0x252C, # G+526  U+252C  SF060000,  BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
        0x2524, # G+527  U+2524  SF090000,  BOX DRAWINGS LIGHT VERTICAL AND LEFT
        0x2534, # G+528  U+2534  SF070000,  BOX DRAWINGS LIGHT UP AND HORIZONTAL
        0x253C, # G+529  U+253C  SF050000,  BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
        0x2501, # G+530  U+2501  uni2501,  BOX DRAWINGS HEAVY HORIZONTAL
        0x2503, # G+531  U+2503  uni2503,  BOX DRAWINGS HEAVY VERTICAL
        0x250F, # G+532  U+250F  uni250F,  BOX DRAWINGS HEAVY DOWN AND RIGHT
        0x2513, # G+533  U+2513  uni2513,  BOX DRAWINGS HEAVY DOWN AND LEFT
        0x251B, # G+534  U+251B  uni251B,  BOX DRAWINGS HEAVY UP AND LEFT
        0x2517, # G+535  U+2517  uni2517,  BOX DRAWINGS HEAVY UP AND RIGHT
        0x2523, # G+536  U+2523  uni2523,  BOX DRAWINGS HEAVY VERTICAL AND RIGHT
        0x2533, # G+537  U+2533  uni2533,  BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
        0x252B, # G+538  U+252B  uni252B,  BOX DRAWINGS HEAVY VERTICAL AND LEFT
        0x253B, # G+539  U+253B  uni253B,  BOX DRAWINGS HEAVY UP AND HORIZONTAL
        0x254B, # G+540  U+254B  uni254B,  BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
        0x2520, # G+541  U+2520  uni2520,  BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
        0x252F, # G+542  U+252F  uni252F,  BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
        0x2528, # G+543  U+2528  uni2528,  BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
        0x2537, # G+544  U+2537  uni2537,  BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
        0x253F, # G+545  U+253F  uni253F,  BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
        0x251D, # G+546  U+251D  uni251D,  BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
        0x2530, # G+547  U+2530  uni2530,  BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
        0x2525, # G+548  U+2525  uni2525,  BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
        0x2538, # G+549  U+2538  uni2538,  BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
        0x2542, # G+550  U+2542  uni2542,  BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
        0x2512, # G+551  U+2512  uni2512,  BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
        0x2511, # G+552  U+2511  uni2511,  BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
        0x251A, # G+553  U+251A  uni251A,  BOX DRAWINGS UP HEAVY AND LEFT LIGHT
        0x2519, # G+554  U+2519  uni2519,  BOX DRAWINGS UP LIGHT AND LEFT HEAVY
        0x2516, # G+555  U+2516  uni2516,  BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
        0x2515, # G+556  U+2515  uni2515,  BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
        0x250E, # G+557  U+250E  uni250E,  BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
        0x250D, # G+558  U+250D  uni250D,  BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
        0x251E, # G+559  U+251E  uni251E,  BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
        0x251F, # G+560  U+251F  uni251F,  BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
        0x2521, # G+561  U+2521  uni2521,  BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
        0x2522, # G+562  U+2522  uni2522,  BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
        0x2526, # G+563  U+2526  uni2526,  BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
        0x2527, # G+564  U+2527  uni2527,  BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
        0x2529, # G+565  U+2529  uni2529,  BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
        0x252A, # G+566  U+252A  uni252A,  BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
        0x252D, # G+567  U+252D  uni252D,  BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
        0x252E, # G+568  U+252E  uni252E,  BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
        0x2531, # G+569  U+2531  uni2531,  BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
        0x2532, # G+570  U+2532  uni2532,  BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
        0x2535, # G+571  U+2535  uni2535,  BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
        0x2536, # G+572  U+2536  uni2536,  BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
        0x2539, # G+573  U+2539  uni2539,  BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
        0x253A, # G+574  U+253A  uni253A,  BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
        0x253D, # G+575  U+253D  uni253D,  BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
        0x253E, # G+576  U+253E  uni253E,  BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
        0x2540, # G+577  U+2540  uni2540,  BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
        0x2541, # G+578  U+2541  uni2541,  BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
        0x2543, # G+579  U+2543  uni2543,  BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
        0x2544, # G+580  U+2544  uni2544,  BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
        0x2545, # G+581  U+2545  uni2545,  BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
        0x2546, # G+582  U+2546  uni2546,  BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
        0x2547, # G+583  U+2547  uni2547,  BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
        0x2548, # G+584  U+2548  uni2548,  BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
        0x2549, # G+585  U+2549  uni2549,  BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
        0x254A, # G+586  U+254A  uni254A,  BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
        0x3395, # G+587  U+3395  uni3395,  SQUARE MU L
        0x3396, # G+588  U+3396  uni3396,  SQUARE ML
        0x3397, # G+589  U+3397  uni3397,  SQUARE DL
        0x2113, # G+590  U+2113  afii61289,  SCRIPT SMALL L
        0x3398, # G+591  U+3398  uni3398,  SQUARE KL
        0x33C4, # G+592  U+33C4  uni33C4,  SQUARE CC
        0x33A3, # G+593  U+33A3  uni33A3,  SQUARE MM CUBED
        0x33A4, # G+594  U+33A4  uni33A4,  SQUARE CM CUBED
        0x33A5, # G+595  U+33A5  uni33A5,  SQUARE M CUBED
        0x33A6, # G+596  U+33A6  uni33A6,  SQUARE KM CUBED
        0x3399, # G+597  U+3399  uni3399,  SQUARE FM
        0x339A, # G+598  U+339A  uni339A,  SQUARE NM
        0x339B, # G+599  U+339B  uni339B,  SQUARE MU M
        0x339C, # G+600  U+339C  uni339C,  SQUARE MM
        0x339D, # G+601  U+339D  uni339D,  SQUARE CM
        0x339E, # G+602  U+339E  uni339E,  SQUARE KM
        0x339F, # G+603  U+339F  uni339F,  SQUARE MM SQUARED
        0x33A0, # G+604  U+33A0  uni33A0,  SQUARE CM SQUARED
        0x33A1, # G+605  U+33A1  uni33A1,  SQUARE M SQUARED
        0x33A2, # G+606  U+33A2  uni33A2,  SQUARE KM SQUARED
        0x33CA, # G+607  U+33CA  uni33CA,  SQUARE HA
        0x338D, # G+608  U+338D  uni338D,  SQUARE MU G
        0x338E, # G+609  U+338E  uni338E,  SQUARE MG
        0x338F, # G+610  U+338F  uni338F,  SQUARE KG
        0x33CF, # G+611  U+33CF  uni33CF,  SQUARE KT
        0x3388, # G+612  U+3388  uni3388,  SQUARE CAL
        0x3389, # G+613  U+3389  uni3389,  SQUARE KCAL
        0x33C8, # G+614  U+33C8  uni33C8,  SQUARE DB
        0x33A7, # G+615  U+33A7  uni33A7,  SQUARE M OVER S
        0x33A8, # G+616  U+33A8  uni33A8,  SQUARE M OVER S SQUARED
        0x33B0, # G+617  U+33B0  uni33B0,  SQUARE PS
        0x33B1, # G+618  U+33B1  uni33B1,  SQUARE NS
        0x33B2, # G+619  U+33B2  uni33B2,  SQUARE MU S
        0x33B3, # G+620  U+33B3  uni33B3,  SQUARE MS
        0x33B4, # G+621  U+33B4  uni33B4,  SQUARE PV
        0x33B5, # G+622  U+33B5  uni33B5,  SQUARE NV
        0x33B6, # G+623  U+33B6  uni33B6,  SQUARE MU V
        0x33B7, # G+624  U+33B7  uni33B7,  SQUARE MV
        0x33B8, # G+625  U+33B8  uni33B8,  SQUARE KV
        0x33B9, # G+626  U+33B9  uni33B9,  SQUARE MV MEGA
        0x3380, # G+627  U+3380  uni3380,  SQUARE PA AMPS
        0x3381, # G+628  U+3381  uni3381,  SQUARE NA
        0x3382, # G+629  U+3382  uni3382,  SQUARE MU A
        0x3383, # G+630  U+3383  uni3383,  SQUARE MA
        0x3384, # G+631  U+3384  uni3384,  SQUARE KA
        0x33BA, # G+632  U+33BA  uni33BA,  SQUARE PW
        0x33BB, # G+633  U+33BB  uni33BB,  SQUARE NW
        0x33BC, # G+634  U+33BC  uni33BC,  SQUARE MU W
        0x33BD, # G+635  U+33BD  uni33BD,  SQUARE MW
        0x33BE, # G+636  U+33BE  uni33BE,  SQUARE KW
        0x33BF, # G+637  U+33BF  uni33BF,  SQUARE MW MEGA
        0x3390, # G+638  U+3390  uni3390,  SQUARE HZ
        0x3391, # G+639  U+3391  uni3391,  SQUARE KHZ
        0x3392, # G+640  U+3392  uni3392,  SQUARE MHZ
        0x3393, # G+641  U+3393  uni3393,  SQUARE GHZ
        0x3394, # G+642  U+3394  uni3394,  SQUARE THZ
        0x2126, # G+643  U+2126  Omega,  OHM SIGN
        0x33C0, # G+644  U+33C0  uni33C0,  SQUARE K OHM
        0x33C1, # G+645  U+33C1  uni33C1,  SQUARE M OHM
        0x338A, # G+646  U+338A  uni338A,  SQUARE PF
        0x338B, # G+647  U+338B  uni338B,  SQUARE NF
        0x338C, # G+648  U+338C  uni338C,  SQUARE MU F
        0x33D6, # G+649  U+33D6  uni33D6,  SQUARE MOL
        0x33C5, # G+650  U+33C5  uni33C5,  SQUARE CD
        0x33AD, # G+651  U+33AD  uni33AD,  SQUARE RAD
        0x33AE, # G+652  U+33AE  uni33AE,  SQUARE RAD OVER S
        0x33AF, # G+653  U+33AF  uni33AF,  SQUARE RAD OVER S SQUARED
        0x33DB, # G+654  U+33DB  uni33DB,  SQUARE SR
        0x33A9, # G+655  U+33A9  uni33A9,  SQUARE PA
        0x33AA, # G+656  U+33AA  uni33AA,  SQUARE KPA
        0x33AB, # G+657  U+33AB  uni33AB,  SQUARE MPA
        0x33AC, # G+658  U+33AC  uni33AC,  SQUARE GPA
        0x33DD, # G+659  U+33DD  uni33DD,  SQUARE WB
        0x33D0, # G+660  U+33D0  uni33D0,  SQUARE LM
        0x33D3, # G+661  U+33D3  uni33D3,  SQUARE LX
        0x33C3, # G+662  U+33C3  uni33C3,  SQUARE BQ
        0x33C9, # G+663  U+33C9  uni33C9,  SQUARE GY
        0x33DC, # G+664  U+33DC  uni33DC,  SQUARE SV
        0x33C6, # G+665  U+33C6  uni33C6,  SQUARE C OVER KG
        0x00C6, # G+666  U+00C6  AE,  LATIN CAPITAL LETTER AE
        0x00D0, # G+667  U+00D0  Eth,  LATIN CAPITAL LETTER ETH
        0x00AA, # G+668  U+00AA  ordfeminine,  FEMININE ORDINAL INDICATOR
        0x0126, # G+669  U+0126  Hbar,  LATIN CAPITAL LETTER H WITH STROKE
        0x0132, # G+670  U+0132  IJ,  LATIN CAPITAL LIGATURE IJ
        0x013F, # G+671  U+013F  Ldot,  LATIN CAPITAL LETTER L WITH MIDDLE DOT
        0x0141, # G+672  U+0141  Lslash,  LATIN CAPITAL LETTER L WITH STROKE
        0x00D8, # G+673  U+00D8  Oslash,  LATIN CAPITAL LETTER O WITH STROKE
        0x0152, # G+674  U+0152  OE,  LATIN CAPITAL LIGATURE OE
        0x00BA, # G+675  U+00BA  ordmasculine,  MASCULINE ORDINAL INDICATOR
        0x00DE, # G+676  U+00DE  Thorn,  LATIN CAPITAL LETTER THORN
        0x0166, # G+677  U+0166  Tbar,  LATIN CAPITAL LETTER T WITH STROKE
        0x014A, # G+678  U+014A  Eng,  LATIN CAPITAL LETTER ENG
        0x3260, # G+679  U+3260  uni3260,  CIRCLED HANGUL KIYEOK
        0x3261, # G+680  U+3261  uni3261,  CIRCLED HANGUL NIEUN
        0x3262, # G+681  U+3262  uni3262,  CIRCLED HANGUL TIKEUT
        0x3263, # G+682  U+3263  uni3263,  CIRCLED HANGUL RIEUL
        0x3264, # G+683  U+3264  uni3264,  CIRCLED HANGUL MIEUM
        0x3265, # G+684  U+3265  uni3265,  CIRCLED HANGUL PIEUP
        0x3266, # G+685  U+3266  uni3266,  CIRCLED HANGUL SIOS
        0x3267, # G+686  U+3267  uni3267,  CIRCLED HANGUL IEUNG
        0x3268, # G+687  U+3268  uni3268,  CIRCLED HANGUL CIEUC
        0x3269, # G+688  U+3269  uni3269,  CIRCLED HANGUL CHIEUCH
        0x326A, # G+689  U+326A  uni326A,  CIRCLED HANGUL KHIEUKH
        0x326B, # G+690  U+326B  uni326B,  CIRCLED HANGUL THIEUTH
        0x326C, # G+691  U+326C  uni326C,  CIRCLED HANGUL PHIEUPH
        0x326D, # G+692  U+326D  uni326D,  CIRCLED HANGUL HIEUH
        0x326E, # G+693  U+326E  uni326E,  CIRCLED HANGUL KIYEOK A
        0x326F, # G+694  U+326F  uni326F,  CIRCLED HANGUL NIEUN A
        0x3270, # G+695  U+3270  uni3270,  CIRCLED HANGUL TIKEUT A
        0x3271, # G+696  U+3271  uni3271,  CIRCLED HANGUL RIEUL A
        0x3272, # G+697  U+3272  uni3272,  CIRCLED HANGUL MIEUM A
        0x3273, # G+698  U+3273  uni3273,  CIRCLED HANGUL PIEUP A
        0x3274, # G+699  U+3274  uni3274,  CIRCLED HANGUL SIOS A
        0x3275, # G+700  U+3275  uni3275,  CIRCLED HANGUL IEUNG A
        0x3276, # G+701  U+3276  uni3276,  CIRCLED HANGUL CIEUC A
        0x3277, # G+702  U+3277  uni3277,  CIRCLED HANGUL CHIEUCH A
        0x3278, # G+703  U+3278  uni3278,  CIRCLED HANGUL KHIEUKH A
        0x3279, # G+704  U+3279  uni3279,  CIRCLED HANGUL THIEUTH A
        0x327A, # G+705  U+327A  uni327A,  CIRCLED HANGUL PHIEUPH A
        0x327B, # G+706  U+327B  uni327B,  CIRCLED HANGUL HIEUH A
        0x24D0, # G+707  U+24D0  uni24D0,  CIRCLED LATIN SMALL LETTER A
        0x24D1, # G+708  U+24D1  uni24D1,  CIRCLED LATIN SMALL LETTER B
        0x24D2, # G+709  U+24D2  uni24D2,  CIRCLED LATIN SMALL LETTER C
        0x24D3, # G+710  U+24D3  uni24D3,  CIRCLED LATIN SMALL LETTER D
        0x24D4, # G+711  U+24D4  uni24D4,  CIRCLED LATIN SMALL LETTER E
        0x24D5, # G+712  U+24D5  uni24D5,  CIRCLED LATIN SMALL LETTER F
        0x24D6, # G+713  U+24D6  uni24D6,  CIRCLED LATIN SMALL LETTER G
        0x24D7, # G+714  U+24D7  uni24D7,  CIRCLED LATIN SMALL LETTER H
        0x24D8, # G+715  U+24D8  uni24D8,  CIRCLED LATIN SMALL LETTER I
        0x24D9, # G+716  U+24D9  uni24D9,  CIRCLED LATIN SMALL LETTER J
        0x24DA, # G+717  U+24DA  uni24DA,  CIRCLED LATIN SMALL LETTER K
        0x24DB, # G+718  U+24DB  uni24DB,  CIRCLED LATIN SMALL LETTER L
        0x24DC, # G+719  U+24DC  uni24DC,  CIRCLED LATIN SMALL LETTER M
        0x24DD, # G+720  U+24DD  uni24DD,  CIRCLED LATIN SMALL LETTER N
        0x24DE, # G+721  U+24DE  uni24DE,  CIRCLED LATIN SMALL LETTER O
        0x24DF, # G+722  U+24DF  uni24DF,  CIRCLED LATIN SMALL LETTER P
        0x24E0, # G+723  U+24E0  uni24E0,  CIRCLED LATIN SMALL LETTER Q
        0x24E1, # G+724  U+24E1  uni24E1,  CIRCLED LATIN SMALL LETTER R
        0x24E2, # G+725  U+24E2  uni24E2,  CIRCLED LATIN SMALL LETTER S
        0x24E3, # G+726  U+24E3  uni24E3,  CIRCLED LATIN SMALL LETTER T
        0x24E4, # G+727  U+24E4  uni24E4,  CIRCLED LATIN SMALL LETTER U
        0x24E5, # G+728  U+24E5  uni24E5,  CIRCLED LATIN SMALL LETTER V
        0x24E6, # G+729  U+24E6  uni24E6,  CIRCLED LATIN SMALL LETTER W
        0x24E7, # G+730  U+24E7  uni24E7,  CIRCLED LATIN SMALL LETTER X
        0x24E8, # G+731  U+24E8  uni24E8,  CIRCLED LATIN SMALL LETTER Y
        0x24E9, # G+732  U+24E9  uni24E9,  CIRCLED LATIN SMALL LETTER Z
        0x2460, # G+733  U+2460  a120,  CIRCLED DIGIT ONE
        0x2461, # G+734  U+2461  a121,  CIRCLED DIGIT TWO
        0x2462, # G+735  U+2462  a122,  CIRCLED DIGIT THREE
        0x2463, # G+736  U+2463  a123,  CIRCLED DIGIT FOUR
        0x2464, # G+737  U+2464  a124,  CIRCLED DIGIT FIVE
        0x2465, # G+738  U+2465  a125,  CIRCLED DIGIT SIX
        0x2466, # G+739  U+2466  a126,  CIRCLED DIGIT SEVEN
        0x2467, # G+740  U+2467  a127,  CIRCLED DIGIT EIGHT
        0x2468, # G+741  U+2468  a128,  CIRCLED DIGIT NINE
        0x2469, # G+742  U+2469  a129,  CIRCLED NUMBER TEN
        0x246A, # G+743  U+246A  uni246A,  CIRCLED NUMBER ELEVEN
        0x246B, # G+744  U+246B  uni246B,  CIRCLED NUMBER TWELVE
        0x246C, # G+745  U+246C  uni246C,  CIRCLED NUMBER THIRTEEN
        0x246D, # G+746  U+246D  uni246D,  CIRCLED NUMBER FOURTEEN
        0x246E, # G+747  U+246E  uni246E,  CIRCLED NUMBER FIFTEEN
        0x00BD, # G+748  U+00BD  onehalf,  VULGAR FRACTION ONE HALF
        0x2153, # G+749  U+2153  onethird,  VULGAR FRACTION ONE THIRD
        0x2154, # G+750  U+2154  twothirds,  VULGAR FRACTION TWO THIRDS
        0x00BC, # G+751  U+00BC  onequarter,  VULGAR FRACTION ONE QUARTER
        0x00BE, # G+752  U+00BE  threequarters,  VULGAR FRACTION THREE QUARTERS
        0x215B, # G+753  U+215B  oneeighth,  VULGAR FRACTION ONE EIGHTH
        0x215C, # G+754  U+215C  threeeighths,  VULGAR FRACTION THREE EIGHTHS
        0x215D, # G+755  U+215D  fiveeighths,  VULGAR FRACTION FIVE EIGHTHS
        0x215E, # G+756  U+215E  seveneighths,  VULGAR FRACTION SEVEN EIGHTHS
        0x00E6, # G+757  U+00E6  ae,  LATIN SMALL LETTER AE
        0x0111, # G+758  U+0111  dcroat,  LATIN SMALL LETTER D WITH STROKE
        0x00F0, # G+759  U+00F0  eth,  LATIN SMALL LETTER ETH
        0x0127, # G+760  U+0127  hbar,  LATIN SMALL LETTER H WITH STROKE
        0x0131, # G+761  U+0131  dotlessi,  LATIN SMALL LETTER DOTLESS I
        0x0133, # G+762  U+0133  ij,  LATIN SMALL LIGATURE IJ
        0x0138, # G+763  U+0138  kgreenlandic,  LATIN SMALL LETTER KRA
        0x0140, # G+764  U+0140  ldot,  LATIN SMALL LETTER L WITH MIDDLE DOT
        0x0142, # G+765  U+0142  lslash,  LATIN SMALL LETTER L WITH STROKE
        0x00F8, # G+766  U+00F8  oslash,  LATIN SMALL LETTER O WITH STROKE
        0x0153, # G+767  U+0153  oe,  LATIN SMALL LIGATURE OE
        0x00DF, # G+768  U+00DF  germandbls,  LATIN SMALL LETTER SHARP S
        0x00FE, # G+769  U+00FE  thorn,  LATIN SMALL LETTER THORN
        0x0167, # G+770  U+0167  tbar,  LATIN SMALL LETTER T WITH STROKE
        0x014B, # G+771  U+014B  eng,  LATIN SMALL LETTER ENG
        0x0149, # G+772  U+0149  napostrophe,  LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
        0x3200, # G+773  U+3200  uni3200,  PARENTHESIZED HANGUL KIYEOK
        0x3201, # G+774  U+3201  uni3201,  PARENTHESIZED HANGUL NIEUN
        0x3202, # G+775  U+3202  uni3202,  PARENTHESIZED HANGUL TIKEUT
        0x3203, # G+776  U+3203  uni3203,  PARENTHESIZED HANGUL RIEUL
        0x3204, # G+777  U+3204  uni3204,  PARENTHESIZED HANGUL MIEUM
        0x3205, # G+778  U+3205  uni3205,  PARENTHESIZED HANGUL PIEUP
        0x3206, # G+779  U+3206  uni3206,  PARENTHESIZED HANGUL SIOS
        0x3207, # G+780  U+3207  uni3207,  PARENTHESIZED HANGUL IEUNG
        0x3208, # G+781  U+3208  uni3208,  PARENTHESIZED HANGUL CIEUC
        0x3209, # G+782  U+3209  uni3209,  PARENTHESIZED HANGUL CHIEUCH
        0x320A, # G+783  U+320A  uni320A,  PARENTHESIZED HANGUL KHIEUKH
        0x320B, # G+784  U+320B  uni320B,  PARENTHESIZED HANGUL THIEUTH
        0x320C, # G+785  U+320C  uni320C,  PARENTHESIZED HANGUL PHIEUPH
        0x320D, # G+786  U+320D  uni320D,  PARENTHESIZED HANGUL HIEUH
        0x320E, # G+787  U+320E  uni320E,  PARENTHESIZED HANGUL KIYEOK A
        0x320F, # G+788  U+320F  uni320F,  PARENTHESIZED HANGUL NIEUN A
        0x3210, # G+789  U+3210  uni3210,  PARENTHESIZED HANGUL TIKEUT A
        0x3211, # G+790  U+3211  uni3211,  PARENTHESIZED HANGUL RIEUL A
        0x3212, # G+791  U+3212  uni3212,  PARENTHESIZED HANGUL MIEUM A
        0x3213, # G+792  U+3213  uni3213,  PARENTHESIZED HANGUL PIEUP A
        0x3214, # G+793  U+3214  uni3214,  PARENTHESIZED HANGUL SIOS A
        0x3215, # G+794  U+3215  uni3215,  PARENTHESIZED HANGUL IEUNG A
        0x3216, # G+795  U+3216  uni3216,  PARENTHESIZED HANGUL CIEUC A
        0x3217, # G+796  U+3217  uni3217,  PARENTHESIZED HANGUL CHIEUCH A
        0x3218, # G+797  U+3218  uni3218,  PARENTHESIZED HANGUL KHIEUKH A
        0x3219, # G+798  U+3219  uni3219,  PARENTHESIZED HANGUL THIEUTH A
        0x321A, # G+799  U+321A  uni321A,  PARENTHESIZED HANGUL PHIEUPH A
        0x321B, # G+800  U+321B  uni321B,  PARENTHESIZED HANGUL HIEUH A
        0x249C, # G+801  U+249C  uni249C,  PARENTHESIZED LATIN SMALL LETTER A
        0x249D, # G+802  U+249D  uni249D,  PARENTHESIZED LATIN SMALL LETTER B
        0x249E, # G+803  U+249E  uni249E,  PARENTHESIZED LATIN SMALL LETTER C
        0x249F, # G+804  U+249F  uni249F,  PARENTHESIZED LATIN SMALL LETTER D
        0x24A0, # G+805  U+24A0  uni24A0,  PARENTHESIZED LATIN SMALL LETTER E
        0x24A1, # G+806  U+24A1  uni24A1,  PARENTHESIZED LATIN SMALL LETTER F
        0x24A2, # G+807  U+24A2  uni24A2,  PARENTHESIZED LATIN SMALL LETTER G
        0x24A3, # G+808  U+24A3  uni24A3,  PARENTHESIZED LATIN SMALL LETTER H
        0x24A4, # G+809  U+24A4  uni24A4,  PARENTHESIZED LATIN SMALL LETTER I
        0x24A5, # G+810  U+24A5  uni24A5,  PARENTHESIZED LATIN SMALL LETTER J
        0x24A6, # G+811  U+24A6  uni24A6,  PARENTHESIZED LATIN SMALL LETTER K
        0x24A7, # G+812  U+24A7  uni24A7,  PARENTHESIZED LATIN SMALL LETTER L
        0x24A8, # G+813  U+24A8  uni24A8,  PARENTHESIZED LATIN SMALL LETTER M
        0x24A9, # G+814  U+24A9  uni24A9,  PARENTHESIZED LATIN SMALL LETTER N
        0x24AA, # G+815  U+24AA  uni24AA,  PARENTHESIZED LATIN SMALL LETTER O
        0x24AB, # G+816  U+24AB  uni24AB,  PARENTHESIZED LATIN SMALL LETTER P
        0x24AC, # G+817  U+24AC  uni24AC,  PARENTHESIZED LATIN SMALL LETTER Q
        0x24AD, # G+818  U+24AD  uni24AD,  PARENTHESIZED LATIN SMALL LETTER R
        0x24AE, # G+819  U+24AE  uni24AE,  PARENTHESIZED LATIN SMALL LETTER S
        0x24AF, # G+820  U+24AF  uni24AF,  PARENTHESIZED LATIN SMALL LETTER T
        0x24B0, # G+821  U+24B0  uni24B0,  PARENTHESIZED LATIN SMALL LETTER U
        0x24B1, # G+822  U+24B1  uni24B1,  PARENTHESIZED LATIN SMALL LETTER V
        0x24B2, # G+823  U+24B2  uni24B2,  PARENTHESIZED LATIN SMALL LETTER W
        0x24B3, # G+824  U+24B3  uni24B3,  PARENTHESIZED LATIN SMALL LETTER X
        0x24B4, # G+825  U+24B4  uni24B4,  PARENTHESIZED LATIN SMALL LETTER Y
        0x24B5, # G+826  U+24B5  uni24B5,  PARENTHESIZED LATIN SMALL LETTER Z
        0x2474, # G+827  U+2474  uni2474,  PARENTHESIZED DIGIT ONE
        0x2475, # G+828  U+2475  uni2475,  PARENTHESIZED DIGIT TWO
        0x2476, # G+829  U+2476  uni2476,  PARENTHESIZED DIGIT THREE
        0x2477, # G+830  U+2477  uni2477,  PARENTHESIZED DIGIT FOUR
        0x2478, # G+831  U+2478  uni2478,  PARENTHESIZED DIGIT FIVE
        0x2479, # G+832  U+2479  uni2479,  PARENTHESIZED DIGIT SIX
        0x247A, # G+833  U+247A  uni247A,  PARENTHESIZED DIGIT SEVEN
        0x247B, # G+834  U+247B  uni247B,  PARENTHESIZED DIGIT EIGHT
        0x247C, # G+835  U+247C  uni247C,  PARENTHESIZED DIGIT NINE
        0x247D, # G+836  U+247D  uni247D,  PARENTHESIZED NUMBER TEN
        0x247E, # G+837  U+247E  uni247E,  PARENTHESIZED NUMBER ELEVEN
        0x247F, # G+838  U+247F  uni247F,  PARENTHESIZED NUMBER TWELVE
        0x2480, # G+839  U+2480  uni2480,  PARENTHESIZED NUMBER THIRTEEN
        0x2481, # G+840  U+2481  uni2481,  PARENTHESIZED NUMBER FOURTEEN
        0x2482, # G+841  U+2482  uni2482,  PARENTHESIZED NUMBER FIFTEEN
        0x00B9, # G+842  U+00B9  onesuperior,  SUPERSCRIPT ONE
        0x00B2, # G+843  U+00B2  twosuperior,  SUPERSCRIPT TWO
        0x00B3, # G+844  U+00B3  threesuperior,  SUPERSCRIPT THREE
        0x2074, # G+845  U+2074  foursuperior,  SUPERSCRIPT FOUR
        0x207F, # G+846  U+207F  nsuperior,  SUPERSCRIPT LATIN SMALL LETTER N
        0x2081, # G+847  U+2081  oneinferior,  SUBSCRIPT ONE
        0x2082, # G+848  U+2082  twoinferior,  SUBSCRIPT TWO
        0x2083, # G+849  U+2083  threeinferior,  SUBSCRIPT THREE
        0x2084, # G+850  U+2084  fourinferior,  SUBSCRIPT FOUR
        0x3041, # G+851  U+3041  uni3041,  HIRAGANA LETTER SMALL A
        0x3042, # G+852  U+3042  uni3042,  HIRAGANA LETTER A
        0x3043, # G+853  U+3043  uni3043,  HIRAGANA LETTER SMALL I
        0x3044, # G+854  U+3044  uni3044,  HIRAGANA LETTER I
        0x3045, # G+855  U+3045  uni3045,  HIRAGANA LETTER SMALL U
        0x3046, # G+856  U+3046  uni3046,  HIRAGANA LETTER U
        0x3047, # G+857  U+3047  uni3047,  HIRAGANA LETTER SMALL E
        0x3048, # G+858  U+3048  uni3048,  HIRAGANA LETTER E
        0x3049, # G+859  U+3049  uni3049,  HIRAGANA LETTER SMALL O
        0x304A, # G+860  U+304A  uni304A,  HIRAGANA LETTER O
        0x304B, # G+861  U+304B  uni304B,  HIRAGANA LETTER KA
        0x304C, # G+862  U+304C  uni304C,  HIRAGANA LETTER GA
        0x304D, # G+863  U+304D  uni304D,  HIRAGANA LETTER KI
        0x304E, # G+864  U+304E  uni304E,  HIRAGANA LETTER GI
        0x304F, # G+865  U+304F  uni304F,  HIRAGANA LETTER KU
        0x3050, # G+866  U+3050  uni3050,  HIRAGANA LETTER GU
        0x3051, # G+867  U+3051  uni3051,  HIRAGANA LETTER KE
        0x3052, # G+868  U+3052  uni3052,  HIRAGANA LETTER GE
        0x3053, # G+869  U+3053  uni3053,  HIRAGANA LETTER KO
        0x3054, # G+870  U+3054  uni3054,  HIRAGANA LETTER GO
        0x3055, # G+871  U+3055  uni3055,  HIRAGANA LETTER SA
        0x3056, # G+872  U+3056  uni3056,  HIRAGANA LETTER ZA
        0x3057, # G+873  U+3057  uni3057,  HIRAGANA LETTER SI
        0x3058, # G+874  U+3058  uni3058,  HIRAGANA LETTER ZI
        0x3059, # G+875  U+3059  uni3059,  HIRAGANA LETTER SU
        0x305A, # G+876  U+305A  uni305A,  HIRAGANA LETTER ZU
        0x305B, # G+877  U+305B  uni305B,  HIRAGANA LETTER SE
        0x305C, # G+878  U+305C  uni305C,  HIRAGANA LETTER ZE
        0x305D, # G+879  U+305D  uni305D,  HIRAGANA LETTER SO
        0x305E, # G+880  U+305E  uni305E,  HIRAGANA LETTER ZO
        0x305F, # G+881  U+305F  uni305F,  HIRAGANA LETTER TA
        0x3060, # G+882  U+3060  uni3060,  HIRAGANA LETTER DA
        0x3061, # G+883  U+3061  uni3061,  HIRAGANA LETTER TI
        0x3062, # G+884  U+3062  uni3062,  HIRAGANA LETTER DI
        0x3063, # G+885  U+3063  uni3063,  HIRAGANA LETTER SMALL TU
        0x3064, # G+886  U+3064  uni3064,  HIRAGANA LETTER TU
        0x3065, # G+887  U+3065  uni3065,  HIRAGANA LETTER DU
        0x3066, # G+888  U+3066  uni3066,  HIRAGANA LETTER TE
        0x3067, # G+889  U+3067  uni3067,  HIRAGANA LETTER DE
        0x3068, # G+890  U+3068  uni3068,  HIRAGANA LETTER TO
        0x3069, # G+891  U+3069  uni3069,  HIRAGANA LETTER DO
        0x306A, # G+892  U+306A  uni306A,  HIRAGANA LETTER NA
        0x306B, # G+893  U+306B  uni306B,  HIRAGANA LETTER NI
        0x306C, # G+894  U+306C  uni306C,  HIRAGANA LETTER NU
        0x306D, # G+895  U+306D  uni306D,  HIRAGANA LETTER NE
        0x306E, # G+896  U+306E  uni306E,  HIRAGANA LETTER NO
        0x306F, # G+897  U+306F  uni306F,  HIRAGANA LETTER HA
        0x3070, # G+898  U+3070  uni3070,  HIRAGANA LETTER BA
        0x3071, # G+899  U+3071  uni3071,  HIRAGANA LETTER PA
        0x3072, # G+900  U+3072  uni3072,  HIRAGANA LETTER HI
        0x3073, # G+901  U+3073  uni3073,  HIRAGANA LETTER BI
        0x3074, # G+902  U+3074  uni3074,  HIRAGANA LETTER PI
        0x3075, # G+903  U+3075  uni3075,  HIRAGANA LETTER HU
        0x3076, # G+904  U+3076  uni3076,  HIRAGANA LETTER BU
        0x3077, # G+905  U+3077  uni3077,  HIRAGANA LETTER PU
        0x3078, # G+906  U+3078  uni3078,  HIRAGANA LETTER HE
        0x3079, # G+907  U+3079  uni3079,  HIRAGANA LETTER BE
        0x307A, # G+908  U+307A  uni307A,  HIRAGANA LETTER PE
        0x307B, # G+909  U+307B  uni307B,  HIRAGANA LETTER HO
        0x307C, # G+910  U+307C  uni307C,  HIRAGANA LETTER BO
        0x307D, # G+911  U+307D  uni307D,  HIRAGANA LETTER PO
        0x307E, # G+912  U+307E  uni307E,  HIRAGANA LETTER MA
        0x307F, # G+913  U+307F  uni307F,  HIRAGANA LETTER MI
        0x3080, # G+914  U+3080  uni3080,  HIRAGANA LETTER MU
        0x3081, # G+915  U+3081  uni3081,  HIRAGANA LETTER ME
        0x3082, # G+916  U+3082  uni3082,  HIRAGANA LETTER MO
        0x3083, # G+917  U+3083  uni3083,  HIRAGANA LETTER SMALL YA
        0x3084, # G+918  U+3084  uni3084,  HIRAGANA LETTER YA
        0x3085, # G+919  U+3085  uni3085,  HIRAGANA LETTER SMALL YU
        0x3086, # G+920  U+3086  uni3086,  HIRAGANA LETTER YU
        0x3087, # G+921  U+3087  uni3087,  HIRAGANA LETTER SMALL YO
        0x3088, # G+922  U+3088  uni3088,  HIRAGANA LETTER YO
        0x3089, # G+923  U+3089  uni3089,  HIRAGANA LETTER RA
        0x308A, # G+924  U+308A  uni308A,  HIRAGANA LETTER RI
        0x308B, # G+925  U+308B  uni308B,  HIRAGANA LETTER RU
        0x308C, # G+926  U+308C  uni308C,  HIRAGANA LETTER RE
        0x308D, # G+927  U+308D  uni308D,  HIRAGANA LETTER RO
        0x308E, # G+928  U+308E  uni308E,  HIRAGANA LETTER SMALL WA
        0x308F, # G+929  U+308F  uni308F,  HIRAGANA LETTER WA
        0x3090, # G+930  U+3090  uni3090,  HIRAGANA LETTER WI
        0x3091, # G+931  U+3091  uni3091,  HIRAGANA LETTER WE
        0x3092, # G+932  U+3092  uni3092,  HIRAGANA LETTER WO
        0x3093, # G+933  U+3093  uni3093,  HIRAGANA LETTER N
        0x30A1, # G+934  U+30A1  uni30A1,  KATAKANA LETTER SMALL A
        0x30A2, # G+935  U+30A2  uni30A2,  KATAKANA LETTER A
        0x30A3, # G+936  U+30A3  uni30A3,  KATAKANA LETTER SMALL I
        0x30A4, # G+937  U+30A4  uni30A4,  KATAKANA LETTER I
        0x30A5, # G+938  U+30A5  uni30A5,  KATAKANA LETTER SMALL U
        0x30A6, # G+939  U+30A6  uni30A6,  KATAKANA LETTER U
        0x30A7, # G+940  U+30A7  uni30A7,  KATAKANA LETTER SMALL E
        0x30A8, # G+941  U+30A8  uni30A8,  KATAKANA LETTER E
        0x30A9, # G+942  U+30A9  uni30A9,  KATAKANA LETTER SMALL O
        0x30AA, # G+943  U+30AA  uni30AA,  KATAKANA LETTER O
        0x30AB, # G+944  U+30AB  uni30AB,  KATAKANA LETTER KA
        0x30AC, # G+945  U+30AC  uni30AC,  KATAKANA LETTER GA
        0x30AD, # G+946  U+30AD  uni30AD,  KATAKANA LETTER KI
        0x30AE, # G+947  U+30AE  uni30AE,  KATAKANA LETTER GI
        0x30AF, # G+948  U+30AF  uni30AF,  KATAKANA LETTER KU
        0x30B0, # G+949  U+30B0  uni30B0,  KATAKANA LETTER GU
        0x30B1, # G+950  U+30B1  uni30B1,  KATAKANA LETTER KE
        0x30B2, # G+951  U+30B2  uni30B2,  KATAKANA LETTER GE
        0x30B3, # G+952  U+30B3  uni30B3,  KATAKANA LETTER KO
        0x30B4, # G+953  U+30B4  uni30B4,  KATAKANA LETTER GO
        0x30B5, # G+954  U+30B5  uni30B5,  KATAKANA LETTER SA
        0x30B6, # G+955  U+30B6  uni30B6,  KATAKANA LETTER ZA
        0x30B7, # G+956  U+30B7  uni30B7,  KATAKANA LETTER SI
        0x30B8, # G+957  U+30B8  uni30B8,  KATAKANA LETTER ZI
        0x30B9, # G+958  U+30B9  uni30B9,  KATAKANA LETTER SU
        0x30BA, # G+959  U+30BA  uni30BA,  KATAKANA LETTER ZU
        0x30BB, # G+960  U+30BB  uni30BB,  KATAKANA LETTER SE
        0x30BC, # G+961  U+30BC  uni30BC,  KATAKANA LETTER ZE
        0x30BD, # G+962  U+30BD  uni30BD,  KATAKANA LETTER SO
        0x30BE, # G+963  U+30BE  uni30BE,  KATAKANA LETTER ZO
        0x30BF, # G+964  U+30BF  uni30BF,  KATAKANA LETTER TA
        0x30C0, # G+965  U+30C0  uni30C0,  KATAKANA LETTER DA
        0x30C1, # G+966  U+30C1  uni30C1,  KATAKANA LETTER TI
        0x30C2, # G+967  U+30C2  uni30C2,  KATAKANA LETTER DI
        0x30C3, # G+968  U+30C3  uni30C3,  KATAKANA LETTER SMALL TU
        0x30C4, # G+969  U+30C4  uni30C4,  KATAKANA LETTER TU
        0x30C5, # G+970  U+30C5  uni30C5,  KATAKANA LETTER DU
        0x30C6, # G+971  U+30C6  uni30C6,  KATAKANA LETTER TE
        0x30C7, # G+972  U+30C7  uni30C7,  KATAKANA LETTER DE
        0x30C8, # G+973  U+30C8  uni30C8,  KATAKANA LETTER TO
        0x30C9, # G+974  U+30C9  uni30C9,  KATAKANA LETTER DO
        0x30CA, # G+975  U+30CA  uni30CA,  KATAKANA LETTER NA
        0x30CB, # G+976  U+30CB  uni30CB,  KATAKANA LETTER NI
        0x30CC, # G+977  U+30CC  uni30CC,  KATAKANA LETTER NU
        0x30CD, # G+978  U+30CD  uni30CD,  KATAKANA LETTER NE
        0x30CE, # G+979  U+30CE  uni30CE,  KATAKANA LETTER NO
        0x30CF, # G+980  U+30CF  uni30CF,  KATAKANA LETTER HA
        0x30D0, # G+981  U+30D0  uni30D0,  KATAKANA LETTER BA
        0x30D1, # G+982  U+30D1  uni30D1,  KATAKANA LETTER PA
        0x30D2, # G+983  U+30D2  uni30D2,  KATAKANA LETTER HI
        0x30D3, # G+984  U+30D3  uni30D3,  KATAKANA LETTER BI
        0x30D4, # G+985  U+30D4  uni30D4,  KATAKANA LETTER PI
        0x30D5, # G+986  U+30D5  uni30D5,  KATAKANA LETTER HU
        0x30D6, # G+987  U+30D6  uni30D6,  KATAKANA LETTER BU
        0x30D7, # G+988  U+30D7  uni30D7,  KATAKANA LETTER PU
        0x30D8, # G+989  U+30D8  uni30D8,  KATAKANA LETTER HE
        0x30D9, # G+990  U+30D9  uni30D9,  KATAKANA LETTER BE
        0x30DA, # G+991  U+30DA  uni30DA,  KATAKANA LETTER PE
        0x30DB, # G+992  U+30DB  uni30DB,  KATAKANA LETTER HO
        0x30DC, # G+993  U+30DC  uni30DC,  KATAKANA LETTER BO
        0x30DD, # G+994  U+30DD  uni30DD,  KATAKANA LETTER PO
        0x30DE, # G+995  U+30DE  uni30DE,  KATAKANA LETTER MA
        0x30DF, # G+996  U+30DF  uni30DF,  KATAKANA LETTER MI
        0x30E0, # G+997  U+30E0  uni30E0,  KATAKANA LETTER MU
        0x30E1, # G+998  U+30E1  uni30E1,  KATAKANA LETTER ME
        0x30E2, # G+999  U+30E2  uni30E2,  KATAKANA LETTER MO
        0x30E3, # G+1000  U+30E3  uni30E3,  KATAKANA LETTER SMALL YA
        0x30E4, # G+1001  U+30E4  uni30E4,  KATAKANA LETTER YA
        0x30E5, # G+1002  U+30E5  uni30E5,  KATAKANA LETTER SMALL YU
        0x30E6, # G+1003  U+30E6  uni30E6,  KATAKANA LETTER YU
        0x30E7, # G+1004  U+30E7  uni30E7,  KATAKANA LETTER SMALL YO
        0x30E8, # G+1005  U+30E8  uni30E8,  KATAKANA LETTER YO
        0x30E9, # G+1006  U+30E9  uni30E9,  KATAKANA LETTER RA
        0x30EA, # G+1007  U+30EA  uni30EA,  KATAKANA LETTER RI
        0x30EB, # G+1008  U+30EB  uni30EB,  KATAKANA LETTER RU
        0x30EC, # G+1009  U+30EC  uni30EC,  KATAKANA LETTER RE
        0x30ED, # G+1010  U+30ED  uni30ED,  KATAKANA LETTER RO
        0x30EE, # G+1011  U+30EE  uni30EE,  KATAKANA LETTER SMALL WA
        0x30EF, # G+1012  U+30EF  uni30EF,  KATAKANA LETTER WA
        0x30F0, # G+1013  U+30F0  uni30F0,  KATAKANA LETTER WI
        0x30F1, # G+1014  U+30F1  uni30F1,  KATAKANA LETTER WE
        0x30F2, # G+1015  U+30F2  uni30F2,  KATAKANA LETTER WO
        0x30F3, # G+1016  U+30F3  uni30F3,  KATAKANA LETTER N
        0x30F4, # G+1017  U+30F4  uni30F4,  KATAKANA LETTER VU
        0x30F5, # G+1018  U+30F5  uni30F5,  KATAKANA LETTER SMALL KA
        0x30F6, # G+1019  U+30F6  uni30F6,  KATAKANA LETTER SMALL KE
        0x0410, # G+1020  U+0410  afii10017,  CYRILLIC CAPITAL LETTER A
        0x0411, # G+1021  U+0411  afii10018,  CYRILLIC CAPITAL LETTER BE
        0x0412, # G+1022  U+0412  afii10019,  CYRILLIC CAPITAL LETTER VE
        0x0413, # G+1023  U+0413  afii10020,  CYRILLIC CAPITAL LETTER GHE
        0x0414, # G+1024  U+0414  afii10021,  CYRILLIC CAPITAL LETTER DE
        0x0415, # G+1025  U+0415  afii10022,  CYRILLIC CAPITAL LETTER IE
        0x0401, # G+1026  U+0401  afii10023,  CYRILLIC CAPITAL LETTER IO
        0x0416, # G+1027  U+0416  afii10024,  CYRILLIC CAPITAL LETTER ZHE
        0x0417, # G+1028  U+0417  afii10025,  CYRILLIC CAPITAL LETTER ZE
        0x0418, # G+1029  U+0418  afii10026,  CYRILLIC CAPITAL LETTER I
        0x0419, # G+1030  U+0419  afii10027,  CYRILLIC CAPITAL LETTER SHORT I
        0x041A, # G+1031  U+041A  afii10028,  CYRILLIC CAPITAL LETTER KA
        0x041B, # G+1032  U+041B  afii10029,  CYRILLIC CAPITAL LETTER EL
        0x041C, # G+1033  U+041C  afii10030,  CYRILLIC CAPITAL LETTER EM
        0x041D, # G+1034  U+041D  afii10031,  CYRILLIC CAPITAL LETTER EN
        0x041E, # G+1035  U+041E  afii10032,  CYRILLIC CAPITAL LETTER O
        0x041F, # G+1036  U+041F  afii10033,  CYRILLIC CAPITAL LETTER PE
        0x0420, # G+1037  U+0420  afii10034,  CYRILLIC CAPITAL LETTER ER
        0x0421, # G+1038  U+0421  afii10035,  CYRILLIC CAPITAL LETTER ES
        0x0422, # G+1039  U+0422  afii10036,  CYRILLIC CAPITAL LETTER TE
        0x0423, # G+1040  U+0423  afii10037,  CYRILLIC CAPITAL LETTER U
        0x0424, # G+1041  U+0424  afii10038,  CYRILLIC CAPITAL LETTER EF
        0x0425, # G+1042  U+0425  afii10039,  CYRILLIC CAPITAL LETTER HA
        0x0426, # G+1043  U+0426  afii10040,  CYRILLIC CAPITAL LETTER TSE
        0x0427, # G+1044  U+0427  afii10041,  CYRILLIC CAPITAL LETTER CHE
        0x0428, # G+1045  U+0428  afii10042,  CYRILLIC CAPITAL LETTER SHA
        0x0429, # G+1046  U+0429  afii10043,  CYRILLIC CAPITAL LETTER SHCHA
        0x042A, # G+1047  U+042A  afii10044,  CYRILLIC CAPITAL LETTER HARD SIGN
        0x042B, # G+1048  U+042B  afii10045,  CYRILLIC CAPITAL LETTER YERU
        0x042C, # G+1049  U+042C  afii10046,  CYRILLIC CAPITAL LETTER SOFT SIGN
        0x042D, # G+1050  U+042D  afii10047,  CYRILLIC CAPITAL LETTER E
        0x042E, # G+1051  U+042E  afii10048,  CYRILLIC CAPITAL LETTER YU
        0x042F, # G+1052  U+042F  afii10049,  CYRILLIC CAPITAL LETTER YA
        0x0430, # G+1053  U+0430  afii10065,  CYRILLIC SMALL LETTER A
        0x0431, # G+1054  U+0431  afii10066,  CYRILLIC SMALL LETTER BE
        0x0432, # G+1055  U+0432  afii10067,  CYRILLIC SMALL LETTER VE
        0x0433, # G+1056  U+0433  afii10068,  CYRILLIC SMALL LETTER GHE
        0x0434, # G+1057  U+0434  afii10069,  CYRILLIC SMALL LETTER DE
        0x0435, # G+1058  U+0435  afii10070,  CYRILLIC SMALL LETTER IE
        0x0451, # G+1059  U+0451  afii10071,  CYRILLIC SMALL LETTER IO
        0x0436, # G+1060  U+0436  afii10072,  CYRILLIC SMALL LETTER ZHE
        0x0437, # G+1061  U+0437  afii10073,  CYRILLIC SMALL LETTER ZE
        0x0438, # G+1062  U+0438  afii10074,  CYRILLIC SMALL LETTER I
        0x0439, # G+1063  U+0439  afii10075,  CYRILLIC SMALL LETTER SHORT I
        0x043A, # G+1064  U+043A  afii10076,  CYRILLIC SMALL LETTER KA
        0x043B, # G+1065  U+043B  afii10077,  CYRILLIC SMALL LETTER EL
        0x043C, # G+1066  U+043C  afii10078,  CYRILLIC SMALL LETTER EM
        0x043D, # G+1067  U+043D  afii10079,  CYRILLIC SMALL LETTER EN
        0x043E, # G+1068  U+043E  afii10080,  CYRILLIC SMALL LETTER O
        0x043F, # G+1069  U+043F  afii10081,  CYRILLIC SMALL LETTER PE
        0x0440, # G+1070  U+0440  afii10082,  CYRILLIC SMALL LETTER ER
        0x0441, # G+1071  U+0441  afii10083,  CYRILLIC SMALL LETTER ES
        0x0442, # G+1072  U+0442  afii10084,  CYRILLIC SMALL LETTER TE
        0x0443, # G+1073  U+0443  afii10085,  CYRILLIC SMALL LETTER U
        0x0444, # G+1074  U+0444  afii10086,  CYRILLIC SMALL LETTER EF
        0x0445, # G+1075  U+0445  afii10087,  CYRILLIC SMALL LETTER HA
        0x0446, # G+1076  U+0446  afii10088,  CYRILLIC SMALL LETTER TSE
        0x0447, # G+1077  U+0447  afii10089,  CYRILLIC SMALL LETTER CHE
        0x0448, # G+1078  U+0448  afii10090,  CYRILLIC SMALL LETTER SHA
        0x0449, # G+1079  U+0449  afii10091,  CYRILLIC SMALL LETTER SHCHA
        0x044A, # G+1080  U+044A  afii10092,  CYRILLIC SMALL LETTER HARD SIGN
        0x044B, # G+1081  U+044B  afii10093,  CYRILLIC SMALL LETTER YERU
        0x044C, # G+1082  U+044C  afii10094,  CYRILLIC SMALL LETTER SOFT SIGN
        0x044D, # G+1083  U+044D  afii10095,  CYRILLIC SMALL LETTER E
        0x044E, # G+1084  U+044E  afii10096,  CYRILLIC SMALL LETTER YU
        0x044F, # G+1085  U+044F  afii10097,  CYRILLIC SMALL LETTER YA
        0xAC00, # G+1086  U+AC00  uniAC00,  HANGUL SYLLABLE-AC00
        0xAC01, # G+1087  U+AC01  uniAC01,  HANGUL SYLLABLE-AC01
        0xAC04, # G+1088  U+AC04  uniAC04,  HANGUL SYLLABLE-AC04
        0xAC07, # G+1089  U+AC07  uniAC07,  HANGUL SYLLABLE-AC07
        0xAC08, # G+1090  U+AC08  uniAC08,  HANGUL SYLLABLE-AC08
        0xAC09, # G+1091  U+AC09  uniAC09,  HANGUL SYLLABLE-AC09
        0xAC0A, # G+1092  U+AC0A  uniAC0A,  HANGUL SYLLABLE-AC0A
        0xAC10, # G+1093  U+AC10  uniAC10,  HANGUL SYLLABLE-AC10
        0xAC11, # G+1094  U+AC11  uniAC11,  HANGUL SYLLABLE-AC11
        0xAC12, # G+1095  U+AC12  uniAC12,  HANGUL SYLLABLE-AC12
        0xAC13, # G+1096  U+AC13  uniAC13,  HANGUL SYLLABLE-AC13
        0xAC14, # G+1097  U+AC14  uniAC14,  HANGUL SYLLABLE-AC14
        0xAC15, # G+1098  U+AC15  uniAC15,  HANGUL SYLLABLE-AC15
        0xAC16, # G+1099  U+AC16  uniAC16,  HANGUL SYLLABLE-AC16
        0xAC17, # G+1100  U+AC17  uniAC17,  HANGUL SYLLABLE-AC17
        0xAC19, # G+1101  U+AC19  uniAC19,  HANGUL SYLLABLE-AC19
        0xAC1A, # G+1102  U+AC1A  uniAC1A,  HANGUL SYLLABLE-AC1A
        0xAC1B, # G+1103  U+AC1B  uniAC1B,  HANGUL SYLLABLE-AC1B
        0xAC1C, # G+1104  U+AC1C  uniAC1C,  HANGUL SYLLABLE-AC1C
        0xAC1D, # G+1105  U+AC1D  uniAC1D,  HANGUL SYLLABLE-AC1D
        0xAC20, # G+1106  U+AC20  uniAC20,  HANGUL SYLLABLE-AC20
        0xAC24, # G+1107  U+AC24  uniAC24,  HANGUL SYLLABLE-AC24
        0xAC2C, # G+1108  U+AC2C  uniAC2C,  HANGUL SYLLABLE-AC2C
        0xAC2D, # G+1109  U+AC2D  uniAC2D,  HANGUL SYLLABLE-AC2D
        0xAC2F, # G+1110  U+AC2F  uniAC2F,  HANGUL SYLLABLE-AC2F
        0xAC30, # G+1111  U+AC30  uniAC30,  HANGUL SYLLABLE-AC30
        0xAC31, # G+1112  U+AC31  uniAC31,  HANGUL SYLLABLE-AC31
        0xAC38, # G+1113  U+AC38  uniAC38,  HANGUL SYLLABLE-AC38
        0xAC39, # G+1114  U+AC39  uniAC39,  HANGUL SYLLABLE-AC39
        0xAC3C, # G+1115  U+AC3C  uniAC3C,  HANGUL SYLLABLE-AC3C
        0xAC40, # G+1116  U+AC40  uniAC40,  HANGUL SYLLABLE-AC40
        0xAC4B, # G+1117  U+AC4B  uniAC4B,  HANGUL SYLLABLE-AC4B
        0xAC4D, # G+1118  U+AC4D  uniAC4D,  HANGUL SYLLABLE-AC4D
        0xAC54, # G+1119  U+AC54  uniAC54,  HANGUL SYLLABLE-AC54
        0xAC58, # G+1120  U+AC58  uniAC58,  HANGUL SYLLABLE-AC58
        0xAC5C, # G+1121  U+AC5C  uniAC5C,  HANGUL SYLLABLE-AC5C
        0xAC70, # G+1122  U+AC70  uniAC70,  HANGUL SYLLABLE-AC70
        0xAC71, # G+1123  U+AC71  uniAC71,  HANGUL SYLLABLE-AC71
        0xAC74, # G+1124  U+AC74  uniAC74,  HANGUL SYLLABLE-AC74
        0xAC77, # G+1125  U+AC77  uniAC77,  HANGUL SYLLABLE-AC77
        0xAC78, # G+1126  U+AC78  uniAC78,  HANGUL SYLLABLE-AC78
        0xAC7A, # G+1127  U+AC7A  uniAC7A,  HANGUL SYLLABLE-AC7A
        0xAC80, # G+1128  U+AC80  uniAC80,  HANGUL SYLLABLE-AC80
        0xAC81, # G+1129  U+AC81  uniAC81,  HANGUL SYLLABLE-AC81
        0xAC83, # G+1130  U+AC83  uniAC83,  HANGUL SYLLABLE-AC83
        0xAC84, # G+1131  U+AC84  uniAC84,  HANGUL SYLLABLE-AC84
        0xAC85, # G+1132  U+AC85  uniAC85,  HANGUL SYLLABLE-AC85
        0xAC86, # G+1133  U+AC86  uniAC86,  HANGUL SYLLABLE-AC86
        0xAC89, # G+1134  U+AC89  uniAC89,  HANGUL SYLLABLE-AC89
        0xAC8A, # G+1135  U+AC8A  uniAC8A,  HANGUL SYLLABLE-AC8A
        0xAC8B, # G+1136  U+AC8B  uniAC8B,  HANGUL SYLLABLE-AC8B
        0xAC8C, # G+1137  U+AC8C  uniAC8C,  HANGUL SYLLABLE-AC8C
        0xAC90, # G+1138  U+AC90  uniAC90,  HANGUL SYLLABLE-AC90
        0xAC94, # G+1139  U+AC94  uniAC94,  HANGUL SYLLABLE-AC94
        0xAC9C, # G+1140  U+AC9C  uniAC9C,  HANGUL SYLLABLE-AC9C
        0xAC9D, # G+1141  U+AC9D  uniAC9D,  HANGUL SYLLABLE-AC9D
        0xAC9F, # G+1142  U+AC9F  uniAC9F,  HANGUL SYLLABLE-AC9F
        0xACA0, # G+1143  U+ACA0  uniACA0,  HANGUL SYLLABLE-ACA0
        0xACA1, # G+1144  U+ACA1  uniACA1,  HANGUL SYLLABLE-ACA1
        0xACA8, # G+1145  U+ACA8  uniACA8,  HANGUL SYLLABLE-ACA8
        0xACA9, # G+1146  U+ACA9  uniACA9,  HANGUL SYLLABLE-ACA9
        0xACAA, # G+1147  U+ACAA  uniACAA,  HANGUL SYLLABLE-ACAA
        0xACAC, # G+1148  U+ACAC  uniACAC,  HANGUL SYLLABLE-ACAC
        0xACAF, # G+1149  U+ACAF  uniACAF,  HANGUL SYLLABLE-ACAF
        0xACB0, # G+1150  U+ACB0  uniACB0,  HANGUL SYLLABLE-ACB0
        0xACB8, # G+1151  U+ACB8  uniACB8,  HANGUL SYLLABLE-ACB8
        0xACB9, # G+1152  U+ACB9  uniACB9,  HANGUL SYLLABLE-ACB9
        0xACBB, # G+1153  U+ACBB  uniACBB,  HANGUL SYLLABLE-ACBB
        0xACBC, # G+1154  U+ACBC  uniACBC,  HANGUL SYLLABLE-ACBC
        0xACBD, # G+1155  U+ACBD  uniACBD,  HANGUL SYLLABLE-ACBD
        0xACC1, # G+1156  U+ACC1  uniACC1,  HANGUL SYLLABLE-ACC1
        0xACC4, # G+1157  U+ACC4  uniACC4,  HANGUL SYLLABLE-ACC4
        0xACC8, # G+1158  U+ACC8  uniACC8,  HANGUL SYLLABLE-ACC8
        0xACCC, # G+1159  U+ACCC  uniACCC,  HANGUL SYLLABLE-ACCC
        0xACD5, # G+1160  U+ACD5  uniACD5,  HANGUL SYLLABLE-ACD5
        0xACD7, # G+1161  U+ACD7  uniACD7,  HANGUL SYLLABLE-ACD7
        0xACE0, # G+1162  U+ACE0  uniACE0,  HANGUL SYLLABLE-ACE0
        0xACE1, # G+1163  U+ACE1  uniACE1,  HANGUL SYLLABLE-ACE1
        0xACE4, # G+1164  U+ACE4  uniACE4,  HANGUL SYLLABLE-ACE4
        0xACE7, # G+1165  U+ACE7  uniACE7,  HANGUL SYLLABLE-ACE7
        0xACE8, # G+1166  U+ACE8  uniACE8,  HANGUL SYLLABLE-ACE8
        0xACEA, # G+1167  U+ACEA  uniACEA,  HANGUL SYLLABLE-ACEA
        0xACEC, # G+1168  U+ACEC  uniACEC,  HANGUL SYLLABLE-ACEC
        0xACEF, # G+1169  U+ACEF  uniACEF,  HANGUL SYLLABLE-ACEF
        0xACF0, # G+1170  U+ACF0  uniACF0,  HANGUL SYLLABLE-ACF0
        0xACF1, # G+1171  U+ACF1  uniACF1,  HANGUL SYLLABLE-ACF1
        0xACF3, # G+1172  U+ACF3  uniACF3,  HANGUL SYLLABLE-ACF3
        0xACF5, # G+1173  U+ACF5  uniACF5,  HANGUL SYLLABLE-ACF5
        0xACF6, # G+1174  U+ACF6  uniACF6,  HANGUL SYLLABLE-ACF6
        0xACFC, # G+1175  U+ACFC  uniACFC,  HANGUL SYLLABLE-ACFC
        0xACFD, # G+1176  U+ACFD  uniACFD,  HANGUL SYLLABLE-ACFD
        0xAD00, # G+1177  U+AD00  uniAD00,  HANGUL SYLLABLE-AD00
        0xAD04, # G+1178  U+AD04  uniAD04,  HANGUL SYLLABLE-AD04
        0xAD06, # G+1179  U+AD06  uniAD06,  HANGUL SYLLABLE-AD06
        0xAD0C, # G+1180  U+AD0C  uniAD0C,  HANGUL SYLLABLE-AD0C
        0xAD0D, # G+1181  U+AD0D  uniAD0D,  HANGUL SYLLABLE-AD0D
        0xAD0F, # G+1182  U+AD0F  uniAD0F,  HANGUL SYLLABLE-AD0F
        0xAD11, # G+1183  U+AD11  uniAD11,  HANGUL SYLLABLE-AD11
        0xAD18, # G+1184  U+AD18  uniAD18,  HANGUL SYLLABLE-AD18
        0xAD1C, # G+1185  U+AD1C  uniAD1C,  HANGUL SYLLABLE-AD1C
        0xAD20, # G+1186  U+AD20  uniAD20,  HANGUL SYLLABLE-AD20
        0xAD29, # G+1187  U+AD29  uniAD29,  HANGUL SYLLABLE-AD29
        0xAD2C, # G+1188  U+AD2C  uniAD2C,  HANGUL SYLLABLE-AD2C
        0xAD2D, # G+1189  U+AD2D  uniAD2D,  HANGUL SYLLABLE-AD2D
        0xAD34, # G+1190  U+AD34  uniAD34,  HANGUL SYLLABLE-AD34
        0xAD35, # G+1191  U+AD35  uniAD35,  HANGUL SYLLABLE-AD35
        0xAD38, # G+1192  U+AD38  uniAD38,  HANGUL SYLLABLE-AD38
        0xAD3C, # G+1193  U+AD3C  uniAD3C,  HANGUL SYLLABLE-AD3C
        0xAD44, # G+1194  U+AD44  uniAD44,  HANGUL SYLLABLE-AD44
        0xAD45, # G+1195  U+AD45  uniAD45,  HANGUL SYLLABLE-AD45
        0xAD47, # G+1196  U+AD47  uniAD47,  HANGUL SYLLABLE-AD47
        0xAD49, # G+1197  U+AD49  uniAD49,  HANGUL SYLLABLE-AD49
        0xAD50, # G+1198  U+AD50  uniAD50,  HANGUL SYLLABLE-AD50
        0xAD54, # G+1199  U+AD54  uniAD54,  HANGUL SYLLABLE-AD54
        0xAD58, # G+1200  U+AD58  uniAD58,  HANGUL SYLLABLE-AD58
        0xAD61, # G+1201  U+AD61  uniAD61,  HANGUL SYLLABLE-AD61
        0xAD63, # G+1202  U+AD63  uniAD63,  HANGUL SYLLABLE-AD63
        0xAD6C, # G+1203  U+AD6C  uniAD6C,  HANGUL SYLLABLE-AD6C
        0xAD6D, # G+1204  U+AD6D  uniAD6D,  HANGUL SYLLABLE-AD6D
        0xAD70, # G+1205  U+AD70  uniAD70,  HANGUL SYLLABLE-AD70
        0xAD73, # G+1206  U+AD73  uniAD73,  HANGUL SYLLABLE-AD73
        0xAD74, # G+1207  U+AD74  uniAD74,  HANGUL SYLLABLE-AD74
        0xAD75, # G+1208  U+AD75  uniAD75,  HANGUL SYLLABLE-AD75
        0xAD76, # G+1209  U+AD76  uniAD76,  HANGUL SYLLABLE-AD76
        0xAD7B, # G+1210  U+AD7B  uniAD7B,  HANGUL SYLLABLE-AD7B
        0xAD7C, # G+1211  U+AD7C  uniAD7C,  HANGUL SYLLABLE-AD7C
        0xAD7D, # G+1212  U+AD7D  uniAD7D,  HANGUL SYLLABLE-AD7D
        0xAD7F, # G+1213  U+AD7F  uniAD7F,  HANGUL SYLLABLE-AD7F
        0xAD81, # G+1214  U+AD81  uniAD81,  HANGUL SYLLABLE-AD81
        0xAD82, # G+1215  U+AD82  uniAD82,  HANGUL SYLLABLE-AD82
        0xAD88, # G+1216  U+AD88  uniAD88,  HANGUL SYLLABLE-AD88
        0xAD89, # G+1217  U+AD89  uniAD89,  HANGUL SYLLABLE-AD89
        0xAD8C, # G+1218  U+AD8C  uniAD8C,  HANGUL SYLLABLE-AD8C
        0xAD90, # G+1219  U+AD90  uniAD90,  HANGUL SYLLABLE-AD90
        0xAD9C, # G+1220  U+AD9C  uniAD9C,  HANGUL SYLLABLE-AD9C
        0xAD9D, # G+1221  U+AD9D  uniAD9D,  HANGUL SYLLABLE-AD9D
        0xADA4, # G+1222  U+ADA4  uniADA4,  HANGUL SYLLABLE-ADA4
        0xADB7, # G+1223  U+ADB7  uniADB7,  HANGUL SYLLABLE-ADB7
        0xADC0, # G+1224  U+ADC0  uniADC0,  HANGUL SYLLABLE-ADC0
        0xADC1, # G+1225  U+ADC1  uniADC1,  HANGUL SYLLABLE-ADC1
        0xADC4, # G+1226  U+ADC4  uniADC4,  HANGUL SYLLABLE-ADC4
        0xADC8, # G+1227  U+ADC8  uniADC8,  HANGUL SYLLABLE-ADC8
        0xADD0, # G+1228  U+ADD0  uniADD0,  HANGUL SYLLABLE-ADD0
        0xADD1, # G+1229  U+ADD1  uniADD1,  HANGUL SYLLABLE-ADD1
        0xADD3, # G+1230  U+ADD3  uniADD3,  HANGUL SYLLABLE-ADD3
        0xADDC, # G+1231  U+ADDC  uniADDC,  HANGUL SYLLABLE-ADDC
        0xADE0, # G+1232  U+ADE0  uniADE0,  HANGUL SYLLABLE-ADE0
        0xADE4, # G+1233  U+ADE4  uniADE4,  HANGUL SYLLABLE-ADE4
        0xADF8, # G+1234  U+ADF8  uniADF8,  HANGUL SYLLABLE-ADF8
        0xADF9, # G+1235  U+ADF9  uniADF9,  HANGUL SYLLABLE-ADF9
        0xADFC, # G+1236  U+ADFC  uniADFC,  HANGUL SYLLABLE-ADFC
        0xADFF, # G+1237  U+ADFF  uniADFF,  HANGUL SYLLABLE-ADFF
        0xAE00, # G+1238  U+AE00  uniAE00,  HANGUL SYLLABLE-AE00
        0xAE01, # G+1239  U+AE01  uniAE01,  HANGUL SYLLABLE-AE01
        0xAE08, # G+1240  U+AE08  uniAE08,  HANGUL SYLLABLE-AE08
        0xAE09, # G+1241  U+AE09  uniAE09,  HANGUL SYLLABLE-AE09
        0xAE0B, # G+1242  U+AE0B  uniAE0B,  HANGUL SYLLABLE-AE0B
        0xAE0D, # G+1243  U+AE0D  uniAE0D,  HANGUL SYLLABLE-AE0D
        0xAE14, # G+1244  U+AE14  uniAE14,  HANGUL SYLLABLE-AE14
        0xAE30, # G+1245  U+AE30  uniAE30,  HANGUL SYLLABLE-AE30
        0xAE31, # G+1246  U+AE31  uniAE31,  HANGUL SYLLABLE-AE31
        0xAE34, # G+1247  U+AE34  uniAE34,  HANGUL SYLLABLE-AE34
        0xAE37, # G+1248  U+AE37  uniAE37,  HANGUL SYLLABLE-AE37
        0xAE38, # G+1249  U+AE38  uniAE38,  HANGUL SYLLABLE-AE38
        0xAE3A, # G+1250  U+AE3A  uniAE3A,  HANGUL SYLLABLE-AE3A
        0xAE40, # G+1251  U+AE40  uniAE40,  HANGUL SYLLABLE-AE40
        0xAE41, # G+1252  U+AE41  uniAE41,  HANGUL SYLLABLE-AE41
        0xAE43, # G+1253  U+AE43  uniAE43,  HANGUL SYLLABLE-AE43
        0xAE45, # G+1254  U+AE45  uniAE45,  HANGUL SYLLABLE-AE45
        0xAE46, # G+1255  U+AE46  uniAE46,  HANGUL SYLLABLE-AE46
        0xAE4A, # G+1256  U+AE4A  uniAE4A,  HANGUL SYLLABLE-AE4A
        0xAE4C, # G+1257  U+AE4C  uniAE4C,  HANGUL SYLLABLE-AE4C
        0xAE4D, # G+1258  U+AE4D  uniAE4D,  HANGUL SYLLABLE-AE4D
        0xAE4E, # G+1259  U+AE4E  uniAE4E,  HANGUL SYLLABLE-AE4E
        0xAE50, # G+1260  U+AE50  uniAE50,  HANGUL SYLLABLE-AE50
        0xAE54, # G+1261  U+AE54  uniAE54,  HANGUL SYLLABLE-AE54
        0xAE56, # G+1262  U+AE56  uniAE56,  HANGUL SYLLABLE-AE56
        0xAE5C, # G+1263  U+AE5C  uniAE5C,  HANGUL SYLLABLE-AE5C
        0xAE5D, # G+1264  U+AE5D  uniAE5D,  HANGUL SYLLABLE-AE5D
        0xAE5F, # G+1265  U+AE5F  uniAE5F,  HANGUL SYLLABLE-AE5F
        0xAE60, # G+1266  U+AE60  uniAE60,  HANGUL SYLLABLE-AE60
        0xAE61, # G+1267  U+AE61  uniAE61,  HANGUL SYLLABLE-AE61
        0xAE65, # G+1268  U+AE65  uniAE65,  HANGUL SYLLABLE-AE65
        0xAE68, # G+1269  U+AE68  uniAE68,  HANGUL SYLLABLE-AE68
        0xAE69, # G+1270  U+AE69  uniAE69,  HANGUL SYLLABLE-AE69
        0xAE6C, # G+1271  U+AE6C  uniAE6C,  HANGUL SYLLABLE-AE6C
        0xAE70, # G+1272  U+AE70  uniAE70,  HANGUL SYLLABLE-AE70
        0xAE78, # G+1273  U+AE78  uniAE78,  HANGUL SYLLABLE-AE78
        0xAE79, # G+1274  U+AE79  uniAE79,  HANGUL SYLLABLE-AE79
        0xAE7B, # G+1275  U+AE7B  uniAE7B,  HANGUL SYLLABLE-AE7B
        0xAE7C, # G+1276  U+AE7C  uniAE7C,  HANGUL SYLLABLE-AE7C
        0xAE7D, # G+1277  U+AE7D  uniAE7D,  HANGUL SYLLABLE-AE7D
        0xAE84, # G+1278  U+AE84  uniAE84,  HANGUL SYLLABLE-AE84
        0xAE85, # G+1279  U+AE85  uniAE85,  HANGUL SYLLABLE-AE85
        0xAE8C, # G+1280  U+AE8C  uniAE8C,  HANGUL SYLLABLE-AE8C
        0xAEBC, # G+1281  U+AEBC  uniAEBC,  HANGUL SYLLABLE-AEBC
        0xAEBD, # G+1282  U+AEBD  uniAEBD,  HANGUL SYLLABLE-AEBD
        0xAEBE, # G+1283  U+AEBE  uniAEBE,  HANGUL SYLLABLE-AEBE
        0xAEC0, # G+1284  U+AEC0  uniAEC0,  HANGUL SYLLABLE-AEC0
        0xAEC4, # G+1285  U+AEC4  uniAEC4,  HANGUL SYLLABLE-AEC4
        0xAECC, # G+1286  U+AECC  uniAECC,  HANGUL SYLLABLE-AECC
        0xAECD, # G+1287  U+AECD  uniAECD,  HANGUL SYLLABLE-AECD
        0xAECF, # G+1288  U+AECF  uniAECF,  HANGUL SYLLABLE-AECF
        0xAED0, # G+1289  U+AED0  uniAED0,  HANGUL SYLLABLE-AED0
        0xAED1, # G+1290  U+AED1  uniAED1,  HANGUL SYLLABLE-AED1
        0xAED8, # G+1291  U+AED8  uniAED8,  HANGUL SYLLABLE-AED8
        0xAED9, # G+1292  U+AED9  uniAED9,  HANGUL SYLLABLE-AED9
        0xAEDC, # G+1293  U+AEDC  uniAEDC,  HANGUL SYLLABLE-AEDC
        0xAEE8, # G+1294  U+AEE8  uniAEE8,  HANGUL SYLLABLE-AEE8
        0xAEEB, # G+1295  U+AEEB  uniAEEB,  HANGUL SYLLABLE-AEEB
        0xAEED, # G+1296  U+AEED  uniAEED,  HANGUL SYLLABLE-AEED
        0xAEF4, # G+1297  U+AEF4  uniAEF4,  HANGUL SYLLABLE-AEF4
        0xAEF8, # G+1298  U+AEF8  uniAEF8,  HANGUL SYLLABLE-AEF8
        0xAEFC, # G+1299  U+AEFC  uniAEFC,  HANGUL SYLLABLE-AEFC
        0xAF07, # G+1300  U+AF07  uniAF07,  HANGUL SYLLABLE-AF07
        0xAF08, # G+1301  U+AF08  uniAF08,  HANGUL SYLLABLE-AF08
        0xAF0D, # G+1302  U+AF0D  uniAF0D,  HANGUL SYLLABLE-AF0D
        0xAF10, # G+1303  U+AF10  uniAF10,  HANGUL SYLLABLE-AF10
        0xAF2C, # G+1304  U+AF2C  uniAF2C,  HANGUL SYLLABLE-AF2C
        0xAF2D, # G+1305  U+AF2D  uniAF2D,  HANGUL SYLLABLE-AF2D
        0xAF30, # G+1306  U+AF30  uniAF30,  HANGUL SYLLABLE-AF30
        0xAF32, # G+1307  U+AF32  uniAF32,  HANGUL SYLLABLE-AF32
        0xAF34, # G+1308  U+AF34  uniAF34,  HANGUL SYLLABLE-AF34
        0xAF3C, # G+1309  U+AF3C  uniAF3C,  HANGUL SYLLABLE-AF3C
        0xAF3D, # G+1310  U+AF3D  uniAF3D,  HANGUL SYLLABLE-AF3D
        0xAF3F, # G+1311  U+AF3F  uniAF3F,  HANGUL SYLLABLE-AF3F
        0xAF41, # G+1312  U+AF41  uniAF41,  HANGUL SYLLABLE-AF41
        0xAF42, # G+1313  U+AF42  uniAF42,  HANGUL SYLLABLE-AF42
        0xAF43, # G+1314  U+AF43  uniAF43,  HANGUL SYLLABLE-AF43
        0xAF48, # G+1315  U+AF48  uniAF48,  HANGUL SYLLABLE-AF48
        0xAF49, # G+1316  U+AF49  uniAF49,  HANGUL SYLLABLE-AF49
        0xAF50, # G+1317  U+AF50  uniAF50,  HANGUL SYLLABLE-AF50
        0xAF5C, # G+1318  U+AF5C  uniAF5C,  HANGUL SYLLABLE-AF5C
        0xAF5D, # G+1319  U+AF5D  uniAF5D,  HANGUL SYLLABLE-AF5D
        0xAF64, # G+1320  U+AF64  uniAF64,  HANGUL SYLLABLE-AF64
        0xAF65, # G+1321  U+AF65  uniAF65,  HANGUL SYLLABLE-AF65
        0xAF79, # G+1322  U+AF79  uniAF79,  HANGUL SYLLABLE-AF79
        0xAF80, # G+1323  U+AF80  uniAF80,  HANGUL SYLLABLE-AF80
        0xAF84, # G+1324  U+AF84  uniAF84,  HANGUL SYLLABLE-AF84
        0xAF88, # G+1325  U+AF88  uniAF88,  HANGUL SYLLABLE-AF88
        0xAF90, # G+1326  U+AF90  uniAF90,  HANGUL SYLLABLE-AF90
        0xAF91, # G+1327  U+AF91  uniAF91,  HANGUL SYLLABLE-AF91
        0xAF95, # G+1328  U+AF95  uniAF95,  HANGUL SYLLABLE-AF95
        0xAF9C, # G+1329  U+AF9C  uniAF9C,  HANGUL SYLLABLE-AF9C
        0xAFB8, # G+1330  U+AFB8  uniAFB8,  HANGUL SYLLABLE-AFB8
        0xAFB9, # G+1331  U+AFB9  uniAFB9,  HANGUL SYLLABLE-AFB9
        0xAFBC, # G+1332  U+AFBC  uniAFBC,  HANGUL SYLLABLE-AFBC
        0xAFC0, # G+1333  U+AFC0  uniAFC0,  HANGUL SYLLABLE-AFC0
        0xAFC7, # G+1334  U+AFC7  uniAFC7,  HANGUL SYLLABLE-AFC7
        0xAFC8, # G+1335  U+AFC8  uniAFC8,  HANGUL SYLLABLE-AFC8
        0xAFC9, # G+1336  U+AFC9  uniAFC9,  HANGUL SYLLABLE-AFC9
        0xAFCB, # G+1337  U+AFCB  uniAFCB,  HANGUL SYLLABLE-AFCB
        0xAFCD, # G+1338  U+AFCD  uniAFCD,  HANGUL SYLLABLE-AFCD
        0xAFCE, # G+1339  U+AFCE  uniAFCE,  HANGUL SYLLABLE-AFCE
        0xAFD4, # G+1340  U+AFD4  uniAFD4,  HANGUL SYLLABLE-AFD4
        0xAFDC, # G+1341  U+AFDC  uniAFDC,  HANGUL SYLLABLE-AFDC
        0xAFE8, # G+1342  U+AFE8  uniAFE8,  HANGUL SYLLABLE-AFE8
        0xAFE9, # G+1343  U+AFE9  uniAFE9,  HANGUL SYLLABLE-AFE9
        0xAFF0, # G+1344  U+AFF0  uniAFF0,  HANGUL SYLLABLE-AFF0
        0xAFF1, # G+1345  U+AFF1  uniAFF1,  HANGUL SYLLABLE-AFF1
        0xAFF4, # G+1346  U+AFF4  uniAFF4,  HANGUL SYLLABLE-AFF4
        0xAFF8, # G+1347  U+AFF8  uniAFF8,  HANGUL SYLLABLE-AFF8
        0xB000, # G+1348  U+B000  uniB000,  HANGUL SYLLABLE-B000
        0xB001, # G+1349  U+B001  uniB001,  HANGUL SYLLABLE-B001
        0xB004, # G+1350  U+B004  uniB004,  HANGUL SYLLABLE-B004
        0xB00C, # G+1351  U+B00C  uniB00C,  HANGUL SYLLABLE-B00C
        0xB010, # G+1352  U+B010  uniB010,  HANGUL SYLLABLE-B010
        0xB014, # G+1353  U+B014  uniB014,  HANGUL SYLLABLE-B014
        0xB01C, # G+1354  U+B01C  uniB01C,  HANGUL SYLLABLE-B01C
        0xB01D, # G+1355  U+B01D  uniB01D,  HANGUL SYLLABLE-B01D
        0xB028, # G+1356  U+B028  uniB028,  HANGUL SYLLABLE-B028
        0xB044, # G+1357  U+B044  uniB044,  HANGUL SYLLABLE-B044
        0xB045, # G+1358  U+B045  uniB045,  HANGUL SYLLABLE-B045
        0xB048, # G+1359  U+B048  uniB048,  HANGUL SYLLABLE-B048
        0xB04A, # G+1360  U+B04A  uniB04A,  HANGUL SYLLABLE-B04A
        0xB04C, # G+1361  U+B04C  uniB04C,  HANGUL SYLLABLE-B04C
        0xB04E, # G+1362  U+B04E  uniB04E,  HANGUL SYLLABLE-B04E
        0xB053, # G+1363  U+B053  uniB053,  HANGUL SYLLABLE-B053
        0xB054, # G+1364  U+B054  uniB054,  HANGUL SYLLABLE-B054
        0xB055, # G+1365  U+B055  uniB055,  HANGUL SYLLABLE-B055
        0xB057, # G+1366  U+B057  uniB057,  HANGUL SYLLABLE-B057
        0xB059, # G+1367  U+B059  uniB059,  HANGUL SYLLABLE-B059
        0xB05D, # G+1368  U+B05D  uniB05D,  HANGUL SYLLABLE-B05D
        0xB07C, # G+1369  U+B07C  uniB07C,  HANGUL SYLLABLE-B07C
        0xB07D, # G+1370  U+B07D  uniB07D,  HANGUL SYLLABLE-B07D
        0xB080, # G+1371  U+B080  uniB080,  HANGUL SYLLABLE-B080
        0xB084, # G+1372  U+B084  uniB084,  HANGUL SYLLABLE-B084
        0xB08C, # G+1373  U+B08C  uniB08C,  HANGUL SYLLABLE-B08C
        0xB08D, # G+1374  U+B08D  uniB08D,  HANGUL SYLLABLE-B08D
        0xB08F, # G+1375  U+B08F  uniB08F,  HANGUL SYLLABLE-B08F
        0xB091, # G+1376  U+B091  uniB091,  HANGUL SYLLABLE-B091
        0xB098, # G+1377  U+B098  uniB098,  HANGUL SYLLABLE-B098
        0xB099, # G+1378  U+B099  uniB099,  HANGUL SYLLABLE-B099
        0xB09A, # G+1379  U+B09A  uniB09A,  HANGUL SYLLABLE-B09A
        0xB09C, # G+1380  U+B09C  uniB09C,  HANGUL SYLLABLE-B09C
        0xB09F, # G+1381  U+B09F  uniB09F,  HANGUL SYLLABLE-B09F
        0xB0A0, # G+1382  U+B0A0  uniB0A0,  HANGUL SYLLABLE-B0A0
        0xB0A1, # G+1383  U+B0A1  uniB0A1,  HANGUL SYLLABLE-B0A1
        0xB0A2, # G+1384  U+B0A2  uniB0A2,  HANGUL SYLLABLE-B0A2
        0xB0A8, # G+1385  U+B0A8  uniB0A8,  HANGUL SYLLABLE-B0A8
        0xB0A9, # G+1386  U+B0A9  uniB0A9,  HANGUL SYLLABLE-B0A9
        0xB0AB, # G+1387  U+B0AB  uniB0AB,  HANGUL SYLLABLE-B0AB
        0xB0AC, # G+1388  U+B0AC  uniB0AC,  HANGUL SYLLABLE-B0AC
        0xB0AD, # G+1389  U+B0AD  uniB0AD,  HANGUL SYLLABLE-B0AD
        0xB0AE, # G+1390  U+B0AE  uniB0AE,  HANGUL SYLLABLE-B0AE
        0xB0AF, # G+1391  U+B0AF  uniB0AF,  HANGUL SYLLABLE-B0AF
        0xB0B1, # G+1392  U+B0B1  uniB0B1,  HANGUL SYLLABLE-B0B1
        0xB0B3, # G+1393  U+B0B3  uniB0B3,  HANGUL SYLLABLE-B0B3
        0xB0B4, # G+1394  U+B0B4  uniB0B4,  HANGUL SYLLABLE-B0B4
        0xB0B5, # G+1395  U+B0B5  uniB0B5,  HANGUL SYLLABLE-B0B5
        0xB0B8, # G+1396  U+B0B8  uniB0B8,  HANGUL SYLLABLE-B0B8
        0xB0BC, # G+1397  U+B0BC  uniB0BC,  HANGUL SYLLABLE-B0BC
        0xB0C4, # G+1398  U+B0C4  uniB0C4,  HANGUL SYLLABLE-B0C4
        0xB0C5, # G+1399  U+B0C5  uniB0C5,  HANGUL SYLLABLE-B0C5
        0xB0C7, # G+1400  U+B0C7  uniB0C7,  HANGUL SYLLABLE-B0C7
        0xB0C8, # G+1401  U+B0C8  uniB0C8,  HANGUL SYLLABLE-B0C8
        0xB0C9, # G+1402  U+B0C9  uniB0C9,  HANGUL SYLLABLE-B0C9
        0xB0D0, # G+1403  U+B0D0  uniB0D0,  HANGUL SYLLABLE-B0D0
        0xB0D1, # G+1404  U+B0D1  uniB0D1,  HANGUL SYLLABLE-B0D1
        0xB0D4, # G+1405  U+B0D4  uniB0D4,  HANGUL SYLLABLE-B0D4
        0xB0D8, # G+1406  U+B0D8  uniB0D8,  HANGUL SYLLABLE-B0D8
        0xB0E0, # G+1407  U+B0E0  uniB0E0,  HANGUL SYLLABLE-B0E0
        0xB0E5, # G+1408  U+B0E5  uniB0E5,  HANGUL SYLLABLE-B0E5
        0xB108, # G+1409  U+B108  uniB108,  HANGUL SYLLABLE-B108
        0xB109, # G+1410  U+B109  uniB109,  HANGUL SYLLABLE-B109
        0xB10B, # G+1411  U+B10B  uniB10B,  HANGUL SYLLABLE-B10B
        0xB10C, # G+1412  U+B10C  uniB10C,  HANGUL SYLLABLE-B10C
        0xB110, # G+1413  U+B110  uniB110,  HANGUL SYLLABLE-B110
        0xB112, # G+1414  U+B112  uniB112,  HANGUL SYLLABLE-B112
        0xB113, # G+1415  U+B113  uniB113,  HANGUL SYLLABLE-B113
        0xB118, # G+1416  U+B118  uniB118,  HANGUL SYLLABLE-B118
        0xB119, # G+1417  U+B119  uniB119,  HANGUL SYLLABLE-B119
        0xB11B, # G+1418  U+B11B  uniB11B,  HANGUL SYLLABLE-B11B
        0xB11C, # G+1419  U+B11C  uniB11C,  HANGUL SYLLABLE-B11C
        0xB11D, # G+1420  U+B11D  uniB11D,  HANGUL SYLLABLE-B11D
        0xB123, # G+1421  U+B123  uniB123,  HANGUL SYLLABLE-B123
        0xB124, # G+1422  U+B124  uniB124,  HANGUL SYLLABLE-B124
        0xB125, # G+1423  U+B125  uniB125,  HANGUL SYLLABLE-B125
        0xB128, # G+1424  U+B128  uniB128,  HANGUL SYLLABLE-B128
        0xB12C, # G+1425  U+B12C  uniB12C,  HANGUL SYLLABLE-B12C
        0xB134, # G+1426  U+B134  uniB134,  HANGUL SYLLABLE-B134
        0xB135, # G+1427  U+B135  uniB135,  HANGUL SYLLABLE-B135
        0xB137, # G+1428  U+B137  uniB137,  HANGUL SYLLABLE-B137
        0xB138, # G+1429  U+B138  uniB138,  HANGUL SYLLABLE-B138
        0xB139, # G+1430  U+B139  uniB139,  HANGUL SYLLABLE-B139
        0xB140, # G+1431  U+B140  uniB140,  HANGUL SYLLABLE-B140
        0xB141, # G+1432  U+B141  uniB141,  HANGUL SYLLABLE-B141
        0xB144, # G+1433  U+B144  uniB144,  HANGUL SYLLABLE-B144
        0xB148, # G+1434  U+B148  uniB148,  HANGUL SYLLABLE-B148
        0xB150, # G+1435  U+B150  uniB150,  HANGUL SYLLABLE-B150
        0xB151, # G+1436  U+B151  uniB151,  HANGUL SYLLABLE-B151
        0xB154, # G+1437  U+B154  uniB154,  HANGUL SYLLABLE-B154
        0xB155, # G+1438  U+B155  uniB155,  HANGUL SYLLABLE-B155
        0xB158, # G+1439  U+B158  uniB158,  HANGUL SYLLABLE-B158
        0xB15C, # G+1440  U+B15C  uniB15C,  HANGUL SYLLABLE-B15C
        0xB160, # G+1441  U+B160  uniB160,  HANGUL SYLLABLE-B160
        0xB178, # G+1442  U+B178  uniB178,  HANGUL SYLLABLE-B178
        0xB179, # G+1443  U+B179  uniB179,  HANGUL SYLLABLE-B179
        0xB17C, # G+1444  U+B17C  uniB17C,  HANGUL SYLLABLE-B17C
        0xB180, # G+1445  U+B180  uniB180,  HANGUL SYLLABLE-B180
        0xB182, # G+1446  U+B182  uniB182,  HANGUL SYLLABLE-B182
        0xB188, # G+1447  U+B188  uniB188,  HANGUL SYLLABLE-B188
        0xB189, # G+1448  U+B189  uniB189,  HANGUL SYLLABLE-B189
        0xB18B, # G+1449  U+B18B  uniB18B,  HANGUL SYLLABLE-B18B
        0xB18D, # G+1450  U+B18D  uniB18D,  HANGUL SYLLABLE-B18D
        0xB192, # G+1451  U+B192  uniB192,  HANGUL SYLLABLE-B192
        0xB193, # G+1452  U+B193  uniB193,  HANGUL SYLLABLE-B193
        0xB194, # G+1453  U+B194  uniB194,  HANGUL SYLLABLE-B194
        0xB198, # G+1454  U+B198  uniB198,  HANGUL SYLLABLE-B198
        0xB19C, # G+1455  U+B19C  uniB19C,  HANGUL SYLLABLE-B19C
        0xB1A8, # G+1456  U+B1A8  uniB1A8,  HANGUL SYLLABLE-B1A8
        0xB1CC, # G+1457  U+B1CC  uniB1CC,  HANGUL SYLLABLE-B1CC
        0xB1D0, # G+1458  U+B1D0  uniB1D0,  HANGUL SYLLABLE-B1D0
        0xB1D4, # G+1459  U+B1D4  uniB1D4,  HANGUL SYLLABLE-B1D4
        0xB1DC, # G+1460  U+B1DC  uniB1DC,  HANGUL SYLLABLE-B1DC
        0xB1DD, # G+1461  U+B1DD  uniB1DD,  HANGUL SYLLABLE-B1DD
        0xB1DF, # G+1462  U+B1DF  uniB1DF,  HANGUL SYLLABLE-B1DF
        0xB1E8, # G+1463  U+B1E8  uniB1E8,  HANGUL SYLLABLE-B1E8
        0xB1E9, # G+1464  U+B1E9  uniB1E9,  HANGUL SYLLABLE-B1E9
        0xB1EC, # G+1465  U+B1EC  uniB1EC,  HANGUL SYLLABLE-B1EC
        0xB1F0, # G+1466  U+B1F0  uniB1F0,  HANGUL SYLLABLE-B1F0
        0xB1F9, # G+1467  U+B1F9  uniB1F9,  HANGUL SYLLABLE-B1F9
        0xB1FB, # G+1468  U+B1FB  uniB1FB,  HANGUL SYLLABLE-B1FB
        0xB1FD, # G+1469  U+B1FD  uniB1FD,  HANGUL SYLLABLE-B1FD
        0xB204, # G+1470  U+B204  uniB204,  HANGUL SYLLABLE-B204
        0xB205, # G+1471  U+B205  uniB205,  HANGUL SYLLABLE-B205
        0xB208, # G+1472  U+B208  uniB208,  HANGUL SYLLABLE-B208
        0xB20B, # G+1473  U+B20B  uniB20B,  HANGUL SYLLABLE-B20B
        0xB20C, # G+1474  U+B20C  uniB20C,  HANGUL SYLLABLE-B20C
        0xB214, # G+1475  U+B214  uniB214,  HANGUL SYLLABLE-B214
        0xB215, # G+1476  U+B215  uniB215,  HANGUL SYLLABLE-B215
        0xB217, # G+1477  U+B217  uniB217,  HANGUL SYLLABLE-B217
        0xB219, # G+1478  U+B219  uniB219,  HANGUL SYLLABLE-B219
        0xB220, # G+1479  U+B220  uniB220,  HANGUL SYLLABLE-B220
        0xB234, # G+1480  U+B234  uniB234,  HANGUL SYLLABLE-B234
        0xB23C, # G+1481  U+B23C  uniB23C,  HANGUL SYLLABLE-B23C
        0xB258, # G+1482  U+B258  uniB258,  HANGUL SYLLABLE-B258
        0xB25C, # G+1483  U+B25C  uniB25C,  HANGUL SYLLABLE-B25C
        0xB260, # G+1484  U+B260  uniB260,  HANGUL SYLLABLE-B260
        0xB268, # G+1485  U+B268  uniB268,  HANGUL SYLLABLE-B268
        0xB269, # G+1486  U+B269  uniB269,  HANGUL SYLLABLE-B269
        0xB274, # G+1487  U+B274  uniB274,  HANGUL SYLLABLE-B274
        0xB275, # G+1488  U+B275  uniB275,  HANGUL SYLLABLE-B275
        0xB27C, # G+1489  U+B27C  uniB27C,  HANGUL SYLLABLE-B27C
        0xB284, # G+1490  U+B284  uniB284,  HANGUL SYLLABLE-B284
        0xB285, # G+1491  U+B285  uniB285,  HANGUL SYLLABLE-B285
        0xB289, # G+1492  U+B289  uniB289,  HANGUL SYLLABLE-B289
        0xB290, # G+1493  U+B290  uniB290,  HANGUL SYLLABLE-B290
        0xB291, # G+1494  U+B291  uniB291,  HANGUL SYLLABLE-B291
        0xB294, # G+1495  U+B294  uniB294,  HANGUL SYLLABLE-B294
        0xB298, # G+1496  U+B298  uniB298,  HANGUL SYLLABLE-B298
        0xB299, # G+1497  U+B299  uniB299,  HANGUL SYLLABLE-B299
        0xB29A, # G+1498  U+B29A  uniB29A,  HANGUL SYLLABLE-B29A
        0xB2A0, # G+1499  U+B2A0  uniB2A0,  HANGUL SYLLABLE-B2A0
        0xB2A1, # G+1500  U+B2A1  uniB2A1,  HANGUL SYLLABLE-B2A1
        0xB2A3, # G+1501  U+B2A3  uniB2A3,  HANGUL SYLLABLE-B2A3
        0xB2A5, # G+1502  U+B2A5  uniB2A5,  HANGUL SYLLABLE-B2A5
        0xB2A6, # G+1503  U+B2A6  uniB2A6,  HANGUL SYLLABLE-B2A6
        0xB2AA, # G+1504  U+B2AA  uniB2AA,  HANGUL SYLLABLE-B2AA
        0xB2AC, # G+1505  U+B2AC  uniB2AC,  HANGUL SYLLABLE-B2AC
        0xB2B0, # G+1506  U+B2B0  uniB2B0,  HANGUL SYLLABLE-B2B0
        0xB2B4, # G+1507  U+B2B4  uniB2B4,  HANGUL SYLLABLE-B2B4
        0xB2C8, # G+1508  U+B2C8  uniB2C8,  HANGUL SYLLABLE-B2C8
        0xB2C9, # G+1509  U+B2C9  uniB2C9,  HANGUL SYLLABLE-B2C9
        0xB2CC, # G+1510  U+B2CC  uniB2CC,  HANGUL SYLLABLE-B2CC
        0xB2D0, # G+1511  U+B2D0  uniB2D0,  HANGUL SYLLABLE-B2D0
        0xB2D2, # G+1512  U+B2D2  uniB2D2,  HANGUL SYLLABLE-B2D2
        0xB2D8, # G+1513  U+B2D8  uniB2D8,  HANGUL SYLLABLE-B2D8
        0xB2D9, # G+1514  U+B2D9  uniB2D9,  HANGUL SYLLABLE-B2D9
        0xB2DB, # G+1515  U+B2DB  uniB2DB,  HANGUL SYLLABLE-B2DB
        0xB2DD, # G+1516  U+B2DD  uniB2DD,  HANGUL SYLLABLE-B2DD
        0xB2E2, # G+1517  U+B2E2  uniB2E2,  HANGUL SYLLABLE-B2E2
        0xB2E4, # G+1518  U+B2E4  uniB2E4,  HANGUL SYLLABLE-B2E4
        0xB2E5, # G+1519  U+B2E5  uniB2E5,  HANGUL SYLLABLE-B2E5
        0xB2E6, # G+1520  U+B2E6  uniB2E6,  HANGUL SYLLABLE-B2E6
        0xB2E8, # G+1521  U+B2E8  uniB2E8,  HANGUL SYLLABLE-B2E8
        0xB2EB, # G+1522  U+B2EB  uniB2EB,  HANGUL SYLLABLE-B2EB
        0xB2EC, # G+1523  U+B2EC  uniB2EC,  HANGUL SYLLABLE-B2EC
        0xB2ED, # G+1524  U+B2ED  uniB2ED,  HANGUL SYLLABLE-B2ED
        0xB2EE, # G+1525  U+B2EE  uniB2EE,  HANGUL SYLLABLE-B2EE
        0xB2EF, # G+1526  U+B2EF  uniB2EF,  HANGUL SYLLABLE-B2EF
        0xB2F3, # G+1527  U+B2F3  uniB2F3,  HANGUL SYLLABLE-B2F3
        0xB2F4, # G+1528  U+B2F4  uniB2F4,  HANGUL SYLLABLE-B2F4
        0xB2F5, # G+1529  U+B2F5  uniB2F5,  HANGUL SYLLABLE-B2F5
        0xB2F7, # G+1530  U+B2F7  uniB2F7,  HANGUL SYLLABLE-B2F7
        0xB2F8, # G+1531  U+B2F8  uniB2F8,  HANGUL SYLLABLE-B2F8
        0xB2F9, # G+1532  U+B2F9  uniB2F9,  HANGUL SYLLABLE-B2F9
        0xB2FA, # G+1533  U+B2FA  uniB2FA,  HANGUL SYLLABLE-B2FA
        0xB2FB, # G+1534  U+B2FB  uniB2FB,  HANGUL SYLLABLE-B2FB
        0xB2FF, # G+1535  U+B2FF  uniB2FF,  HANGUL SYLLABLE-B2FF
        0xB300, # G+1536  U+B300  uniB300,  HANGUL SYLLABLE-B300
        0xB301, # G+1537  U+B301  uniB301,  HANGUL SYLLABLE-B301
        0xB304, # G+1538  U+B304  uniB304,  HANGUL SYLLABLE-B304
        0xB308, # G+1539  U+B308  uniB308,  HANGUL SYLLABLE-B308
        0xB310, # G+1540  U+B310  uniB310,  HANGUL SYLLABLE-B310
        0xB311, # G+1541  U+B311  uniB311,  HANGUL SYLLABLE-B311
        0xB313, # G+1542  U+B313  uniB313,  HANGUL SYLLABLE-B313
        0xB314, # G+1543  U+B314  uniB314,  HANGUL SYLLABLE-B314
        0xB315, # G+1544  U+B315  uniB315,  HANGUL SYLLABLE-B315
        0xB31C, # G+1545  U+B31C  uniB31C,  HANGUL SYLLABLE-B31C
        0xB354, # G+1546  U+B354  uniB354,  HANGUL SYLLABLE-B354
        0xB355, # G+1547  U+B355  uniB355,  HANGUL SYLLABLE-B355
        0xB356, # G+1548  U+B356  uniB356,  HANGUL SYLLABLE-B356
        0xB358, # G+1549  U+B358  uniB358,  HANGUL SYLLABLE-B358
        0xB35B, # G+1550  U+B35B  uniB35B,  HANGUL SYLLABLE-B35B
        0xB35C, # G+1551  U+B35C  uniB35C,  HANGUL SYLLABLE-B35C
        0xB35E, # G+1552  U+B35E  uniB35E,  HANGUL SYLLABLE-B35E
        0xB35F, # G+1553  U+B35F  uniB35F,  HANGUL SYLLABLE-B35F
        0xB364, # G+1554  U+B364  uniB364,  HANGUL SYLLABLE-B364
        0xB365, # G+1555  U+B365  uniB365,  HANGUL SYLLABLE-B365
        0xB367, # G+1556  U+B367  uniB367,  HANGUL SYLLABLE-B367
        0xB369, # G+1557  U+B369  uniB369,  HANGUL SYLLABLE-B369
        0xB36B, # G+1558  U+B36B  uniB36B,  HANGUL SYLLABLE-B36B
        0xB36E, # G+1559  U+B36E  uniB36E,  HANGUL SYLLABLE-B36E
        0xB370, # G+1560  U+B370  uniB370,  HANGUL SYLLABLE-B370
        0xB371, # G+1561  U+B371  uniB371,  HANGUL SYLLABLE-B371
        0xB374, # G+1562  U+B374  uniB374,  HANGUL SYLLABLE-B374
        0xB378, # G+1563  U+B378  uniB378,  HANGUL SYLLABLE-B378
        0xB380, # G+1564  U+B380  uniB380,  HANGUL SYLLABLE-B380
        0xB381, # G+1565  U+B381  uniB381,  HANGUL SYLLABLE-B381
        0xB383, # G+1566  U+B383  uniB383,  HANGUL SYLLABLE-B383
        0xB384, # G+1567  U+B384  uniB384,  HANGUL SYLLABLE-B384
        0xB385, # G+1568  U+B385  uniB385,  HANGUL SYLLABLE-B385
        0xB38C, # G+1569  U+B38C  uniB38C,  HANGUL SYLLABLE-B38C
        0xB390, # G+1570  U+B390  uniB390,  HANGUL SYLLABLE-B390
        0xB394, # G+1571  U+B394  uniB394,  HANGUL SYLLABLE-B394
        0xB3A0, # G+1572  U+B3A0  uniB3A0,  HANGUL SYLLABLE-B3A0
        0xB3A1, # G+1573  U+B3A1  uniB3A1,  HANGUL SYLLABLE-B3A1
        0xB3A8, # G+1574  U+B3A8  uniB3A8,  HANGUL SYLLABLE-B3A8
        0xB3AC, # G+1575  U+B3AC  uniB3AC,  HANGUL SYLLABLE-B3AC
        0xB3C4, # G+1576  U+B3C4  uniB3C4,  HANGUL SYLLABLE-B3C4
        0xB3C5, # G+1577  U+B3C5  uniB3C5,  HANGUL SYLLABLE-B3C5
        0xB3C8, # G+1578  U+B3C8  uniB3C8,  HANGUL SYLLABLE-B3C8
        0xB3CB, # G+1579  U+B3CB  uniB3CB,  HANGUL SYLLABLE-B3CB
        0xB3CC, # G+1580  U+B3CC  uniB3CC,  HANGUL SYLLABLE-B3CC
        0xB3CE, # G+1581  U+B3CE  uniB3CE,  HANGUL SYLLABLE-B3CE
        0xB3D0, # G+1582  U+B3D0  uniB3D0,  HANGUL SYLLABLE-B3D0
        0xB3D4, # G+1583  U+B3D4  uniB3D4,  HANGUL SYLLABLE-B3D4
        0xB3D5, # G+1584  U+B3D5  uniB3D5,  HANGUL SYLLABLE-B3D5
        0xB3D7, # G+1585  U+B3D7  uniB3D7,  HANGUL SYLLABLE-B3D7
        0xB3D9, # G+1586  U+B3D9  uniB3D9,  HANGUL SYLLABLE-B3D9
        0xB3DB, # G+1587  U+B3DB  uniB3DB,  HANGUL SYLLABLE-B3DB
        0xB3DD, # G+1588  U+B3DD  uniB3DD,  HANGUL SYLLABLE-B3DD
        0xB3E0, # G+1589  U+B3E0  uniB3E0,  HANGUL SYLLABLE-B3E0
        0xB3E4, # G+1590  U+B3E4  uniB3E4,  HANGUL SYLLABLE-B3E4
        0xB3E8, # G+1591  U+B3E8  uniB3E8,  HANGUL SYLLABLE-B3E8
        0xB3FC, # G+1592  U+B3FC  uniB3FC,  HANGUL SYLLABLE-B3FC
        0xB410, # G+1593  U+B410  uniB410,  HANGUL SYLLABLE-B410
        0xB418, # G+1594  U+B418  uniB418,  HANGUL SYLLABLE-B418
        0xB41C, # G+1595  U+B41C  uniB41C,  HANGUL SYLLABLE-B41C
        0xB420, # G+1596  U+B420  uniB420,  HANGUL SYLLABLE-B420
        0xB428, # G+1597  U+B428  uniB428,  HANGUL SYLLABLE-B428
        0xB429, # G+1598  U+B429  uniB429,  HANGUL SYLLABLE-B429
        0xB42B, # G+1599  U+B42B  uniB42B,  HANGUL SYLLABLE-B42B
        0xB434, # G+1600  U+B434  uniB434,  HANGUL SYLLABLE-B434
        0xB450, # G+1601  U+B450  uniB450,  HANGUL SYLLABLE-B450
        0xB451, # G+1602  U+B451  uniB451,  HANGUL SYLLABLE-B451
        0xB454, # G+1603  U+B454  uniB454,  HANGUL SYLLABLE-B454
        0xB458, # G+1604  U+B458  uniB458,  HANGUL SYLLABLE-B458
        0xB460, # G+1605  U+B460  uniB460,  HANGUL SYLLABLE-B460
        0xB461, # G+1606  U+B461  uniB461,  HANGUL SYLLABLE-B461
        0xB463, # G+1607  U+B463  uniB463,  HANGUL SYLLABLE-B463
        0xB465, # G+1608  U+B465  uniB465,  HANGUL SYLLABLE-B465
        0xB46C, # G+1609  U+B46C  uniB46C,  HANGUL SYLLABLE-B46C
        0xB480, # G+1610  U+B480  uniB480,  HANGUL SYLLABLE-B480
        0xB488, # G+1611  U+B488  uniB488,  HANGUL SYLLABLE-B488
        0xB49D, # G+1612  U+B49D  uniB49D,  HANGUL SYLLABLE-B49D
        0xB4A4, # G+1613  U+B4A4  uniB4A4,  HANGUL SYLLABLE-B4A4
        0xB4A8, # G+1614  U+B4A8  uniB4A8,  HANGUL SYLLABLE-B4A8
        0xB4AC, # G+1615  U+B4AC  uniB4AC,  HANGUL SYLLABLE-B4AC
        0xB4B5, # G+1616  U+B4B5  uniB4B5,  HANGUL SYLLABLE-B4B5
        0xB4B7, # G+1617  U+B4B7  uniB4B7,  HANGUL SYLLABLE-B4B7
        0xB4B9, # G+1618  U+B4B9  uniB4B9,  HANGUL SYLLABLE-B4B9
        0xB4C0, # G+1619  U+B4C0  uniB4C0,  HANGUL SYLLABLE-B4C0
        0xB4C4, # G+1620  U+B4C4  uniB4C4,  HANGUL SYLLABLE-B4C4
        0xB4C8, # G+1621  U+B4C8  uniB4C8,  HANGUL SYLLABLE-B4C8
        0xB4D0, # G+1622  U+B4D0  uniB4D0,  HANGUL SYLLABLE-B4D0
        0xB4D5, # G+1623  U+B4D5  uniB4D5,  HANGUL SYLLABLE-B4D5
        0xB4DC, # G+1624  U+B4DC  uniB4DC,  HANGUL SYLLABLE-B4DC
        0xB4DD, # G+1625  U+B4DD  uniB4DD,  HANGUL SYLLABLE-B4DD
        0xB4E0, # G+1626  U+B4E0  uniB4E0,  HANGUL SYLLABLE-B4E0
        0xB4E3, # G+1627  U+B4E3  uniB4E3,  HANGUL SYLLABLE-B4E3
        0xB4E4, # G+1628  U+B4E4  uniB4E4,  HANGUL SYLLABLE-B4E4
        0xB4E6, # G+1629  U+B4E6  uniB4E6,  HANGUL SYLLABLE-B4E6
        0xB4EC, # G+1630  U+B4EC  uniB4EC,  HANGUL SYLLABLE-B4EC
        0xB4ED, # G+1631  U+B4ED  uniB4ED,  HANGUL SYLLABLE-B4ED
        0xB4EF, # G+1632  U+B4EF  uniB4EF,  HANGUL SYLLABLE-B4EF
        0xB4F1, # G+1633  U+B4F1  uniB4F1,  HANGUL SYLLABLE-B4F1
        0xB4F8, # G+1634  U+B4F8  uniB4F8,  HANGUL SYLLABLE-B4F8
        0xB514, # G+1635  U+B514  uniB514,  HANGUL SYLLABLE-B514
        0xB515, # G+1636  U+B515  uniB515,  HANGUL SYLLABLE-B515
        0xB518, # G+1637  U+B518  uniB518,  HANGUL SYLLABLE-B518
        0xB51B, # G+1638  U+B51B  uniB51B,  HANGUL SYLLABLE-B51B
        0xB51C, # G+1639  U+B51C  uniB51C,  HANGUL SYLLABLE-B51C
        0xB524, # G+1640  U+B524  uniB524,  HANGUL SYLLABLE-B524
        0xB525, # G+1641  U+B525  uniB525,  HANGUL SYLLABLE-B525
        0xB527, # G+1642  U+B527  uniB527,  HANGUL SYLLABLE-B527
        0xB528, # G+1643  U+B528  uniB528,  HANGUL SYLLABLE-B528
        0xB529, # G+1644  U+B529  uniB529,  HANGUL SYLLABLE-B529
        0xB52A, # G+1645  U+B52A  uniB52A,  HANGUL SYLLABLE-B52A
        0xB530, # G+1646  U+B530  uniB530,  HANGUL SYLLABLE-B530
        0xB531, # G+1647  U+B531  uniB531,  HANGUL SYLLABLE-B531
        0xB534, # G+1648  U+B534  uniB534,  HANGUL SYLLABLE-B534
        0xB538, # G+1649  U+B538  uniB538,  HANGUL SYLLABLE-B538
        0xB540, # G+1650  U+B540  uniB540,  HANGUL SYLLABLE-B540
        0xB541, # G+1651  U+B541  uniB541,  HANGUL SYLLABLE-B541
        0xB543, # G+1652  U+B543  uniB543,  HANGUL SYLLABLE-B543
        0xB544, # G+1653  U+B544  uniB544,  HANGUL SYLLABLE-B544
        0xB545, # G+1654  U+B545  uniB545,  HANGUL SYLLABLE-B545
        0xB54B, # G+1655  U+B54B  uniB54B,  HANGUL SYLLABLE-B54B
        0xB54C, # G+1656  U+B54C  uniB54C,  HANGUL SYLLABLE-B54C
        0xB54D, # G+1657  U+B54D  uniB54D,  HANGUL SYLLABLE-B54D
        0xB550, # G+1658  U+B550  uniB550,  HANGUL SYLLABLE-B550
        0xB554, # G+1659  U+B554  uniB554,  HANGUL SYLLABLE-B554
        0xB55C, # G+1660  U+B55C  uniB55C,  HANGUL SYLLABLE-B55C
        0xB55D, # G+1661  U+B55D  uniB55D,  HANGUL SYLLABLE-B55D
        0xB55F, # G+1662  U+B55F  uniB55F,  HANGUL SYLLABLE-B55F
        0xB560, # G+1663  U+B560  uniB560,  HANGUL SYLLABLE-B560
        0xB561, # G+1664  U+B561  uniB561,  HANGUL SYLLABLE-B561
        0xB5A0, # G+1665  U+B5A0  uniB5A0,  HANGUL SYLLABLE-B5A0
        0xB5A1, # G+1666  U+B5A1  uniB5A1,  HANGUL SYLLABLE-B5A1
        0xB5A4, # G+1667  U+B5A4  uniB5A4,  HANGUL SYLLABLE-B5A4
        0xB5A8, # G+1668  U+B5A8  uniB5A8,  HANGUL SYLLABLE-B5A8
        0xB5AA, # G+1669  U+B5AA  uniB5AA,  HANGUL SYLLABLE-B5AA
        0xB5AB, # G+1670  U+B5AB  uniB5AB,  HANGUL SYLLABLE-B5AB
        0xB5B0, # G+1671  U+B5B0  uniB5B0,  HANGUL SYLLABLE-B5B0
        0xB5B1, # G+1672  U+B5B1  uniB5B1,  HANGUL SYLLABLE-B5B1
        0xB5B3, # G+1673  U+B5B3  uniB5B3,  HANGUL SYLLABLE-B5B3
        0xB5B4, # G+1674  U+B5B4  uniB5B4,  HANGUL SYLLABLE-B5B4
        0xB5B5, # G+1675  U+B5B5  uniB5B5,  HANGUL SYLLABLE-B5B5
        0xB5BB, # G+1676  U+B5BB  uniB5BB,  HANGUL SYLLABLE-B5BB
        0xB5BC, # G+1677  U+B5BC  uniB5BC,  HANGUL SYLLABLE-B5BC
        0xB5BD, # G+1678  U+B5BD  uniB5BD,  HANGUL SYLLABLE-B5BD
        0xB5C0, # G+1679  U+B5C0  uniB5C0,  HANGUL SYLLABLE-B5C0
        0xB5C4, # G+1680  U+B5C4  uniB5C4,  HANGUL SYLLABLE-B5C4
        0xB5CC, # G+1681  U+B5CC  uniB5CC,  HANGUL SYLLABLE-B5CC
        0xB5CD, # G+1682  U+B5CD  uniB5CD,  HANGUL SYLLABLE-B5CD
        0xB5CF, # G+1683  U+B5CF  uniB5CF,  HANGUL SYLLABLE-B5CF
        0xB5D0, # G+1684  U+B5D0  uniB5D0,  HANGUL SYLLABLE-B5D0
        0xB5D1, # G+1685  U+B5D1  uniB5D1,  HANGUL SYLLABLE-B5D1
        0xB5D8, # G+1686  U+B5D8  uniB5D8,  HANGUL SYLLABLE-B5D8
        0xB5EC, # G+1687  U+B5EC  uniB5EC,  HANGUL SYLLABLE-B5EC
        0xB610, # G+1688  U+B610  uniB610,  HANGUL SYLLABLE-B610
        0xB611, # G+1689  U+B611  uniB611,  HANGUL SYLLABLE-B611
        0xB614, # G+1690  U+B614  uniB614,  HANGUL SYLLABLE-B614
        0xB618, # G+1691  U+B618  uniB618,  HANGUL SYLLABLE-B618
        0xB625, # G+1692  U+B625  uniB625,  HANGUL SYLLABLE-B625
        0xB62C, # G+1693  U+B62C  uniB62C,  HANGUL SYLLABLE-B62C
        0xB634, # G+1694  U+B634  uniB634,  HANGUL SYLLABLE-B634
        0xB648, # G+1695  U+B648  uniB648,  HANGUL SYLLABLE-B648
        0xB664, # G+1696  U+B664  uniB664,  HANGUL SYLLABLE-B664
        0xB668, # G+1697  U+B668  uniB668,  HANGUL SYLLABLE-B668
        0xB69C, # G+1698  U+B69C  uniB69C,  HANGUL SYLLABLE-B69C
        0xB69D, # G+1699  U+B69D  uniB69D,  HANGUL SYLLABLE-B69D
        0xB6A0, # G+1700  U+B6A0  uniB6A0,  HANGUL SYLLABLE-B6A0
        0xB6A4, # G+1701  U+B6A4  uniB6A4,  HANGUL SYLLABLE-B6A4
        0xB6AB, # G+1702  U+B6AB  uniB6AB,  HANGUL SYLLABLE-B6AB
        0xB6AC, # G+1703  U+B6AC  uniB6AC,  HANGUL SYLLABLE-B6AC
        0xB6B1, # G+1704  U+B6B1  uniB6B1,  HANGUL SYLLABLE-B6B1
        0xB6D4, # G+1705  U+B6D4  uniB6D4,  HANGUL SYLLABLE-B6D4
        0xB6F0, # G+1706  U+B6F0  uniB6F0,  HANGUL SYLLABLE-B6F0
        0xB6F4, # G+1707  U+B6F4  uniB6F4,  HANGUL SYLLABLE-B6F4
        0xB6F8, # G+1708  U+B6F8  uniB6F8,  HANGUL SYLLABLE-B6F8
        0xB700, # G+1709  U+B700  uniB700,  HANGUL SYLLABLE-B700
        0xB701, # G+1710  U+B701  uniB701,  HANGUL SYLLABLE-B701
        0xB705, # G+1711  U+B705  uniB705,  HANGUL SYLLABLE-B705
        0xB728, # G+1712  U+B728  uniB728,  HANGUL SYLLABLE-B728
        0xB729, # G+1713  U+B729  uniB729,  HANGUL SYLLABLE-B729
        0xB72C, # G+1714  U+B72C  uniB72C,  HANGUL SYLLABLE-B72C
        0xB72F, # G+1715  U+B72F  uniB72F,  HANGUL SYLLABLE-B72F
        0xB730, # G+1716  U+B730  uniB730,  HANGUL SYLLABLE-B730
        0xB738, # G+1717  U+B738  uniB738,  HANGUL SYLLABLE-B738
        0xB739, # G+1718  U+B739  uniB739,  HANGUL SYLLABLE-B739
        0xB73B, # G+1719  U+B73B  uniB73B,  HANGUL SYLLABLE-B73B
        0xB744, # G+1720  U+B744  uniB744,  HANGUL SYLLABLE-B744
        0xB748, # G+1721  U+B748  uniB748,  HANGUL SYLLABLE-B748
        0xB74C, # G+1722  U+B74C  uniB74C,  HANGUL SYLLABLE-B74C
        0xB754, # G+1723  U+B754  uniB754,  HANGUL SYLLABLE-B754
        0xB755, # G+1724  U+B755  uniB755,  HANGUL SYLLABLE-B755
        0xB760, # G+1725  U+B760  uniB760,  HANGUL SYLLABLE-B760
        0xB764, # G+1726  U+B764  uniB764,  HANGUL SYLLABLE-B764
        0xB768, # G+1727  U+B768  uniB768,  HANGUL SYLLABLE-B768
        0xB770, # G+1728  U+B770  uniB770,  HANGUL SYLLABLE-B770
        0xB771, # G+1729  U+B771  uniB771,  HANGUL SYLLABLE-B771
        0xB773, # G+1730  U+B773  uniB773,  HANGUL SYLLABLE-B773
        0xB775, # G+1731  U+B775  uniB775,  HANGUL SYLLABLE-B775
        0xB77C, # G+1732  U+B77C  uniB77C,  HANGUL SYLLABLE-B77C
        0xB77D, # G+1733  U+B77D  uniB77D,  HANGUL SYLLABLE-B77D
        0xB780, # G+1734  U+B780  uniB780,  HANGUL SYLLABLE-B780
        0xB784, # G+1735  U+B784  uniB784,  HANGUL SYLLABLE-B784
        0xB78C, # G+1736  U+B78C  uniB78C,  HANGUL SYLLABLE-B78C
        0xB78D, # G+1737  U+B78D  uniB78D,  HANGUL SYLLABLE-B78D
        0xB78F, # G+1738  U+B78F  uniB78F,  HANGUL SYLLABLE-B78F
        0xB790, # G+1739  U+B790  uniB790,  HANGUL SYLLABLE-B790
        0xB791, # G+1740  U+B791  uniB791,  HANGUL SYLLABLE-B791
        0xB792, # G+1741  U+B792  uniB792,  HANGUL SYLLABLE-B792
        0xB796, # G+1742  U+B796  uniB796,  HANGUL SYLLABLE-B796
        0xB797, # G+1743  U+B797  uniB797,  HANGUL SYLLABLE-B797
        0xB798, # G+1744  U+B798  uniB798,  HANGUL SYLLABLE-B798
        0xB799, # G+1745  U+B799  uniB799,  HANGUL SYLLABLE-B799
        0xB79C, # G+1746  U+B79C  uniB79C,  HANGUL SYLLABLE-B79C
        0xB7A0, # G+1747  U+B7A0  uniB7A0,  HANGUL SYLLABLE-B7A0
        0xB7A8, # G+1748  U+B7A8  uniB7A8,  HANGUL SYLLABLE-B7A8
        0xB7A9, # G+1749  U+B7A9  uniB7A9,  HANGUL SYLLABLE-B7A9
        0xB7AB, # G+1750  U+B7AB  uniB7AB,  HANGUL SYLLABLE-B7AB
        0xB7AC, # G+1751  U+B7AC  uniB7AC,  HANGUL SYLLABLE-B7AC
        0xB7AD, # G+1752  U+B7AD  uniB7AD,  HANGUL SYLLABLE-B7AD
        0xB7B4, # G+1753  U+B7B4  uniB7B4,  HANGUL SYLLABLE-B7B4
        0xB7B5, # G+1754  U+B7B5  uniB7B5,  HANGUL SYLLABLE-B7B5
        0xB7B8, # G+1755  U+B7B8  uniB7B8,  HANGUL SYLLABLE-B7B8
        0xB7C7, # G+1756  U+B7C7  uniB7C7,  HANGUL SYLLABLE-B7C7
        0xB7C9, # G+1757  U+B7C9  uniB7C9,  HANGUL SYLLABLE-B7C9
        0xB7EC, # G+1758  U+B7EC  uniB7EC,  HANGUL SYLLABLE-B7EC
        0xB7ED, # G+1759  U+B7ED  uniB7ED,  HANGUL SYLLABLE-B7ED
        0xB7F0, # G+1760  U+B7F0  uniB7F0,  HANGUL SYLLABLE-B7F0
        0xB7F4, # G+1761  U+B7F4  uniB7F4,  HANGUL SYLLABLE-B7F4
        0xB7FC, # G+1762  U+B7FC  uniB7FC,  HANGUL SYLLABLE-B7FC
        0xB7FD, # G+1763  U+B7FD  uniB7FD,  HANGUL SYLLABLE-B7FD
        0xB7FF, # G+1764  U+B7FF  uniB7FF,  HANGUL SYLLABLE-B7FF
        0xB800, # G+1765  U+B800  uniB800,  HANGUL SYLLABLE-B800
        0xB801, # G+1766  U+B801  uniB801,  HANGUL SYLLABLE-B801
        0xB807, # G+1767  U+B807  uniB807,  HANGUL SYLLABLE-B807
        0xB808, # G+1768  U+B808  uniB808,  HANGUL SYLLABLE-B808
        0xB809, # G+1769  U+B809  uniB809,  HANGUL SYLLABLE-B809
        0xB80C, # G+1770  U+B80C  uniB80C,  HANGUL SYLLABLE-B80C
        0xB810, # G+1771  U+B810  uniB810,  HANGUL SYLLABLE-B810
        0xB818, # G+1772  U+B818  uniB818,  HANGUL SYLLABLE-B818
        0xB819, # G+1773  U+B819  uniB819,  HANGUL SYLLABLE-B819
        0xB81B, # G+1774  U+B81B  uniB81B,  HANGUL SYLLABLE-B81B
        0xB81D, # G+1775  U+B81D  uniB81D,  HANGUL SYLLABLE-B81D
        0xB824, # G+1776  U+B824  uniB824,  HANGUL SYLLABLE-B824
        0xB825, # G+1777  U+B825  uniB825,  HANGUL SYLLABLE-B825
        0xB828, # G+1778  U+B828  uniB828,  HANGUL SYLLABLE-B828
        0xB82C, # G+1779  U+B82C  uniB82C,  HANGUL SYLLABLE-B82C
        0xB834, # G+1780  U+B834  uniB834,  HANGUL SYLLABLE-B834
        0xB835, # G+1781  U+B835  uniB835,  HANGUL SYLLABLE-B835
        0xB837, # G+1782  U+B837  uniB837,  HANGUL SYLLABLE-B837
        0xB838, # G+1783  U+B838  uniB838,  HANGUL SYLLABLE-B838
        0xB839, # G+1784  U+B839  uniB839,  HANGUL SYLLABLE-B839
        0xB840, # G+1785  U+B840  uniB840,  HANGUL SYLLABLE-B840
        0xB844, # G+1786  U+B844  uniB844,  HANGUL SYLLABLE-B844
        0xB851, # G+1787  U+B851  uniB851,  HANGUL SYLLABLE-B851
        0xB853, # G+1788  U+B853  uniB853,  HANGUL SYLLABLE-B853
        0xB85C, # G+1789  U+B85C  uniB85C,  HANGUL SYLLABLE-B85C
        0xB85D, # G+1790  U+B85D  uniB85D,  HANGUL SYLLABLE-B85D
        0xB860, # G+1791  U+B860  uniB860,  HANGUL SYLLABLE-B860
        0xB864, # G+1792  U+B864  uniB864,  HANGUL SYLLABLE-B864
        0xB86C, # G+1793  U+B86C  uniB86C,  HANGUL SYLLABLE-B86C
        0xB86D, # G+1794  U+B86D  uniB86D,  HANGUL SYLLABLE-B86D
        0xB86F, # G+1795  U+B86F  uniB86F,  HANGUL SYLLABLE-B86F
        0xB871, # G+1796  U+B871  uniB871,  HANGUL SYLLABLE-B871
        0xB878, # G+1797  U+B878  uniB878,  HANGUL SYLLABLE-B878
        0xB87C, # G+1798  U+B87C  uniB87C,  HANGUL SYLLABLE-B87C
        0xB88D, # G+1799  U+B88D  uniB88D,  HANGUL SYLLABLE-B88D
        0xB8A8, # G+1800  U+B8A8  uniB8A8,  HANGUL SYLLABLE-B8A8
        0xB8B0, # G+1801  U+B8B0  uniB8B0,  HANGUL SYLLABLE-B8B0
        0xB8B4, # G+1802  U+B8B4  uniB8B4,  HANGUL SYLLABLE-B8B4
        0xB8B8, # G+1803  U+B8B8  uniB8B8,  HANGUL SYLLABLE-B8B8
        0xB8C0, # G+1804  U+B8C0  uniB8C0,  HANGUL SYLLABLE-B8C0
        0xB8C1, # G+1805  U+B8C1  uniB8C1,  HANGUL SYLLABLE-B8C1
        0xB8C3, # G+1806  U+B8C3  uniB8C3,  HANGUL SYLLABLE-B8C3
        0xB8C5, # G+1807  U+B8C5  uniB8C5,  HANGUL SYLLABLE-B8C5
        0xB8CC, # G+1808  U+B8CC  uniB8CC,  HANGUL SYLLABLE-B8CC
        0xB8D0, # G+1809  U+B8D0  uniB8D0,  HANGUL SYLLABLE-B8D0
        0xB8D4, # G+1810  U+B8D4  uniB8D4,  HANGUL SYLLABLE-B8D4
        0xB8DD, # G+1811  U+B8DD  uniB8DD,  HANGUL SYLLABLE-B8DD
        0xB8DF, # G+1812  U+B8DF  uniB8DF,  HANGUL SYLLABLE-B8DF
        0xB8E1, # G+1813  U+B8E1  uniB8E1,  HANGUL SYLLABLE-B8E1
        0xB8E8, # G+1814  U+B8E8  uniB8E8,  HANGUL SYLLABLE-B8E8
        0xB8E9, # G+1815  U+B8E9  uniB8E9,  HANGUL SYLLABLE-B8E9
        0xB8EC, # G+1816  U+B8EC  uniB8EC,  HANGUL SYLLABLE-B8EC
        0xB8F0, # G+1817  U+B8F0  uniB8F0,  HANGUL SYLLABLE-B8F0
        0xB8F8, # G+1818  U+B8F8  uniB8F8,  HANGUL SYLLABLE-B8F8
        0xB8F9, # G+1819  U+B8F9  uniB8F9,  HANGUL SYLLABLE-B8F9
        0xB8FB, # G+1820  U+B8FB  uniB8FB,  HANGUL SYLLABLE-B8FB
        0xB8FD, # G+1821  U+B8FD  uniB8FD,  HANGUL SYLLABLE-B8FD
        0xB904, # G+1822  U+B904  uniB904,  HANGUL SYLLABLE-B904
        0xB918, # G+1823  U+B918  uniB918,  HANGUL SYLLABLE-B918
        0xB920, # G+1824  U+B920  uniB920,  HANGUL SYLLABLE-B920
        0xB93C, # G+1825  U+B93C  uniB93C,  HANGUL SYLLABLE-B93C
        0xB93D, # G+1826  U+B93D  uniB93D,  HANGUL SYLLABLE-B93D
        0xB940, # G+1827  U+B940  uniB940,  HANGUL SYLLABLE-B940
        0xB944, # G+1828  U+B944  uniB944,  HANGUL SYLLABLE-B944
        0xB94C, # G+1829  U+B94C  uniB94C,  HANGUL SYLLABLE-B94C
        0xB94F, # G+1830  U+B94F  uniB94F,  HANGUL SYLLABLE-B94F
        0xB951, # G+1831  U+B951  uniB951,  HANGUL SYLLABLE-B951
        0xB958, # G+1832  U+B958  uniB958,  HANGUL SYLLABLE-B958
        0xB959, # G+1833  U+B959  uniB959,  HANGUL SYLLABLE-B959
        0xB95C, # G+1834  U+B95C  uniB95C,  HANGUL SYLLABLE-B95C
        0xB960, # G+1835  U+B960  uniB960,  HANGUL SYLLABLE-B960
        0xB968, # G+1836  U+B968  uniB968,  HANGUL SYLLABLE-B968
        0xB969, # G+1837  U+B969  uniB969,  HANGUL SYLLABLE-B969
        0xB96B, # G+1838  U+B96B  uniB96B,  HANGUL SYLLABLE-B96B
        0xB96D, # G+1839  U+B96D  uniB96D,  HANGUL SYLLABLE-B96D
        0xB974, # G+1840  U+B974  uniB974,  HANGUL SYLLABLE-B974
        0xB975, # G+1841  U+B975  uniB975,  HANGUL SYLLABLE-B975
        0xB978, # G+1842  U+B978  uniB978,  HANGUL SYLLABLE-B978
        0xB97C, # G+1843  U+B97C  uniB97C,  HANGUL SYLLABLE-B97C
        0xB984, # G+1844  U+B984  uniB984,  HANGUL SYLLABLE-B984
        0xB985, # G+1845  U+B985  uniB985,  HANGUL SYLLABLE-B985
        0xB987, # G+1846  U+B987  uniB987,  HANGUL SYLLABLE-B987
        0xB989, # G+1847  U+B989  uniB989,  HANGUL SYLLABLE-B989
        0xB98A, # G+1848  U+B98A  uniB98A,  HANGUL SYLLABLE-B98A
        0xB98D, # G+1849  U+B98D  uniB98D,  HANGUL SYLLABLE-B98D
        0xB98E, # G+1850  U+B98E  uniB98E,  HANGUL SYLLABLE-B98E
        0xB9AC, # G+1851  U+B9AC  uniB9AC,  HANGUL SYLLABLE-B9AC
        0xB9AD, # G+1852  U+B9AD  uniB9AD,  HANGUL SYLLABLE-B9AD
        0xB9B0, # G+1853  U+B9B0  uniB9B0,  HANGUL SYLLABLE-B9B0
        0xB9B4, # G+1854  U+B9B4  uniB9B4,  HANGUL SYLLABLE-B9B4
        0xB9BC, # G+1855  U+B9BC  uniB9BC,  HANGUL SYLLABLE-B9BC
        0xB9BD, # G+1856  U+B9BD  uniB9BD,  HANGUL SYLLABLE-B9BD
        0xB9BF, # G+1857  U+B9BF  uniB9BF,  HANGUL SYLLABLE-B9BF
        0xB9C1, # G+1858  U+B9C1  uniB9C1,  HANGUL SYLLABLE-B9C1
        0xB9C8, # G+1859  U+B9C8  uniB9C8,  HANGUL SYLLABLE-B9C8
        0xB9C9, # G+1860  U+B9C9  uniB9C9,  HANGUL SYLLABLE-B9C9
        0xB9CC, # G+1861  U+B9CC  uniB9CC,  HANGUL SYLLABLE-B9CC
        0xB9CE, # G+1862  U+B9CE  uniB9CE,  HANGUL SYLLABLE-B9CE
        0xB9CF, # G+1863  U+B9CF  uniB9CF,  HANGUL SYLLABLE-B9CF
        0xB9D0, # G+1864  U+B9D0  uniB9D0,  HANGUL SYLLABLE-B9D0
        0xB9D1, # G+1865  U+B9D1  uniB9D1,  HANGUL SYLLABLE-B9D1
        0xB9D2, # G+1866  U+B9D2  uniB9D2,  HANGUL SYLLABLE-B9D2
        0xB9D8, # G+1867  U+B9D8  uniB9D8,  HANGUL SYLLABLE-B9D8
        0xB9D9, # G+1868  U+B9D9  uniB9D9,  HANGUL SYLLABLE-B9D9
        0xB9DB, # G+1869  U+B9DB  uniB9DB,  HANGUL SYLLABLE-B9DB
        0xB9DD, # G+1870  U+B9DD  uniB9DD,  HANGUL SYLLABLE-B9DD
        0xB9DE, # G+1871  U+B9DE  uniB9DE,  HANGUL SYLLABLE-B9DE
        0xB9E1, # G+1872  U+B9E1  uniB9E1,  HANGUL SYLLABLE-B9E1
        0xB9E3, # G+1873  U+B9E3  uniB9E3,  HANGUL SYLLABLE-B9E3
        0xB9E4, # G+1874  U+B9E4  uniB9E4,  HANGUL SYLLABLE-B9E4
        0xB9E5, # G+1875  U+B9E5  uniB9E5,  HANGUL SYLLABLE-B9E5
        0xB9E8, # G+1876  U+B9E8  uniB9E8,  HANGUL SYLLABLE-B9E8
        0xB9EC, # G+1877  U+B9EC  uniB9EC,  HANGUL SYLLABLE-B9EC
        0xB9F4, # G+1878  U+B9F4  uniB9F4,  HANGUL SYLLABLE-B9F4
        0xB9F5, # G+1879  U+B9F5  uniB9F5,  HANGUL SYLLABLE-B9F5
        0xB9F7, # G+1880  U+B9F7  uniB9F7,  HANGUL SYLLABLE-B9F7
        0xB9F8, # G+1881  U+B9F8  uniB9F8,  HANGUL SYLLABLE-B9F8
        0xB9F9, # G+1882  U+B9F9  uniB9F9,  HANGUL SYLLABLE-B9F9
        0xB9FA, # G+1883  U+B9FA  uniB9FA,  HANGUL SYLLABLE-B9FA
        0xBA00, # G+1884  U+BA00  uniBA00,  HANGUL SYLLABLE-BA00
        0xBA01, # G+1885  U+BA01  uniBA01,  HANGUL SYLLABLE-BA01
        0xBA08, # G+1886  U+BA08  uniBA08,  HANGUL SYLLABLE-BA08
        0xBA15, # G+1887  U+BA15  uniBA15,  HANGUL SYLLABLE-BA15
        0xBA38, # G+1888  U+BA38  uniBA38,  HANGUL SYLLABLE-BA38
        0xBA39, # G+1889  U+BA39  uniBA39,  HANGUL SYLLABLE-BA39
        0xBA3C, # G+1890  U+BA3C  uniBA3C,  HANGUL SYLLABLE-BA3C
        0xBA40, # G+1891  U+BA40  uniBA40,  HANGUL SYLLABLE-BA40
        0xBA42, # G+1892  U+BA42  uniBA42,  HANGUL SYLLABLE-BA42
        0xBA48, # G+1893  U+BA48  uniBA48,  HANGUL SYLLABLE-BA48
        0xBA49, # G+1894  U+BA49  uniBA49,  HANGUL SYLLABLE-BA49
        0xBA4B, # G+1895  U+BA4B  uniBA4B,  HANGUL SYLLABLE-BA4B
        0xBA4D, # G+1896  U+BA4D  uniBA4D,  HANGUL SYLLABLE-BA4D
        0xBA4E, # G+1897  U+BA4E  uniBA4E,  HANGUL SYLLABLE-BA4E
        0xBA53, # G+1898  U+BA53  uniBA53,  HANGUL SYLLABLE-BA53
        0xBA54, # G+1899  U+BA54  uniBA54,  HANGUL SYLLABLE-BA54
        0xBA55, # G+1900  U+BA55  uniBA55,  HANGUL SYLLABLE-BA55
        0xBA58, # G+1901  U+BA58  uniBA58,  HANGUL SYLLABLE-BA58
        0xBA5C, # G+1902  U+BA5C  uniBA5C,  HANGUL SYLLABLE-BA5C
        0xBA64, # G+1903  U+BA64  uniBA64,  HANGUL SYLLABLE-BA64
        0xBA65, # G+1904  U+BA65  uniBA65,  HANGUL SYLLABLE-BA65
        0xBA67, # G+1905  U+BA67  uniBA67,  HANGUL SYLLABLE-BA67
        0xBA68, # G+1906  U+BA68  uniBA68,  HANGUL SYLLABLE-BA68
        0xBA69, # G+1907  U+BA69  uniBA69,  HANGUL SYLLABLE-BA69
        0xBA70, # G+1908  U+BA70  uniBA70,  HANGUL SYLLABLE-BA70
        0xBA71, # G+1909  U+BA71  uniBA71,  HANGUL SYLLABLE-BA71
        0xBA74, # G+1910  U+BA74  uniBA74,  HANGUL SYLLABLE-BA74
        0xBA78, # G+1911  U+BA78  uniBA78,  HANGUL SYLLABLE-BA78
        0xBA83, # G+1912  U+BA83  uniBA83,  HANGUL SYLLABLE-BA83
        0xBA84, # G+1913  U+BA84  uniBA84,  HANGUL SYLLABLE-BA84
        0xBA85, # G+1914  U+BA85  uniBA85,  HANGUL SYLLABLE-BA85
        0xBA87, # G+1915  U+BA87  uniBA87,  HANGUL SYLLABLE-BA87
        0xBA8C, # G+1916  U+BA8C  uniBA8C,  HANGUL SYLLABLE-BA8C
        0xBAA8, # G+1917  U+BAA8  uniBAA8,  HANGUL SYLLABLE-BAA8
        0xBAA9, # G+1918  U+BAA9  uniBAA9,  HANGUL SYLLABLE-BAA9
        0xBAAB, # G+1919  U+BAAB  uniBAAB,  HANGUL SYLLABLE-BAAB
        0xBAAC, # G+1920  U+BAAC  uniBAAC,  HANGUL SYLLABLE-BAAC
        0xBAB0, # G+1921  U+BAB0  uniBAB0,  HANGUL SYLLABLE-BAB0
        0xBAB2, # G+1922  U+BAB2  uniBAB2,  HANGUL SYLLABLE-BAB2
        0xBAB8, # G+1923  U+BAB8  uniBAB8,  HANGUL SYLLABLE-BAB8
        0xBAB9, # G+1924  U+BAB9  uniBAB9,  HANGUL SYLLABLE-BAB9
        0xBABB, # G+1925  U+BABB  uniBABB,  HANGUL SYLLABLE-BABB
        0xBABD, # G+1926  U+BABD  uniBABD,  HANGUL SYLLABLE-BABD
        0xBAC4, # G+1927  U+BAC4  uniBAC4,  HANGUL SYLLABLE-BAC4
        0xBAC8, # G+1928  U+BAC8  uniBAC8,  HANGUL SYLLABLE-BAC8
        0xBAD8, # G+1929  U+BAD8  uniBAD8,  HANGUL SYLLABLE-BAD8
        0xBAD9, # G+1930  U+BAD9  uniBAD9,  HANGUL SYLLABLE-BAD9
        0xBAFC, # G+1931  U+BAFC  uniBAFC,  HANGUL SYLLABLE-BAFC
        0xBB00, # G+1932  U+BB00  uniBB00,  HANGUL SYLLABLE-BB00
        0xBB04, # G+1933  U+BB04  uniBB04,  HANGUL SYLLABLE-BB04
        0xBB0D, # G+1934  U+BB0D  uniBB0D,  HANGUL SYLLABLE-BB0D
        0xBB0F, # G+1935  U+BB0F  uniBB0F,  HANGUL SYLLABLE-BB0F
        0xBB11, # G+1936  U+BB11  uniBB11,  HANGUL SYLLABLE-BB11
        0xBB18, # G+1937  U+BB18  uniBB18,  HANGUL SYLLABLE-BB18
        0xBB1C, # G+1938  U+BB1C  uniBB1C,  HANGUL SYLLABLE-BB1C
        0xBB20, # G+1939  U+BB20  uniBB20,  HANGUL SYLLABLE-BB20
        0xBB29, # G+1940  U+BB29  uniBB29,  HANGUL SYLLABLE-BB29
        0xBB2B, # G+1941  U+BB2B  uniBB2B,  HANGUL SYLLABLE-BB2B
        0xBB34, # G+1942  U+BB34  uniBB34,  HANGUL SYLLABLE-BB34
        0xBB35, # G+1943  U+BB35  uniBB35,  HANGUL SYLLABLE-BB35
        0xBB36, # G+1944  U+BB36  uniBB36,  HANGUL SYLLABLE-BB36
        0xBB38, # G+1945  U+BB38  uniBB38,  HANGUL SYLLABLE-BB38
        0xBB3B, # G+1946  U+BB3B  uniBB3B,  HANGUL SYLLABLE-BB3B
        0xBB3C, # G+1947  U+BB3C  uniBB3C,  HANGUL SYLLABLE-BB3C
        0xBB3D, # G+1948  U+BB3D  uniBB3D,  HANGUL SYLLABLE-BB3D
        0xBB3E, # G+1949  U+BB3E  uniBB3E,  HANGUL SYLLABLE-BB3E
        0xBB44, # G+1950  U+BB44  uniBB44,  HANGUL SYLLABLE-BB44
        0xBB45, # G+1951  U+BB45  uniBB45,  HANGUL SYLLABLE-BB45
        0xBB47, # G+1952  U+BB47  uniBB47,  HANGUL SYLLABLE-BB47
        0xBB49, # G+1953  U+BB49  uniBB49,  HANGUL SYLLABLE-BB49
        0xBB4D, # G+1954  U+BB4D  uniBB4D,  HANGUL SYLLABLE-BB4D
        0xBB4F, # G+1955  U+BB4F  uniBB4F,  HANGUL SYLLABLE-BB4F
        0xBB50, # G+1956  U+BB50  uniBB50,  HANGUL SYLLABLE-BB50
        0xBB54, # G+1957  U+BB54  uniBB54,  HANGUL SYLLABLE-BB54
        0xBB58, # G+1958  U+BB58  uniBB58,  HANGUL SYLLABLE-BB58
        0xBB61, # G+1959  U+BB61  uniBB61,  HANGUL SYLLABLE-BB61
        0xBB63, # G+1960  U+BB63  uniBB63,  HANGUL SYLLABLE-BB63
        0xBB6C, # G+1961  U+BB6C  uniBB6C,  HANGUL SYLLABLE-BB6C
        0xBB88, # G+1962  U+BB88  uniBB88,  HANGUL SYLLABLE-BB88
        0xBB8C, # G+1963  U+BB8C  uniBB8C,  HANGUL SYLLABLE-BB8C
        0xBB90, # G+1964  U+BB90  uniBB90,  HANGUL SYLLABLE-BB90
        0xBBA4, # G+1965  U+BBA4  uniBBA4,  HANGUL SYLLABLE-BBA4
        0xBBA8, # G+1966  U+BBA8  uniBBA8,  HANGUL SYLLABLE-BBA8
        0xBBAC, # G+1967  U+BBAC  uniBBAC,  HANGUL SYLLABLE-BBAC
        0xBBB4, # G+1968  U+BBB4  uniBBB4,  HANGUL SYLLABLE-BBB4
        0xBBB7, # G+1969  U+BBB7  uniBBB7,  HANGUL SYLLABLE-BBB7
        0xBBC0, # G+1970  U+BBC0  uniBBC0,  HANGUL SYLLABLE-BBC0
        0xBBC4, # G+1971  U+BBC4  uniBBC4,  HANGUL SYLLABLE-BBC4
        0xBBC8, # G+1972  U+BBC8  uniBBC8,  HANGUL SYLLABLE-BBC8
        0xBBD0, # G+1973  U+BBD0  uniBBD0,  HANGUL SYLLABLE-BBD0
        0xBBD3, # G+1974  U+BBD3  uniBBD3,  HANGUL SYLLABLE-BBD3
        0xBBF8, # G+1975  U+BBF8  uniBBF8,  HANGUL SYLLABLE-BBF8
        0xBBF9, # G+1976  U+BBF9  uniBBF9,  HANGUL SYLLABLE-BBF9
        0xBBFC, # G+1977  U+BBFC  uniBBFC,  HANGUL SYLLABLE-BBFC
        0xBBFF, # G+1978  U+BBFF  uniBBFF,  HANGUL SYLLABLE-BBFF
        0xBC00, # G+1979  U+BC00  uniBC00,  HANGUL SYLLABLE-BC00
        0xBC02, # G+1980  U+BC02  uniBC02,  HANGUL SYLLABLE-BC02
        0xBC08, # G+1981  U+BC08  uniBC08,  HANGUL SYLLABLE-BC08
        0xBC09, # G+1982  U+BC09  uniBC09,  HANGUL SYLLABLE-BC09
        0xBC0B, # G+1983  U+BC0B  uniBC0B,  HANGUL SYLLABLE-BC0B
        0xBC0C, # G+1984  U+BC0C  uniBC0C,  HANGUL SYLLABLE-BC0C
        0xBC0D, # G+1985  U+BC0D  uniBC0D,  HANGUL SYLLABLE-BC0D
        0xBC0F, # G+1986  U+BC0F  uniBC0F,  HANGUL SYLLABLE-BC0F
        0xBC11, # G+1987  U+BC11  uniBC11,  HANGUL SYLLABLE-BC11
        0xBC14, # G+1988  U+BC14  uniBC14,  HANGUL SYLLABLE-BC14
        0xBC15, # G+1989  U+BC15  uniBC15,  HANGUL SYLLABLE-BC15
        0xBC16, # G+1990  U+BC16  uniBC16,  HANGUL SYLLABLE-BC16
        0xBC17, # G+1991  U+BC17  uniBC17,  HANGUL SYLLABLE-BC17
        0xBC18, # G+1992  U+BC18  uniBC18,  HANGUL SYLLABLE-BC18
        0xBC1B, # G+1993  U+BC1B  uniBC1B,  HANGUL SYLLABLE-BC1B
        0xBC1C, # G+1994  U+BC1C  uniBC1C,  HANGUL SYLLABLE-BC1C
        0xBC1D, # G+1995  U+BC1D  uniBC1D,  HANGUL SYLLABLE-BC1D
        0xBC1E, # G+1996  U+BC1E  uniBC1E,  HANGUL SYLLABLE-BC1E
        0xBC1F, # G+1997  U+BC1F  uniBC1F,  HANGUL SYLLABLE-BC1F
        0xBC24, # G+1998  U+BC24  uniBC24,  HANGUL SYLLABLE-BC24
        0xBC25, # G+1999  U+BC25  uniBC25,  HANGUL SYLLABLE-BC25
        0xBC27, # G+2000  U+BC27  uniBC27,  HANGUL SYLLABLE-BC27
        0xBC29, # G+2001  U+BC29  uniBC29,  HANGUL SYLLABLE-BC29
        0xBC2D, # G+2002  U+BC2D  uniBC2D,  HANGUL SYLLABLE-BC2D
        0xBC30, # G+2003  U+BC30  uniBC30,  HANGUL SYLLABLE-BC30
        0xBC31, # G+2004  U+BC31  uniBC31,  HANGUL SYLLABLE-BC31
        0xBC34, # G+2005  U+BC34  uniBC34,  HANGUL SYLLABLE-BC34
        0xBC38, # G+2006  U+BC38  uniBC38,  HANGUL SYLLABLE-BC38
        0xBC40, # G+2007  U+BC40  uniBC40,  HANGUL SYLLABLE-BC40
        0xBC41, # G+2008  U+BC41  uniBC41,  HANGUL SYLLABLE-BC41
        0xBC43, # G+2009  U+BC43  uniBC43,  HANGUL SYLLABLE-BC43
        0xBC44, # G+2010  U+BC44  uniBC44,  HANGUL SYLLABLE-BC44
        0xBC45, # G+2011  U+BC45  uniBC45,  HANGUL SYLLABLE-BC45
        0xBC49, # G+2012  U+BC49  uniBC49,  HANGUL SYLLABLE-BC49
        0xBC4C, # G+2013  U+BC4C  uniBC4C,  HANGUL SYLLABLE-BC4C
        0xBC4D, # G+2014  U+BC4D  uniBC4D,  HANGUL SYLLABLE-BC4D
        0xBC50, # G+2015  U+BC50  uniBC50,  HANGUL SYLLABLE-BC50
        0xBC5D, # G+2016  U+BC5D  uniBC5D,  HANGUL SYLLABLE-BC5D
        0xBC84, # G+2017  U+BC84  uniBC84,  HANGUL SYLLABLE-BC84
        0xBC85, # G+2018  U+BC85  uniBC85,  HANGUL SYLLABLE-BC85
        0xBC88, # G+2019  U+BC88  uniBC88,  HANGUL SYLLABLE-BC88
        0xBC8B, # G+2020  U+BC8B  uniBC8B,  HANGUL SYLLABLE-BC8B
        0xBC8C, # G+2021  U+BC8C  uniBC8C,  HANGUL SYLLABLE-BC8C
        0xBC8E, # G+2022  U+BC8E  uniBC8E,  HANGUL SYLLABLE-BC8E
        0xBC94, # G+2023  U+BC94  uniBC94,  HANGUL SYLLABLE-BC94
        0xBC95, # G+2024  U+BC95  uniBC95,  HANGUL SYLLABLE-BC95
        0xBC97, # G+2025  U+BC97  uniBC97,  HANGUL SYLLABLE-BC97
        0xBC99, # G+2026  U+BC99  uniBC99,  HANGUL SYLLABLE-BC99
        0xBC9A, # G+2027  U+BC9A  uniBC9A,  HANGUL SYLLABLE-BC9A
        0xBCA0, # G+2028  U+BCA0  uniBCA0,  HANGUL SYLLABLE-BCA0
        0xBCA1, # G+2029  U+BCA1  uniBCA1,  HANGUL SYLLABLE-BCA1
        0xBCA4, # G+2030  U+BCA4  uniBCA4,  HANGUL SYLLABLE-BCA4
        0xBCA7, # G+2031  U+BCA7  uniBCA7,  HANGUL SYLLABLE-BCA7
        0xBCA8, # G+2032  U+BCA8  uniBCA8,  HANGUL SYLLABLE-BCA8
        0xBCB0, # G+2033  U+BCB0  uniBCB0,  HANGUL SYLLABLE-BCB0
        0xBCB1, # G+2034  U+BCB1  uniBCB1,  HANGUL SYLLABLE-BCB1
        0xBCB3, # G+2035  U+BCB3  uniBCB3,  HANGUL SYLLABLE-BCB3
        0xBCB4, # G+2036  U+BCB4  uniBCB4,  HANGUL SYLLABLE-BCB4
        0xBCB5, # G+2037  U+BCB5  uniBCB5,  HANGUL SYLLABLE-BCB5
        0xBCBC, # G+2038  U+BCBC  uniBCBC,  HANGUL SYLLABLE-BCBC
        0xBCBD, # G+2039  U+BCBD  uniBCBD,  HANGUL SYLLABLE-BCBD
        0xBCC0, # G+2040  U+BCC0  uniBCC0,  HANGUL SYLLABLE-BCC0
        0xBCC4, # G+2041  U+BCC4  uniBCC4,  HANGUL SYLLABLE-BCC4
        0xBCCD, # G+2042  U+BCCD  uniBCCD,  HANGUL SYLLABLE-BCCD
        0xBCCF, # G+2043  U+BCCF  uniBCCF,  HANGUL SYLLABLE-BCCF
        0xBCD0, # G+2044  U+BCD0  uniBCD0,  HANGUL SYLLABLE-BCD0
        0xBCD1, # G+2045  U+BCD1  uniBCD1,  HANGUL SYLLABLE-BCD1
        0xBCD5, # G+2046  U+BCD5  uniBCD5,  HANGUL SYLLABLE-BCD5
        0xBCD8, # G+2047  U+BCD8  uniBCD8,  HANGUL SYLLABLE-BCD8
        0xBCDC, # G+2048  U+BCDC  uniBCDC,  HANGUL SYLLABLE-BCDC
        0xBCF4, # G+2049  U+BCF4  uniBCF4,  HANGUL SYLLABLE-BCF4
        0xBCF5, # G+2050  U+BCF5  uniBCF5,  HANGUL SYLLABLE-BCF5
        0xBCF6, # G+2051  U+BCF6  uniBCF6,  HANGUL SYLLABLE-BCF6
        0xBCF8, # G+2052  U+BCF8  uniBCF8,  HANGUL SYLLABLE-BCF8
        0xBCFC, # G+2053  U+BCFC  uniBCFC,  HANGUL SYLLABLE-BCFC
        0xBD04, # G+2054  U+BD04  uniBD04,  HANGUL SYLLABLE-BD04
        0xBD05, # G+2055  U+BD05  uniBD05,  HANGUL SYLLABLE-BD05
        0xBD07, # G+2056  U+BD07  uniBD07,  HANGUL SYLLABLE-BD07
        0xBD09, # G+2057  U+BD09  uniBD09,  HANGUL SYLLABLE-BD09
        0xBD10, # G+2058  U+BD10  uniBD10,  HANGUL SYLLABLE-BD10
        0xBD14, # G+2059  U+BD14  uniBD14,  HANGUL SYLLABLE-BD14
        0xBD24, # G+2060  U+BD24  uniBD24,  HANGUL SYLLABLE-BD24
        0xBD2C, # G+2061  U+BD2C  uniBD2C,  HANGUL SYLLABLE-BD2C
        0xBD40, # G+2062  U+BD40  uniBD40,  HANGUL SYLLABLE-BD40
        0xBD48, # G+2063  U+BD48  uniBD48,  HANGUL SYLLABLE-BD48
        0xBD49, # G+2064  U+BD49  uniBD49,  HANGUL SYLLABLE-BD49
        0xBD4C, # G+2065  U+BD4C  uniBD4C,  HANGUL SYLLABLE-BD4C
        0xBD50, # G+2066  U+BD50  uniBD50,  HANGUL SYLLABLE-BD50
        0xBD58, # G+2067  U+BD58  uniBD58,  HANGUL SYLLABLE-BD58
        0xBD59, # G+2068  U+BD59  uniBD59,  HANGUL SYLLABLE-BD59
        0xBD64, # G+2069  U+BD64  uniBD64,  HANGUL SYLLABLE-BD64
        0xBD68, # G+2070  U+BD68  uniBD68,  HANGUL SYLLABLE-BD68
        0xBD80, # G+2071  U+BD80  uniBD80,  HANGUL SYLLABLE-BD80
        0xBD81, # G+2072  U+BD81  uniBD81,  HANGUL SYLLABLE-BD81
        0xBD84, # G+2073  U+BD84  uniBD84,  HANGUL SYLLABLE-BD84
        0xBD87, # G+2074  U+BD87  uniBD87,  HANGUL SYLLABLE-BD87
        0xBD88, # G+2075  U+BD88  uniBD88,  HANGUL SYLLABLE-BD88
        0xBD89, # G+2076  U+BD89  uniBD89,  HANGUL SYLLABLE-BD89
        0xBD8A, # G+2077  U+BD8A  uniBD8A,  HANGUL SYLLABLE-BD8A
        0xBD90, # G+2078  U+BD90  uniBD90,  HANGUL SYLLABLE-BD90
        0xBD91, # G+2079  U+BD91  uniBD91,  HANGUL SYLLABLE-BD91
        0xBD93, # G+2080  U+BD93  uniBD93,  HANGUL SYLLABLE-BD93
        0xBD95, # G+2081  U+BD95  uniBD95,  HANGUL SYLLABLE-BD95
        0xBD99, # G+2082  U+BD99  uniBD99,  HANGUL SYLLABLE-BD99
        0xBD9A, # G+2083  U+BD9A  uniBD9A,  HANGUL SYLLABLE-BD9A
        0xBD9C, # G+2084  U+BD9C  uniBD9C,  HANGUL SYLLABLE-BD9C
        0xBDA4, # G+2085  U+BDA4  uniBDA4,  HANGUL SYLLABLE-BDA4
        0xBDB0, # G+2086  U+BDB0  uniBDB0,  HANGUL SYLLABLE-BDB0
        0xBDB8, # G+2087  U+BDB8  uniBDB8,  HANGUL SYLLABLE-BDB8
        0xBDD4, # G+2088  U+BDD4  uniBDD4,  HANGUL SYLLABLE-BDD4
        0xBDD5, # G+2089  U+BDD5  uniBDD5,  HANGUL SYLLABLE-BDD5
        0xBDD8, # G+2090  U+BDD8  uniBDD8,  HANGUL SYLLABLE-BDD8
        0xBDDC, # G+2091  U+BDDC  uniBDDC,  HANGUL SYLLABLE-BDDC
        0xBDE9, # G+2092  U+BDE9  uniBDE9,  HANGUL SYLLABLE-BDE9
        0xBDF0, # G+2093  U+BDF0  uniBDF0,  HANGUL SYLLABLE-BDF0
        0xBDF4, # G+2094  U+BDF4  uniBDF4,  HANGUL SYLLABLE-BDF4
        0xBDF8, # G+2095  U+BDF8  uniBDF8,  HANGUL SYLLABLE-BDF8
        0xBE00, # G+2096  U+BE00  uniBE00,  HANGUL SYLLABLE-BE00
        0xBE03, # G+2097  U+BE03  uniBE03,  HANGUL SYLLABLE-BE03
        0xBE05, # G+2098  U+BE05  uniBE05,  HANGUL SYLLABLE-BE05
        0xBE0C, # G+2099  U+BE0C  uniBE0C,  HANGUL SYLLABLE-BE0C
        0xBE0D, # G+2100  U+BE0D  uniBE0D,  HANGUL SYLLABLE-BE0D
        0xBE10, # G+2101  U+BE10  uniBE10,  HANGUL SYLLABLE-BE10
        0xBE14, # G+2102  U+BE14  uniBE14,  HANGUL SYLLABLE-BE14
        0xBE1C, # G+2103  U+BE1C  uniBE1C,  HANGUL SYLLABLE-BE1C
        0xBE1D, # G+2104  U+BE1D  uniBE1D,  HANGUL SYLLABLE-BE1D
        0xBE1F, # G+2105  U+BE1F  uniBE1F,  HANGUL SYLLABLE-BE1F
        0xBE44, # G+2106  U+BE44  uniBE44,  HANGUL SYLLABLE-BE44
        0xBE45, # G+2107  U+BE45  uniBE45,  HANGUL SYLLABLE-BE45
        0xBE48, # G+2108  U+BE48  uniBE48,  HANGUL SYLLABLE-BE48
        0xBE4C, # G+2109  U+BE4C  uniBE4C,  HANGUL SYLLABLE-BE4C
        0xBE4E, # G+2110  U+BE4E  uniBE4E,  HANGUL SYLLABLE-BE4E
        0xBE54, # G+2111  U+BE54  uniBE54,  HANGUL SYLLABLE-BE54
        0xBE55, # G+2112  U+BE55  uniBE55,  HANGUL SYLLABLE-BE55
        0xBE57, # G+2113  U+BE57  uniBE57,  HANGUL SYLLABLE-BE57
        0xBE59, # G+2114  U+BE59  uniBE59,  HANGUL SYLLABLE-BE59
        0xBE5A, # G+2115  U+BE5A  uniBE5A,  HANGUL SYLLABLE-BE5A
        0xBE5B, # G+2116  U+BE5B  uniBE5B,  HANGUL SYLLABLE-BE5B
        0xBE60, # G+2117  U+BE60  uniBE60,  HANGUL SYLLABLE-BE60
        0xBE61, # G+2118  U+BE61  uniBE61,  HANGUL SYLLABLE-BE61
        0xBE64, # G+2119  U+BE64  uniBE64,  HANGUL SYLLABLE-BE64
        0xBE68, # G+2120  U+BE68  uniBE68,  HANGUL SYLLABLE-BE68
        0xBE6A, # G+2121  U+BE6A  uniBE6A,  HANGUL SYLLABLE-BE6A
        0xBE70, # G+2122  U+BE70  uniBE70,  HANGUL SYLLABLE-BE70
        0xBE71, # G+2123  U+BE71  uniBE71,  HANGUL SYLLABLE-BE71
        0xBE73, # G+2124  U+BE73  uniBE73,  HANGUL SYLLABLE-BE73
        0xBE74, # G+2125  U+BE74  uniBE74,  HANGUL SYLLABLE-BE74
        0xBE75, # G+2126  U+BE75  uniBE75,  HANGUL SYLLABLE-BE75
        0xBE7B, # G+2127  U+BE7B  uniBE7B,  HANGUL SYLLABLE-BE7B
        0xBE7C, # G+2128  U+BE7C  uniBE7C,  HANGUL SYLLABLE-BE7C
        0xBE7D, # G+2129  U+BE7D  uniBE7D,  HANGUL SYLLABLE-BE7D
        0xBE80, # G+2130  U+BE80  uniBE80,  HANGUL SYLLABLE-BE80
        0xBE84, # G+2131  U+BE84  uniBE84,  HANGUL SYLLABLE-BE84
        0xBE8C, # G+2132  U+BE8C  uniBE8C,  HANGUL SYLLABLE-BE8C
        0xBE8D, # G+2133  U+BE8D  uniBE8D,  HANGUL SYLLABLE-BE8D
        0xBE8F, # G+2134  U+BE8F  uniBE8F,  HANGUL SYLLABLE-BE8F
        0xBE90, # G+2135  U+BE90  uniBE90,  HANGUL SYLLABLE-BE90
        0xBE91, # G+2136  U+BE91  uniBE91,  HANGUL SYLLABLE-BE91
        0xBE98, # G+2137  U+BE98  uniBE98,  HANGUL SYLLABLE-BE98
        0xBE99, # G+2138  U+BE99  uniBE99,  HANGUL SYLLABLE-BE99
        0xBEA8, # G+2139  U+BEA8  uniBEA8,  HANGUL SYLLABLE-BEA8
        0xBED0, # G+2140  U+BED0  uniBED0,  HANGUL SYLLABLE-BED0
        0xBED1, # G+2141  U+BED1  uniBED1,  HANGUL SYLLABLE-BED1
        0xBED4, # G+2142  U+BED4  uniBED4,  HANGUL SYLLABLE-BED4
        0xBED7, # G+2143  U+BED7  uniBED7,  HANGUL SYLLABLE-BED7
        0xBED8, # G+2144  U+BED8  uniBED8,  HANGUL SYLLABLE-BED8
        0xBEE0, # G+2145  U+BEE0  uniBEE0,  HANGUL SYLLABLE-BEE0
        0xBEE3, # G+2146  U+BEE3  uniBEE3,  HANGUL SYLLABLE-BEE3
        0xBEE4, # G+2147  U+BEE4  uniBEE4,  HANGUL SYLLABLE-BEE4
        0xBEE5, # G+2148  U+BEE5  uniBEE5,  HANGUL SYLLABLE-BEE5
        0xBEEC, # G+2149  U+BEEC  uniBEEC,  HANGUL SYLLABLE-BEEC
        0xBF01, # G+2150  U+BF01  uniBF01,  HANGUL SYLLABLE-BF01
        0xBF08, # G+2151  U+BF08  uniBF08,  HANGUL SYLLABLE-BF08
        0xBF09, # G+2152  U+BF09  uniBF09,  HANGUL SYLLABLE-BF09
        0xBF18, # G+2153  U+BF18  uniBF18,  HANGUL SYLLABLE-BF18
        0xBF19, # G+2154  U+BF19  uniBF19,  HANGUL SYLLABLE-BF19
        0xBF1B, # G+2155  U+BF1B  uniBF1B,  HANGUL SYLLABLE-BF1B
        0xBF1C, # G+2156  U+BF1C  uniBF1C,  HANGUL SYLLABLE-BF1C
        0xBF1D, # G+2157  U+BF1D  uniBF1D,  HANGUL SYLLABLE-BF1D
        0xBF40, # G+2158  U+BF40  uniBF40,  HANGUL SYLLABLE-BF40
        0xBF41, # G+2159  U+BF41  uniBF41,  HANGUL SYLLABLE-BF41
        0xBF44, # G+2160  U+BF44  uniBF44,  HANGUL SYLLABLE-BF44
        0xBF48, # G+2161  U+BF48  uniBF48,  HANGUL SYLLABLE-BF48
        0xBF50, # G+2162  U+BF50  uniBF50,  HANGUL SYLLABLE-BF50
        0xBF51, # G+2163  U+BF51  uniBF51,  HANGUL SYLLABLE-BF51
        0xBF55, # G+2164  U+BF55  uniBF55,  HANGUL SYLLABLE-BF55
        0xBF94, # G+2165  U+BF94  uniBF94,  HANGUL SYLLABLE-BF94
        0xBFB0, # G+2166  U+BFB0  uniBFB0,  HANGUL SYLLABLE-BFB0
        0xBFC5, # G+2167  U+BFC5  uniBFC5,  HANGUL SYLLABLE-BFC5
        0xBFCC, # G+2168  U+BFCC  uniBFCC,  HANGUL SYLLABLE-BFCC
        0xBFCD, # G+2169  U+BFCD  uniBFCD,  HANGUL SYLLABLE-BFCD
        0xBFD0, # G+2170  U+BFD0  uniBFD0,  HANGUL SYLLABLE-BFD0
        0xBFD4, # G+2171  U+BFD4  uniBFD4,  HANGUL SYLLABLE-BFD4
        0xBFDC, # G+2172  U+BFDC  uniBFDC,  HANGUL SYLLABLE-BFDC
        0xBFDF, # G+2173  U+BFDF  uniBFDF,  HANGUL SYLLABLE-BFDF
        0xBFE1, # G+2174  U+BFE1  uniBFE1,  HANGUL SYLLABLE-BFE1
        0xC03C, # G+2175  U+C03C  uniC03C,  HANGUL SYLLABLE-C03C
        0xC051, # G+2176  U+C051  uniC051,  HANGUL SYLLABLE-C051
        0xC058, # G+2177  U+C058  uniC058,  HANGUL SYLLABLE-C058
        0xC05C, # G+2178  U+C05C  uniC05C,  HANGUL SYLLABLE-C05C
        0xC060, # G+2179  U+C060  uniC060,  HANGUL SYLLABLE-C060
        0xC068, # G+2180  U+C068  uniC068,  HANGUL SYLLABLE-C068
        0xC069, # G+2181  U+C069  uniC069,  HANGUL SYLLABLE-C069
        0xC090, # G+2182  U+C090  uniC090,  HANGUL SYLLABLE-C090
        0xC091, # G+2183  U+C091  uniC091,  HANGUL SYLLABLE-C091
        0xC094, # G+2184  U+C094  uniC094,  HANGUL SYLLABLE-C094
        0xC098, # G+2185  U+C098  uniC098,  HANGUL SYLLABLE-C098
        0xC0A0, # G+2186  U+C0A0  uniC0A0,  HANGUL SYLLABLE-C0A0
        0xC0A1, # G+2187  U+C0A1  uniC0A1,  HANGUL SYLLABLE-C0A1
        0xC0A3, # G+2188  U+C0A3  uniC0A3,  HANGUL SYLLABLE-C0A3
        0xC0A5, # G+2189  U+C0A5  uniC0A5,  HANGUL SYLLABLE-C0A5
        0xC0AC, # G+2190  U+C0AC  uniC0AC,  HANGUL SYLLABLE-C0AC
        0xC0AD, # G+2191  U+C0AD  uniC0AD,  HANGUL SYLLABLE-C0AD
        0xC0AF, # G+2192  U+C0AF  uniC0AF,  HANGUL SYLLABLE-C0AF
        0xC0B0, # G+2193  U+C0B0  uniC0B0,  HANGUL SYLLABLE-C0B0
        0xC0B3, # G+2194  U+C0B3  uniC0B3,  HANGUL SYLLABLE-C0B3
        0xC0B4, # G+2195  U+C0B4  uniC0B4,  HANGUL SYLLABLE-C0B4
        0xC0B5, # G+2196  U+C0B5  uniC0B5,  HANGUL SYLLABLE-C0B5
        0xC0B6, # G+2197  U+C0B6  uniC0B6,  HANGUL SYLLABLE-C0B6
        0xC0BC, # G+2198  U+C0BC  uniC0BC,  HANGUL SYLLABLE-C0BC
        0xC0BD, # G+2199  U+C0BD  uniC0BD,  HANGUL SYLLABLE-C0BD
        0xC0BF, # G+2200  U+C0BF  uniC0BF,  HANGUL SYLLABLE-C0BF
        0xC0C0, # G+2201  U+C0C0  uniC0C0,  HANGUL SYLLABLE-C0C0
        0xC0C1, # G+2202  U+C0C1  uniC0C1,  HANGUL SYLLABLE-C0C1
        0xC0C5, # G+2203  U+C0C5  uniC0C5,  HANGUL SYLLABLE-C0C5
        0xC0C8, # G+2204  U+C0C8  uniC0C8,  HANGUL SYLLABLE-C0C8
        0xC0C9, # G+2205  U+C0C9  uniC0C9,  HANGUL SYLLABLE-C0C9
        0xC0CC, # G+2206  U+C0CC  uniC0CC,  HANGUL SYLLABLE-C0CC
        0xC0D0, # G+2207  U+C0D0  uniC0D0,  HANGUL SYLLABLE-C0D0
        0xC0D8, # G+2208  U+C0D8  uniC0D8,  HANGUL SYLLABLE-C0D8
        0xC0D9, # G+2209  U+C0D9  uniC0D9,  HANGUL SYLLABLE-C0D9
        0xC0DB, # G+2210  U+C0DB  uniC0DB,  HANGUL SYLLABLE-C0DB
        0xC0DC, # G+2211  U+C0DC  uniC0DC,  HANGUL SYLLABLE-C0DC
        0xC0DD, # G+2212  U+C0DD  uniC0DD,  HANGUL SYLLABLE-C0DD
        0xC0E4, # G+2213  U+C0E4  uniC0E4,  HANGUL SYLLABLE-C0E4
        0xC0E5, # G+2214  U+C0E5  uniC0E5,  HANGUL SYLLABLE-C0E5
        0xC0E8, # G+2215  U+C0E8  uniC0E8,  HANGUL SYLLABLE-C0E8
        0xC0EC, # G+2216  U+C0EC  uniC0EC,  HANGUL SYLLABLE-C0EC
        0xC0F4, # G+2217  U+C0F4  uniC0F4,  HANGUL SYLLABLE-C0F4
        0xC0F5, # G+2218  U+C0F5  uniC0F5,  HANGUL SYLLABLE-C0F5
        0xC0F7, # G+2219  U+C0F7  uniC0F7,  HANGUL SYLLABLE-C0F7
        0xC0F9, # G+2220  U+C0F9  uniC0F9,  HANGUL SYLLABLE-C0F9
        0xC100, # G+2221  U+C100  uniC100,  HANGUL SYLLABLE-C100
        0xC104, # G+2222  U+C104  uniC104,  HANGUL SYLLABLE-C104
        0xC108, # G+2223  U+C108  uniC108,  HANGUL SYLLABLE-C108
        0xC110, # G+2224  U+C110  uniC110,  HANGUL SYLLABLE-C110
        0xC115, # G+2225  U+C115  uniC115,  HANGUL SYLLABLE-C115
        0xC11C, # G+2226  U+C11C  uniC11C,  HANGUL SYLLABLE-C11C
        0xC11D, # G+2227  U+C11D  uniC11D,  HANGUL SYLLABLE-C11D
        0xC11E, # G+2228  U+C11E  uniC11E,  HANGUL SYLLABLE-C11E
        0xC11F, # G+2229  U+C11F  uniC11F,  HANGUL SYLLABLE-C11F
        0xC120, # G+2230  U+C120  uniC120,  HANGUL SYLLABLE-C120
        0xC123, # G+2231  U+C123  uniC123,  HANGUL SYLLABLE-C123
        0xC124, # G+2232  U+C124  uniC124,  HANGUL SYLLABLE-C124
        0xC126, # G+2233  U+C126  uniC126,  HANGUL SYLLABLE-C126
        0xC127, # G+2234  U+C127  uniC127,  HANGUL SYLLABLE-C127
        0xC12C, # G+2235  U+C12C  uniC12C,  HANGUL SYLLABLE-C12C
        0xC12D, # G+2236  U+C12D  uniC12D,  HANGUL SYLLABLE-C12D
        0xC12F, # G+2237  U+C12F  uniC12F,  HANGUL SYLLABLE-C12F
        0xC130, # G+2238  U+C130  uniC130,  HANGUL SYLLABLE-C130
        0xC131, # G+2239  U+C131  uniC131,  HANGUL SYLLABLE-C131
        0xC136, # G+2240  U+C136  uniC136,  HANGUL SYLLABLE-C136
        0xC138, # G+2241  U+C138  uniC138,  HANGUL SYLLABLE-C138
        0xC139, # G+2242  U+C139  uniC139,  HANGUL SYLLABLE-C139
        0xC13C, # G+2243  U+C13C  uniC13C,  HANGUL SYLLABLE-C13C
        0xC140, # G+2244  U+C140  uniC140,  HANGUL SYLLABLE-C140
        0xC148, # G+2245  U+C148  uniC148,  HANGUL SYLLABLE-C148
        0xC149, # G+2246  U+C149  uniC149,  HANGUL SYLLABLE-C149
        0xC14B, # G+2247  U+C14B  uniC14B,  HANGUL SYLLABLE-C14B
        0xC14C, # G+2248  U+C14C  uniC14C,  HANGUL SYLLABLE-C14C
        0xC14D, # G+2249  U+C14D  uniC14D,  HANGUL SYLLABLE-C14D
        0xC154, # G+2250  U+C154  uniC154,  HANGUL SYLLABLE-C154
        0xC155, # G+2251  U+C155  uniC155,  HANGUL SYLLABLE-C155
        0xC158, # G+2252  U+C158  uniC158,  HANGUL SYLLABLE-C158
        0xC15C, # G+2253  U+C15C  uniC15C,  HANGUL SYLLABLE-C15C
        0xC164, # G+2254  U+C164  uniC164,  HANGUL SYLLABLE-C164
        0xC165, # G+2255  U+C165  uniC165,  HANGUL SYLLABLE-C165
        0xC167, # G+2256  U+C167  uniC167,  HANGUL SYLLABLE-C167
        0xC168, # G+2257  U+C168  uniC168,  HANGUL SYLLABLE-C168
        0xC169, # G+2258  U+C169  uniC169,  HANGUL SYLLABLE-C169
        0xC170, # G+2259  U+C170  uniC170,  HANGUL SYLLABLE-C170
        0xC174, # G+2260  U+C174  uniC174,  HANGUL SYLLABLE-C174
        0xC178, # G+2261  U+C178  uniC178,  HANGUL SYLLABLE-C178
        0xC185, # G+2262  U+C185  uniC185,  HANGUL SYLLABLE-C185
        0xC18C, # G+2263  U+C18C  uniC18C,  HANGUL SYLLABLE-C18C
        0xC18D, # G+2264  U+C18D  uniC18D,  HANGUL SYLLABLE-C18D
        0xC18E, # G+2265  U+C18E  uniC18E,  HANGUL SYLLABLE-C18E
        0xC190, # G+2266  U+C190  uniC190,  HANGUL SYLLABLE-C190
        0xC194, # G+2267  U+C194  uniC194,  HANGUL SYLLABLE-C194
        0xC196, # G+2268  U+C196  uniC196,  HANGUL SYLLABLE-C196
        0xC19C, # G+2269  U+C19C  uniC19C,  HANGUL SYLLABLE-C19C
        0xC19D, # G+2270  U+C19D  uniC19D,  HANGUL SYLLABLE-C19D
        0xC19F, # G+2271  U+C19F  uniC19F,  HANGUL SYLLABLE-C19F
        0xC1A1, # G+2272  U+C1A1  uniC1A1,  HANGUL SYLLABLE-C1A1
        0xC1A5, # G+2273  U+C1A5  uniC1A5,  HANGUL SYLLABLE-C1A5
        0xC1A8, # G+2274  U+C1A8  uniC1A8,  HANGUL SYLLABLE-C1A8
        0xC1A9, # G+2275  U+C1A9  uniC1A9,  HANGUL SYLLABLE-C1A9
        0xC1AC, # G+2276  U+C1AC  uniC1AC,  HANGUL SYLLABLE-C1AC
        0xC1B0, # G+2277  U+C1B0  uniC1B0,  HANGUL SYLLABLE-C1B0
        0xC1BD, # G+2278  U+C1BD  uniC1BD,  HANGUL SYLLABLE-C1BD
        0xC1C4, # G+2279  U+C1C4  uniC1C4,  HANGUL SYLLABLE-C1C4
        0xC1C8, # G+2280  U+C1C8  uniC1C8,  HANGUL SYLLABLE-C1C8
        0xC1CC, # G+2281  U+C1CC  uniC1CC,  HANGUL SYLLABLE-C1CC
        0xC1D4, # G+2282  U+C1D4  uniC1D4,  HANGUL SYLLABLE-C1D4
        0xC1D7, # G+2283  U+C1D7  uniC1D7,  HANGUL SYLLABLE-C1D7
        0xC1D8, # G+2284  U+C1D8  uniC1D8,  HANGUL SYLLABLE-C1D8
        0xC1E0, # G+2285  U+C1E0  uniC1E0,  HANGUL SYLLABLE-C1E0
        0xC1E4, # G+2286  U+C1E4  uniC1E4,  HANGUL SYLLABLE-C1E4
        0xC1E8, # G+2287  U+C1E8  uniC1E8,  HANGUL SYLLABLE-C1E8
        0xC1F0, # G+2288  U+C1F0  uniC1F0,  HANGUL SYLLABLE-C1F0
        0xC1F1, # G+2289  U+C1F1  uniC1F1,  HANGUL SYLLABLE-C1F1
        0xC1F3, # G+2290  U+C1F3  uniC1F3,  HANGUL SYLLABLE-C1F3
        0xC1FC, # G+2291  U+C1FC  uniC1FC,  HANGUL SYLLABLE-C1FC
        0xC1FD, # G+2292  U+C1FD  uniC1FD,  HANGUL SYLLABLE-C1FD
        0xC200, # G+2293  U+C200  uniC200,  HANGUL SYLLABLE-C200
        0xC204, # G+2294  U+C204  uniC204,  HANGUL SYLLABLE-C204
        0xC20C, # G+2295  U+C20C  uniC20C,  HANGUL SYLLABLE-C20C
        0xC20D, # G+2296  U+C20D  uniC20D,  HANGUL SYLLABLE-C20D
        0xC20F, # G+2297  U+C20F  uniC20F,  HANGUL SYLLABLE-C20F
        0xC211, # G+2298  U+C211  uniC211,  HANGUL SYLLABLE-C211
        0xC218, # G+2299  U+C218  uniC218,  HANGUL SYLLABLE-C218
        0xC219, # G+2300  U+C219  uniC219,  HANGUL SYLLABLE-C219
        0xC21C, # G+2301  U+C21C  uniC21C,  HANGUL SYLLABLE-C21C
        0xC21F, # G+2302  U+C21F  uniC21F,  HANGUL SYLLABLE-C21F
        0xC220, # G+2303  U+C220  uniC220,  HANGUL SYLLABLE-C220
        0xC228, # G+2304  U+C228  uniC228,  HANGUL SYLLABLE-C228
        0xC229, # G+2305  U+C229  uniC229,  HANGUL SYLLABLE-C229
        0xC22B, # G+2306  U+C22B  uniC22B,  HANGUL SYLLABLE-C22B
        0xC22D, # G+2307  U+C22D  uniC22D,  HANGUL SYLLABLE-C22D
        0xC22F, # G+2308  U+C22F  uniC22F,  HANGUL SYLLABLE-C22F
        0xC231, # G+2309  U+C231  uniC231,  HANGUL SYLLABLE-C231
        0xC232, # G+2310  U+C232  uniC232,  HANGUL SYLLABLE-C232
        0xC234, # G+2311  U+C234  uniC234,  HANGUL SYLLABLE-C234
        0xC248, # G+2312  U+C248  uniC248,  HANGUL SYLLABLE-C248
        0xC250, # G+2313  U+C250  uniC250,  HANGUL SYLLABLE-C250
        0xC251, # G+2314  U+C251  uniC251,  HANGUL SYLLABLE-C251
        0xC254, # G+2315  U+C254  uniC254,  HANGUL SYLLABLE-C254
        0xC258, # G+2316  U+C258  uniC258,  HANGUL SYLLABLE-C258
        0xC260, # G+2317  U+C260  uniC260,  HANGUL SYLLABLE-C260
        0xC265, # G+2318  U+C265  uniC265,  HANGUL SYLLABLE-C265
        0xC26C, # G+2319  U+C26C  uniC26C,  HANGUL SYLLABLE-C26C
        0xC26D, # G+2320  U+C26D  uniC26D,  HANGUL SYLLABLE-C26D
        0xC270, # G+2321  U+C270  uniC270,  HANGUL SYLLABLE-C270
        0xC274, # G+2322  U+C274  uniC274,  HANGUL SYLLABLE-C274
        0xC27C, # G+2323  U+C27C  uniC27C,  HANGUL SYLLABLE-C27C
        0xC27D, # G+2324  U+C27D  uniC27D,  HANGUL SYLLABLE-C27D
        0xC27F, # G+2325  U+C27F  uniC27F,  HANGUL SYLLABLE-C27F
        0xC281, # G+2326  U+C281  uniC281,  HANGUL SYLLABLE-C281
        0xC288, # G+2327  U+C288  uniC288,  HANGUL SYLLABLE-C288
        0xC289, # G+2328  U+C289  uniC289,  HANGUL SYLLABLE-C289
        0xC290, # G+2329  U+C290  uniC290,  HANGUL SYLLABLE-C290
        0xC298, # G+2330  U+C298  uniC298,  HANGUL SYLLABLE-C298
        0xC29B, # G+2331  U+C29B  uniC29B,  HANGUL SYLLABLE-C29B
        0xC29D, # G+2332  U+C29D  uniC29D,  HANGUL SYLLABLE-C29D
        0xC2A4, # G+2333  U+C2A4  uniC2A4,  HANGUL SYLLABLE-C2A4
        0xC2A5, # G+2334  U+C2A5  uniC2A5,  HANGUL SYLLABLE-C2A5
        0xC2A8, # G+2335  U+C2A8  uniC2A8,  HANGUL SYLLABLE-C2A8
        0xC2AC, # G+2336  U+C2AC  uniC2AC,  HANGUL SYLLABLE-C2AC
        0xC2AD, # G+2337  U+C2AD  uniC2AD,  HANGUL SYLLABLE-C2AD
        0xC2B4, # G+2338  U+C2B4  uniC2B4,  HANGUL SYLLABLE-C2B4
        0xC2B5, # G+2339  U+C2B5  uniC2B5,  HANGUL SYLLABLE-C2B5
        0xC2B7, # G+2340  U+C2B7  uniC2B7,  HANGUL SYLLABLE-C2B7
        0xC2B9, # G+2341  U+C2B9  uniC2B9,  HANGUL SYLLABLE-C2B9
        0xC2DC, # G+2342  U+C2DC  uniC2DC,  HANGUL SYLLABLE-C2DC
        0xC2DD, # G+2343  U+C2DD  uniC2DD,  HANGUL SYLLABLE-C2DD
        0xC2E0, # G+2344  U+C2E0  uniC2E0,  HANGUL SYLLABLE-C2E0
        0xC2E3, # G+2345  U+C2E3  uniC2E3,  HANGUL SYLLABLE-C2E3
        0xC2E4, # G+2346  U+C2E4  uniC2E4,  HANGUL SYLLABLE-C2E4
        0xC2EB, # G+2347  U+C2EB  uniC2EB,  HANGUL SYLLABLE-C2EB
        0xC2EC, # G+2348  U+C2EC  uniC2EC,  HANGUL SYLLABLE-C2EC
        0xC2ED, # G+2349  U+C2ED  uniC2ED,  HANGUL SYLLABLE-C2ED
        0xC2EF, # G+2350  U+C2EF  uniC2EF,  HANGUL SYLLABLE-C2EF
        0xC2F1, # G+2351  U+C2F1  uniC2F1,  HANGUL SYLLABLE-C2F1
        0xC2F6, # G+2352  U+C2F6  uniC2F6,  HANGUL SYLLABLE-C2F6
        0xC2F8, # G+2353  U+C2F8  uniC2F8,  HANGUL SYLLABLE-C2F8
        0xC2F9, # G+2354  U+C2F9  uniC2F9,  HANGUL SYLLABLE-C2F9
        0xC2FB, # G+2355  U+C2FB  uniC2FB,  HANGUL SYLLABLE-C2FB
        0xC2FC, # G+2356  U+C2FC  uniC2FC,  HANGUL SYLLABLE-C2FC
        0xC300, # G+2357  U+C300  uniC300,  HANGUL SYLLABLE-C300
        0xC308, # G+2358  U+C308  uniC308,  HANGUL SYLLABLE-C308
        0xC309, # G+2359  U+C309  uniC309,  HANGUL SYLLABLE-C309
        0xC30C, # G+2360  U+C30C  uniC30C,  HANGUL SYLLABLE-C30C
        0xC30D, # G+2361  U+C30D  uniC30D,  HANGUL SYLLABLE-C30D
        0xC313, # G+2362  U+C313  uniC313,  HANGUL SYLLABLE-C313
        0xC314, # G+2363  U+C314  uniC314,  HANGUL SYLLABLE-C314
        0xC315, # G+2364  U+C315  uniC315,  HANGUL SYLLABLE-C315
        0xC318, # G+2365  U+C318  uniC318,  HANGUL SYLLABLE-C318
        0xC31C, # G+2366  U+C31C  uniC31C,  HANGUL SYLLABLE-C31C
        0xC324, # G+2367  U+C324  uniC324,  HANGUL SYLLABLE-C324
        0xC325, # G+2368  U+C325  uniC325,  HANGUL SYLLABLE-C325
        0xC328, # G+2369  U+C328  uniC328,  HANGUL SYLLABLE-C328
        0xC329, # G+2370  U+C329  uniC329,  HANGUL SYLLABLE-C329
        0xC345, # G+2371  U+C345  uniC345,  HANGUL SYLLABLE-C345
        0xC368, # G+2372  U+C368  uniC368,  HANGUL SYLLABLE-C368
        0xC369, # G+2373  U+C369  uniC369,  HANGUL SYLLABLE-C369
        0xC36C, # G+2374  U+C36C  uniC36C,  HANGUL SYLLABLE-C36C
        0xC370, # G+2375  U+C370  uniC370,  HANGUL SYLLABLE-C370
        0xC372, # G+2376  U+C372  uniC372,  HANGUL SYLLABLE-C372
        0xC378, # G+2377  U+C378  uniC378,  HANGUL SYLLABLE-C378
        0xC379, # G+2378  U+C379  uniC379,  HANGUL SYLLABLE-C379
        0xC37C, # G+2379  U+C37C  uniC37C,  HANGUL SYLLABLE-C37C
        0xC37D, # G+2380  U+C37D  uniC37D,  HANGUL SYLLABLE-C37D
        0xC384, # G+2381  U+C384  uniC384,  HANGUL SYLLABLE-C384
        0xC388, # G+2382  U+C388  uniC388,  HANGUL SYLLABLE-C388
        0xC38C, # G+2383  U+C38C  uniC38C,  HANGUL SYLLABLE-C38C
        0xC3C0, # G+2384  U+C3C0  uniC3C0,  HANGUL SYLLABLE-C3C0
        0xC3D8, # G+2385  U+C3D8  uniC3D8,  HANGUL SYLLABLE-C3D8
        0xC3D9, # G+2386  U+C3D9  uniC3D9,  HANGUL SYLLABLE-C3D9
        0xC3DC, # G+2387  U+C3DC  uniC3DC,  HANGUL SYLLABLE-C3DC
        0xC3DF, # G+2388  U+C3DF  uniC3DF,  HANGUL SYLLABLE-C3DF
        0xC3E0, # G+2389  U+C3E0  uniC3E0,  HANGUL SYLLABLE-C3E0
        0xC3E2, # G+2390  U+C3E2  uniC3E2,  HANGUL SYLLABLE-C3E2
        0xC3E8, # G+2391  U+C3E8  uniC3E8,  HANGUL SYLLABLE-C3E8
        0xC3E9, # G+2392  U+C3E9  uniC3E9,  HANGUL SYLLABLE-C3E9
        0xC3ED, # G+2393  U+C3ED  uniC3ED,  HANGUL SYLLABLE-C3ED
        0xC3F4, # G+2394  U+C3F4  uniC3F4,  HANGUL SYLLABLE-C3F4
        0xC3F5, # G+2395  U+C3F5  uniC3F5,  HANGUL SYLLABLE-C3F5
        0xC3F8, # G+2396  U+C3F8  uniC3F8,  HANGUL SYLLABLE-C3F8
        0xC408, # G+2397  U+C408  uniC408,  HANGUL SYLLABLE-C408
        0xC410, # G+2398  U+C410  uniC410,  HANGUL SYLLABLE-C410
        0xC424, # G+2399  U+C424  uniC424,  HANGUL SYLLABLE-C424
        0xC42C, # G+2400  U+C42C  uniC42C,  HANGUL SYLLABLE-C42C
        0xC430, # G+2401  U+C430  uniC430,  HANGUL SYLLABLE-C430
        0xC434, # G+2402  U+C434  uniC434,  HANGUL SYLLABLE-C434
        0xC43C, # G+2403  U+C43C  uniC43C,  HANGUL SYLLABLE-C43C
        0xC43D, # G+2404  U+C43D  uniC43D,  HANGUL SYLLABLE-C43D
        0xC448, # G+2405  U+C448  uniC448,  HANGUL SYLLABLE-C448
        0xC464, # G+2406  U+C464  uniC464,  HANGUL SYLLABLE-C464
        0xC465, # G+2407  U+C465  uniC465,  HANGUL SYLLABLE-C465
        0xC468, # G+2408  U+C468  uniC468,  HANGUL SYLLABLE-C468
        0xC46C, # G+2409  U+C46C  uniC46C,  HANGUL SYLLABLE-C46C
        0xC474, # G+2410  U+C474  uniC474,  HANGUL SYLLABLE-C474
        0xC475, # G+2411  U+C475  uniC475,  HANGUL SYLLABLE-C475
        0xC479, # G+2412  U+C479  uniC479,  HANGUL SYLLABLE-C479
        0xC480, # G+2413  U+C480  uniC480,  HANGUL SYLLABLE-C480
        0xC494, # G+2414  U+C494  uniC494,  HANGUL SYLLABLE-C494
        0xC49C, # G+2415  U+C49C  uniC49C,  HANGUL SYLLABLE-C49C
        0xC4B8, # G+2416  U+C4B8  uniC4B8,  HANGUL SYLLABLE-C4B8
        0xC4BC, # G+2417  U+C4BC  uniC4BC,  HANGUL SYLLABLE-C4BC
        0xC4E9, # G+2418  U+C4E9  uniC4E9,  HANGUL SYLLABLE-C4E9
        0xC4F0, # G+2419  U+C4F0  uniC4F0,  HANGUL SYLLABLE-C4F0
        0xC4F1, # G+2420  U+C4F1  uniC4F1,  HANGUL SYLLABLE-C4F1
        0xC4F4, # G+2421  U+C4F4  uniC4F4,  HANGUL SYLLABLE-C4F4
        0xC4F8, # G+2422  U+C4F8  uniC4F8,  HANGUL SYLLABLE-C4F8
        0xC4FA, # G+2423  U+C4FA  uniC4FA,  HANGUL SYLLABLE-C4FA
        0xC4FF, # G+2424  U+C4FF  uniC4FF,  HANGUL SYLLABLE-C4FF
        0xC500, # G+2425  U+C500  uniC500,  HANGUL SYLLABLE-C500
        0xC501, # G+2426  U+C501  uniC501,  HANGUL SYLLABLE-C501
        0xC50C, # G+2427  U+C50C  uniC50C,  HANGUL SYLLABLE-C50C
        0xC510, # G+2428  U+C510  uniC510,  HANGUL SYLLABLE-C510
        0xC514, # G+2429  U+C514  uniC514,  HANGUL SYLLABLE-C514
        0xC51C, # G+2430  U+C51C  uniC51C,  HANGUL SYLLABLE-C51C
        0xC528, # G+2431  U+C528  uniC528,  HANGUL SYLLABLE-C528
        0xC529, # G+2432  U+C529  uniC529,  HANGUL SYLLABLE-C529
        0xC52C, # G+2433  U+C52C  uniC52C,  HANGUL SYLLABLE-C52C
        0xC530, # G+2434  U+C530  uniC530,  HANGUL SYLLABLE-C530
        0xC538, # G+2435  U+C538  uniC538,  HANGUL SYLLABLE-C538
        0xC539, # G+2436  U+C539  uniC539,  HANGUL SYLLABLE-C539
        0xC53B, # G+2437  U+C53B  uniC53B,  HANGUL SYLLABLE-C53B
        0xC53D, # G+2438  U+C53D  uniC53D,  HANGUL SYLLABLE-C53D
        0xC544, # G+2439  U+C544  uniC544,  HANGUL SYLLABLE-C544
        0xC545, # G+2440  U+C545  uniC545,  HANGUL SYLLABLE-C545
        0xC548, # G+2441  U+C548  uniC548,  HANGUL SYLLABLE-C548
        0xC549, # G+2442  U+C549  uniC549,  HANGUL SYLLABLE-C549
        0xC54A, # G+2443  U+C54A  uniC54A,  HANGUL SYLLABLE-C54A
        0xC54C, # G+2444  U+C54C  uniC54C,  HANGUL SYLLABLE-C54C
        0xC54D, # G+2445  U+C54D  uniC54D,  HANGUL SYLLABLE-C54D
        0xC54E, # G+2446  U+C54E  uniC54E,  HANGUL SYLLABLE-C54E
        0xC553, # G+2447  U+C553  uniC553,  HANGUL SYLLABLE-C553
        0xC554, # G+2448  U+C554  uniC554,  HANGUL SYLLABLE-C554
        0xC555, # G+2449  U+C555  uniC555,  HANGUL SYLLABLE-C555
        0xC557, # G+2450  U+C557  uniC557,  HANGUL SYLLABLE-C557
        0xC558, # G+2451  U+C558  uniC558,  HANGUL SYLLABLE-C558
        0xC559, # G+2452  U+C559  uniC559,  HANGUL SYLLABLE-C559
        0xC55D, # G+2453  U+C55D  uniC55D,  HANGUL SYLLABLE-C55D
        0xC55E, # G+2454  U+C55E  uniC55E,  HANGUL SYLLABLE-C55E
        0xC560, # G+2455  U+C560  uniC560,  HANGUL SYLLABLE-C560
        0xC561, # G+2456  U+C561  uniC561,  HANGUL SYLLABLE-C561
        0xC564, # G+2457  U+C564  uniC564,  HANGUL SYLLABLE-C564
        0xC568, # G+2458  U+C568  uniC568,  HANGUL SYLLABLE-C568
        0xC570, # G+2459  U+C570  uniC570,  HANGUL SYLLABLE-C570
        0xC571, # G+2460  U+C571  uniC571,  HANGUL SYLLABLE-C571
        0xC573, # G+2461  U+C573  uniC573,  HANGUL SYLLABLE-C573
        0xC574, # G+2462  U+C574  uniC574,  HANGUL SYLLABLE-C574
        0xC575, # G+2463  U+C575  uniC575,  HANGUL SYLLABLE-C575
        0xC57C, # G+2464  U+C57C  uniC57C,  HANGUL SYLLABLE-C57C
        0xC57D, # G+2465  U+C57D  uniC57D,  HANGUL SYLLABLE-C57D
        0xC580, # G+2466  U+C580  uniC580,  HANGUL SYLLABLE-C580
        0xC584, # G+2467  U+C584  uniC584,  HANGUL SYLLABLE-C584
        0xC587, # G+2468  U+C587  uniC587,  HANGUL SYLLABLE-C587
        0xC58C, # G+2469  U+C58C  uniC58C,  HANGUL SYLLABLE-C58C
        0xC58D, # G+2470  U+C58D  uniC58D,  HANGUL SYLLABLE-C58D
        0xC58F, # G+2471  U+C58F  uniC58F,  HANGUL SYLLABLE-C58F
        0xC591, # G+2472  U+C591  uniC591,  HANGUL SYLLABLE-C591
        0xC595, # G+2473  U+C595  uniC595,  HANGUL SYLLABLE-C595
        0xC597, # G+2474  U+C597  uniC597,  HANGUL SYLLABLE-C597
        0xC598, # G+2475  U+C598  uniC598,  HANGUL SYLLABLE-C598
        0xC59C, # G+2476  U+C59C  uniC59C,  HANGUL SYLLABLE-C59C
        0xC5A0, # G+2477  U+C5A0  uniC5A0,  HANGUL SYLLABLE-C5A0
        0xC5A9, # G+2478  U+C5A9  uniC5A9,  HANGUL SYLLABLE-C5A9
        0xC5B4, # G+2479  U+C5B4  uniC5B4,  HANGUL SYLLABLE-C5B4
        0xC5B5, # G+2480  U+C5B5  uniC5B5,  HANGUL SYLLABLE-C5B5
        0xC5B8, # G+2481  U+C5B8  uniC5B8,  HANGUL SYLLABLE-C5B8
        0xC5B9, # G+2482  U+C5B9  uniC5B9,  HANGUL SYLLABLE-C5B9
        0xC5BB, # G+2483  U+C5BB  uniC5BB,  HANGUL SYLLABLE-C5BB
        0xC5BC, # G+2484  U+C5BC  uniC5BC,  HANGUL SYLLABLE-C5BC
        0xC5BD, # G+2485  U+C5BD  uniC5BD,  HANGUL SYLLABLE-C5BD
        0xC5BE, # G+2486  U+C5BE  uniC5BE,  HANGUL SYLLABLE-C5BE
        0xC5C4, # G+2487  U+C5C4  uniC5C4,  HANGUL SYLLABLE-C5C4
        0xC5C5, # G+2488  U+C5C5  uniC5C5,  HANGUL SYLLABLE-C5C5
        0xC5C6, # G+2489  U+C5C6  uniC5C6,  HANGUL SYLLABLE-C5C6
        0xC5C7, # G+2490  U+C5C7  uniC5C7,  HANGUL SYLLABLE-C5C7
        0xC5C8, # G+2491  U+C5C8  uniC5C8,  HANGUL SYLLABLE-C5C8
        0xC5C9, # G+2492  U+C5C9  uniC5C9,  HANGUL SYLLABLE-C5C9
        0xC5CA, # G+2493  U+C5CA  uniC5CA,  HANGUL SYLLABLE-C5CA
        0xC5CC, # G+2494  U+C5CC  uniC5CC,  HANGUL SYLLABLE-C5CC
        0xC5CE, # G+2495  U+C5CE  uniC5CE,  HANGUL SYLLABLE-C5CE
        0xC5D0, # G+2496  U+C5D0  uniC5D0,  HANGUL SYLLABLE-C5D0
        0xC5D1, # G+2497  U+C5D1  uniC5D1,  HANGUL SYLLABLE-C5D1
        0xC5D4, # G+2498  U+C5D4  uniC5D4,  HANGUL SYLLABLE-C5D4
        0xC5D8, # G+2499  U+C5D8  uniC5D8,  HANGUL SYLLABLE-C5D8
        0xC5E0, # G+2500  U+C5E0  uniC5E0,  HANGUL SYLLABLE-C5E0
        0xC5E1, # G+2501  U+C5E1  uniC5E1,  HANGUL SYLLABLE-C5E1
        0xC5E3, # G+2502  U+C5E3  uniC5E3,  HANGUL SYLLABLE-C5E3
        0xC5E5, # G+2503  U+C5E5  uniC5E5,  HANGUL SYLLABLE-C5E5
        0xC5EC, # G+2504  U+C5EC  uniC5EC,  HANGUL SYLLABLE-C5EC
        0xC5ED, # G+2505  U+C5ED  uniC5ED,  HANGUL SYLLABLE-C5ED
        0xC5EE, # G+2506  U+C5EE  uniC5EE,  HANGUL SYLLABLE-C5EE
        0xC5F0, # G+2507  U+C5F0  uniC5F0,  HANGUL SYLLABLE-C5F0
        0xC5F4, # G+2508  U+C5F4  uniC5F4,  HANGUL SYLLABLE-C5F4
        0xC5F6, # G+2509  U+C5F6  uniC5F6,  HANGUL SYLLABLE-C5F6
        0xC5F7, # G+2510  U+C5F7  uniC5F7,  HANGUL SYLLABLE-C5F7
        0xC5FC, # G+2511  U+C5FC  uniC5FC,  HANGUL SYLLABLE-C5FC
        0xC5FD, # G+2512  U+C5FD  uniC5FD,  HANGUL SYLLABLE-C5FD
        0xC5FE, # G+2513  U+C5FE  uniC5FE,  HANGUL SYLLABLE-C5FE
        0xC5FF, # G+2514  U+C5FF  uniC5FF,  HANGUL SYLLABLE-C5FF
        0xC600, # G+2515  U+C600  uniC600,  HANGUL SYLLABLE-C600
        0xC601, # G+2516  U+C601  uniC601,  HANGUL SYLLABLE-C601
        0xC605, # G+2517  U+C605  uniC605,  HANGUL SYLLABLE-C605
        0xC606, # G+2518  U+C606  uniC606,  HANGUL SYLLABLE-C606
        0xC607, # G+2519  U+C607  uniC607,  HANGUL SYLLABLE-C607
        0xC608, # G+2520  U+C608  uniC608,  HANGUL SYLLABLE-C608
        0xC60C, # G+2521  U+C60C  uniC60C,  HANGUL SYLLABLE-C60C
        0xC610, # G+2522  U+C610  uniC610,  HANGUL SYLLABLE-C610
        0xC618, # G+2523  U+C618  uniC618,  HANGUL SYLLABLE-C618
        0xC619, # G+2524  U+C619  uniC619,  HANGUL SYLLABLE-C619
        0xC61B, # G+2525  U+C61B  uniC61B,  HANGUL SYLLABLE-C61B
        0xC61C, # G+2526  U+C61C  uniC61C,  HANGUL SYLLABLE-C61C
        0xC624, # G+2527  U+C624  uniC624,  HANGUL SYLLABLE-C624
        0xC625, # G+2528  U+C625  uniC625,  HANGUL SYLLABLE-C625
        0xC628, # G+2529  U+C628  uniC628,  HANGUL SYLLABLE-C628
        0xC62C, # G+2530  U+C62C  uniC62C,  HANGUL SYLLABLE-C62C
        0xC62D, # G+2531  U+C62D  uniC62D,  HANGUL SYLLABLE-C62D
        0xC62E, # G+2532  U+C62E  uniC62E,  HANGUL SYLLABLE-C62E
        0xC630, # G+2533  U+C630  uniC630,  HANGUL SYLLABLE-C630
        0xC633, # G+2534  U+C633  uniC633,  HANGUL SYLLABLE-C633
        0xC634, # G+2535  U+C634  uniC634,  HANGUL SYLLABLE-C634
        0xC635, # G+2536  U+C635  uniC635,  HANGUL SYLLABLE-C635
        0xC637, # G+2537  U+C637  uniC637,  HANGUL SYLLABLE-C637
        0xC639, # G+2538  U+C639  uniC639,  HANGUL SYLLABLE-C639
        0xC63B, # G+2539  U+C63B  uniC63B,  HANGUL SYLLABLE-C63B
        0xC640, # G+2540  U+C640  uniC640,  HANGUL SYLLABLE-C640
        0xC641, # G+2541  U+C641  uniC641,  HANGUL SYLLABLE-C641
        0xC644, # G+2542  U+C644  uniC644,  HANGUL SYLLABLE-C644
        0xC648, # G+2543  U+C648  uniC648,  HANGUL SYLLABLE-C648
        0xC650, # G+2544  U+C650  uniC650,  HANGUL SYLLABLE-C650
        0xC651, # G+2545  U+C651  uniC651,  HANGUL SYLLABLE-C651
        0xC653, # G+2546  U+C653  uniC653,  HANGUL SYLLABLE-C653
        0xC654, # G+2547  U+C654  uniC654,  HANGUL SYLLABLE-C654
        0xC655, # G+2548  U+C655  uniC655,  HANGUL SYLLABLE-C655
        0xC65C, # G+2549  U+C65C  uniC65C,  HANGUL SYLLABLE-C65C
        0xC65D, # G+2550  U+C65D  uniC65D,  HANGUL SYLLABLE-C65D
        0xC660, # G+2551  U+C660  uniC660,  HANGUL SYLLABLE-C660
        0xC66C, # G+2552  U+C66C  uniC66C,  HANGUL SYLLABLE-C66C
        0xC66F, # G+2553  U+C66F  uniC66F,  HANGUL SYLLABLE-C66F
        0xC671, # G+2554  U+C671  uniC671,  HANGUL SYLLABLE-C671
        0xC678, # G+2555  U+C678  uniC678,  HANGUL SYLLABLE-C678
        0xC679, # G+2556  U+C679  uniC679,  HANGUL SYLLABLE-C679
        0xC67C, # G+2557  U+C67C  uniC67C,  HANGUL SYLLABLE-C67C
        0xC680, # G+2558  U+C680  uniC680,  HANGUL SYLLABLE-C680
        0xC688, # G+2559  U+C688  uniC688,  HANGUL SYLLABLE-C688
        0xC689, # G+2560  U+C689  uniC689,  HANGUL SYLLABLE-C689
        0xC68B, # G+2561  U+C68B  uniC68B,  HANGUL SYLLABLE-C68B
        0xC68D, # G+2562  U+C68D  uniC68D,  HANGUL SYLLABLE-C68D
        0xC694, # G+2563  U+C694  uniC694,  HANGUL SYLLABLE-C694
        0xC695, # G+2564  U+C695  uniC695,  HANGUL SYLLABLE-C695
        0xC698, # G+2565  U+C698  uniC698,  HANGUL SYLLABLE-C698
        0xC69C, # G+2566  U+C69C  uniC69C,  HANGUL SYLLABLE-C69C
        0xC6A4, # G+2567  U+C6A4  uniC6A4,  HANGUL SYLLABLE-C6A4
        0xC6A5, # G+2568  U+C6A5  uniC6A5,  HANGUL SYLLABLE-C6A5
        0xC6A7, # G+2569  U+C6A7  uniC6A7,  HANGUL SYLLABLE-C6A7
        0xC6A9, # G+2570  U+C6A9  uniC6A9,  HANGUL SYLLABLE-C6A9
        0xC6B0, # G+2571  U+C6B0  uniC6B0,  HANGUL SYLLABLE-C6B0
        0xC6B1, # G+2572  U+C6B1  uniC6B1,  HANGUL SYLLABLE-C6B1
        0xC6B4, # G+2573  U+C6B4  uniC6B4,  HANGUL SYLLABLE-C6B4
        0xC6B8, # G+2574  U+C6B8  uniC6B8,  HANGUL SYLLABLE-C6B8
        0xC6B9, # G+2575  U+C6B9  uniC6B9,  HANGUL SYLLABLE-C6B9
        0xC6BA, # G+2576  U+C6BA  uniC6BA,  HANGUL SYLLABLE-C6BA
        0xC6C0, # G+2577  U+C6C0  uniC6C0,  HANGUL SYLLABLE-C6C0
        0xC6C1, # G+2578  U+C6C1  uniC6C1,  HANGUL SYLLABLE-C6C1
        0xC6C3, # G+2579  U+C6C3  uniC6C3,  HANGUL SYLLABLE-C6C3
        0xC6C5, # G+2580  U+C6C5  uniC6C5,  HANGUL SYLLABLE-C6C5
        0xC6CC, # G+2581  U+C6CC  uniC6CC,  HANGUL SYLLABLE-C6CC
        0xC6CD, # G+2582  U+C6CD  uniC6CD,  HANGUL SYLLABLE-C6CD
        0xC6D0, # G+2583  U+C6D0  uniC6D0,  HANGUL SYLLABLE-C6D0
        0xC6D4, # G+2584  U+C6D4  uniC6D4,  HANGUL SYLLABLE-C6D4
        0xC6DC, # G+2585  U+C6DC  uniC6DC,  HANGUL SYLLABLE-C6DC
        0xC6DD, # G+2586  U+C6DD  uniC6DD,  HANGUL SYLLABLE-C6DD
        0xC6E0, # G+2587  U+C6E0  uniC6E0,  HANGUL SYLLABLE-C6E0
        0xC6E1, # G+2588  U+C6E1  uniC6E1,  HANGUL SYLLABLE-C6E1
        0xC6E8, # G+2589  U+C6E8  uniC6E8,  HANGUL SYLLABLE-C6E8
        0xC6E9, # G+2590  U+C6E9  uniC6E9,  HANGUL SYLLABLE-C6E9
        0xC6EC, # G+2591  U+C6EC  uniC6EC,  HANGUL SYLLABLE-C6EC
        0xC6F0, # G+2592  U+C6F0  uniC6F0,  HANGUL SYLLABLE-C6F0
        0xC6F8, # G+2593  U+C6F8  uniC6F8,  HANGUL SYLLABLE-C6F8
        0xC6F9, # G+2594  U+C6F9  uniC6F9,  HANGUL SYLLABLE-C6F9
        0xC6FD, # G+2595  U+C6FD  uniC6FD,  HANGUL SYLLABLE-C6FD
        0xC704, # G+2596  U+C704  uniC704,  HANGUL SYLLABLE-C704
        0xC705, # G+2597  U+C705  uniC705,  HANGUL SYLLABLE-C705
        0xC708, # G+2598  U+C708  uniC708,  HANGUL SYLLABLE-C708
        0xC70C, # G+2599  U+C70C  uniC70C,  HANGUL SYLLABLE-C70C
        0xC714, # G+2600  U+C714  uniC714,  HANGUL SYLLABLE-C714
        0xC715, # G+2601  U+C715  uniC715,  HANGUL SYLLABLE-C715
        0xC717, # G+2602  U+C717  uniC717,  HANGUL SYLLABLE-C717
        0xC719, # G+2603  U+C719  uniC719,  HANGUL SYLLABLE-C719
        0xC720, # G+2604  U+C720  uniC720,  HANGUL SYLLABLE-C720
        0xC721, # G+2605  U+C721  uniC721,  HANGUL SYLLABLE-C721
        0xC724, # G+2606  U+C724  uniC724,  HANGUL SYLLABLE-C724
        0xC728, # G+2607  U+C728  uniC728,  HANGUL SYLLABLE-C728
        0xC730, # G+2608  U+C730  uniC730,  HANGUL SYLLABLE-C730
        0xC731, # G+2609  U+C731  uniC731,  HANGUL SYLLABLE-C731
        0xC733, # G+2610  U+C733  uniC733,  HANGUL SYLLABLE-C733
        0xC735, # G+2611  U+C735  uniC735,  HANGUL SYLLABLE-C735
        0xC737, # G+2612  U+C737  uniC737,  HANGUL SYLLABLE-C737
        0xC73C, # G+2613  U+C73C  uniC73C,  HANGUL SYLLABLE-C73C
        0xC73D, # G+2614  U+C73D  uniC73D,  HANGUL SYLLABLE-C73D
        0xC740, # G+2615  U+C740  uniC740,  HANGUL SYLLABLE-C740
        0xC744, # G+2616  U+C744  uniC744,  HANGUL SYLLABLE-C744
        0xC74A, # G+2617  U+C74A  uniC74A,  HANGUL SYLLABLE-C74A
        0xC74C, # G+2618  U+C74C  uniC74C,  HANGUL SYLLABLE-C74C
        0xC74D, # G+2619  U+C74D  uniC74D,  HANGUL SYLLABLE-C74D
        0xC74F, # G+2620  U+C74F  uniC74F,  HANGUL SYLLABLE-C74F
        0xC751, # G+2621  U+C751  uniC751,  HANGUL SYLLABLE-C751
        0xC752, # G+2622  U+C752  uniC752,  HANGUL SYLLABLE-C752
        0xC753, # G+2623  U+C753  uniC753,  HANGUL SYLLABLE-C753
        0xC754, # G+2624  U+C754  uniC754,  HANGUL SYLLABLE-C754
        0xC755, # G+2625  U+C755  uniC755,  HANGUL SYLLABLE-C755
        0xC756, # G+2626  U+C756  uniC756,  HANGUL SYLLABLE-C756
        0xC757, # G+2627  U+C757  uniC757,  HANGUL SYLLABLE-C757
        0xC758, # G+2628  U+C758  uniC758,  HANGUL SYLLABLE-C758
        0xC75C, # G+2629  U+C75C  uniC75C,  HANGUL SYLLABLE-C75C
        0xC760, # G+2630  U+C760  uniC760,  HANGUL SYLLABLE-C760
        0xC768, # G+2631  U+C768  uniC768,  HANGUL SYLLABLE-C768
        0xC76B, # G+2632  U+C76B  uniC76B,  HANGUL SYLLABLE-C76B
        0xC774, # G+2633  U+C774  uniC774,  HANGUL SYLLABLE-C774
        0xC775, # G+2634  U+C775  uniC775,  HANGUL SYLLABLE-C775
        0xC778, # G+2635  U+C778  uniC778,  HANGUL SYLLABLE-C778
        0xC77C, # G+2636  U+C77C  uniC77C,  HANGUL SYLLABLE-C77C
        0xC77D, # G+2637  U+C77D  uniC77D,  HANGUL SYLLABLE-C77D
        0xC77E, # G+2638  U+C77E  uniC77E,  HANGUL SYLLABLE-C77E
        0xC783, # G+2639  U+C783  uniC783,  HANGUL SYLLABLE-C783
        0xC784, # G+2640  U+C784  uniC784,  HANGUL SYLLABLE-C784
        0xC785, # G+2641  U+C785  uniC785,  HANGUL SYLLABLE-C785
        0xC787, # G+2642  U+C787  uniC787,  HANGUL SYLLABLE-C787
        0xC788, # G+2643  U+C788  uniC788,  HANGUL SYLLABLE-C788
        0xC789, # G+2644  U+C789  uniC789,  HANGUL SYLLABLE-C789
        0xC78A, # G+2645  U+C78A  uniC78A,  HANGUL SYLLABLE-C78A
        0xC78E, # G+2646  U+C78E  uniC78E,  HANGUL SYLLABLE-C78E
        0xC790, # G+2647  U+C790  uniC790,  HANGUL SYLLABLE-C790
        0xC791, # G+2648  U+C791  uniC791,  HANGUL SYLLABLE-C791
        0xC794, # G+2649  U+C794  uniC794,  HANGUL SYLLABLE-C794
        0xC796, # G+2650  U+C796  uniC796,  HANGUL SYLLABLE-C796
        0xC797, # G+2651  U+C797  uniC797,  HANGUL SYLLABLE-C797
        0xC798, # G+2652  U+C798  uniC798,  HANGUL SYLLABLE-C798
        0xC79A, # G+2653  U+C79A  uniC79A,  HANGUL SYLLABLE-C79A
        0xC7A0, # G+2654  U+C7A0  uniC7A0,  HANGUL SYLLABLE-C7A0
        0xC7A1, # G+2655  U+C7A1  uniC7A1,  HANGUL SYLLABLE-C7A1
        0xC7A3, # G+2656  U+C7A3  uniC7A3,  HANGUL SYLLABLE-C7A3
        0xC7A4, # G+2657  U+C7A4  uniC7A4,  HANGUL SYLLABLE-C7A4
        0xC7A5, # G+2658  U+C7A5  uniC7A5,  HANGUL SYLLABLE-C7A5
        0xC7A6, # G+2659  U+C7A6  uniC7A6,  HANGUL SYLLABLE-C7A6
        0xC7AC, # G+2660  U+C7AC  uniC7AC,  HANGUL SYLLABLE-C7AC
        0xC7AD, # G+2661  U+C7AD  uniC7AD,  HANGUL SYLLABLE-C7AD
        0xC7B0, # G+2662  U+C7B0  uniC7B0,  HANGUL SYLLABLE-C7B0
        0xC7B4, # G+2663  U+C7B4  uniC7B4,  HANGUL SYLLABLE-C7B4
        0xC7BC, # G+2664  U+C7BC  uniC7BC,  HANGUL SYLLABLE-C7BC
        0xC7BD, # G+2665  U+C7BD  uniC7BD,  HANGUL SYLLABLE-C7BD
        0xC7BF, # G+2666  U+C7BF  uniC7BF,  HANGUL SYLLABLE-C7BF
        0xC7C0, # G+2667  U+C7C0  uniC7C0,  HANGUL SYLLABLE-C7C0
        0xC7C1, # G+2668  U+C7C1  uniC7C1,  HANGUL SYLLABLE-C7C1
        0xC7C8, # G+2669  U+C7C8  uniC7C8,  HANGUL SYLLABLE-C7C8
        0xC7C9, # G+2670  U+C7C9  uniC7C9,  HANGUL SYLLABLE-C7C9
        0xC7CC, # G+2671  U+C7CC  uniC7CC,  HANGUL SYLLABLE-C7CC
        0xC7CE, # G+2672  U+C7CE  uniC7CE,  HANGUL SYLLABLE-C7CE
        0xC7D0, # G+2673  U+C7D0  uniC7D0,  HANGUL SYLLABLE-C7D0
        0xC7D8, # G+2674  U+C7D8  uniC7D8,  HANGUL SYLLABLE-C7D8
        0xC7DD, # G+2675  U+C7DD  uniC7DD,  HANGUL SYLLABLE-C7DD
        0xC7E4, # G+2676  U+C7E4  uniC7E4,  HANGUL SYLLABLE-C7E4
        0xC7E8, # G+2677  U+C7E8  uniC7E8,  HANGUL SYLLABLE-C7E8
        0xC7EC, # G+2678  U+C7EC  uniC7EC,  HANGUL SYLLABLE-C7EC
        0xC800, # G+2679  U+C800  uniC800,  HANGUL SYLLABLE-C800
        0xC801, # G+2680  U+C801  uniC801,  HANGUL SYLLABLE-C801
        0xC804, # G+2681  U+C804  uniC804,  HANGUL SYLLABLE-C804
        0xC808, # G+2682  U+C808  uniC808,  HANGUL SYLLABLE-C808
        0xC80A, # G+2683  U+C80A  uniC80A,  HANGUL SYLLABLE-C80A
        0xC810, # G+2684  U+C810  uniC810,  HANGUL SYLLABLE-C810
        0xC811, # G+2685  U+C811  uniC811,  HANGUL SYLLABLE-C811
        0xC813, # G+2686  U+C813  uniC813,  HANGUL SYLLABLE-C813
        0xC815, # G+2687  U+C815  uniC815,  HANGUL SYLLABLE-C815
        0xC816, # G+2688  U+C816  uniC816,  HANGUL SYLLABLE-C816
        0xC81C, # G+2689  U+C81C  uniC81C,  HANGUL SYLLABLE-C81C
        0xC81D, # G+2690  U+C81D  uniC81D,  HANGUL SYLLABLE-C81D
        0xC820, # G+2691  U+C820  uniC820,  HANGUL SYLLABLE-C820
        0xC824, # G+2692  U+C824  uniC824,  HANGUL SYLLABLE-C824
        0xC82C, # G+2693  U+C82C  uniC82C,  HANGUL SYLLABLE-C82C
        0xC82D, # G+2694  U+C82D  uniC82D,  HANGUL SYLLABLE-C82D
        0xC82F, # G+2695  U+C82F  uniC82F,  HANGUL SYLLABLE-C82F
        0xC831, # G+2696  U+C831  uniC831,  HANGUL SYLLABLE-C831
        0xC838, # G+2697  U+C838  uniC838,  HANGUL SYLLABLE-C838
        0xC83C, # G+2698  U+C83C  uniC83C,  HANGUL SYLLABLE-C83C
        0xC840, # G+2699  U+C840  uniC840,  HANGUL SYLLABLE-C840
        0xC848, # G+2700  U+C848  uniC848,  HANGUL SYLLABLE-C848
        0xC849, # G+2701  U+C849  uniC849,  HANGUL SYLLABLE-C849
        0xC84C, # G+2702  U+C84C  uniC84C,  HANGUL SYLLABLE-C84C
        0xC84D, # G+2703  U+C84D  uniC84D,  HANGUL SYLLABLE-C84D
        0xC854, # G+2704  U+C854  uniC854,  HANGUL SYLLABLE-C854
        0xC870, # G+2705  U+C870  uniC870,  HANGUL SYLLABLE-C870
        0xC871, # G+2706  U+C871  uniC871,  HANGUL SYLLABLE-C871
        0xC874, # G+2707  U+C874  uniC874,  HANGUL SYLLABLE-C874
        0xC878, # G+2708  U+C878  uniC878,  HANGUL SYLLABLE-C878
        0xC87A, # G+2709  U+C87A  uniC87A,  HANGUL SYLLABLE-C87A
        0xC880, # G+2710  U+C880  uniC880,  HANGUL SYLLABLE-C880
        0xC881, # G+2711  U+C881  uniC881,  HANGUL SYLLABLE-C881
        0xC883, # G+2712  U+C883  uniC883,  HANGUL SYLLABLE-C883
        0xC885, # G+2713  U+C885  uniC885,  HANGUL SYLLABLE-C885
        0xC886, # G+2714  U+C886  uniC886,  HANGUL SYLLABLE-C886
        0xC887, # G+2715  U+C887  uniC887,  HANGUL SYLLABLE-C887
        0xC88B, # G+2716  U+C88B  uniC88B,  HANGUL SYLLABLE-C88B
        0xC88C, # G+2717  U+C88C  uniC88C,  HANGUL SYLLABLE-C88C
        0xC88D, # G+2718  U+C88D  uniC88D,  HANGUL SYLLABLE-C88D
        0xC894, # G+2719  U+C894  uniC894,  HANGUL SYLLABLE-C894
        0xC89D, # G+2720  U+C89D  uniC89D,  HANGUL SYLLABLE-C89D
        0xC89F, # G+2721  U+C89F  uniC89F,  HANGUL SYLLABLE-C89F
        0xC8A1, # G+2722  U+C8A1  uniC8A1,  HANGUL SYLLABLE-C8A1
        0xC8A8, # G+2723  U+C8A8  uniC8A8,  HANGUL SYLLABLE-C8A8
        0xC8BC, # G+2724  U+C8BC  uniC8BC,  HANGUL SYLLABLE-C8BC
        0xC8BD, # G+2725  U+C8BD  uniC8BD,  HANGUL SYLLABLE-C8BD
        0xC8C4, # G+2726  U+C8C4  uniC8C4,  HANGUL SYLLABLE-C8C4
        0xC8C8, # G+2727  U+C8C8  uniC8C8,  HANGUL SYLLABLE-C8C8
        0xC8CC, # G+2728  U+C8CC  uniC8CC,  HANGUL SYLLABLE-C8CC
        0xC8D4, # G+2729  U+C8D4  uniC8D4,  HANGUL SYLLABLE-C8D4
        0xC8D5, # G+2730  U+C8D5  uniC8D5,  HANGUL SYLLABLE-C8D5
        0xC8D7, # G+2731  U+C8D7  uniC8D7,  HANGUL SYLLABLE-C8D7
        0xC8D9, # G+2732  U+C8D9  uniC8D9,  HANGUL SYLLABLE-C8D9
        0xC8E0, # G+2733  U+C8E0  uniC8E0,  HANGUL SYLLABLE-C8E0
        0xC8E1, # G+2734  U+C8E1  uniC8E1,  HANGUL SYLLABLE-C8E1
        0xC8E4, # G+2735  U+C8E4  uniC8E4,  HANGUL SYLLABLE-C8E4
        0xC8F5, # G+2736  U+C8F5  uniC8F5,  HANGUL SYLLABLE-C8F5
        0xC8FC, # G+2737  U+C8FC  uniC8FC,  HANGUL SYLLABLE-C8FC
        0xC8FD, # G+2738  U+C8FD  uniC8FD,  HANGUL SYLLABLE-C8FD
        0xC900, # G+2739  U+C900  uniC900,  HANGUL SYLLABLE-C900
        0xC904, # G+2740  U+C904  uniC904,  HANGUL SYLLABLE-C904
        0xC905, # G+2741  U+C905  uniC905,  HANGUL SYLLABLE-C905
        0xC906, # G+2742  U+C906  uniC906,  HANGUL SYLLABLE-C906
        0xC90C, # G+2743  U+C90C  uniC90C,  HANGUL SYLLABLE-C90C
        0xC90D, # G+2744  U+C90D  uniC90D,  HANGUL SYLLABLE-C90D
        0xC90F, # G+2745  U+C90F  uniC90F,  HANGUL SYLLABLE-C90F
        0xC911, # G+2746  U+C911  uniC911,  HANGUL SYLLABLE-C911
        0xC918, # G+2747  U+C918  uniC918,  HANGUL SYLLABLE-C918
        0xC92C, # G+2748  U+C92C  uniC92C,  HANGUL SYLLABLE-C92C
        0xC934, # G+2749  U+C934  uniC934,  HANGUL SYLLABLE-C934
        0xC950, # G+2750  U+C950  uniC950,  HANGUL SYLLABLE-C950
        0xC951, # G+2751  U+C951  uniC951,  HANGUL SYLLABLE-C951
        0xC954, # G+2752  U+C954  uniC954,  HANGUL SYLLABLE-C954
        0xC958, # G+2753  U+C958  uniC958,  HANGUL SYLLABLE-C958
        0xC960, # G+2754  U+C960  uniC960,  HANGUL SYLLABLE-C960
        0xC961, # G+2755  U+C961  uniC961,  HANGUL SYLLABLE-C961
        0xC963, # G+2756  U+C963  uniC963,  HANGUL SYLLABLE-C963
        0xC96C, # G+2757  U+C96C  uniC96C,  HANGUL SYLLABLE-C96C
        0xC970, # G+2758  U+C970  uniC970,  HANGUL SYLLABLE-C970
        0xC974, # G+2759  U+C974  uniC974,  HANGUL SYLLABLE-C974
        0xC97C, # G+2760  U+C97C  uniC97C,  HANGUL SYLLABLE-C97C
        0xC988, # G+2761  U+C988  uniC988,  HANGUL SYLLABLE-C988
        0xC989, # G+2762  U+C989  uniC989,  HANGUL SYLLABLE-C989
        0xC98C, # G+2763  U+C98C  uniC98C,  HANGUL SYLLABLE-C98C
        0xC990, # G+2764  U+C990  uniC990,  HANGUL SYLLABLE-C990
        0xC998, # G+2765  U+C998  uniC998,  HANGUL SYLLABLE-C998
        0xC999, # G+2766  U+C999  uniC999,  HANGUL SYLLABLE-C999
        0xC99B, # G+2767  U+C99B  uniC99B,  HANGUL SYLLABLE-C99B
        0xC99D, # G+2768  U+C99D  uniC99D,  HANGUL SYLLABLE-C99D
        0xC9C0, # G+2769  U+C9C0  uniC9C0,  HANGUL SYLLABLE-C9C0
        0xC9C1, # G+2770  U+C9C1  uniC9C1,  HANGUL SYLLABLE-C9C1
        0xC9C4, # G+2771  U+C9C4  uniC9C4,  HANGUL SYLLABLE-C9C4
        0xC9C7, # G+2772  U+C9C7  uniC9C7,  HANGUL SYLLABLE-C9C7
        0xC9C8, # G+2773  U+C9C8  uniC9C8,  HANGUL SYLLABLE-C9C8
        0xC9CA, # G+2774  U+C9CA  uniC9CA,  HANGUL SYLLABLE-C9CA
        0xC9D0, # G+2775  U+C9D0  uniC9D0,  HANGUL SYLLABLE-C9D0
        0xC9D1, # G+2776  U+C9D1  uniC9D1,  HANGUL SYLLABLE-C9D1
        0xC9D3, # G+2777  U+C9D3  uniC9D3,  HANGUL SYLLABLE-C9D3
        0xC9D5, # G+2778  U+C9D5  uniC9D5,  HANGUL SYLLABLE-C9D5
        0xC9D6, # G+2779  U+C9D6  uniC9D6,  HANGUL SYLLABLE-C9D6
        0xC9D9, # G+2780  U+C9D9  uniC9D9,  HANGUL SYLLABLE-C9D9
        0xC9DA, # G+2781  U+C9DA  uniC9DA,  HANGUL SYLLABLE-C9DA
        0xC9DC, # G+2782  U+C9DC  uniC9DC,  HANGUL SYLLABLE-C9DC
        0xC9DD, # G+2783  U+C9DD  uniC9DD,  HANGUL SYLLABLE-C9DD
        0xC9E0, # G+2784  U+C9E0  uniC9E0,  HANGUL SYLLABLE-C9E0
        0xC9E2, # G+2785  U+C9E2  uniC9E2,  HANGUL SYLLABLE-C9E2
        0xC9E4, # G+2786  U+C9E4  uniC9E4,  HANGUL SYLLABLE-C9E4
        0xC9E7, # G+2787  U+C9E7  uniC9E7,  HANGUL SYLLABLE-C9E7
        0xC9EC, # G+2788  U+C9EC  uniC9EC,  HANGUL SYLLABLE-C9EC
        0xC9ED, # G+2789  U+C9ED  uniC9ED,  HANGUL SYLLABLE-C9ED
        0xC9EF, # G+2790  U+C9EF  uniC9EF,  HANGUL SYLLABLE-C9EF
        0xC9F0, # G+2791  U+C9F0  uniC9F0,  HANGUL SYLLABLE-C9F0
        0xC9F1, # G+2792  U+C9F1  uniC9F1,  HANGUL SYLLABLE-C9F1
        0xC9F8, # G+2793  U+C9F8  uniC9F8,  HANGUL SYLLABLE-C9F8
        0xC9F9, # G+2794  U+C9F9  uniC9F9,  HANGUL SYLLABLE-C9F9
        0xC9FC, # G+2795  U+C9FC  uniC9FC,  HANGUL SYLLABLE-C9FC
        0xCA00, # G+2796  U+CA00  uniCA00,  HANGUL SYLLABLE-CA00
        0xCA08, # G+2797  U+CA08  uniCA08,  HANGUL SYLLABLE-CA08
        0xCA09, # G+2798  U+CA09  uniCA09,  HANGUL SYLLABLE-CA09
        0xCA0B, # G+2799  U+CA0B  uniCA0B,  HANGUL SYLLABLE-CA0B
        0xCA0C, # G+2800  U+CA0C  uniCA0C,  HANGUL SYLLABLE-CA0C
        0xCA0D, # G+2801  U+CA0D  uniCA0D,  HANGUL SYLLABLE-CA0D
        0xCA14, # G+2802  U+CA14  uniCA14,  HANGUL SYLLABLE-CA14
        0xCA18, # G+2803  U+CA18  uniCA18,  HANGUL SYLLABLE-CA18
        0xCA29, # G+2804  U+CA29  uniCA29,  HANGUL SYLLABLE-CA29
        0xCA4C, # G+2805  U+CA4C  uniCA4C,  HANGUL SYLLABLE-CA4C
        0xCA4D, # G+2806  U+CA4D  uniCA4D,  HANGUL SYLLABLE-CA4D
        0xCA50, # G+2807  U+CA50  uniCA50,  HANGUL SYLLABLE-CA50
        0xCA54, # G+2808  U+CA54  uniCA54,  HANGUL SYLLABLE-CA54
        0xCA5C, # G+2809  U+CA5C  uniCA5C,  HANGUL SYLLABLE-CA5C
        0xCA5D, # G+2810  U+CA5D  uniCA5D,  HANGUL SYLLABLE-CA5D
        0xCA5F, # G+2811  U+CA5F  uniCA5F,  HANGUL SYLLABLE-CA5F
        0xCA60, # G+2812  U+CA60  uniCA60,  HANGUL SYLLABLE-CA60
        0xCA61, # G+2813  U+CA61  uniCA61,  HANGUL SYLLABLE-CA61
        0xCA68, # G+2814  U+CA68  uniCA68,  HANGUL SYLLABLE-CA68
        0xCA7D, # G+2815  U+CA7D  uniCA7D,  HANGUL SYLLABLE-CA7D
        0xCA84, # G+2816  U+CA84  uniCA84,  HANGUL SYLLABLE-CA84
        0xCA98, # G+2817  U+CA98  uniCA98,  HANGUL SYLLABLE-CA98
        0xCABC, # G+2818  U+CABC  uniCABC,  HANGUL SYLLABLE-CABC
        0xCABD, # G+2819  U+CABD  uniCABD,  HANGUL SYLLABLE-CABD
        0xCAC0, # G+2820  U+CAC0  uniCAC0,  HANGUL SYLLABLE-CAC0
        0xCAC4, # G+2821  U+CAC4  uniCAC4,  HANGUL SYLLABLE-CAC4
        0xCACC, # G+2822  U+CACC  uniCACC,  HANGUL SYLLABLE-CACC
        0xCACD, # G+2823  U+CACD  uniCACD,  HANGUL SYLLABLE-CACD
        0xCACF, # G+2824  U+CACF  uniCACF,  HANGUL SYLLABLE-CACF
        0xCAD1, # G+2825  U+CAD1  uniCAD1,  HANGUL SYLLABLE-CAD1
        0xCAD3, # G+2826  U+CAD3  uniCAD3,  HANGUL SYLLABLE-CAD3
        0xCAD8, # G+2827  U+CAD8  uniCAD8,  HANGUL SYLLABLE-CAD8
        0xCAD9, # G+2828  U+CAD9  uniCAD9,  HANGUL SYLLABLE-CAD9
        0xCAE0, # G+2829  U+CAE0  uniCAE0,  HANGUL SYLLABLE-CAE0
        0xCAEC, # G+2830  U+CAEC  uniCAEC,  HANGUL SYLLABLE-CAEC
        0xCAF4, # G+2831  U+CAF4  uniCAF4,  HANGUL SYLLABLE-CAF4
        0xCB08, # G+2832  U+CB08  uniCB08,  HANGUL SYLLABLE-CB08
        0xCB10, # G+2833  U+CB10  uniCB10,  HANGUL SYLLABLE-CB10
        0xCB14, # G+2834  U+CB14  uniCB14,  HANGUL SYLLABLE-CB14
        0xCB18, # G+2835  U+CB18  uniCB18,  HANGUL SYLLABLE-CB18
        0xCB20, # G+2836  U+CB20  uniCB20,  HANGUL SYLLABLE-CB20
        0xCB21, # G+2837  U+CB21  uniCB21,  HANGUL SYLLABLE-CB21
        0xCB41, # G+2838  U+CB41  uniCB41,  HANGUL SYLLABLE-CB41
        0xCB48, # G+2839  U+CB48  uniCB48,  HANGUL SYLLABLE-CB48
        0xCB49, # G+2840  U+CB49  uniCB49,  HANGUL SYLLABLE-CB49
        0xCB4C, # G+2841  U+CB4C  uniCB4C,  HANGUL SYLLABLE-CB4C
        0xCB50, # G+2842  U+CB50  uniCB50,  HANGUL SYLLABLE-CB50
        0xCB58, # G+2843  U+CB58  uniCB58,  HANGUL SYLLABLE-CB58
        0xCB59, # G+2844  U+CB59  uniCB59,  HANGUL SYLLABLE-CB59
        0xCB5D, # G+2845  U+CB5D  uniCB5D,  HANGUL SYLLABLE-CB5D
        0xCB64, # G+2846  U+CB64  uniCB64,  HANGUL SYLLABLE-CB64
        0xCB78, # G+2847  U+CB78  uniCB78,  HANGUL SYLLABLE-CB78
        0xCB79, # G+2848  U+CB79  uniCB79,  HANGUL SYLLABLE-CB79
        0xCB9C, # G+2849  U+CB9C  uniCB9C,  HANGUL SYLLABLE-CB9C
        0xCBB8, # G+2850  U+CBB8  uniCBB8,  HANGUL SYLLABLE-CBB8
        0xCBD4, # G+2851  U+CBD4  uniCBD4,  HANGUL SYLLABLE-CBD4
        0xCBE4, # G+2852  U+CBE4  uniCBE4,  HANGUL SYLLABLE-CBE4
        0xCBE7, # G+2853  U+CBE7  uniCBE7,  HANGUL SYLLABLE-CBE7
        0xCBE9, # G+2854  U+CBE9  uniCBE9,  HANGUL SYLLABLE-CBE9
        0xCC0C, # G+2855  U+CC0C  uniCC0C,  HANGUL SYLLABLE-CC0C
        0xCC0D, # G+2856  U+CC0D  uniCC0D,  HANGUL SYLLABLE-CC0D
        0xCC10, # G+2857  U+CC10  uniCC10,  HANGUL SYLLABLE-CC10
        0xCC14, # G+2858  U+CC14  uniCC14,  HANGUL SYLLABLE-CC14
        0xCC1C, # G+2859  U+CC1C  uniCC1C,  HANGUL SYLLABLE-CC1C
        0xCC1D, # G+2860  U+CC1D  uniCC1D,  HANGUL SYLLABLE-CC1D
        0xCC21, # G+2861  U+CC21  uniCC21,  HANGUL SYLLABLE-CC21
        0xCC22, # G+2862  U+CC22  uniCC22,  HANGUL SYLLABLE-CC22
        0xCC27, # G+2863  U+CC27  uniCC27,  HANGUL SYLLABLE-CC27
        0xCC28, # G+2864  U+CC28  uniCC28,  HANGUL SYLLABLE-CC28
        0xCC29, # G+2865  U+CC29  uniCC29,  HANGUL SYLLABLE-CC29
        0xCC2C, # G+2866  U+CC2C  uniCC2C,  HANGUL SYLLABLE-CC2C
        0xCC2E, # G+2867  U+CC2E  uniCC2E,  HANGUL SYLLABLE-CC2E
        0xCC30, # G+2868  U+CC30  uniCC30,  HANGUL SYLLABLE-CC30
        0xCC38, # G+2869  U+CC38  uniCC38,  HANGUL SYLLABLE-CC38
        0xCC39, # G+2870  U+CC39  uniCC39,  HANGUL SYLLABLE-CC39
        0xCC3B, # G+2871  U+CC3B  uniCC3B,  HANGUL SYLLABLE-CC3B
        0xCC3C, # G+2872  U+CC3C  uniCC3C,  HANGUL SYLLABLE-CC3C
        0xCC3D, # G+2873  U+CC3D  uniCC3D,  HANGUL SYLLABLE-CC3D
        0xCC3E, # G+2874  U+CC3E  uniCC3E,  HANGUL SYLLABLE-CC3E
        0xCC44, # G+2875  U+CC44  uniCC44,  HANGUL SYLLABLE-CC44
        0xCC45, # G+2876  U+CC45  uniCC45,  HANGUL SYLLABLE-CC45
        0xCC48, # G+2877  U+CC48  uniCC48,  HANGUL SYLLABLE-CC48
        0xCC4C, # G+2878  U+CC4C  uniCC4C,  HANGUL SYLLABLE-CC4C
        0xCC54, # G+2879  U+CC54  uniCC54,  HANGUL SYLLABLE-CC54
        0xCC55, # G+2880  U+CC55  uniCC55,  HANGUL SYLLABLE-CC55
        0xCC57, # G+2881  U+CC57  uniCC57,  HANGUL SYLLABLE-CC57
        0xCC58, # G+2882  U+CC58  uniCC58,  HANGUL SYLLABLE-CC58
        0xCC59, # G+2883  U+CC59  uniCC59,  HANGUL SYLLABLE-CC59
        0xCC60, # G+2884  U+CC60  uniCC60,  HANGUL SYLLABLE-CC60
        0xCC64, # G+2885  U+CC64  uniCC64,  HANGUL SYLLABLE-CC64
        0xCC66, # G+2886  U+CC66  uniCC66,  HANGUL SYLLABLE-CC66
        0xCC68, # G+2887  U+CC68  uniCC68,  HANGUL SYLLABLE-CC68
        0xCC70, # G+2888  U+CC70  uniCC70,  HANGUL SYLLABLE-CC70
        0xCC75, # G+2889  U+CC75  uniCC75,  HANGUL SYLLABLE-CC75
        0xCC98, # G+2890  U+CC98  uniCC98,  HANGUL SYLLABLE-CC98
        0xCC99, # G+2891  U+CC99  uniCC99,  HANGUL SYLLABLE-CC99
        0xCC9C, # G+2892  U+CC9C  uniCC9C,  HANGUL SYLLABLE-CC9C
        0xCCA0, # G+2893  U+CCA0  uniCCA0,  HANGUL SYLLABLE-CCA0
        0xCCA8, # G+2894  U+CCA8  uniCCA8,  HANGUL SYLLABLE-CCA8
        0xCCA9, # G+2895  U+CCA9  uniCCA9,  HANGUL SYLLABLE-CCA9
        0xCCAB, # G+2896  U+CCAB  uniCCAB,  HANGUL SYLLABLE-CCAB
        0xCCAC, # G+2897  U+CCAC  uniCCAC,  HANGUL SYLLABLE-CCAC
        0xCCAD, # G+2898  U+CCAD  uniCCAD,  HANGUL SYLLABLE-CCAD
        0xCCB4, # G+2899  U+CCB4  uniCCB4,  HANGUL SYLLABLE-CCB4
        0xCCB5, # G+2900  U+CCB5  uniCCB5,  HANGUL SYLLABLE-CCB5
        0xCCB8, # G+2901  U+CCB8  uniCCB8,  HANGUL SYLLABLE-CCB8
        0xCCBC, # G+2902  U+CCBC  uniCCBC,  HANGUL SYLLABLE-CCBC
        0xCCC4, # G+2903  U+CCC4  uniCCC4,  HANGUL SYLLABLE-CCC4
        0xCCC5, # G+2904  U+CCC5  uniCCC5,  HANGUL SYLLABLE-CCC5
        0xCCC7, # G+2905  U+CCC7  uniCCC7,  HANGUL SYLLABLE-CCC7
        0xCCC9, # G+2906  U+CCC9  uniCCC9,  HANGUL SYLLABLE-CCC9
        0xCCD0, # G+2907  U+CCD0  uniCCD0,  HANGUL SYLLABLE-CCD0
        0xCCD4, # G+2908  U+CCD4  uniCCD4,  HANGUL SYLLABLE-CCD4
        0xCCE4, # G+2909  U+CCE4  uniCCE4,  HANGUL SYLLABLE-CCE4
        0xCCEC, # G+2910  U+CCEC  uniCCEC,  HANGUL SYLLABLE-CCEC
        0xCCF0, # G+2911  U+CCF0  uniCCF0,  HANGUL SYLLABLE-CCF0
        0xCD01, # G+2912  U+CD01  uniCD01,  HANGUL SYLLABLE-CD01
        0xCD08, # G+2913  U+CD08  uniCD08,  HANGUL SYLLABLE-CD08
        0xCD09, # G+2914  U+CD09  uniCD09,  HANGUL SYLLABLE-CD09
        0xCD0C, # G+2915  U+CD0C  uniCD0C,  HANGUL SYLLABLE-CD0C
        0xCD10, # G+2916  U+CD10  uniCD10,  HANGUL SYLLABLE-CD10
        0xCD18, # G+2917  U+CD18  uniCD18,  HANGUL SYLLABLE-CD18
        0xCD19, # G+2918  U+CD19  uniCD19,  HANGUL SYLLABLE-CD19
        0xCD1B, # G+2919  U+CD1B  uniCD1B,  HANGUL SYLLABLE-CD1B
        0xCD1D, # G+2920  U+CD1D  uniCD1D,  HANGUL SYLLABLE-CD1D
        0xCD24, # G+2921  U+CD24  uniCD24,  HANGUL SYLLABLE-CD24
        0xCD28, # G+2922  U+CD28  uniCD28,  HANGUL SYLLABLE-CD28
        0xCD2C, # G+2923  U+CD2C  uniCD2C,  HANGUL SYLLABLE-CD2C
        0xCD39, # G+2924  U+CD39  uniCD39,  HANGUL SYLLABLE-CD39
        0xCD5C, # G+2925  U+CD5C  uniCD5C,  HANGUL SYLLABLE-CD5C
        0xCD60, # G+2926  U+CD60  uniCD60,  HANGUL SYLLABLE-CD60
        0xCD64, # G+2927  U+CD64  uniCD64,  HANGUL SYLLABLE-CD64
        0xCD6C, # G+2928  U+CD6C  uniCD6C,  HANGUL SYLLABLE-CD6C
        0xCD6D, # G+2929  U+CD6D  uniCD6D,  HANGUL SYLLABLE-CD6D
        0xCD6F, # G+2930  U+CD6F  uniCD6F,  HANGUL SYLLABLE-CD6F
        0xCD71, # G+2931  U+CD71  uniCD71,  HANGUL SYLLABLE-CD71
        0xCD78, # G+2932  U+CD78  uniCD78,  HANGUL SYLLABLE-CD78
        0xCD88, # G+2933  U+CD88  uniCD88,  HANGUL SYLLABLE-CD88
        0xCD94, # G+2934  U+CD94  uniCD94,  HANGUL SYLLABLE-CD94
        0xCD95, # G+2935  U+CD95  uniCD95,  HANGUL SYLLABLE-CD95
        0xCD98, # G+2936  U+CD98  uniCD98,  HANGUL SYLLABLE-CD98
        0xCD9C, # G+2937  U+CD9C  uniCD9C,  HANGUL SYLLABLE-CD9C
        0xCDA4, # G+2938  U+CDA4  uniCDA4,  HANGUL SYLLABLE-CDA4
        0xCDA5, # G+2939  U+CDA5  uniCDA5,  HANGUL SYLLABLE-CDA5
        0xCDA7, # G+2940  U+CDA7  uniCDA7,  HANGUL SYLLABLE-CDA7
        0xCDA9, # G+2941  U+CDA9  uniCDA9,  HANGUL SYLLABLE-CDA9
        0xCDB0, # G+2942  U+CDB0  uniCDB0,  HANGUL SYLLABLE-CDB0
        0xCDC4, # G+2943  U+CDC4  uniCDC4,  HANGUL SYLLABLE-CDC4
        0xCDCC, # G+2944  U+CDCC  uniCDCC,  HANGUL SYLLABLE-CDCC
        0xCDD0, # G+2945  U+CDD0  uniCDD0,  HANGUL SYLLABLE-CDD0
        0xCDE8, # G+2946  U+CDE8  uniCDE8,  HANGUL SYLLABLE-CDE8
        0xCDEC, # G+2947  U+CDEC  uniCDEC,  HANGUL SYLLABLE-CDEC
        0xCDF0, # G+2948  U+CDF0  uniCDF0,  HANGUL SYLLABLE-CDF0
        0xCDF8, # G+2949  U+CDF8  uniCDF8,  HANGUL SYLLABLE-CDF8
        0xCDF9, # G+2950  U+CDF9  uniCDF9,  HANGUL SYLLABLE-CDF9
        0xCDFB, # G+2951  U+CDFB  uniCDFB,  HANGUL SYLLABLE-CDFB
        0xCDFD, # G+2952  U+CDFD  uniCDFD,  HANGUL SYLLABLE-CDFD
        0xCE04, # G+2953  U+CE04  uniCE04,  HANGUL SYLLABLE-CE04
        0xCE08, # G+2954  U+CE08  uniCE08,  HANGUL SYLLABLE-CE08
        0xCE0C, # G+2955  U+CE0C  uniCE0C,  HANGUL SYLLABLE-CE0C
        0xCE14, # G+2956  U+CE14  uniCE14,  HANGUL SYLLABLE-CE14
        0xCE19, # G+2957  U+CE19  uniCE19,  HANGUL SYLLABLE-CE19
        0xCE20, # G+2958  U+CE20  uniCE20,  HANGUL SYLLABLE-CE20
        0xCE21, # G+2959  U+CE21  uniCE21,  HANGUL SYLLABLE-CE21
        0xCE24, # G+2960  U+CE24  uniCE24,  HANGUL SYLLABLE-CE24
        0xCE28, # G+2961  U+CE28  uniCE28,  HANGUL SYLLABLE-CE28
        0xCE30, # G+2962  U+CE30  uniCE30,  HANGUL SYLLABLE-CE30
        0xCE31, # G+2963  U+CE31  uniCE31,  HANGUL SYLLABLE-CE31
        0xCE33, # G+2964  U+CE33  uniCE33,  HANGUL SYLLABLE-CE33
        0xCE35, # G+2965  U+CE35  uniCE35,  HANGUL SYLLABLE-CE35
        0xCE58, # G+2966  U+CE58  uniCE58,  HANGUL SYLLABLE-CE58
        0xCE59, # G+2967  U+CE59  uniCE59,  HANGUL SYLLABLE-CE59
        0xCE5C, # G+2968  U+CE5C  uniCE5C,  HANGUL SYLLABLE-CE5C
        0xCE5F, # G+2969  U+CE5F  uniCE5F,  HANGUL SYLLABLE-CE5F
        0xCE60, # G+2970  U+CE60  uniCE60,  HANGUL SYLLABLE-CE60
        0xCE61, # G+2971  U+CE61  uniCE61,  HANGUL SYLLABLE-CE61
        0xCE68, # G+2972  U+CE68  uniCE68,  HANGUL SYLLABLE-CE68
        0xCE69, # G+2973  U+CE69  uniCE69,  HANGUL SYLLABLE-CE69
        0xCE6B, # G+2974  U+CE6B  uniCE6B,  HANGUL SYLLABLE-CE6B
        0xCE6D, # G+2975  U+CE6D  uniCE6D,  HANGUL SYLLABLE-CE6D
        0xCE74, # G+2976  U+CE74  uniCE74,  HANGUL SYLLABLE-CE74
        0xCE75, # G+2977  U+CE75  uniCE75,  HANGUL SYLLABLE-CE75
        0xCE78, # G+2978  U+CE78  uniCE78,  HANGUL SYLLABLE-CE78
        0xCE7C, # G+2979  U+CE7C  uniCE7C,  HANGUL SYLLABLE-CE7C
        0xCE84, # G+2980  U+CE84  uniCE84,  HANGUL SYLLABLE-CE84
        0xCE85, # G+2981  U+CE85  uniCE85,  HANGUL SYLLABLE-CE85
        0xCE87, # G+2982  U+CE87  uniCE87,  HANGUL SYLLABLE-CE87
        0xCE89, # G+2983  U+CE89  uniCE89,  HANGUL SYLLABLE-CE89
        0xCE90, # G+2984  U+CE90  uniCE90,  HANGUL SYLLABLE-CE90
        0xCE91, # G+2985  U+CE91  uniCE91,  HANGUL SYLLABLE-CE91
        0xCE94, # G+2986  U+CE94  uniCE94,  HANGUL SYLLABLE-CE94
        0xCE98, # G+2987  U+CE98  uniCE98,  HANGUL SYLLABLE-CE98
        0xCEA0, # G+2988  U+CEA0  uniCEA0,  HANGUL SYLLABLE-CEA0
        0xCEA1, # G+2989  U+CEA1  uniCEA1,  HANGUL SYLLABLE-CEA1
        0xCEA3, # G+2990  U+CEA3  uniCEA3,  HANGUL SYLLABLE-CEA3
        0xCEA4, # G+2991  U+CEA4  uniCEA4,  HANGUL SYLLABLE-CEA4
        0xCEA5, # G+2992  U+CEA5  uniCEA5,  HANGUL SYLLABLE-CEA5
        0xCEAC, # G+2993  U+CEAC  uniCEAC,  HANGUL SYLLABLE-CEAC
        0xCEAD, # G+2994  U+CEAD  uniCEAD,  HANGUL SYLLABLE-CEAD
        0xCEC1, # G+2995  U+CEC1  uniCEC1,  HANGUL SYLLABLE-CEC1
        0xCEE4, # G+2996  U+CEE4  uniCEE4,  HANGUL SYLLABLE-CEE4
        0xCEE5, # G+2997  U+CEE5  uniCEE5,  HANGUL SYLLABLE-CEE5
        0xCEE8, # G+2998  U+CEE8  uniCEE8,  HANGUL SYLLABLE-CEE8
        0xCEEB, # G+2999  U+CEEB  uniCEEB,  HANGUL SYLLABLE-CEEB
        0xCEEC, # G+3000  U+CEEC  uniCEEC,  HANGUL SYLLABLE-CEEC
        0xCEF4, # G+3001  U+CEF4  uniCEF4,  HANGUL SYLLABLE-CEF4
        0xCEF5, # G+3002  U+CEF5  uniCEF5,  HANGUL SYLLABLE-CEF5
        0xCEF7, # G+3003  U+CEF7  uniCEF7,  HANGUL SYLLABLE-CEF7
        0xCEF8, # G+3004  U+CEF8  uniCEF8,  HANGUL SYLLABLE-CEF8
        0xCEF9, # G+3005  U+CEF9  uniCEF9,  HANGUL SYLLABLE-CEF9
        0xCF00, # G+3006  U+CF00  uniCF00,  HANGUL SYLLABLE-CF00
        0xCF01, # G+3007  U+CF01  uniCF01,  HANGUL SYLLABLE-CF01
        0xCF04, # G+3008  U+CF04  uniCF04,  HANGUL SYLLABLE-CF04
        0xCF08, # G+3009  U+CF08  uniCF08,  HANGUL SYLLABLE-CF08
        0xCF10, # G+3010  U+CF10  uniCF10,  HANGUL SYLLABLE-CF10
        0xCF11, # G+3011  U+CF11  uniCF11,  HANGUL SYLLABLE-CF11
        0xCF13, # G+3012  U+CF13  uniCF13,  HANGUL SYLLABLE-CF13
        0xCF15, # G+3013  U+CF15  uniCF15,  HANGUL SYLLABLE-CF15
        0xCF1C, # G+3014  U+CF1C  uniCF1C,  HANGUL SYLLABLE-CF1C
        0xCF20, # G+3015  U+CF20  uniCF20,  HANGUL SYLLABLE-CF20
        0xCF24, # G+3016  U+CF24  uniCF24,  HANGUL SYLLABLE-CF24
        0xCF2C, # G+3017  U+CF2C  uniCF2C,  HANGUL SYLLABLE-CF2C
        0xCF2D, # G+3018  U+CF2D  uniCF2D,  HANGUL SYLLABLE-CF2D
        0xCF2F, # G+3019  U+CF2F  uniCF2F,  HANGUL SYLLABLE-CF2F
        0xCF30, # G+3020  U+CF30  uniCF30,  HANGUL SYLLABLE-CF30
        0xCF31, # G+3021  U+CF31  uniCF31,  HANGUL SYLLABLE-CF31
        0xCF38, # G+3022  U+CF38  uniCF38,  HANGUL SYLLABLE-CF38
        0xCF54, # G+3023  U+CF54  uniCF54,  HANGUL SYLLABLE-CF54
        0xCF55, # G+3024  U+CF55  uniCF55,  HANGUL SYLLABLE-CF55
        0xCF58, # G+3025  U+CF58  uniCF58,  HANGUL SYLLABLE-CF58
        0xCF5C, # G+3026  U+CF5C  uniCF5C,  HANGUL SYLLABLE-CF5C
        0xCF64, # G+3027  U+CF64  uniCF64,  HANGUL SYLLABLE-CF64
        0xCF65, # G+3028  U+CF65  uniCF65,  HANGUL SYLLABLE-CF65
        0xCF67, # G+3029  U+CF67  uniCF67,  HANGUL SYLLABLE-CF67
        0xCF69, # G+3030  U+CF69  uniCF69,  HANGUL SYLLABLE-CF69
        0xCF70, # G+3031  U+CF70  uniCF70,  HANGUL SYLLABLE-CF70
        0xCF71, # G+3032  U+CF71  uniCF71,  HANGUL SYLLABLE-CF71
        0xCF74, # G+3033  U+CF74  uniCF74,  HANGUL SYLLABLE-CF74
        0xCF78, # G+3034  U+CF78  uniCF78,  HANGUL SYLLABLE-CF78
        0xCF80, # G+3035  U+CF80  uniCF80,  HANGUL SYLLABLE-CF80
        0xCF85, # G+3036  U+CF85  uniCF85,  HANGUL SYLLABLE-CF85
        0xCF8C, # G+3037  U+CF8C  uniCF8C,  HANGUL SYLLABLE-CF8C
        0xCFA1, # G+3038  U+CFA1  uniCFA1,  HANGUL SYLLABLE-CFA1
        0xCFA8, # G+3039  U+CFA8  uniCFA8,  HANGUL SYLLABLE-CFA8
        0xCFB0, # G+3040  U+CFB0  uniCFB0,  HANGUL SYLLABLE-CFB0
        0xCFC4, # G+3041  U+CFC4  uniCFC4,  HANGUL SYLLABLE-CFC4
        0xCFE0, # G+3042  U+CFE0  uniCFE0,  HANGUL SYLLABLE-CFE0
        0xCFE1, # G+3043  U+CFE1  uniCFE1,  HANGUL SYLLABLE-CFE1
        0xCFE4, # G+3044  U+CFE4  uniCFE4,  HANGUL SYLLABLE-CFE4
        0xCFE8, # G+3045  U+CFE8  uniCFE8,  HANGUL SYLLABLE-CFE8
        0xCFF0, # G+3046  U+CFF0  uniCFF0,  HANGUL SYLLABLE-CFF0
        0xCFF1, # G+3047  U+CFF1  uniCFF1,  HANGUL SYLLABLE-CFF1
        0xCFF3, # G+3048  U+CFF3  uniCFF3,  HANGUL SYLLABLE-CFF3
        0xCFF5, # G+3049  U+CFF5  uniCFF5,  HANGUL SYLLABLE-CFF5
        0xCFFC, # G+3050  U+CFFC  uniCFFC,  HANGUL SYLLABLE-CFFC
        0xD000, # G+3051  U+D000  uniD000,  HANGUL SYLLABLE-D000
        0xD004, # G+3052  U+D004  uniD004,  HANGUL SYLLABLE-D004
        0xD011, # G+3053  U+D011  uniD011,  HANGUL SYLLABLE-D011
        0xD018, # G+3054  U+D018  uniD018,  HANGUL SYLLABLE-D018
        0xD02D, # G+3055  U+D02D  uniD02D,  HANGUL SYLLABLE-D02D
        0xD034, # G+3056  U+D034  uniD034,  HANGUL SYLLABLE-D034
        0xD035, # G+3057  U+D035  uniD035,  HANGUL SYLLABLE-D035
        0xD038, # G+3058  U+D038  uniD038,  HANGUL SYLLABLE-D038
        0xD03C, # G+3059  U+D03C  uniD03C,  HANGUL SYLLABLE-D03C
        0xD044, # G+3060  U+D044  uniD044,  HANGUL SYLLABLE-D044
        0xD045, # G+3061  U+D045  uniD045,  HANGUL SYLLABLE-D045
        0xD047, # G+3062  U+D047  uniD047,  HANGUL SYLLABLE-D047
        0xD049, # G+3063  U+D049  uniD049,  HANGUL SYLLABLE-D049
        0xD050, # G+3064  U+D050  uniD050,  HANGUL SYLLABLE-D050
        0xD054, # G+3065  U+D054  uniD054,  HANGUL SYLLABLE-D054
        0xD058, # G+3066  U+D058  uniD058,  HANGUL SYLLABLE-D058
        0xD060, # G+3067  U+D060  uniD060,  HANGUL SYLLABLE-D060
        0xD06C, # G+3068  U+D06C  uniD06C,  HANGUL SYLLABLE-D06C
        0xD06D, # G+3069  U+D06D  uniD06D,  HANGUL SYLLABLE-D06D
        0xD070, # G+3070  U+D070  uniD070,  HANGUL SYLLABLE-D070
        0xD074, # G+3071  U+D074  uniD074,  HANGUL SYLLABLE-D074
        0xD07C, # G+3072  U+D07C  uniD07C,  HANGUL SYLLABLE-D07C
        0xD07D, # G+3073  U+D07D  uniD07D,  HANGUL SYLLABLE-D07D
        0xD081, # G+3074  U+D081  uniD081,  HANGUL SYLLABLE-D081
        0xD0A4, # G+3075  U+D0A4  uniD0A4,  HANGUL SYLLABLE-D0A4
        0xD0A5, # G+3076  U+D0A5  uniD0A5,  HANGUL SYLLABLE-D0A5
        0xD0A8, # G+3077  U+D0A8  uniD0A8,  HANGUL SYLLABLE-D0A8
        0xD0AC, # G+3078  U+D0AC  uniD0AC,  HANGUL SYLLABLE-D0AC
        0xD0B4, # G+3079  U+D0B4  uniD0B4,  HANGUL SYLLABLE-D0B4
        0xD0B5, # G+3080  U+D0B5  uniD0B5,  HANGUL SYLLABLE-D0B5
        0xD0B7, # G+3081  U+D0B7  uniD0B7,  HANGUL SYLLABLE-D0B7
        0xD0B9, # G+3082  U+D0B9  uniD0B9,  HANGUL SYLLABLE-D0B9
        0xD0C0, # G+3083  U+D0C0  uniD0C0,  HANGUL SYLLABLE-D0C0
        0xD0C1, # G+3084  U+D0C1  uniD0C1,  HANGUL SYLLABLE-D0C1
        0xD0C4, # G+3085  U+D0C4  uniD0C4,  HANGUL SYLLABLE-D0C4
        0xD0C8, # G+3086  U+D0C8  uniD0C8,  HANGUL SYLLABLE-D0C8
        0xD0C9, # G+3087  U+D0C9  uniD0C9,  HANGUL SYLLABLE-D0C9
        0xD0D0, # G+3088  U+D0D0  uniD0D0,  HANGUL SYLLABLE-D0D0
        0xD0D1, # G+3089  U+D0D1  uniD0D1,  HANGUL SYLLABLE-D0D1
        0xD0D3, # G+3090  U+D0D3  uniD0D3,  HANGUL SYLLABLE-D0D3
        0xD0D4, # G+3091  U+D0D4  uniD0D4,  HANGUL SYLLABLE-D0D4
        0xD0D5, # G+3092  U+D0D5  uniD0D5,  HANGUL SYLLABLE-D0D5
        0xD0DC, # G+3093  U+D0DC  uniD0DC,  HANGUL SYLLABLE-D0DC
        0xD0DD, # G+3094  U+D0DD  uniD0DD,  HANGUL SYLLABLE-D0DD
        0xD0E0, # G+3095  U+D0E0  uniD0E0,  HANGUL SYLLABLE-D0E0
        0xD0E4, # G+3096  U+D0E4  uniD0E4,  HANGUL SYLLABLE-D0E4
        0xD0EC, # G+3097  U+D0EC  uniD0EC,  HANGUL SYLLABLE-D0EC
        0xD0ED, # G+3098  U+D0ED  uniD0ED,  HANGUL SYLLABLE-D0ED
        0xD0EF, # G+3099  U+D0EF  uniD0EF,  HANGUL SYLLABLE-D0EF
        0xD0F0, # G+3100  U+D0F0  uniD0F0,  HANGUL SYLLABLE-D0F0
        0xD0F1, # G+3101  U+D0F1  uniD0F1,  HANGUL SYLLABLE-D0F1
        0xD0F8, # G+3102  U+D0F8  uniD0F8,  HANGUL SYLLABLE-D0F8
        0xD10D, # G+3103  U+D10D  uniD10D,  HANGUL SYLLABLE-D10D
        0xD130, # G+3104  U+D130  uniD130,  HANGUL SYLLABLE-D130
        0xD131, # G+3105  U+D131  uniD131,  HANGUL SYLLABLE-D131
        0xD134, # G+3106  U+D134  uniD134,  HANGUL SYLLABLE-D134
        0xD138, # G+3107  U+D138  uniD138,  HANGUL SYLLABLE-D138
        0xD13A, # G+3108  U+D13A  uniD13A,  HANGUL SYLLABLE-D13A
        0xD140, # G+3109  U+D140  uniD140,  HANGUL SYLLABLE-D140
        0xD141, # G+3110  U+D141  uniD141,  HANGUL SYLLABLE-D141
        0xD143, # G+3111  U+D143  uniD143,  HANGUL SYLLABLE-D143
        0xD144, # G+3112  U+D144  uniD144,  HANGUL SYLLABLE-D144
        0xD145, # G+3113  U+D145  uniD145,  HANGUL SYLLABLE-D145
        0xD14C, # G+3114  U+D14C  uniD14C,  HANGUL SYLLABLE-D14C
        0xD14D, # G+3115  U+D14D  uniD14D,  HANGUL SYLLABLE-D14D
        0xD150, # G+3116  U+D150  uniD150,  HANGUL SYLLABLE-D150
        0xD154, # G+3117  U+D154  uniD154,  HANGUL SYLLABLE-D154
        0xD15C, # G+3118  U+D15C  uniD15C,  HANGUL SYLLABLE-D15C
        0xD15D, # G+3119  U+D15D  uniD15D,  HANGUL SYLLABLE-D15D
        0xD15F, # G+3120  U+D15F  uniD15F,  HANGUL SYLLABLE-D15F
        0xD161, # G+3121  U+D161  uniD161,  HANGUL SYLLABLE-D161
        0xD168, # G+3122  U+D168  uniD168,  HANGUL SYLLABLE-D168
        0xD16C, # G+3123  U+D16C  uniD16C,  HANGUL SYLLABLE-D16C
        0xD17C, # G+3124  U+D17C  uniD17C,  HANGUL SYLLABLE-D17C
        0xD184, # G+3125  U+D184  uniD184,  HANGUL SYLLABLE-D184
        0xD188, # G+3126  U+D188  uniD188,  HANGUL SYLLABLE-D188
        0xD1A0, # G+3127  U+D1A0  uniD1A0,  HANGUL SYLLABLE-D1A0
        0xD1A1, # G+3128  U+D1A1  uniD1A1,  HANGUL SYLLABLE-D1A1
        0xD1A4, # G+3129  U+D1A4  uniD1A4,  HANGUL SYLLABLE-D1A4
        0xD1A8, # G+3130  U+D1A8  uniD1A8,  HANGUL SYLLABLE-D1A8
        0xD1B0, # G+3131  U+D1B0  uniD1B0,  HANGUL SYLLABLE-D1B0
        0xD1B1, # G+3132  U+D1B1  uniD1B1,  HANGUL SYLLABLE-D1B1
        0xD1B3, # G+3133  U+D1B3  uniD1B3,  HANGUL SYLLABLE-D1B3
        0xD1B5, # G+3134  U+D1B5  uniD1B5,  HANGUL SYLLABLE-D1B5
        0xD1BA, # G+3135  U+D1BA  uniD1BA,  HANGUL SYLLABLE-D1BA
        0xD1BC, # G+3136  U+D1BC  uniD1BC,  HANGUL SYLLABLE-D1BC
        0xD1C0, # G+3137  U+D1C0  uniD1C0,  HANGUL SYLLABLE-D1C0
        0xD1D8, # G+3138  U+D1D8  uniD1D8,  HANGUL SYLLABLE-D1D8
        0xD1F4, # G+3139  U+D1F4  uniD1F4,  HANGUL SYLLABLE-D1F4
        0xD1F8, # G+3140  U+D1F8  uniD1F8,  HANGUL SYLLABLE-D1F8
        0xD207, # G+3141  U+D207  uniD207,  HANGUL SYLLABLE-D207
        0xD209, # G+3142  U+D209  uniD209,  HANGUL SYLLABLE-D209
        0xD210, # G+3143  U+D210  uniD210,  HANGUL SYLLABLE-D210
        0xD22C, # G+3144  U+D22C  uniD22C,  HANGUL SYLLABLE-D22C
        0xD22D, # G+3145  U+D22D  uniD22D,  HANGUL SYLLABLE-D22D
        0xD230, # G+3146  U+D230  uniD230,  HANGUL SYLLABLE-D230
        0xD234, # G+3147  U+D234  uniD234,  HANGUL SYLLABLE-D234
        0xD23C, # G+3148  U+D23C  uniD23C,  HANGUL SYLLABLE-D23C
        0xD23D, # G+3149  U+D23D  uniD23D,  HANGUL SYLLABLE-D23D
        0xD23F, # G+3150  U+D23F  uniD23F,  HANGUL SYLLABLE-D23F
        0xD241, # G+3151  U+D241  uniD241,  HANGUL SYLLABLE-D241
        0xD248, # G+3152  U+D248  uniD248,  HANGUL SYLLABLE-D248
        0xD25C, # G+3153  U+D25C  uniD25C,  HANGUL SYLLABLE-D25C
        0xD264, # G+3154  U+D264  uniD264,  HANGUL SYLLABLE-D264
        0xD280, # G+3155  U+D280  uniD280,  HANGUL SYLLABLE-D280
        0xD281, # G+3156  U+D281  uniD281,  HANGUL SYLLABLE-D281
        0xD284, # G+3157  U+D284  uniD284,  HANGUL SYLLABLE-D284
        0xD288, # G+3158  U+D288  uniD288,  HANGUL SYLLABLE-D288
        0xD290, # G+3159  U+D290  uniD290,  HANGUL SYLLABLE-D290
        0xD291, # G+3160  U+D291  uniD291,  HANGUL SYLLABLE-D291
        0xD295, # G+3161  U+D295  uniD295,  HANGUL SYLLABLE-D295
        0xD29C, # G+3162  U+D29C  uniD29C,  HANGUL SYLLABLE-D29C
        0xD2A0, # G+3163  U+D2A0  uniD2A0,  HANGUL SYLLABLE-D2A0
        0xD2A4, # G+3164  U+D2A4  uniD2A4,  HANGUL SYLLABLE-D2A4
        0xD2AC, # G+3165  U+D2AC  uniD2AC,  HANGUL SYLLABLE-D2AC
        0xD2B1, # G+3166  U+D2B1  uniD2B1,  HANGUL SYLLABLE-D2B1
        0xD2B8, # G+3167  U+D2B8  uniD2B8,  HANGUL SYLLABLE-D2B8
        0xD2B9, # G+3168  U+D2B9  uniD2B9,  HANGUL SYLLABLE-D2B9
        0xD2BC, # G+3169  U+D2BC  uniD2BC,  HANGUL SYLLABLE-D2BC
        0xD2BF, # G+3170  U+D2BF  uniD2BF,  HANGUL SYLLABLE-D2BF
        0xD2C0, # G+3171  U+D2C0  uniD2C0,  HANGUL SYLLABLE-D2C0
        0xD2C2, # G+3172  U+D2C2  uniD2C2,  HANGUL SYLLABLE-D2C2
        0xD2C8, # G+3173  U+D2C8  uniD2C8,  HANGUL SYLLABLE-D2C8
        0xD2C9, # G+3174  U+D2C9  uniD2C9,  HANGUL SYLLABLE-D2C9
        0xD2CB, # G+3175  U+D2CB  uniD2CB,  HANGUL SYLLABLE-D2CB
        0xD2D4, # G+3176  U+D2D4  uniD2D4,  HANGUL SYLLABLE-D2D4
        0xD2D8, # G+3177  U+D2D8  uniD2D8,  HANGUL SYLLABLE-D2D8
        0xD2DC, # G+3178  U+D2DC  uniD2DC,  HANGUL SYLLABLE-D2DC
        0xD2E4, # G+3179  U+D2E4  uniD2E4,  HANGUL SYLLABLE-D2E4
        0xD2E5, # G+3180  U+D2E5  uniD2E5,  HANGUL SYLLABLE-D2E5
        0xD2F0, # G+3181  U+D2F0  uniD2F0,  HANGUL SYLLABLE-D2F0
        0xD2F1, # G+3182  U+D2F1  uniD2F1,  HANGUL SYLLABLE-D2F1
        0xD2F4, # G+3183  U+D2F4  uniD2F4,  HANGUL SYLLABLE-D2F4
        0xD2F8, # G+3184  U+D2F8  uniD2F8,  HANGUL SYLLABLE-D2F8
        0xD300, # G+3185  U+D300  uniD300,  HANGUL SYLLABLE-D300
        0xD301, # G+3186  U+D301  uniD301,  HANGUL SYLLABLE-D301
        0xD303, # G+3187  U+D303  uniD303,  HANGUL SYLLABLE-D303
        0xD305, # G+3188  U+D305  uniD305,  HANGUL SYLLABLE-D305
        0xD30C, # G+3189  U+D30C  uniD30C,  HANGUL SYLLABLE-D30C
        0xD30D, # G+3190  U+D30D  uniD30D,  HANGUL SYLLABLE-D30D
        0xD30E, # G+3191  U+D30E  uniD30E,  HANGUL SYLLABLE-D30E
        0xD310, # G+3192  U+D310  uniD310,  HANGUL SYLLABLE-D310
        0xD314, # G+3193  U+D314  uniD314,  HANGUL SYLLABLE-D314
        0xD316, # G+3194  U+D316  uniD316,  HANGUL SYLLABLE-D316
        0xD31C, # G+3195  U+D31C  uniD31C,  HANGUL SYLLABLE-D31C
        0xD31D, # G+3196  U+D31D  uniD31D,  HANGUL SYLLABLE-D31D
        0xD31F, # G+3197  U+D31F  uniD31F,  HANGUL SYLLABLE-D31F
        0xD320, # G+3198  U+D320  uniD320,  HANGUL SYLLABLE-D320
        0xD321, # G+3199  U+D321  uniD321,  HANGUL SYLLABLE-D321
        0xD325, # G+3200  U+D325  uniD325,  HANGUL SYLLABLE-D325
        0xD328, # G+3201  U+D328  uniD328,  HANGUL SYLLABLE-D328
        0xD329, # G+3202  U+D329  uniD329,  HANGUL SYLLABLE-D329
        0xD32C, # G+3203  U+D32C  uniD32C,  HANGUL SYLLABLE-D32C
        0xD330, # G+3204  U+D330  uniD330,  HANGUL SYLLABLE-D330
        0xD338, # G+3205  U+D338  uniD338,  HANGUL SYLLABLE-D338
        0xD339, # G+3206  U+D339  uniD339,  HANGUL SYLLABLE-D339
        0xD33B, # G+3207  U+D33B  uniD33B,  HANGUL SYLLABLE-D33B
        0xD33C, # G+3208  U+D33C  uniD33C,  HANGUL SYLLABLE-D33C
        0xD33D, # G+3209  U+D33D  uniD33D,  HANGUL SYLLABLE-D33D
        0xD344, # G+3210  U+D344  uniD344,  HANGUL SYLLABLE-D344
        0xD345, # G+3211  U+D345  uniD345,  HANGUL SYLLABLE-D345
        0xD37C, # G+3212  U+D37C  uniD37C,  HANGUL SYLLABLE-D37C
        0xD37D, # G+3213  U+D37D  uniD37D,  HANGUL SYLLABLE-D37D
        0xD380, # G+3214  U+D380  uniD380,  HANGUL SYLLABLE-D380
        0xD384, # G+3215  U+D384  uniD384,  HANGUL SYLLABLE-D384
        0xD38C, # G+3216  U+D38C  uniD38C,  HANGUL SYLLABLE-D38C
        0xD38D, # G+3217  U+D38D  uniD38D,  HANGUL SYLLABLE-D38D
        0xD38F, # G+3218  U+D38F  uniD38F,  HANGUL SYLLABLE-D38F
        0xD390, # G+3219  U+D390  uniD390,  HANGUL SYLLABLE-D390
        0xD391, # G+3220  U+D391  uniD391,  HANGUL SYLLABLE-D391
        0xD398, # G+3221  U+D398  uniD398,  HANGUL SYLLABLE-D398
        0xD399, # G+3222  U+D399  uniD399,  HANGUL SYLLABLE-D399
        0xD39C, # G+3223  U+D39C  uniD39C,  HANGUL SYLLABLE-D39C
        0xD3A0, # G+3224  U+D3A0  uniD3A0,  HANGUL SYLLABLE-D3A0
        0xD3A8, # G+3225  U+D3A8  uniD3A8,  HANGUL SYLLABLE-D3A8
        0xD3A9, # G+3226  U+D3A9  uniD3A9,  HANGUL SYLLABLE-D3A9
        0xD3AB, # G+3227  U+D3AB  uniD3AB,  HANGUL SYLLABLE-D3AB
        0xD3AD, # G+3228  U+D3AD  uniD3AD,  HANGUL SYLLABLE-D3AD
        0xD3B4, # G+3229  U+D3B4  uniD3B4,  HANGUL SYLLABLE-D3B4
        0xD3B8, # G+3230  U+D3B8  uniD3B8,  HANGUL SYLLABLE-D3B8
        0xD3BC, # G+3231  U+D3BC  uniD3BC,  HANGUL SYLLABLE-D3BC
        0xD3C4, # G+3232  U+D3C4  uniD3C4,  HANGUL SYLLABLE-D3C4
        0xD3C5, # G+3233  U+D3C5  uniD3C5,  HANGUL SYLLABLE-D3C5
        0xD3C8, # G+3234  U+D3C8  uniD3C8,  HANGUL SYLLABLE-D3C8
        0xD3C9, # G+3235  U+D3C9  uniD3C9,  HANGUL SYLLABLE-D3C9
        0xD3D0, # G+3236  U+D3D0  uniD3D0,  HANGUL SYLLABLE-D3D0
        0xD3D8, # G+3237  U+D3D8  uniD3D8,  HANGUL SYLLABLE-D3D8
        0xD3E1, # G+3238  U+D3E1  uniD3E1,  HANGUL SYLLABLE-D3E1
        0xD3E3, # G+3239  U+D3E3  uniD3E3,  HANGUL SYLLABLE-D3E3
        0xD3EC, # G+3240  U+D3EC  uniD3EC,  HANGUL SYLLABLE-D3EC
        0xD3ED, # G+3241  U+D3ED  uniD3ED,  HANGUL SYLLABLE-D3ED
        0xD3F0, # G+3242  U+D3F0  uniD3F0,  HANGUL SYLLABLE-D3F0
        0xD3F4, # G+3243  U+D3F4  uniD3F4,  HANGUL SYLLABLE-D3F4
        0xD3FC, # G+3244  U+D3FC  uniD3FC,  HANGUL SYLLABLE-D3FC
        0xD3FD, # G+3245  U+D3FD  uniD3FD,  HANGUL SYLLABLE-D3FD
        0xD3FF, # G+3246  U+D3FF  uniD3FF,  HANGUL SYLLABLE-D3FF
        0xD401, # G+3247  U+D401  uniD401,  HANGUL SYLLABLE-D401
        0xD408, # G+3248  U+D408  uniD408,  HANGUL SYLLABLE-D408
        0xD41D, # G+3249  U+D41D  uniD41D,  HANGUL SYLLABLE-D41D
        0xD440, # G+3250  U+D440  uniD440,  HANGUL SYLLABLE-D440
        0xD444, # G+3251  U+D444  uniD444,  HANGUL SYLLABLE-D444
        0xD45C, # G+3252  U+D45C  uniD45C,  HANGUL SYLLABLE-D45C
        0xD460, # G+3253  U+D460  uniD460,  HANGUL SYLLABLE-D460
        0xD464, # G+3254  U+D464  uniD464,  HANGUL SYLLABLE-D464
        0xD46D, # G+3255  U+D46D  uniD46D,  HANGUL SYLLABLE-D46D
        0xD46F, # G+3256  U+D46F  uniD46F,  HANGUL SYLLABLE-D46F
        0xD478, # G+3257  U+D478  uniD478,  HANGUL SYLLABLE-D478
        0xD479, # G+3258  U+D479  uniD479,  HANGUL SYLLABLE-D479
        0xD47C, # G+3259  U+D47C  uniD47C,  HANGUL SYLLABLE-D47C
        0xD47F, # G+3260  U+D47F  uniD47F,  HANGUL SYLLABLE-D47F
        0xD480, # G+3261  U+D480  uniD480,  HANGUL SYLLABLE-D480
        0xD482, # G+3262  U+D482  uniD482,  HANGUL SYLLABLE-D482
        0xD488, # G+3263  U+D488  uniD488,  HANGUL SYLLABLE-D488
        0xD489, # G+3264  U+D489  uniD489,  HANGUL SYLLABLE-D489
        0xD48B, # G+3265  U+D48B  uniD48B,  HANGUL SYLLABLE-D48B
        0xD48D, # G+3266  U+D48D  uniD48D,  HANGUL SYLLABLE-D48D
        0xD494, # G+3267  U+D494  uniD494,  HANGUL SYLLABLE-D494
        0xD4A9, # G+3268  U+D4A9  uniD4A9,  HANGUL SYLLABLE-D4A9
        0xD4CC, # G+3269  U+D4CC  uniD4CC,  HANGUL SYLLABLE-D4CC
        0xD4D0, # G+3270  U+D4D0  uniD4D0,  HANGUL SYLLABLE-D4D0
        0xD4D4, # G+3271  U+D4D4  uniD4D4,  HANGUL SYLLABLE-D4D4
        0xD4DC, # G+3272  U+D4DC  uniD4DC,  HANGUL SYLLABLE-D4DC
        0xD4DF, # G+3273  U+D4DF  uniD4DF,  HANGUL SYLLABLE-D4DF
        0xD4E8, # G+3274  U+D4E8  uniD4E8,  HANGUL SYLLABLE-D4E8
        0xD4EC, # G+3275  U+D4EC  uniD4EC,  HANGUL SYLLABLE-D4EC
        0xD4F0, # G+3276  U+D4F0  uniD4F0,  HANGUL SYLLABLE-D4F0
        0xD4F8, # G+3277  U+D4F8  uniD4F8,  HANGUL SYLLABLE-D4F8
        0xD4FB, # G+3278  U+D4FB  uniD4FB,  HANGUL SYLLABLE-D4FB
        0xD4FD, # G+3279  U+D4FD  uniD4FD,  HANGUL SYLLABLE-D4FD
        0xD504, # G+3280  U+D504  uniD504,  HANGUL SYLLABLE-D504
        0xD508, # G+3281  U+D508  uniD508,  HANGUL SYLLABLE-D508
        0xD50C, # G+3282  U+D50C  uniD50C,  HANGUL SYLLABLE-D50C
        0xD514, # G+3283  U+D514  uniD514,  HANGUL SYLLABLE-D514
        0xD515, # G+3284  U+D515  uniD515,  HANGUL SYLLABLE-D515
        0xD517, # G+3285  U+D517  uniD517,  HANGUL SYLLABLE-D517
        0xD53C, # G+3286  U+D53C  uniD53C,  HANGUL SYLLABLE-D53C
        0xD53D, # G+3287  U+D53D  uniD53D,  HANGUL SYLLABLE-D53D
        0xD540, # G+3288  U+D540  uniD540,  HANGUL SYLLABLE-D540
        0xD544, # G+3289  U+D544  uniD544,  HANGUL SYLLABLE-D544
        0xD54C, # G+3290  U+D54C  uniD54C,  HANGUL SYLLABLE-D54C
        0xD54D, # G+3291  U+D54D  uniD54D,  HANGUL SYLLABLE-D54D
        0xD54F, # G+3292  U+D54F  uniD54F,  HANGUL SYLLABLE-D54F
        0xD551, # G+3293  U+D551  uniD551,  HANGUL SYLLABLE-D551
        0xD558, # G+3294  U+D558  uniD558,  HANGUL SYLLABLE-D558
        0xD559, # G+3295  U+D559  uniD559,  HANGUL SYLLABLE-D559
        0xD55C, # G+3296  U+D55C  uniD55C,  HANGUL SYLLABLE-D55C
        0xD560, # G+3297  U+D560  uniD560,  HANGUL SYLLABLE-D560
        0xD565, # G+3298  U+D565  uniD565,  HANGUL SYLLABLE-D565
        0xD568, # G+3299  U+D568  uniD568,  HANGUL SYLLABLE-D568
        0xD569, # G+3300  U+D569  uniD569,  HANGUL SYLLABLE-D569
        0xD56B, # G+3301  U+D56B  uniD56B,  HANGUL SYLLABLE-D56B
        0xD56D, # G+3302  U+D56D  uniD56D,  HANGUL SYLLABLE-D56D
        0xD574, # G+3303  U+D574  uniD574,  HANGUL SYLLABLE-D574
        0xD575, # G+3304  U+D575  uniD575,  HANGUL SYLLABLE-D575
        0xD578, # G+3305  U+D578  uniD578,  HANGUL SYLLABLE-D578
        0xD57C, # G+3306  U+D57C  uniD57C,  HANGUL SYLLABLE-D57C
        0xD584, # G+3307  U+D584  uniD584,  HANGUL SYLLABLE-D584
        0xD585, # G+3308  U+D585  uniD585,  HANGUL SYLLABLE-D585
        0xD587, # G+3309  U+D587  uniD587,  HANGUL SYLLABLE-D587
        0xD588, # G+3310  U+D588  uniD588,  HANGUL SYLLABLE-D588
        0xD589, # G+3311  U+D589  uniD589,  HANGUL SYLLABLE-D589
        0xD590, # G+3312  U+D590  uniD590,  HANGUL SYLLABLE-D590
        0xD5A5, # G+3313  U+D5A5  uniD5A5,  HANGUL SYLLABLE-D5A5
        0xD5C8, # G+3314  U+D5C8  uniD5C8,  HANGUL SYLLABLE-D5C8
        0xD5C9, # G+3315  U+D5C9  uniD5C9,  HANGUL SYLLABLE-D5C9
        0xD5CC, # G+3316  U+D5CC  uniD5CC,  HANGUL SYLLABLE-D5CC
        0xD5D0, # G+3317  U+D5D0  uniD5D0,  HANGUL SYLLABLE-D5D0
        0xD5D2, # G+3318  U+D5D2  uniD5D2,  HANGUL SYLLABLE-D5D2
        0xD5D8, # G+3319  U+D5D8  uniD5D8,  HANGUL SYLLABLE-D5D8
        0xD5D9, # G+3320  U+D5D9  uniD5D9,  HANGUL SYLLABLE-D5D9
        0xD5DB, # G+3321  U+D5DB  uniD5DB,  HANGUL SYLLABLE-D5DB
        0xD5DD, # G+3322  U+D5DD  uniD5DD,  HANGUL SYLLABLE-D5DD
        0xD5E4, # G+3323  U+D5E4  uniD5E4,  HANGUL SYLLABLE-D5E4
        0xD5E5, # G+3324  U+D5E5  uniD5E5,  HANGUL SYLLABLE-D5E5
        0xD5E8, # G+3325  U+D5E8  uniD5E8,  HANGUL SYLLABLE-D5E8
        0xD5EC, # G+3326  U+D5EC  uniD5EC,  HANGUL SYLLABLE-D5EC
        0xD5F4, # G+3327  U+D5F4  uniD5F4,  HANGUL SYLLABLE-D5F4
        0xD5F5, # G+3328  U+D5F5  uniD5F5,  HANGUL SYLLABLE-D5F5
        0xD5F7, # G+3329  U+D5F7  uniD5F7,  HANGUL SYLLABLE-D5F7
        0xD5F9, # G+3330  U+D5F9  uniD5F9,  HANGUL SYLLABLE-D5F9
        0xD600, # G+3331  U+D600  uniD600,  HANGUL SYLLABLE-D600
        0xD601, # G+3332  U+D601  uniD601,  HANGUL SYLLABLE-D601
        0xD604, # G+3333  U+D604  uniD604,  HANGUL SYLLABLE-D604
        0xD608, # G+3334  U+D608  uniD608,  HANGUL SYLLABLE-D608
        0xD610, # G+3335  U+D610  uniD610,  HANGUL SYLLABLE-D610
        0xD611, # G+3336  U+D611  uniD611,  HANGUL SYLLABLE-D611
        0xD613, # G+3337  U+D613  uniD613,  HANGUL SYLLABLE-D613
        0xD614, # G+3338  U+D614  uniD614,  HANGUL SYLLABLE-D614
        0xD615, # G+3339  U+D615  uniD615,  HANGUL SYLLABLE-D615
        0xD61C, # G+3340  U+D61C  uniD61C,  HANGUL SYLLABLE-D61C
        0xD620, # G+3341  U+D620  uniD620,  HANGUL SYLLABLE-D620
        0xD624, # G+3342  U+D624  uniD624,  HANGUL SYLLABLE-D624
        0xD62D, # G+3343  U+D62D  uniD62D,  HANGUL SYLLABLE-D62D
        0xD638, # G+3344  U+D638  uniD638,  HANGUL SYLLABLE-D638
        0xD639, # G+3345  U+D639  uniD639,  HANGUL SYLLABLE-D639
        0xD63C, # G+3346  U+D63C  uniD63C,  HANGUL SYLLABLE-D63C
        0xD640, # G+3347  U+D640  uniD640,  HANGUL SYLLABLE-D640
        0xD645, # G+3348  U+D645  uniD645,  HANGUL SYLLABLE-D645
        0xD648, # G+3349  U+D648  uniD648,  HANGUL SYLLABLE-D648
        0xD649, # G+3350  U+D649  uniD649,  HANGUL SYLLABLE-D649
        0xD64B, # G+3351  U+D64B  uniD64B,  HANGUL SYLLABLE-D64B
        0xD64D, # G+3352  U+D64D  uniD64D,  HANGUL SYLLABLE-D64D
        0xD651, # G+3353  U+D651  uniD651,  HANGUL SYLLABLE-D651
        0xD654, # G+3354  U+D654  uniD654,  HANGUL SYLLABLE-D654
        0xD655, # G+3355  U+D655  uniD655,  HANGUL SYLLABLE-D655
        0xD658, # G+3356  U+D658  uniD658,  HANGUL SYLLABLE-D658
        0xD65C, # G+3357  U+D65C  uniD65C,  HANGUL SYLLABLE-D65C
        0xD667, # G+3358  U+D667  uniD667,  HANGUL SYLLABLE-D667
        0xD669, # G+3359  U+D669  uniD669,  HANGUL SYLLABLE-D669
        0xD670, # G+3360  U+D670  uniD670,  HANGUL SYLLABLE-D670
        0xD671, # G+3361  U+D671  uniD671,  HANGUL SYLLABLE-D671
        0xD674, # G+3362  U+D674  uniD674,  HANGUL SYLLABLE-D674
        0xD683, # G+3363  U+D683  uniD683,  HANGUL SYLLABLE-D683
        0xD685, # G+3364  U+D685  uniD685,  HANGUL SYLLABLE-D685
        0xD68C, # G+3365  U+D68C  uniD68C,  HANGUL SYLLABLE-D68C
        0xD68D, # G+3366  U+D68D  uniD68D,  HANGUL SYLLABLE-D68D
        0xD690, # G+3367  U+D690  uniD690,  HANGUL SYLLABLE-D690
        0xD694, # G+3368  U+D694  uniD694,  HANGUL SYLLABLE-D694
        0xD69D, # G+3369  U+D69D  uniD69D,  HANGUL SYLLABLE-D69D
        0xD69F, # G+3370  U+D69F  uniD69F,  HANGUL SYLLABLE-D69F
        0xD6A1, # G+3371  U+D6A1  uniD6A1,  HANGUL SYLLABLE-D6A1
        0xD6A8, # G+3372  U+D6A8  uniD6A8,  HANGUL SYLLABLE-D6A8
        0xD6AC, # G+3373  U+D6AC  uniD6AC,  HANGUL SYLLABLE-D6AC
        0xD6B0, # G+3374  U+D6B0  uniD6B0,  HANGUL SYLLABLE-D6B0
        0xD6B9, # G+3375  U+D6B9  uniD6B9,  HANGUL SYLLABLE-D6B9
        0xD6BB, # G+3376  U+D6BB  uniD6BB,  HANGUL SYLLABLE-D6BB
        0xD6C4, # G+3377  U+D6C4  uniD6C4,  HANGUL SYLLABLE-D6C4
        0xD6C5, # G+3378  U+D6C5  uniD6C5,  HANGUL SYLLABLE-D6C5
        0xD6C8, # G+3379  U+D6C8  uniD6C8,  HANGUL SYLLABLE-D6C8
        0xD6CC, # G+3380  U+D6CC  uniD6CC,  HANGUL SYLLABLE-D6CC
        0xD6D1, # G+3381  U+D6D1  uniD6D1,  HANGUL SYLLABLE-D6D1
        0xD6D4, # G+3382  U+D6D4  uniD6D4,  HANGUL SYLLABLE-D6D4
        0xD6D7, # G+3383  U+D6D7  uniD6D7,  HANGUL SYLLABLE-D6D7
        0xD6D9, # G+3384  U+D6D9  uniD6D9,  HANGUL SYLLABLE-D6D9
        0xD6E0, # G+3385  U+D6E0  uniD6E0,  HANGUL SYLLABLE-D6E0
        0xD6E4, # G+3386  U+D6E4  uniD6E4,  HANGUL SYLLABLE-D6E4
        0xD6E8, # G+3387  U+D6E8  uniD6E8,  HANGUL SYLLABLE-D6E8
        0xD6F0, # G+3388  U+D6F0  uniD6F0,  HANGUL SYLLABLE-D6F0
        0xD6F5, # G+3389  U+D6F5  uniD6F5,  HANGUL SYLLABLE-D6F5
        0xD6FC, # G+3390  U+D6FC  uniD6FC,  HANGUL SYLLABLE-D6FC
        0xD6FD, # G+3391  U+D6FD  uniD6FD,  HANGUL SYLLABLE-D6FD
        0xD700, # G+3392  U+D700  uniD700,  HANGUL SYLLABLE-D700
        0xD704, # G+3393  U+D704  uniD704,  HANGUL SYLLABLE-D704
        0xD711, # G+3394  U+D711  uniD711,  HANGUL SYLLABLE-D711
        0xD718, # G+3395  U+D718  uniD718,  HANGUL SYLLABLE-D718
        0xD719, # G+3396  U+D719  uniD719,  HANGUL SYLLABLE-D719
        0xD71C, # G+3397  U+D71C  uniD71C,  HANGUL SYLLABLE-D71C
        0xD720, # G+3398  U+D720  uniD720,  HANGUL SYLLABLE-D720
        0xD728, # G+3399  U+D728  uniD728,  HANGUL SYLLABLE-D728
        0xD729, # G+3400  U+D729  uniD729,  HANGUL SYLLABLE-D729
        0xD72B, # G+3401  U+D72B  uniD72B,  HANGUL SYLLABLE-D72B
        0xD72D, # G+3402  U+D72D  uniD72D,  HANGUL SYLLABLE-D72D
        0xD734, # G+3403  U+D734  uniD734,  HANGUL SYLLABLE-D734
        0xD735, # G+3404  U+D735  uniD735,  HANGUL SYLLABLE-D735
        0xD738, # G+3405  U+D738  uniD738,  HANGUL SYLLABLE-D738
        0xD73C, # G+3406  U+D73C  uniD73C,  HANGUL SYLLABLE-D73C
        0xD744, # G+3407  U+D744  uniD744,  HANGUL SYLLABLE-D744
        0xD747, # G+3408  U+D747  uniD747,  HANGUL SYLLABLE-D747
        0xD749, # G+3409  U+D749  uniD749,  HANGUL SYLLABLE-D749
        0xD750, # G+3410  U+D750  uniD750,  HANGUL SYLLABLE-D750
        0xD751, # G+3411  U+D751  uniD751,  HANGUL SYLLABLE-D751
        0xD754, # G+3412  U+D754  uniD754,  HANGUL SYLLABLE-D754
        0xD756, # G+3413  U+D756  uniD756,  HANGUL SYLLABLE-D756
        0xD757, # G+3414  U+D757  uniD757,  HANGUL SYLLABLE-D757
        0xD758, # G+3415  U+D758  uniD758,  HANGUL SYLLABLE-D758
        0xD759, # G+3416  U+D759  uniD759,  HANGUL SYLLABLE-D759
        0xD760, # G+3417  U+D760  uniD760,  HANGUL SYLLABLE-D760
        0xD761, # G+3418  U+D761  uniD761,  HANGUL SYLLABLE-D761
        0xD763, # G+3419  U+D763  uniD763,  HANGUL SYLLABLE-D763
        0xD765, # G+3420  U+D765  uniD765,  HANGUL SYLLABLE-D765
        0xD769, # G+3421  U+D769  uniD769,  HANGUL SYLLABLE-D769
        0xD76C, # G+3422  U+D76C  uniD76C,  HANGUL SYLLABLE-D76C
        0xD770, # G+3423  U+D770  uniD770,  HANGUL SYLLABLE-D770
        0xD774, # G+3424  U+D774  uniD774,  HANGUL SYLLABLE-D774
        0xD77C, # G+3425  U+D77C  uniD77C,  HANGUL SYLLABLE-D77C
        0xD77D, # G+3426  U+D77D  uniD77D,  HANGUL SYLLABLE-D77D
        0xD781, # G+3427  U+D781  uniD781,  HANGUL SYLLABLE-D781
        0xD788, # G+3428  U+D788  uniD788,  HANGUL SYLLABLE-D788
        0xD789, # G+3429  U+D789  uniD789,  HANGUL SYLLABLE-D789
        0xD78C, # G+3430  U+D78C  uniD78C,  HANGUL SYLLABLE-D78C
        0xD790, # G+3431  U+D790  uniD790,  HANGUL SYLLABLE-D790
        0xD798, # G+3432  U+D798  uniD798,  HANGUL SYLLABLE-D798
        0xD799, # G+3433  U+D799  uniD799,  HANGUL SYLLABLE-D799
        0xD79B, # G+3434  U+D79B  uniD79B,  HANGUL SYLLABLE-D79B
        0xD79D, # G+3435  U+D79D  uniD79D,  HANGUL SYLLABLE-D79D
        0x4F3D, # G+3436  U+4F3D  uni4F3D,  CJK UNIFIED IDEOGRAPH-4F3D
        0x4F73, # G+3437  U+4F73  uni4F73,  CJK UNIFIED IDEOGRAPH-4F73
        0x5047, # G+3438  U+5047  uni5047,  CJK UNIFIED IDEOGRAPH-5047
        0x50F9, # G+3439  U+50F9  uni50F9,  CJK UNIFIED IDEOGRAPH-50F9
        0x52A0, # G+3440  U+52A0  uni52A0,  CJK UNIFIED IDEOGRAPH-52A0
        0x53EF, # G+3441  U+53EF  uni53EF,  CJK UNIFIED IDEOGRAPH-53EF
        0x5475, # G+3442  U+5475  uni5475,  CJK UNIFIED IDEOGRAPH-5475
        0x54E5, # G+3443  U+54E5  uni54E5,  CJK UNIFIED IDEOGRAPH-54E5
        0x5609, # G+3444  U+5609  uni5609,  CJK UNIFIED IDEOGRAPH-5609
        0x5AC1, # G+3445  U+5AC1  uni5AC1,  CJK UNIFIED IDEOGRAPH-5AC1
        0x5BB6, # G+3446  U+5BB6  uni5BB6,  CJK UNIFIED IDEOGRAPH-5BB6
        0x6687, # G+3447  U+6687  uni6687,  CJK UNIFIED IDEOGRAPH-6687
        0x67B6, # G+3448  U+67B6  uni67B6,  CJK UNIFIED IDEOGRAPH-67B6
        0x67B7, # G+3449  U+67B7  uni67B7,  CJK UNIFIED IDEOGRAPH-67B7
        0x67EF, # G+3450  U+67EF  uni67EF,  CJK UNIFIED IDEOGRAPH-67EF
        0x6B4C, # G+3451  U+6B4C  uni6B4C,  CJK UNIFIED IDEOGRAPH-6B4C
        0x73C2, # G+3452  U+73C2  uni73C2,  CJK UNIFIED IDEOGRAPH-73C2
        0x75C2, # G+3453  U+75C2  uni75C2,  CJK UNIFIED IDEOGRAPH-75C2
        0x7A3C, # G+3454  U+7A3C  uni7A3C,  CJK UNIFIED IDEOGRAPH-7A3C
        0x82DB, # G+3455  U+82DB  uni82DB,  CJK UNIFIED IDEOGRAPH-82DB
        0x8304, # G+3456  U+8304  uni8304,  CJK UNIFIED IDEOGRAPH-8304
        0x8857, # G+3457  U+8857  uni8857,  CJK UNIFIED IDEOGRAPH-8857
        0x8888, # G+3458  U+8888  uni8888,  CJK UNIFIED IDEOGRAPH-8888
        0x8A36, # G+3459  U+8A36  uni8A36,  CJK UNIFIED IDEOGRAPH-8A36
        0x8CC8, # G+3460  U+8CC8  uni8CC8,  CJK UNIFIED IDEOGRAPH-8CC8
        0x8DCF, # G+3461  U+8DCF  uni8DCF,  CJK UNIFIED IDEOGRAPH-8DCF
        0x8EFB, # G+3462  U+8EFB  uni8EFB,  CJK UNIFIED IDEOGRAPH-8EFB
        0x8FE6, # G+3463  U+8FE6  uni8FE6,  CJK UNIFIED IDEOGRAPH-8FE6
        0x99D5, # G+3464  U+99D5  uni99D5,  CJK UNIFIED IDEOGRAPH-99D5
        0x523B, # G+3465  U+523B  uni523B,  CJK UNIFIED IDEOGRAPH-523B
        0x5374, # G+3466  U+5374  uni5374,  CJK UNIFIED IDEOGRAPH-5374
        0x5404, # G+3467  U+5404  uni5404,  CJK UNIFIED IDEOGRAPH-5404
        0x606A, # G+3468  U+606A  uni606A,  CJK UNIFIED IDEOGRAPH-606A
        0x6164, # G+3469  U+6164  uni6164,  CJK UNIFIED IDEOGRAPH-6164
        0x6BBC, # G+3470  U+6BBC  uni6BBC,  CJK UNIFIED IDEOGRAPH-6BBC
        0x73CF, # G+3471  U+73CF  uni73CF,  CJK UNIFIED IDEOGRAPH-73CF
        0x811A, # G+3472  U+811A  uni811A,  CJK UNIFIED IDEOGRAPH-811A
        0x89BA, # G+3473  U+89BA  uni89BA,  CJK UNIFIED IDEOGRAPH-89BA
        0x2F93, # G+3474  U+2F93  uni2F93,  KANGXI RADICAL HORN
        0x95A3, # G+3475  U+95A3  uni95A3,  CJK UNIFIED IDEOGRAPH-95A3
        0x4F83, # G+3476  U+4F83  uni4F83,  CJK UNIFIED IDEOGRAPH-4F83
        0x520A, # G+3477  U+520A  uni520A,  CJK UNIFIED IDEOGRAPH-520A
        0x58BE, # G+3478  U+58BE  uni58BE,  CJK UNIFIED IDEOGRAPH-58BE
        0x5978, # G+3479  U+5978  uni5978,  CJK UNIFIED IDEOGRAPH-5978
        0x59E6, # G+3480  U+59E6  uni59E6,  CJK UNIFIED IDEOGRAPH-59E6
        0x2F32, # G+3481  U+2F32  uni2F32,  KANGXI RADICAL DRY
        0x5E79, # G+3482  U+5E79  uni5E79,  CJK UNIFIED IDEOGRAPH-5E79
        0x61C7, # G+3483  U+61C7  uni61C7,  CJK UNIFIED IDEOGRAPH-61C7
        0x63C0, # G+3484  U+63C0  uni63C0,  CJK UNIFIED IDEOGRAPH-63C0
        0x6746, # G+3485  U+6746  uni6746,  CJK UNIFIED IDEOGRAPH-6746
        0x67EC, # G+3486  U+67EC  uni67EC,  CJK UNIFIED IDEOGRAPH-67EC
        0x687F, # G+3487  U+687F  uni687F,  CJK UNIFIED IDEOGRAPH-687F
        0x6F97, # G+3488  U+6F97  uni6F97,  CJK UNIFIED IDEOGRAPH-6F97
        0x764E, # G+3489  U+764E  uni764E,  CJK UNIFIED IDEOGRAPH-764E
        0x770B, # G+3490  U+770B  uni770B,  CJK UNIFIED IDEOGRAPH-770B
        0x78F5, # G+3491  U+78F5  uni78F5,  CJK UNIFIED IDEOGRAPH-78F5
        0x7A08, # G+3492  U+7A08  uni7A08,  CJK UNIFIED IDEOGRAPH-7A08
        0x7AFF, # G+3493  U+7AFF  uni7AFF,  CJK UNIFIED IDEOGRAPH-7AFF
        0x7C21, # G+3494  U+7C21  uni7C21,  CJK UNIFIED IDEOGRAPH-7C21
        0x809D, # G+3495  U+809D  uni809D,  CJK UNIFIED IDEOGRAPH-809D
        0x2F89, # G+3496  U+2F89  uni2F89,  KANGXI RADICAL STOPPING
        0x8271, # G+3497  U+8271  uni8271,  CJK UNIFIED IDEOGRAPH-8271
        0x8AEB, # G+3498  U+8AEB  uni8AEB,  CJK UNIFIED IDEOGRAPH-8AEB
        0x9593, # G+3499  U+9593  uni9593,  CJK UNIFIED IDEOGRAPH-9593
        0x4E6B, # G+3500  U+4E6B  uni4E6B,  CJK UNIFIED IDEOGRAPH-4E6B
        0x559D, # G+3501  U+559D  uni559D,  CJK UNIFIED IDEOGRAPH-559D
        0x66F7, # G+3502  U+66F7  uni66F7,  CJK UNIFIED IDEOGRAPH-66F7
        0x6E34, # G+3503  U+6E34  uni6E34,  CJK UNIFIED IDEOGRAPH-6E34
        0x78A3, # G+3504  U+78A3  uni78A3,  CJK UNIFIED IDEOGRAPH-78A3
        0x7AED, # G+3505  U+7AED  uni7AED,  CJK UNIFIED IDEOGRAPH-7AED
        0x845B, # G+3506  U+845B  uni845B,  CJK UNIFIED IDEOGRAPH-845B
        0x8910, # G+3507  U+8910  uni8910,  CJK UNIFIED IDEOGRAPH-8910
        0x874E, # G+3508  U+874E  uni874E,  CJK UNIFIED IDEOGRAPH-874E
        0x97A8, # G+3509  U+97A8  uni97A8,  CJK UNIFIED IDEOGRAPH-97A8
        0x52D8, # G+3510  U+52D8  uni52D8,  CJK UNIFIED IDEOGRAPH-52D8
        0x574E, # G+3511  U+574E  uni574E,  CJK UNIFIED IDEOGRAPH-574E
        0x582A, # G+3512  U+582A  uni582A,  CJK UNIFIED IDEOGRAPH-582A
        0x5D4C, # G+3513  U+5D4C  uni5D4C,  CJK UNIFIED IDEOGRAPH-5D4C
        0x611F, # G+3514  U+611F  uni611F,  CJK UNIFIED IDEOGRAPH-611F
        0x61BE, # G+3515  U+61BE  uni61BE,  CJK UNIFIED IDEOGRAPH-61BE
        0x6221, # G+3516  U+6221  uni6221,  CJK UNIFIED IDEOGRAPH-6221
        0x6562, # G+3517  U+6562  uni6562,  CJK UNIFIED IDEOGRAPH-6562
        0x67D1, # G+3518  U+67D1  uni67D1,  CJK UNIFIED IDEOGRAPH-67D1
        0x6A44, # G+3519  U+6A44  uni6A44,  CJK UNIFIED IDEOGRAPH-6A44
        0x6E1B, # G+3520  U+6E1B  uni6E1B,  CJK UNIFIED IDEOGRAPH-6E1B
        0x2F62, # G+3521  U+2F62  uni2F62,  KANGXI RADICAL SWEET
        0x75B3, # G+3522  U+75B3  uni75B3,  CJK UNIFIED IDEOGRAPH-75B3
        0x76E3, # G+3523  U+76E3  uni76E3,  CJK UNIFIED IDEOGRAPH-76E3
        0x77B0, # G+3524  U+77B0  uni77B0,  CJK UNIFIED IDEOGRAPH-77B0
        0x7D3A, # G+3525  U+7D3A  uni7D3A,  CJK UNIFIED IDEOGRAPH-7D3A
        0x90AF, # G+3526  U+90AF  uni90AF,  CJK UNIFIED IDEOGRAPH-90AF
        0x9451, # G+3527  U+9451  uni9451,  CJK UNIFIED IDEOGRAPH-9451
        0x9452, # G+3528  U+9452  uni9452,  CJK UNIFIED IDEOGRAPH-9452
        0x9F95, # G+3529  U+9F95  uni9F95,  CJK UNIFIED IDEOGRAPH-9F95
        0x5323, # G+3530  U+5323  uni5323,  CJK UNIFIED IDEOGRAPH-5323
        0x5CAC, # G+3531  U+5CAC  uni5CAC,  CJK UNIFIED IDEOGRAPH-5CAC
        0x7532, # G+3532  U+7532  uni7532,  CJK UNIFIED IDEOGRAPH-7532
        0x80DB, # G+3533  U+80DB  uni80DB,  CJK UNIFIED IDEOGRAPH-80DB
        0x9240, # G+3534  U+9240  uni9240,  CJK UNIFIED IDEOGRAPH-9240
        0x9598, # G+3535  U+9598  uni9598,  CJK UNIFIED IDEOGRAPH-9598
        0x525B, # G+3536  U+525B  uni525B,  CJK UNIFIED IDEOGRAPH-525B
        0x5808, # G+3537  U+5808  uni5808,  CJK UNIFIED IDEOGRAPH-5808
        0x59DC, # G+3538  U+59DC  uni59DC,  CJK UNIFIED IDEOGRAPH-59DC
        0x5CA1, # G+3539  U+5CA1  uni5CA1,  CJK UNIFIED IDEOGRAPH-5CA1
        0x5D17, # G+3540  U+5D17  uni5D17,  CJK UNIFIED IDEOGRAPH-5D17
        0x5EB7, # G+3541  U+5EB7  uni5EB7,  CJK UNIFIED IDEOGRAPH-5EB7
        0x5F3A, # G+3542  U+5F3A  uni5F3A,  CJK UNIFIED IDEOGRAPH-5F3A
        0x5F4A, # G+3543  U+5F4A  uni5F4A,  CJK UNIFIED IDEOGRAPH-5F4A
        0x6177, # G+3544  U+6177  uni6177,  CJK UNIFIED IDEOGRAPH-6177
        0x6C5F, # G+3545  U+6C5F  uni6C5F,  CJK UNIFIED IDEOGRAPH-6C5F
        0x757A, # G+3546  U+757A  uni757A,  CJK UNIFIED IDEOGRAPH-757A
        0x7586, # G+3547  U+7586  uni7586,  CJK UNIFIED IDEOGRAPH-7586
        0x7CE0, # G+3548  U+7CE0  uni7CE0,  CJK UNIFIED IDEOGRAPH-7CE0
        0x7D73, # G+3549  U+7D73  uni7D73,  CJK UNIFIED IDEOGRAPH-7D73
        0x7DB1, # G+3550  U+7DB1  uni7DB1,  CJK UNIFIED IDEOGRAPH-7DB1
        0x7F8C, # G+3551  U+7F8C  uni7F8C,  CJK UNIFIED IDEOGRAPH-7F8C
        0x8154, # G+3552  U+8154  uni8154,  CJK UNIFIED IDEOGRAPH-8154
        0x8221, # G+3553  U+8221  uni8221,  CJK UNIFIED IDEOGRAPH-8221
        0x8591, # G+3554  U+8591  uni8591,  CJK UNIFIED IDEOGRAPH-8591
        0x8941, # G+3555  U+8941  uni8941,  CJK UNIFIED IDEOGRAPH-8941
        0x8B1B, # G+3556  U+8B1B  uni8B1B,  CJK UNIFIED IDEOGRAPH-8B1B
        0x92FC, # G+3557  U+92FC  uni92FC,  CJK UNIFIED IDEOGRAPH-92FC
        0x964D, # G+3558  U+964D  uni964D,  CJK UNIFIED IDEOGRAPH-964D
        0x9C47, # G+3559  U+9C47  uni9C47,  CJK UNIFIED IDEOGRAPH-9C47
        0x4ECB, # G+3560  U+4ECB  uni4ECB,  CJK UNIFIED IDEOGRAPH-4ECB
        0x4EF7, # G+3561  U+4EF7  uni4EF7,  CJK UNIFIED IDEOGRAPH-4EF7
        0x500B, # G+3562  U+500B  uni500B,  CJK UNIFIED IDEOGRAPH-500B
        0x51F1, # G+3563  U+51F1  uni51F1,  CJK UNIFIED IDEOGRAPH-51F1
        0x584F, # G+3564  U+584F  uni584F,  CJK UNIFIED IDEOGRAPH-584F
        0x6137, # G+3565  U+6137  uni6137,  CJK UNIFIED IDEOGRAPH-6137
        0x613E, # G+3566  U+613E  uni613E,  CJK UNIFIED IDEOGRAPH-613E
        0x6168, # G+3567  U+6168  uni6168,  CJK UNIFIED IDEOGRAPH-6168
        0x6539, # G+3568  U+6539  uni6539,  CJK UNIFIED IDEOGRAPH-6539
        0x69EA, # G+3569  U+69EA  uni69EA,  CJK UNIFIED IDEOGRAPH-69EA
        0x6F11, # G+3570  U+6F11  uni6F11,  CJK UNIFIED IDEOGRAPH-6F11
        0x75A5, # G+3571  U+75A5  uni75A5,  CJK UNIFIED IDEOGRAPH-75A5
        0x7686, # G+3572  U+7686  uni7686,  CJK UNIFIED IDEOGRAPH-7686
        0x76D6, # G+3573  U+76D6  uni76D6,  CJK UNIFIED IDEOGRAPH-76D6
        0x7B87, # G+3574  U+7B87  uni7B87,  CJK UNIFIED IDEOGRAPH-7B87
        0x82A5, # G+3575  U+82A5  uni82A5,  CJK UNIFIED IDEOGRAPH-82A5
        0x84CB, # G+3576  U+84CB  uni84CB,  CJK UNIFIED IDEOGRAPH-84CB
        0x93A7, # G+3577  U+93A7  uni93A7,  CJK UNIFIED IDEOGRAPH-93A7
        0x958B, # G+3578  U+958B  uni958B,  CJK UNIFIED IDEOGRAPH-958B
        0x5580, # G+3579  U+5580  uni5580,  CJK UNIFIED IDEOGRAPH-5580
        0x5BA2, # G+3580  U+5BA2  uni5BA2,  CJK UNIFIED IDEOGRAPH-5BA2
        0x5751, # G+3581  U+5751  uni5751,  CJK UNIFIED IDEOGRAPH-5751
        0x7CB3, # G+3582  U+7CB3  uni7CB3,  CJK UNIFIED IDEOGRAPH-7CB3
        0x7FB9, # G+3583  U+7FB9  uni7FB9,  CJK UNIFIED IDEOGRAPH-7FB9
        0x91B5, # G+3584  U+91B5  uni91B5,  CJK UNIFIED IDEOGRAPH-91B5
        0x5028, # G+3585  U+5028  uni5028,  CJK UNIFIED IDEOGRAPH-5028
        0x53BB, # G+3586  U+53BB  uni53BB,  CJK UNIFIED IDEOGRAPH-53BB
        0x5C45, # G+3587  U+5C45  uni5C45,  CJK UNIFIED IDEOGRAPH-5C45
        0x5DE8, # G+3588  U+5DE8  uni5DE8,  CJK UNIFIED IDEOGRAPH-5DE8
        0x62D2, # G+3589  U+62D2  uni62D2,  CJK UNIFIED IDEOGRAPH-62D2
        0x636E, # G+3590  U+636E  uni636E,  CJK UNIFIED IDEOGRAPH-636E
        0x64DA, # G+3591  U+64DA  uni64DA,  CJK UNIFIED IDEOGRAPH-64DA
        0x64E7, # G+3592  U+64E7  uni64E7,  CJK UNIFIED IDEOGRAPH-64E7
        0x6E20, # G+3593  U+6E20  uni6E20,  CJK UNIFIED IDEOGRAPH-6E20
        0x70AC, # G+3594  U+70AC  uni70AC,  CJK UNIFIED IDEOGRAPH-70AC
        0x795B, # G+3595  U+795B  uni795B,  CJK UNIFIED IDEOGRAPH-795B
        0x8DDD, # G+3596  U+8DDD  uni8DDD,  CJK UNIFIED IDEOGRAPH-8DDD
        0x8E1E, # G+3597  U+8E1E  uni8E1E,  CJK UNIFIED IDEOGRAPH-8E1E
        0x907D, # G+3598  U+907D  uni907D,  CJK UNIFIED IDEOGRAPH-907D
        0x9245, # G+3599  U+9245  uni9245,  CJK UNIFIED IDEOGRAPH-9245
        0x92F8, # G+3600  U+92F8  uni92F8,  CJK UNIFIED IDEOGRAPH-92F8
        0x4E7E, # G+3601  U+4E7E  uni4E7E,  CJK UNIFIED IDEOGRAPH-4E7E
        0x4EF6, # G+3602  U+4EF6  uni4EF6,  CJK UNIFIED IDEOGRAPH-4EF6
        0x5065, # G+3603  U+5065  uni5065,  CJK UNIFIED IDEOGRAPH-5065
        0x2F31, # G+3604  U+2F31  uni2F31,  KANGXI RADICAL TURBAN
        0x5EFA, # G+3605  U+5EFA  uni5EFA,  CJK UNIFIED IDEOGRAPH-5EFA
        0x6106, # G+3606  U+6106  uni6106,  CJK UNIFIED IDEOGRAPH-6106
        0x6957, # G+3607  U+6957  uni6957,  CJK UNIFIED IDEOGRAPH-6957
        0x8171, # G+3608  U+8171  uni8171,  CJK UNIFIED IDEOGRAPH-8171
        0x8654, # G+3609  U+8654  uni8654,  CJK UNIFIED IDEOGRAPH-8654
        0x8E47, # G+3610  U+8E47  uni8E47,  CJK UNIFIED IDEOGRAPH-8E47
        0x9375, # G+3611  U+9375  uni9375,  CJK UNIFIED IDEOGRAPH-9375
        0x9A2B, # G+3612  U+9A2B  uni9A2B,  CJK UNIFIED IDEOGRAPH-9A2B
        0x4E5E, # G+3613  U+4E5E  uni4E5E,  CJK UNIFIED IDEOGRAPH-4E5E
        0x5091, # G+3614  U+5091  uni5091,  CJK UNIFIED IDEOGRAPH-5091
        0x6770, # G+3615  U+6770  uni6770,  CJK UNIFIED IDEOGRAPH-6770
        0x6840, # G+3616  U+6840  uni6840,  CJK UNIFIED IDEOGRAPH-6840
        0x5109, # G+3617  U+5109  uni5109,  CJK UNIFIED IDEOGRAPH-5109
        0x528D, # G+3618  U+528D  uni528D,  CJK UNIFIED IDEOGRAPH-528D
        0x5292, # G+3619  U+5292  uni5292,  CJK UNIFIED IDEOGRAPH-5292
        0x6AA2, # G+3620  U+6AA2  uni6AA2,  CJK UNIFIED IDEOGRAPH-6AA2
        0x77BC, # G+3621  U+77BC  uni77BC,  CJK UNIFIED IDEOGRAPH-77BC
        0x9210, # G+3622  U+9210  uni9210,  CJK UNIFIED IDEOGRAPH-9210
        0x9ED4, # G+3623  U+9ED4  uni9ED4,  CJK UNIFIED IDEOGRAPH-9ED4
        0x52AB, # G+3624  U+52AB  uni52AB,  CJK UNIFIED IDEOGRAPH-52AB
        0x602F, # G+3625  U+602F  uni602F,  CJK UNIFIED IDEOGRAPH-602F
        0x8FF2, # G+3626  U+8FF2  uni8FF2,  CJK UNIFIED IDEOGRAPH-8FF2
        0x5048, # G+3627  U+5048  uni5048,  CJK UNIFIED IDEOGRAPH-5048
        0x61A9, # G+3628  U+61A9  uni61A9,  CJK UNIFIED IDEOGRAPH-61A9
        0x63ED, # G+3629  U+63ED  uni63ED,  CJK UNIFIED IDEOGRAPH-63ED
        0x64CA, # G+3630  U+64CA  uni64CA,  CJK UNIFIED IDEOGRAPH-64CA
        0x683C, # G+3631  U+683C  uni683C,  CJK UNIFIED IDEOGRAPH-683C
        0x6A84, # G+3632  U+6A84  uni6A84,  CJK UNIFIED IDEOGRAPH-6A84
        0x6FC0, # G+3633  U+6FC0  uni6FC0,  CJK UNIFIED IDEOGRAPH-6FC0
        0x8188, # G+3634  U+8188  uni8188,  CJK UNIFIED IDEOGRAPH-8188
        0x89A1, # G+3635  U+89A1  uni89A1,  CJK UNIFIED IDEOGRAPH-89A1
        0x9694, # G+3636  U+9694  uni9694,  CJK UNIFIED IDEOGRAPH-9694
        0x5805, # G+3637  U+5805  uni5805,  CJK UNIFIED IDEOGRAPH-5805
        0x727D, # G+3638  U+727D  uni727D,  CJK UNIFIED IDEOGRAPH-727D
        0x2F5D, # G+3639  U+2F5D  uni2F5D,  KANGXI RADICAL DOG
        0x7504, # G+3640  U+7504  uni7504,  CJK UNIFIED IDEOGRAPH-7504
        0x7D79, # G+3641  U+7D79  uni7D79,  CJK UNIFIED IDEOGRAPH-7D79
        0x7E6D, # G+3642  U+7E6D  uni7E6D,  CJK UNIFIED IDEOGRAPH-7E6D
        0x80A9, # G+3643  U+80A9  uni80A9,  CJK UNIFIED IDEOGRAPH-80A9
        0x2F92, # G+3644  U+2F92  uni2F92,  KANGXI RADICAL SEE
        0x8B74, # G+3645  U+8B74  uni8B74,  CJK UNIFIED IDEOGRAPH-8B74
        0x9063, # G+3646  U+9063  uni9063,  CJK UNIFIED IDEOGRAPH-9063
        0x9D51, # G+3647  U+9D51  uni9D51,  CJK UNIFIED IDEOGRAPH-9D51
        0x6289, # G+3648  U+6289  uni6289,  CJK UNIFIED IDEOGRAPH-6289
        0x6C7A, # G+3649  U+6C7A  uni6C7A,  CJK UNIFIED IDEOGRAPH-6C7A
        0x6F54, # G+3650  U+6F54  uni6F54,  CJK UNIFIED IDEOGRAPH-6F54
        0x7D50, # G+3651  U+7D50  uni7D50,  CJK UNIFIED IDEOGRAPH-7D50
        0x7F3A, # G+3652  U+7F3A  uni7F3A,  CJK UNIFIED IDEOGRAPH-7F3A
        0x8A23, # G+3653  U+8A23  uni8A23,  CJK UNIFIED IDEOGRAPH-8A23
        0x517C, # G+3654  U+517C  uni517C,  CJK UNIFIED IDEOGRAPH-517C
        0x614A, # G+3655  U+614A  uni614A,  CJK UNIFIED IDEOGRAPH-614A
        0x7B9D, # G+3656  U+7B9D  uni7B9D,  CJK UNIFIED IDEOGRAPH-7B9D
        0x8B19, # G+3657  U+8B19  uni8B19,  CJK UNIFIED IDEOGRAPH-8B19
        0x9257, # G+3658  U+9257  uni9257,  CJK UNIFIED IDEOGRAPH-9257
        0x938C, # G+3659  U+938C  uni938C,  CJK UNIFIED IDEOGRAPH-938C
        0x4EAC, # G+3660  U+4EAC  uni4EAC,  CJK UNIFIED IDEOGRAPH-4EAC
        0x4FD3, # G+3661  U+4FD3  uni4FD3,  CJK UNIFIED IDEOGRAPH-4FD3
        0x501E, # G+3662  U+501E  uni501E,  CJK UNIFIED IDEOGRAPH-501E
        0x50BE, # G+3663  U+50BE  uni50BE,  CJK UNIFIED IDEOGRAPH-50BE
        0x5106, # G+3664  U+5106  uni5106,  CJK UNIFIED IDEOGRAPH-5106
        0x52C1, # G+3665  U+52C1  uni52C1,  CJK UNIFIED IDEOGRAPH-52C1
        0x52CD, # G+3666  U+52CD  uni52CD,  CJK UNIFIED IDEOGRAPH-52CD
        0x537F, # G+3667  U+537F  uni537F,  CJK UNIFIED IDEOGRAPH-537F
        0x5770, # G+3668  U+5770  uni5770,  CJK UNIFIED IDEOGRAPH-5770
        0x5883, # G+3669  U+5883  uni5883,  CJK UNIFIED IDEOGRAPH-5883
        0x5E9A, # G+3670  U+5E9A  uni5E9A,  CJK UNIFIED IDEOGRAPH-5E9A
        0x5F91, # G+3671  U+5F91  uni5F91,  CJK UNIFIED IDEOGRAPH-5F91
        0x6176, # G+3672  U+6176  uni6176,  CJK UNIFIED IDEOGRAPH-6176
        0x61AC, # G+3673  U+61AC  uni61AC,  CJK UNIFIED IDEOGRAPH-61AC
        0x64CE, # G+3674  U+64CE  uni64CE,  CJK UNIFIED IDEOGRAPH-64CE
        0x656C, # G+3675  U+656C  uni656C,  CJK UNIFIED IDEOGRAPH-656C
        0x666F, # G+3676  U+666F  uni666F,  CJK UNIFIED IDEOGRAPH-666F
        0x66BB, # G+3677  U+66BB  uni66BB,  CJK UNIFIED IDEOGRAPH-66BB
        0x66F4, # G+3678  U+66F4  uni66F4,  CJK UNIFIED IDEOGRAPH-66F4
        0x6897, # G+3679  U+6897  uni6897,  CJK UNIFIED IDEOGRAPH-6897
        0x6D87, # G+3680  U+6D87  uni6D87,  CJK UNIFIED IDEOGRAPH-6D87
        0x7085, # G+3681  U+7085  uni7085,  CJK UNIFIED IDEOGRAPH-7085
        0x70F1, # G+3682  U+70F1  uni70F1,  CJK UNIFIED IDEOGRAPH-70F1
        0x749F, # G+3683  U+749F  uni749F,  CJK UNIFIED IDEOGRAPH-749F
        0x74A5, # G+3684  U+74A5  uni74A5,  CJK UNIFIED IDEOGRAPH-74A5
        0x74CA, # G+3685  U+74CA  uni74CA,  CJK UNIFIED IDEOGRAPH-74CA
        0x75D9, # G+3686  U+75D9  uni75D9,  CJK UNIFIED IDEOGRAPH-75D9
        0x786C, # G+3687  U+786C  uni786C,  CJK UNIFIED IDEOGRAPH-786C
        0x78EC, # G+3688  U+78EC  uni78EC,  CJK UNIFIED IDEOGRAPH-78EC
        0x7ADF, # G+3689  U+7ADF  uni7ADF,  CJK UNIFIED IDEOGRAPH-7ADF
        0x7AF6, # G+3690  U+7AF6  uni7AF6,  CJK UNIFIED IDEOGRAPH-7AF6
        0x7D45, # G+3691  U+7D45  uni7D45,  CJK UNIFIED IDEOGRAPH-7D45
        0x7D93, # G+3692  U+7D93  uni7D93,  CJK UNIFIED IDEOGRAPH-7D93
        0x8015, # G+3693  U+8015  uni8015,  CJK UNIFIED IDEOGRAPH-8015
        0x803F, # G+3694  U+803F  uni803F,  CJK UNIFIED IDEOGRAPH-803F
        0x811B, # G+3695  U+811B  uni811B,  CJK UNIFIED IDEOGRAPH-811B
        0x8396, # G+3696  U+8396  uni8396,  CJK UNIFIED IDEOGRAPH-8396
        0x8B66, # G+3697  U+8B66  uni8B66,  CJK UNIFIED IDEOGRAPH-8B66
        0x8F15, # G+3698  U+8F15  uni8F15,  CJK UNIFIED IDEOGRAPH-8F15
        0x9015, # G+3699  U+9015  uni9015,  CJK UNIFIED IDEOGRAPH-9015
        0x93E1, # G+3700  U+93E1  uni93E1,  CJK UNIFIED IDEOGRAPH-93E1
        0x9803, # G+3701  U+9803  uni9803,  CJK UNIFIED IDEOGRAPH-9803
        0x9838, # G+3702  U+9838  uni9838,  CJK UNIFIED IDEOGRAPH-9838
        0x9A5A, # G+3703  U+9A5A  uni9A5A,  CJK UNIFIED IDEOGRAPH-9A5A
        0x9BE8, # G+3704  U+9BE8  uni9BE8,  CJK UNIFIED IDEOGRAPH-9BE8
        0x4FC2, # G+3705  U+4FC2  uni4FC2,  CJK UNIFIED IDEOGRAPH-4FC2
        0x5553, # G+3706  U+5553  uni5553,  CJK UNIFIED IDEOGRAPH-5553
        0x583A, # G+3707  U+583A  uni583A,  CJK UNIFIED IDEOGRAPH-583A
        0x5951, # G+3708  U+5951  uni5951,  CJK UNIFIED IDEOGRAPH-5951
        0x5B63, # G+3709  U+5B63  uni5B63,  CJK UNIFIED IDEOGRAPH-5B63
        0x5C46, # G+3710  U+5C46  uni5C46,  CJK UNIFIED IDEOGRAPH-5C46
        0x60B8, # G+3711  U+60B8  uni60B8,  CJK UNIFIED IDEOGRAPH-60B8
        0x6212, # G+3712  U+6212  uni6212,  CJK UNIFIED IDEOGRAPH-6212
        0x6842, # G+3713  U+6842  uni6842,  CJK UNIFIED IDEOGRAPH-6842
        0x68B0, # G+3714  U+68B0  uni68B0,  CJK UNIFIED IDEOGRAPH-68B0
        0x68E8, # G+3715  U+68E8  uni68E8,  CJK UNIFIED IDEOGRAPH-68E8
        0x6EAA, # G+3716  U+6EAA  uni6EAA,  CJK UNIFIED IDEOGRAPH-6EAA
        0x754C, # G+3717  U+754C  uni754C,  CJK UNIFIED IDEOGRAPH-754C
        0x7678, # G+3718  U+7678  uni7678,  CJK UNIFIED IDEOGRAPH-7678
        0x78CE, # G+3719  U+78CE  uni78CE,  CJK UNIFIED IDEOGRAPH-78CE
        0x7A3D, # G+3720  U+7A3D  uni7A3D,  CJK UNIFIED IDEOGRAPH-7A3D
        0x7CFB, # G+3721  U+7CFB  uni7CFB,  CJK UNIFIED IDEOGRAPH-7CFB
        0x7E6B, # G+3722  U+7E6B  uni7E6B,  CJK UNIFIED IDEOGRAPH-7E6B
        0x7E7C, # G+3723  U+7E7C  uni7E7C,  CJK UNIFIED IDEOGRAPH-7E7C
        0x8A08, # G+3724  U+8A08  uni8A08,  CJK UNIFIED IDEOGRAPH-8A08
        0x8AA1, # G+3725  U+8AA1  uni8AA1,  CJK UNIFIED IDEOGRAPH-8AA1
        0x8C3F, # G+3726  U+8C3F  uni8C3F,  CJK UNIFIED IDEOGRAPH-8C3F
        0x968E, # G+3727  U+968E  uni968E,  CJK UNIFIED IDEOGRAPH-968E
        0x9DC4, # G+3728  U+9DC4  uni9DC4,  CJK UNIFIED IDEOGRAPH-9DC4
        0x53E4, # G+3729  U+53E4  uni53E4,  CJK UNIFIED IDEOGRAPH-53E4
        0x53E9, # G+3730  U+53E9  uni53E9,  CJK UNIFIED IDEOGRAPH-53E9
        0x544A, # G+3731  U+544A  uni544A,  CJK UNIFIED IDEOGRAPH-544A
        0x5471, # G+3732  U+5471  uni5471,  CJK UNIFIED IDEOGRAPH-5471
        0x56FA, # G+3733  U+56FA  uni56FA,  CJK UNIFIED IDEOGRAPH-56FA
        0x59D1, # G+3734  U+59D1  uni59D1,  CJK UNIFIED IDEOGRAPH-59D1
        0x5B64, # G+3735  U+5B64  uni5B64,  CJK UNIFIED IDEOGRAPH-5B64
        0x5C3B, # G+3736  U+5C3B  uni5C3B,  CJK UNIFIED IDEOGRAPH-5C3B
        0x5EAB, # G+3737  U+5EAB  uni5EAB,  CJK UNIFIED IDEOGRAPH-5EAB
        0x62F7, # G+3738  U+62F7  uni62F7,  CJK UNIFIED IDEOGRAPH-62F7
        0x6537, # G+3739  U+6537  uni6537,  CJK UNIFIED IDEOGRAPH-6537
        0x6545, # G+3740  U+6545  uni6545,  CJK UNIFIED IDEOGRAPH-6545
        0x6572, # G+3741  U+6572  uni6572,  CJK UNIFIED IDEOGRAPH-6572
        0x66A0, # G+3742  U+66A0  uni66A0,  CJK UNIFIED IDEOGRAPH-66A0
        0x67AF, # G+3743  U+67AF  uni67AF,  CJK UNIFIED IDEOGRAPH-67AF
        0x69C1, # G+3744  U+69C1  uni69C1,  CJK UNIFIED IDEOGRAPH-69C1
        0x6CBD, # G+3745  U+6CBD  uni6CBD,  CJK UNIFIED IDEOGRAPH-6CBD
        0x75FC, # G+3746  U+75FC  uni75FC,  CJK UNIFIED IDEOGRAPH-75FC
        0x7690, # G+3747  U+7690  uni7690,  CJK UNIFIED IDEOGRAPH-7690
        0x777E, # G+3748  U+777E  uni777E,  CJK UNIFIED IDEOGRAPH-777E
        0x7A3F, # G+3749  U+7A3F  uni7A3F,  CJK UNIFIED IDEOGRAPH-7A3F
        0x7F94, # G+3750  U+7F94  uni7F94,  CJK UNIFIED IDEOGRAPH-7F94
        0x8003, # G+3751  U+8003  uni8003,  CJK UNIFIED IDEOGRAPH-8003
        0x80A1, # G+3752  U+80A1  uni80A1,  CJK UNIFIED IDEOGRAPH-80A1
        0x818F, # G+3753  U+818F  uni818F,  CJK UNIFIED IDEOGRAPH-818F
        0x82E6, # G+3754  U+82E6  uni82E6,  CJK UNIFIED IDEOGRAPH-82E6
        0x82FD, # G+3755  U+82FD  uni82FD,  CJK UNIFIED IDEOGRAPH-82FD
        0x83F0, # G+3756  U+83F0  uni83F0,  CJK UNIFIED IDEOGRAPH-83F0
        0x85C1, # G+3757  U+85C1  uni85C1,  CJK UNIFIED IDEOGRAPH-85C1
        0x8831, # G+3758  U+8831  uni8831,  CJK UNIFIED IDEOGRAPH-8831
        0x88B4, # G+3759  U+88B4  uni88B4,  CJK UNIFIED IDEOGRAPH-88B4
        0x8AA5, # G+3760  U+8AA5  uni8AA5,  CJK UNIFIED IDEOGRAPH-8AA5
        0x8F9C, # G+3761  U+8F9C  uni8F9C,  CJK UNIFIED IDEOGRAPH-8F9C
        0x932E, # G+3762  U+932E  uni932E,  CJK UNIFIED IDEOGRAPH-932E
        0x96C7, # G+3763  U+96C7  uni96C7,  CJK UNIFIED IDEOGRAPH-96C7
        0x9867, # G+3764  U+9867  uni9867,  CJK UNIFIED IDEOGRAPH-9867
        0x2FBC, # G+3765  U+2FBC  uni2FBC,  KANGXI RADICAL TALL
        0x2FCE, # G+3766  U+2FCE  uni2FCE,  KANGXI RADICAL DRUM
        0x54ED, # G+3767  U+54ED  uni54ED,  CJK UNIFIED IDEOGRAPH-54ED
        0x659B, # G+3768  U+659B  uni659B,  CJK UNIFIED IDEOGRAPH-659B
        0x66F2, # G+3769  U+66F2  uni66F2,  CJK UNIFIED IDEOGRAPH-66F2
        0x688F, # G+3770  U+688F  uni688F,  CJK UNIFIED IDEOGRAPH-688F
        0x7A40, # G+3771  U+7A40  uni7A40,  CJK UNIFIED IDEOGRAPH-7A40
        0x2F95, # G+3772  U+2F95  uni2F95,  KANGXI RADICAL VALLEY
        0x9D60, # G+3773  U+9D60  uni9D60,  CJK UNIFIED IDEOGRAPH-9D60
        0x56F0, # G+3774  U+56F0  uni56F0,  CJK UNIFIED IDEOGRAPH-56F0
        0x5764, # G+3775  U+5764  uni5764,  CJK UNIFIED IDEOGRAPH-5764
        0x5D11, # G+3776  U+5D11  uni5D11,  CJK UNIFIED IDEOGRAPH-5D11
        0x6606, # G+3777  U+6606  uni6606,  CJK UNIFIED IDEOGRAPH-6606
        0x68B1, # G+3778  U+68B1  uni68B1,  CJK UNIFIED IDEOGRAPH-68B1
        0x68CD, # G+3779  U+68CD  uni68CD,  CJK UNIFIED IDEOGRAPH-68CD
        0x6EFE, # G+3780  U+6EFE  uni6EFE,  CJK UNIFIED IDEOGRAPH-6EFE
        0x7428, # G+3781  U+7428  uni7428,  CJK UNIFIED IDEOGRAPH-7428
        0x889E, # G+3782  U+889E  uni889E,  CJK UNIFIED IDEOGRAPH-889E
        0x9BE4, # G+3783  U+9BE4  uni9BE4,  CJK UNIFIED IDEOGRAPH-9BE4
        0x6C68, # G+3784  U+6C68  uni6C68,  CJK UNIFIED IDEOGRAPH-6C68
        0x2FBB, # G+3785  U+2FBB  uni2FBB,  KANGXI RADICAL BONE
        0x4F9B, # G+3786  U+4F9B  uni4F9B,  CJK UNIFIED IDEOGRAPH-4F9B
        0x516C, # G+3787  U+516C  uni516C,  CJK UNIFIED IDEOGRAPH-516C
        0x5171, # G+3788  U+5171  uni5171,  CJK UNIFIED IDEOGRAPH-5171
        0x529F, # G+3789  U+529F  uni529F,  CJK UNIFIED IDEOGRAPH-529F
        0x5B54, # G+3790  U+5B54  uni5B54,  CJK UNIFIED IDEOGRAPH-5B54
        0x2F2F, # G+3791  U+2F2F  uni2F2F,  KANGXI RADICAL WORK
        0x6050, # G+3792  U+6050  uni6050,  CJK UNIFIED IDEOGRAPH-6050
        0x606D, # G+3793  U+606D  uni606D,  CJK UNIFIED IDEOGRAPH-606D
        0x62F1, # G+3794  U+62F1  uni62F1,  CJK UNIFIED IDEOGRAPH-62F1
        0x63A7, # G+3795  U+63A7  uni63A7,  CJK UNIFIED IDEOGRAPH-63A7
        0x653B, # G+3796  U+653B  uni653B,  CJK UNIFIED IDEOGRAPH-653B
        0x73D9, # G+3797  U+73D9  uni73D9,  CJK UNIFIED IDEOGRAPH-73D9
        0x7A7A, # G+3798  U+7A7A  uni7A7A,  CJK UNIFIED IDEOGRAPH-7A7A
        0x86A3, # G+3799  U+86A3  uni86A3,  CJK UNIFIED IDEOGRAPH-86A3
        0x8CA2, # G+3800  U+8CA2  uni8CA2,  CJK UNIFIED IDEOGRAPH-8CA2
        0x978F, # G+3801  U+978F  uni978F,  CJK UNIFIED IDEOGRAPH-978F
        0x4E32, # G+3802  U+4E32  uni4E32,  CJK UNIFIED IDEOGRAPH-4E32
        0x5BE1, # G+3803  U+5BE1  uni5BE1,  CJK UNIFIED IDEOGRAPH-5BE1
        0x2F3D, # G+3804  U+2F3D  uni2F3D,  KANGXI RADICAL HALBERD
        0x679C, # G+3805  U+679C  uni679C,  CJK UNIFIED IDEOGRAPH-679C
        0x2F60, # G+3806  U+2F60  uni2F60,  KANGXI RADICAL MELON
        0x79D1, # G+3807  U+79D1  uni79D1,  CJK UNIFIED IDEOGRAPH-79D1
        0x83D3, # G+3808  U+83D3  uni83D3,  CJK UNIFIED IDEOGRAPH-83D3
        0x8A87, # G+3809  U+8A87  uni8A87,  CJK UNIFIED IDEOGRAPH-8A87
        0x8AB2, # G+3810  U+8AB2  uni8AB2,  CJK UNIFIED IDEOGRAPH-8AB2
        0x8DE8, # G+3811  U+8DE8  uni8DE8,  CJK UNIFIED IDEOGRAPH-8DE8
        0x904E, # G+3812  U+904E  uni904E,  CJK UNIFIED IDEOGRAPH-904E
        0x934B, # G+3813  U+934B  uni934B,  CJK UNIFIED IDEOGRAPH-934B
        0x9846, # G+3814  U+9846  uni9846,  CJK UNIFIED IDEOGRAPH-9846
        0x5ED3, # G+3815  U+5ED3  uni5ED3,  CJK UNIFIED IDEOGRAPH-5ED3
        0x69E8, # G+3816  U+69E8  uni69E8,  CJK UNIFIED IDEOGRAPH-69E8
        0x85FF, # G+3817  U+85FF  uni85FF,  CJK UNIFIED IDEOGRAPH-85FF
        0x90ED, # G+3818  U+90ED  uni90ED,  CJK UNIFIED IDEOGRAPH-90ED
        0x51A0, # G+3819  U+51A0  uni51A0,  CJK UNIFIED IDEOGRAPH-51A0
        0x5B98, # G+3820  U+5B98  uni5B98,  CJK UNIFIED IDEOGRAPH-5B98
        0x5BEC, # G+3821  U+5BEC  uni5BEC,  CJK UNIFIED IDEOGRAPH-5BEC
        0x6163, # G+3822  U+6163  uni6163,  CJK UNIFIED IDEOGRAPH-6163
        0x68FA, # G+3823  U+68FA  uni68FA,  CJK UNIFIED IDEOGRAPH-68FA
        0x6B3E, # G+3824  U+6B3E  uni6B3E,  CJK UNIFIED IDEOGRAPH-6B3E
        0x704C, # G+3825  U+704C  uni704C,  CJK UNIFIED IDEOGRAPH-704C
        0x742F, # G+3826  U+742F  uni742F,  CJK UNIFIED IDEOGRAPH-742F
        0x74D8, # G+3827  U+74D8  uni74D8,  CJK UNIFIED IDEOGRAPH-74D8
        0x7BA1, # G+3828  U+7BA1  uni7BA1,  CJK UNIFIED IDEOGRAPH-7BA1
        0x7F50, # G+3829  U+7F50  uni7F50,  CJK UNIFIED IDEOGRAPH-7F50
        0x83C5, # G+3830  U+83C5  uni83C5,  CJK UNIFIED IDEOGRAPH-83C5
        0x89C0, # G+3831  U+89C0  uni89C0,  CJK UNIFIED IDEOGRAPH-89C0
        0x8CAB, # G+3832  U+8CAB  uni8CAB,  CJK UNIFIED IDEOGRAPH-8CAB
        0x95DC, # G+3833  U+95DC  uni95DC,  CJK UNIFIED IDEOGRAPH-95DC
        0x9928, # G+3834  U+9928  uni9928,  CJK UNIFIED IDEOGRAPH-9928
        0x522E, # G+3835  U+522E  uni522E,  CJK UNIFIED IDEOGRAPH-522E
        0x605D, # G+3836  U+605D  uni605D,  CJK UNIFIED IDEOGRAPH-605D
        0x62EC, # G+3837  U+62EC  uni62EC,  CJK UNIFIED IDEOGRAPH-62EC
        0x9002, # G+3838  U+9002  uni9002,  CJK UNIFIED IDEOGRAPH-9002
        0x4F8A, # G+3839  U+4F8A  uni4F8A,  CJK UNIFIED IDEOGRAPH-4F8A
        0x5149, # G+3840  U+5149  uni5149,  CJK UNIFIED IDEOGRAPH-5149
        0x5321, # G+3841  U+5321  uni5321,  CJK UNIFIED IDEOGRAPH-5321
        0x58D9, # G+3842  U+58D9  uni58D9,  CJK UNIFIED IDEOGRAPH-58D9
        0x5EE3, # G+3843  U+5EE3  uni5EE3,  CJK UNIFIED IDEOGRAPH-5EE3
        0x66E0, # G+3844  U+66E0  uni66E0,  CJK UNIFIED IDEOGRAPH-66E0
        0x6D38, # G+3845  U+6D38  uni6D38,  CJK UNIFIED IDEOGRAPH-6D38
        0x709A, # G+3846  U+709A  uni709A,  CJK UNIFIED IDEOGRAPH-709A
        0x72C2, # G+3847  U+72C2  uni72C2,  CJK UNIFIED IDEOGRAPH-72C2
        0x73D6, # G+3848  U+73D6  uni73D6,  CJK UNIFIED IDEOGRAPH-73D6
        0x7B50, # G+3849  U+7B50  uni7B50,  CJK UNIFIED IDEOGRAPH-7B50
        0x80F1, # G+3850  U+80F1  uni80F1,  CJK UNIFIED IDEOGRAPH-80F1
        0x945B, # G+3851  U+945B  uni945B,  CJK UNIFIED IDEOGRAPH-945B
        0x5366, # G+3852  U+5366  uni5366,  CJK UNIFIED IDEOGRAPH-5366
        0x639B, # G+3853  U+639B  uni639B,  CJK UNIFIED IDEOGRAPH-639B
        0x7F6B, # G+3854  U+7F6B  uni7F6B,  CJK UNIFIED IDEOGRAPH-7F6B
        0x4E56, # G+3855  U+4E56  uni4E56,  CJK UNIFIED IDEOGRAPH-4E56
        0x5080, # G+3856  U+5080  uni5080,  CJK UNIFIED IDEOGRAPH-5080
        0x584A, # G+3857  U+584A  uni584A,  CJK UNIFIED IDEOGRAPH-584A
        0x58DE, # G+3858  U+58DE  uni58DE,  CJK UNIFIED IDEOGRAPH-58DE
        0x602A, # G+3859  U+602A  uni602A,  CJK UNIFIED IDEOGRAPH-602A
        0x6127, # G+3860  U+6127  uni6127,  CJK UNIFIED IDEOGRAPH-6127
        0x62D0, # G+3861  U+62D0  uni62D0,  CJK UNIFIED IDEOGRAPH-62D0
        0x69D0, # G+3862  U+69D0  uni69D0,  CJK UNIFIED IDEOGRAPH-69D0
        0x9B41, # G+3863  U+9B41  uni9B41,  CJK UNIFIED IDEOGRAPH-9B41
        0x5B8F, # G+3864  U+5B8F  uni5B8F,  CJK UNIFIED IDEOGRAPH-5B8F
        0x7D18, # G+3865  U+7D18  uni7D18,  CJK UNIFIED IDEOGRAPH-7D18
        0x80B1, # G+3866  U+80B1  uni80B1,  CJK UNIFIED IDEOGRAPH-80B1
        0x8F5F, # G+3867  U+8F5F  uni8F5F,  CJK UNIFIED IDEOGRAPH-8F5F
        0x4EA4, # G+3868  U+4EA4  uni4EA4,  CJK UNIFIED IDEOGRAPH-4EA4
        0x50D1, # G+3869  U+50D1  uni50D1,  CJK UNIFIED IDEOGRAPH-50D1
        0x54AC, # G+3870  U+54AC  uni54AC,  CJK UNIFIED IDEOGRAPH-54AC
        0x55AC, # G+3871  U+55AC  uni55AC,  CJK UNIFIED IDEOGRAPH-55AC
        0x5B0C, # G+3872  U+5B0C  uni5B0C,  CJK UNIFIED IDEOGRAPH-5B0C
        0x5DA0, # G+3873  U+5DA0  uni5DA0,  CJK UNIFIED IDEOGRAPH-5DA0
        0x5DE7, # G+3874  U+5DE7  uni5DE7,  CJK UNIFIED IDEOGRAPH-5DE7
        0x652A, # G+3875  U+652A  uni652A,  CJK UNIFIED IDEOGRAPH-652A
        0x654E, # G+3876  U+654E  uni654E,  CJK UNIFIED IDEOGRAPH-654E
        0x6821, # G+3877  U+6821  uni6821,  CJK UNIFIED IDEOGRAPH-6821
        0x6A4B, # G+3878  U+6A4B  uni6A4B,  CJK UNIFIED IDEOGRAPH-6A4B
        0x72E1, # G+3879  U+72E1  uni72E1,  CJK UNIFIED IDEOGRAPH-72E1
        0x768E, # G+3880  U+768E  uni768E,  CJK UNIFIED IDEOGRAPH-768E
        0x77EF, # G+3881  U+77EF  uni77EF,  CJK UNIFIED IDEOGRAPH-77EF
        0x7D5E, # G+3882  U+7D5E  uni7D5E,  CJK UNIFIED IDEOGRAPH-7D5E
        0x7FF9, # G+3883  U+7FF9  uni7FF9,  CJK UNIFIED IDEOGRAPH-7FF9
        0x81A0, # G+3884  U+81A0  uni81A0,  CJK UNIFIED IDEOGRAPH-81A0
        0x854E, # G+3885  U+854E  uni854E,  CJK UNIFIED IDEOGRAPH-854E
        0x86DF, # G+3886  U+86DF  uni86DF,  CJK UNIFIED IDEOGRAPH-86DF
        0x8F03, # G+3887  U+8F03  uni8F03,  CJK UNIFIED IDEOGRAPH-8F03
        0x8F4E, # G+3888  U+8F4E  uni8F4E,  CJK UNIFIED IDEOGRAPH-8F4E
        0x90CA, # G+3889  U+90CA  uni90CA,  CJK UNIFIED IDEOGRAPH-90CA
        0x9903, # G+3890  U+9903  uni9903,  CJK UNIFIED IDEOGRAPH-9903
        0x9A55, # G+3891  U+9A55  uni9A55,  CJK UNIFIED IDEOGRAPH-9A55
        0x9BAB, # G+3892  U+9BAB  uni9BAB,  CJK UNIFIED IDEOGRAPH-9BAB
        0x4E18, # G+3893  U+4E18  uni4E18,  CJK UNIFIED IDEOGRAPH-4E18
        0x4E45, # G+3894  U+4E45  uni4E45,  CJK UNIFIED IDEOGRAPH-4E45
        0x4E5D, # G+3895  U+4E5D  uni4E5D,  CJK UNIFIED IDEOGRAPH-4E5D
        0x4EC7, # G+3896  U+4EC7  uni4EC7,  CJK UNIFIED IDEOGRAPH-4EC7
        0x4FF1, # G+3897  U+4FF1  uni4FF1,  CJK UNIFIED IDEOGRAPH-4FF1
        0x5177, # G+3898  U+5177  uni5177,  CJK UNIFIED IDEOGRAPH-5177
        0x52FE, # G+3899  U+52FE  uni52FE,  CJK UNIFIED IDEOGRAPH-52FE
        0x5340, # G+3900  U+5340  uni5340,  CJK UNIFIED IDEOGRAPH-5340
        0x2F1D, # G+3901  U+2F1D  uni2F1D,  KANGXI RADICAL MOUTH
        0x53E5, # G+3902  U+53E5  uni53E5,  CJK UNIFIED IDEOGRAPH-53E5
        0x548E, # G+3903  U+548E  uni548E,  CJK UNIFIED IDEOGRAPH-548E
        0x5614, # G+3904  U+5614  uni5614,  CJK UNIFIED IDEOGRAPH-5614
        0x5775, # G+3905  U+5775  uni5775,  CJK UNIFIED IDEOGRAPH-5775
        0x57A2, # G+3906  U+57A2  uni57A2,  CJK UNIFIED IDEOGRAPH-57A2
        0x5BC7, # G+3907  U+5BC7  uni5BC7,  CJK UNIFIED IDEOGRAPH-5BC7
        0x5D87, # G+3908  U+5D87  uni5D87,  CJK UNIFIED IDEOGRAPH-5D87
        0x5ED0, # G+3909  U+5ED0  uni5ED0,  CJK UNIFIED IDEOGRAPH-5ED0
        0x61FC, # G+3910  U+61FC  uni61FC,  CJK UNIFIED IDEOGRAPH-61FC
        0x62D8, # G+3911  U+62D8  uni62D8,  CJK UNIFIED IDEOGRAPH-62D8
        0x6551, # G+3912  U+6551  uni6551,  CJK UNIFIED IDEOGRAPH-6551
        0x67B8, # G+3913  U+67B8  uni67B8,  CJK UNIFIED IDEOGRAPH-67B8
        0x67E9, # G+3914  U+67E9  uni67E9,  CJK UNIFIED IDEOGRAPH-67E9
        0x69CB, # G+3915  U+69CB  uni69CB,  CJK UNIFIED IDEOGRAPH-69CB
        0x6B50, # G+3916  U+6B50  uni6B50,  CJK UNIFIED IDEOGRAPH-6B50
        0x6BC6, # G+3917  U+6BC6  uni6BC6,  CJK UNIFIED IDEOGRAPH-6BC6
        0x6BEC, # G+3918  U+6BEC  uni6BEC,  CJK UNIFIED IDEOGRAPH-6BEC
        0x6C42, # G+3919  U+6C42  uni6C42,  CJK UNIFIED IDEOGRAPH-6C42
        0x6E9D, # G+3920  U+6E9D  uni6E9D,  CJK UNIFIED IDEOGRAPH-6E9D
        0x7078, # G+3921  U+7078  uni7078,  CJK UNIFIED IDEOGRAPH-7078
        0x72D7, # G+3922  U+72D7  uni72D7,  CJK UNIFIED IDEOGRAPH-72D7
        0x7396, # G+3923  U+7396  uni7396,  CJK UNIFIED IDEOGRAPH-7396
        0x7403, # G+3924  U+7403  uni7403,  CJK UNIFIED IDEOGRAPH-7403
        0x77BF, # G+3925  U+77BF  uni77BF,  CJK UNIFIED IDEOGRAPH-77BF
        0x77E9, # G+3926  U+77E9  uni77E9,  CJK UNIFIED IDEOGRAPH-77E9
        0x7A76, # G+3927  U+7A76  uni7A76,  CJK UNIFIED IDEOGRAPH-7A76
        0x7D7F, # G+3928  U+7D7F  uni7D7F,  CJK UNIFIED IDEOGRAPH-7D7F
        0x8009, # G+3929  U+8009  uni8009,  CJK UNIFIED IDEOGRAPH-8009
        0x2F85, # G+3930  U+2F85  uni2F85,  KANGXI RADICAL MORTAR
        0x8205, # G+3931  U+8205  uni8205,  CJK UNIFIED IDEOGRAPH-8205
        0x820A, # G+3932  U+820A  uni820A,  CJK UNIFIED IDEOGRAPH-820A
        0x82DF, # G+3933  U+82DF  uni82DF,  CJK UNIFIED IDEOGRAPH-82DF
        0x8862, # G+3934  U+8862  uni8862,  CJK UNIFIED IDEOGRAPH-8862
        0x8B33, # G+3935  U+8B33  uni8B33,  CJK UNIFIED IDEOGRAPH-8B33
        0x8CFC, # G+3936  U+8CFC  uni8CFC,  CJK UNIFIED IDEOGRAPH-8CFC
        0x8EC0, # G+3937  U+8EC0  uni8EC0,  CJK UNIFIED IDEOGRAPH-8EC0
        0x9011, # G+3938  U+9011  uni9011,  CJK UNIFIED IDEOGRAPH-9011
        0x90B1, # G+3939  U+90B1  uni90B1,  CJK UNIFIED IDEOGRAPH-90B1
        0x9264, # G+3940  U+9264  uni9264,  CJK UNIFIED IDEOGRAPH-9264
        0x92B6, # G+3941  U+92B6  uni92B6,  CJK UNIFIED IDEOGRAPH-92B6
        0x99D2, # G+3942  U+99D2  uni99D2,  CJK UNIFIED IDEOGRAPH-99D2
        0x9A45, # G+3943  U+9A45  uni9A45,  CJK UNIFIED IDEOGRAPH-9A45
        0x9CE9, # G+3944  U+9CE9  uni9CE9,  CJK UNIFIED IDEOGRAPH-9CE9
        0x9DD7, # G+3945  U+9DD7  uni9DD7,  CJK UNIFIED IDEOGRAPH-9DD7
        0x2FD4, # G+3946  U+2FD4  uni2FD4,  KANGXI RADICAL TURTLE
        0x570B, # G+3947  U+570B  uni570B,  CJK UNIFIED IDEOGRAPH-570B
        0x5C40, # G+3948  U+5C40  uni5C40,  CJK UNIFIED IDEOGRAPH-5C40
        0x83CA, # G+3949  U+83CA  uni83CA,  CJK UNIFIED IDEOGRAPH-83CA
        0x97A0, # G+3950  U+97A0  uni97A0,  CJK UNIFIED IDEOGRAPH-97A0
        0x97AB, # G+3951  U+97AB  uni97AB,  CJK UNIFIED IDEOGRAPH-97AB
        0x9EB4, # G+3952  U+9EB4  uni9EB4,  CJK UNIFIED IDEOGRAPH-9EB4
        0x541B, # G+3953  U+541B  uni541B,  CJK UNIFIED IDEOGRAPH-541B
        0x7A98, # G+3954  U+7A98  uni7A98,  CJK UNIFIED IDEOGRAPH-7A98
        0x7FA4, # G+3955  U+7FA4  uni7FA4,  CJK UNIFIED IDEOGRAPH-7FA4
        0x88D9, # G+3956  U+88D9  uni88D9,  CJK UNIFIED IDEOGRAPH-88D9
        0x8ECD, # G+3957  U+8ECD  uni8ECD,  CJK UNIFIED IDEOGRAPH-8ECD
        0x90E1, # G+3958  U+90E1  uni90E1,  CJK UNIFIED IDEOGRAPH-90E1
        0x5800, # G+3959  U+5800  uni5800,  CJK UNIFIED IDEOGRAPH-5800
        0x5C48, # G+3960  U+5C48  uni5C48,  CJK UNIFIED IDEOGRAPH-5C48
        0x6398, # G+3961  U+6398  uni6398,  CJK UNIFIED IDEOGRAPH-6398
        0x7A9F, # G+3962  U+7A9F  uni7A9F,  CJK UNIFIED IDEOGRAPH-7A9F
        0x5BAE, # G+3963  U+5BAE  uni5BAE,  CJK UNIFIED IDEOGRAPH-5BAE
        0x2F38, # G+3964  U+2F38  uni2F38,  KANGXI RADICAL BOW
        0x7A79, # G+3965  U+7A79  uni7A79,  CJK UNIFIED IDEOGRAPH-7A79
        0x7AAE, # G+3966  U+7AAE  uni7AAE,  CJK UNIFIED IDEOGRAPH-7AAE
        0x828E, # G+3967  U+828E  uni828E,  CJK UNIFIED IDEOGRAPH-828E
        0x8EAC, # G+3968  U+8EAC  uni8EAC,  CJK UNIFIED IDEOGRAPH-8EAC
        0x5026, # G+3969  U+5026  uni5026,  CJK UNIFIED IDEOGRAPH-5026
        0x5238, # G+3970  U+5238  uni5238,  CJK UNIFIED IDEOGRAPH-5238
        0x52F8, # G+3971  U+52F8  uni52F8,  CJK UNIFIED IDEOGRAPH-52F8
        0x5377, # G+3972  U+5377  uni5377,  CJK UNIFIED IDEOGRAPH-5377
        0x5708, # G+3973  U+5708  uni5708,  CJK UNIFIED IDEOGRAPH-5708
        0x62F3, # G+3974  U+62F3  uni62F3,  CJK UNIFIED IDEOGRAPH-62F3
        0x6372, # G+3975  U+6372  uni6372,  CJK UNIFIED IDEOGRAPH-6372
        0x6B0A, # G+3976  U+6B0A  uni6B0A,  CJK UNIFIED IDEOGRAPH-6B0A
        0x6DC3, # G+3977  U+6DC3  uni6DC3,  CJK UNIFIED IDEOGRAPH-6DC3
        0x7737, # G+3978  U+7737  uni7737,  CJK UNIFIED IDEOGRAPH-7737
        0x53A5, # G+3979  U+53A5  uni53A5,  CJK UNIFIED IDEOGRAPH-53A5
        0x7357, # G+3980  U+7357  uni7357,  CJK UNIFIED IDEOGRAPH-7357
        0x8568, # G+3981  U+8568  uni8568,  CJK UNIFIED IDEOGRAPH-8568
        0x8E76, # G+3982  U+8E76  uni8E76,  CJK UNIFIED IDEOGRAPH-8E76
        0x95D5, # G+3983  U+95D5  uni95D5,  CJK UNIFIED IDEOGRAPH-95D5
        0x673A, # G+3984  U+673A  uni673A,  CJK UNIFIED IDEOGRAPH-673A
        0x6AC3, # G+3985  U+6AC3  uni6AC3,  CJK UNIFIED IDEOGRAPH-6AC3
        0x6F70, # G+3986  U+6F70  uni6F70,  CJK UNIFIED IDEOGRAPH-6F70
        0x8A6D, # G+3987  U+8A6D  uni8A6D,  CJK UNIFIED IDEOGRAPH-8A6D
        0x8ECC, # G+3988  U+8ECC  uni8ECC,  CJK UNIFIED IDEOGRAPH-8ECC
        0x994B, # G+3989  U+994B  uni994B,  CJK UNIFIED IDEOGRAPH-994B
        0x6677, # G+3990  U+6677  uni6677,  CJK UNIFIED IDEOGRAPH-6677
        0x6B78, # G+3991  U+6B78  uni6B78,  CJK UNIFIED IDEOGRAPH-6B78
        0x8CB4, # G+3992  U+8CB4  uni8CB4,  CJK UNIFIED IDEOGRAPH-8CB4
        0x2FC1, # G+3993  U+2FC1  uni2FC1,  KANGXI RADICAL GHOST
        0x53EB, # G+3994  U+53EB  uni53EB,  CJK UNIFIED IDEOGRAPH-53EB
        0x572D, # G+3995  U+572D  uni572D,  CJK UNIFIED IDEOGRAPH-572D
        0x594E, # G+3996  U+594E  uni594E,  CJK UNIFIED IDEOGRAPH-594E
        0x63C6, # G+3997  U+63C6  uni63C6,  CJK UNIFIED IDEOGRAPH-63C6
        0x69FB, # G+3998  U+69FB  uni69FB,  CJK UNIFIED IDEOGRAPH-69FB
        0x73EA, # G+3999  U+73EA  uni73EA,  CJK UNIFIED IDEOGRAPH-73EA
        0x7845, # G+4000  U+7845  uni7845,  CJK UNIFIED IDEOGRAPH-7845
        0x7ABA, # G+4001  U+7ABA  uni7ABA,  CJK UNIFIED IDEOGRAPH-7ABA
        0x7AC5, # G+4002  U+7AC5  uni7AC5,  CJK UNIFIED IDEOGRAPH-7AC5
        0x7CFE, # G+4003  U+7CFE  uni7CFE,  CJK UNIFIED IDEOGRAPH-7CFE
        0x8475, # G+4004  U+8475  uni8475,  CJK UNIFIED IDEOGRAPH-8475
        0x898F, # G+4005  U+898F  uni898F,  CJK UNIFIED IDEOGRAPH-898F
        0x8D73, # G+4006  U+8D73  uni8D73,  CJK UNIFIED IDEOGRAPH-8D73
        0x9035, # G+4007  U+9035  uni9035,  CJK UNIFIED IDEOGRAPH-9035
        0x95A8, # G+4008  U+95A8  uni95A8,  CJK UNIFIED IDEOGRAPH-95A8
        0x52FB, # G+4009  U+52FB  uni52FB,  CJK UNIFIED IDEOGRAPH-52FB
        0x5747, # G+4010  U+5747  uni5747,  CJK UNIFIED IDEOGRAPH-5747
        0x7547, # G+4011  U+7547  uni7547,  CJK UNIFIED IDEOGRAPH-7547
        0x7B60, # G+4012  U+7B60  uni7B60,  CJK UNIFIED IDEOGRAPH-7B60
        0x83CC, # G+4013  U+83CC  uni83CC,  CJK UNIFIED IDEOGRAPH-83CC
        0x921E, # G+4014  U+921E  uni921E,  CJK UNIFIED IDEOGRAPH-921E
        0x6A58, # G+4015  U+6A58  uni6A58,  CJK UNIFIED IDEOGRAPH-6A58
        0x514B, # G+4016  U+514B  uni514B,  CJK UNIFIED IDEOGRAPH-514B
        0x524B, # G+4017  U+524B  uni524B,  CJK UNIFIED IDEOGRAPH-524B
        0x5287, # G+4018  U+5287  uni5287,  CJK UNIFIED IDEOGRAPH-5287
        0x621F, # G+4019  U+621F  uni621F,  CJK UNIFIED IDEOGRAPH-621F
        0x68D8, # G+4020  U+68D8  uni68D8,  CJK UNIFIED IDEOGRAPH-68D8
        0x6975, # G+4021  U+6975  uni6975,  CJK UNIFIED IDEOGRAPH-6975
        0x9699, # G+4022  U+9699  uni9699,  CJK UNIFIED IDEOGRAPH-9699
        0x50C5, # G+4023  U+50C5  uni50C5,  CJK UNIFIED IDEOGRAPH-50C5
        0x52A4, # G+4024  U+52A4  uni52A4,  CJK UNIFIED IDEOGRAPH-52A4
        0x52E4, # G+4025  U+52E4  uni52E4,  CJK UNIFIED IDEOGRAPH-52E4
        0x61C3, # G+4026  U+61C3  uni61C3,  CJK UNIFIED IDEOGRAPH-61C3
        0x2F44, # G+4027  U+2F44  uni2F44,  KANGXI RADICAL AXE
        0x6839, # G+4028  U+6839  uni6839,  CJK UNIFIED IDEOGRAPH-6839
        0x69FF, # G+4029  U+69FF  uni69FF,  CJK UNIFIED IDEOGRAPH-69FF
        0x747E, # G+4030  U+747E  uni747E,  CJK UNIFIED IDEOGRAPH-747E
        0x7B4B, # G+4031  U+7B4B  uni7B4B,  CJK UNIFIED IDEOGRAPH-7B4B
        0x82B9, # G+4032  U+82B9  uni82B9,  CJK UNIFIED IDEOGRAPH-82B9
        0x83EB, # G+4033  U+83EB  uni83EB,  CJK UNIFIED IDEOGRAPH-83EB
        0x89B2, # G+4034  U+89B2  uni89B2,  CJK UNIFIED IDEOGRAPH-89B2
        0x8B39, # G+4035  U+8B39  uni8B39,  CJK UNIFIED IDEOGRAPH-8B39
        0x8FD1, # G+4036  U+8FD1  uni8FD1,  CJK UNIFIED IDEOGRAPH-8FD1
        0x9949, # G+4037  U+9949  uni9949,  CJK UNIFIED IDEOGRAPH-9949
        0x4ECA, # G+4038  U+4ECA  uni4ECA,  CJK UNIFIED IDEOGRAPH-4ECA
        0x5997, # G+4039  U+5997  uni5997,  CJK UNIFIED IDEOGRAPH-5997
        0x64D2, # G+4040  U+64D2  uni64D2,  CJK UNIFIED IDEOGRAPH-64D2
        0x6611, # G+4041  U+6611  uni6611,  CJK UNIFIED IDEOGRAPH-6611
        0x6A8E, # G+4042  U+6A8E  uni6A8E,  CJK UNIFIED IDEOGRAPH-6A8E
        0x7434, # G+4043  U+7434  uni7434,  CJK UNIFIED IDEOGRAPH-7434
        0x7981, # G+4044  U+7981  uni7981,  CJK UNIFIED IDEOGRAPH-7981
        0x79BD, # G+4045  U+79BD  uni79BD,  CJK UNIFIED IDEOGRAPH-79BD
        0x82A9, # G+4046  U+82A9  uni82A9,  CJK UNIFIED IDEOGRAPH-82A9
        0x887E, # G+4047  U+887E  uni887E,  CJK UNIFIED IDEOGRAPH-887E
        0x887F, # G+4048  U+887F  uni887F,  CJK UNIFIED IDEOGRAPH-887F
        0x895F, # G+4049  U+895F  uni895F,  CJK UNIFIED IDEOGRAPH-895F
        0x9326, # G+4050  U+9326  uni9326,  CJK UNIFIED IDEOGRAPH-9326
        0x4F0B, # G+4051  U+4F0B  uni4F0B,  CJK UNIFIED IDEOGRAPH-4F0B
        0x53CA, # G+4052  U+53CA  uni53CA,  CJK UNIFIED IDEOGRAPH-53CA
        0x6025, # G+4053  U+6025  uni6025,  CJK UNIFIED IDEOGRAPH-6025
        0x6271, # G+4054  U+6271  uni6271,  CJK UNIFIED IDEOGRAPH-6271
        0x6C72, # G+4055  U+6C72  uni6C72,  CJK UNIFIED IDEOGRAPH-6C72
        0x7D1A, # G+4056  U+7D1A  uni7D1A,  CJK UNIFIED IDEOGRAPH-7D1A
        0x7D66, # G+4057  U+7D66  uni7D66,  CJK UNIFIED IDEOGRAPH-7D66
        0x4E98, # G+4058  U+4E98  uni4E98,  CJK UNIFIED IDEOGRAPH-4E98
        0x5162, # G+4059  U+5162  uni5162,  CJK UNIFIED IDEOGRAPH-5162
        0x77DC, # G+4060  U+77DC  uni77DC,  CJK UNIFIED IDEOGRAPH-77DC
        0x80AF, # G+4061  U+80AF  uni80AF,  CJK UNIFIED IDEOGRAPH-80AF
        0x4F01, # G+4062  U+4F01  uni4F01,  CJK UNIFIED IDEOGRAPH-4F01
        0x4F0E, # G+4063  U+4F0E  uni4F0E,  CJK UNIFIED IDEOGRAPH-4F0E
        0x5176, # G+4064  U+5176  uni5176,  CJK UNIFIED IDEOGRAPH-5176
        0x5180, # G+4065  U+5180  uni5180,  CJK UNIFIED IDEOGRAPH-5180
        0x55DC, # G+4066  U+55DC  uni55DC,  CJK UNIFIED IDEOGRAPH-55DC
        0x5668, # G+4067  U+5668  uni5668,  CJK UNIFIED IDEOGRAPH-5668
        0x573B, # G+4068  U+573B  uni573B,  CJK UNIFIED IDEOGRAPH-573B
        0x57FA, # G+4069  U+57FA  uni57FA,  CJK UNIFIED IDEOGRAPH-57FA
        0x57FC, # G+4070  U+57FC  uni57FC,  CJK UNIFIED IDEOGRAPH-57FC
        0x5914, # G+4071  U+5914  uni5914,  CJK UNIFIED IDEOGRAPH-5914
        0x5947, # G+4072  U+5947  uni5947,  CJK UNIFIED IDEOGRAPH-5947
        0x5993, # G+4073  U+5993  uni5993,  CJK UNIFIED IDEOGRAPH-5993
        0x5BC4, # G+4074  U+5BC4  uni5BC4,  CJK UNIFIED IDEOGRAPH-5BC4
        0x5C90, # G+4075  U+5C90  uni5C90,  CJK UNIFIED IDEOGRAPH-5C90
        0x5D0E, # G+4076  U+5D0E  uni5D0E,  CJK UNIFIED IDEOGRAPH-5D0E
        0x2F30, # G+4077  U+2F30  uni2F30,  KANGXI RADICAL ONESELF
        0x5E7E, # G+4078  U+5E7E  uni5E7E,  CJK UNIFIED IDEOGRAPH-5E7E
        0x5FCC, # G+4079  U+5FCC  uni5FCC,  CJK UNIFIED IDEOGRAPH-5FCC
        0x6280, # G+4080  U+6280  uni6280,  CJK UNIFIED IDEOGRAPH-6280
        0x65D7, # G+4081  U+65D7  uni65D7,  CJK UNIFIED IDEOGRAPH-65D7
        0x65E3, # G+4082  U+65E3  uni65E3,  CJK UNIFIED IDEOGRAPH-65E3
        0x671E, # G+4083  U+671E  uni671E,  CJK UNIFIED IDEOGRAPH-671E
        0x671F, # G+4084  U+671F  uni671F,  CJK UNIFIED IDEOGRAPH-671F
        0x675E, # G+4085  U+675E  uni675E,  CJK UNIFIED IDEOGRAPH-675E
        0x68CB, # G+4086  U+68CB  uni68CB,  CJK UNIFIED IDEOGRAPH-68CB
        0x68C4, # G+4087  U+68C4  uni68C4,  CJK UNIFIED IDEOGRAPH-68C4
        0x6A5F, # G+4088  U+6A5F  uni6A5F,  CJK UNIFIED IDEOGRAPH-6A5F
        0x6B3A, # G+4089  U+6B3A  uni6B3A,  CJK UNIFIED IDEOGRAPH-6B3A
        0x6C23, # G+4090  U+6C23  uni6C23,  CJK UNIFIED IDEOGRAPH-6C23
        0x6C7D, # G+4091  U+6C7D  uni6C7D,  CJK UNIFIED IDEOGRAPH-6C7D
        0x6C82, # G+4092  U+6C82  uni6C82,  CJK UNIFIED IDEOGRAPH-6C82
        0x6DC7, # G+4093  U+6DC7  uni6DC7,  CJK UNIFIED IDEOGRAPH-6DC7
        0x7398, # G+4094  U+7398  uni7398,  CJK UNIFIED IDEOGRAPH-7398
        0x7426, # G+4095  U+7426  uni7426,  CJK UNIFIED IDEOGRAPH-7426
        0x742A, # G+4096  U+742A  uni742A,  CJK UNIFIED IDEOGRAPH-742A
        0x7482, # G+4097  U+7482  uni7482,  CJK UNIFIED IDEOGRAPH-7482
        0x74A3, # G+4098  U+74A3  uni74A3,  CJK UNIFIED IDEOGRAPH-74A3
        0x7578, # G+4099  U+7578  uni7578,  CJK UNIFIED IDEOGRAPH-7578
        0x757F, # G+4100  U+757F  uni757F,  CJK UNIFIED IDEOGRAPH-757F
        0x7881, # G+4101  U+7881  uni7881,  CJK UNIFIED IDEOGRAPH-7881
        0x78EF, # G+4102  U+78EF  uni78EF,  CJK UNIFIED IDEOGRAPH-78EF
        0x7941, # G+4103  U+7941  uni7941,  CJK UNIFIED IDEOGRAPH-7941
        0x7947, # G+4104  U+7947  uni7947,  CJK UNIFIED IDEOGRAPH-7947
        0x7948, # G+4105  U+7948  uni7948,  CJK UNIFIED IDEOGRAPH-7948
        0x797A, # G+4106  U+797A  uni797A,  CJK UNIFIED IDEOGRAPH-797A
        0x7B95, # G+4107  U+7B95  uni7B95,  CJK UNIFIED IDEOGRAPH-7B95
        0x7D00, # G+4108  U+7D00  uni7D00,  CJK UNIFIED IDEOGRAPH-7D00
        0x7DBA, # G+4109  U+7DBA  uni7DBA,  CJK UNIFIED IDEOGRAPH-7DBA
        0x7F88, # G+4110  U+7F88  uni7F88,  CJK UNIFIED IDEOGRAPH-7F88
        0x8006, # G+4111  U+8006  uni8006,  CJK UNIFIED IDEOGRAPH-8006
        0x802D, # G+4112  U+802D  uni802D,  CJK UNIFIED IDEOGRAPH-802D
        0x808C, # G+4113  U+808C  uni808C,  CJK UNIFIED IDEOGRAPH-808C
        0x8A18, # G+4114  U+8A18  uni8A18,  CJK UNIFIED IDEOGRAPH-8A18
        0x8B4F, # G+4115  U+8B4F  uni8B4F,  CJK UNIFIED IDEOGRAPH-8B4F
        0x8C48, # G+4116  U+8C48  uni8C48,  CJK UNIFIED IDEOGRAPH-8C48
        0x8D77, # G+4117  U+8D77  uni8D77,  CJK UNIFIED IDEOGRAPH-8D77
        0x9321, # G+4118  U+9321  uni9321,  CJK UNIFIED IDEOGRAPH-9321
        0x9324, # G+4119  U+9324  uni9324,  CJK UNIFIED IDEOGRAPH-9324
        0x98E2, # G+4120  U+98E2  uni98E2,  CJK UNIFIED IDEOGRAPH-98E2
        0x9951, # G+4121  U+9951  uni9951,  CJK UNIFIED IDEOGRAPH-9951
        0x9A0E, # G+4122  U+9A0E  uni9A0E,  CJK UNIFIED IDEOGRAPH-9A0E
        0x9A0F, # G+4123  U+9A0F  uni9A0F,  CJK UNIFIED IDEOGRAPH-9A0F
        0x9A65, # G+4124  U+9A65  uni9A65,  CJK UNIFIED IDEOGRAPH-9A65
        0x9E92, # G+4125  U+9E92  uni9E92,  CJK UNIFIED IDEOGRAPH-9E92
        0x7DCA, # G+4126  U+7DCA  uni7DCA,  CJK UNIFIED IDEOGRAPH-7DCA
        0x4F76, # G+4127  U+4F76  uni4F76,  CJK UNIFIED IDEOGRAPH-4F76
        0x5409, # G+4128  U+5409  uni5409,  CJK UNIFIED IDEOGRAPH-5409
        0x62EE, # G+4129  U+62EE  uni62EE,  CJK UNIFIED IDEOGRAPH-62EE
        0x6854, # G+4130  U+6854  uni6854,  CJK UNIFIED IDEOGRAPH-6854
        0x2FA6, # G+4131  U+2FA6  uni2FA6,  KANGXI RADICAL GOLD
        0x55AB, # G+4132  U+55AB  uni55AB,  CJK UNIFIED IDEOGRAPH-55AB
        0x513A, # G+4133  U+513A  uni513A,  CJK UNIFIED IDEOGRAPH-513A
        0x5A1C, # G+4134  U+5A1C  uni5A1C,  CJK UNIFIED IDEOGRAPH-5A1C
        0x61E6, # G+4135  U+61E6  uni61E6,  CJK UNIFIED IDEOGRAPH-61E6
        0x62CF, # G+4136  U+62CF  uni62CF,  CJK UNIFIED IDEOGRAPH-62CF
        0x62FF, # G+4137  U+62FF  uni62FF,  CJK UNIFIED IDEOGRAPH-62FF
        0x90A3, # G+4138  U+90A3  uni90A3,  CJK UNIFIED IDEOGRAPH-90A3
        0x8AFE, # G+4139  U+8AFE  uni8AFE,  CJK UNIFIED IDEOGRAPH-8AFE
        0x6696, # G+4140  U+6696  uni6696,  CJK UNIFIED IDEOGRAPH-6696
        0x7156, # G+4141  U+7156  uni7156,  CJK UNIFIED IDEOGRAPH-7156
        0x96E3, # G+4142  U+96E3  uni96E3,  CJK UNIFIED IDEOGRAPH-96E3
        0x634F, # G+4143  U+634F  uni634F,  CJK UNIFIED IDEOGRAPH-634F
        0x637A, # G+4144  U+637A  uni637A,  CJK UNIFIED IDEOGRAPH-637A
        0x5357, # G+4145  U+5357  uni5357,  CJK UNIFIED IDEOGRAPH-5357
        0x678F, # G+4146  U+678F  uni678F,  CJK UNIFIED IDEOGRAPH-678F
        0x6960, # G+4147  U+6960  uni6960,  CJK UNIFIED IDEOGRAPH-6960
        0x6E73, # G+4148  U+6E73  uni6E73,  CJK UNIFIED IDEOGRAPH-6E73
        0x7537, # G+4149  U+7537  uni7537,  CJK UNIFIED IDEOGRAPH-7537
        0x7D0D, # G+4150  U+7D0D  uni7D0D,  CJK UNIFIED IDEOGRAPH-7D0D
        0x8872, # G+4151  U+8872  uni8872,  CJK UNIFIED IDEOGRAPH-8872
        0x56CA, # G+4152  U+56CA  uni56CA,  CJK UNIFIED IDEOGRAPH-56CA
        0x5A18, # G+4153  U+5A18  uni5A18,  CJK UNIFIED IDEOGRAPH-5A18
        0x4E43, # G+4154  U+4E43  uni4E43,  CJK UNIFIED IDEOGRAPH-4E43
        0x5167, # G+4155  U+5167  uni5167,  CJK UNIFIED IDEOGRAPH-5167
        0x5948, # G+4156  U+5948  uni5948,  CJK UNIFIED IDEOGRAPH-5948
        0x67F0, # G+4157  U+67F0  uni67F0,  CJK UNIFIED IDEOGRAPH-67F0
        0x8010, # G+4158  U+8010  uni8010,  CJK UNIFIED IDEOGRAPH-8010
        0x2F25, # G+4159  U+2F25  uni2F25,  KANGXI RADICAL WOMAN
        0x5E74, # G+4160  U+5E74  uni5E74,  CJK UNIFIED IDEOGRAPH-5E74
        0x649A, # G+4161  U+649A  uni649A,  CJK UNIFIED IDEOGRAPH-649A
        0x79CA, # G+4162  U+79CA  uni79CA,  CJK UNIFIED IDEOGRAPH-79CA
        0x5FF5, # G+4163  U+5FF5  uni5FF5,  CJK UNIFIED IDEOGRAPH-5FF5
        0x606C, # G+4164  U+606C  uni606C,  CJK UNIFIED IDEOGRAPH-606C
        0x62C8, # G+4165  U+62C8  uni62C8,  CJK UNIFIED IDEOGRAPH-62C8
        0x637B, # G+4166  U+637B  uni637B,  CJK UNIFIED IDEOGRAPH-637B
        0x5BE7, # G+4167  U+5BE7  uni5BE7,  CJK UNIFIED IDEOGRAPH-5BE7
        0x5BD7, # G+4168  U+5BD7  uni5BD7,  CJK UNIFIED IDEOGRAPH-5BD7
        0x52AA, # G+4169  U+52AA  uni52AA,  CJK UNIFIED IDEOGRAPH-52AA
        0x5974, # G+4170  U+5974  uni5974,  CJK UNIFIED IDEOGRAPH-5974
        0x5F29, # G+4171  U+5F29  uni5F29,  CJK UNIFIED IDEOGRAPH-5F29
        0x6012, # G+4172  U+6012  uni6012,  CJK UNIFIED IDEOGRAPH-6012
        0x7459, # G+4173  U+7459  uni7459,  CJK UNIFIED IDEOGRAPH-7459
        0x99D1, # G+4174  U+99D1  uni99D1,  CJK UNIFIED IDEOGRAPH-99D1
        0x6FC3, # G+4175  U+6FC3  uni6FC3,  CJK UNIFIED IDEOGRAPH-6FC3
        0x81BF, # G+4176  U+81BF  uni81BF,  CJK UNIFIED IDEOGRAPH-81BF
        0x8FB2, # G+4177  U+8FB2  uni8FB2,  CJK UNIFIED IDEOGRAPH-8FB2
        0x60F1, # G+4178  U+60F1  uni60F1,  CJK UNIFIED IDEOGRAPH-60F1
        0x8166, # G+4179  U+8166  uni8166,  CJK UNIFIED IDEOGRAPH-8166
        0x5C3F, # G+4180  U+5C3F  uni5C3F,  CJK UNIFIED IDEOGRAPH-5C3F
        0x5AE9, # G+4181  U+5AE9  uni5AE9,  CJK UNIFIED IDEOGRAPH-5AE9
        0x8A25, # G+4182  U+8A25  uni8A25,  CJK UNIFIED IDEOGRAPH-8A25
        0x677B, # G+4183  U+677B  uni677B,  CJK UNIFIED IDEOGRAPH-677B
        0x7D10, # G+4184  U+7D10  uni7D10,  CJK UNIFIED IDEOGRAPH-7D10
        0x80FD, # G+4185  U+80FD  uni80FD,  CJK UNIFIED IDEOGRAPH-80FD
        0x5C3C, # G+4186  U+5C3C  uni5C3C,  CJK UNIFIED IDEOGRAPH-5C3C
        0x6CE5, # G+4187  U+6CE5  uni6CE5,  CJK UNIFIED IDEOGRAPH-6CE5
        0x533F, # G+4188  U+533F  uni533F,  CJK UNIFIED IDEOGRAPH-533F
        0x6EBA, # G+4189  U+6EBA  uni6EBA,  CJK UNIFIED IDEOGRAPH-6EBA
        0x591A, # G+4190  U+591A  uni591A,  CJK UNIFIED IDEOGRAPH-591A
        0x8336, # G+4191  U+8336  uni8336,  CJK UNIFIED IDEOGRAPH-8336
        0x4E39, # G+4192  U+4E39  uni4E39,  CJK UNIFIED IDEOGRAPH-4E39
        0x4EB6, # G+4193  U+4EB6  uni4EB6,  CJK UNIFIED IDEOGRAPH-4EB6
        0x4F46, # G+4194  U+4F46  uni4F46,  CJK UNIFIED IDEOGRAPH-4F46
        0x55AE, # G+4195  U+55AE  uni55AE,  CJK UNIFIED IDEOGRAPH-55AE
        0x5718, # G+4196  U+5718  uni5718,  CJK UNIFIED IDEOGRAPH-5718
        0x58C7, # G+4197  U+58C7  uni58C7,  CJK UNIFIED IDEOGRAPH-58C7
        0x5F56, # G+4198  U+5F56  uni5F56,  CJK UNIFIED IDEOGRAPH-5F56
        0x65B7, # G+4199  U+65B7  uni65B7,  CJK UNIFIED IDEOGRAPH-65B7
        0x65E6, # G+4200  U+65E6  uni65E6,  CJK UNIFIED IDEOGRAPH-65E6
        0x6A80, # G+4201  U+6A80  uni6A80,  CJK UNIFIED IDEOGRAPH-6A80
        0x6BB5, # G+4202  U+6BB5  uni6BB5,  CJK UNIFIED IDEOGRAPH-6BB5
        0x6E4D, # G+4203  U+6E4D  uni6E4D,  CJK UNIFIED IDEOGRAPH-6E4D
        0x77ED, # G+4204  U+77ED  uni77ED,  CJK UNIFIED IDEOGRAPH-77ED
        0x7AEF, # G+4205  U+7AEF  uni7AEF,  CJK UNIFIED IDEOGRAPH-7AEF
        0x7C1E, # G+4206  U+7C1E  uni7C1E,  CJK UNIFIED IDEOGRAPH-7C1E
        0x7DDE, # G+4207  U+7DDE  uni7DDE,  CJK UNIFIED IDEOGRAPH-7DDE
        0x86CB, # G+4208  U+86CB  uni86CB,  CJK UNIFIED IDEOGRAPH-86CB
        0x8892, # G+4209  U+8892  uni8892,  CJK UNIFIED IDEOGRAPH-8892
        0x9132, # G+4210  U+9132  uni9132,  CJK UNIFIED IDEOGRAPH-9132
        0x935B, # G+4211  U+935B  uni935B,  CJK UNIFIED IDEOGRAPH-935B
        0x64BB, # G+4212  U+64BB  uni64BB,  CJK UNIFIED IDEOGRAPH-64BB
        0x6FBE, # G+4213  U+6FBE  uni6FBE,  CJK UNIFIED IDEOGRAPH-6FBE
        0x737A, # G+4214  U+737A  uni737A,  CJK UNIFIED IDEOGRAPH-737A
        0x75B8, # G+4215  U+75B8  uni75B8,  CJK UNIFIED IDEOGRAPH-75B8
        0x9054, # G+4216  U+9054  uni9054,  CJK UNIFIED IDEOGRAPH-9054
        0x5556, # G+4217  U+5556  uni5556,  CJK UNIFIED IDEOGRAPH-5556
        0x574D, # G+4218  U+574D  uni574D,  CJK UNIFIED IDEOGRAPH-574D
        0x61BA, # G+4219  U+61BA  uni61BA,  CJK UNIFIED IDEOGRAPH-61BA
        0x64D4, # G+4220  U+64D4  uni64D4,  CJK UNIFIED IDEOGRAPH-64D4
        0x66C7, # G+4221  U+66C7  uni66C7,  CJK UNIFIED IDEOGRAPH-66C7
        0x6DE1, # G+4222  U+6DE1  uni6DE1,  CJK UNIFIED IDEOGRAPH-6DE1
        0x6E5B, # G+4223  U+6E5B  uni6E5B,  CJK UNIFIED IDEOGRAPH-6E5B
        0x6F6D, # G+4224  U+6F6D  uni6F6D,  CJK UNIFIED IDEOGRAPH-6F6D
        0x6FB9, # G+4225  U+6FB9  uni6FB9,  CJK UNIFIED IDEOGRAPH-6FB9
        0x75F0, # G+4226  U+75F0  uni75F0,  CJK UNIFIED IDEOGRAPH-75F0
        0x8043, # G+4227  U+8043  uni8043,  CJK UNIFIED IDEOGRAPH-8043
        0x81BD, # G+4228  U+81BD  uni81BD,  CJK UNIFIED IDEOGRAPH-81BD
        0x8541, # G+4229  U+8541  uni8541,  CJK UNIFIED IDEOGRAPH-8541
        0x8983, # G+4230  U+8983  uni8983,  CJK UNIFIED IDEOGRAPH-8983
        0x8AC7, # G+4231  U+8AC7  uni8AC7,  CJK UNIFIED IDEOGRAPH-8AC7
        0x8B5A, # G+4232  U+8B5A  uni8B5A,  CJK UNIFIED IDEOGRAPH-8B5A
        0x931F, # G+4233  U+931F  uni931F,  CJK UNIFIED IDEOGRAPH-931F
        0x6C93, # G+4234  U+6C93  uni6C93,  CJK UNIFIED IDEOGRAPH-6C93
        0x7553, # G+4235  U+7553  uni7553,  CJK UNIFIED IDEOGRAPH-7553
        0x7B54, # G+4236  U+7B54  uni7B54,  CJK UNIFIED IDEOGRAPH-7B54
        0x8E0F, # G+4237  U+8E0F  uni8E0F,  CJK UNIFIED IDEOGRAPH-8E0F
        0x905D, # G+4238  U+905D  uni905D,  CJK UNIFIED IDEOGRAPH-905D
        0x5510, # G+4239  U+5510  uni5510,  CJK UNIFIED IDEOGRAPH-5510
        0x5802, # G+4240  U+5802  uni5802,  CJK UNIFIED IDEOGRAPH-5802
        0x5858, # G+4241  U+5858  uni5858,  CJK UNIFIED IDEOGRAPH-5858
        0x5E62, # G+4242  U+5E62  uni5E62,  CJK UNIFIED IDEOGRAPH-5E62
        0x6207, # G+4243  U+6207  uni6207,  CJK UNIFIED IDEOGRAPH-6207
        0x649E, # G+4244  U+649E  uni649E,  CJK UNIFIED IDEOGRAPH-649E
        0x68E0, # G+4245  U+68E0  uni68E0,  CJK UNIFIED IDEOGRAPH-68E0
        0x7576, # G+4246  U+7576  uni7576,  CJK UNIFIED IDEOGRAPH-7576
        0x7CD6, # G+4247  U+7CD6  uni7CD6,  CJK UNIFIED IDEOGRAPH-7CD6
        0x87B3, # G+4248  U+87B3  uni87B3,  CJK UNIFIED IDEOGRAPH-87B3
        0x9EE8, # G+4249  U+9EE8  uni9EE8,  CJK UNIFIED IDEOGRAPH-9EE8
        0x4EE3, # G+4250  U+4EE3  uni4EE3,  CJK UNIFIED IDEOGRAPH-4EE3
        0x5788, # G+4251  U+5788  uni5788,  CJK UNIFIED IDEOGRAPH-5788
        0x576E, # G+4252  U+576E  uni576E,  CJK UNIFIED IDEOGRAPH-576E
        0x2F24, # G+4253  U+2F24  uni2F24,  KANGXI RADICAL BIG
        0x5C0D, # G+4254  U+5C0D  uni5C0D,  CJK UNIFIED IDEOGRAPH-5C0D
        0x5CB1, # G+4255  U+5CB1  uni5CB1,  CJK UNIFIED IDEOGRAPH-5CB1
        0x5E36, # G+4256  U+5E36  uni5E36,  CJK UNIFIED IDEOGRAPH-5E36
        0x5F85, # G+4257  U+5F85  uni5F85,  CJK UNIFIED IDEOGRAPH-5F85
        0x6234, # G+4258  U+6234  uni6234,  CJK UNIFIED IDEOGRAPH-6234
        0x64E1, # G+4259  U+64E1  uni64E1,  CJK UNIFIED IDEOGRAPH-64E1
        0x73B3, # G+4260  U+73B3  uni73B3,  CJK UNIFIED IDEOGRAPH-73B3
        0x81FA, # G+4261  U+81FA  uni81FA,  CJK UNIFIED IDEOGRAPH-81FA
        0x888B, # G+4262  U+888B  uni888B,  CJK UNIFIED IDEOGRAPH-888B
        0x8CB8, # G+4263  U+8CB8  uni8CB8,  CJK UNIFIED IDEOGRAPH-8CB8
        0x968A, # G+4264  U+968A  uni968A,  CJK UNIFIED IDEOGRAPH-968A
        0x9EDB, # G+4265  U+9EDB  uni9EDB,  CJK UNIFIED IDEOGRAPH-9EDB
        0x5B85, # G+4266  U+5B85  uni5B85,  CJK UNIFIED IDEOGRAPH-5B85
        0x5FB7, # G+4267  U+5FB7  uni5FB7,  CJK UNIFIED IDEOGRAPH-5FB7
        0x60B3, # G+4268  U+60B3  uni60B3,  CJK UNIFIED IDEOGRAPH-60B3
        0x5012, # G+4269  U+5012  uni5012,  CJK UNIFIED IDEOGRAPH-5012
        0x2F11, # G+4270  U+2F11  uni2F11,  KANGXI RADICAL KNIFE
        0x5230, # G+4271  U+5230  uni5230,  CJK UNIFIED IDEOGRAPH-5230
        0x5716, # G+4272  U+5716  uni5716,  CJK UNIFIED IDEOGRAPH-5716
        0x5835, # G+4273  U+5835  uni5835,  CJK UNIFIED IDEOGRAPH-5835
        0x5857, # G+4274  U+5857  uni5857,  CJK UNIFIED IDEOGRAPH-5857
        0x5C0E, # G+4275  U+5C0E  uni5C0E,  CJK UNIFIED IDEOGRAPH-5C0E
        0x5C60, # G+4276  U+5C60  uni5C60,  CJK UNIFIED IDEOGRAPH-5C60
        0x5CF6, # G+4277  U+5CF6  uni5CF6,  CJK UNIFIED IDEOGRAPH-5CF6
        0x5D8B, # G+4278  U+5D8B  uni5D8B,  CJK UNIFIED IDEOGRAPH-5D8B
        0x5EA6, # G+4279  U+5EA6  uni5EA6,  CJK UNIFIED IDEOGRAPH-5EA6
        0x5F92, # G+4280  U+5F92  uni5F92,  CJK UNIFIED IDEOGRAPH-5F92
        0x60BC, # G+4281  U+60BC  uni60BC,  CJK UNIFIED IDEOGRAPH-60BC
        0x6311, # G+4282  U+6311  uni6311,  CJK UNIFIED IDEOGRAPH-6311
        0x6389, # G+4283  U+6389  uni6389,  CJK UNIFIED IDEOGRAPH-6389
        0x6417, # G+4284  U+6417  uni6417,  CJK UNIFIED IDEOGRAPH-6417
        0x6843, # G+4285  U+6843  uni6843,  CJK UNIFIED IDEOGRAPH-6843
        0x68F9, # G+4286  U+68F9  uni68F9,  CJK UNIFIED IDEOGRAPH-68F9
        0x6AC2, # G+4287  U+6AC2  uni6AC2,  CJK UNIFIED IDEOGRAPH-6AC2
        0x6DD8, # G+4288  U+6DD8  uni6DD8,  CJK UNIFIED IDEOGRAPH-6DD8
        0x6E21, # G+4289  U+6E21  uni6E21,  CJK UNIFIED IDEOGRAPH-6E21
        0x6ED4, # G+4290  U+6ED4  uni6ED4,  CJK UNIFIED IDEOGRAPH-6ED4
        0x6FE4, # G+4291  U+6FE4  uni6FE4,  CJK UNIFIED IDEOGRAPH-6FE4
        0x71FE, # G+4292  U+71FE  uni71FE,  CJK UNIFIED IDEOGRAPH-71FE
        0x76DC, # G+4293  U+76DC  uni76DC,  CJK UNIFIED IDEOGRAPH-76DC
        0x7779, # G+4294  U+7779  uni7779,  CJK UNIFIED IDEOGRAPH-7779
        0x79B1, # G+4295  U+79B1  uni79B1,  CJK UNIFIED IDEOGRAPH-79B1
        0x7A3B, # G+4296  U+7A3B  uni7A3B,  CJK UNIFIED IDEOGRAPH-7A3B
        0x8404, # G+4297  U+8404  uni8404,  CJK UNIFIED IDEOGRAPH-8404
        0x89A9, # G+4298  U+89A9  uni89A9,  CJK UNIFIED IDEOGRAPH-89A9
        0x8CED, # G+4299  U+8CED  uni8CED,  CJK UNIFIED IDEOGRAPH-8CED
        0x8DF3, # G+4300  U+8DF3  uni8DF3,  CJK UNIFIED IDEOGRAPH-8DF3
        0x8E48, # G+4301  U+8E48  uni8E48,  CJK UNIFIED IDEOGRAPH-8E48
        0x9003, # G+4302  U+9003  uni9003,  CJK UNIFIED IDEOGRAPH-9003
        0x9014, # G+4303  U+9014  uni9014,  CJK UNIFIED IDEOGRAPH-9014
        0x9053, # G+4304  U+9053  uni9053,  CJK UNIFIED IDEOGRAPH-9053
        0x90FD, # G+4305  U+90FD  uni90FD,  CJK UNIFIED IDEOGRAPH-90FD
        0x934D, # G+4306  U+934D  uni934D,  CJK UNIFIED IDEOGRAPH-934D
        0x9676, # G+4307  U+9676  uni9676,  CJK UNIFIED IDEOGRAPH-9676
        0x97DC, # G+4308  U+97DC  uni97DC,  CJK UNIFIED IDEOGRAPH-97DC
        0x6BD2, # G+4309  U+6BD2  uni6BD2,  CJK UNIFIED IDEOGRAPH-6BD2
        0x7006, # G+4310  U+7006  uni7006,  CJK UNIFIED IDEOGRAPH-7006
        0x7258, # G+4311  U+7258  uni7258,  CJK UNIFIED IDEOGRAPH-7258
        0x72A2, # G+4312  U+72A2  uni72A2,  CJK UNIFIED IDEOGRAPH-72A2
        0x7368, # G+4313  U+7368  uni7368,  CJK UNIFIED IDEOGRAPH-7368
        0x7763, # G+4314  U+7763  uni7763,  CJK UNIFIED IDEOGRAPH-7763
        0x79BF, # G+4315  U+79BF  uni79BF,  CJK UNIFIED IDEOGRAPH-79BF
        0x7BE4, # G+4316  U+7BE4  uni7BE4,  CJK UNIFIED IDEOGRAPH-7BE4
        0x7E9B, # G+4317  U+7E9B  uni7E9B,  CJK UNIFIED IDEOGRAPH-7E9B
        0x8B80, # G+4318  U+8B80  uni8B80,  CJK UNIFIED IDEOGRAPH-8B80
        0x58A9, # G+4319  U+58A9  uni58A9,  CJK UNIFIED IDEOGRAPH-58A9
        0x60C7, # G+4320  U+60C7  uni60C7,  CJK UNIFIED IDEOGRAPH-60C7
        0x6566, # G+4321  U+6566  uni6566,  CJK UNIFIED IDEOGRAPH-6566
        0x65FD, # G+4322  U+65FD  uni65FD,  CJK UNIFIED IDEOGRAPH-65FD
        0x66BE, # G+4323  U+66BE  uni66BE,  CJK UNIFIED IDEOGRAPH-66BE
        0x6C8C, # G+4324  U+6C8C  uni6C8C,  CJK UNIFIED IDEOGRAPH-6C8C
        0x711E, # G+4325  U+711E  uni711E,  CJK UNIFIED IDEOGRAPH-711E
        0x71C9, # G+4326  U+71C9  uni71C9,  CJK UNIFIED IDEOGRAPH-71C9
        0x8C5A, # G+4327  U+8C5A  uni8C5A,  CJK UNIFIED IDEOGRAPH-8C5A
        0x9813, # G+4328  U+9813  uni9813,  CJK UNIFIED IDEOGRAPH-9813
        0x4E6D, # G+4329  U+4E6D  uni4E6D,  CJK UNIFIED IDEOGRAPH-4E6D
        0x7A81, # G+4330  U+7A81  uni7A81,  CJK UNIFIED IDEOGRAPH-7A81
        0x4EDD, # G+4331  U+4EDD  uni4EDD,  CJK UNIFIED IDEOGRAPH-4EDD
        0x51AC, # G+4332  U+51AC  uni51AC,  CJK UNIFIED IDEOGRAPH-51AC
        0x51CD, # G+4333  U+51CD  uni51CD,  CJK UNIFIED IDEOGRAPH-51CD
        0x52D5, # G+4334  U+52D5  uni52D5,  CJK UNIFIED IDEOGRAPH-52D5
        0x540C, # G+4335  U+540C  uni540C,  CJK UNIFIED IDEOGRAPH-540C
        0x61A7, # G+4336  U+61A7  uni61A7,  CJK UNIFIED IDEOGRAPH-61A7
        0x6771, # G+4337  U+6771  uni6771,  CJK UNIFIED IDEOGRAPH-6771
        0x6850, # G+4338  U+6850  uni6850,  CJK UNIFIED IDEOGRAPH-6850
        0x68DF, # G+4339  U+68DF  uni68DF,  CJK UNIFIED IDEOGRAPH-68DF
        0x6D1E, # G+4340  U+6D1E  uni6D1E,  CJK UNIFIED IDEOGRAPH-6D1E
        0x6F7C, # G+4341  U+6F7C  uni6F7C,  CJK UNIFIED IDEOGRAPH-6F7C
        0x75BC, # G+4342  U+75BC  uni75BC,  CJK UNIFIED IDEOGRAPH-75BC
        0x77B3, # G+4343  U+77B3  uni77B3,  CJK UNIFIED IDEOGRAPH-77B3
        0x7AE5, # G+4344  U+7AE5  uni7AE5,  CJK UNIFIED IDEOGRAPH-7AE5
        0x80F4, # G+4345  U+80F4  uni80F4,  CJK UNIFIED IDEOGRAPH-80F4
        0x8463, # G+4346  U+8463  uni8463,  CJK UNIFIED IDEOGRAPH-8463
        0x9285, # G+4347  U+9285  uni9285,  CJK UNIFIED IDEOGRAPH-9285
        0x515C, # G+4348  U+515C  uni515C,  CJK UNIFIED IDEOGRAPH-515C
        0x2F43, # G+4349  U+2F43  uni2F43,  KANGXI RADICAL DIPPER
        0x675C, # G+4350  U+675C  uni675C,  CJK UNIFIED IDEOGRAPH-675C
        0x6793, # G+4351  U+6793  uni6793,  CJK UNIFIED IDEOGRAPH-6793
        0x75D8, # G+4352  U+75D8  uni75D8,  CJK UNIFIED IDEOGRAPH-75D8
        0x7AC7, # G+4353  U+7AC7  uni7AC7,  CJK UNIFIED IDEOGRAPH-7AC7
        0x8373, # G+4354  U+8373  uni8373,  CJK UNIFIED IDEOGRAPH-8373
        0x2F96, # G+4355  U+2F96  uni2F96,  KANGXI RADICAL BEAN
        0x9017, # G+4356  U+9017  uni9017,  CJK UNIFIED IDEOGRAPH-9017
        0x982D, # G+4357  U+982D  uni982D,  CJK UNIFIED IDEOGRAPH-982D
        0x5C6F, # G+4358  U+5C6F  uni5C6F,  CJK UNIFIED IDEOGRAPH-5C6F
        0x81C0, # G+4359  U+81C0  uni81C0,  CJK UNIFIED IDEOGRAPH-81C0
        0x829A, # G+4360  U+829A  uni829A,  CJK UNIFIED IDEOGRAPH-829A
        0x9041, # G+4361  U+9041  uni9041,  CJK UNIFIED IDEOGRAPH-9041
        0x906F, # G+4362  U+906F  uni906F,  CJK UNIFIED IDEOGRAPH-906F
        0x920D, # G+4363  U+920D  uni920D,  CJK UNIFIED IDEOGRAPH-920D
        0x5F97, # G+4364  U+5F97  uni5F97,  CJK UNIFIED IDEOGRAPH-5F97
        0x5D9D, # G+4365  U+5D9D  uni5D9D,  CJK UNIFIED IDEOGRAPH-5D9D
        0x6A59, # G+4366  U+6A59  uni6A59,  CJK UNIFIED IDEOGRAPH-6A59
        0x71C8, # G+4367  U+71C8  uni71C8,  CJK UNIFIED IDEOGRAPH-71C8
        0x767B, # G+4368  U+767B  uni767B,  CJK UNIFIED IDEOGRAPH-767B
        0x7B49, # G+4369  U+7B49  uni7B49,  CJK UNIFIED IDEOGRAPH-7B49
        0x85E4, # G+4370  U+85E4  uni85E4,  CJK UNIFIED IDEOGRAPH-85E4
        0x8B04, # G+4371  U+8B04  uni8B04,  CJK UNIFIED IDEOGRAPH-8B04
        0x9127, # G+4372  U+9127  uni9127,  CJK UNIFIED IDEOGRAPH-9127
        0x9A30, # G+4373  U+9A30  uni9A30,  CJK UNIFIED IDEOGRAPH-9A30
        0x5587, # G+4374  U+5587  uni5587,  CJK UNIFIED IDEOGRAPH-5587
        0x61F6, # G+4375  U+61F6  uni61F6,  CJK UNIFIED IDEOGRAPH-61F6
        0x7669, # G+4376  U+7669  uni7669,  CJK UNIFIED IDEOGRAPH-7669
        0x7F85, # G+4377  U+7F85  uni7F85,  CJK UNIFIED IDEOGRAPH-7F85
        0x863F, # G+4378  U+863F  uni863F,  CJK UNIFIED IDEOGRAPH-863F
        0x87BA, # G+4379  U+87BA  uni87BA,  CJK UNIFIED IDEOGRAPH-87BA
        0x88F8, # G+4380  U+88F8  uni88F8,  CJK UNIFIED IDEOGRAPH-88F8
        0x908F, # G+4381  U+908F  uni908F,  CJK UNIFIED IDEOGRAPH-908F
        0x6D1B, # G+4382  U+6D1B  uni6D1B,  CJK UNIFIED IDEOGRAPH-6D1B
        0x70D9, # G+4383  U+70D9  uni70D9,  CJK UNIFIED IDEOGRAPH-70D9
        0x73DE, # G+4384  U+73DE  uni73DE,  CJK UNIFIED IDEOGRAPH-73DE
        0x7D61, # G+4385  U+7D61  uni7D61,  CJK UNIFIED IDEOGRAPH-7D61
        0x843D, # G+4386  U+843D  uni843D,  CJK UNIFIED IDEOGRAPH-843D
        0x916A, # G+4387  U+916A  uni916A,  CJK UNIFIED IDEOGRAPH-916A
        0x99F1, # G+4388  U+99F1  uni99F1,  CJK UNIFIED IDEOGRAPH-99F1
        0x4E82, # G+4389  U+4E82  uni4E82,  CJK UNIFIED IDEOGRAPH-4E82
        0x5375, # G+4390  U+5375  uni5375,  CJK UNIFIED IDEOGRAPH-5375
        0x6B04, # G+4391  U+6B04  uni6B04,  CJK UNIFIED IDEOGRAPH-6B04
        0x6B12, # G+4392  U+6B12  uni6B12,  CJK UNIFIED IDEOGRAPH-6B12
        0x703E, # G+4393  U+703E  uni703E,  CJK UNIFIED IDEOGRAPH-703E
        0x721B, # G+4394  U+721B  uni721B,  CJK UNIFIED IDEOGRAPH-721B
        0x862D, # G+4395  U+862D  uni862D,  CJK UNIFIED IDEOGRAPH-862D
        0x9E1E, # G+4396  U+9E1E  uni9E1E,  CJK UNIFIED IDEOGRAPH-9E1E
        0x524C, # G+4397  U+524C  uni524C,  CJK UNIFIED IDEOGRAPH-524C
        0x8FA3, # G+4398  U+8FA3  uni8FA3,  CJK UNIFIED IDEOGRAPH-8FA3
        0x5D50, # G+4399  U+5D50  uni5D50,  CJK UNIFIED IDEOGRAPH-5D50
        0x64E5, # G+4400  U+64E5  uni64E5,  CJK UNIFIED IDEOGRAPH-64E5
        0x652C, # G+4401  U+652C  uni652C,  CJK UNIFIED IDEOGRAPH-652C
        0x6B16, # G+4402  U+6B16  uni6B16,  CJK UNIFIED IDEOGRAPH-6B16
        0x6FEB, # G+4403  U+6FEB  uni6FEB,  CJK UNIFIED IDEOGRAPH-6FEB
        0x7C43, # G+4404  U+7C43  uni7C43,  CJK UNIFIED IDEOGRAPH-7C43
        0x7E9C, # G+4405  U+7E9C  uni7E9C,  CJK UNIFIED IDEOGRAPH-7E9C
        0x85CD, # G+4406  U+85CD  uni85CD,  CJK UNIFIED IDEOGRAPH-85CD
        0x8964, # G+4407  U+8964  uni8964,  CJK UNIFIED IDEOGRAPH-8964
        0x89BD, # G+4408  U+89BD  uni89BD,  CJK UNIFIED IDEOGRAPH-89BD
        0x62C9, # G+4409  U+62C9  uni62C9,  CJK UNIFIED IDEOGRAPH-62C9
        0x81D8, # G+4410  U+81D8  uni81D8,  CJK UNIFIED IDEOGRAPH-81D8
        0x881F, # G+4411  U+881F  uni881F,  CJK UNIFIED IDEOGRAPH-881F
        0x5ECA, # G+4412  U+5ECA  uni5ECA,  CJK UNIFIED IDEOGRAPH-5ECA
        0x6717, # G+4413  U+6717  uni6717,  CJK UNIFIED IDEOGRAPH-6717
        0x6D6A, # G+4414  U+6D6A  uni6D6A,  CJK UNIFIED IDEOGRAPH-6D6A
        0x72FC, # G+4415  U+72FC  uni72FC,  CJK UNIFIED IDEOGRAPH-72FC
        0x7405, # G+4416  U+7405  uni7405,  CJK UNIFIED IDEOGRAPH-7405
        0x746F, # G+4417  U+746F  uni746F,  CJK UNIFIED IDEOGRAPH-746F
        0x8782, # G+4418  U+8782  uni8782,  CJK UNIFIED IDEOGRAPH-8782
        0x90DE, # G+4419  U+90DE  uni90DE,  CJK UNIFIED IDEOGRAPH-90DE
        0x4F86, # G+4420  U+4F86  uni4F86,  CJK UNIFIED IDEOGRAPH-4F86
        0x5D0D, # G+4421  U+5D0D  uni5D0D,  CJK UNIFIED IDEOGRAPH-5D0D
        0x5FA0, # G+4422  U+5FA0  uni5FA0,  CJK UNIFIED IDEOGRAPH-5FA0
        0x840A, # G+4423  U+840A  uni840A,  CJK UNIFIED IDEOGRAPH-840A
        0x51B7, # G+4424  U+51B7  uni51B7,  CJK UNIFIED IDEOGRAPH-51B7
        0x63A0, # G+4425  U+63A0  uni63A0,  CJK UNIFIED IDEOGRAPH-63A0
        0x7565, # G+4426  U+7565  uni7565,  CJK UNIFIED IDEOGRAPH-7565
        0x4EAE, # G+4427  U+4EAE  uni4EAE,  CJK UNIFIED IDEOGRAPH-4EAE
        0x5006, # G+4428  U+5006  uni5006,  CJK UNIFIED IDEOGRAPH-5006
        0x5169, # G+4429  U+5169  uni5169,  CJK UNIFIED IDEOGRAPH-5169
        0x51C9, # G+4430  U+51C9  uni51C9,  CJK UNIFIED IDEOGRAPH-51C9
        0x6881, # G+4431  U+6881  uni6881,  CJK UNIFIED IDEOGRAPH-6881
        0x6A11, # G+4432  U+6A11  uni6A11,  CJK UNIFIED IDEOGRAPH-6A11
        0x7CAE, # G+4433  U+7CAE  uni7CAE,  CJK UNIFIED IDEOGRAPH-7CAE
        0x7CB1, # G+4434  U+7CB1  uni7CB1,  CJK UNIFIED IDEOGRAPH-7CB1
        0x7CE7, # G+4435  U+7CE7  uni7CE7,  CJK UNIFIED IDEOGRAPH-7CE7
        0x826F, # G+4436  U+826F  uni826F,  CJK UNIFIED IDEOGRAPH-826F
        0x8AD2, # G+4437  U+8AD2  uni8AD2,  CJK UNIFIED IDEOGRAPH-8AD2
        0x8F1B, # G+4438  U+8F1B  uni8F1B,  CJK UNIFIED IDEOGRAPH-8F1B
        0x91CF, # G+4439  U+91CF  uni91CF,  CJK UNIFIED IDEOGRAPH-91CF
        0x4FB6, # G+4440  U+4FB6  uni4FB6,  CJK UNIFIED IDEOGRAPH-4FB6
        0x5137, # G+4441  U+5137  uni5137,  CJK UNIFIED IDEOGRAPH-5137
        0x52F5, # G+4442  U+52F5  uni52F5,  CJK UNIFIED IDEOGRAPH-52F5
        0x5442, # G+4443  U+5442  uni5442,  CJK UNIFIED IDEOGRAPH-5442
        0x5EEC, # G+4444  U+5EEC  uni5EEC,  CJK UNIFIED IDEOGRAPH-5EEC
        0x616E, # G+4445  U+616E  uni616E,  CJK UNIFIED IDEOGRAPH-616E
        0x623E, # G+4446  U+623E  uni623E,  CJK UNIFIED IDEOGRAPH-623E
        0x65C5, # G+4447  U+65C5  uni65C5,  CJK UNIFIED IDEOGRAPH-65C5
        0x6ADA, # G+4448  U+6ADA  uni6ADA,  CJK UNIFIED IDEOGRAPH-6ADA
        0x6FFE, # G+4449  U+6FFE  uni6FFE,  CJK UNIFIED IDEOGRAPH-6FFE
        0x792A, # G+4450  U+792A  uni792A,  CJK UNIFIED IDEOGRAPH-792A
        0x85DC, # G+4451  U+85DC  uni85DC,  CJK UNIFIED IDEOGRAPH-85DC
        0x8823, # G+4452  U+8823  uni8823,  CJK UNIFIED IDEOGRAPH-8823
        0x95AD, # G+4453  U+95AD  uni95AD,  CJK UNIFIED IDEOGRAPH-95AD
        0x9A62, # G+4454  U+9A62  uni9A62,  CJK UNIFIED IDEOGRAPH-9A62
        0x9A6A, # G+4455  U+9A6A  uni9A6A,  CJK UNIFIED IDEOGRAPH-9A6A
        0x9E97, # G+4456  U+9E97  uni9E97,  CJK UNIFIED IDEOGRAPH-9E97
        0x9ECE, # G+4457  U+9ECE  uni9ECE,  CJK UNIFIED IDEOGRAPH-9ECE
        0x2F12, # G+4458  U+2F12  uni2F12,  KANGXI RADICAL POWER
        0x66C6, # G+4459  U+66C6  uni66C6,  CJK UNIFIED IDEOGRAPH-66C6
        0x6B77, # G+4460  U+6B77  uni6B77,  CJK UNIFIED IDEOGRAPH-6B77
        0x701D, # G+4461  U+701D  uni701D,  CJK UNIFIED IDEOGRAPH-701D
        0x792B, # G+4462  U+792B  uni792B,  CJK UNIFIED IDEOGRAPH-792B
        0x8F62, # G+4463  U+8F62  uni8F62,  CJK UNIFIED IDEOGRAPH-8F62
        0x9742, # G+4464  U+9742  uni9742,  CJK UNIFIED IDEOGRAPH-9742
        0x6190, # G+4465  U+6190  uni6190,  CJK UNIFIED IDEOGRAPH-6190
        0x6200, # G+4466  U+6200  uni6200,  CJK UNIFIED IDEOGRAPH-6200
        0x6523, # G+4467  U+6523  uni6523,  CJK UNIFIED IDEOGRAPH-6523
        0x6F23, # G+4468  U+6F23  uni6F23,  CJK UNIFIED IDEOGRAPH-6F23
        0x7149, # G+4469  U+7149  uni7149,  CJK UNIFIED IDEOGRAPH-7149
        0x7489, # G+4470  U+7489  uni7489,  CJK UNIFIED IDEOGRAPH-7489
        0x7DF4, # G+4471  U+7DF4  uni7DF4,  CJK UNIFIED IDEOGRAPH-7DF4
        0x806F, # G+4472  U+806F  uni806F,  CJK UNIFIED IDEOGRAPH-806F
        0x84EE, # G+4473  U+84EE  uni84EE,  CJK UNIFIED IDEOGRAPH-84EE
        0x8F26, # G+4474  U+8F26  uni8F26,  CJK UNIFIED IDEOGRAPH-8F26
        0x9023, # G+4475  U+9023  uni9023,  CJK UNIFIED IDEOGRAPH-9023
        0x934A, # G+4476  U+934A  uni934A,  CJK UNIFIED IDEOGRAPH-934A
        0x51BD, # G+4477  U+51BD  uni51BD,  CJK UNIFIED IDEOGRAPH-51BD
        0x5217, # G+4478  U+5217  uni5217,  CJK UNIFIED IDEOGRAPH-5217
        0x52A3, # G+4479  U+52A3  uni52A3,  CJK UNIFIED IDEOGRAPH-52A3
        0x6D0C, # G+4480  U+6D0C  uni6D0C,  CJK UNIFIED IDEOGRAPH-6D0C
        0x70C8, # G+4481  U+70C8  uni70C8,  CJK UNIFIED IDEOGRAPH-70C8
        0x88C2, # G+4482  U+88C2  uni88C2,  CJK UNIFIED IDEOGRAPH-88C2
        0x5EC9, # G+4483  U+5EC9  uni5EC9,  CJK UNIFIED IDEOGRAPH-5EC9
        0x6582, # G+4484  U+6582  uni6582,  CJK UNIFIED IDEOGRAPH-6582
        0x6BAE, # G+4485  U+6BAE  uni6BAE,  CJK UNIFIED IDEOGRAPH-6BAE
        0x6FC2, # G+4486  U+6FC2  uni6FC2,  CJK UNIFIED IDEOGRAPH-6FC2
        0x7C3E, # G+4487  U+7C3E  uni7C3E,  CJK UNIFIED IDEOGRAPH-7C3E
        0x7375, # G+4488  U+7375  uni7375,  CJK UNIFIED IDEOGRAPH-7375
        0x4EE4, # G+4489  U+4EE4  uni4EE4,  CJK UNIFIED IDEOGRAPH-4EE4
        0x4F36, # G+4490  U+4F36  uni4F36,  CJK UNIFIED IDEOGRAPH-4F36
        0x56F9, # G+4491  U+56F9  uni56F9,  CJK UNIFIED IDEOGRAPH-56F9
        0x5CBA, # G+4492  U+5CBA  uni5CBA,  CJK UNIFIED IDEOGRAPH-5CBA
        0x5DBA, # G+4493  U+5DBA  uni5DBA,  CJK UNIFIED IDEOGRAPH-5DBA
        0x601C, # G+4494  U+601C  uni601C,  CJK UNIFIED IDEOGRAPH-601C
        0x73B2, # G+4495  U+73B2  uni73B2,  CJK UNIFIED IDEOGRAPH-73B2
        0x7B2D, # G+4496  U+7B2D  uni7B2D,  CJK UNIFIED IDEOGRAPH-7B2D
        0x7F9A, # G+4497  U+7F9A  uni7F9A,  CJK UNIFIED IDEOGRAPH-7F9A
        0x7FCE, # G+4498  U+7FCE  uni7FCE,  CJK UNIFIED IDEOGRAPH-7FCE
        0x8046, # G+4499  U+8046  uni8046,  CJK UNIFIED IDEOGRAPH-8046
        0x901E, # G+4500  U+901E  uni901E,  CJK UNIFIED IDEOGRAPH-901E
        0x9234, # G+4501  U+9234  uni9234,  CJK UNIFIED IDEOGRAPH-9234
        0x96F6, # G+4502  U+96F6  uni96F6,  CJK UNIFIED IDEOGRAPH-96F6
        0x9748, # G+4503  U+9748  uni9748,  CJK UNIFIED IDEOGRAPH-9748
        0x9818, # G+4504  U+9818  uni9818,  CJK UNIFIED IDEOGRAPH-9818
        0x9F61, # G+4505  U+9F61  uni9F61,  CJK UNIFIED IDEOGRAPH-9F61
        0x4F8B, # G+4506  U+4F8B  uni4F8B,  CJK UNIFIED IDEOGRAPH-4F8B
        0x6FA7, # G+4507  U+6FA7  uni6FA7,  CJK UNIFIED IDEOGRAPH-6FA7
        0x79AE, # G+4508  U+79AE  uni79AE,  CJK UNIFIED IDEOGRAPH-79AE
        0x91B4, # G+4509  U+91B4  uni91B4,  CJK UNIFIED IDEOGRAPH-91B4
        0x96B7, # G+4510  U+96B7  uni96B7,  CJK UNIFIED IDEOGRAPH-96B7
        0x52DE, # G+4511  U+52DE  uni52DE,  CJK UNIFIED IDEOGRAPH-52DE
        0x6488, # G+4512  U+6488  uni6488,  CJK UNIFIED IDEOGRAPH-6488
        0x64C4, # G+4513  U+64C4  uni64C4,  CJK UNIFIED IDEOGRAPH-64C4
        0x6AD3, # G+4514  U+6AD3  uni6AD3,  CJK UNIFIED IDEOGRAPH-6AD3
        0x6F5E, # G+4515  U+6F5E  uni6F5E,  CJK UNIFIED IDEOGRAPH-6F5E
        0x7018, # G+4516  U+7018  uni7018,  CJK UNIFIED IDEOGRAPH-7018
        0x7210, # G+4517  U+7210  uni7210,  CJK UNIFIED IDEOGRAPH-7210
        0x76E7, # G+4518  U+76E7  uni76E7,  CJK UNIFIED IDEOGRAPH-76E7
        0x2F7C, # G+4519  U+2F7C  uni2F7C,  KANGXI RADICAL OLD
        0x8606, # G+4520  U+8606  uni8606,  CJK UNIFIED IDEOGRAPH-8606
        0x865C, # G+4521  U+865C  uni865C,  CJK UNIFIED IDEOGRAPH-865C
        0x8DEF, # G+4522  U+8DEF  uni8DEF,  CJK UNIFIED IDEOGRAPH-8DEF
        0x8F05, # G+4523  U+8F05  uni8F05,  CJK UNIFIED IDEOGRAPH-8F05
        0x9732, # G+4524  U+9732  uni9732,  CJK UNIFIED IDEOGRAPH-9732
        0x9B6F, # G+4525  U+9B6F  uni9B6F,  CJK UNIFIED IDEOGRAPH-9B6F
        0x9DFA, # G+4526  U+9DFA  uni9DFA,  CJK UNIFIED IDEOGRAPH-9DFA
        0x2FC4, # G+4527  U+2FC4  uni2FC4,  KANGXI RADICAL SALT
        0x788C, # G+4528  U+788C  uni788C,  CJK UNIFIED IDEOGRAPH-788C
        0x797F, # G+4529  U+797F  uni797F,  CJK UNIFIED IDEOGRAPH-797F
        0x7DA0, # G+4530  U+7DA0  uni7DA0,  CJK UNIFIED IDEOGRAPH-7DA0
        0x83C9, # G+4531  U+83C9  uni83C9,  CJK UNIFIED IDEOGRAPH-83C9
        0x9304, # G+4532  U+9304  uni9304,  CJK UNIFIED IDEOGRAPH-9304
        0x2FC5, # G+4533  U+2FC5  uni2FC5,  KANGXI RADICAL DEER
        0x9E93, # G+4534  U+9E93  uni9E93,  CJK UNIFIED IDEOGRAPH-9E93
        0x8AD6, # G+4535  U+8AD6  uni8AD6,  CJK UNIFIED IDEOGRAPH-8AD6
        0x58DF, # G+4536  U+58DF  uni58DF,  CJK UNIFIED IDEOGRAPH-58DF
        0x5F04, # G+4537  U+5F04  uni5F04,  CJK UNIFIED IDEOGRAPH-5F04
        0x6727, # G+4538  U+6727  uni6727,  CJK UNIFIED IDEOGRAPH-6727
        0x7027, # G+4539  U+7027  uni7027,  CJK UNIFIED IDEOGRAPH-7027
        0x74CF, # G+4540  U+74CF  uni74CF,  CJK UNIFIED IDEOGRAPH-74CF
        0x7C60, # G+4541  U+7C60  uni7C60,  CJK UNIFIED IDEOGRAPH-7C60
        0x807E, # G+4542  U+807E  uni807E,  CJK UNIFIED IDEOGRAPH-807E
        0x5121, # G+4543  U+5121  uni5121,  CJK UNIFIED IDEOGRAPH-5121
        0x7028, # G+4544  U+7028  uni7028,  CJK UNIFIED IDEOGRAPH-7028
        0x7262, # G+4545  U+7262  uni7262,  CJK UNIFIED IDEOGRAPH-7262
        0x78CA, # G+4546  U+78CA  uni78CA,  CJK UNIFIED IDEOGRAPH-78CA
        0x8CC2, # G+4547  U+8CC2  uni8CC2,  CJK UNIFIED IDEOGRAPH-8CC2
        0x8CDA, # G+4548  U+8CDA  uni8CDA,  CJK UNIFIED IDEOGRAPH-8CDA
        0x8CF4, # G+4549  U+8CF4  uni8CF4,  CJK UNIFIED IDEOGRAPH-8CF4
        0x96F7, # G+4550  U+96F7  uni96F7,  CJK UNIFIED IDEOGRAPH-96F7
        0x4E86, # G+4551  U+4E86  uni4E86,  CJK UNIFIED IDEOGRAPH-4E86
        0x50DA, # G+4552  U+50DA  uni50DA,  CJK UNIFIED IDEOGRAPH-50DA
        0x5BEE, # G+4553  U+5BEE  uni5BEE,  CJK UNIFIED IDEOGRAPH-5BEE
        0x5ED6, # G+4554  U+5ED6  uni5ED6,  CJK UNIFIED IDEOGRAPH-5ED6
        0x6599, # G+4555  U+6599  uni6599,  CJK UNIFIED IDEOGRAPH-6599
        0x71CE, # G+4556  U+71CE  uni71CE,  CJK UNIFIED IDEOGRAPH-71CE
        0x7642, # G+4557  U+7642  uni7642,  CJK UNIFIED IDEOGRAPH-7642
        0x77AD, # G+4558  U+77AD  uni77AD,  CJK UNIFIED IDEOGRAPH-77AD
        0x804A, # G+4559  U+804A  uni804A,  CJK UNIFIED IDEOGRAPH-804A
        0x84FC, # G+4560  U+84FC  uni84FC,  CJK UNIFIED IDEOGRAPH-84FC
        0x907C, # G+4561  U+907C  uni907C,  CJK UNIFIED IDEOGRAPH-907C
        0x9B27, # G+4562  U+9B27  uni9B27,  CJK UNIFIED IDEOGRAPH-9B27
        0x2FD3, # G+4563  U+2FD3  uni2FD3,  KANGXI RADICAL DRAGON
        0x58D8, # G+4564  U+58D8  uni58D8,  CJK UNIFIED IDEOGRAPH-58D8
        0x5A41, # G+4565  U+5A41  uni5A41,  CJK UNIFIED IDEOGRAPH-5A41
        0x5C62, # G+4566  U+5C62  uni5C62,  CJK UNIFIED IDEOGRAPH-5C62
        0x6A13, # G+4567  U+6A13  uni6A13,  CJK UNIFIED IDEOGRAPH-6A13
        0x6DDA, # G+4568  U+6DDA  uni6DDA,  CJK UNIFIED IDEOGRAPH-6DDA
        0x6F0F, # G+4569  U+6F0F  uni6F0F,  CJK UNIFIED IDEOGRAPH-6F0F
        0x763B, # G+4570  U+763B  uni763B,  CJK UNIFIED IDEOGRAPH-763B
        0x7D2F, # G+4571  U+7D2F  uni7D2F,  CJK UNIFIED IDEOGRAPH-7D2F
        0x7E37, # G+4572  U+7E37  uni7E37,  CJK UNIFIED IDEOGRAPH-7E37
        0x851E, # G+4573  U+851E  uni851E,  CJK UNIFIED IDEOGRAPH-851E
        0x8938, # G+4574  U+8938  uni8938,  CJK UNIFIED IDEOGRAPH-8938
        0x93E4, # G+4575  U+93E4  uni93E4,  CJK UNIFIED IDEOGRAPH-93E4
        0x964B, # G+4576  U+964B  uni964B,  CJK UNIFIED IDEOGRAPH-964B
        0x5289, # G+4577  U+5289  uni5289,  CJK UNIFIED IDEOGRAPH-5289
        0x65D2, # G+4578  U+65D2  uni65D2,  CJK UNIFIED IDEOGRAPH-65D2
        0x67F3, # G+4579  U+67F3  uni67F3,  CJK UNIFIED IDEOGRAPH-67F3
        0x69B4, # G+4580  U+69B4  uni69B4,  CJK UNIFIED IDEOGRAPH-69B4
        0x6D41, # G+4581  U+6D41  uni6D41,  CJK UNIFIED IDEOGRAPH-6D41
        0x6E9C, # G+4582  U+6E9C  uni6E9C,  CJK UNIFIED IDEOGRAPH-6E9C
        0x700F, # G+4583  U+700F  uni700F,  CJK UNIFIED IDEOGRAPH-700F
        0x7409, # G+4584  U+7409  uni7409,  CJK UNIFIED IDEOGRAPH-7409
        0x7460, # G+4585  U+7460  uni7460,  CJK UNIFIED IDEOGRAPH-7460
        0x7559, # G+4586  U+7559  uni7559,  CJK UNIFIED IDEOGRAPH-7559
        0x7624, # G+4587  U+7624  uni7624,  CJK UNIFIED IDEOGRAPH-7624
        0x786B, # G+4588  U+786B  uni786B,  CJK UNIFIED IDEOGRAPH-786B
        0x8B2C, # G+4589  U+8B2C  uni8B2C,  CJK UNIFIED IDEOGRAPH-8B2C
        0x985E, # G+4590  U+985E  uni985E,  CJK UNIFIED IDEOGRAPH-985E
        0x516D, # G+4591  U+516D  uni516D,  CJK UNIFIED IDEOGRAPH-516D
        0x622E, # G+4592  U+622E  uni622E,  CJK UNIFIED IDEOGRAPH-622E
        0x9678, # G+4593  U+9678  uni9678,  CJK UNIFIED IDEOGRAPH-9678
        0x4F96, # G+4594  U+4F96  uni4F96,  CJK UNIFIED IDEOGRAPH-4F96
        0x502B, # G+4595  U+502B  uni502B,  CJK UNIFIED IDEOGRAPH-502B
        0x5D19, # G+4596  U+5D19  uni5D19,  CJK UNIFIED IDEOGRAPH-5D19
        0x6DEA, # G+4597  U+6DEA  uni6DEA,  CJK UNIFIED IDEOGRAPH-6DEA
        0x7DB8, # G+4598  U+7DB8  uni7DB8,  CJK UNIFIED IDEOGRAPH-7DB8
        0x8F2A, # G+4599  U+8F2A  uni8F2A,  CJK UNIFIED IDEOGRAPH-8F2A
        0x5F8B, # G+4600  U+5F8B  uni5F8B,  CJK UNIFIED IDEOGRAPH-5F8B
        0x6144, # G+4601  U+6144  uni6144,  CJK UNIFIED IDEOGRAPH-6144
        0x6817, # G+4602  U+6817  uni6817,  CJK UNIFIED IDEOGRAPH-6817
        0x9686, # G+4603  U+9686  uni9686,  CJK UNIFIED IDEOGRAPH-9686
        0x52D2, # G+4604  U+52D2  uni52D2,  CJK UNIFIED IDEOGRAPH-52D2
        0x808B, # G+4605  U+808B  uni808B,  CJK UNIFIED IDEOGRAPH-808B
        0x51DC, # G+4606  U+51DC  uni51DC,  CJK UNIFIED IDEOGRAPH-51DC
        0x51CC, # G+4607  U+51CC  uni51CC,  CJK UNIFIED IDEOGRAPH-51CC
        0x695E, # G+4608  U+695E  uni695E,  CJK UNIFIED IDEOGRAPH-695E
        0x7A1C, # G+4609  U+7A1C  uni7A1C,  CJK UNIFIED IDEOGRAPH-7A1C
        0x7DBE, # G+4610  U+7DBE  uni7DBE,  CJK UNIFIED IDEOGRAPH-7DBE
        0x83F1, # G+4611  U+83F1  uni83F1,  CJK UNIFIED IDEOGRAPH-83F1
        0x9675, # G+4612  U+9675  uni9675,  CJK UNIFIED IDEOGRAPH-9675
        0x4FDA, # G+4613  U+4FDA  uni4FDA,  CJK UNIFIED IDEOGRAPH-4FDA
        0x5229, # G+4614  U+5229  uni5229,  CJK UNIFIED IDEOGRAPH-5229
        0x5398, # G+4615  U+5398  uni5398,  CJK UNIFIED IDEOGRAPH-5398
        0x540F, # G+4616  U+540F  uni540F,  CJK UNIFIED IDEOGRAPH-540F
        0x550E, # G+4617  U+550E  uni550E,  CJK UNIFIED IDEOGRAPH-550E
        0x5C65, # G+4618  U+5C65  uni5C65,  CJK UNIFIED IDEOGRAPH-5C65
        0x60A7, # G+4619  U+60A7  uni60A7,  CJK UNIFIED IDEOGRAPH-60A7
        0x674E, # G+4620  U+674E  uni674E,  CJK UNIFIED IDEOGRAPH-674E
        0x68A8, # G+4621  U+68A8  uni68A8,  CJK UNIFIED IDEOGRAPH-68A8
        0x6D6C, # G+4622  U+6D6C  uni6D6C,  CJK UNIFIED IDEOGRAPH-6D6C
        0x7281, # G+4623  U+7281  uni7281,  CJK UNIFIED IDEOGRAPH-7281
        0x72F8, # G+4624  U+72F8  uni72F8,  CJK UNIFIED IDEOGRAPH-72F8
        0x7406, # G+4625  U+7406  uni7406,  CJK UNIFIED IDEOGRAPH-7406
        0x7483, # G+4626  U+7483  uni7483,  CJK UNIFIED IDEOGRAPH-7483
        0x75E2, # G+4627  U+75E2  uni75E2,  CJK UNIFIED IDEOGRAPH-75E2
        0x7C6C, # G+4628  U+7C6C  uni7C6C,  CJK UNIFIED IDEOGRAPH-7C6C
        0x7F79, # G+4629  U+7F79  uni7F79,  CJK UNIFIED IDEOGRAPH-7F79
        0x7FB8, # G+4630  U+7FB8  uni7FB8,  CJK UNIFIED IDEOGRAPH-7FB8
        0x8389, # G+4631  U+8389  uni8389,  CJK UNIFIED IDEOGRAPH-8389
        0x88CF, # G+4632  U+88CF  uni88CF,  CJK UNIFIED IDEOGRAPH-88CF
        0x88E1, # G+4633  U+88E1  uni88E1,  CJK UNIFIED IDEOGRAPH-88E1
        0x2FA5, # G+4634  U+2FA5  uni2FA5,  KANGXI RADICAL VILLAGE
        0x91D0, # G+4635  U+91D0  uni91D0,  CJK UNIFIED IDEOGRAPH-91D0
        0x96E2, # G+4636  U+96E2  uni96E2,  CJK UNIFIED IDEOGRAPH-96E2
        0x9BC9, # G+4637  U+9BC9  uni9BC9,  CJK UNIFIED IDEOGRAPH-9BC9
        0x541D, # G+4638  U+541D  uni541D,  CJK UNIFIED IDEOGRAPH-541D
        0x6F7E, # G+4639  U+6F7E  uni6F7E,  CJK UNIFIED IDEOGRAPH-6F7E
        0x71D0, # G+4640  U+71D0  uni71D0,  CJK UNIFIED IDEOGRAPH-71D0
        0x7498, # G+4641  U+7498  uni7498,  CJK UNIFIED IDEOGRAPH-7498
        0x85FA, # G+4642  U+85FA  uni85FA,  CJK UNIFIED IDEOGRAPH-85FA
        0x8EAA, # G+4643  U+8EAA  uni8EAA,  CJK UNIFIED IDEOGRAPH-8EAA
        0x96A3, # G+4644  U+96A3  uni96A3,  CJK UNIFIED IDEOGRAPH-96A3
        0x9C57, # G+4645  U+9C57  uni9C57,  CJK UNIFIED IDEOGRAPH-9C57
        0x9E9F, # G+4646  U+9E9F  uni9E9F,  CJK UNIFIED IDEOGRAPH-9E9F
        0x6797, # G+4647  U+6797  uni6797,  CJK UNIFIED IDEOGRAPH-6797
        0x6DCB, # G+4648  U+6DCB  uni6DCB,  CJK UNIFIED IDEOGRAPH-6DCB
        0x7433, # G+4649  U+7433  uni7433,  CJK UNIFIED IDEOGRAPH-7433
        0x81E8, # G+4650  U+81E8  uni81E8,  CJK UNIFIED IDEOGRAPH-81E8
        0x9716, # G+4651  U+9716  uni9716,  CJK UNIFIED IDEOGRAPH-9716
        0x782C, # G+4652  U+782C  uni782C,  CJK UNIFIED IDEOGRAPH-782C
        0x2F74, # G+4653  U+2F74  uni2F74,  KANGXI RADICAL STAND
        0x7B20, # G+4654  U+7B20  uni7B20,  CJK UNIFIED IDEOGRAPH-7B20
        0x7C92, # G+4655  U+7C92  uni7C92,  CJK UNIFIED IDEOGRAPH-7C92
        0x6469, # G+4656  U+6469  uni6469,  CJK UNIFIED IDEOGRAPH-6469
        0x746A, # G+4657  U+746A  uni746A,  CJK UNIFIED IDEOGRAPH-746A
        0x75F2, # G+4658  U+75F2  uni75F2,  CJK UNIFIED IDEOGRAPH-75F2
        0x78BC, # G+4659  U+78BC  uni78BC,  CJK UNIFIED IDEOGRAPH-78BC
        0x78E8, # G+4660  U+78E8  uni78E8,  CJK UNIFIED IDEOGRAPH-78E8
        0x2FBA, # G+4661  U+2FBA  uni2FBA,  KANGXI RADICAL HORSE
        0x9B54, # G+4662  U+9B54  uni9B54,  CJK UNIFIED IDEOGRAPH-9B54
        0x2FC7, # G+4663  U+2FC7  uni2FC7,  KANGXI RADICAL HEMP
        0x5BDE, # G+4664  U+5BDE  uni5BDE,  CJK UNIFIED IDEOGRAPH-5BDE
        0x5E55, # G+4665  U+5E55  uni5E55,  CJK UNIFIED IDEOGRAPH-5E55
        0x6F20, # G+4666  U+6F20  uni6F20,  CJK UNIFIED IDEOGRAPH-6F20
        0x819C, # G+4667  U+819C  uni819C,  CJK UNIFIED IDEOGRAPH-819C
        0x83AB, # G+4668  U+83AB  uni83AB,  CJK UNIFIED IDEOGRAPH-83AB
        0x9088, # G+4669  U+9088  uni9088,  CJK UNIFIED IDEOGRAPH-9088
        0x4E07, # G+4670  U+4E07  uni4E07,  CJK UNIFIED IDEOGRAPH-4E07
        0x534D, # G+4671  U+534D  uni534D,  CJK UNIFIED IDEOGRAPH-534D
        0x5A29, # G+4672  U+5A29  uni5A29,  CJK UNIFIED IDEOGRAPH-5A29
        0x5DD2, # G+4673  U+5DD2  uni5DD2,  CJK UNIFIED IDEOGRAPH-5DD2
        0x5F4E, # G+4674  U+5F4E  uni5F4E,  CJK UNIFIED IDEOGRAPH-5F4E
        0x6162, # G+4675  U+6162  uni6162,  CJK UNIFIED IDEOGRAPH-6162
        0x633D, # G+4676  U+633D  uni633D,  CJK UNIFIED IDEOGRAPH-633D
        0x6669, # G+4677  U+6669  uni6669,  CJK UNIFIED IDEOGRAPH-6669
        0x66FC, # G+4678  U+66FC  uni66FC,  CJK UNIFIED IDEOGRAPH-66FC
        0x6EFF, # G+4679  U+6EFF  uni6EFF,  CJK UNIFIED IDEOGRAPH-6EFF
        0x6F2B, # G+4680  U+6F2B  uni6F2B,  CJK UNIFIED IDEOGRAPH-6F2B
        0x7063, # G+4681  U+7063  uni7063,  CJK UNIFIED IDEOGRAPH-7063
        0x779E, # G+4682  U+779E  uni779E,  CJK UNIFIED IDEOGRAPH-779E
        0x842C, # G+4683  U+842C  uni842C,  CJK UNIFIED IDEOGRAPH-842C
        0x8513, # G+4684  U+8513  uni8513,  CJK UNIFIED IDEOGRAPH-8513
        0x883B, # G+4685  U+883B  uni883B,  CJK UNIFIED IDEOGRAPH-883B
        0x8F13, # G+4686  U+8F13  uni8F13,  CJK UNIFIED IDEOGRAPH-8F13
        0x9945, # G+4687  U+9945  uni9945,  CJK UNIFIED IDEOGRAPH-9945
        0x9C3B, # G+4688  U+9C3B  uni9C3B,  CJK UNIFIED IDEOGRAPH-9C3B
        0x551C, # G+4689  U+551C  uni551C,  CJK UNIFIED IDEOGRAPH-551C
        0x62B9, # G+4690  U+62B9  uni62B9,  CJK UNIFIED IDEOGRAPH-62B9
        0x672B, # G+4691  U+672B  uni672B,  CJK UNIFIED IDEOGRAPH-672B
        0x6CAB, # G+4692  U+6CAB  uni6CAB,  CJK UNIFIED IDEOGRAPH-6CAB
        0x8309, # G+4693  U+8309  uni8309,  CJK UNIFIED IDEOGRAPH-8309
        0x896A, # G+4694  U+896A  uni896A,  CJK UNIFIED IDEOGRAPH-896A
        0x977A, # G+4695  U+977A  uni977A,  CJK UNIFIED IDEOGRAPH-977A
        0x4EA1, # G+4696  U+4EA1  uni4EA1,  CJK UNIFIED IDEOGRAPH-4EA1
        0x5984, # G+4697  U+5984  uni5984,  CJK UNIFIED IDEOGRAPH-5984
        0x5FD8, # G+4698  U+5FD8  uni5FD8,  CJK UNIFIED IDEOGRAPH-5FD8
        0x5FD9, # G+4699  U+5FD9  uni5FD9,  CJK UNIFIED IDEOGRAPH-5FD9
        0x671B, # G+4700  U+671B  uni671B,  CJK UNIFIED IDEOGRAPH-671B
        0x7DB2, # G+4701  U+7DB2  uni7DB2,  CJK UNIFIED IDEOGRAPH-7DB2
        0x7F54, # G+4702  U+7F54  uni7F54,  CJK UNIFIED IDEOGRAPH-7F54
        0x8292, # G+4703  U+8292  uni8292,  CJK UNIFIED IDEOGRAPH-8292
        0x832B, # G+4704  U+832B  uni832B,  CJK UNIFIED IDEOGRAPH-832B
        0x83BD, # G+4705  U+83BD  uni83BD,  CJK UNIFIED IDEOGRAPH-83BD
        0x8F1E, # G+4706  U+8F1E  uni8F1E,  CJK UNIFIED IDEOGRAPH-8F1E
        0x9099, # G+4707  U+9099  uni9099,  CJK UNIFIED IDEOGRAPH-9099
        0x57CB, # G+4708  U+57CB  uni57CB,  CJK UNIFIED IDEOGRAPH-57CB
        0x59B9, # G+4709  U+59B9  uni59B9,  CJK UNIFIED IDEOGRAPH-59B9
        0x5A92, # G+4710  U+5A92  uni5A92,  CJK UNIFIED IDEOGRAPH-5A92
        0x5BD0, # G+4711  U+5BD0  uni5BD0,  CJK UNIFIED IDEOGRAPH-5BD0
        0x6627, # G+4712  U+6627  uni6627,  CJK UNIFIED IDEOGRAPH-6627
        0x679A, # G+4713  U+679A  uni679A,  CJK UNIFIED IDEOGRAPH-679A
        0x6885, # G+4714  U+6885  uni6885,  CJK UNIFIED IDEOGRAPH-6885
        0x6BCF, # G+4715  U+6BCF  uni6BCF,  CJK UNIFIED IDEOGRAPH-6BCF
        0x7164, # G+4716  U+7164  uni7164,  CJK UNIFIED IDEOGRAPH-7164
        0x7F75, # G+4717  U+7F75  uni7F75,  CJK UNIFIED IDEOGRAPH-7F75
        0x8CB7, # G+4718  U+8CB7  uni8CB7,  CJK UNIFIED IDEOGRAPH-8CB7
        0x8CE3, # G+4719  U+8CE3  uni8CE3,  CJK UNIFIED IDEOGRAPH-8CE3
        0x9081, # G+4720  U+9081  uni9081,  CJK UNIFIED IDEOGRAPH-9081
        0x9B45, # G+4721  U+9B45  uni9B45,  CJK UNIFIED IDEOGRAPH-9B45
        0x8108, # G+4722  U+8108  uni8108,  CJK UNIFIED IDEOGRAPH-8108
        0x8C8A, # G+4723  U+8C8A  uni8C8A,  CJK UNIFIED IDEOGRAPH-8C8A
        0x964C, # G+4724  U+964C  uni964C,  CJK UNIFIED IDEOGRAPH-964C
        0x9A40, # G+4725  U+9A40  uni9A40,  CJK UNIFIED IDEOGRAPH-9A40
        0x2FC6, # G+4726  U+2FC6  uni2FC6,  KANGXI RADICAL WHEAT
        0x5B5F, # G+4727  U+5B5F  uni5B5F,  CJK UNIFIED IDEOGRAPH-5B5F
        0x6C13, # G+4728  U+6C13  uni6C13,  CJK UNIFIED IDEOGRAPH-6C13
        0x731B, # G+4729  U+731B  uni731B,  CJK UNIFIED IDEOGRAPH-731B
        0x76F2, # G+4730  U+76F2  uni76F2,  CJK UNIFIED IDEOGRAPH-76F2
        0x76DF, # G+4731  U+76DF  uni76DF,  CJK UNIFIED IDEOGRAPH-76DF
        0x840C, # G+4732  U+840C  uni840C,  CJK UNIFIED IDEOGRAPH-840C
        0x51AA, # G+4733  U+51AA  uni51AA,  CJK UNIFIED IDEOGRAPH-51AA
        0x8993, # G+4734  U+8993  uni8993,  CJK UNIFIED IDEOGRAPH-8993
        0x514D, # G+4735  U+514D  uni514D,  CJK UNIFIED IDEOGRAPH-514D
        0x5195, # G+4736  U+5195  uni5195,  CJK UNIFIED IDEOGRAPH-5195
        0x52C9, # G+4737  U+52C9  uni52C9,  CJK UNIFIED IDEOGRAPH-52C9
        0x68C9, # G+4738  U+68C9  uni68C9,  CJK UNIFIED IDEOGRAPH-68C9
        0x6C94, # G+4739  U+6C94  uni6C94,  CJK UNIFIED IDEOGRAPH-6C94
        0x7704, # G+4740  U+7704  uni7704,  CJK UNIFIED IDEOGRAPH-7704
        0x7720, # G+4741  U+7720  uni7720,  CJK UNIFIED IDEOGRAPH-7720
        0x7DBF, # G+4742  U+7DBF  uni7DBF,  CJK UNIFIED IDEOGRAPH-7DBF
        0x7DEC, # G+4743  U+7DEC  uni7DEC,  CJK UNIFIED IDEOGRAPH-7DEC
        0x2FAF, # G+4744  U+2FAF  uni2FAF,  KANGXI RADICAL FACE
        0x9EB5, # G+4745  U+9EB5  uni9EB5,  CJK UNIFIED IDEOGRAPH-9EB5
        0x6EC5, # G+4746  U+6EC5  uni6EC5,  CJK UNIFIED IDEOGRAPH-6EC5
        0x8511, # G+4747  U+8511  uni8511,  CJK UNIFIED IDEOGRAPH-8511
        0x51A5, # G+4748  U+51A5  uni51A5,  CJK UNIFIED IDEOGRAPH-51A5
        0x540D, # G+4749  U+540D  uni540D,  CJK UNIFIED IDEOGRAPH-540D
        0x547D, # G+4750  U+547D  uni547D,  CJK UNIFIED IDEOGRAPH-547D
        0x660E, # G+4751  U+660E  uni660E,  CJK UNIFIED IDEOGRAPH-660E
        0x669D, # G+4752  U+669D  uni669D,  CJK UNIFIED IDEOGRAPH-669D
        0x6927, # G+4753  U+6927  uni6927,  CJK UNIFIED IDEOGRAPH-6927
        0x6E9F, # G+4754  U+6E9F  uni6E9F,  CJK UNIFIED IDEOGRAPH-6E9F
        0x2F6B, # G+4755  U+2F6B  uni2F6B,  KANGXI RADICAL DISH
        0x7791, # G+4756  U+7791  uni7791,  CJK UNIFIED IDEOGRAPH-7791
        0x8317, # G+4757  U+8317  uni8317,  CJK UNIFIED IDEOGRAPH-8317
        0x84C2, # G+4758  U+84C2  uni84C2,  CJK UNIFIED IDEOGRAPH-84C2
        0x879F, # G+4759  U+879F  uni879F,  CJK UNIFIED IDEOGRAPH-879F
        0x9169, # G+4760  U+9169  uni9169,  CJK UNIFIED IDEOGRAPH-9169
        0x9298, # G+4761  U+9298  uni9298,  CJK UNIFIED IDEOGRAPH-9298
        0x9CF4, # G+4762  U+9CF4  uni9CF4,  CJK UNIFIED IDEOGRAPH-9CF4
        0x8882, # G+4763  U+8882  uni8882,  CJK UNIFIED IDEOGRAPH-8882
        0x4FAE, # G+4764  U+4FAE  uni4FAE,  CJK UNIFIED IDEOGRAPH-4FAE
        0x5192, # G+4765  U+5192  uni5192,  CJK UNIFIED IDEOGRAPH-5192
        0x52DF, # G+4766  U+52DF  uni52DF,  CJK UNIFIED IDEOGRAPH-52DF
        0x59C6, # G+4767  U+59C6  uni59C6,  CJK UNIFIED IDEOGRAPH-59C6
        0x5E3D, # G+4768  U+5E3D  uni5E3D,  CJK UNIFIED IDEOGRAPH-5E3D
        0x6155, # G+4769  U+6155  uni6155,  CJK UNIFIED IDEOGRAPH-6155
        0x6478, # G+4770  U+6478  uni6478,  CJK UNIFIED IDEOGRAPH-6478
        0x6479, # G+4771  U+6479  uni6479,  CJK UNIFIED IDEOGRAPH-6479
        0x66AE, # G+4772  U+66AE  uni66AE,  CJK UNIFIED IDEOGRAPH-66AE
        0x67D0, # G+4773  U+67D0  uni67D0,  CJK UNIFIED IDEOGRAPH-67D0
        0x6A21, # G+4774  U+6A21  uni6A21,  CJK UNIFIED IDEOGRAPH-6A21
        0x6BCD, # G+4775  U+6BCD  uni6BCD,  CJK UNIFIED IDEOGRAPH-6BCD
        0x2F51, # G+4776  U+2F51  uni2F51,  KANGXI RADICAL FUR
        0x725F, # G+4777  U+725F  uni725F,  CJK UNIFIED IDEOGRAPH-725F
        0x7261, # G+4778  U+7261  uni7261,  CJK UNIFIED IDEOGRAPH-7261
        0x7441, # G+4779  U+7441  uni7441,  CJK UNIFIED IDEOGRAPH-7441
        0x7738, # G+4780  U+7738  uni7738,  CJK UNIFIED IDEOGRAPH-7738
        0x2F6D, # G+4781  U+2F6D  uni2F6D,  KANGXI RADICAL SPEAR
        0x8017, # G+4782  U+8017  uni8017,  CJK UNIFIED IDEOGRAPH-8017
        0x82BC, # G+4783  U+82BC  uni82BC,  CJK UNIFIED IDEOGRAPH-82BC
        0x8305, # G+4784  U+8305  uni8305,  CJK UNIFIED IDEOGRAPH-8305
        0x8B00, # G+4785  U+8B00  uni8B00,  CJK UNIFIED IDEOGRAPH-8B00
        0x8B28, # G+4786  U+8B28  uni8B28,  CJK UNIFIED IDEOGRAPH-8B28
        0x8C8C, # G+4787  U+8C8C  uni8C8C,  CJK UNIFIED IDEOGRAPH-8C8C
        0x2F4A, # G+4788  U+2F4A  uni2F4A,  KANGXI RADICAL TREE
        0x6C90, # G+4789  U+6C90  uni6C90,  CJK UNIFIED IDEOGRAPH-6C90
        0x7267, # G+4790  U+7267  uni7267,  CJK UNIFIED IDEOGRAPH-7267
        0x2F6C, # G+4791  U+2F6C  uni2F6C,  KANGXI RADICAL EYE
        0x7766, # G+4792  U+7766  uni7766,  CJK UNIFIED IDEOGRAPH-7766
        0x7A46, # G+4793  U+7A46  uni7A46,  CJK UNIFIED IDEOGRAPH-7A46
        0x9DA9, # G+4794  U+9DA9  uni9DA9,  CJK UNIFIED IDEOGRAPH-9DA9
        0x6B7F, # G+4795  U+6B7F  uni6B7F,  CJK UNIFIED IDEOGRAPH-6B7F
        0x6C92, # G+4796  U+6C92  uni6C92,  CJK UNIFIED IDEOGRAPH-6C92
        0x5922, # G+4797  U+5922  uni5922,  CJK UNIFIED IDEOGRAPH-5922
        0x6726, # G+4798  U+6726  uni6726,  CJK UNIFIED IDEOGRAPH-6726
        0x8499, # G+4799  U+8499  uni8499,  CJK UNIFIED IDEOGRAPH-8499
        0x536F, # G+4800  U+536F  uni536F,  CJK UNIFIED IDEOGRAPH-536F
        0x5893, # G+4801  U+5893  uni5893,  CJK UNIFIED IDEOGRAPH-5893
        0x5999, # G+4802  U+5999  uni5999,  CJK UNIFIED IDEOGRAPH-5999
        0x5EDF, # G+4803  U+5EDF  uni5EDF,  CJK UNIFIED IDEOGRAPH-5EDF
        0x63CF, # G+4804  U+63CF  uni63CF,  CJK UNIFIED IDEOGRAPH-63CF
        0x6634, # G+4805  U+6634  uni6634,  CJK UNIFIED IDEOGRAPH-6634
        0x6773, # G+4806  U+6773  uni6773,  CJK UNIFIED IDEOGRAPH-6773
        0x6E3A, # G+4807  U+6E3A  uni6E3A,  CJK UNIFIED IDEOGRAPH-6E3A
        0x732B, # G+4808  U+732B  uni732B,  CJK UNIFIED IDEOGRAPH-732B
        0x7AD7, # G+4809  U+7AD7  uni7AD7,  CJK UNIFIED IDEOGRAPH-7AD7
        0x82D7, # G+4810  U+82D7  uni82D7,  CJK UNIFIED IDEOGRAPH-82D7
        0x9328, # G+4811  U+9328  uni9328,  CJK UNIFIED IDEOGRAPH-9328
        0x52D9, # G+4812  U+52D9  uni52D9,  CJK UNIFIED IDEOGRAPH-52D9
        0x5DEB, # G+4813  U+5DEB  uni5DEB,  CJK UNIFIED IDEOGRAPH-5DEB
        0x61AE, # G+4814  U+61AE  uni61AE,  CJK UNIFIED IDEOGRAPH-61AE
        0x61CB, # G+4815  U+61CB  uni61CB,  CJK UNIFIED IDEOGRAPH-61CB
        0x620A, # G+4816  U+620A  uni620A,  CJK UNIFIED IDEOGRAPH-620A
        0x62C7, # G+4817  U+62C7  uni62C7,  CJK UNIFIED IDEOGRAPH-62C7
        0x64AB, # G+4818  U+64AB  uni64AB,  CJK UNIFIED IDEOGRAPH-64AB
        0x2F46, # G+4819  U+2F46  uni2F46,  KANGXI RADICAL NOT
        0x6959, # G+4820  U+6959  uni6959,  CJK UNIFIED IDEOGRAPH-6959
        0x6B66, # G+4821  U+6B66  uni6B66,  CJK UNIFIED IDEOGRAPH-6B66
        0x2F4F, # G+4822  U+2F4F  uni2F4F,  KANGXI RADICAL DO NOT
        0x7121, # G+4823  U+7121  uni7121,  CJK UNIFIED IDEOGRAPH-7121
        0x73F7, # G+4824  U+73F7  uni73F7,  CJK UNIFIED IDEOGRAPH-73F7
        0x755D, # G+4825  U+755D  uni755D,  CJK UNIFIED IDEOGRAPH-755D
        0x7E46, # G+4826  U+7E46  uni7E46,  CJK UNIFIED IDEOGRAPH-7E46
        0x821E, # G+4827  U+821E  uni821E,  CJK UNIFIED IDEOGRAPH-821E
        0x8302, # G+4828  U+8302  uni8302,  CJK UNIFIED IDEOGRAPH-8302
        0x856A, # G+4829  U+856A  uni856A,  CJK UNIFIED IDEOGRAPH-856A
        0x8AA3, # G+4830  U+8AA3  uni8AA3,  CJK UNIFIED IDEOGRAPH-8AA3
        0x8CBF, # G+4831  U+8CBF  uni8CBF,  CJK UNIFIED IDEOGRAPH-8CBF
        0x9727, # G+4832  U+9727  uni9727,  CJK UNIFIED IDEOGRAPH-9727
        0x9D61, # G+4833  U+9D61  uni9D61,  CJK UNIFIED IDEOGRAPH-9D61
        0x58A8, # G+4834  U+58A8  uni58A8,  CJK UNIFIED IDEOGRAPH-58A8
        0x9ED8, # G+4835  U+9ED8  uni9ED8,  CJK UNIFIED IDEOGRAPH-9ED8
        0x5011, # G+4836  U+5011  uni5011,  CJK UNIFIED IDEOGRAPH-5011
        0x520E, # G+4837  U+520E  uni520E,  CJK UNIFIED IDEOGRAPH-520E
        0x543B, # G+4838  U+543B  uni543B,  CJK UNIFIED IDEOGRAPH-543B
        0x554F, # G+4839  U+554F  uni554F,  CJK UNIFIED IDEOGRAPH-554F
        0x2F42, # G+4840  U+2F42  uni2F42,  KANGXI RADICAL SCRIPT
        0x6C76, # G+4841  U+6C76  uni6C76,  CJK UNIFIED IDEOGRAPH-6C76
        0x7D0A, # G+4842  U+7D0A  uni7D0A,  CJK UNIFIED IDEOGRAPH-7D0A
        0x7D0B, # G+4843  U+7D0B  uni7D0B,  CJK UNIFIED IDEOGRAPH-7D0B
        0x805E, # G+4844  U+805E  uni805E,  CJK UNIFIED IDEOGRAPH-805E
        0x868A, # G+4845  U+868A  uni868A,  CJK UNIFIED IDEOGRAPH-868A
        0x2FA8, # G+4846  U+2FA8  uni2FA8,  KANGXI RADICAL GATE
        0x96EF, # G+4847  U+96EF  uni96EF,  CJK UNIFIED IDEOGRAPH-96EF
        0x52FF, # G+4848  U+52FF  uni52FF,  CJK UNIFIED IDEOGRAPH-52FF
        0x6C95, # G+4849  U+6C95  uni6C95,  CJK UNIFIED IDEOGRAPH-6C95
        0x7269, # G+4850  U+7269  uni7269,  CJK UNIFIED IDEOGRAPH-7269
        0x5473, # G+4851  U+5473  uni5473,  CJK UNIFIED IDEOGRAPH-5473
        0x5A9A, # G+4852  U+5A9A  uni5A9A,  CJK UNIFIED IDEOGRAPH-5A9A
        0x5C3E, # G+4853  U+5C3E  uni5C3E,  CJK UNIFIED IDEOGRAPH-5C3E
        0x5D4B, # G+4854  U+5D4B  uni5D4B,  CJK UNIFIED IDEOGRAPH-5D4B
        0x5F4C, # G+4855  U+5F4C  uni5F4C,  CJK UNIFIED IDEOGRAPH-5F4C
        0x5FAE, # G+4856  U+5FAE  uni5FAE,  CJK UNIFIED IDEOGRAPH-5FAE
        0x672A, # G+4857  U+672A  uni672A,  CJK UNIFIED IDEOGRAPH-672A
        0x68B6, # G+4858  U+68B6  uni68B6,  CJK UNIFIED IDEOGRAPH-68B6
        0x6963, # G+4859  U+6963  uni6963,  CJK UNIFIED IDEOGRAPH-6963
        0x6E3C, # G+4860  U+6E3C  uni6E3C,  CJK UNIFIED IDEOGRAPH-6E3C
        0x6E44, # G+4861  U+6E44  uni6E44,  CJK UNIFIED IDEOGRAPH-6E44
        0x7709, # G+4862  U+7709  uni7709,  CJK UNIFIED IDEOGRAPH-7709
        0x2F76, # G+4863  U+2F76  uni2F76,  KANGXI RADICAL RICE
        0x7F8E, # G+4864  U+7F8E  uni7F8E,  CJK UNIFIED IDEOGRAPH-7F8E
        0x8587, # G+4865  U+8587  uni8587,  CJK UNIFIED IDEOGRAPH-8587
        0x8B0E, # G+4866  U+8B0E  uni8B0E,  CJK UNIFIED IDEOGRAPH-8B0E
        0x8FF7, # G+4867  U+8FF7  uni8FF7,  CJK UNIFIED IDEOGRAPH-8FF7
        0x9761, # G+4868  U+9761  uni9761,  CJK UNIFIED IDEOGRAPH-9761
        0x9EF4, # G+4869  U+9EF4  uni9EF4,  CJK UNIFIED IDEOGRAPH-9EF4
        0x5CB7, # G+4870  U+5CB7  uni5CB7,  CJK UNIFIED IDEOGRAPH-5CB7
        0x60B6, # G+4871  U+60B6  uni60B6,  CJK UNIFIED IDEOGRAPH-60B6
        0x610D, # G+4872  U+610D  uni610D,  CJK UNIFIED IDEOGRAPH-610D
        0x61AB, # G+4873  U+61AB  uni61AB,  CJK UNIFIED IDEOGRAPH-61AB
        0x654F, # G+4874  U+654F  uni654F,  CJK UNIFIED IDEOGRAPH-654F
        0x65FB, # G+4875  U+65FB  uni65FB,  CJK UNIFIED IDEOGRAPH-65FB
        0x65FC, # G+4876  U+65FC  uni65FC,  CJK UNIFIED IDEOGRAPH-65FC
        0x6C11, # G+4877  U+6C11  uni6C11,  CJK UNIFIED IDEOGRAPH-6C11
        0x6CEF, # G+4878  U+6CEF  uni6CEF,  CJK UNIFIED IDEOGRAPH-6CEF
        0x739F, # G+4879  U+739F  uni739F,  CJK UNIFIED IDEOGRAPH-739F
        0x73C9, # G+4880  U+73C9  uni73C9,  CJK UNIFIED IDEOGRAPH-73C9
        0x7DE1, # G+4881  U+7DE1  uni7DE1,  CJK UNIFIED IDEOGRAPH-7DE1
        0x9594, # G+4882  U+9594  uni9594,  CJK UNIFIED IDEOGRAPH-9594
        0x5BC6, # G+4883  U+5BC6  uni5BC6,  CJK UNIFIED IDEOGRAPH-5BC6
        0x871C, # G+4884  U+871C  uni871C,  CJK UNIFIED IDEOGRAPH-871C
        0x8B10, # G+4885  U+8B10  uni8B10,  CJK UNIFIED IDEOGRAPH-8B10
        0x525D, # G+4886  U+525D  uni525D,  CJK UNIFIED IDEOGRAPH-525D
        0x535A, # G+4887  U+535A  uni535A,  CJK UNIFIED IDEOGRAPH-535A
        0x62CD, # G+4888  U+62CD  uni62CD,  CJK UNIFIED IDEOGRAPH-62CD
        0x640F, # G+4889  U+640F  uni640F,  CJK UNIFIED IDEOGRAPH-640F
        0x64B2, # G+4890  U+64B2  uni64B2,  CJK UNIFIED IDEOGRAPH-64B2
        0x6734, # G+4891  U+6734  uni6734,  CJK UNIFIED IDEOGRAPH-6734
        0x6A38, # G+4892  U+6A38  uni6A38,  CJK UNIFIED IDEOGRAPH-6A38
        0x6CCA, # G+4893  U+6CCA  uni6CCA,  CJK UNIFIED IDEOGRAPH-6CCA
        0x73C0, # G+4894  U+73C0  uni73C0,  CJK UNIFIED IDEOGRAPH-73C0
        0x749E, # G+4895  U+749E  uni749E,  CJK UNIFIED IDEOGRAPH-749E
        0x7B94, # G+4896  U+7B94  uni7B94,  CJK UNIFIED IDEOGRAPH-7B94
        0x7C95, # G+4897  U+7C95  uni7C95,  CJK UNIFIED IDEOGRAPH-7C95
        0x7E1B, # G+4898  U+7E1B  uni7E1B,  CJK UNIFIED IDEOGRAPH-7E1B
        0x818A, # G+4899  U+818A  uni818A,  CJK UNIFIED IDEOGRAPH-818A
        0x8236, # G+4900  U+8236  uni8236,  CJK UNIFIED IDEOGRAPH-8236
        0x8584, # G+4901  U+8584  uni8584,  CJK UNIFIED IDEOGRAPH-8584
        0x8FEB, # G+4902  U+8FEB  uni8FEB,  CJK UNIFIED IDEOGRAPH-8FEB
        0x96F9, # G+4903  U+96F9  uni96F9,  CJK UNIFIED IDEOGRAPH-96F9
        0x99C1, # G+4904  U+99C1  uni99C1,  CJK UNIFIED IDEOGRAPH-99C1
        0x4F34, # G+4905  U+4F34  uni4F34,  CJK UNIFIED IDEOGRAPH-4F34
        0x534A, # G+4906  U+534A  uni534A,  CJK UNIFIED IDEOGRAPH-534A
        0x53CD, # G+4907  U+53CD  uni53CD,  CJK UNIFIED IDEOGRAPH-53CD
        0x53DB, # G+4908  U+53DB  uni53DB,  CJK UNIFIED IDEOGRAPH-53DB
        0x62CC, # G+4909  U+62CC  uni62CC,  CJK UNIFIED IDEOGRAPH-62CC
        0x642C, # G+4910  U+642C  uni642C,  CJK UNIFIED IDEOGRAPH-642C
        0x6500, # G+4911  U+6500  uni6500,  CJK UNIFIED IDEOGRAPH-6500
        0x6591, # G+4912  U+6591  uni6591,  CJK UNIFIED IDEOGRAPH-6591
        0x69C3, # G+4913  U+69C3  uni69C3,  CJK UNIFIED IDEOGRAPH-69C3
        0x6CEE, # G+4914  U+6CEE  uni6CEE,  CJK UNIFIED IDEOGRAPH-6CEE
        0x6F58, # G+4915  U+6F58  uni6F58,  CJK UNIFIED IDEOGRAPH-6F58
        0x73ED, # G+4916  U+73ED  uni73ED,  CJK UNIFIED IDEOGRAPH-73ED
        0x7554, # G+4917  U+7554  uni7554,  CJK UNIFIED IDEOGRAPH-7554
        0x7622, # G+4918  U+7622  uni7622,  CJK UNIFIED IDEOGRAPH-7622
        0x76E4, # G+4919  U+76E4  uni76E4,  CJK UNIFIED IDEOGRAPH-76E4
        0x76FC, # G+4920  U+76FC  uni76FC,  CJK UNIFIED IDEOGRAPH-76FC
        0x78D0, # G+4921  U+78D0  uni78D0,  CJK UNIFIED IDEOGRAPH-78D0
        0x78FB, # G+4922  U+78FB  uni78FB,  CJK UNIFIED IDEOGRAPH-78FB
        0x792C, # G+4923  U+792C  uni792C,  CJK UNIFIED IDEOGRAPH-792C
        0x7D46, # G+4924  U+7D46  uni7D46,  CJK UNIFIED IDEOGRAPH-7D46
        0x822C, # G+4925  U+822C  uni822C,  CJK UNIFIED IDEOGRAPH-822C
        0x87E0, # G+4926  U+87E0  uni87E0,  CJK UNIFIED IDEOGRAPH-87E0
        0x8FD4, # G+4927  U+8FD4  uni8FD4,  CJK UNIFIED IDEOGRAPH-8FD4
        0x9812, # G+4928  U+9812  uni9812,  CJK UNIFIED IDEOGRAPH-9812
        0x98EF, # G+4929  U+98EF  uni98EF,  CJK UNIFIED IDEOGRAPH-98EF
        0x52C3, # G+4930  U+52C3  uni52C3,  CJK UNIFIED IDEOGRAPH-52C3
        0x62D4, # G+4931  U+62D4  uni62D4,  CJK UNIFIED IDEOGRAPH-62D4
        0x64A5, # G+4932  U+64A5  uni64A5,  CJK UNIFIED IDEOGRAPH-64A5
        0x6E24, # G+4933  U+6E24  uni6E24,  CJK UNIFIED IDEOGRAPH-6E24
        0x6F51, # G+4934  U+6F51  uni6F51,  CJK UNIFIED IDEOGRAPH-6F51
        0x767C, # G+4935  U+767C  uni767C,  CJK UNIFIED IDEOGRAPH-767C
        0x8DCB, # G+4936  U+8DCB  uni8DCB,  CJK UNIFIED IDEOGRAPH-8DCB
        0x91B1, # G+4937  U+91B1  uni91B1,  CJK UNIFIED IDEOGRAPH-91B1
        0x9262, # G+4938  U+9262  uni9262,  CJK UNIFIED IDEOGRAPH-9262
        0x9AEE, # G+4939  U+9AEE  uni9AEE,  CJK UNIFIED IDEOGRAPH-9AEE
        0x9B43, # G+4940  U+9B43  uni9B43,  CJK UNIFIED IDEOGRAPH-9B43
        0x5023, # G+4941  U+5023  uni5023,  CJK UNIFIED IDEOGRAPH-5023
        0x508D, # G+4942  U+508D  uni508D,  CJK UNIFIED IDEOGRAPH-508D
        0x574A, # G+4943  U+574A  uni574A,  CJK UNIFIED IDEOGRAPH-574A
        0x59A8, # G+4944  U+59A8  uni59A8,  CJK UNIFIED IDEOGRAPH-59A8
        0x5C28, # G+4945  U+5C28  uni5C28,  CJK UNIFIED IDEOGRAPH-5C28
        0x5E47, # G+4946  U+5E47  uni5E47,  CJK UNIFIED IDEOGRAPH-5E47
        0x5F77, # G+4947  U+5F77  uni5F77,  CJK UNIFIED IDEOGRAPH-5F77
        0x623F, # G+4948  U+623F  uni623F,  CJK UNIFIED IDEOGRAPH-623F
        0x653E, # G+4949  U+653E  uni653E,  CJK UNIFIED IDEOGRAPH-653E
        0x2F45, # G+4950  U+2F45  uni2F45,  KANGXI RADICAL SQUARE
        0x65C1, # G+4951  U+65C1  uni65C1,  CJK UNIFIED IDEOGRAPH-65C1
        0x6609, # G+4952  U+6609  uni6609,  CJK UNIFIED IDEOGRAPH-6609
        0x678B, # G+4953  U+678B  uni678B,  CJK UNIFIED IDEOGRAPH-678B
        0x699C, # G+4954  U+699C  uni699C,  CJK UNIFIED IDEOGRAPH-699C
        0x6EC2, # G+4955  U+6EC2  uni6EC2,  CJK UNIFIED IDEOGRAPH-6EC2
        0x78C5, # G+4956  U+78C5  uni78C5,  CJK UNIFIED IDEOGRAPH-78C5
        0x7D21, # G+4957  U+7D21  uni7D21,  CJK UNIFIED IDEOGRAPH-7D21
        0x80AA, # G+4958  U+80AA  uni80AA,  CJK UNIFIED IDEOGRAPH-80AA
        0x8180, # G+4959  U+8180  uni8180,  CJK UNIFIED IDEOGRAPH-8180
        0x822B, # G+4960  U+822B  uni822B,  CJK UNIFIED IDEOGRAPH-822B
        0x82B3, # G+4961  U+82B3  uni82B3,  CJK UNIFIED IDEOGRAPH-82B3
        0x84A1, # G+4962  U+84A1  uni84A1,  CJK UNIFIED IDEOGRAPH-84A1
        0x868C, # G+4963  U+868C  uni868C,  CJK UNIFIED IDEOGRAPH-868C
        0x8A2A, # G+4964  U+8A2A  uni8A2A,  CJK UNIFIED IDEOGRAPH-8A2A
        0x8B17, # G+4965  U+8B17  uni8B17,  CJK UNIFIED IDEOGRAPH-8B17
        0x90A6, # G+4966  U+90A6  uni90A6,  CJK UNIFIED IDEOGRAPH-90A6
        0x9632, # G+4967  U+9632  uni9632,  CJK UNIFIED IDEOGRAPH-9632
        0x9F90, # G+4968  U+9F90  uni9F90,  CJK UNIFIED IDEOGRAPH-9F90
        0x500D, # G+4969  U+500D  uni500D,  CJK UNIFIED IDEOGRAPH-500D
        0x4FF3, # G+4970  U+4FF3  uni4FF3,  CJK UNIFIED IDEOGRAPH-4FF3
        0x57F9, # G+4971  U+57F9  uni57F9,  CJK UNIFIED IDEOGRAPH-57F9
        0x5F98, # G+4972  U+5F98  uni5F98,  CJK UNIFIED IDEOGRAPH-5F98
        0x62DC, # G+4973  U+62DC  uni62DC,  CJK UNIFIED IDEOGRAPH-62DC
        0x6392, # G+4974  U+6392  uni6392,  CJK UNIFIED IDEOGRAPH-6392
        0x676F, # G+4975  U+676F  uni676F,  CJK UNIFIED IDEOGRAPH-676F
        0x6E43, # G+4976  U+6E43  uni6E43,  CJK UNIFIED IDEOGRAPH-6E43
        0x7119, # G+4977  U+7119  uni7119,  CJK UNIFIED IDEOGRAPH-7119
        0x76C3, # G+4978  U+76C3  uni76C3,  CJK UNIFIED IDEOGRAPH-76C3
        0x80CC, # G+4979  U+80CC  uni80CC,  CJK UNIFIED IDEOGRAPH-80CC
        0x80DA, # G+4980  U+80DA  uni80DA,  CJK UNIFIED IDEOGRAPH-80DA
        0x88F4, # G+4981  U+88F4  uni88F4,  CJK UNIFIED IDEOGRAPH-88F4
        0x88F5, # G+4982  U+88F5  uni88F5,  CJK UNIFIED IDEOGRAPH-88F5
        0x8919, # G+4983  U+8919  uni8919,  CJK UNIFIED IDEOGRAPH-8919
        0x8CE0, # G+4984  U+8CE0  uni8CE0,  CJK UNIFIED IDEOGRAPH-8CE0
        0x8F29, # G+4985  U+8F29  uni8F29,  CJK UNIFIED IDEOGRAPH-8F29
        0x914D, # G+4986  U+914D  uni914D,  CJK UNIFIED IDEOGRAPH-914D
        0x966A, # G+4987  U+966A  uni966A,  CJK UNIFIED IDEOGRAPH-966A
        0x4F2F, # G+4988  U+4F2F  uni4F2F,  CJK UNIFIED IDEOGRAPH-4F2F
        0x4F70, # G+4989  U+4F70  uni4F70,  CJK UNIFIED IDEOGRAPH-4F70
        0x5E1B, # G+4990  U+5E1B  uni5E1B,  CJK UNIFIED IDEOGRAPH-5E1B
        0x67CF, # G+4991  U+67CF  uni67CF,  CJK UNIFIED IDEOGRAPH-67CF
        0x6822, # G+4992  U+6822  uni6822,  CJK UNIFIED IDEOGRAPH-6822
        0x2F69, # G+4993  U+2F69  uni2F69,  KANGXI RADICAL WHITE
        0x767E, # G+4994  U+767E  uni767E,  CJK UNIFIED IDEOGRAPH-767E
        0x9B44, # G+4995  U+9B44  uni9B44,  CJK UNIFIED IDEOGRAPH-9B44
        0x5E61, # G+4996  U+5E61  uni5E61,  CJK UNIFIED IDEOGRAPH-5E61
        0x6A0A, # G+4997  U+6A0A  uni6A0A,  CJK UNIFIED IDEOGRAPH-6A0A
        0x7169, # G+4998  U+7169  uni7169,  CJK UNIFIED IDEOGRAPH-7169
        0x71D4, # G+4999  U+71D4  uni71D4,  CJK UNIFIED IDEOGRAPH-71D4
        0x756A, # G+5000  U+756A  uni756A,  CJK UNIFIED IDEOGRAPH-756A
        0x7E41, # G+5001  U+7E41  uni7E41,  CJK UNIFIED IDEOGRAPH-7E41
        0x8543, # G+5002  U+8543  uni8543,  CJK UNIFIED IDEOGRAPH-8543
        0x85E9, # G+5003  U+85E9  uni85E9,  CJK UNIFIED IDEOGRAPH-85E9
        0x98DC, # G+5004  U+98DC  uni98DC,  CJK UNIFIED IDEOGRAPH-98DC
        0x4F10, # G+5005  U+4F10  uni4F10,  CJK UNIFIED IDEOGRAPH-4F10
        0x7B4F, # G+5006  U+7B4F  uni7B4F,  CJK UNIFIED IDEOGRAPH-7B4F
        0x7F70, # G+5007  U+7F70  uni7F70,  CJK UNIFIED IDEOGRAPH-7F70
        0x95A5, # G+5008  U+95A5  uni95A5,  CJK UNIFIED IDEOGRAPH-95A5
        0x51E1, # G+5009  U+51E1  uni51E1,  CJK UNIFIED IDEOGRAPH-51E1
        0x5E06, # G+5010  U+5E06  uni5E06,  CJK UNIFIED IDEOGRAPH-5E06
        0x68B5, # G+5011  U+68B5  uni68B5,  CJK UNIFIED IDEOGRAPH-68B5
        0x6C3E, # G+5012  U+6C3E  uni6C3E,  CJK UNIFIED IDEOGRAPH-6C3E
        0x6C4E, # G+5013  U+6C4E  uni6C4E,  CJK UNIFIED IDEOGRAPH-6C4E
        0x6CDB, # G+5014  U+6CDB  uni6CDB,  CJK UNIFIED IDEOGRAPH-6CDB
        0x72AF, # G+5015  U+72AF  uni72AF,  CJK UNIFIED IDEOGRAPH-72AF
        0x7BC4, # G+5016  U+7BC4  uni7BC4,  CJK UNIFIED IDEOGRAPH-7BC4
        0x8303, # G+5017  U+8303  uni8303,  CJK UNIFIED IDEOGRAPH-8303
        0x6CD5, # G+5018  U+6CD5  uni6CD5,  CJK UNIFIED IDEOGRAPH-6CD5
        0x743A, # G+5019  U+743A  uni743A,  CJK UNIFIED IDEOGRAPH-743A
        0x50FB, # G+5020  U+50FB  uni50FB,  CJK UNIFIED IDEOGRAPH-50FB
        0x5288, # G+5021  U+5288  uni5288,  CJK UNIFIED IDEOGRAPH-5288
        0x58C1, # G+5022  U+58C1  uni58C1,  CJK UNIFIED IDEOGRAPH-58C1
        0x64D8, # G+5023  U+64D8  uni64D8,  CJK UNIFIED IDEOGRAPH-64D8
        0x6A97, # G+5024  U+6A97  uni6A97,  CJK UNIFIED IDEOGRAPH-6A97
        0x74A7, # G+5025  U+74A7  uni74A7,  CJK UNIFIED IDEOGRAPH-74A7
        0x7656, # G+5026  U+7656  uni7656,  CJK UNIFIED IDEOGRAPH-7656
        0x78A7, # G+5027  U+78A7  uni78A7,  CJK UNIFIED IDEOGRAPH-78A7
        0x8617, # G+5028  U+8617  uni8617,  CJK UNIFIED IDEOGRAPH-8617
        0x95E2, # G+5029  U+95E2  uni95E2,  CJK UNIFIED IDEOGRAPH-95E2
        0x9739, # G+5030  U+9739  uni9739,  CJK UNIFIED IDEOGRAPH-9739
        0x535E, # G+5031  U+535E  uni535E,  CJK UNIFIED IDEOGRAPH-535E
        0x5F01, # G+5032  U+5F01  uni5F01,  CJK UNIFIED IDEOGRAPH-5F01
        0x8B8A, # G+5033  U+8B8A  uni8B8A,  CJK UNIFIED IDEOGRAPH-8B8A
        0x8FA8, # G+5034  U+8FA8  uni8FA8,  CJK UNIFIED IDEOGRAPH-8FA8
        0x8FAF, # G+5035  U+8FAF  uni8FAF,  CJK UNIFIED IDEOGRAPH-8FAF
        0x908A, # G+5036  U+908A  uni908A,  CJK UNIFIED IDEOGRAPH-908A
        0x5225, # G+5037  U+5225  uni5225,  CJK UNIFIED IDEOGRAPH-5225
        0x77A5, # G+5038  U+77A5  uni77A5,  CJK UNIFIED IDEOGRAPH-77A5
        0x9C49, # G+5039  U+9C49  uni9C49,  CJK UNIFIED IDEOGRAPH-9C49
        0x9F08, # G+5040  U+9F08  uni9F08,  CJK UNIFIED IDEOGRAPH-9F08
        0x4E19, # G+5041  U+4E19  uni4E19,  CJK UNIFIED IDEOGRAPH-4E19
        0x5002, # G+5042  U+5002  uni5002,  CJK UNIFIED IDEOGRAPH-5002
        0x5175, # G+5043  U+5175  uni5175,  CJK UNIFIED IDEOGRAPH-5175
        0x5C5B, # G+5044  U+5C5B  uni5C5B,  CJK UNIFIED IDEOGRAPH-5C5B
        0x5E77, # G+5045  U+5E77  uni5E77,  CJK UNIFIED IDEOGRAPH-5E77
        0x661E, # G+5046  U+661E  uni661E,  CJK UNIFIED IDEOGRAPH-661E
        0x663A, # G+5047  U+663A  uni663A,  CJK UNIFIED IDEOGRAPH-663A
        0x67C4, # G+5048  U+67C4  uni67C4,  CJK UNIFIED IDEOGRAPH-67C4
        0x68C5, # G+5049  U+68C5  uni68C5,  CJK UNIFIED IDEOGRAPH-68C5
        0x70B3, # G+5050  U+70B3  uni70B3,  CJK UNIFIED IDEOGRAPH-70B3
        0x7501, # G+5051  U+7501  uni7501,  CJK UNIFIED IDEOGRAPH-7501
        0x75C5, # G+5052  U+75C5  uni75C5,  CJK UNIFIED IDEOGRAPH-75C5
        0x79C9, # G+5053  U+79C9  uni79C9,  CJK UNIFIED IDEOGRAPH-79C9
        0x7ADD, # G+5054  U+7ADD  uni7ADD,  CJK UNIFIED IDEOGRAPH-7ADD
        0x8F27, # G+5055  U+8F27  uni8F27,  CJK UNIFIED IDEOGRAPH-8F27
        0x9920, # G+5056  U+9920  uni9920,  CJK UNIFIED IDEOGRAPH-9920
        0x9A08, # G+5057  U+9A08  uni9A08,  CJK UNIFIED IDEOGRAPH-9A08
        0x4FDD, # G+5058  U+4FDD  uni4FDD,  CJK UNIFIED IDEOGRAPH-4FDD
        0x5821, # G+5059  U+5821  uni5821,  CJK UNIFIED IDEOGRAPH-5821
        0x5831, # G+5060  U+5831  uni5831,  CJK UNIFIED IDEOGRAPH-5831
        0x5BF6, # G+5061  U+5BF6  uni5BF6,  CJK UNIFIED IDEOGRAPH-5BF6
        0x666E, # G+5062  U+666E  uni666E,  CJK UNIFIED IDEOGRAPH-666E
        0x6B65, # G+5063  U+6B65  uni6B65,  CJK UNIFIED IDEOGRAPH-6B65
        0x6D11, # G+5064  U+6D11  uni6D11,  CJK UNIFIED IDEOGRAPH-6D11
        0x6E7A, # G+5065  U+6E7A  uni6E7A,  CJK UNIFIED IDEOGRAPH-6E7A
        0x6F7D, # G+5066  U+6F7D  uni6F7D,  CJK UNIFIED IDEOGRAPH-6F7D
        0x73E4, # G+5067  U+73E4  uni73E4,  CJK UNIFIED IDEOGRAPH-73E4
        0x752B, # G+5068  U+752B  uni752B,  CJK UNIFIED IDEOGRAPH-752B
        0x83E9, # G+5069  U+83E9  uni83E9,  CJK UNIFIED IDEOGRAPH-83E9
        0x88DC, # G+5070  U+88DC  uni88DC,  CJK UNIFIED IDEOGRAPH-88DC
        0x8913, # G+5071  U+8913  uni8913,  CJK UNIFIED IDEOGRAPH-8913
        0x8B5C, # G+5072  U+8B5C  uni8B5C,  CJK UNIFIED IDEOGRAPH-8B5C
        0x8F14, # G+5073  U+8F14  uni8F14,  CJK UNIFIED IDEOGRAPH-8F14
        0x4F0F, # G+5074  U+4F0F  uni4F0F,  CJK UNIFIED IDEOGRAPH-4F0F
        0x50D5, # G+5075  U+50D5  uni50D5,  CJK UNIFIED IDEOGRAPH-50D5
        0x5310, # G+5076  U+5310  uni5310,  CJK UNIFIED IDEOGRAPH-5310
        0x2F18, # G+5077  U+2F18  uni2F18,  KANGXI RADICAL DIVINATION
        0x5B93, # G+5078  U+5B93  uni5B93,  CJK UNIFIED IDEOGRAPH-5B93
        0x5FA9, # G+5079  U+5FA9  uni5FA9,  CJK UNIFIED IDEOGRAPH-5FA9
        0x670D, # G+5080  U+670D  uni670D,  CJK UNIFIED IDEOGRAPH-670D
        0x798F, # G+5081  U+798F  uni798F,  CJK UNIFIED IDEOGRAPH-798F
        0x8179, # G+5082  U+8179  uni8179,  CJK UNIFIED IDEOGRAPH-8179
        0x832F, # G+5083  U+832F  uni832F,  CJK UNIFIED IDEOGRAPH-832F
        0x8514, # G+5084  U+8514  uni8514,  CJK UNIFIED IDEOGRAPH-8514
        0x8907, # G+5085  U+8907  uni8907,  CJK UNIFIED IDEOGRAPH-8907
        0x8986, # G+5086  U+8986  uni8986,  CJK UNIFIED IDEOGRAPH-8986
        0x8F39, # G+5087  U+8F39  uni8F39,  CJK UNIFIED IDEOGRAPH-8F39
        0x8F3B, # G+5088  U+8F3B  uni8F3B,  CJK UNIFIED IDEOGRAPH-8F3B
        0x99A5, # G+5089  U+99A5  uni99A5,  CJK UNIFIED IDEOGRAPH-99A5
        0x9C12, # G+5090  U+9C12  uni9C12,  CJK UNIFIED IDEOGRAPH-9C12
        0x672C, # G+5091  U+672C  uni672C,  CJK UNIFIED IDEOGRAPH-672C
        0x4E76, # G+5092  U+4E76  uni4E76,  CJK UNIFIED IDEOGRAPH-4E76
        0x4FF8, # G+5093  U+4FF8  uni4FF8,  CJK UNIFIED IDEOGRAPH-4FF8
        0x5949, # G+5094  U+5949  uni5949,  CJK UNIFIED IDEOGRAPH-5949
        0x5C01, # G+5095  U+5C01  uni5C01,  CJK UNIFIED IDEOGRAPH-5C01
        0x5CEF, # G+5096  U+5CEF  uni5CEF,  CJK UNIFIED IDEOGRAPH-5CEF
        0x5CF0, # G+5097  U+5CF0  uni5CF0,  CJK UNIFIED IDEOGRAPH-5CF0
        0x6367, # G+5098  U+6367  uni6367,  CJK UNIFIED IDEOGRAPH-6367
        0x68D2, # G+5099  U+68D2  uni68D2,  CJK UNIFIED IDEOGRAPH-68D2
        0x70FD, # G+5100  U+70FD  uni70FD,  CJK UNIFIED IDEOGRAPH-70FD
        0x71A2, # G+5101  U+71A2  uni71A2,  CJK UNIFIED IDEOGRAPH-71A2
        0x742B, # G+5102  U+742B  uni742B,  CJK UNIFIED IDEOGRAPH-742B
        0x7E2B, # G+5103  U+7E2B  uni7E2B,  CJK UNIFIED IDEOGRAPH-7E2B
        0x84EC, # G+5104  U+84EC  uni84EC,  CJK UNIFIED IDEOGRAPH-84EC
        0x8702, # G+5105  U+8702  uni8702,  CJK UNIFIED IDEOGRAPH-8702
        0x9022, # G+5106  U+9022  uni9022,  CJK UNIFIED IDEOGRAPH-9022
        0x92D2, # G+5107  U+92D2  uni92D2,  CJK UNIFIED IDEOGRAPH-92D2
        0x9CF3, # G+5108  U+9CF3  uni9CF3,  CJK UNIFIED IDEOGRAPH-9CF3
        0x4E0D, # G+5109  U+4E0D  uni4E0D,  CJK UNIFIED IDEOGRAPH-4E0D
        0x4ED8, # G+5110  U+4ED8  uni4ED8,  CJK UNIFIED IDEOGRAPH-4ED8
        0x4FEF, # G+5111  U+4FEF  uni4FEF,  CJK UNIFIED IDEOGRAPH-4FEF
        0x5085, # G+5112  U+5085  uni5085,  CJK UNIFIED IDEOGRAPH-5085
        0x5256, # G+5113  U+5256  uni5256,  CJK UNIFIED IDEOGRAPH-5256
        0x526F, # G+5114  U+526F  uni526F,  CJK UNIFIED IDEOGRAPH-526F
        0x5426, # G+5115  U+5426  uni5426,  CJK UNIFIED IDEOGRAPH-5426
        0x5490, # G+5116  U+5490  uni5490,  CJK UNIFIED IDEOGRAPH-5490
        0x57E0, # G+5117  U+57E0  uni57E0,  CJK UNIFIED IDEOGRAPH-57E0
        0x592B, # G+5118  U+592B  uni592B,  CJK UNIFIED IDEOGRAPH-592B
        0x5A66, # G+5119  U+5A66  uni5A66,  CJK UNIFIED IDEOGRAPH-5A66
        0x5B5A, # G+5120  U+5B5A  uni5B5A,  CJK UNIFIED IDEOGRAPH-5B5A
        0x5B75, # G+5121  U+5B75  uni5B75,  CJK UNIFIED IDEOGRAPH-5B75
        0x5BCC, # G+5122  U+5BCC  uni5BCC,  CJK UNIFIED IDEOGRAPH-5BCC
        0x5E9C, # G+5123  U+5E9C  uni5E9C,  CJK UNIFIED IDEOGRAPH-5E9C
        0x6276, # G+5124  U+6276  uni6276,  CJK UNIFIED IDEOGRAPH-6276
        0x6577, # G+5125  U+6577  uni6577,  CJK UNIFIED IDEOGRAPH-6577
        0x65A7, # G+5126  U+65A7  uni65A7,  CJK UNIFIED IDEOGRAPH-65A7
        0x6D6E, # G+5127  U+6D6E  uni6D6E,  CJK UNIFIED IDEOGRAPH-6D6E
        0x6EA5, # G+5128  U+6EA5  uni6EA5,  CJK UNIFIED IDEOGRAPH-6EA5
        0x2F57, # G+5129  U+2F57  uni2F57,  KANGXI RADICAL FATHER
        0x7B26, # G+5130  U+7B26  uni7B26,  CJK UNIFIED IDEOGRAPH-7B26
        0x7C3F, # G+5131  U+7C3F  uni7C3F,  CJK UNIFIED IDEOGRAPH-7C3F
        0x2F78, # G+5132  U+2F78  uni2F78,  KANGXI RADICAL JAR
        0x8150, # G+5133  U+8150  uni8150,  CJK UNIFIED IDEOGRAPH-8150
        0x8151, # G+5134  U+8151  uni8151,  CJK UNIFIED IDEOGRAPH-8151
        0x819A, # G+5135  U+819A  uni819A,  CJK UNIFIED IDEOGRAPH-819A
        0x8240, # G+5136  U+8240  uni8240,  CJK UNIFIED IDEOGRAPH-8240
        0x8299, # G+5137  U+8299  uni8299,  CJK UNIFIED IDEOGRAPH-8299
        0x83A9, # G+5138  U+83A9  uni83A9,  CJK UNIFIED IDEOGRAPH-83A9
        0x8A03, # G+5139  U+8A03  uni8A03,  CJK UNIFIED IDEOGRAPH-8A03
        0x8CA0, # G+5140  U+8CA0  uni8CA0,  CJK UNIFIED IDEOGRAPH-8CA0
        0x8CE6, # G+5141  U+8CE6  uni8CE6,  CJK UNIFIED IDEOGRAPH-8CE6
        0x8CFB, # G+5142  U+8CFB  uni8CFB,  CJK UNIFIED IDEOGRAPH-8CFB
        0x8D74, # G+5143  U+8D74  uni8D74,  CJK UNIFIED IDEOGRAPH-8D74
        0x8DBA, # G+5144  U+8DBA  uni8DBA,  CJK UNIFIED IDEOGRAPH-8DBA
        0x90E8, # G+5145  U+90E8  uni90E8,  CJK UNIFIED IDEOGRAPH-90E8
        0x91DC, # G+5146  U+91DC  uni91DC,  CJK UNIFIED IDEOGRAPH-91DC
        0x2FA9, # G+5147  U+2FA9  uni2FA9,  KANGXI RADICAL MOUND
        0x9644, # G+5148  U+9644  uni9644,  CJK UNIFIED IDEOGRAPH-9644
        0x99D9, # G+5149  U+99D9  uni99D9,  CJK UNIFIED IDEOGRAPH-99D9
        0x9CE7, # G+5150  U+9CE7  uni9CE7,  CJK UNIFIED IDEOGRAPH-9CE7
        0x5317, # G+5151  U+5317  uni5317,  CJK UNIFIED IDEOGRAPH-5317
        0x5206, # G+5152  U+5206  uni5206,  CJK UNIFIED IDEOGRAPH-5206
        0x5429, # G+5153  U+5429  uni5429,  CJK UNIFIED IDEOGRAPH-5429
        0x5674, # G+5154  U+5674  uni5674,  CJK UNIFIED IDEOGRAPH-5674
        0x58B3, # G+5155  U+58B3  uni58B3,  CJK UNIFIED IDEOGRAPH-58B3
        0x5954, # G+5156  U+5954  uni5954,  CJK UNIFIED IDEOGRAPH-5954
        0x596E, # G+5157  U+596E  uni596E,  CJK UNIFIED IDEOGRAPH-596E
        0x5FFF, # G+5158  U+5FFF  uni5FFF,  CJK UNIFIED IDEOGRAPH-5FFF
        0x61A4, # G+5159  U+61A4  uni61A4,  CJK UNIFIED IDEOGRAPH-61A4
        0x626E, # G+5160  U+626E  uni626E,  CJK UNIFIED IDEOGRAPH-626E
        0x6610, # G+5161  U+6610  uni6610,  CJK UNIFIED IDEOGRAPH-6610
        0x6C7E, # G+5162  U+6C7E  uni6C7E,  CJK UNIFIED IDEOGRAPH-6C7E
        0x711A, # G+5163  U+711A  uni711A,  CJK UNIFIED IDEOGRAPH-711A
        0x76C6, # G+5164  U+76C6  uni76C6,  CJK UNIFIED IDEOGRAPH-76C6
        0x7C89, # G+5165  U+7C89  uni7C89,  CJK UNIFIED IDEOGRAPH-7C89
        0x7CDE, # G+5166  U+7CDE  uni7CDE,  CJK UNIFIED IDEOGRAPH-7CDE
        0x7D1B, # G+5167  U+7D1B  uni7D1B,  CJK UNIFIED IDEOGRAPH-7D1B
        0x82AC, # G+5168  U+82AC  uni82AC,  CJK UNIFIED IDEOGRAPH-82AC
        0x8CC1, # G+5169  U+8CC1  uni8CC1,  CJK UNIFIED IDEOGRAPH-8CC1
        0x96F0, # G+5170  U+96F0  uni96F0,  CJK UNIFIED IDEOGRAPH-96F0
        0x4F5B, # G+5171  U+4F5B  uni4F5B,  CJK UNIFIED IDEOGRAPH-4F5B
        0x5F17, # G+5172  U+5F17  uni5F17,  CJK UNIFIED IDEOGRAPH-5F17
        0x5F7F, # G+5173  U+5F7F  uni5F7F,  CJK UNIFIED IDEOGRAPH-5F7F
        0x62C2, # G+5174  U+62C2  uni62C2,  CJK UNIFIED IDEOGRAPH-62C2
        0x5D29, # G+5175  U+5D29  uni5D29,  CJK UNIFIED IDEOGRAPH-5D29
        0x670B, # G+5176  U+670B  uni670B,  CJK UNIFIED IDEOGRAPH-670B
        0x68DA, # G+5177  U+68DA  uni68DA,  CJK UNIFIED IDEOGRAPH-68DA
        0x787C, # G+5178  U+787C  uni787C,  CJK UNIFIED IDEOGRAPH-787C
        0x7E43, # G+5179  U+7E43  uni7E43,  CJK UNIFIED IDEOGRAPH-7E43
        0x9D6C, # G+5180  U+9D6C  uni9D6C,  CJK UNIFIED IDEOGRAPH-9D6C
        0x4E15, # G+5181  U+4E15  uni4E15,  CJK UNIFIED IDEOGRAPH-4E15
        0x5099, # G+5182  U+5099  uni5099,  CJK UNIFIED IDEOGRAPH-5099
        0x2F14, # G+5183  U+2F14  uni2F14,  KANGXI RADICAL SPOON
        0x532A, # G+5184  U+532A  uni532A,  CJK UNIFIED IDEOGRAPH-532A
        0x5351, # G+5185  U+5351  uni5351,  CJK UNIFIED IDEOGRAPH-5351
        0x5983, # G+5186  U+5983  uni5983,  CJK UNIFIED IDEOGRAPH-5983
        0x5A62, # G+5187  U+5A62  uni5A62,  CJK UNIFIED IDEOGRAPH-5A62
        0x5E87, # G+5188  U+5E87  uni5E87,  CJK UNIFIED IDEOGRAPH-5E87
        0x60B2, # G+5189  U+60B2  uni60B2,  CJK UNIFIED IDEOGRAPH-60B2
        0x618A, # G+5190  U+618A  uni618A,  CJK UNIFIED IDEOGRAPH-618A
        0x6249, # G+5191  U+6249  uni6249,  CJK UNIFIED IDEOGRAPH-6249
        0x6279, # G+5192  U+6279  uni6279,  CJK UNIFIED IDEOGRAPH-6279
        0x6590, # G+5193  U+6590  uni6590,  CJK UNIFIED IDEOGRAPH-6590
        0x6787, # G+5194  U+6787  uni6787,  CJK UNIFIED IDEOGRAPH-6787
        0x69A7, # G+5195  U+69A7  uni69A7,  CJK UNIFIED IDEOGRAPH-69A7
        0x2F50, # G+5196  U+2F50  uni2F50,  KANGXI RADICAL COMPARE
        0x6BD6, # G+5197  U+6BD6  uni6BD6,  CJK UNIFIED IDEOGRAPH-6BD6
        0x6BD7, # G+5198  U+6BD7  uni6BD7,  CJK UNIFIED IDEOGRAPH-6BD7
        0x6BD8, # G+5199  U+6BD8  uni6BD8,  CJK UNIFIED IDEOGRAPH-6BD8
        0x6CB8, # G+5200  U+6CB8  uni6CB8,  CJK UNIFIED IDEOGRAPH-6CB8
        0x7435, # G+5201  U+7435  uni7435,  CJK UNIFIED IDEOGRAPH-7435
        0x75FA, # G+5202  U+75FA  uni75FA,  CJK UNIFIED IDEOGRAPH-75FA
        0x7812, # G+5203  U+7812  uni7812,  CJK UNIFIED IDEOGRAPH-7812
        0x7891, # G+5204  U+7891  uni7891,  CJK UNIFIED IDEOGRAPH-7891
        0x79D5, # G+5205  U+79D5  uni79D5,  CJK UNIFIED IDEOGRAPH-79D5
        0x79D8, # G+5206  U+79D8  uni79D8,  CJK UNIFIED IDEOGRAPH-79D8
        0x7C83, # G+5207  U+7C83  uni7C83,  CJK UNIFIED IDEOGRAPH-7C83
        0x7DCB, # G+5208  U+7DCB  uni7DCB,  CJK UNIFIED IDEOGRAPH-7DCB
        0x7FE1, # G+5209  U+7FE1  uni7FE1,  CJK UNIFIED IDEOGRAPH-7FE1
        0x80A5, # G+5210  U+80A5  uni80A5,  CJK UNIFIED IDEOGRAPH-80A5
        0x813E, # G+5211  U+813E  uni813E,  CJK UNIFIED IDEOGRAPH-813E
        0x81C2, # G+5212  U+81C2  uni81C2,  CJK UNIFIED IDEOGRAPH-81C2
        0x83F2, # G+5213  U+83F2  uni83F2,  CJK UNIFIED IDEOGRAPH-83F2
        0x871A, # G+5214  U+871A  uni871A,  CJK UNIFIED IDEOGRAPH-871A
        0x88E8, # G+5215  U+88E8  uni88E8,  CJK UNIFIED IDEOGRAPH-88E8
        0x8AB9, # G+5216  U+8AB9  uni8AB9,  CJK UNIFIED IDEOGRAPH-8AB9
        0x8B6C, # G+5217  U+8B6C  uni8B6C,  CJK UNIFIED IDEOGRAPH-8B6C
        0x8CBB, # G+5218  U+8CBB  uni8CBB,  CJK UNIFIED IDEOGRAPH-8CBB
        0x9119, # G+5219  U+9119  uni9119,  CJK UNIFIED IDEOGRAPH-9119
        0x2FAE, # G+5220  U+2FAE  uni2FAE,  KANGXI RADICAL WRONG
        0x2FB6, # G+5221  U+2FB6  uni2FB6,  KANGXI RADICAL FLY
        0x2FD0, # G+5222  U+2FD0  uni2FD0,  KANGXI RADICAL NOSE
        0x56AC, # G+5223  U+56AC  uni56AC,  CJK UNIFIED IDEOGRAPH-56AC
        0x5B2A, # G+5224  U+5B2A  uni5B2A,  CJK UNIFIED IDEOGRAPH-5B2A
        0x5F6C, # G+5225  U+5F6C  uni5F6C,  CJK UNIFIED IDEOGRAPH-5F6C
        0x658C, # G+5226  U+658C  uni658C,  CJK UNIFIED IDEOGRAPH-658C
        0x6AB3, # G+5227  U+6AB3  uni6AB3,  CJK UNIFIED IDEOGRAPH-6AB3
        0x6BAF, # G+5228  U+6BAF  uni6BAF,  CJK UNIFIED IDEOGRAPH-6BAF
        0x6D5C, # G+5229  U+6D5C  uni6D5C,  CJK UNIFIED IDEOGRAPH-6D5C
        0x6FF1, # G+5230  U+6FF1  uni6FF1,  CJK UNIFIED IDEOGRAPH-6FF1
        0x7015, # G+5231  U+7015  uni7015,  CJK UNIFIED IDEOGRAPH-7015
        0x725D, # G+5232  U+725D  uni725D,  CJK UNIFIED IDEOGRAPH-725D
        0x73AD, # G+5233  U+73AD  uni73AD,  CJK UNIFIED IDEOGRAPH-73AD
        0x8CA7, # G+5234  U+8CA7  uni8CA7,  CJK UNIFIED IDEOGRAPH-8CA7
        0x8CD3, # G+5235  U+8CD3  uni8CD3,  CJK UNIFIED IDEOGRAPH-8CD3
        0x983B, # G+5236  U+983B  uni983B,  CJK UNIFIED IDEOGRAPH-983B
        0x6191, # G+5237  U+6191  uni6191,  CJK UNIFIED IDEOGRAPH-6191
        0x6C37, # G+5238  U+6C37  uni6C37,  CJK UNIFIED IDEOGRAPH-6C37
        0x8058, # G+5239  U+8058  uni8058,  CJK UNIFIED IDEOGRAPH-8058
        0x9A01, # G+5240  U+9A01  uni9A01,  CJK UNIFIED IDEOGRAPH-9A01
        0x4E4D, # G+5241  U+4E4D  uni4E4D,  CJK UNIFIED IDEOGRAPH-4E4D
        0x4E8B, # G+5242  U+4E8B  uni4E8B,  CJK UNIFIED IDEOGRAPH-4E8B
        0x4E9B, # G+5243  U+4E9B  uni4E9B,  CJK UNIFIED IDEOGRAPH-4E9B
        0x4ED5, # G+5244  U+4ED5  uni4ED5,  CJK UNIFIED IDEOGRAPH-4ED5
        0x4F3A, # G+5245  U+4F3A  uni4F3A,  CJK UNIFIED IDEOGRAPH-4F3A
        0x4F3C, # G+5246  U+4F3C  uni4F3C,  CJK UNIFIED IDEOGRAPH-4F3C
        0x4F7F, # G+5247  U+4F7F  uni4F7F,  CJK UNIFIED IDEOGRAPH-4F7F
        0x4FDF, # G+5248  U+4FDF  uni4FDF,  CJK UNIFIED IDEOGRAPH-4FDF
        0x50FF, # G+5249  U+50FF  uni50FF,  CJK UNIFIED IDEOGRAPH-50FF
        0x53F2, # G+5250  U+53F2  uni53F2,  CJK UNIFIED IDEOGRAPH-53F2
        0x53F8, # G+5251  U+53F8  uni53F8,  CJK UNIFIED IDEOGRAPH-53F8
        0x5506, # G+5252  U+5506  uni5506,  CJK UNIFIED IDEOGRAPH-5506
        0x55E3, # G+5253  U+55E3  uni55E3,  CJK UNIFIED IDEOGRAPH-55E3
        0x56DB, # G+5254  U+56DB  uni56DB,  CJK UNIFIED IDEOGRAPH-56DB
        0x2F20, # G+5255  U+2F20  uni2F20,  KANGXI RADICAL SCHOLAR
        0x5962, # G+5256  U+5962  uni5962,  CJK UNIFIED IDEOGRAPH-5962
        0x5A11, # G+5257  U+5A11  uni5A11,  CJK UNIFIED IDEOGRAPH-5A11
        0x5BEB, # G+5258  U+5BEB  uni5BEB,  CJK UNIFIED IDEOGRAPH-5BEB
        0x5BFA, # G+5259  U+5BFA  uni5BFA,  CJK UNIFIED IDEOGRAPH-5BFA
        0x5C04, # G+5260  U+5C04  uni5C04,  CJK UNIFIED IDEOGRAPH-5C04
        0x5DF3, # G+5261  U+5DF3  uni5DF3,  CJK UNIFIED IDEOGRAPH-5DF3
        0x5E2B, # G+5262  U+5E2B  uni5E2B,  CJK UNIFIED IDEOGRAPH-5E2B
        0x5F99, # G+5263  U+5F99  uni5F99,  CJK UNIFIED IDEOGRAPH-5F99
        0x601D, # G+5264  U+601D  uni601D,  CJK UNIFIED IDEOGRAPH-601D
        0x6368, # G+5265  U+6368  uni6368,  CJK UNIFIED IDEOGRAPH-6368
        0x659C, # G+5266  U+659C  uni659C,  CJK UNIFIED IDEOGRAPH-659C
        0x65AF, # G+5267  U+65AF  uni65AF,  CJK UNIFIED IDEOGRAPH-65AF
        0x67F6, # G+5268  U+67F6  uni67F6,  CJK UNIFIED IDEOGRAPH-67F6
        0x67FB, # G+5269  U+67FB  uni67FB,  CJK UNIFIED IDEOGRAPH-67FB
        0x68AD, # G+5270  U+68AD  uni68AD,  CJK UNIFIED IDEOGRAPH-68AD
        0x6B7B, # G+5271  U+6B7B  uni6B7B,  CJK UNIFIED IDEOGRAPH-6B7B
        0x6C99, # G+5272  U+6C99  uni6C99,  CJK UNIFIED IDEOGRAPH-6C99
        0x6CD7, # G+5273  U+6CD7  uni6CD7,  CJK UNIFIED IDEOGRAPH-6CD7
        0x6E23, # G+5274  U+6E23  uni6E23,  CJK UNIFIED IDEOGRAPH-6E23
        0x7009, # G+5275  U+7009  uni7009,  CJK UNIFIED IDEOGRAPH-7009
        0x7345, # G+5276  U+7345  uni7345,  CJK UNIFIED IDEOGRAPH-7345
        0x7802, # G+5277  U+7802  uni7802,  CJK UNIFIED IDEOGRAPH-7802
        0x793E, # G+5278  U+793E  uni793E,  CJK UNIFIED IDEOGRAPH-793E
        0x7940, # G+5279  U+7940  uni7940,  CJK UNIFIED IDEOGRAPH-7940
        0x7960, # G+5280  U+7960  uni7960,  CJK UNIFIED IDEOGRAPH-7960
        0x79C1, # G+5281  U+79C1  uni79C1,  CJK UNIFIED IDEOGRAPH-79C1
        0x7BE9, # G+5282  U+7BE9  uni7BE9,  CJK UNIFIED IDEOGRAPH-7BE9
        0x7D17, # G+5283  U+7D17  uni7D17,  CJK UNIFIED IDEOGRAPH-7D17
        0x7D72, # G+5284  U+7D72  uni7D72,  CJK UNIFIED IDEOGRAPH-7D72
        0x8086, # G+5285  U+8086  uni8086,  CJK UNIFIED IDEOGRAPH-8086
        0x820D, # G+5286  U+820D  uni820D,  CJK UNIFIED IDEOGRAPH-820D
        0x838E, # G+5287  U+838E  uni838E,  CJK UNIFIED IDEOGRAPH-838E
        0x84D1, # G+5288  U+84D1  uni84D1,  CJK UNIFIED IDEOGRAPH-84D1
        0x86C7, # G+5289  U+86C7  uni86C7,  CJK UNIFIED IDEOGRAPH-86C7
        0x88DF, # G+5290  U+88DF  uni88DF,  CJK UNIFIED IDEOGRAPH-88DF
        0x8A50, # G+5291  U+8A50  uni8A50,  CJK UNIFIED IDEOGRAPH-8A50
        0x8A5E, # G+5292  U+8A5E  uni8A5E,  CJK UNIFIED IDEOGRAPH-8A5E
        0x8B1D, # G+5293  U+8B1D  uni8B1D,  CJK UNIFIED IDEOGRAPH-8B1D
        0x8CDC, # G+5294  U+8CDC  uni8CDC,  CJK UNIFIED IDEOGRAPH-8CDC
        0x8D66, # G+5295  U+8D66  uni8D66,  CJK UNIFIED IDEOGRAPH-8D66
        0x8FAD, # G+5296  U+8FAD  uni8FAD,  CJK UNIFIED IDEOGRAPH-8FAD
        0x90AA, # G+5297  U+90AA  uni90AA,  CJK UNIFIED IDEOGRAPH-90AA
        0x98FC, # G+5298  U+98FC  uni98FC,  CJK UNIFIED IDEOGRAPH-98FC
        0x99DF, # G+5299  U+99DF  uni99DF,  CJK UNIFIED IDEOGRAPH-99DF
        0x9E9D, # G+5300  U+9E9D  uni9E9D,  CJK UNIFIED IDEOGRAPH-9E9D
        0x524A, # G+5301  U+524A  uni524A,  CJK UNIFIED IDEOGRAPH-524A
        0x6714, # G+5302  U+6714  uni6714,  CJK UNIFIED IDEOGRAPH-6714
        0x5098, # G+5303  U+5098  uni5098,  CJK UNIFIED IDEOGRAPH-5098
        0x522A, # G+5304  U+522A  uni522A,  CJK UNIFIED IDEOGRAPH-522A
        0x2F2D, # G+5305  U+2F2D  uni2F2D,  KANGXI RADICAL MOUNTAIN
        0x6563, # G+5306  U+6563  uni6563,  CJK UNIFIED IDEOGRAPH-6563
        0x6C55, # G+5307  U+6C55  uni6C55,  CJK UNIFIED IDEOGRAPH-6C55
        0x73CA, # G+5308  U+73CA  uni73CA,  CJK UNIFIED IDEOGRAPH-73CA
        0x7523, # G+5309  U+7523  uni7523,  CJK UNIFIED IDEOGRAPH-7523
        0x759D, # G+5310  U+759D  uni759D,  CJK UNIFIED IDEOGRAPH-759D
        0x7B97, # G+5311  U+7B97  uni7B97,  CJK UNIFIED IDEOGRAPH-7B97
        0x849C, # G+5312  U+849C  uni849C,  CJK UNIFIED IDEOGRAPH-849C
        0x9178, # G+5313  U+9178  uni9178,  CJK UNIFIED IDEOGRAPH-9178
        0x9730, # G+5314  U+9730  uni9730,  CJK UNIFIED IDEOGRAPH-9730
        0x4E77, # G+5315  U+4E77  uni4E77,  CJK UNIFIED IDEOGRAPH-4E77
        0x6492, # G+5316  U+6492  uni6492,  CJK UNIFIED IDEOGRAPH-6492
        0x6BBA, # G+5317  U+6BBA  uni6BBA,  CJK UNIFIED IDEOGRAPH-6BBA
        0x715E, # G+5318  U+715E  uni715E,  CJK UNIFIED IDEOGRAPH-715E
        0x85A9, # G+5319  U+85A9  uni85A9,  CJK UNIFIED IDEOGRAPH-85A9
        0x4E09, # G+5320  U+4E09  uni4E09,  CJK UNIFIED IDEOGRAPH-4E09
        0x6749, # G+5321  U+6749  uni6749,  CJK UNIFIED IDEOGRAPH-6749
        0x68EE, # G+5322  U+68EE  uni68EE,  CJK UNIFIED IDEOGRAPH-68EE
        0x6E17, # G+5323  U+6E17  uni6E17,  CJK UNIFIED IDEOGRAPH-6E17
        0x829F, # G+5324  U+829F  uni829F,  CJK UNIFIED IDEOGRAPH-829F
        0x8518, # G+5325  U+8518  uni8518,  CJK UNIFIED IDEOGRAPH-8518
        0x886B, # G+5326  U+886B  uni886B,  CJK UNIFIED IDEOGRAPH-886B
        0x63F7, # G+5327  U+63F7  uni63F7,  CJK UNIFIED IDEOGRAPH-63F7
        0x6F81, # G+5328  U+6F81  uni6F81,  CJK UNIFIED IDEOGRAPH-6F81
        0x9212, # G+5329  U+9212  uni9212,  CJK UNIFIED IDEOGRAPH-9212
        0x98AF, # G+5330  U+98AF  uni98AF,  CJK UNIFIED IDEOGRAPH-98AF
        0x4E0A, # G+5331  U+4E0A  uni4E0A,  CJK UNIFIED IDEOGRAPH-4E0A
        0x50B7, # G+5332  U+50B7  uni50B7,  CJK UNIFIED IDEOGRAPH-50B7
        0x50CF, # G+5333  U+50CF  uni50CF,  CJK UNIFIED IDEOGRAPH-50CF
        0x511F, # G+5334  U+511F  uni511F,  CJK UNIFIED IDEOGRAPH-511F
        0x5546, # G+5335  U+5546  uni5546,  CJK UNIFIED IDEOGRAPH-5546
        0x55AA, # G+5336  U+55AA  uni55AA,  CJK UNIFIED IDEOGRAPH-55AA
        0x5617, # G+5337  U+5617  uni5617,  CJK UNIFIED IDEOGRAPH-5617
        0x5B40, # G+5338  U+5B40  uni5B40,  CJK UNIFIED IDEOGRAPH-5B40
        0x5C19, # G+5339  U+5C19  uni5C19,  CJK UNIFIED IDEOGRAPH-5C19
        0x5CE0, # G+5340  U+5CE0  uni5CE0,  CJK UNIFIED IDEOGRAPH-5CE0
        0x5E38, # G+5341  U+5E38  uni5E38,  CJK UNIFIED IDEOGRAPH-5E38
        0x5E8A, # G+5342  U+5E8A  uni5E8A,  CJK UNIFIED IDEOGRAPH-5E8A
        0x5EA0, # G+5343  U+5EA0  uni5EA0,  CJK UNIFIED IDEOGRAPH-5EA0
        0x5EC2, # G+5344  U+5EC2  uni5EC2,  CJK UNIFIED IDEOGRAPH-5EC2
        0x60F3, # G+5345  U+60F3  uni60F3,  CJK UNIFIED IDEOGRAPH-60F3
        0x6851, # G+5346  U+6851  uni6851,  CJK UNIFIED IDEOGRAPH-6851
        0x6A61, # G+5347  U+6A61  uni6A61,  CJK UNIFIED IDEOGRAPH-6A61
        0x6E58, # G+5348  U+6E58  uni6E58,  CJK UNIFIED IDEOGRAPH-6E58
        0x723D, # G+5349  U+723D  uni723D,  CJK UNIFIED IDEOGRAPH-723D
        0x7240, # G+5350  U+7240  uni7240,  CJK UNIFIED IDEOGRAPH-7240
        0x72C0, # G+5351  U+72C0  uni72C0,  CJK UNIFIED IDEOGRAPH-72C0
        0x76F8, # G+5352  U+76F8  uni76F8,  CJK UNIFIED IDEOGRAPH-76F8
        0x7965, # G+5353  U+7965  uni7965,  CJK UNIFIED IDEOGRAPH-7965
        0x7BB1, # G+5354  U+7BB1  uni7BB1,  CJK UNIFIED IDEOGRAPH-7BB1
        0x7FD4, # G+5355  U+7FD4  uni7FD4,  CJK UNIFIED IDEOGRAPH-7FD4
        0x88F3, # G+5356  U+88F3  uni88F3,  CJK UNIFIED IDEOGRAPH-88F3
        0x89F4, # G+5357  U+89F4  uni89F4,  CJK UNIFIED IDEOGRAPH-89F4
        0x8A73, # G+5358  U+8A73  uni8A73,  CJK UNIFIED IDEOGRAPH-8A73
        0x8C61, # G+5359  U+8C61  uni8C61,  CJK UNIFIED IDEOGRAPH-8C61
        0x8CDE, # G+5360  U+8CDE  uni8CDE,  CJK UNIFIED IDEOGRAPH-8CDE
        0x971C, # G+5361  U+971C  uni971C,  CJK UNIFIED IDEOGRAPH-971C
        0x585E, # G+5362  U+585E  uni585E,  CJK UNIFIED IDEOGRAPH-585E
        0x74BD, # G+5363  U+74BD  uni74BD,  CJK UNIFIED IDEOGRAPH-74BD
        0x8CFD, # G+5364  U+8CFD  uni8CFD,  CJK UNIFIED IDEOGRAPH-8CFD
        0x55C7, # G+5365  U+55C7  uni55C7,  CJK UNIFIED IDEOGRAPH-55C7
        0x7A61, # G+5366  U+7A61  uni7A61,  CJK UNIFIED IDEOGRAPH-7A61
        0x7D22, # G+5367  U+7D22  uni7D22,  CJK UNIFIED IDEOGRAPH-7D22
        0x2F8A, # G+5368  U+2F8A  uni2F8A,  KANGXI RADICAL COLOR
        0x7272, # G+5369  U+7272  uni7272,  CJK UNIFIED IDEOGRAPH-7272
        0x2F63, # G+5370  U+2F63  uni2F63,  KANGXI RADICAL LIFE
        0x7525, # G+5371  U+7525  uni7525,  CJK UNIFIED IDEOGRAPH-7525
        0x7B19, # G+5372  U+7B19  uni7B19,  CJK UNIFIED IDEOGRAPH-7B19
        0x5885, # G+5373  U+5885  uni5885,  CJK UNIFIED IDEOGRAPH-5885
        0x58FB, # G+5374  U+58FB  uni58FB,  CJK UNIFIED IDEOGRAPH-58FB
        0x5DBC, # G+5375  U+5DBC  uni5DBC,  CJK UNIFIED IDEOGRAPH-5DBC
        0x5E8F, # G+5376  U+5E8F  uni5E8F,  CJK UNIFIED IDEOGRAPH-5E8F
        0x5EB6, # G+5377  U+5EB6  uni5EB6,  CJK UNIFIED IDEOGRAPH-5EB6
        0x5F90, # G+5378  U+5F90  uni5F90,  CJK UNIFIED IDEOGRAPH-5F90
        0x6055, # G+5379  U+6055  uni6055,  CJK UNIFIED IDEOGRAPH-6055
        0x6292, # G+5380  U+6292  uni6292,  CJK UNIFIED IDEOGRAPH-6292
        0x637F, # G+5381  U+637F  uni637F,  CJK UNIFIED IDEOGRAPH-637F
        0x654D, # G+5382  U+654D  uni654D,  CJK UNIFIED IDEOGRAPH-654D
        0x6691, # G+5383  U+6691  uni6691,  CJK UNIFIED IDEOGRAPH-6691
        0x66D9, # G+5384  U+66D9  uni66D9,  CJK UNIFIED IDEOGRAPH-66D9
        0x66F8, # G+5385  U+66F8  uni66F8,  CJK UNIFIED IDEOGRAPH-66F8
        0x6816, # G+5386  U+6816  uni6816,  CJK UNIFIED IDEOGRAPH-6816
        0x68F2, # G+5387  U+68F2  uni68F2,  CJK UNIFIED IDEOGRAPH-68F2
        0x7280, # G+5388  U+7280  uni7280,  CJK UNIFIED IDEOGRAPH-7280
        0x745E, # G+5389  U+745E  uni745E,  CJK UNIFIED IDEOGRAPH-745E
        0x7B6E, # G+5390  U+7B6E  uni7B6E,  CJK UNIFIED IDEOGRAPH-7B6E
        0x7D6E, # G+5391  U+7D6E  uni7D6E,  CJK UNIFIED IDEOGRAPH-7D6E
        0x7DD6, # G+5392  U+7DD6  uni7DD6,  CJK UNIFIED IDEOGRAPH-7DD6
        0x7F72, # G+5393  U+7F72  uni7F72,  CJK UNIFIED IDEOGRAPH-7F72
        0x80E5, # G+5394  U+80E5  uni80E5,  CJK UNIFIED IDEOGRAPH-80E5
        0x8212, # G+5395  U+8212  uni8212,  CJK UNIFIED IDEOGRAPH-8212
        0x85AF, # G+5396  U+85AF  uni85AF,  CJK UNIFIED IDEOGRAPH-85AF
        0x897F, # G+5397  U+897F  uni897F,  CJK UNIFIED IDEOGRAPH-897F
        0x8A93, # G+5398  U+8A93  uni8A93,  CJK UNIFIED IDEOGRAPH-8A93
        0x901D, # G+5399  U+901D  uni901D,  CJK UNIFIED IDEOGRAPH-901D
        0x92E4, # G+5400  U+92E4  uni92E4,  CJK UNIFIED IDEOGRAPH-92E4
        0x2FC9, # G+5401  U+2FC9  uni2FC9,  KANGXI RADICAL MILLET
        0x2FCF, # G+5402  U+2FCF  uni2FCF,  KANGXI RADICAL RAT
        0x2F23, # G+5403  U+2F23  uni2F23,  KANGXI RADICAL EVENING
        0x596D, # G+5404  U+596D  uni596D,  CJK UNIFIED IDEOGRAPH-596D
        0x5E2D, # G+5405  U+5E2D  uni5E2D,  CJK UNIFIED IDEOGRAPH-5E2D
        0x60DC, # G+5406  U+60DC  uni60DC,  CJK UNIFIED IDEOGRAPH-60DC
        0x6614, # G+5407  U+6614  uni6614,  CJK UNIFIED IDEOGRAPH-6614
        0x6673, # G+5408  U+6673  uni6673,  CJK UNIFIED IDEOGRAPH-6673
        0x6790, # G+5409  U+6790  uni6790,  CJK UNIFIED IDEOGRAPH-6790
        0x6C50, # G+5410  U+6C50  uni6C50,  CJK UNIFIED IDEOGRAPH-6C50
        0x6DC5, # G+5411  U+6DC5  uni6DC5,  CJK UNIFIED IDEOGRAPH-6DC5
        0x6F5F, # G+5412  U+6F5F  uni6F5F,  CJK UNIFIED IDEOGRAPH-6F5F
        0x2F6F, # G+5413  U+2F6F  uni2F6F,  KANGXI RADICAL STONE
        0x78A9, # G+5414  U+78A9  uni78A9,  CJK UNIFIED IDEOGRAPH-78A9
        0x84C6, # G+5415  U+84C6  uni84C6,  CJK UNIFIED IDEOGRAPH-84C6
        0x91CB, # G+5416  U+91CB  uni91CB,  CJK UNIFIED IDEOGRAPH-91CB
        0x932B, # G+5417  U+932B  uni932B,  CJK UNIFIED IDEOGRAPH-932B
        0x4ED9, # G+5418  U+4ED9  uni4ED9,  CJK UNIFIED IDEOGRAPH-4ED9
        0x50CA, # G+5419  U+50CA  uni50CA,  CJK UNIFIED IDEOGRAPH-50CA
        0x5148, # G+5420  U+5148  uni5148,  CJK UNIFIED IDEOGRAPH-5148
        0x5584, # G+5421  U+5584  uni5584,  CJK UNIFIED IDEOGRAPH-5584
        0x5B0B, # G+5422  U+5B0B  uni5B0B,  CJK UNIFIED IDEOGRAPH-5B0B
        0x5BA3, # G+5423  U+5BA3  uni5BA3,  CJK UNIFIED IDEOGRAPH-5BA3
        0x6247, # G+5424  U+6247  uni6247,  CJK UNIFIED IDEOGRAPH-6247
        0x657E, # G+5425  U+657E  uni657E,  CJK UNIFIED IDEOGRAPH-657E
        0x65CB, # G+5426  U+65CB  uni65CB,  CJK UNIFIED IDEOGRAPH-65CB
        0x6E32, # G+5427  U+6E32  uni6E32,  CJK UNIFIED IDEOGRAPH-6E32
        0x717D, # G+5428  U+717D  uni717D,  CJK UNIFIED IDEOGRAPH-717D
        0x7401, # G+5429  U+7401  uni7401,  CJK UNIFIED IDEOGRAPH-7401
        0x7444, # G+5430  U+7444  uni7444,  CJK UNIFIED IDEOGRAPH-7444
        0x7487, # G+5431  U+7487  uni7487,  CJK UNIFIED IDEOGRAPH-7487
        0x74BF, # G+5432  U+74BF  uni74BF,  CJK UNIFIED IDEOGRAPH-74BF
        0x766C, # G+5433  U+766C  uni766C,  CJK UNIFIED IDEOGRAPH-766C
        0x79AA, # G+5434  U+79AA  uni79AA,  CJK UNIFIED IDEOGRAPH-79AA
        0x7DDA, # G+5435  U+7DDA  uni7DDA,  CJK UNIFIED IDEOGRAPH-7DDA
        0x7E55, # G+5436  U+7E55  uni7E55,  CJK UNIFIED IDEOGRAPH-7E55
        0x7FA8, # G+5437  U+7FA8  uni7FA8,  CJK UNIFIED IDEOGRAPH-7FA8
        0x817A, # G+5438  U+817A  uni817A,  CJK UNIFIED IDEOGRAPH-817A
        0x81B3, # G+5439  U+81B3  uni81B3,  CJK UNIFIED IDEOGRAPH-81B3
        0x8239, # G+5440  U+8239  uni8239,  CJK UNIFIED IDEOGRAPH-8239
        0x861A, # G+5441  U+861A  uni861A,  CJK UNIFIED IDEOGRAPH-861A
        0x87EC, # G+5442  U+87EC  uni87EC,  CJK UNIFIED IDEOGRAPH-87EC
        0x8A75, # G+5443  U+8A75  uni8A75,  CJK UNIFIED IDEOGRAPH-8A75
        0x8DE3, # G+5444  U+8DE3  uni8DE3,  CJK UNIFIED IDEOGRAPH-8DE3
        0x9078, # G+5445  U+9078  uni9078,  CJK UNIFIED IDEOGRAPH-9078
        0x9291, # G+5446  U+9291  uni9291,  CJK UNIFIED IDEOGRAPH-9291
        0x9425, # G+5447  U+9425  uni9425,  CJK UNIFIED IDEOGRAPH-9425
        0x994D, # G+5448  U+994D  uni994D,  CJK UNIFIED IDEOGRAPH-994D
        0x9BAE, # G+5449  U+9BAE  uni9BAE,  CJK UNIFIED IDEOGRAPH-9BAE
        0x5368, # G+5450  U+5368  uni5368,  CJK UNIFIED IDEOGRAPH-5368
        0x5C51, # G+5451  U+5C51  uni5C51,  CJK UNIFIED IDEOGRAPH-5C51
        0x6954, # G+5452  U+6954  uni6954,  CJK UNIFIED IDEOGRAPH-6954
        0x6CC4, # G+5453  U+6CC4  uni6CC4,  CJK UNIFIED IDEOGRAPH-6CC4
        0x6D29, # G+5454  U+6D29  uni6D29,  CJK UNIFIED IDEOGRAPH-6D29
        0x6E2B, # G+5455  U+6E2B  uni6E2B,  CJK UNIFIED IDEOGRAPH-6E2B
        0x2F86, # G+5456  U+2F86  uni2F86,  KANGXI RADICAL TONGUE
        0x859B, # G+5457  U+859B  uni859B,  CJK UNIFIED IDEOGRAPH-859B
        0x893B, # G+5458  U+893B  uni893B,  CJK UNIFIED IDEOGRAPH-893B
        0x8A2D, # G+5459  U+8A2D  uni8A2D,  CJK UNIFIED IDEOGRAPH-8A2D
        0x8AAA, # G+5460  U+8AAA  uni8AAA,  CJK UNIFIED IDEOGRAPH-8AAA
        0x96EA, # G+5461  U+96EA  uni96EA,  CJK UNIFIED IDEOGRAPH-96EA
        0x9F67, # G+5462  U+9F67  uni9F67,  CJK UNIFIED IDEOGRAPH-9F67
        0x5261, # G+5463  U+5261  uni5261,  CJK UNIFIED IDEOGRAPH-5261
        0x66B9, # G+5464  U+66B9  uni66B9,  CJK UNIFIED IDEOGRAPH-66B9
        0x6BB2, # G+5465  U+6BB2  uni6BB2,  CJK UNIFIED IDEOGRAPH-6BB2
        0x7E96, # G+5466  U+7E96  uni7E96,  CJK UNIFIED IDEOGRAPH-7E96
        0x87FE, # G+5467  U+87FE  uni87FE,  CJK UNIFIED IDEOGRAPH-87FE
        0x8D0D, # G+5468  U+8D0D  uni8D0D,  CJK UNIFIED IDEOGRAPH-8D0D
        0x9583, # G+5469  U+9583  uni9583,  CJK UNIFIED IDEOGRAPH-9583
        0x965D, # G+5470  U+965D  uni965D,  CJK UNIFIED IDEOGRAPH-965D
        0x651D, # G+5471  U+651D  uni651D,  CJK UNIFIED IDEOGRAPH-651D
        0x6D89, # G+5472  U+6D89  uni6D89,  CJK UNIFIED IDEOGRAPH-6D89
        0x71EE, # G+5473  U+71EE  uni71EE,  CJK UNIFIED IDEOGRAPH-71EE
        0x57CE, # G+5474  U+57CE  uni57CE,  CJK UNIFIED IDEOGRAPH-57CE
        0x59D3, # G+5475  U+59D3  uni59D3,  CJK UNIFIED IDEOGRAPH-59D3
        0x5BAC, # G+5476  U+5BAC  uni5BAC,  CJK UNIFIED IDEOGRAPH-5BAC
        0x6027, # G+5477  U+6027  uni6027,  CJK UNIFIED IDEOGRAPH-6027
        0x60FA, # G+5478  U+60FA  uni60FA,  CJK UNIFIED IDEOGRAPH-60FA
        0x6210, # G+5479  U+6210  uni6210,  CJK UNIFIED IDEOGRAPH-6210
        0x661F, # G+5480  U+661F  uni661F,  CJK UNIFIED IDEOGRAPH-661F
        0x665F, # G+5481  U+665F  uni665F,  CJK UNIFIED IDEOGRAPH-665F
        0x7329, # G+5482  U+7329  uni7329,  CJK UNIFIED IDEOGRAPH-7329
        0x73F9, # G+5483  U+73F9  uni73F9,  CJK UNIFIED IDEOGRAPH-73F9
        0x76DB, # G+5484  U+76DB  uni76DB,  CJK UNIFIED IDEOGRAPH-76DB
        0x7701, # G+5485  U+7701  uni7701,  CJK UNIFIED IDEOGRAPH-7701
        0x7B6C, # G+5486  U+7B6C  uni7B6C,  CJK UNIFIED IDEOGRAPH-7B6C
        0x8056, # G+5487  U+8056  uni8056,  CJK UNIFIED IDEOGRAPH-8056
        0x8072, # G+5488  U+8072  uni8072,  CJK UNIFIED IDEOGRAPH-8072
        0x8165, # G+5489  U+8165  uni8165,  CJK UNIFIED IDEOGRAPH-8165
        0x8AA0, # G+5490  U+8AA0  uni8AA0,  CJK UNIFIED IDEOGRAPH-8AA0
        0x9192, # G+5491  U+9192  uni9192,  CJK UNIFIED IDEOGRAPH-9192
        0x4E16, # G+5492  U+4E16  uni4E16,  CJK UNIFIED IDEOGRAPH-4E16
        0x52E2, # G+5493  U+52E2  uni52E2,  CJK UNIFIED IDEOGRAPH-52E2
        0x6B72, # G+5494  U+6B72  uni6B72,  CJK UNIFIED IDEOGRAPH-6B72
        0x6D17, # G+5495  U+6D17  uni6D17,  CJK UNIFIED IDEOGRAPH-6D17
        0x7A05, # G+5496  U+7A05  uni7A05,  CJK UNIFIED IDEOGRAPH-7A05
        0x7B39, # G+5497  U+7B39  uni7B39,  CJK UNIFIED IDEOGRAPH-7B39
        0x7D30, # G+5498  U+7D30  uni7D30,  CJK UNIFIED IDEOGRAPH-7D30
        0x8CB0, # G+5499  U+8CB0  uni8CB0,  CJK UNIFIED IDEOGRAPH-8CB0
        0x53EC, # G+5500  U+53EC  uni53EC,  CJK UNIFIED IDEOGRAPH-53EC
        0x562F, # G+5501  U+562F  uni562F,  CJK UNIFIED IDEOGRAPH-562F
        0x5851, # G+5502  U+5851  uni5851,  CJK UNIFIED IDEOGRAPH-5851
        0x5BB5, # G+5503  U+5BB5  uni5BB5,  CJK UNIFIED IDEOGRAPH-5BB5
        0x2F29, # G+5504  U+2F29  uni2F29,  KANGXI RADICAL SMALL
        0x5C11, # G+5505  U+5C11  uni5C11,  CJK UNIFIED IDEOGRAPH-5C11
        0x5DE2, # G+5506  U+5DE2  uni5DE2,  CJK UNIFIED IDEOGRAPH-5DE2
        0x6240, # G+5507  U+6240  uni6240,  CJK UNIFIED IDEOGRAPH-6240
        0x6383, # G+5508  U+6383  uni6383,  CJK UNIFIED IDEOGRAPH-6383
        0x6414, # G+5509  U+6414  uni6414,  CJK UNIFIED IDEOGRAPH-6414
        0x662D, # G+5510  U+662D  uni662D,  CJK UNIFIED IDEOGRAPH-662D
        0x68B3, # G+5511  U+68B3  uni68B3,  CJK UNIFIED IDEOGRAPH-68B3
        0x6CBC, # G+5512  U+6CBC  uni6CBC,  CJK UNIFIED IDEOGRAPH-6CBC
        0x6D88, # G+5513  U+6D88  uni6D88,  CJK UNIFIED IDEOGRAPH-6D88
        0x6EAF, # G+5514  U+6EAF  uni6EAF,  CJK UNIFIED IDEOGRAPH-6EAF
        0x701F, # G+5515  U+701F  uni701F,  CJK UNIFIED IDEOGRAPH-701F
        0x70A4, # G+5516  U+70A4  uni70A4,  CJK UNIFIED IDEOGRAPH-70A4
        0x71D2, # G+5517  U+71D2  uni71D2,  CJK UNIFIED IDEOGRAPH-71D2
        0x7526, # G+5518  U+7526  uni7526,  CJK UNIFIED IDEOGRAPH-7526
        0x758F, # G+5519  U+758F  uni758F,  CJK UNIFIED IDEOGRAPH-758F
        0x758E, # G+5520  U+758E  uni758E,  CJK UNIFIED IDEOGRAPH-758E
        0x7619, # G+5521  U+7619  uni7619,  CJK UNIFIED IDEOGRAPH-7619
        0x7B11, # G+5522  U+7B11  uni7B11,  CJK UNIFIED IDEOGRAPH-7B11
        0x7BE0, # G+5523  U+7BE0  uni7BE0,  CJK UNIFIED IDEOGRAPH-7BE0
        0x7C2B, # G+5524  U+7C2B  uni7C2B,  CJK UNIFIED IDEOGRAPH-7C2B
        0x7D20, # G+5525  U+7D20  uni7D20,  CJK UNIFIED IDEOGRAPH-7D20
        0x7D39, # G+5526  U+7D39  uni7D39,  CJK UNIFIED IDEOGRAPH-7D39
        0x852C, # G+5527  U+852C  uni852C,  CJK UNIFIED IDEOGRAPH-852C
        0x856D, # G+5528  U+856D  uni856D,  CJK UNIFIED IDEOGRAPH-856D
        0x8607, # G+5529  U+8607  uni8607,  CJK UNIFIED IDEOGRAPH-8607
        0x8A34, # G+5530  U+8A34  uni8A34,  CJK UNIFIED IDEOGRAPH-8A34
        0x900D, # G+5531  U+900D  uni900D,  CJK UNIFIED IDEOGRAPH-900D
        0x9061, # G+5532  U+9061  uni9061,  CJK UNIFIED IDEOGRAPH-9061
        0x90B5, # G+5533  U+90B5  uni90B5,  CJK UNIFIED IDEOGRAPH-90B5
        0x92B7, # G+5534  U+92B7  uni92B7,  CJK UNIFIED IDEOGRAPH-92B7
        0x97F6, # G+5535  U+97F6  uni97F6,  CJK UNIFIED IDEOGRAPH-97F6
        0x9A37, # G+5536  U+9A37  uni9A37,  CJK UNIFIED IDEOGRAPH-9A37
        0x4FD7, # G+5537  U+4FD7  uni4FD7,  CJK UNIFIED IDEOGRAPH-4FD7
        0x5C6C, # G+5538  U+5C6C  uni5C6C,  CJK UNIFIED IDEOGRAPH-5C6C
        0x675F, # G+5539  U+675F  uni675F,  CJK UNIFIED IDEOGRAPH-675F
        0x6D91, # G+5540  U+6D91  uni6D91,  CJK UNIFIED IDEOGRAPH-6D91
        0x7C9F, # G+5541  U+7C9F  uni7C9F,  CJK UNIFIED IDEOGRAPH-7C9F
        0x7E8C, # G+5542  U+7E8C  uni7E8C,  CJK UNIFIED IDEOGRAPH-7E8C
        0x8B16, # G+5543  U+8B16  uni8B16,  CJK UNIFIED IDEOGRAPH-8B16
        0x8D16, # G+5544  U+8D16  uni8D16,  CJK UNIFIED IDEOGRAPH-8D16
        0x901F, # G+5545  U+901F  uni901F,  CJK UNIFIED IDEOGRAPH-901F
        0x5B6B, # G+5546  U+5B6B  uni5B6B,  CJK UNIFIED IDEOGRAPH-5B6B
        0x5DFD, # G+5547  U+5DFD  uni5DFD,  CJK UNIFIED IDEOGRAPH-5DFD
        0x640D, # G+5548  U+640D  uni640D,  CJK UNIFIED IDEOGRAPH-640D
        0x84C0, # G+5549  U+84C0  uni84C0,  CJK UNIFIED IDEOGRAPH-84C0
        0x905C, # G+5550  U+905C  uni905C,  CJK UNIFIED IDEOGRAPH-905C
        0x98E1, # G+5551  U+98E1  uni98E1,  CJK UNIFIED IDEOGRAPH-98E1
        0x7387, # G+5552  U+7387  uni7387,  CJK UNIFIED IDEOGRAPH-7387
        0x5B8B, # G+5553  U+5B8B  uni5B8B,  CJK UNIFIED IDEOGRAPH-5B8B
        0x609A, # G+5554  U+609A  uni609A,  CJK UNIFIED IDEOGRAPH-609A
        0x677E, # G+5555  U+677E  uni677E,  CJK UNIFIED IDEOGRAPH-677E
        0x6DDE, # G+5556  U+6DDE  uni6DDE,  CJK UNIFIED IDEOGRAPH-6DDE
        0x8A1F, # G+5557  U+8A1F  uni8A1F,  CJK UNIFIED IDEOGRAPH-8A1F
        0x8AA6, # G+5558  U+8AA6  uni8AA6,  CJK UNIFIED IDEOGRAPH-8AA6
        0x9001, # G+5559  U+9001  uni9001,  CJK UNIFIED IDEOGRAPH-9001
        0x980C, # G+5560  U+980C  uni980C,  CJK UNIFIED IDEOGRAPH-980C
        0x5237, # G+5561  U+5237  uni5237,  CJK UNIFIED IDEOGRAPH-5237
        0x7051, # G+5562  U+7051  uni7051,  CJK UNIFIED IDEOGRAPH-7051
        0x788E, # G+5563  U+788E  uni788E,  CJK UNIFIED IDEOGRAPH-788E
        0x9396, # G+5564  U+9396  uni9396,  CJK UNIFIED IDEOGRAPH-9396
        0x8870, # G+5565  U+8870  uni8870,  CJK UNIFIED IDEOGRAPH-8870
        0x91D7, # G+5566  U+91D7  uni91D7,  CJK UNIFIED IDEOGRAPH-91D7
        0x4FEE, # G+5567  U+4FEE  uni4FEE,  CJK UNIFIED IDEOGRAPH-4FEE
        0x53D7, # G+5568  U+53D7  uni53D7,  CJK UNIFIED IDEOGRAPH-53D7
        0x55FD, # G+5569  U+55FD  uni55FD,  CJK UNIFIED IDEOGRAPH-55FD
        0x56DA, # G+5570  U+56DA  uni56DA,  CJK UNIFIED IDEOGRAPH-56DA
        0x5782, # G+5571  U+5782  uni5782,  CJK UNIFIED IDEOGRAPH-5782
        0x58FD, # G+5572  U+58FD  uni58FD,  CJK UNIFIED IDEOGRAPH-58FD
        0x5AC2, # G+5573  U+5AC2  uni5AC2,  CJK UNIFIED IDEOGRAPH-5AC2
        0x5B88, # G+5574  U+5B88  uni5B88,  CJK UNIFIED IDEOGRAPH-5B88
        0x5CAB, # G+5575  U+5CAB  uni5CAB,  CJK UNIFIED IDEOGRAPH-5CAB
        0x5CC0, # G+5576  U+5CC0  uni5CC0,  CJK UNIFIED IDEOGRAPH-5CC0
        0x5E25, # G+5577  U+5E25  uni5E25,  CJK UNIFIED IDEOGRAPH-5E25
        0x6101, # G+5578  U+6101  uni6101,  CJK UNIFIED IDEOGRAPH-6101
        0x620D, # G+5579  U+620D  uni620D,  CJK UNIFIED IDEOGRAPH-620D
        0x2F3F, # G+5580  U+2F3F  uni2F3F,  KANGXI RADICAL HAND
        0x6388, # G+5581  U+6388  uni6388,  CJK UNIFIED IDEOGRAPH-6388
        0x641C, # G+5582  U+641C  uni641C,  CJK UNIFIED IDEOGRAPH-641C
        0x6536, # G+5583  U+6536  uni6536,  CJK UNIFIED IDEOGRAPH-6536
        0x6578, # G+5584  U+6578  uni6578,  CJK UNIFIED IDEOGRAPH-6578
        0x6A39, # G+5585  U+6A39  uni6A39,  CJK UNIFIED IDEOGRAPH-6A39
        0x6B8A, # G+5586  U+6B8A  uni6B8A,  CJK UNIFIED IDEOGRAPH-6B8A
        0x2F54, # G+5587  U+2F54  uni2F54,  KANGXI RADICAL WATER
        0x6D19, # G+5588  U+6D19  uni6D19,  CJK UNIFIED IDEOGRAPH-6D19
        0x6F31, # G+5589  U+6F31  uni6F31,  CJK UNIFIED IDEOGRAPH-6F31
        0x71E7, # G+5590  U+71E7  uni71E7,  CJK UNIFIED IDEOGRAPH-71E7
        0x72E9, # G+5591  U+72E9  uni72E9,  CJK UNIFIED IDEOGRAPH-72E9
        0x7378, # G+5592  U+7378  uni7378,  CJK UNIFIED IDEOGRAPH-7378
        0x7407, # G+5593  U+7407  uni7407,  CJK UNIFIED IDEOGRAPH-7407
        0x74B2, # G+5594  U+74B2  uni74B2,  CJK UNIFIED IDEOGRAPH-74B2
        0x7626, # G+5595  U+7626  uni7626,  CJK UNIFIED IDEOGRAPH-7626
        0x7761, # G+5596  U+7761  uni7761,  CJK UNIFIED IDEOGRAPH-7761
        0x79C0, # G+5597  U+79C0  uni79C0,  CJK UNIFIED IDEOGRAPH-79C0
        0x7A57, # G+5598  U+7A57  uni7A57,  CJK UNIFIED IDEOGRAPH-7A57
        0x7AEA, # G+5599  U+7AEA  uni7AEA,  CJK UNIFIED IDEOGRAPH-7AEA
        0x7CB9, # G+5600  U+7CB9  uni7CB9,  CJK UNIFIED IDEOGRAPH-7CB9
        0x7D8F, # G+5601  U+7D8F  uni7D8F,  CJK UNIFIED IDEOGRAPH-7D8F
        0x7DAC, # G+5602  U+7DAC  uni7DAC,  CJK UNIFIED IDEOGRAPH-7DAC
        0x7E61, # G+5603  U+7E61  uni7E61,  CJK UNIFIED IDEOGRAPH-7E61
        0x7F9E, # G+5604  U+7F9E  uni7F9E,  CJK UNIFIED IDEOGRAPH-7F9E
        0x8129, # G+5605  U+8129  uni8129,  CJK UNIFIED IDEOGRAPH-8129
        0x8331, # G+5606  U+8331  uni8331,  CJK UNIFIED IDEOGRAPH-8331
        0x8490, # G+5607  U+8490  uni8490,  CJK UNIFIED IDEOGRAPH-8490
        0x84DA, # G+5608  U+84DA  uni84DA,  CJK UNIFIED IDEOGRAPH-84DA
        0x85EA, # G+5609  U+85EA  uni85EA,  CJK UNIFIED IDEOGRAPH-85EA
        0x8896, # G+5610  U+8896  uni8896,  CJK UNIFIED IDEOGRAPH-8896
        0x8AB0, # G+5611  U+8AB0  uni8AB0,  CJK UNIFIED IDEOGRAPH-8AB0
        0x8B90, # G+5612  U+8B90  uni8B90,  CJK UNIFIED IDEOGRAPH-8B90
        0x8F38, # G+5613  U+8F38  uni8F38,  CJK UNIFIED IDEOGRAPH-8F38
        0x9042, # G+5614  U+9042  uni9042,  CJK UNIFIED IDEOGRAPH-9042
        0x9083, # G+5615  U+9083  uni9083,  CJK UNIFIED IDEOGRAPH-9083
        0x916C, # G+5616  U+916C  uni916C,  CJK UNIFIED IDEOGRAPH-916C
        0x9296, # G+5617  U+9296  uni9296,  CJK UNIFIED IDEOGRAPH-9296
        0x92B9, # G+5618  U+92B9  uni92B9,  CJK UNIFIED IDEOGRAPH-92B9
        0x968B, # G+5619  U+968B  uni968B,  CJK UNIFIED IDEOGRAPH-968B
        0x96A7, # G+5620  U+96A7  uni96A7,  CJK UNIFIED IDEOGRAPH-96A7
        0x96A8, # G+5621  U+96A8  uni96A8,  CJK UNIFIED IDEOGRAPH-96A8
        0x96D6, # G+5622  U+96D6  uni96D6,  CJK UNIFIED IDEOGRAPH-96D6
        0x9700, # G+5623  U+9700  uni9700,  CJK UNIFIED IDEOGRAPH-9700
        0x9808, # G+5624  U+9808  uni9808,  CJK UNIFIED IDEOGRAPH-9808
        0x2FB8, # G+5625  U+2FB8  uni2FB8,  KANGXI RADICAL HEAD
        0x9AD3, # G+5626  U+9AD3  uni9AD3,  CJK UNIFIED IDEOGRAPH-9AD3
        0x9B1A, # G+5627  U+9B1A  uni9B1A,  CJK UNIFIED IDEOGRAPH-9B1A
        0x53D4, # G+5628  U+53D4  uni53D4,  CJK UNIFIED IDEOGRAPH-53D4
        0x587E, # G+5629  U+587E  uni587E,  CJK UNIFIED IDEOGRAPH-587E
        0x5919, # G+5630  U+5919  uni5919,  CJK UNIFIED IDEOGRAPH-5919
        0x5B70, # G+5631  U+5B70  uni5B70,  CJK UNIFIED IDEOGRAPH-5B70
        0x5BBF, # G+5632  U+5BBF  uni5BBF,  CJK UNIFIED IDEOGRAPH-5BBF
        0x6DD1, # G+5633  U+6DD1  uni6DD1,  CJK UNIFIED IDEOGRAPH-6DD1
        0x6F5A, # G+5634  U+6F5A  uni6F5A,  CJK UNIFIED IDEOGRAPH-6F5A
        0x719F, # G+5635  U+719F  uni719F,  CJK UNIFIED IDEOGRAPH-719F
        0x7421, # G+5636  U+7421  uni7421,  CJK UNIFIED IDEOGRAPH-7421
        0x74B9, # G+5637  U+74B9  uni74B9,  CJK UNIFIED IDEOGRAPH-74B9
        0x8085, # G+5638  U+8085  uni8085,  CJK UNIFIED IDEOGRAPH-8085
        0x83FD, # G+5639  U+83FD  uni83FD,  CJK UNIFIED IDEOGRAPH-83FD
        0x5DE1, # G+5640  U+5DE1  uni5DE1,  CJK UNIFIED IDEOGRAPH-5DE1
        0x5F87, # G+5641  U+5F87  uni5F87,  CJK UNIFIED IDEOGRAPH-5F87
        0x5FAA, # G+5642  U+5FAA  uni5FAA,  CJK UNIFIED IDEOGRAPH-5FAA
        0x6042, # G+5643  U+6042  uni6042,  CJK UNIFIED IDEOGRAPH-6042
        0x65EC, # G+5644  U+65EC  uni65EC,  CJK UNIFIED IDEOGRAPH-65EC
        0x6812, # G+5645  U+6812  uni6812,  CJK UNIFIED IDEOGRAPH-6812
        0x696F, # G+5646  U+696F  uni696F,  CJK UNIFIED IDEOGRAPH-696F
        0x6A53, # G+5647  U+6A53  uni6A53,  CJK UNIFIED IDEOGRAPH-6A53
        0x6B89, # G+5648  U+6B89  uni6B89,  CJK UNIFIED IDEOGRAPH-6B89
        0x6D35, # G+5649  U+6D35  uni6D35,  CJK UNIFIED IDEOGRAPH-6D35
        0x6DF3, # G+5650  U+6DF3  uni6DF3,  CJK UNIFIED IDEOGRAPH-6DF3
        0x73E3, # G+5651  U+73E3  uni73E3,  CJK UNIFIED IDEOGRAPH-73E3
        0x76FE, # G+5652  U+76FE  uni76FE,  CJK UNIFIED IDEOGRAPH-76FE
        0x77AC, # G+5653  U+77AC  uni77AC,  CJK UNIFIED IDEOGRAPH-77AC
        0x7B4D, # G+5654  U+7B4D  uni7B4D,  CJK UNIFIED IDEOGRAPH-7B4D
        0x7D14, # G+5655  U+7D14  uni7D14,  CJK UNIFIED IDEOGRAPH-7D14
        0x8123, # G+5656  U+8123  uni8123,  CJK UNIFIED IDEOGRAPH-8123
        0x821C, # G+5657  U+821C  uni821C,  CJK UNIFIED IDEOGRAPH-821C
        0x8340, # G+5658  U+8340  uni8340,  CJK UNIFIED IDEOGRAPH-8340
        0x84F4, # G+5659  U+84F4  uni84F4,  CJK UNIFIED IDEOGRAPH-84F4
        0x8563, # G+5660  U+8563  uni8563,  CJK UNIFIED IDEOGRAPH-8563
        0x8A62, # G+5661  U+8A62  uni8A62,  CJK UNIFIED IDEOGRAPH-8A62
        0x8AC4, # G+5662  U+8AC4  uni8AC4,  CJK UNIFIED IDEOGRAPH-8AC4
        0x9187, # G+5663  U+9187  uni9187,  CJK UNIFIED IDEOGRAPH-9187
        0x931E, # G+5664  U+931E  uni931E,  CJK UNIFIED IDEOGRAPH-931E
        0x9806, # G+5665  U+9806  uni9806,  CJK UNIFIED IDEOGRAPH-9806
        0x99B4, # G+5666  U+99B4  uni99B4,  CJK UNIFIED IDEOGRAPH-99B4
        0x620C, # G+5667  U+620C  uni620C,  CJK UNIFIED IDEOGRAPH-620C
        0x8853, # G+5668  U+8853  uni8853,  CJK UNIFIED IDEOGRAPH-8853
        0x8FF0, # G+5669  U+8FF0  uni8FF0,  CJK UNIFIED IDEOGRAPH-8FF0
        0x9265, # G+5670  U+9265  uni9265,  CJK UNIFIED IDEOGRAPH-9265
        0x5D07, # G+5671  U+5D07  uni5D07,  CJK UNIFIED IDEOGRAPH-5D07
        0x5D27, # G+5672  U+5D27  uni5D27,  CJK UNIFIED IDEOGRAPH-5D27
        0x5D69, # G+5673  U+5D69  uni5D69,  CJK UNIFIED IDEOGRAPH-5D69
        0x745F, # G+5674  U+745F  uni745F,  CJK UNIFIED IDEOGRAPH-745F
        0x819D, # G+5675  U+819D  uni819D,  CJK UNIFIED IDEOGRAPH-819D
        0x8768, # G+5676  U+8768  uni8768,  CJK UNIFIED IDEOGRAPH-8768
        0x6FD5, # G+5677  U+6FD5  uni6FD5,  CJK UNIFIED IDEOGRAPH-6FD5
        0x62FE, # G+5678  U+62FE  uni62FE,  CJK UNIFIED IDEOGRAPH-62FE
        0x7FD2, # G+5679  U+7FD2  uni7FD2,  CJK UNIFIED IDEOGRAPH-7FD2
        0x8936, # G+5680  U+8936  uni8936,  CJK UNIFIED IDEOGRAPH-8936
        0x8972, # G+5681  U+8972  uni8972,  CJK UNIFIED IDEOGRAPH-8972
        0x4E1E, # G+5682  U+4E1E  uni4E1E,  CJK UNIFIED IDEOGRAPH-4E1E
        0x4E58, # G+5683  U+4E58  uni4E58,  CJK UNIFIED IDEOGRAPH-4E58
        0x50E7, # G+5684  U+50E7  uni50E7,  CJK UNIFIED IDEOGRAPH-50E7
        0x52DD, # G+5685  U+52DD  uni52DD,  CJK UNIFIED IDEOGRAPH-52DD
        0x5347, # G+5686  U+5347  uni5347,  CJK UNIFIED IDEOGRAPH-5347
        0x627F, # G+5687  U+627F  uni627F,  CJK UNIFIED IDEOGRAPH-627F
        0x6607, # G+5688  U+6607  uni6607,  CJK UNIFIED IDEOGRAPH-6607
        0x7E69, # G+5689  U+7E69  uni7E69,  CJK UNIFIED IDEOGRAPH-7E69
        0x8805, # G+5690  U+8805  uni8805,  CJK UNIFIED IDEOGRAPH-8805
        0x965E, # G+5691  U+965E  uni965E,  CJK UNIFIED IDEOGRAPH-965E
        0x4F8D, # G+5692  U+4F8D  uni4F8D,  CJK UNIFIED IDEOGRAPH-4F8D
        0x5319, # G+5693  U+5319  uni5319,  CJK UNIFIED IDEOGRAPH-5319
        0x5636, # G+5694  U+5636  uni5636,  CJK UNIFIED IDEOGRAPH-5636
        0x59CB, # G+5695  U+59CB  uni59CB,  CJK UNIFIED IDEOGRAPH-59CB
        0x5AA4, # G+5696  U+5AA4  uni5AA4,  CJK UNIFIED IDEOGRAPH-5AA4
        0x2F2B, # G+5697  U+2F2B  uni2F2B,  KANGXI RADICAL CORPSE
        0x5C4E, # G+5698  U+5C4E  uni5C4E,  CJK UNIFIED IDEOGRAPH-5C4E
        0x5C4D, # G+5699  U+5C4D  uni5C4D,  CJK UNIFIED IDEOGRAPH-5C4D
        0x5E02, # G+5700  U+5E02  uni5E02,  CJK UNIFIED IDEOGRAPH-5E02
        0x5F11, # G+5701  U+5F11  uni5F11,  CJK UNIFIED IDEOGRAPH-5F11
        0x6043, # G+5702  U+6043  uni6043,  CJK UNIFIED IDEOGRAPH-6043
        0x65BD, # G+5703  U+65BD  uni65BD,  CJK UNIFIED IDEOGRAPH-65BD
        0x662F, # G+5704  U+662F  uni662F,  CJK UNIFIED IDEOGRAPH-662F
        0x6642, # G+5705  U+6642  uni6642,  CJK UNIFIED IDEOGRAPH-6642
        0x67BE, # G+5706  U+67BE  uni67BE,  CJK UNIFIED IDEOGRAPH-67BE
        0x67F4, # G+5707  U+67F4  uni67F4,  CJK UNIFIED IDEOGRAPH-67F4
        0x731C, # G+5708  U+731C  uni731C,  CJK UNIFIED IDEOGRAPH-731C
        0x2F6E, # G+5709  U+2F6E  uni2F6E,  KANGXI RADICAL ARROW
        0x2F70, # G+5710  U+2F70  uni2F70,  KANGXI RADICAL SPIRIT
        0x7FC5, # G+5711  U+7FC5  uni7FC5,  CJK UNIFIED IDEOGRAPH-7FC5
        0x8494, # G+5712  U+8494  uni8494,  CJK UNIFIED IDEOGRAPH-8494
        0x84CD, # G+5713  U+84CD  uni84CD,  CJK UNIFIED IDEOGRAPH-84CD
        0x8996, # G+5714  U+8996  uni8996,  CJK UNIFIED IDEOGRAPH-8996
        0x8A66, # G+5715  U+8A66  uni8A66,  CJK UNIFIED IDEOGRAPH-8A66
        0x8A69, # G+5716  U+8A69  uni8A69,  CJK UNIFIED IDEOGRAPH-8A69
        0x8AE1, # G+5717  U+8AE1  uni8AE1,  CJK UNIFIED IDEOGRAPH-8AE1
        0x2F97, # G+5718  U+2F97  uni2F97,  KANGXI RADICAL PIG
        0x8C7A, # G+5719  U+8C7A  uni8C7A,  CJK UNIFIED IDEOGRAPH-8C7A
        0x57F4, # G+5720  U+57F4  uni57F4,  CJK UNIFIED IDEOGRAPH-57F4
        0x5BD4, # G+5721  U+5BD4  uni5BD4,  CJK UNIFIED IDEOGRAPH-5BD4
        0x5F0F, # G+5722  U+5F0F  uni5F0F,  CJK UNIFIED IDEOGRAPH-5F0F
        0x606F, # G+5723  U+606F  uni606F,  CJK UNIFIED IDEOGRAPH-606F
        0x62ED, # G+5724  U+62ED  uni62ED,  CJK UNIFIED IDEOGRAPH-62ED
        0x690D, # G+5725  U+690D  uni690D,  CJK UNIFIED IDEOGRAPH-690D
        0x6B96, # G+5726  U+6B96  uni6B96,  CJK UNIFIED IDEOGRAPH-6B96
        0x6E5C, # G+5727  U+6E5C  uni6E5C,  CJK UNIFIED IDEOGRAPH-6E5C
        0x7184, # G+5728  U+7184  uni7184,  CJK UNIFIED IDEOGRAPH-7184
        0x7BD2, # G+5729  U+7BD2  uni7BD2,  CJK UNIFIED IDEOGRAPH-7BD2
        0x8755, # G+5730  U+8755  uni8755,  CJK UNIFIED IDEOGRAPH-8755
        0x8B58, # G+5731  U+8B58  uni8B58,  CJK UNIFIED IDEOGRAPH-8B58
        0x8EFE, # G+5732  U+8EFE  uni8EFE,  CJK UNIFIED IDEOGRAPH-8EFE
        0x2FB7, # G+5733  U+2FB7  uni2FB7,  KANGXI RADICAL EAT
        0x98FE, # G+5734  U+98FE  uni98FE,  CJK UNIFIED IDEOGRAPH-98FE
        0x4F38, # G+5735  U+4F38  uni4F38,  CJK UNIFIED IDEOGRAPH-4F38
        0x4F81, # G+5736  U+4F81  uni4F81,  CJK UNIFIED IDEOGRAPH-4F81
        0x4FE1, # G+5737  U+4FE1  uni4FE1,  CJK UNIFIED IDEOGRAPH-4FE1
        0x547B, # G+5738  U+547B  uni547B,  CJK UNIFIED IDEOGRAPH-547B
        0x5A20, # G+5739  U+5A20  uni5A20,  CJK UNIFIED IDEOGRAPH-5A20
        0x5BB8, # G+5740  U+5BB8  uni5BB8,  CJK UNIFIED IDEOGRAPH-5BB8
        0x613C, # G+5741  U+613C  uni613C,  CJK UNIFIED IDEOGRAPH-613C
        0x65B0, # G+5742  U+65B0  uni65B0,  CJK UNIFIED IDEOGRAPH-65B0
        0x6668, # G+5743  U+6668  uni6668,  CJK UNIFIED IDEOGRAPH-6668
        0x71FC, # G+5744  U+71FC  uni71FC,  CJK UNIFIED IDEOGRAPH-71FC
        0x7533, # G+5745  U+7533  uni7533,  CJK UNIFIED IDEOGRAPH-7533
        0x795E, # G+5746  U+795E  uni795E,  CJK UNIFIED IDEOGRAPH-795E
        0x7D33, # G+5747  U+7D33  uni7D33,  CJK UNIFIED IDEOGRAPH-7D33
        0x814E, # G+5748  U+814E  uni814E,  CJK UNIFIED IDEOGRAPH-814E
        0x2F82, # G+5749  U+2F82  uni2F82,  KANGXI RADICAL MINISTER
        0x8398, # G+5750  U+8398  uni8398,  CJK UNIFIED IDEOGRAPH-8398
        0x85AA, # G+5751  U+85AA  uni85AA,  CJK UNIFIED IDEOGRAPH-85AA
        0x85CE, # G+5752  U+85CE  uni85CE,  CJK UNIFIED IDEOGRAPH-85CE
        0x8703, # G+5753  U+8703  uni8703,  CJK UNIFIED IDEOGRAPH-8703
        0x8A0A, # G+5754  U+8A0A  uni8A0A,  CJK UNIFIED IDEOGRAPH-8A0A
        0x2F9D, # G+5755  U+2F9D  uni2F9D,  KANGXI RADICAL BODY
        0x2F9F, # G+5756  U+2F9F  uni2F9F,  KANGXI RADICAL BITTER
        0x8FC5, # G+5757  U+8FC5  uni8FC5,  CJK UNIFIED IDEOGRAPH-8FC5
        0x5931, # G+5758  U+5931  uni5931,  CJK UNIFIED IDEOGRAPH-5931
        0x5BA4, # G+5759  U+5BA4  uni5BA4,  CJK UNIFIED IDEOGRAPH-5BA4
        0x5BE6, # G+5760  U+5BE6  uni5BE6,  CJK UNIFIED IDEOGRAPH-5BE6
        0x6089, # G+5761  U+6089  uni6089,  CJK UNIFIED IDEOGRAPH-6089
        0x5BE9, # G+5762  U+5BE9  uni5BE9,  CJK UNIFIED IDEOGRAPH-5BE9
        0x5C0B, # G+5763  U+5C0B  uni5C0B,  CJK UNIFIED IDEOGRAPH-5C0B
        0x2F3C, # G+5764  U+2F3C  uni2F3C,  KANGXI RADICAL HEART
        0x6C81, # G+5765  U+6C81  uni6C81,  CJK UNIFIED IDEOGRAPH-6C81
        0x6DF1, # G+5766  U+6DF1  uni6DF1,  CJK UNIFIED IDEOGRAPH-6DF1
        0x700B, # G+5767  U+700B  uni700B,  CJK UNIFIED IDEOGRAPH-700B
        0x751A, # G+5768  U+751A  uni751A,  CJK UNIFIED IDEOGRAPH-751A
        0x82AF, # G+5769  U+82AF  uni82AF,  CJK UNIFIED IDEOGRAPH-82AF
        0x8AF6, # G+5770  U+8AF6  uni8AF6,  CJK UNIFIED IDEOGRAPH-8AF6
        0x4EC0, # G+5771  U+4EC0  uni4EC0,  CJK UNIFIED IDEOGRAPH-4EC0
        0x2F17, # G+5772  U+2F17  uni2F17,  KANGXI RADICAL TEN
        0x96D9, # G+5773  U+96D9  uni96D9,  CJK UNIFIED IDEOGRAPH-96D9
        0x2F52, # G+5774  U+2F52  uni2F52,  KANGXI RADICAL CLAN
        0x4E9E, # G+5775  U+4E9E  uni4E9E,  CJK UNIFIED IDEOGRAPH-4E9E
        0x4FC4, # G+5776  U+4FC4  uni4FC4,  CJK UNIFIED IDEOGRAPH-4FC4
        0x5152, # G+5777  U+5152  uni5152,  CJK UNIFIED IDEOGRAPH-5152
        0x555E, # G+5778  U+555E  uni555E,  CJK UNIFIED IDEOGRAPH-555E
        0x5A25, # G+5779  U+5A25  uni5A25,  CJK UNIFIED IDEOGRAPH-5A25
        0x5CE8, # G+5780  U+5CE8  uni5CE8,  CJK UNIFIED IDEOGRAPH-5CE8
        0x6211, # G+5781  U+6211  uni6211,  CJK UNIFIED IDEOGRAPH-6211
        0x2F5B, # G+5782  U+2F5B  uni2F5B,  KANGXI RADICAL FANG
        0x82BD, # G+5783  U+82BD  uni82BD,  CJK UNIFIED IDEOGRAPH-82BD
        0x83AA, # G+5784  U+83AA  uni83AA,  CJK UNIFIED IDEOGRAPH-83AA
        0x86FE, # G+5785  U+86FE  uni86FE,  CJK UNIFIED IDEOGRAPH-86FE
        0x8859, # G+5786  U+8859  uni8859,  CJK UNIFIED IDEOGRAPH-8859
        0x8A1D, # G+5787  U+8A1D  uni8A1D,  CJK UNIFIED IDEOGRAPH-8A1D
        0x963F, # G+5788  U+963F  uni963F,  CJK UNIFIED IDEOGRAPH-963F
        0x96C5, # G+5789  U+96C5  uni96C5,  CJK UNIFIED IDEOGRAPH-96C5
        0x9913, # G+5790  U+9913  uni9913,  CJK UNIFIED IDEOGRAPH-9913
        0x9D09, # G+5791  U+9D09  uni9D09,  CJK UNIFIED IDEOGRAPH-9D09
        0x9D5D, # G+5792  U+9D5D  uni9D5D,  CJK UNIFIED IDEOGRAPH-9D5D
        0x580A, # G+5793  U+580A  uni580A,  CJK UNIFIED IDEOGRAPH-580A
        0x5CB3, # G+5794  U+5CB3  uni5CB3,  CJK UNIFIED IDEOGRAPH-5CB3
        0x5DBD, # G+5795  U+5DBD  uni5DBD,  CJK UNIFIED IDEOGRAPH-5DBD
        0x5E44, # G+5796  U+5E44  uni5E44,  CJK UNIFIED IDEOGRAPH-5E44
        0x60E1, # G+5797  U+60E1  uni60E1,  CJK UNIFIED IDEOGRAPH-60E1
        0x6115, # G+5798  U+6115  uni6115,  CJK UNIFIED IDEOGRAPH-6115
        0x63E1, # G+5799  U+63E1  uni63E1,  CJK UNIFIED IDEOGRAPH-63E1
        0x6A02, # G+5800  U+6A02  uni6A02,  CJK UNIFIED IDEOGRAPH-6A02
        0x6E25, # G+5801  U+6E25  uni6E25,  CJK UNIFIED IDEOGRAPH-6E25
        0x9102, # G+5802  U+9102  uni9102,  CJK UNIFIED IDEOGRAPH-9102
        0x9354, # G+5803  U+9354  uni9354,  CJK UNIFIED IDEOGRAPH-9354
        0x984E, # G+5804  U+984E  uni984E,  CJK UNIFIED IDEOGRAPH-984E
        0x9C10, # G+5805  U+9C10  uni9C10,  CJK UNIFIED IDEOGRAPH-9C10
        0x9F77, # G+5806  U+9F77  uni9F77,  CJK UNIFIED IDEOGRAPH-9F77
        0x5B89, # G+5807  U+5B89  uni5B89,  CJK UNIFIED IDEOGRAPH-5B89
        0x5CB8, # G+5808  U+5CB8  uni5CB8,  CJK UNIFIED IDEOGRAPH-5CB8
        0x6309, # G+5809  U+6309  uni6309,  CJK UNIFIED IDEOGRAPH-6309
        0x664F, # G+5810  U+664F  uni664F,  CJK UNIFIED IDEOGRAPH-664F
        0x6848, # G+5811  U+6848  uni6848,  CJK UNIFIED IDEOGRAPH-6848
        0x773C, # G+5812  U+773C  uni773C,  CJK UNIFIED IDEOGRAPH-773C
        0x96C1, # G+5813  U+96C1  uni96C1,  CJK UNIFIED IDEOGRAPH-96C1
        0x978D, # G+5814  U+978D  uni978D,  CJK UNIFIED IDEOGRAPH-978D
        0x9854, # G+5815  U+9854  uni9854,  CJK UNIFIED IDEOGRAPH-9854
        0x9B9F, # G+5816  U+9B9F  uni9B9F,  CJK UNIFIED IDEOGRAPH-9B9F
        0x65A1, # G+5817  U+65A1  uni65A1,  CJK UNIFIED IDEOGRAPH-65A1
        0x8B01, # G+5818  U+8B01  uni8B01,  CJK UNIFIED IDEOGRAPH-8B01
        0x8ECB, # G+5819  U+8ECB  uni8ECB,  CJK UNIFIED IDEOGRAPH-8ECB
        0x95BC, # G+5820  U+95BC  uni95BC,  CJK UNIFIED IDEOGRAPH-95BC
        0x5535, # G+5821  U+5535  uni5535,  CJK UNIFIED IDEOGRAPH-5535
        0x5CA9, # G+5822  U+5CA9  uni5CA9,  CJK UNIFIED IDEOGRAPH-5CA9
        0x5DD6, # G+5823  U+5DD6  uni5DD6,  CJK UNIFIED IDEOGRAPH-5DD6
        0x5EB5, # G+5824  U+5EB5  uni5EB5,  CJK UNIFIED IDEOGRAPH-5EB5
        0x6697, # G+5825  U+6697  uni6697,  CJK UNIFIED IDEOGRAPH-6697
        0x764C, # G+5826  U+764C  uni764C,  CJK UNIFIED IDEOGRAPH-764C
        0x83F4, # G+5827  U+83F4  uni83F4,  CJK UNIFIED IDEOGRAPH-83F4
        0x95C7, # G+5828  U+95C7  uni95C7,  CJK UNIFIED IDEOGRAPH-95C7
        0x58D3, # G+5829  U+58D3  uni58D3,  CJK UNIFIED IDEOGRAPH-58D3
        0x62BC, # G+5830  U+62BC  uni62BC,  CJK UNIFIED IDEOGRAPH-62BC
        0x72CE, # G+5831  U+72CE  uni72CE,  CJK UNIFIED IDEOGRAPH-72CE
        0x9D28, # G+5832  U+9D28  uni9D28,  CJK UNIFIED IDEOGRAPH-9D28
        0x4EF0, # G+5833  U+4EF0  uni4EF0,  CJK UNIFIED IDEOGRAPH-4EF0
        0x592E, # G+5834  U+592E  uni592E,  CJK UNIFIED IDEOGRAPH-592E
        0x600F, # G+5835  U+600F  uni600F,  CJK UNIFIED IDEOGRAPH-600F
        0x663B, # G+5836  U+663B  uni663B,  CJK UNIFIED IDEOGRAPH-663B
        0x6B83, # G+5837  U+6B83  uni6B83,  CJK UNIFIED IDEOGRAPH-6B83
        0x79E7, # G+5838  U+79E7  uni79E7,  CJK UNIFIED IDEOGRAPH-79E7
        0x9D26, # G+5839  U+9D26  uni9D26,  CJK UNIFIED IDEOGRAPH-9D26
        0x5393, # G+5840  U+5393  uni5393,  CJK UNIFIED IDEOGRAPH-5393
        0x54C0, # G+5841  U+54C0  uni54C0,  CJK UNIFIED IDEOGRAPH-54C0
        0x57C3, # G+5842  U+57C3  uni57C3,  CJK UNIFIED IDEOGRAPH-57C3
        0x5D16, # G+5843  U+5D16  uni5D16,  CJK UNIFIED IDEOGRAPH-5D16
        0x611B, # G+5844  U+611B  uni611B,  CJK UNIFIED IDEOGRAPH-611B
        0x66D6, # G+5845  U+66D6  uni66D6,  CJK UNIFIED IDEOGRAPH-66D6
        0x6DAF, # G+5846  U+6DAF  uni6DAF,  CJK UNIFIED IDEOGRAPH-6DAF
        0x788D, # G+5847  U+788D  uni788D,  CJK UNIFIED IDEOGRAPH-788D
        0x827E, # G+5848  U+827E  uni827E,  CJK UNIFIED IDEOGRAPH-827E
        0x9698, # G+5849  U+9698  uni9698,  CJK UNIFIED IDEOGRAPH-9698
        0x9744, # G+5850  U+9744  uni9744,  CJK UNIFIED IDEOGRAPH-9744
        0x5384, # G+5851  U+5384  uni5384,  CJK UNIFIED IDEOGRAPH-5384
        0x627C, # G+5852  U+627C  uni627C,  CJK UNIFIED IDEOGRAPH-627C
        0x6396, # G+5853  U+6396  uni6396,  CJK UNIFIED IDEOGRAPH-6396
        0x6DB2, # G+5854  U+6DB2  uni6DB2,  CJK UNIFIED IDEOGRAPH-6DB2
        0x7E0A, # G+5855  U+7E0A  uni7E0A,  CJK UNIFIED IDEOGRAPH-7E0A
        0x814B, # G+5856  U+814B  uni814B,  CJK UNIFIED IDEOGRAPH-814B
        0x984D, # G+5857  U+984D  uni984D,  CJK UNIFIED IDEOGRAPH-984D
        0x6AFB, # G+5858  U+6AFB  uni6AFB,  CJK UNIFIED IDEOGRAPH-6AFB
        0x7F4C, # G+5859  U+7F4C  uni7F4C,  CJK UNIFIED IDEOGRAPH-7F4C
        0x9DAF, # G+5860  U+9DAF  uni9DAF,  CJK UNIFIED IDEOGRAPH-9DAF
        0x9E1A, # G+5861  U+9E1A  uni9E1A,  CJK UNIFIED IDEOGRAPH-9E1A
        0x4E5F, # G+5862  U+4E5F  uni4E5F,  CJK UNIFIED IDEOGRAPH-4E5F
        0x503B, # G+5863  U+503B  uni503B,  CJK UNIFIED IDEOGRAPH-503B
        0x51B6, # G+5864  U+51B6  uni51B6,  CJK UNIFIED IDEOGRAPH-51B6
        0x591C, # G+5865  U+591C  uni591C,  CJK UNIFIED IDEOGRAPH-591C
        0x60F9, # G+5866  U+60F9  uni60F9,  CJK UNIFIED IDEOGRAPH-60F9
        0x63F6, # G+5867  U+63F6  uni63F6,  CJK UNIFIED IDEOGRAPH-63F6
        0x6930, # G+5868  U+6930  uni6930,  CJK UNIFIED IDEOGRAPH-6930
        0x723A, # G+5869  U+723A  uni723A,  CJK UNIFIED IDEOGRAPH-723A
        0x8036, # G+5870  U+8036  uni8036,  CJK UNIFIED IDEOGRAPH-8036
        0x91CE, # G+5871  U+91CE  uni91CE,  CJK UNIFIED IDEOGRAPH-91CE
        0x5F31, # G+5872  U+5F31  uni5F31,  CJK UNIFIED IDEOGRAPH-5F31
        0x7D04, # G+5873  U+7D04  uni7D04,  CJK UNIFIED IDEOGRAPH-7D04
        0x82E5, # G+5874  U+82E5  uni82E5,  CJK UNIFIED IDEOGRAPH-82E5
        0x846F, # G+5875  U+846F  uni846F,  CJK UNIFIED IDEOGRAPH-846F
        0x84BB, # G+5876  U+84BB  uni84BB,  CJK UNIFIED IDEOGRAPH-84BB
        0x85E5, # G+5877  U+85E5  uni85E5,  CJK UNIFIED IDEOGRAPH-85E5
        0x8E8D, # G+5878  U+8E8D  uni8E8D,  CJK UNIFIED IDEOGRAPH-8E8D
        0x4F6F, # G+5879  U+4F6F  uni4F6F,  CJK UNIFIED IDEOGRAPH-4F6F
        0x58E4, # G+5880  U+58E4  uni58E4,  CJK UNIFIED IDEOGRAPH-58E4
        0x5B43, # G+5881  U+5B43  uni5B43,  CJK UNIFIED IDEOGRAPH-5B43
        0x6059, # G+5882  U+6059  uni6059,  CJK UNIFIED IDEOGRAPH-6059
        0x63DA, # G+5883  U+63DA  uni63DA,  CJK UNIFIED IDEOGRAPH-63DA
        0x6518, # G+5884  U+6518  uni6518,  CJK UNIFIED IDEOGRAPH-6518
        0x656D, # G+5885  U+656D  uni656D,  CJK UNIFIED IDEOGRAPH-656D
        0x6698, # G+5886  U+6698  uni6698,  CJK UNIFIED IDEOGRAPH-6698
        0x694A, # G+5887  U+694A  uni694A,  CJK UNIFIED IDEOGRAPH-694A
        0x6A23, # G+5888  U+6A23  uni6A23,  CJK UNIFIED IDEOGRAPH-6A23
        0x6D0B, # G+5889  U+6D0B  uni6D0B,  CJK UNIFIED IDEOGRAPH-6D0B
        0x7001, # G+5890  U+7001  uni7001,  CJK UNIFIED IDEOGRAPH-7001
        0x716C, # G+5891  U+716C  uni716C,  CJK UNIFIED IDEOGRAPH-716C
        0x75D2, # G+5892  U+75D2  uni75D2,  CJK UNIFIED IDEOGRAPH-75D2
        0x760D, # G+5893  U+760D  uni760D,  CJK UNIFIED IDEOGRAPH-760D
        0x79B3, # G+5894  U+79B3  uni79B3,  CJK UNIFIED IDEOGRAPH-79B3
        0x7A70, # G+5895  U+7A70  uni7A70,  CJK UNIFIED IDEOGRAPH-7A70
        0x2F7A, # G+5896  U+2F7A  uni2F7A,  KANGXI RADICAL SHEEP
        0x8944, # G+5897  U+8944  uni8944,  CJK UNIFIED IDEOGRAPH-8944
        0x8B93, # G+5898  U+8B93  uni8B93,  CJK UNIFIED IDEOGRAPH-8B93
        0x91C0, # G+5899  U+91C0  uni91C0,  CJK UNIFIED IDEOGRAPH-91C0
        0x967D, # G+5900  U+967D  uni967D,  CJK UNIFIED IDEOGRAPH-967D
        0x990A, # G+5901  U+990A  uni990A,  CJK UNIFIED IDEOGRAPH-990A
        0x5704, # G+5902  U+5704  uni5704,  CJK UNIFIED IDEOGRAPH-5704
        0x5FA1, # G+5903  U+5FA1  uni5FA1,  CJK UNIFIED IDEOGRAPH-5FA1
        0x65BC, # G+5904  U+65BC  uni65BC,  CJK UNIFIED IDEOGRAPH-65BC
        0x6F01, # G+5905  U+6F01  uni6F01,  CJK UNIFIED IDEOGRAPH-6F01
        0x7600, # G+5906  U+7600  uni7600,  CJK UNIFIED IDEOGRAPH-7600
        0x79A6, # G+5907  U+79A6  uni79A6,  CJK UNIFIED IDEOGRAPH-79A6
        0x8A9E, # G+5908  U+8A9E  uni8A9E,  CJK UNIFIED IDEOGRAPH-8A9E
        0x99AD, # G+5909  U+99AD  uni99AD,  CJK UNIFIED IDEOGRAPH-99AD
        0x2FC2, # G+5910  U+2FC2  uni2FC2,  KANGXI RADICAL FISH
        0x9F6C, # G+5911  U+9F6C  uni9F6C,  CJK UNIFIED IDEOGRAPH-9F6C
        0x5104, # G+5912  U+5104  uni5104,  CJK UNIFIED IDEOGRAPH-5104
        0x61B6, # G+5913  U+61B6  uni61B6,  CJK UNIFIED IDEOGRAPH-61B6
        0x6291, # G+5914  U+6291  uni6291,  CJK UNIFIED IDEOGRAPH-6291
        0x6A8D, # G+5915  U+6A8D  uni6A8D,  CJK UNIFIED IDEOGRAPH-6A8D
        0x81C6, # G+5916  U+81C6  uni81C6,  CJK UNIFIED IDEOGRAPH-81C6
        0x5043, # G+5917  U+5043  uni5043,  CJK UNIFIED IDEOGRAPH-5043
        0x5830, # G+5918  U+5830  uni5830,  CJK UNIFIED IDEOGRAPH-5830
        0x5F66, # G+5919  U+5F66  uni5F66,  CJK UNIFIED IDEOGRAPH-5F66
        0x7109, # G+5920  U+7109  uni7109,  CJK UNIFIED IDEOGRAPH-7109
        0x2F94, # G+5921  U+2F94  uni2F94,  KANGXI RADICAL SPEECH
        0x8AFA, # G+5922  U+8AFA  uni8AFA,  CJK UNIFIED IDEOGRAPH-8AFA
        0x5B7C, # G+5923  U+5B7C  uni5B7C,  CJK UNIFIED IDEOGRAPH-5B7C
        0x8616, # G+5924  U+8616  uni8616,  CJK UNIFIED IDEOGRAPH-8616
        0x4FFA, # G+5925  U+4FFA  uni4FFA,  CJK UNIFIED IDEOGRAPH-4FFA
        0x513C, # G+5926  U+513C  uni513C,  CJK UNIFIED IDEOGRAPH-513C
        0x56B4, # G+5927  U+56B4  uni56B4,  CJK UNIFIED IDEOGRAPH-56B4
        0x5944, # G+5928  U+5944  uni5944,  CJK UNIFIED IDEOGRAPH-5944
        0x63A9, # G+5929  U+63A9  uni63A9,  CJK UNIFIED IDEOGRAPH-63A9
        0x6DF9, # G+5930  U+6DF9  uni6DF9,  CJK UNIFIED IDEOGRAPH-6DF9
        0x5DAA, # G+5931  U+5DAA  uni5DAA,  CJK UNIFIED IDEOGRAPH-5DAA
        0x696D, # G+5932  U+696D  uni696D,  CJK UNIFIED IDEOGRAPH-696D
        0x5186, # G+5933  U+5186  uni5186,  CJK UNIFIED IDEOGRAPH-5186
        0x4E88, # G+5934  U+4E88  uni4E88,  CJK UNIFIED IDEOGRAPH-4E88
        0x4F59, # G+5935  U+4F59  uni4F59,  CJK UNIFIED IDEOGRAPH-4F59
        0x5982, # G+5936  U+5982  uni5982,  CJK UNIFIED IDEOGRAPH-5982
        0x6B5F, # G+5937  U+6B5F  uni6B5F,  CJK UNIFIED IDEOGRAPH-6B5F
        0x6C5D, # G+5938  U+6C5D  uni6C5D,  CJK UNIFIED IDEOGRAPH-6C5D
        0x74B5, # G+5939  U+74B5  uni74B5,  CJK UNIFIED IDEOGRAPH-74B5
        0x7916, # G+5940  U+7916  uni7916,  CJK UNIFIED IDEOGRAPH-7916
        0x8207, # G+5941  U+8207  uni8207,  CJK UNIFIED IDEOGRAPH-8207
        0x8245, # G+5942  U+8245  uni8245,  CJK UNIFIED IDEOGRAPH-8245
        0x8339, # G+5943  U+8339  uni8339,  CJK UNIFIED IDEOGRAPH-8339
        0x8F3F, # G+5944  U+8F3F  uni8F3F,  CJK UNIFIED IDEOGRAPH-8F3F
        0x8F5D, # G+5945  U+8F5D  uni8F5D,  CJK UNIFIED IDEOGRAPH-8F5D
        0x9918, # G+5946  U+9918  uni9918,  CJK UNIFIED IDEOGRAPH-9918
        0x4EA6, # G+5947  U+4EA6  uni4EA6,  CJK UNIFIED IDEOGRAPH-4EA6
        0x57DF, # G+5948  U+57DF  uni57DF,  CJK UNIFIED IDEOGRAPH-57DF
        0x5F79, # G+5949  U+5F79  uni5F79,  CJK UNIFIED IDEOGRAPH-5F79
        0x6613, # G+5950  U+6613  uni6613,  CJK UNIFIED IDEOGRAPH-6613
        0x75AB, # G+5951  U+75AB  uni75AB,  CJK UNIFIED IDEOGRAPH-75AB
        0x7E79, # G+5952  U+7E79  uni7E79,  CJK UNIFIED IDEOGRAPH-7E79
        0x8B6F, # G+5953  U+8B6F  uni8B6F,  CJK UNIFIED IDEOGRAPH-8B6F
        0x9006, # G+5954  U+9006  uni9006,  CJK UNIFIED IDEOGRAPH-9006
        0x9A5B, # G+5955  U+9A5B  uni9A5B,  CJK UNIFIED IDEOGRAPH-9A5B
        0x56A5, # G+5956  U+56A5  uni56A5,  CJK UNIFIED IDEOGRAPH-56A5
        0x5827, # G+5957  U+5827  uni5827,  CJK UNIFIED IDEOGRAPH-5827
        0x59F8, # G+5958  U+59F8  uni59F8,  CJK UNIFIED IDEOGRAPH-59F8
        0x5A1F, # G+5959  U+5A1F  uni5A1F,  CJK UNIFIED IDEOGRAPH-5A1F
        0x5BB4, # G+5960  U+5BB4  uni5BB4,  CJK UNIFIED IDEOGRAPH-5BB4
        0x5EF6, # G+5961  U+5EF6  uni5EF6,  CJK UNIFIED IDEOGRAPH-5EF6
        0x6350, # G+5962  U+6350  uni6350,  CJK UNIFIED IDEOGRAPH-6350
        0x633B, # G+5963  U+633B  uni633B,  CJK UNIFIED IDEOGRAPH-633B
        0x693D, # G+5964  U+693D  uni693D,  CJK UNIFIED IDEOGRAPH-693D
        0x6C87, # G+5965  U+6C87  uni6C87,  CJK UNIFIED IDEOGRAPH-6C87
        0x6CBF, # G+5966  U+6CBF  uni6CBF,  CJK UNIFIED IDEOGRAPH-6CBF
        0x6D8E, # G+5967  U+6D8E  uni6D8E,  CJK UNIFIED IDEOGRAPH-6D8E
        0x6D93, # G+5968  U+6D93  uni6D93,  CJK UNIFIED IDEOGRAPH-6D93
        0x6DF5, # G+5969  U+6DF5  uni6DF5,  CJK UNIFIED IDEOGRAPH-6DF5
        0x6F14, # G+5970  U+6F14  uni6F14,  CJK UNIFIED IDEOGRAPH-6F14
        0x70DF, # G+5971  U+70DF  uni70DF,  CJK UNIFIED IDEOGRAPH-70DF
        0x7136, # G+5972  U+7136  uni7136,  CJK UNIFIED IDEOGRAPH-7136
        0x7159, # G+5973  U+7159  uni7159,  CJK UNIFIED IDEOGRAPH-7159
        0x71C3, # G+5974  U+71C3  uni71C3,  CJK UNIFIED IDEOGRAPH-71C3
        0x71D5, # G+5975  U+71D5  uni71D5,  CJK UNIFIED IDEOGRAPH-71D5
        0x784F, # G+5976  U+784F  uni784F,  CJK UNIFIED IDEOGRAPH-784F
        0x786F, # G+5977  U+786F  uni786F,  CJK UNIFIED IDEOGRAPH-786F
        0x7B75, # G+5978  U+7B75  uni7B75,  CJK UNIFIED IDEOGRAPH-7B75
        0x7DE3, # G+5979  U+7DE3  uni7DE3,  CJK UNIFIED IDEOGRAPH-7DE3
        0x7E2F, # G+5980  U+7E2F  uni7E2F,  CJK UNIFIED IDEOGRAPH-7E2F
        0x884D, # G+5981  U+884D  uni884D,  CJK UNIFIED IDEOGRAPH-884D
        0x8EDF, # G+5982  U+8EDF  uni8EDF,  CJK UNIFIED IDEOGRAPH-8EDF
        0x925B, # G+5983  U+925B  uni925B,  CJK UNIFIED IDEOGRAPH-925B
        0x9CF6, # G+5984  U+9CF6  uni9CF6,  CJK UNIFIED IDEOGRAPH-9CF6
        0x6085, # G+5985  U+6085  uni6085,  CJK UNIFIED IDEOGRAPH-6085
        0x6D85, # G+5986  U+6D85  uni6D85,  CJK UNIFIED IDEOGRAPH-6D85
        0x71B1, # G+5987  U+71B1  uni71B1,  CJK UNIFIED IDEOGRAPH-71B1
        0x95B1, # G+5988  U+95B1  uni95B1,  CJK UNIFIED IDEOGRAPH-95B1
        0x53AD, # G+5989  U+53AD  uni53AD,  CJK UNIFIED IDEOGRAPH-53AD
        0x67D3, # G+5990  U+67D3  uni67D3,  CJK UNIFIED IDEOGRAPH-67D3
        0x708E, # G+5991  U+708E  uni708E,  CJK UNIFIED IDEOGRAPH-708E
        0x7130, # G+5992  U+7130  uni7130,  CJK UNIFIED IDEOGRAPH-7130
        0x7430, # G+5993  U+7430  uni7430,  CJK UNIFIED IDEOGRAPH-7430
        0x8276, # G+5994  U+8276  uni8276,  CJK UNIFIED IDEOGRAPH-8276
        0x82D2, # G+5995  U+82D2  uni82D2,  CJK UNIFIED IDEOGRAPH-82D2
        0x95BB, # G+5996  U+95BB  uni95BB,  CJK UNIFIED IDEOGRAPH-95BB
        0x9AE5, # G+5997  U+9AE5  uni9AE5,  CJK UNIFIED IDEOGRAPH-9AE5
        0x9E7D, # G+5998  U+9E7D  uni9E7D,  CJK UNIFIED IDEOGRAPH-9E7D
        0x66C4, # G+5999  U+66C4  uni66C4,  CJK UNIFIED IDEOGRAPH-66C4
        0x71C1, # G+6000  U+71C1  uni71C1,  CJK UNIFIED IDEOGRAPH-71C1
        0x8449, # G+6001  U+8449  uni8449,  CJK UNIFIED IDEOGRAPH-8449
        0x584B, # G+6002  U+584B  uni584B,  CJK UNIFIED IDEOGRAPH-584B
        0x5DB8, # G+6003  U+5DB8  uni5DB8,  CJK UNIFIED IDEOGRAPH-5DB8
        0x5F71, # G+6004  U+5F71  uni5F71,  CJK UNIFIED IDEOGRAPH-5F71
        0x6620, # G+6005  U+6620  uni6620,  CJK UNIFIED IDEOGRAPH-6620
        0x668E, # G+6006  U+668E  uni668E,  CJK UNIFIED IDEOGRAPH-668E
        0x6979, # G+6007  U+6979  uni6979,  CJK UNIFIED IDEOGRAPH-6979
        0x69AE, # G+6008  U+69AE  uni69AE,  CJK UNIFIED IDEOGRAPH-69AE
        0x6C38, # G+6009  U+6C38  uni6C38,  CJK UNIFIED IDEOGRAPH-6C38
        0x6CF3, # G+6010  U+6CF3  uni6CF3,  CJK UNIFIED IDEOGRAPH-6CF3
        0x6E36, # G+6011  U+6E36  uni6E36,  CJK UNIFIED IDEOGRAPH-6E36
        0x6F41, # G+6012  U+6F41  uni6F41,  CJK UNIFIED IDEOGRAPH-6F41
        0x6FDA, # G+6013  U+6FDA  uni6FDA,  CJK UNIFIED IDEOGRAPH-6FDA
        0x701B, # G+6014  U+701B  uni701B,  CJK UNIFIED IDEOGRAPH-701B
        0x702F, # G+6015  U+702F  uni702F,  CJK UNIFIED IDEOGRAPH-702F
        0x7150, # G+6016  U+7150  uni7150,  CJK UNIFIED IDEOGRAPH-7150
        0x71DF, # G+6017  U+71DF  uni71DF,  CJK UNIFIED IDEOGRAPH-71DF
        0x7370, # G+6018  U+7370  uni7370,  CJK UNIFIED IDEOGRAPH-7370
        0x745B, # G+6019  U+745B  uni745B,  CJK UNIFIED IDEOGRAPH-745B
        0x74D4, # G+6020  U+74D4  uni74D4,  CJK UNIFIED IDEOGRAPH-74D4
        0x76C8, # G+6021  U+76C8  uni76C8,  CJK UNIFIED IDEOGRAPH-76C8
        0x7A4E, # G+6022  U+7A4E  uni7A4E,  CJK UNIFIED IDEOGRAPH-7A4E
        0x7E93, # G+6023  U+7E93  uni7E93,  CJK UNIFIED IDEOGRAPH-7E93
        0x82F1, # G+6024  U+82F1  uni82F1,  CJK UNIFIED IDEOGRAPH-82F1
        0x8A60, # G+6025  U+8A60  uni8A60,  CJK UNIFIED IDEOGRAPH-8A60
        0x8FCE, # G+6026  U+8FCE  uni8FCE,  CJK UNIFIED IDEOGRAPH-8FCE
        0x9348, # G+6027  U+9348  uni9348,  CJK UNIFIED IDEOGRAPH-9348
        0x9719, # G+6028  U+9719  uni9719,  CJK UNIFIED IDEOGRAPH-9719
        0x4E42, # G+6029  U+4E42  uni4E42,  CJK UNIFIED IDEOGRAPH-4E42
        0x502A, # G+6030  U+502A  uni502A,  CJK UNIFIED IDEOGRAPH-502A
        0x5208, # G+6031  U+5208  uni5208,  CJK UNIFIED IDEOGRAPH-5208
        0x53E1, # G+6032  U+53E1  uni53E1,  CJK UNIFIED IDEOGRAPH-53E1
        0x66F3, # G+6033  U+66F3  uni66F3,  CJK UNIFIED IDEOGRAPH-66F3
        0x6C6D, # G+6034  U+6C6D  uni6C6D,  CJK UNIFIED IDEOGRAPH-6C6D
        0x6FCA, # G+6035  U+6FCA  uni6FCA,  CJK UNIFIED IDEOGRAPH-6FCA
        0x730A, # G+6036  U+730A  uni730A,  CJK UNIFIED IDEOGRAPH-730A
        0x777F, # G+6037  U+777F  uni777F,  CJK UNIFIED IDEOGRAPH-777F
        0x7A62, # G+6038  U+7A62  uni7A62,  CJK UNIFIED IDEOGRAPH-7A62
        0x82AE, # G+6039  U+82AE  uni82AE,  CJK UNIFIED IDEOGRAPH-82AE
        0x85DD, # G+6040  U+85DD  uni85DD,  CJK UNIFIED IDEOGRAPH-85DD
        0x8602, # G+6041  U+8602  uni8602,  CJK UNIFIED IDEOGRAPH-8602
        0x88D4, # G+6042  U+88D4  uni88D4,  CJK UNIFIED IDEOGRAPH-88D4
        0x8A63, # G+6043  U+8A63  uni8A63,  CJK UNIFIED IDEOGRAPH-8A63
        0x8B7D, # G+6044  U+8B7D  uni8B7D,  CJK UNIFIED IDEOGRAPH-8B7D
        0x8C6B, # G+6045  U+8C6B  uni8C6B,  CJK UNIFIED IDEOGRAPH-8C6B
        0x92B3, # G+6046  U+92B3  uni92B3,  CJK UNIFIED IDEOGRAPH-92B3
        0x9713, # G+6047  U+9713  uni9713,  CJK UNIFIED IDEOGRAPH-9713
        0x9810, # G+6048  U+9810  uni9810,  CJK UNIFIED IDEOGRAPH-9810
        0x4E94, # G+6049  U+4E94  uni4E94,  CJK UNIFIED IDEOGRAPH-4E94
        0x4F0D, # G+6050  U+4F0D  uni4F0D,  CJK UNIFIED IDEOGRAPH-4F0D
        0x4FC9, # G+6051  U+4FC9  uni4FC9,  CJK UNIFIED IDEOGRAPH-4FC9
        0x50B2, # G+6052  U+50B2  uni50B2,  CJK UNIFIED IDEOGRAPH-50B2
        0x5348, # G+6053  U+5348  uni5348,  CJK UNIFIED IDEOGRAPH-5348
        0x543E, # G+6054  U+543E  uni543E,  CJK UNIFIED IDEOGRAPH-543E
        0x5433, # G+6055  U+5433  uni5433,  CJK UNIFIED IDEOGRAPH-5433
        0x55DA, # G+6056  U+55DA  uni55DA,  CJK UNIFIED IDEOGRAPH-55DA
        0x5862, # G+6057  U+5862  uni5862,  CJK UNIFIED IDEOGRAPH-5862
        0x58BA, # G+6058  U+58BA  uni58BA,  CJK UNIFIED IDEOGRAPH-58BA
        0x5967, # G+6059  U+5967  uni5967,  CJK UNIFIED IDEOGRAPH-5967
        0x5A1B, # G+6060  U+5A1B  uni5A1B,  CJK UNIFIED IDEOGRAPH-5A1B
        0x5BE4, # G+6061  U+5BE4  uni5BE4,  CJK UNIFIED IDEOGRAPH-5BE4
        0x609F, # G+6062  U+609F  uni609F,  CJK UNIFIED IDEOGRAPH-609F
        0x61CA, # G+6063  U+61CA  uni61CA,  CJK UNIFIED IDEOGRAPH-61CA
        0x6556, # G+6064  U+6556  uni6556,  CJK UNIFIED IDEOGRAPH-6556
        0x65FF, # G+6065  U+65FF  uni65FF,  CJK UNIFIED IDEOGRAPH-65FF
        0x6664, # G+6066  U+6664  uni6664,  CJK UNIFIED IDEOGRAPH-6664
        0x68A7, # G+6067  U+68A7  uni68A7,  CJK UNIFIED IDEOGRAPH-68A7
        0x6C5A, # G+6068  U+6C5A  uni6C5A,  CJK UNIFIED IDEOGRAPH-6C5A
        0x6FB3, # G+6069  U+6FB3  uni6FB3,  CJK UNIFIED IDEOGRAPH-6FB3
        0x70CF, # G+6070  U+70CF  uni70CF,  CJK UNIFIED IDEOGRAPH-70CF
        0x71AC, # G+6071  U+71AC  uni71AC,  CJK UNIFIED IDEOGRAPH-71AC
        0x7352, # G+6072  U+7352  uni7352,  CJK UNIFIED IDEOGRAPH-7352
        0x7B7D, # G+6073  U+7B7D  uni7B7D,  CJK UNIFIED IDEOGRAPH-7B7D
        0x8708, # G+6074  U+8708  uni8708,  CJK UNIFIED IDEOGRAPH-8708
        0x8AA4, # G+6075  U+8AA4  uni8AA4,  CJK UNIFIED IDEOGRAPH-8AA4
        0x9C32, # G+6076  U+9C32  uni9C32,  CJK UNIFIED IDEOGRAPH-9C32
        0x9F07, # G+6077  U+9F07  uni9F07,  CJK UNIFIED IDEOGRAPH-9F07
        0x5C4B, # G+6078  U+5C4B  uni5C4B,  CJK UNIFIED IDEOGRAPH-5C4B
        0x6C83, # G+6079  U+6C83  uni6C83,  CJK UNIFIED IDEOGRAPH-6C83
        0x7344, # G+6080  U+7344  uni7344,  CJK UNIFIED IDEOGRAPH-7344
        0x2F5F, # G+6081  U+2F5F  uni2F5F,  KANGXI RADICAL JADE
        0x923A, # G+6082  U+923A  uni923A,  CJK UNIFIED IDEOGRAPH-923A
        0x6EAB, # G+6083  U+6EAB  uni6EAB,  CJK UNIFIED IDEOGRAPH-6EAB
        0x7465, # G+6084  U+7465  uni7465,  CJK UNIFIED IDEOGRAPH-7465
        0x761F, # G+6085  U+761F  uni761F,  CJK UNIFIED IDEOGRAPH-761F
        0x7A69, # G+6086  U+7A69  uni7A69,  CJK UNIFIED IDEOGRAPH-7A69
        0x7E15, # G+6087  U+7E15  uni7E15,  CJK UNIFIED IDEOGRAPH-7E15
        0x860A, # G+6088  U+860A  uni860A,  CJK UNIFIED IDEOGRAPH-860A
        0x5140, # G+6089  U+5140  uni5140,  CJK UNIFIED IDEOGRAPH-5140
        0x58C5, # G+6090  U+58C5  uni58C5,  CJK UNIFIED IDEOGRAPH-58C5
        0x64C1, # G+6091  U+64C1  uni64C1,  CJK UNIFIED IDEOGRAPH-64C1
        0x74EE, # G+6092  U+74EE  uni74EE,  CJK UNIFIED IDEOGRAPH-74EE
        0x7515, # G+6093  U+7515  uni7515,  CJK UNIFIED IDEOGRAPH-7515
        0x7670, # G+6094  U+7670  uni7670,  CJK UNIFIED IDEOGRAPH-7670
        0x7FC1, # G+6095  U+7FC1  uni7FC1,  CJK UNIFIED IDEOGRAPH-7FC1
        0x9095, # G+6096  U+9095  uni9095,  CJK UNIFIED IDEOGRAPH-9095
        0x96CD, # G+6097  U+96CD  uni96CD,  CJK UNIFIED IDEOGRAPH-96CD
        0x9954, # G+6098  U+9954  uni9954,  CJK UNIFIED IDEOGRAPH-9954
        0x6E26, # G+6099  U+6E26  uni6E26,  CJK UNIFIED IDEOGRAPH-6E26
        0x2F61, # G+6100  U+2F61  uni2F61,  KANGXI RADICAL TILE
        0x7AA9, # G+6101  U+7AA9  uni7AA9,  CJK UNIFIED IDEOGRAPH-7AA9
        0x7AAA, # G+6102  U+7AAA  uni7AAA,  CJK UNIFIED IDEOGRAPH-7AAA
        0x81E5, # G+6103  U+81E5  uni81E5,  CJK UNIFIED IDEOGRAPH-81E5
        0x86D9, # G+6104  U+86D9  uni86D9,  CJK UNIFIED IDEOGRAPH-86D9
        0x8778, # G+6105  U+8778  uni8778,  CJK UNIFIED IDEOGRAPH-8778
        0x8A1B, # G+6106  U+8A1B  uni8A1B,  CJK UNIFIED IDEOGRAPH-8A1B
        0x5A49, # G+6107  U+5A49  uni5A49,  CJK UNIFIED IDEOGRAPH-5A49
        0x5B8C, # G+6108  U+5B8C  uni5B8C,  CJK UNIFIED IDEOGRAPH-5B8C
        0x5B9B, # G+6109  U+5B9B  uni5B9B,  CJK UNIFIED IDEOGRAPH-5B9B
        0x68A1, # G+6110  U+68A1  uni68A1,  CJK UNIFIED IDEOGRAPH-68A1
        0x6900, # G+6111  U+6900  uni6900,  CJK UNIFIED IDEOGRAPH-6900
        0x6D63, # G+6112  U+6D63  uni6D63,  CJK UNIFIED IDEOGRAPH-6D63
        0x73A9, # G+6113  U+73A9  uni73A9,  CJK UNIFIED IDEOGRAPH-73A9
        0x7413, # G+6114  U+7413  uni7413,  CJK UNIFIED IDEOGRAPH-7413
        0x742C, # G+6115  U+742C  uni742C,  CJK UNIFIED IDEOGRAPH-742C
        0x7897, # G+6116  U+7897  uni7897,  CJK UNIFIED IDEOGRAPH-7897
        0x7DE9, # G+6117  U+7DE9  uni7DE9,  CJK UNIFIED IDEOGRAPH-7DE9
        0x7FEB, # G+6118  U+7FEB  uni7FEB,  CJK UNIFIED IDEOGRAPH-7FEB
        0x8118, # G+6119  U+8118  uni8118,  CJK UNIFIED IDEOGRAPH-8118
        0x8155, # G+6120  U+8155  uni8155,  CJK UNIFIED IDEOGRAPH-8155
        0x839E, # G+6121  U+839E  uni839E,  CJK UNIFIED IDEOGRAPH-839E
        0x8C4C, # G+6122  U+8C4C  uni8C4C,  CJK UNIFIED IDEOGRAPH-8C4C
        0x962E, # G+6123  U+962E  uni962E,  CJK UNIFIED IDEOGRAPH-962E
        0x9811, # G+6124  U+9811  uni9811,  CJK UNIFIED IDEOGRAPH-9811
        0x2F48, # G+6125  U+2F48  uni2F48,  KANGXI RADICAL SAY
        0x5F80, # G+6126  U+5F80  uni5F80,  CJK UNIFIED IDEOGRAPH-5F80
        0x65FA, # G+6127  U+65FA  uni65FA,  CJK UNIFIED IDEOGRAPH-65FA
        0x6789, # G+6128  U+6789  uni6789,  CJK UNIFIED IDEOGRAPH-6789
        0x6C6A, # G+6129  U+6C6A  uni6C6A,  CJK UNIFIED IDEOGRAPH-6C6A
        0x738B, # G+6130  U+738B  uni738B,  CJK UNIFIED IDEOGRAPH-738B
        0x502D, # G+6131  U+502D  uni502D,  CJK UNIFIED IDEOGRAPH-502D
        0x5A03, # G+6132  U+5A03  uni5A03,  CJK UNIFIED IDEOGRAPH-5A03
        0x6B6A, # G+6133  U+6B6A  uni6B6A,  CJK UNIFIED IDEOGRAPH-6B6A
        0x77EE, # G+6134  U+77EE  uni77EE,  CJK UNIFIED IDEOGRAPH-77EE
        0x5916, # G+6135  U+5916  uni5916,  CJK UNIFIED IDEOGRAPH-5916
        0x5D6C, # G+6136  U+5D6C  uni5D6C,  CJK UNIFIED IDEOGRAPH-5D6C
        0x5DCD, # G+6137  U+5DCD  uni5DCD,  CJK UNIFIED IDEOGRAPH-5DCD
        0x7325, # G+6138  U+7325  uni7325,  CJK UNIFIED IDEOGRAPH-7325
        0x754F, # G+6139  U+754F  uni754F,  CJK UNIFIED IDEOGRAPH-754F
        0x50E5, # G+6140  U+50E5  uni50E5,  CJK UNIFIED IDEOGRAPH-50E5
        0x51F9, # G+6141  U+51F9  uni51F9,  CJK UNIFIED IDEOGRAPH-51F9
        0x582F, # G+6142  U+582F  uni582F,  CJK UNIFIED IDEOGRAPH-582F
        0x592D, # G+6143  U+592D  uni592D,  CJK UNIFIED IDEOGRAPH-592D
        0x5996, # G+6144  U+5996  uni5996,  CJK UNIFIED IDEOGRAPH-5996
        0x59DA, # G+6145  U+59DA  uni59DA,  CJK UNIFIED IDEOGRAPH-59DA
        0x5BE5, # G+6146  U+5BE5  uni5BE5,  CJK UNIFIED IDEOGRAPH-5BE5
        0x5DA2, # G+6147  U+5DA2  uni5DA2,  CJK UNIFIED IDEOGRAPH-5DA2
        0x62D7, # G+6148  U+62D7  uni62D7,  CJK UNIFIED IDEOGRAPH-62D7
        0x6416, # G+6149  U+6416  uni6416,  CJK UNIFIED IDEOGRAPH-6416
        0x6493, # G+6150  U+6493  uni6493,  CJK UNIFIED IDEOGRAPH-6493
        0x64FE, # G+6151  U+64FE  uni64FE,  CJK UNIFIED IDEOGRAPH-64FE
        0x66DC, # G+6152  U+66DC  uni66DC,  CJK UNIFIED IDEOGRAPH-66DC
        0x6A48, # G+6153  U+6A48  uni6A48,  CJK UNIFIED IDEOGRAPH-6A48
        0x71FF, # G+6154  U+71FF  uni71FF,  CJK UNIFIED IDEOGRAPH-71FF
        0x7464, # G+6155  U+7464  uni7464,  CJK UNIFIED IDEOGRAPH-7464
        0x7A88, # G+6156  U+7A88  uni7A88,  CJK UNIFIED IDEOGRAPH-7A88
        0x7AAF, # G+6157  U+7AAF  uni7AAF,  CJK UNIFIED IDEOGRAPH-7AAF
        0x7E47, # G+6158  U+7E47  uni7E47,  CJK UNIFIED IDEOGRAPH-7E47
        0x7E5E, # G+6159  U+7E5E  uni7E5E,  CJK UNIFIED IDEOGRAPH-7E5E
        0x8000, # G+6160  U+8000  uni8000,  CJK UNIFIED IDEOGRAPH-8000
        0x8170, # G+6161  U+8170  uni8170,  CJK UNIFIED IDEOGRAPH-8170
        0x87EF, # G+6162  U+87EF  uni87EF,  CJK UNIFIED IDEOGRAPH-87EF
        0x8981, # G+6163  U+8981  uni8981,  CJK UNIFIED IDEOGRAPH-8981
        0x8B20, # G+6164  U+8B20  uni8B20,  CJK UNIFIED IDEOGRAPH-8B20
        0x9059, # G+6165  U+9059  uni9059,  CJK UNIFIED IDEOGRAPH-9059
        0x9080, # G+6166  U+9080  uni9080,  CJK UNIFIED IDEOGRAPH-9080
        0x9952, # G+6167  U+9952  uni9952,  CJK UNIFIED IDEOGRAPH-9952
        0x617E, # G+6168  U+617E  uni617E,  CJK UNIFIED IDEOGRAPH-617E
        0x6B32, # G+6169  U+6B32  uni6B32,  CJK UNIFIED IDEOGRAPH-6B32
        0x6D74, # G+6170  U+6D74  uni6D74,  CJK UNIFIED IDEOGRAPH-6D74
        0x7E1F, # G+6171  U+7E1F  uni7E1F,  CJK UNIFIED IDEOGRAPH-7E1F
        0x8925, # G+6172  U+8925  uni8925,  CJK UNIFIED IDEOGRAPH-8925
        0x8FB1, # G+6173  U+8FB1  uni8FB1,  CJK UNIFIED IDEOGRAPH-8FB1
        0x4FD1, # G+6174  U+4FD1  uni4FD1,  CJK UNIFIED IDEOGRAPH-4FD1
        0x50AD, # G+6175  U+50AD  uni50AD,  CJK UNIFIED IDEOGRAPH-50AD
        0x5197, # G+6176  U+5197  uni5197,  CJK UNIFIED IDEOGRAPH-5197
        0x52C7, # G+6177  U+52C7  uni52C7,  CJK UNIFIED IDEOGRAPH-52C7
        0x57C7, # G+6178  U+57C7  uni57C7,  CJK UNIFIED IDEOGRAPH-57C7
        0x5889, # G+6179  U+5889  uni5889,  CJK UNIFIED IDEOGRAPH-5889
        0x5BB9, # G+6180  U+5BB9  uni5BB9,  CJK UNIFIED IDEOGRAPH-5BB9
        0x5EB8, # G+6181  U+5EB8  uni5EB8,  CJK UNIFIED IDEOGRAPH-5EB8
        0x6142, # G+6182  U+6142  uni6142,  CJK UNIFIED IDEOGRAPH-6142
        0x6995, # G+6183  U+6995  uni6995,  CJK UNIFIED IDEOGRAPH-6995
        0x6D8C, # G+6184  U+6D8C  uni6D8C,  CJK UNIFIED IDEOGRAPH-6D8C
        0x6E67, # G+6185  U+6E67  uni6E67,  CJK UNIFIED IDEOGRAPH-6E67
        0x6EB6, # G+6186  U+6EB6  uni6EB6,  CJK UNIFIED IDEOGRAPH-6EB6
        0x7194, # G+6187  U+7194  uni7194,  CJK UNIFIED IDEOGRAPH-7194
        0x7462, # G+6188  U+7462  uni7462,  CJK UNIFIED IDEOGRAPH-7462
        0x2F64, # G+6189  U+2F64  uni2F64,  KANGXI RADICAL USE
        0x752C, # G+6190  U+752C  uni752C,  CJK UNIFIED IDEOGRAPH-752C
        0x8073, # G+6191  U+8073  uni8073,  CJK UNIFIED IDEOGRAPH-8073
        0x8338, # G+6192  U+8338  uni8338,  CJK UNIFIED IDEOGRAPH-8338
        0x84C9, # G+6193  U+84C9  uni84C9,  CJK UNIFIED IDEOGRAPH-84C9
        0x8E0A, # G+6194  U+8E0A  uni8E0A,  CJK UNIFIED IDEOGRAPH-8E0A
        0x9394, # G+6195  U+9394  uni9394,  CJK UNIFIED IDEOGRAPH-9394
        0x93DE, # G+6196  U+93DE  uni93DE,  CJK UNIFIED IDEOGRAPH-93DE
        0x4E8E, # G+6197  U+4E8E  uni4E8E,  CJK UNIFIED IDEOGRAPH-4E8E
        0x4F51, # G+6198  U+4F51  uni4F51,  CJK UNIFIED IDEOGRAPH-4F51
        0x5076, # G+6199  U+5076  uni5076,  CJK UNIFIED IDEOGRAPH-5076
        0x512A, # G+6200  U+512A  uni512A,  CJK UNIFIED IDEOGRAPH-512A
        0x2F1C, # G+6201  U+2F1C  uni2F1C,  KANGXI RADICAL AGAIN
        0x53CB, # G+6202  U+53CB  uni53CB,  CJK UNIFIED IDEOGRAPH-53CB
        0x53F3, # G+6203  U+53F3  uni53F3,  CJK UNIFIED IDEOGRAPH-53F3
        0x5B87, # G+6204  U+5B87  uni5B87,  CJK UNIFIED IDEOGRAPH-5B87
        0x5BD3, # G+6205  U+5BD3  uni5BD3,  CJK UNIFIED IDEOGRAPH-5BD3
        0x5C24, # G+6206  U+5C24  uni5C24,  CJK UNIFIED IDEOGRAPH-5C24
        0x611A, # G+6207  U+611A  uni611A,  CJK UNIFIED IDEOGRAPH-611A
        0x6182, # G+6208  U+6182  uni6182,  CJK UNIFIED IDEOGRAPH-6182
        0x65F4, # G+6209  U+65F4  uni65F4,  CJK UNIFIED IDEOGRAPH-65F4
        0x2F5C, # G+6210  U+2F5C  uni2F5C,  KANGXI RADICAL COW
        0x7397, # G+6211  U+7397  uni7397,  CJK UNIFIED IDEOGRAPH-7397
        0x7440, # G+6212  U+7440  uni7440,  CJK UNIFIED IDEOGRAPH-7440
        0x76C2, # G+6213  U+76C2  uni76C2,  CJK UNIFIED IDEOGRAPH-76C2
        0x7950, # G+6214  U+7950  uni7950,  CJK UNIFIED IDEOGRAPH-7950
        0x7991, # G+6215  U+7991  uni7991,  CJK UNIFIED IDEOGRAPH-7991
        0x79B9, # G+6216  U+79B9  uni79B9,  CJK UNIFIED IDEOGRAPH-79B9
        0x7D06, # G+6217  U+7D06  uni7D06,  CJK UNIFIED IDEOGRAPH-7D06
        0x2F7B, # G+6218  U+2F7B  uni2F7B,  KANGXI RADICAL FEATHER
        0x828B, # G+6219  U+828B  uni828B,  CJK UNIFIED IDEOGRAPH-828B
        0x85D5, # G+6220  U+85D5  uni85D5,  CJK UNIFIED IDEOGRAPH-85D5
        0x865E, # G+6221  U+865E  uni865E,  CJK UNIFIED IDEOGRAPH-865E
        0x8FC2, # G+6222  U+8FC2  uni8FC2,  CJK UNIFIED IDEOGRAPH-8FC2
        0x9047, # G+6223  U+9047  uni9047,  CJK UNIFIED IDEOGRAPH-9047
        0x90F5, # G+6224  U+90F5  uni90F5,  CJK UNIFIED IDEOGRAPH-90F5
        0x91EA, # G+6225  U+91EA  uni91EA,  CJK UNIFIED IDEOGRAPH-91EA
        0x9685, # G+6226  U+9685  uni9685,  CJK UNIFIED IDEOGRAPH-9685
        0x2FAC, # G+6227  U+2FAC  uni2FAC,  KANGXI RADICAL RAIN
        0x96E9, # G+6228  U+96E9  uni96E9,  CJK UNIFIED IDEOGRAPH-96E9
        0x52D6, # G+6229  U+52D6  uni52D6,  CJK UNIFIED IDEOGRAPH-52D6
        0x5F67, # G+6230  U+5F67  uni5F67,  CJK UNIFIED IDEOGRAPH-5F67
        0x65ED, # G+6231  U+65ED  uni65ED,  CJK UNIFIED IDEOGRAPH-65ED
        0x6631, # G+6232  U+6631  uni6631,  CJK UNIFIED IDEOGRAPH-6631
        0x682F, # G+6233  U+682F  uni682F,  CJK UNIFIED IDEOGRAPH-682F
        0x715C, # G+6234  U+715C  uni715C,  CJK UNIFIED IDEOGRAPH-715C
        0x7A36, # G+6235  U+7A36  uni7A36,  CJK UNIFIED IDEOGRAPH-7A36
        0x90C1, # G+6236  U+90C1  uni90C1,  CJK UNIFIED IDEOGRAPH-90C1
        0x980A, # G+6237  U+980A  uni980A,  CJK UNIFIED IDEOGRAPH-980A
        0x4E91, # G+6238  U+4E91  uni4E91,  CJK UNIFIED IDEOGRAPH-4E91
        0x6A52, # G+6239  U+6A52  uni6A52,  CJK UNIFIED IDEOGRAPH-6A52
        0x6B9E, # G+6240  U+6B9E  uni6B9E,  CJK UNIFIED IDEOGRAPH-6B9E
        0x6F90, # G+6241  U+6F90  uni6F90,  CJK UNIFIED IDEOGRAPH-6F90
        0x7189, # G+6242  U+7189  uni7189,  CJK UNIFIED IDEOGRAPH-7189
        0x8018, # G+6243  U+8018  uni8018,  CJK UNIFIED IDEOGRAPH-8018
        0x82B8, # G+6244  U+82B8  uni82B8,  CJK UNIFIED IDEOGRAPH-82B8
        0x8553, # G+6245  U+8553  uni8553,  CJK UNIFIED IDEOGRAPH-8553
        0x904B, # G+6246  U+904B  uni904B,  CJK UNIFIED IDEOGRAPH-904B
        0x9695, # G+6247  U+9695  uni9695,  CJK UNIFIED IDEOGRAPH-9695
        0x96F2, # G+6248  U+96F2  uni96F2,  CJK UNIFIED IDEOGRAPH-96F2
        0x97FB, # G+6249  U+97FB  uni97FB,  CJK UNIFIED IDEOGRAPH-97FB
        0x851A, # G+6250  U+851A  uni851A,  CJK UNIFIED IDEOGRAPH-851A
        0x9B31, # G+6251  U+9B31  uni9B31,  CJK UNIFIED IDEOGRAPH-9B31
        0x4E90, # G+6252  U+4E90  uni4E90,  CJK UNIFIED IDEOGRAPH-4E90
        0x718A, # G+6253  U+718A  uni718A,  CJK UNIFIED IDEOGRAPH-718A
        0x96C4, # G+6254  U+96C4  uni96C4,  CJK UNIFIED IDEOGRAPH-96C4
        0x5143, # G+6255  U+5143  uni5143,  CJK UNIFIED IDEOGRAPH-5143
        0x539F, # G+6256  U+539F  uni539F,  CJK UNIFIED IDEOGRAPH-539F
        0x54E1, # G+6257  U+54E1  uni54E1,  CJK UNIFIED IDEOGRAPH-54E1
        0x5713, # G+6258  U+5713  uni5713,  CJK UNIFIED IDEOGRAPH-5713
        0x5712, # G+6259  U+5712  uni5712,  CJK UNIFIED IDEOGRAPH-5712
        0x57A3, # G+6260  U+57A3  uni57A3,  CJK UNIFIED IDEOGRAPH-57A3
        0x5A9B, # G+6261  U+5A9B  uni5A9B,  CJK UNIFIED IDEOGRAPH-5A9B
        0x5AC4, # G+6262  U+5AC4  uni5AC4,  CJK UNIFIED IDEOGRAPH-5AC4
        0x5BC3, # G+6263  U+5BC3  uni5BC3,  CJK UNIFIED IDEOGRAPH-5BC3
        0x6028, # G+6264  U+6028  uni6028,  CJK UNIFIED IDEOGRAPH-6028
        0x613F, # G+6265  U+613F  uni613F,  CJK UNIFIED IDEOGRAPH-613F
        0x63F4, # G+6266  U+63F4  uni63F4,  CJK UNIFIED IDEOGRAPH-63F4
        0x6C85, # G+6267  U+6C85  uni6C85,  CJK UNIFIED IDEOGRAPH-6C85
        0x6D39, # G+6268  U+6D39  uni6D39,  CJK UNIFIED IDEOGRAPH-6D39
        0x6E72, # G+6269  U+6E72  uni6E72,  CJK UNIFIED IDEOGRAPH-6E72
        0x6E90, # G+6270  U+6E90  uni6E90,  CJK UNIFIED IDEOGRAPH-6E90
        0x7230, # G+6271  U+7230  uni7230,  CJK UNIFIED IDEOGRAPH-7230
        0x733F, # G+6272  U+733F  uni733F,  CJK UNIFIED IDEOGRAPH-733F
        0x7457, # G+6273  U+7457  uni7457,  CJK UNIFIED IDEOGRAPH-7457
        0x82D1, # G+6274  U+82D1  uni82D1,  CJK UNIFIED IDEOGRAPH-82D1
        0x8881, # G+6275  U+8881  uni8881,  CJK UNIFIED IDEOGRAPH-8881
        0x8F45, # G+6276  U+8F45  uni8F45,  CJK UNIFIED IDEOGRAPH-8F45
        0x9060, # G+6277  U+9060  uni9060,  CJK UNIFIED IDEOGRAPH-9060
        0x9662, # G+6278  U+9662  uni9662,  CJK UNIFIED IDEOGRAPH-9662
        0x9858, # G+6279  U+9858  uni9858,  CJK UNIFIED IDEOGRAPH-9858
        0x9D1B, # G+6280  U+9D1B  uni9D1B,  CJK UNIFIED IDEOGRAPH-9D1B
        0x2F49, # G+6281  U+2F49  uni2F49,  KANGXI RADICAL MOON
        0x8D8A, # G+6282  U+8D8A  uni8D8A,  CJK UNIFIED IDEOGRAPH-8D8A
        0x925E, # G+6283  U+925E  uni925E,  CJK UNIFIED IDEOGRAPH-925E
        0x4F4D, # G+6284  U+4F4D  uni4F4D,  CJK UNIFIED IDEOGRAPH-4F4D
        0x5049, # G+6285  U+5049  uni5049,  CJK UNIFIED IDEOGRAPH-5049
        0x50DE, # G+6286  U+50DE  uni50DE,  CJK UNIFIED IDEOGRAPH-50DE
        0x5371, # G+6287  U+5371  uni5371,  CJK UNIFIED IDEOGRAPH-5371
        0x570D, # G+6288  U+570D  uni570D,  CJK UNIFIED IDEOGRAPH-570D
        0x59D4, # G+6289  U+59D4  uni59D4,  CJK UNIFIED IDEOGRAPH-59D4
        0x5A01, # G+6290  U+5A01  uni5A01,  CJK UNIFIED IDEOGRAPH-5A01
        0x5C09, # G+6291  U+5C09  uni5C09,  CJK UNIFIED IDEOGRAPH-5C09
        0x6170, # G+6292  U+6170  uni6170,  CJK UNIFIED IDEOGRAPH-6170
        0x6690, # G+6293  U+6690  uni6690,  CJK UNIFIED IDEOGRAPH-6690
        0x6E2D, # G+6294  U+6E2D  uni6E2D,  CJK UNIFIED IDEOGRAPH-6E2D
        0x7232, # G+6295  U+7232  uni7232,  CJK UNIFIED IDEOGRAPH-7232
        0x744B, # G+6296  U+744B  uni744B,  CJK UNIFIED IDEOGRAPH-744B
        0x7DEF, # G+6297  U+7DEF  uni7DEF,  CJK UNIFIED IDEOGRAPH-7DEF
        0x80C3, # G+6298  U+80C3  uni80C3,  CJK UNIFIED IDEOGRAPH-80C3
        0x840E, # G+6299  U+840E  uni840E,  CJK UNIFIED IDEOGRAPH-840E
        0x8466, # G+6300  U+8466  uni8466,  CJK UNIFIED IDEOGRAPH-8466
        0x853F, # G+6301  U+853F  uni853F,  CJK UNIFIED IDEOGRAPH-853F
        0x875F, # G+6302  U+875F  uni875F,  CJK UNIFIED IDEOGRAPH-875F
        0x885B, # G+6303  U+885B  uni885B,  CJK UNIFIED IDEOGRAPH-885B
        0x8918, # G+6304  U+8918  uni8918,  CJK UNIFIED IDEOGRAPH-8918
        0x8B02, # G+6305  U+8B02  uni8B02,  CJK UNIFIED IDEOGRAPH-8B02
        0x9055, # G+6306  U+9055  uni9055,  CJK UNIFIED IDEOGRAPH-9055
        0x2FB1, # G+6307  U+2FB1  uni2FB1,  KANGXI RADICAL TANNED LEATHER
        0x9B4F, # G+6308  U+9B4F  uni9B4F,  CJK UNIFIED IDEOGRAPH-9B4F
        0x4E73, # G+6309  U+4E73  uni4E73,  CJK UNIFIED IDEOGRAPH-4E73
        0x4F91, # G+6310  U+4F91  uni4F91,  CJK UNIFIED IDEOGRAPH-4F91
        0x5112, # G+6311  U+5112  uni5112,  CJK UNIFIED IDEOGRAPH-5112
        0x516A, # G+6312  U+516A  uni516A,  CJK UNIFIED IDEOGRAPH-516A
        0x552F, # G+6313  U+552F  uni552F,  CJK UNIFIED IDEOGRAPH-552F
        0x55A9, # G+6314  U+55A9  uni55A9,  CJK UNIFIED IDEOGRAPH-55A9
        0x5B7A, # G+6315  U+5B7A  uni5B7A,  CJK UNIFIED IDEOGRAPH-5B7A
        0x5BA5, # G+6316  U+5BA5  uni5BA5,  CJK UNIFIED IDEOGRAPH-5BA5
        0x5E7C, # G+6317  U+5E7C  uni5E7C,  CJK UNIFIED IDEOGRAPH-5E7C
        0x5E7D, # G+6318  U+5E7D  uni5E7D,  CJK UNIFIED IDEOGRAPH-5E7D
        0x5EBE, # G+6319  U+5EBE  uni5EBE,  CJK UNIFIED IDEOGRAPH-5EBE
        0x60A0, # G+6320  U+60A0  uni60A0,  CJK UNIFIED IDEOGRAPH-60A0
        0x60DF, # G+6321  U+60DF  uni60DF,  CJK UNIFIED IDEOGRAPH-60DF
        0x6108, # G+6322  U+6108  uni6108,  CJK UNIFIED IDEOGRAPH-6108
        0x6109, # G+6323  U+6109  uni6109,  CJK UNIFIED IDEOGRAPH-6109
        0x63C4, # G+6324  U+63C4  uni63C4,  CJK UNIFIED IDEOGRAPH-63C4
        0x6538, # G+6325  U+6538  uni6538,  CJK UNIFIED IDEOGRAPH-6538
        0x6709, # G+6326  U+6709  uni6709,  CJK UNIFIED IDEOGRAPH-6709
        0x67D4, # G+6327  U+67D4  uni67D4,  CJK UNIFIED IDEOGRAPH-67D4
        0x67DA, # G+6328  U+67DA  uni67DA,  CJK UNIFIED IDEOGRAPH-67DA
        0x6961, # G+6329  U+6961  uni6961,  CJK UNIFIED IDEOGRAPH-6961
        0x6962, # G+6330  U+6962  uni6962,  CJK UNIFIED IDEOGRAPH-6962
        0x6CB9, # G+6331  U+6CB9  uni6CB9,  CJK UNIFIED IDEOGRAPH-6CB9
        0x6D27, # G+6332  U+6D27  uni6D27,  CJK UNIFIED IDEOGRAPH-6D27
        0x6E38, # G+6333  U+6E38  uni6E38,  CJK UNIFIED IDEOGRAPH-6E38
        0x6FE1, # G+6334  U+6FE1  uni6FE1,  CJK UNIFIED IDEOGRAPH-6FE1
        0x7336, # G+6335  U+7336  uni7336,  CJK UNIFIED IDEOGRAPH-7336
        0x7337, # G+6336  U+7337  uni7337,  CJK UNIFIED IDEOGRAPH-7337
        0x745C, # G+6337  U+745C  uni745C,  CJK UNIFIED IDEOGRAPH-745C
        0x7531, # G+6338  U+7531  uni7531,  CJK UNIFIED IDEOGRAPH-7531
        0x7652, # G+6339  U+7652  uni7652,  CJK UNIFIED IDEOGRAPH-7652
        0x7DAD, # G+6340  U+7DAD  uni7DAD,  CJK UNIFIED IDEOGRAPH-7DAD
        0x81FE, # G+6341  U+81FE  uni81FE,  CJK UNIFIED IDEOGRAPH-81FE
        0x8438, # G+6342  U+8438  uni8438,  CJK UNIFIED IDEOGRAPH-8438
        0x88D5, # G+6343  U+88D5  uni88D5,  CJK UNIFIED IDEOGRAPH-88D5
        0x8A98, # G+6344  U+8A98  uni8A98,  CJK UNIFIED IDEOGRAPH-8A98
        0x8ADB, # G+6345  U+8ADB  uni8ADB,  CJK UNIFIED IDEOGRAPH-8ADB
        0x8AED, # G+6346  U+8AED  uni8AED,  CJK UNIFIED IDEOGRAPH-8AED
        0x8E30, # G+6347  U+8E30  uni8E30,  CJK UNIFIED IDEOGRAPH-8E30
        0x8E42, # G+6348  U+8E42  uni8E42,  CJK UNIFIED IDEOGRAPH-8E42
        0x904A, # G+6349  U+904A  uni904A,  CJK UNIFIED IDEOGRAPH-904A
        0x903E, # G+6350  U+903E  uni903E,  CJK UNIFIED IDEOGRAPH-903E
        0x907A, # G+6351  U+907A  uni907A,  CJK UNIFIED IDEOGRAPH-907A
        0x2FA3, # G+6352  U+2FA3  uni2FA3,  KANGXI RADICAL WINE
        0x91C9, # G+6353  U+91C9  uni91C9,  CJK UNIFIED IDEOGRAPH-91C9
        0x936E, # G+6354  U+936E  uni936E,  CJK UNIFIED IDEOGRAPH-936E
        0x5809, # G+6355  U+5809  uni5809,  CJK UNIFIED IDEOGRAPH-5809
        0x6BD3, # G+6356  U+6BD3  uni6BD3,  CJK UNIFIED IDEOGRAPH-6BD3
        0x2F81, # G+6357  U+2F81  uni2F81,  KANGXI RADICAL MEAT
        0x80B2, # G+6358  U+80B2  uni80B2,  CJK UNIFIED IDEOGRAPH-80B2
        0x5141, # G+6359  U+5141  uni5141,  CJK UNIFIED IDEOGRAPH-5141
        0x596B, # G+6360  U+596B  uni596B,  CJK UNIFIED IDEOGRAPH-596B
        0x5C39, # G+6361  U+5C39  uni5C39,  CJK UNIFIED IDEOGRAPH-5C39
        0x6F64, # G+6362  U+6F64  uni6F64,  CJK UNIFIED IDEOGRAPH-6F64
        0x73A7, # G+6363  U+73A7  uni73A7,  CJK UNIFIED IDEOGRAPH-73A7
        0x80E4, # G+6364  U+80E4  uni80E4,  CJK UNIFIED IDEOGRAPH-80E4
        0x8D07, # G+6365  U+8D07  uni8D07,  CJK UNIFIED IDEOGRAPH-8D07
        0x9217, # G+6366  U+9217  uni9217,  CJK UNIFIED IDEOGRAPH-9217
        0x958F, # G+6367  U+958F  uni958F,  CJK UNIFIED IDEOGRAPH-958F
        0x2F80, # G+6368  U+2F80  uni2F80,  KANGXI RADICAL BRUSH
        0x620E, # G+6369  U+620E  uni620E,  CJK UNIFIED IDEOGRAPH-620E
        0x701C, # G+6370  U+701C  uni701C,  CJK UNIFIED IDEOGRAPH-701C
        0x7D68, # G+6371  U+7D68  uni7D68,  CJK UNIFIED IDEOGRAPH-7D68
        0x878D, # G+6372  U+878D  uni878D,  CJK UNIFIED IDEOGRAPH-878D
        0x57A0, # G+6373  U+57A0  uni57A0,  CJK UNIFIED IDEOGRAPH-57A0
        0x6069, # G+6374  U+6069  uni6069,  CJK UNIFIED IDEOGRAPH-6069
        0x6147, # G+6375  U+6147  uni6147,  CJK UNIFIED IDEOGRAPH-6147
        0x6BB7, # G+6376  U+6BB7  uni6BB7,  CJK UNIFIED IDEOGRAPH-6BB7
        0x8ABE, # G+6377  U+8ABE  uni8ABE,  CJK UNIFIED IDEOGRAPH-8ABE
        0x9280, # G+6378  U+9280  uni9280,  CJK UNIFIED IDEOGRAPH-9280
        0x96B1, # G+6379  U+96B1  uni96B1,  CJK UNIFIED IDEOGRAPH-96B1
        0x2F04, # G+6380  U+2F04  uni2F04,  KANGXI RADICAL SECOND
        0x541F, # G+6381  U+541F  uni541F,  CJK UNIFIED IDEOGRAPH-541F
        0x6DEB, # G+6382  U+6DEB  uni6DEB,  CJK UNIFIED IDEOGRAPH-6DEB
        0x852D, # G+6383  U+852D  uni852D,  CJK UNIFIED IDEOGRAPH-852D
        0x9670, # G+6384  U+9670  uni9670,  CJK UNIFIED IDEOGRAPH-9670
        0x2FB3, # G+6385  U+2FB3  uni2FB3,  KANGXI RADICAL SOUND
        0x98EE, # G+6386  U+98EE  uni98EE,  CJK UNIFIED IDEOGRAPH-98EE
        0x63D6, # G+6387  U+63D6  uni63D6,  CJK UNIFIED IDEOGRAPH-63D6
        0x6CE3, # G+6388  U+6CE3  uni6CE3,  CJK UNIFIED IDEOGRAPH-6CE3
        0x2FA2, # G+6389  U+2FA2  uni2FA2,  KANGXI RADICAL CITY
        0x51DD, # G+6390  U+51DD  uni51DD,  CJK UNIFIED IDEOGRAPH-51DD
        0x61C9, # G+6391  U+61C9  uni61C9,  CJK UNIFIED IDEOGRAPH-61C9
        0x81BA, # G+6392  U+81BA  uni81BA,  CJK UNIFIED IDEOGRAPH-81BA
        0x9DF9, # G+6393  U+9DF9  uni9DF9,  CJK UNIFIED IDEOGRAPH-9DF9
        0x4F9D, # G+6394  U+4F9D  uni4F9D,  CJK UNIFIED IDEOGRAPH-4F9D
        0x501A, # G+6395  U+501A  uni501A,  CJK UNIFIED IDEOGRAPH-501A
        0x5100, # G+6396  U+5100  uni5100,  CJK UNIFIED IDEOGRAPH-5100
        0x5B9C, # G+6397  U+5B9C  uni5B9C,  CJK UNIFIED IDEOGRAPH-5B9C
        0x610F, # G+6398  U+610F  uni610F,  CJK UNIFIED IDEOGRAPH-610F
        0x61FF, # G+6399  U+61FF  uni61FF,  CJK UNIFIED IDEOGRAPH-61FF
        0x64EC, # G+6400  U+64EC  uni64EC,  CJK UNIFIED IDEOGRAPH-64EC
        0x6905, # G+6401  U+6905  uni6905,  CJK UNIFIED IDEOGRAPH-6905
        0x6BC5, # G+6402  U+6BC5  uni6BC5,  CJK UNIFIED IDEOGRAPH-6BC5
        0x7591, # G+6403  U+7591  uni7591,  CJK UNIFIED IDEOGRAPH-7591
        0x77E3, # G+6404  U+77E3  uni77E3,  CJK UNIFIED IDEOGRAPH-77E3
        0x7FA9, # G+6405  U+7FA9  uni7FA9,  CJK UNIFIED IDEOGRAPH-7FA9
        0x8264, # G+6406  U+8264  uni8264,  CJK UNIFIED IDEOGRAPH-8264
        0x858F, # G+6407  U+858F  uni858F,  CJK UNIFIED IDEOGRAPH-858F
        0x87FB, # G+6408  U+87FB  uni87FB,  CJK UNIFIED IDEOGRAPH-87FB
        0x2F90, # G+6409  U+2F90  uni2F90,  KANGXI RADICAL CLOTHES
        0x8ABC, # G+6410  U+8ABC  uni8ABC,  CJK UNIFIED IDEOGRAPH-8ABC
        0x8B70, # G+6411  U+8B70  uni8B70,  CJK UNIFIED IDEOGRAPH-8B70
        0x91AB, # G+6412  U+91AB  uni91AB,  CJK UNIFIED IDEOGRAPH-91AB
        0x2F06, # G+6413  U+2F06  uni2F06,  KANGXI RADICAL TWO
        0x4EE5, # G+6414  U+4EE5  uni4EE5,  CJK UNIFIED IDEOGRAPH-4EE5
        0x4F0A, # G+6415  U+4F0A  uni4F0A,  CJK UNIFIED IDEOGRAPH-4F0A
        0x5937, # G+6416  U+5937  uni5937,  CJK UNIFIED IDEOGRAPH-5937
        0x59E8, # G+6417  U+59E8  uni59E8,  CJK UNIFIED IDEOGRAPH-59E8
        0x5DF2, # G+6418  U+5DF2  uni5DF2,  CJK UNIFIED IDEOGRAPH-5DF2
        0x5F1B, # G+6419  U+5F1B  uni5F1B,  CJK UNIFIED IDEOGRAPH-5F1B
        0x5F5B, # G+6420  U+5F5B  uni5F5B,  CJK UNIFIED IDEOGRAPH-5F5B
        0x6021, # G+6421  U+6021  uni6021,  CJK UNIFIED IDEOGRAPH-6021
        0x723E, # G+6422  U+723E  uni723E,  CJK UNIFIED IDEOGRAPH-723E
        0x73E5, # G+6423  U+73E5  uni73E5,  CJK UNIFIED IDEOGRAPH-73E5
        0x7570, # G+6424  U+7570  uni7570,  CJK UNIFIED IDEOGRAPH-7570
        0x75CD, # G+6425  U+75CD  uni75CD,  CJK UNIFIED IDEOGRAPH-75CD
        0x79FB, # G+6426  U+79FB  uni79FB,  CJK UNIFIED IDEOGRAPH-79FB
        0x2F7D, # G+6427  U+2F7D  uni2F7D,  KANGXI RADICAL AND
        0x2F7F, # G+6428  U+2F7F  uni2F7F,  KANGXI RADICAL EAR
        0x8084, # G+6429  U+8084  uni8084,  CJK UNIFIED IDEOGRAPH-8084
        0x82E1, # G+6430  U+82E1  uni82E1,  CJK UNIFIED IDEOGRAPH-82E1
        0x8351, # G+6431  U+8351  uni8351,  CJK UNIFIED IDEOGRAPH-8351
        0x8CBD, # G+6432  U+8CBD  uni8CBD,  CJK UNIFIED IDEOGRAPH-8CBD
        0x8CB3, # G+6433  U+8CB3  uni8CB3,  CJK UNIFIED IDEOGRAPH-8CB3
        0x9087, # G+6434  U+9087  uni9087,  CJK UNIFIED IDEOGRAPH-9087
        0x98F4, # G+6435  U+98F4  uni98F4,  CJK UNIFIED IDEOGRAPH-98F4
        0x990C, # G+6436  U+990C  uni990C,  CJK UNIFIED IDEOGRAPH-990C
        0x7037, # G+6437  U+7037  uni7037,  CJK UNIFIED IDEOGRAPH-7037
        0x76CA, # G+6438  U+76CA  uni76CA,  CJK UNIFIED IDEOGRAPH-76CA
        0x7FCA, # G+6439  U+7FCA  uni7FCA,  CJK UNIFIED IDEOGRAPH-7FCA
        0x7FCC, # G+6440  U+7FCC  uni7FCC,  CJK UNIFIED IDEOGRAPH-7FCC
        0x7FFC, # G+6441  U+7FFC  uni7FFC,  CJK UNIFIED IDEOGRAPH-7FFC
        0x8B1A, # G+6442  U+8B1A  uni8B1A,  CJK UNIFIED IDEOGRAPH-8B1A
        0x2F08, # G+6443  U+2F08  uni2F08,  KANGXI RADICAL MAN
        0x4EC1, # G+6444  U+4EC1  uni4EC1,  CJK UNIFIED IDEOGRAPH-4EC1
        0x5203, # G+6445  U+5203  uni5203,  CJK UNIFIED IDEOGRAPH-5203
        0x5370, # G+6446  U+5370  uni5370,  CJK UNIFIED IDEOGRAPH-5370
        0x54BD, # G+6447  U+54BD  uni54BD,  CJK UNIFIED IDEOGRAPH-54BD
        0x56E0, # G+6448  U+56E0  uni56E0,  CJK UNIFIED IDEOGRAPH-56E0
        0x59FB, # G+6449  U+59FB  uni59FB,  CJK UNIFIED IDEOGRAPH-59FB
        0x5BC5, # G+6450  U+5BC5  uni5BC5,  CJK UNIFIED IDEOGRAPH-5BC5
        0x5F15, # G+6451  U+5F15  uni5F15,  CJK UNIFIED IDEOGRAPH-5F15
        0x5FCD, # G+6452  U+5FCD  uni5FCD,  CJK UNIFIED IDEOGRAPH-5FCD
        0x6E6E, # G+6453  U+6E6E  uni6E6E,  CJK UNIFIED IDEOGRAPH-6E6E
        0x7D6A, # G+6454  U+7D6A  uni7D6A,  CJK UNIFIED IDEOGRAPH-7D6A
        0x8335, # G+6455  U+8335  uni8335,  CJK UNIFIED IDEOGRAPH-8335
        0x8693, # G+6456  U+8693  uni8693,  CJK UNIFIED IDEOGRAPH-8693
        0x8A8D, # G+6457  U+8A8D  uni8A8D,  CJK UNIFIED IDEOGRAPH-8A8D
        0x976D, # G+6458  U+976D  uni976D,  CJK UNIFIED IDEOGRAPH-976D
        0x9777, # G+6459  U+9777  uni9777,  CJK UNIFIED IDEOGRAPH-9777
        0x2F00, # G+6460  U+2F00  uni2F00,  KANGXI RADICAL ONE
        0x4F5A, # G+6461  U+4F5A  uni4F5A,  CJK UNIFIED IDEOGRAPH-4F5A
        0x4F7E, # G+6462  U+4F7E  uni4F7E,  CJK UNIFIED IDEOGRAPH-4F7E
        0x58F9, # G+6463  U+58F9  uni58F9,  CJK UNIFIED IDEOGRAPH-58F9
        0x2F47, # G+6464  U+2F47  uni2F47,  KANGXI RADICAL SUN
        0x6EA2, # G+6465  U+6EA2  uni6EA2,  CJK UNIFIED IDEOGRAPH-6EA2
        0x9038, # G+6466  U+9038  uni9038,  CJK UNIFIED IDEOGRAPH-9038
        0x93B0, # G+6467  U+93B0  uni93B0,  CJK UNIFIED IDEOGRAPH-93B0
        0x99B9, # G+6468  U+99B9  uni99B9,  CJK UNIFIED IDEOGRAPH-99B9
        0x4EFB, # G+6469  U+4EFB  uni4EFB,  CJK UNIFIED IDEOGRAPH-4EFB
        0x58EC, # G+6470  U+58EC  uni58EC,  CJK UNIFIED IDEOGRAPH-58EC
        0x598A, # G+6471  U+598A  uni598A,  CJK UNIFIED IDEOGRAPH-598A
        0x59D9, # G+6472  U+59D9  uni59D9,  CJK UNIFIED IDEOGRAPH-59D9
        0x6041, # G+6473  U+6041  uni6041,  CJK UNIFIED IDEOGRAPH-6041
        0x7A14, # G+6474  U+7A14  uni7A14,  CJK UNIFIED IDEOGRAPH-7A14
        0x834F, # G+6475  U+834F  uni834F,  CJK UNIFIED IDEOGRAPH-834F
        0x8CC3, # G+6476  U+8CC3  uni8CC3,  CJK UNIFIED IDEOGRAPH-8CC3
        0x2F0A, # G+6477  U+2F0A  uni2F0A,  KANGXI RADICAL ENTER
        0x5344, # G+6478  U+5344  uni5344,  CJK UNIFIED IDEOGRAPH-5344
        0x4ECD, # G+6479  U+4ECD  uni4ECD,  CJK UNIFIED IDEOGRAPH-4ECD
        0x5269, # G+6480  U+5269  uni5269,  CJK UNIFIED IDEOGRAPH-5269
        0x5B55, # G+6481  U+5B55  uni5B55,  CJK UNIFIED IDEOGRAPH-5B55
        0x82BF, # G+6482  U+82BF  uni82BF,  CJK UNIFIED IDEOGRAPH-82BF
        0x4ED4, # G+6483  U+4ED4  uni4ED4,  CJK UNIFIED IDEOGRAPH-4ED4
        0x523A, # G+6484  U+523A  uni523A,  CJK UNIFIED IDEOGRAPH-523A
        0x54A8, # G+6485  U+54A8  uni54A8,  CJK UNIFIED IDEOGRAPH-54A8
        0x59C9, # G+6486  U+59C9  uni59C9,  CJK UNIFIED IDEOGRAPH-59C9
        0x59FF, # G+6487  U+59FF  uni59FF,  CJK UNIFIED IDEOGRAPH-59FF
        0x2F26, # G+6488  U+2F26  uni2F26,  KANGXI RADICAL CHILD
        0x5B57, # G+6489  U+5B57  uni5B57,  CJK UNIFIED IDEOGRAPH-5B57
        0x5B5C, # G+6490  U+5B5C  uni5B5C,  CJK UNIFIED IDEOGRAPH-5B5C
        0x6063, # G+6491  U+6063  uni6063,  CJK UNIFIED IDEOGRAPH-6063
        0x6148, # G+6492  U+6148  uni6148,  CJK UNIFIED IDEOGRAPH-6148
        0x6ECB, # G+6493  U+6ECB  uni6ECB,  CJK UNIFIED IDEOGRAPH-6ECB
        0x7099, # G+6494  U+7099  uni7099,  CJK UNIFIED IDEOGRAPH-7099
        0x716E, # G+6495  U+716E  uni716E,  CJK UNIFIED IDEOGRAPH-716E
        0x7386, # G+6496  U+7386  uni7386,  CJK UNIFIED IDEOGRAPH-7386
        0x74F7, # G+6497  U+74F7  uni74F7,  CJK UNIFIED IDEOGRAPH-74F7
        0x75B5, # G+6498  U+75B5  uni75B5,  CJK UNIFIED IDEOGRAPH-75B5
        0x78C1, # G+6499  U+78C1  uni78C1,  CJK UNIFIED IDEOGRAPH-78C1
        0x7D2B, # G+6500  U+7D2B  uni7D2B,  CJK UNIFIED IDEOGRAPH-7D2B
        0x8005, # G+6501  U+8005  uni8005,  CJK UNIFIED IDEOGRAPH-8005
        0x2F83, # G+6502  U+2F83  uni2F83,  KANGXI RADICAL SELF
        0x8328, # G+6503  U+8328  uni8328,  CJK UNIFIED IDEOGRAPH-8328
        0x8517, # G+6504  U+8517  uni8517,  CJK UNIFIED IDEOGRAPH-8517
        0x85C9, # G+6505  U+85C9  uni85C9,  CJK UNIFIED IDEOGRAPH-85C9
        0x8AEE, # G+6506  U+8AEE  uni8AEE,  CJK UNIFIED IDEOGRAPH-8AEE
        0x8CC7, # G+6507  U+8CC7  uni8CC7,  CJK UNIFIED IDEOGRAPH-8CC7
        0x96CC, # G+6508  U+96CC  uni96CC,  CJK UNIFIED IDEOGRAPH-96CC
        0x4F5C, # G+6509  U+4F5C  uni4F5C,  CJK UNIFIED IDEOGRAPH-4F5C
        0x52FA, # G+6510  U+52FA  uni52FA,  CJK UNIFIED IDEOGRAPH-52FA
        0x56BC, # G+6511  U+56BC  uni56BC,  CJK UNIFIED IDEOGRAPH-56BC
        0x65AB, # G+6512  U+65AB  uni65AB,  CJK UNIFIED IDEOGRAPH-65AB
        0x6628, # G+6513  U+6628  uni6628,  CJK UNIFIED IDEOGRAPH-6628
        0x707C, # G+6514  U+707C  uni707C,  CJK UNIFIED IDEOGRAPH-707C
        0x70B8, # G+6515  U+70B8  uni70B8,  CJK UNIFIED IDEOGRAPH-70B8
        0x7235, # G+6516  U+7235  uni7235,  CJK UNIFIED IDEOGRAPH-7235
        0x7DBD, # G+6517  U+7DBD  uni7DBD,  CJK UNIFIED IDEOGRAPH-7DBD
        0x828D, # G+6518  U+828D  uni828D,  CJK UNIFIED IDEOGRAPH-828D
        0x914C, # G+6519  U+914C  uni914C,  CJK UNIFIED IDEOGRAPH-914C
        0x96C0, # G+6520  U+96C0  uni96C0,  CJK UNIFIED IDEOGRAPH-96C0
        0x9D72, # G+6521  U+9D72  uni9D72,  CJK UNIFIED IDEOGRAPH-9D72
        0x5B71, # G+6522  U+5B71  uni5B71,  CJK UNIFIED IDEOGRAPH-5B71
        0x68E7, # G+6523  U+68E7  uni68E7,  CJK UNIFIED IDEOGRAPH-68E7
        0x6B98, # G+6524  U+6B98  uni6B98,  CJK UNIFIED IDEOGRAPH-6B98
        0x6F7A, # G+6525  U+6F7A  uni6F7A,  CJK UNIFIED IDEOGRAPH-6F7A
        0x76DE, # G+6526  U+76DE  uni76DE,  CJK UNIFIED IDEOGRAPH-76DE
        0x5C91, # G+6527  U+5C91  uni5C91,  CJK UNIFIED IDEOGRAPH-5C91
        0x66AB, # G+6528  U+66AB  uni66AB,  CJK UNIFIED IDEOGRAPH-66AB
        0x6F5B, # G+6529  U+6F5B  uni6F5B,  CJK UNIFIED IDEOGRAPH-6F5B
        0x7BB4, # G+6530  U+7BB4  uni7BB4,  CJK UNIFIED IDEOGRAPH-7BB4
        0x7C2A, # G+6531  U+7C2A  uni7C2A,  CJK UNIFIED IDEOGRAPH-7C2A
        0x8836, # G+6532  U+8836  uni8836,  CJK UNIFIED IDEOGRAPH-8836
        0x96DC, # G+6533  U+96DC  uni96DC,  CJK UNIFIED IDEOGRAPH-96DC
        0x4E08, # G+6534  U+4E08  uni4E08,  CJK UNIFIED IDEOGRAPH-4E08
        0x4ED7, # G+6535  U+4ED7  uni4ED7,  CJK UNIFIED IDEOGRAPH-4ED7
        0x5320, # G+6536  U+5320  uni5320,  CJK UNIFIED IDEOGRAPH-5320
        0x5834, # G+6537  U+5834  uni5834,  CJK UNIFIED IDEOGRAPH-5834
        0x58BB, # G+6538  U+58BB  uni58BB,  CJK UNIFIED IDEOGRAPH-58BB
        0x58EF, # G+6539  U+58EF  uni58EF,  CJK UNIFIED IDEOGRAPH-58EF
        0x596C, # G+6540  U+596C  uni596C,  CJK UNIFIED IDEOGRAPH-596C
        0x5C07, # G+6541  U+5C07  uni5C07,  CJK UNIFIED IDEOGRAPH-5C07
        0x5E33, # G+6542  U+5E33  uni5E33,  CJK UNIFIED IDEOGRAPH-5E33
        0x5E84, # G+6543  U+5E84  uni5E84,  CJK UNIFIED IDEOGRAPH-5E84
        0x5F35, # G+6544  U+5F35  uni5F35,  CJK UNIFIED IDEOGRAPH-5F35
        0x638C, # G+6545  U+638C  uni638C,  CJK UNIFIED IDEOGRAPH-638C
        0x66B2, # G+6546  U+66B2  uni66B2,  CJK UNIFIED IDEOGRAPH-66B2
        0x6756, # G+6547  U+6756  uni6756,  CJK UNIFIED IDEOGRAPH-6756
        0x6A1F, # G+6548  U+6A1F  uni6A1F,  CJK UNIFIED IDEOGRAPH-6A1F
        0x6AA3, # G+6549  U+6AA3  uni6AA3,  CJK UNIFIED IDEOGRAPH-6AA3
        0x6B0C, # G+6550  U+6B0C  uni6B0C,  CJK UNIFIED IDEOGRAPH-6B0C
        0x6F3F, # G+6551  U+6F3F  uni6F3F,  CJK UNIFIED IDEOGRAPH-6F3F
        0x7246, # G+6552  U+7246  uni7246,  CJK UNIFIED IDEOGRAPH-7246
        0x7350, # G+6553  U+7350  uni7350,  CJK UNIFIED IDEOGRAPH-7350
        0x748B, # G+6554  U+748B  uni748B,  CJK UNIFIED IDEOGRAPH-748B
        0x7AE0, # G+6555  U+7AE0  uni7AE0,  CJK UNIFIED IDEOGRAPH-7AE0
        0x7CA7, # G+6556  U+7CA7  uni7CA7,  CJK UNIFIED IDEOGRAPH-7CA7
        0x8178, # G+6557  U+8178  uni8178,  CJK UNIFIED IDEOGRAPH-8178
        0x81DF, # G+6558  U+81DF  uni81DF,  CJK UNIFIED IDEOGRAPH-81DF
        0x81E7, # G+6559  U+81E7  uni81E7,  CJK UNIFIED IDEOGRAPH-81E7
        0x838A, # G+6560  U+838A  uni838A,  CJK UNIFIED IDEOGRAPH-838A
        0x846C, # G+6561  U+846C  uni846C,  CJK UNIFIED IDEOGRAPH-846C
        0x8523, # G+6562  U+8523  uni8523,  CJK UNIFIED IDEOGRAPH-8523
        0x8594, # G+6563  U+8594  uni8594,  CJK UNIFIED IDEOGRAPH-8594
        0x85CF, # G+6564  U+85CF  uni85CF,  CJK UNIFIED IDEOGRAPH-85CF
        0x88DD, # G+6565  U+88DD  uni88DD,  CJK UNIFIED IDEOGRAPH-88DD
        0x8D13, # G+6566  U+8D13  uni8D13,  CJK UNIFIED IDEOGRAPH-8D13
        0x91AC, # G+6567  U+91AC  uni91AC,  CJK UNIFIED IDEOGRAPH-91AC
        0x2FA7, # G+6568  U+2FA7  uni2FA7,  KANGXI RADICAL LONG
        0x969C, # G+6569  U+969C  uni969C,  CJK UNIFIED IDEOGRAPH-969C
        0x518D, # G+6570  U+518D  uni518D,  CJK UNIFIED IDEOGRAPH-518D
        0x54C9, # G+6571  U+54C9  uni54C9,  CJK UNIFIED IDEOGRAPH-54C9
        0x5728, # G+6572  U+5728  uni5728,  CJK UNIFIED IDEOGRAPH-5728
        0x5BB0, # G+6573  U+5BB0  uni5BB0,  CJK UNIFIED IDEOGRAPH-5BB0
        0x624D, # G+6574  U+624D  uni624D,  CJK UNIFIED IDEOGRAPH-624D
        0x6750, # G+6575  U+6750  uni6750,  CJK UNIFIED IDEOGRAPH-6750
        0x683D, # G+6576  U+683D  uni683D,  CJK UNIFIED IDEOGRAPH-683D
        0x6893, # G+6577  U+6893  uni6893,  CJK UNIFIED IDEOGRAPH-6893
        0x6E3D, # G+6578  U+6E3D  uni6E3D,  CJK UNIFIED IDEOGRAPH-6E3D
        0x6ED3, # G+6579  U+6ED3  uni6ED3,  CJK UNIFIED IDEOGRAPH-6ED3
        0x707D, # G+6580  U+707D  uni707D,  CJK UNIFIED IDEOGRAPH-707D
        0x7E21, # G+6581  U+7E21  uni7E21,  CJK UNIFIED IDEOGRAPH-7E21
        0x88C1, # G+6582  U+88C1  uni88C1,  CJK UNIFIED IDEOGRAPH-88C1
        0x8CA1, # G+6583  U+8CA1  uni8CA1,  CJK UNIFIED IDEOGRAPH-8CA1
        0x8F09, # G+6584  U+8F09  uni8F09,  CJK UNIFIED IDEOGRAPH-8F09
        0x9F4B, # G+6585  U+9F4B  uni9F4B,  CJK UNIFIED IDEOGRAPH-9F4B
        0x9F4E, # G+6586  U+9F4E  uni9F4E,  CJK UNIFIED IDEOGRAPH-9F4E
        0x722D, # G+6587  U+722D  uni722D,  CJK UNIFIED IDEOGRAPH-722D
        0x7B8F, # G+6588  U+7B8F  uni7B8F,  CJK UNIFIED IDEOGRAPH-7B8F
        0x8ACD, # G+6589  U+8ACD  uni8ACD,  CJK UNIFIED IDEOGRAPH-8ACD
        0x931A, # G+6590  U+931A  uni931A,  CJK UNIFIED IDEOGRAPH-931A
        0x4F47, # G+6591  U+4F47  uni4F47,  CJK UNIFIED IDEOGRAPH-4F47
        0x4F4E, # G+6592  U+4F4E  uni4F4E,  CJK UNIFIED IDEOGRAPH-4F4E
        0x5132, # G+6593  U+5132  uni5132,  CJK UNIFIED IDEOGRAPH-5132
        0x5480, # G+6594  U+5480  uni5480,  CJK UNIFIED IDEOGRAPH-5480
        0x59D0, # G+6595  U+59D0  uni59D0,  CJK UNIFIED IDEOGRAPH-59D0
        0x5E95, # G+6596  U+5E95  uni5E95,  CJK UNIFIED IDEOGRAPH-5E95
        0x62B5, # G+6597  U+62B5  uni62B5,  CJK UNIFIED IDEOGRAPH-62B5
        0x6775, # G+6598  U+6775  uni6775,  CJK UNIFIED IDEOGRAPH-6775
        0x696E, # G+6599  U+696E  uni696E,  CJK UNIFIED IDEOGRAPH-696E
        0x6A17, # G+6600  U+6A17  uni6A17,  CJK UNIFIED IDEOGRAPH-6A17
        0x6CAE, # G+6601  U+6CAE  uni6CAE,  CJK UNIFIED IDEOGRAPH-6CAE
        0x6E1A, # G+6602  U+6E1A  uni6E1A,  CJK UNIFIED IDEOGRAPH-6E1A
        0x72D9, # G+6603  U+72D9  uni72D9,  CJK UNIFIED IDEOGRAPH-72D9
        0x732A, # G+6604  U+732A  uni732A,  CJK UNIFIED IDEOGRAPH-732A
        0x75BD, # G+6605  U+75BD  uni75BD,  CJK UNIFIED IDEOGRAPH-75BD
        0x7BB8, # G+6606  U+7BB8  uni7BB8,  CJK UNIFIED IDEOGRAPH-7BB8
        0x7D35, # G+6607  U+7D35  uni7D35,  CJK UNIFIED IDEOGRAPH-7D35
        0x82E7, # G+6608  U+82E7  uni82E7,  CJK UNIFIED IDEOGRAPH-82E7
        0x83F9, # G+6609  U+83F9  uni83F9,  CJK UNIFIED IDEOGRAPH-83F9
        0x8457, # G+6610  U+8457  uni8457,  CJK UNIFIED IDEOGRAPH-8457
        0x85F7, # G+6611  U+85F7  uni85F7,  CJK UNIFIED IDEOGRAPH-85F7
        0x8A5B, # G+6612  U+8A5B  uni8A5B,  CJK UNIFIED IDEOGRAPH-8A5B
        0x8CAF, # G+6613  U+8CAF  uni8CAF,  CJK UNIFIED IDEOGRAPH-8CAF
        0x8E87, # G+6614  U+8E87  uni8E87,  CJK UNIFIED IDEOGRAPH-8E87
        0x9019, # G+6615  U+9019  uni9019,  CJK UNIFIED IDEOGRAPH-9019
        0x90B8, # G+6616  U+90B8  uni90B8,  CJK UNIFIED IDEOGRAPH-90B8
        0x96CE, # G+6617  U+96CE  uni96CE,  CJK UNIFIED IDEOGRAPH-96CE
        0x9F5F, # G+6618  U+9F5F  uni9F5F,  CJK UNIFIED IDEOGRAPH-9F5F
        0x52E3, # G+6619  U+52E3  uni52E3,  CJK UNIFIED IDEOGRAPH-52E3
        0x540A, # G+6620  U+540A  uni540A,  CJK UNIFIED IDEOGRAPH-540A
        0x5AE1, # G+6621  U+5AE1  uni5AE1,  CJK UNIFIED IDEOGRAPH-5AE1
        0x5BC2, # G+6622  U+5BC2  uni5BC2,  CJK UNIFIED IDEOGRAPH-5BC2
        0x6458, # G+6623  U+6458  uni6458,  CJK UNIFIED IDEOGRAPH-6458
        0x6575, # G+6624  U+6575  uni6575,  CJK UNIFIED IDEOGRAPH-6575
        0x6EF4, # G+6625  U+6EF4  uni6EF4,  CJK UNIFIED IDEOGRAPH-6EF4
        0x72C4, # G+6626  U+72C4  uni72C4,  CJK UNIFIED IDEOGRAPH-72C4
        0x7684, # G+6627  U+7684  uni7684,  CJK UNIFIED IDEOGRAPH-7684
        0x7A4D, # G+6628  U+7A4D  uni7A4D,  CJK UNIFIED IDEOGRAPH-7A4D
        0x7B1B, # G+6629  U+7B1B  uni7B1B,  CJK UNIFIED IDEOGRAPH-7B1B
        0x7C4D, # G+6630  U+7C4D  uni7C4D,  CJK UNIFIED IDEOGRAPH-7C4D
        0x7E3E, # G+6631  U+7E3E  uni7E3E,  CJK UNIFIED IDEOGRAPH-7E3E
        0x7FDF, # G+6632  U+7FDF  uni7FDF,  CJK UNIFIED IDEOGRAPH-7FDF
        0x837B, # G+6633  U+837B  uni837B,  CJK UNIFIED IDEOGRAPH-837B
        0x8B2B, # G+6634  U+8B2B  uni8B2B,  CJK UNIFIED IDEOGRAPH-8B2B
        0x8CCA, # G+6635  U+8CCA  uni8CCA,  CJK UNIFIED IDEOGRAPH-8CCA
        0x2F9A, # G+6636  U+2F9A  uni2F9A,  KANGXI RADICAL RED
        0x8DE1, # G+6637  U+8DE1  uni8DE1,  CJK UNIFIED IDEOGRAPH-8DE1
        0x8E5F, # G+6638  U+8E5F  uni8E5F,  CJK UNIFIED IDEOGRAPH-8E5F
        0x8FEA, # G+6639  U+8FEA  uni8FEA,  CJK UNIFIED IDEOGRAPH-8FEA
        0x8FF9, # G+6640  U+8FF9  uni8FF9,  CJK UNIFIED IDEOGRAPH-8FF9
        0x9069, # G+6641  U+9069  uni9069,  CJK UNIFIED IDEOGRAPH-9069
        0x93D1, # G+6642  U+93D1  uni93D1,  CJK UNIFIED IDEOGRAPH-93D1
        0x4F43, # G+6643  U+4F43  uni4F43,  CJK UNIFIED IDEOGRAPH-4F43
        0x4F7A, # G+6644  U+4F7A  uni4F7A,  CJK UNIFIED IDEOGRAPH-4F7A
        0x50B3, # G+6645  U+50B3  uni50B3,  CJK UNIFIED IDEOGRAPH-50B3
        0x5168, # G+6646  U+5168  uni5168,  CJK UNIFIED IDEOGRAPH-5168
        0x5178, # G+6647  U+5178  uni5178,  CJK UNIFIED IDEOGRAPH-5178
        0x524D, # G+6648  U+524D  uni524D,  CJK UNIFIED IDEOGRAPH-524D
        0x526A, # G+6649  U+526A  uni526A,  CJK UNIFIED IDEOGRAPH-526A
        0x5861, # G+6650  U+5861  uni5861,  CJK UNIFIED IDEOGRAPH-5861
        0x587C, # G+6651  U+587C  uni587C,  CJK UNIFIED IDEOGRAPH-587C
        0x5960, # G+6652  U+5960  uni5960,  CJK UNIFIED IDEOGRAPH-5960
        0x5C08, # G+6653  U+5C08  uni5C08,  CJK UNIFIED IDEOGRAPH-5C08
        0x5C55, # G+6654  U+5C55  uni5C55,  CJK UNIFIED IDEOGRAPH-5C55
        0x5EDB, # G+6655  U+5EDB  uni5EDB,  CJK UNIFIED IDEOGRAPH-5EDB
        0x609B, # G+6656  U+609B  uni609B,  CJK UNIFIED IDEOGRAPH-609B
        0x6230, # G+6657  U+6230  uni6230,  CJK UNIFIED IDEOGRAPH-6230
        0x6813, # G+6658  U+6813  uni6813,  CJK UNIFIED IDEOGRAPH-6813
        0x6BBF, # G+6659  U+6BBF  uni6BBF,  CJK UNIFIED IDEOGRAPH-6BBF
        0x6C08, # G+6660  U+6C08  uni6C08,  CJK UNIFIED IDEOGRAPH-6C08
        0x6FB1, # G+6661  U+6FB1  uni6FB1,  CJK UNIFIED IDEOGRAPH-6FB1
        0x714E, # G+6662  U+714E  uni714E,  CJK UNIFIED IDEOGRAPH-714E
        0x7420, # G+6663  U+7420  uni7420,  CJK UNIFIED IDEOGRAPH-7420
        0x2F65, # G+6664  U+2F65  uni2F65,  KANGXI RADICAL FIELD
        0x7538, # G+6665  U+7538  uni7538,  CJK UNIFIED IDEOGRAPH-7538
        0x7551, # G+6666  U+7551  uni7551,  CJK UNIFIED IDEOGRAPH-7551
        0x7672, # G+6667  U+7672  uni7672,  CJK UNIFIED IDEOGRAPH-7672
        0x7B4C, # G+6668  U+7B4C  uni7B4C,  CJK UNIFIED IDEOGRAPH-7B4C
        0x7B8B, # G+6669  U+7B8B  uni7B8B,  CJK UNIFIED IDEOGRAPH-7B8B
        0x7BAD, # G+6670  U+7BAD  uni7BAD,  CJK UNIFIED IDEOGRAPH-7BAD
        0x7BC6, # G+6671  U+7BC6  uni7BC6,  CJK UNIFIED IDEOGRAPH-7BC6
        0x7E8F, # G+6672  U+7E8F  uni7E8F,  CJK UNIFIED IDEOGRAPH-7E8F
        0x8A6E, # G+6673  U+8A6E  uni8A6E,  CJK UNIFIED IDEOGRAPH-8A6E
        0x8F3E, # G+6674  U+8F3E  uni8F3E,  CJK UNIFIED IDEOGRAPH-8F3E
        0x8F49, # G+6675  U+8F49  uni8F49,  CJK UNIFIED IDEOGRAPH-8F49
        0x923F, # G+6676  U+923F  uni923F,  CJK UNIFIED IDEOGRAPH-923F
        0x9293, # G+6677  U+9293  uni9293,  CJK UNIFIED IDEOGRAPH-9293
        0x9322, # G+6678  U+9322  uni9322,  CJK UNIFIED IDEOGRAPH-9322
        0x942B, # G+6679  U+942B  uni942B,  CJK UNIFIED IDEOGRAPH-942B
        0x96FB, # G+6680  U+96FB  uni96FB,  CJK UNIFIED IDEOGRAPH-96FB
        0x985A, # G+6681  U+985A  uni985A,  CJK UNIFIED IDEOGRAPH-985A
        0x986B, # G+6682  U+986B  uni986B,  CJK UNIFIED IDEOGRAPH-986B
        0x991E, # G+6683  U+991E  uni991E,  CJK UNIFIED IDEOGRAPH-991E
        0x5207, # G+6684  U+5207  uni5207,  CJK UNIFIED IDEOGRAPH-5207
        0x622A, # G+6685  U+622A  uni622A,  CJK UNIFIED IDEOGRAPH-622A
        0x6298, # G+6686  U+6298  uni6298,  CJK UNIFIED IDEOGRAPH-6298
        0x6D59, # G+6687  U+6D59  uni6D59,  CJK UNIFIED IDEOGRAPH-6D59
        0x7664, # G+6688  U+7664  uni7664,  CJK UNIFIED IDEOGRAPH-7664
        0x7ACA, # G+6689  U+7ACA  uni7ACA,  CJK UNIFIED IDEOGRAPH-7ACA
        0x7BC0, # G+6690  U+7BC0  uni7BC0,  CJK UNIFIED IDEOGRAPH-7BC0
        0x7D76, # G+6691  U+7D76  uni7D76,  CJK UNIFIED IDEOGRAPH-7D76
        0x5360, # G+6692  U+5360  uni5360,  CJK UNIFIED IDEOGRAPH-5360
        0x5CBE, # G+6693  U+5CBE  uni5CBE,  CJK UNIFIED IDEOGRAPH-5CBE
        0x5E97, # G+6694  U+5E97  uni5E97,  CJK UNIFIED IDEOGRAPH-5E97
        0x6F38, # G+6695  U+6F38  uni6F38,  CJK UNIFIED IDEOGRAPH-6F38
        0x70B9, # G+6696  U+70B9  uni70B9,  CJK UNIFIED IDEOGRAPH-70B9
        0x7C98, # G+6697  U+7C98  uni7C98,  CJK UNIFIED IDEOGRAPH-7C98
        0x9711, # G+6698  U+9711  uni9711,  CJK UNIFIED IDEOGRAPH-9711
        0x9B8E, # G+6699  U+9B8E  uni9B8E,  CJK UNIFIED IDEOGRAPH-9B8E
        0x9EDE, # G+6700  U+9EDE  uni9EDE,  CJK UNIFIED IDEOGRAPH-9EDE
        0x63A5, # G+6701  U+63A5  uni63A5,  CJK UNIFIED IDEOGRAPH-63A5
        0x647A, # G+6702  U+647A  uni647A,  CJK UNIFIED IDEOGRAPH-647A
        0x8776, # G+6703  U+8776  uni8776,  CJK UNIFIED IDEOGRAPH-8776
        0x4E01, # G+6704  U+4E01  uni4E01,  CJK UNIFIED IDEOGRAPH-4E01
        0x4E95, # G+6705  U+4E95  uni4E95,  CJK UNIFIED IDEOGRAPH-4E95
        0x4EAD, # G+6706  U+4EAD  uni4EAD,  CJK UNIFIED IDEOGRAPH-4EAD
        0x505C, # G+6707  U+505C  uni505C,  CJK UNIFIED IDEOGRAPH-505C
        0x5075, # G+6708  U+5075  uni5075,  CJK UNIFIED IDEOGRAPH-5075
        0x5448, # G+6709  U+5448  uni5448,  CJK UNIFIED IDEOGRAPH-5448
        0x59C3, # G+6710  U+59C3  uni59C3,  CJK UNIFIED IDEOGRAPH-59C3
        0x5B9A, # G+6711  U+5B9A  uni5B9A,  CJK UNIFIED IDEOGRAPH-5B9A
        0x5E40, # G+6712  U+5E40  uni5E40,  CJK UNIFIED IDEOGRAPH-5E40
        0x5EAD, # G+6713  U+5EAD  uni5EAD,  CJK UNIFIED IDEOGRAPH-5EAD
        0x5EF7, # G+6714  U+5EF7  uni5EF7,  CJK UNIFIED IDEOGRAPH-5EF7
        0x5F81, # G+6715  U+5F81  uni5F81,  CJK UNIFIED IDEOGRAPH-5F81
        0x60C5, # G+6716  U+60C5  uni60C5,  CJK UNIFIED IDEOGRAPH-60C5
        0x633A, # G+6717  U+633A  uni633A,  CJK UNIFIED IDEOGRAPH-633A
        0x653F, # G+6718  U+653F  uni653F,  CJK UNIFIED IDEOGRAPH-653F
        0x6574, # G+6719  U+6574  uni6574,  CJK UNIFIED IDEOGRAPH-6574
        0x65CC, # G+6720  U+65CC  uni65CC,  CJK UNIFIED IDEOGRAPH-65CC
        0x6676, # G+6721  U+6676  uni6676,  CJK UNIFIED IDEOGRAPH-6676
        0x6678, # G+6722  U+6678  uni6678,  CJK UNIFIED IDEOGRAPH-6678
        0x67FE, # G+6723  U+67FE  uni67FE,  CJK UNIFIED IDEOGRAPH-67FE
        0x6968, # G+6724  U+6968  uni6968,  CJK UNIFIED IDEOGRAPH-6968
        0x6A89, # G+6725  U+6A89  uni6A89,  CJK UNIFIED IDEOGRAPH-6A89
        0x6B63, # G+6726  U+6B63  uni6B63,  CJK UNIFIED IDEOGRAPH-6B63
        0x6C40, # G+6727  U+6C40  uni6C40,  CJK UNIFIED IDEOGRAPH-6C40
        0x6DC0, # G+6728  U+6DC0  uni6DC0,  CJK UNIFIED IDEOGRAPH-6DC0
        0x6DE8, # G+6729  U+6DE8  uni6DE8,  CJK UNIFIED IDEOGRAPH-6DE8
        0x6E1F, # G+6730  U+6E1F  uni6E1F,  CJK UNIFIED IDEOGRAPH-6E1F
        0x6E5E, # G+6731  U+6E5E  uni6E5E,  CJK UNIFIED IDEOGRAPH-6E5E
        0x701E, # G+6732  U+701E  uni701E,  CJK UNIFIED IDEOGRAPH-701E
        0x70A1, # G+6733  U+70A1  uni70A1,  CJK UNIFIED IDEOGRAPH-70A1
        0x738E, # G+6734  U+738E  uni738E,  CJK UNIFIED IDEOGRAPH-738E
        0x73FD, # G+6735  U+73FD  uni73FD,  CJK UNIFIED IDEOGRAPH-73FD
        0x753A, # G+6736  U+753A  uni753A,  CJK UNIFIED IDEOGRAPH-753A
        0x775B, # G+6737  U+775B  uni775B,  CJK UNIFIED IDEOGRAPH-775B
        0x7887, # G+6738  U+7887  uni7887,  CJK UNIFIED IDEOGRAPH-7887
        0x798E, # G+6739  U+798E  uni798E,  CJK UNIFIED IDEOGRAPH-798E
        0x7A0B, # G+6740  U+7A0B  uni7A0B,  CJK UNIFIED IDEOGRAPH-7A0B
        0x7A7D, # G+6741  U+7A7D  uni7A7D,  CJK UNIFIED IDEOGRAPH-7A7D
        0x7CBE, # G+6742  U+7CBE  uni7CBE,  CJK UNIFIED IDEOGRAPH-7CBE
        0x7D8E, # G+6743  U+7D8E  uni7D8E,  CJK UNIFIED IDEOGRAPH-7D8E
        0x8247, # G+6744  U+8247  uni8247,  CJK UNIFIED IDEOGRAPH-8247
        0x8A02, # G+6745  U+8A02  uni8A02,  CJK UNIFIED IDEOGRAPH-8A02
        0x8AEA, # G+6746  U+8AEA  uni8AEA,  CJK UNIFIED IDEOGRAPH-8AEA
        0x8C9E, # G+6747  U+8C9E  uni8C9E,  CJK UNIFIED IDEOGRAPH-8C9E
        0x912D, # G+6748  U+912D  uni912D,  CJK UNIFIED IDEOGRAPH-912D
        0x914A, # G+6749  U+914A  uni914A,  CJK UNIFIED IDEOGRAPH-914A
        0x91D8, # G+6750  U+91D8  uni91D8,  CJK UNIFIED IDEOGRAPH-91D8
        0x9266, # G+6751  U+9266  uni9266,  CJK UNIFIED IDEOGRAPH-9266
        0x92CC, # G+6752  U+92CC  uni92CC,  CJK UNIFIED IDEOGRAPH-92CC
        0x9320, # G+6753  U+9320  uni9320,  CJK UNIFIED IDEOGRAPH-9320
        0x9706, # G+6754  U+9706  uni9706,  CJK UNIFIED IDEOGRAPH-9706
        0x9756, # G+6755  U+9756  uni9756,  CJK UNIFIED IDEOGRAPH-9756
        0x975C, # G+6756  U+975C  uni975C,  CJK UNIFIED IDEOGRAPH-975C
        0x9802, # G+6757  U+9802  uni9802,  CJK UNIFIED IDEOGRAPH-9802
        0x2FCD, # G+6758  U+2FCD  uni2FCD,  KANGXI RADICAL TRIPOD
        0x5236, # G+6759  U+5236  uni5236,  CJK UNIFIED IDEOGRAPH-5236
        0x5291, # G+6760  U+5291  uni5291,  CJK UNIFIED IDEOGRAPH-5291
        0x557C, # G+6761  U+557C  uni557C,  CJK UNIFIED IDEOGRAPH-557C
        0x5824, # G+6762  U+5824  uni5824,  CJK UNIFIED IDEOGRAPH-5824
        0x5E1D, # G+6763  U+5E1D  uni5E1D,  CJK UNIFIED IDEOGRAPH-5E1D
        0x5F1F, # G+6764  U+5F1F  uni5F1F,  CJK UNIFIED IDEOGRAPH-5F1F
        0x608C, # G+6765  U+608C  uni608C,  CJK UNIFIED IDEOGRAPH-608C
        0x63D0, # G+6766  U+63D0  uni63D0,  CJK UNIFIED IDEOGRAPH-63D0
        0x68AF, # G+6767  U+68AF  uni68AF,  CJK UNIFIED IDEOGRAPH-68AF
        0x6FDF, # G+6768  U+6FDF  uni6FDF,  CJK UNIFIED IDEOGRAPH-6FDF
        0x796D, # G+6769  U+796D  uni796D,  CJK UNIFIED IDEOGRAPH-796D
        0x7B2C, # G+6770  U+7B2C  uni7B2C,  CJK UNIFIED IDEOGRAPH-7B2C
        0x81CD, # G+6771  U+81CD  uni81CD,  CJK UNIFIED IDEOGRAPH-81CD
        0x85BA, # G+6772  U+85BA  uni85BA,  CJK UNIFIED IDEOGRAPH-85BA
        0x88FD, # G+6773  U+88FD  uni88FD,  CJK UNIFIED IDEOGRAPH-88FD
        0x8AF8, # G+6774  U+8AF8  uni8AF8,  CJK UNIFIED IDEOGRAPH-8AF8
        0x8E44, # G+6775  U+8E44  uni8E44,  CJK UNIFIED IDEOGRAPH-8E44
        0x918D, # G+6776  U+918D  uni918D,  CJK UNIFIED IDEOGRAPH-918D
        0x9664, # G+6777  U+9664  uni9664,  CJK UNIFIED IDEOGRAPH-9664
        0x969B, # G+6778  U+969B  uni969B,  CJK UNIFIED IDEOGRAPH-969B
        0x973D, # G+6779  U+973D  uni973D,  CJK UNIFIED IDEOGRAPH-973D
        0x984C, # G+6780  U+984C  uni984C,  CJK UNIFIED IDEOGRAPH-984C
        0x2FD1, # G+6781  U+2FD1  uni2FD1,  KANGXI RADICAL EVEN
        0x4FCE, # G+6782  U+4FCE  uni4FCE,  CJK UNIFIED IDEOGRAPH-4FCE
        0x5146, # G+6783  U+5146  uni5146,  CJK UNIFIED IDEOGRAPH-5146
        0x51CB, # G+6784  U+51CB  uni51CB,  CJK UNIFIED IDEOGRAPH-51CB
        0x52A9, # G+6785  U+52A9  uni52A9,  CJK UNIFIED IDEOGRAPH-52A9
        0x5632, # G+6786  U+5632  uni5632,  CJK UNIFIED IDEOGRAPH-5632
        0x5F14, # G+6787  U+5F14  uni5F14,  CJK UNIFIED IDEOGRAPH-5F14
        0x5F6B, # G+6788  U+5F6B  uni5F6B,  CJK UNIFIED IDEOGRAPH-5F6B
        0x63AA, # G+6789  U+63AA  uni63AA,  CJK UNIFIED IDEOGRAPH-63AA
        0x64CD, # G+6790  U+64CD  uni64CD,  CJK UNIFIED IDEOGRAPH-64CD
        0x65E9, # G+6791  U+65E9  uni65E9,  CJK UNIFIED IDEOGRAPH-65E9
        0x6641, # G+6792  U+6641  uni6641,  CJK UNIFIED IDEOGRAPH-6641
        0x66FA, # G+6793  U+66FA  uni66FA,  CJK UNIFIED IDEOGRAPH-66FA
        0x66F9, # G+6794  U+66F9  uni66F9,  CJK UNIFIED IDEOGRAPH-66F9
        0x671D, # G+6795  U+671D  uni671D,  CJK UNIFIED IDEOGRAPH-671D
        0x689D, # G+6796  U+689D  uni689D,  CJK UNIFIED IDEOGRAPH-689D
        0x68D7, # G+6797  U+68D7  uni68D7,  CJK UNIFIED IDEOGRAPH-68D7
        0x69FD, # G+6798  U+69FD  uni69FD,  CJK UNIFIED IDEOGRAPH-69FD
        0x6F15, # G+6799  U+6F15  uni6F15,  CJK UNIFIED IDEOGRAPH-6F15
        0x6F6E, # G+6800  U+6F6E  uni6F6E,  CJK UNIFIED IDEOGRAPH-6F6E
        0x7167, # G+6801  U+7167  uni7167,  CJK UNIFIED IDEOGRAPH-7167
        0x71E5, # G+6802  U+71E5  uni71E5,  CJK UNIFIED IDEOGRAPH-71E5
        0x2F56, # G+6803  U+2F56  uni2F56,  KANGXI RADICAL CLAW
        0x74AA, # G+6804  U+74AA  uni74AA,  CJK UNIFIED IDEOGRAPH-74AA
        0x773A, # G+6805  U+773A  uni773A,  CJK UNIFIED IDEOGRAPH-773A
        0x7956, # G+6806  U+7956  uni7956,  CJK UNIFIED IDEOGRAPH-7956
        0x795A, # G+6807  U+795A  uni795A,  CJK UNIFIED IDEOGRAPH-795A
        0x79DF, # G+6808  U+79DF  uni79DF,  CJK UNIFIED IDEOGRAPH-79DF
        0x7A20, # G+6809  U+7A20  uni7A20,  CJK UNIFIED IDEOGRAPH-7A20
        0x7A95, # G+6810  U+7A95  uni7A95,  CJK UNIFIED IDEOGRAPH-7A95
        0x7C97, # G+6811  U+7C97  uni7C97,  CJK UNIFIED IDEOGRAPH-7C97
        0x7CDF, # G+6812  U+7CDF  uni7CDF,  CJK UNIFIED IDEOGRAPH-7CDF
        0x7D44, # G+6813  U+7D44  uni7D44,  CJK UNIFIED IDEOGRAPH-7D44
        0x7E70, # G+6814  U+7E70  uni7E70,  CJK UNIFIED IDEOGRAPH-7E70
        0x8087, # G+6815  U+8087  uni8087,  CJK UNIFIED IDEOGRAPH-8087
        0x85FB, # G+6816  U+85FB  uni85FB,  CJK UNIFIED IDEOGRAPH-85FB
        0x86A4, # G+6817  U+86A4  uni86A4,  CJK UNIFIED IDEOGRAPH-86A4
        0x8A54, # G+6818  U+8A54  uni8A54,  CJK UNIFIED IDEOGRAPH-8A54
        0x8ABF, # G+6819  U+8ABF  uni8ABF,  CJK UNIFIED IDEOGRAPH-8ABF
        0x8D99, # G+6820  U+8D99  uni8D99,  CJK UNIFIED IDEOGRAPH-8D99
        0x8E81, # G+6821  U+8E81  uni8E81,  CJK UNIFIED IDEOGRAPH-8E81
        0x9020, # G+6822  U+9020  uni9020,  CJK UNIFIED IDEOGRAPH-9020
        0x906D, # G+6823  U+906D  uni906D,  CJK UNIFIED IDEOGRAPH-906D
        0x91E3, # G+6824  U+91E3  uni91E3,  CJK UNIFIED IDEOGRAPH-91E3
        0x963B, # G+6825  U+963B  uni963B,  CJK UNIFIED IDEOGRAPH-963B
        0x96D5, # G+6826  U+96D5  uni96D5,  CJK UNIFIED IDEOGRAPH-96D5
        0x2FC3, # G+6827  U+2FC3  uni2FC3,  KANGXI RADICAL BIRD
        0x65CF, # G+6828  U+65CF  uni65CF,  CJK UNIFIED IDEOGRAPH-65CF
        0x7C07, # G+6829  U+7C07  uni7C07,  CJK UNIFIED IDEOGRAPH-7C07
        0x2F9C, # G+6830  U+2F9C  uni2F9C,  KANGXI RADICAL FOOT
        0x93C3, # G+6831  U+93C3  uni93C3,  CJK UNIFIED IDEOGRAPH-93C3
        0x5B58, # G+6832  U+5B58  uni5B58,  CJK UNIFIED IDEOGRAPH-5B58
        0x5C0A, # G+6833  U+5C0A  uni5C0A,  CJK UNIFIED IDEOGRAPH-5C0A
        0x5352, # G+6834  U+5352  uni5352,  CJK UNIFIED IDEOGRAPH-5352
        0x62D9, # G+6835  U+62D9  uni62D9,  CJK UNIFIED IDEOGRAPH-62D9
        0x731D, # G+6836  U+731D  uni731D,  CJK UNIFIED IDEOGRAPH-731D
        0x5027, # G+6837  U+5027  uni5027,  CJK UNIFIED IDEOGRAPH-5027
        0x5B97, # G+6838  U+5B97  uni5B97,  CJK UNIFIED IDEOGRAPH-5B97
        0x5F9E, # G+6839  U+5F9E  uni5F9E,  CJK UNIFIED IDEOGRAPH-5F9E
        0x60B0, # G+6840  U+60B0  uni60B0,  CJK UNIFIED IDEOGRAPH-60B0
        0x616B, # G+6841  U+616B  uni616B,  CJK UNIFIED IDEOGRAPH-616B
        0x68D5, # G+6842  U+68D5  uni68D5,  CJK UNIFIED IDEOGRAPH-68D5
        0x6DD9, # G+6843  U+6DD9  uni6DD9,  CJK UNIFIED IDEOGRAPH-6DD9
        0x742E, # G+6844  U+742E  uni742E,  CJK UNIFIED IDEOGRAPH-742E
        0x7A2E, # G+6845  U+7A2E  uni7A2E,  CJK UNIFIED IDEOGRAPH-7A2E
        0x7D42, # G+6846  U+7D42  uni7D42,  CJK UNIFIED IDEOGRAPH-7D42
        0x7D9C, # G+6847  U+7D9C  uni7D9C,  CJK UNIFIED IDEOGRAPH-7D9C
        0x7E31, # G+6848  U+7E31  uni7E31,  CJK UNIFIED IDEOGRAPH-7E31
        0x816B, # G+6849  U+816B  uni816B,  CJK UNIFIED IDEOGRAPH-816B
        0x8E2A, # G+6850  U+8E2A  uni8E2A,  CJK UNIFIED IDEOGRAPH-8E2A
        0x8E35, # G+6851  U+8E35  uni8E35,  CJK UNIFIED IDEOGRAPH-8E35
        0x937E, # G+6852  U+937E  uni937E,  CJK UNIFIED IDEOGRAPH-937E
        0x9418, # G+6853  U+9418  uni9418,  CJK UNIFIED IDEOGRAPH-9418
        0x4F50, # G+6854  U+4F50  uni4F50,  CJK UNIFIED IDEOGRAPH-4F50
        0x5750, # G+6855  U+5750  uni5750,  CJK UNIFIED IDEOGRAPH-5750
        0x5DE6, # G+6856  U+5DE6  uni5DE6,  CJK UNIFIED IDEOGRAPH-5DE6
        0x5EA7, # G+6857  U+5EA7  uni5EA7,  CJK UNIFIED IDEOGRAPH-5EA7
        0x632B, # G+6858  U+632B  uni632B,  CJK UNIFIED IDEOGRAPH-632B
        0x7F6A, # G+6859  U+7F6A  uni7F6A,  CJK UNIFIED IDEOGRAPH-7F6A
        0x4E3B, # G+6860  U+4E3B  uni4E3B,  CJK UNIFIED IDEOGRAPH-4E3B
        0x4F4F, # G+6861  U+4F4F  uni4F4F,  CJK UNIFIED IDEOGRAPH-4F4F
        0x4F8F, # G+6862  U+4F8F  uni4F8F,  CJK UNIFIED IDEOGRAPH-4F8F
        0x505A, # G+6863  U+505A  uni505A,  CJK UNIFIED IDEOGRAPH-505A
        0x59DD, # G+6864  U+59DD  uni59DD,  CJK UNIFIED IDEOGRAPH-59DD
        0x80C4, # G+6865  U+80C4  uni80C4,  CJK UNIFIED IDEOGRAPH-80C4
        0x546A, # G+6866  U+546A  uni546A,  CJK UNIFIED IDEOGRAPH-546A
        0x5468, # G+6867  U+5468  uni5468,  CJK UNIFIED IDEOGRAPH-5468
        0x55FE, # G+6868  U+55FE  uni55FE,  CJK UNIFIED IDEOGRAPH-55FE
        0x594F, # G+6869  U+594F  uni594F,  CJK UNIFIED IDEOGRAPH-594F
        0x5B99, # G+6870  U+5B99  uni5B99,  CJK UNIFIED IDEOGRAPH-5B99
        0x5DDE, # G+6871  U+5DDE  uni5DDE,  CJK UNIFIED IDEOGRAPH-5DDE
        0x5EDA, # G+6872  U+5EDA  uni5EDA,  CJK UNIFIED IDEOGRAPH-5EDA
        0x665D, # G+6873  U+665D  uni665D,  CJK UNIFIED IDEOGRAPH-665D
        0x6731, # G+6874  U+6731  uni6731,  CJK UNIFIED IDEOGRAPH-6731
        0x67F1, # G+6875  U+67F1  uni67F1,  CJK UNIFIED IDEOGRAPH-67F1
        0x682A, # G+6876  U+682A  uni682A,  CJK UNIFIED IDEOGRAPH-682A
        0x6CE8, # G+6877  U+6CE8  uni6CE8,  CJK UNIFIED IDEOGRAPH-6CE8
        0x6D32, # G+6878  U+6D32  uni6D32,  CJK UNIFIED IDEOGRAPH-6D32
        0x6E4A, # G+6879  U+6E4A  uni6E4A,  CJK UNIFIED IDEOGRAPH-6E4A
        0x6F8D, # G+6880  U+6F8D  uni6F8D,  CJK UNIFIED IDEOGRAPH-6F8D
        0x70B7, # G+6881  U+70B7  uni70B7,  CJK UNIFIED IDEOGRAPH-70B7
        0x73E0, # G+6882  U+73E0  uni73E0,  CJK UNIFIED IDEOGRAPH-73E0
        0x7587, # G+6883  U+7587  uni7587,  CJK UNIFIED IDEOGRAPH-7587
        0x7C4C, # G+6884  U+7C4C  uni7C4C,  CJK UNIFIED IDEOGRAPH-7C4C
        0x7D02, # G+6885  U+7D02  uni7D02,  CJK UNIFIED IDEOGRAPH-7D02
        0x7D2C, # G+6886  U+7D2C  uni7D2C,  CJK UNIFIED IDEOGRAPH-7D2C
        0x7DA2, # G+6887  U+7DA2  uni7DA2,  CJK UNIFIED IDEOGRAPH-7DA2
        0x2F88, # G+6888  U+2F88  uni2F88,  KANGXI RADICAL BOAT
        0x86DB, # G+6889  U+86DB  uni86DB,  CJK UNIFIED IDEOGRAPH-86DB
        0x8A3B, # G+6890  U+8A3B  uni8A3B,  CJK UNIFIED IDEOGRAPH-8A3B
        0x8A85, # G+6891  U+8A85  uni8A85,  CJK UNIFIED IDEOGRAPH-8A85
        0x2F9B, # G+6892  U+2F9B  uni2F9B,  KANGXI RADICAL RUN
        0x8E8A, # G+6893  U+8E8A  uni8E8A,  CJK UNIFIED IDEOGRAPH-8E8A
        0x8F33, # G+6894  U+8F33  uni8F33,  CJK UNIFIED IDEOGRAPH-8F33
        0x9031, # G+6895  U+9031  uni9031,  CJK UNIFIED IDEOGRAPH-9031
        0x914E, # G+6896  U+914E  uni914E,  CJK UNIFIED IDEOGRAPH-914E
        0x9152, # G+6897  U+9152  uni9152,  CJK UNIFIED IDEOGRAPH-9152
        0x9444, # G+6898  U+9444  uni9444,  CJK UNIFIED IDEOGRAPH-9444
        0x99D0, # G+6899  U+99D0  uni99D0,  CJK UNIFIED IDEOGRAPH-99D0
        0x2F75, # G+6900  U+2F75  uni2F75,  KANGXI RADICAL BAMBOO
        0x7CA5, # G+6901  U+7CA5  uni7CA5,  CJK UNIFIED IDEOGRAPH-7CA5
        0x4FCA, # G+6902  U+4FCA  uni4FCA,  CJK UNIFIED IDEOGRAPH-4FCA
        0x5101, # G+6903  U+5101  uni5101,  CJK UNIFIED IDEOGRAPH-5101
        0x51C6, # G+6904  U+51C6  uni51C6,  CJK UNIFIED IDEOGRAPH-51C6
        0x57C8, # G+6905  U+57C8  uni57C8,  CJK UNIFIED IDEOGRAPH-57C8
        0x5BEF, # G+6906  U+5BEF  uni5BEF,  CJK UNIFIED IDEOGRAPH-5BEF
        0x5CFB, # G+6907  U+5CFB  uni5CFB,  CJK UNIFIED IDEOGRAPH-5CFB
        0x6659, # G+6908  U+6659  uni6659,  CJK UNIFIED IDEOGRAPH-6659
        0x6A3D, # G+6909  U+6A3D  uni6A3D,  CJK UNIFIED IDEOGRAPH-6A3D
        0x6D5A, # G+6910  U+6D5A  uni6D5A,  CJK UNIFIED IDEOGRAPH-6D5A
        0x6E96, # G+6911  U+6E96  uni6E96,  CJK UNIFIED IDEOGRAPH-6E96
        0x6FEC, # G+6912  U+6FEC  uni6FEC,  CJK UNIFIED IDEOGRAPH-6FEC
        0x710C, # G+6913  U+710C  uni710C,  CJK UNIFIED IDEOGRAPH-710C
        0x756F, # G+6914  U+756F  uni756F,  CJK UNIFIED IDEOGRAPH-756F
        0x7AE3, # G+6915  U+7AE3  uni7AE3,  CJK UNIFIED IDEOGRAPH-7AE3
        0x8822, # G+6916  U+8822  uni8822,  CJK UNIFIED IDEOGRAPH-8822
        0x9021, # G+6917  U+9021  uni9021,  CJK UNIFIED IDEOGRAPH-9021
        0x9075, # G+6918  U+9075  uni9075,  CJK UNIFIED IDEOGRAPH-9075
        0x96CB, # G+6919  U+96CB  uni96CB,  CJK UNIFIED IDEOGRAPH-96CB
        0x99FF, # G+6920  U+99FF  uni99FF,  CJK UNIFIED IDEOGRAPH-99FF
        0x8301, # G+6921  U+8301  uni8301,  CJK UNIFIED IDEOGRAPH-8301
        0x4E2D, # G+6922  U+4E2D  uni4E2D,  CJK UNIFIED IDEOGRAPH-4E2D
        0x4EF2, # G+6923  U+4EF2  uni4EF2,  CJK UNIFIED IDEOGRAPH-4EF2
        0x8846, # G+6924  U+8846  uni8846,  CJK UNIFIED IDEOGRAPH-8846
        0x91CD, # G+6925  U+91CD  uni91CD,  CJK UNIFIED IDEOGRAPH-91CD
        0x537D, # G+6926  U+537D  uni537D,  CJK UNIFIED IDEOGRAPH-537D
        0x6ADB, # G+6927  U+6ADB  uni6ADB,  CJK UNIFIED IDEOGRAPH-6ADB
        0x696B, # G+6928  U+696B  uni696B,  CJK UNIFIED IDEOGRAPH-696B
        0x6C41, # G+6929  U+6C41  uni6C41,  CJK UNIFIED IDEOGRAPH-6C41
        0x847A, # G+6930  U+847A  uni847A,  CJK UNIFIED IDEOGRAPH-847A
        0x589E, # G+6931  U+589E  uni589E,  CJK UNIFIED IDEOGRAPH-589E
        0x618E, # G+6932  U+618E  uni618E,  CJK UNIFIED IDEOGRAPH-618E
        0x66FE, # G+6933  U+66FE  uni66FE,  CJK UNIFIED IDEOGRAPH-66FE
        0x62EF, # G+6934  U+62EF  uni62EF,  CJK UNIFIED IDEOGRAPH-62EF
        0x70DD, # G+6935  U+70DD  uni70DD,  CJK UNIFIED IDEOGRAPH-70DD
        0x7511, # G+6936  U+7511  uni7511,  CJK UNIFIED IDEOGRAPH-7511
        0x75C7, # G+6937  U+75C7  uni75C7,  CJK UNIFIED IDEOGRAPH-75C7
        0x7E52, # G+6938  U+7E52  uni7E52,  CJK UNIFIED IDEOGRAPH-7E52
        0x84B8, # G+6939  U+84B8  uni84B8,  CJK UNIFIED IDEOGRAPH-84B8
        0x8B49, # G+6940  U+8B49  uni8B49,  CJK UNIFIED IDEOGRAPH-8B49
        0x8D08, # G+6941  U+8D08  uni8D08,  CJK UNIFIED IDEOGRAPH-8D08
        0x4E4B, # G+6942  U+4E4B  uni4E4B,  CJK UNIFIED IDEOGRAPH-4E4B
        0x53EA, # G+6943  U+53EA  uni53EA,  CJK UNIFIED IDEOGRAPH-53EA
        0x54AB, # G+6944  U+54AB  uni54AB,  CJK UNIFIED IDEOGRAPH-54AB
        0x5730, # G+6945  U+5730  uni5730,  CJK UNIFIED IDEOGRAPH-5730
        0x5740, # G+6946  U+5740  uni5740,  CJK UNIFIED IDEOGRAPH-5740
        0x5FD7, # G+6947  U+5FD7  uni5FD7,  CJK UNIFIED IDEOGRAPH-5FD7
        0x6301, # G+6948  U+6301  uni6301,  CJK UNIFIED IDEOGRAPH-6301
        0x6307, # G+6949  U+6307  uni6307,  CJK UNIFIED IDEOGRAPH-6307
        0x646F, # G+6950  U+646F  uni646F,  CJK UNIFIED IDEOGRAPH-646F
        0x2F40, # G+6951  U+2F40  uni2F40,  KANGXI RADICAL BRANCH
        0x65E8, # G+6952  U+65E8  uni65E8,  CJK UNIFIED IDEOGRAPH-65E8
        0x667A, # G+6953  U+667A  uni667A,  CJK UNIFIED IDEOGRAPH-667A
        0x679D, # G+6954  U+679D  uni679D,  CJK UNIFIED IDEOGRAPH-679D
        0x67B3, # G+6955  U+67B3  uni67B3,  CJK UNIFIED IDEOGRAPH-67B3
        0x2F4C, # G+6956  U+2F4C  uni2F4C,  KANGXI RADICAL STOP
        0x6C60, # G+6957  U+6C60  uni6C60,  CJK UNIFIED IDEOGRAPH-6C60
        0x6C9A, # G+6958  U+6C9A  uni6C9A,  CJK UNIFIED IDEOGRAPH-6C9A
        0x6F2C, # G+6959  U+6F2C  uni6F2C,  CJK UNIFIED IDEOGRAPH-6F2C
        0x77E5, # G+6960  U+77E5  uni77E5,  CJK UNIFIED IDEOGRAPH-77E5
        0x7825, # G+6961  U+7825  uni7825,  CJK UNIFIED IDEOGRAPH-7825
        0x7949, # G+6962  U+7949  uni7949,  CJK UNIFIED IDEOGRAPH-7949
        0x7957, # G+6963  U+7957  uni7957,  CJK UNIFIED IDEOGRAPH-7957
        0x7D19, # G+6964  U+7D19  uni7D19,  CJK UNIFIED IDEOGRAPH-7D19
        0x80A2, # G+6965  U+80A2  uni80A2,  CJK UNIFIED IDEOGRAPH-80A2
        0x8102, # G+6966  U+8102  uni8102,  CJK UNIFIED IDEOGRAPH-8102
        0x2F84, # G+6967  U+2F84  uni2F84,  KANGXI RADICAL ARRIVE
        0x829D, # G+6968  U+829D  uni829D,  CJK UNIFIED IDEOGRAPH-829D
        0x82B7, # G+6969  U+82B7  uni82B7,  CJK UNIFIED IDEOGRAPH-82B7
        0x8718, # G+6970  U+8718  uni8718,  CJK UNIFIED IDEOGRAPH-8718
        0x8A8C, # G+6971  U+8A8C  uni8A8C,  CJK UNIFIED IDEOGRAPH-8A8C
        0x8D04, # G+6972  U+8D04  uni8D04,  CJK UNIFIED IDEOGRAPH-8D04
        0x8DBE, # G+6973  U+8DBE  uni8DBE,  CJK UNIFIED IDEOGRAPH-8DBE
        0x9072, # G+6974  U+9072  uni9072,  CJK UNIFIED IDEOGRAPH-9072
        0x76F4, # G+6975  U+76F4  uni76F4,  CJK UNIFIED IDEOGRAPH-76F4
        0x7A19, # G+6976  U+7A19  uni7A19,  CJK UNIFIED IDEOGRAPH-7A19
        0x7A37, # G+6977  U+7A37  uni7A37,  CJK UNIFIED IDEOGRAPH-7A37
        0x7E54, # G+6978  U+7E54  uni7E54,  CJK UNIFIED IDEOGRAPH-7E54
        0x8077, # G+6979  U+8077  uni8077,  CJK UNIFIED IDEOGRAPH-8077
        0x5507, # G+6980  U+5507  uni5507,  CJK UNIFIED IDEOGRAPH-5507
        0x55D4, # G+6981  U+55D4  uni55D4,  CJK UNIFIED IDEOGRAPH-55D4
        0x5875, # G+6982  U+5875  uni5875,  CJK UNIFIED IDEOGRAPH-5875
        0x632F, # G+6983  U+632F  uni632F,  CJK UNIFIED IDEOGRAPH-632F
        0x6422, # G+6984  U+6422  uni6422,  CJK UNIFIED IDEOGRAPH-6422
        0x6649, # G+6985  U+6649  uni6649,  CJK UNIFIED IDEOGRAPH-6649
        0x664B, # G+6986  U+664B  uni664B,  CJK UNIFIED IDEOGRAPH-664B
        0x686D, # G+6987  U+686D  uni686D,  CJK UNIFIED IDEOGRAPH-686D
        0x699B, # G+6988  U+699B  uni699B,  CJK UNIFIED IDEOGRAPH-699B
        0x6B84, # G+6989  U+6B84  uni6B84,  CJK UNIFIED IDEOGRAPH-6B84
        0x6D25, # G+6990  U+6D25  uni6D25,  CJK UNIFIED IDEOGRAPH-6D25
        0x6EB1, # G+6991  U+6EB1  uni6EB1,  CJK UNIFIED IDEOGRAPH-6EB1
        0x73CD, # G+6992  U+73CD  uni73CD,  CJK UNIFIED IDEOGRAPH-73CD
        0x7468, # G+6993  U+7468  uni7468,  CJK UNIFIED IDEOGRAPH-7468
        0x74A1, # G+6994  U+74A1  uni74A1,  CJK UNIFIED IDEOGRAPH-74A1
        0x755B, # G+6995  U+755B  uni755B,  CJK UNIFIED IDEOGRAPH-755B
        0x75B9, # G+6996  U+75B9  uni75B9,  CJK UNIFIED IDEOGRAPH-75B9
        0x76E1, # G+6997  U+76E1  uni76E1,  CJK UNIFIED IDEOGRAPH-76E1
        0x771E, # G+6998  U+771E  uni771E,  CJK UNIFIED IDEOGRAPH-771E
        0x778B, # G+6999  U+778B  uni778B,  CJK UNIFIED IDEOGRAPH-778B
        0x79E6, # G+7000  U+79E6  uni79E6,  CJK UNIFIED IDEOGRAPH-79E6
        0x7E09, # G+7001  U+7E09  uni7E09,  CJK UNIFIED IDEOGRAPH-7E09
        0x7E1D, # G+7002  U+7E1D  uni7E1D,  CJK UNIFIED IDEOGRAPH-7E1D
        0x81FB, # G+7003  U+81FB  uni81FB,  CJK UNIFIED IDEOGRAPH-81FB
        0x852F, # G+7004  U+852F  uni852F,  CJK UNIFIED IDEOGRAPH-852F
        0x8897, # G+7005  U+8897  uni8897,  CJK UNIFIED IDEOGRAPH-8897
        0x8A3A, # G+7006  U+8A3A  uni8A3A,  CJK UNIFIED IDEOGRAPH-8A3A
        0x8CD1, # G+7007  U+8CD1  uni8CD1,  CJK UNIFIED IDEOGRAPH-8CD1
        0x8EEB, # G+7008  U+8EEB  uni8EEB,  CJK UNIFIED IDEOGRAPH-8EEB
        0x2FA0, # G+7009  U+2FA0  uni2FA0,  KANGXI RADICAL MORNING
        0x9032, # G+7010  U+9032  uni9032,  CJK UNIFIED IDEOGRAPH-9032
        0x93AD, # G+7011  U+93AD  uni93AD,  CJK UNIFIED IDEOGRAPH-93AD
        0x9663, # G+7012  U+9663  uni9663,  CJK UNIFIED IDEOGRAPH-9663
        0x9673, # G+7013  U+9673  uni9673,  CJK UNIFIED IDEOGRAPH-9673
        0x9707, # G+7014  U+9707  uni9707,  CJK UNIFIED IDEOGRAPH-9707
        0x4F84, # G+7015  U+4F84  uni4F84,  CJK UNIFIED IDEOGRAPH-4F84
        0x53F1, # G+7016  U+53F1  uni53F1,  CJK UNIFIED IDEOGRAPH-53F1
        0x59EA, # G+7017  U+59EA  uni59EA,  CJK UNIFIED IDEOGRAPH-59EA
        0x5AC9, # G+7018  U+5AC9  uni5AC9,  CJK UNIFIED IDEOGRAPH-5AC9
        0x5E19, # G+7019  U+5E19  uni5E19,  CJK UNIFIED IDEOGRAPH-5E19
        0x684E, # G+7020  U+684E  uni684E,  CJK UNIFIED IDEOGRAPH-684E
        0x74C6, # G+7021  U+74C6  uni74C6,  CJK UNIFIED IDEOGRAPH-74C6
        0x75BE, # G+7022  U+75BE  uni75BE,  CJK UNIFIED IDEOGRAPH-75BE
        0x79E9, # G+7023  U+79E9  uni79E9,  CJK UNIFIED IDEOGRAPH-79E9
        0x7A92, # G+7024  U+7A92  uni7A92,  CJK UNIFIED IDEOGRAPH-7A92
        0x81A3, # G+7025  U+81A3  uni81A3,  CJK UNIFIED IDEOGRAPH-81A3
        0x86ED, # G+7026  U+86ED  uni86ED,  CJK UNIFIED IDEOGRAPH-86ED
        0x8CEA, # G+7027  U+8CEA  uni8CEA,  CJK UNIFIED IDEOGRAPH-8CEA
        0x8DCC, # G+7028  U+8DCC  uni8DCC,  CJK UNIFIED IDEOGRAPH-8DCC
        0x8FED, # G+7029  U+8FED  uni8FED,  CJK UNIFIED IDEOGRAPH-8FED
        0x659F, # G+7030  U+659F  uni659F,  CJK UNIFIED IDEOGRAPH-659F
        0x6715, # G+7031  U+6715  uni6715,  CJK UNIFIED IDEOGRAPH-6715
        0x57F7, # G+7032  U+57F7  uni57F7,  CJK UNIFIED IDEOGRAPH-57F7
        0x6F57, # G+7033  U+6F57  uni6F57,  CJK UNIFIED IDEOGRAPH-6F57
        0x7DDD, # G+7034  U+7DDD  uni7DDD,  CJK UNIFIED IDEOGRAPH-7DDD
        0x8F2F, # G+7035  U+8F2F  uni8F2F,  CJK UNIFIED IDEOGRAPH-8F2F
        0x93F6, # G+7036  U+93F6  uni93F6,  CJK UNIFIED IDEOGRAPH-93F6
        0x96C6, # G+7037  U+96C6  uni96C6,  CJK UNIFIED IDEOGRAPH-96C6
        0x5FB5, # G+7038  U+5FB5  uni5FB5,  CJK UNIFIED IDEOGRAPH-5FB5
        0x61F2, # G+7039  U+61F2  uni61F2,  CJK UNIFIED IDEOGRAPH-61F2
        0x6F84, # G+7040  U+6F84  uni6F84,  CJK UNIFIED IDEOGRAPH-6F84
        0x4E14, # G+7041  U+4E14  uni4E14,  CJK UNIFIED IDEOGRAPH-4E14
        0x4F98, # G+7042  U+4F98  uni4F98,  CJK UNIFIED IDEOGRAPH-4F98
        0x501F, # G+7043  U+501F  uni501F,  CJK UNIFIED IDEOGRAPH-501F
        0x53C9, # G+7044  U+53C9  uni53C9,  CJK UNIFIED IDEOGRAPH-53C9
        0x55DF, # G+7045  U+55DF  uni55DF,  CJK UNIFIED IDEOGRAPH-55DF
        0x5D6F, # G+7046  U+5D6F  uni5D6F,  CJK UNIFIED IDEOGRAPH-5D6F
        0x5DEE, # G+7047  U+5DEE  uni5DEE,  CJK UNIFIED IDEOGRAPH-5DEE
        0x6B21, # G+7048  U+6B21  uni6B21,  CJK UNIFIED IDEOGRAPH-6B21
        0x6B64, # G+7049  U+6B64  uni6B64,  CJK UNIFIED IDEOGRAPH-6B64
        0x78CB, # G+7050  U+78CB  uni78CB,  CJK UNIFIED IDEOGRAPH-78CB
        0x7B9A, # G+7051  U+7B9A  uni7B9A,  CJK UNIFIED IDEOGRAPH-7B9A
        0x8E49, # G+7052  U+8E49  uni8E49,  CJK UNIFIED IDEOGRAPH-8E49
        0x2F9E, # G+7053  U+2F9E  uni2F9E,  KANGXI RADICAL CART
        0x906E, # G+7054  U+906E  uni906E,  CJK UNIFIED IDEOGRAPH-906E
        0x6349, # G+7055  U+6349  uni6349,  CJK UNIFIED IDEOGRAPH-6349
        0x643E, # G+7056  U+643E  uni643E,  CJK UNIFIED IDEOGRAPH-643E
        0x7740, # G+7057  U+7740  uni7740,  CJK UNIFIED IDEOGRAPH-7740
        0x7A84, # G+7058  U+7A84  uni7A84,  CJK UNIFIED IDEOGRAPH-7A84
        0x932F, # G+7059  U+932F  uni932F,  CJK UNIFIED IDEOGRAPH-932F
        0x947F, # G+7060  U+947F  uni947F,  CJK UNIFIED IDEOGRAPH-947F
        0x9F6A, # G+7061  U+9F6A  uni9F6A,  CJK UNIFIED IDEOGRAPH-9F6A
        0x64B0, # G+7062  U+64B0  uni64B0,  CJK UNIFIED IDEOGRAPH-64B0
        0x6FAF, # G+7063  U+6FAF  uni6FAF,  CJK UNIFIED IDEOGRAPH-6FAF
        0x71E6, # G+7064  U+71E6  uni71E6,  CJK UNIFIED IDEOGRAPH-71E6
        0x74A8, # G+7065  U+74A8  uni74A8,  CJK UNIFIED IDEOGRAPH-74A8
        0x74DA, # G+7066  U+74DA  uni74DA,  CJK UNIFIED IDEOGRAPH-74DA
        0x7AC4, # G+7067  U+7AC4  uni7AC4,  CJK UNIFIED IDEOGRAPH-7AC4
        0x7C12, # G+7068  U+7C12  uni7C12,  CJK UNIFIED IDEOGRAPH-7C12
        0x7E82, # G+7069  U+7E82  uni7E82,  CJK UNIFIED IDEOGRAPH-7E82
        0x7CB2, # G+7070  U+7CB2  uni7CB2,  CJK UNIFIED IDEOGRAPH-7CB2
        0x7E98, # G+7071  U+7E98  uni7E98,  CJK UNIFIED IDEOGRAPH-7E98
        0x8B9A, # G+7072  U+8B9A  uni8B9A,  CJK UNIFIED IDEOGRAPH-8B9A
        0x8D0A, # G+7073  U+8D0A  uni8D0A,  CJK UNIFIED IDEOGRAPH-8D0A
        0x947D, # G+7074  U+947D  uni947D,  CJK UNIFIED IDEOGRAPH-947D
        0x9910, # G+7075  U+9910  uni9910,  CJK UNIFIED IDEOGRAPH-9910
        0x994C, # G+7076  U+994C  uni994C,  CJK UNIFIED IDEOGRAPH-994C
        0x5239, # G+7077  U+5239  uni5239,  CJK UNIFIED IDEOGRAPH-5239
        0x5BDF, # G+7078  U+5BDF  uni5BDF,  CJK UNIFIED IDEOGRAPH-5BDF
        0x64E6, # G+7079  U+64E6  uni64E6,  CJK UNIFIED IDEOGRAPH-64E6
        0x672D, # G+7080  U+672D  uni672D,  CJK UNIFIED IDEOGRAPH-672D
        0x7D2E, # G+7081  U+7D2E  uni7D2E,  CJK UNIFIED IDEOGRAPH-7D2E
        0x50ED, # G+7082  U+50ED  uni50ED,  CJK UNIFIED IDEOGRAPH-50ED
        0x53C3, # G+7083  U+53C3  uni53C3,  CJK UNIFIED IDEOGRAPH-53C3
        0x5879, # G+7084  U+5879  uni5879,  CJK UNIFIED IDEOGRAPH-5879
        0x6158, # G+7085  U+6158  uni6158,  CJK UNIFIED IDEOGRAPH-6158
        0x6159, # G+7086  U+6159  uni6159,  CJK UNIFIED IDEOGRAPH-6159
        0x61FA, # G+7087  U+61FA  uni61FA,  CJK UNIFIED IDEOGRAPH-61FA
        0x65AC, # G+7088  U+65AC  uni65AC,  CJK UNIFIED IDEOGRAPH-65AC
        0x7AD9, # G+7089  U+7AD9  uni7AD9,  CJK UNIFIED IDEOGRAPH-7AD9
        0x8B92, # G+7090  U+8B92  uni8B92,  CJK UNIFIED IDEOGRAPH-8B92
        0x8B96, # G+7091  U+8B96  uni8B96,  CJK UNIFIED IDEOGRAPH-8B96
        0x5009, # G+7092  U+5009  uni5009,  CJK UNIFIED IDEOGRAPH-5009
        0x5021, # G+7093  U+5021  uni5021,  CJK UNIFIED IDEOGRAPH-5021
        0x5275, # G+7094  U+5275  uni5275,  CJK UNIFIED IDEOGRAPH-5275
        0x5531, # G+7095  U+5531  uni5531,  CJK UNIFIED IDEOGRAPH-5531
        0x5A3C, # G+7096  U+5A3C  uni5A3C,  CJK UNIFIED IDEOGRAPH-5A3C
        0x5EE0, # G+7097  U+5EE0  uni5EE0,  CJK UNIFIED IDEOGRAPH-5EE0
        0x5F70, # G+7098  U+5F70  uni5F70,  CJK UNIFIED IDEOGRAPH-5F70
        0x6134, # G+7099  U+6134  uni6134,  CJK UNIFIED IDEOGRAPH-6134
        0x655E, # G+7100  U+655E  uni655E,  CJK UNIFIED IDEOGRAPH-655E
        0x660C, # G+7101  U+660C  uni660C,  CJK UNIFIED IDEOGRAPH-660C
        0x6636, # G+7102  U+6636  uni6636,  CJK UNIFIED IDEOGRAPH-6636
        0x66A2, # G+7103  U+66A2  uni66A2,  CJK UNIFIED IDEOGRAPH-66A2
        0x69CD, # G+7104  U+69CD  uni69CD,  CJK UNIFIED IDEOGRAPH-69CD
        0x6EC4, # G+7105  U+6EC4  uni6EC4,  CJK UNIFIED IDEOGRAPH-6EC4
        0x6F32, # G+7106  U+6F32  uni6F32,  CJK UNIFIED IDEOGRAPH-6F32
        0x7316, # G+7107  U+7316  uni7316,  CJK UNIFIED IDEOGRAPH-7316
        0x7621, # G+7108  U+7621  uni7621,  CJK UNIFIED IDEOGRAPH-7621
        0x7A93, # G+7109  U+7A93  uni7A93,  CJK UNIFIED IDEOGRAPH-7A93
        0x8139, # G+7110  U+8139  uni8139,  CJK UNIFIED IDEOGRAPH-8139
        0x8259, # G+7111  U+8259  uni8259,  CJK UNIFIED IDEOGRAPH-8259
        0x83D6, # G+7112  U+83D6  uni83D6,  CJK UNIFIED IDEOGRAPH-83D6
        0x84BC, # G+7113  U+84BC  uni84BC,  CJK UNIFIED IDEOGRAPH-84BC
        0x50B5, # G+7114  U+50B5  uni50B5,  CJK UNIFIED IDEOGRAPH-50B5
        0x57F0, # G+7115  U+57F0  uni57F0,  CJK UNIFIED IDEOGRAPH-57F0
        0x5BC0, # G+7116  U+5BC0  uni5BC0,  CJK UNIFIED IDEOGRAPH-5BC0
        0x5BE8, # G+7117  U+5BE8  uni5BE8,  CJK UNIFIED IDEOGRAPH-5BE8
        0x5F69, # G+7118  U+5F69  uni5F69,  CJK UNIFIED IDEOGRAPH-5F69
        0x63A1, # G+7119  U+63A1  uni63A1,  CJK UNIFIED IDEOGRAPH-63A1
        0x7826, # G+7120  U+7826  uni7826,  CJK UNIFIED IDEOGRAPH-7826
        0x7DB5, # G+7121  U+7DB5  uni7DB5,  CJK UNIFIED IDEOGRAPH-7DB5
        0x83DC, # G+7122  U+83DC  uni83DC,  CJK UNIFIED IDEOGRAPH-83DC
        0x8521, # G+7123  U+8521  uni8521,  CJK UNIFIED IDEOGRAPH-8521
        0x91C7, # G+7124  U+91C7  uni91C7,  CJK UNIFIED IDEOGRAPH-91C7
        0x91F5, # G+7125  U+91F5  uni91F5,  CJK UNIFIED IDEOGRAPH-91F5
        0x518A, # G+7126  U+518A  uni518A,  CJK UNIFIED IDEOGRAPH-518A
        0x67F5, # G+7127  U+67F5  uni67F5,  CJK UNIFIED IDEOGRAPH-67F5
        0x7B56, # G+7128  U+7B56  uni7B56,  CJK UNIFIED IDEOGRAPH-7B56
        0x8CAC, # G+7129  U+8CAC  uni8CAC,  CJK UNIFIED IDEOGRAPH-8CAC
        0x51C4, # G+7130  U+51C4  uni51C4,  CJK UNIFIED IDEOGRAPH-51C4
        0x59BB, # G+7131  U+59BB  uni59BB,  CJK UNIFIED IDEOGRAPH-59BB
        0x60BD, # G+7132  U+60BD  uni60BD,  CJK UNIFIED IDEOGRAPH-60BD
        0x8655, # G+7133  U+8655  uni8655,  CJK UNIFIED IDEOGRAPH-8655
        0x501C, # G+7134  U+501C  uni501C,  CJK UNIFIED IDEOGRAPH-501C
        0x5254, # G+7135  U+5254  uni5254,  CJK UNIFIED IDEOGRAPH-5254
        0x5C3A, # G+7136  U+5C3A  uni5C3A,  CJK UNIFIED IDEOGRAPH-5C3A
        0x617D, # G+7137  U+617D  uni617D,  CJK UNIFIED IDEOGRAPH-617D
        0x621A, # G+7138  U+621A  uni621A,  CJK UNIFIED IDEOGRAPH-621A
        0x62D3, # G+7139  U+62D3  uni62D3,  CJK UNIFIED IDEOGRAPH-62D3
        0x64F2, # G+7140  U+64F2  uni64F2,  CJK UNIFIED IDEOGRAPH-64F2
        0x65A5, # G+7141  U+65A5  uni65A5,  CJK UNIFIED IDEOGRAPH-65A5
        0x6ECC, # G+7142  U+6ECC  uni6ECC,  CJK UNIFIED IDEOGRAPH-6ECC
        0x7620, # G+7143  U+7620  uni7620,  CJK UNIFIED IDEOGRAPH-7620
        0x810A, # G+7144  U+810A  uni810A,  CJK UNIFIED IDEOGRAPH-810A
        0x8E60, # G+7145  U+8E60  uni8E60,  CJK UNIFIED IDEOGRAPH-8E60
        0x965F, # G+7146  U+965F  uni965F,  CJK UNIFIED IDEOGRAPH-965F
        0x96BB, # G+7147  U+96BB  uni96BB,  CJK UNIFIED IDEOGRAPH-96BB
        0x4EDF, # G+7148  U+4EDF  uni4EDF,  CJK UNIFIED IDEOGRAPH-4EDF
        0x5343, # G+7149  U+5343  uni5343,  CJK UNIFIED IDEOGRAPH-5343
        0x5598, # G+7150  U+5598  uni5598,  CJK UNIFIED IDEOGRAPH-5598
        0x5929, # G+7151  U+5929  uni5929,  CJK UNIFIED IDEOGRAPH-5929
        0x5DDD, # G+7152  U+5DDD  uni5DDD,  CJK UNIFIED IDEOGRAPH-5DDD
        0x64C5, # G+7153  U+64C5  uni64C5,  CJK UNIFIED IDEOGRAPH-64C5
        0x6CC9, # G+7154  U+6CC9  uni6CC9,  CJK UNIFIED IDEOGRAPH-6CC9
        0x6DFA, # G+7155  U+6DFA  uni6DFA,  CJK UNIFIED IDEOGRAPH-6DFA
        0x7394, # G+7156  U+7394  uni7394,  CJK UNIFIED IDEOGRAPH-7394
        0x7A7F, # G+7157  U+7A7F  uni7A7F,  CJK UNIFIED IDEOGRAPH-7A7F
        0x2F87, # G+7158  U+2F87  uni2F87,  KANGXI RADICAL OPPOSE
        0x85A6, # G+7159  U+85A6  uni85A6,  CJK UNIFIED IDEOGRAPH-85A6
        0x8CE4, # G+7160  U+8CE4  uni8CE4,  CJK UNIFIED IDEOGRAPH-8CE4
        0x8E10, # G+7161  U+8E10  uni8E10,  CJK UNIFIED IDEOGRAPH-8E10
        0x9077, # G+7162  U+9077  uni9077,  CJK UNIFIED IDEOGRAPH-9077
        0x91E7, # G+7163  U+91E7  uni91E7,  CJK UNIFIED IDEOGRAPH-91E7
        0x95E1, # G+7164  U+95E1  uni95E1,  CJK UNIFIED IDEOGRAPH-95E1
        0x9621, # G+7165  U+9621  uni9621,  CJK UNIFIED IDEOGRAPH-9621
        0x97C6, # G+7166  U+97C6  uni97C6,  CJK UNIFIED IDEOGRAPH-97C6
        0x51F8, # G+7167  U+51F8  uni51F8,  CJK UNIFIED IDEOGRAPH-51F8
        0x54F2, # G+7168  U+54F2  uni54F2,  CJK UNIFIED IDEOGRAPH-54F2
        0x5586, # G+7169  U+5586  uni5586,  CJK UNIFIED IDEOGRAPH-5586
        0x5FB9, # G+7170  U+5FB9  uni5FB9,  CJK UNIFIED IDEOGRAPH-5FB9
        0x64A4, # G+7171  U+64A4  uni64A4,  CJK UNIFIED IDEOGRAPH-64A4
        0x6F88, # G+7172  U+6F88  uni6F88,  CJK UNIFIED IDEOGRAPH-6F88
        0x7DB4, # G+7173  U+7DB4  uni7DB4,  CJK UNIFIED IDEOGRAPH-7DB4
        0x8F1F, # G+7174  U+8F1F  uni8F1F,  CJK UNIFIED IDEOGRAPH-8F1F
        0x8F4D, # G+7175  U+8F4D  uni8F4D,  CJK UNIFIED IDEOGRAPH-8F4D
        0x9435, # G+7176  U+9435  uni9435,  CJK UNIFIED IDEOGRAPH-9435
        0x50C9, # G+7177  U+50C9  uni50C9,  CJK UNIFIED IDEOGRAPH-50C9
        0x5C16, # G+7178  U+5C16  uni5C16,  CJK UNIFIED IDEOGRAPH-5C16
        0x6CBE, # G+7179  U+6CBE  uni6CBE,  CJK UNIFIED IDEOGRAPH-6CBE
        0x6DFB, # G+7180  U+6DFB  uni6DFB,  CJK UNIFIED IDEOGRAPH-6DFB
        0x751B, # G+7181  U+751B  uni751B,  CJK UNIFIED IDEOGRAPH-751B
        0x77BB, # G+7182  U+77BB  uni77BB,  CJK UNIFIED IDEOGRAPH-77BB
        0x7C3D, # G+7183  U+7C3D  uni7C3D,  CJK UNIFIED IDEOGRAPH-7C3D
        0x7C64, # G+7184  U+7C64  uni7C64,  CJK UNIFIED IDEOGRAPH-7C64
        0x8A79, # G+7185  U+8A79  uni8A79,  CJK UNIFIED IDEOGRAPH-8A79
        0x8AC2, # G+7186  U+8AC2  uni8AC2,  CJK UNIFIED IDEOGRAPH-8AC2
        0x581E, # G+7187  U+581E  uni581E,  CJK UNIFIED IDEOGRAPH-581E
        0x59BE, # G+7188  U+59BE  uni59BE,  CJK UNIFIED IDEOGRAPH-59BE
        0x5E16, # G+7189  U+5E16  uni5E16,  CJK UNIFIED IDEOGRAPH-5E16
        0x6377, # G+7190  U+6377  uni6377,  CJK UNIFIED IDEOGRAPH-6377
        0x7252, # G+7191  U+7252  uni7252,  CJK UNIFIED IDEOGRAPH-7252
        0x758A, # G+7192  U+758A  uni758A,  CJK UNIFIED IDEOGRAPH-758A
        0x776B, # G+7193  U+776B  uni776B,  CJK UNIFIED IDEOGRAPH-776B
        0x8ADC, # G+7194  U+8ADC  uni8ADC,  CJK UNIFIED IDEOGRAPH-8ADC
        0x8CBC, # G+7195  U+8CBC  uni8CBC,  CJK UNIFIED IDEOGRAPH-8CBC
        0x8F12, # G+7196  U+8F12  uni8F12,  CJK UNIFIED IDEOGRAPH-8F12
        0x5EF3, # G+7197  U+5EF3  uni5EF3,  CJK UNIFIED IDEOGRAPH-5EF3
        0x6674, # G+7198  U+6674  uni6674,  CJK UNIFIED IDEOGRAPH-6674
        0x6DF8, # G+7199  U+6DF8  uni6DF8,  CJK UNIFIED IDEOGRAPH-6DF8
        0x807D, # G+7200  U+807D  uni807D,  CJK UNIFIED IDEOGRAPH-807D
        0x83C1, # G+7201  U+83C1  uni83C1,  CJK UNIFIED IDEOGRAPH-83C1
        0x8ACB, # G+7202  U+8ACB  uni8ACB,  CJK UNIFIED IDEOGRAPH-8ACB
        0x2FAD, # G+7203  U+2FAD  uni2FAD,  KANGXI RADICAL BLUE
        0x9BD6, # G+7204  U+9BD6  uni9BD6,  CJK UNIFIED IDEOGRAPH-9BD6
        0x5243, # G+7205  U+5243  uni5243,  CJK UNIFIED IDEOGRAPH-5243
        0x66FF, # G+7206  U+66FF  uni66FF,  CJK UNIFIED IDEOGRAPH-66FF
        0x6D95, # G+7207  U+6D95  uni6D95,  CJK UNIFIED IDEOGRAPH-6D95
        0x6EEF, # G+7208  U+6EEF  uni6EEF,  CJK UNIFIED IDEOGRAPH-6EEF
        0x7DE0, # G+7209  U+7DE0  uni7DE0,  CJK UNIFIED IDEOGRAPH-7DE0
        0x8AE6, # G+7210  U+8AE6  uni8AE6,  CJK UNIFIED IDEOGRAPH-8AE6
        0x902E, # G+7211  U+902E  uni902E,  CJK UNIFIED IDEOGRAPH-902E
        0x905E, # G+7212  U+905E  uni905E,  CJK UNIFIED IDEOGRAPH-905E
        0x9AD4, # G+7213  U+9AD4  uni9AD4,  CJK UNIFIED IDEOGRAPH-9AD4
        0x521D, # G+7214  U+521D  uni521D,  CJK UNIFIED IDEOGRAPH-521D
        0x527F, # G+7215  U+527F  uni527F,  CJK UNIFIED IDEOGRAPH-527F
        0x54E8, # G+7216  U+54E8  uni54E8,  CJK UNIFIED IDEOGRAPH-54E8
        0x6194, # G+7217  U+6194  uni6194,  CJK UNIFIED IDEOGRAPH-6194
        0x6284, # G+7218  U+6284  uni6284,  CJK UNIFIED IDEOGRAPH-6284
        0x62DB, # G+7219  U+62DB  uni62DB,  CJK UNIFIED IDEOGRAPH-62DB
        0x68A2, # G+7220  U+68A2  uni68A2,  CJK UNIFIED IDEOGRAPH-68A2
        0x6912, # G+7221  U+6912  uni6912,  CJK UNIFIED IDEOGRAPH-6912
        0x695A, # G+7222  U+695A  uni695A,  CJK UNIFIED IDEOGRAPH-695A
        0x6A35, # G+7223  U+6A35  uni6A35,  CJK UNIFIED IDEOGRAPH-6A35
        0x7092, # G+7224  U+7092  uni7092,  CJK UNIFIED IDEOGRAPH-7092
        0x7126, # G+7225  U+7126  uni7126,  CJK UNIFIED IDEOGRAPH-7126
        0x785D, # G+7226  U+785D  uni785D,  CJK UNIFIED IDEOGRAPH-785D
        0x7901, # G+7227  U+7901  uni7901,  CJK UNIFIED IDEOGRAPH-7901
        0x790E, # G+7228  U+790E  uni790E,  CJK UNIFIED IDEOGRAPH-790E
        0x79D2, # G+7229  U+79D2  uni79D2,  CJK UNIFIED IDEOGRAPH-79D2
        0x7A0D, # G+7230  U+7A0D  uni7A0D,  CJK UNIFIED IDEOGRAPH-7A0D
        0x8096, # G+7231  U+8096  uni8096,  CJK UNIFIED IDEOGRAPH-8096
        0x2F8B, # G+7232  U+2F8B  uni2F8B,  KANGXI RADICAL GRASS
        0x82D5, # G+7233  U+82D5  uni82D5,  CJK UNIFIED IDEOGRAPH-82D5
        0x8349, # G+7234  U+8349  uni8349,  CJK UNIFIED IDEOGRAPH-8349
        0x8549, # G+7235  U+8549  uni8549,  CJK UNIFIED IDEOGRAPH-8549
        0x8C82, # G+7236  U+8C82  uni8C82,  CJK UNIFIED IDEOGRAPH-8C82
        0x8D85, # G+7237  U+8D85  uni8D85,  CJK UNIFIED IDEOGRAPH-8D85
        0x9162, # G+7238  U+9162  uni9162,  CJK UNIFIED IDEOGRAPH-9162
        0x918B, # G+7239  U+918B  uni918B,  CJK UNIFIED IDEOGRAPH-918B
        0x91AE, # G+7240  U+91AE  uni91AE,  CJK UNIFIED IDEOGRAPH-91AE
        0x4FC3, # G+7241  U+4FC3  uni4FC3,  CJK UNIFIED IDEOGRAPH-4FC3
        0x56D1, # G+7242  U+56D1  uni56D1,  CJK UNIFIED IDEOGRAPH-56D1
        0x71ED, # G+7243  U+71ED  uni71ED,  CJK UNIFIED IDEOGRAPH-71ED
        0x77D7, # G+7244  U+77D7  uni77D7,  CJK UNIFIED IDEOGRAPH-77D7
        0x8700, # G+7245  U+8700  uni8700,  CJK UNIFIED IDEOGRAPH-8700
        0x89F8, # G+7246  U+89F8  uni89F8,  CJK UNIFIED IDEOGRAPH-89F8
        0x2F28, # G+7247  U+2F28  uni2F28,  KANGXI RADICAL INCH
        0x5FD6, # G+7248  U+5FD6  uni5FD6,  CJK UNIFIED IDEOGRAPH-5FD6
        0x6751, # G+7249  U+6751  uni6751,  CJK UNIFIED IDEOGRAPH-6751
        0x90A8, # G+7250  U+90A8  uni90A8,  CJK UNIFIED IDEOGRAPH-90A8
        0x53E2, # G+7251  U+53E2  uni53E2,  CJK UNIFIED IDEOGRAPH-53E2
        0x585A, # G+7252  U+585A  uni585A,  CJK UNIFIED IDEOGRAPH-585A
        0x5BF5, # G+7253  U+5BF5  uni5BF5,  CJK UNIFIED IDEOGRAPH-5BF5
        0x60A4, # G+7254  U+60A4  uni60A4,  CJK UNIFIED IDEOGRAPH-60A4
        0x6181, # G+7255  U+6181  uni6181,  CJK UNIFIED IDEOGRAPH-6181
        0x6460, # G+7256  U+6460  uni6460,  CJK UNIFIED IDEOGRAPH-6460
        0x7E3D, # G+7257  U+7E3D  uni7E3D,  CJK UNIFIED IDEOGRAPH-7E3D
        0x8070, # G+7258  U+8070  uni8070,  CJK UNIFIED IDEOGRAPH-8070
        0x8525, # G+7259  U+8525  uni8525,  CJK UNIFIED IDEOGRAPH-8525
        0x9283, # G+7260  U+9283  uni9283,  CJK UNIFIED IDEOGRAPH-9283
        0x64AE, # G+7261  U+64AE  uni64AE,  CJK UNIFIED IDEOGRAPH-64AE
        0x50AC, # G+7262  U+50AC  uni50AC,  CJK UNIFIED IDEOGRAPH-50AC
        0x5D14, # G+7263  U+5D14  uni5D14,  CJK UNIFIED IDEOGRAPH-5D14
        0x6700, # G+7264  U+6700  uni6700,  CJK UNIFIED IDEOGRAPH-6700
        0x589C, # G+7265  U+589C  uni589C,  CJK UNIFIED IDEOGRAPH-589C
        0x62BD, # G+7266  U+62BD  uni62BD,  CJK UNIFIED IDEOGRAPH-62BD
        0x63A8, # G+7267  U+63A8  uni63A8,  CJK UNIFIED IDEOGRAPH-63A8
        0x690E, # G+7268  U+690E  uni690E,  CJK UNIFIED IDEOGRAPH-690E
        0x6978, # G+7269  U+6978  uni6978,  CJK UNIFIED IDEOGRAPH-6978
        0x6A1E, # G+7270  U+6A1E  uni6A1E,  CJK UNIFIED IDEOGRAPH-6A1E
        0x6E6B, # G+7271  U+6E6B  uni6E6B,  CJK UNIFIED IDEOGRAPH-6E6B
        0x76BA, # G+7272  U+76BA  uni76BA,  CJK UNIFIED IDEOGRAPH-76BA
        0x79CB, # G+7273  U+79CB  uni79CB,  CJK UNIFIED IDEOGRAPH-79CB
        0x82BB, # G+7274  U+82BB  uni82BB,  CJK UNIFIED IDEOGRAPH-82BB
        0x8429, # G+7275  U+8429  uni8429,  CJK UNIFIED IDEOGRAPH-8429
        0x8ACF, # G+7276  U+8ACF  uni8ACF,  CJK UNIFIED IDEOGRAPH-8ACF
        0x8DA8, # G+7277  U+8DA8  uni8DA8,  CJK UNIFIED IDEOGRAPH-8DA8
        0x8FFD, # G+7278  U+8FFD  uni8FFD,  CJK UNIFIED IDEOGRAPH-8FFD
        0x9112, # G+7279  U+9112  uni9112,  CJK UNIFIED IDEOGRAPH-9112
        0x914B, # G+7280  U+914B  uni914B,  CJK UNIFIED IDEOGRAPH-914B
        0x919C, # G+7281  U+919C  uni919C,  CJK UNIFIED IDEOGRAPH-919C
        0x9310, # G+7282  U+9310  uni9310,  CJK UNIFIED IDEOGRAPH-9310
        0x9318, # G+7283  U+9318  uni9318,  CJK UNIFIED IDEOGRAPH-9318
        0x939A, # G+7284  U+939A  uni939A,  CJK UNIFIED IDEOGRAPH-939A
        0x96DB, # G+7285  U+96DB  uni96DB,  CJK UNIFIED IDEOGRAPH-96DB
        0x9A36, # G+7286  U+9A36  uni9A36,  CJK UNIFIED IDEOGRAPH-9A36
        0x9C0D, # G+7287  U+9C0D  uni9C0D,  CJK UNIFIED IDEOGRAPH-9C0D
        0x4E11, # G+7288  U+4E11  uni4E11,  CJK UNIFIED IDEOGRAPH-4E11
        0x755C, # G+7289  U+755C  uni755C,  CJK UNIFIED IDEOGRAPH-755C
        0x795D, # G+7290  U+795D  uni795D,  CJK UNIFIED IDEOGRAPH-795D
        0x7AFA, # G+7291  U+7AFA  uni7AFA,  CJK UNIFIED IDEOGRAPH-7AFA
        0x7B51, # G+7292  U+7B51  uni7B51,  CJK UNIFIED IDEOGRAPH-7B51
        0x7BC9, # G+7293  U+7BC9  uni7BC9,  CJK UNIFIED IDEOGRAPH-7BC9
        0x7E2E, # G+7294  U+7E2E  uni7E2E,  CJK UNIFIED IDEOGRAPH-7E2E
        0x84C4, # G+7295  U+84C4  uni84C4,  CJK UNIFIED IDEOGRAPH-84C4
        0x8E59, # G+7296  U+8E59  uni8E59,  CJK UNIFIED IDEOGRAPH-8E59
        0x8E74, # G+7297  U+8E74  uni8E74,  CJK UNIFIED IDEOGRAPH-8E74
        0x8EF8, # G+7298  U+8EF8  uni8EF8,  CJK UNIFIED IDEOGRAPH-8EF8
        0x9010, # G+7299  U+9010  uni9010,  CJK UNIFIED IDEOGRAPH-9010
        0x6625, # G+7300  U+6625  uni6625,  CJK UNIFIED IDEOGRAPH-6625
        0x693F, # G+7301  U+693F  uni693F,  CJK UNIFIED IDEOGRAPH-693F
        0x7443, # G+7302  U+7443  uni7443,  CJK UNIFIED IDEOGRAPH-7443
        0x51FA, # G+7303  U+51FA  uni51FA,  CJK UNIFIED IDEOGRAPH-51FA
        0x672E, # G+7304  U+672E  uni672E,  CJK UNIFIED IDEOGRAPH-672E
        0x9EDC, # G+7305  U+9EDC  uni9EDC,  CJK UNIFIED IDEOGRAPH-9EDC
        0x5145, # G+7306  U+5145  uni5145,  CJK UNIFIED IDEOGRAPH-5145
        0x5FE0, # G+7307  U+5FE0  uni5FE0,  CJK UNIFIED IDEOGRAPH-5FE0
        0x6C96, # G+7308  U+6C96  uni6C96,  CJK UNIFIED IDEOGRAPH-6C96
        0x87F2, # G+7309  U+87F2  uni87F2,  CJK UNIFIED IDEOGRAPH-87F2
        0x885D, # G+7310  U+885D  uni885D,  CJK UNIFIED IDEOGRAPH-885D
        0x8877, # G+7311  U+8877  uni8877,  CJK UNIFIED IDEOGRAPH-8877
        0x60B4, # G+7312  U+60B4  uni60B4,  CJK UNIFIED IDEOGRAPH-60B4
        0x81B5, # G+7313  U+81B5  uni81B5,  CJK UNIFIED IDEOGRAPH-81B5
        0x8403, # G+7314  U+8403  uni8403,  CJK UNIFIED IDEOGRAPH-8403
        0x8D05, # G+7315  U+8D05  uni8D05,  CJK UNIFIED IDEOGRAPH-8D05
        0x53D6, # G+7316  U+53D6  uni53D6,  CJK UNIFIED IDEOGRAPH-53D6
        0x5439, # G+7317  U+5439  uni5439,  CJK UNIFIED IDEOGRAPH-5439
        0x5634, # G+7318  U+5634  uni5634,  CJK UNIFIED IDEOGRAPH-5634
        0x5A36, # G+7319  U+5A36  uni5A36,  CJK UNIFIED IDEOGRAPH-5A36
        0x5C31, # G+7320  U+5C31  uni5C31,  CJK UNIFIED IDEOGRAPH-5C31
        0x708A, # G+7321  U+708A  uni708A,  CJK UNIFIED IDEOGRAPH-708A
        0x7FE0, # G+7322  U+7FE0  uni7FE0,  CJK UNIFIED IDEOGRAPH-7FE0
        0x805A, # G+7323  U+805A  uni805A,  CJK UNIFIED IDEOGRAPH-805A
        0x8106, # G+7324  U+8106  uni8106,  CJK UNIFIED IDEOGRAPH-8106
        0x81ED, # G+7325  U+81ED  uni81ED,  CJK UNIFIED IDEOGRAPH-81ED
        0x8DA3, # G+7326  U+8DA3  uni8DA3,  CJK UNIFIED IDEOGRAPH-8DA3
        0x9189, # G+7327  U+9189  uni9189,  CJK UNIFIED IDEOGRAPH-9189
        0x9A5F, # G+7328  U+9A5F  uni9A5F,  CJK UNIFIED IDEOGRAPH-9A5F
        0x9DF2, # G+7329  U+9DF2  uni9DF2,  CJK UNIFIED IDEOGRAPH-9DF2
        0x5074, # G+7330  U+5074  uni5074,  CJK UNIFIED IDEOGRAPH-5074
        0x4EC4, # G+7331  U+4EC4  uni4EC4,  CJK UNIFIED IDEOGRAPH-4EC4
        0x53A0, # G+7332  U+53A0  uni53A0,  CJK UNIFIED IDEOGRAPH-53A0
        0x60FB, # G+7333  U+60FB  uni60FB,  CJK UNIFIED IDEOGRAPH-60FB
        0x6E2C, # G+7334  U+6E2C  uni6E2C,  CJK UNIFIED IDEOGRAPH-6E2C
        0x5C64, # G+7335  U+5C64  uni5C64,  CJK UNIFIED IDEOGRAPH-5C64
        0x4F88, # G+7336  U+4F88  uni4F88,  CJK UNIFIED IDEOGRAPH-4F88
        0x5024, # G+7337  U+5024  uni5024,  CJK UNIFIED IDEOGRAPH-5024
        0x55E4, # G+7338  U+55E4  uni55E4,  CJK UNIFIED IDEOGRAPH-55E4
        0x5CD9, # G+7339  U+5CD9  uni5CD9,  CJK UNIFIED IDEOGRAPH-5CD9
        0x5E5F, # G+7340  U+5E5F  uni5E5F,  CJK UNIFIED IDEOGRAPH-5E5F
        0x6065, # G+7341  U+6065  uni6065,  CJK UNIFIED IDEOGRAPH-6065
        0x6894, # G+7342  U+6894  uni6894,  CJK UNIFIED IDEOGRAPH-6894
        0x6CBB, # G+7343  U+6CBB  uni6CBB,  CJK UNIFIED IDEOGRAPH-6CBB
        0x6DC4, # G+7344  U+6DC4  uni6DC4,  CJK UNIFIED IDEOGRAPH-6DC4
        0x71BE, # G+7345  U+71BE  uni71BE,  CJK UNIFIED IDEOGRAPH-71BE
        0x75D4, # G+7346  U+75D4  uni75D4,  CJK UNIFIED IDEOGRAPH-75D4
        0x75F4, # G+7347  U+75F4  uni75F4,  CJK UNIFIED IDEOGRAPH-75F4
        0x7661, # G+7348  U+7661  uni7661,  CJK UNIFIED IDEOGRAPH-7661
        0x7A1A, # G+7349  U+7A1A  uni7A1A,  CJK UNIFIED IDEOGRAPH-7A1A
        0x7A49, # G+7350  U+7A49  uni7A49,  CJK UNIFIED IDEOGRAPH-7A49
        0x7DC7, # G+7351  U+7DC7  uni7DC7,  CJK UNIFIED IDEOGRAPH-7DC7
        0x7DFB, # G+7352  U+7DFB  uni7DFB,  CJK UNIFIED IDEOGRAPH-7DFB
        0x7F6E, # G+7353  U+7F6E  uni7F6E,  CJK UNIFIED IDEOGRAPH-7F6E
        0x81F4, # G+7354  U+81F4  uni81F4,  CJK UNIFIED IDEOGRAPH-81F4
        0x86A9, # G+7355  U+86A9  uni86A9,  CJK UNIFIED IDEOGRAPH-86A9
        0x8F1C, # G+7356  U+8F1C  uni8F1C,  CJK UNIFIED IDEOGRAPH-8F1C
        0x96C9, # G+7357  U+96C9  uni96C9,  CJK UNIFIED IDEOGRAPH-96C9
        0x99B3, # G+7358  U+99B3  uni99B3,  CJK UNIFIED IDEOGRAPH-99B3
        0x2FD2, # G+7359  U+2FD2  uni2FD2,  KANGXI RADICAL TOOTH
        0x5247, # G+7360  U+5247  uni5247,  CJK UNIFIED IDEOGRAPH-5247
        0x52C5, # G+7361  U+52C5  uni52C5,  CJK UNIFIED IDEOGRAPH-52C5
        0x98ED, # G+7362  U+98ED  uni98ED,  CJK UNIFIED IDEOGRAPH-98ED
        0x89AA, # G+7363  U+89AA  uni89AA,  CJK UNIFIED IDEOGRAPH-89AA
        0x4E03, # G+7364  U+4E03  uni4E03,  CJK UNIFIED IDEOGRAPH-4E03
        0x67D2, # G+7365  U+67D2  uni67D2,  CJK UNIFIED IDEOGRAPH-67D2
        0x6F06, # G+7366  U+6F06  uni6F06,  CJK UNIFIED IDEOGRAPH-6F06
        0x4FB5, # G+7367  U+4FB5  uni4FB5,  CJK UNIFIED IDEOGRAPH-4FB5
        0x5BE2, # G+7368  U+5BE2  uni5BE2,  CJK UNIFIED IDEOGRAPH-5BE2
        0x6795, # G+7369  U+6795  uni6795,  CJK UNIFIED IDEOGRAPH-6795
        0x6C88, # G+7370  U+6C88  uni6C88,  CJK UNIFIED IDEOGRAPH-6C88
        0x6D78, # G+7371  U+6D78  uni6D78,  CJK UNIFIED IDEOGRAPH-6D78
        0x741B, # G+7372  U+741B  uni741B,  CJK UNIFIED IDEOGRAPH-741B
        0x7827, # G+7373  U+7827  uni7827,  CJK UNIFIED IDEOGRAPH-7827
        0x91DD, # G+7374  U+91DD  uni91DD,  CJK UNIFIED IDEOGRAPH-91DD
        0x937C, # G+7375  U+937C  uni937C,  CJK UNIFIED IDEOGRAPH-937C
        0x87C4, # G+7376  U+87C4  uni87C4,  CJK UNIFIED IDEOGRAPH-87C4
        0x79E4, # G+7377  U+79E4  uni79E4,  CJK UNIFIED IDEOGRAPH-79E4
        0x7A31, # G+7378  U+7A31  uni7A31,  CJK UNIFIED IDEOGRAPH-7A31
        0x5FEB, # G+7379  U+5FEB  uni5FEB,  CJK UNIFIED IDEOGRAPH-5FEB
        0x4ED6, # G+7380  U+4ED6  uni4ED6,  CJK UNIFIED IDEOGRAPH-4ED6
        0x54A4, # G+7381  U+54A4  uni54A4,  CJK UNIFIED IDEOGRAPH-54A4
        0x553E, # G+7382  U+553E  uni553E,  CJK UNIFIED IDEOGRAPH-553E
        0x58AE, # G+7383  U+58AE  uni58AE,  CJK UNIFIED IDEOGRAPH-58AE
        0x59A5, # G+7384  U+59A5  uni59A5,  CJK UNIFIED IDEOGRAPH-59A5
        0x60F0, # G+7385  U+60F0  uni60F0,  CJK UNIFIED IDEOGRAPH-60F0
        0x6253, # G+7386  U+6253  uni6253,  CJK UNIFIED IDEOGRAPH-6253
        0x62D6, # G+7387  U+62D6  uni62D6,  CJK UNIFIED IDEOGRAPH-62D6
        0x6736, # G+7388  U+6736  uni6736,  CJK UNIFIED IDEOGRAPH-6736
        0x6955, # G+7389  U+6955  uni6955,  CJK UNIFIED IDEOGRAPH-6955
        0x8235, # G+7390  U+8235  uni8235,  CJK UNIFIED IDEOGRAPH-8235
        0x9640, # G+7391  U+9640  uni9640,  CJK UNIFIED IDEOGRAPH-9640
        0x99B1, # G+7392  U+99B1  uni99B1,  CJK UNIFIED IDEOGRAPH-99B1
        0x99DD, # G+7393  U+99DD  uni99DD,  CJK UNIFIED IDEOGRAPH-99DD
        0x502C, # G+7394  U+502C  uni502C,  CJK UNIFIED IDEOGRAPH-502C
        0x5353, # G+7395  U+5353  uni5353,  CJK UNIFIED IDEOGRAPH-5353
        0x5544, # G+7396  U+5544  uni5544,  CJK UNIFIED IDEOGRAPH-5544
        0x577C, # G+7397  U+577C  uni577C,  CJK UNIFIED IDEOGRAPH-577C
        0x6258, # G+7398  U+6258  uni6258,  CJK UNIFIED IDEOGRAPH-6258
        0x64E2, # G+7399  U+64E2  uni64E2,  CJK UNIFIED IDEOGRAPH-64E2
        0x666B, # G+7400  U+666B  uni666B,  CJK UNIFIED IDEOGRAPH-666B
        0x67DD, # G+7401  U+67DD  uni67DD,  CJK UNIFIED IDEOGRAPH-67DD
        0x6FC1, # G+7402  U+6FC1  uni6FC1,  CJK UNIFIED IDEOGRAPH-6FC1
        0x6FEF, # G+7403  U+6FEF  uni6FEF,  CJK UNIFIED IDEOGRAPH-6FEF
        0x7422, # G+7404  U+7422  uni7422,  CJK UNIFIED IDEOGRAPH-7422
        0x7438, # G+7405  U+7438  uni7438,  CJK UNIFIED IDEOGRAPH-7438
        0x8A17, # G+7406  U+8A17  uni8A17,  CJK UNIFIED IDEOGRAPH-8A17
        0x9438, # G+7407  U+9438  uni9438,  CJK UNIFIED IDEOGRAPH-9438
        0x5451, # G+7408  U+5451  uni5451,  CJK UNIFIED IDEOGRAPH-5451
        0x5606, # G+7409  U+5606  uni5606,  CJK UNIFIED IDEOGRAPH-5606
        0x5766, # G+7410  U+5766  uni5766,  CJK UNIFIED IDEOGRAPH-5766
        0x5F48, # G+7411  U+5F48  uni5F48,  CJK UNIFIED IDEOGRAPH-5F48
        0x619A, # G+7412  U+619A  uni619A,  CJK UNIFIED IDEOGRAPH-619A
        0x6B4E, # G+7413  U+6B4E  uni6B4E,  CJK UNIFIED IDEOGRAPH-6B4E
        0x7058, # G+7414  U+7058  uni7058,  CJK UNIFIED IDEOGRAPH-7058
        0x70AD, # G+7415  U+70AD  uni70AD,  CJK UNIFIED IDEOGRAPH-70AD
        0x7DBB, # G+7416  U+7DBB  uni7DBB,  CJK UNIFIED IDEOGRAPH-7DBB
        0x8A95, # G+7417  U+8A95  uni8A95,  CJK UNIFIED IDEOGRAPH-8A95
        0x596A, # G+7418  U+596A  uni596A,  CJK UNIFIED IDEOGRAPH-596A
        0x812B, # G+7419  U+812B  uni812B,  CJK UNIFIED IDEOGRAPH-812B
        0x63A2, # G+7420  U+63A2  uni63A2,  CJK UNIFIED IDEOGRAPH-63A2
        0x7708, # G+7421  U+7708  uni7708,  CJK UNIFIED IDEOGRAPH-7708
        0x803D, # G+7422  U+803D  uni803D,  CJK UNIFIED IDEOGRAPH-803D
        0x8CAA, # G+7423  U+8CAA  uni8CAA,  CJK UNIFIED IDEOGRAPH-8CAA
        0x5854, # G+7424  U+5854  uni5854,  CJK UNIFIED IDEOGRAPH-5854
        0x642D, # G+7425  U+642D  uni642D,  CJK UNIFIED IDEOGRAPH-642D
        0x69BB, # G+7426  U+69BB  uni69BB,  CJK UNIFIED IDEOGRAPH-69BB
        0x5B95, # G+7427  U+5B95  uni5B95,  CJK UNIFIED IDEOGRAPH-5B95
        0x5E11, # G+7428  U+5E11  uni5E11,  CJK UNIFIED IDEOGRAPH-5E11
        0x6E6F, # G+7429  U+6E6F  uni6E6F,  CJK UNIFIED IDEOGRAPH-6E6F
        0x8569, # G+7430  U+8569  uni8569,  CJK UNIFIED IDEOGRAPH-8569
        0x514C, # G+7431  U+514C  uni514C,  CJK UNIFIED IDEOGRAPH-514C
        0x53F0, # G+7432  U+53F0  uni53F0,  CJK UNIFIED IDEOGRAPH-53F0
        0x592A, # G+7433  U+592A  uni592A,  CJK UNIFIED IDEOGRAPH-592A
        0x6020, # G+7434  U+6020  uni6020,  CJK UNIFIED IDEOGRAPH-6020
        0x614B, # G+7435  U+614B  uni614B,  CJK UNIFIED IDEOGRAPH-614B
        0x6B86, # G+7436  U+6B86  uni6B86,  CJK UNIFIED IDEOGRAPH-6B86
        0x6C70, # G+7437  U+6C70  uni6C70,  CJK UNIFIED IDEOGRAPH-6C70
        0x6CF0, # G+7438  U+6CF0  uni6CF0,  CJK UNIFIED IDEOGRAPH-6CF0
        0x7B1E, # G+7439  U+7B1E  uni7B1E,  CJK UNIFIED IDEOGRAPH-7B1E
        0x80CE, # G+7440  U+80CE  uni80CE,  CJK UNIFIED IDEOGRAPH-80CE
        0x82D4, # G+7441  U+82D4  uni82D4,  CJK UNIFIED IDEOGRAPH-82D4
        0x8DC6, # G+7442  U+8DC6  uni8DC6,  CJK UNIFIED IDEOGRAPH-8DC6
        0x90B0, # G+7443  U+90B0  uni90B0,  CJK UNIFIED IDEOGRAPH-90B0
        0x98B1, # G+7444  U+98B1  uni98B1,  CJK UNIFIED IDEOGRAPH-98B1
        0x64C7, # G+7445  U+64C7  uni64C7,  CJK UNIFIED IDEOGRAPH-64C7
        0x6FA4, # G+7446  U+6FA4  uni6FA4,  CJK UNIFIED IDEOGRAPH-6FA4
        0x6491, # G+7447  U+6491  uni6491,  CJK UNIFIED IDEOGRAPH-6491
        0x6504, # G+7448  U+6504  uni6504,  CJK UNIFIED IDEOGRAPH-6504
        0x514E, # G+7449  U+514E  uni514E,  CJK UNIFIED IDEOGRAPH-514E
        0x5410, # G+7450  U+5410  uni5410,  CJK UNIFIED IDEOGRAPH-5410
        0x2F1F, # G+7451  U+2F1F  uni2F1F,  KANGXI RADICAL EARTH
        0x8A0E, # G+7452  U+8A0E  uni8A0E,  CJK UNIFIED IDEOGRAPH-8A0E
        0x615F, # G+7453  U+615F  uni615F,  CJK UNIFIED IDEOGRAPH-615F
        0x6876, # G+7454  U+6876  uni6876,  CJK UNIFIED IDEOGRAPH-6876
        0x75DB, # G+7455  U+75DB  uni75DB,  CJK UNIFIED IDEOGRAPH-75DB
        0x7B52, # G+7456  U+7B52  uni7B52,  CJK UNIFIED IDEOGRAPH-7B52
        0x7D71, # G+7457  U+7D71  uni7D71,  CJK UNIFIED IDEOGRAPH-7D71
        0x901A, # G+7458  U+901A  uni901A,  CJK UNIFIED IDEOGRAPH-901A
        0x5806, # G+7459  U+5806  uni5806,  CJK UNIFIED IDEOGRAPH-5806
        0x69CC, # G+7460  U+69CC  uni69CC,  CJK UNIFIED IDEOGRAPH-69CC
        0x817F, # G+7461  U+817F  uni817F,  CJK UNIFIED IDEOGRAPH-817F
        0x892A, # G+7462  U+892A  uni892A,  CJK UNIFIED IDEOGRAPH-892A
        0x9000, # G+7463  U+9000  uni9000,  CJK UNIFIED IDEOGRAPH-9000
        0x9839, # G+7464  U+9839  uni9839,  CJK UNIFIED IDEOGRAPH-9839
        0x5078, # G+7465  U+5078  uni5078,  CJK UNIFIED IDEOGRAPH-5078
        0x5957, # G+7466  U+5957  uni5957,  CJK UNIFIED IDEOGRAPH-5957
        0x59AC, # G+7467  U+59AC  uni59AC,  CJK UNIFIED IDEOGRAPH-59AC
        0x6295, # G+7468  U+6295  uni6295,  CJK UNIFIED IDEOGRAPH-6295
        0x900F, # G+7469  U+900F  uni900F,  CJK UNIFIED IDEOGRAPH-900F
        0x9B2A, # G+7470  U+9B2A  uni9B2A,  CJK UNIFIED IDEOGRAPH-9B2A
        0x615D, # G+7471  U+615D  uni615D,  CJK UNIFIED IDEOGRAPH-615D
        0x7279, # G+7472  U+7279  uni7279,  CJK UNIFIED IDEOGRAPH-7279
        0x95D6, # G+7473  U+95D6  uni95D6,  CJK UNIFIED IDEOGRAPH-95D6
        0x5761, # G+7474  U+5761  uni5761,  CJK UNIFIED IDEOGRAPH-5761
        0x5A46, # G+7475  U+5A46  uni5A46,  CJK UNIFIED IDEOGRAPH-5A46
        0x5DF4, # G+7476  U+5DF4  uni5DF4,  CJK UNIFIED IDEOGRAPH-5DF4
        0x628A, # G+7477  U+628A  uni628A,  CJK UNIFIED IDEOGRAPH-628A
        0x64AD, # G+7478  U+64AD  uni64AD,  CJK UNIFIED IDEOGRAPH-64AD
        0x64FA, # G+7479  U+64FA  uni64FA,  CJK UNIFIED IDEOGRAPH-64FA
        0x6777, # G+7480  U+6777  uni6777,  CJK UNIFIED IDEOGRAPH-6777
        0x6CE2, # G+7481  U+6CE2  uni6CE2,  CJK UNIFIED IDEOGRAPH-6CE2
        0x6D3E, # G+7482  U+6D3E  uni6D3E,  CJK UNIFIED IDEOGRAPH-6D3E
        0x722C, # G+7483  U+722C  uni722C,  CJK UNIFIED IDEOGRAPH-722C
        0x7436, # G+7484  U+7436  uni7436,  CJK UNIFIED IDEOGRAPH-7436
        0x7834, # G+7485  U+7834  uni7834,  CJK UNIFIED IDEOGRAPH-7834
        0x7F77, # G+7486  U+7F77  uni7F77,  CJK UNIFIED IDEOGRAPH-7F77
        0x82AD, # G+7487  U+82AD  uni82AD,  CJK UNIFIED IDEOGRAPH-82AD
        0x8DDB, # G+7488  U+8DDB  uni8DDB,  CJK UNIFIED IDEOGRAPH-8DDB
        0x9817, # G+7489  U+9817  uni9817,  CJK UNIFIED IDEOGRAPH-9817
        0x5224, # G+7490  U+5224  uni5224,  CJK UNIFIED IDEOGRAPH-5224
        0x5742, # G+7491  U+5742  uni5742,  CJK UNIFIED IDEOGRAPH-5742
        0x677F, # G+7492  U+677F  uni677F,  CJK UNIFIED IDEOGRAPH-677F
        0x7248, # G+7493  U+7248  uni7248,  CJK UNIFIED IDEOGRAPH-7248
        0x74E3, # G+7494  U+74E3  uni74E3,  CJK UNIFIED IDEOGRAPH-74E3
        0x8CA9, # G+7495  U+8CA9  uni8CA9,  CJK UNIFIED IDEOGRAPH-8CA9
        0x8FA6, # G+7496  U+8FA6  uni8FA6,  CJK UNIFIED IDEOGRAPH-8FA6
        0x9211, # G+7497  U+9211  uni9211,  CJK UNIFIED IDEOGRAPH-9211
        0x962A, # G+7498  U+962A  uni962A,  CJK UNIFIED IDEOGRAPH-962A
        0x2F0B, # G+7499  U+2F0B  uni2F0B,  KANGXI RADICAL EIGHT
        0x53ED, # G+7500  U+53ED  uni53ED,  CJK UNIFIED IDEOGRAPH-53ED
        0x634C, # G+7501  U+634C  uni634C,  CJK UNIFIED IDEOGRAPH-634C
        0x4F69, # G+7502  U+4F69  uni4F69,  CJK UNIFIED IDEOGRAPH-4F69
        0x5504, # G+7503  U+5504  uni5504,  CJK UNIFIED IDEOGRAPH-5504
        0x6096, # G+7504  U+6096  uni6096,  CJK UNIFIED IDEOGRAPH-6096
        0x6557, # G+7505  U+6557  uni6557,  CJK UNIFIED IDEOGRAPH-6557
        0x6C9B, # G+7506  U+6C9B  uni6C9B,  CJK UNIFIED IDEOGRAPH-6C9B
        0x6D7F, # G+7507  U+6D7F  uni6D7F,  CJK UNIFIED IDEOGRAPH-6D7F
        0x724C, # G+7508  U+724C  uni724C,  CJK UNIFIED IDEOGRAPH-724C
        0x72FD, # G+7509  U+72FD  uni72FD,  CJK UNIFIED IDEOGRAPH-72FD
        0x7A17, # G+7510  U+7A17  uni7A17,  CJK UNIFIED IDEOGRAPH-7A17
        0x8987, # G+7511  U+8987  uni8987,  CJK UNIFIED IDEOGRAPH-8987
        0x2F99, # G+7512  U+2F99  uni2F99,  KANGXI RADICAL SHELL
        0x5F6D, # G+7513  U+5F6D  uni5F6D,  CJK UNIFIED IDEOGRAPH-5F6D
        0x6F8E, # G+7514  U+6F8E  uni6F8E,  CJK UNIFIED IDEOGRAPH-6F8E
        0x70F9, # G+7515  U+70F9  uni70F9,  CJK UNIFIED IDEOGRAPH-70F9
        0x81A8, # G+7516  U+81A8  uni81A8,  CJK UNIFIED IDEOGRAPH-81A8
        0x610E, # G+7517  U+610E  uni610E,  CJK UNIFIED IDEOGRAPH-610E
        0x4FBF, # G+7518  U+4FBF  uni4FBF,  CJK UNIFIED IDEOGRAPH-4FBF
        0x504F, # G+7519  U+504F  uni504F,  CJK UNIFIED IDEOGRAPH-504F
        0x6241, # G+7520  U+6241  uni6241,  CJK UNIFIED IDEOGRAPH-6241
        0x2F5A, # G+7521  U+2F5A  uni2F5A,  KANGXI RADICAL SLICE
        0x7BC7, # G+7522  U+7BC7  uni7BC7,  CJK UNIFIED IDEOGRAPH-7BC7
        0x7DE8, # G+7523  U+7DE8  uni7DE8,  CJK UNIFIED IDEOGRAPH-7DE8
        0x7FE9, # G+7524  U+7FE9  uni7FE9,  CJK UNIFIED IDEOGRAPH-7FE9
        0x904D, # G+7525  U+904D  uni904D,  CJK UNIFIED IDEOGRAPH-904D
        0x97AD, # G+7526  U+97AD  uni97AD,  CJK UNIFIED IDEOGRAPH-97AD
        0x9A19, # G+7527  U+9A19  uni9A19,  CJK UNIFIED IDEOGRAPH-9A19
        0x8CB6, # G+7528  U+8CB6  uni8CB6,  CJK UNIFIED IDEOGRAPH-8CB6
        0x576A, # G+7529  U+576A  uni576A,  CJK UNIFIED IDEOGRAPH-576A
        0x5E73, # G+7530  U+5E73  uni5E73,  CJK UNIFIED IDEOGRAPH-5E73
        0x67B0, # G+7531  U+67B0  uni67B0,  CJK UNIFIED IDEOGRAPH-67B0
        0x840D, # G+7532  U+840D  uni840D,  CJK UNIFIED IDEOGRAPH-840D
        0x8A55, # G+7533  U+8A55  uni8A55,  CJK UNIFIED IDEOGRAPH-8A55
        0x5420, # G+7534  U+5420  uni5420,  CJK UNIFIED IDEOGRAPH-5420
        0x5B16, # G+7535  U+5B16  uni5B16,  CJK UNIFIED IDEOGRAPH-5B16
        0x5E63, # G+7536  U+5E63  uni5E63,  CJK UNIFIED IDEOGRAPH-5E63
        0x5EE2, # G+7537  U+5EE2  uni5EE2,  CJK UNIFIED IDEOGRAPH-5EE2
        0x5F0A, # G+7538  U+5F0A  uni5F0A,  CJK UNIFIED IDEOGRAPH-5F0A
        0x6583, # G+7539  U+6583  uni6583,  CJK UNIFIED IDEOGRAPH-6583
        0x80BA, # G+7540  U+80BA  uni80BA,  CJK UNIFIED IDEOGRAPH-80BA
        0x853D, # G+7541  U+853D  uni853D,  CJK UNIFIED IDEOGRAPH-853D
        0x9589, # G+7542  U+9589  uni9589,  CJK UNIFIED IDEOGRAPH-9589
        0x965B, # G+7543  U+965B  uni965B,  CJK UNIFIED IDEOGRAPH-965B
        0x4F48, # G+7544  U+4F48  uni4F48,  CJK UNIFIED IDEOGRAPH-4F48
        0x5305, # G+7545  U+5305  uni5305,  CJK UNIFIED IDEOGRAPH-5305
        0x530D, # G+7546  U+530D  uni530D,  CJK UNIFIED IDEOGRAPH-530D
        0x530F, # G+7547  U+530F  uni530F,  CJK UNIFIED IDEOGRAPH-530F
        0x5486, # G+7548  U+5486  uni5486,  CJK UNIFIED IDEOGRAPH-5486
        0x54FA, # G+7549  U+54FA  uni54FA,  CJK UNIFIED IDEOGRAPH-54FA
        0x5703, # G+7550  U+5703  uni5703,  CJK UNIFIED IDEOGRAPH-5703
        0x5E03, # G+7551  U+5E03  uni5E03,  CJK UNIFIED IDEOGRAPH-5E03
        0x6016, # G+7552  U+6016  uni6016,  CJK UNIFIED IDEOGRAPH-6016
        0x629B, # G+7553  U+629B  uni629B,  CJK UNIFIED IDEOGRAPH-629B
        0x62B1, # G+7554  U+62B1  uni62B1,  CJK UNIFIED IDEOGRAPH-62B1
        0x6355, # G+7555  U+6355  uni6355,  CJK UNIFIED IDEOGRAPH-6355
        0x6CE1, # G+7556  U+6CE1  uni6CE1,  CJK UNIFIED IDEOGRAPH-6CE1
        0x6D66, # G+7557  U+6D66  uni6D66,  CJK UNIFIED IDEOGRAPH-6D66
        0x75B1, # G+7558  U+75B1  uni75B1,  CJK UNIFIED IDEOGRAPH-75B1
        0x7832, # G+7559  U+7832  uni7832,  CJK UNIFIED IDEOGRAPH-7832
        0x80DE, # G+7560  U+80DE  uni80DE,  CJK UNIFIED IDEOGRAPH-80DE
        0x812F, # G+7561  U+812F  uni812F,  CJK UNIFIED IDEOGRAPH-812F
        0x82DE, # G+7562  U+82DE  uni82DE,  CJK UNIFIED IDEOGRAPH-82DE
        0x8461, # G+7563  U+8461  uni8461,  CJK UNIFIED IDEOGRAPH-8461
        0x84B2, # G+7564  U+84B2  uni84B2,  CJK UNIFIED IDEOGRAPH-84B2
        0x888D, # G+7565  U+888D  uni888D,  CJK UNIFIED IDEOGRAPH-888D
        0x8912, # G+7566  U+8912  uni8912,  CJK UNIFIED IDEOGRAPH-8912
        0x900B, # G+7567  U+900B  uni900B,  CJK UNIFIED IDEOGRAPH-900B
        0x92EA, # G+7568  U+92EA  uni92EA,  CJK UNIFIED IDEOGRAPH-92EA
        0x98FD, # G+7569  U+98FD  uni98FD,  CJK UNIFIED IDEOGRAPH-98FD
        0x9B91, # G+7570  U+9B91  uni9B91,  CJK UNIFIED IDEOGRAPH-9B91
        0x5E45, # G+7571  U+5E45  uni5E45,  CJK UNIFIED IDEOGRAPH-5E45
        0x66B4, # G+7572  U+66B4  uni66B4,  CJK UNIFIED IDEOGRAPH-66B4
        0x66DD, # G+7573  U+66DD  uni66DD,  CJK UNIFIED IDEOGRAPH-66DD
        0x7011, # G+7574  U+7011  uni7011,  CJK UNIFIED IDEOGRAPH-7011
        0x7206, # G+7575  U+7206  uni7206,  CJK UNIFIED IDEOGRAPH-7206
        0x4FF5, # G+7576  U+4FF5  uni4FF5,  CJK UNIFIED IDEOGRAPH-4FF5
        0x527D, # G+7577  U+527D  uni527D,  CJK UNIFIED IDEOGRAPH-527D
        0x5F6A, # G+7578  U+5F6A  uni5F6A,  CJK UNIFIED IDEOGRAPH-5F6A
        0x6153, # G+7579  U+6153  uni6153,  CJK UNIFIED IDEOGRAPH-6153
        0x6753, # G+7580  U+6753  uni6753,  CJK UNIFIED IDEOGRAPH-6753
        0x6A19, # G+7581  U+6A19  uni6A19,  CJK UNIFIED IDEOGRAPH-6A19
        0x6F02, # G+7582  U+6F02  uni6F02,  CJK UNIFIED IDEOGRAPH-6F02
        0x74E2, # G+7583  U+74E2  uni74E2,  CJK UNIFIED IDEOGRAPH-74E2
        0x7968, # G+7584  U+7968  uni7968,  CJK UNIFIED IDEOGRAPH-7968
        0x8868, # G+7585  U+8868  uni8868,  CJK UNIFIED IDEOGRAPH-8868
        0x8C79, # G+7586  U+8C79  uni8C79,  CJK UNIFIED IDEOGRAPH-8C79
        0x98C7, # G+7587  U+98C7  uni98C7,  CJK UNIFIED IDEOGRAPH-98C7
        0x98C4, # G+7588  U+98C4  uni98C4,  CJK UNIFIED IDEOGRAPH-98C4
        0x9A43, # G+7589  U+9A43  uni9A43,  CJK UNIFIED IDEOGRAPH-9A43
        0x54C1, # G+7590  U+54C1  uni54C1,  CJK UNIFIED IDEOGRAPH-54C1
        0x7A1F, # G+7591  U+7A1F  uni7A1F,  CJK UNIFIED IDEOGRAPH-7A1F
        0x6953, # G+7592  U+6953  uni6953,  CJK UNIFIED IDEOGRAPH-6953
        0x8AF7, # G+7593  U+8AF7  uni8AF7,  CJK UNIFIED IDEOGRAPH-8AF7
        0x8C4A, # G+7594  U+8C4A  uni8C4A,  CJK UNIFIED IDEOGRAPH-8C4A
        0x2FB5, # G+7595  U+2FB5  uni2FB5,  KANGXI RADICAL WIND
        0x99AE, # G+7596  U+99AE  uni99AE,  CJK UNIFIED IDEOGRAPH-99AE
        0x5F7C, # G+7597  U+5F7C  uni5F7C,  CJK UNIFIED IDEOGRAPH-5F7C
        0x62AB, # G+7598  U+62AB  uni62AB,  CJK UNIFIED IDEOGRAPH-62AB
        0x75B2, # G+7599  U+75B2  uni75B2,  CJK UNIFIED IDEOGRAPH-75B2
        0x2F6A, # G+7600  U+2F6A  uni2F6A,  KANGXI RADICAL SKIN
        0x88AB, # G+7601  U+88AB  uni88AB,  CJK UNIFIED IDEOGRAPH-88AB
        0x907F, # G+7602  U+907F  uni907F,  CJK UNIFIED IDEOGRAPH-907F
        0x9642, # G+7603  U+9642  uni9642,  CJK UNIFIED IDEOGRAPH-9642
        0x5339, # G+7604  U+5339  uni5339,  CJK UNIFIED IDEOGRAPH-5339
        0x5F3C, # G+7605  U+5F3C  uni5F3C,  CJK UNIFIED IDEOGRAPH-5F3C
        0x5FC5, # G+7606  U+5FC5  uni5FC5,  CJK UNIFIED IDEOGRAPH-5FC5
        0x6CCC, # G+7607  U+6CCC  uni6CCC,  CJK UNIFIED IDEOGRAPH-6CCC
        0x73CC, # G+7608  U+73CC  uni73CC,  CJK UNIFIED IDEOGRAPH-73CC
        0x7562, # G+7609  U+7562  uni7562,  CJK UNIFIED IDEOGRAPH-7562
        0x2F66, # G+7610  U+2F66  uni2F66,  KANGXI RADICAL BOLT OF CLOTH
        0x7B46, # G+7611  U+7B46  uni7B46,  CJK UNIFIED IDEOGRAPH-7B46
        0x82FE, # G+7612  U+82FE  uni82FE,  CJK UNIFIED IDEOGRAPH-82FE
        0x999D, # G+7613  U+999D  uni999D,  CJK UNIFIED IDEOGRAPH-999D
        0x4E4F, # G+7614  U+4E4F  uni4E4F,  CJK UNIFIED IDEOGRAPH-4E4F
        0x903C, # G+7615  U+903C  uni903C,  CJK UNIFIED IDEOGRAPH-903C
        0x4E0B, # G+7616  U+4E0B  uni4E0B,  CJK UNIFIED IDEOGRAPH-4E0B
        0x4F55, # G+7617  U+4F55  uni4F55,  CJK UNIFIED IDEOGRAPH-4F55
        0x53A6, # G+7618  U+53A6  uni53A6,  CJK UNIFIED IDEOGRAPH-53A6
        0x590F, # G+7619  U+590F  uni590F,  CJK UNIFIED IDEOGRAPH-590F
        0x5EC8, # G+7620  U+5EC8  uni5EC8,  CJK UNIFIED IDEOGRAPH-5EC8
        0x6630, # G+7621  U+6630  uni6630,  CJK UNIFIED IDEOGRAPH-6630
        0x6CB3, # G+7622  U+6CB3  uni6CB3,  CJK UNIFIED IDEOGRAPH-6CB3
        0x7455, # G+7623  U+7455  uni7455,  CJK UNIFIED IDEOGRAPH-7455
        0x8377, # G+7624  U+8377  uni8377,  CJK UNIFIED IDEOGRAPH-8377
        0x8766, # G+7625  U+8766  uni8766,  CJK UNIFIED IDEOGRAPH-8766
        0x8CC0, # G+7626  U+8CC0  uni8CC0,  CJK UNIFIED IDEOGRAPH-8CC0
        0x9050, # G+7627  U+9050  uni9050,  CJK UNIFIED IDEOGRAPH-9050
        0x971E, # G+7628  U+971E  uni971E,  CJK UNIFIED IDEOGRAPH-971E
        0x9C15, # G+7629  U+9C15  uni9C15,  CJK UNIFIED IDEOGRAPH-9C15
        0x58D1, # G+7630  U+58D1  uni58D1,  CJK UNIFIED IDEOGRAPH-58D1
        0x5B78, # G+7631  U+5B78  uni5B78,  CJK UNIFIED IDEOGRAPH-5B78
        0x8650, # G+7632  U+8650  uni8650,  CJK UNIFIED IDEOGRAPH-8650
        0x8B14, # G+7633  U+8B14  uni8B14,  CJK UNIFIED IDEOGRAPH-8B14
        0x9DB4, # G+7634  U+9DB4  uni9DB4,  CJK UNIFIED IDEOGRAPH-9DB4
        0x5BD2, # G+7635  U+5BD2  uni5BD2,  CJK UNIFIED IDEOGRAPH-5BD2
        0x6068, # G+7636  U+6068  uni6068,  CJK UNIFIED IDEOGRAPH-6068
        0x608D, # G+7637  U+608D  uni608D,  CJK UNIFIED IDEOGRAPH-608D
        0x65F1, # G+7638  U+65F1  uni65F1,  CJK UNIFIED IDEOGRAPH-65F1
        0x6C57, # G+7639  U+6C57  uni6C57,  CJK UNIFIED IDEOGRAPH-6C57
        0x6F22, # G+7640  U+6F22  uni6F22,  CJK UNIFIED IDEOGRAPH-6F22
        0x6FA3, # G+7641  U+6FA3  uni6FA3,  CJK UNIFIED IDEOGRAPH-6FA3
        0x701A, # G+7642  U+701A  uni701A,  CJK UNIFIED IDEOGRAPH-701A
        0x7F55, # G+7643  U+7F55  uni7F55,  CJK UNIFIED IDEOGRAPH-7F55
        0x7FF0, # G+7644  U+7FF0  uni7FF0,  CJK UNIFIED IDEOGRAPH-7FF0
        0x9591, # G+7645  U+9591  uni9591,  CJK UNIFIED IDEOGRAPH-9591
        0x9592, # G+7646  U+9592  uni9592,  CJK UNIFIED IDEOGRAPH-9592
        0x9650, # G+7647  U+9650  uni9650,  CJK UNIFIED IDEOGRAPH-9650
        0x97D3, # G+7648  U+97D3  uni97D3,  CJK UNIFIED IDEOGRAPH-97D3
        0x5272, # G+7649  U+5272  uni5272,  CJK UNIFIED IDEOGRAPH-5272
        0x8F44, # G+7650  U+8F44  uni8F44,  CJK UNIFIED IDEOGRAPH-8F44
        0x51FD, # G+7651  U+51FD  uni51FD,  CJK UNIFIED IDEOGRAPH-51FD
        0x542B, # G+7652  U+542B  uni542B,  CJK UNIFIED IDEOGRAPH-542B
        0x54B8, # G+7653  U+54B8  uni54B8,  CJK UNIFIED IDEOGRAPH-54B8
        0x5563, # G+7654  U+5563  uni5563,  CJK UNIFIED IDEOGRAPH-5563
        0x558A, # G+7655  U+558A  uni558A,  CJK UNIFIED IDEOGRAPH-558A
        0x6ABB, # G+7656  U+6ABB  uni6ABB,  CJK UNIFIED IDEOGRAPH-6ABB
        0x6DB5, # G+7657  U+6DB5  uni6DB5,  CJK UNIFIED IDEOGRAPH-6DB5
        0x7DD8, # G+7658  U+7DD8  uni7DD8,  CJK UNIFIED IDEOGRAPH-7DD8
        0x8266, # G+7659  U+8266  uni8266,  CJK UNIFIED IDEOGRAPH-8266
        0x929C, # G+7660  U+929C  uni929C,  CJK UNIFIED IDEOGRAPH-929C
        0x9677, # G+7661  U+9677  uni9677,  CJK UNIFIED IDEOGRAPH-9677
        0x9E79, # G+7662  U+9E79  uni9E79,  CJK UNIFIED IDEOGRAPH-9E79
        0x5408, # G+7663  U+5408  uni5408,  CJK UNIFIED IDEOGRAPH-5408
        0x54C8, # G+7664  U+54C8  uni54C8,  CJK UNIFIED IDEOGRAPH-54C8
        0x76D2, # G+7665  U+76D2  uni76D2,  CJK UNIFIED IDEOGRAPH-76D2
        0x86E4, # G+7666  U+86E4  uni86E4,  CJK UNIFIED IDEOGRAPH-86E4
        0x95A4, # G+7667  U+95A4  uni95A4,  CJK UNIFIED IDEOGRAPH-95A4
        0x95D4, # G+7668  U+95D4  uni95D4,  CJK UNIFIED IDEOGRAPH-95D4
        0x965C, # G+7669  U+965C  uni965C,  CJK UNIFIED IDEOGRAPH-965C
        0x4EA2, # G+7670  U+4EA2  uni4EA2,  CJK UNIFIED IDEOGRAPH-4EA2
        0x4F09, # G+7671  U+4F09  uni4F09,  CJK UNIFIED IDEOGRAPH-4F09
        0x59EE, # G+7672  U+59EE  uni59EE,  CJK UNIFIED IDEOGRAPH-59EE
        0x5AE6, # G+7673  U+5AE6  uni5AE6,  CJK UNIFIED IDEOGRAPH-5AE6
        0x5DF7, # G+7674  U+5DF7  uni5DF7,  CJK UNIFIED IDEOGRAPH-5DF7
        0x6052, # G+7675  U+6052  uni6052,  CJK UNIFIED IDEOGRAPH-6052
        0x6297, # G+7676  U+6297  uni6297,  CJK UNIFIED IDEOGRAPH-6297
        0x676D, # G+7677  U+676D  uni676D,  CJK UNIFIED IDEOGRAPH-676D
        0x6841, # G+7678  U+6841  uni6841,  CJK UNIFIED IDEOGRAPH-6841
        0x6C86, # G+7679  U+6C86  uni6C86,  CJK UNIFIED IDEOGRAPH-6C86
        0x6E2F, # G+7680  U+6E2F  uni6E2F,  CJK UNIFIED IDEOGRAPH-6E2F
        0x7F38, # G+7681  U+7F38  uni7F38,  CJK UNIFIED IDEOGRAPH-7F38
        0x809B, # G+7682  U+809B  uni809B,  CJK UNIFIED IDEOGRAPH-809B
        0x822A, # G+7683  U+822A  uni822A,  CJK UNIFIED IDEOGRAPH-822A
        0x9805, # G+7684  U+9805  uni9805,  CJK UNIFIED IDEOGRAPH-9805
        0x4EA5, # G+7685  U+4EA5  uni4EA5,  CJK UNIFIED IDEOGRAPH-4EA5
        0x5055, # G+7686  U+5055  uni5055,  CJK UNIFIED IDEOGRAPH-5055
        0x54B3, # G+7687  U+54B3  uni54B3,  CJK UNIFIED IDEOGRAPH-54B3
        0x5793, # G+7688  U+5793  uni5793,  CJK UNIFIED IDEOGRAPH-5793
        0x595A, # G+7689  U+595A  uni595A,  CJK UNIFIED IDEOGRAPH-595A
        0x5B69, # G+7690  U+5B69  uni5B69,  CJK UNIFIED IDEOGRAPH-5B69
        0x5BB3, # G+7691  U+5BB3  uni5BB3,  CJK UNIFIED IDEOGRAPH-5BB3
        0x61C8, # G+7692  U+61C8  uni61C8,  CJK UNIFIED IDEOGRAPH-61C8
        0x6977, # G+7693  U+6977  uni6977,  CJK UNIFIED IDEOGRAPH-6977
        0x6D77, # G+7694  U+6D77  uni6D77,  CJK UNIFIED IDEOGRAPH-6D77
        0x7023, # G+7695  U+7023  uni7023,  CJK UNIFIED IDEOGRAPH-7023
        0x87F9, # G+7696  U+87F9  uni87F9,  CJK UNIFIED IDEOGRAPH-87F9
        0x89E3, # G+7697  U+89E3  uni89E3,  CJK UNIFIED IDEOGRAPH-89E3
        0x8A72, # G+7698  U+8A72  uni8A72,  CJK UNIFIED IDEOGRAPH-8A72
        0x8AE7, # G+7699  U+8AE7  uni8AE7,  CJK UNIFIED IDEOGRAPH-8AE7
        0x9082, # G+7700  U+9082  uni9082,  CJK UNIFIED IDEOGRAPH-9082
        0x99ED, # G+7701  U+99ED  uni99ED,  CJK UNIFIED IDEOGRAPH-99ED
        0x9AB8, # G+7702  U+9AB8  uni9AB8,  CJK UNIFIED IDEOGRAPH-9AB8
        0x52BE, # G+7703  U+52BE  uni52BE,  CJK UNIFIED IDEOGRAPH-52BE
        0x6838, # G+7704  U+6838  uni6838,  CJK UNIFIED IDEOGRAPH-6838
        0x5016, # G+7705  U+5016  uni5016,  CJK UNIFIED IDEOGRAPH-5016
        0x5E78, # G+7706  U+5E78  uni5E78,  CJK UNIFIED IDEOGRAPH-5E78
        0x674F, # G+7707  U+674F  uni674F,  CJK UNIFIED IDEOGRAPH-674F
        0x8347, # G+7708  U+8347  uni8347,  CJK UNIFIED IDEOGRAPH-8347
        0x2F8F, # G+7709  U+2F8F  uni2F8F,  KANGXI RADICAL WALK ENCLOSURE
        0x4EAB, # G+7710  U+4EAB  uni4EAB,  CJK UNIFIED IDEOGRAPH-4EAB
        0x5411, # G+7711  U+5411  uni5411,  CJK UNIFIED IDEOGRAPH-5411
        0x56AE, # G+7712  U+56AE  uni56AE,  CJK UNIFIED IDEOGRAPH-56AE
        0x73E6, # G+7713  U+73E6  uni73E6,  CJK UNIFIED IDEOGRAPH-73E6
        0x9115, # G+7714  U+9115  uni9115,  CJK UNIFIED IDEOGRAPH-9115
        0x97FF, # G+7715  U+97FF  uni97FF,  CJK UNIFIED IDEOGRAPH-97FF
        0x9909, # G+7716  U+9909  uni9909,  CJK UNIFIED IDEOGRAPH-9909
        0x9957, # G+7717  U+9957  uni9957,  CJK UNIFIED IDEOGRAPH-9957
        0x2FB9, # G+7718  U+2FB9  uni2FB9,  KANGXI RADICAL FRAGRANT
        0x5653, # G+7719  U+5653  uni5653,  CJK UNIFIED IDEOGRAPH-5653
        0x589F, # G+7720  U+589F  uni589F,  CJK UNIFIED IDEOGRAPH-589F
        0x865B, # G+7721  U+865B  uni865B,  CJK UNIFIED IDEOGRAPH-865B
        0x8A31, # G+7722  U+8A31  uni8A31,  CJK UNIFIED IDEOGRAPH-8A31
        0x61B2, # G+7723  U+61B2  uni61B2,  CJK UNIFIED IDEOGRAPH-61B2
        0x6AF6, # G+7724  U+6AF6  uni6AF6,  CJK UNIFIED IDEOGRAPH-6AF6
        0x737B, # G+7725  U+737B  uni737B,  CJK UNIFIED IDEOGRAPH-737B
        0x8ED2, # G+7726  U+8ED2  uni8ED2,  CJK UNIFIED IDEOGRAPH-8ED2
        0x6B47, # G+7727  U+6B47  uni6B47,  CJK UNIFIED IDEOGRAPH-6B47
        0x96AA, # G+7728  U+96AA  uni96AA,  CJK UNIFIED IDEOGRAPH-96AA
        0x9A57, # G+7729  U+9A57  uni9A57,  CJK UNIFIED IDEOGRAPH-9A57
        0x5955, # G+7730  U+5955  uni5955,  CJK UNIFIED IDEOGRAPH-5955
        0x7200, # G+7731  U+7200  uni7200,  CJK UNIFIED IDEOGRAPH-7200
        0x8D6B, # G+7732  U+8D6B  uni8D6B,  CJK UNIFIED IDEOGRAPH-8D6B
        0x2FB0, # G+7733  U+2FB0  uni2FB0,  KANGXI RADICAL LEATHER
        0x4FD4, # G+7734  U+4FD4  uni4FD4,  CJK UNIFIED IDEOGRAPH-4FD4
        0x5CF4, # G+7735  U+5CF4  uni5CF4,  CJK UNIFIED IDEOGRAPH-5CF4
        0x5F26, # G+7736  U+5F26  uni5F26,  CJK UNIFIED IDEOGRAPH-5F26
        0x61F8, # G+7737  U+61F8  uni61F8,  CJK UNIFIED IDEOGRAPH-61F8
        0x665B, # G+7738  U+665B  uni665B,  CJK UNIFIED IDEOGRAPH-665B
        0x6CEB, # G+7739  U+6CEB  uni6CEB,  CJK UNIFIED IDEOGRAPH-6CEB
        0x70AB, # G+7740  U+70AB  uni70AB,  CJK UNIFIED IDEOGRAPH-70AB
        0x2F5E, # G+7741  U+2F5E  uni2F5E,  KANGXI RADICAL PROFOUND
        0x73B9, # G+7742  U+73B9  uni73B9,  CJK UNIFIED IDEOGRAPH-73B9
        0x73FE, # G+7743  U+73FE  uni73FE,  CJK UNIFIED IDEOGRAPH-73FE
        0x7729, # G+7744  U+7729  uni7729,  CJK UNIFIED IDEOGRAPH-7729
        0x774D, # G+7745  U+774D  uni774D,  CJK UNIFIED IDEOGRAPH-774D
        0x7D43, # G+7746  U+7D43  uni7D43,  CJK UNIFIED IDEOGRAPH-7D43
        0x7D62, # G+7747  U+7D62  uni7D62,  CJK UNIFIED IDEOGRAPH-7D62
        0x7E23, # G+7748  U+7E23  uni7E23,  CJK UNIFIED IDEOGRAPH-7E23
        0x8237, # G+7749  U+8237  uni8237,  CJK UNIFIED IDEOGRAPH-8237
        0x8852, # G+7750  U+8852  uni8852,  CJK UNIFIED IDEOGRAPH-8852
        0x8CE2, # G+7751  U+8CE2  uni8CE2,  CJK UNIFIED IDEOGRAPH-8CE2
        0x9249, # G+7752  U+9249  uni9249,  CJK UNIFIED IDEOGRAPH-9249
        0x986F, # G+7753  U+986F  uni986F,  CJK UNIFIED IDEOGRAPH-986F
        0x5B51, # G+7754  U+5B51  uni5B51,  CJK UNIFIED IDEOGRAPH-5B51
        0x2F73, # G+7755  U+2F73  uni2F73,  KANGXI RADICAL CAVE
        0x2F8E, # G+7756  U+2F8E  uni2F8E,  KANGXI RADICAL BLOOD
        0x2FB4, # G+7757  U+2FB4  uni2FB4,  KANGXI RADICAL LEAF
        0x5ACC, # G+7758  U+5ACC  uni5ACC,  CJK UNIFIED IDEOGRAPH-5ACC
        0x4FE0, # G+7759  U+4FE0  uni4FE0,  CJK UNIFIED IDEOGRAPH-4FE0
        0x5354, # G+7760  U+5354  uni5354,  CJK UNIFIED IDEOGRAPH-5354
        0x593E, # G+7761  U+593E  uni593E,  CJK UNIFIED IDEOGRAPH-593E
        0x5CFD, # G+7762  U+5CFD  uni5CFD,  CJK UNIFIED IDEOGRAPH-5CFD
        0x633E, # G+7763  U+633E  uni633E,  CJK UNIFIED IDEOGRAPH-633E
        0x6D79, # G+7764  U+6D79  uni6D79,  CJK UNIFIED IDEOGRAPH-6D79
        0x72F9, # G+7765  U+72F9  uni72F9,  CJK UNIFIED IDEOGRAPH-72F9
        0x8105, # G+7766  U+8105  uni8105,  CJK UNIFIED IDEOGRAPH-8105
        0x8107, # G+7767  U+8107  uni8107,  CJK UNIFIED IDEOGRAPH-8107
        0x83A2, # G+7768  U+83A2  uni83A2,  CJK UNIFIED IDEOGRAPH-83A2
        0x92CF, # G+7769  U+92CF  uni92CF,  CJK UNIFIED IDEOGRAPH-92CF
        0x9830, # G+7770  U+9830  uni9830,  CJK UNIFIED IDEOGRAPH-9830
        0x4EA8, # G+7771  U+4EA8  uni4EA8,  CJK UNIFIED IDEOGRAPH-4EA8
        0x5144, # G+7772  U+5144  uni5144,  CJK UNIFIED IDEOGRAPH-5144
        0x5211, # G+7773  U+5211  uni5211,  CJK UNIFIED IDEOGRAPH-5211
        0x578B, # G+7774  U+578B  uni578B,  CJK UNIFIED IDEOGRAPH-578B
        0x5F62, # G+7775  U+5F62  uni5F62,  CJK UNIFIED IDEOGRAPH-5F62
        0x6CC2, # G+7776  U+6CC2  uni6CC2,  CJK UNIFIED IDEOGRAPH-6CC2
        0x6ECE, # G+7777  U+6ECE  uni6ECE,  CJK UNIFIED IDEOGRAPH-6ECE
        0x7005, # G+7778  U+7005  uni7005,  CJK UNIFIED IDEOGRAPH-7005
        0x7050, # G+7779  U+7050  uni7050,  CJK UNIFIED IDEOGRAPH-7050
        0x70AF, # G+7780  U+70AF  uni70AF,  CJK UNIFIED IDEOGRAPH-70AF
        0x7192, # G+7781  U+7192  uni7192,  CJK UNIFIED IDEOGRAPH-7192
        0x73E9, # G+7782  U+73E9  uni73E9,  CJK UNIFIED IDEOGRAPH-73E9
        0x7469, # G+7783  U+7469  uni7469,  CJK UNIFIED IDEOGRAPH-7469
        0x834A, # G+7784  U+834A  uni834A,  CJK UNIFIED IDEOGRAPH-834A
        0x87A2, # G+7785  U+87A2  uni87A2,  CJK UNIFIED IDEOGRAPH-87A2
        0x8861, # G+7786  U+8861  uni8861,  CJK UNIFIED IDEOGRAPH-8861
        0x9008, # G+7787  U+9008  uni9008,  CJK UNIFIED IDEOGRAPH-9008
        0x90A2, # G+7788  U+90A2  uni90A2,  CJK UNIFIED IDEOGRAPH-90A2
        0x93A3, # G+7789  U+93A3  uni93A3,  CJK UNIFIED IDEOGRAPH-93A3
        0x99A8, # G+7790  U+99A8  uni99A8,  CJK UNIFIED IDEOGRAPH-99A8
        0x516E, # G+7791  U+516E  uni516E,  CJK UNIFIED IDEOGRAPH-516E
        0x5F57, # G+7792  U+5F57  uni5F57,  CJK UNIFIED IDEOGRAPH-5F57
        0x60E0, # G+7793  U+60E0  uni60E0,  CJK UNIFIED IDEOGRAPH-60E0
        0x6167, # G+7794  U+6167  uni6167,  CJK UNIFIED IDEOGRAPH-6167
        0x66B3, # G+7795  U+66B3  uni66B3,  CJK UNIFIED IDEOGRAPH-66B3
        0x8559, # G+7796  U+8559  uni8559,  CJK UNIFIED IDEOGRAPH-8559
        0x8E4A, # G+7797  U+8E4A  uni8E4A,  CJK UNIFIED IDEOGRAPH-8E4A
        0x91AF, # G+7798  U+91AF  uni91AF,  CJK UNIFIED IDEOGRAPH-91AF
        0x978B, # G+7799  U+978B  uni978B,  CJK UNIFIED IDEOGRAPH-978B
        0x4E4E, # G+7800  U+4E4E  uni4E4E,  CJK UNIFIED IDEOGRAPH-4E4E
        0x4E92, # G+7801  U+4E92  uni4E92,  CJK UNIFIED IDEOGRAPH-4E92
        0x547C, # G+7802  U+547C  uni547C,  CJK UNIFIED IDEOGRAPH-547C
        0x58D5, # G+7803  U+58D5  uni58D5,  CJK UNIFIED IDEOGRAPH-58D5
        0x58FA, # G+7804  U+58FA  uni58FA,  CJK UNIFIED IDEOGRAPH-58FA
        0x597D, # G+7805  U+597D  uni597D,  CJK UNIFIED IDEOGRAPH-597D
        0x5CB5, # G+7806  U+5CB5  uni5CB5,  CJK UNIFIED IDEOGRAPH-5CB5
        0x5F27, # G+7807  U+5F27  uni5F27,  CJK UNIFIED IDEOGRAPH-5F27
        0x2F3E, # G+7808  U+2F3E  uni2F3E,  KANGXI RADICAL DOOR
        0x6248, # G+7809  U+6248  uni6248,  CJK UNIFIED IDEOGRAPH-6248
        0x660A, # G+7810  U+660A  uni660A,  CJK UNIFIED IDEOGRAPH-660A
        0x6667, # G+7811  U+6667  uni6667,  CJK UNIFIED IDEOGRAPH-6667
        0x6BEB, # G+7812  U+6BEB  uni6BEB,  CJK UNIFIED IDEOGRAPH-6BEB
        0x6D69, # G+7813  U+6D69  uni6D69,  CJK UNIFIED IDEOGRAPH-6D69
        0x6DCF, # G+7814  U+6DCF  uni6DCF,  CJK UNIFIED IDEOGRAPH-6DCF
        0x6E56, # G+7815  U+6E56  uni6E56,  CJK UNIFIED IDEOGRAPH-6E56
        0x6EF8, # G+7816  U+6EF8  uni6EF8,  CJK UNIFIED IDEOGRAPH-6EF8
        0x6F94, # G+7817  U+6F94  uni6F94,  CJK UNIFIED IDEOGRAPH-6F94
        0x6FE0, # G+7818  U+6FE0  uni6FE0,  CJK UNIFIED IDEOGRAPH-6FE0
        0x6FE9, # G+7819  U+6FE9  uni6FE9,  CJK UNIFIED IDEOGRAPH-6FE9
        0x705D, # G+7820  U+705D  uni705D,  CJK UNIFIED IDEOGRAPH-705D
        0x72D0, # G+7821  U+72D0  uni72D0,  CJK UNIFIED IDEOGRAPH-72D0
        0x7425, # G+7822  U+7425  uni7425,  CJK UNIFIED IDEOGRAPH-7425
        0x745A, # G+7823  U+745A  uni745A,  CJK UNIFIED IDEOGRAPH-745A
        0x74E0, # G+7824  U+74E0  uni74E0,  CJK UNIFIED IDEOGRAPH-74E0
        0x7693, # G+7825  U+7693  uni7693,  CJK UNIFIED IDEOGRAPH-7693
        0x795C, # G+7826  U+795C  uni795C,  CJK UNIFIED IDEOGRAPH-795C
        0x7CCA, # G+7827  U+7CCA  uni7CCA,  CJK UNIFIED IDEOGRAPH-7CCA
        0x7E1E, # G+7828  U+7E1E  uni7E1E,  CJK UNIFIED IDEOGRAPH-7E1E
        0x80E1, # G+7829  U+80E1  uni80E1,  CJK UNIFIED IDEOGRAPH-80E1
        0x82A6, # G+7830  U+82A6  uni82A6,  CJK UNIFIED IDEOGRAPH-82A6
        0x846B, # G+7831  U+846B  uni846B,  CJK UNIFIED IDEOGRAPH-846B
        0x84BF, # G+7832  U+84BF  uni84BF,  CJK UNIFIED IDEOGRAPH-84BF
        0x864E, # G+7833  U+864E  uni864E,  CJK UNIFIED IDEOGRAPH-864E
        0x865F, # G+7834  U+865F  uni865F,  CJK UNIFIED IDEOGRAPH-865F
        0x8774, # G+7835  U+8774  uni8774,  CJK UNIFIED IDEOGRAPH-8774
        0x8B77, # G+7836  U+8B77  uni8B77,  CJK UNIFIED IDEOGRAPH-8B77
        0x8C6A, # G+7837  U+8C6A  uni8C6A,  CJK UNIFIED IDEOGRAPH-8C6A
        0x93AC, # G+7838  U+93AC  uni93AC,  CJK UNIFIED IDEOGRAPH-93AC
        0x9800, # G+7839  U+9800  uni9800,  CJK UNIFIED IDEOGRAPH-9800
        0x9865, # G+7840  U+9865  uni9865,  CJK UNIFIED IDEOGRAPH-9865
        0x60D1, # G+7841  U+60D1  uni60D1,  CJK UNIFIED IDEOGRAPH-60D1
        0x6216, # G+7842  U+6216  uni6216,  CJK UNIFIED IDEOGRAPH-6216
        0x9177, # G+7843  U+9177  uni9177,  CJK UNIFIED IDEOGRAPH-9177
        0x5A5A, # G+7844  U+5A5A  uni5A5A,  CJK UNIFIED IDEOGRAPH-5A5A
        0x660F, # G+7845  U+660F  uni660F,  CJK UNIFIED IDEOGRAPH-660F
        0x6DF7, # G+7846  U+6DF7  uni6DF7,  CJK UNIFIED IDEOGRAPH-6DF7
        0x6E3E, # G+7847  U+6E3E  uni6E3E,  CJK UNIFIED IDEOGRAPH-6E3E
        0x743F, # G+7848  U+743F  uni743F,  CJK UNIFIED IDEOGRAPH-743F
        0x9B42, # G+7849  U+9B42  uni9B42,  CJK UNIFIED IDEOGRAPH-9B42
        0x5FFD, # G+7850  U+5FFD  uni5FFD,  CJK UNIFIED IDEOGRAPH-5FFD
        0x60DA, # G+7851  U+60DA  uni60DA,  CJK UNIFIED IDEOGRAPH-60DA
        0x7B0F, # G+7852  U+7B0F  uni7B0F,  CJK UNIFIED IDEOGRAPH-7B0F
        0x54C4, # G+7853  U+54C4  uni54C4,  CJK UNIFIED IDEOGRAPH-54C4
        0x5F18, # G+7854  U+5F18  uni5F18,  CJK UNIFIED IDEOGRAPH-5F18
        0x6C5E, # G+7855  U+6C5E  uni6C5E,  CJK UNIFIED IDEOGRAPH-6C5E
        0x6CD3, # G+7856  U+6CD3  uni6CD3,  CJK UNIFIED IDEOGRAPH-6CD3
        0x6D2A, # G+7857  U+6D2A  uni6D2A,  CJK UNIFIED IDEOGRAPH-6D2A
        0x70D8, # G+7858  U+70D8  uni70D8,  CJK UNIFIED IDEOGRAPH-70D8
        0x7D05, # G+7859  U+7D05  uni7D05,  CJK UNIFIED IDEOGRAPH-7D05
        0x8679, # G+7860  U+8679  uni8679,  CJK UNIFIED IDEOGRAPH-8679
        0x8A0C, # G+7861  U+8A0C  uni8A0C,  CJK UNIFIED IDEOGRAPH-8A0C
        0x9D3B, # G+7862  U+9D3B  uni9D3B,  CJK UNIFIED IDEOGRAPH-9D3B
        0x5316, # G+7863  U+5316  uni5316,  CJK UNIFIED IDEOGRAPH-5316
        0x548C, # G+7864  U+548C  uni548C,  CJK UNIFIED IDEOGRAPH-548C
        0x5B05, # G+7865  U+5B05  uni5B05,  CJK UNIFIED IDEOGRAPH-5B05
        0x6A3A, # G+7866  U+6A3A  uni6A3A,  CJK UNIFIED IDEOGRAPH-6A3A
        0x2F55, # G+7867  U+2F55  uni2F55,  KANGXI RADICAL FIRE
        0x7575, # G+7868  U+7575  uni7575,  CJK UNIFIED IDEOGRAPH-7575
        0x798D, # G+7869  U+798D  uni798D,  CJK UNIFIED IDEOGRAPH-798D
        0x2F72, # G+7870  U+2F72  uni2F72,  KANGXI RADICAL GRAIN
        0x82B1, # G+7871  U+82B1  uni82B1,  CJK UNIFIED IDEOGRAPH-82B1
        0x83EF, # G+7872  U+83EF  uni83EF,  CJK UNIFIED IDEOGRAPH-83EF
        0x8A71, # G+7873  U+8A71  uni8A71,  CJK UNIFIED IDEOGRAPH-8A71
        0x8B41, # G+7874  U+8B41  uni8B41,  CJK UNIFIED IDEOGRAPH-8B41
        0x8CA8, # G+7875  U+8CA8  uni8CA8,  CJK UNIFIED IDEOGRAPH-8CA8
        0x9774, # G+7876  U+9774  uni9774,  CJK UNIFIED IDEOGRAPH-9774
        0x64F4, # G+7877  U+64F4  uni64F4,  CJK UNIFIED IDEOGRAPH-64F4
        0x652B, # G+7878  U+652B  uni652B,  CJK UNIFIED IDEOGRAPH-652B
        0x78BA, # G+7879  U+78BA  uni78BA,  CJK UNIFIED IDEOGRAPH-78BA
        0x78BB, # G+7880  U+78BB  uni78BB,  CJK UNIFIED IDEOGRAPH-78BB
        0x7A6B, # G+7881  U+7A6B  uni7A6B,  CJK UNIFIED IDEOGRAPH-7A6B
        0x4E38, # G+7882  U+4E38  uni4E38,  CJK UNIFIED IDEOGRAPH-4E38
        0x559A, # G+7883  U+559A  uni559A,  CJK UNIFIED IDEOGRAPH-559A
        0x5950, # G+7884  U+5950  uni5950,  CJK UNIFIED IDEOGRAPH-5950
        0x5BA6, # G+7885  U+5BA6  uni5BA6,  CJK UNIFIED IDEOGRAPH-5BA6
        0x5E7B, # G+7886  U+5E7B  uni5E7B,  CJK UNIFIED IDEOGRAPH-5E7B
        0x60A3, # G+7887  U+60A3  uni60A3,  CJK UNIFIED IDEOGRAPH-60A3
        0x63DB, # G+7888  U+63DB  uni63DB,  CJK UNIFIED IDEOGRAPH-63DB
        0x6B61, # G+7889  U+6B61  uni6B61,  CJK UNIFIED IDEOGRAPH-6B61
        0x6665, # G+7890  U+6665  uni6665,  CJK UNIFIED IDEOGRAPH-6665
        0x6853, # G+7891  U+6853  uni6853,  CJK UNIFIED IDEOGRAPH-6853
        0x6E19, # G+7892  U+6E19  uni6E19,  CJK UNIFIED IDEOGRAPH-6E19
        0x7165, # G+7893  U+7165  uni7165,  CJK UNIFIED IDEOGRAPH-7165
        0x74B0, # G+7894  U+74B0  uni74B0,  CJK UNIFIED IDEOGRAPH-74B0
        0x7D08, # G+7895  U+7D08  uni7D08,  CJK UNIFIED IDEOGRAPH-7D08
        0x9084, # G+7896  U+9084  uni9084,  CJK UNIFIED IDEOGRAPH-9084
        0x9A69, # G+7897  U+9A69  uni9A69,  CJK UNIFIED IDEOGRAPH-9A69
        0x9C25, # G+7898  U+9C25  uni9C25,  CJK UNIFIED IDEOGRAPH-9C25
        0x6D3B, # G+7899  U+6D3B  uni6D3B,  CJK UNIFIED IDEOGRAPH-6D3B
        0x6ED1, # G+7900  U+6ED1  uni6ED1,  CJK UNIFIED IDEOGRAPH-6ED1
        0x733E, # G+7901  U+733E  uni733E,  CJK UNIFIED IDEOGRAPH-733E
        0x8C41, # G+7902  U+8C41  uni8C41,  CJK UNIFIED IDEOGRAPH-8C41
        0x95CA, # G+7903  U+95CA  uni95CA,  CJK UNIFIED IDEOGRAPH-95CA
        0x51F0, # G+7904  U+51F0  uni51F0,  CJK UNIFIED IDEOGRAPH-51F0
        0x5E4C, # G+7905  U+5E4C  uni5E4C,  CJK UNIFIED IDEOGRAPH-5E4C
        0x5FA8, # G+7906  U+5FA8  uni5FA8,  CJK UNIFIED IDEOGRAPH-5FA8
        0x604D, # G+7907  U+604D  uni604D,  CJK UNIFIED IDEOGRAPH-604D
        0x60F6, # G+7908  U+60F6  uni60F6,  CJK UNIFIED IDEOGRAPH-60F6
        0x6130, # G+7909  U+6130  uni6130,  CJK UNIFIED IDEOGRAPH-6130
        0x614C, # G+7910  U+614C  uni614C,  CJK UNIFIED IDEOGRAPH-614C
        0x6643, # G+7911  U+6643  uni6643,  CJK UNIFIED IDEOGRAPH-6643
        0x6644, # G+7912  U+6644  uni6644,  CJK UNIFIED IDEOGRAPH-6644
        0x69A5, # G+7913  U+69A5  uni69A5,  CJK UNIFIED IDEOGRAPH-69A5
        0x6CC1, # G+7914  U+6CC1  uni6CC1,  CJK UNIFIED IDEOGRAPH-6CC1
        0x6E5F, # G+7915  U+6E5F  uni6E5F,  CJK UNIFIED IDEOGRAPH-6E5F
        0x6EC9, # G+7916  U+6EC9  uni6EC9,  CJK UNIFIED IDEOGRAPH-6EC9
        0x6F62, # G+7917  U+6F62  uni6F62,  CJK UNIFIED IDEOGRAPH-6F62
        0x714C, # G+7918  U+714C  uni714C,  CJK UNIFIED IDEOGRAPH-714C
        0x749C, # G+7919  U+749C  uni749C,  CJK UNIFIED IDEOGRAPH-749C
        0x7687, # G+7920  U+7687  uni7687,  CJK UNIFIED IDEOGRAPH-7687
        0x7BC1, # G+7921  U+7BC1  uni7BC1,  CJK UNIFIED IDEOGRAPH-7BC1
        0x7C27, # G+7922  U+7C27  uni7C27,  CJK UNIFIED IDEOGRAPH-7C27
        0x8352, # G+7923  U+8352  uni8352,  CJK UNIFIED IDEOGRAPH-8352
        0x8757, # G+7924  U+8757  uni8757,  CJK UNIFIED IDEOGRAPH-8757
        0x9051, # G+7925  U+9051  uni9051,  CJK UNIFIED IDEOGRAPH-9051
        0x968D, # G+7926  U+968D  uni968D,  CJK UNIFIED IDEOGRAPH-968D
        0x2FC8, # G+7927  U+2FC8  uni2FC8,  KANGXI RADICAL YELLOW
        0x532F, # G+7928  U+532F  uni532F,  CJK UNIFIED IDEOGRAPH-532F
        0x56DE, # G+7929  U+56DE  uni56DE,  CJK UNIFIED IDEOGRAPH-56DE
        0x5EFB, # G+7930  U+5EFB  uni5EFB,  CJK UNIFIED IDEOGRAPH-5EFB
        0x5F8A, # G+7931  U+5F8A  uni5F8A,  CJK UNIFIED IDEOGRAPH-5F8A
        0x6062, # G+7932  U+6062  uni6062,  CJK UNIFIED IDEOGRAPH-6062
        0x6094, # G+7933  U+6094  uni6094,  CJK UNIFIED IDEOGRAPH-6094
        0x61F7, # G+7934  U+61F7  uni61F7,  CJK UNIFIED IDEOGRAPH-61F7
        0x6666, # G+7935  U+6666  uni6666,  CJK UNIFIED IDEOGRAPH-6666
        0x6703, # G+7936  U+6703  uni6703,  CJK UNIFIED IDEOGRAPH-6703
        0x6A9C, # G+7937  U+6A9C  uni6A9C,  CJK UNIFIED IDEOGRAPH-6A9C
        0x6DEE, # G+7938  U+6DEE  uni6DEE,  CJK UNIFIED IDEOGRAPH-6DEE
        0x6FAE, # G+7939  U+6FAE  uni6FAE,  CJK UNIFIED IDEOGRAPH-6FAE
        0x7070, # G+7940  U+7070  uni7070,  CJK UNIFIED IDEOGRAPH-7070
        0x736A, # G+7941  U+736A  uni736A,  CJK UNIFIED IDEOGRAPH-736A
        0x7E6A, # G+7942  U+7E6A  uni7E6A,  CJK UNIFIED IDEOGRAPH-7E6A
        0x81BE, # G+7943  U+81BE  uni81BE,  CJK UNIFIED IDEOGRAPH-81BE
        0x8334, # G+7944  U+8334  uni8334,  CJK UNIFIED IDEOGRAPH-8334
        0x86D4, # G+7945  U+86D4  uni86D4,  CJK UNIFIED IDEOGRAPH-86D4
        0x8AA8, # G+7946  U+8AA8  uni8AA8,  CJK UNIFIED IDEOGRAPH-8AA8
        0x8CC4, # G+7947  U+8CC4  uni8CC4,  CJK UNIFIED IDEOGRAPH-8CC4
        0x5283, # G+7948  U+5283  uni5283,  CJK UNIFIED IDEOGRAPH-5283
        0x7372, # G+7949  U+7372  uni7372,  CJK UNIFIED IDEOGRAPH-7372
        0x5B96, # G+7950  U+5B96  uni5B96,  CJK UNIFIED IDEOGRAPH-5B96
        0x6A6B, # G+7951  U+6A6B  uni6A6B,  CJK UNIFIED IDEOGRAPH-6A6B
        0x9404, # G+7952  U+9404  uni9404,  CJK UNIFIED IDEOGRAPH-9404
        0x54EE, # G+7953  U+54EE  uni54EE,  CJK UNIFIED IDEOGRAPH-54EE
        0x5686, # G+7954  U+5686  uni5686,  CJK UNIFIED IDEOGRAPH-5686
        0x5B5D, # G+7955  U+5B5D  uni5B5D,  CJK UNIFIED IDEOGRAPH-5B5D
        0x6548, # G+7956  U+6548  uni6548,  CJK UNIFIED IDEOGRAPH-6548
        0x6585, # G+7957  U+6585  uni6585,  CJK UNIFIED IDEOGRAPH-6585
        0x66C9, # G+7958  U+66C9  uni66C9,  CJK UNIFIED IDEOGRAPH-66C9
        0x689F, # G+7959  U+689F  uni689F,  CJK UNIFIED IDEOGRAPH-689F
        0x6D8D, # G+7960  U+6D8D  uni6D8D,  CJK UNIFIED IDEOGRAPH-6D8D
        0x6DC6, # G+7961  U+6DC6  uni6DC6,  CJK UNIFIED IDEOGRAPH-6DC6
        0x2F58, # G+7962  U+2F58  uni2F58,  KANGXI RADICAL DOUBLE X
        0x80B4, # G+7963  U+80B4  uni80B4,  CJK UNIFIED IDEOGRAPH-80B4
        0x9175, # G+7964  U+9175  uni9175,  CJK UNIFIED IDEOGRAPH-9175
        0x9A4D, # G+7965  U+9A4D  uni9A4D,  CJK UNIFIED IDEOGRAPH-9A4D
        0x4FAF, # G+7966  U+4FAF  uni4FAF,  CJK UNIFIED IDEOGRAPH-4FAF
        0x5019, # G+7967  U+5019  uni5019,  CJK UNIFIED IDEOGRAPH-5019
        0x539A, # G+7968  U+539A  uni539A,  CJK UNIFIED IDEOGRAPH-539A
        0x540E, # G+7969  U+540E  uni540E,  CJK UNIFIED IDEOGRAPH-540E
        0x543C, # G+7970  U+543C  uni543C,  CJK UNIFIED IDEOGRAPH-543C
        0x5589, # G+7971  U+5589  uni5589,  CJK UNIFIED IDEOGRAPH-5589
        0x55C5, # G+7972  U+55C5  uni55C5,  CJK UNIFIED IDEOGRAPH-55C5
        0x5E3F, # G+7973  U+5E3F  uni5E3F,  CJK UNIFIED IDEOGRAPH-5E3F
        0x5F8C, # G+7974  U+5F8C  uni5F8C,  CJK UNIFIED IDEOGRAPH-5F8C
        0x673D, # G+7975  U+673D  uni673D,  CJK UNIFIED IDEOGRAPH-673D
        0x7166, # G+7976  U+7166  uni7166,  CJK UNIFIED IDEOGRAPH-7166
        0x73DD, # G+7977  U+73DD  uni73DD,  CJK UNIFIED IDEOGRAPH-73DD
        0x9005, # G+7978  U+9005  uni9005,  CJK UNIFIED IDEOGRAPH-9005
        0x52DB, # G+7979  U+52DB  uni52DB,  CJK UNIFIED IDEOGRAPH-52DB
        0x52F3, # G+7980  U+52F3  uni52F3,  CJK UNIFIED IDEOGRAPH-52F3
        0x5864, # G+7981  U+5864  uni5864,  CJK UNIFIED IDEOGRAPH-5864
        0x58CE, # G+7982  U+58CE  uni58CE,  CJK UNIFIED IDEOGRAPH-58CE
        0x7104, # G+7983  U+7104  uni7104,  CJK UNIFIED IDEOGRAPH-7104
        0x718F, # G+7984  U+718F  uni718F,  CJK UNIFIED IDEOGRAPH-718F
        0x71FB, # G+7985  U+71FB  uni71FB,  CJK UNIFIED IDEOGRAPH-71FB
        0x85B0, # G+7986  U+85B0  uni85B0,  CJK UNIFIED IDEOGRAPH-85B0
        0x8A13, # G+7987  U+8A13  uni8A13,  CJK UNIFIED IDEOGRAPH-8A13
        0x6688, # G+7988  U+6688  uni6688,  CJK UNIFIED IDEOGRAPH-6688
        0x85A8, # G+7989  U+85A8  uni85A8,  CJK UNIFIED IDEOGRAPH-85A8
        0x55A7, # G+7990  U+55A7  uni55A7,  CJK UNIFIED IDEOGRAPH-55A7
        0x6684, # G+7991  U+6684  uni6684,  CJK UNIFIED IDEOGRAPH-6684
        0x714A, # G+7992  U+714A  uni714A,  CJK UNIFIED IDEOGRAPH-714A
        0x8431, # G+7993  U+8431  uni8431,  CJK UNIFIED IDEOGRAPH-8431
        0x5349, # G+7994  U+5349  uni5349,  CJK UNIFIED IDEOGRAPH-5349
        0x5599, # G+7995  U+5599  uni5599,  CJK UNIFIED IDEOGRAPH-5599
        0x6BC1, # G+7996  U+6BC1  uni6BC1,  CJK UNIFIED IDEOGRAPH-6BC1
        0x5F59, # G+7997  U+5F59  uni5F59,  CJK UNIFIED IDEOGRAPH-5F59
        0x5FBD, # G+7998  U+5FBD  uni5FBD,  CJK UNIFIED IDEOGRAPH-5FBD
        0x63EE, # G+7999  U+63EE  uni63EE,  CJK UNIFIED IDEOGRAPH-63EE
        0x6689, # G+8000  U+6689  uni6689,  CJK UNIFIED IDEOGRAPH-6689
        0x7147, # G+8001  U+7147  uni7147,  CJK UNIFIED IDEOGRAPH-7147
        0x8AF1, # G+8002  U+8AF1  uni8AF1,  CJK UNIFIED IDEOGRAPH-8AF1
        0x8F1D, # G+8003  U+8F1D  uni8F1D,  CJK UNIFIED IDEOGRAPH-8F1D
        0x9EBE, # G+8004  U+9EBE  uni9EBE,  CJK UNIFIED IDEOGRAPH-9EBE
        0x4F11, # G+8005  U+4F11  uni4F11,  CJK UNIFIED IDEOGRAPH-4F11
        0x643A, # G+8006  U+643A  uni643A,  CJK UNIFIED IDEOGRAPH-643A
        0x70CB, # G+8007  U+70CB  uni70CB,  CJK UNIFIED IDEOGRAPH-70CB
        0x7566, # G+8008  U+7566  uni7566,  CJK UNIFIED IDEOGRAPH-7566
        0x8667, # G+8009  U+8667  uni8667,  CJK UNIFIED IDEOGRAPH-8667
        0x6064, # G+8010  U+6064  uni6064,  CJK UNIFIED IDEOGRAPH-6064
        0x8B4E, # G+8011  U+8B4E  uni8B4E,  CJK UNIFIED IDEOGRAPH-8B4E
        0x9DF8, # G+8012  U+9DF8  uni9DF8,  CJK UNIFIED IDEOGRAPH-9DF8
        0x5147, # G+8013  U+5147  uni5147,  CJK UNIFIED IDEOGRAPH-5147
        0x51F6, # G+8014  U+51F6  uni51F6,  CJK UNIFIED IDEOGRAPH-51F6
        0x5308, # G+8015  U+5308  uni5308,  CJK UNIFIED IDEOGRAPH-5308
        0x6D36, # G+8016  U+6D36  uni6D36,  CJK UNIFIED IDEOGRAPH-6D36
        0x80F8, # G+8017  U+80F8  uni80F8,  CJK UNIFIED IDEOGRAPH-80F8
        0x2FCA, # G+8018  U+2FCA  uni2FCA,  KANGXI RADICAL BLACK
        0x6615, # G+8019  U+6615  uni6615,  CJK UNIFIED IDEOGRAPH-6615
        0x6B23, # G+8020  U+6B23  uni6B23,  CJK UNIFIED IDEOGRAPH-6B23
        0x7098, # G+8021  U+7098  uni7098,  CJK UNIFIED IDEOGRAPH-7098
        0x75D5, # G+8022  U+75D5  uni75D5,  CJK UNIFIED IDEOGRAPH-75D5
        0x5403, # G+8023  U+5403  uni5403,  CJK UNIFIED IDEOGRAPH-5403
        0x5C79, # G+8024  U+5C79  uni5C79,  CJK UNIFIED IDEOGRAPH-5C79
        0x7D07, # G+8025  U+7D07  uni7D07,  CJK UNIFIED IDEOGRAPH-7D07
        0x8A16, # G+8026  U+8A16  uni8A16,  CJK UNIFIED IDEOGRAPH-8A16
        0x2F4B, # G+8027  U+2F4B  uni2F4B,  KANGXI RADICAL LACK
        0x6B3D, # G+8028  U+6B3D  uni6B3D,  CJK UNIFIED IDEOGRAPH-6B3D
        0x6B46, # G+8029  U+6B46  uni6B46,  CJK UNIFIED IDEOGRAPH-6B46
        0x5438, # G+8030  U+5438  uni5438,  CJK UNIFIED IDEOGRAPH-5438
        0x6070, # G+8031  U+6070  uni6070,  CJK UNIFIED IDEOGRAPH-6070
        0x6D3D, # G+8032  U+6D3D  uni6D3D,  CJK UNIFIED IDEOGRAPH-6D3D
        0x7FD5, # G+8033  U+7FD5  uni7FD5,  CJK UNIFIED IDEOGRAPH-7FD5
        0x8208, # G+8034  U+8208  uni8208,  CJK UNIFIED IDEOGRAPH-8208
        0x50D6, # G+8035  U+50D6  uni50D6,  CJK UNIFIED IDEOGRAPH-50D6
        0x51DE, # G+8036  U+51DE  uni51DE,  CJK UNIFIED IDEOGRAPH-51DE
        0x559C, # G+8037  U+559C  uni559C,  CJK UNIFIED IDEOGRAPH-559C
        0x566B, # G+8038  U+566B  uni566B,  CJK UNIFIED IDEOGRAPH-566B
        0x56CD, # G+8039  U+56CD  uni56CD,  CJK UNIFIED IDEOGRAPH-56CD
        0x59EC, # G+8040  U+59EC  uni59EC,  CJK UNIFIED IDEOGRAPH-59EC
        0x5B09, # G+8041  U+5B09  uni5B09,  CJK UNIFIED IDEOGRAPH-5B09
        0x5E0C, # G+8042  U+5E0C  uni5E0C,  CJK UNIFIED IDEOGRAPH-5E0C
        0x6199, # G+8043  U+6199  uni6199,  CJK UNIFIED IDEOGRAPH-6199
        0x6198, # G+8044  U+6198  uni6198,  CJK UNIFIED IDEOGRAPH-6198
        0x6231, # G+8045  U+6231  uni6231,  CJK UNIFIED IDEOGRAPH-6231
        0x665E, # G+8046  U+665E  uni665E,  CJK UNIFIED IDEOGRAPH-665E
        0x66E6, # G+8047  U+66E6  uni66E6,  CJK UNIFIED IDEOGRAPH-66E6
        0x7199, # G+8048  U+7199  uni7199,  CJK UNIFIED IDEOGRAPH-7199
        0x71B9, # G+8049  U+71B9  uni71B9,  CJK UNIFIED IDEOGRAPH-71B9
        0x71BA, # G+8050  U+71BA  uni71BA,  CJK UNIFIED IDEOGRAPH-71BA
        0x72A7, # G+8051  U+72A7  uni72A7,  CJK UNIFIED IDEOGRAPH-72A7
        0x79A7, # G+8052  U+79A7  uni79A7,  CJK UNIFIED IDEOGRAPH-79A7
        0x7A00, # G+8053  U+7A00  uni7A00,  CJK UNIFIED IDEOGRAPH-7A00
        0x7FB2, # G+8054  U+7FB2  uni7FB2,  CJK UNIFIED IDEOGRAPH-7FB2
        0x8A70, # G+8055  U+8A70  uni8A70,  CJK UNIFIED IDEOGRAPH-8A70
        0x3001, # G+8056  U+3001  uni3001,  IDEOGRAPHIC COMMA
        0x3002, # G+8057  U+3002  uni3002,  IDEOGRAPHIC FULL STOP
        0x2025, # G+8058  U+2025  twodotenleader,  TWO DOT LEADER
        0x2013, # G+8059  U+2013  endash,  EN DASH
        0x2014, # G+8060  U+2014  emdash,  EM DASH
        0x2016, # G+8061  U+2016  uni2016,  DOUBLE VERTICAL LINE
        0xFF5E, # G+8062  U+FF5E  uniFF5E,  FULLWIDTH TILDE
        0x3014, # G+8063  U+3014  uni3014,  LEFT TORTOISE SHELL BRACKET
        0x3015, # G+8064  U+3015  uni3015,  RIGHT TORTOISE SHELL BRACKET
        0x3008, # G+8065  U+3008  uni3008,  LEFT ANGLE BRACKET
        0x3009, # G+8066  U+3009  uni3009,  RIGHT ANGLE BRACKET
        0x300A, # G+8067  U+300A  uni300A,  LEFT DOUBLE ANGLE BRACKET
        0x300B, # G+8068  U+300B  uni300B,  RIGHT DOUBLE ANGLE BRACKET
        0x300C, # G+8069  U+300C  uni300C,  LEFT CORNER BRACKET
        0x300D, # G+8070  U+300D  uni300D,  RIGHT CORNER BRACKET
        0x300E, # G+8071  U+300E  uni300E,  LEFT WHITE CORNER BRACKET
        0x300F, # G+8072  U+300F  uni300F,  RIGHT WHITE CORNER BRACKET
        0x3010, # G+8073  U+3010  uni3010,  LEFT BLACK LENTICULAR BRACKET
        0x3011, # G+8074  U+3011  uni3011,  RIGHT BLACK LENTICULAR BRACKET
        0x3013, # G+8075  U+3013  uni3013,  GETA MARK
        0xFF01, # G+8076  U+FF01  uniFF01,  FULLWIDTH EXCLAMATION MARK
        0xFF08, # G+8077  U+FF08  uniFF08,  FULLWIDTH LEFT PARENTHESIS
        0xFF09, # G+8078  U+FF09  uniFF09,  FULLWIDTH RIGHT PARENTHESIS
        0xFF0C, # G+8079  U+FF0C  uniFF0C,  FULLWIDTH COMMA
        0xFF0E, # G+8080  U+FF0E  uniFF0E,  FULLWIDTH FULL STOP
        0xFF1A, # G+8081  U+FF1A  uniFF1A,  FULLWIDTH COLON
        0xFF1B, # G+8082  U+FF1B  uniFF1B,  FULLWIDTH SEMICOLON
        0xFF1C, # G+8083  U+FF1C  uniFF1C,  FULLWIDTH LESS-THAN SIGN
        0xFF1D, # G+8084  U+FF1D  uniFF1D,  FULLWIDTH EQUALS SIGN
        0xFF1E, # G+8085  U+FF1E  uniFF1E,  FULLWIDTH GREATER-THAN SIGN
        0xFF1F, # G+8086  U+FF1F  uniFF1F,  FULLWIDTH QUESTION MARK
        0xFF3B, # G+8087  U+FF3B  uniFF3B,  FULLWIDTH LEFT SQUARE BRACKET
        0xFF3D, # G+8088  U+FF3D  uniFF3D,  FULLWIDTH RIGHT SQUARE BRACKET
        0xFF3F, # G+8089  U+FF3F  uniFF3F,  FULLWIDTH LOW LINE
        0xFF5B, # G+8090  U+FF5B  uniFF5B,  FULLWIDTH LEFT CURLY BRACKET
        0xFF5C, # G+8091  U+FF5C  uniFF5C,  FULLWIDTH VERTICAL LINE
        0xFF5D, # G+8092  U+FF5D  uniFF5D,  FULLWIDTH RIGHT CURLY BRACKET
        0xFFE3, # G+8093  U+FFE3  uniFFE3,  FULLWIDTH MACRON
        0x0000, # G+8094  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8095  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8096  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8097  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8098  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8099  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8100  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8109  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8110  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8111  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8112  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8114  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8115  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8116  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8117  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8118  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8119  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8120  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8121  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8122  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8123  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8125  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8126  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8127  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8128  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8129  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8130  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8131  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8132  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8133  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8134  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8135  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8136  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8137  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8138  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8139  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8140  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8141  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8142  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8143  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8144  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8145  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8146  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8147  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8148  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8149  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8150  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8151  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8152  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8153  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8154  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8156  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8157  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8158  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8159  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8160  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8161  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8162  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8163  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8164  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8165  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8166  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8172  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8173  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8175  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8176  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8177  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8178  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8181  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8182  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8183  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8184  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8185  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8186  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8187  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8188  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8189  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8190  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8191  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8192  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8193  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8194  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8195  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8196  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8197  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8198  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8199  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8200  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8201  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8202  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8203  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8204  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8205  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8206  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8207  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8208  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8209  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8210  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8211  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8212  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8213  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8214  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8215  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8216  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8217  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8218  U+0000  .notdef,  UNDEFINED
        0x3016, # G+8219  U+3016  uni3016,  LEFT WHITE LENTICULAR BRACKET
        0x3017, # G+8220  U+3017  uni3017,  RIGHT WHITE LENTICULAR BRACKET
        0x3018, # G+8221  U+3018  uni3018,  LEFT WHITE TORTOISE SHELL BRACKET
        0x3019, # G+8222  U+3019  uni3019,  RIGHT WHITE TORTOISE SHELL BRACKET
        0x0000, # G+8223  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8224  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8225  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8226  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8229  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8230  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8231  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8232  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8233  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8234  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8235  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8236  U+0000  .notdef,  UNDEFINED
        0x201F, # G+8237  U+201F  uni201F,  DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        0x201B, # G+8238  U+201B  quotereversed,  SINGLE HIGH-REVERSED-9 QUOTATION MARK
        0x207A, # G+8239  U+207A  uni207A,  SUPERSCRIPT PLUS SIGN
        0x207B, # G+8240  U+207B  uni207B,  SUPERSCRIPT MINUS
        0x0000, # G+8241  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8242  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8243  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8244  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8245  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8246  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8247  U+0000  .notdef,  UNDEFINED
        0x207C, # G+8248  U+207C  uni207C,  SUPERSCRIPT EQUALS SIGN
        0x0000, # G+8249  U+0000  .notdef,  UNDEFINED
        0x207D, # G+8250  U+207D  parenleftsuperior,  SUPERSCRIPT LEFT PARENTHESIS
        0x207E, # G+8251  U+207E  parenrightsuperior,  SUPERSCRIPT RIGHT PARENTHESIS
        0x0000, # G+8252  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8253  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8254  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8256  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8257  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8258  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8259  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8260  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8261  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8262  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8263  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8265  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8266  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8267  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8268  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8269  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8270  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8271  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8272  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8273  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8274  U+0000  .notdef,  UNDEFINED
        0x02BC, # G+8275  U+02BC  afii57929,  MODIFIER LETTER APOSTROPHE
        0x0000, # G+8276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8278  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8279  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8280  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8281  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8282  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8283  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8284  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8285  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8286  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8287  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8288  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8289  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8290  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8291  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8292  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8293  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8294  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8295  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8296  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8297  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8298  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8299  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8300  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8301  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8302  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8303  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8304  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8305  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8306  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8307  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8308  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8309  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8310  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8311  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8312  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8313  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8314  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8315  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8316  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8317  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8318  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8319  U+0000  .notdef,  UNDEFINED
        0x22EE, # G+8320  U+22EE  uni22EE,  VERTICAL ELLIPSIS
        0x2237, # G+8321  U+2237  uni2237,  PROPORTION
        0x0000, # G+8322  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8323  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8324  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8325  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8326  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8327  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8328  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8329  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8330  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8331  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8332  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8333  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8334  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8335  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8336  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8337  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8338  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8339  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8340  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8341  U+0000  .notdef,  UNDEFINED
        0x278A, # G+8342  U+278A  a150,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE
        0x278B, # G+8343  U+278B  a151,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO
        0x278C, # G+8344  U+278C  a152,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE
        0x278D, # G+8345  U+278D  a153,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR
        0x278E, # G+8346  U+278E  a154,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE
        0x278F, # G+8347  U+278F  a155,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX
        0x2790, # G+8348  U+2790  a156,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN
        0x2791, # G+8349  U+2791  a157,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT
        0x2792, # G+8350  U+2792  a158,  DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE
        0x2793, # G+8351  U+2793  a159,  DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN
        0x0000, # G+8352  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8353  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8354  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8355  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8356  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8357  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8358  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8359  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8360  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8361  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8362  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8363  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8364  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8365  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8366  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8367  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8368  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8369  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8370  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8371  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8372  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8373  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8374  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8375  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8376  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8377  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8378  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8379  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8380  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8381  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8382  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8383  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8384  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8385  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8386  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8387  U+0000  .notdef,  UNDEFINED
        0x24B6, # G+8388  U+24B6  uni24B6,  CIRCLED LATIN CAPITAL LETTER A
        0x24B7, # G+8389  U+24B7  uni24B7,  CIRCLED LATIN CAPITAL LETTER B
        0x24B8, # G+8390  U+24B8  uni24B8,  CIRCLED LATIN CAPITAL LETTER C
        0x24B9, # G+8391  U+24B9  uni24B9,  CIRCLED LATIN CAPITAL LETTER D
        0x24BA, # G+8392  U+24BA  uni24BA,  CIRCLED LATIN CAPITAL LETTER E
        0x24BB, # G+8393  U+24BB  uni24BB,  CIRCLED LATIN CAPITAL LETTER F
        0x24BC, # G+8394  U+24BC  uni24BC,  CIRCLED LATIN CAPITAL LETTER G
        0x24BD, # G+8395  U+24BD  uni24BD,  CIRCLED LATIN CAPITAL LETTER H
        0x24BE, # G+8396  U+24BE  uni24BE,  CIRCLED LATIN CAPITAL LETTER I
        0x24BF, # G+8397  U+24BF  uni24BF,  CIRCLED LATIN CAPITAL LETTER J
        0x24C0, # G+8398  U+24C0  uni24C0,  CIRCLED LATIN CAPITAL LETTER K
        0x24C1, # G+8399  U+24C1  uni24C1,  CIRCLED LATIN CAPITAL LETTER L
        0x24C2, # G+8400  U+24C2  uni24C2,  CIRCLED LATIN CAPITAL LETTER M
        0x24C3, # G+8401  U+24C3  uni24C3,  CIRCLED LATIN CAPITAL LETTER N
        0x24C4, # G+8402  U+24C4  uni24C4,  CIRCLED LATIN CAPITAL LETTER O
        0x24C5, # G+8403  U+24C5  uni24C5,  CIRCLED LATIN CAPITAL LETTER P
        0x24C6, # G+8404  U+24C6  uni24C6,  CIRCLED LATIN CAPITAL LETTER Q
        0x24C7, # G+8405  U+24C7  uni24C7,  CIRCLED LATIN CAPITAL LETTER R
        0x24C8, # G+8406  U+24C8  uni24C8,  CIRCLED LATIN CAPITAL LETTER S
        0x24C9, # G+8407  U+24C9  uni24C9,  CIRCLED LATIN CAPITAL LETTER T
        0x24CA, # G+8408  U+24CA  uni24CA,  CIRCLED LATIN CAPITAL LETTER U
        0x24CB, # G+8409  U+24CB  uni24CB,  CIRCLED LATIN CAPITAL LETTER V
        0x24CC, # G+8410  U+24CC  uni24CC,  CIRCLED LATIN CAPITAL LETTER W
        0x24CD, # G+8411  U+24CD  uni24CD,  CIRCLED LATIN CAPITAL LETTER X
        0x24CE, # G+8412  U+24CE  uni24CE,  CIRCLED LATIN CAPITAL LETTER Y
        0x24CF, # G+8413  U+24CF  uni24CF,  CIRCLED LATIN CAPITAL LETTER Z
        0x0000, # G+8414  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8415  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8416  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8417  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8418  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8419  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8420  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8421  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8422  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8423  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8424  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8425  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8426  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8427  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8428  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8429  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8430  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8431  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8432  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8433  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8434  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8435  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8436  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8437  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8438  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8439  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8440  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8441  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8442  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8443  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8444  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8445  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8446  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8447  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8448  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8449  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8450  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8451  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8452  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8453  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8454  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8455  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8456  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8457  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8458  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8459  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8460  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8461  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8462  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8463  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8464  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8465  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8466  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8467  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8468  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8469  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8470  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8471  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8472  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8473  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8474  U+0000  .notdef,  UNDEFINED
        0x227A, # G+8475  U+227A  uni227A,  PRECEDES
        0x227B, # G+8476  U+227B  uni227B,  SUCCEEDS
        0x22CE, # G+8477  U+22CE  uni22CE,  CURLY LOGICAL OR
        0x22CF, # G+8478  U+22CF  uni22CF,  CURLY LOGICAL AND
        0x2280, # G+8479  U+2280  uni2280,  DOES NOT PRECEDE
        0x2281, # G+8480  U+2281  uni2281,  DOES NOT SUCCEED
        0x2270, # G+8481  U+2270  uni2270,  NEITHER LESS-THAN NOR EQUAL TO
        0x2271, # G+8482  U+2271  uni2271,  NEITHER GREATER-THAN NOR EQUAL TO
        0x2272, # G+8483  U+2272  uni2272,  LESS-THAN OR EQUIVALENT TO
        0x2273, # G+8484  U+2273  uni2273,  GREATER-THAN OR EQUIVALENT TO
        0x0000, # G+8485  U+0000  .notdef,  UNDEFINED
        0x228A, # G+8486  U+228A  uni228A,  SUBSET OF WITH NOT EQUAL TO
        0x0000, # G+8487  U+0000  .notdef,  UNDEFINED
        0x228B, # G+8488  U+228B  uni228B,  SUPERSET OF WITH NOT EQUAL TO
        0x2276, # G+8489  U+2276  uni2276,  LESS-THAN OR GREATER-THAN
        0x2277, # G+8490  U+2277  uni2277,  GREATER-THAN OR LESS-THAN
        0x2279, # G+8491  U+2279  uni2279,  NEITHER GREATER-THAN NOR LESS-THAN
        0x22DA, # G+8492  U+22DA  uni22DA,  LESS-THAN EQUAL TO OR GREATER-THAN
        0x22DB, # G+8493  U+22DB  uni22DB,  GREATER-THAN EQUAL TO OR LESS-THAN
        0x0000, # G+8494  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8495  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8496  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8497  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8498  U+0000  .notdef,  UNDEFINED
        0x2245, # G+8499  U+2245  congruent,  APPROXIMATELY EQUAL TO
        0x2243, # G+8500  U+2243  uni2243,  ASYMPTOTICALLY EQUAL TO
        0x2248, # G+8501  U+2248  approxequal,  ALMOST EQUAL TO
        0x0000, # G+8502  U+0000  .notdef,  UNDEFINED
        0x22A4, # G+8503  U+22A4  uni22A4,  DOWN TACK
        0x0000, # G+8504  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8505  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8506  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8507  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8508  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8509  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8510  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8511  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8512  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8513  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8514  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8515  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8516  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8517  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8518  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8519  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8520  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8521  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8522  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8523  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8524  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8525  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8526  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8527  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8528  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8529  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8530  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8531  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8532  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8533  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8534  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8535  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8536  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8537  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8538  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8539  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8540  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8541  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8542  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8543  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8544  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8545  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8546  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8547  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8548  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8549  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8550  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8551  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8552  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8553  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8554  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8555  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8556  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8557  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8558  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8559  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8560  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8561  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8562  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8563  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8564  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8565  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8566  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8567  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8568  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8569  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8570  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8571  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8572  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8573  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8574  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8575  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8576  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8577  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8578  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8579  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8580  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8581  U+0000  .notdef,  UNDEFINED
        0x2034, # G+8582  U+2034  uni2034,  TRIPLE PRIME
        0x0000, # G+8583  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8584  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8585  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8586  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8587  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8588  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8589  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8590  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8591  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8592  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8593  U+0000  .notdef,  UNDEFINED
        0x266F, # G+8594  U+266F  uni266F,  MUSIC SHARP SIGN
        0x0000, # G+8595  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8596  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8597  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8598  U+0000  .notdef,  UNDEFINED
        0x2042, # G+8599  U+2042  uni2042,  ASTERISM
        0x0000, # G+8600  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8601  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8602  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8603  U+0000  .notdef,  UNDEFINED
        0x273D, # G+8604  U+273D  a56,  HEAVY TEARDROP-SPOKED ASTERISK
        0x0000, # G+8605  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8606  U+0000  .notdef,  UNDEFINED
        0x2022, # G+8607  U+2022  bullet,  BULLET
        0x0000, # G+8608  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8609  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8610  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8611  U+0000  .notdef,  UNDEFINED
        0x2039, # G+8612  U+2039  guilsinglleft,  SINGLE LEFT-POINTING ANGLE QUOTATION MARK
        0x203A, # G+8613  U+203A  guilsinglright,  SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
        0x0000, # G+8614  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8615  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8616  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8617  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8618  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8619  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8620  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8621  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8622  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8623  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8624  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8625  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8626  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8627  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8628  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8629  U+0000  .notdef,  UNDEFINED
        0x271A, # G+8630  U+271A  a26,  HEAVY GREEK CROSS
        0x2716, # G+8631  U+2716  a22,  HEAVY MULTIPLICATION X
        0x0000, # G+8632  U+0000  .notdef,  UNDEFINED
        0x25EF, # G+8633  U+25EF  uni25EF,  LARGE CIRCLE
        0x0000, # G+8634  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8635  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8636  U+0000  .notdef,  UNDEFINED
        0x2756, # G+8637  U+2756  a79,  BLACK DIAMOND MINUS WHITE X
        0x0000, # G+8638  U+0000  .notdef,  UNDEFINED
        0x25CC, # G+8639  U+25CC  uni25CC,  DOTTED CIRCLE
        0x0000, # G+8640  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8641  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8642  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8643  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8644  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8645  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8646  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8647  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8648  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8649  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8650  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8651  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8652  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8653  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8654  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8655  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8656  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8657  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8658  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8659  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8660  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8661  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8662  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8663  U+0000  .notdef,  UNDEFINED
        0x262F, # G+8664  U+262F  uni262F,  YIN YANG
        0x0000, # G+8665  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8666  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8667  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8668  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8669  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8670  U+0000  .notdef,  UNDEFINED
        0x3020, # G+8671  U+3020  uni3020,  POSTAL MARK FACE
        0x0000, # G+8672  U+0000  .notdef,  UNDEFINED
        0x2776, # G+8673  U+2776  a130,  DINGBAT NEGATIVE CIRCLED DIGIT ONE
        0x2777, # G+8674  U+2777  a131,  DINGBAT NEGATIVE CIRCLED DIGIT TWO
        0x2778, # G+8675  U+2778  a132,  DINGBAT NEGATIVE CIRCLED DIGIT THREE
        0x2779, # G+8676  U+2779  a133,  DINGBAT NEGATIVE CIRCLED DIGIT FOUR
        0x277A, # G+8677  U+277A  a134,  DINGBAT NEGATIVE CIRCLED DIGIT FIVE
        0x277B, # G+8678  U+277B  a135,  DINGBAT NEGATIVE CIRCLED DIGIT SIX
        0x277C, # G+8679  U+277C  a136,  DINGBAT NEGATIVE CIRCLED DIGIT SEVEN
        0x277D, # G+8680  U+277D  a137,  DINGBAT NEGATIVE CIRCLED DIGIT EIGHT
        0x277E, # G+8681  U+277E  a138,  DINGBAT NEGATIVE CIRCLED DIGIT NINE
        0x277F, # G+8682  U+277F  a139,  DINGBAT NEGATIVE CIRCLED NUMBER TEN
        0x0000, # G+8683  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8684  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8685  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8686  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8687  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8688  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8689  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8690  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8691  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8692  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8693  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8694  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8695  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8696  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8697  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8698  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8699  U+0000  .notdef,  UNDEFINED
        0x3012, # G+8700  U+3012  uni3012,  POSTAL MARK
        0x3036, # G+8701  U+3036  uni3036,  CIRCLED POSTAL MARK
        0x0000, # G+8702  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8703  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8704  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8705  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8706  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8707  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8708  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8709  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8710  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8711  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8714  U+0000  .notdef,  UNDEFINED
        0x2206, # G+8715  U+2206  Delta,  INCREMENT
        0x0000, # G+8716  U+0000  .notdef,  UNDEFINED
        0x221F, # G+8717  U+221F  orthogonal,  RIGHT ANGLE
        0x0000, # G+8718  U+0000  .notdef,  UNDEFINED
        0x2225, # G+8719  U+2225  uni2225,  PARALLEL TO
        0x2226, # G+8720  U+2226  uni2226,  NOT PARALLEL TO
        0x0000, # G+8721  U+0000  .notdef,  UNDEFINED
        0x2253, # G+8722  U+2253  uni2253,  IMAGE OF OR APPROXIMATELY EQUAL TO
        0x2251, # G+8723  U+2251  uni2251,  GEOMETRICALLY EQUAL TO
        0x2266, # G+8724  U+2266  uni2266,  LESS-THAN OVER EQUAL TO
        0x2267, # G+8725  U+2267  uni2267,  GREATER-THAN OVER EQUAL TO
        0x2213, # G+8726  U+2213  uni2213,  MINUS-OR-PLUS SIGN
        0x2295, # G+8727  U+2295  circleplus,  CIRCLED PLUS
        0x2296, # G+8728  U+2296  uni2296,  CIRCLED MINUS
        0x2297, # G+8729  U+2297  circlemultiply,  CIRCLED TIMES
        0x0000, # G+8730  U+0000  .notdef,  UNDEFINED
        0x2314, # G+8731  U+2314  uni2314,  SECTOR
        0x0000, # G+8732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8733  U+0000  .notdef,  UNDEFINED
        0x2262, # G+8734  U+2262  uni2262,  NOT IDENTICAL TO
        0x0000, # G+8735  U+0000  .notdef,  UNDEFINED
        0x25B1, # G+8736  U+25B1  uni25B1,  WHITE PARALLELOGRAM
        0x0000, # G+8737  U+0000  .notdef,  UNDEFINED
        0x2222, # G+8738  U+2222  uni2222,  SPHERICAL ANGLE
        0x2250, # G+8739  U+2250  uni2250,  APPROACHES THE LIMIT
        0x0000, # G+8740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8741  U+0000  .notdef,  UNDEFINED
        0x22A3, # G+8742  U+22A3  uni22A3,  LEFT TACK
        0x0000, # G+8743  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8744  U+0000  .notdef,  UNDEFINED
        0x226E, # G+8745  U+226E  uni226E,  NOT LESS-THAN
        0x226F, # G+8746  U+226F  uni226F,  NOT GREATER-THAN
        0x2285, # G+8747  U+2285  uni2285,  NOT A SUPERSET OF
        0x2284, # G+8748  U+2284  notsubset,  NOT A SUBSET OF
        0x2209, # G+8749  U+2209  notelement,  NOT AN ELEMENT OF
        0x220C, # G+8750  U+220C  uni220C,  DOES NOT CONTAIN AS MEMBER
        0x22BB, # G+8751  U+22BB  uni22BB,  XOR
        0x22BC, # G+8752  U+22BC  uni22BC,  NAND
        0x225A, # G+8753  U+225A  uni225A,  EQUIANGULAR TO
        0x2306, # G+8754  U+2306  uni2306,  PERSPECTIVE
        0x0000, # G+8755  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8756  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8757  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8758  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8759  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8760  U+0000  .notdef,  UNDEFINED
        0x329E, # G+8761  U+329E  uni329E,  CIRCLED IDEOGRAPH PRINT
        0x0000, # G+8762  U+0000  .notdef,  UNDEFINED
        0x203C, # G+8763  U+203C  exclamdbl,  DOUBLE EXCLAMATION MARK
        0x0000, # G+8764  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8765  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8766  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8767  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8768  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8769  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8770  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8771  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8772  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8773  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8774  U+0000  .notdef,  UNDEFINED
        0x25E6, # G+8775  U+25E6  openbullet,  WHITE BULLET
        0x0000, # G+8776  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8777  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8778  U+0000  .notdef,  UNDEFINED
        0x25BF, # G+8779  U+25BF  uni25BF,  WHITE DOWN-POINTING SMALL TRIANGLE
        0x25B5, # G+8780  U+25B5  uni25B5,  WHITE UP-POINTING SMALL TRIANGLE
        0x25B9, # G+8781  U+25B9  uni25B9,  WHITE RIGHT-POINTING SMALL TRIANGLE
        0x25C3, # G+8782  U+25C3  uni25C3,  WHITE LEFT-POINTING SMALL TRIANGLE
        0x0000, # G+8783  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8784  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8785  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8786  U+0000  .notdef,  UNDEFINED
        0x25CA, # G+8787  U+25CA  lozenge,  LOZENGE
        0x3231, # G+8788  U+3231  uni3231,  PARENTHESIZED IDEOGRAPH STOCK
        0x3239, # G+8789  U+3239  uni3239,  PARENTHESIZED IDEOGRAPH REPRESENT
        0x33CB, # G+8790  U+33CB  uni33CB,  SQUARE HP
        0x246F, # G+8791  U+246F  uni246F,  CIRCLED NUMBER SIXTEEN
        0x2470, # G+8792  U+2470  uni2470,  CIRCLED NUMBER SEVENTEEN
        0x2471, # G+8793  U+2471  uni2471,  CIRCLED NUMBER EIGHTEEN
        0x2472, # G+8794  U+2472  uni2472,  CIRCLED NUMBER NINETEEN
        0x2473, # G+8795  U+2473  uni2473,  CIRCLED NUMBER TWENTY
        0x0000, # G+8796  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8797  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8798  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8799  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8800  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8801  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8802  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8803  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8804  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8805  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8806  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8807  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8808  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8809  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8810  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8811  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8812  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8813  U+0000  .notdef,  UNDEFINED
        0x21D0, # G+8814  U+21D0  arrowdblleft,  LEFTWARDS DOUBLE ARROW
        0x21CF, # G+8815  U+21CF  uni21CF,  RIGHTWARDS DOUBLE ARROW WITH STROKE
        0x21CD, # G+8816  U+21CD  uni21CD,  LEFTWARDS DOUBLE ARROW WITH STROKE
        0x0000, # G+8817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8825  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8826  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8830  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8831  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8832  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8833  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8834  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8835  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8836  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8839  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8840  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8846  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8847  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8848  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8849  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8850  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8851  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8852  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8853  U+0000  .notdef,  UNDEFINED
        0x21D1, # G+8854  U+21D1  arrowdblup,  UPWARDS DOUBLE ARROW
        0x21D3, # G+8855  U+21D3  arrowdbldown,  DOWNWARDS DOUBLE ARROW
        0x0000, # G+8856  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8858  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8859  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8860  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8861  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8863  U+0000  .notdef,  UNDEFINED
        0x21B2, # G+8864  U+21B2  uni21B2,  DOWNWARDS ARROW WITH TIP LEFTWARDS
        0x21B1, # G+8865  U+21B1  uni21B1,  UPWARDS ARROW WITH TIP RIGHTWARDS
        0x0000, # G+8866  U+0000  .notdef,  UNDEFINED
        0x21B4, # G+8867  U+21B4  uni21B4,  RIGHTWARDS ARROW WITH CORNER DOWNWARDS
        0x21B0, # G+8868  U+21B0  uni21B0,  UPWARDS ARROW WITH TIP LEFTWARDS
        0x21B3, # G+8869  U+21B3  uni21B3,  DOWNWARDS ARROW WITH TIP RIGHTWARDS
        0x0000, # G+8870  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8873  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8874  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8875  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8876  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8877  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8878  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8879  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8880  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8881  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8882  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8883  U+0000  .notdef,  UNDEFINED
        0x21BC, # G+8884  U+21BC  uni21BC,  LEFTWARDS HARPOON WITH BARB UPWARDS
        0x21C0, # G+8885  U+21C0  uni21C0,  RIGHTWARDS HARPOON WITH BARB UPWARDS
        0x0000, # G+8886  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8887  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8888  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8889  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8890  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8891  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8892  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8893  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8894  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8895  U+0000  .notdef,  UNDEFINED
        0x21C4, # G+8896  U+21C4  uni21C4,  RIGHTWARDS ARROW OVER LEFTWARDS ARROW
        0x21C5, # G+8897  U+21C5  uni21C5,  UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW
        0x0000, # G+8898  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8899  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8900  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8901  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8902  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8903  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8904  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8905  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8906  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8907  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8908  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8909  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8910  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8911  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8912  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8913  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8914  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8915  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8916  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8917  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8918  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8919  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8920  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8921  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8922  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8923  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8924  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8925  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8926  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8927  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8928  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8929  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8930  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8931  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8932  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8933  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8934  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8935  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8936  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8937  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8938  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8939  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8940  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8941  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8942  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8943  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8944  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8945  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8946  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8947  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8948  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8949  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8950  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8951  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8952  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8953  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8954  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8955  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8956  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8957  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8958  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8959  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8960  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8961  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8962  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8963  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8964  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8965  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8966  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8967  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8968  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8969  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8970  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8971  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8972  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8973  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8974  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8975  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8976  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8977  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8978  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8979  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8980  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8981  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8982  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8983  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8984  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8985  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8986  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8987  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8988  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8989  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8990  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8991  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8992  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8993  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8994  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8995  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8996  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8997  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8998  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8999  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9000  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9001  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9002  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9003  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9004  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9005  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9006  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9007  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9008  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9009  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9010  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9011  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9012  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9013  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9014  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9015  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9016  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9017  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9018  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9019  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9020  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9021  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9022  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9023  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9024  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9025  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9026  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9027  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9028  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9029  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9030  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9031  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9032  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9033  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9034  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9035  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9036  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9037  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9038  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9039  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9040  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9041  U+0000  .notdef,  UNDEFINED
        0x2483, # G+9042  U+2483  uni2483,  PARENTHESIZED NUMBER SIXTEEN
        0x2484, # G+9043  U+2484  uni2484,  PARENTHESIZED NUMBER SEVENTEEN
        0x2485, # G+9044  U+2485  uni2485,  PARENTHESIZED NUMBER EIGHTEEN
        0x2486, # G+9045  U+2486  uni2486,  PARENTHESIZED NUMBER NINETEEN
        0x2487, # G+9046  U+2487  uni2487,  PARENTHESIZED NUMBER TWENTY
        0x0000, # G+9047  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9048  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9049  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9050  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9051  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9052  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9053  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9054  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9055  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9056  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9057  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9058  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9059  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9060  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9061  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9062  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9063  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9064  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9065  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9066  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9067  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9068  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9069  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9070  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9071  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9072  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9073  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9074  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9075  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9076  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9077  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9078  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9079  U+0000  .notdef,  UNDEFINED
        0x3294, # G+9080  U+3294  uni3294,  CIRCLED IDEOGRAPH NAME
        0x0000, # G+9081  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9082  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9083  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9084  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9085  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9086  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9087  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9088  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9089  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9090  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9091  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9092  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9093  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9094  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9095  U+0000  .notdef,  UNDEFINED
        0x32A5, # G+9096  U+32A5  uni32A5,  CIRCLED IDEOGRAPH CENTRE
        0x0000, # G+9097  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9098  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9099  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9100  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9109  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9110  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9111  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9112  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9114  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9115  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9116  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9117  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9118  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9119  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9120  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9121  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9122  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9123  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9125  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9126  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9127  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9128  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9129  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9130  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9131  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9132  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9133  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9134  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9135  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9136  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9137  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9138  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9139  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9140  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9141  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9142  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9143  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9144  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9145  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9146  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9147  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9148  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9149  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9150  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9151  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9152  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9153  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9154  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9156  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9157  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9158  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9159  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9160  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9161  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9162  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9163  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9164  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9165  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9166  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9172  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9173  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9175  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9176  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9177  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9178  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9181  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9182  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9183  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9184  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9185  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9186  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9187  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9188  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9189  U+0000  .notdef,  UNDEFINED
        0x21E0, # G+9190  U+21E0  uni21E0,  LEFTWARDS DASHED ARROW
        0x21E2, # G+9191  U+21E2  uni21E2,  RIGHTWARDS DASHED ARROW
        0x21E1, # G+9192  U+21E1  uni21E1,  UPWARDS DASHED ARROW
        0x21E3, # G+9193  U+21E3  uni21E3,  DOWNWARDS DASHED ARROW
        0x0000, # G+9194  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9195  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9196  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9197  U+0000  .notdef,  UNDEFINED
        0x21E6, # G+9198  U+21E6  uni21E6,  LEFTWARDS WHITE ARROW
        0x21E8, # G+9199  U+21E8  uni21E8,  RIGHTWARDS WHITE ARROW
        0x21E7, # G+9200  U+21E7  uni21E7,  UPWARDS WHITE ARROW
        0x21E9, # G+9201  U+21E9  uni21E9,  DOWNWARDS WHITE ARROW
        0x0000, # G+9202  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9203  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9204  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9205  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9206  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9207  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9208  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9209  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9210  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9211  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9212  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9213  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9214  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9215  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9216  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9217  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9218  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9219  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9220  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9221  U+0000  .notdef,  UNDEFINED
        0x261D, # G+9222  U+261D  uni261D,  WHITE UP POINTING INDEX
        0x261F, # G+9223  U+261F  uni261F,  WHITE DOWN POINTING INDEX
        0x0000, # G+9224  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9225  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9226  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9229  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9230  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9231  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9232  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9233  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9234  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9235  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9236  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9237  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9238  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9239  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9240  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9241  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9242  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9243  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9244  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9245  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9246  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9247  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9248  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9249  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9250  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9251  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9252  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9253  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9254  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9256  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9257  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9258  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9259  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9260  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9261  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9262  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9263  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9265  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9266  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9267  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9268  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9269  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9270  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9271  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9272  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9273  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9274  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9275  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9278  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9279  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9280  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9281  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9282  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9283  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9284  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9285  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9286  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9287  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9288  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9289  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9290  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9291  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9292  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9293  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9294  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9295  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9296  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9297  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9298  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9299  U+0000  .notdef,  UNDEFINED
        0x3290, # G+9300  U+3290  uni3290,  CIRCLED IDEOGRAPH SUN
        0x328A, # G+9301  U+328A  uni328A,  CIRCLED IDEOGRAPH MOON
        0x328B, # G+9302  U+328B  uni328B,  CIRCLED IDEOGRAPH FIRE
        0x328C, # G+9303  U+328C  uni328C,  CIRCLED IDEOGRAPH WATER
        0x328D, # G+9304  U+328D  uni328D,  CIRCLED IDEOGRAPH WOOD
        0x328E, # G+9305  U+328E  uni328E,  CIRCLED IDEOGRAPH METAL
        0x328F, # G+9306  U+328F  uni328F,  CIRCLED IDEOGRAPH EARTH
        0x0000, # G+9307  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9308  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9309  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9310  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9311  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9312  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9313  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9314  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9315  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9316  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9317  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9318  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9319  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9320  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9321  U+0000  .notdef,  UNDEFINED
        0x301E, # G+9322  U+301E  uni301E,  DOUBLE PRIME QUOTATION MARK
        0x301F, # G+9323  U+301F  uni301F,  LOW DOUBLE PRIME QUOTATION MARK
        0x2036, # G+9324  U+2036  uni2036,  REVERSED DOUBLE PRIME
        0x0000, # G+9325  U+0000  .notdef,  UNDEFINED
        0x2035, # G+9326  U+2035  uni2035,  REVERSED PRIME
        0x0000, # G+9327  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9328  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9329  U+0000  .notdef,  UNDEFINED
        0x30FC, # G+9330  U+30FC  uni30FC,  KATAKANA-HIRAGANA PROLONGED SOUND MARK
        0x0000, # G+9331  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9332  U+0000  .notdef,  UNDEFINED
        0xAC02, # G+9333  U+AC02  uniAC02,  HANGUL SYLLABLE-AC02
        0xAC03, # G+9334  U+AC03  uniAC03,  HANGUL SYLLABLE-AC03
        0xAC05, # G+9335  U+AC05  uniAC05,  HANGUL SYLLABLE-AC05
        0xAC06, # G+9336  U+AC06  uniAC06,  HANGUL SYLLABLE-AC06
        0xAC0B, # G+9337  U+AC0B  uniAC0B,  HANGUL SYLLABLE-AC0B
        0xAC0C, # G+9338  U+AC0C  uniAC0C,  HANGUL SYLLABLE-AC0C
        0xAC0D, # G+9339  U+AC0D  uniAC0D,  HANGUL SYLLABLE-AC0D
        0xAC0E, # G+9340  U+AC0E  uniAC0E,  HANGUL SYLLABLE-AC0E
        0xAC0F, # G+9341  U+AC0F  uniAC0F,  HANGUL SYLLABLE-AC0F
        0xAC18, # G+9342  U+AC18  uniAC18,  HANGUL SYLLABLE-AC18
        0xAC1E, # G+9343  U+AC1E  uniAC1E,  HANGUL SYLLABLE-AC1E
        0xAC1F, # G+9344  U+AC1F  uniAC1F,  HANGUL SYLLABLE-AC1F
        0xAC21, # G+9345  U+AC21  uniAC21,  HANGUL SYLLABLE-AC21
        0xAC22, # G+9346  U+AC22  uniAC22,  HANGUL SYLLABLE-AC22
        0xAC23, # G+9347  U+AC23  uniAC23,  HANGUL SYLLABLE-AC23
        0xAC25, # G+9348  U+AC25  uniAC25,  HANGUL SYLLABLE-AC25
        0xAC26, # G+9349  U+AC26  uniAC26,  HANGUL SYLLABLE-AC26
        0xAC27, # G+9350  U+AC27  uniAC27,  HANGUL SYLLABLE-AC27
        0xAC28, # G+9351  U+AC28  uniAC28,  HANGUL SYLLABLE-AC28
        0xAC29, # G+9352  U+AC29  uniAC29,  HANGUL SYLLABLE-AC29
        0xAC2A, # G+9353  U+AC2A  uniAC2A,  HANGUL SYLLABLE-AC2A
        0xAC2B, # G+9354  U+AC2B  uniAC2B,  HANGUL SYLLABLE-AC2B
        0xAC2E, # G+9355  U+AC2E  uniAC2E,  HANGUL SYLLABLE-AC2E
        0xAC32, # G+9356  U+AC32  uniAC32,  HANGUL SYLLABLE-AC32
        0xAC33, # G+9357  U+AC33  uniAC33,  HANGUL SYLLABLE-AC33
        0xAC34, # G+9358  U+AC34  uniAC34,  HANGUL SYLLABLE-AC34
        0xAC35, # G+9359  U+AC35  uniAC35,  HANGUL SYLLABLE-AC35
        0xAC36, # G+9360  U+AC36  uniAC36,  HANGUL SYLLABLE-AC36
        0xAC37, # G+9361  U+AC37  uniAC37,  HANGUL SYLLABLE-AC37
        0xAC3A, # G+9362  U+AC3A  uniAC3A,  HANGUL SYLLABLE-AC3A
        0xAC3B, # G+9363  U+AC3B  uniAC3B,  HANGUL SYLLABLE-AC3B
        0xAC3D, # G+9364  U+AC3D  uniAC3D,  HANGUL SYLLABLE-AC3D
        0xAC3E, # G+9365  U+AC3E  uniAC3E,  HANGUL SYLLABLE-AC3E
        0xAC3F, # G+9366  U+AC3F  uniAC3F,  HANGUL SYLLABLE-AC3F
        0xAC41, # G+9367  U+AC41  uniAC41,  HANGUL SYLLABLE-AC41
        0xAC42, # G+9368  U+AC42  uniAC42,  HANGUL SYLLABLE-AC42
        0xAC43, # G+9369  U+AC43  uniAC43,  HANGUL SYLLABLE-AC43
        0xAC44, # G+9370  U+AC44  uniAC44,  HANGUL SYLLABLE-AC44
        0xAC45, # G+9371  U+AC45  uniAC45,  HANGUL SYLLABLE-AC45
        0xAC46, # G+9372  U+AC46  uniAC46,  HANGUL SYLLABLE-AC46
        0xAC47, # G+9373  U+AC47  uniAC47,  HANGUL SYLLABLE-AC47
        0xAC48, # G+9374  U+AC48  uniAC48,  HANGUL SYLLABLE-AC48
        0xAC49, # G+9375  U+AC49  uniAC49,  HANGUL SYLLABLE-AC49
        0xAC4A, # G+9376  U+AC4A  uniAC4A,  HANGUL SYLLABLE-AC4A
        0xAC4C, # G+9377  U+AC4C  uniAC4C,  HANGUL SYLLABLE-AC4C
        0xAC4E, # G+9378  U+AC4E  uniAC4E,  HANGUL SYLLABLE-AC4E
        0xAC4F, # G+9379  U+AC4F  uniAC4F,  HANGUL SYLLABLE-AC4F
        0xAC50, # G+9380  U+AC50  uniAC50,  HANGUL SYLLABLE-AC50
        0xAC51, # G+9381  U+AC51  uniAC51,  HANGUL SYLLABLE-AC51
        0xAC52, # G+9382  U+AC52  uniAC52,  HANGUL SYLLABLE-AC52
        0xAC53, # G+9383  U+AC53  uniAC53,  HANGUL SYLLABLE-AC53
        0xAC55, # G+9384  U+AC55  uniAC55,  HANGUL SYLLABLE-AC55
        0xAC56, # G+9385  U+AC56  uniAC56,  HANGUL SYLLABLE-AC56
        0xAC57, # G+9386  U+AC57  uniAC57,  HANGUL SYLLABLE-AC57
        0xAC59, # G+9387  U+AC59  uniAC59,  HANGUL SYLLABLE-AC59
        0xAC5A, # G+9388  U+AC5A  uniAC5A,  HANGUL SYLLABLE-AC5A
        0xAC5B, # G+9389  U+AC5B  uniAC5B,  HANGUL SYLLABLE-AC5B
        0xAC5D, # G+9390  U+AC5D  uniAC5D,  HANGUL SYLLABLE-AC5D
        0xAC5E, # G+9391  U+AC5E  uniAC5E,  HANGUL SYLLABLE-AC5E
        0xAC5F, # G+9392  U+AC5F  uniAC5F,  HANGUL SYLLABLE-AC5F
        0xAC60, # G+9393  U+AC60  uniAC60,  HANGUL SYLLABLE-AC60
        0xAC61, # G+9394  U+AC61  uniAC61,  HANGUL SYLLABLE-AC61
        0xAC62, # G+9395  U+AC62  uniAC62,  HANGUL SYLLABLE-AC62
        0xAC63, # G+9396  U+AC63  uniAC63,  HANGUL SYLLABLE-AC63
        0xAC64, # G+9397  U+AC64  uniAC64,  HANGUL SYLLABLE-AC64
        0xAC65, # G+9398  U+AC65  uniAC65,  HANGUL SYLLABLE-AC65
        0xAC66, # G+9399  U+AC66  uniAC66,  HANGUL SYLLABLE-AC66
        0xAC67, # G+9400  U+AC67  uniAC67,  HANGUL SYLLABLE-AC67
        0xAC68, # G+9401  U+AC68  uniAC68,  HANGUL SYLLABLE-AC68
        0xAC69, # G+9402  U+AC69  uniAC69,  HANGUL SYLLABLE-AC69
        0xAC6A, # G+9403  U+AC6A  uniAC6A,  HANGUL SYLLABLE-AC6A
        0xAC6B, # G+9404  U+AC6B  uniAC6B,  HANGUL SYLLABLE-AC6B
        0xAC6C, # G+9405  U+AC6C  uniAC6C,  HANGUL SYLLABLE-AC6C
        0xAC6D, # G+9406  U+AC6D  uniAC6D,  HANGUL SYLLABLE-AC6D
        0xAC6E, # G+9407  U+AC6E  uniAC6E,  HANGUL SYLLABLE-AC6E
        0xAC6F, # G+9408  U+AC6F  uniAC6F,  HANGUL SYLLABLE-AC6F
        0xAC72, # G+9409  U+AC72  uniAC72,  HANGUL SYLLABLE-AC72
        0xAC73, # G+9410  U+AC73  uniAC73,  HANGUL SYLLABLE-AC73
        0xAC75, # G+9411  U+AC75  uniAC75,  HANGUL SYLLABLE-AC75
        0xAC76, # G+9412  U+AC76  uniAC76,  HANGUL SYLLABLE-AC76
        0xAC79, # G+9413  U+AC79  uniAC79,  HANGUL SYLLABLE-AC79
        0xAC7B, # G+9414  U+AC7B  uniAC7B,  HANGUL SYLLABLE-AC7B
        0xAC7C, # G+9415  U+AC7C  uniAC7C,  HANGUL SYLLABLE-AC7C
        0xAC7D, # G+9416  U+AC7D  uniAC7D,  HANGUL SYLLABLE-AC7D
        0xAC7E, # G+9417  U+AC7E  uniAC7E,  HANGUL SYLLABLE-AC7E
        0xAC7F, # G+9418  U+AC7F  uniAC7F,  HANGUL SYLLABLE-AC7F
        0xAC82, # G+9419  U+AC82  uniAC82,  HANGUL SYLLABLE-AC82
        0xAC87, # G+9420  U+AC87  uniAC87,  HANGUL SYLLABLE-AC87
        0xAC88, # G+9421  U+AC88  uniAC88,  HANGUL SYLLABLE-AC88
        0xAC8D, # G+9422  U+AC8D  uniAC8D,  HANGUL SYLLABLE-AC8D
        0xAC8E, # G+9423  U+AC8E  uniAC8E,  HANGUL SYLLABLE-AC8E
        0xAC8F, # G+9424  U+AC8F  uniAC8F,  HANGUL SYLLABLE-AC8F
        0xAC91, # G+9425  U+AC91  uniAC91,  HANGUL SYLLABLE-AC91
        0xAC92, # G+9426  U+AC92  uniAC92,  HANGUL SYLLABLE-AC92
        0xAC93, # G+9427  U+AC93  uniAC93,  HANGUL SYLLABLE-AC93
        0xAC95, # G+9428  U+AC95  uniAC95,  HANGUL SYLLABLE-AC95
        0xAC96, # G+9429  U+AC96  uniAC96,  HANGUL SYLLABLE-AC96
        0xAC97, # G+9430  U+AC97  uniAC97,  HANGUL SYLLABLE-AC97
        0xAC98, # G+9431  U+AC98  uniAC98,  HANGUL SYLLABLE-AC98
        0xAC99, # G+9432  U+AC99  uniAC99,  HANGUL SYLLABLE-AC99
        0xAC9A, # G+9433  U+AC9A  uniAC9A,  HANGUL SYLLABLE-AC9A
        0xAC9B, # G+9434  U+AC9B  uniAC9B,  HANGUL SYLLABLE-AC9B
        0xAC9E, # G+9435  U+AC9E  uniAC9E,  HANGUL SYLLABLE-AC9E
        0xACA2, # G+9436  U+ACA2  uniACA2,  HANGUL SYLLABLE-ACA2
        0xACA3, # G+9437  U+ACA3  uniACA3,  HANGUL SYLLABLE-ACA3
        0xACA4, # G+9438  U+ACA4  uniACA4,  HANGUL SYLLABLE-ACA4
        0xACA5, # G+9439  U+ACA5  uniACA5,  HANGUL SYLLABLE-ACA5
        0xACA6, # G+9440  U+ACA6  uniACA6,  HANGUL SYLLABLE-ACA6
        0xACA7, # G+9441  U+ACA7  uniACA7,  HANGUL SYLLABLE-ACA7
        0xACAB, # G+9442  U+ACAB  uniACAB,  HANGUL SYLLABLE-ACAB
        0xACAD, # G+9443  U+ACAD  uniACAD,  HANGUL SYLLABLE-ACAD
        0xACAE, # G+9444  U+ACAE  uniACAE,  HANGUL SYLLABLE-ACAE
        0xACB1, # G+9445  U+ACB1  uniACB1,  HANGUL SYLLABLE-ACB1
        0xACB2, # G+9446  U+ACB2  uniACB2,  HANGUL SYLLABLE-ACB2
        0xACB3, # G+9447  U+ACB3  uniACB3,  HANGUL SYLLABLE-ACB3
        0xACB4, # G+9448  U+ACB4  uniACB4,  HANGUL SYLLABLE-ACB4
        0xACB5, # G+9449  U+ACB5  uniACB5,  HANGUL SYLLABLE-ACB5
        0xACB6, # G+9450  U+ACB6  uniACB6,  HANGUL SYLLABLE-ACB6
        0xACB7, # G+9451  U+ACB7  uniACB7,  HANGUL SYLLABLE-ACB7
        0xACBA, # G+9452  U+ACBA  uniACBA,  HANGUL SYLLABLE-ACBA
        0xACBE, # G+9453  U+ACBE  uniACBE,  HANGUL SYLLABLE-ACBE
        0xACBF, # G+9454  U+ACBF  uniACBF,  HANGUL SYLLABLE-ACBF
        0xACC0, # G+9455  U+ACC0  uniACC0,  HANGUL SYLLABLE-ACC0
        0xACC2, # G+9456  U+ACC2  uniACC2,  HANGUL SYLLABLE-ACC2
        0xACC3, # G+9457  U+ACC3  uniACC3,  HANGUL SYLLABLE-ACC3
        0xACC5, # G+9458  U+ACC5  uniACC5,  HANGUL SYLLABLE-ACC5
        0xACC6, # G+9459  U+ACC6  uniACC6,  HANGUL SYLLABLE-ACC6
        0xACC7, # G+9460  U+ACC7  uniACC7,  HANGUL SYLLABLE-ACC7
        0xACC9, # G+9461  U+ACC9  uniACC9,  HANGUL SYLLABLE-ACC9
        0xACCA, # G+9462  U+ACCA  uniACCA,  HANGUL SYLLABLE-ACCA
        0xACCB, # G+9463  U+ACCB  uniACCB,  HANGUL SYLLABLE-ACCB
        0xACCD, # G+9464  U+ACCD  uniACCD,  HANGUL SYLLABLE-ACCD
        0xACCE, # G+9465  U+ACCE  uniACCE,  HANGUL SYLLABLE-ACCE
        0xACCF, # G+9466  U+ACCF  uniACCF,  HANGUL SYLLABLE-ACCF
        0xACD0, # G+9467  U+ACD0  uniACD0,  HANGUL SYLLABLE-ACD0
        0xACD1, # G+9468  U+ACD1  uniACD1,  HANGUL SYLLABLE-ACD1
        0xACD2, # G+9469  U+ACD2  uniACD2,  HANGUL SYLLABLE-ACD2
        0xACD3, # G+9470  U+ACD3  uniACD3,  HANGUL SYLLABLE-ACD3
        0xACD4, # G+9471  U+ACD4  uniACD4,  HANGUL SYLLABLE-ACD4
        0xACD6, # G+9472  U+ACD6  uniACD6,  HANGUL SYLLABLE-ACD6
        0xACD8, # G+9473  U+ACD8  uniACD8,  HANGUL SYLLABLE-ACD8
        0xACD9, # G+9474  U+ACD9  uniACD9,  HANGUL SYLLABLE-ACD9
        0xACDA, # G+9475  U+ACDA  uniACDA,  HANGUL SYLLABLE-ACDA
        0xACDB, # G+9476  U+ACDB  uniACDB,  HANGUL SYLLABLE-ACDB
        0xACDC, # G+9477  U+ACDC  uniACDC,  HANGUL SYLLABLE-ACDC
        0xACDD, # G+9478  U+ACDD  uniACDD,  HANGUL SYLLABLE-ACDD
        0xACDE, # G+9479  U+ACDE  uniACDE,  HANGUL SYLLABLE-ACDE
        0xACDF, # G+9480  U+ACDF  uniACDF,  HANGUL SYLLABLE-ACDF
        0xACE2, # G+9481  U+ACE2  uniACE2,  HANGUL SYLLABLE-ACE2
        0xACE3, # G+9482  U+ACE3  uniACE3,  HANGUL SYLLABLE-ACE3
        0xACE5, # G+9483  U+ACE5  uniACE5,  HANGUL SYLLABLE-ACE5
        0xACE6, # G+9484  U+ACE6  uniACE6,  HANGUL SYLLABLE-ACE6
        0xACE9, # G+9485  U+ACE9  uniACE9,  HANGUL SYLLABLE-ACE9
        0xACEB, # G+9486  U+ACEB  uniACEB,  HANGUL SYLLABLE-ACEB
        0xACED, # G+9487  U+ACED  uniACED,  HANGUL SYLLABLE-ACED
        0xACEE, # G+9488  U+ACEE  uniACEE,  HANGUL SYLLABLE-ACEE
        0xACF2, # G+9489  U+ACF2  uniACF2,  HANGUL SYLLABLE-ACF2
        0xACF4, # G+9490  U+ACF4  uniACF4,  HANGUL SYLLABLE-ACF4
        0xACF7, # G+9491  U+ACF7  uniACF7,  HANGUL SYLLABLE-ACF7
        0xACF8, # G+9492  U+ACF8  uniACF8,  HANGUL SYLLABLE-ACF8
        0xACF9, # G+9493  U+ACF9  uniACF9,  HANGUL SYLLABLE-ACF9
        0xACFA, # G+9494  U+ACFA  uniACFA,  HANGUL SYLLABLE-ACFA
        0xACFB, # G+9495  U+ACFB  uniACFB,  HANGUL SYLLABLE-ACFB
        0xACFE, # G+9496  U+ACFE  uniACFE,  HANGUL SYLLABLE-ACFE
        0xACFF, # G+9497  U+ACFF  uniACFF,  HANGUL SYLLABLE-ACFF
        0xAD01, # G+9498  U+AD01  uniAD01,  HANGUL SYLLABLE-AD01
        0xAD02, # G+9499  U+AD02  uniAD02,  HANGUL SYLLABLE-AD02
        0xAD03, # G+9500  U+AD03  uniAD03,  HANGUL SYLLABLE-AD03
        0xAD05, # G+9501  U+AD05  uniAD05,  HANGUL SYLLABLE-AD05
        0xAD07, # G+9502  U+AD07  uniAD07,  HANGUL SYLLABLE-AD07
        0xAD08, # G+9503  U+AD08  uniAD08,  HANGUL SYLLABLE-AD08
        0xAD09, # G+9504  U+AD09  uniAD09,  HANGUL SYLLABLE-AD09
        0xAD0A, # G+9505  U+AD0A  uniAD0A,  HANGUL SYLLABLE-AD0A
        0xAD0B, # G+9506  U+AD0B  uniAD0B,  HANGUL SYLLABLE-AD0B
        0xAD0E, # G+9507  U+AD0E  uniAD0E,  HANGUL SYLLABLE-AD0E
        0xAD10, # G+9508  U+AD10  uniAD10,  HANGUL SYLLABLE-AD10
        0xAD12, # G+9509  U+AD12  uniAD12,  HANGUL SYLLABLE-AD12
        0xAD13, # G+9510  U+AD13  uniAD13,  HANGUL SYLLABLE-AD13
        0xAD14, # G+9511  U+AD14  uniAD14,  HANGUL SYLLABLE-AD14
        0xAD15, # G+9512  U+AD15  uniAD15,  HANGUL SYLLABLE-AD15
        0xAD16, # G+9513  U+AD16  uniAD16,  HANGUL SYLLABLE-AD16
        0xAD17, # G+9514  U+AD17  uniAD17,  HANGUL SYLLABLE-AD17
        0xAD19, # G+9515  U+AD19  uniAD19,  HANGUL SYLLABLE-AD19
        0xAD1A, # G+9516  U+AD1A  uniAD1A,  HANGUL SYLLABLE-AD1A
        0xAD1B, # G+9517  U+AD1B  uniAD1B,  HANGUL SYLLABLE-AD1B
        0xAD1D, # G+9518  U+AD1D  uniAD1D,  HANGUL SYLLABLE-AD1D
        0xAD1E, # G+9519  U+AD1E  uniAD1E,  HANGUL SYLLABLE-AD1E
        0xAD1F, # G+9520  U+AD1F  uniAD1F,  HANGUL SYLLABLE-AD1F
        0xAD21, # G+9521  U+AD21  uniAD21,  HANGUL SYLLABLE-AD21
        0xAD22, # G+9522  U+AD22  uniAD22,  HANGUL SYLLABLE-AD22
        0xAD23, # G+9523  U+AD23  uniAD23,  HANGUL SYLLABLE-AD23
        0xAD24, # G+9524  U+AD24  uniAD24,  HANGUL SYLLABLE-AD24
        0xAD25, # G+9525  U+AD25  uniAD25,  HANGUL SYLLABLE-AD25
        0xAD26, # G+9526  U+AD26  uniAD26,  HANGUL SYLLABLE-AD26
        0xAD27, # G+9527  U+AD27  uniAD27,  HANGUL SYLLABLE-AD27
        0xAD28, # G+9528  U+AD28  uniAD28,  HANGUL SYLLABLE-AD28
        0xAD2A, # G+9529  U+AD2A  uniAD2A,  HANGUL SYLLABLE-AD2A
        0xAD2B, # G+9530  U+AD2B  uniAD2B,  HANGUL SYLLABLE-AD2B
        0xAD2E, # G+9531  U+AD2E  uniAD2E,  HANGUL SYLLABLE-AD2E
        0xAD2F, # G+9532  U+AD2F  uniAD2F,  HANGUL SYLLABLE-AD2F
        0xAD30, # G+9533  U+AD30  uniAD30,  HANGUL SYLLABLE-AD30
        0xAD31, # G+9534  U+AD31  uniAD31,  HANGUL SYLLABLE-AD31
        0xAD32, # G+9535  U+AD32  uniAD32,  HANGUL SYLLABLE-AD32
        0xAD33, # G+9536  U+AD33  uniAD33,  HANGUL SYLLABLE-AD33
        0xAD36, # G+9537  U+AD36  uniAD36,  HANGUL SYLLABLE-AD36
        0xAD37, # G+9538  U+AD37  uniAD37,  HANGUL SYLLABLE-AD37
        0xAD39, # G+9539  U+AD39  uniAD39,  HANGUL SYLLABLE-AD39
        0xAD3A, # G+9540  U+AD3A  uniAD3A,  HANGUL SYLLABLE-AD3A
        0xAD3B, # G+9541  U+AD3B  uniAD3B,  HANGUL SYLLABLE-AD3B
        0xAD3D, # G+9542  U+AD3D  uniAD3D,  HANGUL SYLLABLE-AD3D
        0xAD3E, # G+9543  U+AD3E  uniAD3E,  HANGUL SYLLABLE-AD3E
        0xAD3F, # G+9544  U+AD3F  uniAD3F,  HANGUL SYLLABLE-AD3F
        0xAD40, # G+9545  U+AD40  uniAD40,  HANGUL SYLLABLE-AD40
        0xAD41, # G+9546  U+AD41  uniAD41,  HANGUL SYLLABLE-AD41
        0xAD42, # G+9547  U+AD42  uniAD42,  HANGUL SYLLABLE-AD42
        0xAD43, # G+9548  U+AD43  uniAD43,  HANGUL SYLLABLE-AD43
        0xAD46, # G+9549  U+AD46  uniAD46,  HANGUL SYLLABLE-AD46
        0xAD48, # G+9550  U+AD48  uniAD48,  HANGUL SYLLABLE-AD48
        0xAD4A, # G+9551  U+AD4A  uniAD4A,  HANGUL SYLLABLE-AD4A
        0xAD4B, # G+9552  U+AD4B  uniAD4B,  HANGUL SYLLABLE-AD4B
        0xAD4C, # G+9553  U+AD4C  uniAD4C,  HANGUL SYLLABLE-AD4C
        0xAD4D, # G+9554  U+AD4D  uniAD4D,  HANGUL SYLLABLE-AD4D
        0xAD4E, # G+9555  U+AD4E  uniAD4E,  HANGUL SYLLABLE-AD4E
        0xAD4F, # G+9556  U+AD4F  uniAD4F,  HANGUL SYLLABLE-AD4F
        0xAD51, # G+9557  U+AD51  uniAD51,  HANGUL SYLLABLE-AD51
        0xAD52, # G+9558  U+AD52  uniAD52,  HANGUL SYLLABLE-AD52
        0xAD53, # G+9559  U+AD53  uniAD53,  HANGUL SYLLABLE-AD53
        0xAD55, # G+9560  U+AD55  uniAD55,  HANGUL SYLLABLE-AD55
        0xAD56, # G+9561  U+AD56  uniAD56,  HANGUL SYLLABLE-AD56
        0xAD57, # G+9562  U+AD57  uniAD57,  HANGUL SYLLABLE-AD57
        0xAD59, # G+9563  U+AD59  uniAD59,  HANGUL SYLLABLE-AD59
        0xAD5A, # G+9564  U+AD5A  uniAD5A,  HANGUL SYLLABLE-AD5A
        0xAD5B, # G+9565  U+AD5B  uniAD5B,  HANGUL SYLLABLE-AD5B
        0xAD5C, # G+9566  U+AD5C  uniAD5C,  HANGUL SYLLABLE-AD5C
        0xAD5D, # G+9567  U+AD5D  uniAD5D,  HANGUL SYLLABLE-AD5D
        0xAD5E, # G+9568  U+AD5E  uniAD5E,  HANGUL SYLLABLE-AD5E
        0xAD5F, # G+9569  U+AD5F  uniAD5F,  HANGUL SYLLABLE-AD5F
        0xAD60, # G+9570  U+AD60  uniAD60,  HANGUL SYLLABLE-AD60
        0xAD62, # G+9571  U+AD62  uniAD62,  HANGUL SYLLABLE-AD62
        0xAD64, # G+9572  U+AD64  uniAD64,  HANGUL SYLLABLE-AD64
        0xAD65, # G+9573  U+AD65  uniAD65,  HANGUL SYLLABLE-AD65
        0xAD66, # G+9574  U+AD66  uniAD66,  HANGUL SYLLABLE-AD66
        0xAD67, # G+9575  U+AD67  uniAD67,  HANGUL SYLLABLE-AD67
        0xAD68, # G+9576  U+AD68  uniAD68,  HANGUL SYLLABLE-AD68
        0xAD69, # G+9577  U+AD69  uniAD69,  HANGUL SYLLABLE-AD69
        0xAD6A, # G+9578  U+AD6A  uniAD6A,  HANGUL SYLLABLE-AD6A
        0xAD6B, # G+9579  U+AD6B  uniAD6B,  HANGUL SYLLABLE-AD6B
        0xAD6E, # G+9580  U+AD6E  uniAD6E,  HANGUL SYLLABLE-AD6E
        0xAD6F, # G+9581  U+AD6F  uniAD6F,  HANGUL SYLLABLE-AD6F
        0xAD71, # G+9582  U+AD71  uniAD71,  HANGUL SYLLABLE-AD71
        0xAD72, # G+9583  U+AD72  uniAD72,  HANGUL SYLLABLE-AD72
        0xAD77, # G+9584  U+AD77  uniAD77,  HANGUL SYLLABLE-AD77
        0xAD78, # G+9585  U+AD78  uniAD78,  HANGUL SYLLABLE-AD78
        0xAD79, # G+9586  U+AD79  uniAD79,  HANGUL SYLLABLE-AD79
        0xAD7A, # G+9587  U+AD7A  uniAD7A,  HANGUL SYLLABLE-AD7A
        0xAD7E, # G+9588  U+AD7E  uniAD7E,  HANGUL SYLLABLE-AD7E
        0xAD80, # G+9589  U+AD80  uniAD80,  HANGUL SYLLABLE-AD80
        0xAD83, # G+9590  U+AD83  uniAD83,  HANGUL SYLLABLE-AD83
        0xAD84, # G+9591  U+AD84  uniAD84,  HANGUL SYLLABLE-AD84
        0xAD85, # G+9592  U+AD85  uniAD85,  HANGUL SYLLABLE-AD85
        0xAD86, # G+9593  U+AD86  uniAD86,  HANGUL SYLLABLE-AD86
        0xAD87, # G+9594  U+AD87  uniAD87,  HANGUL SYLLABLE-AD87
        0xAD8A, # G+9595  U+AD8A  uniAD8A,  HANGUL SYLLABLE-AD8A
        0xAD8B, # G+9596  U+AD8B  uniAD8B,  HANGUL SYLLABLE-AD8B
        0xAD8D, # G+9597  U+AD8D  uniAD8D,  HANGUL SYLLABLE-AD8D
        0xAD8E, # G+9598  U+AD8E  uniAD8E,  HANGUL SYLLABLE-AD8E
        0xAD8F, # G+9599  U+AD8F  uniAD8F,  HANGUL SYLLABLE-AD8F
        0xAD91, # G+9600  U+AD91  uniAD91,  HANGUL SYLLABLE-AD91
        0xAD92, # G+9601  U+AD92  uniAD92,  HANGUL SYLLABLE-AD92
        0xAD93, # G+9602  U+AD93  uniAD93,  HANGUL SYLLABLE-AD93
        0xAD94, # G+9603  U+AD94  uniAD94,  HANGUL SYLLABLE-AD94
        0xAD95, # G+9604  U+AD95  uniAD95,  HANGUL SYLLABLE-AD95
        0xAD96, # G+9605  U+AD96  uniAD96,  HANGUL SYLLABLE-AD96
        0xAD97, # G+9606  U+AD97  uniAD97,  HANGUL SYLLABLE-AD97
        0xAD98, # G+9607  U+AD98  uniAD98,  HANGUL SYLLABLE-AD98
        0xAD99, # G+9608  U+AD99  uniAD99,  HANGUL SYLLABLE-AD99
        0xAD9A, # G+9609  U+AD9A  uniAD9A,  HANGUL SYLLABLE-AD9A
        0xAD9B, # G+9610  U+AD9B  uniAD9B,  HANGUL SYLLABLE-AD9B
        0xAD9E, # G+9611  U+AD9E  uniAD9E,  HANGUL SYLLABLE-AD9E
        0xAD9F, # G+9612  U+AD9F  uniAD9F,  HANGUL SYLLABLE-AD9F
        0xADA0, # G+9613  U+ADA0  uniADA0,  HANGUL SYLLABLE-ADA0
        0xADA1, # G+9614  U+ADA1  uniADA1,  HANGUL SYLLABLE-ADA1
        0xADA2, # G+9615  U+ADA2  uniADA2,  HANGUL SYLLABLE-ADA2
        0xADA3, # G+9616  U+ADA3  uniADA3,  HANGUL SYLLABLE-ADA3
        0xADA5, # G+9617  U+ADA5  uniADA5,  HANGUL SYLLABLE-ADA5
        0xADA6, # G+9618  U+ADA6  uniADA6,  HANGUL SYLLABLE-ADA6
        0xADA7, # G+9619  U+ADA7  uniADA7,  HANGUL SYLLABLE-ADA7
        0xADA8, # G+9620  U+ADA8  uniADA8,  HANGUL SYLLABLE-ADA8
        0xADA9, # G+9621  U+ADA9  uniADA9,  HANGUL SYLLABLE-ADA9
        0xADAA, # G+9622  U+ADAA  uniADAA,  HANGUL SYLLABLE-ADAA
        0xADAB, # G+9623  U+ADAB  uniADAB,  HANGUL SYLLABLE-ADAB
        0xADAC, # G+9624  U+ADAC  uniADAC,  HANGUL SYLLABLE-ADAC
        0xADAD, # G+9625  U+ADAD  uniADAD,  HANGUL SYLLABLE-ADAD
        0xADAE, # G+9626  U+ADAE  uniADAE,  HANGUL SYLLABLE-ADAE
        0xADAF, # G+9627  U+ADAF  uniADAF,  HANGUL SYLLABLE-ADAF
        0xADB0, # G+9628  U+ADB0  uniADB0,  HANGUL SYLLABLE-ADB0
        0xADB1, # G+9629  U+ADB1  uniADB1,  HANGUL SYLLABLE-ADB1
        0xADB2, # G+9630  U+ADB2  uniADB2,  HANGUL SYLLABLE-ADB2
        0xADB3, # G+9631  U+ADB3  uniADB3,  HANGUL SYLLABLE-ADB3
        0xADB4, # G+9632  U+ADB4  uniADB4,  HANGUL SYLLABLE-ADB4
        0xADB5, # G+9633  U+ADB5  uniADB5,  HANGUL SYLLABLE-ADB5
        0xADB6, # G+9634  U+ADB6  uniADB6,  HANGUL SYLLABLE-ADB6
        0xADB8, # G+9635  U+ADB8  uniADB8,  HANGUL SYLLABLE-ADB8
        0xADB9, # G+9636  U+ADB9  uniADB9,  HANGUL SYLLABLE-ADB9
        0xADBA, # G+9637  U+ADBA  uniADBA,  HANGUL SYLLABLE-ADBA
        0xADBB, # G+9638  U+ADBB  uniADBB,  HANGUL SYLLABLE-ADBB
        0xADBC, # G+9639  U+ADBC  uniADBC,  HANGUL SYLLABLE-ADBC
        0xADBD, # G+9640  U+ADBD  uniADBD,  HANGUL SYLLABLE-ADBD
        0xADBE, # G+9641  U+ADBE  uniADBE,  HANGUL SYLLABLE-ADBE
        0xADBF, # G+9642  U+ADBF  uniADBF,  HANGUL SYLLABLE-ADBF
        0xADC2, # G+9643  U+ADC2  uniADC2,  HANGUL SYLLABLE-ADC2
        0xADC3, # G+9644  U+ADC3  uniADC3,  HANGUL SYLLABLE-ADC3
        0xADC5, # G+9645  U+ADC5  uniADC5,  HANGUL SYLLABLE-ADC5
        0xADC6, # G+9646  U+ADC6  uniADC6,  HANGUL SYLLABLE-ADC6
        0xADC7, # G+9647  U+ADC7  uniADC7,  HANGUL SYLLABLE-ADC7
        0xADC9, # G+9648  U+ADC9  uniADC9,  HANGUL SYLLABLE-ADC9
        0xADCA, # G+9649  U+ADCA  uniADCA,  HANGUL SYLLABLE-ADCA
        0xADCB, # G+9650  U+ADCB  uniADCB,  HANGUL SYLLABLE-ADCB
        0xADCC, # G+9651  U+ADCC  uniADCC,  HANGUL SYLLABLE-ADCC
        0xADCD, # G+9652  U+ADCD  uniADCD,  HANGUL SYLLABLE-ADCD
        0xADCE, # G+9653  U+ADCE  uniADCE,  HANGUL SYLLABLE-ADCE
        0xADCF, # G+9654  U+ADCF  uniADCF,  HANGUL SYLLABLE-ADCF
        0xADD2, # G+9655  U+ADD2  uniADD2,  HANGUL SYLLABLE-ADD2
        0xADD4, # G+9656  U+ADD4  uniADD4,  HANGUL SYLLABLE-ADD4
        0xADD5, # G+9657  U+ADD5  uniADD5,  HANGUL SYLLABLE-ADD5
        0xADD6, # G+9658  U+ADD6  uniADD6,  HANGUL SYLLABLE-ADD6
        0xADD7, # G+9659  U+ADD7  uniADD7,  HANGUL SYLLABLE-ADD7
        0xADD8, # G+9660  U+ADD8  uniADD8,  HANGUL SYLLABLE-ADD8
        0xADD9, # G+9661  U+ADD9  uniADD9,  HANGUL SYLLABLE-ADD9
        0xADDA, # G+9662  U+ADDA  uniADDA,  HANGUL SYLLABLE-ADDA
        0xADDB, # G+9663  U+ADDB  uniADDB,  HANGUL SYLLABLE-ADDB
        0xADDD, # G+9664  U+ADDD  uniADDD,  HANGUL SYLLABLE-ADDD
        0xADDE, # G+9665  U+ADDE  uniADDE,  HANGUL SYLLABLE-ADDE
        0xADDF, # G+9666  U+ADDF  uniADDF,  HANGUL SYLLABLE-ADDF
        0xADE1, # G+9667  U+ADE1  uniADE1,  HANGUL SYLLABLE-ADE1
        0xADE2, # G+9668  U+ADE2  uniADE2,  HANGUL SYLLABLE-ADE2
        0xADE3, # G+9669  U+ADE3  uniADE3,  HANGUL SYLLABLE-ADE3
        0xADE5, # G+9670  U+ADE5  uniADE5,  HANGUL SYLLABLE-ADE5
        0xADE6, # G+9671  U+ADE6  uniADE6,  HANGUL SYLLABLE-ADE6
        0xADE7, # G+9672  U+ADE7  uniADE7,  HANGUL SYLLABLE-ADE7
        0xADE8, # G+9673  U+ADE8  uniADE8,  HANGUL SYLLABLE-ADE8
        0xADE9, # G+9674  U+ADE9  uniADE9,  HANGUL SYLLABLE-ADE9
        0xADEA, # G+9675  U+ADEA  uniADEA,  HANGUL SYLLABLE-ADEA
        0xADEB, # G+9676  U+ADEB  uniADEB,  HANGUL SYLLABLE-ADEB
        0xADEC, # G+9677  U+ADEC  uniADEC,  HANGUL SYLLABLE-ADEC
        0xADED, # G+9678  U+ADED  uniADED,  HANGUL SYLLABLE-ADED
        0xADEE, # G+9679  U+ADEE  uniADEE,  HANGUL SYLLABLE-ADEE
        0xADEF, # G+9680  U+ADEF  uniADEF,  HANGUL SYLLABLE-ADEF
        0xADF0, # G+9681  U+ADF0  uniADF0,  HANGUL SYLLABLE-ADF0
        0xADF1, # G+9682  U+ADF1  uniADF1,  HANGUL SYLLABLE-ADF1
        0xADF2, # G+9683  U+ADF2  uniADF2,  HANGUL SYLLABLE-ADF2
        0xADF3, # G+9684  U+ADF3  uniADF3,  HANGUL SYLLABLE-ADF3
        0xADF4, # G+9685  U+ADF4  uniADF4,  HANGUL SYLLABLE-ADF4
        0xADF5, # G+9686  U+ADF5  uniADF5,  HANGUL SYLLABLE-ADF5
        0xADF6, # G+9687  U+ADF6  uniADF6,  HANGUL SYLLABLE-ADF6
        0xADF7, # G+9688  U+ADF7  uniADF7,  HANGUL SYLLABLE-ADF7
        0xADFA, # G+9689  U+ADFA  uniADFA,  HANGUL SYLLABLE-ADFA
        0xADFB, # G+9690  U+ADFB  uniADFB,  HANGUL SYLLABLE-ADFB
        0xADFD, # G+9691  U+ADFD  uniADFD,  HANGUL SYLLABLE-ADFD
        0xADFE, # G+9692  U+ADFE  uniADFE,  HANGUL SYLLABLE-ADFE
        0xAE02, # G+9693  U+AE02  uniAE02,  HANGUL SYLLABLE-AE02
        0xAE03, # G+9694  U+AE03  uniAE03,  HANGUL SYLLABLE-AE03
        0xAE04, # G+9695  U+AE04  uniAE04,  HANGUL SYLLABLE-AE04
        0xAE05, # G+9696  U+AE05  uniAE05,  HANGUL SYLLABLE-AE05
        0xAE06, # G+9697  U+AE06  uniAE06,  HANGUL SYLLABLE-AE06
        0xAE07, # G+9698  U+AE07  uniAE07,  HANGUL SYLLABLE-AE07
        0xAE0A, # G+9699  U+AE0A  uniAE0A,  HANGUL SYLLABLE-AE0A
        0xAE0C, # G+9700  U+AE0C  uniAE0C,  HANGUL SYLLABLE-AE0C
        0xAE0E, # G+9701  U+AE0E  uniAE0E,  HANGUL SYLLABLE-AE0E
        0xAE0F, # G+9702  U+AE0F  uniAE0F,  HANGUL SYLLABLE-AE0F
        0xAE10, # G+9703  U+AE10  uniAE10,  HANGUL SYLLABLE-AE10
        0xAE11, # G+9704  U+AE11  uniAE11,  HANGUL SYLLABLE-AE11
        0xAE12, # G+9705  U+AE12  uniAE12,  HANGUL SYLLABLE-AE12
        0xAE13, # G+9706  U+AE13  uniAE13,  HANGUL SYLLABLE-AE13
        0xAE15, # G+9707  U+AE15  uniAE15,  HANGUL SYLLABLE-AE15
        0xAE16, # G+9708  U+AE16  uniAE16,  HANGUL SYLLABLE-AE16
        0xAE17, # G+9709  U+AE17  uniAE17,  HANGUL SYLLABLE-AE17
        0xAE18, # G+9710  U+AE18  uniAE18,  HANGUL SYLLABLE-AE18
        0xAE19, # G+9711  U+AE19  uniAE19,  HANGUL SYLLABLE-AE19
        0xAE1A, # G+9712  U+AE1A  uniAE1A,  HANGUL SYLLABLE-AE1A
        0xAE1B, # G+9713  U+AE1B  uniAE1B,  HANGUL SYLLABLE-AE1B
        0xAE1C, # G+9714  U+AE1C  uniAE1C,  HANGUL SYLLABLE-AE1C
        0xAE1D, # G+9715  U+AE1D  uniAE1D,  HANGUL SYLLABLE-AE1D
        0xAE1E, # G+9716  U+AE1E  uniAE1E,  HANGUL SYLLABLE-AE1E
        0xAE1F, # G+9717  U+AE1F  uniAE1F,  HANGUL SYLLABLE-AE1F
        0xAE20, # G+9718  U+AE20  uniAE20,  HANGUL SYLLABLE-AE20
        0xAE21, # G+9719  U+AE21  uniAE21,  HANGUL SYLLABLE-AE21
        0xAE22, # G+9720  U+AE22  uniAE22,  HANGUL SYLLABLE-AE22
        0xAE23, # G+9721  U+AE23  uniAE23,  HANGUL SYLLABLE-AE23
        0xAE24, # G+9722  U+AE24  uniAE24,  HANGUL SYLLABLE-AE24
        0xAE25, # G+9723  U+AE25  uniAE25,  HANGUL SYLLABLE-AE25
        0xAE26, # G+9724  U+AE26  uniAE26,  HANGUL SYLLABLE-AE26
        0xAE27, # G+9725  U+AE27  uniAE27,  HANGUL SYLLABLE-AE27
        0xAE28, # G+9726  U+AE28  uniAE28,  HANGUL SYLLABLE-AE28
        0xAE29, # G+9727  U+AE29  uniAE29,  HANGUL SYLLABLE-AE29
        0xAE2A, # G+9728  U+AE2A  uniAE2A,  HANGUL SYLLABLE-AE2A
        0xAE2B, # G+9729  U+AE2B  uniAE2B,  HANGUL SYLLABLE-AE2B
        0xAE2C, # G+9730  U+AE2C  uniAE2C,  HANGUL SYLLABLE-AE2C
        0xAE2D, # G+9731  U+AE2D  uniAE2D,  HANGUL SYLLABLE-AE2D
        0xAE2E, # G+9732  U+AE2E  uniAE2E,  HANGUL SYLLABLE-AE2E
        0xAE2F, # G+9733  U+AE2F  uniAE2F,  HANGUL SYLLABLE-AE2F
        0xAE32, # G+9734  U+AE32  uniAE32,  HANGUL SYLLABLE-AE32
        0xAE33, # G+9735  U+AE33  uniAE33,  HANGUL SYLLABLE-AE33
        0xAE35, # G+9736  U+AE35  uniAE35,  HANGUL SYLLABLE-AE35
        0xAE36, # G+9737  U+AE36  uniAE36,  HANGUL SYLLABLE-AE36
        0xAE39, # G+9738  U+AE39  uniAE39,  HANGUL SYLLABLE-AE39
        0xAE3B, # G+9739  U+AE3B  uniAE3B,  HANGUL SYLLABLE-AE3B
        0xAE3C, # G+9740  U+AE3C  uniAE3C,  HANGUL SYLLABLE-AE3C
        0xAE3D, # G+9741  U+AE3D  uniAE3D,  HANGUL SYLLABLE-AE3D
        0xAE3E, # G+9742  U+AE3E  uniAE3E,  HANGUL SYLLABLE-AE3E
        0xAE3F, # G+9743  U+AE3F  uniAE3F,  HANGUL SYLLABLE-AE3F
        0xAE42, # G+9744  U+AE42  uniAE42,  HANGUL SYLLABLE-AE42
        0xAE44, # G+9745  U+AE44  uniAE44,  HANGUL SYLLABLE-AE44
        0xAE47, # G+9746  U+AE47  uniAE47,  HANGUL SYLLABLE-AE47
        0xAE48, # G+9747  U+AE48  uniAE48,  HANGUL SYLLABLE-AE48
        0xAE49, # G+9748  U+AE49  uniAE49,  HANGUL SYLLABLE-AE49
        0xAE4B, # G+9749  U+AE4B  uniAE4B,  HANGUL SYLLABLE-AE4B
        0xAE4F, # G+9750  U+AE4F  uniAE4F,  HANGUL SYLLABLE-AE4F
        0xAE51, # G+9751  U+AE51  uniAE51,  HANGUL SYLLABLE-AE51
        0xAE52, # G+9752  U+AE52  uniAE52,  HANGUL SYLLABLE-AE52
        0xAE53, # G+9753  U+AE53  uniAE53,  HANGUL SYLLABLE-AE53
        0xAE55, # G+9754  U+AE55  uniAE55,  HANGUL SYLLABLE-AE55
        0xAE57, # G+9755  U+AE57  uniAE57,  HANGUL SYLLABLE-AE57
        0xAE58, # G+9756  U+AE58  uniAE58,  HANGUL SYLLABLE-AE58
        0xAE59, # G+9757  U+AE59  uniAE59,  HANGUL SYLLABLE-AE59
        0xAE5A, # G+9758  U+AE5A  uniAE5A,  HANGUL SYLLABLE-AE5A
        0xAE5B, # G+9759  U+AE5B  uniAE5B,  HANGUL SYLLABLE-AE5B
        0xAE5E, # G+9760  U+AE5E  uniAE5E,  HANGUL SYLLABLE-AE5E
        0xAE62, # G+9761  U+AE62  uniAE62,  HANGUL SYLLABLE-AE62
        0xAE63, # G+9762  U+AE63  uniAE63,  HANGUL SYLLABLE-AE63
        0xAE64, # G+9763  U+AE64  uniAE64,  HANGUL SYLLABLE-AE64
        0xAE66, # G+9764  U+AE66  uniAE66,  HANGUL SYLLABLE-AE66
        0xAE67, # G+9765  U+AE67  uniAE67,  HANGUL SYLLABLE-AE67
        0xAE6A, # G+9766  U+AE6A  uniAE6A,  HANGUL SYLLABLE-AE6A
        0xAE6B, # G+9767  U+AE6B  uniAE6B,  HANGUL SYLLABLE-AE6B
        0xAE6D, # G+9768  U+AE6D  uniAE6D,  HANGUL SYLLABLE-AE6D
        0xAE6E, # G+9769  U+AE6E  uniAE6E,  HANGUL SYLLABLE-AE6E
        0xAE6F, # G+9770  U+AE6F  uniAE6F,  HANGUL SYLLABLE-AE6F
        0xAE71, # G+9771  U+AE71  uniAE71,  HANGUL SYLLABLE-AE71
        0xAE72, # G+9772  U+AE72  uniAE72,  HANGUL SYLLABLE-AE72
        0xAE73, # G+9773  U+AE73  uniAE73,  HANGUL SYLLABLE-AE73
        0xAE74, # G+9774  U+AE74  uniAE74,  HANGUL SYLLABLE-AE74
        0xAE75, # G+9775  U+AE75  uniAE75,  HANGUL SYLLABLE-AE75
        0xAE76, # G+9776  U+AE76  uniAE76,  HANGUL SYLLABLE-AE76
        0xAE77, # G+9777  U+AE77  uniAE77,  HANGUL SYLLABLE-AE77
        0xAE7A, # G+9778  U+AE7A  uniAE7A,  HANGUL SYLLABLE-AE7A
        0xAE7E, # G+9779  U+AE7E  uniAE7E,  HANGUL SYLLABLE-AE7E
        0xAE7F, # G+9780  U+AE7F  uniAE7F,  HANGUL SYLLABLE-AE7F
        0xAE80, # G+9781  U+AE80  uniAE80,  HANGUL SYLLABLE-AE80
        0xAE81, # G+9782  U+AE81  uniAE81,  HANGUL SYLLABLE-AE81
        0xAE82, # G+9783  U+AE82  uniAE82,  HANGUL SYLLABLE-AE82
        0xAE83, # G+9784  U+AE83  uniAE83,  HANGUL SYLLABLE-AE83
        0xAE86, # G+9785  U+AE86  uniAE86,  HANGUL SYLLABLE-AE86
        0xAE87, # G+9786  U+AE87  uniAE87,  HANGUL SYLLABLE-AE87
        0xAE88, # G+9787  U+AE88  uniAE88,  HANGUL SYLLABLE-AE88
        0xAE89, # G+9788  U+AE89  uniAE89,  HANGUL SYLLABLE-AE89
        0xAE8A, # G+9789  U+AE8A  uniAE8A,  HANGUL SYLLABLE-AE8A
        0xAE8B, # G+9790  U+AE8B  uniAE8B,  HANGUL SYLLABLE-AE8B
        0xAE8D, # G+9791  U+AE8D  uniAE8D,  HANGUL SYLLABLE-AE8D
        0xAE8E, # G+9792  U+AE8E  uniAE8E,  HANGUL SYLLABLE-AE8E
        0xAE8F, # G+9793  U+AE8F  uniAE8F,  HANGUL SYLLABLE-AE8F
        0xAE90, # G+9794  U+AE90  uniAE90,  HANGUL SYLLABLE-AE90
        0xAE91, # G+9795  U+AE91  uniAE91,  HANGUL SYLLABLE-AE91
        0xAE92, # G+9796  U+AE92  uniAE92,  HANGUL SYLLABLE-AE92
        0xAE93, # G+9797  U+AE93  uniAE93,  HANGUL SYLLABLE-AE93
        0xAE94, # G+9798  U+AE94  uniAE94,  HANGUL SYLLABLE-AE94
        0xAE95, # G+9799  U+AE95  uniAE95,  HANGUL SYLLABLE-AE95
        0xAE96, # G+9800  U+AE96  uniAE96,  HANGUL SYLLABLE-AE96
        0xAE97, # G+9801  U+AE97  uniAE97,  HANGUL SYLLABLE-AE97
        0xAE98, # G+9802  U+AE98  uniAE98,  HANGUL SYLLABLE-AE98
        0xAE99, # G+9803  U+AE99  uniAE99,  HANGUL SYLLABLE-AE99
        0xAE9A, # G+9804  U+AE9A  uniAE9A,  HANGUL SYLLABLE-AE9A
        0xAE9B, # G+9805  U+AE9B  uniAE9B,  HANGUL SYLLABLE-AE9B
        0xAE9C, # G+9806  U+AE9C  uniAE9C,  HANGUL SYLLABLE-AE9C
        0xAE9D, # G+9807  U+AE9D  uniAE9D,  HANGUL SYLLABLE-AE9D
        0xAE9E, # G+9808  U+AE9E  uniAE9E,  HANGUL SYLLABLE-AE9E
        0xAE9F, # G+9809  U+AE9F  uniAE9F,  HANGUL SYLLABLE-AE9F
        0xAEA0, # G+9810  U+AEA0  uniAEA0,  HANGUL SYLLABLE-AEA0
        0xAEA1, # G+9811  U+AEA1  uniAEA1,  HANGUL SYLLABLE-AEA1
        0xAEA2, # G+9812  U+AEA2  uniAEA2,  HANGUL SYLLABLE-AEA2
        0xAEA3, # G+9813  U+AEA3  uniAEA3,  HANGUL SYLLABLE-AEA3
        0xAEA4, # G+9814  U+AEA4  uniAEA4,  HANGUL SYLLABLE-AEA4
        0xAEA5, # G+9815  U+AEA5  uniAEA5,  HANGUL SYLLABLE-AEA5
        0xAEA6, # G+9816  U+AEA6  uniAEA6,  HANGUL SYLLABLE-AEA6
        0xAEA7, # G+9817  U+AEA7  uniAEA7,  HANGUL SYLLABLE-AEA7
        0xAEA8, # G+9818  U+AEA8  uniAEA8,  HANGUL SYLLABLE-AEA8
        0xAEA9, # G+9819  U+AEA9  uniAEA9,  HANGUL SYLLABLE-AEA9
        0xAEAA, # G+9820  U+AEAA  uniAEAA,  HANGUL SYLLABLE-AEAA
        0xAEAB, # G+9821  U+AEAB  uniAEAB,  HANGUL SYLLABLE-AEAB
        0xAEAC, # G+9822  U+AEAC  uniAEAC,  HANGUL SYLLABLE-AEAC
        0xAEAD, # G+9823  U+AEAD  uniAEAD,  HANGUL SYLLABLE-AEAD
        0xAEAE, # G+9824  U+AEAE  uniAEAE,  HANGUL SYLLABLE-AEAE
        0xAEAF, # G+9825  U+AEAF  uniAEAF,  HANGUL SYLLABLE-AEAF
        0xAEB0, # G+9826  U+AEB0  uniAEB0,  HANGUL SYLLABLE-AEB0
        0xAEB1, # G+9827  U+AEB1  uniAEB1,  HANGUL SYLLABLE-AEB1
        0xAEB2, # G+9828  U+AEB2  uniAEB2,  HANGUL SYLLABLE-AEB2
        0xAEB3, # G+9829  U+AEB3  uniAEB3,  HANGUL SYLLABLE-AEB3
        0xAEB4, # G+9830  U+AEB4  uniAEB4,  HANGUL SYLLABLE-AEB4
        0xAEB5, # G+9831  U+AEB5  uniAEB5,  HANGUL SYLLABLE-AEB5
        0xAEB6, # G+9832  U+AEB6  uniAEB6,  HANGUL SYLLABLE-AEB6
        0xAEB7, # G+9833  U+AEB7  uniAEB7,  HANGUL SYLLABLE-AEB7
        0xAEB8, # G+9834  U+AEB8  uniAEB8,  HANGUL SYLLABLE-AEB8
        0xAEB9, # G+9835  U+AEB9  uniAEB9,  HANGUL SYLLABLE-AEB9
        0xAEBA, # G+9836  U+AEBA  uniAEBA,  HANGUL SYLLABLE-AEBA
        0xAEBB, # G+9837  U+AEBB  uniAEBB,  HANGUL SYLLABLE-AEBB
        0xAEBF, # G+9838  U+AEBF  uniAEBF,  HANGUL SYLLABLE-AEBF
        0xAEC1, # G+9839  U+AEC1  uniAEC1,  HANGUL SYLLABLE-AEC1
        0xAEC2, # G+9840  U+AEC2  uniAEC2,  HANGUL SYLLABLE-AEC2
        0xAEC3, # G+9841  U+AEC3  uniAEC3,  HANGUL SYLLABLE-AEC3
        0xAEC5, # G+9842  U+AEC5  uniAEC5,  HANGUL SYLLABLE-AEC5
        0xAEC6, # G+9843  U+AEC6  uniAEC6,  HANGUL SYLLABLE-AEC6
        0xAEC7, # G+9844  U+AEC7  uniAEC7,  HANGUL SYLLABLE-AEC7
        0xAEC8, # G+9845  U+AEC8  uniAEC8,  HANGUL SYLLABLE-AEC8
        0xAEC9, # G+9846  U+AEC9  uniAEC9,  HANGUL SYLLABLE-AEC9
        0xAECA, # G+9847  U+AECA  uniAECA,  HANGUL SYLLABLE-AECA
        0xAECB, # G+9848  U+AECB  uniAECB,  HANGUL SYLLABLE-AECB
        0xAECE, # G+9849  U+AECE  uniAECE,  HANGUL SYLLABLE-AECE
        0xAED2, # G+9850  U+AED2  uniAED2,  HANGUL SYLLABLE-AED2
        0xAED3, # G+9851  U+AED3  uniAED3,  HANGUL SYLLABLE-AED3
        0xAED4, # G+9852  U+AED4  uniAED4,  HANGUL SYLLABLE-AED4
        0xAED5, # G+9853  U+AED5  uniAED5,  HANGUL SYLLABLE-AED5
        0xAED6, # G+9854  U+AED6  uniAED6,  HANGUL SYLLABLE-AED6
        0xAED7, # G+9855  U+AED7  uniAED7,  HANGUL SYLLABLE-AED7
        0xAEDA, # G+9856  U+AEDA  uniAEDA,  HANGUL SYLLABLE-AEDA
        0xAEDB, # G+9857  U+AEDB  uniAEDB,  HANGUL SYLLABLE-AEDB
        0xAEDD, # G+9858  U+AEDD  uniAEDD,  HANGUL SYLLABLE-AEDD
        0xAEDE, # G+9859  U+AEDE  uniAEDE,  HANGUL SYLLABLE-AEDE
        0xAEDF, # G+9860  U+AEDF  uniAEDF,  HANGUL SYLLABLE-AEDF
        0xAEE0, # G+9861  U+AEE0  uniAEE0,  HANGUL SYLLABLE-AEE0
        0xAEE1, # G+9862  U+AEE1  uniAEE1,  HANGUL SYLLABLE-AEE1
        0xAEE2, # G+9863  U+AEE2  uniAEE2,  HANGUL SYLLABLE-AEE2
        0xAEE3, # G+9864  U+AEE3  uniAEE3,  HANGUL SYLLABLE-AEE3
        0xAEE4, # G+9865  U+AEE4  uniAEE4,  HANGUL SYLLABLE-AEE4
        0xAEE5, # G+9866  U+AEE5  uniAEE5,  HANGUL SYLLABLE-AEE5
        0xAEE6, # G+9867  U+AEE6  uniAEE6,  HANGUL SYLLABLE-AEE6
        0xAEE7, # G+9868  U+AEE7  uniAEE7,  HANGUL SYLLABLE-AEE7
        0xAEE9, # G+9869  U+AEE9  uniAEE9,  HANGUL SYLLABLE-AEE9
        0xAEEA, # G+9870  U+AEEA  uniAEEA,  HANGUL SYLLABLE-AEEA
        0xAEEC, # G+9871  U+AEEC  uniAEEC,  HANGUL SYLLABLE-AEEC
        0xAEEE, # G+9872  U+AEEE  uniAEEE,  HANGUL SYLLABLE-AEEE
        0xAEEF, # G+9873  U+AEEF  uniAEEF,  HANGUL SYLLABLE-AEEF
        0xAEF0, # G+9874  U+AEF0  uniAEF0,  HANGUL SYLLABLE-AEF0
        0xAEF1, # G+9875  U+AEF1  uniAEF1,  HANGUL SYLLABLE-AEF1
        0xAEF2, # G+9876  U+AEF2  uniAEF2,  HANGUL SYLLABLE-AEF2
        0xAEF3, # G+9877  U+AEF3  uniAEF3,  HANGUL SYLLABLE-AEF3
        0xAEF5, # G+9878  U+AEF5  uniAEF5,  HANGUL SYLLABLE-AEF5
        0xAEF6, # G+9879  U+AEF6  uniAEF6,  HANGUL SYLLABLE-AEF6
        0xAEF7, # G+9880  U+AEF7  uniAEF7,  HANGUL SYLLABLE-AEF7
        0xAEF9, # G+9881  U+AEF9  uniAEF9,  HANGUL SYLLABLE-AEF9
        0xAEFA, # G+9882  U+AEFA  uniAEFA,  HANGUL SYLLABLE-AEFA
        0xAEFB, # G+9883  U+AEFB  uniAEFB,  HANGUL SYLLABLE-AEFB
        0xAEFD, # G+9884  U+AEFD  uniAEFD,  HANGUL SYLLABLE-AEFD
        0xAEFE, # G+9885  U+AEFE  uniAEFE,  HANGUL SYLLABLE-AEFE
        0xAEFF, # G+9886  U+AEFF  uniAEFF,  HANGUL SYLLABLE-AEFF
        0xAF00, # G+9887  U+AF00  uniAF00,  HANGUL SYLLABLE-AF00
        0xAF01, # G+9888  U+AF01  uniAF01,  HANGUL SYLLABLE-AF01
        0xAF02, # G+9889  U+AF02  uniAF02,  HANGUL SYLLABLE-AF02
        0xAF03, # G+9890  U+AF03  uniAF03,  HANGUL SYLLABLE-AF03
        0xAF04, # G+9891  U+AF04  uniAF04,  HANGUL SYLLABLE-AF04
        0xAF05, # G+9892  U+AF05  uniAF05,  HANGUL SYLLABLE-AF05
        0xAF06, # G+9893  U+AF06  uniAF06,  HANGUL SYLLABLE-AF06
        0xAF09, # G+9894  U+AF09  uniAF09,  HANGUL SYLLABLE-AF09
        0xAF0A, # G+9895  U+AF0A  uniAF0A,  HANGUL SYLLABLE-AF0A
        0xAF0B, # G+9896  U+AF0B  uniAF0B,  HANGUL SYLLABLE-AF0B
        0xAF0C, # G+9897  U+AF0C  uniAF0C,  HANGUL SYLLABLE-AF0C
        0xAF0E, # G+9898  U+AF0E  uniAF0E,  HANGUL SYLLABLE-AF0E
        0xAF0F, # G+9899  U+AF0F  uniAF0F,  HANGUL SYLLABLE-AF0F
        0xAF11, # G+9900  U+AF11  uniAF11,  HANGUL SYLLABLE-AF11
        0xAF12, # G+9901  U+AF12  uniAF12,  HANGUL SYLLABLE-AF12
        0xAF13, # G+9902  U+AF13  uniAF13,  HANGUL SYLLABLE-AF13
        0xAF14, # G+9903  U+AF14  uniAF14,  HANGUL SYLLABLE-AF14
        0xAF15, # G+9904  U+AF15  uniAF15,  HANGUL SYLLABLE-AF15
        0xAF16, # G+9905  U+AF16  uniAF16,  HANGUL SYLLABLE-AF16
        0xAF17, # G+9906  U+AF17  uniAF17,  HANGUL SYLLABLE-AF17
        0xAF18, # G+9907  U+AF18  uniAF18,  HANGUL SYLLABLE-AF18
        0xAF19, # G+9908  U+AF19  uniAF19,  HANGUL SYLLABLE-AF19
        0xAF1A, # G+9909  U+AF1A  uniAF1A,  HANGUL SYLLABLE-AF1A
        0xAF1B, # G+9910  U+AF1B  uniAF1B,  HANGUL SYLLABLE-AF1B
        0xAF1C, # G+9911  U+AF1C  uniAF1C,  HANGUL SYLLABLE-AF1C
        0xAF1D, # G+9912  U+AF1D  uniAF1D,  HANGUL SYLLABLE-AF1D
        0xAF1E, # G+9913  U+AF1E  uniAF1E,  HANGUL SYLLABLE-AF1E
        0xAF1F, # G+9914  U+AF1F  uniAF1F,  HANGUL SYLLABLE-AF1F
        0xAF20, # G+9915  U+AF20  uniAF20,  HANGUL SYLLABLE-AF20
        0xAF21, # G+9916  U+AF21  uniAF21,  HANGUL SYLLABLE-AF21
        0xAF22, # G+9917  U+AF22  uniAF22,  HANGUL SYLLABLE-AF22
        0xAF23, # G+9918  U+AF23  uniAF23,  HANGUL SYLLABLE-AF23
        0xAF24, # G+9919  U+AF24  uniAF24,  HANGUL SYLLABLE-AF24
        0xAF25, # G+9920  U+AF25  uniAF25,  HANGUL SYLLABLE-AF25
        0xAF26, # G+9921  U+AF26  uniAF26,  HANGUL SYLLABLE-AF26
        0xAF27, # G+9922  U+AF27  uniAF27,  HANGUL SYLLABLE-AF27
        0xAF28, # G+9923  U+AF28  uniAF28,  HANGUL SYLLABLE-AF28
        0xAF29, # G+9924  U+AF29  uniAF29,  HANGUL SYLLABLE-AF29
        0xAF2A, # G+9925  U+AF2A  uniAF2A,  HANGUL SYLLABLE-AF2A
        0xAF2B, # G+9926  U+AF2B  uniAF2B,  HANGUL SYLLABLE-AF2B
        0xAF2E, # G+9927  U+AF2E  uniAF2E,  HANGUL SYLLABLE-AF2E
        0xAF2F, # G+9928  U+AF2F  uniAF2F,  HANGUL SYLLABLE-AF2F
        0xAF31, # G+9929  U+AF31  uniAF31,  HANGUL SYLLABLE-AF31
        0xAF33, # G+9930  U+AF33  uniAF33,  HANGUL SYLLABLE-AF33
        0xAF35, # G+9931  U+AF35  uniAF35,  HANGUL SYLLABLE-AF35
        0xAF36, # G+9932  U+AF36  uniAF36,  HANGUL SYLLABLE-AF36
        0xAF37, # G+9933  U+AF37  uniAF37,  HANGUL SYLLABLE-AF37
        0xAF38, # G+9934  U+AF38  uniAF38,  HANGUL SYLLABLE-AF38
        0xAF39, # G+9935  U+AF39  uniAF39,  HANGUL SYLLABLE-AF39
        0xAF3A, # G+9936  U+AF3A  uniAF3A,  HANGUL SYLLABLE-AF3A
        0xAF3B, # G+9937  U+AF3B  uniAF3B,  HANGUL SYLLABLE-AF3B
        0xAF3E, # G+9938  U+AF3E  uniAF3E,  HANGUL SYLLABLE-AF3E
        0xAF40, # G+9939  U+AF40  uniAF40,  HANGUL SYLLABLE-AF40
        0xAF44, # G+9940  U+AF44  uniAF44,  HANGUL SYLLABLE-AF44
        0xAF45, # G+9941  U+AF45  uniAF45,  HANGUL SYLLABLE-AF45
        0xAF46, # G+9942  U+AF46  uniAF46,  HANGUL SYLLABLE-AF46
        0xAF47, # G+9943  U+AF47  uniAF47,  HANGUL SYLLABLE-AF47
        0xAF4A, # G+9944  U+AF4A  uniAF4A,  HANGUL SYLLABLE-AF4A
        0xAF4B, # G+9945  U+AF4B  uniAF4B,  HANGUL SYLLABLE-AF4B
        0xAF4C, # G+9946  U+AF4C  uniAF4C,  HANGUL SYLLABLE-AF4C
        0xAF4D, # G+9947  U+AF4D  uniAF4D,  HANGUL SYLLABLE-AF4D
        0xAF4E, # G+9948  U+AF4E  uniAF4E,  HANGUL SYLLABLE-AF4E
        0xAF4F, # G+9949  U+AF4F  uniAF4F,  HANGUL SYLLABLE-AF4F
        0xAF51, # G+9950  U+AF51  uniAF51,  HANGUL SYLLABLE-AF51
        0xAF52, # G+9951  U+AF52  uniAF52,  HANGUL SYLLABLE-AF52
        0xAF53, # G+9952  U+AF53  uniAF53,  HANGUL SYLLABLE-AF53
        0xAF54, # G+9953  U+AF54  uniAF54,  HANGUL SYLLABLE-AF54
        0xAF55, # G+9954  U+AF55  uniAF55,  HANGUL SYLLABLE-AF55
        0xAF56, # G+9955  U+AF56  uniAF56,  HANGUL SYLLABLE-AF56
        0xAF57, # G+9956  U+AF57  uniAF57,  HANGUL SYLLABLE-AF57
        0xAF58, # G+9957  U+AF58  uniAF58,  HANGUL SYLLABLE-AF58
        0xAF59, # G+9958  U+AF59  uniAF59,  HANGUL SYLLABLE-AF59
        0xAF5A, # G+9959  U+AF5A  uniAF5A,  HANGUL SYLLABLE-AF5A
        0xAF5B, # G+9960  U+AF5B  uniAF5B,  HANGUL SYLLABLE-AF5B
        0xAF5E, # G+9961  U+AF5E  uniAF5E,  HANGUL SYLLABLE-AF5E
        0xAF5F, # G+9962  U+AF5F  uniAF5F,  HANGUL SYLLABLE-AF5F
        0xAF60, # G+9963  U+AF60  uniAF60,  HANGUL SYLLABLE-AF60
        0xAF61, # G+9964  U+AF61  uniAF61,  HANGUL SYLLABLE-AF61
        0xAF62, # G+9965  U+AF62  uniAF62,  HANGUL SYLLABLE-AF62
        0xAF63, # G+9966  U+AF63  uniAF63,  HANGUL SYLLABLE-AF63
        0xAF66, # G+9967  U+AF66  uniAF66,  HANGUL SYLLABLE-AF66
        0xAF67, # G+9968  U+AF67  uniAF67,  HANGUL SYLLABLE-AF67
        0xAF68, # G+9969  U+AF68  uniAF68,  HANGUL SYLLABLE-AF68
        0xAF69, # G+9970  U+AF69  uniAF69,  HANGUL SYLLABLE-AF69
        0xAF6A, # G+9971  U+AF6A  uniAF6A,  HANGUL SYLLABLE-AF6A
        0xAF6B, # G+9972  U+AF6B  uniAF6B,  HANGUL SYLLABLE-AF6B
        0xAF6C, # G+9973  U+AF6C  uniAF6C,  HANGUL SYLLABLE-AF6C
        0xAF6D, # G+9974  U+AF6D  uniAF6D,  HANGUL SYLLABLE-AF6D
        0xAF6E, # G+9975  U+AF6E  uniAF6E,  HANGUL SYLLABLE-AF6E
        0xAF6F, # G+9976  U+AF6F  uniAF6F,  HANGUL SYLLABLE-AF6F
        0xAF70, # G+9977  U+AF70  uniAF70,  HANGUL SYLLABLE-AF70
        0xAF71, # G+9978  U+AF71  uniAF71,  HANGUL SYLLABLE-AF71
        0xAF72, # G+9979  U+AF72  uniAF72,  HANGUL SYLLABLE-AF72
        0xAF73, # G+9980  U+AF73  uniAF73,  HANGUL SYLLABLE-AF73
        0xAF74, # G+9981  U+AF74  uniAF74,  HANGUL SYLLABLE-AF74
        0xAF75, # G+9982  U+AF75  uniAF75,  HANGUL SYLLABLE-AF75
        0xAF76, # G+9983  U+AF76  uniAF76,  HANGUL SYLLABLE-AF76
        0xAF77, # G+9984  U+AF77  uniAF77,  HANGUL SYLLABLE-AF77
        0xAF78, # G+9985  U+AF78  uniAF78,  HANGUL SYLLABLE-AF78
        0xAF7A, # G+9986  U+AF7A  uniAF7A,  HANGUL SYLLABLE-AF7A
        0xAF7B, # G+9987  U+AF7B  uniAF7B,  HANGUL SYLLABLE-AF7B
        0xAF7C, # G+9988  U+AF7C  uniAF7C,  HANGUL SYLLABLE-AF7C
        0xAF7D, # G+9989  U+AF7D  uniAF7D,  HANGUL SYLLABLE-AF7D
        0xAF7E, # G+9990  U+AF7E  uniAF7E,  HANGUL SYLLABLE-AF7E
        0xAF7F, # G+9991  U+AF7F  uniAF7F,  HANGUL SYLLABLE-AF7F
        0xAF81, # G+9992  U+AF81  uniAF81,  HANGUL SYLLABLE-AF81
        0xAF82, # G+9993  U+AF82  uniAF82,  HANGUL SYLLABLE-AF82
        0xAF83, # G+9994  U+AF83  uniAF83,  HANGUL SYLLABLE-AF83
        0xAF85, # G+9995  U+AF85  uniAF85,  HANGUL SYLLABLE-AF85
        0xAF86, # G+9996  U+AF86  uniAF86,  HANGUL SYLLABLE-AF86
        0xAF87, # G+9997  U+AF87  uniAF87,  HANGUL SYLLABLE-AF87
        0xAF89, # G+9998  U+AF89  uniAF89,  HANGUL SYLLABLE-AF89
        0xAF8A, # G+9999  U+AF8A  uniAF8A,  HANGUL SYLLABLE-AF8A
        0xAF8B, # G+10000  U+AF8B  uniAF8B,  HANGUL SYLLABLE-AF8B
        0xAF8C, # G+10001  U+AF8C  uniAF8C,  HANGUL SYLLABLE-AF8C
        0xAF8D, # G+10002  U+AF8D  uniAF8D,  HANGUL SYLLABLE-AF8D
        0xAF8E, # G+10003  U+AF8E  uniAF8E,  HANGUL SYLLABLE-AF8E
        0xAF8F, # G+10004  U+AF8F  uniAF8F,  HANGUL SYLLABLE-AF8F
        0xAF92, # G+10005  U+AF92  uniAF92,  HANGUL SYLLABLE-AF92
        0xAF93, # G+10006  U+AF93  uniAF93,  HANGUL SYLLABLE-AF93
        0xAF94, # G+10007  U+AF94  uniAF94,  HANGUL SYLLABLE-AF94
        0xAF96, # G+10008  U+AF96  uniAF96,  HANGUL SYLLABLE-AF96
        0xAF97, # G+10009  U+AF97  uniAF97,  HANGUL SYLLABLE-AF97
        0xAF98, # G+10010  U+AF98  uniAF98,  HANGUL SYLLABLE-AF98
        0xAF99, # G+10011  U+AF99  uniAF99,  HANGUL SYLLABLE-AF99
        0xAF9A, # G+10012  U+AF9A  uniAF9A,  HANGUL SYLLABLE-AF9A
        0xAF9B, # G+10013  U+AF9B  uniAF9B,  HANGUL SYLLABLE-AF9B
        0xAF9D, # G+10014  U+AF9D  uniAF9D,  HANGUL SYLLABLE-AF9D
        0xAF9E, # G+10015  U+AF9E  uniAF9E,  HANGUL SYLLABLE-AF9E
        0xAF9F, # G+10016  U+AF9F  uniAF9F,  HANGUL SYLLABLE-AF9F
        0xAFA0, # G+10017  U+AFA0  uniAFA0,  HANGUL SYLLABLE-AFA0
        0xAFA1, # G+10018  U+AFA1  uniAFA1,  HANGUL SYLLABLE-AFA1
        0xAFA2, # G+10019  U+AFA2  uniAFA2,  HANGUL SYLLABLE-AFA2
        0xAFA3, # G+10020  U+AFA3  uniAFA3,  HANGUL SYLLABLE-AFA3
        0xAFA4, # G+10021  U+AFA4  uniAFA4,  HANGUL SYLLABLE-AFA4
        0xAFA5, # G+10022  U+AFA5  uniAFA5,  HANGUL SYLLABLE-AFA5
        0xAFA6, # G+10023  U+AFA6  uniAFA6,  HANGUL SYLLABLE-AFA6
        0xAFA7, # G+10024  U+AFA7  uniAFA7,  HANGUL SYLLABLE-AFA7
        0xAFA8, # G+10025  U+AFA8  uniAFA8,  HANGUL SYLLABLE-AFA8
        0xAFA9, # G+10026  U+AFA9  uniAFA9,  HANGUL SYLLABLE-AFA9
        0xAFAA, # G+10027  U+AFAA  uniAFAA,  HANGUL SYLLABLE-AFAA
        0xAFAB, # G+10028  U+AFAB  uniAFAB,  HANGUL SYLLABLE-AFAB
        0xAFAC, # G+10029  U+AFAC  uniAFAC,  HANGUL SYLLABLE-AFAC
        0xAFAD, # G+10030  U+AFAD  uniAFAD,  HANGUL SYLLABLE-AFAD
        0xAFAE, # G+10031  U+AFAE  uniAFAE,  HANGUL SYLLABLE-AFAE
        0xAFAF, # G+10032  U+AFAF  uniAFAF,  HANGUL SYLLABLE-AFAF
        0xAFB0, # G+10033  U+AFB0  uniAFB0,  HANGUL SYLLABLE-AFB0
        0xAFB1, # G+10034  U+AFB1  uniAFB1,  HANGUL SYLLABLE-AFB1
        0xAFB2, # G+10035  U+AFB2  uniAFB2,  HANGUL SYLLABLE-AFB2
        0xAFB3, # G+10036  U+AFB3  uniAFB3,  HANGUL SYLLABLE-AFB3
        0xAFB4, # G+10037  U+AFB4  uniAFB4,  HANGUL SYLLABLE-AFB4
        0xAFB5, # G+10038  U+AFB5  uniAFB5,  HANGUL SYLLABLE-AFB5
        0xAFB6, # G+10039  U+AFB6  uniAFB6,  HANGUL SYLLABLE-AFB6
        0xAFB7, # G+10040  U+AFB7  uniAFB7,  HANGUL SYLLABLE-AFB7
        0xAFBA, # G+10041  U+AFBA  uniAFBA,  HANGUL SYLLABLE-AFBA
        0xAFBB, # G+10042  U+AFBB  uniAFBB,  HANGUL SYLLABLE-AFBB
        0xAFBD, # G+10043  U+AFBD  uniAFBD,  HANGUL SYLLABLE-AFBD
        0xAFBE, # G+10044  U+AFBE  uniAFBE,  HANGUL SYLLABLE-AFBE
        0xAFBF, # G+10045  U+AFBF  uniAFBF,  HANGUL SYLLABLE-AFBF
        0xAFC1, # G+10046  U+AFC1  uniAFC1,  HANGUL SYLLABLE-AFC1
        0xAFC2, # G+10047  U+AFC2  uniAFC2,  HANGUL SYLLABLE-AFC2
        0xAFC3, # G+10048  U+AFC3  uniAFC3,  HANGUL SYLLABLE-AFC3
        0xAFC4, # G+10049  U+AFC4  uniAFC4,  HANGUL SYLLABLE-AFC4
        0xAFC5, # G+10050  U+AFC5  uniAFC5,  HANGUL SYLLABLE-AFC5
        0xAFC6, # G+10051  U+AFC6  uniAFC6,  HANGUL SYLLABLE-AFC6
        0xAFCA, # G+10052  U+AFCA  uniAFCA,  HANGUL SYLLABLE-AFCA
        0xAFCC, # G+10053  U+AFCC  uniAFCC,  HANGUL SYLLABLE-AFCC
        0xAFCF, # G+10054  U+AFCF  uniAFCF,  HANGUL SYLLABLE-AFCF
        0xAFD0, # G+10055  U+AFD0  uniAFD0,  HANGUL SYLLABLE-AFD0
        0xAFD1, # G+10056  U+AFD1  uniAFD1,  HANGUL SYLLABLE-AFD1
        0xAFD2, # G+10057  U+AFD2  uniAFD2,  HANGUL SYLLABLE-AFD2
        0xAFD3, # G+10058  U+AFD3  uniAFD3,  HANGUL SYLLABLE-AFD3
        0xAFD5, # G+10059  U+AFD5  uniAFD5,  HANGUL SYLLABLE-AFD5
        0xAFD6, # G+10060  U+AFD6  uniAFD6,  HANGUL SYLLABLE-AFD6
        0xAFD7, # G+10061  U+AFD7  uniAFD7,  HANGUL SYLLABLE-AFD7
        0xAFD8, # G+10062  U+AFD8  uniAFD8,  HANGUL SYLLABLE-AFD8
        0xAFD9, # G+10063  U+AFD9  uniAFD9,  HANGUL SYLLABLE-AFD9
        0xAFDA, # G+10064  U+AFDA  uniAFDA,  HANGUL SYLLABLE-AFDA
        0xAFDB, # G+10065  U+AFDB  uniAFDB,  HANGUL SYLLABLE-AFDB
        0xAFDD, # G+10066  U+AFDD  uniAFDD,  HANGUL SYLLABLE-AFDD
        0xAFDE, # G+10067  U+AFDE  uniAFDE,  HANGUL SYLLABLE-AFDE
        0xAFDF, # G+10068  U+AFDF  uniAFDF,  HANGUL SYLLABLE-AFDF
        0xAFE0, # G+10069  U+AFE0  uniAFE0,  HANGUL SYLLABLE-AFE0
        0xAFE1, # G+10070  U+AFE1  uniAFE1,  HANGUL SYLLABLE-AFE1
        0xAFE2, # G+10071  U+AFE2  uniAFE2,  HANGUL SYLLABLE-AFE2
        0xAFE3, # G+10072  U+AFE3  uniAFE3,  HANGUL SYLLABLE-AFE3
        0xAFE4, # G+10073  U+AFE4  uniAFE4,  HANGUL SYLLABLE-AFE4
        0xAFE5, # G+10074  U+AFE5  uniAFE5,  HANGUL SYLLABLE-AFE5
        0xAFE6, # G+10075  U+AFE6  uniAFE6,  HANGUL SYLLABLE-AFE6
        0xAFE7, # G+10076  U+AFE7  uniAFE7,  HANGUL SYLLABLE-AFE7
        0xAFEA, # G+10077  U+AFEA  uniAFEA,  HANGUL SYLLABLE-AFEA
        0xAFEB, # G+10078  U+AFEB  uniAFEB,  HANGUL SYLLABLE-AFEB
        0xAFEC, # G+10079  U+AFEC  uniAFEC,  HANGUL SYLLABLE-AFEC
        0xAFED, # G+10080  U+AFED  uniAFED,  HANGUL SYLLABLE-AFED
        0xAFEE, # G+10081  U+AFEE  uniAFEE,  HANGUL SYLLABLE-AFEE
        0xAFEF, # G+10082  U+AFEF  uniAFEF,  HANGUL SYLLABLE-AFEF
        0xAFF2, # G+10083  U+AFF2  uniAFF2,  HANGUL SYLLABLE-AFF2
        0xAFF3, # G+10084  U+AFF3  uniAFF3,  HANGUL SYLLABLE-AFF3
        0xAFF5, # G+10085  U+AFF5  uniAFF5,  HANGUL SYLLABLE-AFF5
        0xAFF6, # G+10086  U+AFF6  uniAFF6,  HANGUL SYLLABLE-AFF6
        0xAFF7, # G+10087  U+AFF7  uniAFF7,  HANGUL SYLLABLE-AFF7
        0xAFF9, # G+10088  U+AFF9  uniAFF9,  HANGUL SYLLABLE-AFF9
        0xAFFA, # G+10089  U+AFFA  uniAFFA,  HANGUL SYLLABLE-AFFA
        0xAFFB, # G+10090  U+AFFB  uniAFFB,  HANGUL SYLLABLE-AFFB
        0xAFFC, # G+10091  U+AFFC  uniAFFC,  HANGUL SYLLABLE-AFFC
        0xAFFD, # G+10092  U+AFFD  uniAFFD,  HANGUL SYLLABLE-AFFD
        0xAFFE, # G+10093  U+AFFE  uniAFFE,  HANGUL SYLLABLE-AFFE
        0xAFFF, # G+10094  U+AFFF  uniAFFF,  HANGUL SYLLABLE-AFFF
        0xB002, # G+10095  U+B002  uniB002,  HANGUL SYLLABLE-B002
        0xB003, # G+10096  U+B003  uniB003,  HANGUL SYLLABLE-B003
        0xB005, # G+10097  U+B005  uniB005,  HANGUL SYLLABLE-B005
        0xB006, # G+10098  U+B006  uniB006,  HANGUL SYLLABLE-B006
        0xB007, # G+10099  U+B007  uniB007,  HANGUL SYLLABLE-B007
        0xB008, # G+10100  U+B008  uniB008,  HANGUL SYLLABLE-B008
        0xB009, # G+10101  U+B009  uniB009,  HANGUL SYLLABLE-B009
        0xB00A, # G+10102  U+B00A  uniB00A,  HANGUL SYLLABLE-B00A
        0xB00B, # G+10103  U+B00B  uniB00B,  HANGUL SYLLABLE-B00B
        0xB00D, # G+10104  U+B00D  uniB00D,  HANGUL SYLLABLE-B00D
        0xB00E, # G+10105  U+B00E  uniB00E,  HANGUL SYLLABLE-B00E
        0xB00F, # G+10106  U+B00F  uniB00F,  HANGUL SYLLABLE-B00F
        0xB011, # G+10107  U+B011  uniB011,  HANGUL SYLLABLE-B011
        0xB012, # G+10108  U+B012  uniB012,  HANGUL SYLLABLE-B012
        0xB013, # G+10109  U+B013  uniB013,  HANGUL SYLLABLE-B013
        0xB015, # G+10110  U+B015  uniB015,  HANGUL SYLLABLE-B015
        0xB016, # G+10111  U+B016  uniB016,  HANGUL SYLLABLE-B016
        0xB017, # G+10112  U+B017  uniB017,  HANGUL SYLLABLE-B017
        0xB018, # G+10113  U+B018  uniB018,  HANGUL SYLLABLE-B018
        0xB019, # G+10114  U+B019  uniB019,  HANGUL SYLLABLE-B019
        0xB01A, # G+10115  U+B01A  uniB01A,  HANGUL SYLLABLE-B01A
        0xB01B, # G+10116  U+B01B  uniB01B,  HANGUL SYLLABLE-B01B
        0xB01E, # G+10117  U+B01E  uniB01E,  HANGUL SYLLABLE-B01E
        0xB01F, # G+10118  U+B01F  uniB01F,  HANGUL SYLLABLE-B01F
        0xB020, # G+10119  U+B020  uniB020,  HANGUL SYLLABLE-B020
        0xB021, # G+10120  U+B021  uniB021,  HANGUL SYLLABLE-B021
        0xB022, # G+10121  U+B022  uniB022,  HANGUL SYLLABLE-B022
        0xB023, # G+10122  U+B023  uniB023,  HANGUL SYLLABLE-B023
        0xB024, # G+10123  U+B024  uniB024,  HANGUL SYLLABLE-B024
        0xB025, # G+10124  U+B025  uniB025,  HANGUL SYLLABLE-B025
        0xB026, # G+10125  U+B026  uniB026,  HANGUL SYLLABLE-B026
        0xB027, # G+10126  U+B027  uniB027,  HANGUL SYLLABLE-B027
        0xB029, # G+10127  U+B029  uniB029,  HANGUL SYLLABLE-B029
        0xB02A, # G+10128  U+B02A  uniB02A,  HANGUL SYLLABLE-B02A
        0xB02B, # G+10129  U+B02B  uniB02B,  HANGUL SYLLABLE-B02B
        0xB02C, # G+10130  U+B02C  uniB02C,  HANGUL SYLLABLE-B02C
        0xB02D, # G+10131  U+B02D  uniB02D,  HANGUL SYLLABLE-B02D
        0xB02E, # G+10132  U+B02E  uniB02E,  HANGUL SYLLABLE-B02E
        0xB02F, # G+10133  U+B02F  uniB02F,  HANGUL SYLLABLE-B02F
        0xB030, # G+10134  U+B030  uniB030,  HANGUL SYLLABLE-B030
        0xB031, # G+10135  U+B031  uniB031,  HANGUL SYLLABLE-B031
        0xB032, # G+10136  U+B032  uniB032,  HANGUL SYLLABLE-B032
        0xB033, # G+10137  U+B033  uniB033,  HANGUL SYLLABLE-B033
        0xB034, # G+10138  U+B034  uniB034,  HANGUL SYLLABLE-B034
        0xB035, # G+10139  U+B035  uniB035,  HANGUL SYLLABLE-B035
        0xB036, # G+10140  U+B036  uniB036,  HANGUL SYLLABLE-B036
        0xB037, # G+10141  U+B037  uniB037,  HANGUL SYLLABLE-B037
        0xB038, # G+10142  U+B038  uniB038,  HANGUL SYLLABLE-B038
        0xB039, # G+10143  U+B039  uniB039,  HANGUL SYLLABLE-B039
        0xB03A, # G+10144  U+B03A  uniB03A,  HANGUL SYLLABLE-B03A
        0xB03B, # G+10145  U+B03B  uniB03B,  HANGUL SYLLABLE-B03B
        0xB03C, # G+10146  U+B03C  uniB03C,  HANGUL SYLLABLE-B03C
        0xB03D, # G+10147  U+B03D  uniB03D,  HANGUL SYLLABLE-B03D
        0xB03E, # G+10148  U+B03E  uniB03E,  HANGUL SYLLABLE-B03E
        0xB03F, # G+10149  U+B03F  uniB03F,  HANGUL SYLLABLE-B03F
        0xB040, # G+10150  U+B040  uniB040,  HANGUL SYLLABLE-B040
        0xB041, # G+10151  U+B041  uniB041,  HANGUL SYLLABLE-B041
        0xB042, # G+10152  U+B042  uniB042,  HANGUL SYLLABLE-B042
        0xB043, # G+10153  U+B043  uniB043,  HANGUL SYLLABLE-B043
        0xB046, # G+10154  U+B046  uniB046,  HANGUL SYLLABLE-B046
        0xB047, # G+10155  U+B047  uniB047,  HANGUL SYLLABLE-B047
        0xB049, # G+10156  U+B049  uniB049,  HANGUL SYLLABLE-B049
        0xB04B, # G+10157  U+B04B  uniB04B,  HANGUL SYLLABLE-B04B
        0xB04D, # G+10158  U+B04D  uniB04D,  HANGUL SYLLABLE-B04D
        0xB04F, # G+10159  U+B04F  uniB04F,  HANGUL SYLLABLE-B04F
        0xB050, # G+10160  U+B050  uniB050,  HANGUL SYLLABLE-B050
        0xB051, # G+10161  U+B051  uniB051,  HANGUL SYLLABLE-B051
        0xB052, # G+10162  U+B052  uniB052,  HANGUL SYLLABLE-B052
        0xB056, # G+10163  U+B056  uniB056,  HANGUL SYLLABLE-B056
        0xB058, # G+10164  U+B058  uniB058,  HANGUL SYLLABLE-B058
        0xB05A, # G+10165  U+B05A  uniB05A,  HANGUL SYLLABLE-B05A
        0xB05B, # G+10166  U+B05B  uniB05B,  HANGUL SYLLABLE-B05B
        0xB05C, # G+10167  U+B05C  uniB05C,  HANGUL SYLLABLE-B05C
        0xB05E, # G+10168  U+B05E  uniB05E,  HANGUL SYLLABLE-B05E
        0xB05F, # G+10169  U+B05F  uniB05F,  HANGUL SYLLABLE-B05F
        0xB060, # G+10170  U+B060  uniB060,  HANGUL SYLLABLE-B060
        0xB061, # G+10171  U+B061  uniB061,  HANGUL SYLLABLE-B061
        0xB062, # G+10172  U+B062  uniB062,  HANGUL SYLLABLE-B062
        0xB063, # G+10173  U+B063  uniB063,  HANGUL SYLLABLE-B063
        0xB064, # G+10174  U+B064  uniB064,  HANGUL SYLLABLE-B064
        0xB065, # G+10175  U+B065  uniB065,  HANGUL SYLLABLE-B065
        0xB066, # G+10176  U+B066  uniB066,  HANGUL SYLLABLE-B066
        0xB067, # G+10177  U+B067  uniB067,  HANGUL SYLLABLE-B067
        0xB068, # G+10178  U+B068  uniB068,  HANGUL SYLLABLE-B068
        0xB069, # G+10179  U+B069  uniB069,  HANGUL SYLLABLE-B069
        0xB06A, # G+10180  U+B06A  uniB06A,  HANGUL SYLLABLE-B06A
        0xB06B, # G+10181  U+B06B  uniB06B,  HANGUL SYLLABLE-B06B
        0xB06C, # G+10182  U+B06C  uniB06C,  HANGUL SYLLABLE-B06C
        0xB06D, # G+10183  U+B06D  uniB06D,  HANGUL SYLLABLE-B06D
        0xB06E, # G+10184  U+B06E  uniB06E,  HANGUL SYLLABLE-B06E
        0xB06F, # G+10185  U+B06F  uniB06F,  HANGUL SYLLABLE-B06F
        0xB070, # G+10186  U+B070  uniB070,  HANGUL SYLLABLE-B070
        0xB071, # G+10187  U+B071  uniB071,  HANGUL SYLLABLE-B071
        0xB072, # G+10188  U+B072  uniB072,  HANGUL SYLLABLE-B072
        0xB073, # G+10189  U+B073  uniB073,  HANGUL SYLLABLE-B073
        0xB074, # G+10190  U+B074  uniB074,  HANGUL SYLLABLE-B074
        0xB075, # G+10191  U+B075  uniB075,  HANGUL SYLLABLE-B075
        0xB076, # G+10192  U+B076  uniB076,  HANGUL SYLLABLE-B076
        0xB077, # G+10193  U+B077  uniB077,  HANGUL SYLLABLE-B077
        0xB078, # G+10194  U+B078  uniB078,  HANGUL SYLLABLE-B078
        0xB079, # G+10195  U+B079  uniB079,  HANGUL SYLLABLE-B079
        0xB07A, # G+10196  U+B07A  uniB07A,  HANGUL SYLLABLE-B07A
        0xB07B, # G+10197  U+B07B  uniB07B,  HANGUL SYLLABLE-B07B
        0xB07E, # G+10198  U+B07E  uniB07E,  HANGUL SYLLABLE-B07E
        0xB07F, # G+10199  U+B07F  uniB07F,  HANGUL SYLLABLE-B07F
        0xB081, # G+10200  U+B081  uniB081,  HANGUL SYLLABLE-B081
        0xB082, # G+10201  U+B082  uniB082,  HANGUL SYLLABLE-B082
        0xB083, # G+10202  U+B083  uniB083,  HANGUL SYLLABLE-B083
        0xB085, # G+10203  U+B085  uniB085,  HANGUL SYLLABLE-B085
        0xB086, # G+10204  U+B086  uniB086,  HANGUL SYLLABLE-B086
        0xB087, # G+10205  U+B087  uniB087,  HANGUL SYLLABLE-B087
        0xB088, # G+10206  U+B088  uniB088,  HANGUL SYLLABLE-B088
        0xB089, # G+10207  U+B089  uniB089,  HANGUL SYLLABLE-B089
        0xB08A, # G+10208  U+B08A  uniB08A,  HANGUL SYLLABLE-B08A
        0xB08B, # G+10209  U+B08B  uniB08B,  HANGUL SYLLABLE-B08B
        0xB08E, # G+10210  U+B08E  uniB08E,  HANGUL SYLLABLE-B08E
        0xB090, # G+10211  U+B090  uniB090,  HANGUL SYLLABLE-B090
        0xB092, # G+10212  U+B092  uniB092,  HANGUL SYLLABLE-B092
        0xB093, # G+10213  U+B093  uniB093,  HANGUL SYLLABLE-B093
        0xB094, # G+10214  U+B094  uniB094,  HANGUL SYLLABLE-B094
        0xB095, # G+10215  U+B095  uniB095,  HANGUL SYLLABLE-B095
        0xB096, # G+10216  U+B096  uniB096,  HANGUL SYLLABLE-B096
        0xB097, # G+10217  U+B097  uniB097,  HANGUL SYLLABLE-B097
        0xB09B, # G+10218  U+B09B  uniB09B,  HANGUL SYLLABLE-B09B
        0xB09D, # G+10219  U+B09D  uniB09D,  HANGUL SYLLABLE-B09D
        0xB09E, # G+10220  U+B09E  uniB09E,  HANGUL SYLLABLE-B09E
        0xB0A3, # G+10221  U+B0A3  uniB0A3,  HANGUL SYLLABLE-B0A3
        0xB0A4, # G+10222  U+B0A4  uniB0A4,  HANGUL SYLLABLE-B0A4
        0xB0A5, # G+10223  U+B0A5  uniB0A5,  HANGUL SYLLABLE-B0A5
        0xB0A6, # G+10224  U+B0A6  uniB0A6,  HANGUL SYLLABLE-B0A6
        0xB0A7, # G+10225  U+B0A7  uniB0A7,  HANGUL SYLLABLE-B0A7
        0xB0AA, # G+10226  U+B0AA  uniB0AA,  HANGUL SYLLABLE-B0AA
        0xB0B0, # G+10227  U+B0B0  uniB0B0,  HANGUL SYLLABLE-B0B0
        0xB0B2, # G+10228  U+B0B2  uniB0B2,  HANGUL SYLLABLE-B0B2
        0xB0B6, # G+10229  U+B0B6  uniB0B6,  HANGUL SYLLABLE-B0B6
        0xB0B7, # G+10230  U+B0B7  uniB0B7,  HANGUL SYLLABLE-B0B7
        0xB0B9, # G+10231  U+B0B9  uniB0B9,  HANGUL SYLLABLE-B0B9
        0xB0BA, # G+10232  U+B0BA  uniB0BA,  HANGUL SYLLABLE-B0BA
        0xB0BB, # G+10233  U+B0BB  uniB0BB,  HANGUL SYLLABLE-B0BB
        0xB0BD, # G+10234  U+B0BD  uniB0BD,  HANGUL SYLLABLE-B0BD
        0xB0BE, # G+10235  U+B0BE  uniB0BE,  HANGUL SYLLABLE-B0BE
        0xB0BF, # G+10236  U+B0BF  uniB0BF,  HANGUL SYLLABLE-B0BF
        0xB0C0, # G+10237  U+B0C0  uniB0C0,  HANGUL SYLLABLE-B0C0
        0xB0C1, # G+10238  U+B0C1  uniB0C1,  HANGUL SYLLABLE-B0C1
        0xB0C2, # G+10239  U+B0C2  uniB0C2,  HANGUL SYLLABLE-B0C2
        0xB0C3, # G+10240  U+B0C3  uniB0C3,  HANGUL SYLLABLE-B0C3
        0xB0C6, # G+10241  U+B0C6  uniB0C6,  HANGUL SYLLABLE-B0C6
        0xB0CA, # G+10242  U+B0CA  uniB0CA,  HANGUL SYLLABLE-B0CA
        0xB0CB, # G+10243  U+B0CB  uniB0CB,  HANGUL SYLLABLE-B0CB
        0xB0CC, # G+10244  U+B0CC  uniB0CC,  HANGUL SYLLABLE-B0CC
        0xB0CD, # G+10245  U+B0CD  uniB0CD,  HANGUL SYLLABLE-B0CD
        0xB0CE, # G+10246  U+B0CE  uniB0CE,  HANGUL SYLLABLE-B0CE
        0xB0CF, # G+10247  U+B0CF  uniB0CF,  HANGUL SYLLABLE-B0CF
        0xB0D2, # G+10248  U+B0D2  uniB0D2,  HANGUL SYLLABLE-B0D2
        0xB0D3, # G+10249  U+B0D3  uniB0D3,  HANGUL SYLLABLE-B0D3
        0xB0D5, # G+10250  U+B0D5  uniB0D5,  HANGUL SYLLABLE-B0D5
        0xB0D6, # G+10251  U+B0D6  uniB0D6,  HANGUL SYLLABLE-B0D6
        0xB0D7, # G+10252  U+B0D7  uniB0D7,  HANGUL SYLLABLE-B0D7
        0xB0D9, # G+10253  U+B0D9  uniB0D9,  HANGUL SYLLABLE-B0D9
        0xB0DA, # G+10254  U+B0DA  uniB0DA,  HANGUL SYLLABLE-B0DA
        0xB0DB, # G+10255  U+B0DB  uniB0DB,  HANGUL SYLLABLE-B0DB
        0xB0DC, # G+10256  U+B0DC  uniB0DC,  HANGUL SYLLABLE-B0DC
        0xB0DD, # G+10257  U+B0DD  uniB0DD,  HANGUL SYLLABLE-B0DD
        0xB0DE, # G+10258  U+B0DE  uniB0DE,  HANGUL SYLLABLE-B0DE
        0xB0DF, # G+10259  U+B0DF  uniB0DF,  HANGUL SYLLABLE-B0DF
        0xB0E1, # G+10260  U+B0E1  uniB0E1,  HANGUL SYLLABLE-B0E1
        0xB0E2, # G+10261  U+B0E2  uniB0E2,  HANGUL SYLLABLE-B0E2
        0xB0E3, # G+10262  U+B0E3  uniB0E3,  HANGUL SYLLABLE-B0E3
        0xB0E4, # G+10263  U+B0E4  uniB0E4,  HANGUL SYLLABLE-B0E4
        0xB0E6, # G+10264  U+B0E6  uniB0E6,  HANGUL SYLLABLE-B0E6
        0xB0E7, # G+10265  U+B0E7  uniB0E7,  HANGUL SYLLABLE-B0E7
        0xB0E8, # G+10266  U+B0E8  uniB0E8,  HANGUL SYLLABLE-B0E8
        0xB0E9, # G+10267  U+B0E9  uniB0E9,  HANGUL SYLLABLE-B0E9
        0xB0EA, # G+10268  U+B0EA  uniB0EA,  HANGUL SYLLABLE-B0EA
        0xB0EB, # G+10269  U+B0EB  uniB0EB,  HANGUL SYLLABLE-B0EB
        0xB0EC, # G+10270  U+B0EC  uniB0EC,  HANGUL SYLLABLE-B0EC
        0xB0ED, # G+10271  U+B0ED  uniB0ED,  HANGUL SYLLABLE-B0ED
        0xB0EE, # G+10272  U+B0EE  uniB0EE,  HANGUL SYLLABLE-B0EE
        0xB0EF, # G+10273  U+B0EF  uniB0EF,  HANGUL SYLLABLE-B0EF
        0xB0F0, # G+10274  U+B0F0  uniB0F0,  HANGUL SYLLABLE-B0F0
        0xB0F1, # G+10275  U+B0F1  uniB0F1,  HANGUL SYLLABLE-B0F1
        0xB0F2, # G+10276  U+B0F2  uniB0F2,  HANGUL SYLLABLE-B0F2
        0xB0F3, # G+10277  U+B0F3  uniB0F3,  HANGUL SYLLABLE-B0F3
        0xB0F4, # G+10278  U+B0F4  uniB0F4,  HANGUL SYLLABLE-B0F4
        0xB0F5, # G+10279  U+B0F5  uniB0F5,  HANGUL SYLLABLE-B0F5
        0xB0F6, # G+10280  U+B0F6  uniB0F6,  HANGUL SYLLABLE-B0F6
        0xB0F7, # G+10281  U+B0F7  uniB0F7,  HANGUL SYLLABLE-B0F7
        0xB0F8, # G+10282  U+B0F8  uniB0F8,  HANGUL SYLLABLE-B0F8
        0xB0F9, # G+10283  U+B0F9  uniB0F9,  HANGUL SYLLABLE-B0F9
        0xB0FA, # G+10284  U+B0FA  uniB0FA,  HANGUL SYLLABLE-B0FA
        0xB0FB, # G+10285  U+B0FB  uniB0FB,  HANGUL SYLLABLE-B0FB
        0xB0FC, # G+10286  U+B0FC  uniB0FC,  HANGUL SYLLABLE-B0FC
        0xB0FD, # G+10287  U+B0FD  uniB0FD,  HANGUL SYLLABLE-B0FD
        0xB0FE, # G+10288  U+B0FE  uniB0FE,  HANGUL SYLLABLE-B0FE
        0xB0FF, # G+10289  U+B0FF  uniB0FF,  HANGUL SYLLABLE-B0FF
        0xB100, # G+10290  U+B100  uniB100,  HANGUL SYLLABLE-B100
        0xB101, # G+10291  U+B101  uniB101,  HANGUL SYLLABLE-B101
        0xB102, # G+10292  U+B102  uniB102,  HANGUL SYLLABLE-B102
        0xB103, # G+10293  U+B103  uniB103,  HANGUL SYLLABLE-B103
        0xB104, # G+10294  U+B104  uniB104,  HANGUL SYLLABLE-B104
        0xB105, # G+10295  U+B105  uniB105,  HANGUL SYLLABLE-B105
        0xB106, # G+10296  U+B106  uniB106,  HANGUL SYLLABLE-B106
        0xB107, # G+10297  U+B107  uniB107,  HANGUL SYLLABLE-B107
        0xB10A, # G+10298  U+B10A  uniB10A,  HANGUL SYLLABLE-B10A
        0xB10D, # G+10299  U+B10D  uniB10D,  HANGUL SYLLABLE-B10D
        0xB10E, # G+10300  U+B10E  uniB10E,  HANGUL SYLLABLE-B10E
        0xB10F, # G+10301  U+B10F  uniB10F,  HANGUL SYLLABLE-B10F
        0xB111, # G+10302  U+B111  uniB111,  HANGUL SYLLABLE-B111
        0xB114, # G+10303  U+B114  uniB114,  HANGUL SYLLABLE-B114
        0xB115, # G+10304  U+B115  uniB115,  HANGUL SYLLABLE-B115
        0xB116, # G+10305  U+B116  uniB116,  HANGUL SYLLABLE-B116
        0xB117, # G+10306  U+B117  uniB117,  HANGUL SYLLABLE-B117
        0xB11A, # G+10307  U+B11A  uniB11A,  HANGUL SYLLABLE-B11A
        0xB11E, # G+10308  U+B11E  uniB11E,  HANGUL SYLLABLE-B11E
        0xB11F, # G+10309  U+B11F  uniB11F,  HANGUL SYLLABLE-B11F
        0xB120, # G+10310  U+B120  uniB120,  HANGUL SYLLABLE-B120
        0xB121, # G+10311  U+B121  uniB121,  HANGUL SYLLABLE-B121
        0xB122, # G+10312  U+B122  uniB122,  HANGUL SYLLABLE-B122
        0xB126, # G+10313  U+B126  uniB126,  HANGUL SYLLABLE-B126
        0xB127, # G+10314  U+B127  uniB127,  HANGUL SYLLABLE-B127
        0xB129, # G+10315  U+B129  uniB129,  HANGUL SYLLABLE-B129
        0xB12A, # G+10316  U+B12A  uniB12A,  HANGUL SYLLABLE-B12A
        0xB12B, # G+10317  U+B12B  uniB12B,  HANGUL SYLLABLE-B12B
        0xB12D, # G+10318  U+B12D  uniB12D,  HANGUL SYLLABLE-B12D
        0xB12E, # G+10319  U+B12E  uniB12E,  HANGUL SYLLABLE-B12E
        0xB12F, # G+10320  U+B12F  uniB12F,  HANGUL SYLLABLE-B12F
        0xB130, # G+10321  U+B130  uniB130,  HANGUL SYLLABLE-B130
        0xB131, # G+10322  U+B131  uniB131,  HANGUL SYLLABLE-B131
        0xB132, # G+10323  U+B132  uniB132,  HANGUL SYLLABLE-B132
        0xB133, # G+10324  U+B133  uniB133,  HANGUL SYLLABLE-B133
        0xB136, # G+10325  U+B136  uniB136,  HANGUL SYLLABLE-B136
        0xB13A, # G+10326  U+B13A  uniB13A,  HANGUL SYLLABLE-B13A
        0xB13B, # G+10327  U+B13B  uniB13B,  HANGUL SYLLABLE-B13B
        0xB13C, # G+10328  U+B13C  uniB13C,  HANGUL SYLLABLE-B13C
        0xB13D, # G+10329  U+B13D  uniB13D,  HANGUL SYLLABLE-B13D
        0xB13E, # G+10330  U+B13E  uniB13E,  HANGUL SYLLABLE-B13E
        0xB13F, # G+10331  U+B13F  uniB13F,  HANGUL SYLLABLE-B13F
        0xB142, # G+10332  U+B142  uniB142,  HANGUL SYLLABLE-B142
        0xB143, # G+10333  U+B143  uniB143,  HANGUL SYLLABLE-B143
        0xB145, # G+10334  U+B145  uniB145,  HANGUL SYLLABLE-B145
        0xB146, # G+10335  U+B146  uniB146,  HANGUL SYLLABLE-B146
        0xB147, # G+10336  U+B147  uniB147,  HANGUL SYLLABLE-B147
        0xB149, # G+10337  U+B149  uniB149,  HANGUL SYLLABLE-B149
        0xB14A, # G+10338  U+B14A  uniB14A,  HANGUL SYLLABLE-B14A
        0xB14B, # G+10339  U+B14B  uniB14B,  HANGUL SYLLABLE-B14B
        0xB14C, # G+10340  U+B14C  uniB14C,  HANGUL SYLLABLE-B14C
        0xB14D, # G+10341  U+B14D  uniB14D,  HANGUL SYLLABLE-B14D
        0xB14E, # G+10342  U+B14E  uniB14E,  HANGUL SYLLABLE-B14E
        0xB14F, # G+10343  U+B14F  uniB14F,  HANGUL SYLLABLE-B14F
        0xB152, # G+10344  U+B152  uniB152,  HANGUL SYLLABLE-B152
        0xB153, # G+10345  U+B153  uniB153,  HANGUL SYLLABLE-B153
        0xB156, # G+10346  U+B156  uniB156,  HANGUL SYLLABLE-B156
        0xB157, # G+10347  U+B157  uniB157,  HANGUL SYLLABLE-B157
        0xB159, # G+10348  U+B159  uniB159,  HANGUL SYLLABLE-B159
        0xB15A, # G+10349  U+B15A  uniB15A,  HANGUL SYLLABLE-B15A
        0xB15B, # G+10350  U+B15B  uniB15B,  HANGUL SYLLABLE-B15B
        0xB15D, # G+10351  U+B15D  uniB15D,  HANGUL SYLLABLE-B15D
        0xB15E, # G+10352  U+B15E  uniB15E,  HANGUL SYLLABLE-B15E
        0xB15F, # G+10353  U+B15F  uniB15F,  HANGUL SYLLABLE-B15F
        0xB161, # G+10354  U+B161  uniB161,  HANGUL SYLLABLE-B161
        0xB162, # G+10355  U+B162  uniB162,  HANGUL SYLLABLE-B162
        0xB163, # G+10356  U+B163  uniB163,  HANGUL SYLLABLE-B163
        0xB164, # G+10357  U+B164  uniB164,  HANGUL SYLLABLE-B164
        0xB165, # G+10358  U+B165  uniB165,  HANGUL SYLLABLE-B165
        0xB166, # G+10359  U+B166  uniB166,  HANGUL SYLLABLE-B166
        0xB167, # G+10360  U+B167  uniB167,  HANGUL SYLLABLE-B167
        0xB168, # G+10361  U+B168  uniB168,  HANGUL SYLLABLE-B168
        0xB169, # G+10362  U+B169  uniB169,  HANGUL SYLLABLE-B169
        0xB16A, # G+10363  U+B16A  uniB16A,  HANGUL SYLLABLE-B16A
        0xB16B, # G+10364  U+B16B  uniB16B,  HANGUL SYLLABLE-B16B
        0xB16C, # G+10365  U+B16C  uniB16C,  HANGUL SYLLABLE-B16C
        0xB16D, # G+10366  U+B16D  uniB16D,  HANGUL SYLLABLE-B16D
        0xB16E, # G+10367  U+B16E  uniB16E,  HANGUL SYLLABLE-B16E
        0xB16F, # G+10368  U+B16F  uniB16F,  HANGUL SYLLABLE-B16F
        0xB170, # G+10369  U+B170  uniB170,  HANGUL SYLLABLE-B170
        0xB171, # G+10370  U+B171  uniB171,  HANGUL SYLLABLE-B171
        0xB172, # G+10371  U+B172  uniB172,  HANGUL SYLLABLE-B172
        0xB173, # G+10372  U+B173  uniB173,  HANGUL SYLLABLE-B173
        0xB174, # G+10373  U+B174  uniB174,  HANGUL SYLLABLE-B174
        0xB175, # G+10374  U+B175  uniB175,  HANGUL SYLLABLE-B175
        0xB176, # G+10375  U+B176  uniB176,  HANGUL SYLLABLE-B176
        0xB177, # G+10376  U+B177  uniB177,  HANGUL SYLLABLE-B177
        0xB17A, # G+10377  U+B17A  uniB17A,  HANGUL SYLLABLE-B17A
        0xB17B, # G+10378  U+B17B  uniB17B,  HANGUL SYLLABLE-B17B
        0xB17D, # G+10379  U+B17D  uniB17D,  HANGUL SYLLABLE-B17D
        0xB17E, # G+10380  U+B17E  uniB17E,  HANGUL SYLLABLE-B17E
        0xB17F, # G+10381  U+B17F  uniB17F,  HANGUL SYLLABLE-B17F
        0xB181, # G+10382  U+B181  uniB181,  HANGUL SYLLABLE-B181
        0xB183, # G+10383  U+B183  uniB183,  HANGUL SYLLABLE-B183
        0xB184, # G+10384  U+B184  uniB184,  HANGUL SYLLABLE-B184
        0xB185, # G+10385  U+B185  uniB185,  HANGUL SYLLABLE-B185
        0xB186, # G+10386  U+B186  uniB186,  HANGUL SYLLABLE-B186
        0xB187, # G+10387  U+B187  uniB187,  HANGUL SYLLABLE-B187
        0xB18A, # G+10388  U+B18A  uniB18A,  HANGUL SYLLABLE-B18A
        0xB18C, # G+10389  U+B18C  uniB18C,  HANGUL SYLLABLE-B18C
        0xB18E, # G+10390  U+B18E  uniB18E,  HANGUL SYLLABLE-B18E
        0xB18F, # G+10391  U+B18F  uniB18F,  HANGUL SYLLABLE-B18F
        0xB190, # G+10392  U+B190  uniB190,  HANGUL SYLLABLE-B190
        0xB191, # G+10393  U+B191  uniB191,  HANGUL SYLLABLE-B191
        0xB195, # G+10394  U+B195  uniB195,  HANGUL SYLLABLE-B195
        0xB196, # G+10395  U+B196  uniB196,  HANGUL SYLLABLE-B196
        0xB197, # G+10396  U+B197  uniB197,  HANGUL SYLLABLE-B197
        0xB199, # G+10397  U+B199  uniB199,  HANGUL SYLLABLE-B199
        0xB19A, # G+10398  U+B19A  uniB19A,  HANGUL SYLLABLE-B19A
        0xB19B, # G+10399  U+B19B  uniB19B,  HANGUL SYLLABLE-B19B
        0xB19D, # G+10400  U+B19D  uniB19D,  HANGUL SYLLABLE-B19D
        0xB19E, # G+10401  U+B19E  uniB19E,  HANGUL SYLLABLE-B19E
        0xB19F, # G+10402  U+B19F  uniB19F,  HANGUL SYLLABLE-B19F
        0xB1A0, # G+10403  U+B1A0  uniB1A0,  HANGUL SYLLABLE-B1A0
        0xB1A1, # G+10404  U+B1A1  uniB1A1,  HANGUL SYLLABLE-B1A1
        0xB1A2, # G+10405  U+B1A2  uniB1A2,  HANGUL SYLLABLE-B1A2
        0xB1A3, # G+10406  U+B1A3  uniB1A3,  HANGUL SYLLABLE-B1A3
        0xB1A4, # G+10407  U+B1A4  uniB1A4,  HANGUL SYLLABLE-B1A4
        0xB1A5, # G+10408  U+B1A5  uniB1A5,  HANGUL SYLLABLE-B1A5
        0xB1A6, # G+10409  U+B1A6  uniB1A6,  HANGUL SYLLABLE-B1A6
        0xB1A7, # G+10410  U+B1A7  uniB1A7,  HANGUL SYLLABLE-B1A7
        0xB1A9, # G+10411  U+B1A9  uniB1A9,  HANGUL SYLLABLE-B1A9
        0xB1AA, # G+10412  U+B1AA  uniB1AA,  HANGUL SYLLABLE-B1AA
        0xB1AB, # G+10413  U+B1AB  uniB1AB,  HANGUL SYLLABLE-B1AB
        0xB1AC, # G+10414  U+B1AC  uniB1AC,  HANGUL SYLLABLE-B1AC
        0xB1AD, # G+10415  U+B1AD  uniB1AD,  HANGUL SYLLABLE-B1AD
        0xB1AE, # G+10416  U+B1AE  uniB1AE,  HANGUL SYLLABLE-B1AE
        0xB1AF, # G+10417  U+B1AF  uniB1AF,  HANGUL SYLLABLE-B1AF
        0xB1B0, # G+10418  U+B1B0  uniB1B0,  HANGUL SYLLABLE-B1B0
        0xB1B1, # G+10419  U+B1B1  uniB1B1,  HANGUL SYLLABLE-B1B1
        0xB1B2, # G+10420  U+B1B2  uniB1B2,  HANGUL SYLLABLE-B1B2
        0xB1B3, # G+10421  U+B1B3  uniB1B3,  HANGUL SYLLABLE-B1B3
        0xB1B4, # G+10422  U+B1B4  uniB1B4,  HANGUL SYLLABLE-B1B4
        0xB1B5, # G+10423  U+B1B5  uniB1B5,  HANGUL SYLLABLE-B1B5
        0xB1B6, # G+10424  U+B1B6  uniB1B6,  HANGUL SYLLABLE-B1B6
        0xB1B7, # G+10425  U+B1B7  uniB1B7,  HANGUL SYLLABLE-B1B7
        0xB1B8, # G+10426  U+B1B8  uniB1B8,  HANGUL SYLLABLE-B1B8
        0xB1B9, # G+10427  U+B1B9  uniB1B9,  HANGUL SYLLABLE-B1B9
        0xB1BA, # G+10428  U+B1BA  uniB1BA,  HANGUL SYLLABLE-B1BA
        0xB1BB, # G+10429  U+B1BB  uniB1BB,  HANGUL SYLLABLE-B1BB
        0xB1BC, # G+10430  U+B1BC  uniB1BC,  HANGUL SYLLABLE-B1BC
        0xB1BD, # G+10431  U+B1BD  uniB1BD,  HANGUL SYLLABLE-B1BD
        0xB1BE, # G+10432  U+B1BE  uniB1BE,  HANGUL SYLLABLE-B1BE
        0xB1BF, # G+10433  U+B1BF  uniB1BF,  HANGUL SYLLABLE-B1BF
        0xB1C0, # G+10434  U+B1C0  uniB1C0,  HANGUL SYLLABLE-B1C0
        0xB1C1, # G+10435  U+B1C1  uniB1C1,  HANGUL SYLLABLE-B1C1
        0xB1C2, # G+10436  U+B1C2  uniB1C2,  HANGUL SYLLABLE-B1C2
        0xB1C3, # G+10437  U+B1C3  uniB1C3,  HANGUL SYLLABLE-B1C3
        0xB1C4, # G+10438  U+B1C4  uniB1C4,  HANGUL SYLLABLE-B1C4
        0xB1C5, # G+10439  U+B1C5  uniB1C5,  HANGUL SYLLABLE-B1C5
        0xB1C6, # G+10440  U+B1C6  uniB1C6,  HANGUL SYLLABLE-B1C6
        0xB1C7, # G+10441  U+B1C7  uniB1C7,  HANGUL SYLLABLE-B1C7
        0xB1C8, # G+10442  U+B1C8  uniB1C8,  HANGUL SYLLABLE-B1C8
        0xB1C9, # G+10443  U+B1C9  uniB1C9,  HANGUL SYLLABLE-B1C9
        0xB1CA, # G+10444  U+B1CA  uniB1CA,  HANGUL SYLLABLE-B1CA
        0xB1CB, # G+10445  U+B1CB  uniB1CB,  HANGUL SYLLABLE-B1CB
        0xB1CD, # G+10446  U+B1CD  uniB1CD,  HANGUL SYLLABLE-B1CD
        0xB1CE, # G+10447  U+B1CE  uniB1CE,  HANGUL SYLLABLE-B1CE
        0xB1CF, # G+10448  U+B1CF  uniB1CF,  HANGUL SYLLABLE-B1CF
        0xB1D1, # G+10449  U+B1D1  uniB1D1,  HANGUL SYLLABLE-B1D1
        0xB1D2, # G+10450  U+B1D2  uniB1D2,  HANGUL SYLLABLE-B1D2
        0xB1D3, # G+10451  U+B1D3  uniB1D3,  HANGUL SYLLABLE-B1D3
        0xB1D5, # G+10452  U+B1D5  uniB1D5,  HANGUL SYLLABLE-B1D5
        0xB1D6, # G+10453  U+B1D6  uniB1D6,  HANGUL SYLLABLE-B1D6
        0xB1D7, # G+10454  U+B1D7  uniB1D7,  HANGUL SYLLABLE-B1D7
        0xB1D8, # G+10455  U+B1D8  uniB1D8,  HANGUL SYLLABLE-B1D8
        0xB1D9, # G+10456  U+B1D9  uniB1D9,  HANGUL SYLLABLE-B1D9
        0xB1DA, # G+10457  U+B1DA  uniB1DA,  HANGUL SYLLABLE-B1DA
        0xB1DB, # G+10458  U+B1DB  uniB1DB,  HANGUL SYLLABLE-B1DB
        0xB1DE, # G+10459  U+B1DE  uniB1DE,  HANGUL SYLLABLE-B1DE
        0xB1E0, # G+10460  U+B1E0  uniB1E0,  HANGUL SYLLABLE-B1E0
        0xB1E1, # G+10461  U+B1E1  uniB1E1,  HANGUL SYLLABLE-B1E1
        0xB1E2, # G+10462  U+B1E2  uniB1E2,  HANGUL SYLLABLE-B1E2
        0xB1E3, # G+10463  U+B1E3  uniB1E3,  HANGUL SYLLABLE-B1E3
        0xB1E4, # G+10464  U+B1E4  uniB1E4,  HANGUL SYLLABLE-B1E4
        0xB1E5, # G+10465  U+B1E5  uniB1E5,  HANGUL SYLLABLE-B1E5
        0xB1E6, # G+10466  U+B1E6  uniB1E6,  HANGUL SYLLABLE-B1E6
        0xB1E7, # G+10467  U+B1E7  uniB1E7,  HANGUL SYLLABLE-B1E7
        0xB1EA, # G+10468  U+B1EA  uniB1EA,  HANGUL SYLLABLE-B1EA
        0xB1EB, # G+10469  U+B1EB  uniB1EB,  HANGUL SYLLABLE-B1EB
        0xB1ED, # G+10470  U+B1ED  uniB1ED,  HANGUL SYLLABLE-B1ED
        0xB1EE, # G+10471  U+B1EE  uniB1EE,  HANGUL SYLLABLE-B1EE
        0xB1EF, # G+10472  U+B1EF  uniB1EF,  HANGUL SYLLABLE-B1EF
        0xB1F1, # G+10473  U+B1F1  uniB1F1,  HANGUL SYLLABLE-B1F1
        0xB1F2, # G+10474  U+B1F2  uniB1F2,  HANGUL SYLLABLE-B1F2
        0xB1F3, # G+10475  U+B1F3  uniB1F3,  HANGUL SYLLABLE-B1F3
        0xB1F4, # G+10476  U+B1F4  uniB1F4,  HANGUL SYLLABLE-B1F4
        0xB1F5, # G+10477  U+B1F5  uniB1F5,  HANGUL SYLLABLE-B1F5
        0xB1F6, # G+10478  U+B1F6  uniB1F6,  HANGUL SYLLABLE-B1F6
        0xB1F7, # G+10479  U+B1F7  uniB1F7,  HANGUL SYLLABLE-B1F7
        0xB1F8, # G+10480  U+B1F8  uniB1F8,  HANGUL SYLLABLE-B1F8
        0xB1FA, # G+10481  U+B1FA  uniB1FA,  HANGUL SYLLABLE-B1FA
        0xB1FC, # G+10482  U+B1FC  uniB1FC,  HANGUL SYLLABLE-B1FC
        0xB1FE, # G+10483  U+B1FE  uniB1FE,  HANGUL SYLLABLE-B1FE
        0xB1FF, # G+10484  U+B1FF  uniB1FF,  HANGUL SYLLABLE-B1FF
        0xB200, # G+10485  U+B200  uniB200,  HANGUL SYLLABLE-B200
        0xB201, # G+10486  U+B201  uniB201,  HANGUL SYLLABLE-B201
        0xB202, # G+10487  U+B202  uniB202,  HANGUL SYLLABLE-B202
        0xB203, # G+10488  U+B203  uniB203,  HANGUL SYLLABLE-B203
        0xB206, # G+10489  U+B206  uniB206,  HANGUL SYLLABLE-B206
        0xB207, # G+10490  U+B207  uniB207,  HANGUL SYLLABLE-B207
        0xB209, # G+10491  U+B209  uniB209,  HANGUL SYLLABLE-B209
        0xB20A, # G+10492  U+B20A  uniB20A,  HANGUL SYLLABLE-B20A
        0xB20D, # G+10493  U+B20D  uniB20D,  HANGUL SYLLABLE-B20D
        0xB20E, # G+10494  U+B20E  uniB20E,  HANGUL SYLLABLE-B20E
        0xB20F, # G+10495  U+B20F  uniB20F,  HANGUL SYLLABLE-B20F
        0xB210, # G+10496  U+B210  uniB210,  HANGUL SYLLABLE-B210
        0xB211, # G+10497  U+B211  uniB211,  HANGUL SYLLABLE-B211
        0xB212, # G+10498  U+B212  uniB212,  HANGUL SYLLABLE-B212
        0xB213, # G+10499  U+B213  uniB213,  HANGUL SYLLABLE-B213
        0xB216, # G+10500  U+B216  uniB216,  HANGUL SYLLABLE-B216
        0xB218, # G+10501  U+B218  uniB218,  HANGUL SYLLABLE-B218
        0xB21A, # G+10502  U+B21A  uniB21A,  HANGUL SYLLABLE-B21A
        0xB21B, # G+10503  U+B21B  uniB21B,  HANGUL SYLLABLE-B21B
        0xB21C, # G+10504  U+B21C  uniB21C,  HANGUL SYLLABLE-B21C
        0xB21D, # G+10505  U+B21D  uniB21D,  HANGUL SYLLABLE-B21D
        0xB21E, # G+10506  U+B21E  uniB21E,  HANGUL SYLLABLE-B21E
        0xB21F, # G+10507  U+B21F  uniB21F,  HANGUL SYLLABLE-B21F
        0xB221, # G+10508  U+B221  uniB221,  HANGUL SYLLABLE-B221
        0xB222, # G+10509  U+B222  uniB222,  HANGUL SYLLABLE-B222
        0xB223, # G+10510  U+B223  uniB223,  HANGUL SYLLABLE-B223
        0xB224, # G+10511  U+B224  uniB224,  HANGUL SYLLABLE-B224
        0xB225, # G+10512  U+B225  uniB225,  HANGUL SYLLABLE-B225
        0xB226, # G+10513  U+B226  uniB226,  HANGUL SYLLABLE-B226
        0xB227, # G+10514  U+B227  uniB227,  HANGUL SYLLABLE-B227
        0xB228, # G+10515  U+B228  uniB228,  HANGUL SYLLABLE-B228
        0xB229, # G+10516  U+B229  uniB229,  HANGUL SYLLABLE-B229
        0xB22A, # G+10517  U+B22A  uniB22A,  HANGUL SYLLABLE-B22A
        0xB22B, # G+10518  U+B22B  uniB22B,  HANGUL SYLLABLE-B22B
        0xB22C, # G+10519  U+B22C  uniB22C,  HANGUL SYLLABLE-B22C
        0xB22D, # G+10520  U+B22D  uniB22D,  HANGUL SYLLABLE-B22D
        0xB22E, # G+10521  U+B22E  uniB22E,  HANGUL SYLLABLE-B22E
        0xB22F, # G+10522  U+B22F  uniB22F,  HANGUL SYLLABLE-B22F
        0xB230, # G+10523  U+B230  uniB230,  HANGUL SYLLABLE-B230
        0xB231, # G+10524  U+B231  uniB231,  HANGUL SYLLABLE-B231
        0xB232, # G+10525  U+B232  uniB232,  HANGUL SYLLABLE-B232
        0xB233, # G+10526  U+B233  uniB233,  HANGUL SYLLABLE-B233
        0xB235, # G+10527  U+B235  uniB235,  HANGUL SYLLABLE-B235
        0xB236, # G+10528  U+B236  uniB236,  HANGUL SYLLABLE-B236
        0xB237, # G+10529  U+B237  uniB237,  HANGUL SYLLABLE-B237
        0xB238, # G+10530  U+B238  uniB238,  HANGUL SYLLABLE-B238
        0xB239, # G+10531  U+B239  uniB239,  HANGUL SYLLABLE-B239
        0xB23A, # G+10532  U+B23A  uniB23A,  HANGUL SYLLABLE-B23A
        0xB23B, # G+10533  U+B23B  uniB23B,  HANGUL SYLLABLE-B23B
        0xB23D, # G+10534  U+B23D  uniB23D,  HANGUL SYLLABLE-B23D
        0xB23E, # G+10535  U+B23E  uniB23E,  HANGUL SYLLABLE-B23E
        0xB23F, # G+10536  U+B23F  uniB23F,  HANGUL SYLLABLE-B23F
        0xB240, # G+10537  U+B240  uniB240,  HANGUL SYLLABLE-B240
        0xB241, # G+10538  U+B241  uniB241,  HANGUL SYLLABLE-B241
        0xB242, # G+10539  U+B242  uniB242,  HANGUL SYLLABLE-B242
        0xB243, # G+10540  U+B243  uniB243,  HANGUL SYLLABLE-B243
        0xB244, # G+10541  U+B244  uniB244,  HANGUL SYLLABLE-B244
        0xB245, # G+10542  U+B245  uniB245,  HANGUL SYLLABLE-B245
        0xB246, # G+10543  U+B246  uniB246,  HANGUL SYLLABLE-B246
        0xB247, # G+10544  U+B247  uniB247,  HANGUL SYLLABLE-B247
        0xB248, # G+10545  U+B248  uniB248,  HANGUL SYLLABLE-B248
        0xB249, # G+10546  U+B249  uniB249,  HANGUL SYLLABLE-B249
        0xB24A, # G+10547  U+B24A  uniB24A,  HANGUL SYLLABLE-B24A
        0xB24B, # G+10548  U+B24B  uniB24B,  HANGUL SYLLABLE-B24B
        0xB24C, # G+10549  U+B24C  uniB24C,  HANGUL SYLLABLE-B24C
        0xB24D, # G+10550  U+B24D  uniB24D,  HANGUL SYLLABLE-B24D
        0xB24E, # G+10551  U+B24E  uniB24E,  HANGUL SYLLABLE-B24E
        0xB24F, # G+10552  U+B24F  uniB24F,  HANGUL SYLLABLE-B24F
        0xB250, # G+10553  U+B250  uniB250,  HANGUL SYLLABLE-B250
        0xB251, # G+10554  U+B251  uniB251,  HANGUL SYLLABLE-B251
        0xB252, # G+10555  U+B252  uniB252,  HANGUL SYLLABLE-B252
        0xB253, # G+10556  U+B253  uniB253,  HANGUL SYLLABLE-B253
        0xB254, # G+10557  U+B254  uniB254,  HANGUL SYLLABLE-B254
        0xB255, # G+10558  U+B255  uniB255,  HANGUL SYLLABLE-B255
        0xB256, # G+10559  U+B256  uniB256,  HANGUL SYLLABLE-B256
        0xB257, # G+10560  U+B257  uniB257,  HANGUL SYLLABLE-B257
        0xB259, # G+10561  U+B259  uniB259,  HANGUL SYLLABLE-B259
        0xB25A, # G+10562  U+B25A  uniB25A,  HANGUL SYLLABLE-B25A
        0xB25B, # G+10563  U+B25B  uniB25B,  HANGUL SYLLABLE-B25B
        0xB25D, # G+10564  U+B25D  uniB25D,  HANGUL SYLLABLE-B25D
        0xB25E, # G+10565  U+B25E  uniB25E,  HANGUL SYLLABLE-B25E
        0xB25F, # G+10566  U+B25F  uniB25F,  HANGUL SYLLABLE-B25F
        0xB261, # G+10567  U+B261  uniB261,  HANGUL SYLLABLE-B261
        0xB262, # G+10568  U+B262  uniB262,  HANGUL SYLLABLE-B262
        0xB263, # G+10569  U+B263  uniB263,  HANGUL SYLLABLE-B263
        0xB264, # G+10570  U+B264  uniB264,  HANGUL SYLLABLE-B264
        0xB265, # G+10571  U+B265  uniB265,  HANGUL SYLLABLE-B265
        0xB266, # G+10572  U+B266  uniB266,  HANGUL SYLLABLE-B266
        0xB267, # G+10573  U+B267  uniB267,  HANGUL SYLLABLE-B267
        0xB26A, # G+10574  U+B26A  uniB26A,  HANGUL SYLLABLE-B26A
        0xB26B, # G+10575  U+B26B  uniB26B,  HANGUL SYLLABLE-B26B
        0xB26C, # G+10576  U+B26C  uniB26C,  HANGUL SYLLABLE-B26C
        0xB26D, # G+10577  U+B26D  uniB26D,  HANGUL SYLLABLE-B26D
        0xB26E, # G+10578  U+B26E  uniB26E,  HANGUL SYLLABLE-B26E
        0xB26F, # G+10579  U+B26F  uniB26F,  HANGUL SYLLABLE-B26F
        0xB270, # G+10580  U+B270  uniB270,  HANGUL SYLLABLE-B270
        0xB271, # G+10581  U+B271  uniB271,  HANGUL SYLLABLE-B271
        0xB272, # G+10582  U+B272  uniB272,  HANGUL SYLLABLE-B272
        0xB273, # G+10583  U+B273  uniB273,  HANGUL SYLLABLE-B273
        0xB276, # G+10584  U+B276  uniB276,  HANGUL SYLLABLE-B276
        0xB277, # G+10585  U+B277  uniB277,  HANGUL SYLLABLE-B277
        0xB278, # G+10586  U+B278  uniB278,  HANGUL SYLLABLE-B278
        0xB279, # G+10587  U+B279  uniB279,  HANGUL SYLLABLE-B279
        0xB27A, # G+10588  U+B27A  uniB27A,  HANGUL SYLLABLE-B27A
        0xB27B, # G+10589  U+B27B  uniB27B,  HANGUL SYLLABLE-B27B
        0xB27D, # G+10590  U+B27D  uniB27D,  HANGUL SYLLABLE-B27D
        0xB27E, # G+10591  U+B27E  uniB27E,  HANGUL SYLLABLE-B27E
        0xB27F, # G+10592  U+B27F  uniB27F,  HANGUL SYLLABLE-B27F
        0xB280, # G+10593  U+B280  uniB280,  HANGUL SYLLABLE-B280
        0xB281, # G+10594  U+B281  uniB281,  HANGUL SYLLABLE-B281
        0xB282, # G+10595  U+B282  uniB282,  HANGUL SYLLABLE-B282
        0xB283, # G+10596  U+B283  uniB283,  HANGUL SYLLABLE-B283
        0xB286, # G+10597  U+B286  uniB286,  HANGUL SYLLABLE-B286
        0xB287, # G+10598  U+B287  uniB287,  HANGUL SYLLABLE-B287
        0xB288, # G+10599  U+B288  uniB288,  HANGUL SYLLABLE-B288
        0xB28A, # G+10600  U+B28A  uniB28A,  HANGUL SYLLABLE-B28A
        0xB28B, # G+10601  U+B28B  uniB28B,  HANGUL SYLLABLE-B28B
        0xB28C, # G+10602  U+B28C  uniB28C,  HANGUL SYLLABLE-B28C
        0xB28D, # G+10603  U+B28D  uniB28D,  HANGUL SYLLABLE-B28D
        0xB28E, # G+10604  U+B28E  uniB28E,  HANGUL SYLLABLE-B28E
        0xB28F, # G+10605  U+B28F  uniB28F,  HANGUL SYLLABLE-B28F
        0xB292, # G+10606  U+B292  uniB292,  HANGUL SYLLABLE-B292
        0xB293, # G+10607  U+B293  uniB293,  HANGUL SYLLABLE-B293
        0xB295, # G+10608  U+B295  uniB295,  HANGUL SYLLABLE-B295
        0xB296, # G+10609  U+B296  uniB296,  HANGUL SYLLABLE-B296
        0xB297, # G+10610  U+B297  uniB297,  HANGUL SYLLABLE-B297
        0xB29B, # G+10611  U+B29B  uniB29B,  HANGUL SYLLABLE-B29B
        0xB29C, # G+10612  U+B29C  uniB29C,  HANGUL SYLLABLE-B29C
        0xB29D, # G+10613  U+B29D  uniB29D,  HANGUL SYLLABLE-B29D
        0xB29E, # G+10614  U+B29E  uniB29E,  HANGUL SYLLABLE-B29E
        0xB29F, # G+10615  U+B29F  uniB29F,  HANGUL SYLLABLE-B29F
        0xB2A2, # G+10616  U+B2A2  uniB2A2,  HANGUL SYLLABLE-B2A2
        0xB2A4, # G+10617  U+B2A4  uniB2A4,  HANGUL SYLLABLE-B2A4
        0xB2A7, # G+10618  U+B2A7  uniB2A7,  HANGUL SYLLABLE-B2A7
        0xB2A8, # G+10619  U+B2A8  uniB2A8,  HANGUL SYLLABLE-B2A8
        0xB2A9, # G+10620  U+B2A9  uniB2A9,  HANGUL SYLLABLE-B2A9
        0xB2AB, # G+10621  U+B2AB  uniB2AB,  HANGUL SYLLABLE-B2AB
        0xB2AD, # G+10622  U+B2AD  uniB2AD,  HANGUL SYLLABLE-B2AD
        0xB2AE, # G+10623  U+B2AE  uniB2AE,  HANGUL SYLLABLE-B2AE
        0xB2AF, # G+10624  U+B2AF  uniB2AF,  HANGUL SYLLABLE-B2AF
        0xB2B1, # G+10625  U+B2B1  uniB2B1,  HANGUL SYLLABLE-B2B1
        0xB2B2, # G+10626  U+B2B2  uniB2B2,  HANGUL SYLLABLE-B2B2
        0xB2B3, # G+10627  U+B2B3  uniB2B3,  HANGUL SYLLABLE-B2B3
        0xB2B5, # G+10628  U+B2B5  uniB2B5,  HANGUL SYLLABLE-B2B5
        0xB2B6, # G+10629  U+B2B6  uniB2B6,  HANGUL SYLLABLE-B2B6
        0xB2B7, # G+10630  U+B2B7  uniB2B7,  HANGUL SYLLABLE-B2B7
        0xB2B8, # G+10631  U+B2B8  uniB2B8,  HANGUL SYLLABLE-B2B8
        0xB2B9, # G+10632  U+B2B9  uniB2B9,  HANGUL SYLLABLE-B2B9
        0xB2BA, # G+10633  U+B2BA  uniB2BA,  HANGUL SYLLABLE-B2BA
        0xB2BB, # G+10634  U+B2BB  uniB2BB,  HANGUL SYLLABLE-B2BB
        0xB2BC, # G+10635  U+B2BC  uniB2BC,  HANGUL SYLLABLE-B2BC
        0xB2BD, # G+10636  U+B2BD  uniB2BD,  HANGUL SYLLABLE-B2BD
        0xB2BE, # G+10637  U+B2BE  uniB2BE,  HANGUL SYLLABLE-B2BE
        0xB2BF, # G+10638  U+B2BF  uniB2BF,  HANGUL SYLLABLE-B2BF
        0xB2C0, # G+10639  U+B2C0  uniB2C0,  HANGUL SYLLABLE-B2C0
        0xB2C1, # G+10640  U+B2C1  uniB2C1,  HANGUL SYLLABLE-B2C1
        0xB2C2, # G+10641  U+B2C2  uniB2C2,  HANGUL SYLLABLE-B2C2
        0xB2C3, # G+10642  U+B2C3  uniB2C3,  HANGUL SYLLABLE-B2C3
        0xB2C4, # G+10643  U+B2C4  uniB2C4,  HANGUL SYLLABLE-B2C4
        0xB2C5, # G+10644  U+B2C5  uniB2C5,  HANGUL SYLLABLE-B2C5
        0xB2C6, # G+10645  U+B2C6  uniB2C6,  HANGUL SYLLABLE-B2C6
        0xB2C7, # G+10646  U+B2C7  uniB2C7,  HANGUL SYLLABLE-B2C7
        0xB2CA, # G+10647  U+B2CA  uniB2CA,  HANGUL SYLLABLE-B2CA
        0xB2CB, # G+10648  U+B2CB  uniB2CB,  HANGUL SYLLABLE-B2CB
        0xB2CD, # G+10649  U+B2CD  uniB2CD,  HANGUL SYLLABLE-B2CD
        0xB2CE, # G+10650  U+B2CE  uniB2CE,  HANGUL SYLLABLE-B2CE
        0xB2CF, # G+10651  U+B2CF  uniB2CF,  HANGUL SYLLABLE-B2CF
        0xB2D1, # G+10652  U+B2D1  uniB2D1,  HANGUL SYLLABLE-B2D1
        0xB2D3, # G+10653  U+B2D3  uniB2D3,  HANGUL SYLLABLE-B2D3
        0xB2D4, # G+10654  U+B2D4  uniB2D4,  HANGUL SYLLABLE-B2D4
        0xB2D5, # G+10655  U+B2D5  uniB2D5,  HANGUL SYLLABLE-B2D5
        0xB2D6, # G+10656  U+B2D6  uniB2D6,  HANGUL SYLLABLE-B2D6
        0xB2D7, # G+10657  U+B2D7  uniB2D7,  HANGUL SYLLABLE-B2D7
        0xB2DA, # G+10658  U+B2DA  uniB2DA,  HANGUL SYLLABLE-B2DA
        0xB2DC, # G+10659  U+B2DC  uniB2DC,  HANGUL SYLLABLE-B2DC
        0xB2DE, # G+10660  U+B2DE  uniB2DE,  HANGUL SYLLABLE-B2DE
        0xB2DF, # G+10661  U+B2DF  uniB2DF,  HANGUL SYLLABLE-B2DF
        0xB2E0, # G+10662  U+B2E0  uniB2E0,  HANGUL SYLLABLE-B2E0
        0xB2E1, # G+10663  U+B2E1  uniB2E1,  HANGUL SYLLABLE-B2E1
        0xB2E3, # G+10664  U+B2E3  uniB2E3,  HANGUL SYLLABLE-B2E3
        0xB2E7, # G+10665  U+B2E7  uniB2E7,  HANGUL SYLLABLE-B2E7
        0xB2E9, # G+10666  U+B2E9  uniB2E9,  HANGUL SYLLABLE-B2E9
        0xB2EA, # G+10667  U+B2EA  uniB2EA,  HANGUL SYLLABLE-B2EA
        0xB2F0, # G+10668  U+B2F0  uniB2F0,  HANGUL SYLLABLE-B2F0
        0xB2F1, # G+10669  U+B2F1  uniB2F1,  HANGUL SYLLABLE-B2F1
        0xB2F2, # G+10670  U+B2F2  uniB2F2,  HANGUL SYLLABLE-B2F2
        0xB2F6, # G+10671  U+B2F6  uniB2F6,  HANGUL SYLLABLE-B2F6
        0xB2FC, # G+10672  U+B2FC  uniB2FC,  HANGUL SYLLABLE-B2FC
        0xB2FD, # G+10673  U+B2FD  uniB2FD,  HANGUL SYLLABLE-B2FD
        0xB2FE, # G+10674  U+B2FE  uniB2FE,  HANGUL SYLLABLE-B2FE
        0xB302, # G+10675  U+B302  uniB302,  HANGUL SYLLABLE-B302
        0xB303, # G+10676  U+B303  uniB303,  HANGUL SYLLABLE-B303
        0xB305, # G+10677  U+B305  uniB305,  HANGUL SYLLABLE-B305
        0xB306, # G+10678  U+B306  uniB306,  HANGUL SYLLABLE-B306
        0xB307, # G+10679  U+B307  uniB307,  HANGUL SYLLABLE-B307
        0xB309, # G+10680  U+B309  uniB309,  HANGUL SYLLABLE-B309
        0xB30A, # G+10681  U+B30A  uniB30A,  HANGUL SYLLABLE-B30A
        0xB30B, # G+10682  U+B30B  uniB30B,  HANGUL SYLLABLE-B30B
        0xB30C, # G+10683  U+B30C  uniB30C,  HANGUL SYLLABLE-B30C
        0xB30D, # G+10684  U+B30D  uniB30D,  HANGUL SYLLABLE-B30D
        0xB30E, # G+10685  U+B30E  uniB30E,  HANGUL SYLLABLE-B30E
        0xB30F, # G+10686  U+B30F  uniB30F,  HANGUL SYLLABLE-B30F
        0xB312, # G+10687  U+B312  uniB312,  HANGUL SYLLABLE-B312
        0xB316, # G+10688  U+B316  uniB316,  HANGUL SYLLABLE-B316
        0xB317, # G+10689  U+B317  uniB317,  HANGUL SYLLABLE-B317
        0xB318, # G+10690  U+B318  uniB318,  HANGUL SYLLABLE-B318
        0xB319, # G+10691  U+B319  uniB319,  HANGUL SYLLABLE-B319
        0xB31A, # G+10692  U+B31A  uniB31A,  HANGUL SYLLABLE-B31A
        0xB31B, # G+10693  U+B31B  uniB31B,  HANGUL SYLLABLE-B31B
        0xB31D, # G+10694  U+B31D  uniB31D,  HANGUL SYLLABLE-B31D
        0xB31E, # G+10695  U+B31E  uniB31E,  HANGUL SYLLABLE-B31E
        0xB31F, # G+10696  U+B31F  uniB31F,  HANGUL SYLLABLE-B31F
        0xB320, # G+10697  U+B320  uniB320,  HANGUL SYLLABLE-B320
        0xB321, # G+10698  U+B321  uniB321,  HANGUL SYLLABLE-B321
        0xB322, # G+10699  U+B322  uniB322,  HANGUL SYLLABLE-B322
        0xB323, # G+10700  U+B323  uniB323,  HANGUL SYLLABLE-B323
        0xB324, # G+10701  U+B324  uniB324,  HANGUL SYLLABLE-B324
        0xB325, # G+10702  U+B325  uniB325,  HANGUL SYLLABLE-B325
        0xB326, # G+10703  U+B326  uniB326,  HANGUL SYLLABLE-B326
        0xB327, # G+10704  U+B327  uniB327,  HANGUL SYLLABLE-B327
        0xB328, # G+10705  U+B328  uniB328,  HANGUL SYLLABLE-B328
        0xB329, # G+10706  U+B329  uniB329,  HANGUL SYLLABLE-B329
        0xB32A, # G+10707  U+B32A  uniB32A,  HANGUL SYLLABLE-B32A
        0xB32B, # G+10708  U+B32B  uniB32B,  HANGUL SYLLABLE-B32B
        0xB32C, # G+10709  U+B32C  uniB32C,  HANGUL SYLLABLE-B32C
        0xB32D, # G+10710  U+B32D  uniB32D,  HANGUL SYLLABLE-B32D
        0xB32E, # G+10711  U+B32E  uniB32E,  HANGUL SYLLABLE-B32E
        0xB32F, # G+10712  U+B32F  uniB32F,  HANGUL SYLLABLE-B32F
        0xB330, # G+10713  U+B330  uniB330,  HANGUL SYLLABLE-B330
        0xB331, # G+10714  U+B331  uniB331,  HANGUL SYLLABLE-B331
        0xB332, # G+10715  U+B332  uniB332,  HANGUL SYLLABLE-B332
        0xB333, # G+10716  U+B333  uniB333,  HANGUL SYLLABLE-B333
        0xB334, # G+10717  U+B334  uniB334,  HANGUL SYLLABLE-B334
        0xB335, # G+10718  U+B335  uniB335,  HANGUL SYLLABLE-B335
        0xB336, # G+10719  U+B336  uniB336,  HANGUL SYLLABLE-B336
        0xB337, # G+10720  U+B337  uniB337,  HANGUL SYLLABLE-B337
        0xB338, # G+10721  U+B338  uniB338,  HANGUL SYLLABLE-B338
        0xB339, # G+10722  U+B339  uniB339,  HANGUL SYLLABLE-B339
        0xB33A, # G+10723  U+B33A  uniB33A,  HANGUL SYLLABLE-B33A
        0xB33B, # G+10724  U+B33B  uniB33B,  HANGUL SYLLABLE-B33B
        0xB33C, # G+10725  U+B33C  uniB33C,  HANGUL SYLLABLE-B33C
        0xB33D, # G+10726  U+B33D  uniB33D,  HANGUL SYLLABLE-B33D
        0xB33E, # G+10727  U+B33E  uniB33E,  HANGUL SYLLABLE-B33E
        0xB33F, # G+10728  U+B33F  uniB33F,  HANGUL SYLLABLE-B33F
        0xB340, # G+10729  U+B340  uniB340,  HANGUL SYLLABLE-B340
        0xB341, # G+10730  U+B341  uniB341,  HANGUL SYLLABLE-B341
        0xB342, # G+10731  U+B342  uniB342,  HANGUL SYLLABLE-B342
        0xB343, # G+10732  U+B343  uniB343,  HANGUL SYLLABLE-B343
        0xB344, # G+10733  U+B344  uniB344,  HANGUL SYLLABLE-B344
        0xB345, # G+10734  U+B345  uniB345,  HANGUL SYLLABLE-B345
        0xB346, # G+10735  U+B346  uniB346,  HANGUL SYLLABLE-B346
        0xB347, # G+10736  U+B347  uniB347,  HANGUL SYLLABLE-B347
        0xB348, # G+10737  U+B348  uniB348,  HANGUL SYLLABLE-B348
        0xB349, # G+10738  U+B349  uniB349,  HANGUL SYLLABLE-B349
        0xB34A, # G+10739  U+B34A  uniB34A,  HANGUL SYLLABLE-B34A
        0xB34B, # G+10740  U+B34B  uniB34B,  HANGUL SYLLABLE-B34B
        0xB34C, # G+10741  U+B34C  uniB34C,  HANGUL SYLLABLE-B34C
        0xB34D, # G+10742  U+B34D  uniB34D,  HANGUL SYLLABLE-B34D
        0xB34E, # G+10743  U+B34E  uniB34E,  HANGUL SYLLABLE-B34E
        0xB34F, # G+10744  U+B34F  uniB34F,  HANGUL SYLLABLE-B34F
        0xB350, # G+10745  U+B350  uniB350,  HANGUL SYLLABLE-B350
        0xB351, # G+10746  U+B351  uniB351,  HANGUL SYLLABLE-B351
        0xB352, # G+10747  U+B352  uniB352,  HANGUL SYLLABLE-B352
        0xB353, # G+10748  U+B353  uniB353,  HANGUL SYLLABLE-B353
        0xB357, # G+10749  U+B357  uniB357,  HANGUL SYLLABLE-B357
        0xB359, # G+10750  U+B359  uniB359,  HANGUL SYLLABLE-B359
        0xB35A, # G+10751  U+B35A  uniB35A,  HANGUL SYLLABLE-B35A
        0xB35D, # G+10752  U+B35D  uniB35D,  HANGUL SYLLABLE-B35D
        0xB360, # G+10753  U+B360  uniB360,  HANGUL SYLLABLE-B360
        0xB361, # G+10754  U+B361  uniB361,  HANGUL SYLLABLE-B361
        0xB362, # G+10755  U+B362  uniB362,  HANGUL SYLLABLE-B362
        0xB363, # G+10756  U+B363  uniB363,  HANGUL SYLLABLE-B363
        0xB366, # G+10757  U+B366  uniB366,  HANGUL SYLLABLE-B366
        0xB368, # G+10758  U+B368  uniB368,  HANGUL SYLLABLE-B368
        0xB36A, # G+10759  U+B36A  uniB36A,  HANGUL SYLLABLE-B36A
        0xB36C, # G+10760  U+B36C  uniB36C,  HANGUL SYLLABLE-B36C
        0xB36D, # G+10761  U+B36D  uniB36D,  HANGUL SYLLABLE-B36D
        0xB36F, # G+10762  U+B36F  uniB36F,  HANGUL SYLLABLE-B36F
        0xB372, # G+10763  U+B372  uniB372,  HANGUL SYLLABLE-B372
        0xB373, # G+10764  U+B373  uniB373,  HANGUL SYLLABLE-B373
        0xB375, # G+10765  U+B375  uniB375,  HANGUL SYLLABLE-B375
        0xB376, # G+10766  U+B376  uniB376,  HANGUL SYLLABLE-B376
        0xB377, # G+10767  U+B377  uniB377,  HANGUL SYLLABLE-B377
        0xB379, # G+10768  U+B379  uniB379,  HANGUL SYLLABLE-B379
        0xB37A, # G+10769  U+B37A  uniB37A,  HANGUL SYLLABLE-B37A
        0xB37B, # G+10770  U+B37B  uniB37B,  HANGUL SYLLABLE-B37B
        0xB37C, # G+10771  U+B37C  uniB37C,  HANGUL SYLLABLE-B37C
        0xB37D, # G+10772  U+B37D  uniB37D,  HANGUL SYLLABLE-B37D
        0xB37E, # G+10773  U+B37E  uniB37E,  HANGUL SYLLABLE-B37E
        0xB37F, # G+10774  U+B37F  uniB37F,  HANGUL SYLLABLE-B37F
        0xB382, # G+10775  U+B382  uniB382,  HANGUL SYLLABLE-B382
        0xB386, # G+10776  U+B386  uniB386,  HANGUL SYLLABLE-B386
        0xB387, # G+10777  U+B387  uniB387,  HANGUL SYLLABLE-B387
        0xB388, # G+10778  U+B388  uniB388,  HANGUL SYLLABLE-B388
        0xB389, # G+10779  U+B389  uniB389,  HANGUL SYLLABLE-B389
        0xB38A, # G+10780  U+B38A  uniB38A,  HANGUL SYLLABLE-B38A
        0xB38B, # G+10781  U+B38B  uniB38B,  HANGUL SYLLABLE-B38B
        0xB38D, # G+10782  U+B38D  uniB38D,  HANGUL SYLLABLE-B38D
        0xB38E, # G+10783  U+B38E  uniB38E,  HANGUL SYLLABLE-B38E
        0xB38F, # G+10784  U+B38F  uniB38F,  HANGUL SYLLABLE-B38F
        0xB391, # G+10785  U+B391  uniB391,  HANGUL SYLLABLE-B391
        0xB392, # G+10786  U+B392  uniB392,  HANGUL SYLLABLE-B392
        0xB393, # G+10787  U+B393  uniB393,  HANGUL SYLLABLE-B393
        0xB395, # G+10788  U+B395  uniB395,  HANGUL SYLLABLE-B395
        0xB396, # G+10789  U+B396  uniB396,  HANGUL SYLLABLE-B396
        0xB397, # G+10790  U+B397  uniB397,  HANGUL SYLLABLE-B397
        0xB398, # G+10791  U+B398  uniB398,  HANGUL SYLLABLE-B398
        0xB399, # G+10792  U+B399  uniB399,  HANGUL SYLLABLE-B399
        0xB39A, # G+10793  U+B39A  uniB39A,  HANGUL SYLLABLE-B39A
        0xB39B, # G+10794  U+B39B  uniB39B,  HANGUL SYLLABLE-B39B
        0xB39C, # G+10795  U+B39C  uniB39C,  HANGUL SYLLABLE-B39C
        0xB39D, # G+10796  U+B39D  uniB39D,  HANGUL SYLLABLE-B39D
        0xB39E, # G+10797  U+B39E  uniB39E,  HANGUL SYLLABLE-B39E
        0xB39F, # G+10798  U+B39F  uniB39F,  HANGUL SYLLABLE-B39F
        0xB3A2, # G+10799  U+B3A2  uniB3A2,  HANGUL SYLLABLE-B3A2
        0xB3A3, # G+10800  U+B3A3  uniB3A3,  HANGUL SYLLABLE-B3A3
        0xB3A4, # G+10801  U+B3A4  uniB3A4,  HANGUL SYLLABLE-B3A4
        0xB3A5, # G+10802  U+B3A5  uniB3A5,  HANGUL SYLLABLE-B3A5
        0xB3A6, # G+10803  U+B3A6  uniB3A6,  HANGUL SYLLABLE-B3A6
        0xB3A7, # G+10804  U+B3A7  uniB3A7,  HANGUL SYLLABLE-B3A7
        0xB3A9, # G+10805  U+B3A9  uniB3A9,  HANGUL SYLLABLE-B3A9
        0xB3AA, # G+10806  U+B3AA  uniB3AA,  HANGUL SYLLABLE-B3AA
        0xB3AB, # G+10807  U+B3AB  uniB3AB,  HANGUL SYLLABLE-B3AB
        0xB3AD, # G+10808  U+B3AD  uniB3AD,  HANGUL SYLLABLE-B3AD
        0xB3AE, # G+10809  U+B3AE  uniB3AE,  HANGUL SYLLABLE-B3AE
        0xB3AF, # G+10810  U+B3AF  uniB3AF,  HANGUL SYLLABLE-B3AF
        0xB3B0, # G+10811  U+B3B0  uniB3B0,  HANGUL SYLLABLE-B3B0
        0xB3B1, # G+10812  U+B3B1  uniB3B1,  HANGUL SYLLABLE-B3B1
        0xB3B2, # G+10813  U+B3B2  uniB3B2,  HANGUL SYLLABLE-B3B2
        0xB3B3, # G+10814  U+B3B3  uniB3B3,  HANGUL SYLLABLE-B3B3
        0xB3B4, # G+10815  U+B3B4  uniB3B4,  HANGUL SYLLABLE-B3B4
        0xB3B5, # G+10816  U+B3B5  uniB3B5,  HANGUL SYLLABLE-B3B5
        0xB3B6, # G+10817  U+B3B6  uniB3B6,  HANGUL SYLLABLE-B3B6
        0xB3B7, # G+10818  U+B3B7  uniB3B7,  HANGUL SYLLABLE-B3B7
        0xB3B8, # G+10819  U+B3B8  uniB3B8,  HANGUL SYLLABLE-B3B8
        0xB3B9, # G+10820  U+B3B9  uniB3B9,  HANGUL SYLLABLE-B3B9
        0xB3BA, # G+10821  U+B3BA  uniB3BA,  HANGUL SYLLABLE-B3BA
        0xB3BB, # G+10822  U+B3BB  uniB3BB,  HANGUL SYLLABLE-B3BB
        0xB3BC, # G+10823  U+B3BC  uniB3BC,  HANGUL SYLLABLE-B3BC
        0xB3BD, # G+10824  U+B3BD  uniB3BD,  HANGUL SYLLABLE-B3BD
        0xB3BE, # G+10825  U+B3BE  uniB3BE,  HANGUL SYLLABLE-B3BE
        0xB3BF, # G+10826  U+B3BF  uniB3BF,  HANGUL SYLLABLE-B3BF
        0xB3C0, # G+10827  U+B3C0  uniB3C0,  HANGUL SYLLABLE-B3C0
        0xB3C1, # G+10828  U+B3C1  uniB3C1,  HANGUL SYLLABLE-B3C1
        0xB3C2, # G+10829  U+B3C2  uniB3C2,  HANGUL SYLLABLE-B3C2
        0xB3C3, # G+10830  U+B3C3  uniB3C3,  HANGUL SYLLABLE-B3C3
        0xB3C6, # G+10831  U+B3C6  uniB3C6,  HANGUL SYLLABLE-B3C6
        0xB3C7, # G+10832  U+B3C7  uniB3C7,  HANGUL SYLLABLE-B3C7
        0xB3C9, # G+10833  U+B3C9  uniB3C9,  HANGUL SYLLABLE-B3C9
        0xB3CA, # G+10834  U+B3CA  uniB3CA,  HANGUL SYLLABLE-B3CA
        0xB3CD, # G+10835  U+B3CD  uniB3CD,  HANGUL SYLLABLE-B3CD
        0xB3CF, # G+10836  U+B3CF  uniB3CF,  HANGUL SYLLABLE-B3CF
        0xB3D1, # G+10837  U+B3D1  uniB3D1,  HANGUL SYLLABLE-B3D1
        0xB3D2, # G+10838  U+B3D2  uniB3D2,  HANGUL SYLLABLE-B3D2
        0xB3D3, # G+10839  U+B3D3  uniB3D3,  HANGUL SYLLABLE-B3D3
        0xB3D6, # G+10840  U+B3D6  uniB3D6,  HANGUL SYLLABLE-B3D6
        0xB3D8, # G+10841  U+B3D8  uniB3D8,  HANGUL SYLLABLE-B3D8
        0xB3DA, # G+10842  U+B3DA  uniB3DA,  HANGUL SYLLABLE-B3DA
        0xB3DC, # G+10843  U+B3DC  uniB3DC,  HANGUL SYLLABLE-B3DC
        0xB3DE, # G+10844  U+B3DE  uniB3DE,  HANGUL SYLLABLE-B3DE
        0xB3DF, # G+10845  U+B3DF  uniB3DF,  HANGUL SYLLABLE-B3DF
        0xB3E1, # G+10846  U+B3E1  uniB3E1,  HANGUL SYLLABLE-B3E1
        0xB3E2, # G+10847  U+B3E2  uniB3E2,  HANGUL SYLLABLE-B3E2
        0xB3E3, # G+10848  U+B3E3  uniB3E3,  HANGUL SYLLABLE-B3E3
        0xB3E5, # G+10849  U+B3E5  uniB3E5,  HANGUL SYLLABLE-B3E5
        0xB3E6, # G+10850  U+B3E6  uniB3E6,  HANGUL SYLLABLE-B3E6
        0xB3E7, # G+10851  U+B3E7  uniB3E7,  HANGUL SYLLABLE-B3E7
        0xB3E9, # G+10852  U+B3E9  uniB3E9,  HANGUL SYLLABLE-B3E9
        0xB3EA, # G+10853  U+B3EA  uniB3EA,  HANGUL SYLLABLE-B3EA
        0xB3EB, # G+10854  U+B3EB  uniB3EB,  HANGUL SYLLABLE-B3EB
        0xB3EC, # G+10855  U+B3EC  uniB3EC,  HANGUL SYLLABLE-B3EC
        0xB3ED, # G+10856  U+B3ED  uniB3ED,  HANGUL SYLLABLE-B3ED
        0xB3EE, # G+10857  U+B3EE  uniB3EE,  HANGUL SYLLABLE-B3EE
        0xB3EF, # G+10858  U+B3EF  uniB3EF,  HANGUL SYLLABLE-B3EF
        0xB3F0, # G+10859  U+B3F0  uniB3F0,  HANGUL SYLLABLE-B3F0
        0xB3F1, # G+10860  U+B3F1  uniB3F1,  HANGUL SYLLABLE-B3F1
        0xB3F2, # G+10861  U+B3F2  uniB3F2,  HANGUL SYLLABLE-B3F2
        0xB3F3, # G+10862  U+B3F3  uniB3F3,  HANGUL SYLLABLE-B3F3
        0xB3F4, # G+10863  U+B3F4  uniB3F4,  HANGUL SYLLABLE-B3F4
        0xB3F5, # G+10864  U+B3F5  uniB3F5,  HANGUL SYLLABLE-B3F5
        0xB3F6, # G+10865  U+B3F6  uniB3F6,  HANGUL SYLLABLE-B3F6
        0xB3F7, # G+10866  U+B3F7  uniB3F7,  HANGUL SYLLABLE-B3F7
        0xB3F8, # G+10867  U+B3F8  uniB3F8,  HANGUL SYLLABLE-B3F8
        0xB3F9, # G+10868  U+B3F9  uniB3F9,  HANGUL SYLLABLE-B3F9
        0xB3FA, # G+10869  U+B3FA  uniB3FA,  HANGUL SYLLABLE-B3FA
        0xB3FB, # G+10870  U+B3FB  uniB3FB,  HANGUL SYLLABLE-B3FB
        0xB3FD, # G+10871  U+B3FD  uniB3FD,  HANGUL SYLLABLE-B3FD
        0xB3FE, # G+10872  U+B3FE  uniB3FE,  HANGUL SYLLABLE-B3FE
        0xB3FF, # G+10873  U+B3FF  uniB3FF,  HANGUL SYLLABLE-B3FF
        0xB400, # G+10874  U+B400  uniB400,  HANGUL SYLLABLE-B400
        0xB401, # G+10875  U+B401  uniB401,  HANGUL SYLLABLE-B401
        0xB402, # G+10876  U+B402  uniB402,  HANGUL SYLLABLE-B402
        0xB403, # G+10877  U+B403  uniB403,  HANGUL SYLLABLE-B403
        0xB404, # G+10878  U+B404  uniB404,  HANGUL SYLLABLE-B404
        0xB405, # G+10879  U+B405  uniB405,  HANGUL SYLLABLE-B405
        0xB406, # G+10880  U+B406  uniB406,  HANGUL SYLLABLE-B406
        0xB407, # G+10881  U+B407  uniB407,  HANGUL SYLLABLE-B407
        0xB408, # G+10882  U+B408  uniB408,  HANGUL SYLLABLE-B408
        0xB409, # G+10883  U+B409  uniB409,  HANGUL SYLLABLE-B409
        0xB40A, # G+10884  U+B40A  uniB40A,  HANGUL SYLLABLE-B40A
        0xB40B, # G+10885  U+B40B  uniB40B,  HANGUL SYLLABLE-B40B
        0xB40C, # G+10886  U+B40C  uniB40C,  HANGUL SYLLABLE-B40C
        0xB40D, # G+10887  U+B40D  uniB40D,  HANGUL SYLLABLE-B40D
        0xB40E, # G+10888  U+B40E  uniB40E,  HANGUL SYLLABLE-B40E
        0xB40F, # G+10889  U+B40F  uniB40F,  HANGUL SYLLABLE-B40F
        0xB411, # G+10890  U+B411  uniB411,  HANGUL SYLLABLE-B411
        0xB412, # G+10891  U+B412  uniB412,  HANGUL SYLLABLE-B412
        0xB413, # G+10892  U+B413  uniB413,  HANGUL SYLLABLE-B413
        0xB414, # G+10893  U+B414  uniB414,  HANGUL SYLLABLE-B414
        0xB415, # G+10894  U+B415  uniB415,  HANGUL SYLLABLE-B415
        0xB416, # G+10895  U+B416  uniB416,  HANGUL SYLLABLE-B416
        0xB417, # G+10896  U+B417  uniB417,  HANGUL SYLLABLE-B417
        0xB419, # G+10897  U+B419  uniB419,  HANGUL SYLLABLE-B419
        0xB41A, # G+10898  U+B41A  uniB41A,  HANGUL SYLLABLE-B41A
        0xB41B, # G+10899  U+B41B  uniB41B,  HANGUL SYLLABLE-B41B
        0xB41D, # G+10900  U+B41D  uniB41D,  HANGUL SYLLABLE-B41D
        0xB41E, # G+10901  U+B41E  uniB41E,  HANGUL SYLLABLE-B41E
        0xB41F, # G+10902  U+B41F  uniB41F,  HANGUL SYLLABLE-B41F
        0xB421, # G+10903  U+B421  uniB421,  HANGUL SYLLABLE-B421
        0xB422, # G+10904  U+B422  uniB422,  HANGUL SYLLABLE-B422
        0xB423, # G+10905  U+B423  uniB423,  HANGUL SYLLABLE-B423
        0xB424, # G+10906  U+B424  uniB424,  HANGUL SYLLABLE-B424
        0xB425, # G+10907  U+B425  uniB425,  HANGUL SYLLABLE-B425
        0xB426, # G+10908  U+B426  uniB426,  HANGUL SYLLABLE-B426
        0xB427, # G+10909  U+B427  uniB427,  HANGUL SYLLABLE-B427
        0xB42A, # G+10910  U+B42A  uniB42A,  HANGUL SYLLABLE-B42A
        0xB42C, # G+10911  U+B42C  uniB42C,  HANGUL SYLLABLE-B42C
        0xB42D, # G+10912  U+B42D  uniB42D,  HANGUL SYLLABLE-B42D
        0xB42E, # G+10913  U+B42E  uniB42E,  HANGUL SYLLABLE-B42E
        0xB42F, # G+10914  U+B42F  uniB42F,  HANGUL SYLLABLE-B42F
        0xB430, # G+10915  U+B430  uniB430,  HANGUL SYLLABLE-B430
        0xB431, # G+10916  U+B431  uniB431,  HANGUL SYLLABLE-B431
        0xB432, # G+10917  U+B432  uniB432,  HANGUL SYLLABLE-B432
        0xB433, # G+10918  U+B433  uniB433,  HANGUL SYLLABLE-B433
        0xB435, # G+10919  U+B435  uniB435,  HANGUL SYLLABLE-B435
        0xB436, # G+10920  U+B436  uniB436,  HANGUL SYLLABLE-B436
        0xB437, # G+10921  U+B437  uniB437,  HANGUL SYLLABLE-B437
        0xB438, # G+10922  U+B438  uniB438,  HANGUL SYLLABLE-B438
        0xB439, # G+10923  U+B439  uniB439,  HANGUL SYLLABLE-B439
        0xB43A, # G+10924  U+B43A  uniB43A,  HANGUL SYLLABLE-B43A
        0xB43B, # G+10925  U+B43B  uniB43B,  HANGUL SYLLABLE-B43B
        0xB43C, # G+10926  U+B43C  uniB43C,  HANGUL SYLLABLE-B43C
        0xB43D, # G+10927  U+B43D  uniB43D,  HANGUL SYLLABLE-B43D
        0xB43E, # G+10928  U+B43E  uniB43E,  HANGUL SYLLABLE-B43E
        0xB43F, # G+10929  U+B43F  uniB43F,  HANGUL SYLLABLE-B43F
        0xB440, # G+10930  U+B440  uniB440,  HANGUL SYLLABLE-B440
        0xB441, # G+10931  U+B441  uniB441,  HANGUL SYLLABLE-B441
        0xB442, # G+10932  U+B442  uniB442,  HANGUL SYLLABLE-B442
        0xB443, # G+10933  U+B443  uniB443,  HANGUL SYLLABLE-B443
        0xB444, # G+10934  U+B444  uniB444,  HANGUL SYLLABLE-B444
        0xB445, # G+10935  U+B445  uniB445,  HANGUL SYLLABLE-B445
        0xB446, # G+10936  U+B446  uniB446,  HANGUL SYLLABLE-B446
        0xB447, # G+10937  U+B447  uniB447,  HANGUL SYLLABLE-B447
        0xB448, # G+10938  U+B448  uniB448,  HANGUL SYLLABLE-B448
        0xB449, # G+10939  U+B449  uniB449,  HANGUL SYLLABLE-B449
        0xB44A, # G+10940  U+B44A  uniB44A,  HANGUL SYLLABLE-B44A
        0xB44B, # G+10941  U+B44B  uniB44B,  HANGUL SYLLABLE-B44B
        0xB44C, # G+10942  U+B44C  uniB44C,  HANGUL SYLLABLE-B44C
        0xB44D, # G+10943  U+B44D  uniB44D,  HANGUL SYLLABLE-B44D
        0xB44E, # G+10944  U+B44E  uniB44E,  HANGUL SYLLABLE-B44E
        0xB44F, # G+10945  U+B44F  uniB44F,  HANGUL SYLLABLE-B44F
        0xB452, # G+10946  U+B452  uniB452,  HANGUL SYLLABLE-B452
        0xB453, # G+10947  U+B453  uniB453,  HANGUL SYLLABLE-B453
        0xB455, # G+10948  U+B455  uniB455,  HANGUL SYLLABLE-B455
        0xB456, # G+10949  U+B456  uniB456,  HANGUL SYLLABLE-B456
        0xB457, # G+10950  U+B457  uniB457,  HANGUL SYLLABLE-B457
        0xB459, # G+10951  U+B459  uniB459,  HANGUL SYLLABLE-B459
        0xB45A, # G+10952  U+B45A  uniB45A,  HANGUL SYLLABLE-B45A
        0xB45B, # G+10953  U+B45B  uniB45B,  HANGUL SYLLABLE-B45B
        0xB45C, # G+10954  U+B45C  uniB45C,  HANGUL SYLLABLE-B45C
        0xB45D, # G+10955  U+B45D  uniB45D,  HANGUL SYLLABLE-B45D
        0xB45E, # G+10956  U+B45E  uniB45E,  HANGUL SYLLABLE-B45E
        0xB45F, # G+10957  U+B45F  uniB45F,  HANGUL SYLLABLE-B45F
        0xB462, # G+10958  U+B462  uniB462,  HANGUL SYLLABLE-B462
        0xB464, # G+10959  U+B464  uniB464,  HANGUL SYLLABLE-B464
        0xB466, # G+10960  U+B466  uniB466,  HANGUL SYLLABLE-B466
        0xB467, # G+10961  U+B467  uniB467,  HANGUL SYLLABLE-B467
        0xB468, # G+10962  U+B468  uniB468,  HANGUL SYLLABLE-B468
        0xB469, # G+10963  U+B469  uniB469,  HANGUL SYLLABLE-B469
        0xB46A, # G+10964  U+B46A  uniB46A,  HANGUL SYLLABLE-B46A
        0xB46B, # G+10965  U+B46B  uniB46B,  HANGUL SYLLABLE-B46B
        0xB46D, # G+10966  U+B46D  uniB46D,  HANGUL SYLLABLE-B46D
        0xB46E, # G+10967  U+B46E  uniB46E,  HANGUL SYLLABLE-B46E
        0xB46F, # G+10968  U+B46F  uniB46F,  HANGUL SYLLABLE-B46F
        0xB470, # G+10969  U+B470  uniB470,  HANGUL SYLLABLE-B470
        0xB471, # G+10970  U+B471  uniB471,  HANGUL SYLLABLE-B471
        0xB472, # G+10971  U+B472  uniB472,  HANGUL SYLLABLE-B472
        0xB473, # G+10972  U+B473  uniB473,  HANGUL SYLLABLE-B473
        0xB474, # G+10973  U+B474  uniB474,  HANGUL SYLLABLE-B474
        0xB475, # G+10974  U+B475  uniB475,  HANGUL SYLLABLE-B475
        0xB476, # G+10975  U+B476  uniB476,  HANGUL SYLLABLE-B476
        0xB477, # G+10976  U+B477  uniB477,  HANGUL SYLLABLE-B477
        0xB478, # G+10977  U+B478  uniB478,  HANGUL SYLLABLE-B478
        0xB479, # G+10978  U+B479  uniB479,  HANGUL SYLLABLE-B479
        0xB47A, # G+10979  U+B47A  uniB47A,  HANGUL SYLLABLE-B47A
        0xB47B, # G+10980  U+B47B  uniB47B,  HANGUL SYLLABLE-B47B
        0xB47C, # G+10981  U+B47C  uniB47C,  HANGUL SYLLABLE-B47C
        0xB47D, # G+10982  U+B47D  uniB47D,  HANGUL SYLLABLE-B47D
        0xB47E, # G+10983  U+B47E  uniB47E,  HANGUL SYLLABLE-B47E
        0xB47F, # G+10984  U+B47F  uniB47F,  HANGUL SYLLABLE-B47F
        0xB481, # G+10985  U+B481  uniB481,  HANGUL SYLLABLE-B481
        0xB482, # G+10986  U+B482  uniB482,  HANGUL SYLLABLE-B482
        0xB483, # G+10987  U+B483  uniB483,  HANGUL SYLLABLE-B483
        0xB484, # G+10988  U+B484  uniB484,  HANGUL SYLLABLE-B484
        0xB485, # G+10989  U+B485  uniB485,  HANGUL SYLLABLE-B485
        0xB486, # G+10990  U+B486  uniB486,  HANGUL SYLLABLE-B486
        0xB487, # G+10991  U+B487  uniB487,  HANGUL SYLLABLE-B487
        0xB489, # G+10992  U+B489  uniB489,  HANGUL SYLLABLE-B489
        0xB48A, # G+10993  U+B48A  uniB48A,  HANGUL SYLLABLE-B48A
        0xB48B, # G+10994  U+B48B  uniB48B,  HANGUL SYLLABLE-B48B
        0xB48C, # G+10995  U+B48C  uniB48C,  HANGUL SYLLABLE-B48C
        0xB48D, # G+10996  U+B48D  uniB48D,  HANGUL SYLLABLE-B48D
        0xB48E, # G+10997  U+B48E  uniB48E,  HANGUL SYLLABLE-B48E
        0xB48F, # G+10998  U+B48F  uniB48F,  HANGUL SYLLABLE-B48F
        0xB490, # G+10999  U+B490  uniB490,  HANGUL SYLLABLE-B490
        0xB491, # G+11000  U+B491  uniB491,  HANGUL SYLLABLE-B491
        0xB492, # G+11001  U+B492  uniB492,  HANGUL SYLLABLE-B492
        0xB493, # G+11002  U+B493  uniB493,  HANGUL SYLLABLE-B493
        0xB494, # G+11003  U+B494  uniB494,  HANGUL SYLLABLE-B494
        0xB495, # G+11004  U+B495  uniB495,  HANGUL SYLLABLE-B495
        0xB496, # G+11005  U+B496  uniB496,  HANGUL SYLLABLE-B496
        0xB497, # G+11006  U+B497  uniB497,  HANGUL SYLLABLE-B497
        0xB498, # G+11007  U+B498  uniB498,  HANGUL SYLLABLE-B498
        0xB499, # G+11008  U+B499  uniB499,  HANGUL SYLLABLE-B499
        0xB49A, # G+11009  U+B49A  uniB49A,  HANGUL SYLLABLE-B49A
        0xB49B, # G+11010  U+B49B  uniB49B,  HANGUL SYLLABLE-B49B
        0xB49C, # G+11011  U+B49C  uniB49C,  HANGUL SYLLABLE-B49C
        0xB49E, # G+11012  U+B49E  uniB49E,  HANGUL SYLLABLE-B49E
        0xB49F, # G+11013  U+B49F  uniB49F,  HANGUL SYLLABLE-B49F
        0xB4A0, # G+11014  U+B4A0  uniB4A0,  HANGUL SYLLABLE-B4A0
        0xB4A1, # G+11015  U+B4A1  uniB4A1,  HANGUL SYLLABLE-B4A1
        0xB4A2, # G+11016  U+B4A2  uniB4A2,  HANGUL SYLLABLE-B4A2
        0xB4A3, # G+11017  U+B4A3  uniB4A3,  HANGUL SYLLABLE-B4A3
        0xB4A5, # G+11018  U+B4A5  uniB4A5,  HANGUL SYLLABLE-B4A5
        0xB4A6, # G+11019  U+B4A6  uniB4A6,  HANGUL SYLLABLE-B4A6
        0xB4A7, # G+11020  U+B4A7  uniB4A7,  HANGUL SYLLABLE-B4A7
        0xB4A9, # G+11021  U+B4A9  uniB4A9,  HANGUL SYLLABLE-B4A9
        0xB4AA, # G+11022  U+B4AA  uniB4AA,  HANGUL SYLLABLE-B4AA
        0xB4AB, # G+11023  U+B4AB  uniB4AB,  HANGUL SYLLABLE-B4AB
        0xB4AD, # G+11024  U+B4AD  uniB4AD,  HANGUL SYLLABLE-B4AD
        0xB4AE, # G+11025  U+B4AE  uniB4AE,  HANGUL SYLLABLE-B4AE
        0xB4AF, # G+11026  U+B4AF  uniB4AF,  HANGUL SYLLABLE-B4AF
        0xB4B0, # G+11027  U+B4B0  uniB4B0,  HANGUL SYLLABLE-B4B0
        0xB4B1, # G+11028  U+B4B1  uniB4B1,  HANGUL SYLLABLE-B4B1
        0xB4B2, # G+11029  U+B4B2  uniB4B2,  HANGUL SYLLABLE-B4B2
        0xB4B3, # G+11030  U+B4B3  uniB4B3,  HANGUL SYLLABLE-B4B3
        0xB4B4, # G+11031  U+B4B4  uniB4B4,  HANGUL SYLLABLE-B4B4
        0xB4B6, # G+11032  U+B4B6  uniB4B6,  HANGUL SYLLABLE-B4B6
        0xB4B8, # G+11033  U+B4B8  uniB4B8,  HANGUL SYLLABLE-B4B8
        0xB4BA, # G+11034  U+B4BA  uniB4BA,  HANGUL SYLLABLE-B4BA
        0xB4BB, # G+11035  U+B4BB  uniB4BB,  HANGUL SYLLABLE-B4BB
        0xB4BC, # G+11036  U+B4BC  uniB4BC,  HANGUL SYLLABLE-B4BC
        0xB4BD, # G+11037  U+B4BD  uniB4BD,  HANGUL SYLLABLE-B4BD
        0xB4BE, # G+11038  U+B4BE  uniB4BE,  HANGUL SYLLABLE-B4BE
        0xB4BF, # G+11039  U+B4BF  uniB4BF,  HANGUL SYLLABLE-B4BF
        0xB4C1, # G+11040  U+B4C1  uniB4C1,  HANGUL SYLLABLE-B4C1
        0xB4C2, # G+11041  U+B4C2  uniB4C2,  HANGUL SYLLABLE-B4C2
        0xB4C3, # G+11042  U+B4C3  uniB4C3,  HANGUL SYLLABLE-B4C3
        0xB4C5, # G+11043  U+B4C5  uniB4C5,  HANGUL SYLLABLE-B4C5
        0xB4C6, # G+11044  U+B4C6  uniB4C6,  HANGUL SYLLABLE-B4C6
        0xB4C7, # G+11045  U+B4C7  uniB4C7,  HANGUL SYLLABLE-B4C7
        0xB4C9, # G+11046  U+B4C9  uniB4C9,  HANGUL SYLLABLE-B4C9
        0xB4CA, # G+11047  U+B4CA  uniB4CA,  HANGUL SYLLABLE-B4CA
        0xB4CB, # G+11048  U+B4CB  uniB4CB,  HANGUL SYLLABLE-B4CB
        0xB4CC, # G+11049  U+B4CC  uniB4CC,  HANGUL SYLLABLE-B4CC
        0xB4CD, # G+11050  U+B4CD  uniB4CD,  HANGUL SYLLABLE-B4CD
        0xB4CE, # G+11051  U+B4CE  uniB4CE,  HANGUL SYLLABLE-B4CE
        0xB4CF, # G+11052  U+B4CF  uniB4CF,  HANGUL SYLLABLE-B4CF
        0xB4D1, # G+11053  U+B4D1  uniB4D1,  HANGUL SYLLABLE-B4D1
        0xB4D2, # G+11054  U+B4D2  uniB4D2,  HANGUL SYLLABLE-B4D2
        0xB4D3, # G+11055  U+B4D3  uniB4D3,  HANGUL SYLLABLE-B4D3
        0xB4D4, # G+11056  U+B4D4  uniB4D4,  HANGUL SYLLABLE-B4D4
        0xB4D6, # G+11057  U+B4D6  uniB4D6,  HANGUL SYLLABLE-B4D6
        0xB4D7, # G+11058  U+B4D7  uniB4D7,  HANGUL SYLLABLE-B4D7
        0xB4D8, # G+11059  U+B4D8  uniB4D8,  HANGUL SYLLABLE-B4D8
        0xB4D9, # G+11060  U+B4D9  uniB4D9,  HANGUL SYLLABLE-B4D9
        0xB4DA, # G+11061  U+B4DA  uniB4DA,  HANGUL SYLLABLE-B4DA
        0xB4DB, # G+11062  U+B4DB  uniB4DB,  HANGUL SYLLABLE-B4DB
        0xB4DE, # G+11063  U+B4DE  uniB4DE,  HANGUL SYLLABLE-B4DE
        0xB4DF, # G+11064  U+B4DF  uniB4DF,  HANGUL SYLLABLE-B4DF
        0xB4E1, # G+11065  U+B4E1  uniB4E1,  HANGUL SYLLABLE-B4E1
        0xB4E2, # G+11066  U+B4E2  uniB4E2,  HANGUL SYLLABLE-B4E2
        0xB4E5, # G+11067  U+B4E5  uniB4E5,  HANGUL SYLLABLE-B4E5
        0xB4E7, # G+11068  U+B4E7  uniB4E7,  HANGUL SYLLABLE-B4E7
        0xB4E8, # G+11069  U+B4E8  uniB4E8,  HANGUL SYLLABLE-B4E8
        0xB4E9, # G+11070  U+B4E9  uniB4E9,  HANGUL SYLLABLE-B4E9
        0xB4EA, # G+11071  U+B4EA  uniB4EA,  HANGUL SYLLABLE-B4EA
        0xB4EB, # G+11072  U+B4EB  uniB4EB,  HANGUL SYLLABLE-B4EB
        0xB4EE, # G+11073  U+B4EE  uniB4EE,  HANGUL SYLLABLE-B4EE
        0xB4F0, # G+11074  U+B4F0  uniB4F0,  HANGUL SYLLABLE-B4F0
        0xB4F2, # G+11075  U+B4F2  uniB4F2,  HANGUL SYLLABLE-B4F2
        0xB4F3, # G+11076  U+B4F3  uniB4F3,  HANGUL SYLLABLE-B4F3
        0xB4F4, # G+11077  U+B4F4  uniB4F4,  HANGUL SYLLABLE-B4F4
        0xB4F5, # G+11078  U+B4F5  uniB4F5,  HANGUL SYLLABLE-B4F5
        0xB4F6, # G+11079  U+B4F6  uniB4F6,  HANGUL SYLLABLE-B4F6
        0xB4F7, # G+11080  U+B4F7  uniB4F7,  HANGUL SYLLABLE-B4F7
        0xB4F9, # G+11081  U+B4F9  uniB4F9,  HANGUL SYLLABLE-B4F9
        0xB4FA, # G+11082  U+B4FA  uniB4FA,  HANGUL SYLLABLE-B4FA
        0xB4FB, # G+11083  U+B4FB  uniB4FB,  HANGUL SYLLABLE-B4FB
        0xB4FC, # G+11084  U+B4FC  uniB4FC,  HANGUL SYLLABLE-B4FC
        0xB4FD, # G+11085  U+B4FD  uniB4FD,  HANGUL SYLLABLE-B4FD
        0xB4FE, # G+11086  U+B4FE  uniB4FE,  HANGUL SYLLABLE-B4FE
        0xB4FF, # G+11087  U+B4FF  uniB4FF,  HANGUL SYLLABLE-B4FF
        0xB500, # G+11088  U+B500  uniB500,  HANGUL SYLLABLE-B500
        0xB501, # G+11089  U+B501  uniB501,  HANGUL SYLLABLE-B501
        0xB502, # G+11090  U+B502  uniB502,  HANGUL SYLLABLE-B502
        0xB503, # G+11091  U+B503  uniB503,  HANGUL SYLLABLE-B503
        0xB504, # G+11092  U+B504  uniB504,  HANGUL SYLLABLE-B504
        0xB505, # G+11093  U+B505  uniB505,  HANGUL SYLLABLE-B505
        0xB506, # G+11094  U+B506  uniB506,  HANGUL SYLLABLE-B506
        0xB507, # G+11095  U+B507  uniB507,  HANGUL SYLLABLE-B507
        0xB508, # G+11096  U+B508  uniB508,  HANGUL SYLLABLE-B508
        0xB509, # G+11097  U+B509  uniB509,  HANGUL SYLLABLE-B509
        0xB50A, # G+11098  U+B50A  uniB50A,  HANGUL SYLLABLE-B50A
        0xB50B, # G+11099  U+B50B  uniB50B,  HANGUL SYLLABLE-B50B
        0xB50C, # G+11100  U+B50C  uniB50C,  HANGUL SYLLABLE-B50C
        0xB50D, # G+11101  U+B50D  uniB50D,  HANGUL SYLLABLE-B50D
        0xB50E, # G+11102  U+B50E  uniB50E,  HANGUL SYLLABLE-B50E
        0xB50F, # G+11103  U+B50F  uniB50F,  HANGUL SYLLABLE-B50F
        0xB510, # G+11104  U+B510  uniB510,  HANGUL SYLLABLE-B510
        0xB511, # G+11105  U+B511  uniB511,  HANGUL SYLLABLE-B511
        0xB512, # G+11106  U+B512  uniB512,  HANGUL SYLLABLE-B512
        0xB513, # G+11107  U+B513  uniB513,  HANGUL SYLLABLE-B513
        0xB516, # G+11108  U+B516  uniB516,  HANGUL SYLLABLE-B516
        0xB517, # G+11109  U+B517  uniB517,  HANGUL SYLLABLE-B517
        0xB519, # G+11110  U+B519  uniB519,  HANGUL SYLLABLE-B519
        0xB51A, # G+11111  U+B51A  uniB51A,  HANGUL SYLLABLE-B51A
        0xB51D, # G+11112  U+B51D  uniB51D,  HANGUL SYLLABLE-B51D
        0xB51E, # G+11113  U+B51E  uniB51E,  HANGUL SYLLABLE-B51E
        0xB51F, # G+11114  U+B51F  uniB51F,  HANGUL SYLLABLE-B51F
        0xB520, # G+11115  U+B520  uniB520,  HANGUL SYLLABLE-B520
        0xB521, # G+11116  U+B521  uniB521,  HANGUL SYLLABLE-B521
        0xB522, # G+11117  U+B522  uniB522,  HANGUL SYLLABLE-B522
        0xB523, # G+11118  U+B523  uniB523,  HANGUL SYLLABLE-B523
        0xB526, # G+11119  U+B526  uniB526,  HANGUL SYLLABLE-B526
        0xB52B, # G+11120  U+B52B  uniB52B,  HANGUL SYLLABLE-B52B
        0xB52C, # G+11121  U+B52C  uniB52C,  HANGUL SYLLABLE-B52C
        0xB52D, # G+11122  U+B52D  uniB52D,  HANGUL SYLLABLE-B52D
        0xB52E, # G+11123  U+B52E  uniB52E,  HANGUL SYLLABLE-B52E
        0xB52F, # G+11124  U+B52F  uniB52F,  HANGUL SYLLABLE-B52F
        0xB532, # G+11125  U+B532  uniB532,  HANGUL SYLLABLE-B532
        0xB533, # G+11126  U+B533  uniB533,  HANGUL SYLLABLE-B533
        0xB535, # G+11127  U+B535  uniB535,  HANGUL SYLLABLE-B535
        0xB536, # G+11128  U+B536  uniB536,  HANGUL SYLLABLE-B536
        0xB537, # G+11129  U+B537  uniB537,  HANGUL SYLLABLE-B537
        0xB539, # G+11130  U+B539  uniB539,  HANGUL SYLLABLE-B539
        0xB53A, # G+11131  U+B53A  uniB53A,  HANGUL SYLLABLE-B53A
        0xB53B, # G+11132  U+B53B  uniB53B,  HANGUL SYLLABLE-B53B
        0xB53C, # G+11133  U+B53C  uniB53C,  HANGUL SYLLABLE-B53C
        0xB53D, # G+11134  U+B53D  uniB53D,  HANGUL SYLLABLE-B53D
        0xB53E, # G+11135  U+B53E  uniB53E,  HANGUL SYLLABLE-B53E
        0xB53F, # G+11136  U+B53F  uniB53F,  HANGUL SYLLABLE-B53F
        0xB542, # G+11137  U+B542  uniB542,  HANGUL SYLLABLE-B542
        0xB546, # G+11138  U+B546  uniB546,  HANGUL SYLLABLE-B546
        0xB547, # G+11139  U+B547  uniB547,  HANGUL SYLLABLE-B547
        0xB548, # G+11140  U+B548  uniB548,  HANGUL SYLLABLE-B548
        0xB549, # G+11141  U+B549  uniB549,  HANGUL SYLLABLE-B549
        0xB54A, # G+11142  U+B54A  uniB54A,  HANGUL SYLLABLE-B54A
        0xB54E, # G+11143  U+B54E  uniB54E,  HANGUL SYLLABLE-B54E
        0xB54F, # G+11144  U+B54F  uniB54F,  HANGUL SYLLABLE-B54F
        0xB551, # G+11145  U+B551  uniB551,  HANGUL SYLLABLE-B551
        0xB552, # G+11146  U+B552  uniB552,  HANGUL SYLLABLE-B552
        0xB553, # G+11147  U+B553  uniB553,  HANGUL SYLLABLE-B553
        0xB555, # G+11148  U+B555  uniB555,  HANGUL SYLLABLE-B555
        0xB556, # G+11149  U+B556  uniB556,  HANGUL SYLLABLE-B556
        0xB557, # G+11150  U+B557  uniB557,  HANGUL SYLLABLE-B557
        0xB558, # G+11151  U+B558  uniB558,  HANGUL SYLLABLE-B558
        0xB559, # G+11152  U+B559  uniB559,  HANGUL SYLLABLE-B559
        0xB55A, # G+11153  U+B55A  uniB55A,  HANGUL SYLLABLE-B55A
        0xB55B, # G+11154  U+B55B  uniB55B,  HANGUL SYLLABLE-B55B
        0xB55E, # G+11155  U+B55E  uniB55E,  HANGUL SYLLABLE-B55E
        0xB562, # G+11156  U+B562  uniB562,  HANGUL SYLLABLE-B562
        0xB563, # G+11157  U+B563  uniB563,  HANGUL SYLLABLE-B563
        0xB564, # G+11158  U+B564  uniB564,  HANGUL SYLLABLE-B564
        0xB565, # G+11159  U+B565  uniB565,  HANGUL SYLLABLE-B565
        0xB566, # G+11160  U+B566  uniB566,  HANGUL SYLLABLE-B566
        0xB567, # G+11161  U+B567  uniB567,  HANGUL SYLLABLE-B567
        0xB568, # G+11162  U+B568  uniB568,  HANGUL SYLLABLE-B568
        0xB569, # G+11163  U+B569  uniB569,  HANGUL SYLLABLE-B569
        0xB56A, # G+11164  U+B56A  uniB56A,  HANGUL SYLLABLE-B56A
        0xB56B, # G+11165  U+B56B  uniB56B,  HANGUL SYLLABLE-B56B
        0xB56C, # G+11166  U+B56C  uniB56C,  HANGUL SYLLABLE-B56C
        0xB56D, # G+11167  U+B56D  uniB56D,  HANGUL SYLLABLE-B56D
        0xB56E, # G+11168  U+B56E  uniB56E,  HANGUL SYLLABLE-B56E
        0xB56F, # G+11169  U+B56F  uniB56F,  HANGUL SYLLABLE-B56F
        0xB570, # G+11170  U+B570  uniB570,  HANGUL SYLLABLE-B570
        0xB571, # G+11171  U+B571  uniB571,  HANGUL SYLLABLE-B571
        0xB572, # G+11172  U+B572  uniB572,  HANGUL SYLLABLE-B572
        0xB573, # G+11173  U+B573  uniB573,  HANGUL SYLLABLE-B573
        0xB574, # G+11174  U+B574  uniB574,  HANGUL SYLLABLE-B574
        0xB575, # G+11175  U+B575  uniB575,  HANGUL SYLLABLE-B575
        0xB576, # G+11176  U+B576  uniB576,  HANGUL SYLLABLE-B576
        0xB577, # G+11177  U+B577  uniB577,  HANGUL SYLLABLE-B577
        0xB578, # G+11178  U+B578  uniB578,  HANGUL SYLLABLE-B578
        0xB579, # G+11179  U+B579  uniB579,  HANGUL SYLLABLE-B579
        0xB57A, # G+11180  U+B57A  uniB57A,  HANGUL SYLLABLE-B57A
        0xB57B, # G+11181  U+B57B  uniB57B,  HANGUL SYLLABLE-B57B
        0xB57C, # G+11182  U+B57C  uniB57C,  HANGUL SYLLABLE-B57C
        0xB57D, # G+11183  U+B57D  uniB57D,  HANGUL SYLLABLE-B57D
        0xB57E, # G+11184  U+B57E  uniB57E,  HANGUL SYLLABLE-B57E
        0xB57F, # G+11185  U+B57F  uniB57F,  HANGUL SYLLABLE-B57F
        0xB580, # G+11186  U+B580  uniB580,  HANGUL SYLLABLE-B580
        0xB581, # G+11187  U+B581  uniB581,  HANGUL SYLLABLE-B581
        0xB582, # G+11188  U+B582  uniB582,  HANGUL SYLLABLE-B582
        0xB583, # G+11189  U+B583  uniB583,  HANGUL SYLLABLE-B583
        0xB584, # G+11190  U+B584  uniB584,  HANGUL SYLLABLE-B584
        0xB585, # G+11191  U+B585  uniB585,  HANGUL SYLLABLE-B585
        0xB586, # G+11192  U+B586  uniB586,  HANGUL SYLLABLE-B586
        0xB587, # G+11193  U+B587  uniB587,  HANGUL SYLLABLE-B587
        0xB588, # G+11194  U+B588  uniB588,  HANGUL SYLLABLE-B588
        0xB589, # G+11195  U+B589  uniB589,  HANGUL SYLLABLE-B589
        0xB58A, # G+11196  U+B58A  uniB58A,  HANGUL SYLLABLE-B58A
        0xB58B, # G+11197  U+B58B  uniB58B,  HANGUL SYLLABLE-B58B
        0xB58C, # G+11198  U+B58C  uniB58C,  HANGUL SYLLABLE-B58C
        0xB58D, # G+11199  U+B58D  uniB58D,  HANGUL SYLLABLE-B58D
        0xB58E, # G+11200  U+B58E  uniB58E,  HANGUL SYLLABLE-B58E
        0xB58F, # G+11201  U+B58F  uniB58F,  HANGUL SYLLABLE-B58F
        0xB590, # G+11202  U+B590  uniB590,  HANGUL SYLLABLE-B590
        0xB591, # G+11203  U+B591  uniB591,  HANGUL SYLLABLE-B591
        0xB592, # G+11204  U+B592  uniB592,  HANGUL SYLLABLE-B592
        0xB593, # G+11205  U+B593  uniB593,  HANGUL SYLLABLE-B593
        0xB594, # G+11206  U+B594  uniB594,  HANGUL SYLLABLE-B594
        0xB595, # G+11207  U+B595  uniB595,  HANGUL SYLLABLE-B595
        0xB596, # G+11208  U+B596  uniB596,  HANGUL SYLLABLE-B596
        0xB597, # G+11209  U+B597  uniB597,  HANGUL SYLLABLE-B597
        0xB598, # G+11210  U+B598  uniB598,  HANGUL SYLLABLE-B598
        0xB599, # G+11211  U+B599  uniB599,  HANGUL SYLLABLE-B599
        0xB59A, # G+11212  U+B59A  uniB59A,  HANGUL SYLLABLE-B59A
        0xB59B, # G+11213  U+B59B  uniB59B,  HANGUL SYLLABLE-B59B
        0xB59C, # G+11214  U+B59C  uniB59C,  HANGUL SYLLABLE-B59C
        0xB59D, # G+11215  U+B59D  uniB59D,  HANGUL SYLLABLE-B59D
        0xB59E, # G+11216  U+B59E  uniB59E,  HANGUL SYLLABLE-B59E
        0xB59F, # G+11217  U+B59F  uniB59F,  HANGUL SYLLABLE-B59F
        0xB5A2, # G+11218  U+B5A2  uniB5A2,  HANGUL SYLLABLE-B5A2
        0xB5A3, # G+11219  U+B5A3  uniB5A3,  HANGUL SYLLABLE-B5A3
        0xB5A5, # G+11220  U+B5A5  uniB5A5,  HANGUL SYLLABLE-B5A5
        0xB5A6, # G+11221  U+B5A6  uniB5A6,  HANGUL SYLLABLE-B5A6
        0xB5A7, # G+11222  U+B5A7  uniB5A7,  HANGUL SYLLABLE-B5A7
        0xB5A9, # G+11223  U+B5A9  uniB5A9,  HANGUL SYLLABLE-B5A9
        0xB5AC, # G+11224  U+B5AC  uniB5AC,  HANGUL SYLLABLE-B5AC
        0xB5AD, # G+11225  U+B5AD  uniB5AD,  HANGUL SYLLABLE-B5AD
        0xB5AE, # G+11226  U+B5AE  uniB5AE,  HANGUL SYLLABLE-B5AE
        0xB5AF, # G+11227  U+B5AF  uniB5AF,  HANGUL SYLLABLE-B5AF
        0xB5B2, # G+11228  U+B5B2  uniB5B2,  HANGUL SYLLABLE-B5B2
        0xB5B6, # G+11229  U+B5B6  uniB5B6,  HANGUL SYLLABLE-B5B6
        0xB5B7, # G+11230  U+B5B7  uniB5B7,  HANGUL SYLLABLE-B5B7
        0xB5B8, # G+11231  U+B5B8  uniB5B8,  HANGUL SYLLABLE-B5B8
        0xB5B9, # G+11232  U+B5B9  uniB5B9,  HANGUL SYLLABLE-B5B9
        0xB5BA, # G+11233  U+B5BA  uniB5BA,  HANGUL SYLLABLE-B5BA
        0xB5BE, # G+11234  U+B5BE  uniB5BE,  HANGUL SYLLABLE-B5BE
        0xB5BF, # G+11235  U+B5BF  uniB5BF,  HANGUL SYLLABLE-B5BF
        0xB5C1, # G+11236  U+B5C1  uniB5C1,  HANGUL SYLLABLE-B5C1
        0xB5C2, # G+11237  U+B5C2  uniB5C2,  HANGUL SYLLABLE-B5C2
        0xB5C3, # G+11238  U+B5C3  uniB5C3,  HANGUL SYLLABLE-B5C3
        0xB5C5, # G+11239  U+B5C5  uniB5C5,  HANGUL SYLLABLE-B5C5
        0xB5C6, # G+11240  U+B5C6  uniB5C6,  HANGUL SYLLABLE-B5C6
        0xB5C7, # G+11241  U+B5C7  uniB5C7,  HANGUL SYLLABLE-B5C7
        0xB5C8, # G+11242  U+B5C8  uniB5C8,  HANGUL SYLLABLE-B5C8
        0xB5C9, # G+11243  U+B5C9  uniB5C9,  HANGUL SYLLABLE-B5C9
        0xB5CA, # G+11244  U+B5CA  uniB5CA,  HANGUL SYLLABLE-B5CA
        0xB5CB, # G+11245  U+B5CB  uniB5CB,  HANGUL SYLLABLE-B5CB
        0xB5CE, # G+11246  U+B5CE  uniB5CE,  HANGUL SYLLABLE-B5CE
        0xB5D2, # G+11247  U+B5D2  uniB5D2,  HANGUL SYLLABLE-B5D2
        0xB5D3, # G+11248  U+B5D3  uniB5D3,  HANGUL SYLLABLE-B5D3
        0xB5D4, # G+11249  U+B5D4  uniB5D4,  HANGUL SYLLABLE-B5D4
        0xB5D5, # G+11250  U+B5D5  uniB5D5,  HANGUL SYLLABLE-B5D5
        0xB5D6, # G+11251  U+B5D6  uniB5D6,  HANGUL SYLLABLE-B5D6
        0xB5D7, # G+11252  U+B5D7  uniB5D7,  HANGUL SYLLABLE-B5D7
        0xB5D9, # G+11253  U+B5D9  uniB5D9,  HANGUL SYLLABLE-B5D9
        0xB5DA, # G+11254  U+B5DA  uniB5DA,  HANGUL SYLLABLE-B5DA
        0xB5DB, # G+11255  U+B5DB  uniB5DB,  HANGUL SYLLABLE-B5DB
        0xB5DC, # G+11256  U+B5DC  uniB5DC,  HANGUL SYLLABLE-B5DC
        0xB5DD, # G+11257  U+B5DD  uniB5DD,  HANGUL SYLLABLE-B5DD
        0xB5DE, # G+11258  U+B5DE  uniB5DE,  HANGUL SYLLABLE-B5DE
        0xB5DF, # G+11259  U+B5DF  uniB5DF,  HANGUL SYLLABLE-B5DF
        0xB5E0, # G+11260  U+B5E0  uniB5E0,  HANGUL SYLLABLE-B5E0
        0xB5E1, # G+11261  U+B5E1  uniB5E1,  HANGUL SYLLABLE-B5E1
        0xB5E2, # G+11262  U+B5E2  uniB5E2,  HANGUL SYLLABLE-B5E2
        0xB5E3, # G+11263  U+B5E3  uniB5E3,  HANGUL SYLLABLE-B5E3
        0xB5E4, # G+11264  U+B5E4  uniB5E4,  HANGUL SYLLABLE-B5E4
        0xB5E5, # G+11265  U+B5E5  uniB5E5,  HANGUL SYLLABLE-B5E5
        0xB5E6, # G+11266  U+B5E6  uniB5E6,  HANGUL SYLLABLE-B5E6
        0xB5E7, # G+11267  U+B5E7  uniB5E7,  HANGUL SYLLABLE-B5E7
        0xB5E8, # G+11268  U+B5E8  uniB5E8,  HANGUL SYLLABLE-B5E8
        0xB5E9, # G+11269  U+B5E9  uniB5E9,  HANGUL SYLLABLE-B5E9
        0xB5EA, # G+11270  U+B5EA  uniB5EA,  HANGUL SYLLABLE-B5EA
        0xB5EB, # G+11271  U+B5EB  uniB5EB,  HANGUL SYLLABLE-B5EB
        0xB5ED, # G+11272  U+B5ED  uniB5ED,  HANGUL SYLLABLE-B5ED
        0xB5EE, # G+11273  U+B5EE  uniB5EE,  HANGUL SYLLABLE-B5EE
        0xB5EF, # G+11274  U+B5EF  uniB5EF,  HANGUL SYLLABLE-B5EF
        0xB5F0, # G+11275  U+B5F0  uniB5F0,  HANGUL SYLLABLE-B5F0
        0xB5F1, # G+11276  U+B5F1  uniB5F1,  HANGUL SYLLABLE-B5F1
        0xB5F2, # G+11277  U+B5F2  uniB5F2,  HANGUL SYLLABLE-B5F2
        0xB5F3, # G+11278  U+B5F3  uniB5F3,  HANGUL SYLLABLE-B5F3
        0xB5F4, # G+11279  U+B5F4  uniB5F4,  HANGUL SYLLABLE-B5F4
        0xB5F5, # G+11280  U+B5F5  uniB5F5,  HANGUL SYLLABLE-B5F5
        0xB5F6, # G+11281  U+B5F6  uniB5F6,  HANGUL SYLLABLE-B5F6
        0xB5F7, # G+11282  U+B5F7  uniB5F7,  HANGUL SYLLABLE-B5F7
        0xB5F8, # G+11283  U+B5F8  uniB5F8,  HANGUL SYLLABLE-B5F8
        0xB5F9, # G+11284  U+B5F9  uniB5F9,  HANGUL SYLLABLE-B5F9
        0xB5FA, # G+11285  U+B5FA  uniB5FA,  HANGUL SYLLABLE-B5FA
        0xB5FB, # G+11286  U+B5FB  uniB5FB,  HANGUL SYLLABLE-B5FB
        0xB5FC, # G+11287  U+B5FC  uniB5FC,  HANGUL SYLLABLE-B5FC
        0xB5FD, # G+11288  U+B5FD  uniB5FD,  HANGUL SYLLABLE-B5FD
        0xB5FE, # G+11289  U+B5FE  uniB5FE,  HANGUL SYLLABLE-B5FE
        0xB5FF, # G+11290  U+B5FF  uniB5FF,  HANGUL SYLLABLE-B5FF
        0xB600, # G+11291  U+B600  uniB600,  HANGUL SYLLABLE-B600
        0xB601, # G+11292  U+B601  uniB601,  HANGUL SYLLABLE-B601
        0xB602, # G+11293  U+B602  uniB602,  HANGUL SYLLABLE-B602
        0xB603, # G+11294  U+B603  uniB603,  HANGUL SYLLABLE-B603
        0xB604, # G+11295  U+B604  uniB604,  HANGUL SYLLABLE-B604
        0xB605, # G+11296  U+B605  uniB605,  HANGUL SYLLABLE-B605
        0xB606, # G+11297  U+B606  uniB606,  HANGUL SYLLABLE-B606
        0xB607, # G+11298  U+B607  uniB607,  HANGUL SYLLABLE-B607
        0xB608, # G+11299  U+B608  uniB608,  HANGUL SYLLABLE-B608
        0xB609, # G+11300  U+B609  uniB609,  HANGUL SYLLABLE-B609
        0xB60A, # G+11301  U+B60A  uniB60A,  HANGUL SYLLABLE-B60A
        0xB60B, # G+11302  U+B60B  uniB60B,  HANGUL SYLLABLE-B60B
        0xB60C, # G+11303  U+B60C  uniB60C,  HANGUL SYLLABLE-B60C
        0xB60D, # G+11304  U+B60D  uniB60D,  HANGUL SYLLABLE-B60D
        0xB60E, # G+11305  U+B60E  uniB60E,  HANGUL SYLLABLE-B60E
        0xB60F, # G+11306  U+B60F  uniB60F,  HANGUL SYLLABLE-B60F
        0xB612, # G+11307  U+B612  uniB612,  HANGUL SYLLABLE-B612
        0xB613, # G+11308  U+B613  uniB613,  HANGUL SYLLABLE-B613
        0xB615, # G+11309  U+B615  uniB615,  HANGUL SYLLABLE-B615
        0xB616, # G+11310  U+B616  uniB616,  HANGUL SYLLABLE-B616
        0xB617, # G+11311  U+B617  uniB617,  HANGUL SYLLABLE-B617
        0xB619, # G+11312  U+B619  uniB619,  HANGUL SYLLABLE-B619
        0xB61A, # G+11313  U+B61A  uniB61A,  HANGUL SYLLABLE-B61A
        0xB61B, # G+11314  U+B61B  uniB61B,  HANGUL SYLLABLE-B61B
        0xB61C, # G+11315  U+B61C  uniB61C,  HANGUL SYLLABLE-B61C
        0xB61D, # G+11316  U+B61D  uniB61D,  HANGUL SYLLABLE-B61D
        0xB61E, # G+11317  U+B61E  uniB61E,  HANGUL SYLLABLE-B61E
        0xB61F, # G+11318  U+B61F  uniB61F,  HANGUL SYLLABLE-B61F
        0xB620, # G+11319  U+B620  uniB620,  HANGUL SYLLABLE-B620
        0xB621, # G+11320  U+B621  uniB621,  HANGUL SYLLABLE-B621
        0xB622, # G+11321  U+B622  uniB622,  HANGUL SYLLABLE-B622
        0xB623, # G+11322  U+B623  uniB623,  HANGUL SYLLABLE-B623
        0xB624, # G+11323  U+B624  uniB624,  HANGUL SYLLABLE-B624
        0xB626, # G+11324  U+B626  uniB626,  HANGUL SYLLABLE-B626
        0xB627, # G+11325  U+B627  uniB627,  HANGUL SYLLABLE-B627
        0xB628, # G+11326  U+B628  uniB628,  HANGUL SYLLABLE-B628
        0xB629, # G+11327  U+B629  uniB629,  HANGUL SYLLABLE-B629
        0xB62A, # G+11328  U+B62A  uniB62A,  HANGUL SYLLABLE-B62A
        0xB62B, # G+11329  U+B62B  uniB62B,  HANGUL SYLLABLE-B62B
        0xB62D, # G+11330  U+B62D  uniB62D,  HANGUL SYLLABLE-B62D
        0xB62E, # G+11331  U+B62E  uniB62E,  HANGUL SYLLABLE-B62E
        0xB62F, # G+11332  U+B62F  uniB62F,  HANGUL SYLLABLE-B62F
        0xB630, # G+11333  U+B630  uniB630,  HANGUL SYLLABLE-B630
        0xB631, # G+11334  U+B631  uniB631,  HANGUL SYLLABLE-B631
        0xB632, # G+11335  U+B632  uniB632,  HANGUL SYLLABLE-B632
        0xB633, # G+11336  U+B633  uniB633,  HANGUL SYLLABLE-B633
        0xB635, # G+11337  U+B635  uniB635,  HANGUL SYLLABLE-B635
        0xB636, # G+11338  U+B636  uniB636,  HANGUL SYLLABLE-B636
        0xB637, # G+11339  U+B637  uniB637,  HANGUL SYLLABLE-B637
        0xB638, # G+11340  U+B638  uniB638,  HANGUL SYLLABLE-B638
        0xB639, # G+11341  U+B639  uniB639,  HANGUL SYLLABLE-B639
        0xB63A, # G+11342  U+B63A  uniB63A,  HANGUL SYLLABLE-B63A
        0xB63B, # G+11343  U+B63B  uniB63B,  HANGUL SYLLABLE-B63B
        0xB63C, # G+11344  U+B63C  uniB63C,  HANGUL SYLLABLE-B63C
        0xB63D, # G+11345  U+B63D  uniB63D,  HANGUL SYLLABLE-B63D
        0xB63E, # G+11346  U+B63E  uniB63E,  HANGUL SYLLABLE-B63E
        0xB63F, # G+11347  U+B63F  uniB63F,  HANGUL SYLLABLE-B63F
        0xB640, # G+11348  U+B640  uniB640,  HANGUL SYLLABLE-B640
        0xB641, # G+11349  U+B641  uniB641,  HANGUL SYLLABLE-B641
        0xB642, # G+11350  U+B642  uniB642,  HANGUL SYLLABLE-B642
        0xB643, # G+11351  U+B643  uniB643,  HANGUL SYLLABLE-B643
        0xB644, # G+11352  U+B644  uniB644,  HANGUL SYLLABLE-B644
        0xB645, # G+11353  U+B645  uniB645,  HANGUL SYLLABLE-B645
        0xB646, # G+11354  U+B646  uniB646,  HANGUL SYLLABLE-B646
        0xB647, # G+11355  U+B647  uniB647,  HANGUL SYLLABLE-B647
        0xB649, # G+11356  U+B649  uniB649,  HANGUL SYLLABLE-B649
        0xB64A, # G+11357  U+B64A  uniB64A,  HANGUL SYLLABLE-B64A
        0xB64B, # G+11358  U+B64B  uniB64B,  HANGUL SYLLABLE-B64B
        0xB64C, # G+11359  U+B64C  uniB64C,  HANGUL SYLLABLE-B64C
        0xB64D, # G+11360  U+B64D  uniB64D,  HANGUL SYLLABLE-B64D
        0xB64E, # G+11361  U+B64E  uniB64E,  HANGUL SYLLABLE-B64E
        0xB64F, # G+11362  U+B64F  uniB64F,  HANGUL SYLLABLE-B64F
        0xB650, # G+11363  U+B650  uniB650,  HANGUL SYLLABLE-B650
        0xB651, # G+11364  U+B651  uniB651,  HANGUL SYLLABLE-B651
        0xB652, # G+11365  U+B652  uniB652,  HANGUL SYLLABLE-B652
        0xB653, # G+11366  U+B653  uniB653,  HANGUL SYLLABLE-B653
        0xB654, # G+11367  U+B654  uniB654,  HANGUL SYLLABLE-B654
        0xB655, # G+11368  U+B655  uniB655,  HANGUL SYLLABLE-B655
        0xB656, # G+11369  U+B656  uniB656,  HANGUL SYLLABLE-B656
        0xB657, # G+11370  U+B657  uniB657,  HANGUL SYLLABLE-B657
        0xB658, # G+11371  U+B658  uniB658,  HANGUL SYLLABLE-B658
        0xB659, # G+11372  U+B659  uniB659,  HANGUL SYLLABLE-B659
        0xB65A, # G+11373  U+B65A  uniB65A,  HANGUL SYLLABLE-B65A
        0xB65B, # G+11374  U+B65B  uniB65B,  HANGUL SYLLABLE-B65B
        0xB65C, # G+11375  U+B65C  uniB65C,  HANGUL SYLLABLE-B65C
        0xB65D, # G+11376  U+B65D  uniB65D,  HANGUL SYLLABLE-B65D
        0xB65E, # G+11377  U+B65E  uniB65E,  HANGUL SYLLABLE-B65E
        0xB65F, # G+11378  U+B65F  uniB65F,  HANGUL SYLLABLE-B65F
        0xB660, # G+11379  U+B660  uniB660,  HANGUL SYLLABLE-B660
        0xB661, # G+11380  U+B661  uniB661,  HANGUL SYLLABLE-B661
        0xB662, # G+11381  U+B662  uniB662,  HANGUL SYLLABLE-B662
        0xB663, # G+11382  U+B663  uniB663,  HANGUL SYLLABLE-B663
        0xB665, # G+11383  U+B665  uniB665,  HANGUL SYLLABLE-B665
        0xB666, # G+11384  U+B666  uniB666,  HANGUL SYLLABLE-B666
        0xB667, # G+11385  U+B667  uniB667,  HANGUL SYLLABLE-B667
        0xB669, # G+11386  U+B669  uniB669,  HANGUL SYLLABLE-B669
        0xB66A, # G+11387  U+B66A  uniB66A,  HANGUL SYLLABLE-B66A
        0xB66B, # G+11388  U+B66B  uniB66B,  HANGUL SYLLABLE-B66B
        0xB66C, # G+11389  U+B66C  uniB66C,  HANGUL SYLLABLE-B66C
        0xB66D, # G+11390  U+B66D  uniB66D,  HANGUL SYLLABLE-B66D
        0xB66E, # G+11391  U+B66E  uniB66E,  HANGUL SYLLABLE-B66E
        0xB66F, # G+11392  U+B66F  uniB66F,  HANGUL SYLLABLE-B66F
        0xB670, # G+11393  U+B670  uniB670,  HANGUL SYLLABLE-B670
        0xB671, # G+11394  U+B671  uniB671,  HANGUL SYLLABLE-B671
        0xB672, # G+11395  U+B672  uniB672,  HANGUL SYLLABLE-B672
        0xB673, # G+11396  U+B673  uniB673,  HANGUL SYLLABLE-B673
        0xB674, # G+11397  U+B674  uniB674,  HANGUL SYLLABLE-B674
        0xB675, # G+11398  U+B675  uniB675,  HANGUL SYLLABLE-B675
        0xB676, # G+11399  U+B676  uniB676,  HANGUL SYLLABLE-B676
        0xB677, # G+11400  U+B677  uniB677,  HANGUL SYLLABLE-B677
        0xB678, # G+11401  U+B678  uniB678,  HANGUL SYLLABLE-B678
        0xB679, # G+11402  U+B679  uniB679,  HANGUL SYLLABLE-B679
        0xB67A, # G+11403  U+B67A  uniB67A,  HANGUL SYLLABLE-B67A
        0xB67B, # G+11404  U+B67B  uniB67B,  HANGUL SYLLABLE-B67B
        0xB67C, # G+11405  U+B67C  uniB67C,  HANGUL SYLLABLE-B67C
        0xB67D, # G+11406  U+B67D  uniB67D,  HANGUL SYLLABLE-B67D
        0xB67E, # G+11407  U+B67E  uniB67E,  HANGUL SYLLABLE-B67E
        0xB67F, # G+11408  U+B67F  uniB67F,  HANGUL SYLLABLE-B67F
        0xB680, # G+11409  U+B680  uniB680,  HANGUL SYLLABLE-B680
        0xB681, # G+11410  U+B681  uniB681,  HANGUL SYLLABLE-B681
        0xB682, # G+11411  U+B682  uniB682,  HANGUL SYLLABLE-B682
        0xB683, # G+11412  U+B683  uniB683,  HANGUL SYLLABLE-B683
        0xB684, # G+11413  U+B684  uniB684,  HANGUL SYLLABLE-B684
        0xB685, # G+11414  U+B685  uniB685,  HANGUL SYLLABLE-B685
        0xB686, # G+11415  U+B686  uniB686,  HANGUL SYLLABLE-B686
        0xB687, # G+11416  U+B687  uniB687,  HANGUL SYLLABLE-B687
        0xB688, # G+11417  U+B688  uniB688,  HANGUL SYLLABLE-B688
        0xB689, # G+11418  U+B689  uniB689,  HANGUL SYLLABLE-B689
        0xB68A, # G+11419  U+B68A  uniB68A,  HANGUL SYLLABLE-B68A
        0xB68B, # G+11420  U+B68B  uniB68B,  HANGUL SYLLABLE-B68B
        0xB68C, # G+11421  U+B68C  uniB68C,  HANGUL SYLLABLE-B68C
        0xB68D, # G+11422  U+B68D  uniB68D,  HANGUL SYLLABLE-B68D
        0xB68E, # G+11423  U+B68E  uniB68E,  HANGUL SYLLABLE-B68E
        0xB68F, # G+11424  U+B68F  uniB68F,  HANGUL SYLLABLE-B68F
        0xB690, # G+11425  U+B690  uniB690,  HANGUL SYLLABLE-B690
        0xB691, # G+11426  U+B691  uniB691,  HANGUL SYLLABLE-B691
        0xB692, # G+11427  U+B692  uniB692,  HANGUL SYLLABLE-B692
        0xB693, # G+11428  U+B693  uniB693,  HANGUL SYLLABLE-B693
        0xB694, # G+11429  U+B694  uniB694,  HANGUL SYLLABLE-B694
        0xB695, # G+11430  U+B695  uniB695,  HANGUL SYLLABLE-B695
        0xB696, # G+11431  U+B696  uniB696,  HANGUL SYLLABLE-B696
        0xB697, # G+11432  U+B697  uniB697,  HANGUL SYLLABLE-B697
        0xB698, # G+11433  U+B698  uniB698,  HANGUL SYLLABLE-B698
        0xB699, # G+11434  U+B699  uniB699,  HANGUL SYLLABLE-B699
        0xB69A, # G+11435  U+B69A  uniB69A,  HANGUL SYLLABLE-B69A
        0xB69B, # G+11436  U+B69B  uniB69B,  HANGUL SYLLABLE-B69B
        0xB69E, # G+11437  U+B69E  uniB69E,  HANGUL SYLLABLE-B69E
        0xB69F, # G+11438  U+B69F  uniB69F,  HANGUL SYLLABLE-B69F
        0xB6A1, # G+11439  U+B6A1  uniB6A1,  HANGUL SYLLABLE-B6A1
        0xB6A2, # G+11440  U+B6A2  uniB6A2,  HANGUL SYLLABLE-B6A2
        0xB6A3, # G+11441  U+B6A3  uniB6A3,  HANGUL SYLLABLE-B6A3
        0xB6A5, # G+11442  U+B6A5  uniB6A5,  HANGUL SYLLABLE-B6A5
        0xB6A6, # G+11443  U+B6A6  uniB6A6,  HANGUL SYLLABLE-B6A6
        0xB6A7, # G+11444  U+B6A7  uniB6A7,  HANGUL SYLLABLE-B6A7
        0xB6A8, # G+11445  U+B6A8  uniB6A8,  HANGUL SYLLABLE-B6A8
        0xB6A9, # G+11446  U+B6A9  uniB6A9,  HANGUL SYLLABLE-B6A9
        0xB6AA, # G+11447  U+B6AA  uniB6AA,  HANGUL SYLLABLE-B6AA
        0xB6AD, # G+11448  U+B6AD  uniB6AD,  HANGUL SYLLABLE-B6AD
        0xB6AE, # G+11449  U+B6AE  uniB6AE,  HANGUL SYLLABLE-B6AE
        0xB6AF, # G+11450  U+B6AF  uniB6AF,  HANGUL SYLLABLE-B6AF
        0xB6B0, # G+11451  U+B6B0  uniB6B0,  HANGUL SYLLABLE-B6B0
        0xB6B2, # G+11452  U+B6B2  uniB6B2,  HANGUL SYLLABLE-B6B2
        0xB6B3, # G+11453  U+B6B3  uniB6B3,  HANGUL SYLLABLE-B6B3
        0xB6B4, # G+11454  U+B6B4  uniB6B4,  HANGUL SYLLABLE-B6B4
        0xB6B5, # G+11455  U+B6B5  uniB6B5,  HANGUL SYLLABLE-B6B5
        0xB6B6, # G+11456  U+B6B6  uniB6B6,  HANGUL SYLLABLE-B6B6
        0xB6B7, # G+11457  U+B6B7  uniB6B7,  HANGUL SYLLABLE-B6B7
        0xB6B8, # G+11458  U+B6B8  uniB6B8,  HANGUL SYLLABLE-B6B8
        0xB6B9, # G+11459  U+B6B9  uniB6B9,  HANGUL SYLLABLE-B6B9
        0xB6BA, # G+11460  U+B6BA  uniB6BA,  HANGUL SYLLABLE-B6BA
        0xB6BB, # G+11461  U+B6BB  uniB6BB,  HANGUL SYLLABLE-B6BB
        0xB6BC, # G+11462  U+B6BC  uniB6BC,  HANGUL SYLLABLE-B6BC
        0xB6BD, # G+11463  U+B6BD  uniB6BD,  HANGUL SYLLABLE-B6BD
        0xB6BE, # G+11464  U+B6BE  uniB6BE,  HANGUL SYLLABLE-B6BE
        0xB6BF, # G+11465  U+B6BF  uniB6BF,  HANGUL SYLLABLE-B6BF
        0xB6C0, # G+11466  U+B6C0  uniB6C0,  HANGUL SYLLABLE-B6C0
        0xB6C1, # G+11467  U+B6C1  uniB6C1,  HANGUL SYLLABLE-B6C1
        0xB6C2, # G+11468  U+B6C2  uniB6C2,  HANGUL SYLLABLE-B6C2
        0xB6C3, # G+11469  U+B6C3  uniB6C3,  HANGUL SYLLABLE-B6C3
        0xB6C4, # G+11470  U+B6C4  uniB6C4,  HANGUL SYLLABLE-B6C4
        0xB6C5, # G+11471  U+B6C5  uniB6C5,  HANGUL SYLLABLE-B6C5
        0xB6C6, # G+11472  U+B6C6  uniB6C6,  HANGUL SYLLABLE-B6C6
        0xB6C7, # G+11473  U+B6C7  uniB6C7,  HANGUL SYLLABLE-B6C7
        0xB6C8, # G+11474  U+B6C8  uniB6C8,  HANGUL SYLLABLE-B6C8
        0xB6C9, # G+11475  U+B6C9  uniB6C9,  HANGUL SYLLABLE-B6C9
        0xB6CA, # G+11476  U+B6CA  uniB6CA,  HANGUL SYLLABLE-B6CA
        0xB6CB, # G+11477  U+B6CB  uniB6CB,  HANGUL SYLLABLE-B6CB
        0xB6CC, # G+11478  U+B6CC  uniB6CC,  HANGUL SYLLABLE-B6CC
        0xB6CD, # G+11479  U+B6CD  uniB6CD,  HANGUL SYLLABLE-B6CD
        0xB6CE, # G+11480  U+B6CE  uniB6CE,  HANGUL SYLLABLE-B6CE
        0xB6CF, # G+11481  U+B6CF  uniB6CF,  HANGUL SYLLABLE-B6CF
        0xB6D0, # G+11482  U+B6D0  uniB6D0,  HANGUL SYLLABLE-B6D0
        0xB6D1, # G+11483  U+B6D1  uniB6D1,  HANGUL SYLLABLE-B6D1
        0xB6D2, # G+11484  U+B6D2  uniB6D2,  HANGUL SYLLABLE-B6D2
        0xB6D3, # G+11485  U+B6D3  uniB6D3,  HANGUL SYLLABLE-B6D3
        0xB6D5, # G+11486  U+B6D5  uniB6D5,  HANGUL SYLLABLE-B6D5
        0xB6D6, # G+11487  U+B6D6  uniB6D6,  HANGUL SYLLABLE-B6D6
        0xB6D7, # G+11488  U+B6D7  uniB6D7,  HANGUL SYLLABLE-B6D7
        0xB6D8, # G+11489  U+B6D8  uniB6D8,  HANGUL SYLLABLE-B6D8
        0xB6D9, # G+11490  U+B6D9  uniB6D9,  HANGUL SYLLABLE-B6D9
        0xB6DA, # G+11491  U+B6DA  uniB6DA,  HANGUL SYLLABLE-B6DA
        0xB6DB, # G+11492  U+B6DB  uniB6DB,  HANGUL SYLLABLE-B6DB
        0xB6DC, # G+11493  U+B6DC  uniB6DC,  HANGUL SYLLABLE-B6DC
        0xB6DD, # G+11494  U+B6DD  uniB6DD,  HANGUL SYLLABLE-B6DD
        0xB6DE, # G+11495  U+B6DE  uniB6DE,  HANGUL SYLLABLE-B6DE
        0xB6DF, # G+11496  U+B6DF  uniB6DF,  HANGUL SYLLABLE-B6DF
        0xB6E0, # G+11497  U+B6E0  uniB6E0,  HANGUL SYLLABLE-B6E0
        0xB6E1, # G+11498  U+B6E1  uniB6E1,  HANGUL SYLLABLE-B6E1
        0xB6E2, # G+11499  U+B6E2  uniB6E2,  HANGUL SYLLABLE-B6E2
        0xB6E3, # G+11500  U+B6E3  uniB6E3,  HANGUL SYLLABLE-B6E3
        0xB6E4, # G+11501  U+B6E4  uniB6E4,  HANGUL SYLLABLE-B6E4
        0xB6E5, # G+11502  U+B6E5  uniB6E5,  HANGUL SYLLABLE-B6E5
        0xB6E6, # G+11503  U+B6E6  uniB6E6,  HANGUL SYLLABLE-B6E6
        0xB6E7, # G+11504  U+B6E7  uniB6E7,  HANGUL SYLLABLE-B6E7
        0xB6E8, # G+11505  U+B6E8  uniB6E8,  HANGUL SYLLABLE-B6E8
        0xB6E9, # G+11506  U+B6E9  uniB6E9,  HANGUL SYLLABLE-B6E9
        0xB6EA, # G+11507  U+B6EA  uniB6EA,  HANGUL SYLLABLE-B6EA
        0xB6EB, # G+11508  U+B6EB  uniB6EB,  HANGUL SYLLABLE-B6EB
        0xB6EC, # G+11509  U+B6EC  uniB6EC,  HANGUL SYLLABLE-B6EC
        0xB6ED, # G+11510  U+B6ED  uniB6ED,  HANGUL SYLLABLE-B6ED
        0xB6EE, # G+11511  U+B6EE  uniB6EE,  HANGUL SYLLABLE-B6EE
        0xB6EF, # G+11512  U+B6EF  uniB6EF,  HANGUL SYLLABLE-B6EF
        0xB6F1, # G+11513  U+B6F1  uniB6F1,  HANGUL SYLLABLE-B6F1
        0xB6F2, # G+11514  U+B6F2  uniB6F2,  HANGUL SYLLABLE-B6F2
        0xB6F3, # G+11515  U+B6F3  uniB6F3,  HANGUL SYLLABLE-B6F3
        0xB6F5, # G+11516  U+B6F5  uniB6F5,  HANGUL SYLLABLE-B6F5
        0xB6F6, # G+11517  U+B6F6  uniB6F6,  HANGUL SYLLABLE-B6F6
        0xB6F7, # G+11518  U+B6F7  uniB6F7,  HANGUL SYLLABLE-B6F7
        0xB6F9, # G+11519  U+B6F9  uniB6F9,  HANGUL SYLLABLE-B6F9
        0xB6FA, # G+11520  U+B6FA  uniB6FA,  HANGUL SYLLABLE-B6FA
        0xB6FB, # G+11521  U+B6FB  uniB6FB,  HANGUL SYLLABLE-B6FB
        0xB6FC, # G+11522  U+B6FC  uniB6FC,  HANGUL SYLLABLE-B6FC
        0xB6FD, # G+11523  U+B6FD  uniB6FD,  HANGUL SYLLABLE-B6FD
        0xB6FE, # G+11524  U+B6FE  uniB6FE,  HANGUL SYLLABLE-B6FE
        0xB6FF, # G+11525  U+B6FF  uniB6FF,  HANGUL SYLLABLE-B6FF
        0xB702, # G+11526  U+B702  uniB702,  HANGUL SYLLABLE-B702
        0xB703, # G+11527  U+B703  uniB703,  HANGUL SYLLABLE-B703
        0xB704, # G+11528  U+B704  uniB704,  HANGUL SYLLABLE-B704
        0xB706, # G+11529  U+B706  uniB706,  HANGUL SYLLABLE-B706
        0xB707, # G+11530  U+B707  uniB707,  HANGUL SYLLABLE-B707
        0xB708, # G+11531  U+B708  uniB708,  HANGUL SYLLABLE-B708
        0xB709, # G+11532  U+B709  uniB709,  HANGUL SYLLABLE-B709
        0xB70A, # G+11533  U+B70A  uniB70A,  HANGUL SYLLABLE-B70A
        0xB70B, # G+11534  U+B70B  uniB70B,  HANGUL SYLLABLE-B70B
        0xB70C, # G+11535  U+B70C  uniB70C,  HANGUL SYLLABLE-B70C
        0xB70D, # G+11536  U+B70D  uniB70D,  HANGUL SYLLABLE-B70D
        0xB70E, # G+11537  U+B70E  uniB70E,  HANGUL SYLLABLE-B70E
        0xB70F, # G+11538  U+B70F  uniB70F,  HANGUL SYLLABLE-B70F
        0xB710, # G+11539  U+B710  uniB710,  HANGUL SYLLABLE-B710
        0xB711, # G+11540  U+B711  uniB711,  HANGUL SYLLABLE-B711
        0xB712, # G+11541  U+B712  uniB712,  HANGUL SYLLABLE-B712
        0xB713, # G+11542  U+B713  uniB713,  HANGUL SYLLABLE-B713
        0xB714, # G+11543  U+B714  uniB714,  HANGUL SYLLABLE-B714
        0xB715, # G+11544  U+B715  uniB715,  HANGUL SYLLABLE-B715
        0xB716, # G+11545  U+B716  uniB716,  HANGUL SYLLABLE-B716
        0xB717, # G+11546  U+B717  uniB717,  HANGUL SYLLABLE-B717
        0xB718, # G+11547  U+B718  uniB718,  HANGUL SYLLABLE-B718
        0xB719, # G+11548  U+B719  uniB719,  HANGUL SYLLABLE-B719
        0xB71A, # G+11549  U+B71A  uniB71A,  HANGUL SYLLABLE-B71A
        0xB71B, # G+11550  U+B71B  uniB71B,  HANGUL SYLLABLE-B71B
        0xB71C, # G+11551  U+B71C  uniB71C,  HANGUL SYLLABLE-B71C
        0xB71D, # G+11552  U+B71D  uniB71D,  HANGUL SYLLABLE-B71D
        0xB71E, # G+11553  U+B71E  uniB71E,  HANGUL SYLLABLE-B71E
        0xB71F, # G+11554  U+B71F  uniB71F,  HANGUL SYLLABLE-B71F
        0xB720, # G+11555  U+B720  uniB720,  HANGUL SYLLABLE-B720
        0xB721, # G+11556  U+B721  uniB721,  HANGUL SYLLABLE-B721
        0xB722, # G+11557  U+B722  uniB722,  HANGUL SYLLABLE-B722
        0xB723, # G+11558  U+B723  uniB723,  HANGUL SYLLABLE-B723
        0xB724, # G+11559  U+B724  uniB724,  HANGUL SYLLABLE-B724
        0xB725, # G+11560  U+B725  uniB725,  HANGUL SYLLABLE-B725
        0xB726, # G+11561  U+B726  uniB726,  HANGUL SYLLABLE-B726
        0xB727, # G+11562  U+B727  uniB727,  HANGUL SYLLABLE-B727
        0xB72A, # G+11563  U+B72A  uniB72A,  HANGUL SYLLABLE-B72A
        0xB72B, # G+11564  U+B72B  uniB72B,  HANGUL SYLLABLE-B72B
        0xB72D, # G+11565  U+B72D  uniB72D,  HANGUL SYLLABLE-B72D
        0xB72E, # G+11566  U+B72E  uniB72E,  HANGUL SYLLABLE-B72E
        0xB731, # G+11567  U+B731  uniB731,  HANGUL SYLLABLE-B731
        0xB732, # G+11568  U+B732  uniB732,  HANGUL SYLLABLE-B732
        0xB733, # G+11569  U+B733  uniB733,  HANGUL SYLLABLE-B733
        0xB734, # G+11570  U+B734  uniB734,  HANGUL SYLLABLE-B734
        0xB735, # G+11571  U+B735  uniB735,  HANGUL SYLLABLE-B735
        0xB736, # G+11572  U+B736  uniB736,  HANGUL SYLLABLE-B736
        0xB737, # G+11573  U+B737  uniB737,  HANGUL SYLLABLE-B737
        0xB73A, # G+11574  U+B73A  uniB73A,  HANGUL SYLLABLE-B73A
        0xB73C, # G+11575  U+B73C  uniB73C,  HANGUL SYLLABLE-B73C
        0xB73D, # G+11576  U+B73D  uniB73D,  HANGUL SYLLABLE-B73D
        0xB73E, # G+11577  U+B73E  uniB73E,  HANGUL SYLLABLE-B73E
        0xB73F, # G+11578  U+B73F  uniB73F,  HANGUL SYLLABLE-B73F
        0xB740, # G+11579  U+B740  uniB740,  HANGUL SYLLABLE-B740
        0xB741, # G+11580  U+B741  uniB741,  HANGUL SYLLABLE-B741
        0xB742, # G+11581  U+B742  uniB742,  HANGUL SYLLABLE-B742
        0xB743, # G+11582  U+B743  uniB743,  HANGUL SYLLABLE-B743
        0xB745, # G+11583  U+B745  uniB745,  HANGUL SYLLABLE-B745
        0xB746, # G+11584  U+B746  uniB746,  HANGUL SYLLABLE-B746
        0xB747, # G+11585  U+B747  uniB747,  HANGUL SYLLABLE-B747
        0xB749, # G+11586  U+B749  uniB749,  HANGUL SYLLABLE-B749
        0xB74A, # G+11587  U+B74A  uniB74A,  HANGUL SYLLABLE-B74A
        0xB74B, # G+11588  U+B74B  uniB74B,  HANGUL SYLLABLE-B74B
        0xB74D, # G+11589  U+B74D  uniB74D,  HANGUL SYLLABLE-B74D
        0xB74E, # G+11590  U+B74E  uniB74E,  HANGUL SYLLABLE-B74E
        0xB74F, # G+11591  U+B74F  uniB74F,  HANGUL SYLLABLE-B74F
        0xB750, # G+11592  U+B750  uniB750,  HANGUL SYLLABLE-B750
        0xB751, # G+11593  U+B751  uniB751,  HANGUL SYLLABLE-B751
        0xB752, # G+11594  U+B752  uniB752,  HANGUL SYLLABLE-B752
        0xB753, # G+11595  U+B753  uniB753,  HANGUL SYLLABLE-B753
        0xB756, # G+11596  U+B756  uniB756,  HANGUL SYLLABLE-B756
        0xB757, # G+11597  U+B757  uniB757,  HANGUL SYLLABLE-B757
        0xB758, # G+11598  U+B758  uniB758,  HANGUL SYLLABLE-B758
        0xB759, # G+11599  U+B759  uniB759,  HANGUL SYLLABLE-B759
        0xB75A, # G+11600  U+B75A  uniB75A,  HANGUL SYLLABLE-B75A
        0xB75B, # G+11601  U+B75B  uniB75B,  HANGUL SYLLABLE-B75B
        0xB75C, # G+11602  U+B75C  uniB75C,  HANGUL SYLLABLE-B75C
        0xB75D, # G+11603  U+B75D  uniB75D,  HANGUL SYLLABLE-B75D
        0xB75E, # G+11604  U+B75E  uniB75E,  HANGUL SYLLABLE-B75E
        0xB75F, # G+11605  U+B75F  uniB75F,  HANGUL SYLLABLE-B75F
        0xB761, # G+11606  U+B761  uniB761,  HANGUL SYLLABLE-B761
        0xB762, # G+11607  U+B762  uniB762,  HANGUL SYLLABLE-B762
        0xB763, # G+11608  U+B763  uniB763,  HANGUL SYLLABLE-B763
        0xB765, # G+11609  U+B765  uniB765,  HANGUL SYLLABLE-B765
        0xB766, # G+11610  U+B766  uniB766,  HANGUL SYLLABLE-B766
        0xB767, # G+11611  U+B767  uniB767,  HANGUL SYLLABLE-B767
        0xB769, # G+11612  U+B769  uniB769,  HANGUL SYLLABLE-B769
        0xB76A, # G+11613  U+B76A  uniB76A,  HANGUL SYLLABLE-B76A
        0xB76B, # G+11614  U+B76B  uniB76B,  HANGUL SYLLABLE-B76B
        0xB76C, # G+11615  U+B76C  uniB76C,  HANGUL SYLLABLE-B76C
        0xB76D, # G+11616  U+B76D  uniB76D,  HANGUL SYLLABLE-B76D
        0xB76E, # G+11617  U+B76E  uniB76E,  HANGUL SYLLABLE-B76E
        0xB76F, # G+11618  U+B76F  uniB76F,  HANGUL SYLLABLE-B76F
        0xB772, # G+11619  U+B772  uniB772,  HANGUL SYLLABLE-B772
        0xB774, # G+11620  U+B774  uniB774,  HANGUL SYLLABLE-B774
        0xB776, # G+11621  U+B776  uniB776,  HANGUL SYLLABLE-B776
        0xB777, # G+11622  U+B777  uniB777,  HANGUL SYLLABLE-B777
        0xB778, # G+11623  U+B778  uniB778,  HANGUL SYLLABLE-B778
        0xB779, # G+11624  U+B779  uniB779,  HANGUL SYLLABLE-B779
        0xB77A, # G+11625  U+B77A  uniB77A,  HANGUL SYLLABLE-B77A
        0xB77B, # G+11626  U+B77B  uniB77B,  HANGUL SYLLABLE-B77B
        0xB77E, # G+11627  U+B77E  uniB77E,  HANGUL SYLLABLE-B77E
        0xB77F, # G+11628  U+B77F  uniB77F,  HANGUL SYLLABLE-B77F
        0xB781, # G+11629  U+B781  uniB781,  HANGUL SYLLABLE-B781
        0xB782, # G+11630  U+B782  uniB782,  HANGUL SYLLABLE-B782
        0xB783, # G+11631  U+B783  uniB783,  HANGUL SYLLABLE-B783
        0xB785, # G+11632  U+B785  uniB785,  HANGUL SYLLABLE-B785
        0xB786, # G+11633  U+B786  uniB786,  HANGUL SYLLABLE-B786
        0xB787, # G+11634  U+B787  uniB787,  HANGUL SYLLABLE-B787
        0xB788, # G+11635  U+B788  uniB788,  HANGUL SYLLABLE-B788
        0xB789, # G+11636  U+B789  uniB789,  HANGUL SYLLABLE-B789
        0xB78A, # G+11637  U+B78A  uniB78A,  HANGUL SYLLABLE-B78A
        0xB78B, # G+11638  U+B78B  uniB78B,  HANGUL SYLLABLE-B78B
        0xB78E, # G+11639  U+B78E  uniB78E,  HANGUL SYLLABLE-B78E
        0xB793, # G+11640  U+B793  uniB793,  HANGUL SYLLABLE-B793
        0xB794, # G+11641  U+B794  uniB794,  HANGUL SYLLABLE-B794
        0xB795, # G+11642  U+B795  uniB795,  HANGUL SYLLABLE-B795
        0xB79A, # G+11643  U+B79A  uniB79A,  HANGUL SYLLABLE-B79A
        0xB79B, # G+11644  U+B79B  uniB79B,  HANGUL SYLLABLE-B79B
        0xB79D, # G+11645  U+B79D  uniB79D,  HANGUL SYLLABLE-B79D
        0xB79E, # G+11646  U+B79E  uniB79E,  HANGUL SYLLABLE-B79E
        0xB79F, # G+11647  U+B79F  uniB79F,  HANGUL SYLLABLE-B79F
        0xB7A1, # G+11648  U+B7A1  uniB7A1,  HANGUL SYLLABLE-B7A1
        0xB7A2, # G+11649  U+B7A2  uniB7A2,  HANGUL SYLLABLE-B7A2
        0xB7A3, # G+11650  U+B7A3  uniB7A3,  HANGUL SYLLABLE-B7A3
        0xB7A4, # G+11651  U+B7A4  uniB7A4,  HANGUL SYLLABLE-B7A4
        0xB7A5, # G+11652  U+B7A5  uniB7A5,  HANGUL SYLLABLE-B7A5
        0xB7A6, # G+11653  U+B7A6  uniB7A6,  HANGUL SYLLABLE-B7A6
        0xB7A7, # G+11654  U+B7A7  uniB7A7,  HANGUL SYLLABLE-B7A7
        0xB7AA, # G+11655  U+B7AA  uniB7AA,  HANGUL SYLLABLE-B7AA
        0xB7AE, # G+11656  U+B7AE  uniB7AE,  HANGUL SYLLABLE-B7AE
        0xB7AF, # G+11657  U+B7AF  uniB7AF,  HANGUL SYLLABLE-B7AF
        0xB7B0, # G+11658  U+B7B0  uniB7B0,  HANGUL SYLLABLE-B7B0
        0xB7B1, # G+11659  U+B7B1  uniB7B1,  HANGUL SYLLABLE-B7B1
        0xB7B2, # G+11660  U+B7B2  uniB7B2,  HANGUL SYLLABLE-B7B2
        0xB7B3, # G+11661  U+B7B3  uniB7B3,  HANGUL SYLLABLE-B7B3
        0xB7B6, # G+11662  U+B7B6  uniB7B6,  HANGUL SYLLABLE-B7B6
        0xB7B7, # G+11663  U+B7B7  uniB7B7,  HANGUL SYLLABLE-B7B7
        0xB7B9, # G+11664  U+B7B9  uniB7B9,  HANGUL SYLLABLE-B7B9
        0xB7BA, # G+11665  U+B7BA  uniB7BA,  HANGUL SYLLABLE-B7BA
        0xB7BB, # G+11666  U+B7BB  uniB7BB,  HANGUL SYLLABLE-B7BB
        0xB7BC, # G+11667  U+B7BC  uniB7BC,  HANGUL SYLLABLE-B7BC
        0xB7BD, # G+11668  U+B7BD  uniB7BD,  HANGUL SYLLABLE-B7BD
        0xB7BE, # G+11669  U+B7BE  uniB7BE,  HANGUL SYLLABLE-B7BE
        0xB7BF, # G+11670  U+B7BF  uniB7BF,  HANGUL SYLLABLE-B7BF
        0xB7C0, # G+11671  U+B7C0  uniB7C0,  HANGUL SYLLABLE-B7C0
        0xB7C1, # G+11672  U+B7C1  uniB7C1,  HANGUL SYLLABLE-B7C1
        0xB7C2, # G+11673  U+B7C2  uniB7C2,  HANGUL SYLLABLE-B7C2
        0xB7C3, # G+11674  U+B7C3  uniB7C3,  HANGUL SYLLABLE-B7C3
        0xB7C4, # G+11675  U+B7C4  uniB7C4,  HANGUL SYLLABLE-B7C4
        0xB7C5, # G+11676  U+B7C5  uniB7C5,  HANGUL SYLLABLE-B7C5
        0xB7C6, # G+11677  U+B7C6  uniB7C6,  HANGUL SYLLABLE-B7C6
        0xB7C8, # G+11678  U+B7C8  uniB7C8,  HANGUL SYLLABLE-B7C8
        0xB7CA, # G+11679  U+B7CA  uniB7CA,  HANGUL SYLLABLE-B7CA
        0xB7CB, # G+11680  U+B7CB  uniB7CB,  HANGUL SYLLABLE-B7CB
        0xB7CC, # G+11681  U+B7CC  uniB7CC,  HANGUL SYLLABLE-B7CC
        0xB7CD, # G+11682  U+B7CD  uniB7CD,  HANGUL SYLLABLE-B7CD
        0xB7CE, # G+11683  U+B7CE  uniB7CE,  HANGUL SYLLABLE-B7CE
        0xB7CF, # G+11684  U+B7CF  uniB7CF,  HANGUL SYLLABLE-B7CF
        0xB7D0, # G+11685  U+B7D0  uniB7D0,  HANGUL SYLLABLE-B7D0
        0xB7D1, # G+11686  U+B7D1  uniB7D1,  HANGUL SYLLABLE-B7D1
        0xB7D2, # G+11687  U+B7D2  uniB7D2,  HANGUL SYLLABLE-B7D2
        0xB7D3, # G+11688  U+B7D3  uniB7D3,  HANGUL SYLLABLE-B7D3
        0xB7D4, # G+11689  U+B7D4  uniB7D4,  HANGUL SYLLABLE-B7D4
        0xB7D5, # G+11690  U+B7D5  uniB7D5,  HANGUL SYLLABLE-B7D5
        0xB7D6, # G+11691  U+B7D6  uniB7D6,  HANGUL SYLLABLE-B7D6
        0xB7D7, # G+11692  U+B7D7  uniB7D7,  HANGUL SYLLABLE-B7D7
        0xB7D8, # G+11693  U+B7D8  uniB7D8,  HANGUL SYLLABLE-B7D8
        0xB7D9, # G+11694  U+B7D9  uniB7D9,  HANGUL SYLLABLE-B7D9
        0xB7DA, # G+11695  U+B7DA  uniB7DA,  HANGUL SYLLABLE-B7DA
        0xB7DB, # G+11696  U+B7DB  uniB7DB,  HANGUL SYLLABLE-B7DB
        0xB7DC, # G+11697  U+B7DC  uniB7DC,  HANGUL SYLLABLE-B7DC
        0xB7DD, # G+11698  U+B7DD  uniB7DD,  HANGUL SYLLABLE-B7DD
        0xB7DE, # G+11699  U+B7DE  uniB7DE,  HANGUL SYLLABLE-B7DE
        0xB7DF, # G+11700  U+B7DF  uniB7DF,  HANGUL SYLLABLE-B7DF
        0xB7E0, # G+11701  U+B7E0  uniB7E0,  HANGUL SYLLABLE-B7E0
        0xB7E1, # G+11702  U+B7E1  uniB7E1,  HANGUL SYLLABLE-B7E1
        0xB7E2, # G+11703  U+B7E2  uniB7E2,  HANGUL SYLLABLE-B7E2
        0xB7E3, # G+11704  U+B7E3  uniB7E3,  HANGUL SYLLABLE-B7E3
        0xB7E4, # G+11705  U+B7E4  uniB7E4,  HANGUL SYLLABLE-B7E4
        0xB7E5, # G+11706  U+B7E5  uniB7E5,  HANGUL SYLLABLE-B7E5
        0xB7E6, # G+11707  U+B7E6  uniB7E6,  HANGUL SYLLABLE-B7E6
        0xB7E7, # G+11708  U+B7E7  uniB7E7,  HANGUL SYLLABLE-B7E7
        0xB7E8, # G+11709  U+B7E8  uniB7E8,  HANGUL SYLLABLE-B7E8
        0xB7E9, # G+11710  U+B7E9  uniB7E9,  HANGUL SYLLABLE-B7E9
        0xB7EA, # G+11711  U+B7EA  uniB7EA,  HANGUL SYLLABLE-B7EA
        0xB7EB, # G+11712  U+B7EB  uniB7EB,  HANGUL SYLLABLE-B7EB
        0xB7EE, # G+11713  U+B7EE  uniB7EE,  HANGUL SYLLABLE-B7EE
        0xB7EF, # G+11714  U+B7EF  uniB7EF,  HANGUL SYLLABLE-B7EF
        0xB7F1, # G+11715  U+B7F1  uniB7F1,  HANGUL SYLLABLE-B7F1
        0xB7F2, # G+11716  U+B7F2  uniB7F2,  HANGUL SYLLABLE-B7F2
        0xB7F3, # G+11717  U+B7F3  uniB7F3,  HANGUL SYLLABLE-B7F3
        0xB7F5, # G+11718  U+B7F5  uniB7F5,  HANGUL SYLLABLE-B7F5
        0xB7F6, # G+11719  U+B7F6  uniB7F6,  HANGUL SYLLABLE-B7F6
        0xB7F7, # G+11720  U+B7F7  uniB7F7,  HANGUL SYLLABLE-B7F7
        0xB7F8, # G+11721  U+B7F8  uniB7F8,  HANGUL SYLLABLE-B7F8
        0xB7F9, # G+11722  U+B7F9  uniB7F9,  HANGUL SYLLABLE-B7F9
        0xB7FA, # G+11723  U+B7FA  uniB7FA,  HANGUL SYLLABLE-B7FA
        0xB7FB, # G+11724  U+B7FB  uniB7FB,  HANGUL SYLLABLE-B7FB
        0xB7FE, # G+11725  U+B7FE  uniB7FE,  HANGUL SYLLABLE-B7FE
        0xB802, # G+11726  U+B802  uniB802,  HANGUL SYLLABLE-B802
        0xB803, # G+11727  U+B803  uniB803,  HANGUL SYLLABLE-B803
        0xB804, # G+11728  U+B804  uniB804,  HANGUL SYLLABLE-B804
        0xB805, # G+11729  U+B805  uniB805,  HANGUL SYLLABLE-B805
        0xB806, # G+11730  U+B806  uniB806,  HANGUL SYLLABLE-B806
        0xB80A, # G+11731  U+B80A  uniB80A,  HANGUL SYLLABLE-B80A
        0xB80B, # G+11732  U+B80B  uniB80B,  HANGUL SYLLABLE-B80B
        0xB80D, # G+11733  U+B80D  uniB80D,  HANGUL SYLLABLE-B80D
        0xB80E, # G+11734  U+B80E  uniB80E,  HANGUL SYLLABLE-B80E
        0xB80F, # G+11735  U+B80F  uniB80F,  HANGUL SYLLABLE-B80F
        0xB811, # G+11736  U+B811  uniB811,  HANGUL SYLLABLE-B811
        0xB812, # G+11737  U+B812  uniB812,  HANGUL SYLLABLE-B812
        0xB813, # G+11738  U+B813  uniB813,  HANGUL SYLLABLE-B813
        0xB814, # G+11739  U+B814  uniB814,  HANGUL SYLLABLE-B814
        0xB815, # G+11740  U+B815  uniB815,  HANGUL SYLLABLE-B815
        0xB816, # G+11741  U+B816  uniB816,  HANGUL SYLLABLE-B816
        0xB817, # G+11742  U+B817  uniB817,  HANGUL SYLLABLE-B817
        0xB81A, # G+11743  U+B81A  uniB81A,  HANGUL SYLLABLE-B81A
        0xB81C, # G+11744  U+B81C  uniB81C,  HANGUL SYLLABLE-B81C
        0xB81E, # G+11745  U+B81E  uniB81E,  HANGUL SYLLABLE-B81E
        0xB81F, # G+11746  U+B81F  uniB81F,  HANGUL SYLLABLE-B81F
        0xB820, # G+11747  U+B820  uniB820,  HANGUL SYLLABLE-B820
        0xB821, # G+11748  U+B821  uniB821,  HANGUL SYLLABLE-B821
        0xB822, # G+11749  U+B822  uniB822,  HANGUL SYLLABLE-B822
        0xB823, # G+11750  U+B823  uniB823,  HANGUL SYLLABLE-B823
        0xB826, # G+11751  U+B826  uniB826,  HANGUL SYLLABLE-B826
        0xB827, # G+11752  U+B827  uniB827,  HANGUL SYLLABLE-B827
        0xB829, # G+11753  U+B829  uniB829,  HANGUL SYLLABLE-B829
        0xB82A, # G+11754  U+B82A  uniB82A,  HANGUL SYLLABLE-B82A
        0xB82B, # G+11755  U+B82B  uniB82B,  HANGUL SYLLABLE-B82B
        0xB82D, # G+11756  U+B82D  uniB82D,  HANGUL SYLLABLE-B82D
        0xB82E, # G+11757  U+B82E  uniB82E,  HANGUL SYLLABLE-B82E
        0xB82F, # G+11758  U+B82F  uniB82F,  HANGUL SYLLABLE-B82F
        0xB830, # G+11759  U+B830  uniB830,  HANGUL SYLLABLE-B830
        0xB831, # G+11760  U+B831  uniB831,  HANGUL SYLLABLE-B831
        0xB832, # G+11761  U+B832  uniB832,  HANGUL SYLLABLE-B832
        0xB833, # G+11762  U+B833  uniB833,  HANGUL SYLLABLE-B833
        0xB836, # G+11763  U+B836  uniB836,  HANGUL SYLLABLE-B836
        0xB83A, # G+11764  U+B83A  uniB83A,  HANGUL SYLLABLE-B83A
        0xB83B, # G+11765  U+B83B  uniB83B,  HANGUL SYLLABLE-B83B
        0xB83C, # G+11766  U+B83C  uniB83C,  HANGUL SYLLABLE-B83C
        0xB83D, # G+11767  U+B83D  uniB83D,  HANGUL SYLLABLE-B83D
        0xB83E, # G+11768  U+B83E  uniB83E,  HANGUL SYLLABLE-B83E
        0xB83F, # G+11769  U+B83F  uniB83F,  HANGUL SYLLABLE-B83F
        0xB841, # G+11770  U+B841  uniB841,  HANGUL SYLLABLE-B841
        0xB842, # G+11771  U+B842  uniB842,  HANGUL SYLLABLE-B842
        0xB843, # G+11772  U+B843  uniB843,  HANGUL SYLLABLE-B843
        0xB845, # G+11773  U+B845  uniB845,  HANGUL SYLLABLE-B845
        0xB846, # G+11774  U+B846  uniB846,  HANGUL SYLLABLE-B846
        0xB847, # G+11775  U+B847  uniB847,  HANGUL SYLLABLE-B847
        0xB848, # G+11776  U+B848  uniB848,  HANGUL SYLLABLE-B848
        0xB849, # G+11777  U+B849  uniB849,  HANGUL SYLLABLE-B849
        0xB84A, # G+11778  U+B84A  uniB84A,  HANGUL SYLLABLE-B84A
        0xB84B, # G+11779  U+B84B  uniB84B,  HANGUL SYLLABLE-B84B
        0xB84C, # G+11780  U+B84C  uniB84C,  HANGUL SYLLABLE-B84C
        0xB84D, # G+11781  U+B84D  uniB84D,  HANGUL SYLLABLE-B84D
        0xB84E, # G+11782  U+B84E  uniB84E,  HANGUL SYLLABLE-B84E
        0xB84F, # G+11783  U+B84F  uniB84F,  HANGUL SYLLABLE-B84F
        0xB850, # G+11784  U+B850  uniB850,  HANGUL SYLLABLE-B850
        0xB852, # G+11785  U+B852  uniB852,  HANGUL SYLLABLE-B852
        0xB854, # G+11786  U+B854  uniB854,  HANGUL SYLLABLE-B854
        0xB855, # G+11787  U+B855  uniB855,  HANGUL SYLLABLE-B855
        0xB856, # G+11788  U+B856  uniB856,  HANGUL SYLLABLE-B856
        0xB857, # G+11789  U+B857  uniB857,  HANGUL SYLLABLE-B857
        0xB858, # G+11790  U+B858  uniB858,  HANGUL SYLLABLE-B858
        0xB859, # G+11791  U+B859  uniB859,  HANGUL SYLLABLE-B859
        0xB85A, # G+11792  U+B85A  uniB85A,  HANGUL SYLLABLE-B85A
        0xB85B, # G+11793  U+B85B  uniB85B,  HANGUL SYLLABLE-B85B
        0xB85E, # G+11794  U+B85E  uniB85E,  HANGUL SYLLABLE-B85E
        0xB85F, # G+11795  U+B85F  uniB85F,  HANGUL SYLLABLE-B85F
        0xB861, # G+11796  U+B861  uniB861,  HANGUL SYLLABLE-B861
        0xB862, # G+11797  U+B862  uniB862,  HANGUL SYLLABLE-B862
        0xB863, # G+11798  U+B863  uniB863,  HANGUL SYLLABLE-B863
        0xB865, # G+11799  U+B865  uniB865,  HANGUL SYLLABLE-B865
        0xB866, # G+11800  U+B866  uniB866,  HANGUL SYLLABLE-B866
        0xB867, # G+11801  U+B867  uniB867,  HANGUL SYLLABLE-B867
        0xB868, # G+11802  U+B868  uniB868,  HANGUL SYLLABLE-B868
        0xB869, # G+11803  U+B869  uniB869,  HANGUL SYLLABLE-B869
        0xB86A, # G+11804  U+B86A  uniB86A,  HANGUL SYLLABLE-B86A
        0xB86B, # G+11805  U+B86B  uniB86B,  HANGUL SYLLABLE-B86B
        0xB86E, # G+11806  U+B86E  uniB86E,  HANGUL SYLLABLE-B86E
        0xB870, # G+11807  U+B870  uniB870,  HANGUL SYLLABLE-B870
        0xB872, # G+11808  U+B872  uniB872,  HANGUL SYLLABLE-B872
        0xB873, # G+11809  U+B873  uniB873,  HANGUL SYLLABLE-B873
        0xB874, # G+11810  U+B874  uniB874,  HANGUL SYLLABLE-B874
        0xB875, # G+11811  U+B875  uniB875,  HANGUL SYLLABLE-B875
        0xB876, # G+11812  U+B876  uniB876,  HANGUL SYLLABLE-B876
        0xB877, # G+11813  U+B877  uniB877,  HANGUL SYLLABLE-B877
        0xB879, # G+11814  U+B879  uniB879,  HANGUL SYLLABLE-B879
        0xB87A, # G+11815  U+B87A  uniB87A,  HANGUL SYLLABLE-B87A
        0xB87B, # G+11816  U+B87B  uniB87B,  HANGUL SYLLABLE-B87B
        0xB87D, # G+11817  U+B87D  uniB87D,  HANGUL SYLLABLE-B87D
        0xB87E, # G+11818  U+B87E  uniB87E,  HANGUL SYLLABLE-B87E
        0xB87F, # G+11819  U+B87F  uniB87F,  HANGUL SYLLABLE-B87F
        0xB880, # G+11820  U+B880  uniB880,  HANGUL SYLLABLE-B880
        0xB881, # G+11821  U+B881  uniB881,  HANGUL SYLLABLE-B881
        0xB882, # G+11822  U+B882  uniB882,  HANGUL SYLLABLE-B882
        0xB883, # G+11823  U+B883  uniB883,  HANGUL SYLLABLE-B883
        0xB884, # G+11824  U+B884  uniB884,  HANGUL SYLLABLE-B884
        0xB885, # G+11825  U+B885  uniB885,  HANGUL SYLLABLE-B885
        0xB886, # G+11826  U+B886  uniB886,  HANGUL SYLLABLE-B886
        0xB887, # G+11827  U+B887  uniB887,  HANGUL SYLLABLE-B887
        0xB888, # G+11828  U+B888  uniB888,  HANGUL SYLLABLE-B888
        0xB889, # G+11829  U+B889  uniB889,  HANGUL SYLLABLE-B889
        0xB88A, # G+11830  U+B88A  uniB88A,  HANGUL SYLLABLE-B88A
        0xB88B, # G+11831  U+B88B  uniB88B,  HANGUL SYLLABLE-B88B
        0xB88C, # G+11832  U+B88C  uniB88C,  HANGUL SYLLABLE-B88C
        0xB88E, # G+11833  U+B88E  uniB88E,  HANGUL SYLLABLE-B88E
        0xB88F, # G+11834  U+B88F  uniB88F,  HANGUL SYLLABLE-B88F
        0xB890, # G+11835  U+B890  uniB890,  HANGUL SYLLABLE-B890
        0xB891, # G+11836  U+B891  uniB891,  HANGUL SYLLABLE-B891
        0xB892, # G+11837  U+B892  uniB892,  HANGUL SYLLABLE-B892
        0xB893, # G+11838  U+B893  uniB893,  HANGUL SYLLABLE-B893
        0xB894, # G+11839  U+B894  uniB894,  HANGUL SYLLABLE-B894
        0xB895, # G+11840  U+B895  uniB895,  HANGUL SYLLABLE-B895
        0xB896, # G+11841  U+B896  uniB896,  HANGUL SYLLABLE-B896
        0xB897, # G+11842  U+B897  uniB897,  HANGUL SYLLABLE-B897
        0xB898, # G+11843  U+B898  uniB898,  HANGUL SYLLABLE-B898
        0xB899, # G+11844  U+B899  uniB899,  HANGUL SYLLABLE-B899
        0xB89A, # G+11845  U+B89A  uniB89A,  HANGUL SYLLABLE-B89A
        0xB89B, # G+11846  U+B89B  uniB89B,  HANGUL SYLLABLE-B89B
        0xB89C, # G+11847  U+B89C  uniB89C,  HANGUL SYLLABLE-B89C
        0xB89D, # G+11848  U+B89D  uniB89D,  HANGUL SYLLABLE-B89D
        0xB89E, # G+11849  U+B89E  uniB89E,  HANGUL SYLLABLE-B89E
        0xB89F, # G+11850  U+B89F  uniB89F,  HANGUL SYLLABLE-B89F
        0xB8A0, # G+11851  U+B8A0  uniB8A0,  HANGUL SYLLABLE-B8A0
        0xB8A1, # G+11852  U+B8A1  uniB8A1,  HANGUL SYLLABLE-B8A1
        0xB8A2, # G+11853  U+B8A2  uniB8A2,  HANGUL SYLLABLE-B8A2
        0xB8A3, # G+11854  U+B8A3  uniB8A3,  HANGUL SYLLABLE-B8A3
        0xB8A4, # G+11855  U+B8A4  uniB8A4,  HANGUL SYLLABLE-B8A4
        0xB8A5, # G+11856  U+B8A5  uniB8A5,  HANGUL SYLLABLE-B8A5
        0xB8A6, # G+11857  U+B8A6  uniB8A6,  HANGUL SYLLABLE-B8A6
        0xB8A7, # G+11858  U+B8A7  uniB8A7,  HANGUL SYLLABLE-B8A7
        0xB8A9, # G+11859  U+B8A9  uniB8A9,  HANGUL SYLLABLE-B8A9
        0xB8AA, # G+11860  U+B8AA  uniB8AA,  HANGUL SYLLABLE-B8AA
        0xB8AB, # G+11861  U+B8AB  uniB8AB,  HANGUL SYLLABLE-B8AB
        0xB8AC, # G+11862  U+B8AC  uniB8AC,  HANGUL SYLLABLE-B8AC
        0xB8AD, # G+11863  U+B8AD  uniB8AD,  HANGUL SYLLABLE-B8AD
        0xB8AE, # G+11864  U+B8AE  uniB8AE,  HANGUL SYLLABLE-B8AE
        0xB8AF, # G+11865  U+B8AF  uniB8AF,  HANGUL SYLLABLE-B8AF
        0xB8B1, # G+11866  U+B8B1  uniB8B1,  HANGUL SYLLABLE-B8B1
        0xB8B2, # G+11867  U+B8B2  uniB8B2,  HANGUL SYLLABLE-B8B2
        0xB8B3, # G+11868  U+B8B3  uniB8B3,  HANGUL SYLLABLE-B8B3
        0xB8B5, # G+11869  U+B8B5  uniB8B5,  HANGUL SYLLABLE-B8B5
        0xB8B6, # G+11870  U+B8B6  uniB8B6,  HANGUL SYLLABLE-B8B6
        0xB8B7, # G+11871  U+B8B7  uniB8B7,  HANGUL SYLLABLE-B8B7
        0xB8B9, # G+11872  U+B8B9  uniB8B9,  HANGUL SYLLABLE-B8B9
        0xB8BA, # G+11873  U+B8BA  uniB8BA,  HANGUL SYLLABLE-B8BA
        0xB8BB, # G+11874  U+B8BB  uniB8BB,  HANGUL SYLLABLE-B8BB
        0xB8BC, # G+11875  U+B8BC  uniB8BC,  HANGUL SYLLABLE-B8BC
        0xB8BD, # G+11876  U+B8BD  uniB8BD,  HANGUL SYLLABLE-B8BD
        0xB8BE, # G+11877  U+B8BE  uniB8BE,  HANGUL SYLLABLE-B8BE
        0xB8BF, # G+11878  U+B8BF  uniB8BF,  HANGUL SYLLABLE-B8BF
        0xB8C2, # G+11879  U+B8C2  uniB8C2,  HANGUL SYLLABLE-B8C2
        0xB8C4, # G+11880  U+B8C4  uniB8C4,  HANGUL SYLLABLE-B8C4
        0xB8C6, # G+11881  U+B8C6  uniB8C6,  HANGUL SYLLABLE-B8C6
        0xB8C7, # G+11882  U+B8C7  uniB8C7,  HANGUL SYLLABLE-B8C7
        0xB8C8, # G+11883  U+B8C8  uniB8C8,  HANGUL SYLLABLE-B8C8
        0xB8C9, # G+11884  U+B8C9  uniB8C9,  HANGUL SYLLABLE-B8C9
        0xB8CA, # G+11885  U+B8CA  uniB8CA,  HANGUL SYLLABLE-B8CA
        0xB8CB, # G+11886  U+B8CB  uniB8CB,  HANGUL SYLLABLE-B8CB
        0xB8CD, # G+11887  U+B8CD  uniB8CD,  HANGUL SYLLABLE-B8CD
        0xB8CE, # G+11888  U+B8CE  uniB8CE,  HANGUL SYLLABLE-B8CE
        0xB8CF, # G+11889  U+B8CF  uniB8CF,  HANGUL SYLLABLE-B8CF
        0xB8D1, # G+11890  U+B8D1  uniB8D1,  HANGUL SYLLABLE-B8D1
        0xB8D2, # G+11891  U+B8D2  uniB8D2,  HANGUL SYLLABLE-B8D2
        0xB8D3, # G+11892  U+B8D3  uniB8D3,  HANGUL SYLLABLE-B8D3
        0xB8D5, # G+11893  U+B8D5  uniB8D5,  HANGUL SYLLABLE-B8D5
        0xB8D6, # G+11894  U+B8D6  uniB8D6,  HANGUL SYLLABLE-B8D6
        0xB8D7, # G+11895  U+B8D7  uniB8D7,  HANGUL SYLLABLE-B8D7
        0xB8D8, # G+11896  U+B8D8  uniB8D8,  HANGUL SYLLABLE-B8D8
        0xB8D9, # G+11897  U+B8D9  uniB8D9,  HANGUL SYLLABLE-B8D9
        0xB8DA, # G+11898  U+B8DA  uniB8DA,  HANGUL SYLLABLE-B8DA
        0xB8DB, # G+11899  U+B8DB  uniB8DB,  HANGUL SYLLABLE-B8DB
        0xB8DC, # G+11900  U+B8DC  uniB8DC,  HANGUL SYLLABLE-B8DC
        0xB8DE, # G+11901  U+B8DE  uniB8DE,  HANGUL SYLLABLE-B8DE
        0xB8E0, # G+11902  U+B8E0  uniB8E0,  HANGUL SYLLABLE-B8E0
        0xB8E2, # G+11903  U+B8E2  uniB8E2,  HANGUL SYLLABLE-B8E2
        0xB8E3, # G+11904  U+B8E3  uniB8E3,  HANGUL SYLLABLE-B8E3
        0xB8E4, # G+11905  U+B8E4  uniB8E4,  HANGUL SYLLABLE-B8E4
        0xB8E5, # G+11906  U+B8E5  uniB8E5,  HANGUL SYLLABLE-B8E5
        0xB8E6, # G+11907  U+B8E6  uniB8E6,  HANGUL SYLLABLE-B8E6
        0xB8E7, # G+11908  U+B8E7  uniB8E7,  HANGUL SYLLABLE-B8E7
        0xB8EA, # G+11909  U+B8EA  uniB8EA,  HANGUL SYLLABLE-B8EA
        0xB8EB, # G+11910  U+B8EB  uniB8EB,  HANGUL SYLLABLE-B8EB
        0xB8ED, # G+11911  U+B8ED  uniB8ED,  HANGUL SYLLABLE-B8ED
        0xB8EE, # G+11912  U+B8EE  uniB8EE,  HANGUL SYLLABLE-B8EE
        0xB8EF, # G+11913  U+B8EF  uniB8EF,  HANGUL SYLLABLE-B8EF
        0xB8F1, # G+11914  U+B8F1  uniB8F1,  HANGUL SYLLABLE-B8F1
        0xB8F2, # G+11915  U+B8F2  uniB8F2,  HANGUL SYLLABLE-B8F2
        0xB8F3, # G+11916  U+B8F3  uniB8F3,  HANGUL SYLLABLE-B8F3
        0xB8F4, # G+11917  U+B8F4  uniB8F4,  HANGUL SYLLABLE-B8F4
        0xB8F5, # G+11918  U+B8F5  uniB8F5,  HANGUL SYLLABLE-B8F5
        0xB8F6, # G+11919  U+B8F6  uniB8F6,  HANGUL SYLLABLE-B8F6
        0xB8F7, # G+11920  U+B8F7  uniB8F7,  HANGUL SYLLABLE-B8F7
        0xB8FA, # G+11921  U+B8FA  uniB8FA,  HANGUL SYLLABLE-B8FA
        0xB8FC, # G+11922  U+B8FC  uniB8FC,  HANGUL SYLLABLE-B8FC
        0xB8FE, # G+11923  U+B8FE  uniB8FE,  HANGUL SYLLABLE-B8FE
        0xB8FF, # G+11924  U+B8FF  uniB8FF,  HANGUL SYLLABLE-B8FF
        0xB900, # G+11925  U+B900  uniB900,  HANGUL SYLLABLE-B900
        0xB901, # G+11926  U+B901  uniB901,  HANGUL SYLLABLE-B901
        0xB902, # G+11927  U+B902  uniB902,  HANGUL SYLLABLE-B902
        0xB903, # G+11928  U+B903  uniB903,  HANGUL SYLLABLE-B903
        0xB905, # G+11929  U+B905  uniB905,  HANGUL SYLLABLE-B905
        0xB906, # G+11930  U+B906  uniB906,  HANGUL SYLLABLE-B906
        0xB907, # G+11931  U+B907  uniB907,  HANGUL SYLLABLE-B907
        0xB908, # G+11932  U+B908  uniB908,  HANGUL SYLLABLE-B908
        0xB909, # G+11933  U+B909  uniB909,  HANGUL SYLLABLE-B909
        0xB90A, # G+11934  U+B90A  uniB90A,  HANGUL SYLLABLE-B90A
        0xB90B, # G+11935  U+B90B  uniB90B,  HANGUL SYLLABLE-B90B
        0xB90C, # G+11936  U+B90C  uniB90C,  HANGUL SYLLABLE-B90C
        0xB90D, # G+11937  U+B90D  uniB90D,  HANGUL SYLLABLE-B90D
        0xB90E, # G+11938  U+B90E  uniB90E,  HANGUL SYLLABLE-B90E
        0xB90F, # G+11939  U+B90F  uniB90F,  HANGUL SYLLABLE-B90F
        0xB910, # G+11940  U+B910  uniB910,  HANGUL SYLLABLE-B910
        0xB911, # G+11941  U+B911  uniB911,  HANGUL SYLLABLE-B911
        0xB912, # G+11942  U+B912  uniB912,  HANGUL SYLLABLE-B912
        0xB913, # G+11943  U+B913  uniB913,  HANGUL SYLLABLE-B913
        0xB914, # G+11944  U+B914  uniB914,  HANGUL SYLLABLE-B914
        0xB915, # G+11945  U+B915  uniB915,  HANGUL SYLLABLE-B915
        0xB916, # G+11946  U+B916  uniB916,  HANGUL SYLLABLE-B916
        0xB917, # G+11947  U+B917  uniB917,  HANGUL SYLLABLE-B917
        0xB919, # G+11948  U+B919  uniB919,  HANGUL SYLLABLE-B919
        0xB91A, # G+11949  U+B91A  uniB91A,  HANGUL SYLLABLE-B91A
        0xB91B, # G+11950  U+B91B  uniB91B,  HANGUL SYLLABLE-B91B
        0xB91C, # G+11951  U+B91C  uniB91C,  HANGUL SYLLABLE-B91C
        0xB91D, # G+11952  U+B91D  uniB91D,  HANGUL SYLLABLE-B91D
        0xB91E, # G+11953  U+B91E  uniB91E,  HANGUL SYLLABLE-B91E
        0xB91F, # G+11954  U+B91F  uniB91F,  HANGUL SYLLABLE-B91F
        0xB921, # G+11955  U+B921  uniB921,  HANGUL SYLLABLE-B921
        0xB922, # G+11956  U+B922  uniB922,  HANGUL SYLLABLE-B922
        0xB923, # G+11957  U+B923  uniB923,  HANGUL SYLLABLE-B923
        0xB924, # G+11958  U+B924  uniB924,  HANGUL SYLLABLE-B924
        0xB925, # G+11959  U+B925  uniB925,  HANGUL SYLLABLE-B925
        0xB926, # G+11960  U+B926  uniB926,  HANGUL SYLLABLE-B926
        0xB927, # G+11961  U+B927  uniB927,  HANGUL SYLLABLE-B927
        0xB928, # G+11962  U+B928  uniB928,  HANGUL SYLLABLE-B928
        0xB929, # G+11963  U+B929  uniB929,  HANGUL SYLLABLE-B929
        0xB92A, # G+11964  U+B92A  uniB92A,  HANGUL SYLLABLE-B92A
        0xB92B, # G+11965  U+B92B  uniB92B,  HANGUL SYLLABLE-B92B
        0xB92C, # G+11966  U+B92C  uniB92C,  HANGUL SYLLABLE-B92C
        0xB92D, # G+11967  U+B92D  uniB92D,  HANGUL SYLLABLE-B92D
        0xB92E, # G+11968  U+B92E  uniB92E,  HANGUL SYLLABLE-B92E
        0xB92F, # G+11969  U+B92F  uniB92F,  HANGUL SYLLABLE-B92F
        0xB930, # G+11970  U+B930  uniB930,  HANGUL SYLLABLE-B930
        0xB931, # G+11971  U+B931  uniB931,  HANGUL SYLLABLE-B931
        0xB932, # G+11972  U+B932  uniB932,  HANGUL SYLLABLE-B932
        0xB933, # G+11973  U+B933  uniB933,  HANGUL SYLLABLE-B933
        0xB934, # G+11974  U+B934  uniB934,  HANGUL SYLLABLE-B934
        0xB935, # G+11975  U+B935  uniB935,  HANGUL SYLLABLE-B935
        0xB936, # G+11976  U+B936  uniB936,  HANGUL SYLLABLE-B936
        0xB937, # G+11977  U+B937  uniB937,  HANGUL SYLLABLE-B937
        0xB938, # G+11978  U+B938  uniB938,  HANGUL SYLLABLE-B938
        0xB939, # G+11979  U+B939  uniB939,  HANGUL SYLLABLE-B939
        0xB93A, # G+11980  U+B93A  uniB93A,  HANGUL SYLLABLE-B93A
        0xB93B, # G+11981  U+B93B  uniB93B,  HANGUL SYLLABLE-B93B
        0xB93E, # G+11982  U+B93E  uniB93E,  HANGUL SYLLABLE-B93E
        0xB93F, # G+11983  U+B93F  uniB93F,  HANGUL SYLLABLE-B93F
        0xB941, # G+11984  U+B941  uniB941,  HANGUL SYLLABLE-B941
        0xB942, # G+11985  U+B942  uniB942,  HANGUL SYLLABLE-B942
        0xB943, # G+11986  U+B943  uniB943,  HANGUL SYLLABLE-B943
        0xB945, # G+11987  U+B945  uniB945,  HANGUL SYLLABLE-B945
        0xB946, # G+11988  U+B946  uniB946,  HANGUL SYLLABLE-B946
        0xB947, # G+11989  U+B947  uniB947,  HANGUL SYLLABLE-B947
        0xB948, # G+11990  U+B948  uniB948,  HANGUL SYLLABLE-B948
        0xB949, # G+11991  U+B949  uniB949,  HANGUL SYLLABLE-B949
        0xB94A, # G+11992  U+B94A  uniB94A,  HANGUL SYLLABLE-B94A
        0xB94B, # G+11993  U+B94B  uniB94B,  HANGUL SYLLABLE-B94B
        0xB94D, # G+11994  U+B94D  uniB94D,  HANGUL SYLLABLE-B94D
        0xB94E, # G+11995  U+B94E  uniB94E,  HANGUL SYLLABLE-B94E
        0xB950, # G+11996  U+B950  uniB950,  HANGUL SYLLABLE-B950
        0xB952, # G+11997  U+B952  uniB952,  HANGUL SYLLABLE-B952
        0xB953, # G+11998  U+B953  uniB953,  HANGUL SYLLABLE-B953
        0xB954, # G+11999  U+B954  uniB954,  HANGUL SYLLABLE-B954
        0xB955, # G+12000  U+B955  uniB955,  HANGUL SYLLABLE-B955
        0xB956, # G+12001  U+B956  uniB956,  HANGUL SYLLABLE-B956
        0xB957, # G+12002  U+B957  uniB957,  HANGUL SYLLABLE-B957
        0xB95A, # G+12003  U+B95A  uniB95A,  HANGUL SYLLABLE-B95A
        0xB95B, # G+12004  U+B95B  uniB95B,  HANGUL SYLLABLE-B95B
        0xB95D, # G+12005  U+B95D  uniB95D,  HANGUL SYLLABLE-B95D
        0xB95E, # G+12006  U+B95E  uniB95E,  HANGUL SYLLABLE-B95E
        0xB95F, # G+12007  U+B95F  uniB95F,  HANGUL SYLLABLE-B95F
        0xB961, # G+12008  U+B961  uniB961,  HANGUL SYLLABLE-B961
        0xB962, # G+12009  U+B962  uniB962,  HANGUL SYLLABLE-B962
        0xB963, # G+12010  U+B963  uniB963,  HANGUL SYLLABLE-B963
        0xB964, # G+12011  U+B964  uniB964,  HANGUL SYLLABLE-B964
        0xB965, # G+12012  U+B965  uniB965,  HANGUL SYLLABLE-B965
        0xB966, # G+12013  U+B966  uniB966,  HANGUL SYLLABLE-B966
        0xB967, # G+12014  U+B967  uniB967,  HANGUL SYLLABLE-B967
        0xB96A, # G+12015  U+B96A  uniB96A,  HANGUL SYLLABLE-B96A
        0xB96C, # G+12016  U+B96C  uniB96C,  HANGUL SYLLABLE-B96C
        0xB96E, # G+12017  U+B96E  uniB96E,  HANGUL SYLLABLE-B96E
        0xB96F, # G+12018  U+B96F  uniB96F,  HANGUL SYLLABLE-B96F
        0xB970, # G+12019  U+B970  uniB970,  HANGUL SYLLABLE-B970
        0xB971, # G+12020  U+B971  uniB971,  HANGUL SYLLABLE-B971
        0xB972, # G+12021  U+B972  uniB972,  HANGUL SYLLABLE-B972
        0xB973, # G+12022  U+B973  uniB973,  HANGUL SYLLABLE-B973
        0xB976, # G+12023  U+B976  uniB976,  HANGUL SYLLABLE-B976
        0xB977, # G+12024  U+B977  uniB977,  HANGUL SYLLABLE-B977
        0xB979, # G+12025  U+B979  uniB979,  HANGUL SYLLABLE-B979
        0xB97A, # G+12026  U+B97A  uniB97A,  HANGUL SYLLABLE-B97A
        0xB97B, # G+12027  U+B97B  uniB97B,  HANGUL SYLLABLE-B97B
        0xB97D, # G+12028  U+B97D  uniB97D,  HANGUL SYLLABLE-B97D
        0xB97E, # G+12029  U+B97E  uniB97E,  HANGUL SYLLABLE-B97E
        0xB97F, # G+12030  U+B97F  uniB97F,  HANGUL SYLLABLE-B97F
        0xB980, # G+12031  U+B980  uniB980,  HANGUL SYLLABLE-B980
        0xB981, # G+12032  U+B981  uniB981,  HANGUL SYLLABLE-B981
        0xB982, # G+12033  U+B982  uniB982,  HANGUL SYLLABLE-B982
        0xB983, # G+12034  U+B983  uniB983,  HANGUL SYLLABLE-B983
        0xB986, # G+12035  U+B986  uniB986,  HANGUL SYLLABLE-B986
        0xB988, # G+12036  U+B988  uniB988,  HANGUL SYLLABLE-B988
        0xB98B, # G+12037  U+B98B  uniB98B,  HANGUL SYLLABLE-B98B
        0xB98C, # G+12038  U+B98C  uniB98C,  HANGUL SYLLABLE-B98C
        0xB98F, # G+12039  U+B98F  uniB98F,  HANGUL SYLLABLE-B98F
        0xB990, # G+12040  U+B990  uniB990,  HANGUL SYLLABLE-B990
        0xB991, # G+12041  U+B991  uniB991,  HANGUL SYLLABLE-B991
        0xB992, # G+12042  U+B992  uniB992,  HANGUL SYLLABLE-B992
        0xB993, # G+12043  U+B993  uniB993,  HANGUL SYLLABLE-B993
        0xB994, # G+12044  U+B994  uniB994,  HANGUL SYLLABLE-B994
        0xB995, # G+12045  U+B995  uniB995,  HANGUL SYLLABLE-B995
        0xB996, # G+12046  U+B996  uniB996,  HANGUL SYLLABLE-B996
        0xB997, # G+12047  U+B997  uniB997,  HANGUL SYLLABLE-B997
        0xB998, # G+12048  U+B998  uniB998,  HANGUL SYLLABLE-B998
        0xB999, # G+12049  U+B999  uniB999,  HANGUL SYLLABLE-B999
        0xB99A, # G+12050  U+B99A  uniB99A,  HANGUL SYLLABLE-B99A
        0xB99B, # G+12051  U+B99B  uniB99B,  HANGUL SYLLABLE-B99B
        0xB99C, # G+12052  U+B99C  uniB99C,  HANGUL SYLLABLE-B99C
        0xB99D, # G+12053  U+B99D  uniB99D,  HANGUL SYLLABLE-B99D
        0xB99E, # G+12054  U+B99E  uniB99E,  HANGUL SYLLABLE-B99E
        0xB99F, # G+12055  U+B99F  uniB99F,  HANGUL SYLLABLE-B99F
        0xB9A0, # G+12056  U+B9A0  uniB9A0,  HANGUL SYLLABLE-B9A0
        0xB9A1, # G+12057  U+B9A1  uniB9A1,  HANGUL SYLLABLE-B9A1
        0xB9A2, # G+12058  U+B9A2  uniB9A2,  HANGUL SYLLABLE-B9A2
        0xB9A3, # G+12059  U+B9A3  uniB9A3,  HANGUL SYLLABLE-B9A3
        0xB9A4, # G+12060  U+B9A4  uniB9A4,  HANGUL SYLLABLE-B9A4
        0xB9A5, # G+12061  U+B9A5  uniB9A5,  HANGUL SYLLABLE-B9A5
        0xB9A6, # G+12062  U+B9A6  uniB9A6,  HANGUL SYLLABLE-B9A6
        0xB9A7, # G+12063  U+B9A7  uniB9A7,  HANGUL SYLLABLE-B9A7
        0xB9A8, # G+12064  U+B9A8  uniB9A8,  HANGUL SYLLABLE-B9A8
        0xB9A9, # G+12065  U+B9A9  uniB9A9,  HANGUL SYLLABLE-B9A9
        0xB9AA, # G+12066  U+B9AA  uniB9AA,  HANGUL SYLLABLE-B9AA
        0xB9AB, # G+12067  U+B9AB  uniB9AB,  HANGUL SYLLABLE-B9AB
        0xB9AE, # G+12068  U+B9AE  uniB9AE,  HANGUL SYLLABLE-B9AE
        0xB9AF, # G+12069  U+B9AF  uniB9AF,  HANGUL SYLLABLE-B9AF
        0xB9B1, # G+12070  U+B9B1  uniB9B1,  HANGUL SYLLABLE-B9B1
        0xB9B2, # G+12071  U+B9B2  uniB9B2,  HANGUL SYLLABLE-B9B2
        0xB9B3, # G+12072  U+B9B3  uniB9B3,  HANGUL SYLLABLE-B9B3
        0xB9B5, # G+12073  U+B9B5  uniB9B5,  HANGUL SYLLABLE-B9B5
        0xB9B6, # G+12074  U+B9B6  uniB9B6,  HANGUL SYLLABLE-B9B6
        0xB9B7, # G+12075  U+B9B7  uniB9B7,  HANGUL SYLLABLE-B9B7
        0xB9B8, # G+12076  U+B9B8  uniB9B8,  HANGUL SYLLABLE-B9B8
        0xB9B9, # G+12077  U+B9B9  uniB9B9,  HANGUL SYLLABLE-B9B9
        0xB9BA, # G+12078  U+B9BA  uniB9BA,  HANGUL SYLLABLE-B9BA
        0xB9BB, # G+12079  U+B9BB  uniB9BB,  HANGUL SYLLABLE-B9BB
        0xB9BE, # G+12080  U+B9BE  uniB9BE,  HANGUL SYLLABLE-B9BE
        0xB9C0, # G+12081  U+B9C0  uniB9C0,  HANGUL SYLLABLE-B9C0
        0xB9C2, # G+12082  U+B9C2  uniB9C2,  HANGUL SYLLABLE-B9C2
        0xB9C3, # G+12083  U+B9C3  uniB9C3,  HANGUL SYLLABLE-B9C3
        0xB9C4, # G+12084  U+B9C4  uniB9C4,  HANGUL SYLLABLE-B9C4
        0xB9C5, # G+12085  U+B9C5  uniB9C5,  HANGUL SYLLABLE-B9C5
        0xB9C6, # G+12086  U+B9C6  uniB9C6,  HANGUL SYLLABLE-B9C6
        0xB9C7, # G+12087  U+B9C7  uniB9C7,  HANGUL SYLLABLE-B9C7
        0xB9CA, # G+12088  U+B9CA  uniB9CA,  HANGUL SYLLABLE-B9CA
        0xB9CB, # G+12089  U+B9CB  uniB9CB,  HANGUL SYLLABLE-B9CB
        0xB9CD, # G+12090  U+B9CD  uniB9CD,  HANGUL SYLLABLE-B9CD
        0xB9D3, # G+12091  U+B9D3  uniB9D3,  HANGUL SYLLABLE-B9D3
        0xB9D4, # G+12092  U+B9D4  uniB9D4,  HANGUL SYLLABLE-B9D4
        0xB9D5, # G+12093  U+B9D5  uniB9D5,  HANGUL SYLLABLE-B9D5
        0xB9D6, # G+12094  U+B9D6  uniB9D6,  HANGUL SYLLABLE-B9D6
        0xB9D7, # G+12095  U+B9D7  uniB9D7,  HANGUL SYLLABLE-B9D7
        0xB9DA, # G+12096  U+B9DA  uniB9DA,  HANGUL SYLLABLE-B9DA
        0xB9DC, # G+12097  U+B9DC  uniB9DC,  HANGUL SYLLABLE-B9DC
        0xB9DF, # G+12098  U+B9DF  uniB9DF,  HANGUL SYLLABLE-B9DF
        0xB9E0, # G+12099  U+B9E0  uniB9E0,  HANGUL SYLLABLE-B9E0
        0xB9E2, # G+12100  U+B9E2  uniB9E2,  HANGUL SYLLABLE-B9E2
        0xB9E6, # G+12101  U+B9E6  uniB9E6,  HANGUL SYLLABLE-B9E6
        0xB9E7, # G+12102  U+B9E7  uniB9E7,  HANGUL SYLLABLE-B9E7
        0xB9E9, # G+12103  U+B9E9  uniB9E9,  HANGUL SYLLABLE-B9E9
        0xB9EA, # G+12104  U+B9EA  uniB9EA,  HANGUL SYLLABLE-B9EA
        0xB9EB, # G+12105  U+B9EB  uniB9EB,  HANGUL SYLLABLE-B9EB
        0xB9ED, # G+12106  U+B9ED  uniB9ED,  HANGUL SYLLABLE-B9ED
        0xB9EE, # G+12107  U+B9EE  uniB9EE,  HANGUL SYLLABLE-B9EE
        0xB9EF, # G+12108  U+B9EF  uniB9EF,  HANGUL SYLLABLE-B9EF
        0xB9F0, # G+12109  U+B9F0  uniB9F0,  HANGUL SYLLABLE-B9F0
        0xB9F1, # G+12110  U+B9F1  uniB9F1,  HANGUL SYLLABLE-B9F1
        0xB9F2, # G+12111  U+B9F2  uniB9F2,  HANGUL SYLLABLE-B9F2
        0xB9F3, # G+12112  U+B9F3  uniB9F3,  HANGUL SYLLABLE-B9F3
        0xB9F6, # G+12113  U+B9F6  uniB9F6,  HANGUL SYLLABLE-B9F6
        0xB9FB, # G+12114  U+B9FB  uniB9FB,  HANGUL SYLLABLE-B9FB
        0xB9FC, # G+12115  U+B9FC  uniB9FC,  HANGUL SYLLABLE-B9FC
        0xB9FD, # G+12116  U+B9FD  uniB9FD,  HANGUL SYLLABLE-B9FD
        0xB9FE, # G+12117  U+B9FE  uniB9FE,  HANGUL SYLLABLE-B9FE
        0xB9FF, # G+12118  U+B9FF  uniB9FF,  HANGUL SYLLABLE-B9FF
        0xBA02, # G+12119  U+BA02  uniBA02,  HANGUL SYLLABLE-BA02
        0xBA03, # G+12120  U+BA03  uniBA03,  HANGUL SYLLABLE-BA03
        0xBA04, # G+12121  U+BA04  uniBA04,  HANGUL SYLLABLE-BA04
        0xBA05, # G+12122  U+BA05  uniBA05,  HANGUL SYLLABLE-BA05
        0xBA06, # G+12123  U+BA06  uniBA06,  HANGUL SYLLABLE-BA06
        0xBA07, # G+12124  U+BA07  uniBA07,  HANGUL SYLLABLE-BA07
        0xBA09, # G+12125  U+BA09  uniBA09,  HANGUL SYLLABLE-BA09
        0xBA0A, # G+12126  U+BA0A  uniBA0A,  HANGUL SYLLABLE-BA0A
        0xBA0B, # G+12127  U+BA0B  uniBA0B,  HANGUL SYLLABLE-BA0B
        0xBA0C, # G+12128  U+BA0C  uniBA0C,  HANGUL SYLLABLE-BA0C
        0xBA0D, # G+12129  U+BA0D  uniBA0D,  HANGUL SYLLABLE-BA0D
        0xBA0E, # G+12130  U+BA0E  uniBA0E,  HANGUL SYLLABLE-BA0E
        0xBA0F, # G+12131  U+BA0F  uniBA0F,  HANGUL SYLLABLE-BA0F
        0xBA10, # G+12132  U+BA10  uniBA10,  HANGUL SYLLABLE-BA10
        0xBA11, # G+12133  U+BA11  uniBA11,  HANGUL SYLLABLE-BA11
        0xBA12, # G+12134  U+BA12  uniBA12,  HANGUL SYLLABLE-BA12
        0xBA13, # G+12135  U+BA13  uniBA13,  HANGUL SYLLABLE-BA13
        0xBA14, # G+12136  U+BA14  uniBA14,  HANGUL SYLLABLE-BA14
        0xBA16, # G+12137  U+BA16  uniBA16,  HANGUL SYLLABLE-BA16
        0xBA17, # G+12138  U+BA17  uniBA17,  HANGUL SYLLABLE-BA17
        0xBA18, # G+12139  U+BA18  uniBA18,  HANGUL SYLLABLE-BA18
        0xBA19, # G+12140  U+BA19  uniBA19,  HANGUL SYLLABLE-BA19
        0xBA1A, # G+12141  U+BA1A  uniBA1A,  HANGUL SYLLABLE-BA1A
        0xBA1B, # G+12142  U+BA1B  uniBA1B,  HANGUL SYLLABLE-BA1B
        0xBA1C, # G+12143  U+BA1C  uniBA1C,  HANGUL SYLLABLE-BA1C
        0xBA1D, # G+12144  U+BA1D  uniBA1D,  HANGUL SYLLABLE-BA1D
        0xBA1E, # G+12145  U+BA1E  uniBA1E,  HANGUL SYLLABLE-BA1E
        0xBA1F, # G+12146  U+BA1F  uniBA1F,  HANGUL SYLLABLE-BA1F
        0xBA20, # G+12147  U+BA20  uniBA20,  HANGUL SYLLABLE-BA20
        0xBA21, # G+12148  U+BA21  uniBA21,  HANGUL SYLLABLE-BA21
        0xBA22, # G+12149  U+BA22  uniBA22,  HANGUL SYLLABLE-BA22
        0xBA23, # G+12150  U+BA23  uniBA23,  HANGUL SYLLABLE-BA23
        0xBA24, # G+12151  U+BA24  uniBA24,  HANGUL SYLLABLE-BA24
        0xBA25, # G+12152  U+BA25  uniBA25,  HANGUL SYLLABLE-BA25
        0xBA26, # G+12153  U+BA26  uniBA26,  HANGUL SYLLABLE-BA26
        0xBA27, # G+12154  U+BA27  uniBA27,  HANGUL SYLLABLE-BA27
        0xBA28, # G+12155  U+BA28  uniBA28,  HANGUL SYLLABLE-BA28
        0xBA29, # G+12156  U+BA29  uniBA29,  HANGUL SYLLABLE-BA29
        0xBA2A, # G+12157  U+BA2A  uniBA2A,  HANGUL SYLLABLE-BA2A
        0xBA2B, # G+12158  U+BA2B  uniBA2B,  HANGUL SYLLABLE-BA2B
        0xBA2C, # G+12159  U+BA2C  uniBA2C,  HANGUL SYLLABLE-BA2C
        0xBA2D, # G+12160  U+BA2D  uniBA2D,  HANGUL SYLLABLE-BA2D
        0xBA2E, # G+12161  U+BA2E  uniBA2E,  HANGUL SYLLABLE-BA2E
        0xBA2F, # G+12162  U+BA2F  uniBA2F,  HANGUL SYLLABLE-BA2F
        0xBA30, # G+12163  U+BA30  uniBA30,  HANGUL SYLLABLE-BA30
        0xBA31, # G+12164  U+BA31  uniBA31,  HANGUL SYLLABLE-BA31
        0xBA32, # G+12165  U+BA32  uniBA32,  HANGUL SYLLABLE-BA32
        0xBA33, # G+12166  U+BA33  uniBA33,  HANGUL SYLLABLE-BA33
        0xBA34, # G+12167  U+BA34  uniBA34,  HANGUL SYLLABLE-BA34
        0xBA35, # G+12168  U+BA35  uniBA35,  HANGUL SYLLABLE-BA35
        0xBA36, # G+12169  U+BA36  uniBA36,  HANGUL SYLLABLE-BA36
        0xBA37, # G+12170  U+BA37  uniBA37,  HANGUL SYLLABLE-BA37
        0xBA3A, # G+12171  U+BA3A  uniBA3A,  HANGUL SYLLABLE-BA3A
        0xBA3B, # G+12172  U+BA3B  uniBA3B,  HANGUL SYLLABLE-BA3B
        0xBA3D, # G+12173  U+BA3D  uniBA3D,  HANGUL SYLLABLE-BA3D
        0xBA3E, # G+12174  U+BA3E  uniBA3E,  HANGUL SYLLABLE-BA3E
        0xBA3F, # G+12175  U+BA3F  uniBA3F,  HANGUL SYLLABLE-BA3F
        0xBA41, # G+12176  U+BA41  uniBA41,  HANGUL SYLLABLE-BA41
        0xBA43, # G+12177  U+BA43  uniBA43,  HANGUL SYLLABLE-BA43
        0xBA44, # G+12178  U+BA44  uniBA44,  HANGUL SYLLABLE-BA44
        0xBA45, # G+12179  U+BA45  uniBA45,  HANGUL SYLLABLE-BA45
        0xBA46, # G+12180  U+BA46  uniBA46,  HANGUL SYLLABLE-BA46
        0xBA47, # G+12181  U+BA47  uniBA47,  HANGUL SYLLABLE-BA47
        0xBA4A, # G+12182  U+BA4A  uniBA4A,  HANGUL SYLLABLE-BA4A
        0xBA4C, # G+12183  U+BA4C  uniBA4C,  HANGUL SYLLABLE-BA4C
        0xBA4F, # G+12184  U+BA4F  uniBA4F,  HANGUL SYLLABLE-BA4F
        0xBA50, # G+12185  U+BA50  uniBA50,  HANGUL SYLLABLE-BA50
        0xBA51, # G+12186  U+BA51  uniBA51,  HANGUL SYLLABLE-BA51
        0xBA52, # G+12187  U+BA52  uniBA52,  HANGUL SYLLABLE-BA52
        0xBA56, # G+12188  U+BA56  uniBA56,  HANGUL SYLLABLE-BA56
        0xBA57, # G+12189  U+BA57  uniBA57,  HANGUL SYLLABLE-BA57
        0xBA59, # G+12190  U+BA59  uniBA59,  HANGUL SYLLABLE-BA59
        0xBA5A, # G+12191  U+BA5A  uniBA5A,  HANGUL SYLLABLE-BA5A
        0xBA5B, # G+12192  U+BA5B  uniBA5B,  HANGUL SYLLABLE-BA5B
        0xBA5D, # G+12193  U+BA5D  uniBA5D,  HANGUL SYLLABLE-BA5D
        0xBA5E, # G+12194  U+BA5E  uniBA5E,  HANGUL SYLLABLE-BA5E
        0xBA5F, # G+12195  U+BA5F  uniBA5F,  HANGUL SYLLABLE-BA5F
        0xBA60, # G+12196  U+BA60  uniBA60,  HANGUL SYLLABLE-BA60
        0xBA61, # G+12197  U+BA61  uniBA61,  HANGUL SYLLABLE-BA61
        0xBA62, # G+12198  U+BA62  uniBA62,  HANGUL SYLLABLE-BA62
        0xBA63, # G+12199  U+BA63  uniBA63,  HANGUL SYLLABLE-BA63
        0xBA66, # G+12200  U+BA66  uniBA66,  HANGUL SYLLABLE-BA66
        0xBA6A, # G+12201  U+BA6A  uniBA6A,  HANGUL SYLLABLE-BA6A
        0xBA6B, # G+12202  U+BA6B  uniBA6B,  HANGUL SYLLABLE-BA6B
        0xBA6C, # G+12203  U+BA6C  uniBA6C,  HANGUL SYLLABLE-BA6C
        0xBA6D, # G+12204  U+BA6D  uniBA6D,  HANGUL SYLLABLE-BA6D
        0xBA6E, # G+12205  U+BA6E  uniBA6E,  HANGUL SYLLABLE-BA6E
        0xBA6F, # G+12206  U+BA6F  uniBA6F,  HANGUL SYLLABLE-BA6F
        0xBA72, # G+12207  U+BA72  uniBA72,  HANGUL SYLLABLE-BA72
        0xBA73, # G+12208  U+BA73  uniBA73,  HANGUL SYLLABLE-BA73
        0xBA75, # G+12209  U+BA75  uniBA75,  HANGUL SYLLABLE-BA75
        0xBA76, # G+12210  U+BA76  uniBA76,  HANGUL SYLLABLE-BA76
        0xBA77, # G+12211  U+BA77  uniBA77,  HANGUL SYLLABLE-BA77
        0xBA79, # G+12212  U+BA79  uniBA79,  HANGUL SYLLABLE-BA79
        0xBA7A, # G+12213  U+BA7A  uniBA7A,  HANGUL SYLLABLE-BA7A
        0xBA7B, # G+12214  U+BA7B  uniBA7B,  HANGUL SYLLABLE-BA7B
        0xBA7C, # G+12215  U+BA7C  uniBA7C,  HANGUL SYLLABLE-BA7C
        0xBA7D, # G+12216  U+BA7D  uniBA7D,  HANGUL SYLLABLE-BA7D
        0xBA7E, # G+12217  U+BA7E  uniBA7E,  HANGUL SYLLABLE-BA7E
        0xBA7F, # G+12218  U+BA7F  uniBA7F,  HANGUL SYLLABLE-BA7F
        0xBA80, # G+12219  U+BA80  uniBA80,  HANGUL SYLLABLE-BA80
        0xBA81, # G+12220  U+BA81  uniBA81,  HANGUL SYLLABLE-BA81
        0xBA82, # G+12221  U+BA82  uniBA82,  HANGUL SYLLABLE-BA82
        0xBA86, # G+12222  U+BA86  uniBA86,  HANGUL SYLLABLE-BA86
        0xBA88, # G+12223  U+BA88  uniBA88,  HANGUL SYLLABLE-BA88
        0xBA89, # G+12224  U+BA89  uniBA89,  HANGUL SYLLABLE-BA89
        0xBA8A, # G+12225  U+BA8A  uniBA8A,  HANGUL SYLLABLE-BA8A
        0xBA8B, # G+12226  U+BA8B  uniBA8B,  HANGUL SYLLABLE-BA8B
        0xBA8D, # G+12227  U+BA8D  uniBA8D,  HANGUL SYLLABLE-BA8D
        0xBA8E, # G+12228  U+BA8E  uniBA8E,  HANGUL SYLLABLE-BA8E
        0xBA8F, # G+12229  U+BA8F  uniBA8F,  HANGUL SYLLABLE-BA8F
        0xBA90, # G+12230  U+BA90  uniBA90,  HANGUL SYLLABLE-BA90
        0xBA91, # G+12231  U+BA91  uniBA91,  HANGUL SYLLABLE-BA91
        0xBA92, # G+12232  U+BA92  uniBA92,  HANGUL SYLLABLE-BA92
        0xBA93, # G+12233  U+BA93  uniBA93,  HANGUL SYLLABLE-BA93
        0xBA94, # G+12234  U+BA94  uniBA94,  HANGUL SYLLABLE-BA94
        0xBA95, # G+12235  U+BA95  uniBA95,  HANGUL SYLLABLE-BA95
        0xBA96, # G+12236  U+BA96  uniBA96,  HANGUL SYLLABLE-BA96
        0xBA97, # G+12237  U+BA97  uniBA97,  HANGUL SYLLABLE-BA97
        0xBA98, # G+12238  U+BA98  uniBA98,  HANGUL SYLLABLE-BA98
        0xBA99, # G+12239  U+BA99  uniBA99,  HANGUL SYLLABLE-BA99
        0xBA9A, # G+12240  U+BA9A  uniBA9A,  HANGUL SYLLABLE-BA9A
        0xBA9B, # G+12241  U+BA9B  uniBA9B,  HANGUL SYLLABLE-BA9B
        0xBA9C, # G+12242  U+BA9C  uniBA9C,  HANGUL SYLLABLE-BA9C
        0xBA9D, # G+12243  U+BA9D  uniBA9D,  HANGUL SYLLABLE-BA9D
        0xBA9E, # G+12244  U+BA9E  uniBA9E,  HANGUL SYLLABLE-BA9E
        0xBA9F, # G+12245  U+BA9F  uniBA9F,  HANGUL SYLLABLE-BA9F
        0xBAA0, # G+12246  U+BAA0  uniBAA0,  HANGUL SYLLABLE-BAA0
        0xBAA1, # G+12247  U+BAA1  uniBAA1,  HANGUL SYLLABLE-BAA1
        0xBAA2, # G+12248  U+BAA2  uniBAA2,  HANGUL SYLLABLE-BAA2
        0xBAA3, # G+12249  U+BAA3  uniBAA3,  HANGUL SYLLABLE-BAA3
        0xBAA4, # G+12250  U+BAA4  uniBAA4,  HANGUL SYLLABLE-BAA4
        0xBAA5, # G+12251  U+BAA5  uniBAA5,  HANGUL SYLLABLE-BAA5
        0xBAA6, # G+12252  U+BAA6  uniBAA6,  HANGUL SYLLABLE-BAA6
        0xBAA7, # G+12253  U+BAA7  uniBAA7,  HANGUL SYLLABLE-BAA7
        0xBAAA, # G+12254  U+BAAA  uniBAAA,  HANGUL SYLLABLE-BAAA
        0xBAAD, # G+12255  U+BAAD  uniBAAD,  HANGUL SYLLABLE-BAAD
        0xBAAE, # G+12256  U+BAAE  uniBAAE,  HANGUL SYLLABLE-BAAE
        0xBAAF, # G+12257  U+BAAF  uniBAAF,  HANGUL SYLLABLE-BAAF
        0xBAB1, # G+12258  U+BAB1  uniBAB1,  HANGUL SYLLABLE-BAB1
        0xBAB3, # G+12259  U+BAB3  uniBAB3,  HANGUL SYLLABLE-BAB3
        0xBAB4, # G+12260  U+BAB4  uniBAB4,  HANGUL SYLLABLE-BAB4
        0xBAB5, # G+12261  U+BAB5  uniBAB5,  HANGUL SYLLABLE-BAB5
        0xBAB6, # G+12262  U+BAB6  uniBAB6,  HANGUL SYLLABLE-BAB6
        0xBAB7, # G+12263  U+BAB7  uniBAB7,  HANGUL SYLLABLE-BAB7
        0xBABA, # G+12264  U+BABA  uniBABA,  HANGUL SYLLABLE-BABA
        0xBABC, # G+12265  U+BABC  uniBABC,  HANGUL SYLLABLE-BABC
        0xBABE, # G+12266  U+BABE  uniBABE,  HANGUL SYLLABLE-BABE
        0xBABF, # G+12267  U+BABF  uniBABF,  HANGUL SYLLABLE-BABF
        0xBAC0, # G+12268  U+BAC0  uniBAC0,  HANGUL SYLLABLE-BAC0
        0xBAC1, # G+12269  U+BAC1  uniBAC1,  HANGUL SYLLABLE-BAC1
        0xBAC2, # G+12270  U+BAC2  uniBAC2,  HANGUL SYLLABLE-BAC2
        0xBAC3, # G+12271  U+BAC3  uniBAC3,  HANGUL SYLLABLE-BAC3
        0xBAC5, # G+12272  U+BAC5  uniBAC5,  HANGUL SYLLABLE-BAC5
        0xBAC6, # G+12273  U+BAC6  uniBAC6,  HANGUL SYLLABLE-BAC6
        0xBAC7, # G+12274  U+BAC7  uniBAC7,  HANGUL SYLLABLE-BAC7
        0xBAC9, # G+12275  U+BAC9  uniBAC9,  HANGUL SYLLABLE-BAC9
        0xBACA, # G+12276  U+BACA  uniBACA,  HANGUL SYLLABLE-BACA
        0xBACB, # G+12277  U+BACB  uniBACB,  HANGUL SYLLABLE-BACB
        0xBACC, # G+12278  U+BACC  uniBACC,  HANGUL SYLLABLE-BACC
        0xBACD, # G+12279  U+BACD  uniBACD,  HANGUL SYLLABLE-BACD
        0xBACE, # G+12280  U+BACE  uniBACE,  HANGUL SYLLABLE-BACE
        0xBACF, # G+12281  U+BACF  uniBACF,  HANGUL SYLLABLE-BACF
        0xBAD0, # G+12282  U+BAD0  uniBAD0,  HANGUL SYLLABLE-BAD0
        0xBAD1, # G+12283  U+BAD1  uniBAD1,  HANGUL SYLLABLE-BAD1
        0xBAD2, # G+12284  U+BAD2  uniBAD2,  HANGUL SYLLABLE-BAD2
        0xBAD3, # G+12285  U+BAD3  uniBAD3,  HANGUL SYLLABLE-BAD3
        0xBAD4, # G+12286  U+BAD4  uniBAD4,  HANGUL SYLLABLE-BAD4
        0xBAD5, # G+12287  U+BAD5  uniBAD5,  HANGUL SYLLABLE-BAD5
        0xBAD6, # G+12288  U+BAD6  uniBAD6,  HANGUL SYLLABLE-BAD6
        0xBAD7, # G+12289  U+BAD7  uniBAD7,  HANGUL SYLLABLE-BAD7
        0xBADA, # G+12290  U+BADA  uniBADA,  HANGUL SYLLABLE-BADA
        0xBADB, # G+12291  U+BADB  uniBADB,  HANGUL SYLLABLE-BADB
        0xBADC, # G+12292  U+BADC  uniBADC,  HANGUL SYLLABLE-BADC
        0xBADD, # G+12293  U+BADD  uniBADD,  HANGUL SYLLABLE-BADD
        0xBADE, # G+12294  U+BADE  uniBADE,  HANGUL SYLLABLE-BADE
        0xBADF, # G+12295  U+BADF  uniBADF,  HANGUL SYLLABLE-BADF
        0xBAE0, # G+12296  U+BAE0  uniBAE0,  HANGUL SYLLABLE-BAE0
        0xBAE1, # G+12297  U+BAE1  uniBAE1,  HANGUL SYLLABLE-BAE1
        0xBAE2, # G+12298  U+BAE2  uniBAE2,  HANGUL SYLLABLE-BAE2
        0xBAE3, # G+12299  U+BAE3  uniBAE3,  HANGUL SYLLABLE-BAE3
        0xBAE4, # G+12300  U+BAE4  uniBAE4,  HANGUL SYLLABLE-BAE4
        0xBAE5, # G+12301  U+BAE5  uniBAE5,  HANGUL SYLLABLE-BAE5
        0xBAE6, # G+12302  U+BAE6  uniBAE6,  HANGUL SYLLABLE-BAE6
        0xBAE7, # G+12303  U+BAE7  uniBAE7,  HANGUL SYLLABLE-BAE7
        0xBAE8, # G+12304  U+BAE8  uniBAE8,  HANGUL SYLLABLE-BAE8
        0xBAE9, # G+12305  U+BAE9  uniBAE9,  HANGUL SYLLABLE-BAE9
        0xBAEA, # G+12306  U+BAEA  uniBAEA,  HANGUL SYLLABLE-BAEA
        0xBAEB, # G+12307  U+BAEB  uniBAEB,  HANGUL SYLLABLE-BAEB
        0xBAEC, # G+12308  U+BAEC  uniBAEC,  HANGUL SYLLABLE-BAEC
        0xBAED, # G+12309  U+BAED  uniBAED,  HANGUL SYLLABLE-BAED
        0xBAEE, # G+12310  U+BAEE  uniBAEE,  HANGUL SYLLABLE-BAEE
        0xBAEF, # G+12311  U+BAEF  uniBAEF,  HANGUL SYLLABLE-BAEF
        0xBAF0, # G+12312  U+BAF0  uniBAF0,  HANGUL SYLLABLE-BAF0
        0xBAF1, # G+12313  U+BAF1  uniBAF1,  HANGUL SYLLABLE-BAF1
        0xBAF2, # G+12314  U+BAF2  uniBAF2,  HANGUL SYLLABLE-BAF2
        0xBAF3, # G+12315  U+BAF3  uniBAF3,  HANGUL SYLLABLE-BAF3
        0xBAF4, # G+12316  U+BAF4  uniBAF4,  HANGUL SYLLABLE-BAF4
        0xBAF5, # G+12317  U+BAF5  uniBAF5,  HANGUL SYLLABLE-BAF5
        0xBAF6, # G+12318  U+BAF6  uniBAF6,  HANGUL SYLLABLE-BAF6
        0xBAF7, # G+12319  U+BAF7  uniBAF7,  HANGUL SYLLABLE-BAF7
        0xBAF8, # G+12320  U+BAF8  uniBAF8,  HANGUL SYLLABLE-BAF8
        0xBAF9, # G+12321  U+BAF9  uniBAF9,  HANGUL SYLLABLE-BAF9
        0xBAFA, # G+12322  U+BAFA  uniBAFA,  HANGUL SYLLABLE-BAFA
        0xBAFB, # G+12323  U+BAFB  uniBAFB,  HANGUL SYLLABLE-BAFB
        0xBAFD, # G+12324  U+BAFD  uniBAFD,  HANGUL SYLLABLE-BAFD
        0xBAFE, # G+12325  U+BAFE  uniBAFE,  HANGUL SYLLABLE-BAFE
        0xBAFF, # G+12326  U+BAFF  uniBAFF,  HANGUL SYLLABLE-BAFF
        0xBB01, # G+12327  U+BB01  uniBB01,  HANGUL SYLLABLE-BB01
        0xBB02, # G+12328  U+BB02  uniBB02,  HANGUL SYLLABLE-BB02
        0xBB03, # G+12329  U+BB03  uniBB03,  HANGUL SYLLABLE-BB03
        0xBB05, # G+12330  U+BB05  uniBB05,  HANGUL SYLLABLE-BB05
        0xBB06, # G+12331  U+BB06  uniBB06,  HANGUL SYLLABLE-BB06
        0xBB07, # G+12332  U+BB07  uniBB07,  HANGUL SYLLABLE-BB07
        0xBB08, # G+12333  U+BB08  uniBB08,  HANGUL SYLLABLE-BB08
        0xBB09, # G+12334  U+BB09  uniBB09,  HANGUL SYLLABLE-BB09
        0xBB0A, # G+12335  U+BB0A  uniBB0A,  HANGUL SYLLABLE-BB0A
        0xBB0B, # G+12336  U+BB0B  uniBB0B,  HANGUL SYLLABLE-BB0B
        0xBB0C, # G+12337  U+BB0C  uniBB0C,  HANGUL SYLLABLE-BB0C
        0xBB0E, # G+12338  U+BB0E  uniBB0E,  HANGUL SYLLABLE-BB0E
        0xBB10, # G+12339  U+BB10  uniBB10,  HANGUL SYLLABLE-BB10
        0xBB12, # G+12340  U+BB12  uniBB12,  HANGUL SYLLABLE-BB12
        0xBB13, # G+12341  U+BB13  uniBB13,  HANGUL SYLLABLE-BB13
        0xBB14, # G+12342  U+BB14  uniBB14,  HANGUL SYLLABLE-BB14
        0xBB15, # G+12343  U+BB15  uniBB15,  HANGUL SYLLABLE-BB15
        0xBB16, # G+12344  U+BB16  uniBB16,  HANGUL SYLLABLE-BB16
        0xBB17, # G+12345  U+BB17  uniBB17,  HANGUL SYLLABLE-BB17
        0xBB19, # G+12346  U+BB19  uniBB19,  HANGUL SYLLABLE-BB19
        0xBB1A, # G+12347  U+BB1A  uniBB1A,  HANGUL SYLLABLE-BB1A
        0xBB1B, # G+12348  U+BB1B  uniBB1B,  HANGUL SYLLABLE-BB1B
        0xBB1D, # G+12349  U+BB1D  uniBB1D,  HANGUL SYLLABLE-BB1D
        0xBB1E, # G+12350  U+BB1E  uniBB1E,  HANGUL SYLLABLE-BB1E
        0xBB1F, # G+12351  U+BB1F  uniBB1F,  HANGUL SYLLABLE-BB1F
        0xBB21, # G+12352  U+BB21  uniBB21,  HANGUL SYLLABLE-BB21
        0xBB22, # G+12353  U+BB22  uniBB22,  HANGUL SYLLABLE-BB22
        0xBB23, # G+12354  U+BB23  uniBB23,  HANGUL SYLLABLE-BB23
        0xBB24, # G+12355  U+BB24  uniBB24,  HANGUL SYLLABLE-BB24
        0xBB25, # G+12356  U+BB25  uniBB25,  HANGUL SYLLABLE-BB25
        0xBB26, # G+12357  U+BB26  uniBB26,  HANGUL SYLLABLE-BB26
        0xBB27, # G+12358  U+BB27  uniBB27,  HANGUL SYLLABLE-BB27
        0xBB28, # G+12359  U+BB28  uniBB28,  HANGUL SYLLABLE-BB28
        0xBB2A, # G+12360  U+BB2A  uniBB2A,  HANGUL SYLLABLE-BB2A
        0xBB2C, # G+12361  U+BB2C  uniBB2C,  HANGUL SYLLABLE-BB2C
        0xBB2D, # G+12362  U+BB2D  uniBB2D,  HANGUL SYLLABLE-BB2D
        0xBB2E, # G+12363  U+BB2E  uniBB2E,  HANGUL SYLLABLE-BB2E
        0xBB2F, # G+12364  U+BB2F  uniBB2F,  HANGUL SYLLABLE-BB2F
        0xBB30, # G+12365  U+BB30  uniBB30,  HANGUL SYLLABLE-BB30
        0xBB31, # G+12366  U+BB31  uniBB31,  HANGUL SYLLABLE-BB31
        0xBB32, # G+12367  U+BB32  uniBB32,  HANGUL SYLLABLE-BB32
        0xBB33, # G+12368  U+BB33  uniBB33,  HANGUL SYLLABLE-BB33
        0xBB37, # G+12369  U+BB37  uniBB37,  HANGUL SYLLABLE-BB37
        0xBB39, # G+12370  U+BB39  uniBB39,  HANGUL SYLLABLE-BB39
        0xBB3A, # G+12371  U+BB3A  uniBB3A,  HANGUL SYLLABLE-BB3A
        0xBB3F, # G+12372  U+BB3F  uniBB3F,  HANGUL SYLLABLE-BB3F
        0xBB40, # G+12373  U+BB40  uniBB40,  HANGUL SYLLABLE-BB40
        0xBB41, # G+12374  U+BB41  uniBB41,  HANGUL SYLLABLE-BB41
        0xBB42, # G+12375  U+BB42  uniBB42,  HANGUL SYLLABLE-BB42
        0xBB43, # G+12376  U+BB43  uniBB43,  HANGUL SYLLABLE-BB43
        0xBB46, # G+12377  U+BB46  uniBB46,  HANGUL SYLLABLE-BB46
        0xBB48, # G+12378  U+BB48  uniBB48,  HANGUL SYLLABLE-BB48
        0xBB4A, # G+12379  U+BB4A  uniBB4A,  HANGUL SYLLABLE-BB4A
        0xBB4B, # G+12380  U+BB4B  uniBB4B,  HANGUL SYLLABLE-BB4B
        0xBB4C, # G+12381  U+BB4C  uniBB4C,  HANGUL SYLLABLE-BB4C
        0xBB4E, # G+12382  U+BB4E  uniBB4E,  HANGUL SYLLABLE-BB4E
        0xBB51, # G+12383  U+BB51  uniBB51,  HANGUL SYLLABLE-BB51
        0xBB52, # G+12384  U+BB52  uniBB52,  HANGUL SYLLABLE-BB52
        0xBB53, # G+12385  U+BB53  uniBB53,  HANGUL SYLLABLE-BB53
        0xBB55, # G+12386  U+BB55  uniBB55,  HANGUL SYLLABLE-BB55
        0xBB56, # G+12387  U+BB56  uniBB56,  HANGUL SYLLABLE-BB56
        0xBB57, # G+12388  U+BB57  uniBB57,  HANGUL SYLLABLE-BB57
        0xBB59, # G+12389  U+BB59  uniBB59,  HANGUL SYLLABLE-BB59
        0xBB5A, # G+12390  U+BB5A  uniBB5A,  HANGUL SYLLABLE-BB5A
        0xBB5B, # G+12391  U+BB5B  uniBB5B,  HANGUL SYLLABLE-BB5B
        0xBB5C, # G+12392  U+BB5C  uniBB5C,  HANGUL SYLLABLE-BB5C
        0xBB5D, # G+12393  U+BB5D  uniBB5D,  HANGUL SYLLABLE-BB5D
        0xBB5E, # G+12394  U+BB5E  uniBB5E,  HANGUL SYLLABLE-BB5E
        0xBB5F, # G+12395  U+BB5F  uniBB5F,  HANGUL SYLLABLE-BB5F
        0xBB60, # G+12396  U+BB60  uniBB60,  HANGUL SYLLABLE-BB60
        0xBB62, # G+12397  U+BB62  uniBB62,  HANGUL SYLLABLE-BB62
        0xBB64, # G+12398  U+BB64  uniBB64,  HANGUL SYLLABLE-BB64
        0xBB65, # G+12399  U+BB65  uniBB65,  HANGUL SYLLABLE-BB65
        0xBB66, # G+12400  U+BB66  uniBB66,  HANGUL SYLLABLE-BB66
        0xBB67, # G+12401  U+BB67  uniBB67,  HANGUL SYLLABLE-BB67
        0xBB68, # G+12402  U+BB68  uniBB68,  HANGUL SYLLABLE-BB68
        0xBB69, # G+12403  U+BB69  uniBB69,  HANGUL SYLLABLE-BB69
        0xBB6A, # G+12404  U+BB6A  uniBB6A,  HANGUL SYLLABLE-BB6A
        0xBB6B, # G+12405  U+BB6B  uniBB6B,  HANGUL SYLLABLE-BB6B
        0xBB6D, # G+12406  U+BB6D  uniBB6D,  HANGUL SYLLABLE-BB6D
        0xBB6E, # G+12407  U+BB6E  uniBB6E,  HANGUL SYLLABLE-BB6E
        0xBB6F, # G+12408  U+BB6F  uniBB6F,  HANGUL SYLLABLE-BB6F
        0xBB70, # G+12409  U+BB70  uniBB70,  HANGUL SYLLABLE-BB70
        0xBB71, # G+12410  U+BB71  uniBB71,  HANGUL SYLLABLE-BB71
        0xBB72, # G+12411  U+BB72  uniBB72,  HANGUL SYLLABLE-BB72
        0xBB73, # G+12412  U+BB73  uniBB73,  HANGUL SYLLABLE-BB73
        0xBB74, # G+12413  U+BB74  uniBB74,  HANGUL SYLLABLE-BB74
        0xBB75, # G+12414  U+BB75  uniBB75,  HANGUL SYLLABLE-BB75
        0xBB76, # G+12415  U+BB76  uniBB76,  HANGUL SYLLABLE-BB76
        0xBB77, # G+12416  U+BB77  uniBB77,  HANGUL SYLLABLE-BB77
        0xBB78, # G+12417  U+BB78  uniBB78,  HANGUL SYLLABLE-BB78
        0xBB79, # G+12418  U+BB79  uniBB79,  HANGUL SYLLABLE-BB79
        0xBB7A, # G+12419  U+BB7A  uniBB7A,  HANGUL SYLLABLE-BB7A
        0xBB7B, # G+12420  U+BB7B  uniBB7B,  HANGUL SYLLABLE-BB7B
        0xBB7C, # G+12421  U+BB7C  uniBB7C,  HANGUL SYLLABLE-BB7C
        0xBB7D, # G+12422  U+BB7D  uniBB7D,  HANGUL SYLLABLE-BB7D
        0xBB7E, # G+12423  U+BB7E  uniBB7E,  HANGUL SYLLABLE-BB7E
        0xBB7F, # G+12424  U+BB7F  uniBB7F,  HANGUL SYLLABLE-BB7F
        0xBB80, # G+12425  U+BB80  uniBB80,  HANGUL SYLLABLE-BB80
        0xBB81, # G+12426  U+BB81  uniBB81,  HANGUL SYLLABLE-BB81
        0xBB82, # G+12427  U+BB82  uniBB82,  HANGUL SYLLABLE-BB82
        0xBB83, # G+12428  U+BB83  uniBB83,  HANGUL SYLLABLE-BB83
        0xBB84, # G+12429  U+BB84  uniBB84,  HANGUL SYLLABLE-BB84
        0xBB85, # G+12430  U+BB85  uniBB85,  HANGUL SYLLABLE-BB85
        0xBB86, # G+12431  U+BB86  uniBB86,  HANGUL SYLLABLE-BB86
        0xBB87, # G+12432  U+BB87  uniBB87,  HANGUL SYLLABLE-BB87
        0xBB89, # G+12433  U+BB89  uniBB89,  HANGUL SYLLABLE-BB89
        0xBB8A, # G+12434  U+BB8A  uniBB8A,  HANGUL SYLLABLE-BB8A
        0xBB8B, # G+12435  U+BB8B  uniBB8B,  HANGUL SYLLABLE-BB8B
        0xBB8D, # G+12436  U+BB8D  uniBB8D,  HANGUL SYLLABLE-BB8D
        0xBB8E, # G+12437  U+BB8E  uniBB8E,  HANGUL SYLLABLE-BB8E
        0xBB8F, # G+12438  U+BB8F  uniBB8F,  HANGUL SYLLABLE-BB8F
        0xBB91, # G+12439  U+BB91  uniBB91,  HANGUL SYLLABLE-BB91
        0xBB92, # G+12440  U+BB92  uniBB92,  HANGUL SYLLABLE-BB92
        0xBB93, # G+12441  U+BB93  uniBB93,  HANGUL SYLLABLE-BB93
        0xBB94, # G+12442  U+BB94  uniBB94,  HANGUL SYLLABLE-BB94
        0xBB95, # G+12443  U+BB95  uniBB95,  HANGUL SYLLABLE-BB95
        0xBB96, # G+12444  U+BB96  uniBB96,  HANGUL SYLLABLE-BB96
        0xBB97, # G+12445  U+BB97  uniBB97,  HANGUL SYLLABLE-BB97
        0xBB98, # G+12446  U+BB98  uniBB98,  HANGUL SYLLABLE-BB98
        0xBB99, # G+12447  U+BB99  uniBB99,  HANGUL SYLLABLE-BB99
        0xBB9A, # G+12448  U+BB9A  uniBB9A,  HANGUL SYLLABLE-BB9A
        0xBB9B, # G+12449  U+BB9B  uniBB9B,  HANGUL SYLLABLE-BB9B
        0xBB9C, # G+12450  U+BB9C  uniBB9C,  HANGUL SYLLABLE-BB9C
        0xBB9D, # G+12451  U+BB9D  uniBB9D,  HANGUL SYLLABLE-BB9D
        0xBB9E, # G+12452  U+BB9E  uniBB9E,  HANGUL SYLLABLE-BB9E
        0xBB9F, # G+12453  U+BB9F  uniBB9F,  HANGUL SYLLABLE-BB9F
        0xBBA0, # G+12454  U+BBA0  uniBBA0,  HANGUL SYLLABLE-BBA0
        0xBBA1, # G+12455  U+BBA1  uniBBA1,  HANGUL SYLLABLE-BBA1
        0xBBA2, # G+12456  U+BBA2  uniBBA2,  HANGUL SYLLABLE-BBA2
        0xBBA3, # G+12457  U+BBA3  uniBBA3,  HANGUL SYLLABLE-BBA3
        0xBBA5, # G+12458  U+BBA5  uniBBA5,  HANGUL SYLLABLE-BBA5
        0xBBA6, # G+12459  U+BBA6  uniBBA6,  HANGUL SYLLABLE-BBA6
        0xBBA7, # G+12460  U+BBA7  uniBBA7,  HANGUL SYLLABLE-BBA7
        0xBBA9, # G+12461  U+BBA9  uniBBA9,  HANGUL SYLLABLE-BBA9
        0xBBAA, # G+12462  U+BBAA  uniBBAA,  HANGUL SYLLABLE-BBAA
        0xBBAB, # G+12463  U+BBAB  uniBBAB,  HANGUL SYLLABLE-BBAB
        0xBBAD, # G+12464  U+BBAD  uniBBAD,  HANGUL SYLLABLE-BBAD
        0xBBAE, # G+12465  U+BBAE  uniBBAE,  HANGUL SYLLABLE-BBAE
        0xBBAF, # G+12466  U+BBAF  uniBBAF,  HANGUL SYLLABLE-BBAF
        0xBBB0, # G+12467  U+BBB0  uniBBB0,  HANGUL SYLLABLE-BBB0
        0xBBB1, # G+12468  U+BBB1  uniBBB1,  HANGUL SYLLABLE-BBB1
        0xBBB2, # G+12469  U+BBB2  uniBBB2,  HANGUL SYLLABLE-BBB2
        0xBBB3, # G+12470  U+BBB3  uniBBB3,  HANGUL SYLLABLE-BBB3
        0xBBB5, # G+12471  U+BBB5  uniBBB5,  HANGUL SYLLABLE-BBB5
        0xBBB6, # G+12472  U+BBB6  uniBBB6,  HANGUL SYLLABLE-BBB6
        0xBBB8, # G+12473  U+BBB8  uniBBB8,  HANGUL SYLLABLE-BBB8
        0xBBB9, # G+12474  U+BBB9  uniBBB9,  HANGUL SYLLABLE-BBB9
        0xBBBA, # G+12475  U+BBBA  uniBBBA,  HANGUL SYLLABLE-BBBA
        0xBBBB, # G+12476  U+BBBB  uniBBBB,  HANGUL SYLLABLE-BBBB
        0xBBBC, # G+12477  U+BBBC  uniBBBC,  HANGUL SYLLABLE-BBBC
        0xBBBD, # G+12478  U+BBBD  uniBBBD,  HANGUL SYLLABLE-BBBD
        0xBBBE, # G+12479  U+BBBE  uniBBBE,  HANGUL SYLLABLE-BBBE
        0xBBBF, # G+12480  U+BBBF  uniBBBF,  HANGUL SYLLABLE-BBBF
        0xBBC1, # G+12481  U+BBC1  uniBBC1,  HANGUL SYLLABLE-BBC1
        0xBBC2, # G+12482  U+BBC2  uniBBC2,  HANGUL SYLLABLE-BBC2
        0xBBC3, # G+12483  U+BBC3  uniBBC3,  HANGUL SYLLABLE-BBC3
        0xBBC5, # G+12484  U+BBC5  uniBBC5,  HANGUL SYLLABLE-BBC5
        0xBBC6, # G+12485  U+BBC6  uniBBC6,  HANGUL SYLLABLE-BBC6
        0xBBC7, # G+12486  U+BBC7  uniBBC7,  HANGUL SYLLABLE-BBC7
        0xBBC9, # G+12487  U+BBC9  uniBBC9,  HANGUL SYLLABLE-BBC9
        0xBBCA, # G+12488  U+BBCA  uniBBCA,  HANGUL SYLLABLE-BBCA
        0xBBCB, # G+12489  U+BBCB  uniBBCB,  HANGUL SYLLABLE-BBCB
        0xBBCC, # G+12490  U+BBCC  uniBBCC,  HANGUL SYLLABLE-BBCC
        0xBBCD, # G+12491  U+BBCD  uniBBCD,  HANGUL SYLLABLE-BBCD
        0xBBCE, # G+12492  U+BBCE  uniBBCE,  HANGUL SYLLABLE-BBCE
        0xBBCF, # G+12493  U+BBCF  uniBBCF,  HANGUL SYLLABLE-BBCF
        0xBBD1, # G+12494  U+BBD1  uniBBD1,  HANGUL SYLLABLE-BBD1
        0xBBD2, # G+12495  U+BBD2  uniBBD2,  HANGUL SYLLABLE-BBD2
        0xBBD4, # G+12496  U+BBD4  uniBBD4,  HANGUL SYLLABLE-BBD4
        0xBBD5, # G+12497  U+BBD5  uniBBD5,  HANGUL SYLLABLE-BBD5
        0xBBD6, # G+12498  U+BBD6  uniBBD6,  HANGUL SYLLABLE-BBD6
        0xBBD7, # G+12499  U+BBD7  uniBBD7,  HANGUL SYLLABLE-BBD7
        0xBBD8, # G+12500  U+BBD8  uniBBD8,  HANGUL SYLLABLE-BBD8
        0xBBD9, # G+12501  U+BBD9  uniBBD9,  HANGUL SYLLABLE-BBD9
        0xBBDA, # G+12502  U+BBDA  uniBBDA,  HANGUL SYLLABLE-BBDA
        0xBBDB, # G+12503  U+BBDB  uniBBDB,  HANGUL SYLLABLE-BBDB
        0xBBDC, # G+12504  U+BBDC  uniBBDC,  HANGUL SYLLABLE-BBDC
        0xBBDD, # G+12505  U+BBDD  uniBBDD,  HANGUL SYLLABLE-BBDD
        0xBBDE, # G+12506  U+BBDE  uniBBDE,  HANGUL SYLLABLE-BBDE
        0xBBDF, # G+12507  U+BBDF  uniBBDF,  HANGUL SYLLABLE-BBDF
        0xBBE0, # G+12508  U+BBE0  uniBBE0,  HANGUL SYLLABLE-BBE0
        0xBBE1, # G+12509  U+BBE1  uniBBE1,  HANGUL SYLLABLE-BBE1
        0xBBE2, # G+12510  U+BBE2  uniBBE2,  HANGUL SYLLABLE-BBE2
        0xBBE3, # G+12511  U+BBE3  uniBBE3,  HANGUL SYLLABLE-BBE3
        0xBBE4, # G+12512  U+BBE4  uniBBE4,  HANGUL SYLLABLE-BBE4
        0xBBE5, # G+12513  U+BBE5  uniBBE5,  HANGUL SYLLABLE-BBE5
        0xBBE6, # G+12514  U+BBE6  uniBBE6,  HANGUL SYLLABLE-BBE6
        0xBBE7, # G+12515  U+BBE7  uniBBE7,  HANGUL SYLLABLE-BBE7
        0xBBE8, # G+12516  U+BBE8  uniBBE8,  HANGUL SYLLABLE-BBE8
        0xBBE9, # G+12517  U+BBE9  uniBBE9,  HANGUL SYLLABLE-BBE9
        0xBBEA, # G+12518  U+BBEA  uniBBEA,  HANGUL SYLLABLE-BBEA
        0xBBEB, # G+12519  U+BBEB  uniBBEB,  HANGUL SYLLABLE-BBEB
        0xBBEC, # G+12520  U+BBEC  uniBBEC,  HANGUL SYLLABLE-BBEC
        0xBBED, # G+12521  U+BBED  uniBBED,  HANGUL SYLLABLE-BBED
        0xBBEE, # G+12522  U+BBEE  uniBBEE,  HANGUL SYLLABLE-BBEE
        0xBBEF, # G+12523  U+BBEF  uniBBEF,  HANGUL SYLLABLE-BBEF
        0xBBF0, # G+12524  U+BBF0  uniBBF0,  HANGUL SYLLABLE-BBF0
        0xBBF1, # G+12525  U+BBF1  uniBBF1,  HANGUL SYLLABLE-BBF1
        0xBBF2, # G+12526  U+BBF2  uniBBF2,  HANGUL SYLLABLE-BBF2
        0xBBF3, # G+12527  U+BBF3  uniBBF3,  HANGUL SYLLABLE-BBF3
        0xBBF4, # G+12528  U+BBF4  uniBBF4,  HANGUL SYLLABLE-BBF4
        0xBBF5, # G+12529  U+BBF5  uniBBF5,  HANGUL SYLLABLE-BBF5
        0xBBF6, # G+12530  U+BBF6  uniBBF6,  HANGUL SYLLABLE-BBF6
        0xBBF7, # G+12531  U+BBF7  uniBBF7,  HANGUL SYLLABLE-BBF7
        0xBBFA, # G+12532  U+BBFA  uniBBFA,  HANGUL SYLLABLE-BBFA
        0xBBFB, # G+12533  U+BBFB  uniBBFB,  HANGUL SYLLABLE-BBFB
        0xBBFD, # G+12534  U+BBFD  uniBBFD,  HANGUL SYLLABLE-BBFD
        0xBBFE, # G+12535  U+BBFE  uniBBFE,  HANGUL SYLLABLE-BBFE
        0xBC01, # G+12536  U+BC01  uniBC01,  HANGUL SYLLABLE-BC01
        0xBC03, # G+12537  U+BC03  uniBC03,  HANGUL SYLLABLE-BC03
        0xBC04, # G+12538  U+BC04  uniBC04,  HANGUL SYLLABLE-BC04
        0xBC05, # G+12539  U+BC05  uniBC05,  HANGUL SYLLABLE-BC05
        0xBC06, # G+12540  U+BC06  uniBC06,  HANGUL SYLLABLE-BC06
        0xBC07, # G+12541  U+BC07  uniBC07,  HANGUL SYLLABLE-BC07
        0xBC0A, # G+12542  U+BC0A  uniBC0A,  HANGUL SYLLABLE-BC0A
        0xBC0E, # G+12543  U+BC0E  uniBC0E,  HANGUL SYLLABLE-BC0E
        0xBC10, # G+12544  U+BC10  uniBC10,  HANGUL SYLLABLE-BC10
        0xBC12, # G+12545  U+BC12  uniBC12,  HANGUL SYLLABLE-BC12
        0xBC13, # G+12546  U+BC13  uniBC13,  HANGUL SYLLABLE-BC13
        0xBC19, # G+12547  U+BC19  uniBC19,  HANGUL SYLLABLE-BC19
        0xBC1A, # G+12548  U+BC1A  uniBC1A,  HANGUL SYLLABLE-BC1A
        0xBC20, # G+12549  U+BC20  uniBC20,  HANGUL SYLLABLE-BC20
        0xBC21, # G+12550  U+BC21  uniBC21,  HANGUL SYLLABLE-BC21
        0xBC22, # G+12551  U+BC22  uniBC22,  HANGUL SYLLABLE-BC22
        0xBC23, # G+12552  U+BC23  uniBC23,  HANGUL SYLLABLE-BC23
        0xBC26, # G+12553  U+BC26  uniBC26,  HANGUL SYLLABLE-BC26
        0xBC28, # G+12554  U+BC28  uniBC28,  HANGUL SYLLABLE-BC28
        0xBC2A, # G+12555  U+BC2A  uniBC2A,  HANGUL SYLLABLE-BC2A
        0xBC2B, # G+12556  U+BC2B  uniBC2B,  HANGUL SYLLABLE-BC2B
        0xBC2C, # G+12557  U+BC2C  uniBC2C,  HANGUL SYLLABLE-BC2C
        0xBC2E, # G+12558  U+BC2E  uniBC2E,  HANGUL SYLLABLE-BC2E
        0xBC2F, # G+12559  U+BC2F  uniBC2F,  HANGUL SYLLABLE-BC2F
        0xBC32, # G+12560  U+BC32  uniBC32,  HANGUL SYLLABLE-BC32
        0xBC33, # G+12561  U+BC33  uniBC33,  HANGUL SYLLABLE-BC33
        0xBC35, # G+12562  U+BC35  uniBC35,  HANGUL SYLLABLE-BC35
        0xBC36, # G+12563  U+BC36  uniBC36,  HANGUL SYLLABLE-BC36
        0xBC37, # G+12564  U+BC37  uniBC37,  HANGUL SYLLABLE-BC37
        0xBC39, # G+12565  U+BC39  uniBC39,  HANGUL SYLLABLE-BC39
        0xBC3A, # G+12566  U+BC3A  uniBC3A,  HANGUL SYLLABLE-BC3A
        0xBC3B, # G+12567  U+BC3B  uniBC3B,  HANGUL SYLLABLE-BC3B
        0xBC3C, # G+12568  U+BC3C  uniBC3C,  HANGUL SYLLABLE-BC3C
        0xBC3D, # G+12569  U+BC3D  uniBC3D,  HANGUL SYLLABLE-BC3D
        0xBC3E, # G+12570  U+BC3E  uniBC3E,  HANGUL SYLLABLE-BC3E
        0xBC3F, # G+12571  U+BC3F  uniBC3F,  HANGUL SYLLABLE-BC3F
        0xBC42, # G+12572  U+BC42  uniBC42,  HANGUL SYLLABLE-BC42
        0xBC46, # G+12573  U+BC46  uniBC46,  HANGUL SYLLABLE-BC46
        0xBC47, # G+12574  U+BC47  uniBC47,  HANGUL SYLLABLE-BC47
        0xBC48, # G+12575  U+BC48  uniBC48,  HANGUL SYLLABLE-BC48
        0xBC4A, # G+12576  U+BC4A  uniBC4A,  HANGUL SYLLABLE-BC4A
        0xBC4B, # G+12577  U+BC4B  uniBC4B,  HANGUL SYLLABLE-BC4B
        0xBC4E, # G+12578  U+BC4E  uniBC4E,  HANGUL SYLLABLE-BC4E
        0xBC4F, # G+12579  U+BC4F  uniBC4F,  HANGUL SYLLABLE-BC4F
        0xBC51, # G+12580  U+BC51  uniBC51,  HANGUL SYLLABLE-BC51
        0xBC52, # G+12581  U+BC52  uniBC52,  HANGUL SYLLABLE-BC52
        0xBC53, # G+12582  U+BC53  uniBC53,  HANGUL SYLLABLE-BC53
        0xBC54, # G+12583  U+BC54  uniBC54,  HANGUL SYLLABLE-BC54
        0xBC55, # G+12584  U+BC55  uniBC55,  HANGUL SYLLABLE-BC55
        0xBC56, # G+12585  U+BC56  uniBC56,  HANGUL SYLLABLE-BC56
        0xBC57, # G+12586  U+BC57  uniBC57,  HANGUL SYLLABLE-BC57
        0xBC58, # G+12587  U+BC58  uniBC58,  HANGUL SYLLABLE-BC58
        0xBC59, # G+12588  U+BC59  uniBC59,  HANGUL SYLLABLE-BC59
        0xBC5A, # G+12589  U+BC5A  uniBC5A,  HANGUL SYLLABLE-BC5A
        0xBC5B, # G+12590  U+BC5B  uniBC5B,  HANGUL SYLLABLE-BC5B
        0xBC5C, # G+12591  U+BC5C  uniBC5C,  HANGUL SYLLABLE-BC5C
        0xBC5E, # G+12592  U+BC5E  uniBC5E,  HANGUL SYLLABLE-BC5E
        0xBC5F, # G+12593  U+BC5F  uniBC5F,  HANGUL SYLLABLE-BC5F
        0xBC60, # G+12594  U+BC60  uniBC60,  HANGUL SYLLABLE-BC60
        0xBC61, # G+12595  U+BC61  uniBC61,  HANGUL SYLLABLE-BC61
        0xBC62, # G+12596  U+BC62  uniBC62,  HANGUL SYLLABLE-BC62
        0xBC63, # G+12597  U+BC63  uniBC63,  HANGUL SYLLABLE-BC63
        0xBC64, # G+12598  U+BC64  uniBC64,  HANGUL SYLLABLE-BC64
        0xBC65, # G+12599  U+BC65  uniBC65,  HANGUL SYLLABLE-BC65
        0xBC66, # G+12600  U+BC66  uniBC66,  HANGUL SYLLABLE-BC66
        0xBC67, # G+12601  U+BC67  uniBC67,  HANGUL SYLLABLE-BC67
        0xBC68, # G+12602  U+BC68  uniBC68,  HANGUL SYLLABLE-BC68
        0xBC69, # G+12603  U+BC69  uniBC69,  HANGUL SYLLABLE-BC69
        0xBC6A, # G+12604  U+BC6A  uniBC6A,  HANGUL SYLLABLE-BC6A
        0xBC6B, # G+12605  U+BC6B  uniBC6B,  HANGUL SYLLABLE-BC6B
        0xBC6C, # G+12606  U+BC6C  uniBC6C,  HANGUL SYLLABLE-BC6C
        0xBC6D, # G+12607  U+BC6D  uniBC6D,  HANGUL SYLLABLE-BC6D
        0xBC6E, # G+12608  U+BC6E  uniBC6E,  HANGUL SYLLABLE-BC6E
        0xBC6F, # G+12609  U+BC6F  uniBC6F,  HANGUL SYLLABLE-BC6F
        0xBC70, # G+12610  U+BC70  uniBC70,  HANGUL SYLLABLE-BC70
        0xBC71, # G+12611  U+BC71  uniBC71,  HANGUL SYLLABLE-BC71
        0xBC72, # G+12612  U+BC72  uniBC72,  HANGUL SYLLABLE-BC72
        0xBC73, # G+12613  U+BC73  uniBC73,  HANGUL SYLLABLE-BC73
        0xBC74, # G+12614  U+BC74  uniBC74,  HANGUL SYLLABLE-BC74
        0xBC75, # G+12615  U+BC75  uniBC75,  HANGUL SYLLABLE-BC75
        0xBC76, # G+12616  U+BC76  uniBC76,  HANGUL SYLLABLE-BC76
        0xBC77, # G+12617  U+BC77  uniBC77,  HANGUL SYLLABLE-BC77
        0xBC78, # G+12618  U+BC78  uniBC78,  HANGUL SYLLABLE-BC78
        0xBC79, # G+12619  U+BC79  uniBC79,  HANGUL SYLLABLE-BC79
        0xBC7A, # G+12620  U+BC7A  uniBC7A,  HANGUL SYLLABLE-BC7A
        0xBC7B, # G+12621  U+BC7B  uniBC7B,  HANGUL SYLLABLE-BC7B
        0xBC7C, # G+12622  U+BC7C  uniBC7C,  HANGUL SYLLABLE-BC7C
        0xBC7D, # G+12623  U+BC7D  uniBC7D,  HANGUL SYLLABLE-BC7D
        0xBC7E, # G+12624  U+BC7E  uniBC7E,  HANGUL SYLLABLE-BC7E
        0xBC7F, # G+12625  U+BC7F  uniBC7F,  HANGUL SYLLABLE-BC7F
        0xBC80, # G+12626  U+BC80  uniBC80,  HANGUL SYLLABLE-BC80
        0xBC81, # G+12627  U+BC81  uniBC81,  HANGUL SYLLABLE-BC81
        0xBC82, # G+12628  U+BC82  uniBC82,  HANGUL SYLLABLE-BC82
        0xBC83, # G+12629  U+BC83  uniBC83,  HANGUL SYLLABLE-BC83
        0xBC86, # G+12630  U+BC86  uniBC86,  HANGUL SYLLABLE-BC86
        0xBC87, # G+12631  U+BC87  uniBC87,  HANGUL SYLLABLE-BC87
        0xBC89, # G+12632  U+BC89  uniBC89,  HANGUL SYLLABLE-BC89
        0xBC8A, # G+12633  U+BC8A  uniBC8A,  HANGUL SYLLABLE-BC8A
        0xBC8D, # G+12634  U+BC8D  uniBC8D,  HANGUL SYLLABLE-BC8D
        0xBC8F, # G+12635  U+BC8F  uniBC8F,  HANGUL SYLLABLE-BC8F
        0xBC90, # G+12636  U+BC90  uniBC90,  HANGUL SYLLABLE-BC90
        0xBC91, # G+12637  U+BC91  uniBC91,  HANGUL SYLLABLE-BC91
        0xBC92, # G+12638  U+BC92  uniBC92,  HANGUL SYLLABLE-BC92
        0xBC93, # G+12639  U+BC93  uniBC93,  HANGUL SYLLABLE-BC93
        0xBC96, # G+12640  U+BC96  uniBC96,  HANGUL SYLLABLE-BC96
        0xBC98, # G+12641  U+BC98  uniBC98,  HANGUL SYLLABLE-BC98
        0xBC9B, # G+12642  U+BC9B  uniBC9B,  HANGUL SYLLABLE-BC9B
        0xBC9C, # G+12643  U+BC9C  uniBC9C,  HANGUL SYLLABLE-BC9C
        0xBC9D, # G+12644  U+BC9D  uniBC9D,  HANGUL SYLLABLE-BC9D
        0xBC9E, # G+12645  U+BC9E  uniBC9E,  HANGUL SYLLABLE-BC9E
        0xBC9F, # G+12646  U+BC9F  uniBC9F,  HANGUL SYLLABLE-BC9F
        0xBCA2, # G+12647  U+BCA2  uniBCA2,  HANGUL SYLLABLE-BCA2
        0xBCA3, # G+12648  U+BCA3  uniBCA3,  HANGUL SYLLABLE-BCA3
        0xBCA5, # G+12649  U+BCA5  uniBCA5,  HANGUL SYLLABLE-BCA5
        0xBCA6, # G+12650  U+BCA6  uniBCA6,  HANGUL SYLLABLE-BCA6
        0xBCA9, # G+12651  U+BCA9  uniBCA9,  HANGUL SYLLABLE-BCA9
        0xBCAA, # G+12652  U+BCAA  uniBCAA,  HANGUL SYLLABLE-BCAA
        0xBCAB, # G+12653  U+BCAB  uniBCAB,  HANGUL SYLLABLE-BCAB
        0xBCAC, # G+12654  U+BCAC  uniBCAC,  HANGUL SYLLABLE-BCAC
        0xBCAD, # G+12655  U+BCAD  uniBCAD,  HANGUL SYLLABLE-BCAD
        0xBCAE, # G+12656  U+BCAE  uniBCAE,  HANGUL SYLLABLE-BCAE
        0xBCAF, # G+12657  U+BCAF  uniBCAF,  HANGUL SYLLABLE-BCAF
        0xBCB2, # G+12658  U+BCB2  uniBCB2,  HANGUL SYLLABLE-BCB2
        0xBCB6, # G+12659  U+BCB6  uniBCB6,  HANGUL SYLLABLE-BCB6
        0xBCB7, # G+12660  U+BCB7  uniBCB7,  HANGUL SYLLABLE-BCB7
        0xBCB8, # G+12661  U+BCB8  uniBCB8,  HANGUL SYLLABLE-BCB8
        0xBCB9, # G+12662  U+BCB9  uniBCB9,  HANGUL SYLLABLE-BCB9
        0xBCBA, # G+12663  U+BCBA  uniBCBA,  HANGUL SYLLABLE-BCBA
        0xBCBB, # G+12664  U+BCBB  uniBCBB,  HANGUL SYLLABLE-BCBB
        0xBCBE, # G+12665  U+BCBE  uniBCBE,  HANGUL SYLLABLE-BCBE
        0xBCBF, # G+12666  U+BCBF  uniBCBF,  HANGUL SYLLABLE-BCBF
        0xBCC1, # G+12667  U+BCC1  uniBCC1,  HANGUL SYLLABLE-BCC1
        0xBCC2, # G+12668  U+BCC2  uniBCC2,  HANGUL SYLLABLE-BCC2
        0xBCC3, # G+12669  U+BCC3  uniBCC3,  HANGUL SYLLABLE-BCC3
        0xBCC5, # G+12670  U+BCC5  uniBCC5,  HANGUL SYLLABLE-BCC5
        0xBCC6, # G+12671  U+BCC6  uniBCC6,  HANGUL SYLLABLE-BCC6
        0xBCC7, # G+12672  U+BCC7  uniBCC7,  HANGUL SYLLABLE-BCC7
        0xBCC8, # G+12673  U+BCC8  uniBCC8,  HANGUL SYLLABLE-BCC8
        0xBCC9, # G+12674  U+BCC9  uniBCC9,  HANGUL SYLLABLE-BCC9
        0xBCCA, # G+12675  U+BCCA  uniBCCA,  HANGUL SYLLABLE-BCCA
        0xBCCB, # G+12676  U+BCCB  uniBCCB,  HANGUL SYLLABLE-BCCB
        0xBCCC, # G+12677  U+BCCC  uniBCCC,  HANGUL SYLLABLE-BCCC
        0xBCCE, # G+12678  U+BCCE  uniBCCE,  HANGUL SYLLABLE-BCCE
        0xBCD2, # G+12679  U+BCD2  uniBCD2,  HANGUL SYLLABLE-BCD2
        0xBCD3, # G+12680  U+BCD3  uniBCD3,  HANGUL SYLLABLE-BCD3
        0xBCD4, # G+12681  U+BCD4  uniBCD4,  HANGUL SYLLABLE-BCD4
        0xBCD6, # G+12682  U+BCD6  uniBCD6,  HANGUL SYLLABLE-BCD6
        0xBCD7, # G+12683  U+BCD7  uniBCD7,  HANGUL SYLLABLE-BCD7
        0xBCD9, # G+12684  U+BCD9  uniBCD9,  HANGUL SYLLABLE-BCD9
        0xBCDA, # G+12685  U+BCDA  uniBCDA,  HANGUL SYLLABLE-BCDA
        0xBCDB, # G+12686  U+BCDB  uniBCDB,  HANGUL SYLLABLE-BCDB
        0xBCDD, # G+12687  U+BCDD  uniBCDD,  HANGUL SYLLABLE-BCDD
        0xBCDE, # G+12688  U+BCDE  uniBCDE,  HANGUL SYLLABLE-BCDE
        0xBCDF, # G+12689  U+BCDF  uniBCDF,  HANGUL SYLLABLE-BCDF
        0xBCE0, # G+12690  U+BCE0  uniBCE0,  HANGUL SYLLABLE-BCE0
        0xBCE1, # G+12691  U+BCE1  uniBCE1,  HANGUL SYLLABLE-BCE1
        0xBCE2, # G+12692  U+BCE2  uniBCE2,  HANGUL SYLLABLE-BCE2
        0xBCE3, # G+12693  U+BCE3  uniBCE3,  HANGUL SYLLABLE-BCE3
        0xBCE4, # G+12694  U+BCE4  uniBCE4,  HANGUL SYLLABLE-BCE4
        0xBCE5, # G+12695  U+BCE5  uniBCE5,  HANGUL SYLLABLE-BCE5
        0xBCE6, # G+12696  U+BCE6  uniBCE6,  HANGUL SYLLABLE-BCE6
        0xBCE7, # G+12697  U+BCE7  uniBCE7,  HANGUL SYLLABLE-BCE7
        0xBCE8, # G+12698  U+BCE8  uniBCE8,  HANGUL SYLLABLE-BCE8
        0xBCE9, # G+12699  U+BCE9  uniBCE9,  HANGUL SYLLABLE-BCE9
        0xBCEA, # G+12700  U+BCEA  uniBCEA,  HANGUL SYLLABLE-BCEA
        0xBCEB, # G+12701  U+BCEB  uniBCEB,  HANGUL SYLLABLE-BCEB
        0xBCEC, # G+12702  U+BCEC  uniBCEC,  HANGUL SYLLABLE-BCEC
        0xBCED, # G+12703  U+BCED  uniBCED,  HANGUL SYLLABLE-BCED
        0xBCEE, # G+12704  U+BCEE  uniBCEE,  HANGUL SYLLABLE-BCEE
        0xBCEF, # G+12705  U+BCEF  uniBCEF,  HANGUL SYLLABLE-BCEF
        0xBCF0, # G+12706  U+BCF0  uniBCF0,  HANGUL SYLLABLE-BCF0
        0xBCF1, # G+12707  U+BCF1  uniBCF1,  HANGUL SYLLABLE-BCF1
        0xBCF2, # G+12708  U+BCF2  uniBCF2,  HANGUL SYLLABLE-BCF2
        0xBCF3, # G+12709  U+BCF3  uniBCF3,  HANGUL SYLLABLE-BCF3
        0xBCF7, # G+12710  U+BCF7  uniBCF7,  HANGUL SYLLABLE-BCF7
        0xBCF9, # G+12711  U+BCF9  uniBCF9,  HANGUL SYLLABLE-BCF9
        0xBCFA, # G+12712  U+BCFA  uniBCFA,  HANGUL SYLLABLE-BCFA
        0xBCFB, # G+12713  U+BCFB  uniBCFB,  HANGUL SYLLABLE-BCFB
        0xBCFD, # G+12714  U+BCFD  uniBCFD,  HANGUL SYLLABLE-BCFD
        0xBCFE, # G+12715  U+BCFE  uniBCFE,  HANGUL SYLLABLE-BCFE
        0xBCFF, # G+12716  U+BCFF  uniBCFF,  HANGUL SYLLABLE-BCFF
        0xBD00, # G+12717  U+BD00  uniBD00,  HANGUL SYLLABLE-BD00
        0xBD01, # G+12718  U+BD01  uniBD01,  HANGUL SYLLABLE-BD01
        0xBD02, # G+12719  U+BD02  uniBD02,  HANGUL SYLLABLE-BD02
        0xBD03, # G+12720  U+BD03  uniBD03,  HANGUL SYLLABLE-BD03
        0xBD06, # G+12721  U+BD06  uniBD06,  HANGUL SYLLABLE-BD06
        0xBD08, # G+12722  U+BD08  uniBD08,  HANGUL SYLLABLE-BD08
        0xBD0A, # G+12723  U+BD0A  uniBD0A,  HANGUL SYLLABLE-BD0A
        0xBD0B, # G+12724  U+BD0B  uniBD0B,  HANGUL SYLLABLE-BD0B
        0xBD0C, # G+12725  U+BD0C  uniBD0C,  HANGUL SYLLABLE-BD0C
        0xBD0D, # G+12726  U+BD0D  uniBD0D,  HANGUL SYLLABLE-BD0D
        0xBD0E, # G+12727  U+BD0E  uniBD0E,  HANGUL SYLLABLE-BD0E
        0xBD0F, # G+12728  U+BD0F  uniBD0F,  HANGUL SYLLABLE-BD0F
        0xBD11, # G+12729  U+BD11  uniBD11,  HANGUL SYLLABLE-BD11
        0xBD12, # G+12730  U+BD12  uniBD12,  HANGUL SYLLABLE-BD12
        0xBD13, # G+12731  U+BD13  uniBD13,  HANGUL SYLLABLE-BD13
        0xBD15, # G+12732  U+BD15  uniBD15,  HANGUL SYLLABLE-BD15
        0xBD16, # G+12733  U+BD16  uniBD16,  HANGUL SYLLABLE-BD16
        0xBD17, # G+12734  U+BD17  uniBD17,  HANGUL SYLLABLE-BD17
        0xBD18, # G+12735  U+BD18  uniBD18,  HANGUL SYLLABLE-BD18
        0xBD19, # G+12736  U+BD19  uniBD19,  HANGUL SYLLABLE-BD19
        0xBD1A, # G+12737  U+BD1A  uniBD1A,  HANGUL SYLLABLE-BD1A
        0xBD1B, # G+12738  U+BD1B  uniBD1B,  HANGUL SYLLABLE-BD1B
        0xBD1C, # G+12739  U+BD1C  uniBD1C,  HANGUL SYLLABLE-BD1C
        0xBD1D, # G+12740  U+BD1D  uniBD1D,  HANGUL SYLLABLE-BD1D
        0xBD1E, # G+12741  U+BD1E  uniBD1E,  HANGUL SYLLABLE-BD1E
        0xBD1F, # G+12742  U+BD1F  uniBD1F,  HANGUL SYLLABLE-BD1F
        0xBD20, # G+12743  U+BD20  uniBD20,  HANGUL SYLLABLE-BD20
        0xBD21, # G+12744  U+BD21  uniBD21,  HANGUL SYLLABLE-BD21
        0xBD22, # G+12745  U+BD22  uniBD22,  HANGUL SYLLABLE-BD22
        0xBD23, # G+12746  U+BD23  uniBD23,  HANGUL SYLLABLE-BD23
        0xBD25, # G+12747  U+BD25  uniBD25,  HANGUL SYLLABLE-BD25
        0xBD26, # G+12748  U+BD26  uniBD26,  HANGUL SYLLABLE-BD26
        0xBD27, # G+12749  U+BD27  uniBD27,  HANGUL SYLLABLE-BD27
        0xBD28, # G+12750  U+BD28  uniBD28,  HANGUL SYLLABLE-BD28
        0xBD29, # G+12751  U+BD29  uniBD29,  HANGUL SYLLABLE-BD29
        0xBD2A, # G+12752  U+BD2A  uniBD2A,  HANGUL SYLLABLE-BD2A
        0xBD2B, # G+12753  U+BD2B  uniBD2B,  HANGUL SYLLABLE-BD2B
        0xBD2D, # G+12754  U+BD2D  uniBD2D,  HANGUL SYLLABLE-BD2D
        0xBD2E, # G+12755  U+BD2E  uniBD2E,  HANGUL SYLLABLE-BD2E
        0xBD2F, # G+12756  U+BD2F  uniBD2F,  HANGUL SYLLABLE-BD2F
        0xBD30, # G+12757  U+BD30  uniBD30,  HANGUL SYLLABLE-BD30
        0xBD31, # G+12758  U+BD31  uniBD31,  HANGUL SYLLABLE-BD31
        0xBD32, # G+12759  U+BD32  uniBD32,  HANGUL SYLLABLE-BD32
        0xBD33, # G+12760  U+BD33  uniBD33,  HANGUL SYLLABLE-BD33
        0xBD34, # G+12761  U+BD34  uniBD34,  HANGUL SYLLABLE-BD34
        0xBD35, # G+12762  U+BD35  uniBD35,  HANGUL SYLLABLE-BD35
        0xBD36, # G+12763  U+BD36  uniBD36,  HANGUL SYLLABLE-BD36
        0xBD37, # G+12764  U+BD37  uniBD37,  HANGUL SYLLABLE-BD37
        0xBD38, # G+12765  U+BD38  uniBD38,  HANGUL SYLLABLE-BD38
        0xBD39, # G+12766  U+BD39  uniBD39,  HANGUL SYLLABLE-BD39
        0xBD3A, # G+12767  U+BD3A  uniBD3A,  HANGUL SYLLABLE-BD3A
        0xBD3B, # G+12768  U+BD3B  uniBD3B,  HANGUL SYLLABLE-BD3B
        0xBD3C, # G+12769  U+BD3C  uniBD3C,  HANGUL SYLLABLE-BD3C
        0xBD3D, # G+12770  U+BD3D  uniBD3D,  HANGUL SYLLABLE-BD3D
        0xBD3E, # G+12771  U+BD3E  uniBD3E,  HANGUL SYLLABLE-BD3E
        0xBD3F, # G+12772  U+BD3F  uniBD3F,  HANGUL SYLLABLE-BD3F
        0xBD41, # G+12773  U+BD41  uniBD41,  HANGUL SYLLABLE-BD41
        0xBD42, # G+12774  U+BD42  uniBD42,  HANGUL SYLLABLE-BD42
        0xBD43, # G+12775  U+BD43  uniBD43,  HANGUL SYLLABLE-BD43
        0xBD44, # G+12776  U+BD44  uniBD44,  HANGUL SYLLABLE-BD44
        0xBD45, # G+12777  U+BD45  uniBD45,  HANGUL SYLLABLE-BD45
        0xBD46, # G+12778  U+BD46  uniBD46,  HANGUL SYLLABLE-BD46
        0xBD47, # G+12779  U+BD47  uniBD47,  HANGUL SYLLABLE-BD47
        0xBD4A, # G+12780  U+BD4A  uniBD4A,  HANGUL SYLLABLE-BD4A
        0xBD4B, # G+12781  U+BD4B  uniBD4B,  HANGUL SYLLABLE-BD4B
        0xBD4D, # G+12782  U+BD4D  uniBD4D,  HANGUL SYLLABLE-BD4D
        0xBD4E, # G+12783  U+BD4E  uniBD4E,  HANGUL SYLLABLE-BD4E
        0xBD4F, # G+12784  U+BD4F  uniBD4F,  HANGUL SYLLABLE-BD4F
        0xBD51, # G+12785  U+BD51  uniBD51,  HANGUL SYLLABLE-BD51
        0xBD52, # G+12786  U+BD52  uniBD52,  HANGUL SYLLABLE-BD52
        0xBD53, # G+12787  U+BD53  uniBD53,  HANGUL SYLLABLE-BD53
        0xBD54, # G+12788  U+BD54  uniBD54,  HANGUL SYLLABLE-BD54
        0xBD55, # G+12789  U+BD55  uniBD55,  HANGUL SYLLABLE-BD55
        0xBD56, # G+12790  U+BD56  uniBD56,  HANGUL SYLLABLE-BD56
        0xBD57, # G+12791  U+BD57  uniBD57,  HANGUL SYLLABLE-BD57
        0xBD5A, # G+12792  U+BD5A  uniBD5A,  HANGUL SYLLABLE-BD5A
        0xBD5B, # G+12793  U+BD5B  uniBD5B,  HANGUL SYLLABLE-BD5B
        0xBD5C, # G+12794  U+BD5C  uniBD5C,  HANGUL SYLLABLE-BD5C
        0xBD5D, # G+12795  U+BD5D  uniBD5D,  HANGUL SYLLABLE-BD5D
        0xBD5E, # G+12796  U+BD5E  uniBD5E,  HANGUL SYLLABLE-BD5E
        0xBD5F, # G+12797  U+BD5F  uniBD5F,  HANGUL SYLLABLE-BD5F
        0xBD60, # G+12798  U+BD60  uniBD60,  HANGUL SYLLABLE-BD60
        0xBD61, # G+12799  U+BD61  uniBD61,  HANGUL SYLLABLE-BD61
        0xBD62, # G+12800  U+BD62  uniBD62,  HANGUL SYLLABLE-BD62
        0xBD63, # G+12801  U+BD63  uniBD63,  HANGUL SYLLABLE-BD63
        0xBD65, # G+12802  U+BD65  uniBD65,  HANGUL SYLLABLE-BD65
        0xBD66, # G+12803  U+BD66  uniBD66,  HANGUL SYLLABLE-BD66
        0xBD67, # G+12804  U+BD67  uniBD67,  HANGUL SYLLABLE-BD67
        0xBD69, # G+12805  U+BD69  uniBD69,  HANGUL SYLLABLE-BD69
        0xBD6A, # G+12806  U+BD6A  uniBD6A,  HANGUL SYLLABLE-BD6A
        0xBD6B, # G+12807  U+BD6B  uniBD6B,  HANGUL SYLLABLE-BD6B
        0xBD6C, # G+12808  U+BD6C  uniBD6C,  HANGUL SYLLABLE-BD6C
        0xBD6D, # G+12809  U+BD6D  uniBD6D,  HANGUL SYLLABLE-BD6D
        0xBD6E, # G+12810  U+BD6E  uniBD6E,  HANGUL SYLLABLE-BD6E
        0xBD6F, # G+12811  U+BD6F  uniBD6F,  HANGUL SYLLABLE-BD6F
        0xBD70, # G+12812  U+BD70  uniBD70,  HANGUL SYLLABLE-BD70
        0xBD71, # G+12813  U+BD71  uniBD71,  HANGUL SYLLABLE-BD71
        0xBD72, # G+12814  U+BD72  uniBD72,  HANGUL SYLLABLE-BD72
        0xBD73, # G+12815  U+BD73  uniBD73,  HANGUL SYLLABLE-BD73
        0xBD74, # G+12816  U+BD74  uniBD74,  HANGUL SYLLABLE-BD74
        0xBD75, # G+12817  U+BD75  uniBD75,  HANGUL SYLLABLE-BD75
        0xBD76, # G+12818  U+BD76  uniBD76,  HANGUL SYLLABLE-BD76
        0xBD77, # G+12819  U+BD77  uniBD77,  HANGUL SYLLABLE-BD77
        0xBD78, # G+12820  U+BD78  uniBD78,  HANGUL SYLLABLE-BD78
        0xBD79, # G+12821  U+BD79  uniBD79,  HANGUL SYLLABLE-BD79
        0xBD7A, # G+12822  U+BD7A  uniBD7A,  HANGUL SYLLABLE-BD7A
        0xBD7B, # G+12823  U+BD7B  uniBD7B,  HANGUL SYLLABLE-BD7B
        0xBD7C, # G+12824  U+BD7C  uniBD7C,  HANGUL SYLLABLE-BD7C
        0xBD7D, # G+12825  U+BD7D  uniBD7D,  HANGUL SYLLABLE-BD7D
        0xBD7E, # G+12826  U+BD7E  uniBD7E,  HANGUL SYLLABLE-BD7E
        0xBD7F, # G+12827  U+BD7F  uniBD7F,  HANGUL SYLLABLE-BD7F
        0xBD82, # G+12828  U+BD82  uniBD82,  HANGUL SYLLABLE-BD82
        0xBD83, # G+12829  U+BD83  uniBD83,  HANGUL SYLLABLE-BD83
        0xBD85, # G+12830  U+BD85  uniBD85,  HANGUL SYLLABLE-BD85
        0xBD86, # G+12831  U+BD86  uniBD86,  HANGUL SYLLABLE-BD86
        0xBD8B, # G+12832  U+BD8B  uniBD8B,  HANGUL SYLLABLE-BD8B
        0xBD8C, # G+12833  U+BD8C  uniBD8C,  HANGUL SYLLABLE-BD8C
        0xBD8D, # G+12834  U+BD8D  uniBD8D,  HANGUL SYLLABLE-BD8D
        0xBD8E, # G+12835  U+BD8E  uniBD8E,  HANGUL SYLLABLE-BD8E
        0xBD8F, # G+12836  U+BD8F  uniBD8F,  HANGUL SYLLABLE-BD8F
        0xBD92, # G+12837  U+BD92  uniBD92,  HANGUL SYLLABLE-BD92
        0xBD94, # G+12838  U+BD94  uniBD94,  HANGUL SYLLABLE-BD94
        0xBD96, # G+12839  U+BD96  uniBD96,  HANGUL SYLLABLE-BD96
        0xBD97, # G+12840  U+BD97  uniBD97,  HANGUL SYLLABLE-BD97
        0xBD98, # G+12841  U+BD98  uniBD98,  HANGUL SYLLABLE-BD98
        0xBD9B, # G+12842  U+BD9B  uniBD9B,  HANGUL SYLLABLE-BD9B
        0xBD9D, # G+12843  U+BD9D  uniBD9D,  HANGUL SYLLABLE-BD9D
        0xBD9E, # G+12844  U+BD9E  uniBD9E,  HANGUL SYLLABLE-BD9E
        0xBD9F, # G+12845  U+BD9F  uniBD9F,  HANGUL SYLLABLE-BD9F
        0xBDA0, # G+12846  U+BDA0  uniBDA0,  HANGUL SYLLABLE-BDA0
        0xBDA1, # G+12847  U+BDA1  uniBDA1,  HANGUL SYLLABLE-BDA1
        0xBDA2, # G+12848  U+BDA2  uniBDA2,  HANGUL SYLLABLE-BDA2
        0xBDA3, # G+12849  U+BDA3  uniBDA3,  HANGUL SYLLABLE-BDA3
        0xBDA5, # G+12850  U+BDA5  uniBDA5,  HANGUL SYLLABLE-BDA5
        0xBDA6, # G+12851  U+BDA6  uniBDA6,  HANGUL SYLLABLE-BDA6
        0xBDA7, # G+12852  U+BDA7  uniBDA7,  HANGUL SYLLABLE-BDA7
        0xBDA8, # G+12853  U+BDA8  uniBDA8,  HANGUL SYLLABLE-BDA8
        0xBDA9, # G+12854  U+BDA9  uniBDA9,  HANGUL SYLLABLE-BDA9
        0xBDAA, # G+12855  U+BDAA  uniBDAA,  HANGUL SYLLABLE-BDAA
        0xBDAB, # G+12856  U+BDAB  uniBDAB,  HANGUL SYLLABLE-BDAB
        0xBDAC, # G+12857  U+BDAC  uniBDAC,  HANGUL SYLLABLE-BDAC
        0xBDAD, # G+12858  U+BDAD  uniBDAD,  HANGUL SYLLABLE-BDAD
        0xBDAE, # G+12859  U+BDAE  uniBDAE,  HANGUL SYLLABLE-BDAE
        0xBDAF, # G+12860  U+BDAF  uniBDAF,  HANGUL SYLLABLE-BDAF
        0xBDB1, # G+12861  U+BDB1  uniBDB1,  HANGUL SYLLABLE-BDB1
        0xBDB2, # G+12862  U+BDB2  uniBDB2,  HANGUL SYLLABLE-BDB2
        0xBDB3, # G+12863  U+BDB3  uniBDB3,  HANGUL SYLLABLE-BDB3
        0xBDB4, # G+12864  U+BDB4  uniBDB4,  HANGUL SYLLABLE-BDB4
        0xBDB5, # G+12865  U+BDB5  uniBDB5,  HANGUL SYLLABLE-BDB5
        0xBDB6, # G+12866  U+BDB6  uniBDB6,  HANGUL SYLLABLE-BDB6
        0xBDB7, # G+12867  U+BDB7  uniBDB7,  HANGUL SYLLABLE-BDB7
        0xBDB9, # G+12868  U+BDB9  uniBDB9,  HANGUL SYLLABLE-BDB9
        0xBDBA, # G+12869  U+BDBA  uniBDBA,  HANGUL SYLLABLE-BDBA
        0xBDBB, # G+12870  U+BDBB  uniBDBB,  HANGUL SYLLABLE-BDBB
        0xBDBC, # G+12871  U+BDBC  uniBDBC,  HANGUL SYLLABLE-BDBC
        0xBDBD, # G+12872  U+BDBD  uniBDBD,  HANGUL SYLLABLE-BDBD
        0xBDBE, # G+12873  U+BDBE  uniBDBE,  HANGUL SYLLABLE-BDBE
        0xBDBF, # G+12874  U+BDBF  uniBDBF,  HANGUL SYLLABLE-BDBF
        0xBDC0, # G+12875  U+BDC0  uniBDC0,  HANGUL SYLLABLE-BDC0
        0xBDC1, # G+12876  U+BDC1  uniBDC1,  HANGUL SYLLABLE-BDC1
        0xBDC2, # G+12877  U+BDC2  uniBDC2,  HANGUL SYLLABLE-BDC2
        0xBDC3, # G+12878  U+BDC3  uniBDC3,  HANGUL SYLLABLE-BDC3
        0xBDC4, # G+12879  U+BDC4  uniBDC4,  HANGUL SYLLABLE-BDC4
        0xBDC5, # G+12880  U+BDC5  uniBDC5,  HANGUL SYLLABLE-BDC5
        0xBDC6, # G+12881  U+BDC6  uniBDC6,  HANGUL SYLLABLE-BDC6
        0xBDC7, # G+12882  U+BDC7  uniBDC7,  HANGUL SYLLABLE-BDC7
        0xBDC8, # G+12883  U+BDC8  uniBDC8,  HANGUL SYLLABLE-BDC8
        0xBDC9, # G+12884  U+BDC9  uniBDC9,  HANGUL SYLLABLE-BDC9
        0xBDCA, # G+12885  U+BDCA  uniBDCA,  HANGUL SYLLABLE-BDCA
        0xBDCB, # G+12886  U+BDCB  uniBDCB,  HANGUL SYLLABLE-BDCB
        0xBDCC, # G+12887  U+BDCC  uniBDCC,  HANGUL SYLLABLE-BDCC
        0xBDCD, # G+12888  U+BDCD  uniBDCD,  HANGUL SYLLABLE-BDCD
        0xBDCE, # G+12889  U+BDCE  uniBDCE,  HANGUL SYLLABLE-BDCE
        0xBDCF, # G+12890  U+BDCF  uniBDCF,  HANGUL SYLLABLE-BDCF
        0xBDD0, # G+12891  U+BDD0  uniBDD0,  HANGUL SYLLABLE-BDD0
        0xBDD1, # G+12892  U+BDD1  uniBDD1,  HANGUL SYLLABLE-BDD1
        0xBDD2, # G+12893  U+BDD2  uniBDD2,  HANGUL SYLLABLE-BDD2
        0xBDD3, # G+12894  U+BDD3  uniBDD3,  HANGUL SYLLABLE-BDD3
        0xBDD6, # G+12895  U+BDD6  uniBDD6,  HANGUL SYLLABLE-BDD6
        0xBDD7, # G+12896  U+BDD7  uniBDD7,  HANGUL SYLLABLE-BDD7
        0xBDD9, # G+12897  U+BDD9  uniBDD9,  HANGUL SYLLABLE-BDD9
        0xBDDA, # G+12898  U+BDDA  uniBDDA,  HANGUL SYLLABLE-BDDA
        0xBDDB, # G+12899  U+BDDB  uniBDDB,  HANGUL SYLLABLE-BDDB
        0xBDDD, # G+12900  U+BDDD  uniBDDD,  HANGUL SYLLABLE-BDDD
        0xBDDE, # G+12901  U+BDDE  uniBDDE,  HANGUL SYLLABLE-BDDE
        0xBDDF, # G+12902  U+BDDF  uniBDDF,  HANGUL SYLLABLE-BDDF
        0xBDE0, # G+12903  U+BDE0  uniBDE0,  HANGUL SYLLABLE-BDE0
        0xBDE1, # G+12904  U+BDE1  uniBDE1,  HANGUL SYLLABLE-BDE1
        0xBDE2, # G+12905  U+BDE2  uniBDE2,  HANGUL SYLLABLE-BDE2
        0xBDE3, # G+12906  U+BDE3  uniBDE3,  HANGUL SYLLABLE-BDE3
        0xBDE4, # G+12907  U+BDE4  uniBDE4,  HANGUL SYLLABLE-BDE4
        0xBDE5, # G+12908  U+BDE5  uniBDE5,  HANGUL SYLLABLE-BDE5
        0xBDE6, # G+12909  U+BDE6  uniBDE6,  HANGUL SYLLABLE-BDE6
        0xBDE7, # G+12910  U+BDE7  uniBDE7,  HANGUL SYLLABLE-BDE7
        0xBDE8, # G+12911  U+BDE8  uniBDE8,  HANGUL SYLLABLE-BDE8
        0xBDEA, # G+12912  U+BDEA  uniBDEA,  HANGUL SYLLABLE-BDEA
        0xBDEB, # G+12913  U+BDEB  uniBDEB,  HANGUL SYLLABLE-BDEB
        0xBDEC, # G+12914  U+BDEC  uniBDEC,  HANGUL SYLLABLE-BDEC
        0xBDED, # G+12915  U+BDED  uniBDED,  HANGUL SYLLABLE-BDED
        0xBDEE, # G+12916  U+BDEE  uniBDEE,  HANGUL SYLLABLE-BDEE
        0xBDEF, # G+12917  U+BDEF  uniBDEF,  HANGUL SYLLABLE-BDEF
        0xBDF1, # G+12918  U+BDF1  uniBDF1,  HANGUL SYLLABLE-BDF1
        0xBDF2, # G+12919  U+BDF2  uniBDF2,  HANGUL SYLLABLE-BDF2
        0xBDF3, # G+12920  U+BDF3  uniBDF3,  HANGUL SYLLABLE-BDF3
        0xBDF5, # G+12921  U+BDF5  uniBDF5,  HANGUL SYLLABLE-BDF5
        0xBDF6, # G+12922  U+BDF6  uniBDF6,  HANGUL SYLLABLE-BDF6
        0xBDF7, # G+12923  U+BDF7  uniBDF7,  HANGUL SYLLABLE-BDF7
        0xBDF9, # G+12924  U+BDF9  uniBDF9,  HANGUL SYLLABLE-BDF9
        0xBDFA, # G+12925  U+BDFA  uniBDFA,  HANGUL SYLLABLE-BDFA
        0xBDFB, # G+12926  U+BDFB  uniBDFB,  HANGUL SYLLABLE-BDFB
        0xBDFC, # G+12927  U+BDFC  uniBDFC,  HANGUL SYLLABLE-BDFC
        0xBDFD, # G+12928  U+BDFD  uniBDFD,  HANGUL SYLLABLE-BDFD
        0xBDFE, # G+12929  U+BDFE  uniBDFE,  HANGUL SYLLABLE-BDFE
        0xBDFF, # G+12930  U+BDFF  uniBDFF,  HANGUL SYLLABLE-BDFF
        0xBE01, # G+12931  U+BE01  uniBE01,  HANGUL SYLLABLE-BE01
        0xBE02, # G+12932  U+BE02  uniBE02,  HANGUL SYLLABLE-BE02
        0xBE04, # G+12933  U+BE04  uniBE04,  HANGUL SYLLABLE-BE04
        0xBE06, # G+12934  U+BE06  uniBE06,  HANGUL SYLLABLE-BE06
        0xBE07, # G+12935  U+BE07  uniBE07,  HANGUL SYLLABLE-BE07
        0xBE08, # G+12936  U+BE08  uniBE08,  HANGUL SYLLABLE-BE08
        0xBE09, # G+12937  U+BE09  uniBE09,  HANGUL SYLLABLE-BE09
        0xBE0A, # G+12938  U+BE0A  uniBE0A,  HANGUL SYLLABLE-BE0A
        0xBE0B, # G+12939  U+BE0B  uniBE0B,  HANGUL SYLLABLE-BE0B
        0xBE0E, # G+12940  U+BE0E  uniBE0E,  HANGUL SYLLABLE-BE0E
        0xBE0F, # G+12941  U+BE0F  uniBE0F,  HANGUL SYLLABLE-BE0F
        0xBE11, # G+12942  U+BE11  uniBE11,  HANGUL SYLLABLE-BE11
        0xBE12, # G+12943  U+BE12  uniBE12,  HANGUL SYLLABLE-BE12
        0xBE13, # G+12944  U+BE13  uniBE13,  HANGUL SYLLABLE-BE13
        0xBE15, # G+12945  U+BE15  uniBE15,  HANGUL SYLLABLE-BE15
        0xBE16, # G+12946  U+BE16  uniBE16,  HANGUL SYLLABLE-BE16
        0xBE17, # G+12947  U+BE17  uniBE17,  HANGUL SYLLABLE-BE17
        0xBE18, # G+12948  U+BE18  uniBE18,  HANGUL SYLLABLE-BE18
        0xBE19, # G+12949  U+BE19  uniBE19,  HANGUL SYLLABLE-BE19
        0xBE1A, # G+12950  U+BE1A  uniBE1A,  HANGUL SYLLABLE-BE1A
        0xBE1B, # G+12951  U+BE1B  uniBE1B,  HANGUL SYLLABLE-BE1B
        0xBE1E, # G+12952  U+BE1E  uniBE1E,  HANGUL SYLLABLE-BE1E
        0xBE20, # G+12953  U+BE20  uniBE20,  HANGUL SYLLABLE-BE20
        0xBE21, # G+12954  U+BE21  uniBE21,  HANGUL SYLLABLE-BE21
        0xBE22, # G+12955  U+BE22  uniBE22,  HANGUL SYLLABLE-BE22
        0xBE23, # G+12956  U+BE23  uniBE23,  HANGUL SYLLABLE-BE23
        0xBE24, # G+12957  U+BE24  uniBE24,  HANGUL SYLLABLE-BE24
        0xBE25, # G+12958  U+BE25  uniBE25,  HANGUL SYLLABLE-BE25
        0xBE26, # G+12959  U+BE26  uniBE26,  HANGUL SYLLABLE-BE26
        0xBE27, # G+12960  U+BE27  uniBE27,  HANGUL SYLLABLE-BE27
        0xBE28, # G+12961  U+BE28  uniBE28,  HANGUL SYLLABLE-BE28
        0xBE29, # G+12962  U+BE29  uniBE29,  HANGUL SYLLABLE-BE29
        0xBE2A, # G+12963  U+BE2A  uniBE2A,  HANGUL SYLLABLE-BE2A
        0xBE2B, # G+12964  U+BE2B  uniBE2B,  HANGUL SYLLABLE-BE2B
        0xBE2C, # G+12965  U+BE2C  uniBE2C,  HANGUL SYLLABLE-BE2C
        0xBE2D, # G+12966  U+BE2D  uniBE2D,  HANGUL SYLLABLE-BE2D
        0xBE2E, # G+12967  U+BE2E  uniBE2E,  HANGUL SYLLABLE-BE2E
        0xBE2F, # G+12968  U+BE2F  uniBE2F,  HANGUL SYLLABLE-BE2F
        0xBE30, # G+12969  U+BE30  uniBE30,  HANGUL SYLLABLE-BE30
        0xBE31, # G+12970  U+BE31  uniBE31,  HANGUL SYLLABLE-BE31
        0xBE32, # G+12971  U+BE32  uniBE32,  HANGUL SYLLABLE-BE32
        0xBE33, # G+12972  U+BE33  uniBE33,  HANGUL SYLLABLE-BE33
        0xBE34, # G+12973  U+BE34  uniBE34,  HANGUL SYLLABLE-BE34
        0xBE35, # G+12974  U+BE35  uniBE35,  HANGUL SYLLABLE-BE35
        0xBE36, # G+12975  U+BE36  uniBE36,  HANGUL SYLLABLE-BE36
        0xBE37, # G+12976  U+BE37  uniBE37,  HANGUL SYLLABLE-BE37
        0xBE38, # G+12977  U+BE38  uniBE38,  HANGUL SYLLABLE-BE38
        0xBE39, # G+12978  U+BE39  uniBE39,  HANGUL SYLLABLE-BE39
        0xBE3A, # G+12979  U+BE3A  uniBE3A,  HANGUL SYLLABLE-BE3A
        0xBE3B, # G+12980  U+BE3B  uniBE3B,  HANGUL SYLLABLE-BE3B
        0xBE3C, # G+12981  U+BE3C  uniBE3C,  HANGUL SYLLABLE-BE3C
        0xBE3D, # G+12982  U+BE3D  uniBE3D,  HANGUL SYLLABLE-BE3D
        0xBE3E, # G+12983  U+BE3E  uniBE3E,  HANGUL SYLLABLE-BE3E
        0xBE3F, # G+12984  U+BE3F  uniBE3F,  HANGUL SYLLABLE-BE3F
        0xBE40, # G+12985  U+BE40  uniBE40,  HANGUL SYLLABLE-BE40
        0xBE41, # G+12986  U+BE41  uniBE41,  HANGUL SYLLABLE-BE41
        0xBE42, # G+12987  U+BE42  uniBE42,  HANGUL SYLLABLE-BE42
        0xBE43, # G+12988  U+BE43  uniBE43,  HANGUL SYLLABLE-BE43
        0xBE46, # G+12989  U+BE46  uniBE46,  HANGUL SYLLABLE-BE46
        0xBE47, # G+12990  U+BE47  uniBE47,  HANGUL SYLLABLE-BE47
        0xBE49, # G+12991  U+BE49  uniBE49,  HANGUL SYLLABLE-BE49
        0xBE4A, # G+12992  U+BE4A  uniBE4A,  HANGUL SYLLABLE-BE4A
        0xBE4B, # G+12993  U+BE4B  uniBE4B,  HANGUL SYLLABLE-BE4B
        0xBE4D, # G+12994  U+BE4D  uniBE4D,  HANGUL SYLLABLE-BE4D
        0xBE4F, # G+12995  U+BE4F  uniBE4F,  HANGUL SYLLABLE-BE4F
        0xBE50, # G+12996  U+BE50  uniBE50,  HANGUL SYLLABLE-BE50
        0xBE51, # G+12997  U+BE51  uniBE51,  HANGUL SYLLABLE-BE51
        0xBE52, # G+12998  U+BE52  uniBE52,  HANGUL SYLLABLE-BE52
        0xBE53, # G+12999  U+BE53  uniBE53,  HANGUL SYLLABLE-BE53
        0xBE56, # G+13000  U+BE56  uniBE56,  HANGUL SYLLABLE-BE56
        0xBE58, # G+13001  U+BE58  uniBE58,  HANGUL SYLLABLE-BE58
        0xBE5C, # G+13002  U+BE5C  uniBE5C,  HANGUL SYLLABLE-BE5C
        0xBE5D, # G+13003  U+BE5D  uniBE5D,  HANGUL SYLLABLE-BE5D
        0xBE5E, # G+13004  U+BE5E  uniBE5E,  HANGUL SYLLABLE-BE5E
        0xBE5F, # G+13005  U+BE5F  uniBE5F,  HANGUL SYLLABLE-BE5F
        0xBE62, # G+13006  U+BE62  uniBE62,  HANGUL SYLLABLE-BE62
        0xBE63, # G+13007  U+BE63  uniBE63,  HANGUL SYLLABLE-BE63
        0xBE65, # G+13008  U+BE65  uniBE65,  HANGUL SYLLABLE-BE65
        0xBE66, # G+13009  U+BE66  uniBE66,  HANGUL SYLLABLE-BE66
        0xBE67, # G+13010  U+BE67  uniBE67,  HANGUL SYLLABLE-BE67
        0xBE69, # G+13011  U+BE69  uniBE69,  HANGUL SYLLABLE-BE69
        0xBE6B, # G+13012  U+BE6B  uniBE6B,  HANGUL SYLLABLE-BE6B
        0xBE6C, # G+13013  U+BE6C  uniBE6C,  HANGUL SYLLABLE-BE6C
        0xBE6D, # G+13014  U+BE6D  uniBE6D,  HANGUL SYLLABLE-BE6D
        0xBE6E, # G+13015  U+BE6E  uniBE6E,  HANGUL SYLLABLE-BE6E
        0xBE6F, # G+13016  U+BE6F  uniBE6F,  HANGUL SYLLABLE-BE6F
        0xBE72, # G+13017  U+BE72  uniBE72,  HANGUL SYLLABLE-BE72
        0xBE76, # G+13018  U+BE76  uniBE76,  HANGUL SYLLABLE-BE76
        0xBE77, # G+13019  U+BE77  uniBE77,  HANGUL SYLLABLE-BE77
        0xBE78, # G+13020  U+BE78  uniBE78,  HANGUL SYLLABLE-BE78
        0xBE79, # G+13021  U+BE79  uniBE79,  HANGUL SYLLABLE-BE79
        0xBE7A, # G+13022  U+BE7A  uniBE7A,  HANGUL SYLLABLE-BE7A
        0xBE7E, # G+13023  U+BE7E  uniBE7E,  HANGUL SYLLABLE-BE7E
        0xBE7F, # G+13024  U+BE7F  uniBE7F,  HANGUL SYLLABLE-BE7F
        0xBE81, # G+13025  U+BE81  uniBE81,  HANGUL SYLLABLE-BE81
        0xBE82, # G+13026  U+BE82  uniBE82,  HANGUL SYLLABLE-BE82
        0xBE83, # G+13027  U+BE83  uniBE83,  HANGUL SYLLABLE-BE83
        0xBE85, # G+13028  U+BE85  uniBE85,  HANGUL SYLLABLE-BE85
        0xBE86, # G+13029  U+BE86  uniBE86,  HANGUL SYLLABLE-BE86
        0xBE87, # G+13030  U+BE87  uniBE87,  HANGUL SYLLABLE-BE87
        0xBE88, # G+13031  U+BE88  uniBE88,  HANGUL SYLLABLE-BE88
        0xBE89, # G+13032  U+BE89  uniBE89,  HANGUL SYLLABLE-BE89
        0xBE8A, # G+13033  U+BE8A  uniBE8A,  HANGUL SYLLABLE-BE8A
        0xBE8B, # G+13034  U+BE8B  uniBE8B,  HANGUL SYLLABLE-BE8B
        0xBE8E, # G+13035  U+BE8E  uniBE8E,  HANGUL SYLLABLE-BE8E
        0xBE92, # G+13036  U+BE92  uniBE92,  HANGUL SYLLABLE-BE92
        0xBE93, # G+13037  U+BE93  uniBE93,  HANGUL SYLLABLE-BE93
        0xBE94, # G+13038  U+BE94  uniBE94,  HANGUL SYLLABLE-BE94
        0xBE95, # G+13039  U+BE95  uniBE95,  HANGUL SYLLABLE-BE95
        0xBE96, # G+13040  U+BE96  uniBE96,  HANGUL SYLLABLE-BE96
        0xBE97, # G+13041  U+BE97  uniBE97,  HANGUL SYLLABLE-BE97
        0xBE9A, # G+13042  U+BE9A  uniBE9A,  HANGUL SYLLABLE-BE9A
        0xBE9B, # G+13043  U+BE9B  uniBE9B,  HANGUL SYLLABLE-BE9B
        0xBE9C, # G+13044  U+BE9C  uniBE9C,  HANGUL SYLLABLE-BE9C
        0xBE9D, # G+13045  U+BE9D  uniBE9D,  HANGUL SYLLABLE-BE9D
        0xBE9E, # G+13046  U+BE9E  uniBE9E,  HANGUL SYLLABLE-BE9E
        0xBE9F, # G+13047  U+BE9F  uniBE9F,  HANGUL SYLLABLE-BE9F
        0xBEA0, # G+13048  U+BEA0  uniBEA0,  HANGUL SYLLABLE-BEA0
        0xBEA1, # G+13049  U+BEA1  uniBEA1,  HANGUL SYLLABLE-BEA1
        0xBEA2, # G+13050  U+BEA2  uniBEA2,  HANGUL SYLLABLE-BEA2
        0xBEA3, # G+13051  U+BEA3  uniBEA3,  HANGUL SYLLABLE-BEA3
        0xBEA4, # G+13052  U+BEA4  uniBEA4,  HANGUL SYLLABLE-BEA4
        0xBEA5, # G+13053  U+BEA5  uniBEA5,  HANGUL SYLLABLE-BEA5
        0xBEA6, # G+13054  U+BEA6  uniBEA6,  HANGUL SYLLABLE-BEA6
        0xBEA7, # G+13055  U+BEA7  uniBEA7,  HANGUL SYLLABLE-BEA7
        0xBEA9, # G+13056  U+BEA9  uniBEA9,  HANGUL SYLLABLE-BEA9
        0xBEAA, # G+13057  U+BEAA  uniBEAA,  HANGUL SYLLABLE-BEAA
        0xBEAB, # G+13058  U+BEAB  uniBEAB,  HANGUL SYLLABLE-BEAB
        0xBEAC, # G+13059  U+BEAC  uniBEAC,  HANGUL SYLLABLE-BEAC
        0xBEAD, # G+13060  U+BEAD  uniBEAD,  HANGUL SYLLABLE-BEAD
        0xBEAE, # G+13061  U+BEAE  uniBEAE,  HANGUL SYLLABLE-BEAE
        0xBEAF, # G+13062  U+BEAF  uniBEAF,  HANGUL SYLLABLE-BEAF
        0xBEB0, # G+13063  U+BEB0  uniBEB0,  HANGUL SYLLABLE-BEB0
        0xBEB1, # G+13064  U+BEB1  uniBEB1,  HANGUL SYLLABLE-BEB1
        0xBEB2, # G+13065  U+BEB2  uniBEB2,  HANGUL SYLLABLE-BEB2
        0xBEB3, # G+13066  U+BEB3  uniBEB3,  HANGUL SYLLABLE-BEB3
        0xBEB4, # G+13067  U+BEB4  uniBEB4,  HANGUL SYLLABLE-BEB4
        0xBEB5, # G+13068  U+BEB5  uniBEB5,  HANGUL SYLLABLE-BEB5
        0xBEB6, # G+13069  U+BEB6  uniBEB6,  HANGUL SYLLABLE-BEB6
        0xBEB7, # G+13070  U+BEB7  uniBEB7,  HANGUL SYLLABLE-BEB7
        0xBEB8, # G+13071  U+BEB8  uniBEB8,  HANGUL SYLLABLE-BEB8
        0xBEB9, # G+13072  U+BEB9  uniBEB9,  HANGUL SYLLABLE-BEB9
        0xBEBA, # G+13073  U+BEBA  uniBEBA,  HANGUL SYLLABLE-BEBA
        0xBEBB, # G+13074  U+BEBB  uniBEBB,  HANGUL SYLLABLE-BEBB
        0xBEBC, # G+13075  U+BEBC  uniBEBC,  HANGUL SYLLABLE-BEBC
        0xBEBD, # G+13076  U+BEBD  uniBEBD,  HANGUL SYLLABLE-BEBD
        0xBEBE, # G+13077  U+BEBE  uniBEBE,  HANGUL SYLLABLE-BEBE
        0xBEBF, # G+13078  U+BEBF  uniBEBF,  HANGUL SYLLABLE-BEBF
        0xBEC0, # G+13079  U+BEC0  uniBEC0,  HANGUL SYLLABLE-BEC0
        0xBEC1, # G+13080  U+BEC1  uniBEC1,  HANGUL SYLLABLE-BEC1
        0xBEC2, # G+13081  U+BEC2  uniBEC2,  HANGUL SYLLABLE-BEC2
        0xBEC3, # G+13082  U+BEC3  uniBEC3,  HANGUL SYLLABLE-BEC3
        0xBEC4, # G+13083  U+BEC4  uniBEC4,  HANGUL SYLLABLE-BEC4
        0xBEC5, # G+13084  U+BEC5  uniBEC5,  HANGUL SYLLABLE-BEC5
        0xBEC6, # G+13085  U+BEC6  uniBEC6,  HANGUL SYLLABLE-BEC6
        0xBEC7, # G+13086  U+BEC7  uniBEC7,  HANGUL SYLLABLE-BEC7
        0xBEC8, # G+13087  U+BEC8  uniBEC8,  HANGUL SYLLABLE-BEC8
        0xBEC9, # G+13088  U+BEC9  uniBEC9,  HANGUL SYLLABLE-BEC9
        0xBECA, # G+13089  U+BECA  uniBECA,  HANGUL SYLLABLE-BECA
        0xBECB, # G+13090  U+BECB  uniBECB,  HANGUL SYLLABLE-BECB
        0xBECC, # G+13091  U+BECC  uniBECC,  HANGUL SYLLABLE-BECC
        0xBECD, # G+13092  U+BECD  uniBECD,  HANGUL SYLLABLE-BECD
        0xBECE, # G+13093  U+BECE  uniBECE,  HANGUL SYLLABLE-BECE
        0xBECF, # G+13094  U+BECF  uniBECF,  HANGUL SYLLABLE-BECF
        0xBED2, # G+13095  U+BED2  uniBED2,  HANGUL SYLLABLE-BED2
        0xBED3, # G+13096  U+BED3  uniBED3,  HANGUL SYLLABLE-BED3
        0xBED5, # G+13097  U+BED5  uniBED5,  HANGUL SYLLABLE-BED5
        0xBED6, # G+13098  U+BED6  uniBED6,  HANGUL SYLLABLE-BED6
        0xBED9, # G+13099  U+BED9  uniBED9,  HANGUL SYLLABLE-BED9
        0xBEDA, # G+13100  U+BEDA  uniBEDA,  HANGUL SYLLABLE-BEDA
        0xBEDB, # G+13101  U+BEDB  uniBEDB,  HANGUL SYLLABLE-BEDB
        0xBEDC, # G+13102  U+BEDC  uniBEDC,  HANGUL SYLLABLE-BEDC
        0xBEDD, # G+13103  U+BEDD  uniBEDD,  HANGUL SYLLABLE-BEDD
        0xBEDE, # G+13104  U+BEDE  uniBEDE,  HANGUL SYLLABLE-BEDE
        0xBEDF, # G+13105  U+BEDF  uniBEDF,  HANGUL SYLLABLE-BEDF
        0xBEE1, # G+13106  U+BEE1  uniBEE1,  HANGUL SYLLABLE-BEE1
        0xBEE2, # G+13107  U+BEE2  uniBEE2,  HANGUL SYLLABLE-BEE2
        0xBEE6, # G+13108  U+BEE6  uniBEE6,  HANGUL SYLLABLE-BEE6
        0xBEE7, # G+13109  U+BEE7  uniBEE7,  HANGUL SYLLABLE-BEE7
        0xBEE8, # G+13110  U+BEE8  uniBEE8,  HANGUL SYLLABLE-BEE8
        0xBEE9, # G+13111  U+BEE9  uniBEE9,  HANGUL SYLLABLE-BEE9
        0xBEEA, # G+13112  U+BEEA  uniBEEA,  HANGUL SYLLABLE-BEEA
        0xBEEB, # G+13113  U+BEEB  uniBEEB,  HANGUL SYLLABLE-BEEB
        0xBEED, # G+13114  U+BEED  uniBEED,  HANGUL SYLLABLE-BEED
        0xBEEE, # G+13115  U+BEEE  uniBEEE,  HANGUL SYLLABLE-BEEE
        0xBEEF, # G+13116  U+BEEF  uniBEEF,  HANGUL SYLLABLE-BEEF
        0xBEF0, # G+13117  U+BEF0  uniBEF0,  HANGUL SYLLABLE-BEF0
        0xBEF1, # G+13118  U+BEF1  uniBEF1,  HANGUL SYLLABLE-BEF1
        0xBEF2, # G+13119  U+BEF2  uniBEF2,  HANGUL SYLLABLE-BEF2
        0xBEF3, # G+13120  U+BEF3  uniBEF3,  HANGUL SYLLABLE-BEF3
        0xBEF4, # G+13121  U+BEF4  uniBEF4,  HANGUL SYLLABLE-BEF4
        0xBEF5, # G+13122  U+BEF5  uniBEF5,  HANGUL SYLLABLE-BEF5
        0xBEF6, # G+13123  U+BEF6  uniBEF6,  HANGUL SYLLABLE-BEF6
        0xBEF7, # G+13124  U+BEF7  uniBEF7,  HANGUL SYLLABLE-BEF7
        0xBEF8, # G+13125  U+BEF8  uniBEF8,  HANGUL SYLLABLE-BEF8
        0xBEF9, # G+13126  U+BEF9  uniBEF9,  HANGUL SYLLABLE-BEF9
        0xBEFA, # G+13127  U+BEFA  uniBEFA,  HANGUL SYLLABLE-BEFA
        0xBEFB, # G+13128  U+BEFB  uniBEFB,  HANGUL SYLLABLE-BEFB
        0xBEFC, # G+13129  U+BEFC  uniBEFC,  HANGUL SYLLABLE-BEFC
        0xBEFD, # G+13130  U+BEFD  uniBEFD,  HANGUL SYLLABLE-BEFD
        0xBEFE, # G+13131  U+BEFE  uniBEFE,  HANGUL SYLLABLE-BEFE
        0xBEFF, # G+13132  U+BEFF  uniBEFF,  HANGUL SYLLABLE-BEFF
        0xBF00, # G+13133  U+BF00  uniBF00,  HANGUL SYLLABLE-BF00
        0xBF02, # G+13134  U+BF02  uniBF02,  HANGUL SYLLABLE-BF02
        0xBF03, # G+13135  U+BF03  uniBF03,  HANGUL SYLLABLE-BF03
        0xBF04, # G+13136  U+BF04  uniBF04,  HANGUL SYLLABLE-BF04
        0xBF05, # G+13137  U+BF05  uniBF05,  HANGUL SYLLABLE-BF05
        0xBF06, # G+13138  U+BF06  uniBF06,  HANGUL SYLLABLE-BF06
        0xBF07, # G+13139  U+BF07  uniBF07,  HANGUL SYLLABLE-BF07
        0xBF0A, # G+13140  U+BF0A  uniBF0A,  HANGUL SYLLABLE-BF0A
        0xBF0B, # G+13141  U+BF0B  uniBF0B,  HANGUL SYLLABLE-BF0B
        0xBF0C, # G+13142  U+BF0C  uniBF0C,  HANGUL SYLLABLE-BF0C
        0xBF0D, # G+13143  U+BF0D  uniBF0D,  HANGUL SYLLABLE-BF0D
        0xBF0E, # G+13144  U+BF0E  uniBF0E,  HANGUL SYLLABLE-BF0E
        0xBF0F, # G+13145  U+BF0F  uniBF0F,  HANGUL SYLLABLE-BF0F
        0xBF10, # G+13146  U+BF10  uniBF10,  HANGUL SYLLABLE-BF10
        0xBF11, # G+13147  U+BF11  uniBF11,  HANGUL SYLLABLE-BF11
        0xBF12, # G+13148  U+BF12  uniBF12,  HANGUL SYLLABLE-BF12
        0xBF13, # G+13149  U+BF13  uniBF13,  HANGUL SYLLABLE-BF13
        0xBF14, # G+13150  U+BF14  uniBF14,  HANGUL SYLLABLE-BF14
        0xBF15, # G+13151  U+BF15  uniBF15,  HANGUL SYLLABLE-BF15
        0xBF16, # G+13152  U+BF16  uniBF16,  HANGUL SYLLABLE-BF16
        0xBF17, # G+13153  U+BF17  uniBF17,  HANGUL SYLLABLE-BF17
        0xBF1A, # G+13154  U+BF1A  uniBF1A,  HANGUL SYLLABLE-BF1A
        0xBF1E, # G+13155  U+BF1E  uniBF1E,  HANGUL SYLLABLE-BF1E
        0xBF1F, # G+13156  U+BF1F  uniBF1F,  HANGUL SYLLABLE-BF1F
        0xBF20, # G+13157  U+BF20  uniBF20,  HANGUL SYLLABLE-BF20
        0xBF21, # G+13158  U+BF21  uniBF21,  HANGUL SYLLABLE-BF21
        0xBF22, # G+13159  U+BF22  uniBF22,  HANGUL SYLLABLE-BF22
        0xBF23, # G+13160  U+BF23  uniBF23,  HANGUL SYLLABLE-BF23
        0xBF24, # G+13161  U+BF24  uniBF24,  HANGUL SYLLABLE-BF24
        0xBF25, # G+13162  U+BF25  uniBF25,  HANGUL SYLLABLE-BF25
        0xBF26, # G+13163  U+BF26  uniBF26,  HANGUL SYLLABLE-BF26
        0xBF27, # G+13164  U+BF27  uniBF27,  HANGUL SYLLABLE-BF27
        0xBF28, # G+13165  U+BF28  uniBF28,  HANGUL SYLLABLE-BF28
        0xBF29, # G+13166  U+BF29  uniBF29,  HANGUL SYLLABLE-BF29
        0xBF2A, # G+13167  U+BF2A  uniBF2A,  HANGUL SYLLABLE-BF2A
        0xBF2B, # G+13168  U+BF2B  uniBF2B,  HANGUL SYLLABLE-BF2B
        0xBF2C, # G+13169  U+BF2C  uniBF2C,  HANGUL SYLLABLE-BF2C
        0xBF2D, # G+13170  U+BF2D  uniBF2D,  HANGUL SYLLABLE-BF2D
        0xBF2E, # G+13171  U+BF2E  uniBF2E,  HANGUL SYLLABLE-BF2E
        0xBF2F, # G+13172  U+BF2F  uniBF2F,  HANGUL SYLLABLE-BF2F
        0xBF30, # G+13173  U+BF30  uniBF30,  HANGUL SYLLABLE-BF30
        0xBF31, # G+13174  U+BF31  uniBF31,  HANGUL SYLLABLE-BF31
        0xBF32, # G+13175  U+BF32  uniBF32,  HANGUL SYLLABLE-BF32
        0xBF33, # G+13176  U+BF33  uniBF33,  HANGUL SYLLABLE-BF33
        0xBF34, # G+13177  U+BF34  uniBF34,  HANGUL SYLLABLE-BF34
        0xBF35, # G+13178  U+BF35  uniBF35,  HANGUL SYLLABLE-BF35
        0xBF36, # G+13179  U+BF36  uniBF36,  HANGUL SYLLABLE-BF36
        0xBF37, # G+13180  U+BF37  uniBF37,  HANGUL SYLLABLE-BF37
        0xBF38, # G+13181  U+BF38  uniBF38,  HANGUL SYLLABLE-BF38
        0xBF39, # G+13182  U+BF39  uniBF39,  HANGUL SYLLABLE-BF39
        0xBF3A, # G+13183  U+BF3A  uniBF3A,  HANGUL SYLLABLE-BF3A
        0xBF3B, # G+13184  U+BF3B  uniBF3B,  HANGUL SYLLABLE-BF3B
        0xBF3C, # G+13185  U+BF3C  uniBF3C,  HANGUL SYLLABLE-BF3C
        0xBF3D, # G+13186  U+BF3D  uniBF3D,  HANGUL SYLLABLE-BF3D
        0xBF3E, # G+13187  U+BF3E  uniBF3E,  HANGUL SYLLABLE-BF3E
        0xBF3F, # G+13188  U+BF3F  uniBF3F,  HANGUL SYLLABLE-BF3F
        0xBF42, # G+13189  U+BF42  uniBF42,  HANGUL SYLLABLE-BF42
        0xBF43, # G+13190  U+BF43  uniBF43,  HANGUL SYLLABLE-BF43
        0xBF45, # G+13191  U+BF45  uniBF45,  HANGUL SYLLABLE-BF45
        0xBF46, # G+13192  U+BF46  uniBF46,  HANGUL SYLLABLE-BF46
        0xBF47, # G+13193  U+BF47  uniBF47,  HANGUL SYLLABLE-BF47
        0xBF49, # G+13194  U+BF49  uniBF49,  HANGUL SYLLABLE-BF49
        0xBF4A, # G+13195  U+BF4A  uniBF4A,  HANGUL SYLLABLE-BF4A
        0xBF4B, # G+13196  U+BF4B  uniBF4B,  HANGUL SYLLABLE-BF4B
        0xBF4C, # G+13197  U+BF4C  uniBF4C,  HANGUL SYLLABLE-BF4C
        0xBF4D, # G+13198  U+BF4D  uniBF4D,  HANGUL SYLLABLE-BF4D
        0xBF4E, # G+13199  U+BF4E  uniBF4E,  HANGUL SYLLABLE-BF4E
        0xBF4F, # G+13200  U+BF4F  uniBF4F,  HANGUL SYLLABLE-BF4F
        0xBF52, # G+13201  U+BF52  uniBF52,  HANGUL SYLLABLE-BF52
        0xBF53, # G+13202  U+BF53  uniBF53,  HANGUL SYLLABLE-BF53
        0xBF54, # G+13203  U+BF54  uniBF54,  HANGUL SYLLABLE-BF54
        0xBF56, # G+13204  U+BF56  uniBF56,  HANGUL SYLLABLE-BF56
        0xBF57, # G+13205  U+BF57  uniBF57,  HANGUL SYLLABLE-BF57
        0xBF58, # G+13206  U+BF58  uniBF58,  HANGUL SYLLABLE-BF58
        0xBF59, # G+13207  U+BF59  uniBF59,  HANGUL SYLLABLE-BF59
        0xBF5A, # G+13208  U+BF5A  uniBF5A,  HANGUL SYLLABLE-BF5A
        0xBF5B, # G+13209  U+BF5B  uniBF5B,  HANGUL SYLLABLE-BF5B
        0xBF5C, # G+13210  U+BF5C  uniBF5C,  HANGUL SYLLABLE-BF5C
        0xBF5D, # G+13211  U+BF5D  uniBF5D,  HANGUL SYLLABLE-BF5D
        0xBF5E, # G+13212  U+BF5E  uniBF5E,  HANGUL SYLLABLE-BF5E
        0xBF5F, # G+13213  U+BF5F  uniBF5F,  HANGUL SYLLABLE-BF5F
        0xBF60, # G+13214  U+BF60  uniBF60,  HANGUL SYLLABLE-BF60
        0xBF61, # G+13215  U+BF61  uniBF61,  HANGUL SYLLABLE-BF61
        0xBF62, # G+13216  U+BF62  uniBF62,  HANGUL SYLLABLE-BF62
        0xBF63, # G+13217  U+BF63  uniBF63,  HANGUL SYLLABLE-BF63
        0xBF64, # G+13218  U+BF64  uniBF64,  HANGUL SYLLABLE-BF64
        0xBF65, # G+13219  U+BF65  uniBF65,  HANGUL SYLLABLE-BF65
        0xBF66, # G+13220  U+BF66  uniBF66,  HANGUL SYLLABLE-BF66
        0xBF67, # G+13221  U+BF67  uniBF67,  HANGUL SYLLABLE-BF67
        0xBF68, # G+13222  U+BF68  uniBF68,  HANGUL SYLLABLE-BF68
        0xBF69, # G+13223  U+BF69  uniBF69,  HANGUL SYLLABLE-BF69
        0xBF6A, # G+13224  U+BF6A  uniBF6A,  HANGUL SYLLABLE-BF6A
        0xBF6B, # G+13225  U+BF6B  uniBF6B,  HANGUL SYLLABLE-BF6B
        0xBF6C, # G+13226  U+BF6C  uniBF6C,  HANGUL SYLLABLE-BF6C
        0xBF6D, # G+13227  U+BF6D  uniBF6D,  HANGUL SYLLABLE-BF6D
        0xBF6E, # G+13228  U+BF6E  uniBF6E,  HANGUL SYLLABLE-BF6E
        0xBF6F, # G+13229  U+BF6F  uniBF6F,  HANGUL SYLLABLE-BF6F
        0xBF70, # G+13230  U+BF70  uniBF70,  HANGUL SYLLABLE-BF70
        0xBF71, # G+13231  U+BF71  uniBF71,  HANGUL SYLLABLE-BF71
        0xBF72, # G+13232  U+BF72  uniBF72,  HANGUL SYLLABLE-BF72
        0xBF73, # G+13233  U+BF73  uniBF73,  HANGUL SYLLABLE-BF73
        0xBF74, # G+13234  U+BF74  uniBF74,  HANGUL SYLLABLE-BF74
        0xBF75, # G+13235  U+BF75  uniBF75,  HANGUL SYLLABLE-BF75
        0xBF76, # G+13236  U+BF76  uniBF76,  HANGUL SYLLABLE-BF76
        0xBF77, # G+13237  U+BF77  uniBF77,  HANGUL SYLLABLE-BF77
        0xBF78, # G+13238  U+BF78  uniBF78,  HANGUL SYLLABLE-BF78
        0xBF79, # G+13239  U+BF79  uniBF79,  HANGUL SYLLABLE-BF79
        0xBF7A, # G+13240  U+BF7A  uniBF7A,  HANGUL SYLLABLE-BF7A
        0xBF7B, # G+13241  U+BF7B  uniBF7B,  HANGUL SYLLABLE-BF7B
        0xBF7C, # G+13242  U+BF7C  uniBF7C,  HANGUL SYLLABLE-BF7C
        0xBF7D, # G+13243  U+BF7D  uniBF7D,  HANGUL SYLLABLE-BF7D
        0xBF7E, # G+13244  U+BF7E  uniBF7E,  HANGUL SYLLABLE-BF7E
        0xBF7F, # G+13245  U+BF7F  uniBF7F,  HANGUL SYLLABLE-BF7F
        0xBF80, # G+13246  U+BF80  uniBF80,  HANGUL SYLLABLE-BF80
        0xBF81, # G+13247  U+BF81  uniBF81,  HANGUL SYLLABLE-BF81
        0xBF82, # G+13248  U+BF82  uniBF82,  HANGUL SYLLABLE-BF82
        0xBF83, # G+13249  U+BF83  uniBF83,  HANGUL SYLLABLE-BF83
        0xBF84, # G+13250  U+BF84  uniBF84,  HANGUL SYLLABLE-BF84
        0xBF85, # G+13251  U+BF85  uniBF85,  HANGUL SYLLABLE-BF85
        0xBF86, # G+13252  U+BF86  uniBF86,  HANGUL SYLLABLE-BF86
        0xBF87, # G+13253  U+BF87  uniBF87,  HANGUL SYLLABLE-BF87
        0xBF88, # G+13254  U+BF88  uniBF88,  HANGUL SYLLABLE-BF88
        0xBF89, # G+13255  U+BF89  uniBF89,  HANGUL SYLLABLE-BF89
        0xBF8A, # G+13256  U+BF8A  uniBF8A,  HANGUL SYLLABLE-BF8A
        0xBF8B, # G+13257  U+BF8B  uniBF8B,  HANGUL SYLLABLE-BF8B
        0xBF8C, # G+13258  U+BF8C  uniBF8C,  HANGUL SYLLABLE-BF8C
        0xBF8D, # G+13259  U+BF8D  uniBF8D,  HANGUL SYLLABLE-BF8D
        0xBF8E, # G+13260  U+BF8E  uniBF8E,  HANGUL SYLLABLE-BF8E
        0xBF8F, # G+13261  U+BF8F  uniBF8F,  HANGUL SYLLABLE-BF8F
        0xBF90, # G+13262  U+BF90  uniBF90,  HANGUL SYLLABLE-BF90
        0xBF91, # G+13263  U+BF91  uniBF91,  HANGUL SYLLABLE-BF91
        0xBF92, # G+13264  U+BF92  uniBF92,  HANGUL SYLLABLE-BF92
        0xBF93, # G+13265  U+BF93  uniBF93,  HANGUL SYLLABLE-BF93
        0xBF95, # G+13266  U+BF95  uniBF95,  HANGUL SYLLABLE-BF95
        0xBF96, # G+13267  U+BF96  uniBF96,  HANGUL SYLLABLE-BF96
        0xBF97, # G+13268  U+BF97  uniBF97,  HANGUL SYLLABLE-BF97
        0xBF98, # G+13269  U+BF98  uniBF98,  HANGUL SYLLABLE-BF98
        0xBF99, # G+13270  U+BF99  uniBF99,  HANGUL SYLLABLE-BF99
        0xBF9A, # G+13271  U+BF9A  uniBF9A,  HANGUL SYLLABLE-BF9A
        0xBF9B, # G+13272  U+BF9B  uniBF9B,  HANGUL SYLLABLE-BF9B
        0xBF9C, # G+13273  U+BF9C  uniBF9C,  HANGUL SYLLABLE-BF9C
        0xBF9D, # G+13274  U+BF9D  uniBF9D,  HANGUL SYLLABLE-BF9D
        0xBF9E, # G+13275  U+BF9E  uniBF9E,  HANGUL SYLLABLE-BF9E
        0xBF9F, # G+13276  U+BF9F  uniBF9F,  HANGUL SYLLABLE-BF9F
        0xBFA0, # G+13277  U+BFA0  uniBFA0,  HANGUL SYLLABLE-BFA0
        0xBFA1, # G+13278  U+BFA1  uniBFA1,  HANGUL SYLLABLE-BFA1
        0xBFA2, # G+13279  U+BFA2  uniBFA2,  HANGUL SYLLABLE-BFA2
        0xBFA3, # G+13280  U+BFA3  uniBFA3,  HANGUL SYLLABLE-BFA3
        0xBFA4, # G+13281  U+BFA4  uniBFA4,  HANGUL SYLLABLE-BFA4
        0xBFA5, # G+13282  U+BFA5  uniBFA5,  HANGUL SYLLABLE-BFA5
        0xBFA6, # G+13283  U+BFA6  uniBFA6,  HANGUL SYLLABLE-BFA6
        0xBFA7, # G+13284  U+BFA7  uniBFA7,  HANGUL SYLLABLE-BFA7
        0xBFA8, # G+13285  U+BFA8  uniBFA8,  HANGUL SYLLABLE-BFA8
        0xBFA9, # G+13286  U+BFA9  uniBFA9,  HANGUL SYLLABLE-BFA9
        0xBFAA, # G+13287  U+BFAA  uniBFAA,  HANGUL SYLLABLE-BFAA
        0xBFAB, # G+13288  U+BFAB  uniBFAB,  HANGUL SYLLABLE-BFAB
        0xBFAC, # G+13289  U+BFAC  uniBFAC,  HANGUL SYLLABLE-BFAC
        0xBFAD, # G+13290  U+BFAD  uniBFAD,  HANGUL SYLLABLE-BFAD
        0xBFAE, # G+13291  U+BFAE  uniBFAE,  HANGUL SYLLABLE-BFAE
        0xBFAF, # G+13292  U+BFAF  uniBFAF,  HANGUL SYLLABLE-BFAF
        0xBFB1, # G+13293  U+BFB1  uniBFB1,  HANGUL SYLLABLE-BFB1
        0xBFB2, # G+13294  U+BFB2  uniBFB2,  HANGUL SYLLABLE-BFB2
        0xBFB3, # G+13295  U+BFB3  uniBFB3,  HANGUL SYLLABLE-BFB3
        0xBFB4, # G+13296  U+BFB4  uniBFB4,  HANGUL SYLLABLE-BFB4
        0xBFB5, # G+13297  U+BFB5  uniBFB5,  HANGUL SYLLABLE-BFB5
        0xBFB6, # G+13298  U+BFB6  uniBFB6,  HANGUL SYLLABLE-BFB6
        0xBFB7, # G+13299  U+BFB7  uniBFB7,  HANGUL SYLLABLE-BFB7
        0xBFB8, # G+13300  U+BFB8  uniBFB8,  HANGUL SYLLABLE-BFB8
        0xBFB9, # G+13301  U+BFB9  uniBFB9,  HANGUL SYLLABLE-BFB9
        0xBFBA, # G+13302  U+BFBA  uniBFBA,  HANGUL SYLLABLE-BFBA
        0xBFBB, # G+13303  U+BFBB  uniBFBB,  HANGUL SYLLABLE-BFBB
        0xBFBC, # G+13304  U+BFBC  uniBFBC,  HANGUL SYLLABLE-BFBC
        0xBFBD, # G+13305  U+BFBD  uniBFBD,  HANGUL SYLLABLE-BFBD
        0xBFBE, # G+13306  U+BFBE  uniBFBE,  HANGUL SYLLABLE-BFBE
        0xBFBF, # G+13307  U+BFBF  uniBFBF,  HANGUL SYLLABLE-BFBF
        0xBFC0, # G+13308  U+BFC0  uniBFC0,  HANGUL SYLLABLE-BFC0
        0xBFC1, # G+13309  U+BFC1  uniBFC1,  HANGUL SYLLABLE-BFC1
        0xBFC2, # G+13310  U+BFC2  uniBFC2,  HANGUL SYLLABLE-BFC2
        0xBFC3, # G+13311  U+BFC3  uniBFC3,  HANGUL SYLLABLE-BFC3
        0xBFC4, # G+13312  U+BFC4  uniBFC4,  HANGUL SYLLABLE-BFC4
        0xBFC6, # G+13313  U+BFC6  uniBFC6,  HANGUL SYLLABLE-BFC6
        0xBFC7, # G+13314  U+BFC7  uniBFC7,  HANGUL SYLLABLE-BFC7
        0xBFC8, # G+13315  U+BFC8  uniBFC8,  HANGUL SYLLABLE-BFC8
        0xBFC9, # G+13316  U+BFC9  uniBFC9,  HANGUL SYLLABLE-BFC9
        0xBFCA, # G+13317  U+BFCA  uniBFCA,  HANGUL SYLLABLE-BFCA
        0xBFCB, # G+13318  U+BFCB  uniBFCB,  HANGUL SYLLABLE-BFCB
        0xBFCE, # G+13319  U+BFCE  uniBFCE,  HANGUL SYLLABLE-BFCE
        0xBFCF, # G+13320  U+BFCF  uniBFCF,  HANGUL SYLLABLE-BFCF
        0xBFD1, # G+13321  U+BFD1  uniBFD1,  HANGUL SYLLABLE-BFD1
        0xBFD2, # G+13322  U+BFD2  uniBFD2,  HANGUL SYLLABLE-BFD2
        0xBFD3, # G+13323  U+BFD3  uniBFD3,  HANGUL SYLLABLE-BFD3
        0xBFD5, # G+13324  U+BFD5  uniBFD5,  HANGUL SYLLABLE-BFD5
        0xBFD6, # G+13325  U+BFD6  uniBFD6,  HANGUL SYLLABLE-BFD6
        0xBFD7, # G+13326  U+BFD7  uniBFD7,  HANGUL SYLLABLE-BFD7
        0xBFD8, # G+13327  U+BFD8  uniBFD8,  HANGUL SYLLABLE-BFD8
        0xBFD9, # G+13328  U+BFD9  uniBFD9,  HANGUL SYLLABLE-BFD9
        0xBFDA, # G+13329  U+BFDA  uniBFDA,  HANGUL SYLLABLE-BFDA
        0xBFDB, # G+13330  U+BFDB  uniBFDB,  HANGUL SYLLABLE-BFDB
        0xBFDD, # G+13331  U+BFDD  uniBFDD,  HANGUL SYLLABLE-BFDD
        0xBFDE, # G+13332  U+BFDE  uniBFDE,  HANGUL SYLLABLE-BFDE
        0xBFE0, # G+13333  U+BFE0  uniBFE0,  HANGUL SYLLABLE-BFE0
        0xBFE2, # G+13334  U+BFE2  uniBFE2,  HANGUL SYLLABLE-BFE2
        0xBFE3, # G+13335  U+BFE3  uniBFE3,  HANGUL SYLLABLE-BFE3
        0xBFE4, # G+13336  U+BFE4  uniBFE4,  HANGUL SYLLABLE-BFE4
        0xBFE5, # G+13337  U+BFE5  uniBFE5,  HANGUL SYLLABLE-BFE5
        0xBFE6, # G+13338  U+BFE6  uniBFE6,  HANGUL SYLLABLE-BFE6
        0xBFE7, # G+13339  U+BFE7  uniBFE7,  HANGUL SYLLABLE-BFE7
        0xBFE8, # G+13340  U+BFE8  uniBFE8,  HANGUL SYLLABLE-BFE8
        0xBFE9, # G+13341  U+BFE9  uniBFE9,  HANGUL SYLLABLE-BFE9
        0xBFEA, # G+13342  U+BFEA  uniBFEA,  HANGUL SYLLABLE-BFEA
        0xBFEB, # G+13343  U+BFEB  uniBFEB,  HANGUL SYLLABLE-BFEB
        0xBFEC, # G+13344  U+BFEC  uniBFEC,  HANGUL SYLLABLE-BFEC
        0xBFED, # G+13345  U+BFED  uniBFED,  HANGUL SYLLABLE-BFED
        0xBFEE, # G+13346  U+BFEE  uniBFEE,  HANGUL SYLLABLE-BFEE
        0xBFEF, # G+13347  U+BFEF  uniBFEF,  HANGUL SYLLABLE-BFEF
        0xBFF0, # G+13348  U+BFF0  uniBFF0,  HANGUL SYLLABLE-BFF0
        0xBFF1, # G+13349  U+BFF1  uniBFF1,  HANGUL SYLLABLE-BFF1
        0xBFF2, # G+13350  U+BFF2  uniBFF2,  HANGUL SYLLABLE-BFF2
        0xBFF3, # G+13351  U+BFF3  uniBFF3,  HANGUL SYLLABLE-BFF3
        0xBFF4, # G+13352  U+BFF4  uniBFF4,  HANGUL SYLLABLE-BFF4
        0xBFF5, # G+13353  U+BFF5  uniBFF5,  HANGUL SYLLABLE-BFF5
        0xBFF6, # G+13354  U+BFF6  uniBFF6,  HANGUL SYLLABLE-BFF6
        0xBFF7, # G+13355  U+BFF7  uniBFF7,  HANGUL SYLLABLE-BFF7
        0xBFF8, # G+13356  U+BFF8  uniBFF8,  HANGUL SYLLABLE-BFF8
        0xBFF9, # G+13357  U+BFF9  uniBFF9,  HANGUL SYLLABLE-BFF9
        0xBFFA, # G+13358  U+BFFA  uniBFFA,  HANGUL SYLLABLE-BFFA
        0xBFFB, # G+13359  U+BFFB  uniBFFB,  HANGUL SYLLABLE-BFFB
        0xBFFC, # G+13360  U+BFFC  uniBFFC,  HANGUL SYLLABLE-BFFC
        0xBFFD, # G+13361  U+BFFD  uniBFFD,  HANGUL SYLLABLE-BFFD
        0xBFFE, # G+13362  U+BFFE  uniBFFE,  HANGUL SYLLABLE-BFFE
        0xBFFF, # G+13363  U+BFFF  uniBFFF,  HANGUL SYLLABLE-BFFF
        0xC000, # G+13364  U+C000  uniC000,  HANGUL SYLLABLE-C000
        0xC001, # G+13365  U+C001  uniC001,  HANGUL SYLLABLE-C001
        0xC002, # G+13366  U+C002  uniC002,  HANGUL SYLLABLE-C002
        0xC003, # G+13367  U+C003  uniC003,  HANGUL SYLLABLE-C003
        0xC004, # G+13368  U+C004  uniC004,  HANGUL SYLLABLE-C004
        0xC005, # G+13369  U+C005  uniC005,  HANGUL SYLLABLE-C005
        0xC006, # G+13370  U+C006  uniC006,  HANGUL SYLLABLE-C006
        0xC007, # G+13371  U+C007  uniC007,  HANGUL SYLLABLE-C007
        0xC008, # G+13372  U+C008  uniC008,  HANGUL SYLLABLE-C008
        0xC009, # G+13373  U+C009  uniC009,  HANGUL SYLLABLE-C009
        0xC00A, # G+13374  U+C00A  uniC00A,  HANGUL SYLLABLE-C00A
        0xC00B, # G+13375  U+C00B  uniC00B,  HANGUL SYLLABLE-C00B
        0xC00C, # G+13376  U+C00C  uniC00C,  HANGUL SYLLABLE-C00C
        0xC00D, # G+13377  U+C00D  uniC00D,  HANGUL SYLLABLE-C00D
        0xC00E, # G+13378  U+C00E  uniC00E,  HANGUL SYLLABLE-C00E
        0xC00F, # G+13379  U+C00F  uniC00F,  HANGUL SYLLABLE-C00F
        0xC010, # G+13380  U+C010  uniC010,  HANGUL SYLLABLE-C010
        0xC011, # G+13381  U+C011  uniC011,  HANGUL SYLLABLE-C011
        0xC012, # G+13382  U+C012  uniC012,  HANGUL SYLLABLE-C012
        0xC013, # G+13383  U+C013  uniC013,  HANGUL SYLLABLE-C013
        0xC014, # G+13384  U+C014  uniC014,  HANGUL SYLLABLE-C014
        0xC015, # G+13385  U+C015  uniC015,  HANGUL SYLLABLE-C015
        0xC016, # G+13386  U+C016  uniC016,  HANGUL SYLLABLE-C016
        0xC017, # G+13387  U+C017  uniC017,  HANGUL SYLLABLE-C017
        0xC018, # G+13388  U+C018  uniC018,  HANGUL SYLLABLE-C018
        0xC019, # G+13389  U+C019  uniC019,  HANGUL SYLLABLE-C019
        0xC01A, # G+13390  U+C01A  uniC01A,  HANGUL SYLLABLE-C01A
        0xC01B, # G+13391  U+C01B  uniC01B,  HANGUL SYLLABLE-C01B
        0xC01C, # G+13392  U+C01C  uniC01C,  HANGUL SYLLABLE-C01C
        0xC01D, # G+13393  U+C01D  uniC01D,  HANGUL SYLLABLE-C01D
        0xC01E, # G+13394  U+C01E  uniC01E,  HANGUL SYLLABLE-C01E
        0xC01F, # G+13395  U+C01F  uniC01F,  HANGUL SYLLABLE-C01F
        0xC020, # G+13396  U+C020  uniC020,  HANGUL SYLLABLE-C020
        0xC021, # G+13397  U+C021  uniC021,  HANGUL SYLLABLE-C021
        0xC022, # G+13398  U+C022  uniC022,  HANGUL SYLLABLE-C022
        0xC023, # G+13399  U+C023  uniC023,  HANGUL SYLLABLE-C023
        0xC024, # G+13400  U+C024  uniC024,  HANGUL SYLLABLE-C024
        0xC025, # G+13401  U+C025  uniC025,  HANGUL SYLLABLE-C025
        0xC026, # G+13402  U+C026  uniC026,  HANGUL SYLLABLE-C026
        0xC027, # G+13403  U+C027  uniC027,  HANGUL SYLLABLE-C027
        0xC028, # G+13404  U+C028  uniC028,  HANGUL SYLLABLE-C028
        0xC029, # G+13405  U+C029  uniC029,  HANGUL SYLLABLE-C029
        0xC02A, # G+13406  U+C02A  uniC02A,  HANGUL SYLLABLE-C02A
        0xC02B, # G+13407  U+C02B  uniC02B,  HANGUL SYLLABLE-C02B
        0xC02C, # G+13408  U+C02C  uniC02C,  HANGUL SYLLABLE-C02C
        0xC02D, # G+13409  U+C02D  uniC02D,  HANGUL SYLLABLE-C02D
        0xC02E, # G+13410  U+C02E  uniC02E,  HANGUL SYLLABLE-C02E
        0xC02F, # G+13411  U+C02F  uniC02F,  HANGUL SYLLABLE-C02F
        0xC030, # G+13412  U+C030  uniC030,  HANGUL SYLLABLE-C030
        0xC031, # G+13413  U+C031  uniC031,  HANGUL SYLLABLE-C031
        0xC032, # G+13414  U+C032  uniC032,  HANGUL SYLLABLE-C032
        0xC033, # G+13415  U+C033  uniC033,  HANGUL SYLLABLE-C033
        0xC034, # G+13416  U+C034  uniC034,  HANGUL SYLLABLE-C034
        0xC035, # G+13417  U+C035  uniC035,  HANGUL SYLLABLE-C035
        0xC036, # G+13418  U+C036  uniC036,  HANGUL SYLLABLE-C036
        0xC037, # G+13419  U+C037  uniC037,  HANGUL SYLLABLE-C037
        0xC038, # G+13420  U+C038  uniC038,  HANGUL SYLLABLE-C038
        0xC039, # G+13421  U+C039  uniC039,  HANGUL SYLLABLE-C039
        0xC03A, # G+13422  U+C03A  uniC03A,  HANGUL SYLLABLE-C03A
        0xC03B, # G+13423  U+C03B  uniC03B,  HANGUL SYLLABLE-C03B
        0xC03D, # G+13424  U+C03D  uniC03D,  HANGUL SYLLABLE-C03D
        0xC03E, # G+13425  U+C03E  uniC03E,  HANGUL SYLLABLE-C03E
        0xC03F, # G+13426  U+C03F  uniC03F,  HANGUL SYLLABLE-C03F
        0xC040, # G+13427  U+C040  uniC040,  HANGUL SYLLABLE-C040
        0xC041, # G+13428  U+C041  uniC041,  HANGUL SYLLABLE-C041
        0xC042, # G+13429  U+C042  uniC042,  HANGUL SYLLABLE-C042
        0xC043, # G+13430  U+C043  uniC043,  HANGUL SYLLABLE-C043
        0xC044, # G+13431  U+C044  uniC044,  HANGUL SYLLABLE-C044
        0xC045, # G+13432  U+C045  uniC045,  HANGUL SYLLABLE-C045
        0xC046, # G+13433  U+C046  uniC046,  HANGUL SYLLABLE-C046
        0xC047, # G+13434  U+C047  uniC047,  HANGUL SYLLABLE-C047
        0xC048, # G+13435  U+C048  uniC048,  HANGUL SYLLABLE-C048
        0xC049, # G+13436  U+C049  uniC049,  HANGUL SYLLABLE-C049
        0xC04A, # G+13437  U+C04A  uniC04A,  HANGUL SYLLABLE-C04A
        0xC04B, # G+13438  U+C04B  uniC04B,  HANGUL SYLLABLE-C04B
        0xC04C, # G+13439  U+C04C  uniC04C,  HANGUL SYLLABLE-C04C
        0xC04D, # G+13440  U+C04D  uniC04D,  HANGUL SYLLABLE-C04D
        0xC04E, # G+13441  U+C04E  uniC04E,  HANGUL SYLLABLE-C04E
        0xC04F, # G+13442  U+C04F  uniC04F,  HANGUL SYLLABLE-C04F
        0xC050, # G+13443  U+C050  uniC050,  HANGUL SYLLABLE-C050
        0xC052, # G+13444  U+C052  uniC052,  HANGUL SYLLABLE-C052
        0xC053, # G+13445  U+C053  uniC053,  HANGUL SYLLABLE-C053
        0xC054, # G+13446  U+C054  uniC054,  HANGUL SYLLABLE-C054
        0xC055, # G+13447  U+C055  uniC055,  HANGUL SYLLABLE-C055
        0xC056, # G+13448  U+C056  uniC056,  HANGUL SYLLABLE-C056
        0xC057, # G+13449  U+C057  uniC057,  HANGUL SYLLABLE-C057
        0xC059, # G+13450  U+C059  uniC059,  HANGUL SYLLABLE-C059
        0xC05A, # G+13451  U+C05A  uniC05A,  HANGUL SYLLABLE-C05A
        0xC05B, # G+13452  U+C05B  uniC05B,  HANGUL SYLLABLE-C05B
        0xC05D, # G+13453  U+C05D  uniC05D,  HANGUL SYLLABLE-C05D
        0xC05E, # G+13454  U+C05E  uniC05E,  HANGUL SYLLABLE-C05E
        0xC05F, # G+13455  U+C05F  uniC05F,  HANGUL SYLLABLE-C05F
        0xC061, # G+13456  U+C061  uniC061,  HANGUL SYLLABLE-C061
        0xC062, # G+13457  U+C062  uniC062,  HANGUL SYLLABLE-C062
        0xC063, # G+13458  U+C063  uniC063,  HANGUL SYLLABLE-C063
        0xC064, # G+13459  U+C064  uniC064,  HANGUL SYLLABLE-C064
        0xC065, # G+13460  U+C065  uniC065,  HANGUL SYLLABLE-C065
        0xC066, # G+13461  U+C066  uniC066,  HANGUL SYLLABLE-C066
        0xC067, # G+13462  U+C067  uniC067,  HANGUL SYLLABLE-C067
        0xC06A, # G+13463  U+C06A  uniC06A,  HANGUL SYLLABLE-C06A
        0xC06B, # G+13464  U+C06B  uniC06B,  HANGUL SYLLABLE-C06B
        0xC06C, # G+13465  U+C06C  uniC06C,  HANGUL SYLLABLE-C06C
        0xC06D, # G+13466  U+C06D  uniC06D,  HANGUL SYLLABLE-C06D
        0xC06E, # G+13467  U+C06E  uniC06E,  HANGUL SYLLABLE-C06E
        0xC06F, # G+13468  U+C06F  uniC06F,  HANGUL SYLLABLE-C06F
        0xC070, # G+13469  U+C070  uniC070,  HANGUL SYLLABLE-C070
        0xC071, # G+13470  U+C071  uniC071,  HANGUL SYLLABLE-C071
        0xC072, # G+13471  U+C072  uniC072,  HANGUL SYLLABLE-C072
        0xC073, # G+13472  U+C073  uniC073,  HANGUL SYLLABLE-C073
        0xC074, # G+13473  U+C074  uniC074,  HANGUL SYLLABLE-C074
        0xC075, # G+13474  U+C075  uniC075,  HANGUL SYLLABLE-C075
        0xC076, # G+13475  U+C076  uniC076,  HANGUL SYLLABLE-C076
        0xC077, # G+13476  U+C077  uniC077,  HANGUL SYLLABLE-C077
        0xC078, # G+13477  U+C078  uniC078,  HANGUL SYLLABLE-C078
        0xC079, # G+13478  U+C079  uniC079,  HANGUL SYLLABLE-C079
        0xC07A, # G+13479  U+C07A  uniC07A,  HANGUL SYLLABLE-C07A
        0xC07B, # G+13480  U+C07B  uniC07B,  HANGUL SYLLABLE-C07B
        0xC07C, # G+13481  U+C07C  uniC07C,  HANGUL SYLLABLE-C07C
        0xC07D, # G+13482  U+C07D  uniC07D,  HANGUL SYLLABLE-C07D
        0xC07E, # G+13483  U+C07E  uniC07E,  HANGUL SYLLABLE-C07E
        0xC07F, # G+13484  U+C07F  uniC07F,  HANGUL SYLLABLE-C07F
        0xC080, # G+13485  U+C080  uniC080,  HANGUL SYLLABLE-C080
        0xC081, # G+13486  U+C081  uniC081,  HANGUL SYLLABLE-C081
        0xC082, # G+13487  U+C082  uniC082,  HANGUL SYLLABLE-C082
        0xC083, # G+13488  U+C083  uniC083,  HANGUL SYLLABLE-C083
        0xC084, # G+13489  U+C084  uniC084,  HANGUL SYLLABLE-C084
        0xC085, # G+13490  U+C085  uniC085,  HANGUL SYLLABLE-C085
        0xC086, # G+13491  U+C086  uniC086,  HANGUL SYLLABLE-C086
        0xC087, # G+13492  U+C087  uniC087,  HANGUL SYLLABLE-C087
        0xC088, # G+13493  U+C088  uniC088,  HANGUL SYLLABLE-C088
        0xC089, # G+13494  U+C089  uniC089,  HANGUL SYLLABLE-C089
        0xC08A, # G+13495  U+C08A  uniC08A,  HANGUL SYLLABLE-C08A
        0xC08B, # G+13496  U+C08B  uniC08B,  HANGUL SYLLABLE-C08B
        0xC08C, # G+13497  U+C08C  uniC08C,  HANGUL SYLLABLE-C08C
        0xC08D, # G+13498  U+C08D  uniC08D,  HANGUL SYLLABLE-C08D
        0xC08E, # G+13499  U+C08E  uniC08E,  HANGUL SYLLABLE-C08E
        0xC08F, # G+13500  U+C08F  uniC08F,  HANGUL SYLLABLE-C08F
        0xC092, # G+13501  U+C092  uniC092,  HANGUL SYLLABLE-C092
        0xC093, # G+13502  U+C093  uniC093,  HANGUL SYLLABLE-C093
        0xC095, # G+13503  U+C095  uniC095,  HANGUL SYLLABLE-C095
        0xC096, # G+13504  U+C096  uniC096,  HANGUL SYLLABLE-C096
        0xC097, # G+13505  U+C097  uniC097,  HANGUL SYLLABLE-C097
        0xC099, # G+13506  U+C099  uniC099,  HANGUL SYLLABLE-C099
        0xC09A, # G+13507  U+C09A  uniC09A,  HANGUL SYLLABLE-C09A
        0xC09B, # G+13508  U+C09B  uniC09B,  HANGUL SYLLABLE-C09B
        0xC09C, # G+13509  U+C09C  uniC09C,  HANGUL SYLLABLE-C09C
        0xC09D, # G+13510  U+C09D  uniC09D,  HANGUL SYLLABLE-C09D
        0xC09E, # G+13511  U+C09E  uniC09E,  HANGUL SYLLABLE-C09E
        0xC09F, # G+13512  U+C09F  uniC09F,  HANGUL SYLLABLE-C09F
        0xC0A2, # G+13513  U+C0A2  uniC0A2,  HANGUL SYLLABLE-C0A2
        0xC0A4, # G+13514  U+C0A4  uniC0A4,  HANGUL SYLLABLE-C0A4
        0xC0A6, # G+13515  U+C0A6  uniC0A6,  HANGUL SYLLABLE-C0A6
        0xC0A7, # G+13516  U+C0A7  uniC0A7,  HANGUL SYLLABLE-C0A7
        0xC0A8, # G+13517  U+C0A8  uniC0A8,  HANGUL SYLLABLE-C0A8
        0xC0A9, # G+13518  U+C0A9  uniC0A9,  HANGUL SYLLABLE-C0A9
        0xC0AA, # G+13519  U+C0AA  uniC0AA,  HANGUL SYLLABLE-C0AA
        0xC0AB, # G+13520  U+C0AB  uniC0AB,  HANGUL SYLLABLE-C0AB
        0xC0AE, # G+13521  U+C0AE  uniC0AE,  HANGUL SYLLABLE-C0AE
        0xC0B1, # G+13522  U+C0B1  uniC0B1,  HANGUL SYLLABLE-C0B1
        0xC0B2, # G+13523  U+C0B2  uniC0B2,  HANGUL SYLLABLE-C0B2
        0xC0B7, # G+13524  U+C0B7  uniC0B7,  HANGUL SYLLABLE-C0B7
        0xC0B8, # G+13525  U+C0B8  uniC0B8,  HANGUL SYLLABLE-C0B8
        0xC0B9, # G+13526  U+C0B9  uniC0B9,  HANGUL SYLLABLE-C0B9
        0xC0BA, # G+13527  U+C0BA  uniC0BA,  HANGUL SYLLABLE-C0BA
        0xC0BB, # G+13528  U+C0BB  uniC0BB,  HANGUL SYLLABLE-C0BB
        0xC0BE, # G+13529  U+C0BE  uniC0BE,  HANGUL SYLLABLE-C0BE
        0xC0C2, # G+13530  U+C0C2  uniC0C2,  HANGUL SYLLABLE-C0C2
        0xC0C3, # G+13531  U+C0C3  uniC0C3,  HANGUL SYLLABLE-C0C3
        0xC0C4, # G+13532  U+C0C4  uniC0C4,  HANGUL SYLLABLE-C0C4
        0xC0C6, # G+13533  U+C0C6  uniC0C6,  HANGUL SYLLABLE-C0C6
        0xC0C7, # G+13534  U+C0C7  uniC0C7,  HANGUL SYLLABLE-C0C7
        0xC0CA, # G+13535  U+C0CA  uniC0CA,  HANGUL SYLLABLE-C0CA
        0xC0CB, # G+13536  U+C0CB  uniC0CB,  HANGUL SYLLABLE-C0CB
        0xC0CD, # G+13537  U+C0CD  uniC0CD,  HANGUL SYLLABLE-C0CD
        0xC0CE, # G+13538  U+C0CE  uniC0CE,  HANGUL SYLLABLE-C0CE
        0xC0CF, # G+13539  U+C0CF  uniC0CF,  HANGUL SYLLABLE-C0CF
        0xC0D1, # G+13540  U+C0D1  uniC0D1,  HANGUL SYLLABLE-C0D1
        0xC0D2, # G+13541  U+C0D2  uniC0D2,  HANGUL SYLLABLE-C0D2
        0xC0D3, # G+13542  U+C0D3  uniC0D3,  HANGUL SYLLABLE-C0D3
        0xC0D4, # G+13543  U+C0D4  uniC0D4,  HANGUL SYLLABLE-C0D4
        0xC0D5, # G+13544  U+C0D5  uniC0D5,  HANGUL SYLLABLE-C0D5
        0xC0D6, # G+13545  U+C0D6  uniC0D6,  HANGUL SYLLABLE-C0D6
        0xC0D7, # G+13546  U+C0D7  uniC0D7,  HANGUL SYLLABLE-C0D7
        0xC0DA, # G+13547  U+C0DA  uniC0DA,  HANGUL SYLLABLE-C0DA
        0xC0DE, # G+13548  U+C0DE  uniC0DE,  HANGUL SYLLABLE-C0DE
        0xC0DF, # G+13549  U+C0DF  uniC0DF,  HANGUL SYLLABLE-C0DF
        0xC0E0, # G+13550  U+C0E0  uniC0E0,  HANGUL SYLLABLE-C0E0
        0xC0E1, # G+13551  U+C0E1  uniC0E1,  HANGUL SYLLABLE-C0E1
        0xC0E2, # G+13552  U+C0E2  uniC0E2,  HANGUL SYLLABLE-C0E2
        0xC0E3, # G+13553  U+C0E3  uniC0E3,  HANGUL SYLLABLE-C0E3
        0xC0E6, # G+13554  U+C0E6  uniC0E6,  HANGUL SYLLABLE-C0E6
        0xC0E7, # G+13555  U+C0E7  uniC0E7,  HANGUL SYLLABLE-C0E7
        0xC0E9, # G+13556  U+C0E9  uniC0E9,  HANGUL SYLLABLE-C0E9
        0xC0EA, # G+13557  U+C0EA  uniC0EA,  HANGUL SYLLABLE-C0EA
        0xC0EB, # G+13558  U+C0EB  uniC0EB,  HANGUL SYLLABLE-C0EB
        0xC0ED, # G+13559  U+C0ED  uniC0ED,  HANGUL SYLLABLE-C0ED
        0xC0EE, # G+13560  U+C0EE  uniC0EE,  HANGUL SYLLABLE-C0EE
        0xC0EF, # G+13561  U+C0EF  uniC0EF,  HANGUL SYLLABLE-C0EF
        0xC0F0, # G+13562  U+C0F0  uniC0F0,  HANGUL SYLLABLE-C0F0
        0xC0F1, # G+13563  U+C0F1  uniC0F1,  HANGUL SYLLABLE-C0F1
        0xC0F2, # G+13564  U+C0F2  uniC0F2,  HANGUL SYLLABLE-C0F2
        0xC0F3, # G+13565  U+C0F3  uniC0F3,  HANGUL SYLLABLE-C0F3
        0xC0F6, # G+13566  U+C0F6  uniC0F6,  HANGUL SYLLABLE-C0F6
        0xC0F8, # G+13567  U+C0F8  uniC0F8,  HANGUL SYLLABLE-C0F8
        0xC0FA, # G+13568  U+C0FA  uniC0FA,  HANGUL SYLLABLE-C0FA
        0xC0FB, # G+13569  U+C0FB  uniC0FB,  HANGUL SYLLABLE-C0FB
        0xC0FC, # G+13570  U+C0FC  uniC0FC,  HANGUL SYLLABLE-C0FC
        0xC0FD, # G+13571  U+C0FD  uniC0FD,  HANGUL SYLLABLE-C0FD
        0xC0FE, # G+13572  U+C0FE  uniC0FE,  HANGUL SYLLABLE-C0FE
        0xC0FF, # G+13573  U+C0FF  uniC0FF,  HANGUL SYLLABLE-C0FF
        0xC101, # G+13574  U+C101  uniC101,  HANGUL SYLLABLE-C101
        0xC102, # G+13575  U+C102  uniC102,  HANGUL SYLLABLE-C102
        0xC103, # G+13576  U+C103  uniC103,  HANGUL SYLLABLE-C103
        0xC105, # G+13577  U+C105  uniC105,  HANGUL SYLLABLE-C105
        0xC106, # G+13578  U+C106  uniC106,  HANGUL SYLLABLE-C106
        0xC107, # G+13579  U+C107  uniC107,  HANGUL SYLLABLE-C107
        0xC109, # G+13580  U+C109  uniC109,  HANGUL SYLLABLE-C109
        0xC10A, # G+13581  U+C10A  uniC10A,  HANGUL SYLLABLE-C10A
        0xC10B, # G+13582  U+C10B  uniC10B,  HANGUL SYLLABLE-C10B
        0xC10C, # G+13583  U+C10C  uniC10C,  HANGUL SYLLABLE-C10C
        0xC10D, # G+13584  U+C10D  uniC10D,  HANGUL SYLLABLE-C10D
        0xC10E, # G+13585  U+C10E  uniC10E,  HANGUL SYLLABLE-C10E
        0xC10F, # G+13586  U+C10F  uniC10F,  HANGUL SYLLABLE-C10F
        0xC111, # G+13587  U+C111  uniC111,  HANGUL SYLLABLE-C111
        0xC112, # G+13588  U+C112  uniC112,  HANGUL SYLLABLE-C112
        0xC113, # G+13589  U+C113  uniC113,  HANGUL SYLLABLE-C113
        0xC114, # G+13590  U+C114  uniC114,  HANGUL SYLLABLE-C114
        0xC116, # G+13591  U+C116  uniC116,  HANGUL SYLLABLE-C116
        0xC117, # G+13592  U+C117  uniC117,  HANGUL SYLLABLE-C117
        0xC118, # G+13593  U+C118  uniC118,  HANGUL SYLLABLE-C118
        0xC119, # G+13594  U+C119  uniC119,  HANGUL SYLLABLE-C119
        0xC11A, # G+13595  U+C11A  uniC11A,  HANGUL SYLLABLE-C11A
        0xC11B, # G+13596  U+C11B  uniC11B,  HANGUL SYLLABLE-C11B
        0xC121, # G+13597  U+C121  uniC121,  HANGUL SYLLABLE-C121
        0xC122, # G+13598  U+C122  uniC122,  HANGUL SYLLABLE-C122
        0xC125, # G+13599  U+C125  uniC125,  HANGUL SYLLABLE-C125
        0xC128, # G+13600  U+C128  uniC128,  HANGUL SYLLABLE-C128
        0xC129, # G+13601  U+C129  uniC129,  HANGUL SYLLABLE-C129
        0xC12A, # G+13602  U+C12A  uniC12A,  HANGUL SYLLABLE-C12A
        0xC12B, # G+13603  U+C12B  uniC12B,  HANGUL SYLLABLE-C12B
        0xC12E, # G+13604  U+C12E  uniC12E,  HANGUL SYLLABLE-C12E
        0xC132, # G+13605  U+C132  uniC132,  HANGUL SYLLABLE-C132
        0xC133, # G+13606  U+C133  uniC133,  HANGUL SYLLABLE-C133
        0xC134, # G+13607  U+C134  uniC134,  HANGUL SYLLABLE-C134
        0xC135, # G+13608  U+C135  uniC135,  HANGUL SYLLABLE-C135
        0xC137, # G+13609  U+C137  uniC137,  HANGUL SYLLABLE-C137
        0xC13A, # G+13610  U+C13A  uniC13A,  HANGUL SYLLABLE-C13A
        0xC13B, # G+13611  U+C13B  uniC13B,  HANGUL SYLLABLE-C13B
        0xC13D, # G+13612  U+C13D  uniC13D,  HANGUL SYLLABLE-C13D
        0xC13E, # G+13613  U+C13E  uniC13E,  HANGUL SYLLABLE-C13E
        0xC13F, # G+13614  U+C13F  uniC13F,  HANGUL SYLLABLE-C13F
        0xC141, # G+13615  U+C141  uniC141,  HANGUL SYLLABLE-C141
        0xC142, # G+13616  U+C142  uniC142,  HANGUL SYLLABLE-C142
        0xC143, # G+13617  U+C143  uniC143,  HANGUL SYLLABLE-C143
        0xC144, # G+13618  U+C144  uniC144,  HANGUL SYLLABLE-C144
        0xC145, # G+13619  U+C145  uniC145,  HANGUL SYLLABLE-C145
        0xC146, # G+13620  U+C146  uniC146,  HANGUL SYLLABLE-C146
        0xC147, # G+13621  U+C147  uniC147,  HANGUL SYLLABLE-C147
        0xC14A, # G+13622  U+C14A  uniC14A,  HANGUL SYLLABLE-C14A
        0xC14E, # G+13623  U+C14E  uniC14E,  HANGUL SYLLABLE-C14E
        0xC14F, # G+13624  U+C14F  uniC14F,  HANGUL SYLLABLE-C14F
        0xC150, # G+13625  U+C150  uniC150,  HANGUL SYLLABLE-C150
        0xC151, # G+13626  U+C151  uniC151,  HANGUL SYLLABLE-C151
        0xC152, # G+13627  U+C152  uniC152,  HANGUL SYLLABLE-C152
        0xC153, # G+13628  U+C153  uniC153,  HANGUL SYLLABLE-C153
        0xC156, # G+13629  U+C156  uniC156,  HANGUL SYLLABLE-C156
        0xC157, # G+13630  U+C157  uniC157,  HANGUL SYLLABLE-C157
        0xC159, # G+13631  U+C159  uniC159,  HANGUL SYLLABLE-C159
        0xC15A, # G+13632  U+C15A  uniC15A,  HANGUL SYLLABLE-C15A
        0xC15B, # G+13633  U+C15B  uniC15B,  HANGUL SYLLABLE-C15B
        0xC15D, # G+13634  U+C15D  uniC15D,  HANGUL SYLLABLE-C15D
        0xC15E, # G+13635  U+C15E  uniC15E,  HANGUL SYLLABLE-C15E
        0xC15F, # G+13636  U+C15F  uniC15F,  HANGUL SYLLABLE-C15F
        0xC160, # G+13637  U+C160  uniC160,  HANGUL SYLLABLE-C160
        0xC161, # G+13638  U+C161  uniC161,  HANGUL SYLLABLE-C161
        0xC162, # G+13639  U+C162  uniC162,  HANGUL SYLLABLE-C162
        0xC163, # G+13640  U+C163  uniC163,  HANGUL SYLLABLE-C163
        0xC166, # G+13641  U+C166  uniC166,  HANGUL SYLLABLE-C166
        0xC16A, # G+13642  U+C16A  uniC16A,  HANGUL SYLLABLE-C16A
        0xC16B, # G+13643  U+C16B  uniC16B,  HANGUL SYLLABLE-C16B
        0xC16C, # G+13644  U+C16C  uniC16C,  HANGUL SYLLABLE-C16C
        0xC16D, # G+13645  U+C16D  uniC16D,  HANGUL SYLLABLE-C16D
        0xC16E, # G+13646  U+C16E  uniC16E,  HANGUL SYLLABLE-C16E
        0xC16F, # G+13647  U+C16F  uniC16F,  HANGUL SYLLABLE-C16F
        0xC171, # G+13648  U+C171  uniC171,  HANGUL SYLLABLE-C171
        0xC172, # G+13649  U+C172  uniC172,  HANGUL SYLLABLE-C172
        0xC173, # G+13650  U+C173  uniC173,  HANGUL SYLLABLE-C173
        0xC175, # G+13651  U+C175  uniC175,  HANGUL SYLLABLE-C175
        0xC176, # G+13652  U+C176  uniC176,  HANGUL SYLLABLE-C176
        0xC177, # G+13653  U+C177  uniC177,  HANGUL SYLLABLE-C177
        0xC179, # G+13654  U+C179  uniC179,  HANGUL SYLLABLE-C179
        0xC17A, # G+13655  U+C17A  uniC17A,  HANGUL SYLLABLE-C17A
        0xC17B, # G+13656  U+C17B  uniC17B,  HANGUL SYLLABLE-C17B
        0xC17C, # G+13657  U+C17C  uniC17C,  HANGUL SYLLABLE-C17C
        0xC17D, # G+13658  U+C17D  uniC17D,  HANGUL SYLLABLE-C17D
        0xC17E, # G+13659  U+C17E  uniC17E,  HANGUL SYLLABLE-C17E
        0xC17F, # G+13660  U+C17F  uniC17F,  HANGUL SYLLABLE-C17F
        0xC180, # G+13661  U+C180  uniC180,  HANGUL SYLLABLE-C180
        0xC181, # G+13662  U+C181  uniC181,  HANGUL SYLLABLE-C181
        0xC182, # G+13663  U+C182  uniC182,  HANGUL SYLLABLE-C182
        0xC183, # G+13664  U+C183  uniC183,  HANGUL SYLLABLE-C183
        0xC184, # G+13665  U+C184  uniC184,  HANGUL SYLLABLE-C184
        0xC186, # G+13666  U+C186  uniC186,  HANGUL SYLLABLE-C186
        0xC187, # G+13667  U+C187  uniC187,  HANGUL SYLLABLE-C187
        0xC188, # G+13668  U+C188  uniC188,  HANGUL SYLLABLE-C188
        0xC189, # G+13669  U+C189  uniC189,  HANGUL SYLLABLE-C189
        0xC18A, # G+13670  U+C18A  uniC18A,  HANGUL SYLLABLE-C18A
        0xC18B, # G+13671  U+C18B  uniC18B,  HANGUL SYLLABLE-C18B
        0xC18F, # G+13672  U+C18F  uniC18F,  HANGUL SYLLABLE-C18F
        0xC191, # G+13673  U+C191  uniC191,  HANGUL SYLLABLE-C191
        0xC192, # G+13674  U+C192  uniC192,  HANGUL SYLLABLE-C192
        0xC193, # G+13675  U+C193  uniC193,  HANGUL SYLLABLE-C193
        0xC195, # G+13676  U+C195  uniC195,  HANGUL SYLLABLE-C195
        0xC197, # G+13677  U+C197  uniC197,  HANGUL SYLLABLE-C197
        0xC198, # G+13678  U+C198  uniC198,  HANGUL SYLLABLE-C198
        0xC199, # G+13679  U+C199  uniC199,  HANGUL SYLLABLE-C199
        0xC19A, # G+13680  U+C19A  uniC19A,  HANGUL SYLLABLE-C19A
        0xC19B, # G+13681  U+C19B  uniC19B,  HANGUL SYLLABLE-C19B
        0xC19E, # G+13682  U+C19E  uniC19E,  HANGUL SYLLABLE-C19E
        0xC1A0, # G+13683  U+C1A0  uniC1A0,  HANGUL SYLLABLE-C1A0
        0xC1A2, # G+13684  U+C1A2  uniC1A2,  HANGUL SYLLABLE-C1A2
        0xC1A3, # G+13685  U+C1A3  uniC1A3,  HANGUL SYLLABLE-C1A3
        0xC1A4, # G+13686  U+C1A4  uniC1A4,  HANGUL SYLLABLE-C1A4
        0xC1A6, # G+13687  U+C1A6  uniC1A6,  HANGUL SYLLABLE-C1A6
        0xC1A7, # G+13688  U+C1A7  uniC1A7,  HANGUL SYLLABLE-C1A7
        0xC1AA, # G+13689  U+C1AA  uniC1AA,  HANGUL SYLLABLE-C1AA
        0xC1AB, # G+13690  U+C1AB  uniC1AB,  HANGUL SYLLABLE-C1AB
        0xC1AD, # G+13691  U+C1AD  uniC1AD,  HANGUL SYLLABLE-C1AD
        0xC1AE, # G+13692  U+C1AE  uniC1AE,  HANGUL SYLLABLE-C1AE
        0xC1AF, # G+13693  U+C1AF  uniC1AF,  HANGUL SYLLABLE-C1AF
        0xC1B1, # G+13694  U+C1B1  uniC1B1,  HANGUL SYLLABLE-C1B1
        0xC1B2, # G+13695  U+C1B2  uniC1B2,  HANGUL SYLLABLE-C1B2
        0xC1B3, # G+13696  U+C1B3  uniC1B3,  HANGUL SYLLABLE-C1B3
        0xC1B4, # G+13697  U+C1B4  uniC1B4,  HANGUL SYLLABLE-C1B4
        0xC1B5, # G+13698  U+C1B5  uniC1B5,  HANGUL SYLLABLE-C1B5
        0xC1B6, # G+13699  U+C1B6  uniC1B6,  HANGUL SYLLABLE-C1B6
        0xC1B7, # G+13700  U+C1B7  uniC1B7,  HANGUL SYLLABLE-C1B7
        0xC1B8, # G+13701  U+C1B8  uniC1B8,  HANGUL SYLLABLE-C1B8
        0xC1B9, # G+13702  U+C1B9  uniC1B9,  HANGUL SYLLABLE-C1B9
        0xC1BA, # G+13703  U+C1BA  uniC1BA,  HANGUL SYLLABLE-C1BA
        0xC1BB, # G+13704  U+C1BB  uniC1BB,  HANGUL SYLLABLE-C1BB
        0xC1BC, # G+13705  U+C1BC  uniC1BC,  HANGUL SYLLABLE-C1BC
        0xC1BE, # G+13706  U+C1BE  uniC1BE,  HANGUL SYLLABLE-C1BE
        0xC1BF, # G+13707  U+C1BF  uniC1BF,  HANGUL SYLLABLE-C1BF
        0xC1C0, # G+13708  U+C1C0  uniC1C0,  HANGUL SYLLABLE-C1C0
        0xC1C1, # G+13709  U+C1C1  uniC1C1,  HANGUL SYLLABLE-C1C1
        0xC1C2, # G+13710  U+C1C2  uniC1C2,  HANGUL SYLLABLE-C1C2
        0xC1C3, # G+13711  U+C1C3  uniC1C3,  HANGUL SYLLABLE-C1C3
        0xC1C5, # G+13712  U+C1C5  uniC1C5,  HANGUL SYLLABLE-C1C5
        0xC1C6, # G+13713  U+C1C6  uniC1C6,  HANGUL SYLLABLE-C1C6
        0xC1C7, # G+13714  U+C1C7  uniC1C7,  HANGUL SYLLABLE-C1C7
        0xC1C9, # G+13715  U+C1C9  uniC1C9,  HANGUL SYLLABLE-C1C9
        0xC1CA, # G+13716  U+C1CA  uniC1CA,  HANGUL SYLLABLE-C1CA
        0xC1CB, # G+13717  U+C1CB  uniC1CB,  HANGUL SYLLABLE-C1CB
        0xC1CD, # G+13718  U+C1CD  uniC1CD,  HANGUL SYLLABLE-C1CD
        0xC1CE, # G+13719  U+C1CE  uniC1CE,  HANGUL SYLLABLE-C1CE
        0xC1CF, # G+13720  U+C1CF  uniC1CF,  HANGUL SYLLABLE-C1CF
        0xC1D0, # G+13721  U+C1D0  uniC1D0,  HANGUL SYLLABLE-C1D0
        0xC1D1, # G+13722  U+C1D1  uniC1D1,  HANGUL SYLLABLE-C1D1
        0xC1D2, # G+13723  U+C1D2  uniC1D2,  HANGUL SYLLABLE-C1D2
        0xC1D3, # G+13724  U+C1D3  uniC1D3,  HANGUL SYLLABLE-C1D3
        0xC1D5, # G+13725  U+C1D5  uniC1D5,  HANGUL SYLLABLE-C1D5
        0xC1D6, # G+13726  U+C1D6  uniC1D6,  HANGUL SYLLABLE-C1D6
        0xC1D9, # G+13727  U+C1D9  uniC1D9,  HANGUL SYLLABLE-C1D9
        0xC1DA, # G+13728  U+C1DA  uniC1DA,  HANGUL SYLLABLE-C1DA
        0xC1DB, # G+13729  U+C1DB  uniC1DB,  HANGUL SYLLABLE-C1DB
        0xC1DC, # G+13730  U+C1DC  uniC1DC,  HANGUL SYLLABLE-C1DC
        0xC1DD, # G+13731  U+C1DD  uniC1DD,  HANGUL SYLLABLE-C1DD
        0xC1DE, # G+13732  U+C1DE  uniC1DE,  HANGUL SYLLABLE-C1DE
        0xC1DF, # G+13733  U+C1DF  uniC1DF,  HANGUL SYLLABLE-C1DF
        0xC1E1, # G+13734  U+C1E1  uniC1E1,  HANGUL SYLLABLE-C1E1
        0xC1E2, # G+13735  U+C1E2  uniC1E2,  HANGUL SYLLABLE-C1E2
        0xC1E3, # G+13736  U+C1E3  uniC1E3,  HANGUL SYLLABLE-C1E3
        0xC1E5, # G+13737  U+C1E5  uniC1E5,  HANGUL SYLLABLE-C1E5
        0xC1E6, # G+13738  U+C1E6  uniC1E6,  HANGUL SYLLABLE-C1E6
        0xC1E7, # G+13739  U+C1E7  uniC1E7,  HANGUL SYLLABLE-C1E7
        0xC1E9, # G+13740  U+C1E9  uniC1E9,  HANGUL SYLLABLE-C1E9
        0xC1EA, # G+13741  U+C1EA  uniC1EA,  HANGUL SYLLABLE-C1EA
        0xC1EB, # G+13742  U+C1EB  uniC1EB,  HANGUL SYLLABLE-C1EB
        0xC1EC, # G+13743  U+C1EC  uniC1EC,  HANGUL SYLLABLE-C1EC
        0xC1ED, # G+13744  U+C1ED  uniC1ED,  HANGUL SYLLABLE-C1ED
        0xC1EE, # G+13745  U+C1EE  uniC1EE,  HANGUL SYLLABLE-C1EE
        0xC1EF, # G+13746  U+C1EF  uniC1EF,  HANGUL SYLLABLE-C1EF
        0xC1F2, # G+13747  U+C1F2  uniC1F2,  HANGUL SYLLABLE-C1F2
        0xC1F4, # G+13748  U+C1F4  uniC1F4,  HANGUL SYLLABLE-C1F4
        0xC1F5, # G+13749  U+C1F5  uniC1F5,  HANGUL SYLLABLE-C1F5
        0xC1F6, # G+13750  U+C1F6  uniC1F6,  HANGUL SYLLABLE-C1F6
        0xC1F7, # G+13751  U+C1F7  uniC1F7,  HANGUL SYLLABLE-C1F7
        0xC1F8, # G+13752  U+C1F8  uniC1F8,  HANGUL SYLLABLE-C1F8
        0xC1F9, # G+13753  U+C1F9  uniC1F9,  HANGUL SYLLABLE-C1F9
        0xC1FA, # G+13754  U+C1FA  uniC1FA,  HANGUL SYLLABLE-C1FA
        0xC1FB, # G+13755  U+C1FB  uniC1FB,  HANGUL SYLLABLE-C1FB
        0xC1FE, # G+13756  U+C1FE  uniC1FE,  HANGUL SYLLABLE-C1FE
        0xC1FF, # G+13757  U+C1FF  uniC1FF,  HANGUL SYLLABLE-C1FF
        0xC201, # G+13758  U+C201  uniC201,  HANGUL SYLLABLE-C201
        0xC202, # G+13759  U+C202  uniC202,  HANGUL SYLLABLE-C202
        0xC203, # G+13760  U+C203  uniC203,  HANGUL SYLLABLE-C203
        0xC205, # G+13761  U+C205  uniC205,  HANGUL SYLLABLE-C205
        0xC206, # G+13762  U+C206  uniC206,  HANGUL SYLLABLE-C206
        0xC207, # G+13763  U+C207  uniC207,  HANGUL SYLLABLE-C207
        0xC208, # G+13764  U+C208  uniC208,  HANGUL SYLLABLE-C208
        0xC209, # G+13765  U+C209  uniC209,  HANGUL SYLLABLE-C209
        0xC20A, # G+13766  U+C20A  uniC20A,  HANGUL SYLLABLE-C20A
        0xC20B, # G+13767  U+C20B  uniC20B,  HANGUL SYLLABLE-C20B
        0xC20E, # G+13768  U+C20E  uniC20E,  HANGUL SYLLABLE-C20E
        0xC210, # G+13769  U+C210  uniC210,  HANGUL SYLLABLE-C210
        0xC212, # G+13770  U+C212  uniC212,  HANGUL SYLLABLE-C212
        0xC213, # G+13771  U+C213  uniC213,  HANGUL SYLLABLE-C213
        0xC214, # G+13772  U+C214  uniC214,  HANGUL SYLLABLE-C214
        0xC215, # G+13773  U+C215  uniC215,  HANGUL SYLLABLE-C215
        0xC216, # G+13774  U+C216  uniC216,  HANGUL SYLLABLE-C216
        0xC217, # G+13775  U+C217  uniC217,  HANGUL SYLLABLE-C217
        0xC21A, # G+13776  U+C21A  uniC21A,  HANGUL SYLLABLE-C21A
        0xC21B, # G+13777  U+C21B  uniC21B,  HANGUL SYLLABLE-C21B
        0xC21D, # G+13778  U+C21D  uniC21D,  HANGUL SYLLABLE-C21D
        0xC21E, # G+13779  U+C21E  uniC21E,  HANGUL SYLLABLE-C21E
        0xC221, # G+13780  U+C221  uniC221,  HANGUL SYLLABLE-C221
        0xC222, # G+13781  U+C222  uniC222,  HANGUL SYLLABLE-C222
        0xC223, # G+13782  U+C223  uniC223,  HANGUL SYLLABLE-C223
        0xC224, # G+13783  U+C224  uniC224,  HANGUL SYLLABLE-C224
        0xC225, # G+13784  U+C225  uniC225,  HANGUL SYLLABLE-C225
        0xC226, # G+13785  U+C226  uniC226,  HANGUL SYLLABLE-C226
        0xC227, # G+13786  U+C227  uniC227,  HANGUL SYLLABLE-C227
        0xC22A, # G+13787  U+C22A  uniC22A,  HANGUL SYLLABLE-C22A
        0xC22C, # G+13788  U+C22C  uniC22C,  HANGUL SYLLABLE-C22C
        0xC22E, # G+13789  U+C22E  uniC22E,  HANGUL SYLLABLE-C22E
        0xC230, # G+13790  U+C230  uniC230,  HANGUL SYLLABLE-C230
        0xC233, # G+13791  U+C233  uniC233,  HANGUL SYLLABLE-C233
        0xC235, # G+13792  U+C235  uniC235,  HANGUL SYLLABLE-C235
        0xC236, # G+13793  U+C236  uniC236,  HANGUL SYLLABLE-C236
        0xC237, # G+13794  U+C237  uniC237,  HANGUL SYLLABLE-C237
        0xC238, # G+13795  U+C238  uniC238,  HANGUL SYLLABLE-C238
        0xC239, # G+13796  U+C239  uniC239,  HANGUL SYLLABLE-C239
        0xC23A, # G+13797  U+C23A  uniC23A,  HANGUL SYLLABLE-C23A
        0xC23B, # G+13798  U+C23B  uniC23B,  HANGUL SYLLABLE-C23B
        0xC23C, # G+13799  U+C23C  uniC23C,  HANGUL SYLLABLE-C23C
        0xC23D, # G+13800  U+C23D  uniC23D,  HANGUL SYLLABLE-C23D
        0xC23E, # G+13801  U+C23E  uniC23E,  HANGUL SYLLABLE-C23E
        0xC23F, # G+13802  U+C23F  uniC23F,  HANGUL SYLLABLE-C23F
        0xC240, # G+13803  U+C240  uniC240,  HANGUL SYLLABLE-C240
        0xC241, # G+13804  U+C241  uniC241,  HANGUL SYLLABLE-C241
        0xC242, # G+13805  U+C242  uniC242,  HANGUL SYLLABLE-C242
        0xC243, # G+13806  U+C243  uniC243,  HANGUL SYLLABLE-C243
        0xC244, # G+13807  U+C244  uniC244,  HANGUL SYLLABLE-C244
        0xC245, # G+13808  U+C245  uniC245,  HANGUL SYLLABLE-C245
        0xC246, # G+13809  U+C246  uniC246,  HANGUL SYLLABLE-C246
        0xC247, # G+13810  U+C247  uniC247,  HANGUL SYLLABLE-C247
        0xC249, # G+13811  U+C249  uniC249,  HANGUL SYLLABLE-C249
        0xC24A, # G+13812  U+C24A  uniC24A,  HANGUL SYLLABLE-C24A
        0xC24B, # G+13813  U+C24B  uniC24B,  HANGUL SYLLABLE-C24B
        0xC24C, # G+13814  U+C24C  uniC24C,  HANGUL SYLLABLE-C24C
        0xC24D, # G+13815  U+C24D  uniC24D,  HANGUL SYLLABLE-C24D
        0xC24E, # G+13816  U+C24E  uniC24E,  HANGUL SYLLABLE-C24E
        0xC24F, # G+13817  U+C24F  uniC24F,  HANGUL SYLLABLE-C24F
        0xC252, # G+13818  U+C252  uniC252,  HANGUL SYLLABLE-C252
        0xC253, # G+13819  U+C253  uniC253,  HANGUL SYLLABLE-C253
        0xC255, # G+13820  U+C255  uniC255,  HANGUL SYLLABLE-C255
        0xC256, # G+13821  U+C256  uniC256,  HANGUL SYLLABLE-C256
        0xC257, # G+13822  U+C257  uniC257,  HANGUL SYLLABLE-C257
        0xC259, # G+13823  U+C259  uniC259,  HANGUL SYLLABLE-C259
        0xC25A, # G+13824  U+C25A  uniC25A,  HANGUL SYLLABLE-C25A
        0xC25B, # G+13825  U+C25B  uniC25B,  HANGUL SYLLABLE-C25B
        0xC25C, # G+13826  U+C25C  uniC25C,  HANGUL SYLLABLE-C25C
        0xC25D, # G+13827  U+C25D  uniC25D,  HANGUL SYLLABLE-C25D
        0xC25E, # G+13828  U+C25E  uniC25E,  HANGUL SYLLABLE-C25E
        0xC25F, # G+13829  U+C25F  uniC25F,  HANGUL SYLLABLE-C25F
        0xC261, # G+13830  U+C261  uniC261,  HANGUL SYLLABLE-C261
        0xC262, # G+13831  U+C262  uniC262,  HANGUL SYLLABLE-C262
        0xC263, # G+13832  U+C263  uniC263,  HANGUL SYLLABLE-C263
        0xC264, # G+13833  U+C264  uniC264,  HANGUL SYLLABLE-C264
        0xC266, # G+13834  U+C266  uniC266,  HANGUL SYLLABLE-C266
        0xC267, # G+13835  U+C267  uniC267,  HANGUL SYLLABLE-C267
        0xC268, # G+13836  U+C268  uniC268,  HANGUL SYLLABLE-C268
        0xC269, # G+13837  U+C269  uniC269,  HANGUL SYLLABLE-C269
        0xC26A, # G+13838  U+C26A  uniC26A,  HANGUL SYLLABLE-C26A
        0xC26B, # G+13839  U+C26B  uniC26B,  HANGUL SYLLABLE-C26B
        0xC26E, # G+13840  U+C26E  uniC26E,  HANGUL SYLLABLE-C26E
        0xC26F, # G+13841  U+C26F  uniC26F,  HANGUL SYLLABLE-C26F
        0xC271, # G+13842  U+C271  uniC271,  HANGUL SYLLABLE-C271
        0xC272, # G+13843  U+C272  uniC272,  HANGUL SYLLABLE-C272
        0xC273, # G+13844  U+C273  uniC273,  HANGUL SYLLABLE-C273
        0xC275, # G+13845  U+C275  uniC275,  HANGUL SYLLABLE-C275
        0xC276, # G+13846  U+C276  uniC276,  HANGUL SYLLABLE-C276
        0xC277, # G+13847  U+C277  uniC277,  HANGUL SYLLABLE-C277
        0xC278, # G+13848  U+C278  uniC278,  HANGUL SYLLABLE-C278
        0xC279, # G+13849  U+C279  uniC279,  HANGUL SYLLABLE-C279
        0xC27A, # G+13850  U+C27A  uniC27A,  HANGUL SYLLABLE-C27A
        0xC27B, # G+13851  U+C27B  uniC27B,  HANGUL SYLLABLE-C27B
        0xC27E, # G+13852  U+C27E  uniC27E,  HANGUL SYLLABLE-C27E
        0xC280, # G+13853  U+C280  uniC280,  HANGUL SYLLABLE-C280
        0xC282, # G+13854  U+C282  uniC282,  HANGUL SYLLABLE-C282
        0xC283, # G+13855  U+C283  uniC283,  HANGUL SYLLABLE-C283
        0xC284, # G+13856  U+C284  uniC284,  HANGUL SYLLABLE-C284
        0xC285, # G+13857  U+C285  uniC285,  HANGUL SYLLABLE-C285
        0xC286, # G+13858  U+C286  uniC286,  HANGUL SYLLABLE-C286
        0xC287, # G+13859  U+C287  uniC287,  HANGUL SYLLABLE-C287
        0xC28A, # G+13860  U+C28A  uniC28A,  HANGUL SYLLABLE-C28A
        0xC28B, # G+13861  U+C28B  uniC28B,  HANGUL SYLLABLE-C28B
        0xC28C, # G+13862  U+C28C  uniC28C,  HANGUL SYLLABLE-C28C
        0xC28D, # G+13863  U+C28D  uniC28D,  HANGUL SYLLABLE-C28D
        0xC28E, # G+13864  U+C28E  uniC28E,  HANGUL SYLLABLE-C28E
        0xC28F, # G+13865  U+C28F  uniC28F,  HANGUL SYLLABLE-C28F
        0xC291, # G+13866  U+C291  uniC291,  HANGUL SYLLABLE-C291
        0xC292, # G+13867  U+C292  uniC292,  HANGUL SYLLABLE-C292
        0xC293, # G+13868  U+C293  uniC293,  HANGUL SYLLABLE-C293
        0xC294, # G+13869  U+C294  uniC294,  HANGUL SYLLABLE-C294
        0xC295, # G+13870  U+C295  uniC295,  HANGUL SYLLABLE-C295
        0xC296, # G+13871  U+C296  uniC296,  HANGUL SYLLABLE-C296
        0xC297, # G+13872  U+C297  uniC297,  HANGUL SYLLABLE-C297
        0xC299, # G+13873  U+C299  uniC299,  HANGUL SYLLABLE-C299
        0xC29A, # G+13874  U+C29A  uniC29A,  HANGUL SYLLABLE-C29A
        0xC29C, # G+13875  U+C29C  uniC29C,  HANGUL SYLLABLE-C29C
        0xC29E, # G+13876  U+C29E  uniC29E,  HANGUL SYLLABLE-C29E
        0xC29F, # G+13877  U+C29F  uniC29F,  HANGUL SYLLABLE-C29F
        0xC2A0, # G+13878  U+C2A0  uniC2A0,  HANGUL SYLLABLE-C2A0
        0xC2A1, # G+13879  U+C2A1  uniC2A1,  HANGUL SYLLABLE-C2A1
        0xC2A2, # G+13880  U+C2A2  uniC2A2,  HANGUL SYLLABLE-C2A2
        0xC2A3, # G+13881  U+C2A3  uniC2A3,  HANGUL SYLLABLE-C2A3
        0xC2A6, # G+13882  U+C2A6  uniC2A6,  HANGUL SYLLABLE-C2A6
        0xC2A7, # G+13883  U+C2A7  uniC2A7,  HANGUL SYLLABLE-C2A7
        0xC2A9, # G+13884  U+C2A9  uniC2A9,  HANGUL SYLLABLE-C2A9
        0xC2AA, # G+13885  U+C2AA  uniC2AA,  HANGUL SYLLABLE-C2AA
        0xC2AB, # G+13886  U+C2AB  uniC2AB,  HANGUL SYLLABLE-C2AB
        0xC2AE, # G+13887  U+C2AE  uniC2AE,  HANGUL SYLLABLE-C2AE
        0xC2AF, # G+13888  U+C2AF  uniC2AF,  HANGUL SYLLABLE-C2AF
        0xC2B0, # G+13889  U+C2B0  uniC2B0,  HANGUL SYLLABLE-C2B0
        0xC2B1, # G+13890  U+C2B1  uniC2B1,  HANGUL SYLLABLE-C2B1
        0xC2B2, # G+13891  U+C2B2  uniC2B2,  HANGUL SYLLABLE-C2B2
        0xC2B3, # G+13892  U+C2B3  uniC2B3,  HANGUL SYLLABLE-C2B3
        0xC2B6, # G+13893  U+C2B6  uniC2B6,  HANGUL SYLLABLE-C2B6
        0xC2B8, # G+13894  U+C2B8  uniC2B8,  HANGUL SYLLABLE-C2B8
        0xC2BA, # G+13895  U+C2BA  uniC2BA,  HANGUL SYLLABLE-C2BA
        0xC2BB, # G+13896  U+C2BB  uniC2BB,  HANGUL SYLLABLE-C2BB
        0xC2BC, # G+13897  U+C2BC  uniC2BC,  HANGUL SYLLABLE-C2BC
        0xC2BD, # G+13898  U+C2BD  uniC2BD,  HANGUL SYLLABLE-C2BD
        0xC2BE, # G+13899  U+C2BE  uniC2BE,  HANGUL SYLLABLE-C2BE
        0xC2BF, # G+13900  U+C2BF  uniC2BF,  HANGUL SYLLABLE-C2BF
        0xC2C0, # G+13901  U+C2C0  uniC2C0,  HANGUL SYLLABLE-C2C0
        0xC2C1, # G+13902  U+C2C1  uniC2C1,  HANGUL SYLLABLE-C2C1
        0xC2C2, # G+13903  U+C2C2  uniC2C2,  HANGUL SYLLABLE-C2C2
        0xC2C3, # G+13904  U+C2C3  uniC2C3,  HANGUL SYLLABLE-C2C3
        0xC2C4, # G+13905  U+C2C4  uniC2C4,  HANGUL SYLLABLE-C2C4
        0xC2C5, # G+13906  U+C2C5  uniC2C5,  HANGUL SYLLABLE-C2C5
        0xC2C6, # G+13907  U+C2C6  uniC2C6,  HANGUL SYLLABLE-C2C6
        0xC2C7, # G+13908  U+C2C7  uniC2C7,  HANGUL SYLLABLE-C2C7
        0xC2C8, # G+13909  U+C2C8  uniC2C8,  HANGUL SYLLABLE-C2C8
        0xC2C9, # G+13910  U+C2C9  uniC2C9,  HANGUL SYLLABLE-C2C9
        0xC2CA, # G+13911  U+C2CA  uniC2CA,  HANGUL SYLLABLE-C2CA
        0xC2CB, # G+13912  U+C2CB  uniC2CB,  HANGUL SYLLABLE-C2CB
        0xC2CC, # G+13913  U+C2CC  uniC2CC,  HANGUL SYLLABLE-C2CC
        0xC2CD, # G+13914  U+C2CD  uniC2CD,  HANGUL SYLLABLE-C2CD
        0xC2CE, # G+13915  U+C2CE  uniC2CE,  HANGUL SYLLABLE-C2CE
        0xC2CF, # G+13916  U+C2CF  uniC2CF,  HANGUL SYLLABLE-C2CF
        0xC2D0, # G+13917  U+C2D0  uniC2D0,  HANGUL SYLLABLE-C2D0
        0xC2D1, # G+13918  U+C2D1  uniC2D1,  HANGUL SYLLABLE-C2D1
        0xC2D2, # G+13919  U+C2D2  uniC2D2,  HANGUL SYLLABLE-C2D2
        0xC2D3, # G+13920  U+C2D3  uniC2D3,  HANGUL SYLLABLE-C2D3
        0xC2D4, # G+13921  U+C2D4  uniC2D4,  HANGUL SYLLABLE-C2D4
        0xC2D5, # G+13922  U+C2D5  uniC2D5,  HANGUL SYLLABLE-C2D5
        0xC2D6, # G+13923  U+C2D6  uniC2D6,  HANGUL SYLLABLE-C2D6
        0xC2D7, # G+13924  U+C2D7  uniC2D7,  HANGUL SYLLABLE-C2D7
        0xC2D8, # G+13925  U+C2D8  uniC2D8,  HANGUL SYLLABLE-C2D8
        0xC2D9, # G+13926  U+C2D9  uniC2D9,  HANGUL SYLLABLE-C2D9
        0xC2DA, # G+13927  U+C2DA  uniC2DA,  HANGUL SYLLABLE-C2DA
        0xC2DB, # G+13928  U+C2DB  uniC2DB,  HANGUL SYLLABLE-C2DB
        0xC2DE, # G+13929  U+C2DE  uniC2DE,  HANGUL SYLLABLE-C2DE
        0xC2DF, # G+13930  U+C2DF  uniC2DF,  HANGUL SYLLABLE-C2DF
        0xC2E1, # G+13931  U+C2E1  uniC2E1,  HANGUL SYLLABLE-C2E1
        0xC2E2, # G+13932  U+C2E2  uniC2E2,  HANGUL SYLLABLE-C2E2
        0xC2E5, # G+13933  U+C2E5  uniC2E5,  HANGUL SYLLABLE-C2E5
        0xC2E6, # G+13934  U+C2E6  uniC2E6,  HANGUL SYLLABLE-C2E6
        0xC2E7, # G+13935  U+C2E7  uniC2E7,  HANGUL SYLLABLE-C2E7
        0xC2E8, # G+13936  U+C2E8  uniC2E8,  HANGUL SYLLABLE-C2E8
        0xC2E9, # G+13937  U+C2E9  uniC2E9,  HANGUL SYLLABLE-C2E9
        0xC2EA, # G+13938  U+C2EA  uniC2EA,  HANGUL SYLLABLE-C2EA
        0xC2EE, # G+13939  U+C2EE  uniC2EE,  HANGUL SYLLABLE-C2EE
        0xC2F0, # G+13940  U+C2F0  uniC2F0,  HANGUL SYLLABLE-C2F0
        0xC2F2, # G+13941  U+C2F2  uniC2F2,  HANGUL SYLLABLE-C2F2
        0xC2F3, # G+13942  U+C2F3  uniC2F3,  HANGUL SYLLABLE-C2F3
        0xC2F4, # G+13943  U+C2F4  uniC2F4,  HANGUL SYLLABLE-C2F4
        0xC2F5, # G+13944  U+C2F5  uniC2F5,  HANGUL SYLLABLE-C2F5
        0xC2F7, # G+13945  U+C2F7  uniC2F7,  HANGUL SYLLABLE-C2F7
        0xC2FA, # G+13946  U+C2FA  uniC2FA,  HANGUL SYLLABLE-C2FA
        0xC2FD, # G+13947  U+C2FD  uniC2FD,  HANGUL SYLLABLE-C2FD
        0xC2FE, # G+13948  U+C2FE  uniC2FE,  HANGUL SYLLABLE-C2FE
        0xC2FF, # G+13949  U+C2FF  uniC2FF,  HANGUL SYLLABLE-C2FF
        0xC301, # G+13950  U+C301  uniC301,  HANGUL SYLLABLE-C301
        0xC302, # G+13951  U+C302  uniC302,  HANGUL SYLLABLE-C302
        0xC303, # G+13952  U+C303  uniC303,  HANGUL SYLLABLE-C303
        0xC304, # G+13953  U+C304  uniC304,  HANGUL SYLLABLE-C304
        0xC305, # G+13954  U+C305  uniC305,  HANGUL SYLLABLE-C305
        0xC306, # G+13955  U+C306  uniC306,  HANGUL SYLLABLE-C306
        0xC307, # G+13956  U+C307  uniC307,  HANGUL SYLLABLE-C307
        0xC30A, # G+13957  U+C30A  uniC30A,  HANGUL SYLLABLE-C30A
        0xC30B, # G+13958  U+C30B  uniC30B,  HANGUL SYLLABLE-C30B
        0xC30E, # G+13959  U+C30E  uniC30E,  HANGUL SYLLABLE-C30E
        0xC30F, # G+13960  U+C30F  uniC30F,  HANGUL SYLLABLE-C30F
        0xC310, # G+13961  U+C310  uniC310,  HANGUL SYLLABLE-C310
        0xC311, # G+13962  U+C311  uniC311,  HANGUL SYLLABLE-C311
        0xC312, # G+13963  U+C312  uniC312,  HANGUL SYLLABLE-C312
        0xC316, # G+13964  U+C316  uniC316,  HANGUL SYLLABLE-C316
        0xC317, # G+13965  U+C317  uniC317,  HANGUL SYLLABLE-C317
        0xC319, # G+13966  U+C319  uniC319,  HANGUL SYLLABLE-C319
        0xC31A, # G+13967  U+C31A  uniC31A,  HANGUL SYLLABLE-C31A
        0xC31B, # G+13968  U+C31B  uniC31B,  HANGUL SYLLABLE-C31B
        0xC31D, # G+13969  U+C31D  uniC31D,  HANGUL SYLLABLE-C31D
        0xC31E, # G+13970  U+C31E  uniC31E,  HANGUL SYLLABLE-C31E
        0xC31F, # G+13971  U+C31F  uniC31F,  HANGUL SYLLABLE-C31F
        0xC320, # G+13972  U+C320  uniC320,  HANGUL SYLLABLE-C320
        0xC321, # G+13973  U+C321  uniC321,  HANGUL SYLLABLE-C321
        0xC322, # G+13974  U+C322  uniC322,  HANGUL SYLLABLE-C322
        0xC323, # G+13975  U+C323  uniC323,  HANGUL SYLLABLE-C323
        0xC326, # G+13976  U+C326  uniC326,  HANGUL SYLLABLE-C326
        0xC327, # G+13977  U+C327  uniC327,  HANGUL SYLLABLE-C327
        0xC32A, # G+13978  U+C32A  uniC32A,  HANGUL SYLLABLE-C32A
        0xC32B, # G+13979  U+C32B  uniC32B,  HANGUL SYLLABLE-C32B
        0xC32C, # G+13980  U+C32C  uniC32C,  HANGUL SYLLABLE-C32C
        0xC32D, # G+13981  U+C32D  uniC32D,  HANGUL SYLLABLE-C32D
        0xC32E, # G+13982  U+C32E  uniC32E,  HANGUL SYLLABLE-C32E
        0xC32F, # G+13983  U+C32F  uniC32F,  HANGUL SYLLABLE-C32F
        0xC330, # G+13984  U+C330  uniC330,  HANGUL SYLLABLE-C330
        0xC331, # G+13985  U+C331  uniC331,  HANGUL SYLLABLE-C331
        0xC332, # G+13986  U+C332  uniC332,  HANGUL SYLLABLE-C332
        0xC333, # G+13987  U+C333  uniC333,  HANGUL SYLLABLE-C333
        0xC334, # G+13988  U+C334  uniC334,  HANGUL SYLLABLE-C334
        0xC335, # G+13989  U+C335  uniC335,  HANGUL SYLLABLE-C335
        0xC336, # G+13990  U+C336  uniC336,  HANGUL SYLLABLE-C336
        0xC337, # G+13991  U+C337  uniC337,  HANGUL SYLLABLE-C337
        0xC338, # G+13992  U+C338  uniC338,  HANGUL SYLLABLE-C338
        0xC339, # G+13993  U+C339  uniC339,  HANGUL SYLLABLE-C339
        0xC33A, # G+13994  U+C33A  uniC33A,  HANGUL SYLLABLE-C33A
        0xC33B, # G+13995  U+C33B  uniC33B,  HANGUL SYLLABLE-C33B
        0xC33C, # G+13996  U+C33C  uniC33C,  HANGUL SYLLABLE-C33C
        0xC33D, # G+13997  U+C33D  uniC33D,  HANGUL SYLLABLE-C33D
        0xC33E, # G+13998  U+C33E  uniC33E,  HANGUL SYLLABLE-C33E
        0xC33F, # G+13999  U+C33F  uniC33F,  HANGUL SYLLABLE-C33F
        0xC340, # G+14000  U+C340  uniC340,  HANGUL SYLLABLE-C340
        0xC341, # G+14001  U+C341  uniC341,  HANGUL SYLLABLE-C341
        0xC342, # G+14002  U+C342  uniC342,  HANGUL SYLLABLE-C342
        0xC343, # G+14003  U+C343  uniC343,  HANGUL SYLLABLE-C343
        0xC344, # G+14004  U+C344  uniC344,  HANGUL SYLLABLE-C344
        0xC346, # G+14005  U+C346  uniC346,  HANGUL SYLLABLE-C346
        0xC347, # G+14006  U+C347  uniC347,  HANGUL SYLLABLE-C347
        0xC348, # G+14007  U+C348  uniC348,  HANGUL SYLLABLE-C348
        0xC349, # G+14008  U+C349  uniC349,  HANGUL SYLLABLE-C349
        0xC34A, # G+14009  U+C34A  uniC34A,  HANGUL SYLLABLE-C34A
        0xC34B, # G+14010  U+C34B  uniC34B,  HANGUL SYLLABLE-C34B
        0xC34C, # G+14011  U+C34C  uniC34C,  HANGUL SYLLABLE-C34C
        0xC34D, # G+14012  U+C34D  uniC34D,  HANGUL SYLLABLE-C34D
        0xC34E, # G+14013  U+C34E  uniC34E,  HANGUL SYLLABLE-C34E
        0xC34F, # G+14014  U+C34F  uniC34F,  HANGUL SYLLABLE-C34F
        0xC350, # G+14015  U+C350  uniC350,  HANGUL SYLLABLE-C350
        0xC351, # G+14016  U+C351  uniC351,  HANGUL SYLLABLE-C351
        0xC352, # G+14017  U+C352  uniC352,  HANGUL SYLLABLE-C352
        0xC353, # G+14018  U+C353  uniC353,  HANGUL SYLLABLE-C353
        0xC354, # G+14019  U+C354  uniC354,  HANGUL SYLLABLE-C354
        0xC355, # G+14020  U+C355  uniC355,  HANGUL SYLLABLE-C355
        0xC356, # G+14021  U+C356  uniC356,  HANGUL SYLLABLE-C356
        0xC357, # G+14022  U+C357  uniC357,  HANGUL SYLLABLE-C357
        0xC358, # G+14023  U+C358  uniC358,  HANGUL SYLLABLE-C358
        0xC359, # G+14024  U+C359  uniC359,  HANGUL SYLLABLE-C359
        0xC35A, # G+14025  U+C35A  uniC35A,  HANGUL SYLLABLE-C35A
        0xC35B, # G+14026  U+C35B  uniC35B,  HANGUL SYLLABLE-C35B
        0xC35C, # G+14027  U+C35C  uniC35C,  HANGUL SYLLABLE-C35C
        0xC35D, # G+14028  U+C35D  uniC35D,  HANGUL SYLLABLE-C35D
        0xC35E, # G+14029  U+C35E  uniC35E,  HANGUL SYLLABLE-C35E
        0xC35F, # G+14030  U+C35F  uniC35F,  HANGUL SYLLABLE-C35F
        0xC360, # G+14031  U+C360  uniC360,  HANGUL SYLLABLE-C360
        0xC361, # G+14032  U+C361  uniC361,  HANGUL SYLLABLE-C361
        0xC362, # G+14033  U+C362  uniC362,  HANGUL SYLLABLE-C362
        0xC363, # G+14034  U+C363  uniC363,  HANGUL SYLLABLE-C363
        0xC364, # G+14035  U+C364  uniC364,  HANGUL SYLLABLE-C364
        0xC365, # G+14036  U+C365  uniC365,  HANGUL SYLLABLE-C365
        0xC366, # G+14037  U+C366  uniC366,  HANGUL SYLLABLE-C366
        0xC367, # G+14038  U+C367  uniC367,  HANGUL SYLLABLE-C367
        0xC36A, # G+14039  U+C36A  uniC36A,  HANGUL SYLLABLE-C36A
        0xC36B, # G+14040  U+C36B  uniC36B,  HANGUL SYLLABLE-C36B
        0xC36D, # G+14041  U+C36D  uniC36D,  HANGUL SYLLABLE-C36D
        0xC36E, # G+14042  U+C36E  uniC36E,  HANGUL SYLLABLE-C36E
        0xC36F, # G+14043  U+C36F  uniC36F,  HANGUL SYLLABLE-C36F
        0xC371, # G+14044  U+C371  uniC371,  HANGUL SYLLABLE-C371
        0xC373, # G+14045  U+C373  uniC373,  HANGUL SYLLABLE-C373
        0xC374, # G+14046  U+C374  uniC374,  HANGUL SYLLABLE-C374
        0xC375, # G+14047  U+C375  uniC375,  HANGUL SYLLABLE-C375
        0xC376, # G+14048  U+C376  uniC376,  HANGUL SYLLABLE-C376
        0xC377, # G+14049  U+C377  uniC377,  HANGUL SYLLABLE-C377
        0xC37A, # G+14050  U+C37A  uniC37A,  HANGUL SYLLABLE-C37A
        0xC37B, # G+14051  U+C37B  uniC37B,  HANGUL SYLLABLE-C37B
        0xC37E, # G+14052  U+C37E  uniC37E,  HANGUL SYLLABLE-C37E
        0xC37F, # G+14053  U+C37F  uniC37F,  HANGUL SYLLABLE-C37F
        0xC380, # G+14054  U+C380  uniC380,  HANGUL SYLLABLE-C380
        0xC381, # G+14055  U+C381  uniC381,  HANGUL SYLLABLE-C381
        0xC382, # G+14056  U+C382  uniC382,  HANGUL SYLLABLE-C382
        0xC383, # G+14057  U+C383  uniC383,  HANGUL SYLLABLE-C383
        0xC385, # G+14058  U+C385  uniC385,  HANGUL SYLLABLE-C385
        0xC386, # G+14059  U+C386  uniC386,  HANGUL SYLLABLE-C386
        0xC387, # G+14060  U+C387  uniC387,  HANGUL SYLLABLE-C387
        0xC389, # G+14061  U+C389  uniC389,  HANGUL SYLLABLE-C389
        0xC38A, # G+14062  U+C38A  uniC38A,  HANGUL SYLLABLE-C38A
        0xC38B, # G+14063  U+C38B  uniC38B,  HANGUL SYLLABLE-C38B
        0xC38D, # G+14064  U+C38D  uniC38D,  HANGUL SYLLABLE-C38D
        0xC38E, # G+14065  U+C38E  uniC38E,  HANGUL SYLLABLE-C38E
        0xC38F, # G+14066  U+C38F  uniC38F,  HANGUL SYLLABLE-C38F
        0xC390, # G+14067  U+C390  uniC390,  HANGUL SYLLABLE-C390
        0xC391, # G+14068  U+C391  uniC391,  HANGUL SYLLABLE-C391
        0xC392, # G+14069  U+C392  uniC392,  HANGUL SYLLABLE-C392
        0xC393, # G+14070  U+C393  uniC393,  HANGUL SYLLABLE-C393
        0xC394, # G+14071  U+C394  uniC394,  HANGUL SYLLABLE-C394
        0xC395, # G+14072  U+C395  uniC395,  HANGUL SYLLABLE-C395
        0xC396, # G+14073  U+C396  uniC396,  HANGUL SYLLABLE-C396
        0xC397, # G+14074  U+C397  uniC397,  HANGUL SYLLABLE-C397
        0xC398, # G+14075  U+C398  uniC398,  HANGUL SYLLABLE-C398
        0xC399, # G+14076  U+C399  uniC399,  HANGUL SYLLABLE-C399
        0xC39A, # G+14077  U+C39A  uniC39A,  HANGUL SYLLABLE-C39A
        0xC39B, # G+14078  U+C39B  uniC39B,  HANGUL SYLLABLE-C39B
        0xC39C, # G+14079  U+C39C  uniC39C,  HANGUL SYLLABLE-C39C
        0xC39D, # G+14080  U+C39D  uniC39D,  HANGUL SYLLABLE-C39D
        0xC39E, # G+14081  U+C39E  uniC39E,  HANGUL SYLLABLE-C39E
        0xC39F, # G+14082  U+C39F  uniC39F,  HANGUL SYLLABLE-C39F
        0xC3A0, # G+14083  U+C3A0  uniC3A0,  HANGUL SYLLABLE-C3A0
        0xC3A1, # G+14084  U+C3A1  uniC3A1,  HANGUL SYLLABLE-C3A1
        0xC3A2, # G+14085  U+C3A2  uniC3A2,  HANGUL SYLLABLE-C3A2
        0xC3A3, # G+14086  U+C3A3  uniC3A3,  HANGUL SYLLABLE-C3A3
        0xC3A4, # G+14087  U+C3A4  uniC3A4,  HANGUL SYLLABLE-C3A4
        0xC3A5, # G+14088  U+C3A5  uniC3A5,  HANGUL SYLLABLE-C3A5
        0xC3A6, # G+14089  U+C3A6  uniC3A6,  HANGUL SYLLABLE-C3A6
        0xC3A7, # G+14090  U+C3A7  uniC3A7,  HANGUL SYLLABLE-C3A7
        0xC3A8, # G+14091  U+C3A8  uniC3A8,  HANGUL SYLLABLE-C3A8
        0xC3A9, # G+14092  U+C3A9  uniC3A9,  HANGUL SYLLABLE-C3A9
        0xC3AA, # G+14093  U+C3AA  uniC3AA,  HANGUL SYLLABLE-C3AA
        0xC3AB, # G+14094  U+C3AB  uniC3AB,  HANGUL SYLLABLE-C3AB
        0xC3AC, # G+14095  U+C3AC  uniC3AC,  HANGUL SYLLABLE-C3AC
        0xC3AD, # G+14096  U+C3AD  uniC3AD,  HANGUL SYLLABLE-C3AD
        0xC3AE, # G+14097  U+C3AE  uniC3AE,  HANGUL SYLLABLE-C3AE
        0xC3AF, # G+14098  U+C3AF  uniC3AF,  HANGUL SYLLABLE-C3AF
        0xC3B0, # G+14099  U+C3B0  uniC3B0,  HANGUL SYLLABLE-C3B0
        0xC3B1, # G+14100  U+C3B1  uniC3B1,  HANGUL SYLLABLE-C3B1
        0xC3B2, # G+14101  U+C3B2  uniC3B2,  HANGUL SYLLABLE-C3B2
        0xC3B3, # G+14102  U+C3B3  uniC3B3,  HANGUL SYLLABLE-C3B3
        0xC3B4, # G+14103  U+C3B4  uniC3B4,  HANGUL SYLLABLE-C3B4
        0xC3B5, # G+14104  U+C3B5  uniC3B5,  HANGUL SYLLABLE-C3B5
        0xC3B6, # G+14105  U+C3B6  uniC3B6,  HANGUL SYLLABLE-C3B6
        0xC3B7, # G+14106  U+C3B7  uniC3B7,  HANGUL SYLLABLE-C3B7
        0xC3B8, # G+14107  U+C3B8  uniC3B8,  HANGUL SYLLABLE-C3B8
        0xC3B9, # G+14108  U+C3B9  uniC3B9,  HANGUL SYLLABLE-C3B9
        0xC3BA, # G+14109  U+C3BA  uniC3BA,  HANGUL SYLLABLE-C3BA
        0xC3BB, # G+14110  U+C3BB  uniC3BB,  HANGUL SYLLABLE-C3BB
        0xC3BC, # G+14111  U+C3BC  uniC3BC,  HANGUL SYLLABLE-C3BC
        0xC3BD, # G+14112  U+C3BD  uniC3BD,  HANGUL SYLLABLE-C3BD
        0xC3BE, # G+14113  U+C3BE  uniC3BE,  HANGUL SYLLABLE-C3BE
        0xC3BF, # G+14114  U+C3BF  uniC3BF,  HANGUL SYLLABLE-C3BF
        0xC3C1, # G+14115  U+C3C1  uniC3C1,  HANGUL SYLLABLE-C3C1
        0xC3C2, # G+14116  U+C3C2  uniC3C2,  HANGUL SYLLABLE-C3C2
        0xC3C3, # G+14117  U+C3C3  uniC3C3,  HANGUL SYLLABLE-C3C3
        0xC3C4, # G+14118  U+C3C4  uniC3C4,  HANGUL SYLLABLE-C3C4
        0xC3C5, # G+14119  U+C3C5  uniC3C5,  HANGUL SYLLABLE-C3C5
        0xC3C6, # G+14120  U+C3C6  uniC3C6,  HANGUL SYLLABLE-C3C6
        0xC3C7, # G+14121  U+C3C7  uniC3C7,  HANGUL SYLLABLE-C3C7
        0xC3C8, # G+14122  U+C3C8  uniC3C8,  HANGUL SYLLABLE-C3C8
        0xC3C9, # G+14123  U+C3C9  uniC3C9,  HANGUL SYLLABLE-C3C9
        0xC3CA, # G+14124  U+C3CA  uniC3CA,  HANGUL SYLLABLE-C3CA
        0xC3CB, # G+14125  U+C3CB  uniC3CB,  HANGUL SYLLABLE-C3CB
        0xC3CC, # G+14126  U+C3CC  uniC3CC,  HANGUL SYLLABLE-C3CC
        0xC3CD, # G+14127  U+C3CD  uniC3CD,  HANGUL SYLLABLE-C3CD
        0xC3CE, # G+14128  U+C3CE  uniC3CE,  HANGUL SYLLABLE-C3CE
        0xC3CF, # G+14129  U+C3CF  uniC3CF,  HANGUL SYLLABLE-C3CF
        0xC3D0, # G+14130  U+C3D0  uniC3D0,  HANGUL SYLLABLE-C3D0
        0xC3D1, # G+14131  U+C3D1  uniC3D1,  HANGUL SYLLABLE-C3D1
        0xC3D2, # G+14132  U+C3D2  uniC3D2,  HANGUL SYLLABLE-C3D2
        0xC3D3, # G+14133  U+C3D3  uniC3D3,  HANGUL SYLLABLE-C3D3
        0xC3D4, # G+14134  U+C3D4  uniC3D4,  HANGUL SYLLABLE-C3D4
        0xC3D5, # G+14135  U+C3D5  uniC3D5,  HANGUL SYLLABLE-C3D5
        0xC3D6, # G+14136  U+C3D6  uniC3D6,  HANGUL SYLLABLE-C3D6
        0xC3D7, # G+14137  U+C3D7  uniC3D7,  HANGUL SYLLABLE-C3D7
        0xC3DA, # G+14138  U+C3DA  uniC3DA,  HANGUL SYLLABLE-C3DA
        0xC3DB, # G+14139  U+C3DB  uniC3DB,  HANGUL SYLLABLE-C3DB
        0xC3DD, # G+14140  U+C3DD  uniC3DD,  HANGUL SYLLABLE-C3DD
        0xC3DE, # G+14141  U+C3DE  uniC3DE,  HANGUL SYLLABLE-C3DE
        0xC3E1, # G+14142  U+C3E1  uniC3E1,  HANGUL SYLLABLE-C3E1
        0xC3E3, # G+14143  U+C3E3  uniC3E3,  HANGUL SYLLABLE-C3E3
        0xC3E4, # G+14144  U+C3E4  uniC3E4,  HANGUL SYLLABLE-C3E4
        0xC3E5, # G+14145  U+C3E5  uniC3E5,  HANGUL SYLLABLE-C3E5
        0xC3E6, # G+14146  U+C3E6  uniC3E6,  HANGUL SYLLABLE-C3E6
        0xC3E7, # G+14147  U+C3E7  uniC3E7,  HANGUL SYLLABLE-C3E7
        0xC3EA, # G+14148  U+C3EA  uniC3EA,  HANGUL SYLLABLE-C3EA
        0xC3EB, # G+14149  U+C3EB  uniC3EB,  HANGUL SYLLABLE-C3EB
        0xC3EC, # G+14150  U+C3EC  uniC3EC,  HANGUL SYLLABLE-C3EC
        0xC3EE, # G+14151  U+C3EE  uniC3EE,  HANGUL SYLLABLE-C3EE
        0xC3EF, # G+14152  U+C3EF  uniC3EF,  HANGUL SYLLABLE-C3EF
        0xC3F0, # G+14153  U+C3F0  uniC3F0,  HANGUL SYLLABLE-C3F0
        0xC3F1, # G+14154  U+C3F1  uniC3F1,  HANGUL SYLLABLE-C3F1
        0xC3F2, # G+14155  U+C3F2  uniC3F2,  HANGUL SYLLABLE-C3F2
        0xC3F3, # G+14156  U+C3F3  uniC3F3,  HANGUL SYLLABLE-C3F3
        0xC3F6, # G+14157  U+C3F6  uniC3F6,  HANGUL SYLLABLE-C3F6
        0xC3F7, # G+14158  U+C3F7  uniC3F7,  HANGUL SYLLABLE-C3F7
        0xC3F9, # G+14159  U+C3F9  uniC3F9,  HANGUL SYLLABLE-C3F9
        0xC3FA, # G+14160  U+C3FA  uniC3FA,  HANGUL SYLLABLE-C3FA
        0xC3FB, # G+14161  U+C3FB  uniC3FB,  HANGUL SYLLABLE-C3FB
        0xC3FC, # G+14162  U+C3FC  uniC3FC,  HANGUL SYLLABLE-C3FC
        0xC3FD, # G+14163  U+C3FD  uniC3FD,  HANGUL SYLLABLE-C3FD
        0xC3FE, # G+14164  U+C3FE  uniC3FE,  HANGUL SYLLABLE-C3FE
        0xC3FF, # G+14165  U+C3FF  uniC3FF,  HANGUL SYLLABLE-C3FF
        0xC400, # G+14166  U+C400  uniC400,  HANGUL SYLLABLE-C400
        0xC401, # G+14167  U+C401  uniC401,  HANGUL SYLLABLE-C401
        0xC402, # G+14168  U+C402  uniC402,  HANGUL SYLLABLE-C402
        0xC403, # G+14169  U+C403  uniC403,  HANGUL SYLLABLE-C403
        0xC404, # G+14170  U+C404  uniC404,  HANGUL SYLLABLE-C404
        0xC405, # G+14171  U+C405  uniC405,  HANGUL SYLLABLE-C405
        0xC406, # G+14172  U+C406  uniC406,  HANGUL SYLLABLE-C406
        0xC407, # G+14173  U+C407  uniC407,  HANGUL SYLLABLE-C407
        0xC409, # G+14174  U+C409  uniC409,  HANGUL SYLLABLE-C409
        0xC40A, # G+14175  U+C40A  uniC40A,  HANGUL SYLLABLE-C40A
        0xC40B, # G+14176  U+C40B  uniC40B,  HANGUL SYLLABLE-C40B
        0xC40C, # G+14177  U+C40C  uniC40C,  HANGUL SYLLABLE-C40C
        0xC40D, # G+14178  U+C40D  uniC40D,  HANGUL SYLLABLE-C40D
        0xC40E, # G+14179  U+C40E  uniC40E,  HANGUL SYLLABLE-C40E
        0xC40F, # G+14180  U+C40F  uniC40F,  HANGUL SYLLABLE-C40F
        0xC411, # G+14181  U+C411  uniC411,  HANGUL SYLLABLE-C411
        0xC412, # G+14182  U+C412  uniC412,  HANGUL SYLLABLE-C412
        0xC413, # G+14183  U+C413  uniC413,  HANGUL SYLLABLE-C413
        0xC414, # G+14184  U+C414  uniC414,  HANGUL SYLLABLE-C414
        0xC415, # G+14185  U+C415  uniC415,  HANGUL SYLLABLE-C415
        0xC416, # G+14186  U+C416  uniC416,  HANGUL SYLLABLE-C416
        0xC417, # G+14187  U+C417  uniC417,  HANGUL SYLLABLE-C417
        0xC418, # G+14188  U+C418  uniC418,  HANGUL SYLLABLE-C418
        0xC419, # G+14189  U+C419  uniC419,  HANGUL SYLLABLE-C419
        0xC41A, # G+14190  U+C41A  uniC41A,  HANGUL SYLLABLE-C41A
        0xC41B, # G+14191  U+C41B  uniC41B,  HANGUL SYLLABLE-C41B
        0xC41C, # G+14192  U+C41C  uniC41C,  HANGUL SYLLABLE-C41C
        0xC41D, # G+14193  U+C41D  uniC41D,  HANGUL SYLLABLE-C41D
        0xC41E, # G+14194  U+C41E  uniC41E,  HANGUL SYLLABLE-C41E
        0xC41F, # G+14195  U+C41F  uniC41F,  HANGUL SYLLABLE-C41F
        0xC420, # G+14196  U+C420  uniC420,  HANGUL SYLLABLE-C420
        0xC421, # G+14197  U+C421  uniC421,  HANGUL SYLLABLE-C421
        0xC422, # G+14198  U+C422  uniC422,  HANGUL SYLLABLE-C422
        0xC423, # G+14199  U+C423  uniC423,  HANGUL SYLLABLE-C423
        0xC425, # G+14200  U+C425  uniC425,  HANGUL SYLLABLE-C425
        0xC426, # G+14201  U+C426  uniC426,  HANGUL SYLLABLE-C426
        0xC427, # G+14202  U+C427  uniC427,  HANGUL SYLLABLE-C427
        0xC428, # G+14203  U+C428  uniC428,  HANGUL SYLLABLE-C428
        0xC429, # G+14204  U+C429  uniC429,  HANGUL SYLLABLE-C429
        0xC42A, # G+14205  U+C42A  uniC42A,  HANGUL SYLLABLE-C42A
        0xC42B, # G+14206  U+C42B  uniC42B,  HANGUL SYLLABLE-C42B
        0xC42D, # G+14207  U+C42D  uniC42D,  HANGUL SYLLABLE-C42D
        0xC42E, # G+14208  U+C42E  uniC42E,  HANGUL SYLLABLE-C42E
        0xC42F, # G+14209  U+C42F  uniC42F,  HANGUL SYLLABLE-C42F
        0xC431, # G+14210  U+C431  uniC431,  HANGUL SYLLABLE-C431
        0xC432, # G+14211  U+C432  uniC432,  HANGUL SYLLABLE-C432
        0xC433, # G+14212  U+C433  uniC433,  HANGUL SYLLABLE-C433
        0xC435, # G+14213  U+C435  uniC435,  HANGUL SYLLABLE-C435
        0xC436, # G+14214  U+C436  uniC436,  HANGUL SYLLABLE-C436
        0xC437, # G+14215  U+C437  uniC437,  HANGUL SYLLABLE-C437
        0xC438, # G+14216  U+C438  uniC438,  HANGUL SYLLABLE-C438
        0xC439, # G+14217  U+C439  uniC439,  HANGUL SYLLABLE-C439
        0xC43A, # G+14218  U+C43A  uniC43A,  HANGUL SYLLABLE-C43A
        0xC43B, # G+14219  U+C43B  uniC43B,  HANGUL SYLLABLE-C43B
        0xC43E, # G+14220  U+C43E  uniC43E,  HANGUL SYLLABLE-C43E
        0xC43F, # G+14221  U+C43F  uniC43F,  HANGUL SYLLABLE-C43F
        0xC440, # G+14222  U+C440  uniC440,  HANGUL SYLLABLE-C440
        0xC441, # G+14223  U+C441  uniC441,  HANGUL SYLLABLE-C441
        0xC442, # G+14224  U+C442  uniC442,  HANGUL SYLLABLE-C442
        0xC443, # G+14225  U+C443  uniC443,  HANGUL SYLLABLE-C443
        0xC444, # G+14226  U+C444  uniC444,  HANGUL SYLLABLE-C444
        0xC445, # G+14227  U+C445  uniC445,  HANGUL SYLLABLE-C445
        0xC446, # G+14228  U+C446  uniC446,  HANGUL SYLLABLE-C446
        0xC447, # G+14229  U+C447  uniC447,  HANGUL SYLLABLE-C447
        0xC449, # G+14230  U+C449  uniC449,  HANGUL SYLLABLE-C449
        0xC44A, # G+14231  U+C44A  uniC44A,  HANGUL SYLLABLE-C44A
        0xC44B, # G+14232  U+C44B  uniC44B,  HANGUL SYLLABLE-C44B
        0xC44C, # G+14233  U+C44C  uniC44C,  HANGUL SYLLABLE-C44C
        0xC44D, # G+14234  U+C44D  uniC44D,  HANGUL SYLLABLE-C44D
        0xC44E, # G+14235  U+C44E  uniC44E,  HANGUL SYLLABLE-C44E
        0xC44F, # G+14236  U+C44F  uniC44F,  HANGUL SYLLABLE-C44F
        0xC450, # G+14237  U+C450  uniC450,  HANGUL SYLLABLE-C450
        0xC451, # G+14238  U+C451  uniC451,  HANGUL SYLLABLE-C451
        0xC452, # G+14239  U+C452  uniC452,  HANGUL SYLLABLE-C452
        0xC453, # G+14240  U+C453  uniC453,  HANGUL SYLLABLE-C453
        0xC454, # G+14241  U+C454  uniC454,  HANGUL SYLLABLE-C454
        0xC455, # G+14242  U+C455  uniC455,  HANGUL SYLLABLE-C455
        0xC456, # G+14243  U+C456  uniC456,  HANGUL SYLLABLE-C456
        0xC457, # G+14244  U+C457  uniC457,  HANGUL SYLLABLE-C457
        0xC458, # G+14245  U+C458  uniC458,  HANGUL SYLLABLE-C458
        0xC459, # G+14246  U+C459  uniC459,  HANGUL SYLLABLE-C459
        0xC45A, # G+14247  U+C45A  uniC45A,  HANGUL SYLLABLE-C45A
        0xC45B, # G+14248  U+C45B  uniC45B,  HANGUL SYLLABLE-C45B
        0xC45C, # G+14249  U+C45C  uniC45C,  HANGUL SYLLABLE-C45C
        0xC45D, # G+14250  U+C45D  uniC45D,  HANGUL SYLLABLE-C45D
        0xC45E, # G+14251  U+C45E  uniC45E,  HANGUL SYLLABLE-C45E
        0xC45F, # G+14252  U+C45F  uniC45F,  HANGUL SYLLABLE-C45F
        0xC460, # G+14253  U+C460  uniC460,  HANGUL SYLLABLE-C460
        0xC461, # G+14254  U+C461  uniC461,  HANGUL SYLLABLE-C461
        0xC462, # G+14255  U+C462  uniC462,  HANGUL SYLLABLE-C462
        0xC463, # G+14256  U+C463  uniC463,  HANGUL SYLLABLE-C463
        0xC466, # G+14257  U+C466  uniC466,  HANGUL SYLLABLE-C466
        0xC467, # G+14258  U+C467  uniC467,  HANGUL SYLLABLE-C467
        0xC469, # G+14259  U+C469  uniC469,  HANGUL SYLLABLE-C469
        0xC46A, # G+14260  U+C46A  uniC46A,  HANGUL SYLLABLE-C46A
        0xC46B, # G+14261  U+C46B  uniC46B,  HANGUL SYLLABLE-C46B
        0xC46D, # G+14262  U+C46D  uniC46D,  HANGUL SYLLABLE-C46D
        0xC46E, # G+14263  U+C46E  uniC46E,  HANGUL SYLLABLE-C46E
        0xC46F, # G+14264  U+C46F  uniC46F,  HANGUL SYLLABLE-C46F
        0xC470, # G+14265  U+C470  uniC470,  HANGUL SYLLABLE-C470
        0xC471, # G+14266  U+C471  uniC471,  HANGUL SYLLABLE-C471
        0xC472, # G+14267  U+C472  uniC472,  HANGUL SYLLABLE-C472
        0xC473, # G+14268  U+C473  uniC473,  HANGUL SYLLABLE-C473
        0xC476, # G+14269  U+C476  uniC476,  HANGUL SYLLABLE-C476
        0xC477, # G+14270  U+C477  uniC477,  HANGUL SYLLABLE-C477
        0xC478, # G+14271  U+C478  uniC478,  HANGUL SYLLABLE-C478
        0xC47A, # G+14272  U+C47A  uniC47A,  HANGUL SYLLABLE-C47A
        0xC47B, # G+14273  U+C47B  uniC47B,  HANGUL SYLLABLE-C47B
        0xC47C, # G+14274  U+C47C  uniC47C,  HANGUL SYLLABLE-C47C
        0xC47D, # G+14275  U+C47D  uniC47D,  HANGUL SYLLABLE-C47D
        0xC47E, # G+14276  U+C47E  uniC47E,  HANGUL SYLLABLE-C47E
        0xC47F, # G+14277  U+C47F  uniC47F,  HANGUL SYLLABLE-C47F
        0xC481, # G+14278  U+C481  uniC481,  HANGUL SYLLABLE-C481
        0xC482, # G+14279  U+C482  uniC482,  HANGUL SYLLABLE-C482
        0xC483, # G+14280  U+C483  uniC483,  HANGUL SYLLABLE-C483
        0xC484, # G+14281  U+C484  uniC484,  HANGUL SYLLABLE-C484
        0xC485, # G+14282  U+C485  uniC485,  HANGUL SYLLABLE-C485
        0xC486, # G+14283  U+C486  uniC486,  HANGUL SYLLABLE-C486
        0xC487, # G+14284  U+C487  uniC487,  HANGUL SYLLABLE-C487
        0xC488, # G+14285  U+C488  uniC488,  HANGUL SYLLABLE-C488
        0xC489, # G+14286  U+C489  uniC489,  HANGUL SYLLABLE-C489
        0xC48A, # G+14287  U+C48A  uniC48A,  HANGUL SYLLABLE-C48A
        0xC48B, # G+14288  U+C48B  uniC48B,  HANGUL SYLLABLE-C48B
        0xC48C, # G+14289  U+C48C  uniC48C,  HANGUL SYLLABLE-C48C
        0xC48D, # G+14290  U+C48D  uniC48D,  HANGUL SYLLABLE-C48D
        0xC48E, # G+14291  U+C48E  uniC48E,  HANGUL SYLLABLE-C48E
        0xC48F, # G+14292  U+C48F  uniC48F,  HANGUL SYLLABLE-C48F
        0xC490, # G+14293  U+C490  uniC490,  HANGUL SYLLABLE-C490
        0xC491, # G+14294  U+C491  uniC491,  HANGUL SYLLABLE-C491
        0xC492, # G+14295  U+C492  uniC492,  HANGUL SYLLABLE-C492
        0xC493, # G+14296  U+C493  uniC493,  HANGUL SYLLABLE-C493
        0xC495, # G+14297  U+C495  uniC495,  HANGUL SYLLABLE-C495
        0xC496, # G+14298  U+C496  uniC496,  HANGUL SYLLABLE-C496
        0xC497, # G+14299  U+C497  uniC497,  HANGUL SYLLABLE-C497
        0xC498, # G+14300  U+C498  uniC498,  HANGUL SYLLABLE-C498
        0xC499, # G+14301  U+C499  uniC499,  HANGUL SYLLABLE-C499
        0xC49A, # G+14302  U+C49A  uniC49A,  HANGUL SYLLABLE-C49A
        0xC49B, # G+14303  U+C49B  uniC49B,  HANGUL SYLLABLE-C49B
        0xC49D, # G+14304  U+C49D  uniC49D,  HANGUL SYLLABLE-C49D
        0xC49E, # G+14305  U+C49E  uniC49E,  HANGUL SYLLABLE-C49E
        0xC49F, # G+14306  U+C49F  uniC49F,  HANGUL SYLLABLE-C49F
        0xC4A0, # G+14307  U+C4A0  uniC4A0,  HANGUL SYLLABLE-C4A0
        0xC4A1, # G+14308  U+C4A1  uniC4A1,  HANGUL SYLLABLE-C4A1
        0xC4A2, # G+14309  U+C4A2  uniC4A2,  HANGUL SYLLABLE-C4A2
        0xC4A3, # G+14310  U+C4A3  uniC4A3,  HANGUL SYLLABLE-C4A3
        0xC4A4, # G+14311  U+C4A4  uniC4A4,  HANGUL SYLLABLE-C4A4
        0xC4A5, # G+14312  U+C4A5  uniC4A5,  HANGUL SYLLABLE-C4A5
        0xC4A6, # G+14313  U+C4A6  uniC4A6,  HANGUL SYLLABLE-C4A6
        0xC4A7, # G+14314  U+C4A7  uniC4A7,  HANGUL SYLLABLE-C4A7
        0xC4A8, # G+14315  U+C4A8  uniC4A8,  HANGUL SYLLABLE-C4A8
        0xC4A9, # G+14316  U+C4A9  uniC4A9,  HANGUL SYLLABLE-C4A9
        0xC4AA, # G+14317  U+C4AA  uniC4AA,  HANGUL SYLLABLE-C4AA
        0xC4AB, # G+14318  U+C4AB  uniC4AB,  HANGUL SYLLABLE-C4AB
        0xC4AC, # G+14319  U+C4AC  uniC4AC,  HANGUL SYLLABLE-C4AC
        0xC4AD, # G+14320  U+C4AD  uniC4AD,  HANGUL SYLLABLE-C4AD
        0xC4AE, # G+14321  U+C4AE  uniC4AE,  HANGUL SYLLABLE-C4AE
        0xC4AF, # G+14322  U+C4AF  uniC4AF,  HANGUL SYLLABLE-C4AF
        0xC4B0, # G+14323  U+C4B0  uniC4B0,  HANGUL SYLLABLE-C4B0
        0xC4B1, # G+14324  U+C4B1  uniC4B1,  HANGUL SYLLABLE-C4B1
        0xC4B2, # G+14325  U+C4B2  uniC4B2,  HANGUL SYLLABLE-C4B2
        0xC4B3, # G+14326  U+C4B3  uniC4B3,  HANGUL SYLLABLE-C4B3
        0xC4B4, # G+14327  U+C4B4  uniC4B4,  HANGUL SYLLABLE-C4B4
        0xC4B5, # G+14328  U+C4B5  uniC4B5,  HANGUL SYLLABLE-C4B5
        0xC4B6, # G+14329  U+C4B6  uniC4B6,  HANGUL SYLLABLE-C4B6
        0xC4B7, # G+14330  U+C4B7  uniC4B7,  HANGUL SYLLABLE-C4B7
        0xC4B9, # G+14331  U+C4B9  uniC4B9,  HANGUL SYLLABLE-C4B9
        0xC4BA, # G+14332  U+C4BA  uniC4BA,  HANGUL SYLLABLE-C4BA
        0xC4BB, # G+14333  U+C4BB  uniC4BB,  HANGUL SYLLABLE-C4BB
        0xC4BD, # G+14334  U+C4BD  uniC4BD,  HANGUL SYLLABLE-C4BD
        0xC4BE, # G+14335  U+C4BE  uniC4BE,  HANGUL SYLLABLE-C4BE
        0xC4BF, # G+14336  U+C4BF  uniC4BF,  HANGUL SYLLABLE-C4BF
        0xC4C0, # G+14337  U+C4C0  uniC4C0,  HANGUL SYLLABLE-C4C0
        0xC4C1, # G+14338  U+C4C1  uniC4C1,  HANGUL SYLLABLE-C4C1
        0xC4C2, # G+14339  U+C4C2  uniC4C2,  HANGUL SYLLABLE-C4C2
        0xC4C3, # G+14340  U+C4C3  uniC4C3,  HANGUL SYLLABLE-C4C3
        0xC4C4, # G+14341  U+C4C4  uniC4C4,  HANGUL SYLLABLE-C4C4
        0xC4C5, # G+14342  U+C4C5  uniC4C5,  HANGUL SYLLABLE-C4C5
        0xC4C6, # G+14343  U+C4C6  uniC4C6,  HANGUL SYLLABLE-C4C6
        0xC4C7, # G+14344  U+C4C7  uniC4C7,  HANGUL SYLLABLE-C4C7
        0xC4C8, # G+14345  U+C4C8  uniC4C8,  HANGUL SYLLABLE-C4C8
        0xC4C9, # G+14346  U+C4C9  uniC4C9,  HANGUL SYLLABLE-C4C9
        0xC4CA, # G+14347  U+C4CA  uniC4CA,  HANGUL SYLLABLE-C4CA
        0xC4CB, # G+14348  U+C4CB  uniC4CB,  HANGUL SYLLABLE-C4CB
        0xC4CC, # G+14349  U+C4CC  uniC4CC,  HANGUL SYLLABLE-C4CC
        0xC4CD, # G+14350  U+C4CD  uniC4CD,  HANGUL SYLLABLE-C4CD
        0xC4CE, # G+14351  U+C4CE  uniC4CE,  HANGUL SYLLABLE-C4CE
        0xC4CF, # G+14352  U+C4CF  uniC4CF,  HANGUL SYLLABLE-C4CF
        0xC4D0, # G+14353  U+C4D0  uniC4D0,  HANGUL SYLLABLE-C4D0
        0xC4D1, # G+14354  U+C4D1  uniC4D1,  HANGUL SYLLABLE-C4D1
        0xC4D2, # G+14355  U+C4D2  uniC4D2,  HANGUL SYLLABLE-C4D2
        0xC4D3, # G+14356  U+C4D3  uniC4D3,  HANGUL SYLLABLE-C4D3
        0xC4D4, # G+14357  U+C4D4  uniC4D4,  HANGUL SYLLABLE-C4D4
        0xC4D5, # G+14358  U+C4D5  uniC4D5,  HANGUL SYLLABLE-C4D5
        0xC4D6, # G+14359  U+C4D6  uniC4D6,  HANGUL SYLLABLE-C4D6
        0xC4D7, # G+14360  U+C4D7  uniC4D7,  HANGUL SYLLABLE-C4D7
        0xC4D8, # G+14361  U+C4D8  uniC4D8,  HANGUL SYLLABLE-C4D8
        0xC4D9, # G+14362  U+C4D9  uniC4D9,  HANGUL SYLLABLE-C4D9
        0xC4DA, # G+14363  U+C4DA  uniC4DA,  HANGUL SYLLABLE-C4DA
        0xC4DB, # G+14364  U+C4DB  uniC4DB,  HANGUL SYLLABLE-C4DB
        0xC4DC, # G+14365  U+C4DC  uniC4DC,  HANGUL SYLLABLE-C4DC
        0xC4DD, # G+14366  U+C4DD  uniC4DD,  HANGUL SYLLABLE-C4DD
        0xC4DE, # G+14367  U+C4DE  uniC4DE,  HANGUL SYLLABLE-C4DE
        0xC4DF, # G+14368  U+C4DF  uniC4DF,  HANGUL SYLLABLE-C4DF
        0xC4E0, # G+14369  U+C4E0  uniC4E0,  HANGUL SYLLABLE-C4E0
        0xC4E1, # G+14370  U+C4E1  uniC4E1,  HANGUL SYLLABLE-C4E1
        0xC4E2, # G+14371  U+C4E2  uniC4E2,  HANGUL SYLLABLE-C4E2
        0xC4E3, # G+14372  U+C4E3  uniC4E3,  HANGUL SYLLABLE-C4E3
        0xC4E4, # G+14373  U+C4E4  uniC4E4,  HANGUL SYLLABLE-C4E4
        0xC4E5, # G+14374  U+C4E5  uniC4E5,  HANGUL SYLLABLE-C4E5
        0xC4E6, # G+14375  U+C4E6  uniC4E6,  HANGUL SYLLABLE-C4E6
        0xC4E7, # G+14376  U+C4E7  uniC4E7,  HANGUL SYLLABLE-C4E7
        0xC4E8, # G+14377  U+C4E8  uniC4E8,  HANGUL SYLLABLE-C4E8
        0xC4EA, # G+14378  U+C4EA  uniC4EA,  HANGUL SYLLABLE-C4EA
        0xC4EB, # G+14379  U+C4EB  uniC4EB,  HANGUL SYLLABLE-C4EB
        0xC4EC, # G+14380  U+C4EC  uniC4EC,  HANGUL SYLLABLE-C4EC
        0xC4ED, # G+14381  U+C4ED  uniC4ED,  HANGUL SYLLABLE-C4ED
        0xC4EE, # G+14382  U+C4EE  uniC4EE,  HANGUL SYLLABLE-C4EE
        0xC4EF, # G+14383  U+C4EF  uniC4EF,  HANGUL SYLLABLE-C4EF
        0xC4F2, # G+14384  U+C4F2  uniC4F2,  HANGUL SYLLABLE-C4F2
        0xC4F3, # G+14385  U+C4F3  uniC4F3,  HANGUL SYLLABLE-C4F3
        0xC4F5, # G+14386  U+C4F5  uniC4F5,  HANGUL SYLLABLE-C4F5
        0xC4F6, # G+14387  U+C4F6  uniC4F6,  HANGUL SYLLABLE-C4F6
        0xC4F7, # G+14388  U+C4F7  uniC4F7,  HANGUL SYLLABLE-C4F7
        0xC4F9, # G+14389  U+C4F9  uniC4F9,  HANGUL SYLLABLE-C4F9
        0xC4FB, # G+14390  U+C4FB  uniC4FB,  HANGUL SYLLABLE-C4FB
        0xC4FC, # G+14391  U+C4FC  uniC4FC,  HANGUL SYLLABLE-C4FC
        0xC4FD, # G+14392  U+C4FD  uniC4FD,  HANGUL SYLLABLE-C4FD
        0xC4FE, # G+14393  U+C4FE  uniC4FE,  HANGUL SYLLABLE-C4FE
        0xC502, # G+14394  U+C502  uniC502,  HANGUL SYLLABLE-C502
        0xC503, # G+14395  U+C503  uniC503,  HANGUL SYLLABLE-C503
        0xC504, # G+14396  U+C504  uniC504,  HANGUL SYLLABLE-C504
        0xC505, # G+14397  U+C505  uniC505,  HANGUL SYLLABLE-C505
        0xC506, # G+14398  U+C506  uniC506,  HANGUL SYLLABLE-C506
        0xC507, # G+14399  U+C507  uniC507,  HANGUL SYLLABLE-C507
        0xC508, # G+14400  U+C508  uniC508,  HANGUL SYLLABLE-C508
        0xC509, # G+14401  U+C509  uniC509,  HANGUL SYLLABLE-C509
        0xC50A, # G+14402  U+C50A  uniC50A,  HANGUL SYLLABLE-C50A
        0xC50B, # G+14403  U+C50B  uniC50B,  HANGUL SYLLABLE-C50B
        0xC50D, # G+14404  U+C50D  uniC50D,  HANGUL SYLLABLE-C50D
        0xC50E, # G+14405  U+C50E  uniC50E,  HANGUL SYLLABLE-C50E
        0xC50F, # G+14406  U+C50F  uniC50F,  HANGUL SYLLABLE-C50F
        0xC511, # G+14407  U+C511  uniC511,  HANGUL SYLLABLE-C511
        0xC512, # G+14408  U+C512  uniC512,  HANGUL SYLLABLE-C512
        0xC513, # G+14409  U+C513  uniC513,  HANGUL SYLLABLE-C513
        0xC515, # G+14410  U+C515  uniC515,  HANGUL SYLLABLE-C515
        0xC516, # G+14411  U+C516  uniC516,  HANGUL SYLLABLE-C516
        0xC517, # G+14412  U+C517  uniC517,  HANGUL SYLLABLE-C517
        0xC518, # G+14413  U+C518  uniC518,  HANGUL SYLLABLE-C518
        0xC519, # G+14414  U+C519  uniC519,  HANGUL SYLLABLE-C519
        0xC51A, # G+14415  U+C51A  uniC51A,  HANGUL SYLLABLE-C51A
        0xC51B, # G+14416  U+C51B  uniC51B,  HANGUL SYLLABLE-C51B
        0xC51D, # G+14417  U+C51D  uniC51D,  HANGUL SYLLABLE-C51D
        0xC51E, # G+14418  U+C51E  uniC51E,  HANGUL SYLLABLE-C51E
        0xC51F, # G+14419  U+C51F  uniC51F,  HANGUL SYLLABLE-C51F
        0xC520, # G+14420  U+C520  uniC520,  HANGUL SYLLABLE-C520
        0xC521, # G+14421  U+C521  uniC521,  HANGUL SYLLABLE-C521
        0xC522, # G+14422  U+C522  uniC522,  HANGUL SYLLABLE-C522
        0xC523, # G+14423  U+C523  uniC523,  HANGUL SYLLABLE-C523
        0xC524, # G+14424  U+C524  uniC524,  HANGUL SYLLABLE-C524
        0xC525, # G+14425  U+C525  uniC525,  HANGUL SYLLABLE-C525
        0xC526, # G+14426  U+C526  uniC526,  HANGUL SYLLABLE-C526
        0xC527, # G+14427  U+C527  uniC527,  HANGUL SYLLABLE-C527
        0xC52A, # G+14428  U+C52A  uniC52A,  HANGUL SYLLABLE-C52A
        0xC52B, # G+14429  U+C52B  uniC52B,  HANGUL SYLLABLE-C52B
        0xC52D, # G+14430  U+C52D  uniC52D,  HANGUL SYLLABLE-C52D
        0xC52E, # G+14431  U+C52E  uniC52E,  HANGUL SYLLABLE-C52E
        0xC52F, # G+14432  U+C52F  uniC52F,  HANGUL SYLLABLE-C52F
        0xC531, # G+14433  U+C531  uniC531,  HANGUL SYLLABLE-C531
        0xC532, # G+14434  U+C532  uniC532,  HANGUL SYLLABLE-C532
        0xC533, # G+14435  U+C533  uniC533,  HANGUL SYLLABLE-C533
        0xC534, # G+14436  U+C534  uniC534,  HANGUL SYLLABLE-C534
        0xC535, # G+14437  U+C535  uniC535,  HANGUL SYLLABLE-C535
        0xC536, # G+14438  U+C536  uniC536,  HANGUL SYLLABLE-C536
        0xC537, # G+14439  U+C537  uniC537,  HANGUL SYLLABLE-C537
        0xC53A, # G+14440  U+C53A  uniC53A,  HANGUL SYLLABLE-C53A
        0xC53C, # G+14441  U+C53C  uniC53C,  HANGUL SYLLABLE-C53C
        0xC53E, # G+14442  U+C53E  uniC53E,  HANGUL SYLLABLE-C53E
        0xC53F, # G+14443  U+C53F  uniC53F,  HANGUL SYLLABLE-C53F
        0xC540, # G+14444  U+C540  uniC540,  HANGUL SYLLABLE-C540
        0xC541, # G+14445  U+C541  uniC541,  HANGUL SYLLABLE-C541
        0xC542, # G+14446  U+C542  uniC542,  HANGUL SYLLABLE-C542
        0xC543, # G+14447  U+C543  uniC543,  HANGUL SYLLABLE-C543
        0xC546, # G+14448  U+C546  uniC546,  HANGUL SYLLABLE-C546
        0xC547, # G+14449  U+C547  uniC547,  HANGUL SYLLABLE-C547
        0xC54B, # G+14450  U+C54B  uniC54B,  HANGUL SYLLABLE-C54B
        0xC54F, # G+14451  U+C54F  uniC54F,  HANGUL SYLLABLE-C54F
        0xC550, # G+14452  U+C550  uniC550,  HANGUL SYLLABLE-C550
        0xC551, # G+14453  U+C551  uniC551,  HANGUL SYLLABLE-C551
        0xC552, # G+14454  U+C552  uniC552,  HANGUL SYLLABLE-C552
        0xC556, # G+14455  U+C556  uniC556,  HANGUL SYLLABLE-C556
        0xC55A, # G+14456  U+C55A  uniC55A,  HANGUL SYLLABLE-C55A
        0xC55B, # G+14457  U+C55B  uniC55B,  HANGUL SYLLABLE-C55B
        0xC55C, # G+14458  U+C55C  uniC55C,  HANGUL SYLLABLE-C55C
        0xC55F, # G+14459  U+C55F  uniC55F,  HANGUL SYLLABLE-C55F
        0xC562, # G+14460  U+C562  uniC562,  HANGUL SYLLABLE-C562
        0xC563, # G+14461  U+C563  uniC563,  HANGUL SYLLABLE-C563
        0xC565, # G+14462  U+C565  uniC565,  HANGUL SYLLABLE-C565
        0xC566, # G+14463  U+C566  uniC566,  HANGUL SYLLABLE-C566
        0xC567, # G+14464  U+C567  uniC567,  HANGUL SYLLABLE-C567
        0xC569, # G+14465  U+C569  uniC569,  HANGUL SYLLABLE-C569
        0xC56A, # G+14466  U+C56A  uniC56A,  HANGUL SYLLABLE-C56A
        0xC56B, # G+14467  U+C56B  uniC56B,  HANGUL SYLLABLE-C56B
        0xC56C, # G+14468  U+C56C  uniC56C,  HANGUL SYLLABLE-C56C
        0xC56D, # G+14469  U+C56D  uniC56D,  HANGUL SYLLABLE-C56D
        0xC56E, # G+14470  U+C56E  uniC56E,  HANGUL SYLLABLE-C56E
        0xC56F, # G+14471  U+C56F  uniC56F,  HANGUL SYLLABLE-C56F
        0xC572, # G+14472  U+C572  uniC572,  HANGUL SYLLABLE-C572
        0xC576, # G+14473  U+C576  uniC576,  HANGUL SYLLABLE-C576
        0xC577, # G+14474  U+C577  uniC577,  HANGUL SYLLABLE-C577
        0xC578, # G+14475  U+C578  uniC578,  HANGUL SYLLABLE-C578
        0xC579, # G+14476  U+C579  uniC579,  HANGUL SYLLABLE-C579
        0xC57A, # G+14477  U+C57A  uniC57A,  HANGUL SYLLABLE-C57A
        0xC57B, # G+14478  U+C57B  uniC57B,  HANGUL SYLLABLE-C57B
        0xC57E, # G+14479  U+C57E  uniC57E,  HANGUL SYLLABLE-C57E
        0xC57F, # G+14480  U+C57F  uniC57F,  HANGUL SYLLABLE-C57F
        0xC581, # G+14481  U+C581  uniC581,  HANGUL SYLLABLE-C581
        0xC582, # G+14482  U+C582  uniC582,  HANGUL SYLLABLE-C582
        0xC583, # G+14483  U+C583  uniC583,  HANGUL SYLLABLE-C583
        0xC585, # G+14484  U+C585  uniC585,  HANGUL SYLLABLE-C585
        0xC586, # G+14485  U+C586  uniC586,  HANGUL SYLLABLE-C586
        0xC588, # G+14486  U+C588  uniC588,  HANGUL SYLLABLE-C588
        0xC589, # G+14487  U+C589  uniC589,  HANGUL SYLLABLE-C589
        0xC58A, # G+14488  U+C58A  uniC58A,  HANGUL SYLLABLE-C58A
        0xC58B, # G+14489  U+C58B  uniC58B,  HANGUL SYLLABLE-C58B
        0xC58E, # G+14490  U+C58E  uniC58E,  HANGUL SYLLABLE-C58E
        0xC590, # G+14491  U+C590  uniC590,  HANGUL SYLLABLE-C590
        0xC592, # G+14492  U+C592  uniC592,  HANGUL SYLLABLE-C592
        0xC593, # G+14493  U+C593  uniC593,  HANGUL SYLLABLE-C593
        0xC594, # G+14494  U+C594  uniC594,  HANGUL SYLLABLE-C594
        0xC596, # G+14495  U+C596  uniC596,  HANGUL SYLLABLE-C596
        0xC599, # G+14496  U+C599  uniC599,  HANGUL SYLLABLE-C599
        0xC59A, # G+14497  U+C59A  uniC59A,  HANGUL SYLLABLE-C59A
        0xC59B, # G+14498  U+C59B  uniC59B,  HANGUL SYLLABLE-C59B
        0xC59D, # G+14499  U+C59D  uniC59D,  HANGUL SYLLABLE-C59D
        0xC59E, # G+14500  U+C59E  uniC59E,  HANGUL SYLLABLE-C59E
        0xC59F, # G+14501  U+C59F  uniC59F,  HANGUL SYLLABLE-C59F
        0xC5A1, # G+14502  U+C5A1  uniC5A1,  HANGUL SYLLABLE-C5A1
        0xC5A2, # G+14503  U+C5A2  uniC5A2,  HANGUL SYLLABLE-C5A2
        0xC5A3, # G+14504  U+C5A3  uniC5A3,  HANGUL SYLLABLE-C5A3
        0xC5A4, # G+14505  U+C5A4  uniC5A4,  HANGUL SYLLABLE-C5A4
        0xC5A5, # G+14506  U+C5A5  uniC5A5,  HANGUL SYLLABLE-C5A5
        0xC5A6, # G+14507  U+C5A6  uniC5A6,  HANGUL SYLLABLE-C5A6
        0xC5A7, # G+14508  U+C5A7  uniC5A7,  HANGUL SYLLABLE-C5A7
        0xC5A8, # G+14509  U+C5A8  uniC5A8,  HANGUL SYLLABLE-C5A8
        0xC5AA, # G+14510  U+C5AA  uniC5AA,  HANGUL SYLLABLE-C5AA
        0xC5AB, # G+14511  U+C5AB  uniC5AB,  HANGUL SYLLABLE-C5AB
        0xC5AC, # G+14512  U+C5AC  uniC5AC,  HANGUL SYLLABLE-C5AC
        0xC5AD, # G+14513  U+C5AD  uniC5AD,  HANGUL SYLLABLE-C5AD
        0xC5AE, # G+14514  U+C5AE  uniC5AE,  HANGUL SYLLABLE-C5AE
        0xC5AF, # G+14515  U+C5AF  uniC5AF,  HANGUL SYLLABLE-C5AF
        0xC5B0, # G+14516  U+C5B0  uniC5B0,  HANGUL SYLLABLE-C5B0
        0xC5B1, # G+14517  U+C5B1  uniC5B1,  HANGUL SYLLABLE-C5B1
        0xC5B2, # G+14518  U+C5B2  uniC5B2,  HANGUL SYLLABLE-C5B2
        0xC5B3, # G+14519  U+C5B3  uniC5B3,  HANGUL SYLLABLE-C5B3
        0xC5B6, # G+14520  U+C5B6  uniC5B6,  HANGUL SYLLABLE-C5B6
        0xC5B7, # G+14521  U+C5B7  uniC5B7,  HANGUL SYLLABLE-C5B7
        0xC5BA, # G+14522  U+C5BA  uniC5BA,  HANGUL SYLLABLE-C5BA
        0xC5BF, # G+14523  U+C5BF  uniC5BF,  HANGUL SYLLABLE-C5BF
        0xC5C0, # G+14524  U+C5C0  uniC5C0,  HANGUL SYLLABLE-C5C0
        0xC5C1, # G+14525  U+C5C1  uniC5C1,  HANGUL SYLLABLE-C5C1
        0xC5C2, # G+14526  U+C5C2  uniC5C2,  HANGUL SYLLABLE-C5C2
        0xC5C3, # G+14527  U+C5C3  uniC5C3,  HANGUL SYLLABLE-C5C3
        0xC5CB, # G+14528  U+C5CB  uniC5CB,  HANGUL SYLLABLE-C5CB
        0xC5CD, # G+14529  U+C5CD  uniC5CD,  HANGUL SYLLABLE-C5CD
        0xC5CF, # G+14530  U+C5CF  uniC5CF,  HANGUL SYLLABLE-C5CF
        0xC5D2, # G+14531  U+C5D2  uniC5D2,  HANGUL SYLLABLE-C5D2
        0xC5D3, # G+14532  U+C5D3  uniC5D3,  HANGUL SYLLABLE-C5D3
        0xC5D5, # G+14533  U+C5D5  uniC5D5,  HANGUL SYLLABLE-C5D5
        0xC5D6, # G+14534  U+C5D6  uniC5D6,  HANGUL SYLLABLE-C5D6
        0xC5D7, # G+14535  U+C5D7  uniC5D7,  HANGUL SYLLABLE-C5D7
        0xC5D9, # G+14536  U+C5D9  uniC5D9,  HANGUL SYLLABLE-C5D9
        0xC5DA, # G+14537  U+C5DA  uniC5DA,  HANGUL SYLLABLE-C5DA
        0xC5DB, # G+14538  U+C5DB  uniC5DB,  HANGUL SYLLABLE-C5DB
        0xC5DC, # G+14539  U+C5DC  uniC5DC,  HANGUL SYLLABLE-C5DC
        0xC5DD, # G+14540  U+C5DD  uniC5DD,  HANGUL SYLLABLE-C5DD
        0xC5DE, # G+14541  U+C5DE  uniC5DE,  HANGUL SYLLABLE-C5DE
        0xC5DF, # G+14542  U+C5DF  uniC5DF,  HANGUL SYLLABLE-C5DF
        0xC5E2, # G+14543  U+C5E2  uniC5E2,  HANGUL SYLLABLE-C5E2
        0xC5E4, # G+14544  U+C5E4  uniC5E4,  HANGUL SYLLABLE-C5E4
        0xC5E6, # G+14545  U+C5E6  uniC5E6,  HANGUL SYLLABLE-C5E6
        0xC5E7, # G+14546  U+C5E7  uniC5E7,  HANGUL SYLLABLE-C5E7
        0xC5E8, # G+14547  U+C5E8  uniC5E8,  HANGUL SYLLABLE-C5E8
        0xC5E9, # G+14548  U+C5E9  uniC5E9,  HANGUL SYLLABLE-C5E9
        0xC5EA, # G+14549  U+C5EA  uniC5EA,  HANGUL SYLLABLE-C5EA
        0xC5EB, # G+14550  U+C5EB  uniC5EB,  HANGUL SYLLABLE-C5EB
        0xC5EF, # G+14551  U+C5EF  uniC5EF,  HANGUL SYLLABLE-C5EF
        0xC5F1, # G+14552  U+C5F1  uniC5F1,  HANGUL SYLLABLE-C5F1
        0xC5F2, # G+14553  U+C5F2  uniC5F2,  HANGUL SYLLABLE-C5F2
        0xC5F3, # G+14554  U+C5F3  uniC5F3,  HANGUL SYLLABLE-C5F3
        0xC5F5, # G+14555  U+C5F5  uniC5F5,  HANGUL SYLLABLE-C5F5
        0xC5F8, # G+14556  U+C5F8  uniC5F8,  HANGUL SYLLABLE-C5F8
        0xC5F9, # G+14557  U+C5F9  uniC5F9,  HANGUL SYLLABLE-C5F9
        0xC5FA, # G+14558  U+C5FA  uniC5FA,  HANGUL SYLLABLE-C5FA
        0xC5FB, # G+14559  U+C5FB  uniC5FB,  HANGUL SYLLABLE-C5FB
        0xC602, # G+14560  U+C602  uniC602,  HANGUL SYLLABLE-C602
        0xC603, # G+14561  U+C603  uniC603,  HANGUL SYLLABLE-C603
        0xC604, # G+14562  U+C604  uniC604,  HANGUL SYLLABLE-C604
        0xC609, # G+14563  U+C609  uniC609,  HANGUL SYLLABLE-C609
        0xC60A, # G+14564  U+C60A  uniC60A,  HANGUL SYLLABLE-C60A
        0xC60B, # G+14565  U+C60B  uniC60B,  HANGUL SYLLABLE-C60B
        0xC60D, # G+14566  U+C60D  uniC60D,  HANGUL SYLLABLE-C60D
        0xC60E, # G+14567  U+C60E  uniC60E,  HANGUL SYLLABLE-C60E
        0xC60F, # G+14568  U+C60F  uniC60F,  HANGUL SYLLABLE-C60F
        0xC611, # G+14569  U+C611  uniC611,  HANGUL SYLLABLE-C611
        0xC612, # G+14570  U+C612  uniC612,  HANGUL SYLLABLE-C612
        0xC613, # G+14571  U+C613  uniC613,  HANGUL SYLLABLE-C613
        0xC614, # G+14572  U+C614  uniC614,  HANGUL SYLLABLE-C614
        0xC615, # G+14573  U+C615  uniC615,  HANGUL SYLLABLE-C615
        0xC616, # G+14574  U+C616  uniC616,  HANGUL SYLLABLE-C616
        0xC617, # G+14575  U+C617  uniC617,  HANGUL SYLLABLE-C617
        0xC61A, # G+14576  U+C61A  uniC61A,  HANGUL SYLLABLE-C61A
        0xC61D, # G+14577  U+C61D  uniC61D,  HANGUL SYLLABLE-C61D
        0xC61E, # G+14578  U+C61E  uniC61E,  HANGUL SYLLABLE-C61E
        0xC61F, # G+14579  U+C61F  uniC61F,  HANGUL SYLLABLE-C61F
        0xC620, # G+14580  U+C620  uniC620,  HANGUL SYLLABLE-C620
        0xC621, # G+14581  U+C621  uniC621,  HANGUL SYLLABLE-C621
        0xC622, # G+14582  U+C622  uniC622,  HANGUL SYLLABLE-C622
        0xC623, # G+14583  U+C623  uniC623,  HANGUL SYLLABLE-C623
        0xC626, # G+14584  U+C626  uniC626,  HANGUL SYLLABLE-C626
        0xC627, # G+14585  U+C627  uniC627,  HANGUL SYLLABLE-C627
        0xC629, # G+14586  U+C629  uniC629,  HANGUL SYLLABLE-C629
        0xC62A, # G+14587  U+C62A  uniC62A,  HANGUL SYLLABLE-C62A
        0xC62B, # G+14588  U+C62B  uniC62B,  HANGUL SYLLABLE-C62B
        0xC62F, # G+14589  U+C62F  uniC62F,  HANGUL SYLLABLE-C62F
        0xC631, # G+14590  U+C631  uniC631,  HANGUL SYLLABLE-C631
        0xC632, # G+14591  U+C632  uniC632,  HANGUL SYLLABLE-C632
        0xC636, # G+14592  U+C636  uniC636,  HANGUL SYLLABLE-C636
        0xC638, # G+14593  U+C638  uniC638,  HANGUL SYLLABLE-C638
        0xC63A, # G+14594  U+C63A  uniC63A,  HANGUL SYLLABLE-C63A
        0xC63C, # G+14595  U+C63C  uniC63C,  HANGUL SYLLABLE-C63C
        0xC63D, # G+14596  U+C63D  uniC63D,  HANGUL SYLLABLE-C63D
        0xC63E, # G+14597  U+C63E  uniC63E,  HANGUL SYLLABLE-C63E
        0xC63F, # G+14598  U+C63F  uniC63F,  HANGUL SYLLABLE-C63F
        0xC642, # G+14599  U+C642  uniC642,  HANGUL SYLLABLE-C642
        0xC643, # G+14600  U+C643  uniC643,  HANGUL SYLLABLE-C643
        0xC645, # G+14601  U+C645  uniC645,  HANGUL SYLLABLE-C645
        0xC646, # G+14602  U+C646  uniC646,  HANGUL SYLLABLE-C646
        0xC647, # G+14603  U+C647  uniC647,  HANGUL SYLLABLE-C647
        0xC649, # G+14604  U+C649  uniC649,  HANGUL SYLLABLE-C649
        0xC64A, # G+14605  U+C64A  uniC64A,  HANGUL SYLLABLE-C64A
        0xC64B, # G+14606  U+C64B  uniC64B,  HANGUL SYLLABLE-C64B
        0xC64C, # G+14607  U+C64C  uniC64C,  HANGUL SYLLABLE-C64C
        0xC64D, # G+14608  U+C64D  uniC64D,  HANGUL SYLLABLE-C64D
        0xC64E, # G+14609  U+C64E  uniC64E,  HANGUL SYLLABLE-C64E
        0xC64F, # G+14610  U+C64F  uniC64F,  HANGUL SYLLABLE-C64F
        0xC652, # G+14611  U+C652  uniC652,  HANGUL SYLLABLE-C652
        0xC656, # G+14612  U+C656  uniC656,  HANGUL SYLLABLE-C656
        0xC657, # G+14613  U+C657  uniC657,  HANGUL SYLLABLE-C657
        0xC658, # G+14614  U+C658  uniC658,  HANGUL SYLLABLE-C658
        0xC659, # G+14615  U+C659  uniC659,  HANGUL SYLLABLE-C659
        0xC65A, # G+14616  U+C65A  uniC65A,  HANGUL SYLLABLE-C65A
        0xC65B, # G+14617  U+C65B  uniC65B,  HANGUL SYLLABLE-C65B
        0xC65E, # G+14618  U+C65E  uniC65E,  HANGUL SYLLABLE-C65E
        0xC65F, # G+14619  U+C65F  uniC65F,  HANGUL SYLLABLE-C65F
        0xC661, # G+14620  U+C661  uniC661,  HANGUL SYLLABLE-C661
        0xC662, # G+14621  U+C662  uniC662,  HANGUL SYLLABLE-C662
        0xC663, # G+14622  U+C663  uniC663,  HANGUL SYLLABLE-C663
        0xC664, # G+14623  U+C664  uniC664,  HANGUL SYLLABLE-C664
        0xC665, # G+14624  U+C665  uniC665,  HANGUL SYLLABLE-C665
        0xC666, # G+14625  U+C666  uniC666,  HANGUL SYLLABLE-C666
        0xC667, # G+14626  U+C667  uniC667,  HANGUL SYLLABLE-C667
        0xC668, # G+14627  U+C668  uniC668,  HANGUL SYLLABLE-C668
        0xC669, # G+14628  U+C669  uniC669,  HANGUL SYLLABLE-C669
        0xC66A, # G+14629  U+C66A  uniC66A,  HANGUL SYLLABLE-C66A
        0xC66B, # G+14630  U+C66B  uniC66B,  HANGUL SYLLABLE-C66B
        0xC66D, # G+14631  U+C66D  uniC66D,  HANGUL SYLLABLE-C66D
        0xC66E, # G+14632  U+C66E  uniC66E,  HANGUL SYLLABLE-C66E
        0xC670, # G+14633  U+C670  uniC670,  HANGUL SYLLABLE-C670
        0xC672, # G+14634  U+C672  uniC672,  HANGUL SYLLABLE-C672
        0xC673, # G+14635  U+C673  uniC673,  HANGUL SYLLABLE-C673
        0xC674, # G+14636  U+C674  uniC674,  HANGUL SYLLABLE-C674
        0xC675, # G+14637  U+C675  uniC675,  HANGUL SYLLABLE-C675
        0xC676, # G+14638  U+C676  uniC676,  HANGUL SYLLABLE-C676
        0xC677, # G+14639  U+C677  uniC677,  HANGUL SYLLABLE-C677
        0xC67A, # G+14640  U+C67A  uniC67A,  HANGUL SYLLABLE-C67A
        0xC67B, # G+14641  U+C67B  uniC67B,  HANGUL SYLLABLE-C67B
        0xC67D, # G+14642  U+C67D  uniC67D,  HANGUL SYLLABLE-C67D
        0xC67E, # G+14643  U+C67E  uniC67E,  HANGUL SYLLABLE-C67E
        0xC67F, # G+14644  U+C67F  uniC67F,  HANGUL SYLLABLE-C67F
        0xC681, # G+14645  U+C681  uniC681,  HANGUL SYLLABLE-C681
        0xC682, # G+14646  U+C682  uniC682,  HANGUL SYLLABLE-C682
        0xC683, # G+14647  U+C683  uniC683,  HANGUL SYLLABLE-C683
        0xC684, # G+14648  U+C684  uniC684,  HANGUL SYLLABLE-C684
        0xC685, # G+14649  U+C685  uniC685,  HANGUL SYLLABLE-C685
        0xC686, # G+14650  U+C686  uniC686,  HANGUL SYLLABLE-C686
        0xC687, # G+14651  U+C687  uniC687,  HANGUL SYLLABLE-C687
        0xC68A, # G+14652  U+C68A  uniC68A,  HANGUL SYLLABLE-C68A
        0xC68C, # G+14653  U+C68C  uniC68C,  HANGUL SYLLABLE-C68C
        0xC68E, # G+14654  U+C68E  uniC68E,  HANGUL SYLLABLE-C68E
        0xC68F, # G+14655  U+C68F  uniC68F,  HANGUL SYLLABLE-C68F
        0xC690, # G+14656  U+C690  uniC690,  HANGUL SYLLABLE-C690
        0xC691, # G+14657  U+C691  uniC691,  HANGUL SYLLABLE-C691
        0xC692, # G+14658  U+C692  uniC692,  HANGUL SYLLABLE-C692
        0xC693, # G+14659  U+C693  uniC693,  HANGUL SYLLABLE-C693
        0xC696, # G+14660  U+C696  uniC696,  HANGUL SYLLABLE-C696
        0xC697, # G+14661  U+C697  uniC697,  HANGUL SYLLABLE-C697
        0xC699, # G+14662  U+C699  uniC699,  HANGUL SYLLABLE-C699
        0xC69A, # G+14663  U+C69A  uniC69A,  HANGUL SYLLABLE-C69A
        0xC69B, # G+14664  U+C69B  uniC69B,  HANGUL SYLLABLE-C69B
        0xC69D, # G+14665  U+C69D  uniC69D,  HANGUL SYLLABLE-C69D
        0xC69E, # G+14666  U+C69E  uniC69E,  HANGUL SYLLABLE-C69E
        0xC69F, # G+14667  U+C69F  uniC69F,  HANGUL SYLLABLE-C69F
        0xC6A0, # G+14668  U+C6A0  uniC6A0,  HANGUL SYLLABLE-C6A0
        0xC6A1, # G+14669  U+C6A1  uniC6A1,  HANGUL SYLLABLE-C6A1
        0xC6A2, # G+14670  U+C6A2  uniC6A2,  HANGUL SYLLABLE-C6A2
        0xC6A3, # G+14671  U+C6A3  uniC6A3,  HANGUL SYLLABLE-C6A3
        0xC6A6, # G+14672  U+C6A6  uniC6A6,  HANGUL SYLLABLE-C6A6
        0xC6A8, # G+14673  U+C6A8  uniC6A8,  HANGUL SYLLABLE-C6A8
        0xC6AA, # G+14674  U+C6AA  uniC6AA,  HANGUL SYLLABLE-C6AA
        0xC6AB, # G+14675  U+C6AB  uniC6AB,  HANGUL SYLLABLE-C6AB
        0xC6AC, # G+14676  U+C6AC  uniC6AC,  HANGUL SYLLABLE-C6AC
        0xC6AD, # G+14677  U+C6AD  uniC6AD,  HANGUL SYLLABLE-C6AD
        0xC6AE, # G+14678  U+C6AE  uniC6AE,  HANGUL SYLLABLE-C6AE
        0xC6AF, # G+14679  U+C6AF  uniC6AF,  HANGUL SYLLABLE-C6AF
        0xC6B2, # G+14680  U+C6B2  uniC6B2,  HANGUL SYLLABLE-C6B2
        0xC6B3, # G+14681  U+C6B3  uniC6B3,  HANGUL SYLLABLE-C6B3
        0xC6B5, # G+14682  U+C6B5  uniC6B5,  HANGUL SYLLABLE-C6B5
        0xC6B6, # G+14683  U+C6B6  uniC6B6,  HANGUL SYLLABLE-C6B6
        0xC6B7, # G+14684  U+C6B7  uniC6B7,  HANGUL SYLLABLE-C6B7
        0xC6BB, # G+14685  U+C6BB  uniC6BB,  HANGUL SYLLABLE-C6BB
        0xC6BC, # G+14686  U+C6BC  uniC6BC,  HANGUL SYLLABLE-C6BC
        0xC6BD, # G+14687  U+C6BD  uniC6BD,  HANGUL SYLLABLE-C6BD
        0xC6BE, # G+14688  U+C6BE  uniC6BE,  HANGUL SYLLABLE-C6BE
        0xC6BF, # G+14689  U+C6BF  uniC6BF,  HANGUL SYLLABLE-C6BF
        0xC6C2, # G+14690  U+C6C2  uniC6C2,  HANGUL SYLLABLE-C6C2
        0xC6C4, # G+14691  U+C6C4  uniC6C4,  HANGUL SYLLABLE-C6C4
        0xC6C6, # G+14692  U+C6C6  uniC6C6,  HANGUL SYLLABLE-C6C6
        0xC6C7, # G+14693  U+C6C7  uniC6C7,  HANGUL SYLLABLE-C6C7
        0xC6C8, # G+14694  U+C6C8  uniC6C8,  HANGUL SYLLABLE-C6C8
        0xC6C9, # G+14695  U+C6C9  uniC6C9,  HANGUL SYLLABLE-C6C9
        0xC6CA, # G+14696  U+C6CA  uniC6CA,  HANGUL SYLLABLE-C6CA
        0xC6CB, # G+14697  U+C6CB  uniC6CB,  HANGUL SYLLABLE-C6CB
        0xC6CE, # G+14698  U+C6CE  uniC6CE,  HANGUL SYLLABLE-C6CE
        0xC6CF, # G+14699  U+C6CF  uniC6CF,  HANGUL SYLLABLE-C6CF
        0xC6D1, # G+14700  U+C6D1  uniC6D1,  HANGUL SYLLABLE-C6D1
        0xC6D2, # G+14701  U+C6D2  uniC6D2,  HANGUL SYLLABLE-C6D2
        0xC6D3, # G+14702  U+C6D3  uniC6D3,  HANGUL SYLLABLE-C6D3
        0xC6D5, # G+14703  U+C6D5  uniC6D5,  HANGUL SYLLABLE-C6D5
        0xC6D6, # G+14704  U+C6D6  uniC6D6,  HANGUL SYLLABLE-C6D6
        0xC6D7, # G+14705  U+C6D7  uniC6D7,  HANGUL SYLLABLE-C6D7
        0xC6D8, # G+14706  U+C6D8  uniC6D8,  HANGUL SYLLABLE-C6D8
        0xC6D9, # G+14707  U+C6D9  uniC6D9,  HANGUL SYLLABLE-C6D9
        0xC6DA, # G+14708  U+C6DA  uniC6DA,  HANGUL SYLLABLE-C6DA
        0xC6DB, # G+14709  U+C6DB  uniC6DB,  HANGUL SYLLABLE-C6DB
        0xC6DE, # G+14710  U+C6DE  uniC6DE,  HANGUL SYLLABLE-C6DE
        0xC6DF, # G+14711  U+C6DF  uniC6DF,  HANGUL SYLLABLE-C6DF
        0xC6E2, # G+14712  U+C6E2  uniC6E2,  HANGUL SYLLABLE-C6E2
        0xC6E3, # G+14713  U+C6E3  uniC6E3,  HANGUL SYLLABLE-C6E3
        0xC6E4, # G+14714  U+C6E4  uniC6E4,  HANGUL SYLLABLE-C6E4
        0xC6E5, # G+14715  U+C6E5  uniC6E5,  HANGUL SYLLABLE-C6E5
        0xC6E6, # G+14716  U+C6E6  uniC6E6,  HANGUL SYLLABLE-C6E6
        0xC6E7, # G+14717  U+C6E7  uniC6E7,  HANGUL SYLLABLE-C6E7
        0xC6EA, # G+14718  U+C6EA  uniC6EA,  HANGUL SYLLABLE-C6EA
        0xC6EB, # G+14719  U+C6EB  uniC6EB,  HANGUL SYLLABLE-C6EB
        0xC6ED, # G+14720  U+C6ED  uniC6ED,  HANGUL SYLLABLE-C6ED
        0xC6EE, # G+14721  U+C6EE  uniC6EE,  HANGUL SYLLABLE-C6EE
        0xC6EF, # G+14722  U+C6EF  uniC6EF,  HANGUL SYLLABLE-C6EF
        0xC6F1, # G+14723  U+C6F1  uniC6F1,  HANGUL SYLLABLE-C6F1
        0xC6F2, # G+14724  U+C6F2  uniC6F2,  HANGUL SYLLABLE-C6F2
        0xC6F3, # G+14725  U+C6F3  uniC6F3,  HANGUL SYLLABLE-C6F3
        0xC6F4, # G+14726  U+C6F4  uniC6F4,  HANGUL SYLLABLE-C6F4
        0xC6F5, # G+14727  U+C6F5  uniC6F5,  HANGUL SYLLABLE-C6F5
        0xC6F6, # G+14728  U+C6F6  uniC6F6,  HANGUL SYLLABLE-C6F6
        0xC6F7, # G+14729  U+C6F7  uniC6F7,  HANGUL SYLLABLE-C6F7
        0xC6FA, # G+14730  U+C6FA  uniC6FA,  HANGUL SYLLABLE-C6FA
        0xC6FB, # G+14731  U+C6FB  uniC6FB,  HANGUL SYLLABLE-C6FB
        0xC6FC, # G+14732  U+C6FC  uniC6FC,  HANGUL SYLLABLE-C6FC
        0xC6FE, # G+14733  U+C6FE  uniC6FE,  HANGUL SYLLABLE-C6FE
        0xC6FF, # G+14734  U+C6FF  uniC6FF,  HANGUL SYLLABLE-C6FF
        0xC700, # G+14735  U+C700  uniC700,  HANGUL SYLLABLE-C700
        0xC701, # G+14736  U+C701  uniC701,  HANGUL SYLLABLE-C701
        0xC702, # G+14737  U+C702  uniC702,  HANGUL SYLLABLE-C702
        0xC703, # G+14738  U+C703  uniC703,  HANGUL SYLLABLE-C703
        0xC706, # G+14739  U+C706  uniC706,  HANGUL SYLLABLE-C706
        0xC707, # G+14740  U+C707  uniC707,  HANGUL SYLLABLE-C707
        0xC709, # G+14741  U+C709  uniC709,  HANGUL SYLLABLE-C709
        0xC70A, # G+14742  U+C70A  uniC70A,  HANGUL SYLLABLE-C70A
        0xC70B, # G+14743  U+C70B  uniC70B,  HANGUL SYLLABLE-C70B
        0xC70D, # G+14744  U+C70D  uniC70D,  HANGUL SYLLABLE-C70D
        0xC70E, # G+14745  U+C70E  uniC70E,  HANGUL SYLLABLE-C70E
        0xC70F, # G+14746  U+C70F  uniC70F,  HANGUL SYLLABLE-C70F
        0xC710, # G+14747  U+C710  uniC710,  HANGUL SYLLABLE-C710
        0xC711, # G+14748  U+C711  uniC711,  HANGUL SYLLABLE-C711
        0xC712, # G+14749  U+C712  uniC712,  HANGUL SYLLABLE-C712
        0xC713, # G+14750  U+C713  uniC713,  HANGUL SYLLABLE-C713
        0xC716, # G+14751  U+C716  uniC716,  HANGUL SYLLABLE-C716
        0xC718, # G+14752  U+C718  uniC718,  HANGUL SYLLABLE-C718
        0xC71A, # G+14753  U+C71A  uniC71A,  HANGUL SYLLABLE-C71A
        0xC71B, # G+14754  U+C71B  uniC71B,  HANGUL SYLLABLE-C71B
        0xC71C, # G+14755  U+C71C  uniC71C,  HANGUL SYLLABLE-C71C
        0xC71D, # G+14756  U+C71D  uniC71D,  HANGUL SYLLABLE-C71D
        0xC71E, # G+14757  U+C71E  uniC71E,  HANGUL SYLLABLE-C71E
        0xC71F, # G+14758  U+C71F  uniC71F,  HANGUL SYLLABLE-C71F
        0xC722, # G+14759  U+C722  uniC722,  HANGUL SYLLABLE-C722
        0xC723, # G+14760  U+C723  uniC723,  HANGUL SYLLABLE-C723
        0xC725, # G+14761  U+C725  uniC725,  HANGUL SYLLABLE-C725
        0xC726, # G+14762  U+C726  uniC726,  HANGUL SYLLABLE-C726
        0xC727, # G+14763  U+C727  uniC727,  HANGUL SYLLABLE-C727
        0xC729, # G+14764  U+C729  uniC729,  HANGUL SYLLABLE-C729
        0xC72A, # G+14765  U+C72A  uniC72A,  HANGUL SYLLABLE-C72A
        0xC72B, # G+14766  U+C72B  uniC72B,  HANGUL SYLLABLE-C72B
        0xC72C, # G+14767  U+C72C  uniC72C,  HANGUL SYLLABLE-C72C
        0xC72D, # G+14768  U+C72D  uniC72D,  HANGUL SYLLABLE-C72D
        0xC72E, # G+14769  U+C72E  uniC72E,  HANGUL SYLLABLE-C72E
        0xC72F, # G+14770  U+C72F  uniC72F,  HANGUL SYLLABLE-C72F
        0xC732, # G+14771  U+C732  uniC732,  HANGUL SYLLABLE-C732
        0xC734, # G+14772  U+C734  uniC734,  HANGUL SYLLABLE-C734
        0xC736, # G+14773  U+C736  uniC736,  HANGUL SYLLABLE-C736
        0xC738, # G+14774  U+C738  uniC738,  HANGUL SYLLABLE-C738
        0xC739, # G+14775  U+C739  uniC739,  HANGUL SYLLABLE-C739
        0xC73A, # G+14776  U+C73A  uniC73A,  HANGUL SYLLABLE-C73A
        0xC73B, # G+14777  U+C73B  uniC73B,  HANGUL SYLLABLE-C73B
        0xC73E, # G+14778  U+C73E  uniC73E,  HANGUL SYLLABLE-C73E
        0xC73F, # G+14779  U+C73F  uniC73F,  HANGUL SYLLABLE-C73F
        0xC741, # G+14780  U+C741  uniC741,  HANGUL SYLLABLE-C741
        0xC742, # G+14781  U+C742  uniC742,  HANGUL SYLLABLE-C742
        0xC743, # G+14782  U+C743  uniC743,  HANGUL SYLLABLE-C743
        0xC745, # G+14783  U+C745  uniC745,  HANGUL SYLLABLE-C745
        0xC746, # G+14784  U+C746  uniC746,  HANGUL SYLLABLE-C746
        0xC747, # G+14785  U+C747  uniC747,  HANGUL SYLLABLE-C747
        0xC748, # G+14786  U+C748  uniC748,  HANGUL SYLLABLE-C748
        0xC749, # G+14787  U+C749  uniC749,  HANGUL SYLLABLE-C749
        0xC74B, # G+14788  U+C74B  uniC74B,  HANGUL SYLLABLE-C74B
        0xC74E, # G+14789  U+C74E  uniC74E,  HANGUL SYLLABLE-C74E
        0xC750, # G+14790  U+C750  uniC750,  HANGUL SYLLABLE-C750
        0xC759, # G+14791  U+C759  uniC759,  HANGUL SYLLABLE-C759
        0xC75A, # G+14792  U+C75A  uniC75A,  HANGUL SYLLABLE-C75A
        0xC75B, # G+14793  U+C75B  uniC75B,  HANGUL SYLLABLE-C75B
        0xC75D, # G+14794  U+C75D  uniC75D,  HANGUL SYLLABLE-C75D
        0xC75E, # G+14795  U+C75E  uniC75E,  HANGUL SYLLABLE-C75E
        0xC75F, # G+14796  U+C75F  uniC75F,  HANGUL SYLLABLE-C75F
        0xC761, # G+14797  U+C761  uniC761,  HANGUL SYLLABLE-C761
        0xC762, # G+14798  U+C762  uniC762,  HANGUL SYLLABLE-C762
        0xC763, # G+14799  U+C763  uniC763,  HANGUL SYLLABLE-C763
        0xC764, # G+14800  U+C764  uniC764,  HANGUL SYLLABLE-C764
        0xC765, # G+14801  U+C765  uniC765,  HANGUL SYLLABLE-C765
        0xC766, # G+14802  U+C766  uniC766,  HANGUL SYLLABLE-C766
        0xC767, # G+14803  U+C767  uniC767,  HANGUL SYLLABLE-C767
        0xC769, # G+14804  U+C769  uniC769,  HANGUL SYLLABLE-C769
        0xC76A, # G+14805  U+C76A  uniC76A,  HANGUL SYLLABLE-C76A
        0xC76C, # G+14806  U+C76C  uniC76C,  HANGUL SYLLABLE-C76C
        0xC76D, # G+14807  U+C76D  uniC76D,  HANGUL SYLLABLE-C76D
        0xC76E, # G+14808  U+C76E  uniC76E,  HANGUL SYLLABLE-C76E
        0xC76F, # G+14809  U+C76F  uniC76F,  HANGUL SYLLABLE-C76F
        0xC770, # G+14810  U+C770  uniC770,  HANGUL SYLLABLE-C770
        0xC771, # G+14811  U+C771  uniC771,  HANGUL SYLLABLE-C771
        0xC772, # G+14812  U+C772  uniC772,  HANGUL SYLLABLE-C772
        0xC773, # G+14813  U+C773  uniC773,  HANGUL SYLLABLE-C773
        0xC776, # G+14814  U+C776  uniC776,  HANGUL SYLLABLE-C776
        0xC777, # G+14815  U+C777  uniC777,  HANGUL SYLLABLE-C777
        0xC779, # G+14816  U+C779  uniC779,  HANGUL SYLLABLE-C779
        0xC77A, # G+14817  U+C77A  uniC77A,  HANGUL SYLLABLE-C77A
        0xC77B, # G+14818  U+C77B  uniC77B,  HANGUL SYLLABLE-C77B
        0xC77F, # G+14819  U+C77F  uniC77F,  HANGUL SYLLABLE-C77F
        0xC780, # G+14820  U+C780  uniC780,  HANGUL SYLLABLE-C780
        0xC781, # G+14821  U+C781  uniC781,  HANGUL SYLLABLE-C781
        0xC782, # G+14822  U+C782  uniC782,  HANGUL SYLLABLE-C782
        0xC786, # G+14823  U+C786  uniC786,  HANGUL SYLLABLE-C786
        0xC78B, # G+14824  U+C78B  uniC78B,  HANGUL SYLLABLE-C78B
        0xC78C, # G+14825  U+C78C  uniC78C,  HANGUL SYLLABLE-C78C
        0xC78D, # G+14826  U+C78D  uniC78D,  HANGUL SYLLABLE-C78D
        0xC78F, # G+14827  U+C78F  uniC78F,  HANGUL SYLLABLE-C78F
        0xC792, # G+14828  U+C792  uniC792,  HANGUL SYLLABLE-C792
        0xC793, # G+14829  U+C793  uniC793,  HANGUL SYLLABLE-C793
        0xC795, # G+14830  U+C795  uniC795,  HANGUL SYLLABLE-C795
        0xC799, # G+14831  U+C799  uniC799,  HANGUL SYLLABLE-C799
        0xC79B, # G+14832  U+C79B  uniC79B,  HANGUL SYLLABLE-C79B
        0xC79C, # G+14833  U+C79C  uniC79C,  HANGUL SYLLABLE-C79C
        0xC79D, # G+14834  U+C79D  uniC79D,  HANGUL SYLLABLE-C79D
        0xC79E, # G+14835  U+C79E  uniC79E,  HANGUL SYLLABLE-C79E
        0xC79F, # G+14836  U+C79F  uniC79F,  HANGUL SYLLABLE-C79F
        0xC7A2, # G+14837  U+C7A2  uniC7A2,  HANGUL SYLLABLE-C7A2
        0xC7A7, # G+14838  U+C7A7  uniC7A7,  HANGUL SYLLABLE-C7A7
        0xC7A8, # G+14839  U+C7A8  uniC7A8,  HANGUL SYLLABLE-C7A8
        0xC7A9, # G+14840  U+C7A9  uniC7A9,  HANGUL SYLLABLE-C7A9
        0xC7AA, # G+14841  U+C7AA  uniC7AA,  HANGUL SYLLABLE-C7AA
        0xC7AB, # G+14842  U+C7AB  uniC7AB,  HANGUL SYLLABLE-C7AB
        0xC7AE, # G+14843  U+C7AE  uniC7AE,  HANGUL SYLLABLE-C7AE
        0xC7AF, # G+14844  U+C7AF  uniC7AF,  HANGUL SYLLABLE-C7AF
        0xC7B1, # G+14845  U+C7B1  uniC7B1,  HANGUL SYLLABLE-C7B1
        0xC7B2, # G+14846  U+C7B2  uniC7B2,  HANGUL SYLLABLE-C7B2
        0xC7B3, # G+14847  U+C7B3  uniC7B3,  HANGUL SYLLABLE-C7B3
        0xC7B5, # G+14848  U+C7B5  uniC7B5,  HANGUL SYLLABLE-C7B5
        0xC7B6, # G+14849  U+C7B6  uniC7B6,  HANGUL SYLLABLE-C7B6
        0xC7B7, # G+14850  U+C7B7  uniC7B7,  HANGUL SYLLABLE-C7B7
        0xC7B8, # G+14851  U+C7B8  uniC7B8,  HANGUL SYLLABLE-C7B8
        0xC7B9, # G+14852  U+C7B9  uniC7B9,  HANGUL SYLLABLE-C7B9
        0xC7BA, # G+14853  U+C7BA  uniC7BA,  HANGUL SYLLABLE-C7BA
        0xC7BB, # G+14854  U+C7BB  uniC7BB,  HANGUL SYLLABLE-C7BB
        0xC7BE, # G+14855  U+C7BE  uniC7BE,  HANGUL SYLLABLE-C7BE
        0xC7C2, # G+14856  U+C7C2  uniC7C2,  HANGUL SYLLABLE-C7C2
        0xC7C3, # G+14857  U+C7C3  uniC7C3,  HANGUL SYLLABLE-C7C3
        0xC7C4, # G+14858  U+C7C4  uniC7C4,  HANGUL SYLLABLE-C7C4
        0xC7C5, # G+14859  U+C7C5  uniC7C5,  HANGUL SYLLABLE-C7C5
        0xC7C6, # G+14860  U+C7C6  uniC7C6,  HANGUL SYLLABLE-C7C6
        0xC7C7, # G+14861  U+C7C7  uniC7C7,  HANGUL SYLLABLE-C7C7
        0xC7CA, # G+14862  U+C7CA  uniC7CA,  HANGUL SYLLABLE-C7CA
        0xC7CB, # G+14863  U+C7CB  uniC7CB,  HANGUL SYLLABLE-C7CB
        0xC7CD, # G+14864  U+C7CD  uniC7CD,  HANGUL SYLLABLE-C7CD
        0xC7CF, # G+14865  U+C7CF  uniC7CF,  HANGUL SYLLABLE-C7CF
        0xC7D1, # G+14866  U+C7D1  uniC7D1,  HANGUL SYLLABLE-C7D1
        0xC7D2, # G+14867  U+C7D2  uniC7D2,  HANGUL SYLLABLE-C7D2
        0xC7D3, # G+14868  U+C7D3  uniC7D3,  HANGUL SYLLABLE-C7D3
        0xC7D4, # G+14869  U+C7D4  uniC7D4,  HANGUL SYLLABLE-C7D4
        0xC7D5, # G+14870  U+C7D5  uniC7D5,  HANGUL SYLLABLE-C7D5
        0xC7D6, # G+14871  U+C7D6  uniC7D6,  HANGUL SYLLABLE-C7D6
        0xC7D7, # G+14872  U+C7D7  uniC7D7,  HANGUL SYLLABLE-C7D7
        0xC7D9, # G+14873  U+C7D9  uniC7D9,  HANGUL SYLLABLE-C7D9
        0xC7DA, # G+14874  U+C7DA  uniC7DA,  HANGUL SYLLABLE-C7DA
        0xC7DB, # G+14875  U+C7DB  uniC7DB,  HANGUL SYLLABLE-C7DB
        0xC7DC, # G+14876  U+C7DC  uniC7DC,  HANGUL SYLLABLE-C7DC
        0xC7DE, # G+14877  U+C7DE  uniC7DE,  HANGUL SYLLABLE-C7DE
        0xC7DF, # G+14878  U+C7DF  uniC7DF,  HANGUL SYLLABLE-C7DF
        0xC7E0, # G+14879  U+C7E0  uniC7E0,  HANGUL SYLLABLE-C7E0
        0xC7E1, # G+14880  U+C7E1  uniC7E1,  HANGUL SYLLABLE-C7E1
        0xC7E2, # G+14881  U+C7E2  uniC7E2,  HANGUL SYLLABLE-C7E2
        0xC7E3, # G+14882  U+C7E3  uniC7E3,  HANGUL SYLLABLE-C7E3
        0xC7E5, # G+14883  U+C7E5  uniC7E5,  HANGUL SYLLABLE-C7E5
        0xC7E6, # G+14884  U+C7E6  uniC7E6,  HANGUL SYLLABLE-C7E6
        0xC7E7, # G+14885  U+C7E7  uniC7E7,  HANGUL SYLLABLE-C7E7
        0xC7E9, # G+14886  U+C7E9  uniC7E9,  HANGUL SYLLABLE-C7E9
        0xC7EA, # G+14887  U+C7EA  uniC7EA,  HANGUL SYLLABLE-C7EA
        0xC7EB, # G+14888  U+C7EB  uniC7EB,  HANGUL SYLLABLE-C7EB
        0xC7ED, # G+14889  U+C7ED  uniC7ED,  HANGUL SYLLABLE-C7ED
        0xC7EE, # G+14890  U+C7EE  uniC7EE,  HANGUL SYLLABLE-C7EE
        0xC7EF, # G+14891  U+C7EF  uniC7EF,  HANGUL SYLLABLE-C7EF
        0xC7F0, # G+14892  U+C7F0  uniC7F0,  HANGUL SYLLABLE-C7F0
        0xC7F1, # G+14893  U+C7F1  uniC7F1,  HANGUL SYLLABLE-C7F1
        0xC7F2, # G+14894  U+C7F2  uniC7F2,  HANGUL SYLLABLE-C7F2
        0xC7F3, # G+14895  U+C7F3  uniC7F3,  HANGUL SYLLABLE-C7F3
        0xC7F4, # G+14896  U+C7F4  uniC7F4,  HANGUL SYLLABLE-C7F4
        0xC7F5, # G+14897  U+C7F5  uniC7F5,  HANGUL SYLLABLE-C7F5
        0xC7F6, # G+14898  U+C7F6  uniC7F6,  HANGUL SYLLABLE-C7F6
        0xC7F7, # G+14899  U+C7F7  uniC7F7,  HANGUL SYLLABLE-C7F7
        0xC7F8, # G+14900  U+C7F8  uniC7F8,  HANGUL SYLLABLE-C7F8
        0xC7F9, # G+14901  U+C7F9  uniC7F9,  HANGUL SYLLABLE-C7F9
        0xC7FA, # G+14902  U+C7FA  uniC7FA,  HANGUL SYLLABLE-C7FA
        0xC7FB, # G+14903  U+C7FB  uniC7FB,  HANGUL SYLLABLE-C7FB
        0xC7FC, # G+14904  U+C7FC  uniC7FC,  HANGUL SYLLABLE-C7FC
        0xC7FD, # G+14905  U+C7FD  uniC7FD,  HANGUL SYLLABLE-C7FD
        0xC7FE, # G+14906  U+C7FE  uniC7FE,  HANGUL SYLLABLE-C7FE
        0xC7FF, # G+14907  U+C7FF  uniC7FF,  HANGUL SYLLABLE-C7FF
        0xC802, # G+14908  U+C802  uniC802,  HANGUL SYLLABLE-C802
        0xC803, # G+14909  U+C803  uniC803,  HANGUL SYLLABLE-C803
        0xC805, # G+14910  U+C805  uniC805,  HANGUL SYLLABLE-C805
        0xC806, # G+14911  U+C806  uniC806,  HANGUL SYLLABLE-C806
        0xC807, # G+14912  U+C807  uniC807,  HANGUL SYLLABLE-C807
        0xC809, # G+14913  U+C809  uniC809,  HANGUL SYLLABLE-C809
        0xC80B, # G+14914  U+C80B  uniC80B,  HANGUL SYLLABLE-C80B
        0xC80C, # G+14915  U+C80C  uniC80C,  HANGUL SYLLABLE-C80C
        0xC80D, # G+14916  U+C80D  uniC80D,  HANGUL SYLLABLE-C80D
        0xC80E, # G+14917  U+C80E  uniC80E,  HANGUL SYLLABLE-C80E
        0xC80F, # G+14918  U+C80F  uniC80F,  HANGUL SYLLABLE-C80F
        0xC812, # G+14919  U+C812  uniC812,  HANGUL SYLLABLE-C812
        0xC814, # G+14920  U+C814  uniC814,  HANGUL SYLLABLE-C814
        0xC817, # G+14921  U+C817  uniC817,  HANGUL SYLLABLE-C817
        0xC818, # G+14922  U+C818  uniC818,  HANGUL SYLLABLE-C818
        0xC819, # G+14923  U+C819  uniC819,  HANGUL SYLLABLE-C819
        0xC81A, # G+14924  U+C81A  uniC81A,  HANGUL SYLLABLE-C81A
        0xC81B, # G+14925  U+C81B  uniC81B,  HANGUL SYLLABLE-C81B
        0xC81E, # G+14926  U+C81E  uniC81E,  HANGUL SYLLABLE-C81E
        0xC81F, # G+14927  U+C81F  uniC81F,  HANGUL SYLLABLE-C81F
        0xC821, # G+14928  U+C821  uniC821,  HANGUL SYLLABLE-C821
        0xC822, # G+14929  U+C822  uniC822,  HANGUL SYLLABLE-C822
        0xC823, # G+14930  U+C823  uniC823,  HANGUL SYLLABLE-C823
        0xC825, # G+14931  U+C825  uniC825,  HANGUL SYLLABLE-C825
        0xC826, # G+14932  U+C826  uniC826,  HANGUL SYLLABLE-C826
        0xC827, # G+14933  U+C827  uniC827,  HANGUL SYLLABLE-C827
        0xC828, # G+14934  U+C828  uniC828,  HANGUL SYLLABLE-C828
        0xC829, # G+14935  U+C829  uniC829,  HANGUL SYLLABLE-C829
        0xC82A, # G+14936  U+C82A  uniC82A,  HANGUL SYLLABLE-C82A
        0xC82B, # G+14937  U+C82B  uniC82B,  HANGUL SYLLABLE-C82B
        0xC82E, # G+14938  U+C82E  uniC82E,  HANGUL SYLLABLE-C82E
        0xC830, # G+14939  U+C830  uniC830,  HANGUL SYLLABLE-C830
        0xC832, # G+14940  U+C832  uniC832,  HANGUL SYLLABLE-C832
        0xC833, # G+14941  U+C833  uniC833,  HANGUL SYLLABLE-C833
        0xC834, # G+14942  U+C834  uniC834,  HANGUL SYLLABLE-C834
        0xC835, # G+14943  U+C835  uniC835,  HANGUL SYLLABLE-C835
        0xC836, # G+14944  U+C836  uniC836,  HANGUL SYLLABLE-C836
        0xC837, # G+14945  U+C837  uniC837,  HANGUL SYLLABLE-C837
        0xC839, # G+14946  U+C839  uniC839,  HANGUL SYLLABLE-C839
        0xC83A, # G+14947  U+C83A  uniC83A,  HANGUL SYLLABLE-C83A
        0xC83B, # G+14948  U+C83B  uniC83B,  HANGUL SYLLABLE-C83B
        0xC83D, # G+14949  U+C83D  uniC83D,  HANGUL SYLLABLE-C83D
        0xC83E, # G+14950  U+C83E  uniC83E,  HANGUL SYLLABLE-C83E
        0xC83F, # G+14951  U+C83F  uniC83F,  HANGUL SYLLABLE-C83F
        0xC841, # G+14952  U+C841  uniC841,  HANGUL SYLLABLE-C841
        0xC842, # G+14953  U+C842  uniC842,  HANGUL SYLLABLE-C842
        0xC843, # G+14954  U+C843  uniC843,  HANGUL SYLLABLE-C843
        0xC844, # G+14955  U+C844  uniC844,  HANGUL SYLLABLE-C844
        0xC845, # G+14956  U+C845  uniC845,  HANGUL SYLLABLE-C845
        0xC846, # G+14957  U+C846  uniC846,  HANGUL SYLLABLE-C846
        0xC847, # G+14958  U+C847  uniC847,  HANGUL SYLLABLE-C847
        0xC84A, # G+14959  U+C84A  uniC84A,  HANGUL SYLLABLE-C84A
        0xC84B, # G+14960  U+C84B  uniC84B,  HANGUL SYLLABLE-C84B
        0xC84E, # G+14961  U+C84E  uniC84E,  HANGUL SYLLABLE-C84E
        0xC84F, # G+14962  U+C84F  uniC84F,  HANGUL SYLLABLE-C84F
        0xC850, # G+14963  U+C850  uniC850,  HANGUL SYLLABLE-C850
        0xC851, # G+14964  U+C851  uniC851,  HANGUL SYLLABLE-C851
        0xC852, # G+14965  U+C852  uniC852,  HANGUL SYLLABLE-C852
        0xC853, # G+14966  U+C853  uniC853,  HANGUL SYLLABLE-C853
        0xC855, # G+14967  U+C855  uniC855,  HANGUL SYLLABLE-C855
        0xC856, # G+14968  U+C856  uniC856,  HANGUL SYLLABLE-C856
        0xC857, # G+14969  U+C857  uniC857,  HANGUL SYLLABLE-C857
        0xC858, # G+14970  U+C858  uniC858,  HANGUL SYLLABLE-C858
        0xC859, # G+14971  U+C859  uniC859,  HANGUL SYLLABLE-C859
        0xC85A, # G+14972  U+C85A  uniC85A,  HANGUL SYLLABLE-C85A
        0xC85B, # G+14973  U+C85B  uniC85B,  HANGUL SYLLABLE-C85B
        0xC85C, # G+14974  U+C85C  uniC85C,  HANGUL SYLLABLE-C85C
        0xC85D, # G+14975  U+C85D  uniC85D,  HANGUL SYLLABLE-C85D
        0xC85E, # G+14976  U+C85E  uniC85E,  HANGUL SYLLABLE-C85E
        0xC85F, # G+14977  U+C85F  uniC85F,  HANGUL SYLLABLE-C85F
        0xC860, # G+14978  U+C860  uniC860,  HANGUL SYLLABLE-C860
        0xC861, # G+14979  U+C861  uniC861,  HANGUL SYLLABLE-C861
        0xC862, # G+14980  U+C862  uniC862,  HANGUL SYLLABLE-C862
        0xC863, # G+14981  U+C863  uniC863,  HANGUL SYLLABLE-C863
        0xC864, # G+14982  U+C864  uniC864,  HANGUL SYLLABLE-C864
        0xC865, # G+14983  U+C865  uniC865,  HANGUL SYLLABLE-C865
        0xC866, # G+14984  U+C866  uniC866,  HANGUL SYLLABLE-C866
        0xC867, # G+14985  U+C867  uniC867,  HANGUL SYLLABLE-C867
        0xC868, # G+14986  U+C868  uniC868,  HANGUL SYLLABLE-C868
        0xC869, # G+14987  U+C869  uniC869,  HANGUL SYLLABLE-C869
        0xC86A, # G+14988  U+C86A  uniC86A,  HANGUL SYLLABLE-C86A
        0xC86B, # G+14989  U+C86B  uniC86B,  HANGUL SYLLABLE-C86B
        0xC86C, # G+14990  U+C86C  uniC86C,  HANGUL SYLLABLE-C86C
        0xC86D, # G+14991  U+C86D  uniC86D,  HANGUL SYLLABLE-C86D
        0xC86E, # G+14992  U+C86E  uniC86E,  HANGUL SYLLABLE-C86E
        0xC86F, # G+14993  U+C86F  uniC86F,  HANGUL SYLLABLE-C86F
        0xC872, # G+14994  U+C872  uniC872,  HANGUL SYLLABLE-C872
        0xC873, # G+14995  U+C873  uniC873,  HANGUL SYLLABLE-C873
        0xC875, # G+14996  U+C875  uniC875,  HANGUL SYLLABLE-C875
        0xC876, # G+14997  U+C876  uniC876,  HANGUL SYLLABLE-C876
        0xC877, # G+14998  U+C877  uniC877,  HANGUL SYLLABLE-C877
        0xC879, # G+14999  U+C879  uniC879,  HANGUL SYLLABLE-C879
        0xC87B, # G+15000  U+C87B  uniC87B,  HANGUL SYLLABLE-C87B
        0xC87C, # G+15001  U+C87C  uniC87C,  HANGUL SYLLABLE-C87C
        0xC87D, # G+15002  U+C87D  uniC87D,  HANGUL SYLLABLE-C87D
        0xC87E, # G+15003  U+C87E  uniC87E,  HANGUL SYLLABLE-C87E
        0xC87F, # G+15004  U+C87F  uniC87F,  HANGUL SYLLABLE-C87F
        0xC882, # G+15005  U+C882  uniC882,  HANGUL SYLLABLE-C882
        0xC884, # G+15006  U+C884  uniC884,  HANGUL SYLLABLE-C884
        0xC888, # G+15007  U+C888  uniC888,  HANGUL SYLLABLE-C888
        0xC889, # G+15008  U+C889  uniC889,  HANGUL SYLLABLE-C889
        0xC88A, # G+15009  U+C88A  uniC88A,  HANGUL SYLLABLE-C88A
        0xC88E, # G+15010  U+C88E  uniC88E,  HANGUL SYLLABLE-C88E
        0xC88F, # G+15011  U+C88F  uniC88F,  HANGUL SYLLABLE-C88F
        0xC890, # G+15012  U+C890  uniC890,  HANGUL SYLLABLE-C890
        0xC891, # G+15013  U+C891  uniC891,  HANGUL SYLLABLE-C891
        0xC892, # G+15014  U+C892  uniC892,  HANGUL SYLLABLE-C892
        0xC893, # G+15015  U+C893  uniC893,  HANGUL SYLLABLE-C893
        0xC895, # G+15016  U+C895  uniC895,  HANGUL SYLLABLE-C895
        0xC896, # G+15017  U+C896  uniC896,  HANGUL SYLLABLE-C896
        0xC897, # G+15018  U+C897  uniC897,  HANGUL SYLLABLE-C897
        0xC898, # G+15019  U+C898  uniC898,  H