use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'BlankOnDev',
    VERSION_FROM      => 'lib/BlankOnDev.pm', # finds $VERSION, requires EU::MM from perl >= 5.5
    "ABSTRACT" => "BlankOnDev - Several Development tools for BlankOn GNU/Linux.",
    "AUTHOR" => "Achmad Yusri Afandi <yusrideb\@cpan.org>",
    "CONFIGURE_REQUIRES" => {
        "ExtUtils::MakeMaker" => 0,
        "File::ShareDir::Install" => "0.06"
    },
    "DISTNAME" => "BlankOnDev",
    "EXE_FILES" => [
        "script/boi_bzr2git",
        "script/boidev"
    ],
    "LICENSE" => "perl",
    "MIN_PERL_VERSION" => "5.01205",
    "NAME" => "BlankOnDev",
    "PREREQ_PM" => {
        "JSON" => 0,
        "DBI" => 0,
        "Crypt::Blowfish" => 0,
        "Crypt::JWT" => 0,
        "Digest::SHA1" => 0,
        "Digest::MD5" => 0,
        "List::Util" => 0,
        "MIME::Base64" => 0,
        "MIME::Base64::Perl" => 0,
        "Hash::MultiValue" => 0,
        "Term::ReadKey" => 0,
        "parent" => 0
    },
    "TEST_REQUIRES" => {
        "Test::More" => "0.88",
        "Test::Requires" => 0
    },
    "VERSION_FROM" => 'lib/BlankOnDev/Version.pm',
);
