use 5.006;
use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name         => 'Test::SFTP',
    license             => 'perl',
    dist_author         => q{Sawyer X <xsawyerx@cpan.org>},
    dist_version_from   => 'lib/Test/SFTP.pm',
    build_requires => {
        'Test::More'         => 0,
        'English'            => 1.02,
        'Term::ReadLine'     => 0,
        'Term::ReadPassword' => 0,
    },

    requires => {
        'Carp'                 => 0,
        'perl'                 => 5.006,
        'Moose'                => 0.63,
        'Expect'               => 0,
        'IO::Pty'              => 0,
        'parent'               => 0,
        'Test::Builder'        => 0,
        'Net::SFTP::Foreign'   => 0,
        'namespace::autoclean' => 0,
    },

    add_to_cleanup     => [ 'Test-SFTP-*' ],
    create_makefile_pl => 'traditional',
    create_license     => 1,
    create_readme      => 1,
);

$builder->create_build_script();
