use v6;
# generated by: ../../etc/make-modules.p6 --role-name=ISO_32000::CSS2_style ../../resources/ISO_32000/CSS2_style_attributes.json

#| PDF 32000-1:2008 Table 225 – CSS2 style attributes used in rich text strings
role ISO_32000::CSS2_style {
    method text-align {...};
    method vertical-align {...};
    method font-size {...};
    method font-style {...};
    method font-weight {...};
    method font-family {...};
    method font {...};
    method color {...};
    method text-decoration {...};
    method font-stretch {...};
}

=begin pod

=head1 Methods (Entries)

=head2 text-align [keyword]
- Horizontal alignment. Possible values: left, right, and center.

=head2 vertical-align [decimal]
- An amount by which to adjust the baseline of the enclosed text. A positive value indicates a superscript; a negative value indicates a subscript. The value is of the form <decimal number>pt, optionally preceded by a sign, and followed by “pt”.
EXAMPLE -3pt, 4pt.

=head2 font-size [decimal]
- The font size of the enclosed text. The value is of the form <decimal number>pt.

=head2 font-style [keyword]
- Specifies the font style of the enclosed text. Possible values: normal, italic.

=head2 font-weight [keyword]
- The weight of the font for the enclosed text. Possible values: normal, bold, 100, 200, 300, 400, 500, 600, 700, 800, 900.
normal is equivalent to 400, and bold is equivalent to 700.

=head2 font-family [list]
- A font name or list of font names that is used to display the enclosed text. (If a list is provided, the first one containing glyphs for the specified text is used.)

=head2 font [list]
- A shorthand CSS font property of the form
font:<font-style> <font-weight> <font-size> <font-family>

=head2 color [RGB value]
- The colour of the enclosed text. It can be in one of two forms:
rrggbb with a 2-digit hexadecimal value for each component
rgb(rrr,ggg,bbb) with a decimal value for each component.
Although the values specified by the color property are interpreted as sRGB values, they is transformed into values in a non-ICC based colour space when used to generate the annotation’s appearance.

=head2 text-decoration [keyword]
- One of the following keywords:
underline: The enclosed text is underlined.
line-through: The enclosed text has a line drawn through it.

=head2 font-stretch [keyword]
- Specifies a normal, condensed or extended face from a font family. Supported values from narrowest to widest are ultra-condensed, extra-condensed, condensed, semi-condensed, normal, semi-expanded, expanded, extra-expanded, and ultra-expanded.

=end pod
