package Language::Lisp::ECLs;

use 5.008;
use strict;

our $VERSION = '0.03';

require XSLoader;
XSLoader::load('Language::Lisp::ECLs', $VERSION);

sub new {
    cl_boot();
    return bless {}, __PACKAGE__;
}

sub eval_string {
    my $self = shift;
    return _eval_string(@_);
}
sub eval {
    my $self = shift;
    return _eval(@_);
}

package Language::Lisp::ECLs::Symbol;
our @ISA = ('Language::Lisp::ECLs');
package Language::Lisp::ECLs::Package;
our @ISA = ('Language::Lisp::ECLs');
package Language::Lisp::ECLs::String;
our @ISA = ('Language::Lisp::ECLs');
package Language::Lisp::ECLs::Generic;
our @ISA = ('Language::Lisp::ECLs');

1;

__END__

=head1 NAME

Language::Lisp::ECLs - Perl extension for ECL lisp

=head1 SYNOPSIS

  use Language::Lisp::ECLs;
  my $r = Language::Lisp::ECLs::eval("(format nil \"[~S]\" 'qwerty)");

=head1 DESCRIPTION

Language::Lisp::ECLs is a bit easier to use than Language::Lisp because of
embeddable nature of ECLs. Language::Lisp uses different approach because
they are other way down: Lisp calls Perl and not vice versa.

If symbol is returned, then it is blessed into the
Language::Lisp::ECLs::Symbol package

=head2 EXPORT

None.

=head1 SEE ALSO

Language::Lisp

=head1 AUTHOR

Vadim Konovalov, E<lt>vkon@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by vadrer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8 or,
at your option, any later version of Perl 5 you may have available.


=cut
