#!/bin/echo This is a perl module and should not be run

package Meta::Lang::Perl::Pod::Docbook;

use strict qw(vars refs subs);
use Pod::Parser qw();
use Meta::Utils::Output qw();

our($VERSION,@ISA);
$VERSION="0.13";
@ISA=qw(Pod::Parser);

#sub begin_pod($);
#sub command($$$$$);
#sub verbatim($$$$);
#sub textblock($$$$);
#sub interior_sequence($$$$);

#__DATA__

sub begin_pod($) {
	my($self)=@_;
	my($fh)=$self->output_handle();
	print $fh "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
	print $fh "<!DOCTYPE section PUBLIC \"-//OASIS//DTD DocBook V3.1//EN\" []>\n";
	print $fh "<!--Auto generated by base - DO NOT EDIT!-->\n";
}

sub command($$$$$) {
	my($self,$command,$paragraph,$line_num,$pod_para)=@_;
	my($text)=$self->interpolate($paragraph);
#	Meta::Utils::Output::print("in command with:\n");
#	Meta::Utils::Output::print("command [".$command."]\n");
#	Meta::Utils::Output::print("paragraph [".$paragraph."]\n");
#	Meta::Utils::Output::print("line_num [".$line_num."]\n");
#	Meta::Utils::Output::print("text [".$text."]\n");
	my($out_fh)=$self->output_handle();
	print $out_fh $text;
}

sub verbatim($$$$) {
	my($self,$paragraph,$line_num,$pod_para)=@_;
#	Meta::Utils::Output::print("in verbatim with:\n");
#	Meta::Utils::Output::print("paragraph [".$paragraph."]\n");
#	Meta::Utils::Output::print("line_num [".$line_num."]\n");
	my($out_fh)=$self->output_handle();
	print $out_fh $paragraph;
}

sub textblock($$$$) {
	my($self,$paragraph,$line_num,$pod_para)=@_;
	my($text)=$self->interpolate($paragraph);
#	Meta::Utils::Output::print("in textblock with:\n");
#	Meta::Utils::Output::print("paragraph [".$paragraph."]\n");
#	Meta::Utils::Output::print("line_num [".$line_num."]\n");
#	Meta::Utils::Output::print("text [".$text."]\n");
	my($out_fh)=$self->output_handle();
	print $out_fh $text;
}

sub interior_sequence($$$$) {
	my($self,$seq_cmd,$seq_arg,$pod_seq)=@_;
#	Meta::Utils::Output::print("in interior_sequence with:\n");
#	Meta::Utils::Output::print("seq_cmd [".$seq_cmd."]\n");
#	Meta::Utils::Output::print("seq_arg [".$seq_arg."]\n");
#	Meta::Utils::Output::print("pod_seq [".$pod_seq."]\n");
	if($seq_cmd eq 'B') {#emphasis
		return("<emphasis role=bold>".$seq_arg."</emphasis>");
	}
	if($seq_cmd eq 'C') {#code
		return("<code>".$seq_arg."</code>");
	}
	if($seq_cmd eq 'I') {#emphasis
		return("<emphasis>".$seq_arg."</emphasis>");
	}
	if($seq_cmd eq 'L') {#hyper link
		return("<link linkend=0>".$seq_arg."</link>");
	}
	if($seq_cmd eq 'F') {#filename
		return("<filename>".$seq_arg."</filename>");
	}
	if($seq_cmd eq 'X') {#index term
		return("<indexterm><primary>".$seq_arg."</primary></indexterm>");
	}
	if($seq_cmd eq 'S') {#non breaking spaces text
		return($seq_arg);
	}
	if($seq_cmd eq 'Z') {#zero character ?
		return($seq_arg);
	}
	if($seq_cmd eq 'E') {#escape codes (not handled)
		return($seq_arg);
	}
	Meta::Utils::System::die("what kind of escape sequence is [".$seq_cmd."]");
	return(undef);
}

1;

__END__

=head1 NAME

Meta::Lang::Perl::Pod::Docbook - Translate pod into DocBook.

=head1 COPYRIGHT

Copyright (C) 2001, 2002 Mark Veltzer;
All rights reserved.

=head1 LICENSE

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

=head1 DETAILS

	MANIFEST: Docbook.pm
	PROJECT: meta
	VERSION: 0.13

=head1 SYNOPSIS

	package foo;
	use Meta::Lang::Perl::Pod::Docbook qw();
	my($object)=Meta::Lang::Perl::Pod::Docbook->new();
	my($result)=$object->parse_from_file($infile,$outfile);

=head1 DESCRIPTION

This class translates pod documentation to DocBook format (only a section
mind you).

=head1 FUNCTIONS

	begin_pod($)
	command($$$$$)
	verbatim($$$$)
	textblock($$$$)
	interior_sequence($$$$)

=head1 FUNCTION DOCUMENTATION

=over 4

=item B<begin_pod($)>

This method overrides the base classes begin_pod method to handle begining
of the process.

=item B<command($$$$$)>

This method overrides the base classes command method to handle commands.

=item B<verbatim($$$$)>

This method overrides the base classes verbatim method to handle verbatims.

=item B<textblock($$$$)>

This method overrides the base classes textblock method to handle textblocks.

=item B<interior_sequence($$$$)>

This method overrides the base classes interior_sequence method ot handle
interior sequences.

=back

=head1 BUGS

None.

=head1 AUTHOR

	Name: Mark Veltzer
	Email: mark2776@yahoo.com
	WWW: http://www.geocities.com/mark2776
	CPAN id: VELTZER

=head1 HISTORY

	0.00 MV perl documentation
	0.01 MV more perl quality
	0.02 MV perl qulity code
	0.03 MV more perl code quality
	0.04 MV revision change
	0.05 MV pictures in docbooks
	0.06 MV languages.pl test online
	0.07 MV perl packaging
	0.08 MV md5 project
	0.09 MV database
	0.10 MV perl module versions in files
	0.11 MV movies and small fixes
	0.12 MV thumbnail user interface
	0.13 MV more thumbnail issues

=head1 SEE ALSO

Nothing.

=head1 TODO

-handle S/Z/E tags in sequences.

-handle id's in hyper links.
