package Google::Ads::AdWords::v201710::CampaignGroupPerformanceTarget;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201710' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %id_of :ATTR(:get<id>);
my %campaignGroupId_of :ATTR(:get<campaignGroupId>);
my %performanceTarget_of :ATTR(:get<performanceTarget>);

__PACKAGE__->_factory(
    [ qw(        id
        campaignGroupId
        performanceTarget

    ) ],
    {
        'id' => \%id_of,
        'campaignGroupId' => \%campaignGroupId_of,
        'performanceTarget' => \%performanceTarget_of,
    },
    {
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'campaignGroupId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'performanceTarget' => 'Google::Ads::AdWords::v201710::PerformanceTarget',
    },
    {

        'id' => 'id',
        'campaignGroupId' => 'campaignGroupId',
        'performanceTarget' => 'performanceTarget',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201710::CampaignGroupPerformanceTarget

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CampaignGroupPerformanceTarget from the namespace https://adwords.google.com/api/adwords/cm/v201710.

Data representing a campaign group performance target. A campaign group performance target is an entity that specifies a time range for a campaign group and various metrics by which the performance of that campaign group can be measured for the time period that the performance target is active. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * id


=item * campaignGroupId


=item * performanceTarget




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

