package Google::Ads::AdWords::v201708::DynamicSettings;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201708' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %landscapeLogoImage_of :ATTR(:get<landscapeLogoImage>);
my %pricePrefix_of :ATTR(:get<pricePrefix>);
my %promoText_of :ATTR(:get<promoText>);

__PACKAGE__->_factory(
    [ qw(        landscapeLogoImage
        pricePrefix
        promoText

    ) ],
    {
        'landscapeLogoImage' => \%landscapeLogoImage_of,
        'pricePrefix' => \%pricePrefix_of,
        'promoText' => \%promoText_of,
    },
    {
        'landscapeLogoImage' => 'Google::Ads::AdWords::v201708::Image',
        'pricePrefix' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'promoText' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'landscapeLogoImage' => 'landscapeLogoImage',
        'pricePrefix' => 'pricePrefix',
        'promoText' => 'promoText',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201708::DynamicSettings

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DynamicSettings from the namespace https://adwords.google.com/api/adwords/cm/v201708.

Represents Dynamic Settings. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * landscapeLogoImage


=item * pricePrefix


=item * promoText




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

